## Breaking Changes

* unquoted parameters that are formatted like `[alpha, numeric, underscore]\(...\)` will be parsed as a function rather than a string. eg `command foo(bar baz)` where **foo** will be treated as a subshell function with **bar baz** as its parameters
* brace quotes without a leading `%` will be first parsed as an expression. eg `%(valid string)` vs `(valid expression)`

## Deprecation Warnings

These are changes to Murex defaults, however you shouldn't expect any breaking changes to Murex's behaviour:

* `$ARGV` now preferred instead of `$ARGS` (`$ARGS` will remain supported for now)
* `command: parameters ...` style syntax has been deprecated in favour of the more traditional `command parameters ...` (without a colon) syntax. 

## Features

* new website!!
* commands can now be inlined in expressions, eg `foobar = uptime()` ([issue 676](https://github.com/lmorg/murex/issues/676))
* commands can also be inlined into statements too, eg `echo uptime()` ([issue 676](https://github.com/lmorg/murex/issues/676))

* new event `onSignalReceived` for catching OS signals
* new builtin `signal` for sending OS signals
* new builtins `which` ([issue 609](https://github.com/lmorg/murex/issues/609))
* new builtin `type` ([issue 609](https://github.com/lmorg/murex/issues/609))
* `cd` defaults to `~` if now parameters are passed ([issue 672](https://github.com/lmorg/murex/issues/672))
* `cd -` changes to previous directory ([issue 672](https://github.com/lmorg/murex/issues/672))
* `$SELF.Interactive` value to detect if scope is running in an interactive shell ([issue 685](https://github.com/lmorg/murex/issues/685))
* `$COLUMNS` reserved variable to output width of terminal
* `$MUREX_ARGV` reserved variable to output command line parameters of Murex shell (not to be confused with the parameters of the running function, eg `$ARGV`)
* `csv` data type and `select` builtin now support converting maps (eg JSON objects) into tables ([issue 689](https://github.com/lmorg/murex/issues/689))
* `murex-doc` / `help` can now display a greater number of documents when offline
* improved man page parsing
* improved man page displays in preview
* `alias` now stores `FileRef` metadata ([issue 124](https://github.com/lmorg/murex/issues/124))
* packages can now be removed via `murex-package remove` ([issue 687](https://github.com/lmorg/murex/issues/687))
* a package creation wizard has been added via `murex-package new`
* another new flag for `murex-package`: **git**. Which allows you to run `git` commands on a package even when you're not in that package's working directory
* version constraints added to Murex packages (docs to follow)
* readline: `up` and `down` arrows on a partial command line will cycle through history of only lines that contain your partial command line
* readline: new hotkey, `ctrl`+`z` while readline is open will undo the previous key strokes
* EXPERIMENTAL: logical operators added to expressions: `||` and `&&` ([issue 708](https://github.com/lmorg/murex/issues/708))
* EXPERIMENTAL: new command modifier `<pid:VARNAME>` sets **$VARNAME** with a commands process ID, if an external process (currently doesn't support local variables)
* EXPERIMENTAL: new command modifier `<fid:VARNAME>` sets **$VARNAME** with the Murex function ID of the command (currently doesn't support local variables)
* EXPERIMENTAL: new assignment operator `:=`, assigns a value but retains the former data type, thus converting the value when required (ideally I'd have preferred this as default option but it ran the risk of some serious and unexpected breaking changes to the behaviour of some existing shell scripts)
* EXPERIMENTAL: Various builtins that require variable names now support `$` sigils, eg `foreach $var { ... }` works as well as `foreach var { ... }`
* EXPERIMENTAL: new variable group `$MOD`, like `$GLOBAL` but scoped to the module level
* EXPERIMENTAL: official support added for a pure Go library for sqlite3 -- thus saving individuals from having to install `gcc` as well as `go` compilers. The reduced `cgo` footprint has already reduced file sizes by a 3rd
  
## Bug Fixes

* homebrew environment set on Intel macOS systems (previous only worked on ARM)
* `config` functions (eg `hint-text-func`) now execute with the `FileRef` of the setter. Meaning they can call privates correctly
* scalars fail expression pre-parser ([issue 674](https://github.com/lmorg/murex/issues/674))
* readline: prompt can now span multiple lines ([issue 612](https://github.com/lmorg/murex/issues/612))
* floating point numbers were not loosely compared correctly in expressions
* readline: delay timer hint text should disappear when completed
* `$PWDHIST` was corrupting upon first update
* fixed bug with `git-commit` man page parsing, which caused the parser to hang and ramp up CPU usage on `git` autocompletions
* fixed parsing of nested quotes inside curly braces ([issue 697](https://github.com/lmorg/murex/issues/697))
* don't carry non-zero exit numbers forward if unit test successful
* fixed instances where `FileRef` either wasn't being set, wasn't being set correctly, or was missing a timestamp ([issue 696](https://github.com/lmorg/murex/issues/696))
* `printf` dependency removed from `aliases` function -- this means `aliases` now works on Windows too
* * `||` and `&&` now parse correctly in expressions

## Special Thanks

Special thank yous for this release goes to the following contributors:

* [orefalo](https://github.com/orefalo) for building the new website (which is now small task!), documentation fixes, and general support
* [tiymat](https://github.com/tiymat) for the high quality bug reports and beta testing
* All the downstream package maintainers, who publish Murex to their preferred operating systems/package managers thus making it easier for a wider audience to install and update Murex

You rock!