package docs

func init() {

	Definition["return"] = "# `return` - Command Reference\n\n> Exits current function scope\n\n## Description\n\n`return` will terminate execution of a block at the scope level (eg `function`,\n`private`, etc)\n\nConceptually it is the same as `break` except it doesn't require the scope name\nas a parameter and you can specify the exit number rather than defaulting to 0.\n\n## Usage\n\n    return [ exit-number ]\n\n## Examples\n\n**Setting an exit number:**\n\n    function example {\n        out foo\n        return 13\n        out bar\n    }\n    example\n    exitnum\n    \nRunning the above code would output:\n\n    foo\n    13\n    \n**Returning withing an exit number:**\n\nIf we were to run the same code as above but with `return` written without any\nparameters (ie instead of `return 13` it would be just `return`), then you\nwould see the following output:\n\n    foo\n    0\n\n## Detail\n\nAny process that has been initialised within a `return`ed scope will have their\nexit number updated to the value specified in `return` (or `0` if no parameter\nwas passed).\n\n## See Also\n\n* [`break`](../commands/break.md):\n  Terminate execution of a block within your processes scope\n* [`continue`](../commands/continue.md):\n  Terminate process of a block within a caller function\n* [`exit`](../commands/exit.md):\n  Exit murex\n* [`exitnum`](../commands/exitnum.md):\n  Output the exit number of the previous process\n* [`function`](../commands/function.md):\n  Define a function block\n* [`out`](../commands/out.md):\n  Print a string to the STDOUT with a trailing new line character\n* [`private`](../commands/private.md):\n  Define a private function block"

}
