# v4.1.x - Change Log

The previous releases have brought significant advancements to Murex's syntax but at the cost of longer gaps between releases. So the 4.1.x versions will be shorter releases but focusing on bug fixes. The 4.1.x release notes will be appended to [murex.rocks changelog](https://murex.rocks/docs/changelog/v4.1.html) and available on [Github releases](https://github.com/lmorg/murex/releases) too

## v4.1.7300

### Breaking Changes

None

### Features

* generic `*` data type marshaller can now marshal maps ([#593](https://github.com/lmorg/murex/issues/593))

* range can count from end when supplied with a negative index ([read more](https://murex.rocks/docs/commands/range.html))

### Bug Fixes

* `fexec private` should inherit module string from the owners module ([#600](https://github.com/lmorg/murex/issues/600))

* `source`-ed files should be loaded into a module of a similar name to the parent module

* new code blocks, `{`, should force a new parameter when following a closing block, `}` ([#603](https://github.com/lmorg/murex/issues/603))

* fixed problem with encapsulated variables, eg `$(PWD)`, not getting parsed correctly by syntax highlighter

## v4.1.6140

### Breaking Changes

None

### Features

* readline: blinking cursor added to fuzzy find. This is just a very minor UI change to make it easier to tell where keyboard input would be updating

* `git` autocomplete now includes git aliases

### Bug Fixes

* merge operator (`<~`) should unmarshal strings

* scalars available in all assigns (eg `+=`, `-=`, etc)

* lazy assigns allowed when strict types is set to `false`. Meaning merge operations and `+=` (et al) will work even if the left scalar is unset

* suppress `!!!` style warnings upon `^C`

* strip `:` colon from command name when command string is passed from the pre-parser ([#601](https://github.com/lmorg/murex/issues/601))

## v4.1.5200

### Breaking Changes

None

### Features

* Merge into operator added: `~>`

* `f`: new flag `i` -- deprecates `?` flag due to `?` being a glob pattern. However `?` will remain supported

* `$PREFIX` variable passed to **Dynamic** and **DynamicDesc** functions in `autocomplete` -- includes the partial term ([read more](https://murex.rocks/docs/commands/autocomplete.html#directives))

* `user@` completion support for `ssh`

* Updated `autocomplete` docs ([read more](https://murex.rocks/docs/commands/autocomplete.html))

* command line is included in error message when error running inside another module

* errors within other modules now include the command line string to make debugging even easier

* lambdas success/fail criteria is now driven by the exitnum rather than stdout data type. This allows it to be much more robust. In addition `$.` is now mutable

### Bug Fixes

* `f` improved help message (previously some items displayed code numbers instead of descriptions)

* readline: hint text flicker removed

## v4.1.4200

### Breaking Changes

None

### Features

* Merge operator added: `<~`

### Bug Fixes

* readline: fixed out of bounds errors when calculating unicode cell positions

* readline: fixed panic raised when vim key `p` is used on an empty buffer

* readline: fixed bug where vim mode became unavailable / `esc` didn't work as expected. This was due to autocompletion find (`^f`, `^r`) being launched before `tab` completions and state not being handled correctly

## v4.1.3010

### Breaking Changes

None

### Features

* lambda support added to piped indexes, ie `example -> [{ lambda }]`, to mirror existing `@example[{ lambda }]` functionality

* `--autocomplete` flag added to `read`

### Bug Fixes

* application specific environmental variables (eg `<env:FOO=BAR>`) were not getting set

* `cast` now checks if it is a method. Previously was piping regardless

* fixed by where nested maps would overwrite when altered with `--merge`. Now they merge as expected

* `alter` panics are caught issue ([#536](https://github.com/lmorg/murex/issues/536))

* remove debugging symbol in deprecated math builtin

## v4.1.1100

### Breaking Changes

* Any code that expects `formap` values to be strings despite that value being a different primitive from the originating object. However this type of code would be an anti-pattern so we shouldn't expect much, if any, code written like this

### Features

* `formap` values are now data type aware. You no longer need to cast values. Keys are still string only and the intention is to keep them this way

### Bug Fixes

* improved error messages around a few internal APIs

* micro optimisations in string parsing (minor order to operations, now converting points at a slightly later stage. This adds zero impact on code complexity and almost zero code refactoring but results in slightly less memory getting copied about)

## v4.1.10

### Breaking Changes

None

### Features

No new features

### Bug Fixes

* code references in error messages are cropped to terminal width

* error handling around multiple chained but incompatible tokens ([#566](https://github.com/lmorg/murex/issues/566))

<hr>

Published: 04.06.2023 at 10:44