# What's new in murex v4.1 - Change Log

The previous releases have brought significant advancements to Murex's syntax but at the cost of longer gaps between releases. So the 4.1.x versions will be shorter releases but focusing on bug fixes. The 4.1.x release notes will be appended to [murex.rocks changelog](https://murex.rocks/docs/changelog/v4.1.html) and available on [Github releases](https://github.com/lmorg/murex/releases) too

## v4.1.3010

### Breaking Changes

None

### Features

* lambda support added to piped indexes, ie `example -> [{ lambda }]`, to mirror existing `@example[{ lambda }]` functionality

* `--autocomplete` flag added to `read`

### Bug Fixes

* application specific environmental variables (eg `<env:FOO=BAR>`) were not getting set

* `cast` now checks if it is a method. Previously was piping regardless

* fixed by where nested maps would overwrite when altered with `--merge`. Now they merge as expected

* `alter` panics are caught issue ([#536](https://github.com/lmorg/murex/issues/536))

* remove debugging symbol in deprecated math builtin

## v4.1.1100

### Breaking Changes

* Any code that expects `formap` values to be strings despite that value being a different primitive from the originating object. However this type of code would be an anti-pattern so we shouldn't expect much, if any, code written like this

### Features

* `formap` values are now data type aware. You no longer need to cast values. Keys are still string only and the intention is to keep them this way

### Bug Fixes

* improved error messages around a few internal APIs

* micro optimisations in string parsing (minor order to operations, now converting points at a slightly later stage. This adds zero impact on code complexity and almost zero code refactoring but results in slightly less memory getting copied about)

## v4.1.10

### Breaking Changes

None

### Features

No new features

### Bug Fixes

* code references in error messages are cropped to terminal width

* error handling around multiple chained but incompatible tokens ([#566](https://github.com/lmorg/murex/issues/566))

<hr>

Published: 13.04.2023 at 14:34