package docs

func init() {

	Definition["f"] = "# `f` - Command Reference\n\n> Lists or filters file system objects (eg files)\n\n## Description\n\n`f` lists or filters lists of file system objects, such as files, directories,\netc. `f` provides a quick way to output file system items that confirm to\nspecific criteria.\n\nYou define this criteria by using +flags (eg `+s` for all symlinks) and\noptionally then restricting that criteria with -flags (eg `-x` to remove all\nexecutable items). All flags supported as `+` are also supported as a `-`.\n\nBy default `f` will return no results. You need to include +flags.\n\nOutput is a JSON array as this format preserves whitespace in file names.\n\n## Usage\n\n    f: options -> <stdout>\n    \n    <stdin> -> f: options -> <stdout>\n\n## Examples\n\nReturn only directories:\n\n    f: +d\n    \nReturn file and directories but exclude symlinks:\n\n    f: +fd -s\n    \nFilter out files in a list (eg created by `g`) using conditions set by `f`:\n\n    g: '*.go' -> f: +f\n    \n    rx: '\\.(txt|md)' -> f: +fw\n\n## Flags\n\n* `+`\n    include files (pair this with any other flag apart from `-`)\n* `-`\n    exclude files (pair this with any other flag apart from `+`)\n* `?`\n    irregular files (nothing else is known about these files)\n* `D`\n    regular directories\n* `E`\n    other read permissions\n* `F`\n    regular files (exc symlinks, devices, sockets, named pipes, etc)\n* `Q`\n    other write permissions\n* `R`\n    user read permissions\n* `S`\n    sockets\n* `W`\n    user write permissions\n* `X`\n    user execute permissions\n* `Z`\n    other execute permissions\n* `b`\n    block devices\n* `c`\n    character devices\n* `d`\n    all directories (inc symlinks)\n* `e`\n    group read permissions\n* `f`\n    all files (inc symlinks, devices, sockets, name pipes, etc)\n* `l`\n    symlinks\n* `p`\n    POSIX named pipes (FIFO)\n* `q`\n    group write permissions\n* `r`\n    read permissions (user, group, or other)\n* `s`\n    symlinks\n* `w`\n    write permissions (user, group, or other)\n* `x`\n    execute permissions (user, group, or other)\n* `z`\n    group execute permissions\n\n## Detail\n\n`+` flags are always matched first. Then the `-` flags are used to filter out\nany matches from the `+` flags.\n\n## See Also\n\n* [`g`](../commands/g.md):\n  Glob pattern matching for file system objects (eg `*.txt`)\n* [`json` ](../types/json.md):\n  JavaScript Object Notation (JSON)\n* [`rx`](../commands/rx.md):\n  Regexp pattern matching for file system objects (eg `.*\\\\.txt`)"

}
