# What's new in murex v2.5 - Change Log

Features:

  * `alter` now supports `--sum` where structures are merged and numeric values are added together

  * New builtin `count`. This has deprecated `len` however `len` will stick around as an alias for backwards compatibility

  * New operators added to `let`: `+=`, `-=`, `/=`, `*=`

  * New builtin `addheading` for adding headings to lists

  * Compiled profile will now always execute even if _murex_ flags set to ignore the modules/user profile. This is so that aliases like `len` get set and thus _murex_ can still move forward with changes to builtins but without breaking backwards compatibility

  * `autocomplete` now passes `ISMETHOD` variable to dynamic completions so those dynamic completions are aware if a command requesting auto-completion suggestions is being invoked as a method (mid-pipeline) or function (start of a pipeline)

  * Index, `[`, now supports inlining element, `[[`, lookups. eg `[ a b [/map/c] ]`
  
  * Dynamic auto-completions that include `@IncFiles` or `@IncDirs` will now automatically append files and/or directories to their auto-completion suggestions

  * New `autocomplete` directives: `IncExeAll` (like `IncExePath` but includes builtins, functions, aliases), `IncManPage` (include results from the `man` page parser -- usually suppressed when `autocomplete` config is set)

  * Disabled 'Loading default profile' message -- this was always pretty redundant but now that the compiled profile is being loaded all the time (eg `murex -c 'command'` or when called in a shebang), it's also now ugly too

  * `select` now supports passing a file in the **FROM** syntax. eg `select * FROM ./example.csv`. The caveat here is this breaks currently auto-complete on column names

  * `select` now supports multiple tables using either named pipes (eg `select * FROM <table1>, <table2>`) or variables (eg `select * FROM \$table1, \$table2`) passed in the **FROM** syntax. Variables should be escaped and you cannot mix and match between named pipes, file names nor variables. You can use any number of tables from 1 to 2^63-1 (64bit systems) or 1 to 2^31-1 (32bit systems). Which should be more than enough ;)

  * `config` option for `select` to define default output data type where multiple tables are imported

  * Lots of new and updated documentation!

  Non-user facing changes (internal changes to the _murex_ code base):
  
  * `open` functions can now be called by other functions to take advantage of auto-typing and auto gunzip etc.

  * `tmp.Close()` should return `err`. This isn't a bug but it might catch future bugs

  * `LazyLogging` created to speed up writing tests against data structures

  * `utils/List` package created to handle list / array / map functions. Also makes testing more complex routines easier

  Bug fixes:
  
  * Regression bug fixed where `prepend` was invoking `append`

  * `streams.ReadCloser` not setting context

  * `parameters.StringArray()` should copy values instead of a pointer to ensure the underlying parameters are immutable

<hr>

Published: 12.02.2022 at 16:16

## See Also

* [Pipeline](../user-guide/pipeline.md):
  Overview of what a "pipeline" is
* [`<>` / `read-named-pipe`](../commands/namedpipe.md):
  Reads from a _murex_ named pipe
* [`alter`](../commands/alter.md):
  Change a value within a structured data-type and pass that change along the pipeline without altering the original source input
* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`config`](../commands/config.md):
  Query or define _murex_ runtime settings
* [`count`](../commands/count.md):
  Count items in a map, list or array
* [`let`](../commands/let.md):
  Evaluate a mathematical function and assign to variable (deprecated)
* [`pipe`](../commands/pipe.md):
  Manage _murex_ named pipes
* [`select` ](../optional/select.md):
  Inlining SQL into shell pipelines
* [`set`](../commands/set.md):
  Define a local variable and set it's value