# What's new in murex v2.1 - Change Log

This release sees new optional features plus major bug fixes to the existing
code base:

### Breaking Changes:

Two `config` **shell** keys have changed names:

* recursive-soft-timeout -> `autocomplete-soft-timeout`
* recursive-hard-timeout -> `autocomplete-hard-timeout`

This is to better describe their functionality now that those values are
also used for `Dynamic` and `DynamicDesc` autocompletions as well as
recursive directory lookups.

**This change might break some of your existing profile config!**

### User Facing Changes:

* `config` **shell** **max-suggestions** now defaults at `12` rather than 6

* New optional builtin, `select`, allows you to inline SQL queries against
  any tabulated output (eg `ps -fe`, jsonlines arrays, CSV files, etc). This
  works via importing output into an in memory sqlite3 database. However this
  also breaks cross compiling due to the C includes with sqlite3. Thus this
  builtin will remain optional for now.

* Rethink of how optionals are imported. Rather than modifying `// +build`
  headers in `.go` files, optionals can be copied (or symlinked) from
  `builtins/imports_src` -> `builtins/imports_build`. This enables us to
  write a user friendly pre-compiling build script to enable users to easily
  select which optional builtins to include.

* Stopping jobs via `^z` has been fixed in UNIX. This was a regression bug
  introduced a while back however no tests were in place to catch it.
  Unfortunately this kind of testing would fall outside of unit testing each
  function so I'll need to add another layer of testing against the compiled
  executable to verify any future regressions like these: [discussion](https://github.com/lmorg/murex/issues/318)
  To use this feature, run a command and then press `^z` (ctrl+z) to pause
  the process. You can check which jobs have been paused via `jobs` and/or
  modify processes to run in the background/foreground via `bg` and `fg`.

* Added new API endpoints: `ReadArrayWithType()`. This solves some edge cases
  in `foreach` where elements might not match the same data type as the parent
  object (eg a `json` object might have `int` or `str` elements in an array)

* Rewritten how `Dynamic` autocompletions are executed to fall in line with
  `DynamicDesc`. This should bring improvements to running autocompletions
  in the background and thus improve the user experience with regards to the
  shell's responsiveness. The next step would be to have a lower soft-timeout

* Improvements to the context completions

* Default lengths for autocompletions where all results are deferred to the
  background have been tweaked slightly to give some extra length

* Minor website tweaks

### Non-User Facing / Maintenance Changes

* All dependencies have been updated, pinned and the `vendors` directory
  rebuilt

* Fixed some issues flagged up in [goreportcard.com](https://goreportcard.com/report/github.com/lmorg/murex)

* Some internal API changes that have no UI/UX ramifications but makes the
  code more maintainable

* Lots more unit tests added

<hr>

Published: 30.04.2021 at 10:00

## See Also

* [`*` (generic) ](../types/generic.md):
  generic (primitive)
* [`ReadArrayWithType()` (type)](../apis/ReadArrayWithType.md):
  Read from a data type one array element at a time and return the elements contents and data type
* [`bg`](../commands/bg.md):
  Run processes in the background
* [`csv` ](../types/csv.md):
  CSV files (and other character delimited tables)
* [`fg`](../commands/fg.md):
  Sends a background process into the foreground
* [`foreach`](../commands/foreach.md):
  Iterate through an array
* [`jobs`](../commands/fid-list.md):
  Lists all running functions within the current _murex_ session
* [`jsonl` ](../types/jsonl.md):
  JSON Lines (primitive)
* [`select` ](../optional/select.md):
  Inlining SQL into shell pipelines