# _murex_ Change Log

## What's new in murex v2.7

Breaking Changes:

* zero length arrays returned from subshells (eg `echo @{g this-file-does-not-exist}`) should fail by default, like unset variables. This is enabled by default but can be disabled via `config: set proc strict-arrays false`

* autoglob should fail if it doesn't match any results. eg `@g echo this-file-does-not-exist.*`

* Subshells should fail parent command when used inside `try` and `trypipe` blocks. eg `try { echo ${false} }`

Features:

* `function` now supports defining parameters

* Added support fro `&&` eg `do-something && do-something-else` for chaining successful commands

* Added support for `||` eg `do-something || do-something-else` for chaining unsuccessful commands

* Added support for writing to the terminal emulator's titlebar via `config: set shell titlebar-func { block }`

* `titlebar-func` can also be written to your `tmux` window title via `config: set shell tmux-echo true`.

* New reserved variable: `$HOSTNAME`

* New reserved variables: `$1` (and upwards) which correlates to the scope's parameter index. `$1` is the functions first parameter. `$2` is the second. `$13` is the thirteenth. 

* New reserved variable: `$0` which contains the function name

* New event: `onCommandCompletion` (this is experimental and subject to change in the next release)

* Macro variables. eg `echo Hello ^$name` will prompt the user to enter a name. Macro variables are only support in the REPL

* `read` now supports flags (eg default option, etc) to allow for a better experience in shell scripting

Minor Changes:

* You can now overwrite `onKeyPress` events. This no longer produces an error forcing you to remove the old event before adding the new one

* Autocompletion suggestions shouldn't be sorted is results include paths (improves the ordering of autocompletion suggestions)

* Autocompletion suggestions for `openagent` builtin

* Autocompletion suggestions for hashtags

* Test counts re-added to website

* Windows should show file extensions by default in autocompletion results

Bug Fixes:

* Fix inverted logic on `forceTTY`: `config: get proc force-tty false` set by default, which then proxies STDERR and prints them in red

* ctrl+c (^c) now currectly sends SIGTERM rather than just ending the child process

* Better handling of SIGTERM

* SIGTSTP isn't working. Switched to SIGSTOP when  (^z) doesn't 

* Fix panic in event `onFilesystemChange` where fileRef is not getting passed correctly

* Fix panic in event `onFilesystemChange` where path is zero length string

* Some improvements to variable previews in the REPL

* `count` should check if it is a method

* AST cache now checked more regukarly. This is to reduce the risk of memory leaks during fuzz or load testing

* `murex-docs` still referred to `len` builtin. That should be changed to `count`

* Lots of fuzzing added -- a few edge case bugs discovered

<hr>

Published: 15.05.2022 at 22:49

## See Also

* [parser/And (`&&`) Logical Operator](../parser/logical-and.md):
  Continues next operation if previous operation passes
* [parser/Or (`||`) Logical Operator](../parser/logical-or.md):
  Continues next operation only if previous operation fails
* [user-guide/Reserved Variables](../user-guide/reserved-vars.md):
  Special variables reserved by _murex_
* [commands/`@g` (autoglob) ](../commands/autoglob.md):
  Command prefix to expand globbing (deprecated)
* [commands/`config`](../commands/config.md):
  Query or define _murex_ runtime settings
* [commands/`event`](../commands/event.md):
  Event driven programming for shell scripts
* [commands/`function`](../commands/function.md):
  Define a function block
* [commands/`openagent`](../commands/openagent.md):
  Creates a handler function for `open
* [commands/`read`](../commands/read.md):
  `read` a line of input from the user and store as a variable