package docs

func init() {

	Definition["break"] = "# _murex_ Shell Docs\n\n## Command Reference: `break`\n\n> terminate execution of a block within your processes scope\n\n## Description\n\n`break` will terminate execution of a block (eg `function`, `private`,\n`foreach`, `if`, etc).\n\n`break` requires a parameter and that parameter is the name of the caller\nblock you wish to break out of. If it is a `function` or `private`, then it\nwill be the name of that function or private. If it is an `if` or `foreach`\nloop, then it will be `if` or `foreach` (respectively).\n\n## Usage\n\n    break block-name\n\n## Examples\n\n    function foo {\n        %[1..10] -> foreach i {\n            out $i\n            if { $i == 5 } then {\n                out \"exit running function\"\n                break foo\n                out \"ended\"\n            }\n        }\n    }\n    \nRunning the above code would output:\n\n    » foo\n    1\n    2\n    3\n    4\n    5\n    exit running function\n\n## Detail\n\n`break` cannot escape the bounds of its scope (typically the function it is\nrunning inside). For example, in the following code we are calling `break\nbar` (which is a different function) inside of the function `foo`:\n\n    function foo {\n        %[1..10] -> foreach i {\n            out $i\n            if { $i == 5 } then {\n                out \"exit running function\"\n                break bar\n                out \"ended\"\n            }\n        }\n    }\n    \n    function bar {\n        foo\n    }\n    \nRegardless of whether we run `foo` or `bar`, both of those functions will\nraise the following error:\n\n    Error in `break` (7,17): no block found named `bar` within the scope of `foo`\n\n## See Also\n\n* [commands/`continue`](../commands/continue.md):\n  terminate process of a block within a caller function\n* [commands/`exit`](../commands/exit.md):\n  Exit murex\n* [commands/`foreach`](../commands/foreach.md):\n  Iterate through an array\n* [commands/`formap`](../commands/formap.md):\n  Iterate through a map or other collection of data\n* [commands/`function`](../commands/function.md):\n  Define a function block\n* [commands/`if`](../commands/if.md):\n  Conditional statement to execute different blocks of code depending on the result of the condition\n* [commands/`out`](../commands/out.md):\n  Print a string to the STDOUT with a trailing new line character\n* [commands/`private`](../commands/private.md):\n  Define a private function block"

}
