package docs

func init() {

	Definition["struct-keys"] = "# _murex_ Shell Docs\n\n## Command Reference: `struct-keys`\n\n> Outputs all the keys in a structure as a file path\n\n## Description\n\n`struct-keys` outputs all of the keys in a structured data-type eg JSON, YAML,\nTOML, etc.\n\nThe output is a JSON array of the keys with each value being a file path\nrepresentation of the input structure's node.\n\n`struct-keys` accepts one optional parameter, an integer value which defines\nhow deep into a nest `struct-keys` should travel. The default is set at a\nmodest `20` for runtime performance, however this value might be subject to\nchange in future releases of _murex_ and thus you are recommended to set this\nvalue in any scripts.\n\n## Usage\n\n    <stdin> -> struct-keys [ depth ] -> <stdout>\n\n## Examples\n\n    » set: json example={\n          \"firstName\": \"John\",\n          \"lastName\": \"Smith\",\n          \"isAlive\": true,\n          \"age\": 27,\n          \"address\": {\n              \"streetAddress\": \"21 2nd Street\",\n              \"city\": \"New York\",\n              \"state\": \"NY\",\n              \"postalCode\": \"10021-3100\"\n          },\n          \"phoneNumbers\": [\n              {\n                  \"type\": \"home\",\n                  \"number\": \"212 555-1234\"\n              },\n              {\n                  \"type\": \"office\",\n                  \"number\": \"646 555-4567\"\n              },\n              {\n                  \"type\": \"mobile\",\n                  \"number\": \"123 456-7890\"\n              }\n          ],\n          \"children\": [],\n          \"spouse\": null\n      }\n    » $example -> struct-keys\n    [\n        \"/lastName\",\n        \"/isAlive\",\n        \"/age\",\n        \"/address\",\n        \"/address/state\",\n        \"/address/postalCode\",\n        \"/address/streetAddress\",\n        \"/address/city\",\n        \"/phoneNumbers\",\n        \"/phoneNumbers/0\",\n        \"/phoneNumbers/0/type\",\n        \"/phoneNumbers/0/number\",\n        \"/phoneNumbers/1\",\n        \"/phoneNumbers/1/number\",\n        \"/phoneNumbers/1/type\",\n        \"/phoneNumbers/2\",\n        \"/phoneNumbers/2/type\",\n        \"/phoneNumbers/2/number\",\n        \"/children\",\n        \"/spouse\",\n        \"/firstName\"\n    ]\n\n## See Also\n\n* [commands/`[[` (element)](../commands/element.md):\n  Outputs an element from a nested structure\n* [commands/`[` (index)](../commands/index.md):\n  Outputs an element from an array, map or table\n* [commands/`formap`](../commands/formap.md):\n  Iterate through a map or other collection of data\n* [commands/`set`](../commands/set.md):\n  Define a local variable and set it's value"

}
