package docs

func init() {

	Definition["method"] = "# _murex_ Shell Docs\n\n## Command Reference: `method`\n\n> Define a methods supported data-types\n\n## Description\n\n`method` defines what the typical data type would be for a function's STDIN\nand STDOUT.\n\n## Usage\n\n    method: define name { json }\n\n## Examples\n\n    method: define name {\n        \"Stdin\":  \"@Any\",\n        \"Stdout\": \"json\"\n    }\n\n## Detail\n\n### Type Groups\n\nYou can define a _murex_ data type or use a type group. The following type\ngroups are available to use:\n\n```go\npackage types\n\n// These are the different supported type groups\nconst (\n\tAny               = \"@Any\"\n\tText              = \"@Text\"\n\tMath              = \"@Math\"\n\tUnmarshal         = \"@Unmarshal\"\n\tMarshal           = \"@Marshal\"\n\tReadArray         = \"@ReadArray\"\n\tReadArrayWithType = \"@ReadArrayWithType\"\n\tWriteArray        = \"@WriteArray\"\n\tReadIndex         = \"@ReadIndex\"\n\tReadNotIndex      = \"@ReadNotIndex\"\n\tReadMap           = \"@ReadMap\"\n)\n\n// GroupText is an array of the data types that make up the `text` type\nvar GroupText = []string{\n\tGeneric,\n\tString,\n\t`generic`,\n\t`string`,\n}\n\n// GroupMath is an array of the data types that make up the `math` type\nvar GroupMath = []string{\n\tNumber,\n\tInteger,\n\tFloat,\n\tBoolean,\n}\n```\n\n## See Also\n\n* [commands/`alias`](../commands/alias.md):\n  Create an alias for a command\n* [commands/`autocomplete`](../commands/autocomplete.md):\n  Set definitions for tab-completion in the command line\n* [commands/`function`](../commands/function.md):\n  Define a function block\n* [commands/`private`](../commands/private.md):\n  Define a private function block\n* [commands/`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_"

}
