package docs

func init() {

	Definition["g"] = "# _murex_ Shell Docs\n\n## Command Reference: `g`\n\n> Glob pattern matching for file system objects (eg *.txt)\n\n## Description\n\nReturns a list of files and directories that match a glob pattern.\n\nOutput is a JSON list.\n\n## Usage\n\n    g: pattern -> <stdout>\n\n## Examples\n\n    # inline globbing\n    cat: @{ g: *.txt }\n    \n    # writing a JSON array of files to disk\n    g: *.txt -> > filelist.json\n    \n    # writing a list of files to disk\n    g: *.txt -> format str -> > filelist.txt\n    \n    # checking if a file exists\n    if { g: somefile.txt } then {\n        # file exists\n    }\n    \n    # checking if a file does not exist\n    !if { g: somefile.txt } then {\n        # file does not exist\n    }\n\n## Detail\n\n### Pattern reference\n\n* `*` matches any number of (including zero) characters\n* `?` matches any single character\n\n### Auto-globbing\n\nAny command prefixed with `@g` will be auto-globbed. For example, the two\nfollowing commands will produce the same output:\n\n    » ls @{g: *.go}\n    benchmarks_test.go  defaults_test.go  flags.go  godoc.go  main.go  murex_test.go\n    \n    » @g ls *.go\n    benchmarks_test.go  defaults_test.go  flags.go  godoc.go  main.go  murex_test.go\n    \nThe rational behind the ugly `@g` syntax is simply to make one-liners a bit\nless painful when coming from more traditional POSIX-like shells (eg Bash)\nwhere wildcards are automatically expanded. So if you type `ls *` (for example)\nthen realise you've forgotten to subshell, you can just recall the last command\nwith auto-globbing enabled:\n\n    @g ^!!\n\n## Synonyms\n\n* `g`\n* `@g`\n\n\n## See Also\n\n* [commands/`f`](../commands/f.md):\n  Lists objects (eg files) in the current working directory\n* [commands/`rx`](../commands/rx.md):\n  Regexp pattern matching for file system objects (eg '.*\\.txt')"

}
