package palette

import (
	colorful "github.com/lucasb-eyer/go-colorful"
	"github.com/muesli/gamut"
)

func init() {
	Wikipedia.AddColors(
		gamut.Colors{
			{"Absolute Zero", colorful.Color{R: 0.000000, G: 0.282353, B: 0.729412}, ""},
			{"Acajou", colorful.Color{R: 0.298039, G: 0.184314, B: 0.152941}, ""},
			{"Acid green", colorful.Color{R: 0.690196, G: 0.749020, B: 0.101961}, ""},
			{"Aero", colorful.Color{R: 0.486275, G: 0.725490, B: 0.909804}, ""},
			{"Aero blue", colorful.Color{R: 0.788235, G: 1.000000, B: 0.898039}, ""},
			{"African violet", colorful.Color{R: 0.698039, G: 0.517647, B: 0.745098}, ""},
			{"Air Force blue (RAF)", colorful.Color{R: 0.364706, G: 0.541176, B: 0.658824}, ""},
			{"Air Force blue (USAF)", colorful.Color{R: 0.000000, G: 0.188235, B: 0.560784}, ""},
			{"Air superiority blue", colorful.Color{R: 0.447059, G: 0.627451, B: 0.756863}, ""},
			{"Alabama crimson", colorful.Color{R: 0.686275, G: 0.000000, B: 0.164706}, ""},
			{"Alabaster", colorful.Color{R: 0.949020, G: 0.941176, B: 0.901961}, ""},
			{"Alice blue", colorful.Color{R: 0.941176, G: 0.972549, B: 1.000000}, ""},
			{"Alien Armpit", colorful.Color{R: 0.517647, G: 0.870588, B: 0.007843}, ""},
			{"Alizarin crimson", colorful.Color{R: 0.890196, G: 0.149020, B: 0.211765}, ""},
			{"Alloy orange", colorful.Color{R: 0.768627, G: 0.384314, B: 0.062745}, ""},
			{"Almond", colorful.Color{R: 0.937255, G: 0.870588, B: 0.803922}, ""},
			{"Amaranth", colorful.Color{R: 0.898039, G: 0.168627, B: 0.313725}, ""},
			{"Amaranth deep purple", colorful.Color{R: 0.623529, G: 0.168627, B: 0.407843}, ""},
			{"Amaranth pink", colorful.Color{R: 0.945098, G: 0.611765, B: 0.733333}, ""},
			{"Amaranth purple", colorful.Color{R: 0.670588, G: 0.152941, B: 0.309804}, ""},
			{"Amaranth red", colorful.Color{R: 0.827451, G: 0.129412, B: 0.176471}, ""},
			{"Amazon", colorful.Color{R: 0.231373, G: 0.478431, B: 0.341176}, ""},
			{"Amber", colorful.Color{R: 1.000000, G: 0.749020, B: 0.000000}, ""},
			{"Amber (SAE/ECE)", colorful.Color{R: 1.000000, G: 0.494118, B: 0.000000}, ""},
			{"American blue", colorful.Color{R: 0.231373, G: 0.231373, B: 0.427451}, ""},
			{"American bronze", colorful.Color{R: 0.223529, G: 0.094118, B: 0.007843}, ""},
			{"American brown", colorful.Color{R: 0.501961, G: 0.250980, B: 0.250980}, ""},
			{"American gold", colorful.Color{R: 0.827451, G: 0.686275, B: 0.215686}, ""},
			{"American green", colorful.Color{R: 0.203922, G: 0.701961, B: 0.203922}, ""},
			{"American orange", colorful.Color{R: 1.000000, G: 0.545098, B: 0.000000}, ""},
			{"American pink", colorful.Color{R: 1.000000, G: 0.596078, B: 0.600000}, ""},
			{"American purple", colorful.Color{R: 0.262745, G: 0.109804, B: 0.325490}, ""},
			{"American red", colorful.Color{R: 0.701961, G: 0.129412, B: 0.203922}, ""},
			{"American rose", colorful.Color{R: 1.000000, G: 0.011765, B: 0.243137}, ""},
			{"American silver", colorful.Color{R: 0.811765, G: 0.811765, B: 0.811765}, ""},
			{"American violet", colorful.Color{R: 0.333333, G: 0.105882, B: 0.549020}, ""},
			{"American yellow", colorful.Color{R: 0.949020, G: 0.705882, B: 0.000000}, ""},
			{"Amethyst", colorful.Color{R: 0.600000, G: 0.400000, B: 0.800000}, ""},
			{"Android green", colorful.Color{R: 0.643137, G: 0.776471, B: 0.223529}, ""},
			{"Anti-flash white", colorful.Color{R: 0.949020, G: 0.952941, B: 0.956863}, ""},
			{"Antique brass", colorful.Color{R: 0.803922, G: 0.584314, B: 0.458824}, ""},
			{"Antique bronze", colorful.Color{R: 0.400000, G: 0.364706, B: 0.117647}, ""},
			{"Antique fuchsia", colorful.Color{R: 0.568627, G: 0.360784, B: 0.513725}, ""},
			{"Antique ruby", colorful.Color{R: 0.517647, G: 0.105882, B: 0.176471}, ""},
			{"Antique white", colorful.Color{R: 0.980392, G: 0.921569, B: 0.843137}, ""},
			{"Ao (English)", colorful.Color{R: 0.000000, G: 0.501961, B: 0.000000}, ""},
			{"Apple", colorful.Color{R: 0.400000, G: 0.705882, B: 0.278431}, ""},
			{"Apple green", colorful.Color{R: 0.552941, G: 0.713725, B: 0.000000}, ""},
			{"Apricot", colorful.Color{R: 0.984314, G: 0.807843, B: 0.694118}, ""},
			{"Aqua", colorful.Color{R: 0.000000, G: 1.000000, B: 1.000000}, ""},
			{"Aquamarine", colorful.Color{R: 0.498039, G: 1.000000, B: 0.831373}, ""},
			{"Arctic lime", colorful.Color{R: 0.815686, G: 1.000000, B: 0.078431}, ""},
			{"Army green", colorful.Color{R: 0.294118, G: 0.325490, B: 0.125490}, ""},
			{"Arsenic", colorful.Color{R: 0.231373, G: 0.266667, B: 0.294118}, ""},
			{"Artichoke", colorful.Color{R: 0.560784, G: 0.592157, B: 0.474510}, ""},
			{"Arylide yellow", colorful.Color{R: 0.913725, G: 0.839216, B: 0.419608}, ""},
			{"Ash grey", colorful.Color{R: 0.698039, G: 0.745098, B: 0.709804}, ""},
			{"Asparagus", colorful.Color{R: 0.529412, G: 0.662745, B: 0.419608}, ""},
			{"Ateneo blue", colorful.Color{R: 0.000000, G: 0.227451, B: 0.423529}, ""},
			{"Atomic tangerine", colorful.Color{R: 1.000000, G: 0.600000, B: 0.400000}, ""},
			{"Auburn", colorful.Color{R: 0.647059, G: 0.164706, B: 0.164706}, ""},
			{"Aureolin", colorful.Color{R: 0.992157, G: 0.933333, B: 0.000000}, ""},
			{"AuroMetalSaurus", colorful.Color{R: 0.431373, G: 0.498039, B: 0.501961}, ""},
			{"Avocado", colorful.Color{R: 0.337255, G: 0.509804, B: 0.011765}, ""},
			{"Awesome", colorful.Color{R: 1.000000, G: 0.125490, B: 0.321569}, ""},
			{"Axolotl", colorful.Color{R: 0.388235, G: 0.466667, B: 0.356863}, ""},
			{"Azure", colorful.Color{R: 0.000000, G: 0.498039, B: 1.000000}, ""},
			{"Azure (web color)", colorful.Color{R: 0.941176, G: 1.000000, B: 1.000000}, ""},
			{"Azure mist", colorful.Color{R: 0.941176, G: 1.000000, B: 1.000000}, ""},
			{"B'dazzled blue", colorful.Color{R: 0.180392, G: 0.345098, B: 0.580392}, ""},
			{"Baby blue", colorful.Color{R: 0.537255, G: 0.811765, B: 0.941176}, ""},
			{"Baby blue eyes", colorful.Color{R: 0.631373, G: 0.792157, B: 0.945098}, ""},
			{"Baby pink", colorful.Color{R: 0.956863, G: 0.760784, B: 0.760784}, ""},
			{"Baby powder", colorful.Color{R: 0.996078, G: 0.996078, B: 0.980392}, ""},
			{"Baker-Miller pink", colorful.Color{R: 1.000000, G: 0.568627, B: 0.686275}, ""},
			{"Ball blue", colorful.Color{R: 0.129412, G: 0.670588, B: 0.803922}, ""},
			{"Banana Mania", colorful.Color{R: 0.980392, G: 0.905882, B: 0.709804}, ""},
			{"Banana yellow", colorful.Color{R: 1.000000, G: 0.882353, B: 0.207843}, ""},
			{"Bangladesh green", colorful.Color{R: 0.000000, G: 0.415686, B: 0.305882}, ""},
			{"Barbie pink", colorful.Color{R: 0.878431, G: 0.129412, B: 0.541176}, ""},
			{"Barn red", colorful.Color{R: 0.486275, G: 0.039216, B: 0.007843}, ""},
			{"Battery charged blue", colorful.Color{R: 0.113725, G: 0.674510, B: 0.839216}, ""},
			{"Battleship grey", colorful.Color{R: 0.517647, G: 0.517647, B: 0.509804}, ""},
			{"Bayside", colorful.Color{R: 0.372549, G: 0.788235, B: 0.749020}, ""},
			{"Bazaar", colorful.Color{R: 0.596078, G: 0.466667, B: 0.482353}, ""},
			{"Beau blue", colorful.Color{R: 0.737255, G: 0.831373, B: 0.901961}, ""},
			{"Begonia", colorful.Color{R: 0.980392, G: 0.431373, B: 0.474510}, ""},
			{"Beaver", colorful.Color{R: 0.623529, G: 0.505882, B: 0.439216}, ""},
			{"Beer", colorful.Color{R: 0.949020, G: 0.556863, B: 0.109804}, ""},
			{"Beige", colorful.Color{R: 0.960784, G: 0.960784, B: 0.862745}, ""},
			{"Big dip o’ruby", colorful.Color{R: 0.611765, G: 0.145098, B: 0.258824}, ""},
			{"Big Foot Feet", colorful.Color{R: 0.909804, G: 0.556863, B: 0.352941}, ""},
			{"Bisque", colorful.Color{R: 1.000000, G: 0.894118, B: 0.768627}, ""},
			{"Bistre", colorful.Color{R: 0.239216, G: 0.168627, B: 0.121569}, ""},
			{"Bistre brown", colorful.Color{R: 0.588235, G: 0.443137, B: 0.090196}, ""},
			{"Bitter lemon", colorful.Color{R: 0.792157, G: 0.878431, B: 0.050980}, ""},
			{"Bitter lime", colorful.Color{R: 0.749020, G: 1.000000, B: 0.000000}, ""},
			{"Bittersweet", colorful.Color{R: 0.996078, G: 0.435294, B: 0.368627}, ""},
			{"Bittersweet shimmer", colorful.Color{R: 0.749020, G: 0.309804, B: 0.317647}, ""},
			{"Black", colorful.Color{R: 0.000000, G: 0.000000, B: 0.000000}, ""},
			{"Black bean", colorful.Color{R: 0.239216, G: 0.047059, B: 0.007843}, ""},
			{"Black chocolate", colorful.Color{R: 0.105882, G: 0.094118, B: 0.066667}, ""},
			{"Black coffee", colorful.Color{R: 0.231373, G: 0.184314, B: 0.184314}, ""},
			{"Black coral", colorful.Color{R: 0.329412, G: 0.384314, B: 0.435294}, ""},
			{"Black leather jacket", colorful.Color{R: 0.145098, G: 0.207843, B: 0.160784}, ""},
			{"Black olive", colorful.Color{R: 0.231373, G: 0.235294, B: 0.211765}, ""},
			{"Blackberry", colorful.Color{R: 0.560784, G: 0.349020, B: 0.450980}, ""},
			{"Black Shadows", colorful.Color{R: 0.749020, G: 0.686275, B: 0.698039}, ""},
			{"Blanched almond", colorful.Color{R: 1.000000, G: 0.921569, B: 0.803922}, ""},
			{"Blast-off bronze", colorful.Color{R: 0.647059, G: 0.443137, B: 0.392157}, ""},
			{"Bleu de France", colorful.Color{R: 0.192157, G: 0.549020, B: 0.905882}, ""},
			{"Blizzard blue", colorful.Color{R: 0.674510, G: 0.898039, B: 0.933333}, ""},
			{"Blond", colorful.Color{R: 0.980392, G: 0.941176, B: 0.745098}, ""},
			{"Blood", colorful.Color{R: 0.541176, G: 0.011765, B: 0.011765}, ""},
			{"Blood orange", colorful.Color{R: 0.819608, G: 0.000000, B: 0.109804}, ""},
			{"Blood red", colorful.Color{R: 0.400000, G: 0.000000, B: 0.000000}, ""},
			{"Blood (Animal)", colorful.Color{R: 0.643137, G: 0.074510, B: 0.074510}, ""},
			{"Blood (organ)", colorful.Color{R: 0.388235, G: 0.058824, B: 0.058824}, ""},
			{"Blue", colorful.Color{R: 0.000000, G: 0.000000, B: 1.000000}, ""},
			{"Blue (Crayola)", colorful.Color{R: 0.121569, G: 0.458824, B: 0.996078}, ""},
			{"Blue (Munsell)", colorful.Color{R: 0.000000, G: 0.576471, B: 0.686275}, ""},
			{"Blue (NCS)", colorful.Color{R: 0.000000, G: 0.529412, B: 0.741176}, ""},
			{"Blue (Pantone)", colorful.Color{R: 0.000000, G: 0.094118, B: 0.658824}, ""},
			{"Blue (pigment)", colorful.Color{R: 0.200000, G: 0.200000, B: 0.600000}, ""},
			{"Blue (RYB)", colorful.Color{R: 0.007843, G: 0.278431, B: 0.996078}, ""},
			{"Blue bell", colorful.Color{R: 0.635294, G: 0.635294, B: 0.815686}, ""},
			{"Blue bolt", colorful.Color{R: 0.000000, G: 0.725490, B: 0.984314}, ""},
			{"Blue cola", colorful.Color{R: 0.000000, G: 0.533333, B: 0.862745}, ""},
			{"Blue-gray", colorful.Color{R: 0.400000, G: 0.600000, B: 0.800000}, ""},
			{"Blue-green", colorful.Color{R: 0.050980, G: 0.596078, B: 0.729412}, ""},
			{"Blue-green (color wheel)", colorful.Color{R: 0.023529, G: 0.305882, B: 0.250980}, ""},
			{"Blue jeans", colorful.Color{R: 0.364706, G: 0.678431, B: 0.925490}, ""},
			{"Blue lagoon", colorful.Color{R: 0.674510, G: 0.898039, B: 0.933333}, ""},
			{"Blue-magenta violet", colorful.Color{R: 0.333333, G: 0.207843, B: 0.572549}, ""},
			{"Blue raspberry", colorful.Color{R: 0.047059, G: 0.749020, B: 0.913725}, ""},
			{"Blue sapphire", colorful.Color{R: 0.070588, G: 0.380392, B: 0.501961}, ""},
			{"Blue-violet", colorful.Color{R: 0.541176, G: 0.168627, B: 0.886275}, ""},
			{"Blue-violet (Crayola)", colorful.Color{R: 0.450980, G: 0.400000, B: 0.741176}, ""},
			{"Blue-violet (color wheel)", colorful.Color{R: 0.301961, G: 0.101961, B: 0.498039}, ""},
			{"Blue yonder", colorful.Color{R: 0.313725, G: 0.447059, B: 0.654902}, ""},
			{"Blueberry", colorful.Color{R: 0.309804, G: 0.525490, B: 0.968627}, ""},
			{"Bluebonnet", colorful.Color{R: 0.109804, G: 0.109804, B: 0.941176}, ""},
			{"Blush", colorful.Color{R: 0.870588, G: 0.364706, B: 0.513725}, ""},
			{"Bole", colorful.Color{R: 0.474510, G: 0.266667, B: 0.231373}, ""},
			{"Bondi blue", colorful.Color{R: 0.000000, G: 0.584314, B: 0.713725}, ""},
			{"Bone", colorful.Color{R: 0.890196, G: 0.854902, B: 0.788235}, ""},
			{"Booger Buster", colorful.Color{R: 0.866667, G: 0.886275, B: 0.415686}, ""},
			{"Boston University red", colorful.Color{R: 0.800000, G: 0.000000, B: 0.000000}, ""},
			{"Bottle green", colorful.Color{R: 0.000000, G: 0.415686, B: 0.305882}, ""},
			{"Boy red", colorful.Color{R: 0.054902, G: 0.611765, B: 0.647059}, ""},
			{"Boysenberry", colorful.Color{R: 0.529412, G: 0.196078, B: 0.376471}, ""},
			{"Brandeis blue", colorful.Color{R: 0.000000, G: 0.439216, B: 1.000000}, ""},
			{"Brandy", colorful.Color{R: 0.529412, G: 0.254902, B: 0.247059}, ""},
			{"Brass", colorful.Color{R: 0.709804, G: 0.650980, B: 0.258824}, ""},
			{"Brave orange", colorful.Color{R: 1.000000, G: 0.388235, B: 0.109804}, ""},
			{"Brick red", colorful.Color{R: 0.796078, G: 0.254902, B: 0.329412}, ""},
			{"Bright cerulean", colorful.Color{R: 0.113725, G: 0.674510, B: 0.839216}, ""},
			{"Bright gray", colorful.Color{R: 0.921569, G: 0.925490, B: 0.941176}, ""},
			{"Bright green", colorful.Color{R: 0.400000, G: 1.000000, B: 0.000000}, ""},
			{"Briquette", colorful.Color{R: 0.878431, G: 0.278431, B: 0.360784}, ""},
			{"Bright lavender", colorful.Color{R: 0.749020, G: 0.580392, B: 0.894118}, ""},
			{"Bright lilac", colorful.Color{R: 0.847059, G: 0.568627, B: 0.937255}, ""},
			{"Bright maroon", colorful.Color{R: 0.764706, G: 0.129412, B: 0.282353}, ""},
			{"Bright navy blue", colorful.Color{R: 0.098039, G: 0.454902, B: 0.823529}, ""},
			{"Bright pink", colorful.Color{R: 1.000000, G: 0.000000, B: 0.498039}, ""},
			{"Bright turquoise", colorful.Color{R: 0.031373, G: 0.909804, B: 0.870588}, ""},
			{"Bright ube", colorful.Color{R: 0.819608, G: 0.623529, B: 0.909804}, ""},
			{"Bright yellow (Crayola)", colorful.Color{R: 1.000000, G: 0.666667, B: 0.113725}, ""},
			{"Brilliant azure", colorful.Color{R: 0.200000, G: 0.600000, B: 1.000000}, ""},
			{"Brilliant lavender", colorful.Color{R: 0.956863, G: 0.733333, B: 1.000000}, ""},
			{"Brilliant rose", colorful.Color{R: 1.000000, G: 0.333333, B: 0.639216}, ""},
			{"Brink pink", colorful.Color{R: 0.984314, G: 0.376471, B: 0.498039}, ""},
			{"British racing green", colorful.Color{R: 0.000000, G: 0.258824, B: 0.145098}, ""},
			{"Bronze", colorful.Color{R: 0.533333, G: 0.329412, B: 0.043137}, ""},
			{"Bronze", colorful.Color{R: 0.803922, G: 0.498039, B: 0.196078}, ""},
			{"Bronze (metallic)", colorful.Color{R: 0.690196, G: 0.552941, B: 0.341176}, ""},
			{"Bronze yellow", colorful.Color{R: 0.450980, G: 0.439216, B: 0.000000}, ""},
			{"Brown", colorful.Color{R: 0.600000, G: 0.200000, B: 0.000000}, ""},
			{"Brown (Crayola)", colorful.Color{R: 0.686275, G: 0.349020, B: 0.243137}, ""},
			{"Brown (traditional)", colorful.Color{R: 0.588235, G: 0.294118, B: 0.000000}, ""},
			{"Brown (web)", colorful.Color{R: 0.647059, G: 0.164706, B: 0.164706}, ""},
			{"Brown-nose", colorful.Color{R: 0.419608, G: 0.266667, B: 0.137255}, ""},
			{"Brown sugar", colorful.Color{R: 0.686275, G: 0.431373, B: 0.301961}, ""},
			{"Brown Chocolate", colorful.Color{R: 0.372549, G: 0.098039, B: 0.200000}, ""},
			{"Brown Coffee", colorful.Color{R: 0.290196, G: 0.172549, B: 0.164706}, ""},
			{"Brown Yellow", colorful.Color{R: 0.800000, G: 0.600000, B: 0.400000}, ""},
			{"Brunswick green", colorful.Color{R: 0.105882, G: 0.301961, B: 0.243137}, ""},
			{"Bubble gum", colorful.Color{R: 1.000000, G: 0.756863, B: 0.800000}, ""},
			{"Bubbles", colorful.Color{R: 0.905882, G: 0.996078, B: 1.000000}, ""},
			{"Bud green", colorful.Color{R: 0.482353, G: 0.713725, B: 0.380392}, ""},
			{"Buff", colorful.Color{R: 0.941176, G: 0.862745, B: 0.509804}, ""},
			{"Bulgarian rose", colorful.Color{R: 0.282353, G: 0.023529, B: 0.027451}, ""},
			{"Burgundy", colorful.Color{R: 0.501961, G: 0.000000, B: 0.125490}, ""},
			{"Burlywood", colorful.Color{R: 0.870588, G: 0.721569, B: 0.529412}, ""},
			{"Burnished brown", colorful.Color{R: 0.631373, G: 0.478431, B: 0.454902}, ""},
			{"Burnt orange", colorful.Color{R: 0.800000, G: 0.333333, B: 0.000000}, ""},
			{"Burnt sienna", colorful.Color{R: 0.913725, G: 0.454902, B: 0.317647}, ""},
			{"Burnt umber", colorful.Color{R: 0.541176, G: 0.200000, B: 0.141176}, ""},
			{"Button blue", colorful.Color{R: 0.141176, G: 0.627451, B: 0.929412}, ""},
			{"Byzantine", colorful.Color{R: 0.741176, G: 0.200000, B: 0.643137}, ""},
			{"Byzantium", colorful.Color{R: 0.439216, G: 0.160784, B: 0.388235}, ""},
			{"Cadet", colorful.Color{R: 0.325490, G: 0.407843, B: 0.447059}, ""},
			{"Cadet blue", colorful.Color{R: 0.372549, G: 0.619608, B: 0.627451}, ""},
			{"Cadet blue (Crayola)", colorful.Color{R: 0.662745, G: 0.698039, B: 0.764706}, ""},
			{"Cadet grey", colorful.Color{R: 0.568627, G: 0.639216, B: 0.690196}, ""},
			{"Cadmium blue", colorful.Color{R: 0.039216, G: 0.066667, B: 0.584314}, ""},
			{"Cadmium green", colorful.Color{R: 0.000000, G: 0.419608, B: 0.235294}, ""},
			{"Cadmium orange", colorful.Color{R: 0.929412, G: 0.529412, B: 0.176471}, ""},
			{"Cadmium purple", colorful.Color{R: 0.713725, G: 0.047059, B: 0.149020}, ""},
			{"Cadmium red", colorful.Color{R: 0.890196, G: 0.000000, B: 0.133333}, ""},
			{"Cadmium yellow", colorful.Color{R: 1.000000, G: 0.964706, B: 0.000000}, ""},
			{"Cadmium violet", colorful.Color{R: 0.498039, G: 0.243137, B: 0.596078}, ""},
			{"Café au lait", colorful.Color{R: 0.650980, G: 0.482353, B: 0.356863}, ""},
			{"Café noir", colorful.Color{R: 0.294118, G: 0.211765, B: 0.129412}, ""},
			{"Cal Poly Pomona green", colorful.Color{R: 0.117647, G: 0.301961, B: 0.168627}, ""},
			{"Calamansi", colorful.Color{R: 0.988235, G: 1.000000, B: 0.643137}, ""},
			{"Cambridge blue", colorful.Color{R: 0.639216, G: 0.756863, B: 0.678431}, ""},
			{"Camel", colorful.Color{R: 0.756863, G: 0.603922, B: 0.419608}, ""},
			{"Cameo pink", colorful.Color{R: 0.937255, G: 0.733333, B: 0.800000}, ""},
			{"Camouflage green", colorful.Color{R: 0.470588, G: 0.525490, B: 0.419608}, ""},
			{"Canary", colorful.Color{R: 1.000000, G: 1.000000, B: 0.600000}, ""},
			{"Canary yellow", colorful.Color{R: 1.000000, G: 0.937255, B: 0.000000}, ""},
			{"Candy apple red", colorful.Color{R: 1.000000, G: 0.031373, B: 0.000000}, ""},
			{"Candy pink", colorful.Color{R: 0.894118, G: 0.443137, B: 0.478431}, ""},
			{"Capri", colorful.Color{R: 0.000000, G: 0.749020, B: 1.000000}, ""},
			{"Caput mortuum", colorful.Color{R: 0.349020, G: 0.152941, B: 0.125490}, ""},
			{"Caramel", colorful.Color{R: 1.000000, G: 0.835294, B: 0.603922}, ""},
			{"Cardinal", colorful.Color{R: 0.768627, G: 0.117647, B: 0.227451}, ""},
			{"Caribbean green", colorful.Color{R: 0.000000, G: 0.800000, B: 0.600000}, ""},
			{"Carmine", colorful.Color{R: 0.588235, G: 0.000000, B: 0.094118}, ""},
			{"Carmine (M&amp;P)", colorful.Color{R: 0.843137, G: 0.000000, B: 0.250980}, ""},
			{"Carmine pink", colorful.Color{R: 0.921569, G: 0.298039, B: 0.258824}, ""},
			{"Carmine red", colorful.Color{R: 1.000000, G: 0.000000, B: 0.219608}, ""},
			{"Carnation pink", colorful.Color{R: 1.000000, G: 0.650980, B: 0.788235}, ""},
			{"Carnelian", colorful.Color{R: 0.701961, G: 0.105882, B: 0.105882}, ""},
			{"Carolina blue", colorful.Color{R: 0.337255, G: 0.627451, B: 0.827451}, ""},
			{"Carrot orange", colorful.Color{R: 0.929412, G: 0.568627, B: 0.129412}, ""},
			{"Castleton green", colorful.Color{R: 0.000000, G: 0.337255, B: 0.247059}, ""},
			{"Catalina blue", colorful.Color{R: 0.023529, G: 0.164706, B: 0.470588}, ""},
			{"Catawba", colorful.Color{R: 0.439216, G: 0.211765, B: 0.258824}, ""},
			{"Cedar Chest", colorful.Color{R: 0.788235, G: 0.352941, B: 0.286275}, ""},
			{"Ceil", colorful.Color{R: 0.572549, G: 0.631373, B: 0.811765}, ""},
			{"Celadon", colorful.Color{R: 0.674510, G: 0.882353, B: 0.686275}, ""},
			{"Celadon blue", colorful.Color{R: 0.000000, G: 0.482353, B: 0.654902}, ""},
			{"Celadon green", colorful.Color{R: 0.184314, G: 0.517647, B: 0.486275}, ""},
			{"Celeste", colorful.Color{R: 0.698039, G: 1.000000, B: 1.000000}, ""},
			{"Celestial blue", colorful.Color{R: 0.286275, G: 0.592157, B: 0.815686}, ""},
			{"Celtic blue", colorful.Color{R: 0.141176, G: 0.419608, B: 0.807843}, ""},
			{"Cerise", colorful.Color{R: 0.870588, G: 0.192157, B: 0.388235}, ""},
			{"Cerise pink", colorful.Color{R: 0.925490, G: 0.231373, B: 0.513725}, ""},
			{"Cerulean", colorful.Color{R: 0.000000, G: 0.482353, B: 0.654902}, ""},
			{"Cerulean blue", colorful.Color{R: 0.164706, G: 0.321569, B: 0.745098}, ""},
			{"Cetacean blue", colorful.Color{R: 0.000000, G: 0.078431, B: 0.250980}, ""},
			{"Cerulean frost", colorful.Color{R: 0.427451, G: 0.607843, B: 0.764706}, ""},
			{"Cerulean (Crayola)", colorful.Color{R: 0.113725, G: 0.674510, B: 0.839216}, ""},
			{"CG blue", colorful.Color{R: 0.000000, G: 0.478431, B: 0.647059}, ""},
			{"CG Red", colorful.Color{R: 0.878431, G: 0.235294, B: 0.192157}, ""},
			{"Chambray", colorful.Color{R: 0.678431, G: 0.749020, B: 0.784314}, ""},
			{"Chamoisee", colorful.Color{R: 0.627451, G: 0.470588, B: 0.352941}, ""},
			{"Champagne", colorful.Color{R: 0.968627, G: 0.905882, B: 0.807843}, ""},
			{"Champagne pink", colorful.Color{R: 0.945098, G: 0.866667, B: 0.811765}, ""},
			{"Charcoal", colorful.Color{R: 0.211765, G: 0.270588, B: 0.309804}, ""},
			{"Charleston green", colorful.Color{R: 0.137255, G: 0.168627, B: 0.168627}, ""},
			{"Charm", colorful.Color{R: 0.815686, G: 0.454902, B: 0.545098}, ""},
			{"Charm pink", colorful.Color{R: 0.901961, G: 0.560784, B: 0.674510}, ""},
			{"Chartreuse (traditional)", colorful.Color{R: 0.874510, G: 1.000000, B: 0.000000}, ""},
			{"Chartreuse (web)", colorful.Color{R: 0.498039, G: 1.000000, B: 0.000000}, ""},
			{"Cheese", colorful.Color{R: 1.000000, G: 0.650980, B: 0.000000}, ""},
			{"Cherry", colorful.Color{R: 0.870588, G: 0.192157, B: 0.388235}, ""},
			{"Cherry blossom pink", colorful.Color{R: 1.000000, G: 0.717647, B: 0.772549}, ""},
			{"Chestnut", colorful.Color{R: 0.584314, G: 0.270588, B: 0.207843}, ""},
			{"China pink", colorful.Color{R: 0.870588, G: 0.435294, B: 0.631373}, ""},
			{"China rose", colorful.Color{R: 0.658824, G: 0.317647, B: 0.431373}, ""},
			{"Chinese black", colorful.Color{R: 0.078431, G: 0.078431, B: 0.078431}, ""},
			{"Chinese blue", colorful.Color{R: 0.211765, G: 0.317647, B: 0.580392}, ""},
			{"Chinese bronze", colorful.Color{R: 0.803922, G: 0.501961, B: 0.196078}, ""},
			{"Chinese brown", colorful.Color{R: 0.670588, G: 0.219608, B: 0.121569}, ""},
			{"Chinese green", colorful.Color{R: 0.815686, G: 0.858824, B: 0.380392}, ""},
			{"Chinese gold", colorful.Color{R: 0.800000, G: 0.600000, B: 0.000000}, ""},
			{"Chinese orange", colorful.Color{R: 0.952941, G: 0.439216, B: 0.258824}, ""},
			{"Chinese pink", colorful.Color{R: 0.870588, G: 0.439216, B: 0.631373}, ""},
			{"Chinese purple", colorful.Color{R: 0.447059, G: 0.043137, B: 0.596078}, ""},
			{"Chinese red", colorful.Color{R: 0.803922, G: 0.027451, B: 0.117647}, ""},
			{"Chinese red", colorful.Color{R: 0.666667, G: 0.219608, B: 0.117647}, ""},
			{"Chinese silver", colorful.Color{R: 0.800000, G: 0.800000, B: 0.800000}, ""},
			{"Chinese violet", colorful.Color{R: 0.521569, G: 0.376471, B: 0.533333}, ""},
			{"Chinese white", colorful.Color{R: 0.886275, G: 0.898039, B: 0.870588}, ""},
			{"Chinese yellow", colorful.Color{R: 1.000000, G: 0.698039, B: 0.000000}, ""},
			{"Chlorophyll green", colorful.Color{R: 0.290196, G: 1.000000, B: 0.000000}, ""},
			{"Chocolate brown", colorful.Color{R: 0.247059, G: 0.000000, B: 0.058824}, ""},
			{"Chocolate cosmos", colorful.Color{R: 0.345098, G: 0.066667, B: 0.101961}, ""},
			{"Chocolate Kisses", colorful.Color{R: 0.235294, G: 0.078431, B: 0.129412}, ""},
			{"Chocolate (traditional)", colorful.Color{R: 0.482353, G: 0.247059, B: 0.000000}, ""},
			{"Chocolate (web)", colorful.Color{R: 0.823529, G: 0.411765, B: 0.117647}, ""},
			{"Chrome yellow", colorful.Color{R: 1.000000, G: 0.654902, B: 0.000000}, ""},
			{"Cinereous", colorful.Color{R: 0.596078, G: 0.505882, B: 0.482353}, ""},
			{"Cinnabar", colorful.Color{R: 0.890196, G: 0.258824, B: 0.203922}, ""},
			{"Cinnamon", colorful.Color{R: 0.823529, G: 0.411765, B: 0.117647}, ""},
			{"Cinnamon Satin", colorful.Color{R: 0.803922, G: 0.376471, B: 0.494118}, ""},
			{"Citrine", colorful.Color{R: 0.894118, G: 0.815686, B: 0.039216}, ""},
			{"Citrine Brown", colorful.Color{R: 0.576471, G: 0.215686, B: 0.035294}, ""},
			{"Citron", colorful.Color{R: 0.623529, G: 0.662745, B: 0.121569}, ""},
			{"Claret", colorful.Color{R: 0.498039, G: 0.090196, B: 0.203922}, ""},
			{"Classic rose", colorful.Color{R: 0.984314, G: 0.800000, B: 0.905882}, ""},
			{"Cobalt blue", colorful.Color{R: 0.000000, G: 0.278431, B: 0.670588}, ""},
			{"Cocoa brown", colorful.Color{R: 0.823529, G: 0.411765, B: 0.117647}, ""},
			{"Coconut", colorful.Color{R: 0.588235, G: 0.352941, B: 0.243137}, ""},
			{"Coffee", colorful.Color{R: 0.435294, G: 0.305882, B: 0.215686}, ""},
			{"Cola", colorful.Color{R: 0.235294, G: 0.188235, B: 0.141176}, ""},
			{"Columbia Blue", colorful.Color{R: 0.768627, G: 0.847059, B: 0.886275}, ""},
			{"Conditioner", colorful.Color{R: 1.000000, G: 1.000000, B: 0.800000}, ""},
			{"Congo pink", colorful.Color{R: 0.972549, G: 0.513725, B: 0.474510}, ""},
			{"Cool black", colorful.Color{R: 0.000000, G: 0.180392, B: 0.388235}, ""},
			{"Cool grey", colorful.Color{R: 0.549020, G: 0.572549, B: 0.674510}, ""},
			{"Cookies and cream", colorful.Color{R: 0.933333, G: 0.878431, B: 0.694118}, ""},
			{"Copper", colorful.Color{R: 0.721569, G: 0.450980, B: 0.200000}, ""},
			{"Copper (Crayola)", colorful.Color{R: 0.854902, G: 0.541176, B: 0.403922}, ""},
			{"Copper penny", colorful.Color{R: 0.678431, G: 0.435294, B: 0.411765}, ""},
			{"Copper red", colorful.Color{R: 0.796078, G: 0.427451, B: 0.317647}, ""},
			{"Copper rose", colorful.Color{R: 0.600000, G: 0.400000, B: 0.400000}, ""},
			{"Coquelicot", colorful.Color{R: 1.000000, G: 0.219608, B: 0.000000}, ""},
			{"Coral", colorful.Color{R: 1.000000, G: 0.498039, B: 0.313725}, ""},
			{"Coral pink", colorful.Color{R: 0.972549, G: 0.513725, B: 0.474510}, ""},
			{"Coral red", colorful.Color{R: 1.000000, G: 0.250980, B: 0.250980}, ""},
			{"Coral reef", colorful.Color{R: 0.992157, G: 0.486275, B: 0.431373}, ""},
			{"Coral Reef (Valspar Paint Color)", colorful.Color{R: 0.964706, G: 0.643137, B: 0.580392}, ""},
			{"Cordovan", colorful.Color{R: 0.537255, G: 0.247059, B: 0.270588}, ""},
			{"Corn", colorful.Color{R: 0.984314, G: 0.925490, B: 0.364706}, ""},
			{"Cornell red", colorful.Color{R: 0.701961, G: 0.105882, B: 0.105882}, ""},
			{"Cornflower blue", colorful.Color{R: 0.392157, G: 0.584314, B: 0.929412}, ""},
			{"Cornflower", colorful.Color{R: 0.576471, G: 0.800000, B: 0.917647}, ""},
			{"Cornsilk", colorful.Color{R: 1.000000, G: 0.972549, B: 0.862745}, ""},
			{"Cosmic cobalt", colorful.Color{R: 0.180392, G: 0.176471, B: 0.533333}, ""},
			{"Cosmic latte", colorful.Color{R: 1.000000, G: 0.972549, B: 0.905882}, ""},
			{"Coyote brown", colorful.Color{R: 0.505882, G: 0.380392, B: 0.235294}, ""},
			{"Cotton candy", colorful.Color{R: 1.000000, G: 0.737255, B: 0.850980}, ""},
			{"Cream", colorful.Color{R: 1.000000, G: 0.992157, B: 0.815686}, ""},
			{"Crimson", colorful.Color{R: 0.862745, G: 0.078431, B: 0.235294}, ""},
			{"Crimson glory", colorful.Color{R: 0.745098, G: 0.000000, B: 0.196078}, ""},
			{"Crimson red", colorful.Color{R: 0.600000, G: 0.000000, B: 0.000000}, ""},
			{"Cultured", colorful.Color{R: 0.960784, G: 0.960784, B: 0.960784}, ""},
			{"Cyan", colorful.Color{R: 0.000000, G: 1.000000, B: 1.000000}, ""},
			{"Cyan azure", colorful.Color{R: 0.305882, G: 0.509804, B: 0.705882}, ""},
			{"Cyan-blue azure", colorful.Color{R: 0.274510, G: 0.509804, B: 0.749020}, ""},
			{"Cyan cobalt blue", colorful.Color{R: 0.156863, G: 0.345098, B: 0.611765}, ""},
			{"Cyan cornflower blue", colorful.Color{R: 0.094118, G: 0.545098, B: 0.760784}, ""},
			{"Cyan (process)", colorful.Color{R: 0.000000, G: 0.717647, B: 0.921569}, ""},
			{"Cyber grape", colorful.Color{R: 0.345098, G: 0.258824, B: 0.486275}, ""},
			{"Cyber yellow", colorful.Color{R: 1.000000, G: 0.827451, B: 0.000000}, ""},
			{"Cyclamen", colorful.Color{R: 0.960784, G: 0.435294, B: 0.631373}, ""},
			{"Daffodil", colorful.Color{R: 1.000000, G: 1.000000, B: 0.192157}, ""},
			{"Dandelion", colorful.Color{R: 0.941176, G: 0.882353, B: 0.188235}, ""},
			{"Dandelion (Crayola)", colorful.Color{R: 0.992157, G: 0.858824, B: 0.427451}, ""},
			{"Dark blue", colorful.Color{R: 0.000000, G: 0.000000, B: 0.545098}, ""},
			{"Dark blue-gray", colorful.Color{R: 0.400000, G: 0.400000, B: 0.600000}, ""},
			{"Dark bronze", colorful.Color{R: 0.501961, G: 0.290196, B: 0.000000}, ""},
			{"Dark bronze (Coin)", colorful.Color{R: 0.317647, G: 0.254902, B: 0.000000}, ""},
			{"Dark brown", colorful.Color{R: 0.396078, G: 0.262745, B: 0.129412}, ""},
			{"Dark brown-tangelo", colorful.Color{R: 0.533333, G: 0.396078, B: 0.305882}, ""},
			{"Dark byzantium", colorful.Color{R: 0.364706, G: 0.223529, B: 0.329412}, ""},
			{"Dark candy apple red", colorful.Color{R: 0.643137, G: 0.000000, B: 0.000000}, ""},
			{"Dark cerulean", colorful.Color{R: 0.031373, G: 0.270588, B: 0.494118}, ""},
			{"Dark charcoal", colorful.Color{R: 0.200000, G: 0.200000, B: 0.200000}, ""},
			{"Dark chestnut", colorful.Color{R: 0.596078, G: 0.411765, B: 0.376471}, ""},
			{"Dark chocolate", colorful.Color{R: 0.286275, G: 0.007843, B: 0.023529}, ""},
			{"Dark chocolate (Hershey's)", colorful.Color{R: 0.235294, G: 0.074510, B: 0.129412}, ""},
			{"Dark cornflower blue", colorful.Color{R: 0.149020, G: 0.258824, B: 0.545098}, ""},
			{"Dark coral", colorful.Color{R: 0.803922, G: 0.356863, B: 0.270588}, ""},
			{"Dark cyan", colorful.Color{R: 0.000000, G: 0.545098, B: 0.545098}, ""},
			{"Dark electric blue", colorful.Color{R: 0.325490, G: 0.407843, B: 0.470588}, ""},
			{"Dark gold", colorful.Color{R: 0.666667, G: 0.423529, B: 0.223529}, ""},
			{"Dark goldenrod", colorful.Color{R: 0.721569, G: 0.525490, B: 0.043137}, ""},
			{"Dark gray (X11)", colorful.Color{R: 0.662745, G: 0.662745, B: 0.662745}, ""},
			{"Dark green", colorful.Color{R: 0.003922, G: 0.196078, B: 0.125490}, ""},
			{"Dark green (X11)", colorful.Color{R: 0.000000, G: 0.392157, B: 0.000000}, ""},
			{"Dark gunmetal", colorful.Color{R: 0.121569, G: 0.149020, B: 0.164706}, ""},
			{"Dark imperial blue", colorful.Color{R: 0.000000, G: 0.254902, B: 0.415686}, ""},
			{"Dark imperial blue", colorful.Color{R: 0.000000, G: 0.078431, B: 0.494118}, ""},
			{"Dark jungle green", colorful.Color{R: 0.101961, G: 0.141176, B: 0.129412}, ""},
			{"Dark khaki", colorful.Color{R: 0.741176, G: 0.717647, B: 0.419608}, ""},
			{"Dark lava", colorful.Color{R: 0.282353, G: 0.235294, B: 0.196078}, ""},
			{"Dark lavender", colorful.Color{R: 0.450980, G: 0.309804, B: 0.588235}, ""},
			{"Dark lemon lime", colorful.Color{R: 0.545098, G: 0.745098, B: 0.105882}, ""},
			{"Dark liver", colorful.Color{R: 0.325490, G: 0.294118, B: 0.309804}, ""},
			{"Dark liver (horses)", colorful.Color{R: 0.329412, G: 0.239216, B: 0.215686}, ""},
			{"Dark magenta", colorful.Color{R: 0.545098, G: 0.000000, B: 0.545098}, ""},
			{"Dark medium gray", colorful.Color{R: 0.662745, G: 0.662745, B: 0.662745}, ""},
			{"Dark midnight blue", colorful.Color{R: 0.000000, G: 0.200000, B: 0.400000}, ""},
			{"Dark moss green", colorful.Color{R: 0.290196, G: 0.364706, B: 0.137255}, ""},
			{"Dark olive green", colorful.Color{R: 0.333333, G: 0.419608, B: 0.184314}, ""},
			{"Dark orange", colorful.Color{R: 1.000000, G: 0.549020, B: 0.000000}, ""},
			{"Dark orchid", colorful.Color{R: 0.600000, G: 0.196078, B: 0.800000}, ""},
			{"Dark pastel blue", colorful.Color{R: 0.466667, G: 0.619608, B: 0.796078}, ""},
			{"Dark pastel green", colorful.Color{R: 0.011765, G: 0.752941, B: 0.235294}, ""},
			{"Dark pastel purple", colorful.Color{R: 0.588235, G: 0.435294, B: 0.839216}, ""},
			{"Dark pastel red", colorful.Color{R: 0.760784, G: 0.231373, B: 0.133333}, ""},
			{"Dark pink", colorful.Color{R: 0.905882, G: 0.329412, B: 0.501961}, ""},
			{"Dark powder blue", colorful.Color{R: 0.000000, G: 0.200000, B: 0.600000}, ""},
			{"Dark puce", colorful.Color{R: 0.309804, G: 0.227451, B: 0.235294}, ""},
			{"Dark purple", colorful.Color{R: 0.188235, G: 0.098039, B: 0.203922}, ""},
			{"Dark raspberry", colorful.Color{R: 0.529412, G: 0.149020, B: 0.341176}, ""},
			{"Dark red", colorful.Color{R: 0.545098, G: 0.000000, B: 0.000000}, ""},
			{"Dark salmon", colorful.Color{R: 0.913725, G: 0.588235, B: 0.478431}, ""},
			{"Dark scarlet", colorful.Color{R: 0.337255, G: 0.011765, B: 0.098039}, ""},
			{"Dark sea green", colorful.Color{R: 0.560784, G: 0.737255, B: 0.560784}, ""},
			{"Dark sienna", colorful.Color{R: 0.235294, G: 0.078431, B: 0.078431}, ""},
			{"Dark silver", colorful.Color{R: 0.443137, G: 0.439216, B: 0.431373}, ""},
			{"Dark sky blue", colorful.Color{R: 0.549020, G: 0.745098, B: 0.839216}, ""},
			{"Dark slate blue", colorful.Color{R: 0.282353, G: 0.239216, B: 0.545098}, ""},
			{"Dark slate gray", colorful.Color{R: 0.184314, G: 0.309804, B: 0.309804}, ""},
			{"Dark spring green", colorful.Color{R: 0.090196, G: 0.447059, B: 0.270588}, ""},
			{"Dark tan", colorful.Color{R: 0.568627, G: 0.505882, B: 0.317647}, ""},
			{"Dark tangerine", colorful.Color{R: 1.000000, G: 0.658824, B: 0.070588}, ""},
			{"Dark taupe", colorful.Color{R: 0.282353, G: 0.235294, B: 0.196078}, ""},
			{"Dark terra cotta", colorful.Color{R: 0.800000, G: 0.305882, B: 0.360784}, ""},
			{"Dark turquoise", colorful.Color{R: 0.000000, G: 0.807843, B: 0.819608}, ""},
			{"Dark vanilla", colorful.Color{R: 0.819608, G: 0.745098, B: 0.658824}, ""},
			{"Dark violet", colorful.Color{R: 0.580392, G: 0.000000, B: 0.827451}, ""},
			{"Dark yellow", colorful.Color{R: 0.607843, G: 0.529412, B: 0.047059}, ""},
			{"Dartmouth green", colorful.Color{R: 0.000000, G: 0.439216, B: 0.235294}, ""},
			{"Davy's grey", colorful.Color{R: 0.333333, G: 0.333333, B: 0.333333}, ""},
			{"Debian red", colorful.Color{R: 0.843137, G: 0.039216, B: 0.325490}, ""},
			{"Deep amethyst", colorful.Color{R: 0.611765, G: 0.541176, B: 0.643137}, ""},
			{"Deep aquamarine", colorful.Color{R: 0.250980, G: 0.509804, B: 0.427451}, ""},
			{"Deep carmine", colorful.Color{R: 0.662745, G: 0.125490, B: 0.243137}, ""},
			{"Deep carmine pink", colorful.Color{R: 0.937255, G: 0.188235, B: 0.219608}, ""},
			{"Deep carrot orange", colorful.Color{R: 0.913725, G: 0.411765, B: 0.172549}, ""},
			{"Deep cerise", colorful.Color{R: 0.854902, G: 0.196078, B: 0.529412}, ""},
			{"Deep champagne", colorful.Color{R: 0.980392, G: 0.839216, B: 0.647059}, ""},
			{"Deep chestnut", colorful.Color{R: 0.725490, G: 0.305882, B: 0.282353}, ""},
			{"Deep coffee", colorful.Color{R: 0.439216, G: 0.258824, B: 0.254902}, ""},
			{"Deep fuchsia", colorful.Color{R: 0.756863, G: 0.329412, B: 0.756863}, ""},
			{"Deep Green", colorful.Color{R: 0.019608, G: 0.400000, B: 0.031373}, ""},
			{"Deep green-cyan turquoise", colorful.Color{R: 0.054902, G: 0.486275, B: 0.380392}, ""},
			{"Deep jungle green", colorful.Color{R: 0.000000, G: 0.294118, B: 0.286275}, ""},
			{"Deep koamaru", colorful.Color{R: 0.200000, G: 0.200000, B: 0.400000}, ""},
			{"Deep lemon", colorful.Color{R: 0.960784, G: 0.780392, B: 0.101961}, ""},
			{"Deep lilac", colorful.Color{R: 0.600000, G: 0.333333, B: 0.733333}, ""},
			{"Deep magenta", colorful.Color{R: 0.800000, G: 0.000000, B: 0.800000}, ""},
			{"Deep maroon", colorful.Color{R: 0.509804, G: 0.000000, B: 0.000000}, ""},
			{"Deep mauve", colorful.Color{R: 0.831373, G: 0.450980, B: 0.831373}, ""},
			{"Deep moss green", colorful.Color{R: 0.207843, G: 0.368627, B: 0.231373}, ""},
			{"Deep peach", colorful.Color{R: 1.000000, G: 0.796078, B: 0.643137}, ""},
			{"Deep pink", colorful.Color{R: 1.000000, G: 0.078431, B: 0.576471}, ""},
			{"Deep puce", colorful.Color{R: 0.662745, G: 0.360784, B: 0.407843}, ""},
			{"Deep Red", colorful.Color{R: 0.521569, G: 0.003922, B: 0.003922}, ""},
			{"Deep ruby", colorful.Color{R: 0.517647, G: 0.247059, B: 0.356863}, ""},
			{"Deep saffron", colorful.Color{R: 1.000000, G: 0.600000, B: 0.200000}, ""},
			{"Deep sky blue", colorful.Color{R: 0.000000, G: 0.749020, B: 1.000000}, ""},
			{"Deep Space Sparkle", colorful.Color{R: 0.290196, G: 0.392157, B: 0.423529}, ""},
			{"Deep spring bud", colorful.Color{R: 0.333333, G: 0.419608, B: 0.184314}, ""},
			{"Deep Taupe", colorful.Color{R: 0.494118, G: 0.368627, B: 0.376471}, ""},
			{"Deep Tuscan red", colorful.Color{R: 0.400000, G: 0.258824, B: 0.301961}, ""},
			{"Deep violet", colorful.Color{R: 0.200000, G: 0.000000, B: 0.400000}, ""},
			{"Deer", colorful.Color{R: 0.729412, G: 0.529412, B: 0.349020}, ""},
			{"Denim", colorful.Color{R: 0.082353, G: 0.376471, B: 0.741176}, ""},
			{"Denim Blue", colorful.Color{R: 0.133333, G: 0.262745, B: 0.713725}, ""},
			{"Desaturated cyan", colorful.Color{R: 0.400000, G: 0.600000, B: 0.600000}, ""},
			{"Desert", colorful.Color{R: 0.756863, G: 0.603922, B: 0.419608}, ""},
			{"Desert sand", colorful.Color{R: 0.929412, G: 0.788235, B: 0.686275}, ""},
			{"Desire", colorful.Color{R: 0.917647, G: 0.235294, B: 0.325490}, ""},
			{"Diamond", colorful.Color{R: 0.725490, G: 0.949020, B: 1.000000}, ""},
			{"Dim gray", colorful.Color{R: 0.411765, G: 0.411765, B: 0.411765}, ""},
			{"Dingy Dungeon", colorful.Color{R: 0.772549, G: 0.192157, B: 0.317647}, ""},
			{"Dirt", colorful.Color{R: 0.607843, G: 0.462745, B: 0.325490}, ""},
			{"Dirty brown", colorful.Color{R: 0.709804, G: 0.396078, B: 0.117647}, ""},
			{"Dirty white", colorful.Color{R: 0.909804, G: 0.894118, B: 0.788235}, ""},
			{"Dodger blue", colorful.Color{R: 0.117647, G: 0.564706, B: 1.000000}, ""},
			{"Dodie yellow", colorful.Color{R: 0.996078, G: 0.964706, B: 0.356863}, ""},
			{"Dogwood rose", colorful.Color{R: 0.843137, G: 0.094118, B: 0.407843}, ""},
			{"Dollar bill", colorful.Color{R: 0.521569, G: 0.733333, B: 0.396078}, ""},
			{"Dolphin gray", colorful.Color{R: 0.509804, G: 0.556863, B: 0.517647}, ""},
			{"Donkey brown", colorful.Color{R: 0.400000, G: 0.298039, B: 0.156863}, ""},
			{"Drab", colorful.Color{R: 0.588235, G: 0.443137, B: 0.090196}, ""},
			{"Duke blue", colorful.Color{R: 0.000000, G: 0.000000, B: 0.611765}, ""},
			{"Dust storm", colorful.Color{R: 0.898039, G: 0.800000, B: 0.788235}, ""},
			{"Dutch white", colorful.Color{R: 0.937255, G: 0.874510, B: 0.733333}, ""},
			{"Earthtone", colorful.Color{R: 0.364706, G: 0.227451, B: 0.101961}, ""},
			{"Earth yellow", colorful.Color{R: 0.882353, G: 0.662745, B: 0.372549}, ""},
			{"Ebony", colorful.Color{R: 0.333333, G: 0.364706, B: 0.313725}, ""},
			{"Ecru", colorful.Color{R: 0.760784, G: 0.698039, B: 0.501961}, ""},
			{"Eerie black", colorful.Color{R: 0.105882, G: 0.105882, B: 0.105882}, ""},
			{"Eggplant", colorful.Color{R: 0.380392, G: 0.250980, B: 0.317647}, ""},
			{"Eggshell", colorful.Color{R: 0.941176, G: 0.917647, B: 0.839216}, ""},
			{"Egyptian blue", colorful.Color{R: 0.062745, G: 0.203922, B: 0.650980}, ""},
			{"Electric blue", colorful.Color{R: 0.490196, G: 0.976471, B: 1.000000}, ""},
			{"Electric brown", colorful.Color{R: 0.709804, G: 0.384314, B: 0.341176}, ""},
			{"Electric crimson", colorful.Color{R: 1.000000, G: 0.000000, B: 0.247059}, ""},
			{"Electric cyan", colorful.Color{R: 0.000000, G: 1.000000, B: 1.000000}, ""},
			{"Electric green", colorful.Color{R: 0.000000, G: 1.000000, B: 0.000000}, ""},
			{"Electric indigo", colorful.Color{R: 0.435294, G: 0.000000, B: 1.000000}, ""},
			{"Electric lavender", colorful.Color{R: 0.956863, G: 0.733333, B: 1.000000}, ""},
			{"Electric lime", colorful.Color{R: 0.800000, G: 1.000000, B: 0.000000}, ""},
			{"Electric orange", colorful.Color{R: 1.000000, G: 0.207843, B: 0.011765}, ""},
			{"Electric pink", colorful.Color{R: 0.964706, G: 0.149020, B: 0.505882}, ""},
			{"Electric purple", colorful.Color{R: 0.749020, G: 0.000000, B: 1.000000}, ""},
			{"Electric red", colorful.Color{R: 0.901961, G: 0.000000, B: 0.000000}, ""},
			{"Electric ultramarine", colorful.Color{R: 0.247059, G: 0.000000, B: 1.000000}, ""},
			{"Electric violet", colorful.Color{R: 0.560784, G: 0.000000, B: 1.000000}, ""},
			{"Electric yellow", colorful.Color{R: 1.000000, G: 1.000000, B: 0.200000}, ""},
			{"Emerald", colorful.Color{R: 0.313725, G: 0.784314, B: 0.470588}, ""},
			{"Emerald green", colorful.Color{R: 0.015686, G: 0.388235, B: 0.027451}, ""},
			{"Eminence", colorful.Color{R: 0.423529, G: 0.188235, B: 0.509804}, ""},
			{"English green", colorful.Color{R: 0.105882, G: 0.301961, B: 0.243137}, ""},
			{"English lavender", colorful.Color{R: 0.705882, G: 0.513725, B: 0.584314}, ""},
			{"English red", colorful.Color{R: 0.670588, G: 0.294118, B: 0.321569}, ""},
			{"English vermillion", colorful.Color{R: 0.800000, G: 0.278431, B: 0.294118}, ""},
			{"English violet", colorful.Color{R: 0.337255, G: 0.235294, B: 0.360784}, ""},
			{"Eton blue", colorful.Color{R: 0.588235, G: 0.784314, B: 0.635294}, ""},
			{"Eucalyptus", colorful.Color{R: 0.266667, G: 0.843137, B: 0.658824}, ""},
			{"Facebook Blue", colorful.Color{R: 0.223529, G: 0.337255, B: 0.611765}, ""},
			{"Fallow", colorful.Color{R: 0.756863, G: 0.603922, B: 0.419608}, ""},
			{"Falu red", colorful.Color{R: 0.501961, G: 0.094118, B: 0.094118}, ""},
			{"Fandango", colorful.Color{R: 0.709804, G: 0.200000, B: 0.537255}, ""},
			{"Fandango pink", colorful.Color{R: 0.870588, G: 0.321569, B: 0.521569}, ""},
			{"Fashion fuchsia", colorful.Color{R: 0.956863, G: 0.000000, B: 0.631373}, ""},
			{"Fawn", colorful.Color{R: 0.898039, G: 0.666667, B: 0.439216}, ""},
			{"Feldgrau", colorful.Color{R: 0.301961, G: 0.364706, B: 0.325490}, ""},
			{"Feldspar", colorful.Color{R: 0.992157, G: 0.835294, B: 0.694118}, ""},
			{"Fern green", colorful.Color{R: 0.309804, G: 0.474510, B: 0.258824}, ""},
			{"Ferrari red", colorful.Color{R: 1.000000, G: 0.156863, B: 0.000000}, ""},
			{"Field drab", colorful.Color{R: 0.423529, G: 0.329412, B: 0.117647}, ""},
			{"Fiery rose", colorful.Color{R: 1.000000, G: 0.329412, B: 0.439216}, ""},
			{"Firebrick", colorful.Color{R: 0.698039, G: 0.133333, B: 0.133333}, ""},
			{"Fire engine red", colorful.Color{R: 0.807843, G: 0.125490, B: 0.160784}, ""},
			{"Fire opal", colorful.Color{R: 0.913725, G: 0.360784, B: 0.294118}, ""},
			{"Flame", colorful.Color{R: 0.886275, G: 0.345098, B: 0.133333}, ""},
			{"Flamingo pink", colorful.Color{R: 0.988235, G: 0.556863, B: 0.674510}, ""},
			{"Flattery", colorful.Color{R: 0.419608, G: 0.266667, B: 0.137255}, ""},
			{"Flavescent", colorful.Color{R: 0.968627, G: 0.913725, B: 0.556863}, ""},
			{"Flax", colorful.Color{R: 0.933333, G: 0.862745, B: 0.509804}, ""},
			{"Flesh", colorful.Color{R: 1.000000, G: 0.913725, B: 0.819608}, ""},
			{"Flickr Blue", colorful.Color{R: 0.129412, G: 0.419608, B: 0.839216}, ""},
			{"Flickr Pink", colorful.Color{R: 0.984314, G: 0.000000, B: 0.505882}, ""},
			{"Flirt", colorful.Color{R: 0.635294, G: 0.000000, B: 0.427451}, ""},
			{"Floral white", colorful.Color{R: 1.000000, G: 0.980392, B: 0.941176}, ""},
			{"Flower girl", colorful.Color{R: 0.956863, G: 0.596078, B: 0.678431}, ""},
			{"Fluorescent blue", colorful.Color{R: 0.082353, G: 0.956863, B: 0.933333}, ""},
			{"Fluorescent orange", colorful.Color{R: 1.000000, G: 0.749020, B: 0.000000}, ""},
			{"Fluorescent pink", colorful.Color{R: 1.000000, G: 0.078431, B: 0.576471}, ""},
			{"Fluorescent yellow", colorful.Color{R: 0.800000, G: 1.000000, B: 0.000000}, ""},
			{"Folly", colorful.Color{R: 1.000000, G: 0.000000, B: 0.309804}, ""},
			{"Forest green (Crayola)", colorful.Color{R: 0.372549, G: 0.654902, B: 0.466667}, ""},
			{"Forest green (traditional)", colorful.Color{R: 0.003922, G: 0.266667, B: 0.129412}, ""},
			{"Forest green (web)", colorful.Color{R: 0.133333, G: 0.545098, B: 0.133333}, ""},
			{"French beige", colorful.Color{R: 0.650980, G: 0.482353, B: 0.356863}, ""},
			{"French bistre", colorful.Color{R: 0.521569, G: 0.427451, B: 0.301961}, ""},
			{"French blue", colorful.Color{R: 0.000000, G: 0.447059, B: 0.733333}, ""},
			{"French fuchsia", colorful.Color{R: 0.992157, G: 0.247059, B: 0.572549}, ""},
			{"French lilac", colorful.Color{R: 0.525490, G: 0.376471, B: 0.556863}, ""},
			{"French lime", colorful.Color{R: 0.619608, G: 0.992157, B: 0.219608}, ""},
			{"French mauve", colorful.Color{R: 0.831373, G: 0.450980, B: 0.831373}, ""},
			{"French Middle Red Purple", colorful.Color{R: 0.109804, G: 0.007843, B: 0.094118}, ""},
			{"French pink", colorful.Color{R: 0.992157, G: 0.423529, B: 0.619608}, ""},
			{"French plum", colorful.Color{R: 0.505882, G: 0.078431, B: 0.325490}, ""},
			{"French puce", colorful.Color{R: 0.305882, G: 0.086275, B: 0.035294}, ""},
			{"French raspberry", colorful.Color{R: 0.780392, G: 0.172549, B: 0.282353}, ""},
			{"French rose", colorful.Color{R: 0.964706, G: 0.290196, B: 0.541176}, ""},
			{"French sky blue", colorful.Color{R: 0.466667, G: 0.709804, B: 0.996078}, ""},
			{"French violet", colorful.Color{R: 0.533333, G: 0.023529, B: 0.807843}, ""},
			{"French wine", colorful.Color{R: 0.674510, G: 0.117647, B: 0.266667}, ""},
			{"Fresh Air", colorful.Color{R: 0.650980, G: 0.905882, B: 1.000000}, ""},
			{"Frostbite", colorful.Color{R: 0.913725, G: 0.211765, B: 0.654902}, ""},
			{"Fuchsia", colorful.Color{R: 1.000000, G: 0.000000, B: 1.000000}, ""},
			{"Fuchsia (Crayola)", colorful.Color{R: 0.756863, G: 0.329412, B: 0.756863}, ""},
			{"Fuchsia pink", colorful.Color{R: 1.000000, G: 0.466667, B: 1.000000}, ""},
			{"Fuchsia purple", colorful.Color{R: 0.800000, G: 0.223529, B: 0.482353}, ""},
			{"Fuchsia rose", colorful.Color{R: 0.780392, G: 0.262745, B: 0.458824}, ""},
			{"Fulvous", colorful.Color{R: 0.894118, G: 0.517647, B: 0.000000}, ""},
			{"Fuzzy Wuzzy", colorful.Color{R: 0.800000, G: 0.400000, B: 0.400000}, ""},
			{"Gainsboro", colorful.Color{R: 0.862745, G: 0.862745, B: 0.862745}, ""},
			{"Gamboge", colorful.Color{R: 0.894118, G: 0.607843, B: 0.058824}, ""},
			{"Gamboge orange (brown)", colorful.Color{R: 0.600000, G: 0.400000, B: 0.000000}, ""},
			{"Garnet", colorful.Color{R: 0.450980, G: 0.211765, B: 0.207843}, ""},
			{"Gargoyle Gas", colorful.Color{R: 1.000000, G: 0.874510, B: 0.274510}, ""},
			{"Generic viridian", colorful.Color{R: 0.000000, G: 0.498039, B: 0.400000}, ""},
			{"Ghost white", colorful.Color{R: 0.972549, G: 0.972549, B: 1.000000}, ""},
			{"Giant's Club", colorful.Color{R: 0.690196, G: 0.360784, B: 0.321569}, ""},
			{"Giants orange", colorful.Color{R: 0.996078, G: 0.352941, B: 0.113725}, ""},
			{"Gin", colorful.Color{R: 0.847059, G: 0.894118, B: 0.737255}, ""},
			{"Glaucous", colorful.Color{R: 0.376471, G: 0.509804, B: 0.713725}, ""},
			{"Glossy grape", colorful.Color{R: 0.670588, G: 0.572549, B: 0.701961}, ""},
			{"GO green", colorful.Color{R: 0.000000, G: 0.670588, B: 0.400000}, ""},
			{"Gold", colorful.Color{R: 0.647059, G: 0.486275, B: 0.000000}, ""},
			{"Gold (metallic)", colorful.Color{R: 0.831373, G: 0.686275, B: 0.215686}, ""},
			{"Gold (web) (Golden)", colorful.Color{R: 1.000000, G: 0.843137, B: 0.000000}, ""},
			{"Gold (Crayola)", colorful.Color{R: 0.901961, G: 0.745098, B: 0.541176}, ""},
			{"Gold Fusion", colorful.Color{R: 0.521569, G: 0.458824, B: 0.305882}, ""},
			{"Gold foil", colorful.Color{R: 0.741176, G: 0.607843, B: 0.086275}, ""},
			{"Golden brown", colorful.Color{R: 0.600000, G: 0.396078, B: 0.082353}, ""},
			{"Golden poppy", colorful.Color{R: 0.988235, G: 0.760784, B: 0.000000}, ""},
			{"Golden yellow", colorful.Color{R: 1.000000, G: 0.874510, B: 0.000000}, ""},
			{"Goldenrod", colorful.Color{R: 0.854902, G: 0.647059, B: 0.125490}, ""},
			{"Google Chrome red", colorful.Color{R: 0.870588, G: 0.321569, B: 0.274510}, ""},
			{"Google Chrome blue", colorful.Color{R: 0.298039, G: 0.545098, B: 0.960784}, ""},
			{"Google Chrome green", colorful.Color{R: 0.101961, G: 0.635294, B: 0.376471}, ""},
			{"Google Chrome yellow", colorful.Color{R: 1.000000, G: 0.807843, B: 0.266667}, ""},
			{"Granite gray", colorful.Color{R: 0.403922, G: 0.403922, B: 0.403922}, ""},
			{"Granny Smith apple", colorful.Color{R: 0.658824, G: 0.894118, B: 0.627451}, ""},
			{"Grape", colorful.Color{R: 0.435294, G: 0.176471, B: 0.658824}, ""},
			{"Gray (HTML/CSS gray)", colorful.Color{R: 0.501961, G: 0.501961, B: 0.501961}, ""},
			{"Gray (X11 gray)", colorful.Color{R: 0.745098, G: 0.745098, B: 0.745098}, ""},
			{"Gray-asparagus", colorful.Color{R: 0.274510, G: 0.349020, B: 0.270588}, ""},
			{"Gray-blue", colorful.Color{R: 0.549020, G: 0.572549, B: 0.674510}, ""},
			{"Green", colorful.Color{R: 0.000000, G: 0.501961, B: 0.003922}, ""},
			{"Green (Color Wheel) (X11 green)", colorful.Color{R: 0.000000, G: 1.000000, B: 0.000000}, ""},
			{"Green (Crayola)", colorful.Color{R: 0.109804, G: 0.674510, B: 0.470588}, ""},
			{"Green (HTML/CSS color)", colorful.Color{R: 0.000000, G: 0.501961, B: 0.000000}, ""},
			{"Green (Munsell)", colorful.Color{R: 0.000000, G: 0.658824, B: 0.466667}, ""},
			{"Green (NCS)", colorful.Color{R: 0.000000, G: 0.623529, B: 0.419608}, ""},
			{"Green (Pantone)", colorful.Color{R: 0.000000, G: 0.678431, B: 0.262745}, ""},
			{"Green (pigment)", colorful.Color{R: 0.000000, G: 0.647059, B: 0.313725}, ""},
			{"Green (RYB)", colorful.Color{R: 0.400000, G: 0.690196, B: 0.196078}, ""},
			{"Green-blue", colorful.Color{R: 0.066667, G: 0.392157, B: 0.705882}, ""},
			{"Green-blue (Crayola)", colorful.Color{R: 0.156863, G: 0.529412, B: 0.784314}, ""},
			{"Green Cola", colorful.Color{R: 0.298039, G: 0.447059, B: 0.113725}, ""},
			{"Green-cyan", colorful.Color{R: 0.000000, G: 0.600000, B: 0.400000}, ""},
			{"Green Lizard", colorful.Color{R: 0.654902, G: 0.956863, B: 0.196078}, ""},
			{"Green Sheen", colorful.Color{R: 0.431373, G: 0.682353, B: 0.631373}, ""},
			{"Green slime", colorful.Color{R: 0.396078, G: 1.000000, B: 0.000000}, ""},
			{"Green-yellow", colorful.Color{R: 0.678431, G: 1.000000, B: 0.184314}, ""},
			{"Green-yellow (Crayola)", colorful.Color{R: 0.941176, G: 0.909804, B: 0.568627}, ""},
			{"Grullo", colorful.Color{R: 0.662745, G: 0.603922, B: 0.525490}, ""},
			{"Guppie green", colorful.Color{R: 0.000000, G: 1.000000, B: 0.498039}, ""},
			{"Gunmetal", colorful.Color{R: 0.164706, G: 0.203922, B: 0.223529}, ""},
			{"Guyabano", colorful.Color{R: 0.972549, G: 0.972549, B: 0.972549}, ""},
			{"Halayà úbe", colorful.Color{R: 0.400000, G: 0.219608, B: 0.329412}, ""},
			{"Halloween orange", colorful.Color{R: 0.921569, G: 0.380392, B: 0.137255}, ""},
			{"Han blue", colorful.Color{R: 0.266667, G: 0.423529, B: 0.811765}, ""},
			{"Han purple", colorful.Color{R: 0.321569, G: 0.094118, B: 0.980392}, ""},
			{"Hansa yellow", colorful.Color{R: 0.913725, G: 0.839216, B: 0.419608}, ""},
			{"Harlequin", colorful.Color{R: 0.247059, G: 1.000000, B: 0.000000}, ""},
			{"Harlequin green", colorful.Color{R: 0.274510, G: 0.796078, B: 0.094118}, ""},
			{"Harmonious rose", colorful.Color{R: 0.949020, G: 0.611765, B: 0.717647}, ""},
			{"Harvard crimson", colorful.Color{R: 0.788235, G: 0.000000, B: 0.086275}, ""},
			{"Harvest gold", colorful.Color{R: 0.854902, G: 0.568627, B: 0.000000}, ""},
			{"Heart gold", colorful.Color{R: 0.501961, G: 0.501961, B: 0.000000}, ""},
			{"Heat Wave", colorful.Color{R: 1.000000, G: 0.478431, B: 0.000000}, ""},
			{"Heidelberg red", colorful.Color{R: 0.588235, G: 0.000000, B: 0.094118}, ""},
			{"Heliotrope", colorful.Color{R: 0.874510, G: 0.450980, B: 1.000000}, ""},
			{"Heliotrope gray", colorful.Color{R: 0.666667, G: 0.596078, B: 0.662745}, ""},
			{"Heliotrope magenta", colorful.Color{R: 0.666667, G: 0.000000, B: 0.733333}, ""},
			{"Hollywood cerise", colorful.Color{R: 0.956863, G: 0.000000, B: 0.631373}, ""},
			{"Honeydew", colorful.Color{R: 0.941176, G: 1.000000, B: 0.941176}, ""},
			{"Honolulu blue", colorful.Color{R: 0.000000, G: 0.427451, B: 0.690196}, ""},
			{"Hooker's green", colorful.Color{R: 0.286275, G: 0.474510, B: 0.419608}, ""},
			{"Hot magenta", colorful.Color{R: 1.000000, G: 0.113725, B: 0.807843}, ""},
			{"Hot pink", colorful.Color{R: 1.000000, G: 0.411765, B: 0.705882}, ""},
			{"Hunter green", colorful.Color{R: 0.207843, G: 0.368627, B: 0.231373}, ""},
			{"Iceberg", colorful.Color{R: 0.443137, G: 0.650980, B: 0.823529}, ""},
			{"Iced tea", colorful.Color{R: 0.572549, G: 0.235294, B: 0.003922}, ""},
			{"Icterine", colorful.Color{R: 0.988235, G: 0.968627, B: 0.368627}, ""},
			{"Iguana green", colorful.Color{R: 0.443137, G: 0.737255, B: 0.470588}, ""},
			{"Illuminating emerald", colorful.Color{R: 0.192157, G: 0.568627, B: 0.466667}, ""},
			{"Imperial", colorful.Color{R: 0.376471, G: 0.184314, B: 0.419608}, ""},
			{"Imperial blue", colorful.Color{R: 0.000000, G: 0.137255, B: 0.584314}, ""},
			{"Imperial purple", colorful.Color{R: 0.400000, G: 0.007843, B: 0.235294}, ""},
			{"Imperial red", colorful.Color{R: 0.929412, G: 0.160784, B: 0.223529}, ""},
			{"Inchworm", colorful.Color{R: 0.698039, G: 0.925490, B: 0.364706}, ""},
			{"Independence", colorful.Color{R: 0.298039, G: 0.317647, B: 0.427451}, ""},
			{"India green", colorful.Color{R: 0.074510, G: 0.533333, B: 0.031373}, ""},
			{"Indian red", colorful.Color{R: 0.803922, G: 0.360784, B: 0.360784}, ""},
			{"Indian yellow", colorful.Color{R: 0.890196, G: 0.658824, B: 0.341176}, ""},
			{"Indigo", colorful.Color{R: 0.294118, G: 0.000000, B: 0.509804}, ""},
			{"Indigo dye", colorful.Color{R: 0.035294, G: 0.121569, B: 0.572549}, ""},
			{"Indigo (Crayola)", colorful.Color{R: 0.309804, G: 0.411765, B: 0.776471}, ""},
			{"Indigo (Rainbow)", colorful.Color{R: 0.137255, G: 0.188235, B: 0.403922}, ""},
			{"Indigo (web)", colorful.Color{R: 0.294118, G: 0.000000, B: 0.509804}, ""},
			{"Infra red", colorful.Color{R: 1.000000, G: 0.286275, B: 0.423529}, ""},
			{"Interdimensional blue", colorful.Color{R: 0.211765, G: 0.047059, B: 0.800000}, ""},
			{"International Klein Blue", colorful.Color{R: 0.000000, G: 0.184314, B: 0.654902}, ""},
			{"International orange (aerospace)", colorful.Color{R: 1.000000, G: 0.309804, B: 0.000000}, ""},
			{"International orange (engineering)", colorful.Color{R: 0.729412, G: 0.086275, B: 0.047059}, ""},
			{"International orange (Golden Gate Bridge)", colorful.Color{R: 0.752941, G: 0.211765, B: 0.172549}, ""},
			{"Iris", colorful.Color{R: 0.352941, G: 0.309804, B: 0.811765}, ""},
			{"Iron", colorful.Color{R: 0.631373, G: 0.615686, B: 0.580392}, ""},
			{"Irresistible", colorful.Color{R: 0.701961, G: 0.266667, B: 0.423529}, ""},
			{"Isabelline", colorful.Color{R: 0.956863, G: 0.941176, B: 0.925490}, ""},
			{"Islamic green", colorful.Color{R: 0.000000, G: 0.564706, B: 0.000000}, ""},
			{"Italian sky blue", colorful.Color{R: 0.698039, G: 1.000000, B: 1.000000}, ""},
			{"Ivory", colorful.Color{R: 1.000000, G: 1.000000, B: 0.941176}, ""},
			{"Jacarta", colorful.Color{R: 0.239216, G: 0.196078, B: 0.364706}, ""},
			{"Jacko bean", colorful.Color{R: 0.254902, G: 0.211765, B: 0.156863}, ""},
			{"Jade", colorful.Color{R: 0.000000, G: 0.658824, B: 0.419608}, ""},
			{"Japanese carmine", colorful.Color{R: 0.615686, G: 0.160784, B: 0.200000}, ""},
			{"Japanese indigo", colorful.Color{R: 0.149020, G: 0.262745, B: 0.282353}, ""},
			{"Japanese laurel", colorful.Color{R: 0.184314, G: 0.458824, B: 0.196078}, ""},
			{"Japanese violet", colorful.Color{R: 0.356863, G: 0.196078, B: 0.337255}, ""},
			{"Jasmine", colorful.Color{R: 0.972549, G: 0.870588, B: 0.494118}, ""},
			{"Jasper", colorful.Color{R: 0.843137, G: 0.231373, B: 0.243137}, ""},
			{"Jasper orange", colorful.Color{R: 0.870588, G: 0.560784, B: 0.305882}, ""},
			{"Jazzberry jam", colorful.Color{R: 0.647059, G: 0.043137, B: 0.368627}, ""},
			{"Jelly bean", colorful.Color{R: 0.854902, G: 0.380392, B: 0.305882}, ""},
			{"Jelly bean blue", colorful.Color{R: 0.266667, G: 0.474510, B: 0.556863}, ""},
			{"Jet", colorful.Color{R: 0.203922, G: 0.203922, B: 0.203922}, ""},
			{"Jet stream", colorful.Color{R: 0.733333, G: 0.815686, B: 0.788235}, ""},
			{"Jonquil", colorful.Color{R: 0.956863, G: 0.792157, B: 0.086275}, ""},
			{"Jordy blue", colorful.Color{R: 0.541176, G: 0.725490, B: 0.945098}, ""},
			{"June bud", colorful.Color{R: 0.741176, G: 0.854902, B: 0.341176}, ""},
			{"Jungle green", colorful.Color{R: 0.160784, G: 0.670588, B: 0.529412}, ""},
			{"Kelly green", colorful.Color{R: 0.298039, G: 0.733333, B: 0.090196}, ""},
			{"Kenyan copper", colorful.Color{R: 0.486275, G: 0.109804, B: 0.019608}, ""},
			{"Keppel", colorful.Color{R: 0.227451, G: 0.690196, B: 0.619608}, ""},
			{"Key lime", colorful.Color{R: 0.909804, G: 0.956863, B: 0.549020}, ""},
			{"Khaki (HTML/CSS) (Khaki)", colorful.Color{R: 0.764706, G: 0.690196, B: 0.568627}, ""},
			{"Khaki (X11) (Light khaki)", colorful.Color{R: 0.941176, G: 0.901961, B: 0.549020}, ""},
			{"Kiwi", colorful.Color{R: 0.556863, G: 0.898039, B: 0.247059}, ""},
			{"Kobe", colorful.Color{R: 0.533333, G: 0.176471, B: 0.090196}, ""},
			{"Kobi", colorful.Color{R: 0.905882, G: 0.623529, B: 0.768627}, ""},
			{"Kobicha", colorful.Color{R: 0.419608, G: 0.266667, B: 0.137255}, ""},
			{"Kombu green", colorful.Color{R: 0.207843, G: 0.258824, B: 0.188235}, ""},
			{"KSU Purple", colorful.Color{R: 0.317647, G: 0.156863, B: 0.533333}, ""},
			{"KU Crimson", colorful.Color{R: 0.909804, G: 0.000000, B: 0.050980}, ""},
			{"La Salle green", colorful.Color{R: 0.031373, G: 0.470588, B: 0.188235}, ""},
			{"Languid lavender", colorful.Color{R: 0.839216, G: 0.792157, B: 0.866667}, ""},
			{"Lanzones", colorful.Color{R: 0.878431, G: 0.737255, B: 0.356863}, ""},
			{"Lapis lazuli", colorful.Color{R: 0.149020, G: 0.380392, B: 0.611765}, ""},
			{"Laser Lemon", colorful.Color{R: 1.000000, G: 1.000000, B: 0.400000}, ""},
			{"Laurel green", colorful.Color{R: 0.662745, G: 0.729412, B: 0.615686}, ""},
			{"Lava", colorful.Color{R: 0.811765, G: 0.062745, B: 0.125490}, ""},
			{"Lavender (floral)", colorful.Color{R: 0.709804, G: 0.494118, B: 0.862745}, ""},
			{"Lavender (web)", colorful.Color{R: 0.901961, G: 0.901961, B: 0.980392}, ""},
			{"Lavender blue", colorful.Color{R: 0.800000, G: 0.800000, B: 1.000000}, ""},
			{"Lavender blush", colorful.Color{R: 1.000000, G: 0.941176, B: 0.960784}, ""},
			{"Lavender gray", colorful.Color{R: 0.768627, G: 0.764706, B: 0.815686}, ""},
			{"Lavender indigo", colorful.Color{R: 0.580392, G: 0.341176, B: 0.921569}, ""},
			{"Lavender magenta", colorful.Color{R: 0.933333, G: 0.509804, B: 0.933333}, ""},
			{"Lavender mist", colorful.Color{R: 0.901961, G: 0.901961, B: 0.980392}, ""},
			{"Lavender pink", colorful.Color{R: 0.984314, G: 0.682353, B: 0.823529}, ""},
			{"Lavender purple", colorful.Color{R: 0.588235, G: 0.482353, B: 0.713725}, ""},
			{"Lavender rose", colorful.Color{R: 0.984314, G: 0.627451, B: 0.890196}, ""},
			{"Lawn green", colorful.Color{R: 0.486275, G: 0.988235, B: 0.000000}, ""},
			{"Lemon", colorful.Color{R: 1.000000, G: 0.968627, B: 0.000000}, ""},
			{"Lemon chiffon", colorful.Color{R: 1.000000, G: 0.980392, B: 0.803922}, ""},
			{"Lemon curry", colorful.Color{R: 0.800000, G: 0.627451, B: 0.113725}, ""},
			{"Lemon glacier", colorful.Color{R: 0.992157, G: 1.000000, B: 0.000000}, ""},
			{"Lemon iced tea", colorful.Color{R: 0.741176, G: 0.188235, B: 0.000000}, ""},
			{"Lemon lime", colorful.Color{R: 0.890196, G: 1.000000, B: 0.000000}, ""},
			{"Lemon lime", colorful.Color{R: 0.360784, G: 1.000000, B: 0.403922}, ""},
			{"Lemon meringue", colorful.Color{R: 0.964706, G: 0.917647, B: 0.745098}, ""},
			{"Lemon yellow", colorful.Color{R: 1.000000, G: 0.956863, B: 0.309804}, ""},
			{"Lemon yellow (Crayola)", colorful.Color{R: 1.000000, G: 1.000000, B: 0.623529}, ""},
			{"Lenurple", colorful.Color{R: 0.729412, G: 0.576471, B: 0.847059}, ""},
			{"Liberty", colorful.Color{R: 0.329412, G: 0.352941, B: 0.654902}, ""},
			{"Licorice", colorful.Color{R: 0.101961, G: 0.066667, B: 0.062745}, ""},
			{"Light apricot", colorful.Color{R: 0.992157, G: 0.835294, B: 0.694118}, ""},
			{"Light blue", colorful.Color{R: 0.678431, G: 0.847059, B: 0.901961}, ""},
			{"Light brown", colorful.Color{R: 0.709804, G: 0.396078, B: 0.113725}, ""},
			{"Light carmine pink", colorful.Color{R: 0.901961, G: 0.403922, B: 0.443137}, ""},
			{"Light chocolate cosmos", colorful.Color{R: 0.333333, G: 0.121569, B: 0.184314}, ""},
			{"Light cobalt blue", colorful.Color{R: 0.533333, G: 0.674510, B: 0.878431}, ""},
			{"Light coral", colorful.Color{R: 0.941176, G: 0.501961, B: 0.501961}, ""},
			{"Light cornflower blue", colorful.Color{R: 0.576471, G: 0.800000, B: 0.917647}, ""},
			{"Light crimson", colorful.Color{R: 0.960784, G: 0.411765, B: 0.568627}, ""},
			{"Light cyan", colorful.Color{R: 0.878431, G: 1.000000, B: 1.000000}, ""},
			{"Light deep pink", colorful.Color{R: 1.000000, G: 0.360784, B: 0.803922}, ""},
			{"Light French beige", colorful.Color{R: 0.784314, G: 0.678431, B: 0.498039}, ""},
			{"Light fuchsia pink", colorful.Color{R: 0.976471, G: 0.517647, B: 0.937255}, ""},
			{"Light gold", colorful.Color{R: 0.698039, G: 0.592157, B: 0.000000}, ""},
			{"Light goldenrod yellow", colorful.Color{R: 0.980392, G: 0.980392, B: 0.823529}, ""},
			{"Light gray", colorful.Color{R: 0.827451, G: 0.827451, B: 0.827451}, ""},
			{"Light grayish magenta", colorful.Color{R: 0.800000, G: 0.600000, B: 0.800000}, ""},
			{"Light green", colorful.Color{R: 0.564706, G: 0.933333, B: 0.564706}, ""},
			{"Light hot pink", colorful.Color{R: 1.000000, G: 0.701961, B: 0.870588}, ""},
			{"Light khaki", colorful.Color{R: 0.941176, G: 0.901961, B: 0.549020}, ""},
			{"Light medium orchid", colorful.Color{R: 0.827451, G: 0.607843, B: 0.796078}, ""},
			{"Light moss green", colorful.Color{R: 0.678431, G: 0.874510, B: 0.678431}, ""},
			{"Light orange", colorful.Color{R: 0.996078, G: 0.847059, B: 0.694118}, ""},
			{"Light orchid", colorful.Color{R: 0.901961, G: 0.658824, B: 0.843137}, ""},
			{"Light pastel purple", colorful.Color{R: 0.694118, G: 0.611765, B: 0.850980}, ""},
			{"Light periwinkle", colorful.Color{R: 0.772549, G: 0.796078, B: 0.882353}, ""},
			{"Light pink", colorful.Color{R: 1.000000, G: 0.713725, B: 0.756863}, ""},
			{"Light red", colorful.Color{R: 1.000000, G: 0.800000, B: 0.796078}, ""},
			{"Light red ochre", colorful.Color{R: 0.913725, G: 0.454902, B: 0.317647}, ""},
			{"Light salmon", colorful.Color{R: 1.000000, G: 0.627451, B: 0.478431}, ""},
			{"Light salmon pink", colorful.Color{R: 1.000000, G: 0.600000, B: 0.600000}, ""},
			{"Light sea green", colorful.Color{R: 0.125490, G: 0.698039, B: 0.666667}, ""},
			{"Light silver", colorful.Color{R: 0.847059, G: 0.847059, B: 0.847059}, ""},
			{"Light sky blue", colorful.Color{R: 0.529412, G: 0.807843, B: 0.980392}, ""},
			{"Light slate gray", colorful.Color{R: 0.466667, G: 0.533333, B: 0.600000}, ""},
			{"Light steel blue", colorful.Color{R: 0.690196, G: 0.768627, B: 0.870588}, ""},
			{"Light taupe", colorful.Color{R: 0.701961, G: 0.545098, B: 0.427451}, ""},
			{"Light Thulian pink", colorful.Color{R: 0.901961, G: 0.560784, B: 0.674510}, ""},
			{"Light yellow", colorful.Color{R: 1.000000, G: 1.000000, B: 0.878431}, ""},
			{"Lilac", colorful.Color{R: 0.784314, G: 0.635294, B: 0.784314}, ""},
			{"Lilac Luster", colorful.Color{R: 0.682353, G: 0.596078, B: 0.666667}, ""},
			{"Lime (color wheel)", colorful.Color{R: 0.749020, G: 1.000000, B: 0.000000}, ""},
			{"Lime (web) (X11 green)", colorful.Color{R: 0.000000, G: 1.000000, B: 0.000000}, ""},
			{"Lime green", colorful.Color{R: 0.196078, G: 0.803922, B: 0.196078}, ""},
			{"Limerick", colorful.Color{R: 0.615686, G: 0.760784, B: 0.035294}, ""},
			{"Lincoln green", colorful.Color{R: 0.098039, G: 0.349020, B: 0.019608}, ""},
			{"Linen", colorful.Color{R: 0.980392, G: 0.941176, B: 0.901961}, ""},
			{"Lion", colorful.Color{R: 0.756863, G: 0.603922, B: 0.419608}, ""},
			{"Liseran purple", colorful.Color{R: 0.870588, G: 0.435294, B: 0.631373}, ""},
			{"Little boy blue", colorful.Color{R: 0.423529, G: 0.627451, B: 0.862745}, ""},
			{"Little girl pink", colorful.Color{R: 0.972549, G: 0.725490, B: 0.831373}, ""},
			{"Liver", colorful.Color{R: 0.403922, G: 0.298039, B: 0.278431}, ""},
			{"Liver (dogs)", colorful.Color{R: 0.721569, G: 0.427451, B: 0.160784}, ""},
			{"Liver (organ)", colorful.Color{R: 0.423529, G: 0.180392, B: 0.121569}, ""},
			{"Liver chestnut", colorful.Color{R: 0.596078, G: 0.454902, B: 0.337255}, ""},
			{"Livid", colorful.Color{R: 0.400000, G: 0.600000, B: 0.800000}, ""},
			{"Lotion", colorful.Color{R: 0.996078, G: 0.992157, B: 0.980392}, ""},
			{"Lotion blue", colorful.Color{R: 0.082353, G: 0.949020, B: 0.992157}, ""},
			{"Lotion pink", colorful.Color{R: 0.925490, G: 0.811765, B: 0.811765}, ""},
			{"Lumber", colorful.Color{R: 1.000000, G: 0.894118, B: 0.803922}, ""},
			{"Lust", colorful.Color{R: 0.901961, G: 0.125490, B: 0.125490}, ""},
			{"Maastricht Blue", colorful.Color{R: 0.000000, G: 0.109804, B: 0.239216}, ""},
			{"Macaroni and Cheese", colorful.Color{R: 1.000000, G: 0.741176, B: 0.533333}, ""},
			{"Madder Lake", colorful.Color{R: 0.800000, G: 0.200000, B: 0.211765}, ""},
			{"Magenta", colorful.Color{R: 1.000000, G: 0.000000, B: 1.000000}, ""},
			{"Magenta (Crayola)", colorful.Color{R: 1.000000, G: 0.333333, B: 0.639216}, ""},
			{"Magenta (dye)", colorful.Color{R: 0.792157, G: 0.121569, B: 0.482353}, ""},
			{"Magenta (Pantone)", colorful.Color{R: 0.815686, G: 0.254902, B: 0.494118}, ""},
			{"Magenta (process)", colorful.Color{R: 1.000000, G: 0.000000, B: 0.564706}, ""},
			{"Magenta haze", colorful.Color{R: 0.623529, G: 0.270588, B: 0.462745}, ""},
			{"Magenta-pink", colorful.Color{R: 0.800000, G: 0.200000, B: 0.545098}, ""},
			{"Magic mint", colorful.Color{R: 0.666667, G: 0.941176, B: 0.819608}, ""},
			{"Magic Potion", colorful.Color{R: 1.000000, G: 0.266667, B: 0.400000}, ""},
			{"Magnolia", colorful.Color{R: 0.972549, G: 0.956863, B: 1.000000}, ""},
			{"Mahogany", colorful.Color{R: 0.752941, G: 0.250980, B: 0.000000}, ""},
			{"Mahogany (Crayola)", colorful.Color{R: 0.792157, G: 0.203922, B: 0.207843}, ""},
			{"Maize", colorful.Color{R: 0.984314, G: 0.925490, B: 0.364706}, ""},
			{"Maize (Crayola)", colorful.Color{R: 0.949020, G: 0.776471, B: 0.286275}, ""},
			{"Majorelle Blue", colorful.Color{R: 0.376471, G: 0.313725, B: 0.862745}, ""},
			{"Malachite", colorful.Color{R: 0.043137, G: 0.854902, B: 0.317647}, ""},
			{"Manatee", colorful.Color{R: 0.592157, G: 0.603922, B: 0.666667}, ""},
			{"Mandarin", colorful.Color{R: 0.952941, G: 0.478431, B: 0.282353}, ""},
			{"Mango", colorful.Color{R: 0.992157, G: 0.745098, B: 0.007843}, ""},
			{"Mango green", colorful.Color{R: 0.588235, G: 1.000000, B: 0.000000}, ""},
			{"Mango Tango", colorful.Color{R: 1.000000, G: 0.509804, B: 0.262745}, ""},
			{"Mantis", colorful.Color{R: 0.454902, G: 0.764706, B: 0.396078}, ""},
			{"Mardi Gras", colorful.Color{R: 0.533333, G: 0.000000, B: 0.521569}, ""},
			{"Marigold", colorful.Color{R: 0.917647, G: 0.635294, B: 0.129412}, ""},
			{"Maroon (Crayola)", colorful.Color{R: 0.764706, G: 0.129412, B: 0.282353}, ""},
			{"Maroon (HTML/CSS)", colorful.Color{R: 0.501961, G: 0.000000, B: 0.000000}, ""},
			{"Maroon (X11)", colorful.Color{R: 0.690196, G: 0.188235, B: 0.376471}, ""},
			{"Mauve", colorful.Color{R: 0.878431, G: 0.690196, B: 1.000000}, ""},
			{"Mauve taupe", colorful.Color{R: 0.568627, G: 0.372549, B: 0.427451}, ""},
			{"Mauvelous", colorful.Color{R: 0.937255, G: 0.596078, B: 0.666667}, ""},
			{"Maximum Blue", colorful.Color{R: 0.278431, G: 0.670588, B: 0.800000}, ""},
			{"Maximum Blue Green", colorful.Color{R: 0.188235, G: 0.749020, B: 0.749020}, ""},
			{"Maximum Blue Purple", colorful.Color{R: 0.674510, G: 0.674510, B: 0.901961}, ""},
			{"Maximum Green", colorful.Color{R: 0.368627, G: 0.549020, B: 0.192157}, ""},
			{"Maximum Green Yellow", colorful.Color{R: 0.850980, G: 0.901961, B: 0.313725}, ""},
			{"Maximum orange", colorful.Color{R: 1.000000, G: 0.356863, B: 0.000000}, ""},
			{"Maximum Purple", colorful.Color{R: 0.450980, G: 0.200000, B: 0.501961}, ""},
			{"Maximum pink", colorful.Color{R: 0.964706, G: 0.647059, B: 0.949020}, ""},
			{"Maximum red", colorful.Color{R: 0.850980, G: 0.129412, B: 0.129412}, ""},
			{"Maximum Red Purple", colorful.Color{R: 0.650980, G: 0.227451, B: 0.474510}, ""},
			{"Maximum violet", colorful.Color{R: 0.537255, G: 0.184314, B: 0.466667}, ""},
			{"Maximum yellow", colorful.Color{R: 0.980392, G: 0.980392, B: 0.215686}, ""},
			{"Maximum yellow red", colorful.Color{R: 0.949020, G: 0.729412, B: 0.286275}, ""},
			{"May green", colorful.Color{R: 0.298039, G: 0.568627, B: 0.254902}, ""},
			{"Maya blue", colorful.Color{R: 0.450980, G: 0.760784, B: 0.984314}, ""},
			{"Meat brown", colorful.Color{R: 0.898039, G: 0.717647, B: 0.231373}, ""},
			{"Medium aquamarine", colorful.Color{R: 0.400000, G: 0.866667, B: 0.666667}, ""},
			{"Medium blue", colorful.Color{R: 0.000000, G: 0.000000, B: 0.803922}, ""},
			{"Medium candy apple red", colorful.Color{R: 0.886275, G: 0.023529, B: 0.172549}, ""},
			{"Medium carmine", colorful.Color{R: 0.686275, G: 0.250980, B: 0.207843}, ""},
			{"Medium champagne", colorful.Color{R: 0.952941, G: 0.898039, B: 0.670588}, ""},
			{"Medium electric blue", colorful.Color{R: 0.011765, G: 0.313725, B: 0.588235}, ""},
			{"Medium green", colorful.Color{R: 0.011765, G: 0.474510, B: 0.286275}, ""},
			{"Medium jungle green", colorful.Color{R: 0.109804, G: 0.207843, B: 0.176471}, ""},
			{"Medium lavender magenta", colorful.Color{R: 0.866667, G: 0.627451, B: 0.866667}, ""},
			{"Medium orange", colorful.Color{R: 1.000000, G: 0.470588, B: 0.007843}, ""},
			{"Medium orchid", colorful.Color{R: 0.729412, G: 0.333333, B: 0.827451}, ""},
			{"Medium Persian blue", colorful.Color{R: 0.000000, G: 0.403922, B: 0.647059}, ""},
			{"Medium pink", colorful.Color{R: 0.996078, G: 0.431373, B: 0.623529}, ""},
			{"Medium purple", colorful.Color{R: 0.576471, G: 0.439216, B: 0.858824}, ""},
			{"Medium red", colorful.Color{R: 0.694118, G: 0.011765, B: 0.015686}, ""},
			{"Medium red-violet", colorful.Color{R: 0.733333, G: 0.200000, B: 0.521569}, ""},
			{"Medium ruby", colorful.Color{R: 0.666667, G: 0.250980, B: 0.411765}, ""},
			{"Medium sea green", colorful.Color{R: 0.235294, G: 0.701961, B: 0.443137}, ""},
			{"Medium sky blue", colorful.Color{R: 0.501961, G: 0.854902, B: 0.921569}, ""},
			{"Medium slate blue", colorful.Color{R: 0.482353, G: 0.407843, B: 0.933333}, ""},
			{"Medium spring bud", colorful.Color{R: 0.788235, G: 0.862745, B: 0.529412}, ""},
			{"Medium spring green", colorful.Color{R: 0.000000, G: 0.980392, B: 0.603922}, ""},
			{"Medium taupe", colorful.Color{R: 0.403922, G: 0.298039, B: 0.278431}, ""},
			{"Medium turquoise", colorful.Color{R: 0.282353, G: 0.819608, B: 0.800000}, ""},
			{"Medium Tuscan red", colorful.Color{R: 0.474510, G: 0.266667, B: 0.231373}, ""},
			{"Medium vermilion", colorful.Color{R: 0.850980, G: 0.376471, B: 0.231373}, ""},
			{"Medium violet", colorful.Color{R: 0.396078, G: 0.192157, B: 0.372549}, ""},
			{"Medium violet-red", colorful.Color{R: 0.780392, G: 0.082353, B: 0.521569}, ""},
			{"Medium yellow", colorful.Color{R: 1.000000, G: 0.890196, B: 0.007843}, ""},
			{"Mellow apricot", colorful.Color{R: 0.972549, G: 0.721569, B: 0.470588}, ""},
			{"Mellow yellow", colorful.Color{R: 0.972549, G: 0.870588, B: 0.494118}, ""},
			{"Melon", colorful.Color{R: 0.992157, G: 0.737255, B: 0.705882}, ""},
			{"Melon (Crayola)", colorful.Color{R: 0.996078, G: 0.729412, B: 0.678431}, ""},
			{"Menthol", colorful.Color{R: 0.756863, G: 0.976471, B: 0.635294}, ""},
			{"Metallic blue", colorful.Color{R: 0.196078, G: 0.321569, B: 0.482353}, ""},
			{"Metallic bronze", colorful.Color{R: 0.662745, G: 0.443137, B: 0.258824}, ""},
			{"Metallic brown", colorful.Color{R: 0.674510, G: 0.262745, B: 0.074510}, ""},
			{"Metallic gold", colorful.Color{R: 0.827451, G: 0.686275, B: 0.215686}, ""},
			{"Metallic green", colorful.Color{R: 0.160784, G: 0.431373, B: 0.003922}, ""},
			{"Metallic orange", colorful.Color{R: 0.854902, G: 0.407843, B: 0.058824}, ""},
			{"Metallic pink", colorful.Color{R: 0.929412, G: 0.650980, B: 0.768627}, ""},
			{"Metallic red", colorful.Color{R: 0.650980, G: 0.172549, B: 0.168627}, ""},
			{"Metallic Seaweed", colorful.Color{R: 0.039216, G: 0.494118, B: 0.549020}, ""},
			{"Metallic silver", colorful.Color{R: 0.658824, G: 0.662745, B: 0.678431}, ""},
			{"Metallic Sunburst", colorful.Color{R: 0.611765, G: 0.486275, B: 0.219608}, ""},
			{"Metallic violet", colorful.Color{R: 0.356863, G: 0.039216, B: 0.568627}, ""},
			{"Metallic yellow", colorful.Color{R: 0.992157, G: 0.800000, B: 0.050980}, ""},
			{"Mexican pink", colorful.Color{R: 0.894118, G: 0.000000, B: 0.486275}, ""},
			{"Microsoft blue", colorful.Color{R: 0.000000, G: 0.635294, B: 0.929412}, ""},
			{"Microsoft Edge blue", colorful.Color{R: 0.000000, G: 0.470588, B: 0.843137}, ""},
			{"Microsoft green", colorful.Color{R: 0.490196, G: 0.717647, B: 0.000000}, ""},
			{"Microsoft red", colorful.Color{R: 0.941176, G: 0.305882, B: 0.121569}, ""},
			{"Microsoft yellow", colorful.Color{R: 0.992157, G: 0.725490, B: 0.000000}, ""},
			{"Middle blue", colorful.Color{R: 0.494118, G: 0.831373, B: 0.901961}, ""},
			{"Middle blue green", colorful.Color{R: 0.552941, G: 0.850980, B: 0.800000}, ""},
			{"Middle blue purple", colorful.Color{R: 0.545098, G: 0.447059, B: 0.745098}, ""},
			{"Middle grey", colorful.Color{R: 0.545098, G: 0.525490, B: 0.501961}, ""},
			{"Middle green", colorful.Color{R: 0.301961, G: 0.549020, B: 0.341176}, ""},
			{"Middle green yellow", colorful.Color{R: 0.674510, G: 0.749020, B: 0.376471}, ""},
			{"Middle purple", colorful.Color{R: 0.850980, G: 0.509804, B: 0.709804}, ""},
			{"Middle red", colorful.Color{R: 0.898039, G: 0.556863, B: 0.450980}, ""},
			{"Middle red purple", colorful.Color{R: 0.647059, G: 0.325490, B: 0.325490}, ""},
			{"Middle yellow", colorful.Color{R: 1.000000, G: 0.921569, B: 0.000000}, ""},
			{"Middle yellow red", colorful.Color{R: 0.925490, G: 0.694118, B: 0.462745}, ""},
			{"Midnight", colorful.Color{R: 0.439216, G: 0.149020, B: 0.439216}, ""},
			{"Midnight blue", colorful.Color{R: 0.098039, G: 0.098039, B: 0.439216}, ""},
			{"Midnight blue", colorful.Color{R: 0.000000, G: 0.274510, B: 0.549020}, ""},
			{"Midnight green (eagle green)", colorful.Color{R: 0.000000, G: 0.286275, B: 0.325490}, ""},
			{"Mikado yellow", colorful.Color{R: 1.000000, G: 0.768627, B: 0.047059}, ""},
			{"Milk", colorful.Color{R: 0.992157, G: 1.000000, B: 0.960784}, ""},
			{"Milk chocolate", colorful.Color{R: 0.517647, G: 0.337255, B: 0.235294}, ""},
			{"Mimi pink", colorful.Color{R: 1.000000, G: 0.854902, B: 0.913725}, ""},
			{"Mindaro", colorful.Color{R: 0.890196, G: 0.976471, B: 0.533333}, ""},
			{"Ming", colorful.Color{R: 0.211765, G: 0.454902, B: 0.490196}, ""},
			{"Minion yellow", colorful.Color{R: 0.960784, G: 0.878431, B: 0.313725}, ""},
			{"Mint", colorful.Color{R: 0.243137, G: 0.705882, B: 0.537255}, ""},
			{"Mint cream", colorful.Color{R: 0.960784, G: 1.000000, B: 0.980392}, ""},
			{"Mint green", colorful.Color{R: 0.596078, G: 1.000000, B: 0.596078}, ""},
			{"Misty Moss", colorful.Color{R: 0.733333, G: 0.705882, B: 0.466667}, ""},
			{"Misty rose", colorful.Color{R: 1.000000, G: 0.894118, B: 0.882353}, ""},
			{"Moccasin", colorful.Color{R: 0.980392, G: 0.921569, B: 0.843137}, ""},
			{"Mocha", colorful.Color{R: 0.745098, G: 0.643137, B: 0.576471}, ""},
			{"Mode beige", colorful.Color{R: 0.588235, G: 0.443137, B: 0.090196}, ""},
			{"Moonstone", colorful.Color{R: 0.227451, G: 0.658824, B: 0.756863}, ""},
			{"Moonstone blue", colorful.Color{R: 0.450980, G: 0.662745, B: 0.760784}, ""},
			{"Mordant red 19", colorful.Color{R: 0.682353, G: 0.047059, B: 0.000000}, ""},
			{"Morning blue", colorful.Color{R: 0.552941, G: 0.639216, B: 0.600000}, ""},
			{"Moss green", colorful.Color{R: 0.541176, G: 0.603922, B: 0.356863}, ""},
			{"Mountain Meadow", colorful.Color{R: 0.188235, G: 0.729412, B: 0.560784}, ""},
			{"Mountbatten pink", colorful.Color{R: 0.600000, G: 0.478431, B: 0.552941}, ""},
			{"MSU green", colorful.Color{R: 0.094118, G: 0.270588, B: 0.231373}, ""},
			{"Mud", colorful.Color{R: 0.439216, G: 0.329412, B: 0.243137}, ""},
			{"Mughal green", colorful.Color{R: 0.188235, G: 0.376471, B: 0.188235}, ""},
			{"Mulberry", colorful.Color{R: 0.772549, G: 0.294118, B: 0.549020}, ""},
			{"Mulberry (Crayola)", colorful.Color{R: 0.784314, G: 0.313725, B: 0.607843}, ""},
			{"Mummy's Tomb", colorful.Color{R: 0.509804, G: 0.556863, B: 0.517647}, ""},
			{"Mustard", colorful.Color{R: 1.000000, G: 0.858824, B: 0.345098}, ""},
			{"Mustard brown", colorful.Color{R: 0.803922, G: 0.478431, B: 0.000000}, ""},
			{"Mustard green", colorful.Color{R: 0.431373, G: 0.431373, B: 0.188235}, ""},
			{"Mustard yellow", colorful.Color{R: 0.882353, G: 0.678431, B: 0.003922}, ""},
			{"Myrtle green", colorful.Color{R: 0.192157, G: 0.470588, B: 0.450980}, ""},
			{"Mystic", colorful.Color{R: 0.839216, G: 0.321569, B: 0.509804}, ""},
			{"Mystic maroon", colorful.Color{R: 0.678431, G: 0.262745, B: 0.474510}, ""},
			{"Mystic red", colorful.Color{R: 1.000000, G: 0.333333, B: 0.000000}, ""},
			{"Nadeshiko pink", colorful.Color{R: 0.964706, G: 0.678431, B: 0.776471}, ""},
			{"Napier green", colorful.Color{R: 0.164706, G: 0.501961, B: 0.000000}, ""},
			{"Naples yellow", colorful.Color{R: 0.980392, G: 0.854902, B: 0.368627}, ""},
			{"Navajo white", colorful.Color{R: 1.000000, G: 0.870588, B: 0.678431}, ""},
			{"Navy blue", colorful.Color{R: 0.000000, G: 0.000000, B: 0.501961}, ""},
			{"Navy blue (Crayola)", colorful.Color{R: 0.098039, G: 0.454902, B: 0.823529}, ""},
			{"Navy purple", colorful.Color{R: 0.580392, G: 0.341176, B: 0.921569}, ""},
			{"Neon blue", colorful.Color{R: 0.105882, G: 0.011765, B: 0.639216}, ""},
			{"Neon brown", colorful.Color{R: 0.764706, G: 0.450980, B: 0.164706}, ""},
			{"Neon Carrot", colorful.Color{R: 1.000000, G: 0.639216, B: 0.262745}, ""},
			{"Neon cyan", colorful.Color{R: 0.000000, G: 0.996078, B: 0.988235}, ""},
			{"Neon fuchsia", colorful.Color{R: 0.996078, G: 0.254902, B: 0.392157}, ""},
			{"Neon gold", colorful.Color{R: 0.811765, G: 0.666667, B: 0.003922}, ""},
			{"Neon gray", colorful.Color{R: 0.501961, G: 0.501961, B: 0.501961}, ""},
			{"Neon dark green", colorful.Color{R: 0.000000, G: 0.517647, B: 0.262745}, ""},
			{"Neon green", colorful.Color{R: 0.074510, G: 0.607843, B: 0.258824}, ""},
			{"Neon green", colorful.Color{R: 0.223529, G: 1.000000, B: 0.078431}, ""},
			{"Neon pink", colorful.Color{R: 0.996078, G: 0.203922, B: 0.494118}, ""},
			{"Neon purple", colorful.Color{R: 0.580392, G: 0.341176, B: 0.921569}, ""},
			{"Neon red", colorful.Color{R: 1.000000, G: 0.094118, B: 0.094118}, ""},
			{"Neon scarlet", colorful.Color{R: 1.000000, G: 0.149020, B: 0.011765}, ""},
			{"Neon silver", colorful.Color{R: 0.800000, G: 0.800000, B: 0.800000}, ""},
			{"Neon tangerine", colorful.Color{R: 0.964706, G: 0.537255, B: 0.039216}, ""},
			{"Neon yellow", colorful.Color{R: 1.000000, G: 0.968627, B: 0.000000}, ""},
			{"New Car", colorful.Color{R: 0.129412, G: 0.309804, B: 0.776471}, ""},
			{"New York pink", colorful.Color{R: 0.843137, G: 0.513725, B: 0.498039}, ""},
			{"Nickel", colorful.Color{R: 0.447059, G: 0.454902, B: 0.447059}, ""},
			{"Nintendo red", colorful.Color{R: 0.894118, G: 0.000000, B: 0.058824}, ""},
			{"Non-photo blue", colorful.Color{R: 0.643137, G: 0.866667, B: 0.929412}, ""},
			{"North Texas green", colorful.Color{R: 0.019608, G: 0.564706, B: 0.200000}, ""},
			{"Nyanza", colorful.Color{R: 0.913725, G: 1.000000, B: 0.858824}, ""},
			{"Ocean blue", colorful.Color{R: 0.309804, G: 0.258824, B: 0.709804}, ""},
			{"Ocean boat blue", colorful.Color{R: 0.000000, G: 0.466667, B: 0.745098}, ""},
			{"Ocean green", colorful.Color{R: 0.282353, G: 0.749020, B: 0.568627}, ""},
			{"Ochre", colorful.Color{R: 0.800000, G: 0.466667, B: 0.133333}, ""},
			{"Office green", colorful.Color{R: 0.000000, G: 0.501961, B: 0.000000}, ""},
			{"Ogre Odor", colorful.Color{R: 0.992157, G: 0.321569, B: 0.250980}, ""},
			{"Old burgundy", colorful.Color{R: 0.262745, G: 0.188235, B: 0.180392}, ""},
			{"Old gold", colorful.Color{R: 0.811765, G: 0.709804, B: 0.231373}, ""},
			{"Old heliotrope", colorful.Color{R: 0.337255, G: 0.235294, B: 0.360784}, ""},
			{"Old lace", colorful.Color{R: 0.992157, G: 0.960784, B: 0.901961}, ""},
			{"Old lavender", colorful.Color{R: 0.474510, G: 0.407843, B: 0.470588}, ""},
			{"Old mauve", colorful.Color{R: 0.403922, G: 0.192157, B: 0.278431}, ""},
			{"Old moss green", colorful.Color{R: 0.525490, G: 0.494118, B: 0.211765}, ""},
			{"Old rose", colorful.Color{R: 0.752941, G: 0.501961, B: 0.505882}, ""},
			{"Old silver", colorful.Color{R: 0.517647, G: 0.517647, B: 0.509804}, ""},
			{"Olive", colorful.Color{R: 0.501961, G: 0.501961, B: 0.000000}, ""},
			{"Olive drab (#3)", colorful.Color{R: 0.419608, G: 0.556863, B: 0.137255}, ""},
			{"Olive drab #7", colorful.Color{R: 0.235294, G: 0.203922, B: 0.121569}, ""},
			{"Olive green", colorful.Color{R: 0.709804, G: 0.701961, B: 0.360784}, ""},
			{"Olivine", colorful.Color{R: 0.603922, G: 0.725490, B: 0.450980}, ""},
			{"Onyx", colorful.Color{R: 0.207843, G: 0.219608, B: 0.223529}, ""},
			{"Opal", colorful.Color{R: 0.658824, G: 0.764706, B: 0.737255}, ""},
			{"Opera mauve", colorful.Color{R: 0.717647, G: 0.517647, B: 0.654902}, ""},
			{"Orange", colorful.Color{R: 1.000000, G: 0.400000, B: 0.000000}, ""},
			{"Orange (color wheel)", colorful.Color{R: 1.000000, G: 0.498039, B: 0.000000}, ""},
			{"Orange (Crayola)", colorful.Color{R: 1.000000, G: 0.458824, B: 0.219608}, ""},
			{"Orange (Pantone)", colorful.Color{R: 1.000000, G: 0.345098, B: 0.000000}, ""},
			{"Orange (RYB)", colorful.Color{R: 0.984314, G: 0.600000, B: 0.007843}, ""},
			{"Orange (web)", colorful.Color{R: 1.000000, G: 0.647059, B: 0.000000}, ""},
			{"Orange iced tea", colorful.Color{R: 1.000000, G: 0.403922, B: 0.000000}, ""},
			{"Orange peel", colorful.Color{R: 1.000000, G: 0.623529, B: 0.000000}, ""},
			{"Orange-red", colorful.Color{R: 1.000000, G: 0.407843, B: 0.121569}, ""},
			{"Orange-red (Crayola)", colorful.Color{R: 1.000000, G: 0.325490, B: 0.286275}, ""},
			{"Orange soda", colorful.Color{R: 0.905882, G: 0.305882, B: 0.078431}, ""},
			{"Orange Soda", colorful.Color{R: 0.980392, G: 0.356863, B: 0.239216}, ""},
			{"Orange-yellow", colorful.Color{R: 0.960784, G: 0.741176, B: 0.121569}, ""},
			{"Orange-yellow (Crayola)", colorful.Color{R: 0.972549, G: 0.835294, B: 0.407843}, ""},
			{"Orchid", colorful.Color{R: 0.854902, G: 0.439216, B: 0.839216}, ""},
			{"Orchid pink", colorful.Color{R: 0.949020, G: 0.741176, B: 0.803922}, ""},
			{"Orchid (Crayola)", colorful.Color{R: 0.886275, G: 0.611765, B: 0.823529}, ""},
			{"Orioles orange", colorful.Color{R: 0.984314, G: 0.309804, B: 0.078431}, ""},
			{"Otter brown", colorful.Color{R: 0.396078, G: 0.262745, B: 0.129412}, ""},
			{"Outer Space", colorful.Color{R: 0.254902, G: 0.290196, B: 0.298039}, ""},
			{"Outer space (Crayola)", colorful.Color{R: 0.176471, G: 0.219608, B: 0.227451}, ""},
			{"Outrageous Orange", colorful.Color{R: 1.000000, G: 0.431373, B: 0.290196}, ""},
			{"Oxblood", colorful.Color{R: 0.501961, G: 0.000000, B: 0.125490}, ""},
			{"Oxford blue", colorful.Color{R: 0.000000, G: 0.129412, B: 0.278431}, ""},
			{"Oxley", colorful.Color{R: 0.427451, G: 0.603922, B: 0.474510}, ""},
			{"OU Crimson red", colorful.Color{R: 0.600000, G: 0.000000, B: 0.000000}, ""},
			{"Pacific Blue", colorful.Color{R: 0.109804, G: 0.662745, B: 0.788235}, ""},
			{"Pakistan green", colorful.Color{R: 0.000000, G: 0.400000, B: 0.000000}, ""},
			{"Palatinate blue", colorful.Color{R: 0.152941, G: 0.231373, B: 0.886275}, ""},
			{"Palatinate purple", colorful.Color{R: 0.407843, G: 0.156863, B: 0.376471}, ""},
			{"Pale aqua", colorful.Color{R: 0.737255, G: 0.831373, B: 0.901961}, ""},
			{"Pale blue", colorful.Color{R: 0.686275, G: 0.933333, B: 0.933333}, ""},
			{"Pale brown", colorful.Color{R: 0.596078, G: 0.462745, B: 0.329412}, ""},
			{"Pale carmine", colorful.Color{R: 0.686275, G: 0.250980, B: 0.207843}, ""},
			{"Pale cerulean", colorful.Color{R: 0.607843, G: 0.768627, B: 0.886275}, ""},
			{"Pale chestnut", colorful.Color{R: 0.866667, G: 0.678431, B: 0.686275}, ""},
			{"Pale copper", colorful.Color{R: 0.854902, G: 0.541176, B: 0.403922}, ""},
			{"Pale cornflower blue", colorful.Color{R: 0.670588, G: 0.803922, B: 0.937255}, ""},
			{"Pale cyan", colorful.Color{R: 0.529412, G: 0.827451, B: 0.972549}, ""},
			{"Pale gold", colorful.Color{R: 0.901961, G: 0.745098, B: 0.541176}, ""},
			{"Pale goldenrod", colorful.Color{R: 0.933333, G: 0.909804, B: 0.666667}, ""},
			{"Pale green", colorful.Color{R: 0.596078, G: 0.984314, B: 0.596078}, ""},
			{"Pale lavender", colorful.Color{R: 0.862745, G: 0.815686, B: 1.000000}, ""},
			{"Pale magenta", colorful.Color{R: 0.976471, G: 0.517647, B: 0.898039}, ""},
			{"Pale magenta-pink", colorful.Color{R: 1.000000, G: 0.600000, B: 0.800000}, ""},
			{"Pale pink", colorful.Color{R: 0.980392, G: 0.854902, B: 0.866667}, ""},
			{"Pale plum", colorful.Color{R: 0.866667, G: 0.627451, B: 0.866667}, ""},
			{"Pale red-violet", colorful.Color{R: 0.858824, G: 0.439216, B: 0.576471}, ""},
			{"Pale robin egg blue", colorful.Color{R: 0.588235, G: 0.870588, B: 0.819608}, ""},
			{"Pale silver", colorful.Color{R: 0.788235, G: 0.752941, B: 0.733333}, ""},
			{"Pale spring bud", colorful.Color{R: 0.925490, G: 0.921569, B: 0.741176}, ""},
			{"Pale taupe", colorful.Color{R: 0.737255, G: 0.596078, B: 0.494118}, ""},
			{"Pale turquoise", colorful.Color{R: 0.686275, G: 0.933333, B: 0.933333}, ""},
			{"Pale violet", colorful.Color{R: 0.800000, G: 0.600000, B: 1.000000}, ""},
			{"Pale violet-red", colorful.Color{R: 0.858824, G: 0.439216, B: 0.576471}, ""},
			{"Palm Leaf", colorful.Color{R: 0.435294, G: 0.600000, B: 0.250980}, ""},
			{"Pansy purple", colorful.Color{R: 0.470588, G: 0.094118, B: 0.290196}, ""},
			{"Paolo Veronese green", colorful.Color{R: 0.000000, G: 0.607843, B: 0.490196}, ""},
			{"Papaya whip", colorful.Color{R: 1.000000, G: 0.937255, B: 0.835294}, ""},
			{"Paradise pink", colorful.Color{R: 0.901961, G: 0.243137, B: 0.384314}, ""},
			{"Paris Green", colorful.Color{R: 0.313725, G: 0.784314, B: 0.470588}, ""},
			{"Parrot Pink", colorful.Color{R: 0.850980, G: 0.596078, B: 0.627451}, ""},
			{"Pastel blue", colorful.Color{R: 0.682353, G: 0.776471, B: 0.811765}, ""},
			{"Pastel brown", colorful.Color{R: 0.513725, G: 0.411765, B: 0.325490}, ""},
			{"Pastel gray", colorful.Color{R: 0.811765, G: 0.811765, B: 0.768627}, ""},
			{"Pastel green", colorful.Color{R: 0.466667, G: 0.866667, B: 0.466667}, ""},
			{"Pastel magenta", colorful.Color{R: 0.956863, G: 0.603922, B: 0.760784}, ""},
			{"Pastel orange", colorful.Color{R: 1.000000, G: 0.701961, B: 0.278431}, ""},
			{"Pastel pink", colorful.Color{R: 0.870588, G: 0.647059, B: 0.643137}, ""},
			{"Pastel purple", colorful.Color{R: 0.701961, G: 0.619608, B: 0.709804}, ""},
			{"Pastel red", colorful.Color{R: 1.000000, G: 0.411765, B: 0.380392}, ""},
			{"Pastel violet", colorful.Color{R: 0.796078, G: 0.600000, B: 0.788235}, ""},
			{"Pastel yellow", colorful.Color{R: 0.992157, G: 0.992157, B: 0.588235}, ""},
			{"Patriarch", colorful.Color{R: 0.501961, G: 0.000000, B: 0.501961}, ""},
			{"Payne's grey", colorful.Color{R: 0.325490, G: 0.407843, B: 0.470588}, ""},
			{"Peach", colorful.Color{R: 1.000000, G: 0.898039, B: 0.705882}, ""},
			{"Peach", colorful.Color{R: 1.000000, G: 0.796078, B: 0.643137}, ""},
			{"Peach-orange", colorful.Color{R: 1.000000, G: 0.800000, B: 0.600000}, ""},
			{"Peach puff", colorful.Color{R: 1.000000, G: 0.854902, B: 0.725490}, ""},
			{"Peach-yellow", colorful.Color{R: 0.980392, G: 0.874510, B: 0.678431}, ""},
			{"Pear", colorful.Color{R: 0.819608, G: 0.886275, B: 0.192157}, ""},
			{"Pearl", colorful.Color{R: 0.917647, G: 0.878431, B: 0.784314}, ""},
			{"Pearl Aqua", colorful.Color{R: 0.533333, G: 0.847059, B: 0.752941}, ""},
			{"Pearly purple", colorful.Color{R: 0.717647, G: 0.407843, B: 0.635294}, ""},
			{"Peridot", colorful.Color{R: 0.901961, G: 0.886275, B: 0.000000}, ""},
			{"Periwinkle", colorful.Color{R: 0.800000, G: 0.800000, B: 1.000000}, ""},
			{"Periwinkle (Crayola)", colorful.Color{R: 0.764706, G: 0.803922, B: 0.901961}, ""},
			{"Permanent Geranium Lake", colorful.Color{R: 0.882353, G: 0.172549, B: 0.172549}, ""},
			{"Persian blue", colorful.Color{R: 0.109804, G: 0.223529, B: 0.733333}, ""},
			{"Persian green", colorful.Color{R: 0.000000, G: 0.650980, B: 0.576471}, ""},
			{"Persian indigo", colorful.Color{R: 0.196078, G: 0.070588, B: 0.478431}, ""},
			{"Persian orange", colorful.Color{R: 0.850980, G: 0.564706, B: 0.345098}, ""},
			{"Persian pink", colorful.Color{R: 0.968627, G: 0.498039, B: 0.745098}, ""},
			{"Persian plum", colorful.Color{R: 0.439216, G: 0.109804, B: 0.109804}, ""},
			{"Persian red", colorful.Color{R: 0.800000, G: 0.200000, B: 0.200000}, ""},
			{"Persian rose", colorful.Color{R: 0.996078, G: 0.156863, B: 0.635294}, ""},
			{"Persimmon", colorful.Color{R: 0.925490, G: 0.345098, B: 0.000000}, ""},
			{"Peru", colorful.Color{R: 0.803922, G: 0.521569, B: 0.247059}, ""},
			{"Pewter Blue", colorful.Color{R: 0.545098, G: 0.658824, B: 0.717647}, ""},
			{"Philippine blue", colorful.Color{R: 0.000000, G: 0.219608, B: 0.654902}, ""},
			{"Philippine bronze", colorful.Color{R: 0.431373, G: 0.227451, B: 0.027451}, ""},
			{"Philippine brown", colorful.Color{R: 0.364706, G: 0.098039, B: 0.086275}, ""},
			{"Philippine gold", colorful.Color{R: 0.694118, G: 0.450980, B: 0.015686}, ""},
			{"Philippine golden yellow", colorful.Color{R: 1.000000, G: 0.874510, B: 0.000000}, ""},
			{"Philippine gray", colorful.Color{R: 0.549020, G: 0.549020, B: 0.549020}, ""},
			{"Philippine green", colorful.Color{R: 0.000000, G: 0.521569, B: 0.262745}, ""},
			{"Philippine indigo", colorful.Color{R: 0.000000, G: 0.254902, B: 0.415686}, ""},
			{"Philippine orange", colorful.Color{R: 1.000000, G: 0.450980, B: 0.000000}, ""},
			{"Philippine pink", colorful.Color{R: 0.980392, G: 0.101961, B: 0.556863}, ""},
			{"Philippine red", colorful.Color{R: 0.807843, G: 0.066667, B: 0.152941}, ""},
			{"Philippine silver", colorful.Color{R: 0.701961, G: 0.701961, B: 0.701961}, ""},
			{"Philippine sky blue", colorful.Color{R: 0.000000, G: 0.400000, B: 1.000000}, ""},
			{"Philippine violet", colorful.Color{R: 0.505882, G: 0.000000, B: 0.498039}, ""},
			{"Philippine yellow", colorful.Color{R: 0.996078, G: 0.796078, B: 0.000000}, ""},
			{"Phlox", colorful.Color{R: 0.874510, G: 0.000000, B: 1.000000}, ""},
			{"Phthalo blue", colorful.Color{R: 0.000000, G: 0.058824, B: 0.537255}, ""},
			{"Phthalo green", colorful.Color{R: 0.070588, G: 0.207843, B: 0.141176}, ""},
			{"Picton blue", colorful.Color{R: 0.270588, G: 0.694118, B: 0.909804}, ""},
			{"Pictorial carmine", colorful.Color{R: 0.764706, G: 0.043137, B: 0.305882}, ""},
			{"Piggy pink", colorful.Color{R: 0.992157, G: 0.866667, B: 0.901961}, ""},
			{"Pine green", colorful.Color{R: 0.003922, G: 0.474510, B: 0.435294}, ""},
			{"Pine tree", colorful.Color{R: 0.164706, G: 0.184314, B: 0.137255}, ""},
			{"Pineapple", colorful.Color{R: 0.337255, G: 0.235294, B: 0.050980}, ""},
			{"Pink", colorful.Color{R: 1.000000, G: 0.752941, B: 0.796078}, ""},
			{"Pink (Pantone)", colorful.Color{R: 0.843137, G: 0.282353, B: 0.580392}, ""},
			{"Pink Diamond (Ace Hardware Color)", colorful.Color{R: 0.964706, G: 0.839216, B: 0.870588}, ""},
			{"Pink Diamond (Independent Retailers Colors)", colorful.Color{R: 0.941176, G: 0.827451, B: 0.862745}, ""},
			{"Pink flamingo", colorful.Color{R: 0.988235, G: 0.454902, B: 0.992157}, ""},
			{"Pink lace", colorful.Color{R: 1.000000, G: 0.866667, B: 0.956863}, ""},
			{"Pink lavender", colorful.Color{R: 0.847059, G: 0.698039, B: 0.819608}, ""},
			{"Pink-orange", colorful.Color{R: 1.000000, G: 0.600000, B: 0.400000}, ""},
			{"Pink pearl", colorful.Color{R: 0.905882, G: 0.674510, B: 0.811765}, ""},
			{"Pink raspberry", colorful.Color{R: 0.596078, G: 0.000000, B: 0.211765}, ""},
			{"Pink Sherbet", colorful.Color{R: 0.968627, G: 0.560784, B: 0.654902}, ""},
			{"Pistachio", colorful.Color{R: 0.576471, G: 0.772549, B: 0.447059}, ""},
			{"Pixie Powder", colorful.Color{R: 0.223529, G: 0.070588, B: 0.521569}, ""},
			{"Platinum", colorful.Color{R: 0.898039, G: 0.894118, B: 0.886275}, ""},
			{"Plum", colorful.Color{R: 0.556863, G: 0.270588, B: 0.521569}, ""},
			{"Plum (web)", colorful.Color{R: 0.866667, G: 0.627451, B: 0.866667}, ""},
			{"Plump Purple", colorful.Color{R: 0.349020, G: 0.274510, B: 0.698039}, ""},
			{"Police blue", colorful.Color{R: 0.215686, G: 0.309804, B: 0.419608}, ""},
			{"Polished Pine", colorful.Color{R: 0.364706, G: 0.643137, B: 0.576471}, ""},
			{"Pomp and Power", colorful.Color{R: 0.525490, G: 0.376471, B: 0.556863}, ""},
			{"Popstar", colorful.Color{R: 0.745098, G: 0.309804, B: 0.384314}, ""},
			{"Portland Orange", colorful.Color{R: 1.000000, G: 0.352941, B: 0.211765}, ""},
			{"Powder blue", colorful.Color{R: 0.690196, G: 0.878431, B: 0.901961}, ""},
			{"Prilly blue", colorful.Color{R: 0.196078, G: 0.611765, B: 0.764706}, ""},
			{"Prilly pink", colorful.Color{R: 1.000000, G: 0.250980, B: 0.627451}, ""},
			{"Prilly red", colorful.Color{R: 1.000000, G: 0.000000, B: 0.250980}, ""},
			{"Princess Perfume", colorful.Color{R: 1.000000, G: 0.521569, B: 0.811765}, ""},
			{"Princeton orange", colorful.Color{R: 0.960784, G: 0.501961, B: 0.145098}, ""},
			{"Prune", colorful.Color{R: 0.439216, G: 0.109804, B: 0.109804}, ""},
			{"Prussian blue", colorful.Color{R: 0.000000, G: 0.192157, B: 0.325490}, ""},
			{"Psychedelic purple", colorful.Color{R: 0.874510, G: 0.000000, B: 1.000000}, ""},
			{"Puce", colorful.Color{R: 0.800000, G: 0.533333, B: 0.600000}, ""},
			{"Puce red", colorful.Color{R: 0.447059, G: 0.184314, B: 0.215686}, ""},
			{"Pullman Brown (UPS Brown)", colorful.Color{R: 0.392157, G: 0.254902, B: 0.090196}, ""},
			{"Pullman Green", colorful.Color{R: 0.231373, G: 0.200000, B: 0.109804}, ""},
			{"Pumpkin", colorful.Color{R: 1.000000, G: 0.458824, B: 0.094118}, ""},
			{"Purple (HTML)", colorful.Color{R: 0.501961, G: 0.000000, B: 0.501961}, ""},
			{"Purple (Munsell)", colorful.Color{R: 0.623529, G: 0.000000, B: 0.772549}, ""},
			{"Purple (X11)", colorful.Color{R: 0.627451, G: 0.125490, B: 0.941176}, ""},
			{"Purple Heart", colorful.Color{R: 0.411765, G: 0.207843, B: 0.611765}, ""},
			{"Purple mountain majesty", colorful.Color{R: 0.588235, G: 0.470588, B: 0.713725}, ""},
			{"Purple navy", colorful.Color{R: 0.305882, G: 0.317647, B: 0.501961}, ""},
			{"Purple pizzazz", colorful.Color{R: 0.996078, G: 0.305882, B: 0.854902}, ""},
			{"Purple Plum", colorful.Color{R: 0.611765, G: 0.317647, B: 0.713725}, ""},
			{"Purple taupe", colorful.Color{R: 0.313725, G: 0.250980, B: 0.301961}, ""},
			{"Purpureus", colorful.Color{R: 0.603922, G: 0.305882, B: 0.682353}, ""},
			{"Quartz", colorful.Color{R: 0.317647, G: 0.282353, B: 0.309804}, ""},
			{"Queen blue", colorful.Color{R: 0.262745, G: 0.419608, B: 0.584314}, ""},
			{"Queen pink", colorful.Color{R: 0.909804, G: 0.800000, B: 0.843137}, ""},
			{"Quick Silver", colorful.Color{R: 0.650980, G: 0.650980, B: 0.650980}, ""},
			{"Quinacridone magenta", colorful.Color{R: 0.556863, G: 0.227451, B: 0.349020}, ""},
			{"Quincy", colorful.Color{R: 0.415686, G: 0.329412, B: 0.270588}, ""},
			{"Rackley", colorful.Color{R: 0.364706, G: 0.541176, B: 0.658824}, ""},
			{"Radical Red", colorful.Color{R: 1.000000, G: 0.207843, B: 0.368627}, ""},
			{"Raisin black", colorful.Color{R: 0.141176, G: 0.129412, B: 0.141176}, ""},
			{"Rajah", colorful.Color{R: 0.984314, G: 0.670588, B: 0.376471}, ""},
			{"Raspberry", colorful.Color{R: 0.890196, G: 0.043137, B: 0.364706}, ""},
			{"Raspberry glace", colorful.Color{R: 0.568627, G: 0.372549, B: 0.427451}, ""},
			{"Raspberry pink", colorful.Color{R: 0.886275, G: 0.313725, B: 0.596078}, ""},
			{"Raspberry rose", colorful.Color{R: 0.701961, G: 0.266667, B: 0.423529}, ""},
			{"Raw Sienna", colorful.Color{R: 0.839216, G: 0.541176, B: 0.349020}, ""},
			{"Raw umber", colorful.Color{R: 0.509804, G: 0.400000, B: 0.266667}, ""},
			{"Razzle dazzle rose", colorful.Color{R: 1.000000, G: 0.200000, B: 0.800000}, ""},
			{"Razzmatazz", colorful.Color{R: 0.890196, G: 0.145098, B: 0.419608}, ""},
			{"Razzmic Berry", colorful.Color{R: 0.552941, G: 0.305882, B: 0.521569}, ""},
			{"Rebecca Purple", colorful.Color{R: 0.400000, G: 0.200000, B: 0.600000}, ""},
			{"Red", colorful.Color{R: 1.000000, G: 0.000000, B: 0.000000}, ""},
			{"Red (Crayola)", colorful.Color{R: 0.933333, G: 0.125490, B: 0.301961}, ""},
			{"Red (Munsell)", colorful.Color{R: 0.949020, G: 0.000000, B: 0.235294}, ""},
			{"Red (NCS)", colorful.Color{R: 0.768627, G: 0.007843, B: 0.200000}, ""},
			{"Red (Pantone)", colorful.Color{R: 0.929412, G: 0.160784, B: 0.223529}, ""},
			{"Red (pigment)", colorful.Color{R: 0.929412, G: 0.109804, B: 0.141176}, ""},
			{"Red (RYB)", colorful.Color{R: 0.996078, G: 0.152941, B: 0.070588}, ""},
			{"Red-brown", colorful.Color{R: 0.647059, G: 0.164706, B: 0.164706}, ""},
			{"Red cola", colorful.Color{R: 0.874510, G: 0.003922, B: 0.094118}, ""},
			{"Red devil", colorful.Color{R: 0.525490, G: 0.003922, B: 0.066667}, ""},
			{"Red-orange", colorful.Color{R: 1.000000, G: 0.325490, B: 0.286275}, ""},
			{"Red-orange (Crayola)", colorful.Color{R: 1.000000, G: 0.407843, B: 0.121569}, ""},
			{"Red-orange (Color wheel)", colorful.Color{R: 1.000000, G: 0.270588, B: 0.000000}, ""},
			{"Red-purple", colorful.Color{R: 0.894118, G: 0.000000, B: 0.470588}, ""},
			{"Red rum", colorful.Color{R: 0.592157, G: 0.227451, B: 0.290196}, ""},
			{"Red Salsa", colorful.Color{R: 0.992157, G: 0.227451, B: 0.290196}, ""},
			{"Red strawberry", colorful.Color{R: 0.925490, G: 0.011765, B: 0.015686}, ""},
			{"Red-violet", colorful.Color{R: 0.780392, G: 0.082353, B: 0.521569}, ""},
			{"Red-violet (Crayola)", colorful.Color{R: 0.752941, G: 0.266667, B: 0.560784}, ""},
			{"Red-violet (Color wheel)", colorful.Color{R: 0.572549, G: 0.168627, B: 0.243137}, ""},
			{"Redwood", colorful.Color{R: 0.643137, G: 0.352941, B: 0.321569}, ""},
			{"Regalia", colorful.Color{R: 0.321569, G: 0.176471, B: 0.501961}, ""},
			{"Registration black", colorful.Color{R: 0.000000, G: 0.000000, B: 0.000000}, ""},
			{"Resolution blue", colorful.Color{R: 0.000000, G: 0.137255, B: 0.529412}, ""},
			{"Rhythm", colorful.Color{R: 0.466667, G: 0.462745, B: 0.588235}, ""},
			{"Rich black", colorful.Color{R: 0.000000, G: 0.250980, B: 0.250980}, ""},
			{"Rich black (FOGRA29)", colorful.Color{R: 0.003922, G: 0.043137, B: 0.074510}, ""},
			{"Rich black (FOGRA39)", colorful.Color{R: 0.003922, G: 0.007843, B: 0.011765}, ""},
			{"Rich brilliant lavender", colorful.Color{R: 0.945098, G: 0.654902, B: 0.996078}, ""},
			{"Rich carmine", colorful.Color{R: 0.843137, G: 0.000000, B: 0.250980}, ""},
			{"Rich electric blue", colorful.Color{R: 0.031373, G: 0.572549, B: 0.815686}, ""},
			{"Rich lavender", colorful.Color{R: 0.654902, G: 0.419608, B: 0.811765}, ""},
			{"Rich lilac", colorful.Color{R: 0.713725, G: 0.400000, B: 0.823529}, ""},
			{"Rich maroon", colorful.Color{R: 0.690196, G: 0.188235, B: 0.376471}, ""},
			{"Rifle green", colorful.Color{R: 0.266667, G: 0.298039, B: 0.219608}, ""},
			{"Ripe mango", colorful.Color{R: 1.000000, G: 0.764706, B: 0.141176}, ""},
			{"Roast coffee", colorful.Color{R: 0.439216, G: 0.258824, B: 0.254902}, ""},
			{"Robin egg blue", colorful.Color{R: 0.000000, G: 0.800000, B: 0.800000}, ""},
			{"Rocket metallic", colorful.Color{R: 0.541176, G: 0.498039, B: 0.501961}, ""},
			{"Roman silver", colorful.Color{R: 0.513725, G: 0.537255, B: 0.588235}, ""},
			{"Root beer", colorful.Color{R: 0.160784, G: 0.054902, B: 0.019608}, ""},
			{"Rose", colorful.Color{R: 1.000000, G: 0.000000, B: 0.498039}, ""},
			{"Rose bonbon", colorful.Color{R: 0.976471, G: 0.258824, B: 0.619608}, ""},
			{"Rose Dust", colorful.Color{R: 0.619608, G: 0.368627, B: 0.435294}, ""},
			{"Rose ebony", colorful.Color{R: 0.403922, G: 0.282353, B: 0.274510}, ""},
			{"Rose garnet", colorful.Color{R: 0.588235, G: 0.003922, B: 0.270588}, ""},
			{"Rose gold", colorful.Color{R: 0.717647, G: 0.431373, B: 0.474510}, ""},
			{"Rose madder", colorful.Color{R: 0.890196, G: 0.149020, B: 0.211765}, ""},
			{"Rose pink", colorful.Color{R: 1.000000, G: 0.400000, B: 0.800000}, ""},
			{"Rose quartz", colorful.Color{R: 0.666667, G: 0.596078, B: 0.662745}, ""},
			{"Rose quartz pink", colorful.Color{R: 0.741176, G: 0.333333, B: 0.611765}, ""},
			{"Rose red", colorful.Color{R: 0.760784, G: 0.117647, B: 0.337255}, ""},
			{"Rose taupe", colorful.Color{R: 0.564706, G: 0.364706, B: 0.364706}, ""},
			{"Rose vale", colorful.Color{R: 0.670588, G: 0.305882, B: 0.321569}, ""},
			{"Rosewood", colorful.Color{R: 0.396078, G: 0.000000, B: 0.043137}, ""},
			{"Rosso corsa", colorful.Color{R: 0.831373, G: 0.000000, B: 0.000000}, ""},
			{"Rosy brown", colorful.Color{R: 0.737255, G: 0.560784, B: 0.560784}, ""},
			{"Royal azure", colorful.Color{R: 0.000000, G: 0.219608, B: 0.658824}, ""},
			{"Royal blue", colorful.Color{R: 0.000000, G: 0.137255, B: 0.400000}, ""},
			{"Royal blue", colorful.Color{R: 0.254902, G: 0.411765, B: 0.882353}, ""},
			{"Royal brown", colorful.Color{R: 0.321569, G: 0.231373, B: 0.207843}, ""},
			{"Royal fuchsia", colorful.Color{R: 0.792157, G: 0.172549, B: 0.572549}, ""},
			{"Royal green", colorful.Color{R: 0.074510, G: 0.384314, B: 0.027451}, ""},
			{"Royal orange", colorful.Color{R: 0.976471, G: 0.572549, B: 0.270588}, ""},
			{"Royal pink", colorful.Color{R: 0.905882, G: 0.219608, B: 0.584314}, ""},
			{"Royal red", colorful.Color{R: 0.607843, G: 0.109804, B: 0.192157}, ""},
			{"Royal red", colorful.Color{R: 0.815686, G: 0.000000, B: 0.376471}, ""},
			{"Royal purple", colorful.Color{R: 0.470588, G: 0.317647, B: 0.662745}, ""},
			{"Royal yellow", colorful.Color{R: 0.980392, G: 0.854902, B: 0.368627}, ""},
			{"Ruber", colorful.Color{R: 0.807843, G: 0.274510, B: 0.462745}, ""},
			{"Rubine red", colorful.Color{R: 0.819608, G: 0.000000, B: 0.337255}, ""},
			{"Ruby", colorful.Color{R: 0.878431, G: 0.066667, B: 0.372549}, ""},
			{"Ruby red", colorful.Color{R: 0.607843, G: 0.066667, B: 0.117647}, ""},
			{"Ruddy", colorful.Color{R: 1.000000, G: 0.000000, B: 0.156863}, ""},
			{"Ruddy brown", colorful.Color{R: 0.733333, G: 0.396078, B: 0.156863}, ""},
			{"Ruddy pink", colorful.Color{R: 0.882353, G: 0.556863, B: 0.588235}, ""},
			{"Rufous", colorful.Color{R: 0.658824, G: 0.109804, B: 0.027451}, ""},
			{"Rum", colorful.Color{R: 0.603922, G: 0.305882, B: 0.250980}, ""},
			{"Russet", colorful.Color{R: 0.501961, G: 0.274510, B: 0.105882}, ""},
			{"Russian green", colorful.Color{R: 0.403922, G: 0.572549, B: 0.403922}, ""},
			{"Russian violet", colorful.Color{R: 0.196078, G: 0.090196, B: 0.301961}, ""},
			{"Rust", colorful.Color{R: 0.717647, G: 0.254902, B: 0.054902}, ""},
			{"Rusty red", colorful.Color{R: 0.854902, G: 0.172549, B: 0.262745}, ""},
			{"Sacramento State green", colorful.Color{R: 0.015686, G: 0.223529, B: 0.152941}, ""},
			{"Saddle brown", colorful.Color{R: 0.545098, G: 0.270588, B: 0.074510}, ""},
			{"Safety orange", colorful.Color{R: 1.000000, G: 0.470588, B: 0.000000}, ""},
			{"Safety orange (blaze orange)", colorful.Color{R: 1.000000, G: 0.403922, B: 0.000000}, ""},
			{"Safety yellow", colorful.Color{R: 0.933333, G: 0.823529, B: 0.007843}, ""},
			{"Saffron", colorful.Color{R: 0.956863, G: 0.768627, B: 0.188235}, ""},
			{"Sage", colorful.Color{R: 0.737255, G: 0.721569, B: 0.541176}, ""},
			{"St. Patrick's blue", colorful.Color{R: 0.137255, G: 0.160784, B: 0.478431}, ""},
			{"Salem", colorful.Color{R: 0.090196, G: 0.482353, B: 0.301961}, ""},
			{"Salmon", colorful.Color{R: 0.980392, G: 0.501961, B: 0.447059}, ""},
			{"Salmon Rose", colorful.Color{R: 0.905882, G: 0.588235, B: 0.545098}, ""},
			{"Salmon pink", colorful.Color{R: 1.000000, G: 0.568627, B: 0.643137}, ""},
			{"Samsung blue", colorful.Color{R: 0.070588, G: 0.152941, B: 0.619608}, ""},
			{"Sand", colorful.Color{R: 0.760784, G: 0.698039, B: 0.501961}, ""},
			{"Sand dune", colorful.Color{R: 0.588235, G: 0.443137, B: 0.090196}, ""},
			{"Sandstorm", colorful.Color{R: 0.925490, G: 0.835294, B: 0.250980}, ""},
			{"Sandy brown", colorful.Color{R: 0.956863, G: 0.643137, B: 0.376471}, ""},
			{"Sandy Tan", colorful.Color{R: 0.992157, G: 0.850980, B: 0.709804}, ""},
			{"Sandy taupe", colorful.Color{R: 0.588235, G: 0.443137, B: 0.090196}, ""},
			{"Sangria", colorful.Color{R: 0.572549, G: 0.000000, B: 0.039216}, ""},
			{"Sap green", colorful.Color{R: 0.313725, G: 0.490196, B: 0.164706}, ""},
			{"Sapphire", colorful.Color{R: 0.058824, G: 0.321569, B: 0.729412}, ""},
			{"Sapphire blue", colorful.Color{R: 0.000000, G: 0.403922, B: 0.647059}, ""},
			{"Sasquatch Socks", colorful.Color{R: 1.000000, G: 0.274510, B: 0.505882}, ""},
			{"Satin sheen gold", colorful.Color{R: 0.796078, G: 0.631373, B: 0.207843}, ""},
			{"Scarlet", colorful.Color{R: 1.000000, G: 0.141176, B: 0.000000}, ""},
			{"Scarlet", colorful.Color{R: 0.992157, G: 0.054902, B: 0.207843}, ""},
			{"Schauss pink", colorful.Color{R: 1.000000, G: 0.568627, B: 0.686275}, ""},
			{"School bus yellow", colorful.Color{R: 1.000000, G: 0.847059, B: 0.000000}, ""},
			{"Screamin' Green", colorful.Color{R: 0.400000, G: 1.000000, B: 0.400000}, ""},
			{"Sea blue", colorful.Color{R: 0.000000, G: 0.411765, B: 0.580392}, ""},
			{"Sea Foam Green", colorful.Color{R: 0.623529, G: 0.886275, B: 0.749020}, ""},
			{"Sea green", colorful.Color{R: 0.180392, G: 0.545098, B: 0.341176}, ""},
			{"Sea green (Crayola)", colorful.Color{R: 0.000000, G: 1.000000, B: 0.803922}, ""},
			{"Sea Serpent", colorful.Color{R: 0.294118, G: 0.780392, B: 0.811765}, ""},
			{"Seal brown", colorful.Color{R: 0.349020, G: 0.149020, B: 0.043137}, ""},
			{"Seashell", colorful.Color{R: 1.000000, G: 0.960784, B: 0.933333}, ""},
			{"Selective yellow", colorful.Color{R: 1.000000, G: 0.729412, B: 0.000000}, ""},
			{"Sepia", colorful.Color{R: 0.439216, G: 0.258824, B: 0.078431}, ""},
			{"Shadow", colorful.Color{R: 0.541176, G: 0.474510, B: 0.364706}, ""},
			{"Shadow blue", colorful.Color{R: 0.466667, G: 0.545098, B: 0.647059}, ""},
			{"Shampoo", colorful.Color{R: 1.000000, G: 0.811765, B: 0.945098}, ""},
			{"Shamrock green", colorful.Color{R: 0.000000, G: 0.619608, B: 0.376471}, ""},
			{"Shandy", colorful.Color{R: 1.000000, G: 0.901961, B: 0.439216}, ""},
			{"Sheen green", colorful.Color{R: 0.560784, G: 0.831373, B: 0.000000}, ""},
			{"Shimmering Blush", colorful.Color{R: 0.850980, G: 0.525490, B: 0.584314}, ""},
			{"Shiny Shamrock", colorful.Color{R: 0.372549, G: 0.654902, B: 0.470588}, ""},
			{"Shocking pink", colorful.Color{R: 0.988235, G: 0.058824, B: 0.752941}, ""},
			{"Shocking pink (Crayola)", colorful.Color{R: 1.000000, G: 0.435294, B: 1.000000}, ""},
			{"Sienna", colorful.Color{R: 0.533333, G: 0.176471, B: 0.090196}, ""},
			{"Silver", colorful.Color{R: 0.752941, G: 0.752941, B: 0.752941}, ""},
			{"Silver (Crayola)", colorful.Color{R: 0.788235, G: 0.752941, B: 0.733333}, ""},
			{"Silver (Metallic)", colorful.Color{R: 0.666667, G: 0.662745, B: 0.678431}, ""},
			{"Silver chalice", colorful.Color{R: 0.674510, G: 0.674510, B: 0.674510}, ""},
			{"Silver foil", colorful.Color{R: 0.686275, G: 0.694118, B: 0.682353}, ""},
			{"Silver Lake blue", colorful.Color{R: 0.364706, G: 0.537255, B: 0.729412}, ""},
			{"Silver pink", colorful.Color{R: 0.768627, G: 0.682353, B: 0.678431}, ""},
			{"Silver sand", colorful.Color{R: 0.749020, G: 0.756863, B: 0.760784}, ""},
			{"Sinopia", colorful.Color{R: 0.796078, G: 0.254902, B: 0.043137}, ""},
			{"Sizzling Red", colorful.Color{R: 1.000000, G: 0.219608, B: 0.333333}, ""},
			{"Sizzling Sunrise", colorful.Color{R: 1.000000, G: 0.858824, B: 0.000000}, ""},
			{"Skobeloff", colorful.Color{R: 0.000000, G: 0.454902, B: 0.454902}, ""},
			{"Sky blue", colorful.Color{R: 0.529412, G: 0.807843, B: 0.921569}, ""},
			{"Sky blue (Crayola)", colorful.Color{R: 0.462745, G: 0.843137, B: 0.917647}, ""},
			{"Sky magenta", colorful.Color{R: 0.811765, G: 0.443137, B: 0.686275}, ""},
			{"Slate blue", colorful.Color{R: 0.415686, G: 0.352941, B: 0.803922}, ""},
			{"Slate gray", colorful.Color{R: 0.439216, G: 0.501961, B: 0.564706}, ""},
			{"Slimy green", colorful.Color{R: 0.160784, G: 0.588235, B: 0.090196}, ""},
			{"Smalt (Dark powder blue)", colorful.Color{R: 0.000000, G: 0.200000, B: 0.600000}, ""},
			{"Smashed Pumpkin", colorful.Color{R: 1.000000, G: 0.427451, B: 0.227451}, ""},
			{"Smitten", colorful.Color{R: 0.784314, G: 0.254902, B: 0.525490}, ""},
			{"Smoke", colorful.Color{R: 0.450980, G: 0.509804, B: 0.462745}, ""},
			{"Smokey Topaz", colorful.Color{R: 0.513725, G: 0.164706, B: 0.050980}, ""},
			{"Smoky black", colorful.Color{R: 0.062745, G: 0.047059, B: 0.031373}, ""},
			{"Smoky Topaz", colorful.Color{R: 0.576471, G: 0.239216, B: 0.254902}, ""},
			{"Snow", colorful.Color{R: 1.000000, G: 0.980392, B: 0.980392}, ""},
			{"Soap", colorful.Color{R: 0.807843, G: 0.784314, B: 0.937255}, ""},
			{"Soldier Green", colorful.Color{R: 0.329412, G: 0.352941, B: 0.172549}, ""},
			{"Solid pink", colorful.Color{R: 0.537255, G: 0.219608, B: 0.262745}, ""},
			{"Sonic silver", colorful.Color{R: 0.458824, G: 0.458824, B: 0.458824}, ""},
			{"Spartan Crimson", colorful.Color{R: 0.619608, G: 0.074510, B: 0.086275}, ""},
			{"Space cadet", colorful.Color{R: 0.113725, G: 0.160784, B: 0.317647}, ""},
			{"Spanish bistre", colorful.Color{R: 0.501961, G: 0.458824, B: 0.196078}, ""},
			{"Spanish blue", colorful.Color{R: 0.000000, G: 0.439216, B: 0.721569}, ""},
			{"Spanish carmine", colorful.Color{R: 0.819608, G: 0.000000, B: 0.278431}, ""},
			{"Spanish crimson", colorful.Color{R: 0.898039, G: 0.101961, B: 0.298039}, ""},
			{"Spanish gray", colorful.Color{R: 0.596078, G: 0.596078, B: 0.596078}, ""},
			{"Spanish green", colorful.Color{R: 0.000000, G: 0.568627, B: 0.313725}, ""},
			{"Spanish orange", colorful.Color{R: 0.909804, G: 0.380392, B: 0.000000}, ""},
			{"Spanish pink", colorful.Color{R: 0.968627, G: 0.749020, B: 0.745098}, ""},
			{"Spanish purple", colorful.Color{R: 0.400000, G: 0.011765, B: 0.235294}, ""},
			{"Spanish red", colorful.Color{R: 0.901961, G: 0.000000, B: 0.149020}, ""},
			{"Spanish sky blue", colorful.Color{R: 0.000000, G: 1.000000, B: 1.000000}, ""},
			{"Spanish violet", colorful.Color{R: 0.298039, G: 0.156863, B: 0.509804}, ""},
			{"Spanish viridian", colorful.Color{R: 0.000000, G: 0.498039, B: 0.360784}, ""},
			{"Spanish yellow", colorful.Color{R: 0.964706, G: 0.709804, B: 0.066667}, ""},
			{"Spicy mix", colorful.Color{R: 0.545098, G: 0.372549, B: 0.301961}, ""},
			{"Spiro Disco Ball", colorful.Color{R: 0.058824, G: 0.752941, B: 0.988235}, ""},
			{"Spring bud", colorful.Color{R: 0.654902, G: 0.988235, B: 0.000000}, ""},
			{"Spring Frost", colorful.Color{R: 0.529412, G: 1.000000, B: 0.164706}, ""},
			{"Spring green", colorful.Color{R: 0.000000, G: 1.000000, B: 0.498039}, ""},
			{"Spring green (Crayola)", colorful.Color{R: 0.925490, G: 0.921569, B: 0.741176}, ""},
			{"Star command blue", colorful.Color{R: 0.000000, G: 0.482353, B: 0.721569}, ""},
			{"Steel blue", colorful.Color{R: 0.274510, G: 0.509804, B: 0.705882}, ""},
			{"Steel pink", colorful.Color{R: 0.800000, G: 0.200000, B: 0.800000}, ""},
			{"Steel Teal", colorful.Color{R: 0.372549, G: 0.541176, B: 0.545098}, ""},
			{"Stil de grain yellow", colorful.Color{R: 0.980392, G: 0.854902, B: 0.368627}, ""},
			{"Stizza", colorful.Color{R: 0.600000, G: 0.000000, B: 0.000000}, ""},
			{"Stormcloud", colorful.Color{R: 0.309804, G: 0.400000, B: 0.415686}, ""},
			{"Straw", colorful.Color{R: 0.894118, G: 0.850980, B: 0.435294}, ""},
			{"Strawberry", colorful.Color{R: 0.988235, G: 0.352941, B: 0.552941}, ""},
			{"Stop red", colorful.Color{R: 0.811765, G: 0.078431, B: 0.168627}, ""},
			{"Strawberry iced tea", colorful.Color{R: 0.988235, G: 0.352941, B: 0.552941}, ""},
			{"Strawberry red", colorful.Color{R: 0.784314, G: 0.247059, B: 0.286275}, ""},
			{"Sugar Plum", colorful.Color{R: 0.568627, G: 0.305882, B: 0.458824}, ""},
			{"Sunburnt Cyclops", colorful.Color{R: 1.000000, G: 0.250980, B: 0.298039}, ""},
			{"Sunglow", colorful.Color{R: 1.000000, G: 0.800000, B: 0.200000}, ""},
			{"Sunny", colorful.Color{R: 0.949020, G: 0.949020, B: 0.478431}, ""},
			{"Sunray", colorful.Color{R: 0.890196, G: 0.670588, B: 0.341176}, ""},
			{"Sunset", colorful.Color{R: 0.980392, G: 0.839216, B: 0.647059}, ""},
			{"Sunset orange", colorful.Color{R: 0.992157, G: 0.368627, B: 0.325490}, ""},
			{"Super pink", colorful.Color{R: 0.811765, G: 0.419608, B: 0.662745}, ""},
			{"Sweet Brown", colorful.Color{R: 0.658824, G: 0.215686, B: 0.192157}, ""},
			{"Tan", colorful.Color{R: 0.823529, G: 0.705882, B: 0.549020}, ""},
			{"Tan (Crayola)", colorful.Color{R: 0.850980, G: 0.603922, B: 0.423529}, ""},
			{"Tangelo", colorful.Color{R: 0.976471, G: 0.301961, B: 0.000000}, ""},
			{"Tangerine", colorful.Color{R: 0.949020, G: 0.521569, B: 0.000000}, ""},
			{"Tangerine yellow", colorful.Color{R: 1.000000, G: 0.800000, B: 0.000000}, ""},
			{"Tango pink", colorful.Color{R: 0.894118, G: 0.443137, B: 0.478431}, ""},
			{"Tart Orange", colorful.Color{R: 0.984314, G: 0.301961, B: 0.274510}, ""},
			{"Taupe", colorful.Color{R: 0.282353, G: 0.235294, B: 0.196078}, ""},
			{"Taupe gray", colorful.Color{R: 0.545098, G: 0.521569, B: 0.537255}, ""},
			{"Tea green", colorful.Color{R: 0.815686, G: 0.941176, B: 0.752941}, ""},
			{"Tea rose", colorful.Color{R: 0.972549, G: 0.513725, B: 0.474510}, ""},
			{"Tea rose", colorful.Color{R: 0.956863, G: 0.760784, B: 0.760784}, ""},
			{"Teal", colorful.Color{R: 0.000000, G: 0.501961, B: 0.501961}, ""},
			{"Teal blue", colorful.Color{R: 0.211765, G: 0.458824, B: 0.533333}, ""},
			{"Teal deer", colorful.Color{R: 0.600000, G: 0.901961, B: 0.701961}, ""},
			{"Teal green", colorful.Color{R: 0.000000, G: 0.509804, B: 0.498039}, ""},
			{"Telemagenta", colorful.Color{R: 0.811765, G: 0.203922, B: 0.462745}, ""},
			{"Temptress", colorful.Color{R: 0.235294, G: 0.129412, B: 0.149020}, ""},
			{"Tenné", colorful.Color{R: 0.803922, G: 0.341176, B: 0.000000}, ""},
			{"Terra cotta", colorful.Color{R: 0.886275, G: 0.447059, B: 0.356863}, ""},
			{"Thistle", colorful.Color{R: 0.847059, G: 0.749020, B: 0.847059}, ""},
			{"Thistle (Crayola)", colorful.Color{R: 0.921569, G: 0.690196, B: 0.843137}, ""},
			{"Thulian pink", colorful.Color{R: 0.870588, G: 0.435294, B: 0.631373}, ""},
			{"Tickle Me Pink", colorful.Color{R: 0.988235, G: 0.537255, B: 0.674510}, ""},
			{"Tiffany Blue", colorful.Color{R: 0.039216, G: 0.729412, B: 0.709804}, ""},
			{"Tiger's eye", colorful.Color{R: 0.878431, G: 0.552941, B: 0.235294}, ""},
			{"Timberwolf", colorful.Color{R: 0.858824, G: 0.843137, B: 0.823529}, ""},
			{"Titanium", colorful.Color{R: 0.529412, G: 0.525490, B: 0.505882}, ""},
			{"Titanium yellow", colorful.Color{R: 0.933333, G: 0.901961, B: 0.000000}, ""},
			{"Tomato", colorful.Color{R: 1.000000, G: 0.388235, B: 0.278431}, ""},
			{"Tomato sauce", colorful.Color{R: 0.698039, G: 0.094118, B: 0.027451}, ""},
			{"Toolbox", colorful.Color{R: 0.454902, G: 0.423529, B: 0.752941}, ""},
			{"Tooth", colorful.Color{R: 1.000000, G: 0.980392, B: 0.980392}, ""},
			{"Topaz", colorful.Color{R: 1.000000, G: 0.784314, B: 0.486275}, ""},
			{"Tractor red", colorful.Color{R: 0.992157, G: 0.054902, B: 0.207843}, ""},
			{"Trolley grey", colorful.Color{R: 0.501961, G: 0.501961, B: 0.501961}, ""},
			{"Tropical rain forest", colorful.Color{R: 0.000000, G: 0.458824, B: 0.368627}, ""},
			{"Tropical violet", colorful.Color{R: 0.803922, G: 0.643137, B: 0.870588}, ""},
			{"True blue", colorful.Color{R: 0.000000, G: 0.450980, B: 0.811765}, ""},
			{"Tufts blue", colorful.Color{R: 0.243137, G: 0.556863, B: 0.870588}, ""},
			{"Tulip", colorful.Color{R: 1.000000, G: 0.529412, B: 0.552941}, ""},
			{"Tumbleweed", colorful.Color{R: 0.870588, G: 0.666667, B: 0.533333}, ""},
			{"Turkish rose", colorful.Color{R: 0.709804, G: 0.447059, B: 0.505882}, ""},
			{"Turquoise", colorful.Color{R: 0.250980, G: 0.878431, B: 0.815686}, ""},
			{"Turquoise blue", colorful.Color{R: 0.000000, G: 1.000000, B: 0.937255}, ""},
			{"Turquoise green", colorful.Color{R: 0.627451, G: 0.839216, B: 0.705882}, ""},
			{"Turquoise Surf", colorful.Color{R: 0.000000, G: 0.772549, B: 0.803922}, ""},
			{"Turtle green", colorful.Color{R: 0.541176, G: 0.603922, B: 0.356863}, ""},
			{"Tuscan", colorful.Color{R: 0.980392, G: 0.839216, B: 0.647059}, ""},
			{"Tuscan brown", colorful.Color{R: 0.435294, G: 0.305882, B: 0.215686}, ""},
			{"Tuscan red", colorful.Color{R: 0.486275, G: 0.282353, B: 0.282353}, ""},
			{"Tuscan tan", colorful.Color{R: 0.650980, G: 0.482353, B: 0.356863}, ""},
			{"Tuscany", colorful.Color{R: 0.752941, G: 0.600000, B: 0.600000}, ""},
			{"Twilight lavender", colorful.Color{R: 0.541176, G: 0.286275, B: 0.419608}, ""},
			{"Twitter blue", colorful.Color{R: 0.149020, G: 0.654902, B: 0.870588}, ""},
			{"Tyrian purple", colorful.Color{R: 0.400000, G: 0.007843, B: 0.235294}, ""},
			{"UA blue", colorful.Color{R: 0.000000, G: 0.200000, B: 0.666667}, ""},
			{"UA red", colorful.Color{R: 0.850980, G: 0.000000, B: 0.298039}, ""},
			{"Ube", colorful.Color{R: 0.533333, G: 0.470588, B: 0.764706}, ""},
			{"UCLA blue", colorful.Color{R: 0.325490, G: 0.407843, B: 0.584314}, ""},
			{"UCLA gold", colorful.Color{R: 1.000000, G: 0.701961, B: 0.000000}, ""},
			{"UE red", colorful.Color{R: 0.729412, G: 0.000000, B: 0.003922}, ""},
			{"UFO Green", colorful.Color{R: 0.235294, G: 0.815686, B: 0.439216}, ""},
			{"Ultramarine", colorful.Color{R: 0.247059, G: 0.000000, B: 1.000000}, ""},
			{"Ultramarine blue", colorful.Color{R: 0.254902, G: 0.400000, B: 0.960784}, ""},
			{"Ultramarine blue (Caran d'Ache)", colorful.Color{R: 0.129412, G: 0.066667, B: 0.937255}, ""},
			{"Ultra pink", colorful.Color{R: 1.000000, G: 0.435294, B: 1.000000}, ""},
			{"Ultra red", colorful.Color{R: 0.988235, G: 0.423529, B: 0.521569}, ""},
			{"Umber", colorful.Color{R: 0.388235, G: 0.317647, B: 0.278431}, ""},
			{"Unbleached silk", colorful.Color{R: 1.000000, G: 0.866667, B: 0.792157}, ""},
			{"United Nations blue", colorful.Color{R: 0.356863, G: 0.572549, B: 0.898039}, ""},
			{"University of California gold", colorful.Color{R: 0.717647, G: 0.529412, B: 0.152941}, ""},
			{"University of Tennessee orange", colorful.Color{R: 0.968627, G: 0.498039, B: 0.000000}, ""},
			{"Unmellow yellow", colorful.Color{R: 1.000000, G: 1.000000, B: 0.400000}, ""},
			{"UP Forest green", colorful.Color{R: 0.003922, G: 0.266667, B: 0.129412}, ""},
			{"UP maroon", colorful.Color{R: 0.482353, G: 0.066667, B: 0.074510}, ""},
			{"Upsdell red", colorful.Color{R: 0.682353, G: 0.125490, B: 0.160784}, ""},
			{"Urobilin", colorful.Color{R: 0.882353, G: 0.678431, B: 0.129412}, ""},
			{"USAFA blue", colorful.Color{R: 0.000000, G: 0.309804, B: 0.596078}, ""},
			{"USC cardinal", colorful.Color{R: 0.600000, G: 0.000000, B: 0.000000}, ""},
			{"USC gold", colorful.Color{R: 1.000000, G: 0.800000, B: 0.000000}, ""},
			{"Utah Crimson", colorful.Color{R: 0.827451, G: 0.000000, B: 0.247059}, ""},
			{"Vampire black", colorful.Color{R: 0.031373, G: 0.031373, B: 0.031373}, ""},
			{"Van Dyke brown", colorful.Color{R: 0.400000, G: 0.258824, B: 0.156863}, ""},
			{"Vanilla", colorful.Color{R: 0.952941, G: 0.898039, B: 0.670588}, ""},
			{"Vanilla ice", colorful.Color{R: 0.952941, G: 0.560784, B: 0.662745}, ""},
			{"Vegas gold", colorful.Color{R: 0.772549, G: 0.701961, B: 0.345098}, ""},
			{"Venetian red", colorful.Color{R: 0.784314, G: 0.031373, B: 0.082353}, ""},
			{"Verdigris", colorful.Color{R: 0.262745, G: 0.701961, B: 0.682353}, ""},
			{"Verizon Red", colorful.Color{R: 0.803922, G: 0.015686, B: 0.043137}, ""},
			{"Vermilion", colorful.Color{R: 0.890196, G: 0.258824, B: 0.203922}, ""},
			{"Vermilion", colorful.Color{R: 0.850980, G: 0.219608, B: 0.117647}, ""},
			{"Veronica", colorful.Color{R: 0.627451, G: 0.125490, B: 0.941176}, ""},
			{"Verse green", colorful.Color{R: 0.094118, G: 0.533333, B: 0.050980}, ""},
			{"Very light azure", colorful.Color{R: 0.454902, G: 0.733333, B: 0.984314}, ""},
			{"Very light blue", colorful.Color{R: 0.400000, G: 0.400000, B: 1.000000}, ""},
			{"Very light malachite green", colorful.Color{R: 0.392157, G: 0.913725, B: 0.525490}, ""},
			{"Very light tangelo", colorful.Color{R: 1.000000, G: 0.690196, B: 0.466667}, ""},
			{"Very pale orange", colorful.Color{R: 1.000000, G: 0.874510, B: 0.749020}, ""},
			{"Very pale yellow", colorful.Color{R: 1.000000, G: 1.000000, B: 0.749020}, ""},
			{"Vine Green", colorful.Color{R: 0.086275, G: 0.250980, B: 0.062745}, ""},
			{"Violet", colorful.Color{R: 0.560784, G: 0.000000, B: 1.000000}, ""},
			{"Violet (Caran d'Ache)", colorful.Color{R: 0.431373, G: 0.000000, B: 0.752941}, ""},
			{"Violet (color wheel)", colorful.Color{R: 0.498039, G: 0.000000, B: 1.000000}, ""},
			{"Violet (crayola)", colorful.Color{R: 0.588235, G: 0.239216, B: 0.498039}, ""},
			{"Violet (RYB)", colorful.Color{R: 0.525490, G: 0.003922, B: 0.686275}, ""},
			{"Violet (web)", colorful.Color{R: 0.933333, G: 0.509804, B: 0.933333}, ""},
			{"Violet-blue", colorful.Color{R: 0.196078, G: 0.290196, B: 0.698039}, ""},
			{"Violet-blue (Crayola)", colorful.Color{R: 0.462745, G: 0.431373, B: 0.784314}, ""},
			{"Violet-red", colorful.Color{R: 0.968627, G: 0.325490, B: 0.580392}, ""},
			{"Violet-red", colorful.Color{R: 0.537255, G: 0.078431, B: 0.274510}, ""},
			{"Violin Brown", colorful.Color{R: 0.403922, G: 0.266667, B: 0.011765}, ""},
			{"Viridian", colorful.Color{R: 0.250980, G: 0.509804, B: 0.427451}, ""},
			{"Viridian green", colorful.Color{R: 0.000000, G: 0.588235, B: 0.596078}, ""},
			{"Vista blue", colorful.Color{R: 0.486275, G: 0.619608, B: 0.850980}, ""},
			{"Vivaldi Red", colorful.Color{R: 0.937255, G: 0.223529, B: 0.223529}, ""},
			{"Vivid amber", colorful.Color{R: 0.800000, G: 0.600000, B: 0.000000}, ""},
			{"Vivid auburn", colorful.Color{R: 0.572549, G: 0.152941, B: 0.141176}, ""},
			{"Vivid burgundy", colorful.Color{R: 0.623529, G: 0.113725, B: 0.207843}, ""},
			{"Vivid cerise", colorful.Color{R: 0.854902, G: 0.113725, B: 0.505882}, ""},
			{"Vivid cerulean", colorful.Color{R: 0.000000, G: 0.666667, B: 0.933333}, ""},
			{"Vivid crimson", colorful.Color{R: 0.800000, G: 0.000000, B: 0.200000}, ""},
			{"Vivid gamboge", colorful.Color{R: 1.000000, G: 0.600000, B: 0.000000}, ""},
			{"Vivid lime green", colorful.Color{R: 0.650980, G: 0.839216, B: 0.031373}, ""},
			{"Vivid malachite", colorful.Color{R: 0.000000, G: 0.800000, B: 0.200000}, ""},
			{"Vivid mulberry", colorful.Color{R: 0.721569, G: 0.047059, B: 0.890196}, ""},
			{"Vivid orange", colorful.Color{R: 1.000000, G: 0.372549, B: 0.000000}, ""},
			{"Vivid orange peel", colorful.Color{R: 1.000000, G: 0.627451, B: 0.000000}, ""},
			{"Vivid orchid", colorful.Color{R: 0.800000, G: 0.000000, B: 1.000000}, ""},
			{"Vivid raspberry", colorful.Color{R: 1.000000, G: 0.000000, B: 0.423529}, ""},
			{"Vivid red", colorful.Color{R: 0.968627, G: 0.050980, B: 0.101961}, ""},
			{"Vivid red-tangelo", colorful.Color{R: 0.874510, G: 0.380392, B: 0.141176}, ""},
			{"Vivid sky blue", colorful.Color{R: 0.000000, G: 0.800000, B: 1.000000}, ""},
			{"Vivid tangelo", colorful.Color{R: 0.941176, G: 0.454902, B: 0.152941}, ""},
			{"Vivid tangerine", colorful.Color{R: 1.000000, G: 0.627451, B: 0.537255}, ""},
			{"Vivid vermilion", colorful.Color{R: 0.898039, G: 0.376471, B: 0.141176}, ""},
			{"Vivid violet", colorful.Color{R: 0.623529, G: 0.000000, B: 1.000000}, ""},
			{"Vivid yellow", colorful.Color{R: 1.000000, G: 0.890196, B: 0.007843}, ""},
			{"Vodka", colorful.Color{R: 0.749020, G: 0.752941, B: 0.933333}, ""},
			{"Volt", colorful.Color{R: 0.807843, G: 1.000000, B: 0.000000}, ""},
			{"Wageningen green", colorful.Color{R: 0.203922, G: 0.698039, B: 0.200000}, ""},
			{"Walmart blue", colorful.Color{R: 0.000000, G: 0.490196, B: 0.776471}, ""},
			{"Walmart blue (1992–2008)", colorful.Color{R: 0.184314, G: 0.223529, B: 0.658824}, ""},
			{"Walmart blue (1981–1992)", colorful.Color{R: 0.113725, G: 0.172549, B: 0.627451}, ""},
			{"Walmart blue (1964–1981)", colorful.Color{R: 0.011765, G: 0.011765, B: 0.011765}, ""},
			{"Walmart blue (1962–1964)", colorful.Color{R: 0.047059, G: 0.364706, B: 0.654902}, ""},
			{"Warm black", colorful.Color{R: 0.000000, G: 0.258824, B: 0.258824}, ""},
			{"Water", colorful.Color{R: 0.831373, G: 0.945098, B: 0.976471}, ""},
			{"Watermelon", colorful.Color{R: 0.941176, G: 0.360784, B: 0.521569}, ""},
			{"Watermelon red", colorful.Color{R: 0.749020, G: 0.254902, B: 0.278431}, ""},
			{"Watermelon Yellow", colorful.Color{R: 0.933333, G: 1.000000, B: 0.105882}, ""},
			{"Waterspout", colorful.Color{R: 0.643137, G: 0.956863, B: 0.976471}, ""},
			{"Weldon Blue", colorful.Color{R: 0.486275, G: 0.596078, B: 0.670588}, ""},
			{"Wenge", colorful.Color{R: 0.392157, G: 0.329412, B: 0.321569}, ""},
			{"Wheat", colorful.Color{R: 0.960784, G: 0.870588, B: 0.701961}, ""},
			{"White", colorful.Color{R: 1.000000, G: 1.000000, B: 1.000000}, ""},
			{"White chocolate", colorful.Color{R: 0.929412, G: 0.901961, B: 0.839216}, ""},
			{"White coffee", colorful.Color{R: 0.901961, G: 0.878431, B: 0.831373}, ""},
			{"White smoke", colorful.Color{R: 0.960784, G: 0.960784, B: 0.960784}, ""},
			{"Wild blue yonder", colorful.Color{R: 0.635294, G: 0.678431, B: 0.815686}, ""},
			{"Wild orchid", colorful.Color{R: 0.831373, G: 0.439216, B: 0.635294}, ""},
			{"Wild Strawberry", colorful.Color{R: 1.000000, G: 0.262745, B: 0.643137}, ""},
			{"Wild watermelon", colorful.Color{R: 0.988235, G: 0.423529, B: 0.521569}, ""},
			{"Willpower orange", colorful.Color{R: 0.992157, G: 0.345098, B: 0.000000}, ""},
			{"Windsor tan", colorful.Color{R: 0.654902, G: 0.333333, B: 0.007843}, ""},
			{"Wine", colorful.Color{R: 0.447059, G: 0.184314, B: 0.215686}, ""},
			{"Wine dregs", colorful.Color{R: 0.403922, G: 0.192157, B: 0.278431}, ""},
			{"Wine red", colorful.Color{R: 0.694118, G: 0.070588, B: 0.149020}, ""},
			{"Winter Sky", colorful.Color{R: 1.000000, G: 0.000000, B: 0.486275}, ""},
			{"Winter Wizard", colorful.Color{R: 0.627451, G: 0.901961, B: 1.000000}, ""},
			{"Wintergreen Dream", colorful.Color{R: 0.337255, G: 0.533333, B: 0.490196}, ""},
			{"Wisteria", colorful.Color{R: 0.788235, G: 0.627451, B: 0.862745}, ""},
			{"Wood brown", colorful.Color{R: 0.756863, G: 0.603922, B: 0.419608}, ""},
			{"Xanadu", colorful.Color{R: 0.450980, G: 0.525490, B: 0.470588}, ""},
			{"Xbox Green", colorful.Color{R: 0.054902, G: 0.478431, B: 0.050980}, ""},
			{"Xiaomi Orange", colorful.Color{R: 0.992157, G: 0.286275, B: 0.000000}, ""},
			{"Yahoo Japan Red", colorful.Color{R: 1.000000, G: 0.000000, B: 0.200000}, ""},
			{"Yahoo Purple", colorful.Color{R: 0.254902, G: 0.007843, B: 0.690196}, ""},
			{"Yahoo Purple (1995)", colorful.Color{R: 0.486275, G: 0.003922, B: 0.603922}, ""},
			{"Yale Blue", colorful.Color{R: 0.058824, G: 0.301961, B: 0.572549}, ""},
			{"Yankees blue", colorful.Color{R: 0.109804, G: 0.156863, B: 0.254902}, ""},
			{"Yellow", colorful.Color{R: 1.000000, G: 1.000000, B: 0.000000}, ""},
			{"Yellow (Crayola)", colorful.Color{R: 0.988235, G: 0.909804, B: 0.513725}, ""},
			{"Yellow (Munsell)", colorful.Color{R: 0.937255, G: 0.800000, B: 0.000000}, ""},
			{"Yellow (NCS)", colorful.Color{R: 1.000000, G: 0.827451, B: 0.000000}, ""},
			{"Yellow (Pantone)", colorful.Color{R: 0.996078, G: 0.874510, B: 0.000000}, ""},
			{"Yellow (process)", colorful.Color{R: 1.000000, G: 0.937255, B: 0.000000}, ""},
			{"Yellow (RYB)", colorful.Color{R: 0.996078, G: 0.996078, B: 0.200000}, ""},
			{"Yellow-green", colorful.Color{R: 0.603922, G: 0.803922, B: 0.196078}, ""},
			{"Yellow-green (Crayola)", colorful.Color{R: 0.772549, G: 0.890196, B: 0.517647}, ""},
			{"Yellow Orange", colorful.Color{R: 1.000000, G: 0.682353, B: 0.258824}, ""},
			{"Yellow Orange (Color Wheel)", colorful.Color{R: 1.000000, G: 0.584314, B: 0.019608}, ""},
			{"Yellow rose", colorful.Color{R: 1.000000, G: 0.941176, B: 0.000000}, ""},
			{"Yellow Sunshine", colorful.Color{R: 1.000000, G: 0.968627, B: 0.000000}, ""},
			{"YInMn Blue", colorful.Color{R: 0.180392, G: 0.313725, B: 0.564706}, ""},
			{"Youtube red", colorful.Color{R: 0.698039, G: 0.027451, B: 0.113725}, ""},
			{"Zaffre", colorful.Color{R: 0.000000, G: 0.078431, B: 0.658824}, ""},
			{"Zebra White", colorful.Color{R: 0.960784, G: 0.960784, B: 0.960784}, ""},
			{"Zinnwaldite brown", colorful.Color{R: 0.172549, G: 0.086275, B: 0.031373}, ""},
			{"Zomp", colorful.Color{R: 0.223529, G: 0.654902, B: 0.556863}, ""},
			{"ZTE Blue", colorful.Color{R: 0.258824, G: 0.525490, B: 0.823529}, ""},
		})
}
