//
// Copyright (c) 2014-2019 Cesanta Software Limited
// All rights reserved
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package atca

import (
	"bytes"
	"encoding/hex"
	"testing"
)

var (
	testConfigGolden = [128]byte{
		0x01, 0x23, 0x52, 0xaa,
		0x00, 0x00, 0x50, 0x00,
		0xd1, 0xbb, 0xf3, 0x78,
		0xee, 0xc0, 0x01, 0x00,
		0xc0, 0x00, 0x55, 0x00,
		0x87, 0x64, 0x87, 0x64,
		0x87, 0x64, 0x87, 0x64,
		0x80, 0x0f, 0x8f, 0x8f,
		0x9f, 0x8f, 0x82, 0x20,
		0xc4, 0x44, 0xc4, 0x44,
		0x0f, 0x0f, 0x0f, 0x0f,
		0x0f, 0x0f, 0x0f, 0x0f,
		0x0f, 0x0f, 0x0f, 0x0f,
		0xff, 0xff, 0xff, 0xff,
		0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff,
		0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
		0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x33, 0x00, 0x33, 0x00,
		0x33, 0x00, 0x33, 0x00,
		0x3c, 0x00, 0x1c, 0x00,
		0x1c, 0x00, 0x33, 0x00,
		0x1c, 0x00, 0x1c, 0x00,
		0x3c, 0x00, 0x3c, 0x00,
		0x3c, 0x00, 0x3c, 0x00,
		0x1c, 0x00, 0x3c, 0x00,
	}
)

func TestParseAndWrite(t *testing.T) {
	c, err := ParseBinaryConfig(testConfigGolden[:])
	if err != nil {
		t.Fatalf("failed to parse golden config: %s", err)
	}
	cb, err := WriteBinaryConfig(c)
	if err != nil {
		t.Fatalf("failed to serialize golden config: %s", err)
	}
	if bytes.Compare(cb, testConfigGolden[:]) != 0 {
		t.Fatalf("serialized config does not match golden:\nExpected: %s\nGot     : %s",
			hex.EncodeToString(testConfigGolden[:]), hex.EncodeToString(cb))
	}
}
