# Miller docs

## Why use Mkdocs

* Connects to https://miller.readthedocs.io so people can get their docmods onto the web instead of the self-hosted https://johnkerl.org/miller/doc. Thanks to @pabloab for the great advice!
* More standard look and feel -- lots of people use readthedocs for other things so this should feel familiar.
* We get a Search feature for free.
* Mkdocs vs Sphinx: these are similar tools, but I find that I more easily get better desktop+mobile formatting using Mkdocs.

## Contributing

* You need `pip install mkdocs` (or `pip3 install mkdocs`) as well as `pip install mkdocs-material`.
* The docs include lots of live code examples which will be invoked using `mlr` which must be somewhere in your `$PATH`.
* Clone https://github.com/johnkerl/miller and cd into `docs/` within your clone.
* Overview of flow:
  * `docs/src` has `*.md.in` files containing markdown as well as directives for auto-generating code samples.
  * A `genmds` script reads `docs/src/*.md.in` and writes `docs/src/*.md`.
  * The `mkdocs build` tools reads `docs/src/*.md` and writes HTML files in `docs/site`.
  * Running `make` within the `docs` directory handles both of those steps.
  * TL;DR just `make docs` from the Miller base directory
* Quick-editing loop:
  * In one terminal, cd to this directory and leave `mkdocs serve` running.
  * In another terminal, cd to the `src` subdirectory of `docs` and edit `*.md.in`.
  * Run `genmds` to re-create all the `*.md` files, or `genmds foo.md.in` to just re-create the `foo.md.in` file you just edited, or (simplest) just `make` within the `docs/src` subdirectory.
  * In your browser, visit http://127.0.0.1:8000
  * This doesn't write HTML in `docs/site`; HTML is served up directly in the browser -- this is nice for previewing interactive edits.
* For-publish editing loop:
  * cd to the `src` subdirectory of `docs` and edit `*.md.in`.
  * `make -C ..`
  * This does write HTML in `docs/site`.
  * In your browser, visit `file:///your/path/to/miller/docs/site/index.html`
  * Link-checking:
    * `sudo pip3 install git+https://github.com/linkchecker/linkchecker.git`
    * `cd site` and `linkchecker .`
* Submitting:
  * Do the for-publish editing steps -- in particular, `docs/src/*md.in` and `docs/src/*md` are both checked in to source control.
  * `git add` your modified files, `git commit`, `git push`, and submit a PR at https://github.com/johnkerl/miller.

## Notes

* CSS:
  * I used the Mkdocs "material" theme which I like a lot. I customized `docs/src/extra.css` for Miller coloring/branding.
* Live code:
  * I didn't find a way to include non-Python live-code examples within Mkdocs so I adapted the pre-Mkdocs Miller-doc strategy which is to have a generator script read a template file (here, `foo.md.in`), run the marked lines, and generate the output file (`foo.md`). This is `genmds`.
  * Edit the `*.md.in` files, not `*.md` directly.
  * Within the `*.md.in` files are lines like `GENMD_RUN_COMMAND`. These will be run, and their output included, by `genmds` which calls the `genmds` script for you.
* readthedocs:
  * https://readthedocs.org/
  * https://readthedocs.org/projects/miller/
  * https://readthedocs.org/projects/miller/builds/
  * https://miller.readthedocs.io/en/latest/

## readthedocs website

* Published to https://miller.readthedocs.io/en/latest on each commit to `main` in this repo
* https://readthedocs.org/projects/miller/
* https://readthedocs.org/api/v2/webhook/miller/134065/
* https://readthedocs.org/projects/miller/builds/
* https://readthedocs.org/
