// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// PurchaseInvoicePostRequestParameter undocumented
type PurchaseInvoicePostRequestParameter struct {
}

// Currency is navigation property
func (b *PurchaseInvoiceRequestBuilder) Currency() *CurrencyRequestBuilder {
	bb := &CurrencyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/currency"
	return bb
}

// PurchaseInvoiceLines returns request builder for PurchaseInvoiceLine collection
func (b *PurchaseInvoiceRequestBuilder) PurchaseInvoiceLines() *PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder {
	bb := &PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/purchaseInvoiceLines"
	return bb
}

// PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder is request builder for PurchaseInvoiceLine collection
type PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PurchaseInvoiceLine collection
func (b *PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder) Request() *PurchaseInvoicePurchaseInvoiceLinesCollectionRequest {
	return &PurchaseInvoicePurchaseInvoiceLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PurchaseInvoiceLine item
func (b *PurchaseInvoicePurchaseInvoiceLinesCollectionRequestBuilder) ID(id string) *PurchaseInvoiceLineRequestBuilder {
	bb := &PurchaseInvoiceLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// PurchaseInvoicePurchaseInvoiceLinesCollectionRequest is request for PurchaseInvoiceLine collection
type PurchaseInvoicePurchaseInvoiceLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PurchaseInvoiceLine collection
func (r *PurchaseInvoicePurchaseInvoiceLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PurchaseInvoiceLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PurchaseInvoiceLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PurchaseInvoiceLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PurchaseInvoiceLine collection, max N pages
func (r *PurchaseInvoicePurchaseInvoiceLinesCollectionRequest) GetN(ctx context.Context, n int) ([]PurchaseInvoiceLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PurchaseInvoiceLine collection
func (r *PurchaseInvoicePurchaseInvoiceLinesCollectionRequest) Get(ctx context.Context) ([]PurchaseInvoiceLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PurchaseInvoiceLine collection
func (r *PurchaseInvoicePurchaseInvoiceLinesCollectionRequest) Add(ctx context.Context, reqObj *PurchaseInvoiceLine) (resObj *PurchaseInvoiceLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Vendor is navigation property
func (b *PurchaseInvoiceRequestBuilder) Vendor() *VendorRequestBuilder {
	bb := &VendorRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/vendor"
	return bb
}

// Account is navigation property
func (b *PurchaseInvoiceLineRequestBuilder) Account() *AccountRequestBuilder {
	bb := &AccountRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/account"
	return bb
}

// Item is navigation property
func (b *PurchaseInvoiceLineRequestBuilder) Item() *ItemRequestBuilder {
	bb := &ItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/item"
	return bb
}
