// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// Accounts returns request builder for Account collection
func (b *CompanyRequestBuilder) Accounts() *CompanyAccountsCollectionRequestBuilder {
	bb := &CompanyAccountsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/accounts"
	return bb
}

// CompanyAccountsCollectionRequestBuilder is request builder for Account collection
type CompanyAccountsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Account collection
func (b *CompanyAccountsCollectionRequestBuilder) Request() *CompanyAccountsCollectionRequest {
	return &CompanyAccountsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Account item
func (b *CompanyAccountsCollectionRequestBuilder) ID(id string) *AccountRequestBuilder {
	bb := &AccountRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyAccountsCollectionRequest is request for Account collection
type CompanyAccountsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Account collection
func (r *CompanyAccountsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Account, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Account
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Account
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Account collection, max N pages
func (r *CompanyAccountsCollectionRequest) GetN(ctx context.Context, n int) ([]Account, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Account collection
func (r *CompanyAccountsCollectionRequest) Get(ctx context.Context) ([]Account, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Account collection
func (r *CompanyAccountsCollectionRequest) Add(ctx context.Context, reqObj *Account) (resObj *Account, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AgedAccountsPayable returns request builder for AgedAccountsPayable collection
func (b *CompanyRequestBuilder) AgedAccountsPayable() *CompanyAgedAccountsPayableCollectionRequestBuilder {
	bb := &CompanyAgedAccountsPayableCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/agedAccountsPayable"
	return bb
}

// CompanyAgedAccountsPayableCollectionRequestBuilder is request builder for AgedAccountsPayable collection
type CompanyAgedAccountsPayableCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AgedAccountsPayable collection
func (b *CompanyAgedAccountsPayableCollectionRequestBuilder) Request() *CompanyAgedAccountsPayableCollectionRequest {
	return &CompanyAgedAccountsPayableCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AgedAccountsPayable item
func (b *CompanyAgedAccountsPayableCollectionRequestBuilder) ID(id string) *AgedAccountsPayableRequestBuilder {
	bb := &AgedAccountsPayableRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyAgedAccountsPayableCollectionRequest is request for AgedAccountsPayable collection
type CompanyAgedAccountsPayableCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AgedAccountsPayable collection
func (r *CompanyAgedAccountsPayableCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AgedAccountsPayable, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AgedAccountsPayable
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AgedAccountsPayable
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AgedAccountsPayable collection, max N pages
func (r *CompanyAgedAccountsPayableCollectionRequest) GetN(ctx context.Context, n int) ([]AgedAccountsPayable, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AgedAccountsPayable collection
func (r *CompanyAgedAccountsPayableCollectionRequest) Get(ctx context.Context) ([]AgedAccountsPayable, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AgedAccountsPayable collection
func (r *CompanyAgedAccountsPayableCollectionRequest) Add(ctx context.Context, reqObj *AgedAccountsPayable) (resObj *AgedAccountsPayable, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AgedAccountsReceivable returns request builder for AgedAccountsReceivable collection
func (b *CompanyRequestBuilder) AgedAccountsReceivable() *CompanyAgedAccountsReceivableCollectionRequestBuilder {
	bb := &CompanyAgedAccountsReceivableCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/agedAccountsReceivable"
	return bb
}

// CompanyAgedAccountsReceivableCollectionRequestBuilder is request builder for AgedAccountsReceivable collection
type CompanyAgedAccountsReceivableCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for AgedAccountsReceivable collection
func (b *CompanyAgedAccountsReceivableCollectionRequestBuilder) Request() *CompanyAgedAccountsReceivableCollectionRequest {
	return &CompanyAgedAccountsReceivableCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for AgedAccountsReceivable item
func (b *CompanyAgedAccountsReceivableCollectionRequestBuilder) ID(id string) *AgedAccountsReceivableRequestBuilder {
	bb := &AgedAccountsReceivableRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyAgedAccountsReceivableCollectionRequest is request for AgedAccountsReceivable collection
type CompanyAgedAccountsReceivableCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for AgedAccountsReceivable collection
func (r *CompanyAgedAccountsReceivableCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]AgedAccountsReceivable, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []AgedAccountsReceivable
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []AgedAccountsReceivable
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for AgedAccountsReceivable collection, max N pages
func (r *CompanyAgedAccountsReceivableCollectionRequest) GetN(ctx context.Context, n int) ([]AgedAccountsReceivable, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for AgedAccountsReceivable collection
func (r *CompanyAgedAccountsReceivableCollectionRequest) Get(ctx context.Context) ([]AgedAccountsReceivable, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for AgedAccountsReceivable collection
func (r *CompanyAgedAccountsReceivableCollectionRequest) Add(ctx context.Context, reqObj *AgedAccountsReceivable) (resObj *AgedAccountsReceivable, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CompanyInformation returns request builder for CompanyInformation collection
func (b *CompanyRequestBuilder) CompanyInformation() *CompanyCompanyInformationCollectionRequestBuilder {
	bb := &CompanyCompanyInformationCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/companyInformation"
	return bb
}

// CompanyCompanyInformationCollectionRequestBuilder is request builder for CompanyInformation collection
type CompanyCompanyInformationCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CompanyInformation collection
func (b *CompanyCompanyInformationCollectionRequestBuilder) Request() *CompanyCompanyInformationCollectionRequest {
	return &CompanyCompanyInformationCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CompanyInformation item
func (b *CompanyCompanyInformationCollectionRequestBuilder) ID(id string) *CompanyInformationRequestBuilder {
	bb := &CompanyInformationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCompanyInformationCollectionRequest is request for CompanyInformation collection
type CompanyCompanyInformationCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CompanyInformation collection
func (r *CompanyCompanyInformationCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CompanyInformation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CompanyInformation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CompanyInformation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CompanyInformation collection, max N pages
func (r *CompanyCompanyInformationCollectionRequest) GetN(ctx context.Context, n int) ([]CompanyInformation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CompanyInformation collection
func (r *CompanyCompanyInformationCollectionRequest) Get(ctx context.Context) ([]CompanyInformation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CompanyInformation collection
func (r *CompanyCompanyInformationCollectionRequest) Add(ctx context.Context, reqObj *CompanyInformation) (resObj *CompanyInformation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CountriesRegions returns request builder for CountryRegion collection
func (b *CompanyRequestBuilder) CountriesRegions() *CompanyCountriesRegionsCollectionRequestBuilder {
	bb := &CompanyCountriesRegionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/countriesRegions"
	return bb
}

// CompanyCountriesRegionsCollectionRequestBuilder is request builder for CountryRegion collection
type CompanyCountriesRegionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CountryRegion collection
func (b *CompanyCountriesRegionsCollectionRequestBuilder) Request() *CompanyCountriesRegionsCollectionRequest {
	return &CompanyCountriesRegionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CountryRegion item
func (b *CompanyCountriesRegionsCollectionRequestBuilder) ID(id string) *CountryRegionRequestBuilder {
	bb := &CountryRegionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCountriesRegionsCollectionRequest is request for CountryRegion collection
type CompanyCountriesRegionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CountryRegion collection
func (r *CompanyCountriesRegionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CountryRegion, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CountryRegion
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CountryRegion
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CountryRegion collection, max N pages
func (r *CompanyCountriesRegionsCollectionRequest) GetN(ctx context.Context, n int) ([]CountryRegion, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CountryRegion collection
func (r *CompanyCountriesRegionsCollectionRequest) Get(ctx context.Context) ([]CountryRegion, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CountryRegion collection
func (r *CompanyCountriesRegionsCollectionRequest) Add(ctx context.Context, reqObj *CountryRegion) (resObj *CountryRegion, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Currencies returns request builder for Currency collection
func (b *CompanyRequestBuilder) Currencies() *CompanyCurrenciesCollectionRequestBuilder {
	bb := &CompanyCurrenciesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/currencies"
	return bb
}

// CompanyCurrenciesCollectionRequestBuilder is request builder for Currency collection
type CompanyCurrenciesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Currency collection
func (b *CompanyCurrenciesCollectionRequestBuilder) Request() *CompanyCurrenciesCollectionRequest {
	return &CompanyCurrenciesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Currency item
func (b *CompanyCurrenciesCollectionRequestBuilder) ID(id string) *CurrencyRequestBuilder {
	bb := &CurrencyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCurrenciesCollectionRequest is request for Currency collection
type CompanyCurrenciesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Currency collection
func (r *CompanyCurrenciesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Currency, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Currency
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Currency
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Currency collection, max N pages
func (r *CompanyCurrenciesCollectionRequest) GetN(ctx context.Context, n int) ([]Currency, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Currency collection
func (r *CompanyCurrenciesCollectionRequest) Get(ctx context.Context) ([]Currency, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Currency collection
func (r *CompanyCurrenciesCollectionRequest) Add(ctx context.Context, reqObj *Currency) (resObj *Currency, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CustomerPaymentJournals returns request builder for CustomerPaymentJournal collection
func (b *CompanyRequestBuilder) CustomerPaymentJournals() *CompanyCustomerPaymentJournalsCollectionRequestBuilder {
	bb := &CompanyCustomerPaymentJournalsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/customerPaymentJournals"
	return bb
}

// CompanyCustomerPaymentJournalsCollectionRequestBuilder is request builder for CustomerPaymentJournal collection
type CompanyCustomerPaymentJournalsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CustomerPaymentJournal collection
func (b *CompanyCustomerPaymentJournalsCollectionRequestBuilder) Request() *CompanyCustomerPaymentJournalsCollectionRequest {
	return &CompanyCustomerPaymentJournalsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CustomerPaymentJournal item
func (b *CompanyCustomerPaymentJournalsCollectionRequestBuilder) ID(id string) *CustomerPaymentJournalRequestBuilder {
	bb := &CustomerPaymentJournalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCustomerPaymentJournalsCollectionRequest is request for CustomerPaymentJournal collection
type CompanyCustomerPaymentJournalsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CustomerPaymentJournal collection
func (r *CompanyCustomerPaymentJournalsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CustomerPaymentJournal, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CustomerPaymentJournal
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CustomerPaymentJournal
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CustomerPaymentJournal collection, max N pages
func (r *CompanyCustomerPaymentJournalsCollectionRequest) GetN(ctx context.Context, n int) ([]CustomerPaymentJournal, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CustomerPaymentJournal collection
func (r *CompanyCustomerPaymentJournalsCollectionRequest) Get(ctx context.Context) ([]CustomerPaymentJournal, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CustomerPaymentJournal collection
func (r *CompanyCustomerPaymentJournalsCollectionRequest) Add(ctx context.Context, reqObj *CustomerPaymentJournal) (resObj *CustomerPaymentJournal, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// CustomerPayments returns request builder for CustomerPayment collection
func (b *CompanyRequestBuilder) CustomerPayments() *CompanyCustomerPaymentsCollectionRequestBuilder {
	bb := &CompanyCustomerPaymentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/customerPayments"
	return bb
}

// CompanyCustomerPaymentsCollectionRequestBuilder is request builder for CustomerPayment collection
type CompanyCustomerPaymentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for CustomerPayment collection
func (b *CompanyCustomerPaymentsCollectionRequestBuilder) Request() *CompanyCustomerPaymentsCollectionRequest {
	return &CompanyCustomerPaymentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for CustomerPayment item
func (b *CompanyCustomerPaymentsCollectionRequestBuilder) ID(id string) *CustomerPaymentRequestBuilder {
	bb := &CustomerPaymentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCustomerPaymentsCollectionRequest is request for CustomerPayment collection
type CompanyCustomerPaymentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for CustomerPayment collection
func (r *CompanyCustomerPaymentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]CustomerPayment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []CustomerPayment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []CustomerPayment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for CustomerPayment collection, max N pages
func (r *CompanyCustomerPaymentsCollectionRequest) GetN(ctx context.Context, n int) ([]CustomerPayment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for CustomerPayment collection
func (r *CompanyCustomerPaymentsCollectionRequest) Get(ctx context.Context) ([]CustomerPayment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for CustomerPayment collection
func (r *CompanyCustomerPaymentsCollectionRequest) Add(ctx context.Context, reqObj *CustomerPayment) (resObj *CustomerPayment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Customers returns request builder for Customer collection
func (b *CompanyRequestBuilder) Customers() *CompanyCustomersCollectionRequestBuilder {
	bb := &CompanyCustomersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/customers"
	return bb
}

// CompanyCustomersCollectionRequestBuilder is request builder for Customer collection
type CompanyCustomersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Customer collection
func (b *CompanyCustomersCollectionRequestBuilder) Request() *CompanyCustomersCollectionRequest {
	return &CompanyCustomersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Customer item
func (b *CompanyCustomersCollectionRequestBuilder) ID(id string) *CustomerRequestBuilder {
	bb := &CustomerRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyCustomersCollectionRequest is request for Customer collection
type CompanyCustomersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Customer collection
func (r *CompanyCustomersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Customer, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Customer
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Customer
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Customer collection, max N pages
func (r *CompanyCustomersCollectionRequest) GetN(ctx context.Context, n int) ([]Customer, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Customer collection
func (r *CompanyCustomersCollectionRequest) Get(ctx context.Context) ([]Customer, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Customer collection
func (r *CompanyCustomersCollectionRequest) Add(ctx context.Context, reqObj *Customer) (resObj *Customer, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// DimensionValues returns request builder for DimensionValue collection
func (b *CompanyRequestBuilder) DimensionValues() *CompanyDimensionValuesCollectionRequestBuilder {
	bb := &CompanyDimensionValuesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/dimensionValues"
	return bb
}

// CompanyDimensionValuesCollectionRequestBuilder is request builder for DimensionValue collection
type CompanyDimensionValuesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for DimensionValue collection
func (b *CompanyDimensionValuesCollectionRequestBuilder) Request() *CompanyDimensionValuesCollectionRequest {
	return &CompanyDimensionValuesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for DimensionValue item
func (b *CompanyDimensionValuesCollectionRequestBuilder) ID(id string) *DimensionValueRequestBuilder {
	bb := &DimensionValueRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyDimensionValuesCollectionRequest is request for DimensionValue collection
type CompanyDimensionValuesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for DimensionValue collection
func (r *CompanyDimensionValuesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]DimensionValue, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []DimensionValue
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []DimensionValue
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for DimensionValue collection, max N pages
func (r *CompanyDimensionValuesCollectionRequest) GetN(ctx context.Context, n int) ([]DimensionValue, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for DimensionValue collection
func (r *CompanyDimensionValuesCollectionRequest) Get(ctx context.Context) ([]DimensionValue, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for DimensionValue collection
func (r *CompanyDimensionValuesCollectionRequest) Add(ctx context.Context, reqObj *DimensionValue) (resObj *DimensionValue, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Dimensions returns request builder for Dimension collection
func (b *CompanyRequestBuilder) Dimensions() *CompanyDimensionsCollectionRequestBuilder {
	bb := &CompanyDimensionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/dimensions"
	return bb
}

// CompanyDimensionsCollectionRequestBuilder is request builder for Dimension collection
type CompanyDimensionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Dimension collection
func (b *CompanyDimensionsCollectionRequestBuilder) Request() *CompanyDimensionsCollectionRequest {
	return &CompanyDimensionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Dimension item
func (b *CompanyDimensionsCollectionRequestBuilder) ID(id string) *DimensionRequestBuilder {
	bb := &DimensionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyDimensionsCollectionRequest is request for Dimension collection
type CompanyDimensionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Dimension collection
func (r *CompanyDimensionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Dimension, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Dimension
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Dimension
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Dimension collection, max N pages
func (r *CompanyDimensionsCollectionRequest) GetN(ctx context.Context, n int) ([]Dimension, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Dimension collection
func (r *CompanyDimensionsCollectionRequest) Get(ctx context.Context) ([]Dimension, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Dimension collection
func (r *CompanyDimensionsCollectionRequest) Add(ctx context.Context, reqObj *Dimension) (resObj *Dimension, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Employees returns request builder for Employee collection
func (b *CompanyRequestBuilder) Employees() *CompanyEmployeesCollectionRequestBuilder {
	bb := &CompanyEmployeesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/employees"
	return bb
}

// CompanyEmployeesCollectionRequestBuilder is request builder for Employee collection
type CompanyEmployeesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Employee collection
func (b *CompanyEmployeesCollectionRequestBuilder) Request() *CompanyEmployeesCollectionRequest {
	return &CompanyEmployeesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Employee item
func (b *CompanyEmployeesCollectionRequestBuilder) ID(id string) *EmployeeRequestBuilder {
	bb := &EmployeeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyEmployeesCollectionRequest is request for Employee collection
type CompanyEmployeesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Employee collection
func (r *CompanyEmployeesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Employee, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Employee
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Employee
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Employee collection, max N pages
func (r *CompanyEmployeesCollectionRequest) GetN(ctx context.Context, n int) ([]Employee, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Employee collection
func (r *CompanyEmployeesCollectionRequest) Get(ctx context.Context) ([]Employee, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Employee collection
func (r *CompanyEmployeesCollectionRequest) Add(ctx context.Context, reqObj *Employee) (resObj *Employee, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// GeneralLedgerEntries returns request builder for GeneralLedgerEntry collection
func (b *CompanyRequestBuilder) GeneralLedgerEntries() *CompanyGeneralLedgerEntriesCollectionRequestBuilder {
	bb := &CompanyGeneralLedgerEntriesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/generalLedgerEntries"
	return bb
}

// CompanyGeneralLedgerEntriesCollectionRequestBuilder is request builder for GeneralLedgerEntry collection
type CompanyGeneralLedgerEntriesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for GeneralLedgerEntry collection
func (b *CompanyGeneralLedgerEntriesCollectionRequestBuilder) Request() *CompanyGeneralLedgerEntriesCollectionRequest {
	return &CompanyGeneralLedgerEntriesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for GeneralLedgerEntry item
func (b *CompanyGeneralLedgerEntriesCollectionRequestBuilder) ID(id string) *GeneralLedgerEntryRequestBuilder {
	bb := &GeneralLedgerEntryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyGeneralLedgerEntriesCollectionRequest is request for GeneralLedgerEntry collection
type CompanyGeneralLedgerEntriesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for GeneralLedgerEntry collection
func (r *CompanyGeneralLedgerEntriesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]GeneralLedgerEntry, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []GeneralLedgerEntry
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []GeneralLedgerEntry
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for GeneralLedgerEntry collection, max N pages
func (r *CompanyGeneralLedgerEntriesCollectionRequest) GetN(ctx context.Context, n int) ([]GeneralLedgerEntry, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for GeneralLedgerEntry collection
func (r *CompanyGeneralLedgerEntriesCollectionRequest) Get(ctx context.Context) ([]GeneralLedgerEntry, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for GeneralLedgerEntry collection
func (r *CompanyGeneralLedgerEntriesCollectionRequest) Add(ctx context.Context, reqObj *GeneralLedgerEntry) (resObj *GeneralLedgerEntry, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ItemCategories returns request builder for ItemCategory collection
func (b *CompanyRequestBuilder) ItemCategories() *CompanyItemCategoriesCollectionRequestBuilder {
	bb := &CompanyItemCategoriesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/itemCategories"
	return bb
}

// CompanyItemCategoriesCollectionRequestBuilder is request builder for ItemCategory collection
type CompanyItemCategoriesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ItemCategory collection
func (b *CompanyItemCategoriesCollectionRequestBuilder) Request() *CompanyItemCategoriesCollectionRequest {
	return &CompanyItemCategoriesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ItemCategory item
func (b *CompanyItemCategoriesCollectionRequestBuilder) ID(id string) *ItemCategoryRequestBuilder {
	bb := &ItemCategoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyItemCategoriesCollectionRequest is request for ItemCategory collection
type CompanyItemCategoriesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ItemCategory collection
func (r *CompanyItemCategoriesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ItemCategory, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ItemCategory
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ItemCategory
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ItemCategory collection, max N pages
func (r *CompanyItemCategoriesCollectionRequest) GetN(ctx context.Context, n int) ([]ItemCategory, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ItemCategory collection
func (r *CompanyItemCategoriesCollectionRequest) Get(ctx context.Context) ([]ItemCategory, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ItemCategory collection
func (r *CompanyItemCategoriesCollectionRequest) Add(ctx context.Context, reqObj *ItemCategory) (resObj *ItemCategory, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Items returns request builder for Item collection
func (b *CompanyRequestBuilder) Items() *CompanyItemsCollectionRequestBuilder {
	bb := &CompanyItemsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/items"
	return bb
}

// CompanyItemsCollectionRequestBuilder is request builder for Item collection
type CompanyItemsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Item collection
func (b *CompanyItemsCollectionRequestBuilder) Request() *CompanyItemsCollectionRequest {
	return &CompanyItemsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Item item
func (b *CompanyItemsCollectionRequestBuilder) ID(id string) *ItemRequestBuilder {
	bb := &ItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyItemsCollectionRequest is request for Item collection
type CompanyItemsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Item collection
func (r *CompanyItemsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Item, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Item
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Item
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Item collection, max N pages
func (r *CompanyItemsCollectionRequest) GetN(ctx context.Context, n int) ([]Item, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Item collection
func (r *CompanyItemsCollectionRequest) Get(ctx context.Context) ([]Item, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Item collection
func (r *CompanyItemsCollectionRequest) Add(ctx context.Context, reqObj *Item) (resObj *Item, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// JournalLines returns request builder for JournalLine collection
func (b *CompanyRequestBuilder) JournalLines() *CompanyJournalLinesCollectionRequestBuilder {
	bb := &CompanyJournalLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/journalLines"
	return bb
}

// CompanyJournalLinesCollectionRequestBuilder is request builder for JournalLine collection
type CompanyJournalLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for JournalLine collection
func (b *CompanyJournalLinesCollectionRequestBuilder) Request() *CompanyJournalLinesCollectionRequest {
	return &CompanyJournalLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for JournalLine item
func (b *CompanyJournalLinesCollectionRequestBuilder) ID(id string) *JournalLineRequestBuilder {
	bb := &JournalLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyJournalLinesCollectionRequest is request for JournalLine collection
type CompanyJournalLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for JournalLine collection
func (r *CompanyJournalLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]JournalLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []JournalLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []JournalLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for JournalLine collection, max N pages
func (r *CompanyJournalLinesCollectionRequest) GetN(ctx context.Context, n int) ([]JournalLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for JournalLine collection
func (r *CompanyJournalLinesCollectionRequest) Get(ctx context.Context) ([]JournalLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for JournalLine collection
func (r *CompanyJournalLinesCollectionRequest) Add(ctx context.Context, reqObj *JournalLine) (resObj *JournalLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Journals returns request builder for Journal collection
func (b *CompanyRequestBuilder) Journals() *CompanyJournalsCollectionRequestBuilder {
	bb := &CompanyJournalsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/journals"
	return bb
}

// CompanyJournalsCollectionRequestBuilder is request builder for Journal collection
type CompanyJournalsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Journal collection
func (b *CompanyJournalsCollectionRequestBuilder) Request() *CompanyJournalsCollectionRequest {
	return &CompanyJournalsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Journal item
func (b *CompanyJournalsCollectionRequestBuilder) ID(id string) *JournalRequestBuilder {
	bb := &JournalRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyJournalsCollectionRequest is request for Journal collection
type CompanyJournalsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Journal collection
func (r *CompanyJournalsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Journal, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Journal
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Journal
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Journal collection, max N pages
func (r *CompanyJournalsCollectionRequest) GetN(ctx context.Context, n int) ([]Journal, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Journal collection
func (r *CompanyJournalsCollectionRequest) Get(ctx context.Context) ([]Journal, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Journal collection
func (r *CompanyJournalsCollectionRequest) Add(ctx context.Context, reqObj *Journal) (resObj *Journal, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PaymentMethods returns request builder for PaymentMethod collection
func (b *CompanyRequestBuilder) PaymentMethods() *CompanyPaymentMethodsCollectionRequestBuilder {
	bb := &CompanyPaymentMethodsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/paymentMethods"
	return bb
}

// CompanyPaymentMethodsCollectionRequestBuilder is request builder for PaymentMethod collection
type CompanyPaymentMethodsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PaymentMethod collection
func (b *CompanyPaymentMethodsCollectionRequestBuilder) Request() *CompanyPaymentMethodsCollectionRequest {
	return &CompanyPaymentMethodsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PaymentMethod item
func (b *CompanyPaymentMethodsCollectionRequestBuilder) ID(id string) *PaymentMethodRequestBuilder {
	bb := &PaymentMethodRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyPaymentMethodsCollectionRequest is request for PaymentMethod collection
type CompanyPaymentMethodsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PaymentMethod collection
func (r *CompanyPaymentMethodsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PaymentMethod, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PaymentMethod
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PaymentMethod
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PaymentMethod collection, max N pages
func (r *CompanyPaymentMethodsCollectionRequest) GetN(ctx context.Context, n int) ([]PaymentMethod, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PaymentMethod collection
func (r *CompanyPaymentMethodsCollectionRequest) Get(ctx context.Context) ([]PaymentMethod, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PaymentMethod collection
func (r *CompanyPaymentMethodsCollectionRequest) Add(ctx context.Context, reqObj *PaymentMethod) (resObj *PaymentMethod, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PaymentTerms returns request builder for PaymentTerm collection
func (b *CompanyRequestBuilder) PaymentTerms() *CompanyPaymentTermsCollectionRequestBuilder {
	bb := &CompanyPaymentTermsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/paymentTerms"
	return bb
}

// CompanyPaymentTermsCollectionRequestBuilder is request builder for PaymentTerm collection
type CompanyPaymentTermsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PaymentTerm collection
func (b *CompanyPaymentTermsCollectionRequestBuilder) Request() *CompanyPaymentTermsCollectionRequest {
	return &CompanyPaymentTermsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PaymentTerm item
func (b *CompanyPaymentTermsCollectionRequestBuilder) ID(id string) *PaymentTermRequestBuilder {
	bb := &PaymentTermRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyPaymentTermsCollectionRequest is request for PaymentTerm collection
type CompanyPaymentTermsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PaymentTerm collection
func (r *CompanyPaymentTermsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PaymentTerm, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PaymentTerm
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PaymentTerm
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PaymentTerm collection, max N pages
func (r *CompanyPaymentTermsCollectionRequest) GetN(ctx context.Context, n int) ([]PaymentTerm, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PaymentTerm collection
func (r *CompanyPaymentTermsCollectionRequest) Get(ctx context.Context) ([]PaymentTerm, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PaymentTerm collection
func (r *CompanyPaymentTermsCollectionRequest) Add(ctx context.Context, reqObj *PaymentTerm) (resObj *PaymentTerm, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Picture returns request builder for Picture collection
func (b *CompanyRequestBuilder) Picture() *CompanyPictureCollectionRequestBuilder {
	bb := &CompanyPictureCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/picture"
	return bb
}

// CompanyPictureCollectionRequestBuilder is request builder for Picture collection
type CompanyPictureCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Picture collection
func (b *CompanyPictureCollectionRequestBuilder) Request() *CompanyPictureCollectionRequest {
	return &CompanyPictureCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Picture item
func (b *CompanyPictureCollectionRequestBuilder) ID(id string) *PictureRequestBuilder {
	bb := &PictureRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyPictureCollectionRequest is request for Picture collection
type CompanyPictureCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Picture collection
func (r *CompanyPictureCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Picture, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Picture
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Picture
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Picture collection, max N pages
func (r *CompanyPictureCollectionRequest) GetN(ctx context.Context, n int) ([]Picture, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Picture collection
func (r *CompanyPictureCollectionRequest) Get(ctx context.Context) ([]Picture, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Picture collection
func (r *CompanyPictureCollectionRequest) Add(ctx context.Context, reqObj *Picture) (resObj *Picture, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PurchaseInvoiceLines returns request builder for PurchaseInvoiceLine collection
func (b *CompanyRequestBuilder) PurchaseInvoiceLines() *CompanyPurchaseInvoiceLinesCollectionRequestBuilder {
	bb := &CompanyPurchaseInvoiceLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/purchaseInvoiceLines"
	return bb
}

// CompanyPurchaseInvoiceLinesCollectionRequestBuilder is request builder for PurchaseInvoiceLine collection
type CompanyPurchaseInvoiceLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PurchaseInvoiceLine collection
func (b *CompanyPurchaseInvoiceLinesCollectionRequestBuilder) Request() *CompanyPurchaseInvoiceLinesCollectionRequest {
	return &CompanyPurchaseInvoiceLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PurchaseInvoiceLine item
func (b *CompanyPurchaseInvoiceLinesCollectionRequestBuilder) ID(id string) *PurchaseInvoiceLineRequestBuilder {
	bb := &PurchaseInvoiceLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyPurchaseInvoiceLinesCollectionRequest is request for PurchaseInvoiceLine collection
type CompanyPurchaseInvoiceLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PurchaseInvoiceLine collection
func (r *CompanyPurchaseInvoiceLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PurchaseInvoiceLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PurchaseInvoiceLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PurchaseInvoiceLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PurchaseInvoiceLine collection, max N pages
func (r *CompanyPurchaseInvoiceLinesCollectionRequest) GetN(ctx context.Context, n int) ([]PurchaseInvoiceLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PurchaseInvoiceLine collection
func (r *CompanyPurchaseInvoiceLinesCollectionRequest) Get(ctx context.Context) ([]PurchaseInvoiceLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PurchaseInvoiceLine collection
func (r *CompanyPurchaseInvoiceLinesCollectionRequest) Add(ctx context.Context, reqObj *PurchaseInvoiceLine) (resObj *PurchaseInvoiceLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// PurchaseInvoices returns request builder for PurchaseInvoice collection
func (b *CompanyRequestBuilder) PurchaseInvoices() *CompanyPurchaseInvoicesCollectionRequestBuilder {
	bb := &CompanyPurchaseInvoicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/purchaseInvoices"
	return bb
}

// CompanyPurchaseInvoicesCollectionRequestBuilder is request builder for PurchaseInvoice collection
type CompanyPurchaseInvoicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PurchaseInvoice collection
func (b *CompanyPurchaseInvoicesCollectionRequestBuilder) Request() *CompanyPurchaseInvoicesCollectionRequest {
	return &CompanyPurchaseInvoicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PurchaseInvoice item
func (b *CompanyPurchaseInvoicesCollectionRequestBuilder) ID(id string) *PurchaseInvoiceRequestBuilder {
	bb := &PurchaseInvoiceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyPurchaseInvoicesCollectionRequest is request for PurchaseInvoice collection
type CompanyPurchaseInvoicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PurchaseInvoice collection
func (r *CompanyPurchaseInvoicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PurchaseInvoice, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PurchaseInvoice
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PurchaseInvoice
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PurchaseInvoice collection, max N pages
func (r *CompanyPurchaseInvoicesCollectionRequest) GetN(ctx context.Context, n int) ([]PurchaseInvoice, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PurchaseInvoice collection
func (r *CompanyPurchaseInvoicesCollectionRequest) Get(ctx context.Context) ([]PurchaseInvoice, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PurchaseInvoice collection
func (r *CompanyPurchaseInvoicesCollectionRequest) Add(ctx context.Context, reqObj *PurchaseInvoice) (resObj *PurchaseInvoice, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesCreditMemoLines returns request builder for SalesCreditMemoLine collection
func (b *CompanyRequestBuilder) SalesCreditMemoLines() *CompanySalesCreditMemoLinesCollectionRequestBuilder {
	bb := &CompanySalesCreditMemoLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesCreditMemoLines"
	return bb
}

// CompanySalesCreditMemoLinesCollectionRequestBuilder is request builder for SalesCreditMemoLine collection
type CompanySalesCreditMemoLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesCreditMemoLine collection
func (b *CompanySalesCreditMemoLinesCollectionRequestBuilder) Request() *CompanySalesCreditMemoLinesCollectionRequest {
	return &CompanySalesCreditMemoLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesCreditMemoLine item
func (b *CompanySalesCreditMemoLinesCollectionRequestBuilder) ID(id string) *SalesCreditMemoLineRequestBuilder {
	bb := &SalesCreditMemoLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesCreditMemoLinesCollectionRequest is request for SalesCreditMemoLine collection
type CompanySalesCreditMemoLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesCreditMemoLine collection
func (r *CompanySalesCreditMemoLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesCreditMemoLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesCreditMemoLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesCreditMemoLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesCreditMemoLine collection, max N pages
func (r *CompanySalesCreditMemoLinesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesCreditMemoLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesCreditMemoLine collection
func (r *CompanySalesCreditMemoLinesCollectionRequest) Get(ctx context.Context) ([]SalesCreditMemoLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesCreditMemoLine collection
func (r *CompanySalesCreditMemoLinesCollectionRequest) Add(ctx context.Context, reqObj *SalesCreditMemoLine) (resObj *SalesCreditMemoLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesCreditMemos returns request builder for SalesCreditMemo collection
func (b *CompanyRequestBuilder) SalesCreditMemos() *CompanySalesCreditMemosCollectionRequestBuilder {
	bb := &CompanySalesCreditMemosCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesCreditMemos"
	return bb
}

// CompanySalesCreditMemosCollectionRequestBuilder is request builder for SalesCreditMemo collection
type CompanySalesCreditMemosCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesCreditMemo collection
func (b *CompanySalesCreditMemosCollectionRequestBuilder) Request() *CompanySalesCreditMemosCollectionRequest {
	return &CompanySalesCreditMemosCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesCreditMemo item
func (b *CompanySalesCreditMemosCollectionRequestBuilder) ID(id string) *SalesCreditMemoRequestBuilder {
	bb := &SalesCreditMemoRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesCreditMemosCollectionRequest is request for SalesCreditMemo collection
type CompanySalesCreditMemosCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesCreditMemo collection
func (r *CompanySalesCreditMemosCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesCreditMemo, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesCreditMemo
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesCreditMemo
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesCreditMemo collection, max N pages
func (r *CompanySalesCreditMemosCollectionRequest) GetN(ctx context.Context, n int) ([]SalesCreditMemo, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesCreditMemo collection
func (r *CompanySalesCreditMemosCollectionRequest) Get(ctx context.Context) ([]SalesCreditMemo, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesCreditMemo collection
func (r *CompanySalesCreditMemosCollectionRequest) Add(ctx context.Context, reqObj *SalesCreditMemo) (resObj *SalesCreditMemo, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesInvoiceLines returns request builder for SalesInvoiceLine collection
func (b *CompanyRequestBuilder) SalesInvoiceLines() *CompanySalesInvoiceLinesCollectionRequestBuilder {
	bb := &CompanySalesInvoiceLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesInvoiceLines"
	return bb
}

// CompanySalesInvoiceLinesCollectionRequestBuilder is request builder for SalesInvoiceLine collection
type CompanySalesInvoiceLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesInvoiceLine collection
func (b *CompanySalesInvoiceLinesCollectionRequestBuilder) Request() *CompanySalesInvoiceLinesCollectionRequest {
	return &CompanySalesInvoiceLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesInvoiceLine item
func (b *CompanySalesInvoiceLinesCollectionRequestBuilder) ID(id string) *SalesInvoiceLineRequestBuilder {
	bb := &SalesInvoiceLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesInvoiceLinesCollectionRequest is request for SalesInvoiceLine collection
type CompanySalesInvoiceLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesInvoiceLine collection
func (r *CompanySalesInvoiceLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesInvoiceLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesInvoiceLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesInvoiceLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesInvoiceLine collection, max N pages
func (r *CompanySalesInvoiceLinesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesInvoiceLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesInvoiceLine collection
func (r *CompanySalesInvoiceLinesCollectionRequest) Get(ctx context.Context) ([]SalesInvoiceLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesInvoiceLine collection
func (r *CompanySalesInvoiceLinesCollectionRequest) Add(ctx context.Context, reqObj *SalesInvoiceLine) (resObj *SalesInvoiceLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesInvoices returns request builder for SalesInvoice collection
func (b *CompanyRequestBuilder) SalesInvoices() *CompanySalesInvoicesCollectionRequestBuilder {
	bb := &CompanySalesInvoicesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesInvoices"
	return bb
}

// CompanySalesInvoicesCollectionRequestBuilder is request builder for SalesInvoice collection
type CompanySalesInvoicesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesInvoice collection
func (b *CompanySalesInvoicesCollectionRequestBuilder) Request() *CompanySalesInvoicesCollectionRequest {
	return &CompanySalesInvoicesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesInvoice item
func (b *CompanySalesInvoicesCollectionRequestBuilder) ID(id string) *SalesInvoiceRequestBuilder {
	bb := &SalesInvoiceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesInvoicesCollectionRequest is request for SalesInvoice collection
type CompanySalesInvoicesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesInvoice collection
func (r *CompanySalesInvoicesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesInvoice, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesInvoice
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesInvoice
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesInvoice collection, max N pages
func (r *CompanySalesInvoicesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesInvoice, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesInvoice collection
func (r *CompanySalesInvoicesCollectionRequest) Get(ctx context.Context) ([]SalesInvoice, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesInvoice collection
func (r *CompanySalesInvoicesCollectionRequest) Add(ctx context.Context, reqObj *SalesInvoice) (resObj *SalesInvoice, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesOrderLines returns request builder for SalesOrderLine collection
func (b *CompanyRequestBuilder) SalesOrderLines() *CompanySalesOrderLinesCollectionRequestBuilder {
	bb := &CompanySalesOrderLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesOrderLines"
	return bb
}

// CompanySalesOrderLinesCollectionRequestBuilder is request builder for SalesOrderLine collection
type CompanySalesOrderLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesOrderLine collection
func (b *CompanySalesOrderLinesCollectionRequestBuilder) Request() *CompanySalesOrderLinesCollectionRequest {
	return &CompanySalesOrderLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesOrderLine item
func (b *CompanySalesOrderLinesCollectionRequestBuilder) ID(id string) *SalesOrderLineRequestBuilder {
	bb := &SalesOrderLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesOrderLinesCollectionRequest is request for SalesOrderLine collection
type CompanySalesOrderLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesOrderLine collection
func (r *CompanySalesOrderLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesOrderLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesOrderLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesOrderLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesOrderLine collection, max N pages
func (r *CompanySalesOrderLinesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesOrderLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesOrderLine collection
func (r *CompanySalesOrderLinesCollectionRequest) Get(ctx context.Context) ([]SalesOrderLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesOrderLine collection
func (r *CompanySalesOrderLinesCollectionRequest) Add(ctx context.Context, reqObj *SalesOrderLine) (resObj *SalesOrderLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesOrders returns request builder for SalesOrder collection
func (b *CompanyRequestBuilder) SalesOrders() *CompanySalesOrdersCollectionRequestBuilder {
	bb := &CompanySalesOrdersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesOrders"
	return bb
}

// CompanySalesOrdersCollectionRequestBuilder is request builder for SalesOrder collection
type CompanySalesOrdersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesOrder collection
func (b *CompanySalesOrdersCollectionRequestBuilder) Request() *CompanySalesOrdersCollectionRequest {
	return &CompanySalesOrdersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesOrder item
func (b *CompanySalesOrdersCollectionRequestBuilder) ID(id string) *SalesOrderRequestBuilder {
	bb := &SalesOrderRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesOrdersCollectionRequest is request for SalesOrder collection
type CompanySalesOrdersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesOrder collection
func (r *CompanySalesOrdersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesOrder, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesOrder
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesOrder
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesOrder collection, max N pages
func (r *CompanySalesOrdersCollectionRequest) GetN(ctx context.Context, n int) ([]SalesOrder, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesOrder collection
func (r *CompanySalesOrdersCollectionRequest) Get(ctx context.Context) ([]SalesOrder, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesOrder collection
func (r *CompanySalesOrdersCollectionRequest) Add(ctx context.Context, reqObj *SalesOrder) (resObj *SalesOrder, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesQuoteLines returns request builder for SalesQuoteLine collection
func (b *CompanyRequestBuilder) SalesQuoteLines() *CompanySalesQuoteLinesCollectionRequestBuilder {
	bb := &CompanySalesQuoteLinesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesQuoteLines"
	return bb
}

// CompanySalesQuoteLinesCollectionRequestBuilder is request builder for SalesQuoteLine collection
type CompanySalesQuoteLinesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesQuoteLine collection
func (b *CompanySalesQuoteLinesCollectionRequestBuilder) Request() *CompanySalesQuoteLinesCollectionRequest {
	return &CompanySalesQuoteLinesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesQuoteLine item
func (b *CompanySalesQuoteLinesCollectionRequestBuilder) ID(id string) *SalesQuoteLineRequestBuilder {
	bb := &SalesQuoteLineRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesQuoteLinesCollectionRequest is request for SalesQuoteLine collection
type CompanySalesQuoteLinesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesQuoteLine collection
func (r *CompanySalesQuoteLinesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesQuoteLine, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesQuoteLine
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesQuoteLine
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesQuoteLine collection, max N pages
func (r *CompanySalesQuoteLinesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesQuoteLine, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesQuoteLine collection
func (r *CompanySalesQuoteLinesCollectionRequest) Get(ctx context.Context) ([]SalesQuoteLine, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesQuoteLine collection
func (r *CompanySalesQuoteLinesCollectionRequest) Add(ctx context.Context, reqObj *SalesQuoteLine) (resObj *SalesQuoteLine, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SalesQuotes returns request builder for SalesQuote collection
func (b *CompanyRequestBuilder) SalesQuotes() *CompanySalesQuotesCollectionRequestBuilder {
	bb := &CompanySalesQuotesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/salesQuotes"
	return bb
}

// CompanySalesQuotesCollectionRequestBuilder is request builder for SalesQuote collection
type CompanySalesQuotesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SalesQuote collection
func (b *CompanySalesQuotesCollectionRequestBuilder) Request() *CompanySalesQuotesCollectionRequest {
	return &CompanySalesQuotesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SalesQuote item
func (b *CompanySalesQuotesCollectionRequestBuilder) ID(id string) *SalesQuoteRequestBuilder {
	bb := &SalesQuoteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanySalesQuotesCollectionRequest is request for SalesQuote collection
type CompanySalesQuotesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SalesQuote collection
func (r *CompanySalesQuotesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SalesQuote, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SalesQuote
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SalesQuote
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SalesQuote collection, max N pages
func (r *CompanySalesQuotesCollectionRequest) GetN(ctx context.Context, n int) ([]SalesQuote, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SalesQuote collection
func (r *CompanySalesQuotesCollectionRequest) Get(ctx context.Context) ([]SalesQuote, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SalesQuote collection
func (r *CompanySalesQuotesCollectionRequest) Add(ctx context.Context, reqObj *SalesQuote) (resObj *SalesQuote, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ShipmentMethods returns request builder for ShipmentMethod collection
func (b *CompanyRequestBuilder) ShipmentMethods() *CompanyShipmentMethodsCollectionRequestBuilder {
	bb := &CompanyShipmentMethodsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/shipmentMethods"
	return bb
}

// CompanyShipmentMethodsCollectionRequestBuilder is request builder for ShipmentMethod collection
type CompanyShipmentMethodsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ShipmentMethod collection
func (b *CompanyShipmentMethodsCollectionRequestBuilder) Request() *CompanyShipmentMethodsCollectionRequest {
	return &CompanyShipmentMethodsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ShipmentMethod item
func (b *CompanyShipmentMethodsCollectionRequestBuilder) ID(id string) *ShipmentMethodRequestBuilder {
	bb := &ShipmentMethodRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyShipmentMethodsCollectionRequest is request for ShipmentMethod collection
type CompanyShipmentMethodsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ShipmentMethod collection
func (r *CompanyShipmentMethodsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ShipmentMethod, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ShipmentMethod
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ShipmentMethod
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ShipmentMethod collection, max N pages
func (r *CompanyShipmentMethodsCollectionRequest) GetN(ctx context.Context, n int) ([]ShipmentMethod, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ShipmentMethod collection
func (r *CompanyShipmentMethodsCollectionRequest) Get(ctx context.Context) ([]ShipmentMethod, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ShipmentMethod collection
func (r *CompanyShipmentMethodsCollectionRequest) Add(ctx context.Context, reqObj *ShipmentMethod) (resObj *ShipmentMethod, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TaxAreas returns request builder for TaxArea collection
func (b *CompanyRequestBuilder) TaxAreas() *CompanyTaxAreasCollectionRequestBuilder {
	bb := &CompanyTaxAreasCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/taxAreas"
	return bb
}

// CompanyTaxAreasCollectionRequestBuilder is request builder for TaxArea collection
type CompanyTaxAreasCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for TaxArea collection
func (b *CompanyTaxAreasCollectionRequestBuilder) Request() *CompanyTaxAreasCollectionRequest {
	return &CompanyTaxAreasCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for TaxArea item
func (b *CompanyTaxAreasCollectionRequestBuilder) ID(id string) *TaxAreaRequestBuilder {
	bb := &TaxAreaRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyTaxAreasCollectionRequest is request for TaxArea collection
type CompanyTaxAreasCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for TaxArea collection
func (r *CompanyTaxAreasCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]TaxArea, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []TaxArea
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []TaxArea
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for TaxArea collection, max N pages
func (r *CompanyTaxAreasCollectionRequest) GetN(ctx context.Context, n int) ([]TaxArea, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for TaxArea collection
func (r *CompanyTaxAreasCollectionRequest) Get(ctx context.Context) ([]TaxArea, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for TaxArea collection
func (r *CompanyTaxAreasCollectionRequest) Add(ctx context.Context, reqObj *TaxArea) (resObj *TaxArea, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TaxGroups returns request builder for TaxGroup collection
func (b *CompanyRequestBuilder) TaxGroups() *CompanyTaxGroupsCollectionRequestBuilder {
	bb := &CompanyTaxGroupsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/taxGroups"
	return bb
}

// CompanyTaxGroupsCollectionRequestBuilder is request builder for TaxGroup collection
type CompanyTaxGroupsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for TaxGroup collection
func (b *CompanyTaxGroupsCollectionRequestBuilder) Request() *CompanyTaxGroupsCollectionRequest {
	return &CompanyTaxGroupsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for TaxGroup item
func (b *CompanyTaxGroupsCollectionRequestBuilder) ID(id string) *TaxGroupRequestBuilder {
	bb := &TaxGroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyTaxGroupsCollectionRequest is request for TaxGroup collection
type CompanyTaxGroupsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for TaxGroup collection
func (r *CompanyTaxGroupsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]TaxGroup, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []TaxGroup
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []TaxGroup
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for TaxGroup collection, max N pages
func (r *CompanyTaxGroupsCollectionRequest) GetN(ctx context.Context, n int) ([]TaxGroup, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for TaxGroup collection
func (r *CompanyTaxGroupsCollectionRequest) Get(ctx context.Context) ([]TaxGroup, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for TaxGroup collection
func (r *CompanyTaxGroupsCollectionRequest) Add(ctx context.Context, reqObj *TaxGroup) (resObj *TaxGroup, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// UnitsOfMeasure returns request builder for UnitOfMeasure collection
func (b *CompanyRequestBuilder) UnitsOfMeasure() *CompanyUnitsOfMeasureCollectionRequestBuilder {
	bb := &CompanyUnitsOfMeasureCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/unitsOfMeasure"
	return bb
}

// CompanyUnitsOfMeasureCollectionRequestBuilder is request builder for UnitOfMeasure collection
type CompanyUnitsOfMeasureCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UnitOfMeasure collection
func (b *CompanyUnitsOfMeasureCollectionRequestBuilder) Request() *CompanyUnitsOfMeasureCollectionRequest {
	return &CompanyUnitsOfMeasureCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UnitOfMeasure item
func (b *CompanyUnitsOfMeasureCollectionRequestBuilder) ID(id string) *UnitOfMeasureRequestBuilder {
	bb := &UnitOfMeasureRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyUnitsOfMeasureCollectionRequest is request for UnitOfMeasure collection
type CompanyUnitsOfMeasureCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UnitOfMeasure collection
func (r *CompanyUnitsOfMeasureCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UnitOfMeasure, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UnitOfMeasure
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UnitOfMeasure
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UnitOfMeasure collection, max N pages
func (r *CompanyUnitsOfMeasureCollectionRequest) GetN(ctx context.Context, n int) ([]UnitOfMeasure, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UnitOfMeasure collection
func (r *CompanyUnitsOfMeasureCollectionRequest) Get(ctx context.Context) ([]UnitOfMeasure, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UnitOfMeasure collection
func (r *CompanyUnitsOfMeasureCollectionRequest) Add(ctx context.Context, reqObj *UnitOfMeasure) (resObj *UnitOfMeasure, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Vendors returns request builder for Vendor collection
func (b *CompanyRequestBuilder) Vendors() *CompanyVendorsCollectionRequestBuilder {
	bb := &CompanyVendorsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/vendors"
	return bb
}

// CompanyVendorsCollectionRequestBuilder is request builder for Vendor collection
type CompanyVendorsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Vendor collection
func (b *CompanyVendorsCollectionRequestBuilder) Request() *CompanyVendorsCollectionRequest {
	return &CompanyVendorsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Vendor item
func (b *CompanyVendorsCollectionRequestBuilder) ID(id string) *VendorRequestBuilder {
	bb := &VendorRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// CompanyVendorsCollectionRequest is request for Vendor collection
type CompanyVendorsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Vendor collection
func (r *CompanyVendorsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Vendor, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Vendor
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Vendor
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Vendor collection, max N pages
func (r *CompanyVendorsCollectionRequest) GetN(ctx context.Context, n int) ([]Vendor, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Vendor collection
func (r *CompanyVendorsCollectionRequest) Get(ctx context.Context) ([]Vendor, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Vendor collection
func (r *CompanyVendorsCollectionRequest) Add(ctx context.Context, reqObj *Vendor) (resObj *Vendor, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
