// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// Device undocumented
type Device struct {
	// DirectoryObject is the base model of Device
	DirectoryObject
	// AccountEnabled undocumented
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// AlternativeSecurityIDs undocumented
	AlternativeSecurityIDs []AlternativeSecurityID `json:"alternativeSecurityIds,omitempty"`
	// ApproximateLastSignInDateTime undocumented
	ApproximateLastSignInDateTime *time.Time `json:"approximateLastSignInDateTime,omitempty"`
	// ComplianceExpirationDateTime undocumented
	ComplianceExpirationDateTime *time.Time `json:"complianceExpirationDateTime,omitempty"`
	// DeviceID undocumented
	DeviceID *string `json:"deviceId,omitempty"`
	// DeviceMetadata undocumented
	DeviceMetadata *string `json:"deviceMetadata,omitempty"`
	// DeviceVersion undocumented
	DeviceVersion *int `json:"deviceVersion,omitempty"`
	// DisplayName undocumented
	DisplayName *string `json:"displayName,omitempty"`
	// IsCompliant undocumented
	IsCompliant *bool `json:"isCompliant,omitempty"`
	// IsManaged undocumented
	IsManaged *bool `json:"isManaged,omitempty"`
	// OnPremisesLastSyncDateTime undocumented
	OnPremisesLastSyncDateTime *time.Time `json:"onPremisesLastSyncDateTime,omitempty"`
	// OnPremisesSyncEnabled undocumented
	OnPremisesSyncEnabled *bool `json:"onPremisesSyncEnabled,omitempty"`
	// OperatingSystem undocumented
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// OperatingSystemVersion undocumented
	OperatingSystemVersion *string `json:"operatingSystemVersion,omitempty"`
	// PhysicalIDs undocumented
	PhysicalIDs []string `json:"physicalIds,omitempty"`
	// ProfileType undocumented
	ProfileType *string `json:"profileType,omitempty"`
	// SystemLabels undocumented
	SystemLabels []string `json:"systemLabels,omitempty"`
	// TrustType undocumented
	TrustType *string `json:"trustType,omitempty"`
	// Name undocumented
	Name *string `json:"Name,omitempty"`
	// Manufacturer undocumented
	Manufacturer *string `json:"Manufacturer,omitempty"`
	// Model undocumented
	Model *string `json:"Model,omitempty"`
	// Kind undocumented
	Kind *string `json:"Kind,omitempty"`
	// Status undocumented
	Status *string `json:"Status,omitempty"`
	// Platform undocumented
	Platform *string `json:"Platform,omitempty"`
	// MemberOf undocumented
	MemberOf []DirectoryObject `json:"memberOf,omitempty"`
	// RegisteredOwners undocumented
	RegisteredOwners []DirectoryObject `json:"registeredOwners,omitempty"`
	// RegisteredUsers undocumented
	RegisteredUsers []DirectoryObject `json:"registeredUsers,omitempty"`
	// TransitiveMemberOf undocumented
	TransitiveMemberOf []DirectoryObject `json:"transitiveMemberOf,omitempty"`
	// Extensions undocumented
	Extensions []Extension `json:"extensions,omitempty"`
	// Commands undocumented
	Commands []Command `json:"commands,omitempty"`
}

// DeviceActionResult undocumented
type DeviceActionResult struct {
	// Object is the base model of DeviceActionResult
	Object
	// ActionName Action name
	ActionName *string `json:"actionName,omitempty"`
	// ActionState State of the action
	ActionState *ActionState `json:"actionState,omitempty"`
	// StartDateTime Time the action was initiated
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// LastUpdatedDateTime Time the action state was last updated
	LastUpdatedDateTime *time.Time `json:"lastUpdatedDateTime,omitempty"`
}

// DeviceAndAppManagementAssignedRoleDetails undocumented
type DeviceAndAppManagementAssignedRoleDetails struct {
	// Object is the base model of DeviceAndAppManagementAssignedRoleDetails
	Object
	// RoleDefinitionIDs Role Definition IDs for the specifc Role Definitions assigned to a user.
	RoleDefinitionIDs []string `json:"roleDefinitionIds,omitempty"`
	// RoleAssignmentIDs Role Assignment IDs for the specifc Role Assignments assigned to a user.
	RoleAssignmentIDs []string `json:"roleAssignmentIds,omitempty"`
}

// DeviceAndAppManagementAssignmentTarget undocumented
type DeviceAndAppManagementAssignmentTarget struct {
	// Object is the base model of DeviceAndAppManagementAssignmentTarget
	Object
}

// DeviceAndAppManagementData undocumented
type DeviceAndAppManagementData struct {
	// Object is the base model of DeviceAndAppManagementData
	Object
	// Content undocumented
	Content *Stream `json:"content,omitempty"`
}

// DeviceAndAppManagementRoleAssignment The Role Assignment resource. Role assignments tie together a role definition with members and scopes. There can be one or more role assignments per role. This applies to custom and built-in roles.
type DeviceAndAppManagementRoleAssignment struct {
	// RoleAssignment is the base model of DeviceAndAppManagementRoleAssignment
	RoleAssignment
	// Members The list of ids of role member security groups. These are IDs from Azure Active Directory.
	Members []string `json:"members,omitempty"`
	// RoleScopeTags undocumented
	RoleScopeTags []RoleScopeTag `json:"roleScopeTags,omitempty"`
}

// DeviceAndAppManagementRoleDefinition The Role Definition resource. The role definition is the foundation of role based access in Intune. The role combines an Intune resource such as a Mobile App and associated role permissions such as Create or Read for the resource. There are two types of roles, built-in and custom. Built-in roles cannot be modified. Both built-in roles and custom roles must have assignments to be enforced. Create custom roles if you want to define a role that allows any of the available resources and role permissions to be combined into a single role.
type DeviceAndAppManagementRoleDefinition struct {
	// RoleDefinition is the base model of DeviceAndAppManagementRoleDefinition
	RoleDefinition
}

// DeviceAppManagement Singleton entity that acts as a container for all device and app management functionality.
type DeviceAppManagement struct {
	// Entity is the base model of DeviceAppManagement
	Entity
	// MicrosoftStoreForBusinessLastSuccessfulSyncDateTime The last time the apps from the Microsoft Store for Business were synced successfully for the account.
	MicrosoftStoreForBusinessLastSuccessfulSyncDateTime *time.Time `json:"microsoftStoreForBusinessLastSuccessfulSyncDateTime,omitempty"`
	// IsEnabledForMicrosoftStoreForBusiness Whether the account is enabled for syncing applications from the Microsoft Store for Business.
	IsEnabledForMicrosoftStoreForBusiness *bool `json:"isEnabledForMicrosoftStoreForBusiness,omitempty"`
	// MicrosoftStoreForBusinessLanguage The locale information used to sync applications from the Microsoft Store for Business. Cultures that are specific to a country/region. The names of these cultures follow RFC 4646 (Windows Vista and later). The format is <languagecode2>-<country/regioncode2>, where <languagecode2> is a lowercase two-letter code derived from ISO 639-1 and <country/regioncode2> is an uppercase two-letter code derived from ISO 3166. For example, en-US for English (United States) is a specific culture.
	MicrosoftStoreForBusinessLanguage *string `json:"microsoftStoreForBusinessLanguage,omitempty"`
	// MicrosoftStoreForBusinessLastCompletedApplicationSyncTime The last time an application sync from the Microsoft Store for Business was completed.
	MicrosoftStoreForBusinessLastCompletedApplicationSyncTime *time.Time `json:"microsoftStoreForBusinessLastCompletedApplicationSyncTime,omitempty"`
	// MicrosoftStoreForBusinessPortalSelection The end user portal information is used to sync applications from the Microsoft Store for Business to Intune Company Portal. There are three options to pick from ['Company portal only', 'Company portal and private store', 'Private store only']
	MicrosoftStoreForBusinessPortalSelection *MicrosoftStoreForBusinessPortalSelectionOptions `json:"microsoftStoreForBusinessPortalSelection,omitempty"`
	// ManagedEBooks undocumented
	ManagedEBooks []ManagedEBook `json:"managedEBooks,omitempty"`
	// MobileApps undocumented
	MobileApps []MobileApp `json:"mobileApps,omitempty"`
	// MobileAppCategories undocumented
	MobileAppCategories []MobileAppCategory `json:"mobileAppCategories,omitempty"`
	// EnterpriseCodeSigningCertificates undocumented
	EnterpriseCodeSigningCertificates []EnterpriseCodeSigningCertificate `json:"enterpriseCodeSigningCertificates,omitempty"`
	// IOSLobAppProvisioningConfigurations undocumented
	IOSLobAppProvisioningConfigurations []IOSLobAppProvisioningConfiguration `json:"iosLobAppProvisioningConfigurations,omitempty"`
	// SymantecCodeSigningCertificate undocumented
	SymantecCodeSigningCertificate *SymantecCodeSigningCertificate `json:"symantecCodeSigningCertificate,omitempty"`
	// MobileAppConfigurations undocumented
	MobileAppConfigurations []ManagedDeviceMobileAppConfiguration `json:"mobileAppConfigurations,omitempty"`
	// ManagedEBookCategories undocumented
	ManagedEBookCategories []ManagedEBookCategory `json:"managedEBookCategories,omitempty"`
	// PolicySets undocumented
	PolicySets []PolicySet `json:"policySets,omitempty"`
	// SideLoadingKeys undocumented
	SideLoadingKeys []SideLoadingKey `json:"sideLoadingKeys,omitempty"`
	// VPPTokens undocumented
	VPPTokens []VPPToken `json:"vppTokens,omitempty"`
	// WindowsManagementApp undocumented
	WindowsManagementApp *WindowsManagementApp `json:"windowsManagementApp,omitempty"`
	// ManagedAppPolicies undocumented
	ManagedAppPolicies []ManagedAppPolicy `json:"managedAppPolicies,omitempty"`
	// IOSManagedAppProtections undocumented
	IOSManagedAppProtections []IOSManagedAppProtection `json:"iosManagedAppProtections,omitempty"`
	// AndroidManagedAppProtections undocumented
	AndroidManagedAppProtections []AndroidManagedAppProtection `json:"androidManagedAppProtections,omitempty"`
	// DefaultManagedAppProtections undocumented
	DefaultManagedAppProtections []DefaultManagedAppProtection `json:"defaultManagedAppProtections,omitempty"`
	// TargetedManagedAppConfigurations undocumented
	TargetedManagedAppConfigurations []TargetedManagedAppConfiguration `json:"targetedManagedAppConfigurations,omitempty"`
	// MDMWindowsInformationProtectionPolicies undocumented
	MDMWindowsInformationProtectionPolicies []MDMWindowsInformationProtectionPolicy `json:"mdmWindowsInformationProtectionPolicies,omitempty"`
	// WindowsInformationProtectionPolicies undocumented
	WindowsInformationProtectionPolicies []WindowsInformationProtectionPolicy `json:"windowsInformationProtectionPolicies,omitempty"`
	// ManagedAppRegistrations undocumented
	ManagedAppRegistrations []ManagedAppRegistration `json:"managedAppRegistrations,omitempty"`
	// ManagedAppStatuses undocumented
	ManagedAppStatuses []ManagedAppStatus `json:"managedAppStatuses,omitempty"`
	// WindowsInformationProtectionDeviceRegistrations undocumented
	WindowsInformationProtectionDeviceRegistrations []WindowsInformationProtectionDeviceRegistration `json:"windowsInformationProtectionDeviceRegistrations,omitempty"`
	// WindowsInformationProtectionWipeActions undocumented
	WindowsInformationProtectionWipeActions []WindowsInformationProtectionWipeAction `json:"windowsInformationProtectionWipeActions,omitempty"`
	// DeviceAppManagementTasks undocumented
	DeviceAppManagementTasks []DeviceAppManagementTask `json:"deviceAppManagementTasks,omitempty"`
	// WdacSupplementalPolicies undocumented
	WdacSupplementalPolicies []WindowsDefenderApplicationControlSupplementalPolicy `json:"wdacSupplementalPolicies,omitempty"`
}

// DeviceAppManagementTask A device app management task.
type DeviceAppManagementTask struct {
	// Entity is the base model of DeviceAppManagementTask
	Entity
	// DisplayName The name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description The description.
	Description *string `json:"description,omitempty"`
	// CreatedDateTime The created date.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// DueDateTime The due date.
	DueDateTime *time.Time `json:"dueDateTime,omitempty"`
	// Category The category.
	Category *DeviceAppManagementTaskCategory `json:"category,omitempty"`
	// Priority The priority.
	Priority *DeviceAppManagementTaskPriority `json:"priority,omitempty"`
	// Creator The email address of the creator.
	Creator *string `json:"creator,omitempty"`
	// CreatorNotes Notes from the creator.
	CreatorNotes *string `json:"creatorNotes,omitempty"`
	// AssignedTo The name or email of the admin this task is assigned to.
	AssignedTo *string `json:"assignedTo,omitempty"`
	// Status The status.
	Status *DeviceAppManagementTaskStatus `json:"status,omitempty"`
}

// DeviceCategory Device categories provides a way to organize your devices. Using device categories, company administrators can define their own categories that make sense to their company. These categories can then be applied to a device in the Intune Azure console or selected by a user during device enrollment. You can filter reports and create dynamic Azure Active Directory device groups based on device categories.
type DeviceCategory struct {
	// Entity is the base model of DeviceCategory
	Entity
	// DisplayName Display name for the device category.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Optional description for the device category.
	Description *string `json:"description,omitempty"`
	// RoleScopeTagIDs Optional role scope tags for the device category.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
}

// DeviceComplianceActionItem Scheduled Action Configuration
type DeviceComplianceActionItem struct {
	// Entity is the base model of DeviceComplianceActionItem
	Entity
	// GracePeriodHours Number of hours to wait till the action will be enforced. Valid values 0 to 8760
	GracePeriodHours *int `json:"gracePeriodHours,omitempty"`
	// ActionType What action to take
	ActionType *DeviceComplianceActionType `json:"actionType,omitempty"`
	// NotificationTemplateID What notification Message template to use
	NotificationTemplateID *string `json:"notificationTemplateId,omitempty"`
	// NotificationMessageCCList A list of group IDs to speicify who to CC this notification message to.
	NotificationMessageCCList []string `json:"notificationMessageCCList,omitempty"`
}

// DeviceComplianceDeviceOverview undocumented
type DeviceComplianceDeviceOverview struct {
	// Entity is the base model of DeviceComplianceDeviceOverview
	Entity
	// PendingCount Number of pending devices
	PendingCount *int `json:"pendingCount,omitempty"`
	// NotApplicableCount Number of not applicable devices
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// NotApplicablePlatformCount Number of not applicable devices due to mismatch platform and policy
	NotApplicablePlatformCount *int `json:"notApplicablePlatformCount,omitempty"`
	// SuccessCount Number of succeeded devices
	SuccessCount *int `json:"successCount,omitempty"`
	// ErrorCount Number of error devices
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed devices
	FailedCount *int `json:"failedCount,omitempty"`
	// ConflictCount Number of devices in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// LastUpdateDateTime Last update time
	LastUpdateDateTime *time.Time `json:"lastUpdateDateTime,omitempty"`
	// ConfigurationVersion Version of the policy for that overview
	ConfigurationVersion *int `json:"configurationVersion,omitempty"`
}

// DeviceComplianceDeviceStatus undocumented
type DeviceComplianceDeviceStatus struct {
	// Entity is the base model of DeviceComplianceDeviceStatus
	Entity
	// DeviceDisplayName Device name of the DevicePolicyStatus.
	DeviceDisplayName *string `json:"deviceDisplayName,omitempty"`
	// UserName The User Name that is being reported
	UserName *string `json:"userName,omitempty"`
	// DeviceModel The device model that is being reported
	DeviceModel *string `json:"deviceModel,omitempty"`
	// Platform Platform of the device that is being reported
	Platform *int `json:"platform,omitempty"`
	// ComplianceGracePeriodExpirationDateTime The DateTime when device compliance grace period expires
	ComplianceGracePeriodExpirationDateTime *time.Time `json:"complianceGracePeriodExpirationDateTime,omitempty"`
	// Status Compliance status of the policy report.
	Status *ComplianceStatus `json:"status,omitempty"`
	// LastReportedDateTime Last modified date time of the policy report.
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceCompliancePolicy This is the base class for Compliance policy. Compliance policies are platform specific and individual per-platform compliance policies inherit from here.
type DeviceCompliancePolicy struct {
	// Entity is the base model of DeviceCompliancePolicy
	Entity
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// CreatedDateTime DateTime the object was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// Description Admin provided description of the Device Configuration.
	Description *string `json:"description,omitempty"`
	// LastModifiedDateTime DateTime the object was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// DisplayName Admin provided name of the device configuration.
	DisplayName *string `json:"displayName,omitempty"`
	// Version Version of the device configuration.
	Version *int `json:"version,omitempty"`
	// ScheduledActionsForRule undocumented
	ScheduledActionsForRule []DeviceComplianceScheduledActionForRule `json:"scheduledActionsForRule,omitempty"`
	// DeviceStatuses undocumented
	DeviceStatuses []DeviceComplianceDeviceStatus `json:"deviceStatuses,omitempty"`
	// UserStatuses undocumented
	UserStatuses []DeviceComplianceUserStatus `json:"userStatuses,omitempty"`
	// DeviceStatusOverview undocumented
	DeviceStatusOverview *DeviceComplianceDeviceOverview `json:"deviceStatusOverview,omitempty"`
	// UserStatusOverview undocumented
	UserStatusOverview *DeviceComplianceUserOverview `json:"userStatusOverview,omitempty"`
	// DeviceSettingStateSummaries undocumented
	DeviceSettingStateSummaries []SettingStateDeviceSummary `json:"deviceSettingStateSummaries,omitempty"`
	// Assignments undocumented
	Assignments []DeviceCompliancePolicyAssignment `json:"assignments,omitempty"`
}

// DeviceCompliancePolicyAssignment Device compliance policy assignment.
type DeviceCompliancePolicyAssignment struct {
	// Entity is the base model of DeviceCompliancePolicyAssignment
	Entity
	// Target Target for the compliance policy assignment.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
	// Source The assignment source for the device compliance policy, direct or parcel/policySet.
	Source *DeviceAndAppManagementAssignmentSource `json:"source,omitempty"`
	// SourceID The identifier of the source of the assignment.
	SourceID *string `json:"sourceId,omitempty"`
}

// DeviceCompliancePolicyDeviceStateSummary undocumented
type DeviceCompliancePolicyDeviceStateSummary struct {
	// Entity is the base model of DeviceCompliancePolicyDeviceStateSummary
	Entity
	// InGracePeriodCount Number of devices that are in grace period
	InGracePeriodCount *int `json:"inGracePeriodCount,omitempty"`
	// ConfigManagerCount Number of devices that have compliance managed by System Center Configuration Manager
	ConfigManagerCount *int `json:"configManagerCount,omitempty"`
	// UnknownDeviceCount Number of unknown devices
	UnknownDeviceCount *int `json:"unknownDeviceCount,omitempty"`
	// NotApplicableDeviceCount Number of not applicable devices
	NotApplicableDeviceCount *int `json:"notApplicableDeviceCount,omitempty"`
	// CompliantDeviceCount Number of compliant devices
	CompliantDeviceCount *int `json:"compliantDeviceCount,omitempty"`
	// RemediatedDeviceCount Number of remediated devices
	RemediatedDeviceCount *int `json:"remediatedDeviceCount,omitempty"`
	// NonCompliantDeviceCount Number of NonCompliant devices
	NonCompliantDeviceCount *int `json:"nonCompliantDeviceCount,omitempty"`
	// ErrorDeviceCount Number of error devices
	ErrorDeviceCount *int `json:"errorDeviceCount,omitempty"`
	// ConflictDeviceCount Number of conflict devices
	ConflictDeviceCount *int `json:"conflictDeviceCount,omitempty"`
}

// DeviceCompliancePolicyGroupAssignment Device compliance policy group assignment.
type DeviceCompliancePolicyGroupAssignment struct {
	// Entity is the base model of DeviceCompliancePolicyGroupAssignment
	Entity
	// TargetGroupID The Id of the AAD group we are targeting the device compliance policy to.
	TargetGroupID *string `json:"targetGroupId,omitempty"`
	// ExcludeGroup Indicates if this group is should be excluded. Defaults that the group should be included
	ExcludeGroup *bool `json:"excludeGroup,omitempty"`
	// DeviceCompliancePolicy undocumented
	DeviceCompliancePolicy *DeviceCompliancePolicy `json:"deviceCompliancePolicy,omitempty"`
}

// DeviceCompliancePolicyPolicySetItem A class containing the properties used for device compliance policy PolicySetItem.
type DeviceCompliancePolicyPolicySetItem struct {
	// PolicySetItem is the base model of DeviceCompliancePolicyPolicySetItem
	PolicySetItem
}

// DeviceCompliancePolicySettingState undocumented
type DeviceCompliancePolicySettingState struct {
	// Object is the base model of DeviceCompliancePolicySettingState
	Object
	// Setting The setting that is being reported
	Setting *string `json:"setting,omitempty"`
	// SettingName Localized/user friendly setting name that is being reported
	SettingName *string `json:"settingName,omitempty"`
	// InstanceDisplayName Name of setting instance that is being reported.
	InstanceDisplayName *string `json:"instanceDisplayName,omitempty"`
	// State The compliance state of the setting
	State *ComplianceStatus `json:"state,omitempty"`
	// ErrorCode Error code for the setting
	ErrorCode *int `json:"errorCode,omitempty"`
	// ErrorDescription Error description
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// UserID UserId
	UserID *string `json:"userId,omitempty"`
	// UserName UserName
	UserName *string `json:"userName,omitempty"`
	// UserEmail UserEmail
	UserEmail *string `json:"userEmail,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// Sources Contributing policies
	Sources []SettingSource `json:"sources,omitempty"`
	// CurrentValue Current value of setting on device
	CurrentValue *string `json:"currentValue,omitempty"`
}

// DeviceCompliancePolicySettingStateSummary Device Compilance Policy Setting State summary across the account.
type DeviceCompliancePolicySettingStateSummary struct {
	// Entity is the base model of DeviceCompliancePolicySettingStateSummary
	Entity
	// Setting The setting class name and property name.
	Setting *string `json:"setting,omitempty"`
	// SettingName Name of the setting.
	SettingName *string `json:"settingName,omitempty"`
	// PlatformType Setting platform
	PlatformType *PolicyPlatformType `json:"platformType,omitempty"`
	// UnknownDeviceCount Number of unknown devices
	UnknownDeviceCount *int `json:"unknownDeviceCount,omitempty"`
	// NotApplicableDeviceCount Number of not applicable devices
	NotApplicableDeviceCount *int `json:"notApplicableDeviceCount,omitempty"`
	// CompliantDeviceCount Number of compliant devices
	CompliantDeviceCount *int `json:"compliantDeviceCount,omitempty"`
	// RemediatedDeviceCount Number of remediated devices
	RemediatedDeviceCount *int `json:"remediatedDeviceCount,omitempty"`
	// NonCompliantDeviceCount Number of NonCompliant devices
	NonCompliantDeviceCount *int `json:"nonCompliantDeviceCount,omitempty"`
	// ErrorDeviceCount Number of error devices
	ErrorDeviceCount *int `json:"errorDeviceCount,omitempty"`
	// ConflictDeviceCount Number of conflict devices
	ConflictDeviceCount *int `json:"conflictDeviceCount,omitempty"`
	// DeviceComplianceSettingStates undocumented
	DeviceComplianceSettingStates []DeviceComplianceSettingState `json:"deviceComplianceSettingStates,omitempty"`
}

// DeviceCompliancePolicyState Device Compliance Policy State for a given device.
type DeviceCompliancePolicyState struct {
	// Entity is the base model of DeviceCompliancePolicyState
	Entity
	// SettingStates undocumented
	SettingStates []DeviceCompliancePolicySettingState `json:"settingStates,omitempty"`
	// DisplayName The name of the policy for this policyBase
	DisplayName *string `json:"displayName,omitempty"`
	// Version The version of the policy
	Version *int `json:"version,omitempty"`
	// PlatformType Platform type that the policy applies to
	PlatformType *PolicyPlatformType `json:"platformType,omitempty"`
	// State The compliance state of the policy
	State *ComplianceStatus `json:"state,omitempty"`
	// SettingCount Count of how many setting a policy holds
	SettingCount *int `json:"settingCount,omitempty"`
	// UserID User unique identifier, must be Guid
	UserID *string `json:"userId,omitempty"`
	// UserPrincipalName User Principal Name
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceComplianceScheduledActionForRule Scheduled Action for Rule
type DeviceComplianceScheduledActionForRule struct {
	// Entity is the base model of DeviceComplianceScheduledActionForRule
	Entity
	// RuleName Name of the rule which this scheduled action applies to.
	RuleName *string `json:"ruleName,omitempty"`
	// ScheduledActionConfigurations undocumented
	ScheduledActionConfigurations []DeviceComplianceActionItem `json:"scheduledActionConfigurations,omitempty"`
}

// DeviceComplianceSettingState Device compliance setting State for a given device.
type DeviceComplianceSettingState struct {
	// Entity is the base model of DeviceComplianceSettingState
	Entity
	// PlatformType Device platform type
	PlatformType *DeviceType `json:"platformType,omitempty"`
	// Setting The setting class name and property name.
	Setting *string `json:"setting,omitempty"`
	// SettingName The Setting Name that is being reported
	SettingName *string `json:"settingName,omitempty"`
	// DeviceID The Device Id that is being reported
	DeviceID *string `json:"deviceId,omitempty"`
	// DeviceName The Device Name that is being reported
	DeviceName *string `json:"deviceName,omitempty"`
	// UserID The user Id that is being reported
	UserID *string `json:"userId,omitempty"`
	// UserEmail The User email address that is being reported
	UserEmail *string `json:"userEmail,omitempty"`
	// UserName The User Name that is being reported
	UserName *string `json:"userName,omitempty"`
	// UserPrincipalName The User PrincipalName that is being reported
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// DeviceModel The device model that is being reported
	DeviceModel *string `json:"deviceModel,omitempty"`
	// State The compliance state of the setting
	State *ComplianceStatus `json:"state,omitempty"`
	// ComplianceGracePeriodExpirationDateTime The DateTime when device compliance grace period expires
	ComplianceGracePeriodExpirationDateTime *time.Time `json:"complianceGracePeriodExpirationDateTime,omitempty"`
}

// DeviceComplianceUserOverview undocumented
type DeviceComplianceUserOverview struct {
	// Entity is the base model of DeviceComplianceUserOverview
	Entity
	// PendingCount Number of pending Users
	PendingCount *int `json:"pendingCount,omitempty"`
	// NotApplicableCount Number of not applicable users
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// SuccessCount Number of succeeded Users
	SuccessCount *int `json:"successCount,omitempty"`
	// ErrorCount Number of error Users
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed Users
	FailedCount *int `json:"failedCount,omitempty"`
	// ConflictCount Number of users in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// LastUpdateDateTime Last update time
	LastUpdateDateTime *time.Time `json:"lastUpdateDateTime,omitempty"`
	// ConfigurationVersion Version of the policy for that overview
	ConfigurationVersion *int `json:"configurationVersion,omitempty"`
}

// DeviceComplianceUserStatus undocumented
type DeviceComplianceUserStatus struct {
	// Entity is the base model of DeviceComplianceUserStatus
	Entity
	// UserDisplayName User name of the DevicePolicyStatus.
	UserDisplayName *string `json:"userDisplayName,omitempty"`
	// DevicesCount Devices count for that user.
	DevicesCount *int `json:"devicesCount,omitempty"`
	// Status Compliance status of the policy report.
	Status *ComplianceStatus `json:"status,omitempty"`
	// LastReportedDateTime Last modified date time of the policy report.
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceConfiguration Device Configuration.
type DeviceConfiguration struct {
	// Entity is the base model of DeviceConfiguration
	Entity
	// LastModifiedDateTime DateTime the object was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// SupportsScopeTags Indicates whether or not the underlying Device Configuration supports the assignment of scope tags. Assigning to the ScopeTags property is not allowed when this value is false and entities will not be visible to scoped users. This occurs for Legacy policies created in Silverlight and can be resolved by deleting and recreating the policy in the Azure Portal. This property is read-only.
	SupportsScopeTags *bool `json:"supportsScopeTags,omitempty"`
	// DeviceManagementApplicabilityRuleOsEdition The OS edition applicability for this Policy.
	DeviceManagementApplicabilityRuleOsEdition *DeviceManagementApplicabilityRuleOsEdition `json:"deviceManagementApplicabilityRuleOsEdition,omitempty"`
	// DeviceManagementApplicabilityRuleOsVersion The OS version applicability rule for this Policy.
	DeviceManagementApplicabilityRuleOsVersion *DeviceManagementApplicabilityRuleOsVersion `json:"deviceManagementApplicabilityRuleOsVersion,omitempty"`
	// DeviceManagementApplicabilityRuleDeviceMode The device mode applicability rule for this Policy.
	DeviceManagementApplicabilityRuleDeviceMode *DeviceManagementApplicabilityRuleDeviceMode `json:"deviceManagementApplicabilityRuleDeviceMode,omitempty"`
	// CreatedDateTime DateTime the object was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// Description Admin provided description of the Device Configuration.
	Description *string `json:"description,omitempty"`
	// DisplayName Admin provided name of the device configuration.
	DisplayName *string `json:"displayName,omitempty"`
	// Version Version of the device configuration.
	Version *int `json:"version,omitempty"`
	// GroupAssignments undocumented
	GroupAssignments []DeviceConfigurationGroupAssignment `json:"groupAssignments,omitempty"`
	// Assignments undocumented
	Assignments []DeviceConfigurationAssignment `json:"assignments,omitempty"`
	// DeviceStatuses undocumented
	DeviceStatuses []DeviceConfigurationDeviceStatus `json:"deviceStatuses,omitempty"`
	// UserStatuses undocumented
	UserStatuses []DeviceConfigurationUserStatus `json:"userStatuses,omitempty"`
	// DeviceStatusOverview undocumented
	DeviceStatusOverview *DeviceConfigurationDeviceOverview `json:"deviceStatusOverview,omitempty"`
	// UserStatusOverview undocumented
	UserStatusOverview *DeviceConfigurationUserOverview `json:"userStatusOverview,omitempty"`
	// DeviceSettingStateSummaries undocumented
	DeviceSettingStateSummaries []SettingStateDeviceSummary `json:"deviceSettingStateSummaries,omitempty"`
}

// DeviceConfigurationAssignment The device configuration assignment entity assigns an AAD group to a specific device configuration.
type DeviceConfigurationAssignment struct {
	// Entity is the base model of DeviceConfigurationAssignment
	Entity
	// Target The assignment target for the device configuration.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
	// Source The assignment source for the device configuration, direct or parcel/policySet. This property is read-only.
	Source *DeviceAndAppManagementAssignmentSource `json:"source,omitempty"`
	// SourceID The identifier of the source of the assignment. This property is read-only.
	SourceID *string `json:"sourceId,omitempty"`
}

// DeviceConfigurationConflictSummary Conflict summary for a set of device configuration policies.
type DeviceConfigurationConflictSummary struct {
	// Entity is the base model of DeviceConfigurationConflictSummary
	Entity
	// ConflictingDeviceConfigurations The set of policies in conflict with the given setting
	ConflictingDeviceConfigurations []SettingSource `json:"conflictingDeviceConfigurations,omitempty"`
	// ContributingSettings The set of settings in conflict with the given policies
	ContributingSettings []string `json:"contributingSettings,omitempty"`
	// DeviceCheckinsImpacted The count of checkins impacted by the conflicting policies and settings
	DeviceCheckinsImpacted *int `json:"deviceCheckinsImpacted,omitempty"`
}

// DeviceConfigurationDeviceOverview undocumented
type DeviceConfigurationDeviceOverview struct {
	// Entity is the base model of DeviceConfigurationDeviceOverview
	Entity
	// PendingCount Number of pending devices
	PendingCount *int `json:"pendingCount,omitempty"`
	// NotApplicableCount Number of not applicable devices
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// NotApplicablePlatformCount Number of not applicable devices due to mismatch platform and policy
	NotApplicablePlatformCount *int `json:"notApplicablePlatformCount,omitempty"`
	// SuccessCount Number of succeeded devices
	SuccessCount *int `json:"successCount,omitempty"`
	// ErrorCount Number of error devices
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed devices
	FailedCount *int `json:"failedCount,omitempty"`
	// ConflictCount Number of devices in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// LastUpdateDateTime Last update time
	LastUpdateDateTime *time.Time `json:"lastUpdateDateTime,omitempty"`
	// ConfigurationVersion Version of the policy for that overview
	ConfigurationVersion *int `json:"configurationVersion,omitempty"`
}

// DeviceConfigurationDeviceStateSummary undocumented
type DeviceConfigurationDeviceStateSummary struct {
	// Entity is the base model of DeviceConfigurationDeviceStateSummary
	Entity
	// UnknownDeviceCount Number of unknown devices
	UnknownDeviceCount *int `json:"unknownDeviceCount,omitempty"`
	// NotApplicableDeviceCount Number of not applicable devices
	NotApplicableDeviceCount *int `json:"notApplicableDeviceCount,omitempty"`
	// CompliantDeviceCount Number of compliant devices
	CompliantDeviceCount *int `json:"compliantDeviceCount,omitempty"`
	// RemediatedDeviceCount Number of remediated devices
	RemediatedDeviceCount *int `json:"remediatedDeviceCount,omitempty"`
	// NonCompliantDeviceCount Number of NonCompliant devices
	NonCompliantDeviceCount *int `json:"nonCompliantDeviceCount,omitempty"`
	// ErrorDeviceCount Number of error devices
	ErrorDeviceCount *int `json:"errorDeviceCount,omitempty"`
	// ConflictDeviceCount Number of conflict devices
	ConflictDeviceCount *int `json:"conflictDeviceCount,omitempty"`
}

// DeviceConfigurationDeviceStatus undocumented
type DeviceConfigurationDeviceStatus struct {
	// Entity is the base model of DeviceConfigurationDeviceStatus
	Entity
	// DeviceDisplayName Device name of the DevicePolicyStatus.
	DeviceDisplayName *string `json:"deviceDisplayName,omitempty"`
	// UserName The User Name that is being reported
	UserName *string `json:"userName,omitempty"`
	// DeviceModel The device model that is being reported
	DeviceModel *string `json:"deviceModel,omitempty"`
	// Platform Platform of the device that is being reported
	Platform *int `json:"platform,omitempty"`
	// ComplianceGracePeriodExpirationDateTime The DateTime when device compliance grace period expires
	ComplianceGracePeriodExpirationDateTime *time.Time `json:"complianceGracePeriodExpirationDateTime,omitempty"`
	// Status Compliance status of the policy report.
	Status *ComplianceStatus `json:"status,omitempty"`
	// LastReportedDateTime Last modified date time of the policy report.
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceConfigurationGroupAssignment Device configuration group assignment.
type DeviceConfigurationGroupAssignment struct {
	// Entity is the base model of DeviceConfigurationGroupAssignment
	Entity
	// TargetGroupID The Id of the AAD group we are targeting the device configuration to.
	TargetGroupID *string `json:"targetGroupId,omitempty"`
	// ExcludeGroup Indicates if this group is should be excluded. Defaults that the group should be included
	ExcludeGroup *bool `json:"excludeGroup,omitempty"`
	// DeviceConfiguration undocumented
	DeviceConfiguration *DeviceConfiguration `json:"deviceConfiguration,omitempty"`
}

// DeviceConfigurationPolicySetItem A class containing the properties used for device configuration PolicySetItem.
type DeviceConfigurationPolicySetItem struct {
	// PolicySetItem is the base model of DeviceConfigurationPolicySetItem
	PolicySetItem
}

// DeviceConfigurationSettingState undocumented
type DeviceConfigurationSettingState struct {
	// Object is the base model of DeviceConfigurationSettingState
	Object
	// Setting The setting that is being reported
	Setting *string `json:"setting,omitempty"`
	// SettingName Localized/user friendly setting name that is being reported
	SettingName *string `json:"settingName,omitempty"`
	// InstanceDisplayName Name of setting instance that is being reported.
	InstanceDisplayName *string `json:"instanceDisplayName,omitempty"`
	// State The compliance state of the setting
	State *ComplianceStatus `json:"state,omitempty"`
	// ErrorCode Error code for the setting
	ErrorCode *int `json:"errorCode,omitempty"`
	// ErrorDescription Error description
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// UserID UserId
	UserID *string `json:"userId,omitempty"`
	// UserName UserName
	UserName *string `json:"userName,omitempty"`
	// UserEmail UserEmail
	UserEmail *string `json:"userEmail,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// Sources Contributing policies
	Sources []SettingSource `json:"sources,omitempty"`
	// CurrentValue Current value of setting on device
	CurrentValue *string `json:"currentValue,omitempty"`
}

// DeviceConfigurationState Device Configuration State for a given device.
type DeviceConfigurationState struct {
	// Entity is the base model of DeviceConfigurationState
	Entity
	// SettingStates undocumented
	SettingStates []DeviceConfigurationSettingState `json:"settingStates,omitempty"`
	// DisplayName The name of the policy for this policyBase
	DisplayName *string `json:"displayName,omitempty"`
	// Version The version of the policy
	Version *int `json:"version,omitempty"`
	// PlatformType Platform type that the policy applies to
	PlatformType *PolicyPlatformType `json:"platformType,omitempty"`
	// State The compliance state of the policy
	State *ComplianceStatus `json:"state,omitempty"`
	// SettingCount Count of how many setting a policy holds
	SettingCount *int `json:"settingCount,omitempty"`
	// UserID User unique identifier, must be Guid
	UserID *string `json:"userId,omitempty"`
	// UserPrincipalName User Principal Name
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceConfigurationTargetedUserAndDevice undocumented
type DeviceConfigurationTargetedUserAndDevice struct {
	// Object is the base model of DeviceConfigurationTargetedUserAndDevice
	Object
	// DeviceID The id of the device in the checkin.
	DeviceID *string `json:"deviceId,omitempty"`
	// DeviceName The name of the device in the checkin.
	DeviceName *string `json:"deviceName,omitempty"`
	// UserID The id of the user in the checkin.
	UserID *string `json:"userId,omitempty"`
	// UserDisplayName The display name of the user in the checkin
	UserDisplayName *string `json:"userDisplayName,omitempty"`
	// UserPrincipalName The UPN of the user in the checkin.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// LastCheckinDateTime Last checkin time for this user/device pair.
	LastCheckinDateTime *time.Time `json:"lastCheckinDateTime,omitempty"`
}

// DeviceConfigurationUserOverview undocumented
type DeviceConfigurationUserOverview struct {
	// Entity is the base model of DeviceConfigurationUserOverview
	Entity
	// PendingCount Number of pending Users
	PendingCount *int `json:"pendingCount,omitempty"`
	// NotApplicableCount Number of not applicable users
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// SuccessCount Number of succeeded Users
	SuccessCount *int `json:"successCount,omitempty"`
	// ErrorCount Number of error Users
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed Users
	FailedCount *int `json:"failedCount,omitempty"`
	// ConflictCount Number of users in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// LastUpdateDateTime Last update time
	LastUpdateDateTime *time.Time `json:"lastUpdateDateTime,omitempty"`
	// ConfigurationVersion Version of the policy for that overview
	ConfigurationVersion *int `json:"configurationVersion,omitempty"`
}

// DeviceConfigurationUserStateSummary undocumented
type DeviceConfigurationUserStateSummary struct {
	// Entity is the base model of DeviceConfigurationUserStateSummary
	Entity
	// UnknownUserCount Number of unknown users
	UnknownUserCount *int `json:"unknownUserCount,omitempty"`
	// NotApplicableUserCount Number of not applicable users
	NotApplicableUserCount *int `json:"notApplicableUserCount,omitempty"`
	// CompliantUserCount Number of compliant users
	CompliantUserCount *int `json:"compliantUserCount,omitempty"`
	// RemediatedUserCount Number of remediated users
	RemediatedUserCount *int `json:"remediatedUserCount,omitempty"`
	// NonCompliantUserCount Number of NonCompliant users
	NonCompliantUserCount *int `json:"nonCompliantUserCount,omitempty"`
	// ErrorUserCount Number of error users
	ErrorUserCount *int `json:"errorUserCount,omitempty"`
	// ConflictUserCount Number of conflict users
	ConflictUserCount *int `json:"conflictUserCount,omitempty"`
}

// DeviceConfigurationUserStatus undocumented
type DeviceConfigurationUserStatus struct {
	// Entity is the base model of DeviceConfigurationUserStatus
	Entity
	// UserDisplayName User name of the DevicePolicyStatus.
	UserDisplayName *string `json:"userDisplayName,omitempty"`
	// DevicesCount Devices count for that user.
	DevicesCount *int `json:"devicesCount,omitempty"`
	// Status Compliance status of the policy report.
	Status *ComplianceStatus `json:"status,omitempty"`
	// LastReportedDateTime Last modified date time of the policy report.
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// UserPrincipalName UserPrincipalName.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// DeviceDetail undocumented
type DeviceDetail struct {
	// Object is the base model of DeviceDetail
	Object
	// DeviceID undocumented
	DeviceID *string `json:"deviceId,omitempty"`
	// DisplayName undocumented
	DisplayName *string `json:"displayName,omitempty"`
	// OperatingSystem undocumented
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// Browser undocumented
	Browser *string `json:"browser,omitempty"`
	// BrowserID undocumented
	BrowserID *string `json:"browserId,omitempty"`
	// IsCompliant undocumented
	IsCompliant *bool `json:"isCompliant,omitempty"`
	// IsManaged undocumented
	IsManaged *bool `json:"isManaged,omitempty"`
	// TrustType undocumented
	TrustType *string `json:"trustType,omitempty"`
}

// DeviceEnrollmentConfiguration The Base Class of Device Enrollment Configuration
type DeviceEnrollmentConfiguration struct {
	// Entity is the base model of DeviceEnrollmentConfiguration
	Entity
	// DisplayName The display name of the device enrollment configuration
	DisplayName *string `json:"displayName,omitempty"`
	// Description The description of the device enrollment configuration
	Description *string `json:"description,omitempty"`
	// Priority Priority is used when a user exists in multiple groups that are assigned enrollment configuration. Users are subject only to the configuration with the lowest priority value.
	Priority *int `json:"priority,omitempty"`
	// CreatedDateTime Created date time in UTC of the device enrollment configuration
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime Last modified date time in UTC of the device enrollment configuration
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// Version The version of the device enrollment configuration
	Version *int `json:"version,omitempty"`
	// Assignments undocumented
	Assignments []EnrollmentConfigurationAssignment `json:"assignments,omitempty"`
}

// DeviceEnrollmentLimitConfiguration Device Enrollment Configuration that restricts the number of devices a user can enroll
type DeviceEnrollmentLimitConfiguration struct {
	// DeviceEnrollmentConfiguration is the base model of DeviceEnrollmentLimitConfiguration
	DeviceEnrollmentConfiguration
	// Limit The maximum number of devices that a user can enroll
	Limit *int `json:"limit,omitempty"`
}

// DeviceEnrollmentPlatformRestriction undocumented
type DeviceEnrollmentPlatformRestriction struct {
	// Object is the base model of DeviceEnrollmentPlatformRestriction
	Object
	// PlatformBlocked Block the platform from enrolling
	PlatformBlocked *bool `json:"platformBlocked,omitempty"`
	// PersonalDeviceEnrollmentBlocked Block personally owned devices from enrolling
	PersonalDeviceEnrollmentBlocked *bool `json:"personalDeviceEnrollmentBlocked,omitempty"`
	// OsMinimumVersion Min OS version supported
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Max OS version supported
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
}

// DeviceEnrollmentPlatformRestrictionsConfiguration Device Enrollment Configuration that restricts the types of devices a user can enroll
type DeviceEnrollmentPlatformRestrictionsConfiguration struct {
	// DeviceEnrollmentConfiguration is the base model of DeviceEnrollmentPlatformRestrictionsConfiguration
	DeviceEnrollmentConfiguration
	// IOSRestriction Ios restrictions based on platform, platform operating system version, and device ownership
	IOSRestriction *DeviceEnrollmentPlatformRestriction `json:"iosRestriction,omitempty"`
	// WindowsRestriction Windows restrictions based on platform, platform operating system version, and device ownership
	WindowsRestriction *DeviceEnrollmentPlatformRestriction `json:"windowsRestriction,omitempty"`
	// WindowsMobileRestriction Windows mobile restrictions based on platform, platform operating system version, and device ownership
	WindowsMobileRestriction *DeviceEnrollmentPlatformRestriction `json:"windowsMobileRestriction,omitempty"`
	// AndroidRestriction Android restrictions based on platform, platform operating system version, and device ownership
	AndroidRestriction *DeviceEnrollmentPlatformRestriction `json:"androidRestriction,omitempty"`
	// AndroidForWorkRestriction Android for work restrictions based on platform, platform operating system version, and device ownership
	AndroidForWorkRestriction *DeviceEnrollmentPlatformRestriction `json:"androidForWorkRestriction,omitempty"`
	// MacRestriction Mac restrictions based on platform, platform operating system version, and device ownership
	MacRestriction *DeviceEnrollmentPlatformRestriction `json:"macRestriction,omitempty"`
	// MacOSRestriction Mac restrictions based on platform, platform operating system version, and device ownership
	MacOSRestriction *DeviceEnrollmentPlatformRestriction `json:"macOSRestriction,omitempty"`
}

// DeviceEnrollmentWindowsHelloForBusinessConfiguration Windows Hello for Business settings lets users access their devices using a gesture, such as biometric authentication, or a PIN. Configure settings for enrolled Windows 10, Windows 10 Mobile and later.
type DeviceEnrollmentWindowsHelloForBusinessConfiguration struct {
	// DeviceEnrollmentConfiguration is the base model of DeviceEnrollmentWindowsHelloForBusinessConfiguration
	DeviceEnrollmentConfiguration
	// PinMinimumLength Controls the minimum number of characters required for the Windows Hello for Business PIN.  This value must be between 4 and 127, inclusive, and less than or equal to the value set for the maximum PIN.
	PinMinimumLength *int `json:"pinMinimumLength,omitempty"`
	// PinMaximumLength Controls the maximum number of characters allowed for the Windows Hello for Business PIN. This value must be between 4 and 127, inclusive. This value must be greater than or equal to the value set for the minimum PIN.
	PinMaximumLength *int `json:"pinMaximumLength,omitempty"`
	// PinUppercaseCharactersUsage Controls the ability to use uppercase letters in the Windows Hello for Business PIN.  Allowed permits the use of uppercase letter(s), whereas Required ensures they are present. If set to Not Allowed, uppercase letters will not be permitted.
	PinUppercaseCharactersUsage *WindowsHelloForBusinessPinUsage `json:"pinUppercaseCharactersUsage,omitempty"`
	// PinLowercaseCharactersUsage Controls the ability to use lowercase letters in the Windows Hello for Business PIN.  Allowed permits the use of lowercase letter(s), whereas Required ensures they are present. If set to Not Allowed, lowercase letters will not be permitted.
	PinLowercaseCharactersUsage *WindowsHelloForBusinessPinUsage `json:"pinLowercaseCharactersUsage,omitempty"`
	// PinSpecialCharactersUsage Controls the ability to use special characters in the Windows Hello for Business PIN.  Allowed permits the use of special character(s), whereas Required ensures they are present. If set to Not Allowed, special character(s) will not be permitted.
	PinSpecialCharactersUsage *WindowsHelloForBusinessPinUsage `json:"pinSpecialCharactersUsage,omitempty"`
	// State Controls whether to allow the device to be configured for Windows Hello for Business. If set to disabled, the user cannot provision Windows Hello for Business except on Azure Active Directory joined mobile phones if otherwise required. If set to Not Configured, Intune will not override client defaults.
	State *Enablement `json:"state,omitempty"`
	// SecurityDeviceRequired Controls whether to require a Trusted Platform Module (TPM) for provisioning Windows Hello for Business. A TPM provides an additional security benefit in that data stored on it cannot be used on other devices. If set to False, all devices can provision Windows Hello for Business even if there is not a usable TPM.
	SecurityDeviceRequired *bool `json:"securityDeviceRequired,omitempty"`
	// UnlockWithBiometricsEnabled Controls the use of biometric gestures, such as face and fingerprint, as an alternative to the Windows Hello for Business PIN.  If set to False, biometric gestures are not allowed. Users must still configure a PIN as a backup in case of failures.
	UnlockWithBiometricsEnabled *bool `json:"unlockWithBiometricsEnabled,omitempty"`
	// RemotePassportEnabled Controls the use of Remote Windows Hello for Business. Remote Windows Hello for Business provides the ability for a portable, registered device to be usable as a companion for desktop authentication. The desktop must be Azure AD joined and the companion device must have a Windows Hello for Business PIN.
	RemotePassportEnabled *bool `json:"remotePassportEnabled,omitempty"`
	// PinPreviousBlockCount Controls the ability to prevent users from using past PINs. This must be set between 0 and 50, inclusive, and the current PIN of the user is included in that count. If set to 0, previous PINs are not stored. PIN history is not preserved through a PIN reset.
	PinPreviousBlockCount *int `json:"pinPreviousBlockCount,omitempty"`
	// PinExpirationInDays Controls the period of time (in days) that a PIN can be used before the system requires the user to change it. This must be set between 0 and 730, inclusive. If set to 0, the user's PIN will never expire
	PinExpirationInDays *int `json:"pinExpirationInDays,omitempty"`
	// EnhancedBiometricsState Controls the ability to use the anti-spoofing features for facial recognition on devices which support it. If set to disabled, anti-spoofing features are not allowed. If set to Not Configured, the user can choose whether they want to use anti-spoofing.
	EnhancedBiometricsState *Enablement `json:"enhancedBiometricsState,omitempty"`
	// SecurityKeyForSignIn Security key for Sign In provides the capacity for remotely turning ON/OFF Windows Hello Sercurity Keyl Not configured will honor configurations done on the clinet.
	SecurityKeyForSignIn *Enablement `json:"securityKeyForSignIn,omitempty"`
}

// DeviceExchangeAccessStateSummary undocumented
type DeviceExchangeAccessStateSummary struct {
	// Object is the base model of DeviceExchangeAccessStateSummary
	Object
	// AllowedDeviceCount Total count of devices with Exchange Access State: Allowed.
	AllowedDeviceCount *int `json:"allowedDeviceCount,omitempty"`
	// BlockedDeviceCount Total count of devices with Exchange Access State: Blocked.
	BlockedDeviceCount *int `json:"blockedDeviceCount,omitempty"`
	// QuarantinedDeviceCount Total count of devices with Exchange Access State: Quarantined.
	QuarantinedDeviceCount *int `json:"quarantinedDeviceCount,omitempty"`
	// UnknownDeviceCount Total count of devices with Exchange Access State: Unknown.
	UnknownDeviceCount *int `json:"unknownDeviceCount,omitempty"`
	// UnavailableDeviceCount Total count of devices for which no Exchange Access State could be found.
	UnavailableDeviceCount *int `json:"unavailableDeviceCount,omitempty"`
}

// DeviceGeoLocation undocumented
type DeviceGeoLocation struct {
	// Object is the base model of DeviceGeoLocation
	Object
	// LastCollectedDateTimeUtc Time at which location was recorded, relative to UTC
	LastCollectedDateTimeUtc *time.Time `json:"lastCollectedDateTimeUtc,omitempty"`
	// LastCollectedDateTime Time at which location was recorded, relative to UTC
	LastCollectedDateTime *time.Time `json:"lastCollectedDateTime,omitempty"`
	// Longitude Longitude coordinate of the device's location
	Longitude *float64 `json:"longitude,omitempty"`
	// Latitude Latitude coordinate of the device's location
	Latitude *float64 `json:"latitude,omitempty"`
	// Altitude Altitude, given in meters above sea level
	Altitude *float64 `json:"altitude,omitempty"`
	// HorizontalAccuracy Accuracy of longitude and latitude in meters
	HorizontalAccuracy *float64 `json:"horizontalAccuracy,omitempty"`
	// VerticalAccuracy Accuracy of altitude in meters
	VerticalAccuracy *float64 `json:"verticalAccuracy,omitempty"`
	// Heading Heading in degrees from true north
	Heading *float64 `json:"heading,omitempty"`
	// Speed Speed the device is traveling in meters per second
	Speed *float64 `json:"speed,omitempty"`
}

// DeviceHealthAttestationState undocumented
type DeviceHealthAttestationState struct {
	// Object is the base model of DeviceHealthAttestationState
	Object
	// LastUpdateDateTime The Timestamp of the last update.
	LastUpdateDateTime *string `json:"lastUpdateDateTime,omitempty"`
	// ContentNamespaceURL The DHA report version. (Namespace version)
	ContentNamespaceURL *string `json:"contentNamespaceUrl,omitempty"`
	// DeviceHealthAttestationStatus The DHA report version. (Namespace version)
	DeviceHealthAttestationStatus *string `json:"deviceHealthAttestationStatus,omitempty"`
	// ContentVersion The HealthAttestation state schema version
	ContentVersion *string `json:"contentVersion,omitempty"`
	// IssuedDateTime The DateTime when device was evaluated or issued to MDM
	IssuedDateTime *time.Time `json:"issuedDateTime,omitempty"`
	// AttestationIdentityKey TWhen an Attestation Identity Key (AIK) is present on a device, it indicates that the device has an endorsement key (EK) certificate.
	AttestationIdentityKey *string `json:"attestationIdentityKey,omitempty"`
	// ResetCount The number of times a PC device has hibernated or resumed
	ResetCount *int `json:"resetCount,omitempty"`
	// RestartCount The number of times a PC device has rebooted
	RestartCount *int `json:"restartCount,omitempty"`
	// DataExcutionPolicy DEP Policy defines a set of hardware and software technologies that perform additional checks on memory
	DataExcutionPolicy *string `json:"dataExcutionPolicy,omitempty"`
	// BitLockerStatus On or Off of BitLocker Drive Encryption
	BitLockerStatus *string `json:"bitLockerStatus,omitempty"`
	// BootManagerVersion The version of the Boot Manager
	BootManagerVersion *string `json:"bootManagerVersion,omitempty"`
	// CodeIntegrityCheckVersion The version of the Boot Manager
	CodeIntegrityCheckVersion *string `json:"codeIntegrityCheckVersion,omitempty"`
	// SecureBoot When Secure Boot is enabled, the core components must have the correct cryptographic signatures
	SecureBoot *string `json:"secureBoot,omitempty"`
	// BootDebugging When bootDebugging is enabled, the device is used in development and testing
	BootDebugging *string `json:"bootDebugging,omitempty"`
	// OperatingSystemKernelDebugging When operatingSystemKernelDebugging is enabled, the device is used in development and testing
	OperatingSystemKernelDebugging *string `json:"operatingSystemKernelDebugging,omitempty"`
	// CodeIntegrity  When code integrity is enabled, code execution is restricted to integrity verified code
	CodeIntegrity *string `json:"codeIntegrity,omitempty"`
	// TestSigning When test signing is allowed, the device does not enforce signature validation during boot
	TestSigning *string `json:"testSigning,omitempty"`
	// SafeMode Safe mode is a troubleshooting option for Windows that starts your computer in a limited state
	SafeMode *string `json:"safeMode,omitempty"`
	// WindowsPE Operating system running with limited services that is used to prepare a computer for Windows
	WindowsPE *string `json:"windowsPE,omitempty"`
	// EarlyLaunchAntiMalwareDriverProtection ELAM provides protection for the computers in your network when they start up
	EarlyLaunchAntiMalwareDriverProtection *string `json:"earlyLaunchAntiMalwareDriverProtection,omitempty"`
	// VirtualSecureMode VSM is a container that protects high value assets from a compromised kernel
	VirtualSecureMode *string `json:"virtualSecureMode,omitempty"`
	// PcrHashAlgorithm Informational attribute that identifies the HASH algorithm that was used by TPM
	PcrHashAlgorithm *string `json:"pcrHashAlgorithm,omitempty"`
	// BootAppSecurityVersion The security version number of the Boot Application
	BootAppSecurityVersion *string `json:"bootAppSecurityVersion,omitempty"`
	// BootManagerSecurityVersion The security version number of the Boot Application
	BootManagerSecurityVersion *string `json:"bootManagerSecurityVersion,omitempty"`
	// TpmVersion The security version number of the Boot Application
	TpmVersion *string `json:"tpmVersion,omitempty"`
	// Pcr0 The measurement that is captured in PCR[0]
	Pcr0 *string `json:"pcr0,omitempty"`
	// SecureBootConfigurationPolicyFingerPrint Fingerprint of the Custom Secure Boot Configuration Policy
	SecureBootConfigurationPolicyFingerPrint *string `json:"secureBootConfigurationPolicyFingerPrint,omitempty"`
	// CodeIntegrityPolicy The Code Integrity policy that is controlling the security of the boot environment
	CodeIntegrityPolicy *string `json:"codeIntegrityPolicy,omitempty"`
	// BootRevisionListInfo The Boot Revision List that was loaded during initial boot on the attested device
	BootRevisionListInfo *string `json:"bootRevisionListInfo,omitempty"`
	// OperatingSystemRevListInfo The Operating System Revision List that was loaded during initial boot on the attested device
	OperatingSystemRevListInfo *string `json:"operatingSystemRevListInfo,omitempty"`
	// HealthStatusMismatchInfo This attribute appears if DHA-Service detects an integrity issue
	HealthStatusMismatchInfo *string `json:"healthStatusMismatchInfo,omitempty"`
	// HealthAttestationSupportedStatus This attribute indicates if DHA is supported for the device
	HealthAttestationSupportedStatus *string `json:"healthAttestationSupportedStatus,omitempty"`
}

// DeviceHealthScript Intune will provide customer the ability to run their Powershell Health scripts (remediation + detection) on the enrolled windows 10 Azure Active Directory joined devices.
type DeviceHealthScript struct {
	// Entity is the base model of DeviceHealthScript
	Entity
	// Publisher Name of the device health script publisher
	Publisher *string `json:"publisher,omitempty"`
	// Version Version of the device health script
	Version *string `json:"version,omitempty"`
	// DisplayName Name of the device health script
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of the device health script
	Description *string `json:"description,omitempty"`
	// DetectionScriptContent The entire content of the detection powershell script
	DetectionScriptContent *Binary `json:"detectionScriptContent,omitempty"`
	// RemediationScriptContent The entire content of the remediation powershell script
	RemediationScriptContent *Binary `json:"remediationScriptContent,omitempty"`
	// CreatedDateTime The timestamp of when the device health script was created. This property is read-only.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime The timestamp of when the device health script was modified. This property is read-only.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// RunAsAccount Indicates the type of execution context
	RunAsAccount *RunAsAccountType `json:"runAsAccount,omitempty"`
	// EnforceSignatureCheck Indicate whether the script signature needs be checked
	EnforceSignatureCheck *bool `json:"enforceSignatureCheck,omitempty"`
	// RunAs32Bit Indicate whether PowerShell script(s) should run as 32-bit
	RunAs32Bit *bool `json:"runAs32Bit,omitempty"`
	// RoleScopeTagIDs List of Scope Tag IDs for the device health script
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// Assignments undocumented
	Assignments []DeviceHealthScriptAssignment `json:"assignments,omitempty"`
	// RunSummary undocumented
	RunSummary *DeviceHealthScriptRunSummary `json:"runSummary,omitempty"`
	// DeviceRunStates undocumented
	DeviceRunStates []DeviceHealthScriptDeviceState `json:"deviceRunStates,omitempty"`
}

// DeviceHealthScriptAssignment Contains properties used to assign a device management script to a group.
type DeviceHealthScriptAssignment struct {
	// Entity is the base model of DeviceHealthScriptAssignment
	Entity
	// Target The Azure Active Directory group we are targeting the script to
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
	// RunRemediationScript Determine whether we want to run detection script only or run both detection script and remediation script
	RunRemediationScript *bool `json:"runRemediationScript,omitempty"`
	// RunSchedule Script run schedule for the target group
	RunSchedule *RunSchedule `json:"runSchedule,omitempty"`
}

// DeviceHealthScriptDeviceState Contains properties for device run state of the device health script.
type DeviceHealthScriptDeviceState struct {
	// Entity is the base model of DeviceHealthScriptDeviceState
	Entity
	// DetectionState Detection state from the lastest device health script execution
	DetectionState *RunState `json:"detectionState,omitempty"`
	// LastStateUpdateDateTime The last timestamp of when the device health script executed
	LastStateUpdateDateTime *time.Time `json:"lastStateUpdateDateTime,omitempty"`
	// ExpectedStateUpdateDateTime The next timestamp of when the device health script is expected to execute
	ExpectedStateUpdateDateTime *time.Time `json:"expectedStateUpdateDateTime,omitempty"`
	// LastSyncDateTime The last time that Intune Managment Extension synced with Intune
	LastSyncDateTime *time.Time `json:"lastSyncDateTime,omitempty"`
	// PreRemediationDetectionScriptOutput Output of the detection script before remediation
	PreRemediationDetectionScriptOutput *string `json:"preRemediationDetectionScriptOutput,omitempty"`
	// PreRemediationDetectionScriptError Error from the detection script before remediation
	PreRemediationDetectionScriptError *string `json:"preRemediationDetectionScriptError,omitempty"`
	// RemediationScriptError Error output of the remediation script
	RemediationScriptError *string `json:"remediationScriptError,omitempty"`
	// PostRemediationDetectionScriptOutput Detection script output after remediation
	PostRemediationDetectionScriptOutput *string `json:"postRemediationDetectionScriptOutput,omitempty"`
	// PostRemediationDetectionScriptError Error from the detection script after remediation
	PostRemediationDetectionScriptError *string `json:"postRemediationDetectionScriptError,omitempty"`
	// RemediationState Remediation state from the lastest device health script execution
	RemediationState *RemediationState `json:"remediationState,omitempty"`
	// ManagedDevice undocumented
	ManagedDevice *ManagedDevice `json:"managedDevice,omitempty"`
}

// DeviceHealthScriptRunSummary Contains properties for the run summary of a device management script.
type DeviceHealthScriptRunSummary struct {
	// Entity is the base model of DeviceHealthScriptRunSummary
	Entity
	// NoIssueDetectedDeviceCount Number of devices for which the detection script did not find an issue and the device is healthy
	NoIssueDetectedDeviceCount *int `json:"noIssueDetectedDeviceCount,omitempty"`
	// IssueDetectedDeviceCount Number of devices for which the detection script found an issue
	IssueDetectedDeviceCount *int `json:"issueDetectedDeviceCount,omitempty"`
	// DetectionScriptErrorDeviceCount Number of devices on which the detection script execution encountered an error and did not complete
	DetectionScriptErrorDeviceCount *int `json:"detectionScriptErrorDeviceCount,omitempty"`
	// DetectionScriptPendingDeviceCount Number of devices which have not yet run the latest version of the device health script
	DetectionScriptPendingDeviceCount *int `json:"detectionScriptPendingDeviceCount,omitempty"`
	// IssueRemediatedDeviceCount Number of devices for which the remediation script was able to resolve the detected issue
	IssueRemediatedDeviceCount *int `json:"issueRemediatedDeviceCount,omitempty"`
	// RemediationSkippedDeviceCount Number of devices for which remediation was skipped
	RemediationSkippedDeviceCount *int `json:"remediationSkippedDeviceCount,omitempty"`
	// IssueReoccurredDeviceCount Number of devices for which the remediation script executed successfully but failed to resolve the detected issue
	IssueReoccurredDeviceCount *int `json:"issueReoccurredDeviceCount,omitempty"`
	// RemediationScriptErrorDeviceCount Number of devices for which the remediation script execution encountered an error and did not complete
	RemediationScriptErrorDeviceCount *int `json:"remediationScriptErrorDeviceCount,omitempty"`
	// LastScriptRunDateTime Last run time for the script across all devices
	LastScriptRunDateTime *time.Time `json:"lastScriptRunDateTime,omitempty"`
}

// DeviceInstallState Contains properties for the installation state for a device.
type DeviceInstallState struct {
	// Entity is the base model of DeviceInstallState
	Entity
	// DeviceName Device name.
	DeviceName *string `json:"deviceName,omitempty"`
	// DeviceID Device Id.
	DeviceID *string `json:"deviceId,omitempty"`
	// LastSyncDateTime Last sync date and time.
	LastSyncDateTime *time.Time `json:"lastSyncDateTime,omitempty"`
	// InstallState The install state of the eBook.
	InstallState *InstallState `json:"installState,omitempty"`
	// ErrorCode The error code for install failures.
	ErrorCode *string `json:"errorCode,omitempty"`
	// OsVersion OS Version.
	OsVersion *string `json:"osVersion,omitempty"`
	// OsDescription OS Description.
	OsDescription *string `json:"osDescription,omitempty"`
	// UserName Device User Name.
	UserName *string `json:"userName,omitempty"`
}

// DeviceKey undocumented
type DeviceKey struct {
	// Object is the base model of DeviceKey
	Object
	// KeyType undocumented
	KeyType *string `json:"keyType,omitempty"`
	// KeyMaterial undocumented
	KeyMaterial *Binary `json:"keyMaterial,omitempty"`
	// DeviceID undocumented
	DeviceID *UUID `json:"deviceId,omitempty"`
}

// DeviceManagement Singleton that acts as container for a collection of UserPFXCertificate entities.
type DeviceManagement struct {
	// Entity is the base model of DeviceManagement
	Entity
	// Settings Account level settings.
	Settings *DeviceManagementSettings `json:"settings,omitempty"`
	// MaximumDepTokens Maximum number of dep tokens allowed per-tenant.
	MaximumDepTokens *int `json:"maximumDepTokens,omitempty"`
	// IntuneAccountID Intune Account Id for given tenant
	IntuneAccountID *UUID `json:"intuneAccountId,omitempty"`
	// LastReportAggregationDateTime The last modified time of reporting for this account. This property is read-only.
	LastReportAggregationDateTime *time.Time `json:"lastReportAggregationDateTime,omitempty"`
	// DeviceComplianceReportSummarizationDateTime The last requested time of device compliance reporting for this account. This property is read-only.
	DeviceComplianceReportSummarizationDateTime *time.Time `json:"deviceComplianceReportSummarizationDateTime,omitempty"`
	// LegacyPcManangementEnabled The property to enable Non-MDM managed legacy PC management for this account. This property is read-only.
	LegacyPcManangementEnabled *bool `json:"legacyPcManangementEnabled,omitempty"`
	// IntuneBrand intuneBrand contains data which is used in customizing the appearance of the Company Portal applications as well as the end user web portal.
	IntuneBrand *IntuneBrand `json:"intuneBrand,omitempty"`
	// SubscriptionState Tenant mobile device management subscription state.
	SubscriptionState *DeviceManagementSubscriptionState `json:"subscriptionState,omitempty"`
	// Subscriptions Tenant's Subscription.
	Subscriptions *DeviceManagementSubscriptions `json:"subscriptions,omitempty"`
	// ManagedDeviceCleanupSettings Device cleanup rule
	ManagedDeviceCleanupSettings *ManagedDeviceCleanupSettings `json:"managedDeviceCleanupSettings,omitempty"`
	// AdminConsent Admin consent information.
	AdminConsent *AdminConsent `json:"adminConsent,omitempty"`
	// DeviceProtectionOverview Device protection overview.
	DeviceProtectionOverview *DeviceProtectionOverview `json:"deviceProtectionOverview,omitempty"`
	// WindowsMalwareOverview Malware overview for windows devices.
	WindowsMalwareOverview *WindowsMalwareOverview `json:"windowsMalwareOverview,omitempty"`
	// AccountMoveCompletionDateTime The date & time when tenant data moved between scaleunits.
	AccountMoveCompletionDateTime *time.Time `json:"accountMoveCompletionDateTime,omitempty"`
	// GroupPolicyObjectFiles A list of Group Policy Object files uploaded.
	GroupPolicyObjectFiles []GroupPolicyObjectFile `json:"groupPolicyObjectFiles,omitempty"`
	// AuditEvents undocumented
	AuditEvents []AuditEvent `json:"auditEvents,omitempty"`
	// AndroidForWorkSettings undocumented
	AndroidForWorkSettings *AndroidForWorkSettings `json:"androidForWorkSettings,omitempty"`
	// AndroidForWorkAppConfigurationSchemas undocumented
	AndroidForWorkAppConfigurationSchemas []AndroidForWorkAppConfigurationSchema `json:"androidForWorkAppConfigurationSchemas,omitempty"`
	// AndroidForWorkEnrollmentProfiles undocumented
	AndroidForWorkEnrollmentProfiles []AndroidForWorkEnrollmentProfile `json:"androidForWorkEnrollmentProfiles,omitempty"`
	// AndroidManagedStoreAccountEnterpriseSettings undocumented
	AndroidManagedStoreAccountEnterpriseSettings *AndroidManagedStoreAccountEnterpriseSettings `json:"androidManagedStoreAccountEnterpriseSettings,omitempty"`
	// AndroidManagedStoreAppConfigurationSchemas undocumented
	AndroidManagedStoreAppConfigurationSchemas []AndroidManagedStoreAppConfigurationSchema `json:"androidManagedStoreAppConfigurationSchemas,omitempty"`
	// AndroidDeviceOwnerEnrollmentProfiles undocumented
	AndroidDeviceOwnerEnrollmentProfiles []AndroidDeviceOwnerEnrollmentProfile `json:"androidDeviceOwnerEnrollmentProfiles,omitempty"`
	// TermsAndConditions undocumented
	TermsAndConditions []TermsAndConditions `json:"termsAndConditions,omitempty"`
	// DeviceConfigurations undocumented
	DeviceConfigurations []DeviceConfiguration `json:"deviceConfigurations,omitempty"`
	// DeviceCompliancePolicies undocumented
	DeviceCompliancePolicies []DeviceCompliancePolicy `json:"deviceCompliancePolicies,omitempty"`
	// SoftwareUpdateStatusSummary undocumented
	SoftwareUpdateStatusSummary *SoftwareUpdateStatusSummary `json:"softwareUpdateStatusSummary,omitempty"`
	// DeviceCompliancePolicyDeviceStateSummary undocumented
	DeviceCompliancePolicyDeviceStateSummary *DeviceCompliancePolicyDeviceStateSummary `json:"deviceCompliancePolicyDeviceStateSummary,omitempty"`
	// DeviceCompliancePolicySettingStateSummaries undocumented
	DeviceCompliancePolicySettingStateSummaries []DeviceCompliancePolicySettingStateSummary `json:"deviceCompliancePolicySettingStateSummaries,omitempty"`
	// AdvancedThreatProtectionOnboardingStateSummary undocumented
	AdvancedThreatProtectionOnboardingStateSummary *AdvancedThreatProtectionOnboardingStateSummary `json:"advancedThreatProtectionOnboardingStateSummary,omitempty"`
	// DeviceConfigurationDeviceStateSummaries undocumented
	DeviceConfigurationDeviceStateSummaries *DeviceConfigurationDeviceStateSummary `json:"deviceConfigurationDeviceStateSummaries,omitempty"`
	// DeviceConfigurationUserStateSummaries undocumented
	DeviceConfigurationUserStateSummaries *DeviceConfigurationUserStateSummary `json:"deviceConfigurationUserStateSummaries,omitempty"`
	// CartToClassAssociations undocumented
	CartToClassAssociations []CartToClassAssociation `json:"cartToClassAssociations,omitempty"`
	// IOSUpdateStatuses undocumented
	IOSUpdateStatuses []IOSUpdateDeviceStatus `json:"iosUpdateStatuses,omitempty"`
	// NDESConnectors undocumented
	NDESConnectors []NDESConnector `json:"ndesConnectors,omitempty"`
	// DeviceConfigurationRestrictedAppsViolations undocumented
	DeviceConfigurationRestrictedAppsViolations []RestrictedAppsViolation `json:"deviceConfigurationRestrictedAppsViolations,omitempty"`
	// ManagedDeviceEncryptionStates undocumented
	ManagedDeviceEncryptionStates []ManagedDeviceEncryptionState `json:"managedDeviceEncryptionStates,omitempty"`
	// DeviceConfigurationConflictSummary undocumented
	DeviceConfigurationConflictSummary []DeviceConfigurationConflictSummary `json:"deviceConfigurationConflictSummary,omitempty"`
	// DeviceConfigurationsAllManagedDeviceCertificateStates undocumented
	DeviceConfigurationsAllManagedDeviceCertificateStates []ManagedAllDeviceCertificateState `json:"deviceConfigurationsAllManagedDeviceCertificateStates,omitempty"`
	// DeviceCategories undocumented
	DeviceCategories []DeviceCategory `json:"deviceCategories,omitempty"`
	// ExchangeConnectors undocumented
	ExchangeConnectors []DeviceManagementExchangeConnector `json:"exchangeConnectors,omitempty"`
	// DeviceEnrollmentConfigurations undocumented
	DeviceEnrollmentConfigurations []DeviceEnrollmentConfiguration `json:"deviceEnrollmentConfigurations,omitempty"`
	// ExchangeOnPremisesPolicy undocumented
	ExchangeOnPremisesPolicy *DeviceManagementExchangeOnPremisesPolicy `json:"exchangeOnPremisesPolicy,omitempty"`
	// ExchangeOnPremisesPolicies undocumented
	ExchangeOnPremisesPolicies []DeviceManagementExchangeOnPremisesPolicy `json:"exchangeOnPremisesPolicies,omitempty"`
	// ConditionalAccessSettings undocumented
	ConditionalAccessSettings *OnPremisesConditionalAccessSettings `json:"conditionalAccessSettings,omitempty"`
	// MobileThreatDefenseConnectors undocumented
	MobileThreatDefenseConnectors []MobileThreatDefenseConnector `json:"mobileThreatDefenseConnectors,omitempty"`
	// DeviceManagementPartners undocumented
	DeviceManagementPartners []DeviceManagementPartner `json:"deviceManagementPartners,omitempty"`
	// ComplianceManagementPartners undocumented
	ComplianceManagementPartners []ComplianceManagementPartner `json:"complianceManagementPartners,omitempty"`
	// Intents undocumented
	Intents []DeviceManagementIntent `json:"intents,omitempty"`
	// SettingDefinitions undocumented
	SettingDefinitions []DeviceManagementSettingDefinition `json:"settingDefinitions,omitempty"`
	// Templates undocumented
	Templates []DeviceManagementTemplate `json:"templates,omitempty"`
	// Categories undocumented
	Categories []DeviceManagementSettingCategory `json:"categories,omitempty"`
	// RemoteActionAudits undocumented
	RemoteActionAudits []RemoteActionAudit `json:"remoteActionAudits,omitempty"`
	// ApplePushNotificationCertificate undocumented
	ApplePushNotificationCertificate *ApplePushNotificationCertificate `json:"applePushNotificationCertificate,omitempty"`
	// DeviceManagementScripts undocumented
	DeviceManagementScripts []DeviceManagementScript `json:"deviceManagementScripts,omitempty"`
	// DeviceHealthScripts undocumented
	DeviceHealthScripts []DeviceHealthScript `json:"deviceHealthScripts,omitempty"`
	// ManagedDeviceOverview undocumented
	ManagedDeviceOverview *ManagedDeviceOverview `json:"managedDeviceOverview,omitempty"`
	// DetectedApps undocumented
	DetectedApps []DetectedApp `json:"detectedApps,omitempty"`
	// ManagedDevices undocumented
	ManagedDevices []ManagedDevice `json:"managedDevices,omitempty"`
	// WindowsMalwareInformation undocumented
	WindowsMalwareInformation []WindowsMalwareInformation `json:"windowsMalwareInformation,omitempty"`
	// DataSharingConsents undocumented
	DataSharingConsents []DataSharingConsent `json:"dataSharingConsents,omitempty"`
	// MobileAppTroubleshootingEvents undocumented
	MobileAppTroubleshootingEvents []MobileAppTroubleshootingEvent `json:"mobileAppTroubleshootingEvents,omitempty"`
	// UserExperienceAnalyticsOverview undocumented
	UserExperienceAnalyticsOverview *UserExperienceAnalyticsOverview `json:"userExperienceAnalyticsOverview,omitempty"`
	// UserExperienceAnalyticsBaselines undocumented
	UserExperienceAnalyticsBaselines []UserExperienceAnalyticsBaseline `json:"userExperienceAnalyticsBaselines,omitempty"`
	// UserExperienceAnalyticsCategories undocumented
	UserExperienceAnalyticsCategories []UserExperienceAnalyticsCategory `json:"userExperienceAnalyticsCategories,omitempty"`
	// UserExperienceAnalyticsDevicePerformance undocumented
	UserExperienceAnalyticsDevicePerformance []UserExperienceAnalyticsDevicePerformance `json:"userExperienceAnalyticsDevicePerformance,omitempty"`
	// UserExperienceAnalyticsRegressionSummary undocumented
	UserExperienceAnalyticsRegressionSummary *UserExperienceAnalyticsRegressionSummary `json:"userExperienceAnalyticsRegressionSummary,omitempty"`
	// UserExperienceAnalyticsDeviceStartupHistory undocumented
	UserExperienceAnalyticsDeviceStartupHistory []UserExperienceAnalyticsDeviceStartupHistory `json:"userExperienceAnalyticsDeviceStartupHistory,omitempty"`
	// DerivedCredentials undocumented
	DerivedCredentials []DeviceManagementDerivedCredentialSettings `json:"derivedCredentials,omitempty"`
	// WindowsAutopilotSettings undocumented
	WindowsAutopilotSettings *WindowsAutopilotSettings `json:"windowsAutopilotSettings,omitempty"`
	// WindowsAutopilotDeviceIdentities undocumented
	WindowsAutopilotDeviceIdentities []WindowsAutopilotDeviceIdentity `json:"windowsAutopilotDeviceIdentities,omitempty"`
	// WindowsAutopilotDeploymentProfiles undocumented
	WindowsAutopilotDeploymentProfiles []WindowsAutopilotDeploymentProfile `json:"windowsAutopilotDeploymentProfiles,omitempty"`
	// ImportedDeviceIdentities undocumented
	ImportedDeviceIdentities []ImportedDeviceIdentity `json:"importedDeviceIdentities,omitempty"`
	// DepOnboardingSettings undocumented
	DepOnboardingSettings []DepOnboardingSetting `json:"depOnboardingSettings,omitempty"`
	// ImportedWindowsAutopilotDeviceIdentities undocumented
	ImportedWindowsAutopilotDeviceIdentities []ImportedWindowsAutopilotDeviceIdentity `json:"importedWindowsAutopilotDeviceIdentities,omitempty"`
	// AppleUserInitiatedEnrollmentProfiles undocumented
	AppleUserInitiatedEnrollmentProfiles []AppleUserInitiatedEnrollmentProfile `json:"appleUserInitiatedEnrollmentProfiles,omitempty"`
	// ManagementConditions undocumented
	ManagementConditions []ManagementCondition `json:"managementConditions,omitempty"`
	// ManagementConditionStatements undocumented
	ManagementConditionStatements []ManagementConditionStatement `json:"managementConditionStatements,omitempty"`
	// GroupPolicyMigrationReports undocumented
	GroupPolicyMigrationReports []GroupPolicyMigrationReport `json:"groupPolicyMigrationReports,omitempty"`
	// GroupPolicyConfigurations undocumented
	GroupPolicyConfigurations []GroupPolicyConfiguration `json:"groupPolicyConfigurations,omitempty"`
	// GroupPolicyDefinitions undocumented
	GroupPolicyDefinitions []GroupPolicyDefinition `json:"groupPolicyDefinitions,omitempty"`
	// GroupPolicyDefinitionFiles undocumented
	GroupPolicyDefinitionFiles []GroupPolicyDefinitionFile `json:"groupPolicyDefinitionFiles,omitempty"`
	// NotificationMessageTemplates undocumented
	NotificationMessageTemplates []NotificationMessageTemplate `json:"notificationMessageTemplates,omitempty"`
	// DomainJoinConnectors undocumented
	DomainJoinConnectors []DeviceManagementDomainJoinConnector `json:"domainJoinConnectors,omitempty"`
	// RoleDefinitions undocumented
	RoleDefinitions []RoleDefinition `json:"roleDefinitions,omitempty"`
	// RoleAssignments undocumented
	RoleAssignments []DeviceAndAppManagementRoleAssignment `json:"roleAssignments,omitempty"`
	// RoleScopeTags undocumented
	RoleScopeTags []RoleScopeTag `json:"roleScopeTags,omitempty"`
	// ResourceOperations undocumented
	ResourceOperations []ResourceOperation `json:"resourceOperations,omitempty"`
	// RemoteAssistancePartners undocumented
	RemoteAssistancePartners []RemoteAssistancePartner `json:"remoteAssistancePartners,omitempty"`
	// Reports undocumented
	Reports *DeviceManagementReports `json:"reports,omitempty"`
	// TelecomExpenseManagementPartners undocumented
	TelecomExpenseManagementPartners []TelecomExpenseManagementPartner `json:"telecomExpenseManagementPartners,omitempty"`
	// EmbeddedSIMActivationCodePools undocumented
	EmbeddedSIMActivationCodePools []EmbeddedSIMActivationCodePool `json:"embeddedSIMActivationCodePools,omitempty"`
	// TroubleshootingEvents undocumented
	TroubleshootingEvents []DeviceManagementTroubleshootingEvent `json:"troubleshootingEvents,omitempty"`
	// AutopilotEvents undocumented
	AutopilotEvents []DeviceManagementAutopilotEvent `json:"autopilotEvents,omitempty"`
	// WindowsFeatureUpdateProfiles undocumented
	WindowsFeatureUpdateProfiles []WindowsFeatureUpdateProfile `json:"windowsFeatureUpdateProfiles,omitempty"`
	// WindowsInformationProtectionAppLearningSummaries undocumented
	WindowsInformationProtectionAppLearningSummaries []WindowsInformationProtectionAppLearningSummary `json:"windowsInformationProtectionAppLearningSummaries,omitempty"`
	// WindowsInformationProtectionNetworkLearningSummaries undocumented
	WindowsInformationProtectionNetworkLearningSummaries []WindowsInformationProtectionNetworkLearningSummary `json:"windowsInformationProtectionNetworkLearningSummaries,omitempty"`
	// IntuneBrandingProfiles undocumented
	IntuneBrandingProfiles []IntuneBrandingProfile `json:"intuneBrandingProfiles,omitempty"`
	// UserPfxCertificates undocumented
	UserPfxCertificates []UserPFXCertificate `json:"userPfxCertificates,omitempty"`
}

// DeviceManagementAbstractComplexSettingDefinition Entity representing the defintion for an abstract complex setting
type DeviceManagementAbstractComplexSettingDefinition struct {
	// DeviceManagementSettingDefinition is the base model of DeviceManagementAbstractComplexSettingDefinition
	DeviceManagementSettingDefinition
	// Implementations List of definition IDs for all possible implementations of this abstract complex setting
	Implementations []string `json:"implementations,omitempty"`
}

// DeviceManagementAbstractComplexSettingInstance A setting instance representing a complex value for an abstract setting
type DeviceManagementAbstractComplexSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementAbstractComplexSettingInstance
	DeviceManagementSettingInstance
	// ImplementationID The definition ID for the chosen implementation of this complex setting
	ImplementationID *string `json:"implementationId,omitempty"`
	// Value undocumented
	Value []DeviceManagementSettingInstance `json:"value,omitempty"`
}

// DeviceManagementApplicabilityRuleDeviceMode undocumented
type DeviceManagementApplicabilityRuleDeviceMode struct {
	// Object is the base model of DeviceManagementApplicabilityRuleDeviceMode
	Object
	// DeviceMode Applicability rule for device mode.
	DeviceMode *Windows10DeviceModeType `json:"deviceMode,omitempty"`
	// Name Name for object.
	Name *string `json:"name,omitempty"`
	// RuleType Applicability Rule type.
	RuleType *DeviceManagementApplicabilityRuleType `json:"ruleType,omitempty"`
}

// DeviceManagementApplicabilityRuleOsEdition undocumented
type DeviceManagementApplicabilityRuleOsEdition struct {
	// Object is the base model of DeviceManagementApplicabilityRuleOsEdition
	Object
	// OsEditionTypes Applicability rule OS edition type.
	OsEditionTypes []Windows10EditionType `json:"osEditionTypes,omitempty"`
	// Name Name for object.
	Name *string `json:"name,omitempty"`
	// RuleType Applicability Rule type.
	RuleType *DeviceManagementApplicabilityRuleType `json:"ruleType,omitempty"`
}

// DeviceManagementApplicabilityRuleOsVersion undocumented
type DeviceManagementApplicabilityRuleOsVersion struct {
	// Object is the base model of DeviceManagementApplicabilityRuleOsVersion
	Object
	// MinOSVersion Min OS version for Applicability Rule.
	MinOSVersion *string `json:"minOSVersion,omitempty"`
	// MaxOSVersion Max OS version for Applicability Rule.
	MaxOSVersion *string `json:"maxOSVersion,omitempty"`
	// Name Name for object.
	Name *string `json:"name,omitempty"`
	// RuleType Applicability Rule type.
	RuleType *DeviceManagementApplicabilityRuleType `json:"ruleType,omitempty"`
}

// DeviceManagementAutopilotEvent Represents an Autopilot flow event.
type DeviceManagementAutopilotEvent struct {
	// Entity is the base model of DeviceManagementAutopilotEvent
	Entity
	// EventDateTime Time when the event occurred .
	EventDateTime *time.Time `json:"eventDateTime,omitempty"`
	// DeviceRegisteredDateTime Device registration date.
	DeviceRegisteredDateTime *time.Time `json:"deviceRegisteredDateTime,omitempty"`
	// EnrollmentStartDateTime Device enrollment start date.
	EnrollmentStartDateTime *time.Time `json:"enrollmentStartDateTime,omitempty"`
	// EnrollmentType Enrollment type.
	EnrollmentType *WindowsAutopilotEnrollmentType `json:"enrollmentType,omitempty"`
	// DeviceSerialNumber Device serial number.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// ManagedDeviceName Managed device name.
	ManagedDeviceName *string `json:"managedDeviceName,omitempty"`
	// UserPrincipalName User principal name used to enroll the device.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// WindowsAutopilotDeploymentProfileDisplayName Autopilot profile name.
	WindowsAutopilotDeploymentProfileDisplayName *string `json:"windowsAutopilotDeploymentProfileDisplayName,omitempty"`
	// EnrollmentState Enrollment state like Enrolled, Failed.
	EnrollmentState *EnrollmentState `json:"enrollmentState,omitempty"`
	// Windows10EnrollmentCompletionPageConfigurationDisplayName Enrollment Status Page profile name
	Windows10EnrollmentCompletionPageConfigurationDisplayName *string `json:"windows10EnrollmentCompletionPageConfigurationDisplayName,omitempty"`
	// DeploymentState Deployment state like Success, Failure, InProgress, SuccessWithTimeout.
	DeploymentState *WindowsAutopilotDeploymentState `json:"deploymentState,omitempty"`
	// OsVersion Device operating system version.
	OsVersion *string `json:"osVersion,omitempty"`
	// DeploymentDuration Autopilot deployment duration including enrollment.
	DeploymentDuration *Duration `json:"deploymentDuration,omitempty"`
	// DeploymentTotalDuration Total deployment duration from enrollment to Desktop screen.
	DeploymentTotalDuration *Duration `json:"deploymentTotalDuration,omitempty"`
	// DevicePreparationDuration Time spent in device enrollment.
	DevicePreparationDuration *Duration `json:"devicePreparationDuration,omitempty"`
	// DeviceSetupDuration Time spent in device ESP.
	DeviceSetupDuration *Duration `json:"deviceSetupDuration,omitempty"`
	// AccountSetupDuration Time spent in user ESP.
	AccountSetupDuration *Duration `json:"accountSetupDuration,omitempty"`
	// DeploymentStartDateTime Deployment start time.
	DeploymentStartDateTime *time.Time `json:"deploymentStartDateTime,omitempty"`
	// DeploymentEndDateTime Deployment end time.
	DeploymentEndDateTime *time.Time `json:"deploymentEndDateTime,omitempty"`
	// TargetedAppCount Count of applications targeted.
	TargetedAppCount *int `json:"targetedAppCount,omitempty"`
	// TargetedPolicyCount Count of policies targeted.
	TargetedPolicyCount *int `json:"targetedPolicyCount,omitempty"`
	// EnrollmentFailureDetails Enrollment failure details.
	EnrollmentFailureDetails *string `json:"enrollmentFailureDetails,omitempty"`
}

// DeviceManagementBooleanSettingInstance A setting instance representing a boolean value
type DeviceManagementBooleanSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementBooleanSettingInstance
	DeviceManagementSettingInstance
	// Value The boolean value
	Value *bool `json:"value,omitempty"`
}

// DeviceManagementCachedReportConfiguration Entity representing the configuration of a cached report
type DeviceManagementCachedReportConfiguration struct {
	// Entity is the base model of DeviceManagementCachedReportConfiguration
	Entity
	// ReportName Name of the report
	ReportName *string `json:"reportName,omitempty"`
	// Filter Filters applied on report creation.
	Filter *string `json:"filter,omitempty"`
	// Select Columns selected from the report
	Select []string `json:"select,omitempty"`
	// OrderBy Ordering of columns in the report
	OrderBy []string `json:"orderBy,omitempty"`
	// Status Status of the cached report
	Status *DeviceManagementReportStatus `json:"status,omitempty"`
	// LastRefreshDateTime Time that the cached report was last refreshed
	LastRefreshDateTime *time.Time `json:"lastRefreshDateTime,omitempty"`
	// ExpirationDateTime Time that the cached report expires
	ExpirationDateTime *time.Time `json:"expirationDateTime,omitempty"`
}

// DeviceManagementCollectionSettingDefinition Entity representing the defintion for a collection setting
type DeviceManagementCollectionSettingDefinition struct {
	// DeviceManagementSettingDefinition is the base model of DeviceManagementCollectionSettingDefinition
	DeviceManagementSettingDefinition
	// ElementDefinitionID The Setting Definition ID that describes what each element of the collection looks like
	ElementDefinitionID *string `json:"elementDefinitionId,omitempty"`
}

// DeviceManagementCollectionSettingInstance A setting instance representing a collection of values
type DeviceManagementCollectionSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementCollectionSettingInstance
	DeviceManagementSettingInstance
	// Value undocumented
	Value []DeviceManagementSettingInstance `json:"value,omitempty"`
}

// DeviceManagementComplexSettingDefinition Entity representing the defintion for a complex setting
type DeviceManagementComplexSettingDefinition struct {
	// DeviceManagementSettingDefinition is the base model of DeviceManagementComplexSettingDefinition
	DeviceManagementSettingDefinition
	// PropertyDefinitionIDs The definitions of each property of the complex setting
	PropertyDefinitionIDs []string `json:"propertyDefinitionIds,omitempty"`
}

// DeviceManagementComplexSettingInstance A setting instance representing a complex value
type DeviceManagementComplexSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementComplexSettingInstance
	DeviceManagementSettingInstance
	// Value undocumented
	Value []DeviceManagementSettingInstance `json:"value,omitempty"`
}

// DeviceManagementConstraint undocumented
type DeviceManagementConstraint struct {
	// Object is the base model of DeviceManagementConstraint
	Object
}

// DeviceManagementDerivedCredentialSettings Entity that describes tenant level settings for derived credentials
type DeviceManagementDerivedCredentialSettings struct {
	// Entity is the base model of DeviceManagementDerivedCredentialSettings
	Entity
	// HelpURL The URL that will be accessible to end users as they retrieve a derived credential using the Company Portal.
	HelpURL *string `json:"helpUrl,omitempty"`
	// DisplayName The display name for the profile.
	DisplayName *string `json:"displayName,omitempty"`
	// Issuer The derived credential provider to use.
	Issuer *DeviceManagementDerivedCredentialIssuer `json:"issuer,omitempty"`
	// NotificationType The methods used to inform the end user to open Company Portal to deliver Wi-Fi, VPN, or email profiles that use certificates to the device.
	NotificationType *DeviceManagementDerivedCredentialNotificationType `json:"notificationType,omitempty"`
}

// DeviceManagementDomainJoinConnector A Domain Join Connector is a connector that is responsible to allocate (and delete) machine account blobs
type DeviceManagementDomainJoinConnector struct {
	// Entity is the base model of DeviceManagementDomainJoinConnector
	Entity
	// DisplayName The connector display name.
	DisplayName *string `json:"displayName,omitempty"`
	// LastConnectionDateTime Last time connector contacted Intune.
	LastConnectionDateTime *time.Time `json:"lastConnectionDateTime,omitempty"`
	// State The connector state.
	State *DeviceManagementDomainJoinConnectorState `json:"state,omitempty"`
	// Version The version of the connector.
	Version *string `json:"version,omitempty"`
}

// DeviceManagementEnumConstraint undocumented
type DeviceManagementEnumConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementEnumConstraint
	DeviceManagementConstraint
	// Values List of valid values for this string
	Values []DeviceManagementEnumValue `json:"values,omitempty"`
}

// DeviceManagementEnumValue undocumented
type DeviceManagementEnumValue struct {
	// Object is the base model of DeviceManagementEnumValue
	Object
	// Value The raw enum value text
	Value *string `json:"value,omitempty"`
	// DisplayName Display name for this enum value
	DisplayName *string `json:"displayName,omitempty"`
}

// DeviceManagementExchangeAccessRule undocumented
type DeviceManagementExchangeAccessRule struct {
	// Object is the base model of DeviceManagementExchangeAccessRule
	Object
	// DeviceClass Device Class which will be impacted by this rule.
	DeviceClass *DeviceManagementExchangeDeviceClass `json:"deviceClass,omitempty"`
	// AccessLevel Access Level for Exchange granted by this rule.
	AccessLevel *DeviceManagementExchangeAccessLevel `json:"accessLevel,omitempty"`
}

// DeviceManagementExchangeConnector Entity which represents a connection to an Exchange environment.
type DeviceManagementExchangeConnector struct {
	// Entity is the base model of DeviceManagementExchangeConnector
	Entity
	// LastSyncDateTime Last sync time for the Exchange Connector
	LastSyncDateTime *time.Time `json:"lastSyncDateTime,omitempty"`
	// Status Exchange Connector Status
	Status *DeviceManagementExchangeConnectorStatus `json:"status,omitempty"`
	// PrimarySMTPAddress Email address used to configure the Service To Service Exchange Connector.
	PrimarySMTPAddress *string `json:"primarySmtpAddress,omitempty"`
	// ServerName The name of the Exchange server.
	ServerName *string `json:"serverName,omitempty"`
	// ConnectorServerName The name of the server hosting the Exchange Connector.
	ConnectorServerName *string `json:"connectorServerName,omitempty"`
	// ExchangeConnectorType The type of Exchange Connector Configured.
	ExchangeConnectorType *DeviceManagementExchangeConnectorType `json:"exchangeConnectorType,omitempty"`
	// Version The version of the ExchangeConnectorAgent
	Version *string `json:"version,omitempty"`
	// ExchangeAlias An alias assigned to the Exchange server
	ExchangeAlias *string `json:"exchangeAlias,omitempty"`
	// ExchangeOrganization Exchange Organization to the Exchange server
	ExchangeOrganization *string `json:"exchangeOrganization,omitempty"`
}

// DeviceManagementExchangeDeviceClass undocumented
type DeviceManagementExchangeDeviceClass struct {
	// Object is the base model of DeviceManagementExchangeDeviceClass
	Object
	// Name Name of the device class which will be impacted by this rule.
	Name *string `json:"name,omitempty"`
	// Type Type of device which is impacted by this rule e.g. Model, Family
	Type *DeviceManagementExchangeAccessRuleType `json:"type,omitempty"`
}

// DeviceManagementExchangeOnPremisesPolicy Singleton entity which represents the Exchange OnPremises policy configured for a tenant.
type DeviceManagementExchangeOnPremisesPolicy struct {
	// Entity is the base model of DeviceManagementExchangeOnPremisesPolicy
	Entity
	// NotificationContent Notification text that will be sent to users quarantined by this policy. This is UTF8 encoded byte array HTML.
	NotificationContent *Binary `json:"notificationContent,omitempty"`
	// DefaultAccessLevel Default access state in Exchange. This rule applies globally to the entire Exchange organization
	DefaultAccessLevel *DeviceManagementExchangeAccessLevel `json:"defaultAccessLevel,omitempty"`
	// AccessRules The list of device access rules in Exchange. The access rules apply globally to the entire Exchange organization
	AccessRules []DeviceManagementExchangeAccessRule `json:"accessRules,omitempty"`
	// KnownDeviceClasses The list of device classes known to Exchange
	KnownDeviceClasses []DeviceManagementExchangeDeviceClass `json:"knownDeviceClasses,omitempty"`
	// ConditionalAccessSettings undocumented
	ConditionalAccessSettings *OnPremisesConditionalAccessSettings `json:"conditionalAccessSettings,omitempty"`
}

// DeviceManagementExportJob Entity representing a job to export a report
type DeviceManagementExportJob struct {
	// Entity is the base model of DeviceManagementExportJob
	Entity
	// ReportName Name of the report
	ReportName *string `json:"reportName,omitempty"`
	// Filter Filters applied on the report
	Filter *string `json:"filter,omitempty"`
	// Select Columns selected from the report
	Select []string `json:"select,omitempty"`
	// Format Format of the exported report
	Format *DeviceManagementReportFileFormat `json:"format,omitempty"`
	// SnapshotID A snapshot is an identifiable subset of the dataset represented by the ReportName. A sessionId or CachedReportConfiguration id can be used here. If a sessionId is specified, Filter, Select, and OrderBy are applied to the data represented by the sessionId. Filter, Select, and OrderBy cannot be specified together with a CachedReportConfiguration id.
	SnapshotID *string `json:"snapshotId,omitempty"`
	// Status Status of the export job
	Status *DeviceManagementReportStatus `json:"status,omitempty"`
	// URL Temporary location of the exported report
	URL *string `json:"url,omitempty"`
	// RequestDateTime Time that the exported report was requested
	RequestDateTime *time.Time `json:"requestDateTime,omitempty"`
	// ExpirationDateTime Time that the exported report expires
	ExpirationDateTime *time.Time `json:"expirationDateTime,omitempty"`
}

// DeviceManagementIntegerSettingInstance A setting instance representing an integer value
type DeviceManagementIntegerSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementIntegerSettingInstance
	DeviceManagementSettingInstance
	// Value The integer value
	Value *int `json:"value,omitempty"`
}

// DeviceManagementIntent Entity that represents an intent to apply settings to a device
type DeviceManagementIntent struct {
	// Entity is the base model of DeviceManagementIntent
	Entity
	// DisplayName The user given display name
	DisplayName *string `json:"displayName,omitempty"`
	// Description The user given description
	Description *string `json:"description,omitempty"`
	// IsAssigned Signifies whether or not the intent is assigned to users
	IsAssigned *bool `json:"isAssigned,omitempty"`
	// LastModifiedDateTime When the intent was last modified
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// TemplateID The ID of the template this intent was created from (if any)
	TemplateID *string `json:"templateId,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// Settings undocumented
	Settings []DeviceManagementSettingInstance `json:"settings,omitempty"`
	// Categories undocumented
	Categories []DeviceManagementIntentSettingCategory `json:"categories,omitempty"`
	// Assignments undocumented
	Assignments []DeviceManagementIntentAssignment `json:"assignments,omitempty"`
	// DeviceSettingStateSummaries undocumented
	DeviceSettingStateSummaries []DeviceManagementIntentDeviceSettingStateSummary `json:"deviceSettingStateSummaries,omitempty"`
	// DeviceStates undocumented
	DeviceStates []DeviceManagementIntentDeviceState `json:"deviceStates,omitempty"`
	// UserStates undocumented
	UserStates []DeviceManagementIntentUserState `json:"userStates,omitempty"`
	// DeviceStateSummary undocumented
	DeviceStateSummary *DeviceManagementIntentDeviceStateSummary `json:"deviceStateSummary,omitempty"`
	// UserStateSummary undocumented
	UserStateSummary *DeviceManagementIntentUserStateSummary `json:"userStateSummary,omitempty"`
}

// DeviceManagementIntentAssignment Intent assignment entity
type DeviceManagementIntentAssignment struct {
	// Entity is the base model of DeviceManagementIntentAssignment
	Entity
	// Target The assignment target
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
}

// DeviceManagementIntentDeviceSettingStateSummary Entity that represents device setting state summary for an intent
type DeviceManagementIntentDeviceSettingStateSummary struct {
	// Entity is the base model of DeviceManagementIntentDeviceSettingStateSummary
	Entity
	// SettingName Name of a setting
	SettingName *string `json:"settingName,omitempty"`
	// CompliantCount Number of compliant devices
	CompliantCount *int `json:"compliantCount,omitempty"`
	// ConflictCount Number of devices in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// ErrorCount Number of error devices
	ErrorCount *int `json:"errorCount,omitempty"`
	// NonCompliantCount Number of non compliant devices
	NonCompliantCount *int `json:"nonCompliantCount,omitempty"`
	// NotApplicableCount Number of not applicable devices
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// RemediatedCount Number of remediated devices
	RemediatedCount *int `json:"remediatedCount,omitempty"`
}

// DeviceManagementIntentDeviceState Entity that represents device state for an intent
type DeviceManagementIntentDeviceState struct {
	// Entity is the base model of DeviceManagementIntentDeviceState
	Entity
	// UserPrincipalName The user principal name that is being reported on a device
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// UserName The user name that is being reported on a device
	UserName *string `json:"userName,omitempty"`
	// DeviceDisplayName Device name that is being reported
	DeviceDisplayName *string `json:"deviceDisplayName,omitempty"`
	// LastReportedDateTime Last modified date time of an intent report
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// State Device state for an intent
	State *ComplianceStatus `json:"state,omitempty"`
	// DeviceID Device id that is being reported
	DeviceID *string `json:"deviceId,omitempty"`
}

// DeviceManagementIntentDeviceStateSummary Entity that represents device state summary for an intent
type DeviceManagementIntentDeviceStateSummary struct {
	// Entity is the base model of DeviceManagementIntentDeviceStateSummary
	Entity
	// ConflictCount Number of devices in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// ErrorCount Number of error devices
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed devices
	FailedCount *int `json:"failedCount,omitempty"`
	// NotApplicableCount Number of not applicable devices
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// NotApplicablePlatformCount Number of not applicable devices due to mismatch platform and policy
	NotApplicablePlatformCount *int `json:"notApplicablePlatformCount,omitempty"`
	// SuccessCount Number of succeeded devices
	SuccessCount *int `json:"successCount,omitempty"`
}

// DeviceManagementIntentSettingCategory Entity representing an intent setting category
type DeviceManagementIntentSettingCategory struct {
	// DeviceManagementSettingCategory is the base model of DeviceManagementIntentSettingCategory
	DeviceManagementSettingCategory
	// Settings undocumented
	Settings []DeviceManagementSettingInstance `json:"settings,omitempty"`
}

// DeviceManagementIntentUserState Entity that represents user state for an intent
type DeviceManagementIntentUserState struct {
	// Entity is the base model of DeviceManagementIntentUserState
	Entity
	// UserPrincipalName The user principal name that is being reported on a device
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// UserName The user name that is being reported on a device
	UserName *string `json:"userName,omitempty"`
	// DeviceCount Count of Devices that belongs to a user for an intent
	DeviceCount *int `json:"deviceCount,omitempty"`
	// LastReportedDateTime Last modified date time of an intent report
	LastReportedDateTime *time.Time `json:"lastReportedDateTime,omitempty"`
	// State User state for an intent
	State *ComplianceStatus `json:"state,omitempty"`
}

// DeviceManagementIntentUserStateSummary Entity that represents user state summary for an intent
type DeviceManagementIntentUserStateSummary struct {
	// Entity is the base model of DeviceManagementIntentUserStateSummary
	Entity
	// ConflictCount Number of users in conflict
	ConflictCount *int `json:"conflictCount,omitempty"`
	// ErrorCount Number of error users
	ErrorCount *int `json:"errorCount,omitempty"`
	// FailedCount Number of failed users
	FailedCount *int `json:"failedCount,omitempty"`
	// NotApplicableCount Number of not applicable users
	NotApplicableCount *int `json:"notApplicableCount,omitempty"`
	// SuccessCount Number of succeeded users
	SuccessCount *int `json:"successCount,omitempty"`
}

// DeviceManagementPartner Entity which represents a connection to device management partner.
type DeviceManagementPartner struct {
	// Entity is the base model of DeviceManagementPartner
	Entity
	// LastHeartbeatDateTime Timestamp of last heartbeat after admin enabled option Connect to Device management Partner
	LastHeartbeatDateTime *time.Time `json:"lastHeartbeatDateTime,omitempty"`
	// PartnerState Partner state of this tenant
	PartnerState *DeviceManagementPartnerTenantState `json:"partnerState,omitempty"`
	// PartnerAppType Partner App type
	PartnerAppType *DeviceManagementPartnerAppType `json:"partnerAppType,omitempty"`
	// SingleTenantAppID Partner Single tenant App id
	SingleTenantAppID *string `json:"singleTenantAppId,omitempty"`
	// DisplayName Partner display name
	DisplayName *string `json:"displayName,omitempty"`
	// IsConfigured Whether device management partner is configured or not
	IsConfigured *bool `json:"isConfigured,omitempty"`
	// WhenPartnerDevicesWillBeRemoved DateTime in UTC when PartnerDevices will be removed. This will become obselete soon.
	WhenPartnerDevicesWillBeRemoved *time.Time `json:"whenPartnerDevicesWillBeRemoved,omitempty"`
	// WhenPartnerDevicesWillBeMarkedAsNonCompliant DateTime in UTC when PartnerDevices will be marked as NonCompliant. This will become obselete soon.
	WhenPartnerDevicesWillBeMarkedAsNonCompliant *time.Time `json:"whenPartnerDevicesWillBeMarkedAsNonCompliant,omitempty"`
	// WhenPartnerDevicesWillBeRemovedDateTime DateTime in UTC when PartnerDevices will be removed
	WhenPartnerDevicesWillBeRemovedDateTime *time.Time `json:"whenPartnerDevicesWillBeRemovedDateTime,omitempty"`
	// WhenPartnerDevicesWillBeMarkedAsNonCompliantDateTime DateTime in UTC when PartnerDevices will be marked as NonCompliant
	WhenPartnerDevicesWillBeMarkedAsNonCompliantDateTime *time.Time `json:"whenPartnerDevicesWillBeMarkedAsNonCompliantDateTime,omitempty"`
	// GroupsRequiringPartnerEnrollment User groups that specifies whether enrollment is through partner.
	GroupsRequiringPartnerEnrollment []DeviceManagementPartnerAssignment `json:"groupsRequiringPartnerEnrollment,omitempty"`
}

// DeviceManagementPartnerAssignment undocumented
type DeviceManagementPartnerAssignment struct {
	// Object is the base model of DeviceManagementPartnerAssignment
	Object
	// Target User groups targeting for devices to be enrolled through partner.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
}

// DeviceManagementReportSchedule Entity representing a schedule for which reports are delivered
type DeviceManagementReportSchedule struct {
	// Entity is the base model of DeviceManagementReportSchedule
	Entity
	// ReportScheduleName Name of the schedule
	ReportScheduleName *string `json:"reportScheduleName,omitempty"`
	// Subject Subject of the scheduled reports that are delivered
	Subject *string `json:"subject,omitempty"`
	// Emails Emails to which the scheduled reports are delivered
	Emails []string `json:"emails,omitempty"`
	// Recurrence Frequency of scheduled report delivery
	Recurrence *DeviceManagementScheduledReportRecurrence `json:"recurrence,omitempty"`
	// StartDateTime Time that the delivery of the scheduled reports starts
	StartDateTime *time.Time `json:"startDateTime,omitempty"`
	// EndDateTime Time that the delivery of the scheduled reports ends
	EndDateTime *time.Time `json:"endDateTime,omitempty"`
	// UserID The Id of the User who created the report
	UserID *string `json:"userId,omitempty"`
	// ReportName Name of the report
	ReportName *string `json:"reportName,omitempty"`
	// Filter Filters applied on the report
	Filter *string `json:"filter,omitempty"`
	// Select Columns selected from the report
	Select []string `json:"select,omitempty"`
	// OrderBy Ordering of columns in the report
	OrderBy []string `json:"orderBy,omitempty"`
	// Format Format of the scheduled report
	Format *DeviceManagementReportFileFormat `json:"format,omitempty"`
}

// DeviceManagementReports Singleton entity that acts as a container for all reports functionality.
type DeviceManagementReports struct {
	// Entity is the base model of DeviceManagementReports
	Entity
	// CachedReportConfigurations undocumented
	CachedReportConfigurations []DeviceManagementCachedReportConfiguration `json:"cachedReportConfigurations,omitempty"`
	// ExportJobs undocumented
	ExportJobs []DeviceManagementExportJob `json:"exportJobs,omitempty"`
	// ReportSchedules undocumented
	ReportSchedules []DeviceManagementReportSchedule `json:"reportSchedules,omitempty"`
}

// DeviceManagementScript Intune will provide customer the ability to run their Powershell scripts on the enrolled windows 10 Azure Active Directory joined devices. The script can be run once or periodically.
type DeviceManagementScript struct {
	// Entity is the base model of DeviceManagementScript
	Entity
	// DisplayName Name of the device management script.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Optional description for the device management script.
	Description *string `json:"description,omitempty"`
	// ScriptContent The script content.
	ScriptContent *Binary `json:"scriptContent,omitempty"`
	// CreatedDateTime The date and time the device management script was created. This property is read-only.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime The date and time the device management script was last modified. This property is read-only.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// RunAsAccount Indicates the type of execution context.
	RunAsAccount *RunAsAccountType `json:"runAsAccount,omitempty"`
	// EnforceSignatureCheck Indicate whether the script signature needs be checked.
	EnforceSignatureCheck *bool `json:"enforceSignatureCheck,omitempty"`
	// FileName Script file name.
	FileName *string `json:"fileName,omitempty"`
	// RoleScopeTagIDs List of Scope Tag IDs for this PowerShellScript instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
	// RunAs32Bit A value indicating whether the PowerShell script should run as 32-bit
	RunAs32Bit *bool `json:"runAs32Bit,omitempty"`
	// GroupAssignments undocumented
	GroupAssignments []DeviceManagementScriptGroupAssignment `json:"groupAssignments,omitempty"`
	// Assignments undocumented
	Assignments []DeviceManagementScriptAssignment `json:"assignments,omitempty"`
	// RunSummary undocumented
	RunSummary *DeviceManagementScriptRunSummary `json:"runSummary,omitempty"`
	// DeviceRunStates undocumented
	DeviceRunStates []DeviceManagementScriptDeviceState `json:"deviceRunStates,omitempty"`
	// UserRunStates undocumented
	UserRunStates []DeviceManagementScriptUserState `json:"userRunStates,omitempty"`
}

// DeviceManagementScriptAssignment Contains properties used to assign a device management script to a group.
type DeviceManagementScriptAssignment struct {
	// Entity is the base model of DeviceManagementScriptAssignment
	Entity
	// Target The Id of the Azure Active Directory group we are targeting the script to.
	Target *DeviceAndAppManagementAssignmentTarget `json:"target,omitempty"`
}

// DeviceManagementScriptDeviceState Contains properties for device run state of the device management script.
type DeviceManagementScriptDeviceState struct {
	// Entity is the base model of DeviceManagementScriptDeviceState
	Entity
	// RunState State of latest run of the device management script.
	RunState *RunState `json:"runState,omitempty"`
	// ResultMessage Details of execution output.
	ResultMessage *string `json:"resultMessage,omitempty"`
	// LastStateUpdateDateTime Latest time the device management script executes.
	LastStateUpdateDateTime *time.Time `json:"lastStateUpdateDateTime,omitempty"`
	// ErrorCode Error code corresponding to erroneous execution of the device management script.
	ErrorCode *int `json:"errorCode,omitempty"`
	// ErrorDescription Error description corresponding to erroneous execution of the device management script.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ManagedDevice undocumented
	ManagedDevice *ManagedDevice `json:"managedDevice,omitempty"`
}

// DeviceManagementScriptGroupAssignment Contains properties used to assign a device management script to a group.
type DeviceManagementScriptGroupAssignment struct {
	// Entity is the base model of DeviceManagementScriptGroupAssignment
	Entity
	// TargetGroupID The Id of the Azure Active Directory group we are targeting the script to.
	TargetGroupID *string `json:"targetGroupId,omitempty"`
}

// DeviceManagementScriptPolicySetItem A class containing the properties used for device management script PolicySetItem.
type DeviceManagementScriptPolicySetItem struct {
	// PolicySetItem is the base model of DeviceManagementScriptPolicySetItem
	PolicySetItem
}

// DeviceManagementScriptRunSummary Contains properties for the run summary of a device management script.
type DeviceManagementScriptRunSummary struct {
	// Entity is the base model of DeviceManagementScriptRunSummary
	Entity
	// SuccessDeviceCount Success device count.
	SuccessDeviceCount *int `json:"successDeviceCount,omitempty"`
	// ErrorDeviceCount Error device count.
	ErrorDeviceCount *int `json:"errorDeviceCount,omitempty"`
	// SuccessUserCount Success user count.
	SuccessUserCount *int `json:"successUserCount,omitempty"`
	// ErrorUserCount Error user count.
	ErrorUserCount *int `json:"errorUserCount,omitempty"`
}

// DeviceManagementScriptUserState Contains properties for user run state of the device management script.
type DeviceManagementScriptUserState struct {
	// Entity is the base model of DeviceManagementScriptUserState
	Entity
	// SuccessDeviceCount Success device count for specific user.
	SuccessDeviceCount *int `json:"successDeviceCount,omitempty"`
	// ErrorDeviceCount Error device count for specific user.
	ErrorDeviceCount *int `json:"errorDeviceCount,omitempty"`
	// UserPrincipalName User principle name of specific user.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// DeviceRunStates undocumented
	DeviceRunStates []DeviceManagementScriptDeviceState `json:"deviceRunStates,omitempty"`
}

// DeviceManagementSettingBooleanConstraint undocumented
type DeviceManagementSettingBooleanConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementSettingBooleanConstraint
	DeviceManagementConstraint
	// Value The boolean value to compare against
	Value *bool `json:"value,omitempty"`
}

// DeviceManagementSettingCategory Entity representing a setting category
type DeviceManagementSettingCategory struct {
	// Entity is the base model of DeviceManagementSettingCategory
	Entity
	// DisplayName The category name
	DisplayName *string `json:"displayName,omitempty"`
	// SettingDefinitions undocumented
	SettingDefinitions []DeviceManagementSettingDefinition `json:"settingDefinitions,omitempty"`
}

// DeviceManagementSettingComparison undocumented
type DeviceManagementSettingComparison struct {
	// Object is the base model of DeviceManagementSettingComparison
	Object
	// ID The setting ID
	ID *string `json:"id,omitempty"`
	// DisplayName The setting's display name
	DisplayName *string `json:"displayName,omitempty"`
	// DefinitionID The ID of the setting definition for this instance
	DefinitionID *string `json:"definitionId,omitempty"`
	// CurrentValueJSON JSON representation of current intent (or) template setting's value
	CurrentValueJSON *string `json:"currentValueJson,omitempty"`
	// NewValueJSON JSON representation of new template setting's value
	NewValueJSON *string `json:"newValueJson,omitempty"`
	// ComparisonResult Setting comparison result
	ComparisonResult *DeviceManagementComparisonResult `json:"comparisonResult,omitempty"`
}

// DeviceManagementSettingDefinition Entity representing the defintion for a given setting
type DeviceManagementSettingDefinition struct {
	// Entity is the base model of DeviceManagementSettingDefinition
	Entity
	// ValueType The data type of the value
	ValueType *DeviceManangementIntentValueType `json:"valueType,omitempty"`
	// DisplayName The setting's display name
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopLevel If the setting is top level, it can be configured without the need to be wrapped in a collection or complex setting
	IsTopLevel *bool `json:"isTopLevel,omitempty"`
	// Description The setting's description
	Description *string `json:"description,omitempty"`
	// DocumentationURL Url to setting documentation
	DocumentationURL *string `json:"documentationUrl,omitempty"`
	// Keywords Keywords associated with the setting
	Keywords []string `json:"keywords,omitempty"`
	// Constraints Collection of constraints for the setting value
	Constraints []DeviceManagementConstraint `json:"constraints,omitempty"`
	// Dependencies Collection of dependencies on other settings
	Dependencies []DeviceManagementSettingDependency `json:"dependencies,omitempty"`
}

// DeviceManagementSettingDependency undocumented
type DeviceManagementSettingDependency struct {
	// Object is the base model of DeviceManagementSettingDependency
	Object
	// DefinitionID The setting definition ID of the setting depended on
	DefinitionID *string `json:"definitionId,omitempty"`
	// Constraints Collection of constraints for the dependency setting value
	Constraints []DeviceManagementConstraint `json:"constraints,omitempty"`
}

// DeviceManagementSettingInstance Base type for a setting instance
type DeviceManagementSettingInstance struct {
	// Entity is the base model of DeviceManagementSettingInstance
	Entity
	// DefinitionID The ID of the setting definition for this instance
	DefinitionID *string `json:"definitionId,omitempty"`
	// ValueJSON JSON representation of the value
	ValueJSON *string `json:"valueJson,omitempty"`
}

// DeviceManagementSettingIntegerConstraint undocumented
type DeviceManagementSettingIntegerConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementSettingIntegerConstraint
	DeviceManagementConstraint
	// MinimumValue The minimum permitted value
	MinimumValue *int `json:"minimumValue,omitempty"`
	// MaximumValue The maximum permitted value
	MaximumValue *int `json:"maximumValue,omitempty"`
}

// DeviceManagementSettingRegexConstraint undocumented
type DeviceManagementSettingRegexConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementSettingRegexConstraint
	DeviceManagementConstraint
	// Regex The RegEx pattern to match against
	Regex *string `json:"regex,omitempty"`
}

// DeviceManagementSettingStringLengthConstraint undocumented
type DeviceManagementSettingStringLengthConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementSettingStringLengthConstraint
	DeviceManagementConstraint
	// MinimumLength The minimum permitted string length
	MinimumLength *int `json:"minimumLength,omitempty"`
	// MaximumLength The maximum permitted string length
	MaximumLength *int `json:"maximumLength,omitempty"`
}

// DeviceManagementSettingXMLConstraint undocumented
type DeviceManagementSettingXMLConstraint struct {
	// DeviceManagementConstraint is the base model of DeviceManagementSettingXMLConstraint
	DeviceManagementConstraint
}

// DeviceManagementSettings undocumented
type DeviceManagementSettings struct {
	// Object is the base model of DeviceManagementSettings
	Object
	// DeviceComplianceCheckinThresholdDays The number of days a device is allowed to go without checking in to remain compliant.
	DeviceComplianceCheckinThresholdDays *int `json:"deviceComplianceCheckinThresholdDays,omitempty"`
	// IsScheduledActionEnabled Is feature enabled or not for scheduled action for rule.
	IsScheduledActionEnabled *bool `json:"isScheduledActionEnabled,omitempty"`
	// SecureByDefault Device should be noncompliant when there is no compliance policy targeted when this is true
	SecureByDefault *bool `json:"secureByDefault,omitempty"`
	// EnhancedJailBreak Is feature enabled or not for enhanced jailbreak detection.
	EnhancedJailBreak *bool `json:"enhancedJailBreak,omitempty"`
	// DeviceInactivityBeforeRetirementInDay When the device does not check in for specified number of days, the company data might be removed and the device will not be under management. Valid values 30 to 270
	DeviceInactivityBeforeRetirementInDay *int `json:"deviceInactivityBeforeRetirementInDay,omitempty"`
	// DerivedCredentialProvider The Derived Credential Provider to use for this account.
	DerivedCredentialProvider *DerivedCredentialProviderType `json:"derivedCredentialProvider,omitempty"`
	// DerivedCredentialURL The Derived Credential Provider self-service URI.
	DerivedCredentialURL *string `json:"derivedCredentialUrl,omitempty"`
	// AndroidDeviceAdministratorEnrollmentEnabled The property to determine if Android device administrator enrollment is enabled for this account.
	AndroidDeviceAdministratorEnrollmentEnabled *bool `json:"androidDeviceAdministratorEnrollmentEnabled,omitempty"`
}

// DeviceManagementStringSettingInstance A setting instance representing a string value
type DeviceManagementStringSettingInstance struct {
	// DeviceManagementSettingInstance is the base model of DeviceManagementStringSettingInstance
	DeviceManagementSettingInstance
	// Value The string value
	Value *string `json:"value,omitempty"`
}

// DeviceManagementTemplate Entity that represents a defined collection of device settings
type DeviceManagementTemplate struct {
	// Entity is the base model of DeviceManagementTemplate
	Entity
	// DisplayName The template's display name
	DisplayName *string `json:"displayName,omitempty"`
	// Description The template's description
	Description *string `json:"description,omitempty"`
	// VersionInfo The template's version information
	VersionInfo *string `json:"versionInfo,omitempty"`
	// IsDeprecated The template is deprecated or not. Intents cannot be created from a deprecated template.
	IsDeprecated *bool `json:"isDeprecated,omitempty"`
	// IntentCount Number of Intents created from this template.
	IntentCount *int `json:"intentCount,omitempty"`
	// TemplateType The template's type.
	TemplateType *DeviceManagementTemplateType `json:"templateType,omitempty"`
	// PlatformType The template's platform.
	PlatformType *PolicyPlatformType `json:"platformType,omitempty"`
	// PublishedDateTime When the template was published
	PublishedDateTime *time.Time `json:"publishedDateTime,omitempty"`
	// Settings undocumented
	Settings []DeviceManagementSettingInstance `json:"settings,omitempty"`
	// Categories undocumented
	Categories []DeviceManagementTemplateSettingCategory `json:"categories,omitempty"`
	// MigratableTo undocumented
	MigratableTo []DeviceManagementTemplate `json:"migratableTo,omitempty"`
}

// DeviceManagementTemplateSettingCategory Entity representing a template setting category
type DeviceManagementTemplateSettingCategory struct {
	// DeviceManagementSettingCategory is the base model of DeviceManagementTemplateSettingCategory
	DeviceManagementSettingCategory
	// RecommendedSettings undocumented
	RecommendedSettings []DeviceManagementSettingInstance `json:"recommendedSettings,omitempty"`
}

// DeviceManagementTroubleshootingErrorDetails undocumented
type DeviceManagementTroubleshootingErrorDetails struct {
	// Object is the base model of DeviceManagementTroubleshootingErrorDetails
	Object
	// Context undocumented
	Context *string `json:"context,omitempty"`
	// Failure undocumented
	Failure *string `json:"failure,omitempty"`
	// FailureDetails The detailed description of what went wrong.
	FailureDetails *string `json:"failureDetails,omitempty"`
	// Remediation The detailed description of how to remediate this issue.
	Remediation *string `json:"remediation,omitempty"`
	// Resources Links to helpful documentation about this failure.
	Resources []DeviceManagementTroubleshootingErrorResource `json:"resources,omitempty"`
}

// DeviceManagementTroubleshootingErrorResource undocumented
type DeviceManagementTroubleshootingErrorResource struct {
	// Object is the base model of DeviceManagementTroubleshootingErrorResource
	Object
	// Text undocumented
	Text *string `json:"text,omitempty"`
	// Link The link to the web resource. Can contain any of the following formatters: {{UPN}}, {{DeviceGUID}}, {{UserGUID}}
	Link *string `json:"link,omitempty"`
}

// DeviceManagementTroubleshootingEvent Event representing an general failure.
type DeviceManagementTroubleshootingEvent struct {
	// Entity is the base model of DeviceManagementTroubleshootingEvent
	Entity
	// EventDateTime Time when the event occurred .
	EventDateTime *time.Time `json:"eventDateTime,omitempty"`
	// CorrelationID Id used for tracing the failure in the service.
	CorrelationID *string `json:"correlationId,omitempty"`
	// TroubleshootingErrorDetails Object containing detailed information about the error and its remediation.
	TroubleshootingErrorDetails *DeviceManagementTroubleshootingErrorDetails `json:"troubleshootingErrorDetails,omitempty"`
	// EventName Event Name corresponding to the Troubleshooting Event. It is an Optional field
	EventName *string `json:"eventName,omitempty"`
	// AdditionalInformation A set of string key and string value pairs which provides additional information on the Troubleshooting event
	AdditionalInformation []KeyValuePair `json:"additionalInformation,omitempty"`
}

// DeviceManagementUserRightsLocalUserOrGroup undocumented
type DeviceManagementUserRightsLocalUserOrGroup struct {
	// Object is the base model of DeviceManagementUserRightsLocalUserOrGroup
	Object
	// Name The name of this local user or group.
	Name *string `json:"name,omitempty"`
	// Description Admin’s description of this local user or group.
	Description *string `json:"description,omitempty"`
	// SecurityIdentifier The security identifier of this local user or group (e.g. *S-1-5-32-544).
	SecurityIdentifier *string `json:"securityIdentifier,omitempty"`
}

// DeviceManagementUserRightsSetting undocumented
type DeviceManagementUserRightsSetting struct {
	// Object is the base model of DeviceManagementUserRightsSetting
	Object
	// State Representing the current state of this user rights setting
	State *StateManagementSetting `json:"state,omitempty"`
	// LocalUsersOrGroups Representing a collection of local users or groups which will be set on device if the state of this setting is Allowed. This collection can contain a maximum of 500 elements.
	LocalUsersOrGroups []DeviceManagementUserRightsLocalUserOrGroup `json:"localUsersOrGroups,omitempty"`
}

// DeviceOperatingSystemSummary undocumented
type DeviceOperatingSystemSummary struct {
	// Object is the base model of DeviceOperatingSystemSummary
	Object
	// AndroidCount Number of android device count.
	AndroidCount *int `json:"androidCount,omitempty"`
	// IOSCount Number of iOS device count.
	IOSCount *int `json:"iosCount,omitempty"`
	// MacOSCount Number of Mac OS X device count.
	MacOSCount *int `json:"macOSCount,omitempty"`
	// WindowsMobileCount Number of Windows mobile device count.
	WindowsMobileCount *int `json:"windowsMobileCount,omitempty"`
	// WindowsCount Number of Windows device count.
	WindowsCount *int `json:"windowsCount,omitempty"`
	// UnknownCount Number of unknown device count.
	UnknownCount *int `json:"unknownCount,omitempty"`
	// AndroidDedicatedCount Number of dedicated Android devices.
	AndroidDedicatedCount *int `json:"androidDedicatedCount,omitempty"`
	// AndroidDeviceAdminCount Number of device admin Android devices.
	AndroidDeviceAdminCount *int `json:"androidDeviceAdminCount,omitempty"`
	// AndroidFullyManagedCount Number of fully managed Android devices.
	AndroidFullyManagedCount *int `json:"androidFullyManagedCount,omitempty"`
	// AndroidWorkProfileCount Number of work profile Android devices.
	AndroidWorkProfileCount *int `json:"androidWorkProfileCount,omitempty"`
}

// DeviceProtectionOverview undocumented
type DeviceProtectionOverview struct {
	// Object is the base model of DeviceProtectionOverview
	Object
	// TotalReportedDeviceCount Total device count.
	TotalReportedDeviceCount *int `json:"totalReportedDeviceCount,omitempty"`
	// InactiveThreatAgentDeviceCount Device with inactive threat agent count
	InactiveThreatAgentDeviceCount *int `json:"inactiveThreatAgentDeviceCount,omitempty"`
	// UnknownStateThreatAgentDeviceCount Device with threat agent state as unknown count.
	UnknownStateThreatAgentDeviceCount *int `json:"unknownStateThreatAgentDeviceCount,omitempty"`
	// PendingSignatureUpdateDeviceCount Device with old signature count.
	PendingSignatureUpdateDeviceCount *int `json:"pendingSignatureUpdateDeviceCount,omitempty"`
	// CleanDeviceCount Clean device count.
	CleanDeviceCount *int `json:"cleanDeviceCount,omitempty"`
	// PendingFullScanDeviceCount Pending full scan device count.
	PendingFullScanDeviceCount *int `json:"pendingFullScanDeviceCount,omitempty"`
	// PendingRestartDeviceCount Pending restart device count.
	PendingRestartDeviceCount *int `json:"pendingRestartDeviceCount,omitempty"`
	// PendingManualStepsDeviceCount Pending manual steps device count.
	PendingManualStepsDeviceCount *int `json:"pendingManualStepsDeviceCount,omitempty"`
	// PendingOfflineScanDeviceCount Pending offline scan device count.
	PendingOfflineScanDeviceCount *int `json:"pendingOfflineScanDeviceCount,omitempty"`
	// CriticalFailuresDeviceCount Critical failures device count.
	CriticalFailuresDeviceCount *int `json:"criticalFailuresDeviceCount,omitempty"`
}

// DeviceRestrictionAction undocumented
type DeviceRestrictionAction struct {
	// DlpActionInfo is the base model of DeviceRestrictionAction
	DlpActionInfo
	// RestrictionAction undocumented
	RestrictionAction *RestrictionAction `json:"restrictionAction,omitempty"`
	// Triggers undocumented
	Triggers []RestrictionTrigger `json:"triggers,omitempty"`
	// Message undocumented
	Message *string `json:"message,omitempty"`
}

// DeviceSetupConfiguration This is the base class for Setup Configuration. Setup configurations are platform specific and individual per-platform setup configurations inherit from here.
type DeviceSetupConfiguration struct {
	// Entity is the base model of DeviceSetupConfiguration
	Entity
	// CreatedDateTime DateTime the object was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// Description Admin provided description of the Device Configuration.
	Description *string `json:"description,omitempty"`
	// LastModifiedDateTime DateTime the object was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// DisplayName Admin provided name of the device configuration.
	DisplayName *string `json:"displayName,omitempty"`
	// Version Version of the device configuration.
	Version *int `json:"version,omitempty"`
}
