// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import "time"

// AndroidCertificateProfileBase Android certificate profile base.
type AndroidCertificateProfileBase struct {
	// DeviceConfiguration is the base model of AndroidCertificateProfileBase
	DeviceConfiguration
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *SubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name Type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// RootCertificate undocumented
	RootCertificate *AndroidTrustedRootCertificate `json:"rootCertificate,omitempty"`
}

// AndroidCompliancePolicy This class contains compliance settings for Android.
type AndroidCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of AndroidCompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Require a password to unlock device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordMinimumLength Minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordRequiredType Type of characters in password
	PasswordRequiredType *AndroidRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 1 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign-in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// SecurityPreventInstallAppsFromUnknownSources Require that devices disallow installation of apps from unknown sources.
	SecurityPreventInstallAppsFromUnknownSources *bool `json:"securityPreventInstallAppsFromUnknownSources,omitempty"`
	// SecurityDisableUsbDebugging Disable USB debugging on Android devices.
	SecurityDisableUsbDebugging *bool `json:"securityDisableUsbDebugging,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// SecurityBlockJailbrokenDevices Devices must not be jailbroken or rooted.
	SecurityBlockJailbrokenDevices *bool `json:"securityBlockJailbrokenDevices,omitempty"`
	// OsMinimumVersion Minimum Android version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Android version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// MinAndroidSecurityPatchLevel Minimum Android security patch level.
	MinAndroidSecurityPatchLevel *string `json:"minAndroidSecurityPatchLevel,omitempty"`
	// StorageRequireEncryption Require encryption on Android devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// SecurityRequireSafetyNetAttestationBasicIntegrity Require the device to pass the SafetyNet basic integrity check.
	SecurityRequireSafetyNetAttestationBasicIntegrity *bool `json:"securityRequireSafetyNetAttestationBasicIntegrity,omitempty"`
	// SecurityRequireSafetyNetAttestationCertifiedDevice Require the device to pass the SafetyNet certified device check.
	SecurityRequireSafetyNetAttestationCertifiedDevice *bool `json:"securityRequireSafetyNetAttestationCertifiedDevice,omitempty"`
	// SecurityRequireGooglePlayServices Require Google Play Services to be installed and enabled on the device.
	SecurityRequireGooglePlayServices *bool `json:"securityRequireGooglePlayServices,omitempty"`
	// SecurityRequireUpToDateSecurityProviders Require the device to have up to date security providers. The device will require Google Play Services to be enabled and up to date.
	SecurityRequireUpToDateSecurityProviders *bool `json:"securityRequireUpToDateSecurityProviders,omitempty"`
	// SecurityRequireCompanyPortalAppIntegrity Require the device to pass the Company Portal client app runtime integrity check.
	SecurityRequireCompanyPortalAppIntegrity *bool `json:"securityRequireCompanyPortalAppIntegrity,omitempty"`
	// ConditionStatementID Condition statement id.
	ConditionStatementID *string `json:"conditionStatementId,omitempty"`
	// RestrictedApps Require the device to not have the specified apps installed. This collection can contain a maximum of 100 elements.
	RestrictedApps []AppListItem `json:"restrictedApps,omitempty"`
}

// AndroidCustomConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the androidCustomConfiguration resource.
type AndroidCustomConfiguration struct {
	// DeviceConfiguration is the base model of AndroidCustomConfiguration
	DeviceConfiguration
	// OMASettings OMA settings. This collection can contain a maximum of 1000 elements.
	OMASettings []OMASetting `json:"omaSettings,omitempty"`
}

// AndroidDeviceComplianceLocalActionBase Local Action Configuration
type AndroidDeviceComplianceLocalActionBase struct {
	// Entity is the base model of AndroidDeviceComplianceLocalActionBase
	Entity
	// GracePeriodInMinutes Number of minutes to wait till a local action is enforced. Valid values 0 to 2147483647
	GracePeriodInMinutes *int `json:"gracePeriodInMinutes,omitempty"`
}

// AndroidDeviceComplianceLocalActionLockDevice Local Action Lock Device Only Configuration
type AndroidDeviceComplianceLocalActionLockDevice struct {
	// AndroidDeviceComplianceLocalActionBase is the base model of AndroidDeviceComplianceLocalActionLockDevice
	AndroidDeviceComplianceLocalActionBase
}

// AndroidDeviceComplianceLocalActionLockDeviceWithPasscode Local Action Lock Device with Passcode Configuration
type AndroidDeviceComplianceLocalActionLockDeviceWithPasscode struct {
	// AndroidDeviceComplianceLocalActionBase is the base model of AndroidDeviceComplianceLocalActionLockDeviceWithPasscode
	AndroidDeviceComplianceLocalActionBase
	// Passcode Passcode to reset to Android device. This property is read-only.
	Passcode *string `json:"passcode,omitempty"`
	// PasscodeSignInFailureCountBeforeWipe Number of sign in failures before wiping device, the value can be 4-11. Valid values 4 to 11
	PasscodeSignInFailureCountBeforeWipe *int `json:"passcodeSignInFailureCountBeforeWipe,omitempty"`
}

// AndroidDeviceOwnerCertificateProfileBase Android Device Owner certificate profile base.
type AndroidDeviceOwnerCertificateProfileBase struct {
	// DeviceConfiguration is the base model of AndroidDeviceOwnerCertificateProfileBase
	DeviceConfiguration
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *SubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name Type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// RootCertificate undocumented
	RootCertificate *AndroidDeviceOwnerTrustedRootCertificate `json:"rootCertificate,omitempty"`
}

// AndroidDeviceOwnerCompliancePolicy This topic provides descriptions of the declared methods, properties and relationships exposed by the AndroidDeviceOwnerCompliancePolicy resource.
type AndroidDeviceOwnerCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of AndroidDeviceOwnerCompliancePolicy
	DeviceCompliancePolicy
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// SecurityRequireSafetyNetAttestationBasicIntegrity Require the device to pass the SafetyNet basic integrity check.
	SecurityRequireSafetyNetAttestationBasicIntegrity *bool `json:"securityRequireSafetyNetAttestationBasicIntegrity,omitempty"`
	// SecurityRequireSafetyNetAttestationCertifiedDevice Require the device to pass the SafetyNet certified device check.
	SecurityRequireSafetyNetAttestationCertifiedDevice *bool `json:"securityRequireSafetyNetAttestationCertifiedDevice,omitempty"`
	// OsMinimumVersion Minimum Android version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Android version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// MinAndroidSecurityPatchLevel Minimum Android security patch level.
	MinAndroidSecurityPatchLevel *string `json:"minAndroidSecurityPatchLevel,omitempty"`
	// PasswordRequired Require a password to unlock device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordMinimumLength Minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinimumLetterCharacters Indicates the minimum number of letter characters required for device password. Valid values 1 to 16
	PasswordMinimumLetterCharacters *int `json:"passwordMinimumLetterCharacters,omitempty"`
	// PasswordMinimumLowerCaseCharacters Indicates the minimum number of lower case characters required for device password. Valid values 1 to 16
	PasswordMinimumLowerCaseCharacters *int `json:"passwordMinimumLowerCaseCharacters,omitempty"`
	// PasswordMinimumNonLetterCharacters Indicates the minimum number of non-letter characters required for device password. Valid values 1 to 16
	PasswordMinimumNonLetterCharacters *int `json:"passwordMinimumNonLetterCharacters,omitempty"`
	// PasswordMinimumNumericCharacters Indicates the minimum number of numeric characters required for device password. Valid values 1 to 16
	PasswordMinimumNumericCharacters *int `json:"passwordMinimumNumericCharacters,omitempty"`
	// PasswordMinimumSymbolCharacters Indicates the minimum number of symbol characters required for device password. Valid values 1 to 16
	PasswordMinimumSymbolCharacters *int `json:"passwordMinimumSymbolCharacters,omitempty"`
	// PasswordMinimumUpperCaseCharacters Indicates the minimum number of upper case letter characters required for device password. Valid values 1 to 16
	PasswordMinimumUpperCaseCharacters *int `json:"passwordMinimumUpperCaseCharacters,omitempty"`
	// PasswordRequiredType Type of characters in password
	PasswordRequiredType *AndroidDeviceOwnerRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordPreviousPasswordCountToBlock Number of previous passwords to block. Valid values 1 to 24
	PasswordPreviousPasswordCountToBlock *int `json:"passwordPreviousPasswordCountToBlock,omitempty"`
	// StorageRequireEncryption Require encryption on Android devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
}

// AndroidDeviceOwnerEnrollmentProfile Enrollment Profile used to enroll COSU devices using Google's Cloud Management.
type AndroidDeviceOwnerEnrollmentProfile struct {
	// Entity is the base model of AndroidDeviceOwnerEnrollmentProfile
	Entity
	// AccountID Tenant GUID the enrollment profile belongs to.
	AccountID *string `json:"accountId,omitempty"`
	// DisplayName Display name for the enrollment profile.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description for the enrollment profile.
	Description *string `json:"description,omitempty"`
	// CreatedDateTime Date time the enrollment profile was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime Date time the enrollment profile was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// TokenValue Value of the most recently created token for this enrollment profile.
	TokenValue *string `json:"tokenValue,omitempty"`
	// TokenCreationDateTime Date time the most recently created token was created.
	TokenCreationDateTime *time.Time `json:"tokenCreationDateTime,omitempty"`
	// TokenExpirationDateTime Date time the most recently created token will expire.
	TokenExpirationDateTime *time.Time `json:"tokenExpirationDateTime,omitempty"`
	// EnrolledDeviceCount Total number of Android devices that have enrolled using this enrollment profile.
	EnrolledDeviceCount *int `json:"enrolledDeviceCount,omitempty"`
	// QrCodeContent String used to generate a QR code for the token.
	QrCodeContent *string `json:"qrCodeContent,omitempty"`
	// QrCodeImage String used to generate a QR code for the token.
	QrCodeImage *MimeContent `json:"qrCodeImage,omitempty"`
	// RoleScopeTagIDs List of Scope Tags for this Entity instance.
	RoleScopeTagIDs []string `json:"roleScopeTagIds,omitempty"`
}

// AndroidDeviceOwnerEnterpriseWiFiConfiguration By providing the configurations in this profile you can instruct the Android Device Owner device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type AndroidDeviceOwnerEnterpriseWiFiConfiguration struct {
	// AndroidDeviceOwnerWiFiConfiguration is the base model of AndroidDeviceOwnerEnterpriseWiFiConfiguration
	AndroidDeviceOwnerWiFiConfiguration
	// EapType Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *AndroidEapType `json:"eapType,omitempty"`
	// AuthenticationMethod Indicates the Authentication Method the client (device) needs to use when the EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// InnerAuthenticationProtocolForPeap Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForPeap *NonEapAuthenticationMethodForPeap `json:"innerAuthenticationProtocolForPeap,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS or PEAP. The String provided here is used to mask the username of individual users when they attempt to connect to Wi-Fi network.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *AndroidDeviceOwnerTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *AndroidDeviceOwnerCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// AndroidDeviceOwnerGeneralDeviceConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the androidDeviceOwnerGeneralDeviceConfiguration resource.
type AndroidDeviceOwnerGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of AndroidDeviceOwnerGeneralDeviceConfiguration
	DeviceConfiguration
	// AccountsBlockModification Indicates whether or not adding or removing accounts is disabled.
	AccountsBlockModification *bool `json:"accountsBlockModification,omitempty"`
	// AppsAllowInstallFromUnknownSources Indicates whether or not the user is allowed to enable to unknown sources setting.
	AppsAllowInstallFromUnknownSources *bool `json:"appsAllowInstallFromUnknownSources,omitempty"`
	// AppsAutoUpdatePolicy Indicates the value of the app auto update policy.
	AppsAutoUpdatePolicy *AndroidDeviceOwnerAppAutoUpdatePolicyType `json:"appsAutoUpdatePolicy,omitempty"`
	// AppsDefaultPermissionPolicy Indicates the permission policy for requests for runtime permissions if one is not defined for the app specifically.
	AppsDefaultPermissionPolicy *AndroidDeviceOwnerDefaultAppPermissionPolicyType `json:"appsDefaultPermissionPolicy,omitempty"`
	// AppsRecommendSkippingFirstUseHints Whether or not to recommend all apps skip any first-time-use hints they may have added.
	AppsRecommendSkippingFirstUseHints *bool `json:"appsRecommendSkippingFirstUseHints,omitempty"`
	// BluetoothBlockConfiguration Indicates whether or not to block a user from configuring bluetooth.
	BluetoothBlockConfiguration *bool `json:"bluetoothBlockConfiguration,omitempty"`
	// BluetoothBlockContactSharing Indicates whether or not to block a user from sharing contacts via bluetooth.
	BluetoothBlockContactSharing *bool `json:"bluetoothBlockContactSharing,omitempty"`
	// CameraBlocked Indicates whether or not to disable the use of the camera.
	CameraBlocked *bool `json:"cameraBlocked,omitempty"`
	// CellularBlockWiFiTethering Indicates whether or not to block Wi-Fi tethering.
	CellularBlockWiFiTethering *bool `json:"cellularBlockWiFiTethering,omitempty"`
	// DataRoamingBlocked Indicates whether or not to block a user from data roaming.
	DataRoamingBlocked *bool `json:"dataRoamingBlocked,omitempty"`
	// DateTimeConfigurationBlocked Indicates whether or not to block the user from manually changing the date or time on the device
	DateTimeConfigurationBlocked *bool `json:"dateTimeConfigurationBlocked,omitempty"`
	// FactoryResetDeviceAdministratorEmails List of Google account emails that will be required to authenticate after a device is factory reset before it can be set up.
	FactoryResetDeviceAdministratorEmails []string `json:"factoryResetDeviceAdministratorEmails,omitempty"`
	// FactoryResetBlocked Indicates whether or not the factory reset option in settings is disabled.
	FactoryResetBlocked *bool `json:"factoryResetBlocked,omitempty"`
	// GlobalProxy Proxy is set up directly with host, port and excluded hosts.
	GlobalProxy *AndroidDeviceOwnerGlobalProxy `json:"globalProxy,omitempty"`
	// GoogleAccountsBlocked Indicates whether or not google accounts will be blocked.
	GoogleAccountsBlocked *bool `json:"googleAccountsBlocked,omitempty"`
	// KioskModeScreenSaverConfigurationEnabled Whether or not to enable screen saver mode or not in Kiosk Mode.
	KioskModeScreenSaverConfigurationEnabled *bool `json:"kioskModeScreenSaverConfigurationEnabled,omitempty"`
	// KioskModeScreenSaverImageURL URL for an image that will be the device's screen saver in Kiosk Mode.
	KioskModeScreenSaverImageURL *string `json:"kioskModeScreenSaverImageUrl,omitempty"`
	// KioskModeScreenSaverDisplayTimeInSeconds The number of seconds that the device will display the screen saver for in Kiosk Mode. Valid values 0 to 9999999
	KioskModeScreenSaverDisplayTimeInSeconds *int `json:"kioskModeScreenSaverDisplayTimeInSeconds,omitempty"`
	// KioskModeScreenSaverStartDelayInSeconds The number of seconds the device needs to be inactive for before the screen saver is shown in Kiosk Mode. Valid values 1 to 9999999
	KioskModeScreenSaverStartDelayInSeconds *int `json:"kioskModeScreenSaverStartDelayInSeconds,omitempty"`
	// KioskModeScreenSaverDetectMediaDisabled Whether or not the device screen should show the screen saver if audio/video is playing in Kiosk Mode.
	KioskModeScreenSaverDetectMediaDisabled *bool `json:"kioskModeScreenSaverDetectMediaDisabled,omitempty"`
	// KioskModeApps A list of managed apps that will be shown when the device is in Kiosk Mode. This collection can contain a maximum of 500 elements.
	KioskModeApps []AppListItem `json:"kioskModeApps,omitempty"`
	// KioskModeWallpaperURL URL to a publicly accessible image to use for the wallpaper when the device is in Kiosk Mode.
	KioskModeWallpaperURL *string `json:"kioskModeWallpaperUrl,omitempty"`
	// KioskModeExitCode Exit code to allow a user to escape from Kiosk Mode when the device is in Kiosk Mode.
	KioskModeExitCode *string `json:"kioskModeExitCode,omitempty"`
	// KioskModeVirtualHomeButtonEnabled Whether or not to display a virtual home button when the device is in Kiosk Mode.
	KioskModeVirtualHomeButtonEnabled *bool `json:"kioskModeVirtualHomeButtonEnabled,omitempty"`
	// KioskModeVirtualHomeButtonType Indicates whether the virtual home button is a swipe up home button or a floating home button.
	KioskModeVirtualHomeButtonType *AndroidDeviceOwnerVirtualHomeButtonType `json:"kioskModeVirtualHomeButtonType,omitempty"`
	// KioskModeBluetoothConfigurationEnabled Whether or not to allow a user to configure Bluetooth settings in Kiosk Mode.
	KioskModeBluetoothConfigurationEnabled *bool `json:"kioskModeBluetoothConfigurationEnabled,omitempty"`
	// KioskModeWiFiConfigurationEnabled Whether or not to allow a user to configure Wi-Fi settings in Kiosk Mode.
	KioskModeWiFiConfigurationEnabled *bool `json:"kioskModeWiFiConfigurationEnabled,omitempty"`
	// KioskModeFlashlightConfigurationEnabled Whether or not to allow a user to use the flashlight in Kiosk Mode.
	KioskModeFlashlightConfigurationEnabled *bool `json:"kioskModeFlashlightConfigurationEnabled,omitempty"`
	// KioskModeMediaVolumeConfigurationEnabled Whether or not to allow a user to change the media volume in Kiosk Mode.
	KioskModeMediaVolumeConfigurationEnabled *bool `json:"kioskModeMediaVolumeConfigurationEnabled,omitempty"`
	// MicrophoneForceMute Indicates whether or not to block unmuting the microphone on the device.
	MicrophoneForceMute *bool `json:"microphoneForceMute,omitempty"`
	// NetworkEscapeHatchAllowed Indicates whether or not the device will allow connecting to a temporary network connection at boot time.
	NetworkEscapeHatchAllowed *bool `json:"networkEscapeHatchAllowed,omitempty"`
	// NfcBlockOutgoingBeam Indicates whether or not to block NFC outgoing beam.
	NfcBlockOutgoingBeam *bool `json:"nfcBlockOutgoingBeam,omitempty"`
	// PasswordBlockKeyguard Indicates whether or not the keyguard is disabled.
	PasswordBlockKeyguard *bool `json:"passwordBlockKeyguard,omitempty"`
	// PasswordBlockKeyguardFeatures List of device keyguard features to block. This collection can contain a maximum of 7 elements.
	PasswordBlockKeyguardFeatures []AndroidKeyguardFeature `json:"passwordBlockKeyguardFeatures,omitempty"`
	// PasswordExpirationDays Indicates the amount of time in seconds that a password can be set for before it expires and a new password will be required. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength Indicates the minimum length of the password required on the device. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinimumLetterCharacters Indicates the minimum number of letter characters required for device password. Valid values 1 to 16
	PasswordMinimumLetterCharacters *int `json:"passwordMinimumLetterCharacters,omitempty"`
	// PasswordMinimumLowerCaseCharacters Indicates the minimum number of lower case characters required for device password. Valid values 1 to 16
	PasswordMinimumLowerCaseCharacters *int `json:"passwordMinimumLowerCaseCharacters,omitempty"`
	// PasswordMinimumNonLetterCharacters Indicates the minimum number of non-letter characters required for device password. Valid values 1 to 16
	PasswordMinimumNonLetterCharacters *int `json:"passwordMinimumNonLetterCharacters,omitempty"`
	// PasswordMinimumNumericCharacters Indicates the minimum number of numeric characters required for device password. Valid values 1 to 16
	PasswordMinimumNumericCharacters *int `json:"passwordMinimumNumericCharacters,omitempty"`
	// PasswordMinimumSymbolCharacters Indicates the minimum number of symbol characters required for device password. Valid values 1 to 16
	PasswordMinimumSymbolCharacters *int `json:"passwordMinimumSymbolCharacters,omitempty"`
	// PasswordMinimumUpperCaseCharacters Indicates the minimum number of upper caseletter characters required for device password. Valid values 1 to 16
	PasswordMinimumUpperCaseCharacters *int `json:"passwordMinimumUpperCaseCharacters,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout Milliseconds of inactivity before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordPreviousPasswordCountToBlock Indicates the length of password history, where the user will not be able to enter a new password that is the same as any password in the history. Valid values 0 to 24
	PasswordPreviousPasswordCountToBlock *int `json:"passwordPreviousPasswordCountToBlock,omitempty"`
	// PasswordRequiredType Indicates the minimum password quality required on the device.
	PasswordRequiredType *AndroidDeviceOwnerRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Indicates the number of times a user can enter an incorrect password before the device is wiped. Valid values 4 to 11
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// PlayStoreMode Indicates the Play Store mode of the device.
	PlayStoreMode *AndroidDeviceOwnerPlayStoreMode `json:"playStoreMode,omitempty"`
	// SafeBootBlocked Indicates whether or not rebooting the device into safe boot is disabled.
	SafeBootBlocked *bool `json:"safeBootBlocked,omitempty"`
	// ScreenCaptureBlocked Indicates whether or not to disable the capability to take screenshots.
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// SecurityAllowDebuggingFeatures Indicates whether or not to block the user from enabling debugging features on the device.
	SecurityAllowDebuggingFeatures *bool `json:"securityAllowDebuggingFeatures,omitempty"`
	// SecurityRequireVerifyApps Indicates whether or not verify apps is required.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// StatusBarBlocked Indicates whether or the status bar is disabled, including notifications, quick settings and other screen overlays.
	StatusBarBlocked *bool `json:"statusBarBlocked,omitempty"`
	// StayOnModes List of modes in which the device's display will stay powered-on. This collection can contain a maximum of 4 elements.
	StayOnModes []AndroidDeviceOwnerBatteryPluggedMode `json:"stayOnModes,omitempty"`
	// StorageAllowUsb Indicates whether or not to allow USB mass storage.
	StorageAllowUsb *bool `json:"storageAllowUsb,omitempty"`
	// StorageBlockExternalMedia Indicates whether or not to block external media.
	StorageBlockExternalMedia *bool `json:"storageBlockExternalMedia,omitempty"`
	// StorageBlockUsbFileTransfer Indicates whether or not to block USB file transfer.
	StorageBlockUsbFileTransfer *bool `json:"storageBlockUsbFileTransfer,omitempty"`
	// SystemUpdateWindowStartMinutesAfterMidnight Indicates the number of minutes after midnight that the system update window starts. Valid values 0 to 1440
	SystemUpdateWindowStartMinutesAfterMidnight *int `json:"systemUpdateWindowStartMinutesAfterMidnight,omitempty"`
	// SystemUpdateWindowEndMinutesAfterMidnight Indicates the number of minutes after midnight that the system update window ends. Valid values 0 to 1440
	SystemUpdateWindowEndMinutesAfterMidnight *int `json:"systemUpdateWindowEndMinutesAfterMidnight,omitempty"`
	// SystemUpdateInstallType The type of system update configuration.
	SystemUpdateInstallType *AndroidDeviceOwnerSystemUpdateInstallType `json:"systemUpdateInstallType,omitempty"`
	// SystemWindowsBlocked Whether or not to block Android system prompt windows, like toasts, phone activities, and system alerts.
	SystemWindowsBlocked *bool `json:"systemWindowsBlocked,omitempty"`
	// UsersBlockAdd Indicates whether or not adding users and profiles is disabled.
	UsersBlockAdd *bool `json:"usersBlockAdd,omitempty"`
	// UsersBlockRemove Indicates whether or not to disable removing other users from the device.
	UsersBlockRemove *bool `json:"usersBlockRemove,omitempty"`
	// VolumeBlockAdjustment Indicates whether or not adjusting the master volume is disabled.
	VolumeBlockAdjustment *bool `json:"volumeBlockAdjustment,omitempty"`
	// VPNAlwaysOnPackageIdentifier Android app package name for app that will handle an always-on VPN connection.
	VPNAlwaysOnPackageIdentifier *string `json:"vpnAlwaysOnPackageIdentifier,omitempty"`
	// VPNAlwaysOnLockdownMode If an always on VPN package name is specified, whether or not to lock network traffic when that VPN is disconnected.
	VPNAlwaysOnLockdownMode *bool `json:"vpnAlwaysOnLockdownMode,omitempty"`
	// WiFiBlockEditConfigurations Indicates whether or not to block the user from editing the wifi connection settings.
	WiFiBlockEditConfigurations *bool `json:"wifiBlockEditConfigurations,omitempty"`
	// WiFiBlockEditPolicyDefinedConfigurations Indicates whether or not to block the user from editing just the networks defined by the policy.
	WiFiBlockEditPolicyDefinedConfigurations *bool `json:"wifiBlockEditPolicyDefinedConfigurations,omitempty"`
}

// AndroidDeviceOwnerGlobalProxy undocumented
type AndroidDeviceOwnerGlobalProxy struct {
	// Object is the base model of AndroidDeviceOwnerGlobalProxy
	Object
}

// AndroidDeviceOwnerGlobalProxyAutoConfig undocumented
type AndroidDeviceOwnerGlobalProxyAutoConfig struct {
	// AndroidDeviceOwnerGlobalProxy is the base model of AndroidDeviceOwnerGlobalProxyAutoConfig
	AndroidDeviceOwnerGlobalProxy
	// ProxyAutoConfigURL The proxy auto-config URL
	ProxyAutoConfigURL *string `json:"proxyAutoConfigURL,omitempty"`
}

// AndroidDeviceOwnerGlobalProxyDirect undocumented
type AndroidDeviceOwnerGlobalProxyDirect struct {
	// AndroidDeviceOwnerGlobalProxy is the base model of AndroidDeviceOwnerGlobalProxyDirect
	AndroidDeviceOwnerGlobalProxy
	// Host The host name
	Host *string `json:"host,omitempty"`
	// Port The port
	Port *int `json:"port,omitempty"`
	// ExcludedHosts The excluded hosts
	ExcludedHosts []string `json:"excludedHosts,omitempty"`
}

// AndroidDeviceOwnerScepCertificateProfile Android Device Owner SCEP certificate profile
type AndroidDeviceOwnerScepCertificateProfile struct {
	// AndroidDeviceOwnerCertificateProfileBase is the base model of AndroidDeviceOwnerScepCertificateProfile
	AndroidDeviceOwnerCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s)
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size
	KeySize *KeySize `json:"keySize,omitempty"`
	// HashAlgorithm SCEP Hash Algorithm
	HashAlgorithm *HashAlgorithms `json:"hashAlgorithm,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidDeviceOwnerTrustedRootCertificate Android Device Owner Trusted Root Certificate configuration profile
type AndroidDeviceOwnerTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of AndroidDeviceOwnerTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// AndroidDeviceOwnerVPNConfiguration By providing the configurations in this profile you can instruct the Android Fully Managed device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type AndroidDeviceOwnerVPNConfiguration struct {
	// VPNConfiguration is the base model of AndroidDeviceOwnerVPNConfiguration
	VPNConfiguration
	// ConnectionType Connection type.
	ConnectionType *AndroidVPNConnectionType `json:"connectionType,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidDeviceOwnerCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidDeviceOwnerWiFiConfiguration By providing the configurations in this profile you can instruct the Android device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user. This profile provides limited and simpler security types than Enterprise Wi-Fi profile.
type AndroidDeviceOwnerWiFiConfiguration struct {
	// DeviceConfiguration is the base model of AndroidDeviceOwnerWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *AndroidDeviceOwnerWiFiSecurityType `json:"wiFiSecurityType,omitempty"`
	// PreSharedKey This is the pre-shared key for WPA Personal Wi-Fi network.
	PreSharedKey *string `json:"preSharedKey,omitempty"`
	// PreSharedKeyIsSet This is the pre-shared key for WPA Personal Wi-Fi network.
	PreSharedKeyIsSet *bool `json:"preSharedKeyIsSet,omitempty"`
}

// AndroidEasEmailProfileConfiguration By providing configurations in this profile you can instruct the native email client on KNOX devices to communicate with an Exchange server and get email, contacts, calendar, tasks, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type AndroidEasEmailProfileConfiguration struct {
	// DeviceConfiguration is the base model of AndroidEasEmailProfileConfiguration
	DeviceConfiguration
	// AccountName Exchange ActiveSync account name, displayed to users as name of EAS (this) profile.
	AccountName *string `json:"accountName,omitempty"`
	// AuthenticationMethod Authentication method for Exchange ActiveSync.
	AuthenticationMethod *EasAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// SyncCalendar Toggles syncing the calendar. If set to false calendar is turned off on the device.
	SyncCalendar *bool `json:"syncCalendar,omitempty"`
	// SyncContacts Toggles syncing contacts. If set to false contacts are turned off on the device.
	SyncContacts *bool `json:"syncContacts,omitempty"`
	// SyncTasks Toggles syncing tasks. If set to false tasks are turned off on the device.
	SyncTasks *bool `json:"syncTasks,omitempty"`
	// SyncNotes Toggles syncing notes. If set to false notes are turned off on the device.
	SyncNotes *bool `json:"syncNotes,omitempty"`
	// DurationOfEmailToSync Duration of time email should be synced to.
	DurationOfEmailToSync *EmailSyncDuration `json:"durationOfEmailToSync,omitempty"`
	// EmailAddressSource Email attribute that is picked from AAD and injected into this profile before installing on the device.
	EmailAddressSource *UserEmailSource `json:"emailAddressSource,omitempty"`
	// EmailSyncSchedule Email sync schedule.
	EmailSyncSchedule *EmailSyncSchedule `json:"emailSyncSchedule,omitempty"`
	// HostName Exchange location (URL) that the native mail app connects to.
	HostName *string `json:"hostName,omitempty"`
	// RequireSmime Indicates whether or not to use S/MIME certificate.
	RequireSmime *bool `json:"requireSmime,omitempty"`
	// RequireSsl Indicates whether or not to use SSL.
	RequireSsl *bool `json:"requireSsl,omitempty"`
	// UsernameSource Username attribute that is picked from AAD and injected into this profile before installing on the device.
	UsernameSource *AndroidUsernameSource `json:"usernameSource,omitempty"`
	// UserDomainNameSource UserDomainname attribute that is picked from AAD and injected into this profile before installing on the device.
	UserDomainNameSource *DomainNameSource `json:"userDomainNameSource,omitempty"`
	// CustomDomainName Custom domain name value used while generating an email profile before installing on the device.
	CustomDomainName *string `json:"customDomainName,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidCertificateProfileBase `json:"identityCertificate,omitempty"`
	// SmimeSigningCertificate undocumented
	SmimeSigningCertificate *AndroidCertificateProfileBase `json:"smimeSigningCertificate,omitempty"`
}

// AndroidEnrollmentCompanyCode undocumented
type AndroidEnrollmentCompanyCode struct {
	// Object is the base model of AndroidEnrollmentCompanyCode
	Object
	// EnrollmentToken Enrollment Token used by the User to enroll their device.
	EnrollmentToken *string `json:"enrollmentToken,omitempty"`
	// QrCodeContent String used to generate a QR code for the token.
	QrCodeContent *string `json:"qrCodeContent,omitempty"`
	// QrCodeImage Generated QR code for the token.
	QrCodeImage *MimeContent `json:"qrCodeImage,omitempty"`
}

// AndroidEnterpriseWiFiConfiguration By providing the configurations in this profile you can instruct the Android device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type AndroidEnterpriseWiFiConfiguration struct {
	// AndroidWiFiConfiguration is the base model of AndroidEnterpriseWiFiConfiguration
	AndroidWiFiConfiguration
	// EapType Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *AndroidEapType `json:"eapType,omitempty"`
	// AuthenticationMethod Indicates the Authentication Method the client (device) needs to use when the EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// InnerAuthenticationProtocolForPeap Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForPeap *NonEapAuthenticationMethodForPeap `json:"innerAuthenticationProtocolForPeap,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS or PEAP. The String provided here is used to mask the username of individual users when they attempt to connect to Wi-Fi network.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// UsernameFormatString Username format string used to build the username to connect to wifi
	UsernameFormatString *string `json:"usernameFormatString,omitempty"`
	// PasswordFormatString Password format string used to build the password to connect to wifi
	PasswordFormatString *string `json:"passwordFormatString,omitempty"`
	// PreSharedKey PreSharedKey used to build the password to connect to wifi
	PreSharedKey *string `json:"preSharedKey,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *AndroidTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *AndroidCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// AndroidForWorkApp Contains properties and inherited properties for Android for Work (AFW) Apps.
type AndroidForWorkApp struct {
	// MobileApp is the base model of AndroidForWorkApp
	MobileApp
	// PackageID The package identifier.
	PackageID *string `json:"packageId,omitempty"`
	// AppIdentifier The Identity Name.
	AppIdentifier *string `json:"appIdentifier,omitempty"`
	// UsedLicenseCount The number of VPP licenses in use.
	UsedLicenseCount *int `json:"usedLicenseCount,omitempty"`
	// TotalLicenseCount The total number of VPP licenses.
	TotalLicenseCount *int `json:"totalLicenseCount,omitempty"`
	// AppStoreURL The Play for Work Store app URL.
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
}

// AndroidForWorkAppConfigurationSchema Schema describing an Android for Work application's custom configurations.
type AndroidForWorkAppConfigurationSchema struct {
	// Entity is the base model of AndroidForWorkAppConfigurationSchema
	Entity
	// ExampleJSON UTF8 encoded byte array containing example JSON string conforming to this schema that demonstrates how to set the configuration for this app
	ExampleJSON *Binary `json:"exampleJson,omitempty"`
	// SchemaItems Collection of items each representing a named configuration option in the schema
	SchemaItems []AndroidForWorkAppConfigurationSchemaItem `json:"schemaItems,omitempty"`
}

// AndroidForWorkAppConfigurationSchemaItem undocumented
type AndroidForWorkAppConfigurationSchemaItem struct {
	// Object is the base model of AndroidForWorkAppConfigurationSchemaItem
	Object
	// SchemaItemKey Unique key the application uses to identify the item
	SchemaItemKey *string `json:"schemaItemKey,omitempty"`
	// DisplayName Human readable name
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of what the item controls within the application
	Description *string `json:"description,omitempty"`
	// DefaultBoolValue Default value for boolean type items, if specified by the app developer
	DefaultBoolValue *bool `json:"defaultBoolValue,omitempty"`
	// DefaultIntValue Default value for integer type items, if specified by the app developer
	DefaultIntValue *int `json:"defaultIntValue,omitempty"`
	// DefaultStringValue Default value for string type items, if specified by the app developer
	DefaultStringValue *string `json:"defaultStringValue,omitempty"`
	// DefaultStringArrayValue Default value for string array type items, if specified by the app developer
	DefaultStringArrayValue []string `json:"defaultStringArrayValue,omitempty"`
	// DataType The type of value this item describes
	DataType *AndroidForWorkAppConfigurationSchemaItemDataType `json:"dataType,omitempty"`
	// Selections List of human readable name/value pairs for the valid values that can be set for this item (Choice and Multiselect items only)
	Selections []KeyValuePair `json:"selections,omitempty"`
}

// AndroidForWorkCertificateProfileBase Android For Work certificate profile base.
type AndroidForWorkCertificateProfileBase struct {
	// DeviceConfiguration is the base model of AndroidForWorkCertificateProfileBase
	DeviceConfiguration
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *SubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name Type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// RootCertificate undocumented
	RootCertificate *AndroidForWorkTrustedRootCertificate `json:"rootCertificate,omitempty"`
}

// AndroidForWorkCompliancePolicy This class contains compliance settings for Android for Work.
type AndroidForWorkCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of AndroidForWorkCompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Require a password to unlock device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordMinimumLength Minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordRequiredType Type of characters in password
	PasswordRequiredType *AndroidRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 1 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign-in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// SecurityPreventInstallAppsFromUnknownSources Require that devices disallow installation of apps from unknown sources.
	SecurityPreventInstallAppsFromUnknownSources *bool `json:"securityPreventInstallAppsFromUnknownSources,omitempty"`
	// SecurityDisableUsbDebugging Disable USB debugging on Android devices.
	SecurityDisableUsbDebugging *bool `json:"securityDisableUsbDebugging,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// SecurityBlockJailbrokenDevices Devices must not be jailbroken or rooted.
	SecurityBlockJailbrokenDevices *bool `json:"securityBlockJailbrokenDevices,omitempty"`
	// OsMinimumVersion Minimum Android version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Android version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// MinAndroidSecurityPatchLevel Minimum Android security patch level.
	MinAndroidSecurityPatchLevel *string `json:"minAndroidSecurityPatchLevel,omitempty"`
	// StorageRequireEncryption Require encryption on Android devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// SecurityRequireSafetyNetAttestationBasicIntegrity Require the device to pass the SafetyNet basic integrity check.
	SecurityRequireSafetyNetAttestationBasicIntegrity *bool `json:"securityRequireSafetyNetAttestationBasicIntegrity,omitempty"`
	// SecurityRequireSafetyNetAttestationCertifiedDevice Require the device to pass the SafetyNet certified device check.
	SecurityRequireSafetyNetAttestationCertifiedDevice *bool `json:"securityRequireSafetyNetAttestationCertifiedDevice,omitempty"`
	// SecurityRequireGooglePlayServices Require Google Play Services to be installed and enabled on the device.
	SecurityRequireGooglePlayServices *bool `json:"securityRequireGooglePlayServices,omitempty"`
	// SecurityRequireUpToDateSecurityProviders Require the device to have up to date security providers. The device will require Google Play Services to be enabled and up to date.
	SecurityRequireUpToDateSecurityProviders *bool `json:"securityRequireUpToDateSecurityProviders,omitempty"`
	// SecurityRequireCompanyPortalAppIntegrity Require the device to pass the Company Portal client app runtime integrity check.
	SecurityRequireCompanyPortalAppIntegrity *bool `json:"securityRequireCompanyPortalAppIntegrity,omitempty"`
}

// AndroidForWorkCustomConfiguration Android For Work custom configuration
type AndroidForWorkCustomConfiguration struct {
	// DeviceConfiguration is the base model of AndroidForWorkCustomConfiguration
	DeviceConfiguration
	// OMASettings OMA settings. This collection can contain a maximum of 500 elements.
	OMASettings []OMASetting `json:"omaSettings,omitempty"`
}

// AndroidForWorkEasEmailProfileBase Base for Android For Work EAS Email profiles
type AndroidForWorkEasEmailProfileBase struct {
	// DeviceConfiguration is the base model of AndroidForWorkEasEmailProfileBase
	DeviceConfiguration
	// AuthenticationMethod Authentication method for Exchange ActiveSync.
	AuthenticationMethod *EasAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// DurationOfEmailToSync Duration of time email should be synced to.
	DurationOfEmailToSync *EmailSyncDuration `json:"durationOfEmailToSync,omitempty"`
	// EmailAddressSource Email attribute that is picked from AAD and injected into this profile before installing on the device.
	EmailAddressSource *UserEmailSource `json:"emailAddressSource,omitempty"`
	// HostName Exchange location (URL) that the mail app connects to.
	HostName *string `json:"hostName,omitempty"`
	// RequireSsl Indicates whether or not to use SSL.
	RequireSsl *bool `json:"requireSsl,omitempty"`
	// UsernameSource Username attribute that is picked from AAD and injected into this profile before installing on the device.
	UsernameSource *AndroidUsernameSource `json:"usernameSource,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidForWorkCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidForWorkEnrollmentProfile Enrollment Profile used to enroll COSU devices using Google's Cloud Management.
type AndroidForWorkEnrollmentProfile struct {
	// Entity is the base model of AndroidForWorkEnrollmentProfile
	Entity
	// AccountID Tenant GUID the enrollment profile belongs to.
	AccountID *string `json:"accountId,omitempty"`
	// DisplayName Display name for the enrollment profile.
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description for the enrollment profile.
	Description *string `json:"description,omitempty"`
	// CreatedDateTime Date time the enrollment profile was created.
	CreatedDateTime *time.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime Date time the enrollment profile was last modified.
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// TokenValue Value of the most recently created token for this enrollment profile.
	TokenValue *string `json:"tokenValue,omitempty"`
	// TokenExpirationDateTime Date time the most recently created token will expire.
	TokenExpirationDateTime *time.Time `json:"tokenExpirationDateTime,omitempty"`
	// EnrolledDeviceCount Total number of Android devices that have enrolled using this enrollment profile.
	EnrolledDeviceCount *int `json:"enrolledDeviceCount,omitempty"`
	// QrCodeContent String used to generate a QR code for the token.
	QrCodeContent *string `json:"qrCodeContent,omitempty"`
	// QrCodeImage String used to generate a QR code for the token.
	QrCodeImage *MimeContent `json:"qrCodeImage,omitempty"`
}

// AndroidForWorkEnterpriseWiFiConfiguration By providing the configurations in this profile you can instruct the Android for Work device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type AndroidForWorkEnterpriseWiFiConfiguration struct {
	// AndroidForWorkWiFiConfiguration is the base model of AndroidForWorkEnterpriseWiFiConfiguration
	AndroidForWorkWiFiConfiguration
	// EapType Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *AndroidEapType `json:"eapType,omitempty"`
	// AuthenticationMethod Indicates the Authentication Method the client (device) needs to use when the EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// InnerAuthenticationProtocolForPeap Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForPeap *NonEapAuthenticationMethodForPeap `json:"innerAuthenticationProtocolForPeap,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS or PEAP. The String provided here is used to mask the username of individual users when they attempt to connect to Wi-Fi network.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *AndroidForWorkTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *AndroidForWorkCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// AndroidForWorkGeneralDeviceConfiguration Android For Work general device configuration.
type AndroidForWorkGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of AndroidForWorkGeneralDeviceConfiguration
	DeviceConfiguration
	// PasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock.
	PasswordBlockFingerprintUnlock *bool `json:"passwordBlockFingerprintUnlock,omitempty"`
	// PasswordBlockTrustAgents Indicates whether or not to block Smart Lock and other trust agents.
	PasswordBlockTrustAgents *bool `json:"passwordBlockTrustAgents,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength Minimum length of passwords. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 0 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// PasswordRequiredType Type of password that is required.
	PasswordRequiredType *AndroidForWorkRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// WorkProfileDataSharingType Type of data sharing that is allowed.
	WorkProfileDataSharingType *AndroidForWorkCrossProfileDataSharingType `json:"workProfileDataSharingType,omitempty"`
	// WorkProfileBlockNotificationsWhileDeviceLocked Indicates whether or not to block notifications while device locked.
	WorkProfileBlockNotificationsWhileDeviceLocked *bool `json:"workProfileBlockNotificationsWhileDeviceLocked,omitempty"`
	// WorkProfileBlockAddingAccounts Block users from adding/removing accounts in work profile.
	WorkProfileBlockAddingAccounts *bool `json:"workProfileBlockAddingAccounts,omitempty"`
	// WorkProfileBluetoothEnableContactSharing Allow bluetooth devices to access enterprise contacts.
	WorkProfileBluetoothEnableContactSharing *bool `json:"workProfileBluetoothEnableContactSharing,omitempty"`
	// WorkProfileBlockScreenCapture Block screen capture in work profile.
	WorkProfileBlockScreenCapture *bool `json:"workProfileBlockScreenCapture,omitempty"`
	// WorkProfileBlockCrossProfileCallerID Block display work profile caller ID in personal profile.
	WorkProfileBlockCrossProfileCallerID *bool `json:"workProfileBlockCrossProfileCallerId,omitempty"`
	// WorkProfileBlockCamera Block work profile camera.
	WorkProfileBlockCamera *bool `json:"workProfileBlockCamera,omitempty"`
	// WorkProfileBlockCrossProfileContactsSearch Block work profile contacts availability in personal profile.
	WorkProfileBlockCrossProfileContactsSearch *bool `json:"workProfileBlockCrossProfileContactsSearch,omitempty"`
	// WorkProfileBlockCrossProfileCopyPaste Boolean that indicates if the setting disallow cross profile copy/paste is enabled.
	WorkProfileBlockCrossProfileCopyPaste *bool `json:"workProfileBlockCrossProfileCopyPaste,omitempty"`
	// WorkProfileDefaultAppPermissionPolicy Type of password that is required.
	WorkProfileDefaultAppPermissionPolicy *AndroidForWorkDefaultAppPermissionPolicyType `json:"workProfileDefaultAppPermissionPolicy,omitempty"`
	// WorkProfilePasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock for work profile.
	WorkProfilePasswordBlockFingerprintUnlock *bool `json:"workProfilePasswordBlockFingerprintUnlock,omitempty"`
	// WorkProfilePasswordBlockTrustAgents Indicates whether or not to block Smart Lock and other trust agents for work profile.
	WorkProfilePasswordBlockTrustAgents *bool `json:"workProfilePasswordBlockTrustAgents,omitempty"`
	// WorkProfilePasswordExpirationDays Number of days before the work profile password expires. Valid values 1 to 365
	WorkProfilePasswordExpirationDays *int `json:"workProfilePasswordExpirationDays,omitempty"`
	// WorkProfilePasswordMinimumLength Minimum length of work profile password. Valid values 4 to 16
	WorkProfilePasswordMinimumLength *int `json:"workProfilePasswordMinimumLength,omitempty"`
	// WorkProfilePasswordMinNumericCharacters Minimum # of numeric characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinNumericCharacters *int `json:"workProfilePasswordMinNumericCharacters,omitempty"`
	// WorkProfilePasswordMinNonLetterCharacters Minimum # of non-letter characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinNonLetterCharacters *int `json:"workProfilePasswordMinNonLetterCharacters,omitempty"`
	// WorkProfilePasswordMinLetterCharacters Minimum # of letter characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinLetterCharacters *int `json:"workProfilePasswordMinLetterCharacters,omitempty"`
	// WorkProfilePasswordMinLowerCaseCharacters Minimum # of lower-case characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinLowerCaseCharacters *int `json:"workProfilePasswordMinLowerCaseCharacters,omitempty"`
	// WorkProfilePasswordMinUpperCaseCharacters Minimum # of upper-case characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinUpperCaseCharacters *int `json:"workProfilePasswordMinUpperCaseCharacters,omitempty"`
	// WorkProfilePasswordMinSymbolCharacters Minimum # of symbols required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinSymbolCharacters *int `json:"workProfilePasswordMinSymbolCharacters,omitempty"`
	// WorkProfilePasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	WorkProfilePasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"workProfilePasswordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// WorkProfilePasswordPreviousPasswordBlockCount Number of previous work profile passwords to block. Valid values 0 to 24
	WorkProfilePasswordPreviousPasswordBlockCount *int `json:"workProfilePasswordPreviousPasswordBlockCount,omitempty"`
	// WorkProfilePasswordSignInFailureCountBeforeFactoryReset Number of sign in failures allowed before work profile is removed and all corporate data deleted. Valid values 1 to 16
	WorkProfilePasswordSignInFailureCountBeforeFactoryReset *int `json:"workProfilePasswordSignInFailureCountBeforeFactoryReset,omitempty"`
	// WorkProfilePasswordRequiredType Type of work profile password that is required.
	WorkProfilePasswordRequiredType *AndroidForWorkRequiredPasswordType `json:"workProfilePasswordRequiredType,omitempty"`
	// WorkProfileRequirePassword Password is required or not for work profile
	WorkProfileRequirePassword *bool `json:"workProfileRequirePassword,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// VPNAlwaysOnPackageIdentifier Enable lockdown mode for always-on VPN.
	VPNAlwaysOnPackageIdentifier *string `json:"vpnAlwaysOnPackageIdentifier,omitempty"`
	// VPNEnableAlwaysOnLockdownMode Enable lockdown mode for always-on VPN.
	VPNEnableAlwaysOnLockdownMode *bool `json:"vpnEnableAlwaysOnLockdownMode,omitempty"`
	// WorkProfileAllowWidgets Allow widgets from work profile apps.
	WorkProfileAllowWidgets *bool `json:"workProfileAllowWidgets,omitempty"`
	// WorkProfileBlockPersonalAppInstallsFromUnknownSources Prevent app installations from unknown sources in the personal profile.
	WorkProfileBlockPersonalAppInstallsFromUnknownSources *bool `json:"workProfileBlockPersonalAppInstallsFromUnknownSources,omitempty"`
}

// AndroidForWorkGmailEasConfiguration By providing configurations in this profile you can instruct the Gmail email client on Android For Work devices to communicate with an Exchange server and get email, contacts, calendar, tasks, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type AndroidForWorkGmailEasConfiguration struct {
	// AndroidForWorkEasEmailProfileBase is the base model of AndroidForWorkGmailEasConfiguration
	AndroidForWorkEasEmailProfileBase
}

// AndroidForWorkImportedPFXCertificateProfile Android For Work PFX Import certificate profile
type AndroidForWorkImportedPFXCertificateProfile struct {
	// AndroidCertificateProfileBase is the base model of AndroidForWorkImportedPFXCertificateProfile
	AndroidCertificateProfileBase
	// IntendedPurpose Intended Purpose of the Certificate Profile - which could be Unassigned, SmimeEncryption, SmimeSigning etc.
	IntendedPurpose *IntendedPurpose `json:"intendedPurpose,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidForWorkMobileAppConfiguration Contains properties, inherited properties and actions for AFW mobile app configurations.
type AndroidForWorkMobileAppConfiguration struct {
	// ManagedDeviceMobileAppConfiguration is the base model of AndroidForWorkMobileAppConfiguration
	ManagedDeviceMobileAppConfiguration
	// PackageID Android For Work app configuration package id.
	PackageID *string `json:"packageId,omitempty"`
	// PayloadJSON Android For Work app configuration JSON payload.
	PayloadJSON *string `json:"payloadJson,omitempty"`
	// PermissionActions List of Android app permissions and corresponding permission actions.
	PermissionActions []AndroidPermissionAction `json:"permissionActions,omitempty"`
}

// AndroidForWorkNineWorkEasConfiguration By providing configurations in this profile you can instruct the Nine Work email client on Android For Work devices to communicate with an Exchange server and get email, contacts, calendar, tasks, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type AndroidForWorkNineWorkEasConfiguration struct {
	// AndroidForWorkEasEmailProfileBase is the base model of AndroidForWorkNineWorkEasConfiguration
	AndroidForWorkEasEmailProfileBase
	// SyncCalendar Toggles syncing the calendar. If set to false the calendar is turned off on the device.
	SyncCalendar *bool `json:"syncCalendar,omitempty"`
	// SyncContacts Toggles syncing contacts. If set to false contacts are turned off on the device.
	SyncContacts *bool `json:"syncContacts,omitempty"`
	// SyncTasks Toggles syncing tasks. If set to false tasks are turned off on the device.
	SyncTasks *bool `json:"syncTasks,omitempty"`
}

// AndroidForWorkPkcsCertificateProfile Android For Work PKCS certificate profile
type AndroidForWorkPkcsCertificateProfile struct {
	// AndroidForWorkCertificateProfileBase is the base model of AndroidForWorkPkcsCertificateProfile
	AndroidForWorkCertificateProfileBase
	// CertificationAuthority PKCS Certification Authority
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidForWorkScepCertificateProfile Android For Work SCEP certificate profile
type AndroidForWorkScepCertificateProfile struct {
	// AndroidForWorkCertificateProfileBase is the base model of AndroidForWorkScepCertificateProfile
	AndroidForWorkCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s)
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size
	KeySize *KeySize `json:"keySize,omitempty"`
	// HashAlgorithm SCEP Hash Algorithm
	HashAlgorithm *HashAlgorithms `json:"hashAlgorithm,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidForWorkSettings Settings for Android For Work.
type AndroidForWorkSettings struct {
	// Entity is the base model of AndroidForWorkSettings
	Entity
	// BindStatus Bind status of the tenant with the Google EMM API
	BindStatus *AndroidForWorkBindStatus `json:"bindStatus,omitempty"`
	// LastAppSyncDateTime Last completion time for app sync
	LastAppSyncDateTime *time.Time `json:"lastAppSyncDateTime,omitempty"`
	// LastAppSyncStatus Last application sync result
	LastAppSyncStatus *AndroidForWorkSyncStatus `json:"lastAppSyncStatus,omitempty"`
	// OwnerUserPrincipalName Owner UPN that created the enterprise
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// OwnerOrganizationName Organization name used when onboarding Android for Work
	OwnerOrganizationName *string `json:"ownerOrganizationName,omitempty"`
	// LastModifiedDateTime Last modification time for Android for Work settings
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// EnrollmentTarget Indicates which users can enroll devices in Android for Work device management
	EnrollmentTarget *AndroidForWorkEnrollmentTarget `json:"enrollmentTarget,omitempty"`
	// TargetGroupIDs Specifies which AAD groups can enroll devices in Android for Work device management if enrollmentTarget is set to 'Targeted'
	TargetGroupIDs []string `json:"targetGroupIds,omitempty"`
	// DeviceOwnerManagementEnabled Indicates if this account is flighting for Android Device Owner Management with CloudDPC.
	DeviceOwnerManagementEnabled *bool `json:"deviceOwnerManagementEnabled,omitempty"`
}

// AndroidForWorkTrustedRootCertificate Android For Work Trusted Root Certificate configuration profile
type AndroidForWorkTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of AndroidForWorkTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// AndroidForWorkVPNConfiguration By providing the configurations in this profile you can instruct the Android device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type AndroidForWorkVPNConfiguration struct {
	// DeviceConfiguration is the base model of AndroidForWorkVPNConfiguration
	DeviceConfiguration
	// ConnectionName Connection name displayed to the user.
	ConnectionName *string `json:"connectionName,omitempty"`
	// ConnectionType Connection type.
	ConnectionType *AndroidForWorkVPNConnectionType `json:"connectionType,omitempty"`
	// Role Role when connection type is set to Pulse Secure.
	Role *string `json:"role,omitempty"`
	// Realm Realm when connection type is set to Pulse Secure.
	Realm *string `json:"realm,omitempty"`
	// Servers List of VPN Servers on the network. Make sure end users can access these network locations. This collection can contain a maximum of 500 elements.
	Servers []VPNServer `json:"servers,omitempty"`
	// Fingerprint Fingerprint is a string that will be used to verify the VPN server can be trusted, which is only applicable when connection type is Check Point Capsule VPN.
	Fingerprint *string `json:"fingerprint,omitempty"`
	// CustomData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomData []KeyValue `json:"customData,omitempty"`
	// CustomKeyValueData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomKeyValueData []KeyValuePair `json:"customKeyValueData,omitempty"`
	// AuthenticationMethod Authentication method.
	AuthenticationMethod *VPNAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidForWorkCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidForWorkWiFiConfiguration By providing the configurations in this profile you can instruct the Android for Work device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user. This profile provides limited and simpler security types than Enterprise Wi-Fi profile.
type AndroidForWorkWiFiConfiguration struct {
	// DeviceConfiguration is the base model of AndroidForWorkWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *AndroidWiFiSecurityType `json:"wiFiSecurityType,omitempty"`
}

// AndroidGeneralDeviceConfiguration This topic provides descriptions of the declared methods, properties and relationships exposed by the androidGeneralDeviceConfiguration resource.
type AndroidGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of AndroidGeneralDeviceConfiguration
	DeviceConfiguration
	// AppsBlockClipboardSharing Indicates whether or not to block clipboard sharing to copy and paste between applications.
	AppsBlockClipboardSharing *bool `json:"appsBlockClipboardSharing,omitempty"`
	// AppsBlockCopyPaste Indicates whether or not to block copy and paste within applications.
	AppsBlockCopyPaste *bool `json:"appsBlockCopyPaste,omitempty"`
	// AppsBlockYouTube Indicates whether or not to block the YouTube app.
	AppsBlockYouTube *bool `json:"appsBlockYouTube,omitempty"`
	// BluetoothBlocked Indicates whether or not to block Bluetooth.
	BluetoothBlocked *bool `json:"bluetoothBlocked,omitempty"`
	// CameraBlocked Indicates whether or not to block the use of the camera.
	CameraBlocked *bool `json:"cameraBlocked,omitempty"`
	// CellularBlockDataRoaming Indicates whether or not to block data roaming.
	CellularBlockDataRoaming *bool `json:"cellularBlockDataRoaming,omitempty"`
	// CellularBlockMessaging Indicates whether or not to block SMS/MMS messaging.
	CellularBlockMessaging *bool `json:"cellularBlockMessaging,omitempty"`
	// CellularBlockVoiceRoaming Indicates whether or not to block voice roaming.
	CellularBlockVoiceRoaming *bool `json:"cellularBlockVoiceRoaming,omitempty"`
	// CellularBlockWiFiTethering Indicates whether or not to block syncing Wi-Fi tethering.
	CellularBlockWiFiTethering *bool `json:"cellularBlockWiFiTethering,omitempty"`
	// CompliantAppsList List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
	CompliantAppsList []AppListItem `json:"compliantAppsList,omitempty"`
	// CompliantAppListType Type of list that is in the CompliantAppsList.
	CompliantAppListType *AppListType `json:"compliantAppListType,omitempty"`
	// DiagnosticDataBlockSubmission Indicates whether or not to block diagnostic data submission.
	DiagnosticDataBlockSubmission *bool `json:"diagnosticDataBlockSubmission,omitempty"`
	// LocationServicesBlocked Indicates whether or not to block location services.
	LocationServicesBlocked *bool `json:"locationServicesBlocked,omitempty"`
	// GoogleAccountBlockAutoSync Indicates whether or not to block Google account auto sync.
	GoogleAccountBlockAutoSync *bool `json:"googleAccountBlockAutoSync,omitempty"`
	// GooglePlayStoreBlocked Indicates whether or not to block the Google Play store.
	GooglePlayStoreBlocked *bool `json:"googlePlayStoreBlocked,omitempty"`
	// KioskModeBlockSleepButton Indicates whether or not to block the screen sleep button while in Kiosk Mode.
	KioskModeBlockSleepButton *bool `json:"kioskModeBlockSleepButton,omitempty"`
	// KioskModeBlockVolumeButtons Indicates whether or not to block the volume buttons while in Kiosk Mode.
	KioskModeBlockVolumeButtons *bool `json:"kioskModeBlockVolumeButtons,omitempty"`
	// DateAndTimeBlockChanges Indicates whether or not to block changing date and time while in KNOX Mode.
	DateAndTimeBlockChanges *bool `json:"dateAndTimeBlockChanges,omitempty"`
	// KioskModeApps A list of apps that will be allowed to run when the device is in Kiosk Mode. This collection can contain a maximum of 500 elements.
	KioskModeApps []AppListItem `json:"kioskModeApps,omitempty"`
	// NfcBlocked Indicates whether or not to block Near-Field Communication.
	NfcBlocked *bool `json:"nfcBlocked,omitempty"`
	// PasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock.
	PasswordBlockFingerprintUnlock *bool `json:"passwordBlockFingerprintUnlock,omitempty"`
	// PasswordBlockTrustAgents Indicates whether or not to block Smart Lock and other trust agents.
	PasswordBlockTrustAgents *bool `json:"passwordBlockTrustAgents,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength Minimum length of passwords. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 0 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// PasswordRequiredType Type of password that is required.
	PasswordRequiredType *AndroidRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordRequired Indicates whether or not to require a password.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PowerOffBlocked Indicates whether or not to block powering off the device.
	PowerOffBlocked *bool `json:"powerOffBlocked,omitempty"`
	// FactoryResetBlocked Indicates whether or not to block user performing a factory reset.
	FactoryResetBlocked *bool `json:"factoryResetBlocked,omitempty"`
	// ScreenCaptureBlocked Indicates whether or not to block screenshots.
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// DeviceSharingAllowed Indicates whether or not to allow device sharing mode.
	DeviceSharingAllowed *bool `json:"deviceSharingAllowed,omitempty"`
	// StorageBlockGoogleBackup Indicates whether or not to block Google Backup.
	StorageBlockGoogleBackup *bool `json:"storageBlockGoogleBackup,omitempty"`
	// StorageBlockRemovableStorage Indicates whether or not to block removable storage usage.
	StorageBlockRemovableStorage *bool `json:"storageBlockRemovableStorage,omitempty"`
	// StorageRequireDeviceEncryption Indicates whether or not to require device encryption.
	StorageRequireDeviceEncryption *bool `json:"storageRequireDeviceEncryption,omitempty"`
	// StorageRequireRemovableStorageEncryption Indicates whether or not to require removable storage encryption.
	StorageRequireRemovableStorageEncryption *bool `json:"storageRequireRemovableStorageEncryption,omitempty"`
	// VoiceAssistantBlocked Indicates whether or not to block the use of the Voice Assistant.
	VoiceAssistantBlocked *bool `json:"voiceAssistantBlocked,omitempty"`
	// VoiceDialingBlocked Indicates whether or not to block voice dialing.
	VoiceDialingBlocked *bool `json:"voiceDialingBlocked,omitempty"`
	// WebBrowserBlockPopups Indicates whether or not to block popups within the web browser.
	WebBrowserBlockPopups *bool `json:"webBrowserBlockPopups,omitempty"`
	// WebBrowserBlockAutofill Indicates whether or not to block the web browser's auto fill feature.
	WebBrowserBlockAutofill *bool `json:"webBrowserBlockAutofill,omitempty"`
	// WebBrowserBlockJavaScript Indicates whether or not to block JavaScript within the web browser.
	WebBrowserBlockJavaScript *bool `json:"webBrowserBlockJavaScript,omitempty"`
	// WebBrowserBlocked Indicates whether or not to block the web browser.
	WebBrowserBlocked *bool `json:"webBrowserBlocked,omitempty"`
	// WebBrowserCookieSettings Cookie settings within the web browser.
	WebBrowserCookieSettings *WebBrowserCookieSettings `json:"webBrowserCookieSettings,omitempty"`
	// WiFiBlocked Indicates whether or not to block syncing Wi-Fi.
	WiFiBlocked *bool `json:"wiFiBlocked,omitempty"`
	// AppsInstallAllowList List of apps which can be installed on the KNOX device. This collection can contain a maximum of 500 elements.
	AppsInstallAllowList []AppListItem `json:"appsInstallAllowList,omitempty"`
	// AppsLaunchBlockList List of apps which are blocked from being launched on the KNOX device. This collection can contain a maximum of 500 elements.
	AppsLaunchBlockList []AppListItem `json:"appsLaunchBlockList,omitempty"`
	// AppsHideList List of apps to be hidden on the KNOX device. This collection can contain a maximum of 500 elements.
	AppsHideList []AppListItem `json:"appsHideList,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
}

// AndroidImportedPFXCertificateProfile Android PFX Import certificate profile
type AndroidImportedPFXCertificateProfile struct {
	// AndroidCertificateProfileBase is the base model of AndroidImportedPFXCertificateProfile
	AndroidCertificateProfileBase
	// IntendedPurpose Intended Purpose of the Certificate Profile - which could be Unassigned, SmimeEncryption, SmimeSigning etc.
	IntendedPurpose *IntendedPurpose `json:"intendedPurpose,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidLobApp Contains properties and inherited properties for Android Line Of Business apps.
type AndroidLobApp struct {
	// MobileLobApp is the base model of AndroidLobApp
	MobileLobApp
	// PackageID The package identifier.
	PackageID *string `json:"packageId,omitempty"`
	// IdentityName The Identity Name.
	IdentityName *string `json:"identityName,omitempty"`
	// MinimumSupportedOperatingSystem The value for the minimum applicable operating system.
	MinimumSupportedOperatingSystem *AndroidMinimumOperatingSystem `json:"minimumSupportedOperatingSystem,omitempty"`
	// VersionName The version name of Android Line of Business (LoB) app.
	VersionName *string `json:"versionName,omitempty"`
	// VersionCode The version code of Android Line of Business (LoB) app.
	VersionCode *string `json:"versionCode,omitempty"`
	// IdentityVersion The identity version.
	IdentityVersion *string `json:"identityVersion,omitempty"`
}

// AndroidManagedAppProtection Policy used to configure detailed management settings targeted to specific security groups and for a specified set of apps on an Android device
type AndroidManagedAppProtection struct {
	// TargetedManagedAppProtection is the base model of AndroidManagedAppProtection
	TargetedManagedAppProtection
	// ScreenCaptureBlocked Indicates whether a managed user can take screen captures of managed apps
	ScreenCaptureBlocked *bool `json:"screenCaptureBlocked,omitempty"`
	// DisableAppEncryptionIfDeviceEncryptionIsEnabled When this setting is enabled, app level encryption is disabled if device level encryption is enabled
	DisableAppEncryptionIfDeviceEncryptionIsEnabled *bool `json:"disableAppEncryptionIfDeviceEncryptionIsEnabled,omitempty"`
	// EncryptAppData Indicates whether application data for managed apps should be encrypted
	EncryptAppData *bool `json:"encryptAppData,omitempty"`
	// DeployedAppCount Count of apps to which the current policy is deployed.
	DeployedAppCount *int `json:"deployedAppCount,omitempty"`
	// MinimumRequiredPatchVersion Define the oldest required Android security patch level a user can have to gain secure access to the app.
	MinimumRequiredPatchVersion *string `json:"minimumRequiredPatchVersion,omitempty"`
	// MinimumWarningPatchVersion Define the oldest recommended Android security patch level a user can have for secure access to the app.
	MinimumWarningPatchVersion *string `json:"minimumWarningPatchVersion,omitempty"`
	// ExemptedAppPackages App packages in this list will be exempt from the policy and will be able to receive data from managed apps.
	ExemptedAppPackages []KeyValuePair `json:"exemptedAppPackages,omitempty"`
	// MinimumWipePatchVersion Android security patch level  less than or equal to the specified value will wipe the managed app and the associated company data.
	MinimumWipePatchVersion *string `json:"minimumWipePatchVersion,omitempty"`
	// AllowedAndroidDeviceManufacturers Semicolon seperated list of device manufacturers allowed, as a string, for the managed app to work.
	AllowedAndroidDeviceManufacturers *string `json:"allowedAndroidDeviceManufacturers,omitempty"`
	// AppActionIfAndroidDeviceManufacturerNotAllowed Defines a managed app behavior, either block or wipe, if the specified device manufacturer is not allowed.
	AppActionIfAndroidDeviceManufacturerNotAllowed *ManagedAppRemediationAction `json:"appActionIfAndroidDeviceManufacturerNotAllowed,omitempty"`
	// RequiredAndroidSafetyNetDeviceAttestationType Defines the Android SafetyNet Device Attestation requirement for a managed app to work.
	RequiredAndroidSafetyNetDeviceAttestationType *AndroidManagedAppSafetyNetDeviceAttestationType `json:"requiredAndroidSafetyNetDeviceAttestationType,omitempty"`
	// AppActionIfAndroidSafetyNetDeviceAttestationFailed Defines a managed app behavior, either warn or block, if the specified Android SafetyNet Attestation requirment fails.
	AppActionIfAndroidSafetyNetDeviceAttestationFailed *ManagedAppRemediationAction `json:"appActionIfAndroidSafetyNetDeviceAttestationFailed,omitempty"`
	// RequiredAndroidSafetyNetAppsVerificationType Defines the Android SafetyNet Apps Verification requirement for a managed app to work.
	RequiredAndroidSafetyNetAppsVerificationType *AndroidManagedAppSafetyNetAppsVerificationType `json:"requiredAndroidSafetyNetAppsVerificationType,omitempty"`
	// AppActionIfAndroidSafetyNetAppsVerificationFailed Defines a managed app behavior, either warn or block, if the specified Android App Verification requirment fails.
	AppActionIfAndroidSafetyNetAppsVerificationFailed *ManagedAppRemediationAction `json:"appActionIfAndroidSafetyNetAppsVerificationFailed,omitempty"`
	// CustomBrowserPackageID Unique identifier of a custom browser to open weblink on Android.
	CustomBrowserPackageID *string `json:"customBrowserPackageId,omitempty"`
	// CustomBrowserDisplayName Friendly name of the preferred custom browser to open weblink on Android.
	CustomBrowserDisplayName *string `json:"customBrowserDisplayName,omitempty"`
	// MinimumRequiredCompanyPortalVersion Minimum version of the Company portal that must be installed on the device or app access will be blocked
	MinimumRequiredCompanyPortalVersion *string `json:"minimumRequiredCompanyPortalVersion,omitempty"`
	// MinimumWarningCompanyPortalVersion Minimum version of the Company portal that must be installed on the device or the user will receive a warning
	MinimumWarningCompanyPortalVersion *string `json:"minimumWarningCompanyPortalVersion,omitempty"`
	// MinimumWipeCompanyPortalVersion Minimum version of the Company portal that must be installed on the device or the company data on the app will be wiped
	MinimumWipeCompanyPortalVersion *string `json:"minimumWipeCompanyPortalVersion,omitempty"`
	// KeyboardsRestricted Indicates if keyboard restriction is enabled. If enabled list of approved keyboards must be provided as well.
	KeyboardsRestricted *bool `json:"keyboardsRestricted,omitempty"`
	// ApprovedKeyboards If Keyboard Restriction is enabled, only keyboards in this approved list will be allowed. A key should be Android package id for a keyboard and value should be a friendly name
	ApprovedKeyboards []KeyValuePair `json:"approvedKeyboards,omitempty"`
	// Apps undocumented
	Apps []ManagedMobileApp `json:"apps,omitempty"`
	// DeploymentSummary undocumented
	DeploymentSummary *ManagedAppPolicyDeploymentSummary `json:"deploymentSummary,omitempty"`
}

// AndroidManagedAppRegistration Represents the synchronization details of an android app, with management capabilities, for a specific user.
type AndroidManagedAppRegistration struct {
	// ManagedAppRegistration is the base model of AndroidManagedAppRegistration
	ManagedAppRegistration
	// PatchVersion The patch version for the current android app registration
	PatchVersion *string `json:"patchVersion,omitempty"`
}

// AndroidManagedStoreAccountEnterpriseSettings Enterprise settings for an Android managed store account.
type AndroidManagedStoreAccountEnterpriseSettings struct {
	// Entity is the base model of AndroidManagedStoreAccountEnterpriseSettings
	Entity
	// BindStatus Bind status of the tenant with the Google EMM API
	BindStatus *AndroidManagedStoreAccountBindStatus `json:"bindStatus,omitempty"`
	// LastAppSyncDateTime Last completion time for app sync
	LastAppSyncDateTime *time.Time `json:"lastAppSyncDateTime,omitempty"`
	// LastAppSyncStatus Last application sync result
	LastAppSyncStatus *AndroidManagedStoreAccountAppSyncStatus `json:"lastAppSyncStatus,omitempty"`
	// OwnerUserPrincipalName Owner UPN that created the enterprise
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`
	// OwnerOrganizationName Organization name used when onboarding Android Enterprise
	OwnerOrganizationName *string `json:"ownerOrganizationName,omitempty"`
	// LastModifiedDateTime Last modification time for Android enterprise settings
	LastModifiedDateTime *time.Time `json:"lastModifiedDateTime,omitempty"`
	// EnrollmentTarget Indicates which users can enroll devices in Android Enterprise device management
	EnrollmentTarget *AndroidManagedStoreAccountEnrollmentTarget `json:"enrollmentTarget,omitempty"`
	// TargetGroupIDs Specifies which AAD groups can enroll devices in Android for Work device management if enrollmentTarget is set to 'Targeted'
	TargetGroupIDs []string `json:"targetGroupIds,omitempty"`
	// DeviceOwnerManagementEnabled Indicates if this account is flighting for Android Device Owner Management with CloudDPC.
	DeviceOwnerManagementEnabled *bool `json:"deviceOwnerManagementEnabled,omitempty"`
	// CompanyCodes Company codes for AndroidManagedStoreAccountEnterpriseSettings
	CompanyCodes []AndroidEnrollmentCompanyCode `json:"companyCodes,omitempty"`
	// AndroidDeviceOwnerFullyManagedEnrollmentEnabled Company codes for AndroidManagedStoreAccountEnterpriseSettings
	AndroidDeviceOwnerFullyManagedEnrollmentEnabled *bool `json:"androidDeviceOwnerFullyManagedEnrollmentEnabled,omitempty"`
}

// AndroidManagedStoreApp Contains properties and inherited properties for Android Managed Store Apps.
type AndroidManagedStoreApp struct {
	// MobileApp is the base model of AndroidManagedStoreApp
	MobileApp
	// PackageID The package identifier.
	PackageID *string `json:"packageId,omitempty"`
	// AppIdentifier The Identity Name.
	AppIdentifier *string `json:"appIdentifier,omitempty"`
	// UsedLicenseCount The number of VPP licenses in use.
	UsedLicenseCount *int `json:"usedLicenseCount,omitempty"`
	// TotalLicenseCount The total number of VPP licenses.
	TotalLicenseCount *int `json:"totalLicenseCount,omitempty"`
	// AppStoreURL The Play for Work Store app URL.
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
	// IsPrivate Indicates whether the app is only available to a given enterprise's users.
	IsPrivate *bool `json:"isPrivate,omitempty"`
	// IsSystemApp Indicates whether the app is a preinstalled system app.
	IsSystemApp *bool `json:"isSystemApp,omitempty"`
	// SupportsOemConfig Whether this app supports OEMConfig policy.
	SupportsOemConfig *bool `json:"supportsOemConfig,omitempty"`
}

// AndroidManagedStoreAppConfiguration Contains properties, inherited properties and actions for Android Enterprise mobile app configurations.
type AndroidManagedStoreAppConfiguration struct {
	// ManagedDeviceMobileAppConfiguration is the base model of AndroidManagedStoreAppConfiguration
	ManagedDeviceMobileAppConfiguration
	// PackageID Android Enterprise app configuration package id.
	PackageID *string `json:"packageId,omitempty"`
	// PayloadJSON Android Enterprise app configuration JSON payload.
	PayloadJSON *string `json:"payloadJson,omitempty"`
	// PermissionActions List of Android app permissions and corresponding permission actions.
	PermissionActions []AndroidPermissionAction `json:"permissionActions,omitempty"`
	// AppSupportsOemConfig Whether or not this AppConfig is an OEMConfig policy.
	AppSupportsOemConfig *bool `json:"appSupportsOemConfig,omitempty"`
}

// AndroidManagedStoreAppConfigurationSchema Schema describing an Android application's custom configurations.
type AndroidManagedStoreAppConfigurationSchema struct {
	// Entity is the base model of AndroidManagedStoreAppConfigurationSchema
	Entity
	// ExampleJSON UTF8 encoded byte array containing example JSON string conforming to this schema that demonstrates how to set the configuration for this app
	ExampleJSON *Binary `json:"exampleJson,omitempty"`
	// SchemaItems Collection of items each representing a named configuration option in the schema. It only contains the root-level configuration.
	SchemaItems []AndroidManagedStoreAppConfigurationSchemaItem `json:"schemaItems,omitempty"`
	// NestedSchemaItems Collection of items each representing a named configuration option in the schema. It contains a flat list of all configuration.
	NestedSchemaItems []AndroidManagedStoreAppConfigurationSchemaItem `json:"nestedSchemaItems,omitempty"`
}

// AndroidManagedStoreAppConfigurationSchemaItem undocumented
type AndroidManagedStoreAppConfigurationSchemaItem struct {
	// Object is the base model of AndroidManagedStoreAppConfigurationSchemaItem
	Object
	// Index Unique index the application uses to maintain nested schema items
	Index *int `json:"index,omitempty"`
	// ParentIndex Index of parent schema item to track nested schema items
	ParentIndex *int `json:"parentIndex,omitempty"`
	// SchemaItemKey Unique key the application uses to identify the item
	SchemaItemKey *string `json:"schemaItemKey,omitempty"`
	// DisplayName Human readable name
	DisplayName *string `json:"displayName,omitempty"`
	// Description Description of what the item controls within the application
	Description *string `json:"description,omitempty"`
	// DefaultBoolValue Default value for boolean type items, if specified by the app developer
	DefaultBoolValue *bool `json:"defaultBoolValue,omitempty"`
	// DefaultIntValue Default value for integer type items, if specified by the app developer
	DefaultIntValue *int `json:"defaultIntValue,omitempty"`
	// DefaultStringValue Default value for string type items, if specified by the app developer
	DefaultStringValue *string `json:"defaultStringValue,omitempty"`
	// DefaultStringArrayValue Default value for string array type items, if specified by the app developer
	DefaultStringArrayValue []string `json:"defaultStringArrayValue,omitempty"`
	// DataType The type of value this item describes
	DataType *AndroidManagedStoreAppConfigurationSchemaItemDataType `json:"dataType,omitempty"`
	// Selections List of human readable name/value pairs for the valid values that can be set for this item (Choice and Multiselect items only)
	Selections []KeyValuePair `json:"selections,omitempty"`
}

// AndroidManagedStoreWebApp Contains properties and inherited properties for web apps configured to be distributed via the managed Android app store.
type AndroidManagedStoreWebApp struct {
	// AndroidManagedStoreApp is the base model of AndroidManagedStoreWebApp
	AndroidManagedStoreApp
}

// AndroidMinimumOperatingSystem undocumented
type AndroidMinimumOperatingSystem struct {
	// Object is the base model of AndroidMinimumOperatingSystem
	Object
	// V4_0 Version 4.0 or later.
	V4_0 *bool `json:"v4_0,omitempty"`
	// V4_0_3 Version 4.0.3 or later.
	V4_0_3 *bool `json:"v4_0_3,omitempty"`
	// V4_1 Version 4.1 or later.
	V4_1 *bool `json:"v4_1,omitempty"`
	// V4_2 Version 4.2 or later.
	V4_2 *bool `json:"v4_2,omitempty"`
	// V4_3 Version 4.3 or later.
	V4_3 *bool `json:"v4_3,omitempty"`
	// V4_4 Version 4.4 or later.
	V4_4 *bool `json:"v4_4,omitempty"`
	// V5_0 Version 5.0 or later.
	V5_0 *bool `json:"v5_0,omitempty"`
	// V5_1 Version 5.1 or later.
	V5_1 *bool `json:"v5_1,omitempty"`
	// V6_0 Version 6.0 or later.
	V6_0 *bool `json:"v6_0,omitempty"`
	// V7_0 Version 7.0 or later.
	V7_0 *bool `json:"v7_0,omitempty"`
	// V7_1 Version 7.1 or later.
	V7_1 *bool `json:"v7_1,omitempty"`
	// V8_0 Version 8.0 or later.
	V8_0 *bool `json:"v8_0,omitempty"`
	// V8_1 Version 8.1 or later.
	V8_1 *bool `json:"v8_1,omitempty"`
	// V9_0 Version 9.0 or later.
	V9_0 *bool `json:"v9_0,omitempty"`
}

// AndroidMobileAppIdentifier undocumented
type AndroidMobileAppIdentifier struct {
	// MobileAppIdentifier is the base model of AndroidMobileAppIdentifier
	MobileAppIdentifier
	// PackageID The identifier for an app, as specified in the play store.
	PackageID *string `json:"packageId,omitempty"`
}

// AndroidOMACpConfiguration By providing a configuration in this profile you can configure Android devices that support OMA-CP.
type AndroidOMACpConfiguration struct {
	// DeviceConfiguration is the base model of AndroidOMACpConfiguration
	DeviceConfiguration
	// ConfigurationXML Configuration XML that will be applied to the device. When it is read, it only provides a placeholder string since the original data is encrypted and stored.
	ConfigurationXML *Binary `json:"configurationXml,omitempty"`
}

// AndroidPermissionAction undocumented
type AndroidPermissionAction struct {
	// Object is the base model of AndroidPermissionAction
	Object
	// Permission Android permission string, defined in the official Android documentation.  Example 'android.permission.READ_CONTACTS'.
	Permission *string `json:"permission,omitempty"`
	// Action Type of Android permission action.
	Action *AndroidPermissionActionType `json:"action,omitempty"`
}

// AndroidPkcsCertificateProfile Android PKCS certificate profile
type AndroidPkcsCertificateProfile struct {
	// AndroidCertificateProfileBase is the base model of AndroidPkcsCertificateProfile
	AndroidCertificateProfileBase
	// CertificationAuthority PKCS Certification Authority
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidScepCertificateProfile Android SCEP certificate profile
type AndroidScepCertificateProfile struct {
	// AndroidCertificateProfileBase is the base model of AndroidScepCertificateProfile
	AndroidCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s)
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size
	KeySize *KeySize `json:"keySize,omitempty"`
	// HashAlgorithm SCEP Hash Algorithm
	HashAlgorithm *HashAlgorithms `json:"hashAlgorithm,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidStoreApp Contains properties and inherited properties for Android store apps.
type AndroidStoreApp struct {
	// MobileApp is the base model of AndroidStoreApp
	MobileApp
	// PackageID The package identifier.
	PackageID *string `json:"packageId,omitempty"`
	// AppIdentifier The Identity Name.
	AppIdentifier *string `json:"appIdentifier,omitempty"`
	// AppStoreURL The Android app store URL.
	AppStoreURL *string `json:"appStoreUrl,omitempty"`
	// MinimumSupportedOperatingSystem The value for the minimum applicable operating system.
	MinimumSupportedOperatingSystem *AndroidMinimumOperatingSystem `json:"minimumSupportedOperatingSystem,omitempty"`
}

// AndroidTrustedRootCertificate Android Trusted Root Certificate configuration profile
type AndroidTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of AndroidTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// AndroidVPNConfiguration By providing the configurations in this profile you can instruct the Android device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type AndroidVPNConfiguration struct {
	// DeviceConfiguration is the base model of AndroidVPNConfiguration
	DeviceConfiguration
	// ConnectionName Connection name displayed to the user.
	ConnectionName *string `json:"connectionName,omitempty"`
	// ConnectionType Connection type.
	ConnectionType *AndroidVPNConnectionType `json:"connectionType,omitempty"`
	// Role Role when connection type is set to Pulse Secure.
	Role *string `json:"role,omitempty"`
	// Realm Realm when connection type is set to Pulse Secure.
	Realm *string `json:"realm,omitempty"`
	// Servers List of VPN Servers on the network. Make sure end users can access these network locations. This collection can contain a maximum of 500 elements.
	Servers []VPNServer `json:"servers,omitempty"`
	// Fingerprint Fingerprint is a string that will be used to verify the VPN server can be trusted, which is only applicable when connection type is Check Point Capsule VPN.
	Fingerprint *string `json:"fingerprint,omitempty"`
	// CustomData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomData []KeyValue `json:"customData,omitempty"`
	// CustomKeyValueData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomKeyValueData []KeyValuePair `json:"customKeyValueData,omitempty"`
	// AuthenticationMethod Authentication method.
	AuthenticationMethod *VPNAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidWiFiConfiguration By providing the configurations in this profile you can instruct the Android device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user. This profile provides limited and simpler security types than Enterprise Wi-Fi profile.
type AndroidWiFiConfiguration struct {
	// DeviceConfiguration is the base model of AndroidWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *AndroidWiFiSecurityType `json:"wiFiSecurityType,omitempty"`
}

// AndroidWorkProfileCertificateProfileBase Android Work Profile certificate profile base.
type AndroidWorkProfileCertificateProfileBase struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileCertificateProfileBase
	DeviceConfiguration
	// RenewalThresholdPercentage Certificate renewal threshold percentage. Valid values 1 to 99
	RenewalThresholdPercentage *int `json:"renewalThresholdPercentage,omitempty"`
	// SubjectNameFormat Certificate Subject Name Format.
	SubjectNameFormat *SubjectNameFormat `json:"subjectNameFormat,omitempty"`
	// CertificateValidityPeriodValue Value for the Certificate Validity Period.
	CertificateValidityPeriodValue *int `json:"certificateValidityPeriodValue,omitempty"`
	// CertificateValidityPeriodScale Scale for the Certificate Validity Period.
	CertificateValidityPeriodScale *CertificateValidityPeriodScale `json:"certificateValidityPeriodScale,omitempty"`
	// ExtendedKeyUsages Extended Key Usage (EKU) settings. This collection can contain a maximum of 500 elements.
	ExtendedKeyUsages []ExtendedKeyUsage `json:"extendedKeyUsages,omitempty"`
	// SubjectAlternativeNameType Certificate Subject Alternative Name Type.
	SubjectAlternativeNameType *SubjectAlternativeNameType `json:"subjectAlternativeNameType,omitempty"`
	// RootCertificate undocumented
	RootCertificate *AndroidWorkProfileTrustedRootCertificate `json:"rootCertificate,omitempty"`
}

// AndroidWorkProfileCompliancePolicy This class contains compliance settings for Android Work Profile.
type AndroidWorkProfileCompliancePolicy struct {
	// DeviceCompliancePolicy is the base model of AndroidWorkProfileCompliancePolicy
	DeviceCompliancePolicy
	// PasswordRequired Require a password to unlock device.
	PasswordRequired *bool `json:"passwordRequired,omitempty"`
	// PasswordMinimumLength Minimum password length. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordRequiredType Type of characters in password
	PasswordRequiredType *AndroidRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// PasswordMinutesOfInactivityBeforeLock Minutes of inactivity before a password is required.
	PasswordMinutesOfInactivityBeforeLock *int `json:"passwordMinutesOfInactivityBeforeLock,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 1 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign-in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// SecurityPreventInstallAppsFromUnknownSources Require that devices disallow installation of apps from unknown sources.
	SecurityPreventInstallAppsFromUnknownSources *bool `json:"securityPreventInstallAppsFromUnknownSources,omitempty"`
	// SecurityDisableUsbDebugging Disable USB debugging on Android devices.
	SecurityDisableUsbDebugging *bool `json:"securityDisableUsbDebugging,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// DeviceThreatProtectionEnabled Require that devices have enabled device threat protection.
	DeviceThreatProtectionEnabled *bool `json:"deviceThreatProtectionEnabled,omitempty"`
	// DeviceThreatProtectionRequiredSecurityLevel Require Mobile Threat Protection minimum risk level to report noncompliance.
	DeviceThreatProtectionRequiredSecurityLevel *DeviceThreatProtectionLevel `json:"deviceThreatProtectionRequiredSecurityLevel,omitempty"`
	// SecurityBlockJailbrokenDevices Devices must not be jailbroken or rooted.
	SecurityBlockJailbrokenDevices *bool `json:"securityBlockJailbrokenDevices,omitempty"`
	// OsMinimumVersion Minimum Android version.
	OsMinimumVersion *string `json:"osMinimumVersion,omitempty"`
	// OsMaximumVersion Maximum Android version.
	OsMaximumVersion *string `json:"osMaximumVersion,omitempty"`
	// MinAndroidSecurityPatchLevel Minimum Android security patch level.
	MinAndroidSecurityPatchLevel *string `json:"minAndroidSecurityPatchLevel,omitempty"`
	// StorageRequireEncryption Require encryption on Android devices.
	StorageRequireEncryption *bool `json:"storageRequireEncryption,omitempty"`
	// SecurityRequireSafetyNetAttestationBasicIntegrity Require the device to pass the SafetyNet basic integrity check.
	SecurityRequireSafetyNetAttestationBasicIntegrity *bool `json:"securityRequireSafetyNetAttestationBasicIntegrity,omitempty"`
	// SecurityRequireSafetyNetAttestationCertifiedDevice Require the device to pass the SafetyNet certified device check.
	SecurityRequireSafetyNetAttestationCertifiedDevice *bool `json:"securityRequireSafetyNetAttestationCertifiedDevice,omitempty"`
	// SecurityRequireGooglePlayServices Require Google Play Services to be installed and enabled on the device.
	SecurityRequireGooglePlayServices *bool `json:"securityRequireGooglePlayServices,omitempty"`
	// SecurityRequireUpToDateSecurityProviders Require the device to have up to date security providers. The device will require Google Play Services to be enabled and up to date.
	SecurityRequireUpToDateSecurityProviders *bool `json:"securityRequireUpToDateSecurityProviders,omitempty"`
	// SecurityRequireCompanyPortalAppIntegrity Require the device to pass the Company Portal client app runtime integrity check.
	SecurityRequireCompanyPortalAppIntegrity *bool `json:"securityRequireCompanyPortalAppIntegrity,omitempty"`
}

// AndroidWorkProfileCustomConfiguration Android Work Profile custom configuration
type AndroidWorkProfileCustomConfiguration struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileCustomConfiguration
	DeviceConfiguration
	// OMASettings OMA settings. This collection can contain a maximum of 500 elements.
	OMASettings []OMASetting `json:"omaSettings,omitempty"`
}

// AndroidWorkProfileEasEmailProfileBase Base for Android Work Profile EAS Email profiles
type AndroidWorkProfileEasEmailProfileBase struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileEasEmailProfileBase
	DeviceConfiguration
	// AuthenticationMethod Authentication method for Exchange ActiveSync.
	AuthenticationMethod *EasAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// DurationOfEmailToSync Duration of time email should be synced to.
	DurationOfEmailToSync *EmailSyncDuration `json:"durationOfEmailToSync,omitempty"`
	// EmailAddressSource Email attribute that is picked from AAD and injected into this profile before installing on the device.
	EmailAddressSource *UserEmailSource `json:"emailAddressSource,omitempty"`
	// HostName Exchange location (URL) that the mail app connects to.
	HostName *string `json:"hostName,omitempty"`
	// RequireSsl Indicates whether or not to use SSL.
	RequireSsl *bool `json:"requireSsl,omitempty"`
	// UsernameSource Username attribute that is picked from AAD and injected into this profile before installing on the device.
	UsernameSource *AndroidUsernameSource `json:"usernameSource,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidWorkProfileCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidWorkProfileEnterpriseWiFiConfiguration By providing the configurations in this profile you can instruct the Android Work Profile device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user.
type AndroidWorkProfileEnterpriseWiFiConfiguration struct {
	// AndroidWorkProfileWiFiConfiguration is the base model of AndroidWorkProfileEnterpriseWiFiConfiguration
	AndroidWorkProfileWiFiConfiguration
	// EapType Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).
	EapType *AndroidEapType `json:"eapType,omitempty"`
	// AuthenticationMethod Indicates the Authentication Method the client (device) needs to use when the EAP Type is configured to PEAP or EAP-TTLS.
	AuthenticationMethod *WiFiAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// InnerAuthenticationProtocolForEapTtls Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForEapTtls *NonEapAuthenticationMethodForEapTtlsType `json:"innerAuthenticationProtocolForEapTtls,omitempty"`
	// InnerAuthenticationProtocolForPeap Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and Authenticationmethod is Username and Password.
	InnerAuthenticationProtocolForPeap *NonEapAuthenticationMethodForPeap `json:"innerAuthenticationProtocolForPeap,omitempty"`
	// OuterIdentityPrivacyTemporaryValue Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS or PEAP. The String provided here is used to mask the username of individual users when they attempt to connect to Wi-Fi network.
	OuterIdentityPrivacyTemporaryValue *string `json:"outerIdentityPrivacyTemporaryValue,omitempty"`
	// RootCertificateForServerValidation undocumented
	RootCertificateForServerValidation *AndroidWorkProfileTrustedRootCertificate `json:"rootCertificateForServerValidation,omitempty"`
	// IdentityCertificateForClientAuthentication undocumented
	IdentityCertificateForClientAuthentication *AndroidWorkProfileCertificateProfileBase `json:"identityCertificateForClientAuthentication,omitempty"`
}

// AndroidWorkProfileGeneralDeviceConfiguration Android Work Profile general device configuration.
type AndroidWorkProfileGeneralDeviceConfiguration struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileGeneralDeviceConfiguration
	DeviceConfiguration
	// PasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock.
	PasswordBlockFingerprintUnlock *bool `json:"passwordBlockFingerprintUnlock,omitempty"`
	// PasswordBlockTrustAgents Indicates whether or not to block Smart Lock and other trust agents.
	PasswordBlockTrustAgents *bool `json:"passwordBlockTrustAgents,omitempty"`
	// PasswordExpirationDays Number of days before the password expires. Valid values 1 to 365
	PasswordExpirationDays *int `json:"passwordExpirationDays,omitempty"`
	// PasswordMinimumLength Minimum length of passwords. Valid values 4 to 16
	PasswordMinimumLength *int `json:"passwordMinimumLength,omitempty"`
	// PasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	PasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"passwordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// PasswordPreviousPasswordBlockCount Number of previous passwords to block. Valid values 0 to 24
	PasswordPreviousPasswordBlockCount *int `json:"passwordPreviousPasswordBlockCount,omitempty"`
	// PasswordSignInFailureCountBeforeFactoryReset Number of sign in failures allowed before factory reset. Valid values 1 to 16
	PasswordSignInFailureCountBeforeFactoryReset *int `json:"passwordSignInFailureCountBeforeFactoryReset,omitempty"`
	// PasswordRequiredType Type of password that is required.
	PasswordRequiredType *AndroidWorkProfileRequiredPasswordType `json:"passwordRequiredType,omitempty"`
	// WorkProfileDataSharingType Type of data sharing that is allowed.
	WorkProfileDataSharingType *AndroidWorkProfileCrossProfileDataSharingType `json:"workProfileDataSharingType,omitempty"`
	// WorkProfileBlockNotificationsWhileDeviceLocked Indicates whether or not to block notifications while device locked.
	WorkProfileBlockNotificationsWhileDeviceLocked *bool `json:"workProfileBlockNotificationsWhileDeviceLocked,omitempty"`
	// WorkProfileBlockAddingAccounts Block users from adding/removing accounts in work profile.
	WorkProfileBlockAddingAccounts *bool `json:"workProfileBlockAddingAccounts,omitempty"`
	// WorkProfileBluetoothEnableContactSharing Allow bluetooth devices to access enterprise contacts.
	WorkProfileBluetoothEnableContactSharing *bool `json:"workProfileBluetoothEnableContactSharing,omitempty"`
	// WorkProfileBlockScreenCapture Block screen capture in work profile.
	WorkProfileBlockScreenCapture *bool `json:"workProfileBlockScreenCapture,omitempty"`
	// WorkProfileBlockCrossProfileCallerID Block display work profile caller ID in personal profile.
	WorkProfileBlockCrossProfileCallerID *bool `json:"workProfileBlockCrossProfileCallerId,omitempty"`
	// WorkProfileBlockCamera Block work profile camera.
	WorkProfileBlockCamera *bool `json:"workProfileBlockCamera,omitempty"`
	// WorkProfileBlockCrossProfileContactsSearch Block work profile contacts availability in personal profile.
	WorkProfileBlockCrossProfileContactsSearch *bool `json:"workProfileBlockCrossProfileContactsSearch,omitempty"`
	// WorkProfileBlockCrossProfileCopyPaste Boolean that indicates if the setting disallow cross profile copy/paste is enabled.
	WorkProfileBlockCrossProfileCopyPaste *bool `json:"workProfileBlockCrossProfileCopyPaste,omitempty"`
	// WorkProfileDefaultAppPermissionPolicy Type of password that is required.
	WorkProfileDefaultAppPermissionPolicy *AndroidWorkProfileDefaultAppPermissionPolicyType `json:"workProfileDefaultAppPermissionPolicy,omitempty"`
	// WorkProfilePasswordBlockFingerprintUnlock Indicates whether or not to block fingerprint unlock for work profile.
	WorkProfilePasswordBlockFingerprintUnlock *bool `json:"workProfilePasswordBlockFingerprintUnlock,omitempty"`
	// WorkProfilePasswordBlockTrustAgents Indicates whether or not to block Smart Lock and other trust agents for work profile.
	WorkProfilePasswordBlockTrustAgents *bool `json:"workProfilePasswordBlockTrustAgents,omitempty"`
	// WorkProfilePasswordExpirationDays Number of days before the work profile password expires. Valid values 1 to 365
	WorkProfilePasswordExpirationDays *int `json:"workProfilePasswordExpirationDays,omitempty"`
	// WorkProfilePasswordMinimumLength Minimum length of work profile password. Valid values 4 to 16
	WorkProfilePasswordMinimumLength *int `json:"workProfilePasswordMinimumLength,omitempty"`
	// WorkProfilePasswordMinNumericCharacters Minimum # of numeric characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinNumericCharacters *int `json:"workProfilePasswordMinNumericCharacters,omitempty"`
	// WorkProfilePasswordMinNonLetterCharacters Minimum # of non-letter characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinNonLetterCharacters *int `json:"workProfilePasswordMinNonLetterCharacters,omitempty"`
	// WorkProfilePasswordMinLetterCharacters Minimum # of letter characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinLetterCharacters *int `json:"workProfilePasswordMinLetterCharacters,omitempty"`
	// WorkProfilePasswordMinLowerCaseCharacters Minimum # of lower-case characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinLowerCaseCharacters *int `json:"workProfilePasswordMinLowerCaseCharacters,omitempty"`
	// WorkProfilePasswordMinUpperCaseCharacters Minimum # of upper-case characters required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinUpperCaseCharacters *int `json:"workProfilePasswordMinUpperCaseCharacters,omitempty"`
	// WorkProfilePasswordMinSymbolCharacters Minimum # of symbols required in work profile password. Valid values 1 to 10
	WorkProfilePasswordMinSymbolCharacters *int `json:"workProfilePasswordMinSymbolCharacters,omitempty"`
	// WorkProfilePasswordMinutesOfInactivityBeforeScreenTimeout Minutes of inactivity before the screen times out.
	WorkProfilePasswordMinutesOfInactivityBeforeScreenTimeout *int `json:"workProfilePasswordMinutesOfInactivityBeforeScreenTimeout,omitempty"`
	// WorkProfilePasswordPreviousPasswordBlockCount Number of previous work profile passwords to block. Valid values 0 to 24
	WorkProfilePasswordPreviousPasswordBlockCount *int `json:"workProfilePasswordPreviousPasswordBlockCount,omitempty"`
	// WorkProfilePasswordSignInFailureCountBeforeFactoryReset Number of sign in failures allowed before work profile is removed and all corporate data deleted. Valid values 1 to 16
	WorkProfilePasswordSignInFailureCountBeforeFactoryReset *int `json:"workProfilePasswordSignInFailureCountBeforeFactoryReset,omitempty"`
	// WorkProfilePasswordRequiredType Type of work profile password that is required.
	WorkProfilePasswordRequiredType *AndroidWorkProfileRequiredPasswordType `json:"workProfilePasswordRequiredType,omitempty"`
	// WorkProfileRequirePassword Password is required or not for work profile
	WorkProfileRequirePassword *bool `json:"workProfileRequirePassword,omitempty"`
	// SecurityRequireVerifyApps Require the Android Verify apps feature is turned on.
	SecurityRequireVerifyApps *bool `json:"securityRequireVerifyApps,omitempty"`
	// VPNAlwaysOnPackageIdentifier Enable lockdown mode for always-on VPN.
	VPNAlwaysOnPackageIdentifier *string `json:"vpnAlwaysOnPackageIdentifier,omitempty"`
	// VPNEnableAlwaysOnLockdownMode Enable lockdown mode for always-on VPN.
	VPNEnableAlwaysOnLockdownMode *bool `json:"vpnEnableAlwaysOnLockdownMode,omitempty"`
	// WorkProfileAllowWidgets Allow widgets from work profile apps.
	WorkProfileAllowWidgets *bool `json:"workProfileAllowWidgets,omitempty"`
	// WorkProfileBlockPersonalAppInstallsFromUnknownSources Prevent app installations from unknown sources in the personal profile.
	WorkProfileBlockPersonalAppInstallsFromUnknownSources *bool `json:"workProfileBlockPersonalAppInstallsFromUnknownSources,omitempty"`
}

// AndroidWorkProfileGmailEasConfiguration By providing configurations in this profile you can instruct the Gmail email client on Android Work Profile devices to communicate with an Exchange server and get email, contacts, calendar, tasks, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type AndroidWorkProfileGmailEasConfiguration struct {
	// AndroidWorkProfileEasEmailProfileBase is the base model of AndroidWorkProfileGmailEasConfiguration
	AndroidWorkProfileEasEmailProfileBase
}

// AndroidWorkProfileNineWorkEasConfiguration By providing configurations in this profile you can instruct the Nine Work email client on Android Work Profile devices to communicate with an Exchange server and get email, contacts, calendar, tasks, and notes. Furthermore, you can also specify how much email to sync and how often the device should sync.
type AndroidWorkProfileNineWorkEasConfiguration struct {
	// AndroidWorkProfileEasEmailProfileBase is the base model of AndroidWorkProfileNineWorkEasConfiguration
	AndroidWorkProfileEasEmailProfileBase
	// SyncCalendar Toggles syncing the calendar. If set to false the calendar is turned off on the device.
	SyncCalendar *bool `json:"syncCalendar,omitempty"`
	// SyncContacts Toggles syncing contacts. If set to false contacts are turned off on the device.
	SyncContacts *bool `json:"syncContacts,omitempty"`
	// SyncTasks Toggles syncing tasks. If set to false tasks are turned off on the device.
	SyncTasks *bool `json:"syncTasks,omitempty"`
}

// AndroidWorkProfilePkcsCertificateProfile Android Work Profile PKCS certificate profile
type AndroidWorkProfilePkcsCertificateProfile struct {
	// AndroidWorkProfileCertificateProfileBase is the base model of AndroidWorkProfilePkcsCertificateProfile
	AndroidWorkProfileCertificateProfileBase
	// CertificationAuthority PKCS Certification Authority
	CertificationAuthority *string `json:"certificationAuthority,omitempty"`
	// CertificationAuthorityName PKCS Certification Authority Name
	CertificationAuthorityName *string `json:"certificationAuthorityName,omitempty"`
	// CertificateTemplateName PKCS Certificate Template Name
	CertificateTemplateName *string `json:"certificateTemplateName,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidWorkProfileScepCertificateProfile Android Work Profile SCEP certificate profile
type AndroidWorkProfileScepCertificateProfile struct {
	// AndroidWorkProfileCertificateProfileBase is the base model of AndroidWorkProfileScepCertificateProfile
	AndroidWorkProfileCertificateProfileBase
	// ScepServerUrls SCEP Server Url(s)
	ScepServerUrls []string `json:"scepServerUrls,omitempty"`
	// SubjectNameFormatString Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress}},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,C=US
	SubjectNameFormatString *string `json:"subjectNameFormatString,omitempty"`
	// KeyUsage SCEP Key Usage
	KeyUsage *KeyUsages `json:"keyUsage,omitempty"`
	// KeySize SCEP Key Size
	KeySize *KeySize `json:"keySize,omitempty"`
	// HashAlgorithm SCEP Hash Algorithm
	HashAlgorithm *HashAlgorithms `json:"hashAlgorithm,omitempty"`
	// SubjectAlternativeNameFormatString Custom String that defines the AAD Attribute.
	SubjectAlternativeNameFormatString *string `json:"subjectAlternativeNameFormatString,omitempty"`
	// CertificateStore Target store certificate
	CertificateStore *CertificateStore `json:"certificateStore,omitempty"`
	// CustomSubjectAlternativeNames Custom Subject Alternative Name Settings. This collection can contain a maximum of 500 elements.
	CustomSubjectAlternativeNames []CustomSubjectAlternativeName `json:"customSubjectAlternativeNames,omitempty"`
	// ManagedDeviceCertificateStates undocumented
	ManagedDeviceCertificateStates []ManagedDeviceCertificateState `json:"managedDeviceCertificateStates,omitempty"`
}

// AndroidWorkProfileTrustedRootCertificate Android Work Profile Trusted Root Certificate configuration profile
type AndroidWorkProfileTrustedRootCertificate struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileTrustedRootCertificate
	DeviceConfiguration
	// TrustedRootCertificate Trusted Root Certificate
	TrustedRootCertificate *Binary `json:"trustedRootCertificate,omitempty"`
	// CertFileName File name to display in UI.
	CertFileName *string `json:"certFileName,omitempty"`
}

// AndroidWorkProfileVPNConfiguration By providing the configurations in this profile you can instruct the Android Work Profile device to connect to desired VPN endpoint. By specifying the authentication method and security types expected by VPN endpoint you can make the VPN connection seamless for end user.
type AndroidWorkProfileVPNConfiguration struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileVPNConfiguration
	DeviceConfiguration
	// ConnectionName Connection name displayed to the user.
	ConnectionName *string `json:"connectionName,omitempty"`
	// ConnectionType Connection type.
	ConnectionType *AndroidWorkProfileVPNConnectionType `json:"connectionType,omitempty"`
	// Role Role when connection type is set to Pulse Secure.
	Role *string `json:"role,omitempty"`
	// Realm Realm when connection type is set to Pulse Secure.
	Realm *string `json:"realm,omitempty"`
	// Servers List of VPN Servers on the network. Make sure end users can access these network locations. This collection can contain a maximum of 500 elements.
	Servers []VPNServer `json:"servers,omitempty"`
	// Fingerprint Fingerprint is a string that will be used to verify the VPN server can be trusted, which is only applicable when connection type is Check Point Capsule VPN.
	Fingerprint *string `json:"fingerprint,omitempty"`
	// CustomData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomData []KeyValue `json:"customData,omitempty"`
	// CustomKeyValueData Custom data when connection type is set to Citrix. This collection can contain a maximum of 25 elements.
	CustomKeyValueData []KeyValuePair `json:"customKeyValueData,omitempty"`
	// AuthenticationMethod Authentication method.
	AuthenticationMethod *VPNAuthenticationMethod `json:"authenticationMethod,omitempty"`
	// IdentityCertificate undocumented
	IdentityCertificate *AndroidWorkProfileCertificateProfileBase `json:"identityCertificate,omitempty"`
}

// AndroidWorkProfileWiFiConfiguration By providing the configurations in this profile you can instruct the Android Work Profile device to connect to desired Wi-Fi endpoint. By specifying the authentication method and security types expected by Wi-Fi endpoint you can make the Wi-Fi connection seamless for end user. This profile provides limited and simpler security types than Enterprise Wi-Fi profile.
type AndroidWorkProfileWiFiConfiguration struct {
	// DeviceConfiguration is the base model of AndroidWorkProfileWiFiConfiguration
	DeviceConfiguration
	// NetworkName Network Name
	NetworkName *string `json:"networkName,omitempty"`
	// Ssid This is the name of the Wi-Fi network that is broadcast to all devices.
	Ssid *string `json:"ssid,omitempty"`
	// ConnectAutomatically Connect automatically when this network is in range. Setting this to true will skip the user prompt and automatically connect the device to Wi-Fi network.
	ConnectAutomatically *bool `json:"connectAutomatically,omitempty"`
	// ConnectWhenNetworkNameIsHidden When set to true, this profile forces the device to connect to a network that doesn't broadcast its SSID to all devices.
	ConnectWhenNetworkNameIsHidden *bool `json:"connectWhenNetworkNameIsHidden,omitempty"`
	// WiFiSecurityType Indicates whether Wi-Fi endpoint uses an EAP based security type.
	WiFiSecurityType *AndroidWiFiSecurityType `json:"wiFiSecurityType,omitempty"`
}
