// Code generated by protoc-gen-go-hrpc. DO NOT EDIT.

package chatv1

import (
	bytes "bytes"
	context "context"
	errors "errors"
	websocket "github.com/gorilla/websocket"
	proto "google.golang.org/protobuf/proto"
	ioutil "io/ioutil"
	http "net/http"
	httptest "net/http/httptest"
	url "net/url"
)

type ChatServiceClient interface {
	// Endpoint to create a guild.
	CreateGuild(context.Context, *CreateGuildRequest) (*CreateGuildResponse, error)
	// Endpoint to create a "room" guild.
	CreateRoom(context.Context, *CreateRoomRequest) (*CreateRoomResponse, error)
	// Endpoint to create a "direct message" guild.
	//
	// - The inviter and the invitee that join the created guild will both be owners.
	// - The guild should be created on the server that inviter is on.
	// - The server should send a guild invite to the invitee (specified in the request),
	// using the `UserInvited` postbox event if the invitee is on another server,
	// otherwise see the below item.
	// - The server should process this as follows: adding the invite to their pending
	// invite list and sending an `InviteReceived` event over their event stream if
	// the invitee is on this server.
	// - The invitee may or may not use the invite. Only the invitee may use the invite.
	CreateDirectMessage(context.Context, *CreateDirectMessageRequest) (*CreateDirectMessageResponse, error)
	// Endpoint to upgrade a "room" guild to a "normal" guild.
	UpgradeRoomToGuild(context.Context, *UpgradeRoomToGuildRequest) (*UpgradeRoomToGuildResponse, error)
	// Endpoint to create an invite.
	CreateInvite(context.Context, *CreateInviteRequest) (*CreateInviteResponse, error)
	// Endpoint to create a channel.
	CreateChannel(context.Context, *CreateChannelRequest) (*CreateChannelResponse, error)
	// Endpoint to get your guild list.
	GetGuildList(context.Context, *GetGuildListRequest) (*GetGuildListResponse, error)
	// Endpoint to invite a user to a guild.
	InviteUserToGuild(context.Context, *InviteUserToGuildRequest) (*InviteUserToGuildResponse, error)
	// Endpoint to get your pending invites.
	GetPendingInvites(context.Context, *GetPendingInvitesRequest) (*GetPendingInvitesResponse, error)
	// Endpoint to reject (delete with notification to the inviter) an invite
	// from your pending invite list.
	//
	// If the invitee is on a different server than the inviter, the invitee's
	// server should send a `UserRejectedInvite` postbox event to the inviter's
	// server.
	//
	// The "notification" is sending a `InviteRejected` stream event to the
	// inviter. If the guild's kind is `DirectMessage`, the server should also
	// set the `rejected` field of the guild's kind to `true`.
	RejectPendingInvite(context.Context, *RejectPendingInviteRequest) (*RejectPendingInviteResponse, error)
	// Endpoint to ignore (delete without notification to the inviter) an
	// invite from your pending invite list.
	IgnorePendingInvite(context.Context, *IgnorePendingInviteRequest) (*IgnorePendingInviteResponse, error)
	// Endpoint to get information about a guild.
	GetGuild(context.Context, *GetGuildRequest) (*GetGuildResponse, error)
	// Endpoint to get the invites of a guild.
	//
	// This requires the "invites.view" permission.
	GetGuildInvites(context.Context, *GetGuildInvitesRequest) (*GetGuildInvitesResponse, error)
	// Endpoint to get the members of a guild.
	GetGuildMembers(context.Context, *GetGuildMembersRequest) (*GetGuildMembersResponse, error)
	// Endpoint to get the channels of a guild.
	//
	// You will only be informed of channels you have the "messages.view"
	// permission for.
	GetGuildChannels(context.Context, *GetGuildChannelsRequest) (*GetGuildChannelsResponse, error)
	// Endpoint to get the messages from a guild channel.
	GetChannelMessages(context.Context, *GetChannelMessagesRequest) (*GetChannelMessagesResponse, error)
	// Endpoint to get a single message from a guild channel.
	GetMessage(context.Context, *GetMessageRequest) (*GetMessageResponse, error)
	// Endpoint to update a guild's information.
	UpdateGuildInformation(context.Context, *UpdateGuildInformationRequest) (*UpdateGuildInformationResponse, error)
	// Endpoint to update a channel's information.
	UpdateChannelInformation(context.Context, *UpdateChannelInformationRequest) (*UpdateChannelInformationResponse, error)
	// Endpoint to change the position of a channel in the channel list.
	UpdateChannelOrder(context.Context, *UpdateChannelOrderRequest) (*UpdateChannelOrderResponse, error)
	// Endpoint to change the position of all channels in the guild;
	// must specifcy all channels or fails
	UpdateAllChannelOrder(context.Context, *UpdateAllChannelOrderRequest) (*UpdateAllChannelOrderResponse, error)
	// Endpoint to change the text of a message.
	UpdateMessageText(context.Context, *UpdateMessageTextRequest) (*UpdateMessageTextResponse, error)
	// Endpoint to delete a guild.
	// Can only be invoked if there's one owner.
	DeleteGuild(context.Context, *DeleteGuildRequest) (*DeleteGuildResponse, error)
	// Endpoint to delete an invite.
	DeleteInvite(context.Context, *DeleteInviteRequest) (*DeleteInviteResponse, error)
	// Endpoint to delete a channel.
	DeleteChannel(context.Context, *DeleteChannelRequest) (*DeleteChannelResponse, error)
	// Endpoint to delete a message.
	//
	// This requires the "messages.manage.delete" permission if you are not the
	// message author.
	DeleteMessage(context.Context, *DeleteMessageRequest) (*DeleteMessageResponse, error)
	// Endpoint to join a guild.
	//
	// - If the invite used is in a user's "pending invites" list, it should be
	// removed from there.
	JoinGuild(context.Context, *JoinGuildRequest) (*JoinGuildResponse, error)
	// Endpoint to leave a guild.
	//
	// - If you're the only owner, you can't leave a guild. Exception to this
	// rule are "direct message" guilds.
	// - When the last member in a "direct message" guild leaves it, that guild
	// should be deleted.
	LeaveGuild(context.Context, *LeaveGuildRequest) (*LeaveGuildResponse, error)
	// Endpont to trigger an action.
	TriggerAction(context.Context, *TriggerActionRequest) (*TriggerActionResponse, error)
	// Endpoint to send a message.
	SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error)
	// Endpoint to query if a user has a permission.
	QueryHasPermission(context.Context, *QueryHasPermissionRequest) (*QueryHasPermissionResponse, error)
	// Endpoint to set permissions for a role in a guild.
	SetPermissions(context.Context, *SetPermissionsRequest) (*SetPermissionsResponse, error)
	// Endpoint to get permissions for a role in a guild.
	GetPermissions(context.Context, *GetPermissionsRequest) (*GetPermissionsResponse, error)
	// Endpoint to change the position of a role in the role list in a guild.
	MoveRole(context.Context, *MoveRoleRequest) (*MoveRoleResponse, error)
	// Endpoint to get the roles from a guild.
	GetGuildRoles(context.Context, *GetGuildRolesRequest) (*GetGuildRolesResponse, error)
	// Endpoint to add a role to a guild.
	AddGuildRole(context.Context, *AddGuildRoleRequest) (*AddGuildRoleResponse, error)
	// Endpoint to a modify a role from a guild.
	ModifyGuildRole(context.Context, *ModifyGuildRoleRequest) (*ModifyGuildRoleResponse, error)
	// Endpoint to delete a role from a guild.
	DeleteGuildRole(context.Context, *DeleteGuildRoleRequest) (*DeleteGuildRoleResponse, error)
	// Endpoint to manage the roles of a guild member.
	ManageUserRoles(context.Context, *ManageUserRolesRequest) (*ManageUserRolesResponse, error)
	// Endpoint to get the roles a guild member has.
	GetUserRoles(context.Context, *GetUserRolesRequest) (*GetUserRolesResponse, error)
	// Endpoint to send a typing notification in a guild channel.
	Typing(context.Context, *TypingRequest) (*TypingResponse, error)
	// Endpoint to "preview" a guild, which returns some information about a
	// guild.
	//
	// - Guilds with the "direct message" kind can only be previewed
	// by the user who is invited to the guild.
	PreviewGuild(context.Context, *PreviewGuildRequest) (*PreviewGuildResponse, error)
	// Endpoint to get banned users in a guild.
	GetBannedUsers(context.Context, *GetBannedUsersRequest) (*GetBannedUsersResponse, error)
	// Endpoint to ban a user from a guild.
	BanUser(context.Context, *BanUserRequest) (*BanUserResponse, error)
	// Endpoint to kick a user from a guild.
	KickUser(context.Context, *KickUserRequest) (*KickUserResponse, error)
	// Endpoint to unban a user from a guild.
	UnbanUser(context.Context, *UnbanUserRequest) (*UnbanUserResponse, error)
	// Endpoint to get all pinned messages in a guild channel.
	GetPinnedMessages(context.Context, *GetPinnedMessagesRequest) (*GetPinnedMessagesResponse, error)
	// Endpoint to pin a message in a guild channel.
	PinMessage(context.Context, *PinMessageRequest) (*PinMessageResponse, error)
	// Endpoint to unpin a message in a guild channel.
	UnpinMessage(context.Context, *UnpinMessageRequest) (*UnpinMessageResponse, error)
	// Endpoint to stream events from the homeserver.
	// By default, this endpoint will subscribe to all events.
	// Any guilds joined in the future will be added to the subscription as well.
	// Use the UnsubscribeFromAll event for unsubscribing from all current subscriptions and disable the automatic guild subscriptions
	StreamEvents(context.Context, chan *StreamEventsRequest) (chan *StreamEventsResponse, error)
	// Endpoint to add a reaction to a message.
	AddReaction(context.Context, *AddReactionRequest) (*AddReactionResponse, error)
	// Endpoint to remove a reaction from a message.
	RemoveReaction(context.Context, *RemoveReactionRequest) (*RemoveReactionResponse, error)
	// Endpoint to give ownership to someone else.
	GrantOwnership(context.Context, *GrantOwnershipRequest) (*GrantOwnershipResponse, error)
	// Endpoint to give up your own ownership.
	// Requires that at least one other person will still be owner.
	GiveUpOwnership(context.Context, *GiveUpOwnershipRequest) (*GiveUpOwnershipResponse, error)
}

type HTTPChatServiceClient struct {
	Client         http.Client
	BaseURL        string
	WebsocketProto string
	WebsocketHost  string
	Header         http.Header
}

func (client *HTTPChatServiceClient) CreateGuild(req *CreateGuildRequest) (*CreateGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/CreateGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) CreateRoom(req *CreateRoomRequest) (*CreateRoomResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/CreateRoom", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateRoomResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) CreateDirectMessage(req *CreateDirectMessageRequest) (*CreateDirectMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/CreateDirectMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateDirectMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpgradeRoomToGuild(req *UpgradeRoomToGuildRequest) (*UpgradeRoomToGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpgradeRoomToGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpgradeRoomToGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) CreateInvite(req *CreateInviteRequest) (*CreateInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/CreateInvite", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) CreateChannel(req *CreateChannelRequest) (*CreateChannelResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/CreateChannel", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateChannelResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuildList(req *GetGuildListRequest) (*GetGuildListResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuildList", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildListResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) InviteUserToGuild(req *InviteUserToGuildRequest) (*InviteUserToGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/InviteUserToGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &InviteUserToGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetPendingInvites(req *GetPendingInvitesRequest) (*GetPendingInvitesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetPendingInvites", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPendingInvitesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) RejectPendingInvite(req *RejectPendingInviteRequest) (*RejectPendingInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/RejectPendingInvite", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &RejectPendingInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) IgnorePendingInvite(req *IgnorePendingInviteRequest) (*IgnorePendingInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/IgnorePendingInvite", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &IgnorePendingInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuild(req *GetGuildRequest) (*GetGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuildInvites(req *GetGuildInvitesRequest) (*GetGuildInvitesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuildInvites", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildInvitesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuildMembers(req *GetGuildMembersRequest) (*GetGuildMembersResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuildMembers", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildMembersResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuildChannels(req *GetGuildChannelsRequest) (*GetGuildChannelsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuildChannels", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildChannelsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetChannelMessages(req *GetChannelMessagesRequest) (*GetChannelMessagesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetChannelMessages", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetChannelMessagesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetMessage(req *GetMessageRequest) (*GetMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpdateGuildInformation(req *UpdateGuildInformationRequest) (*UpdateGuildInformationResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpdateGuildInformation", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateGuildInformationResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpdateChannelInformation(req *UpdateChannelInformationRequest) (*UpdateChannelInformationResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpdateChannelInformation", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateChannelInformationResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpdateChannelOrder(req *UpdateChannelOrderRequest) (*UpdateChannelOrderResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpdateChannelOrder", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateChannelOrderResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpdateAllChannelOrder(req *UpdateAllChannelOrderRequest) (*UpdateAllChannelOrderResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpdateAllChannelOrder", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateAllChannelOrderResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UpdateMessageText(req *UpdateMessageTextRequest) (*UpdateMessageTextResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UpdateMessageText", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateMessageTextResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) DeleteGuild(req *DeleteGuildRequest) (*DeleteGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/DeleteGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) DeleteInvite(req *DeleteInviteRequest) (*DeleteInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/DeleteInvite", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) DeleteChannel(req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/DeleteChannel", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteChannelResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) DeleteMessage(req *DeleteMessageRequest) (*DeleteMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/DeleteMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) JoinGuild(req *JoinGuildRequest) (*JoinGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/JoinGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &JoinGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) LeaveGuild(req *LeaveGuildRequest) (*LeaveGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/LeaveGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &LeaveGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) TriggerAction(req *TriggerActionRequest) (*TriggerActionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/TriggerAction", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &TriggerActionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) SendMessage(req *SendMessageRequest) (*SendMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/SendMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &SendMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) QueryHasPermission(req *QueryHasPermissionRequest) (*QueryHasPermissionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/QueryHasPermission", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &QueryHasPermissionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) SetPermissions(req *SetPermissionsRequest) (*SetPermissionsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/SetPermissions", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &SetPermissionsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetPermissions(req *GetPermissionsRequest) (*GetPermissionsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetPermissions", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPermissionsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) MoveRole(req *MoveRoleRequest) (*MoveRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/MoveRole", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &MoveRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetGuildRoles(req *GetGuildRolesRequest) (*GetGuildRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetGuildRoles", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) AddGuildRole(req *AddGuildRoleRequest) (*AddGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/AddGuildRole", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &AddGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) ModifyGuildRole(req *ModifyGuildRoleRequest) (*ModifyGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/ModifyGuildRole", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &ModifyGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) DeleteGuildRole(req *DeleteGuildRoleRequest) (*DeleteGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/DeleteGuildRole", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) ManageUserRoles(req *ManageUserRolesRequest) (*ManageUserRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/ManageUserRoles", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &ManageUserRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetUserRoles(req *GetUserRolesRequest) (*GetUserRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetUserRoles", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetUserRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) Typing(req *TypingRequest) (*TypingResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/Typing", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &TypingResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) PreviewGuild(req *PreviewGuildRequest) (*PreviewGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/PreviewGuild", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &PreviewGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetBannedUsers(req *GetBannedUsersRequest) (*GetBannedUsersResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetBannedUsers", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetBannedUsersResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) BanUser(req *BanUserRequest) (*BanUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/BanUser", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &BanUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) KickUser(req *KickUserRequest) (*KickUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/KickUser", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &KickUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UnbanUser(req *UnbanUserRequest) (*UnbanUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UnbanUser", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UnbanUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GetPinnedMessages(req *GetPinnedMessagesRequest) (*GetPinnedMessagesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GetPinnedMessages", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPinnedMessagesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) PinMessage(req *PinMessageRequest) (*PinMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/PinMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &PinMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) UnpinMessage(req *UnpinMessageRequest) (*UnpinMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/UnpinMessage", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UnpinMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) StreamEvents(req chan *StreamEventsRequest) (chan *StreamEventsResponse, error) {
	u := url.URL{Scheme: client.WebsocketProto, Host: client.WebsocketHost, Path: "/protocol.chat.v1.ChatService/StreamEvents"}
	inC := req
	outC := make(chan *StreamEventsResponse)
	c, _, err := websocket.DefaultDialer.Dial(u.String(), client.Header)
	if err != nil {
		return nil, err
	}
	go func() {
		defer c.Close()
		msgs := make(chan []byte)
		go func() {
			for {
				_, message, err := c.ReadMessage()
				if err != nil {
					close(msgs)
					break
				}
				msgs <- message
			}
		}()
		for {
			select {
			case msg, ok := <-msgs:
				if !ok {
					close(inC)
					close(outC)
					return
				}
				thing := &StreamEventsResponse{}
				err := proto.Unmarshal(msg[1:], thing)
				if err != nil {
					close(inC)
					close(outC)
					return
				}
				outC <- thing
			case send, ok := <-inC:
				if !ok {
					close(outC)
					return
				}
				data, err := proto.Marshal(send)
				if err != nil {
					return
				}
				err = c.WriteMessage(websocket.BinaryMessage, data)
				if err != nil {
					return
				}
			}
		}
	}()
	return outC, nil
}
func (client *HTTPChatServiceClient) AddReaction(req *AddReactionRequest) (*AddReactionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/AddReaction", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &AddReactionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) RemoveReaction(req *RemoveReactionRequest) (*RemoveReactionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/RemoveReaction", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &RemoveReactionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GrantOwnership(req *GrantOwnershipRequest) (*GrantOwnershipResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GrantOwnership", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GrantOwnershipResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPChatServiceClient) GiveUpOwnership(req *GiveUpOwnershipRequest) (*GiveUpOwnershipResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	hreq, err := http.NewRequest("POST", client.BaseURL+"/protocol.chat.v1.ChatService/GiveUpOwnership", reader)
	if err != nil {
		return nil, err
	}
	for k, v := range client.Header {
		hreq.Header[k] = v
	}
	hreq.Header.Add("content-type", "application/hrpc")
	resp, err := client.Client.Do(hreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GiveUpOwnershipResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}

type HTTPTestChatServiceClient struct {
	Client interface {
		Test(*http.Request, ...int) (*http.Response, error)
	}
}

func (client *HTTPTestChatServiceClient) CreateGuild(req *CreateGuildRequest) (*CreateGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/CreateGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) CreateRoom(req *CreateRoomRequest) (*CreateRoomResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/CreateRoom", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateRoomResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) CreateDirectMessage(req *CreateDirectMessageRequest) (*CreateDirectMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/CreateDirectMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateDirectMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpgradeRoomToGuild(req *UpgradeRoomToGuildRequest) (*UpgradeRoomToGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpgradeRoomToGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpgradeRoomToGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) CreateInvite(req *CreateInviteRequest) (*CreateInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/CreateInvite", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) CreateChannel(req *CreateChannelRequest) (*CreateChannelResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/CreateChannel", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &CreateChannelResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuildList(req *GetGuildListRequest) (*GetGuildListResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuildList", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildListResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) InviteUserToGuild(req *InviteUserToGuildRequest) (*InviteUserToGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/InviteUserToGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &InviteUserToGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetPendingInvites(req *GetPendingInvitesRequest) (*GetPendingInvitesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetPendingInvites", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPendingInvitesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) RejectPendingInvite(req *RejectPendingInviteRequest) (*RejectPendingInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/RejectPendingInvite", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &RejectPendingInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) IgnorePendingInvite(req *IgnorePendingInviteRequest) (*IgnorePendingInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/IgnorePendingInvite", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &IgnorePendingInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuild(req *GetGuildRequest) (*GetGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuildInvites(req *GetGuildInvitesRequest) (*GetGuildInvitesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuildInvites", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildInvitesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuildMembers(req *GetGuildMembersRequest) (*GetGuildMembersResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuildMembers", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildMembersResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuildChannels(req *GetGuildChannelsRequest) (*GetGuildChannelsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuildChannels", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildChannelsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetChannelMessages(req *GetChannelMessagesRequest) (*GetChannelMessagesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetChannelMessages", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetChannelMessagesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetMessage(req *GetMessageRequest) (*GetMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpdateGuildInformation(req *UpdateGuildInformationRequest) (*UpdateGuildInformationResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpdateGuildInformation", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateGuildInformationResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpdateChannelInformation(req *UpdateChannelInformationRequest) (*UpdateChannelInformationResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpdateChannelInformation", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateChannelInformationResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpdateChannelOrder(req *UpdateChannelOrderRequest) (*UpdateChannelOrderResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpdateChannelOrder", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateChannelOrderResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpdateAllChannelOrder(req *UpdateAllChannelOrderRequest) (*UpdateAllChannelOrderResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpdateAllChannelOrder", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateAllChannelOrderResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UpdateMessageText(req *UpdateMessageTextRequest) (*UpdateMessageTextResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UpdateMessageText", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UpdateMessageTextResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) DeleteGuild(req *DeleteGuildRequest) (*DeleteGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/DeleteGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) DeleteInvite(req *DeleteInviteRequest) (*DeleteInviteResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/DeleteInvite", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteInviteResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) DeleteChannel(req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/DeleteChannel", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteChannelResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) DeleteMessage(req *DeleteMessageRequest) (*DeleteMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/DeleteMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) JoinGuild(req *JoinGuildRequest) (*JoinGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/JoinGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &JoinGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) LeaveGuild(req *LeaveGuildRequest) (*LeaveGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/LeaveGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &LeaveGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) TriggerAction(req *TriggerActionRequest) (*TriggerActionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/TriggerAction", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &TriggerActionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) SendMessage(req *SendMessageRequest) (*SendMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/SendMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &SendMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) QueryHasPermission(req *QueryHasPermissionRequest) (*QueryHasPermissionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/QueryHasPermission", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &QueryHasPermissionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) SetPermissions(req *SetPermissionsRequest) (*SetPermissionsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/SetPermissions", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &SetPermissionsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetPermissions(req *GetPermissionsRequest) (*GetPermissionsResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetPermissions", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPermissionsResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) MoveRole(req *MoveRoleRequest) (*MoveRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/MoveRole", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &MoveRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetGuildRoles(req *GetGuildRolesRequest) (*GetGuildRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetGuildRoles", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetGuildRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) AddGuildRole(req *AddGuildRoleRequest) (*AddGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/AddGuildRole", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &AddGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) ModifyGuildRole(req *ModifyGuildRoleRequest) (*ModifyGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/ModifyGuildRole", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &ModifyGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) DeleteGuildRole(req *DeleteGuildRoleRequest) (*DeleteGuildRoleResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/DeleteGuildRole", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &DeleteGuildRoleResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) ManageUserRoles(req *ManageUserRolesRequest) (*ManageUserRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/ManageUserRoles", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &ManageUserRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetUserRoles(req *GetUserRolesRequest) (*GetUserRolesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetUserRoles", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetUserRolesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) Typing(req *TypingRequest) (*TypingResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/Typing", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &TypingResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) PreviewGuild(req *PreviewGuildRequest) (*PreviewGuildResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/PreviewGuild", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &PreviewGuildResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetBannedUsers(req *GetBannedUsersRequest) (*GetBannedUsersResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetBannedUsers", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetBannedUsersResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) BanUser(req *BanUserRequest) (*BanUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/BanUser", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &BanUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) KickUser(req *KickUserRequest) (*KickUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/KickUser", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &KickUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UnbanUser(req *UnbanUserRequest) (*UnbanUserResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UnbanUser", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UnbanUserResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GetPinnedMessages(req *GetPinnedMessagesRequest) (*GetPinnedMessagesResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GetPinnedMessages", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GetPinnedMessagesResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) PinMessage(req *PinMessageRequest) (*PinMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/PinMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &PinMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) UnpinMessage(req *UnpinMessageRequest) (*UnpinMessageResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/UnpinMessage", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &UnpinMessageResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) StreamEvents(req chan *StreamEventsRequest) (chan *StreamEventsResponse, error) {
	return nil, errors.New("unimplemented")
}
func (client *HTTPTestChatServiceClient) AddReaction(req *AddReactionRequest) (*AddReactionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/AddReaction", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &AddReactionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) RemoveReaction(req *RemoveReactionRequest) (*RemoveReactionResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/RemoveReaction", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &RemoveReactionResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GrantOwnership(req *GrantOwnershipRequest) (*GrantOwnershipResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GrantOwnership", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GrantOwnershipResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
func (client *HTTPTestChatServiceClient) GiveUpOwnership(req *GiveUpOwnershipRequest) (*GiveUpOwnershipResponse, error) {
	data, marshalErr := proto.Marshal(req)
	if marshalErr != nil {
		return nil, marshalErr
	}
	reader := bytes.NewReader(data)
	testreq := httptest.NewRequest("POST", "/protocol.chat.v1.ChatService/GiveUpOwnership", reader)
	resp, err := client.Client.Test(testreq)
	if err != nil {
		return nil, err
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	ret := &GiveUpOwnershipResponse{}
	unmarshalErr := proto.Unmarshal(body, ret)
	if unmarshalErr != nil {
		return nil, unmarshalErr
	}
	return ret, nil
}
