// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// EducationAssignmentPublishRequestParameter undocumented
type EducationAssignmentPublishRequestParameter struct {
}

// EducationSubmissionReturnRequestParameter undocumented
type EducationSubmissionReturnRequestParameter struct {
}

// EducationSubmissionSubmitRequestParameter undocumented
type EducationSubmissionSubmitRequestParameter struct {
}

// EducationSubmissionUnsubmitRequestParameter undocumented
type EducationSubmissionUnsubmitRequestParameter struct {
}

// EducationSynchronizationProfileResumeRequestParameter undocumented
type EducationSynchronizationProfileResumeRequestParameter struct {
}

// EducationSynchronizationProfilePauseRequestParameter undocumented
type EducationSynchronizationProfilePauseRequestParameter struct {
}

// EducationSynchronizationProfileResetRequestParameter undocumented
type EducationSynchronizationProfileResetRequestParameter struct {
}

// EducationSynchronizationProfileStartRequestParameter undocumented
type EducationSynchronizationProfileStartRequestParameter struct {
}

// Categories returns request builder for EducationCategory collection
func (b *EducationAssignmentRequestBuilder) Categories() *EducationAssignmentCategoriesCollectionRequestBuilder {
	bb := &EducationAssignmentCategoriesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/categories"
	return bb
}

// EducationAssignmentCategoriesCollectionRequestBuilder is request builder for EducationCategory collection
type EducationAssignmentCategoriesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationCategory collection
func (b *EducationAssignmentCategoriesCollectionRequestBuilder) Request() *EducationAssignmentCategoriesCollectionRequest {
	return &EducationAssignmentCategoriesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationCategory item
func (b *EducationAssignmentCategoriesCollectionRequestBuilder) ID(id string) *EducationCategoryRequestBuilder {
	bb := &EducationCategoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationAssignmentCategoriesCollectionRequest is request for EducationCategory collection
type EducationAssignmentCategoriesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationCategory collection
func (r *EducationAssignmentCategoriesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationCategory, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationCategory
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationCategory
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationCategory collection, max N pages
func (r *EducationAssignmentCategoriesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationCategory, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationCategory collection
func (r *EducationAssignmentCategoriesCollectionRequest) Get(ctx context.Context) ([]EducationCategory, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationCategory collection
func (r *EducationAssignmentCategoriesCollectionRequest) Add(ctx context.Context, reqObj *EducationCategory) (resObj *EducationCategory, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Resources returns request builder for EducationAssignmentResource collection
func (b *EducationAssignmentRequestBuilder) Resources() *EducationAssignmentResourcesCollectionRequestBuilder {
	bb := &EducationAssignmentResourcesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/resources"
	return bb
}

// EducationAssignmentResourcesCollectionRequestBuilder is request builder for EducationAssignmentResource collection
type EducationAssignmentResourcesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationAssignmentResource collection
func (b *EducationAssignmentResourcesCollectionRequestBuilder) Request() *EducationAssignmentResourcesCollectionRequest {
	return &EducationAssignmentResourcesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationAssignmentResource item
func (b *EducationAssignmentResourcesCollectionRequestBuilder) ID(id string) *EducationAssignmentResourceRequestBuilder {
	bb := &EducationAssignmentResourceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationAssignmentResourcesCollectionRequest is request for EducationAssignmentResource collection
type EducationAssignmentResourcesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationAssignmentResource collection
func (r *EducationAssignmentResourcesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationAssignmentResource, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationAssignmentResource
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationAssignmentResource
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationAssignmentResource collection, max N pages
func (r *EducationAssignmentResourcesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationAssignmentResource, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationAssignmentResource collection
func (r *EducationAssignmentResourcesCollectionRequest) Get(ctx context.Context) ([]EducationAssignmentResource, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationAssignmentResource collection
func (r *EducationAssignmentResourcesCollectionRequest) Add(ctx context.Context, reqObj *EducationAssignmentResource) (resObj *EducationAssignmentResource, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Rubric is navigation property
func (b *EducationAssignmentRequestBuilder) Rubric() *EducationRubricRequestBuilder {
	bb := &EducationRubricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rubric"
	return bb
}

// Submissions returns request builder for EducationSubmission collection
func (b *EducationAssignmentRequestBuilder) Submissions() *EducationAssignmentSubmissionsCollectionRequestBuilder {
	bb := &EducationAssignmentSubmissionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/submissions"
	return bb
}

// EducationAssignmentSubmissionsCollectionRequestBuilder is request builder for EducationSubmission collection
type EducationAssignmentSubmissionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSubmission collection
func (b *EducationAssignmentSubmissionsCollectionRequestBuilder) Request() *EducationAssignmentSubmissionsCollectionRequest {
	return &EducationAssignmentSubmissionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSubmission item
func (b *EducationAssignmentSubmissionsCollectionRequestBuilder) ID(id string) *EducationSubmissionRequestBuilder {
	bb := &EducationSubmissionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationAssignmentSubmissionsCollectionRequest is request for EducationSubmission collection
type EducationAssignmentSubmissionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSubmission collection
func (r *EducationAssignmentSubmissionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSubmission, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSubmission
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSubmission
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSubmission collection, max N pages
func (r *EducationAssignmentSubmissionsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSubmission, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSubmission collection
func (r *EducationAssignmentSubmissionsCollectionRequest) Get(ctx context.Context) ([]EducationSubmission, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSubmission collection
func (r *EducationAssignmentSubmissionsCollectionRequest) Add(ctx context.Context, reqObj *EducationSubmission) (resObj *EducationSubmission, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AssignmentCategories returns request builder for EducationCategory collection
func (b *EducationClassRequestBuilder) AssignmentCategories() *EducationClassAssignmentCategoriesCollectionRequestBuilder {
	bb := &EducationClassAssignmentCategoriesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignmentCategories"
	return bb
}

// EducationClassAssignmentCategoriesCollectionRequestBuilder is request builder for EducationCategory collection
type EducationClassAssignmentCategoriesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationCategory collection
func (b *EducationClassAssignmentCategoriesCollectionRequestBuilder) Request() *EducationClassAssignmentCategoriesCollectionRequest {
	return &EducationClassAssignmentCategoriesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationCategory item
func (b *EducationClassAssignmentCategoriesCollectionRequestBuilder) ID(id string) *EducationCategoryRequestBuilder {
	bb := &EducationCategoryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationClassAssignmentCategoriesCollectionRequest is request for EducationCategory collection
type EducationClassAssignmentCategoriesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationCategory collection
func (r *EducationClassAssignmentCategoriesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationCategory, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationCategory
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationCategory
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationCategory collection, max N pages
func (r *EducationClassAssignmentCategoriesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationCategory, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationCategory collection
func (r *EducationClassAssignmentCategoriesCollectionRequest) Get(ctx context.Context) ([]EducationCategory, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationCategory collection
func (r *EducationClassAssignmentCategoriesCollectionRequest) Add(ctx context.Context, reqObj *EducationCategory) (resObj *EducationCategory, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Assignments returns request builder for EducationAssignment collection
func (b *EducationClassRequestBuilder) Assignments() *EducationClassAssignmentsCollectionRequestBuilder {
	bb := &EducationClassAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// EducationClassAssignmentsCollectionRequestBuilder is request builder for EducationAssignment collection
type EducationClassAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationAssignment collection
func (b *EducationClassAssignmentsCollectionRequestBuilder) Request() *EducationClassAssignmentsCollectionRequest {
	return &EducationClassAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationAssignment item
func (b *EducationClassAssignmentsCollectionRequestBuilder) ID(id string) *EducationAssignmentRequestBuilder {
	bb := &EducationAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationClassAssignmentsCollectionRequest is request for EducationAssignment collection
type EducationClassAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationAssignment collection
func (r *EducationClassAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationAssignment collection, max N pages
func (r *EducationClassAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationAssignment collection
func (r *EducationClassAssignmentsCollectionRequest) Get(ctx context.Context) ([]EducationAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationAssignment collection
func (r *EducationClassAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *EducationAssignment) (resObj *EducationAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Group is navigation property
func (b *EducationClassRequestBuilder) Group() *GroupRequestBuilder {
	bb := &GroupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/group"
	return bb
}

// Members returns request builder for EducationUser collection
func (b *EducationClassRequestBuilder) Members() *EducationClassMembersCollectionRequestBuilder {
	bb := &EducationClassMembersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/members"
	return bb
}

// EducationClassMembersCollectionRequestBuilder is request builder for EducationUser collection
type EducationClassMembersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationUser collection
func (b *EducationClassMembersCollectionRequestBuilder) Request() *EducationClassMembersCollectionRequest {
	return &EducationClassMembersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationUser item
func (b *EducationClassMembersCollectionRequestBuilder) ID(id string) *EducationUserRequestBuilder {
	bb := &EducationUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationClassMembersCollectionRequest is request for EducationUser collection
type EducationClassMembersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationUser collection
func (r *EducationClassMembersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationUser, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationUser
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationUser
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationUser collection, max N pages
func (r *EducationClassMembersCollectionRequest) GetN(ctx context.Context, n int) ([]EducationUser, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationUser collection
func (r *EducationClassMembersCollectionRequest) Get(ctx context.Context) ([]EducationUser, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationUser collection
func (r *EducationClassMembersCollectionRequest) Add(ctx context.Context, reqObj *EducationUser) (resObj *EducationUser, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Schools returns request builder for EducationSchool collection
func (b *EducationClassRequestBuilder) Schools() *EducationClassSchoolsCollectionRequestBuilder {
	bb := &EducationClassSchoolsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/schools"
	return bb
}

// EducationClassSchoolsCollectionRequestBuilder is request builder for EducationSchool collection
type EducationClassSchoolsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSchool collection
func (b *EducationClassSchoolsCollectionRequestBuilder) Request() *EducationClassSchoolsCollectionRequest {
	return &EducationClassSchoolsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSchool item
func (b *EducationClassSchoolsCollectionRequestBuilder) ID(id string) *EducationSchoolRequestBuilder {
	bb := &EducationSchoolRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationClassSchoolsCollectionRequest is request for EducationSchool collection
type EducationClassSchoolsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSchool collection
func (r *EducationClassSchoolsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSchool, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSchool
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSchool
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSchool collection, max N pages
func (r *EducationClassSchoolsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSchool, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSchool collection
func (r *EducationClassSchoolsCollectionRequest) Get(ctx context.Context) ([]EducationSchool, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSchool collection
func (r *EducationClassSchoolsCollectionRequest) Add(ctx context.Context, reqObj *EducationSchool) (resObj *EducationSchool, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Teachers returns request builder for EducationUser collection
func (b *EducationClassRequestBuilder) Teachers() *EducationClassTeachersCollectionRequestBuilder {
	bb := &EducationClassTeachersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/teachers"
	return bb
}

// EducationClassTeachersCollectionRequestBuilder is request builder for EducationUser collection
type EducationClassTeachersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationUser collection
func (b *EducationClassTeachersCollectionRequestBuilder) Request() *EducationClassTeachersCollectionRequest {
	return &EducationClassTeachersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationUser item
func (b *EducationClassTeachersCollectionRequestBuilder) ID(id string) *EducationUserRequestBuilder {
	bb := &EducationUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationClassTeachersCollectionRequest is request for EducationUser collection
type EducationClassTeachersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationUser collection
func (r *EducationClassTeachersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationUser, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationUser
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationUser
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationUser collection, max N pages
func (r *EducationClassTeachersCollectionRequest) GetN(ctx context.Context, n int) ([]EducationUser, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationUser collection
func (r *EducationClassTeachersCollectionRequest) Get(ctx context.Context) ([]EducationUser, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationUser collection
func (r *EducationClassTeachersCollectionRequest) Add(ctx context.Context, reqObj *EducationUser) (resObj *EducationUser, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Classes returns request builder for EducationClass collection
func (b *EducationRootRequestBuilder) Classes() *EducationRootClassesCollectionRequestBuilder {
	bb := &EducationRootClassesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/classes"
	return bb
}

// EducationRootClassesCollectionRequestBuilder is request builder for EducationClass collection
type EducationRootClassesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationClass collection
func (b *EducationRootClassesCollectionRequestBuilder) Request() *EducationRootClassesCollectionRequest {
	return &EducationRootClassesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationClass item
func (b *EducationRootClassesCollectionRequestBuilder) ID(id string) *EducationClassRequestBuilder {
	bb := &EducationClassRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationRootClassesCollectionRequest is request for EducationClass collection
type EducationRootClassesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationClass collection
func (r *EducationRootClassesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationClass, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationClass
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationClass
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationClass collection, max N pages
func (r *EducationRootClassesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationClass, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationClass collection
func (r *EducationRootClassesCollectionRequest) Get(ctx context.Context) ([]EducationClass, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationClass collection
func (r *EducationRootClassesCollectionRequest) Add(ctx context.Context, reqObj *EducationClass) (resObj *EducationClass, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Me is navigation property
func (b *EducationRootRequestBuilder) Me() *EducationUserRequestBuilder {
	bb := &EducationUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/me"
	return bb
}

// Schools returns request builder for EducationSchool collection
func (b *EducationRootRequestBuilder) Schools() *EducationRootSchoolsCollectionRequestBuilder {
	bb := &EducationRootSchoolsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/schools"
	return bb
}

// EducationRootSchoolsCollectionRequestBuilder is request builder for EducationSchool collection
type EducationRootSchoolsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSchool collection
func (b *EducationRootSchoolsCollectionRequestBuilder) Request() *EducationRootSchoolsCollectionRequest {
	return &EducationRootSchoolsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSchool item
func (b *EducationRootSchoolsCollectionRequestBuilder) ID(id string) *EducationSchoolRequestBuilder {
	bb := &EducationSchoolRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationRootSchoolsCollectionRequest is request for EducationSchool collection
type EducationRootSchoolsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSchool collection
func (r *EducationRootSchoolsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSchool, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSchool
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSchool
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSchool collection, max N pages
func (r *EducationRootSchoolsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSchool, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSchool collection
func (r *EducationRootSchoolsCollectionRequest) Get(ctx context.Context) ([]EducationSchool, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSchool collection
func (r *EducationRootSchoolsCollectionRequest) Add(ctx context.Context, reqObj *EducationSchool) (resObj *EducationSchool, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SynchronizationProfiles returns request builder for EducationSynchronizationProfile collection
func (b *EducationRootRequestBuilder) SynchronizationProfiles() *EducationRootSynchronizationProfilesCollectionRequestBuilder {
	bb := &EducationRootSynchronizationProfilesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/synchronizationProfiles"
	return bb
}

// EducationRootSynchronizationProfilesCollectionRequestBuilder is request builder for EducationSynchronizationProfile collection
type EducationRootSynchronizationProfilesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSynchronizationProfile collection
func (b *EducationRootSynchronizationProfilesCollectionRequestBuilder) Request() *EducationRootSynchronizationProfilesCollectionRequest {
	return &EducationRootSynchronizationProfilesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSynchronizationProfile item
func (b *EducationRootSynchronizationProfilesCollectionRequestBuilder) ID(id string) *EducationSynchronizationProfileRequestBuilder {
	bb := &EducationSynchronizationProfileRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationRootSynchronizationProfilesCollectionRequest is request for EducationSynchronizationProfile collection
type EducationRootSynchronizationProfilesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSynchronizationProfile collection
func (r *EducationRootSynchronizationProfilesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSynchronizationProfile, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSynchronizationProfile
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSynchronizationProfile
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSynchronizationProfile collection, max N pages
func (r *EducationRootSynchronizationProfilesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSynchronizationProfile, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSynchronizationProfile collection
func (r *EducationRootSynchronizationProfilesCollectionRequest) Get(ctx context.Context) ([]EducationSynchronizationProfile, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSynchronizationProfile collection
func (r *EducationRootSynchronizationProfilesCollectionRequest) Add(ctx context.Context, reqObj *EducationSynchronizationProfile) (resObj *EducationSynchronizationProfile, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Users returns request builder for EducationUser collection
func (b *EducationRootRequestBuilder) Users() *EducationRootUsersCollectionRequestBuilder {
	bb := &EducationRootUsersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/users"
	return bb
}

// EducationRootUsersCollectionRequestBuilder is request builder for EducationUser collection
type EducationRootUsersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationUser collection
func (b *EducationRootUsersCollectionRequestBuilder) Request() *EducationRootUsersCollectionRequest {
	return &EducationRootUsersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationUser item
func (b *EducationRootUsersCollectionRequestBuilder) ID(id string) *EducationUserRequestBuilder {
	bb := &EducationUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationRootUsersCollectionRequest is request for EducationUser collection
type EducationRootUsersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationUser collection
func (r *EducationRootUsersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationUser, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationUser
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationUser
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationUser collection, max N pages
func (r *EducationRootUsersCollectionRequest) GetN(ctx context.Context, n int) ([]EducationUser, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationUser collection
func (r *EducationRootUsersCollectionRequest) Get(ctx context.Context) ([]EducationUser, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationUser collection
func (r *EducationRootUsersCollectionRequest) Add(ctx context.Context, reqObj *EducationUser) (resObj *EducationUser, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// AdministrativeUnit is navigation property
func (b *EducationSchoolRequestBuilder) AdministrativeUnit() *AdministrativeUnitRequestBuilder {
	bb := &AdministrativeUnitRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/administrativeUnit"
	return bb
}

// Classes returns request builder for EducationClass collection
func (b *EducationSchoolRequestBuilder) Classes() *EducationSchoolClassesCollectionRequestBuilder {
	bb := &EducationSchoolClassesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/classes"
	return bb
}

// EducationSchoolClassesCollectionRequestBuilder is request builder for EducationClass collection
type EducationSchoolClassesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationClass collection
func (b *EducationSchoolClassesCollectionRequestBuilder) Request() *EducationSchoolClassesCollectionRequest {
	return &EducationSchoolClassesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationClass item
func (b *EducationSchoolClassesCollectionRequestBuilder) ID(id string) *EducationClassRequestBuilder {
	bb := &EducationClassRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSchoolClassesCollectionRequest is request for EducationClass collection
type EducationSchoolClassesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationClass collection
func (r *EducationSchoolClassesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationClass, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationClass
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationClass
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationClass collection, max N pages
func (r *EducationSchoolClassesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationClass, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationClass collection
func (r *EducationSchoolClassesCollectionRequest) Get(ctx context.Context) ([]EducationClass, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationClass collection
func (r *EducationSchoolClassesCollectionRequest) Add(ctx context.Context, reqObj *EducationClass) (resObj *EducationClass, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Users returns request builder for EducationUser collection
func (b *EducationSchoolRequestBuilder) Users() *EducationSchoolUsersCollectionRequestBuilder {
	bb := &EducationSchoolUsersCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/users"
	return bb
}

// EducationSchoolUsersCollectionRequestBuilder is request builder for EducationUser collection
type EducationSchoolUsersCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationUser collection
func (b *EducationSchoolUsersCollectionRequestBuilder) Request() *EducationSchoolUsersCollectionRequest {
	return &EducationSchoolUsersCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationUser item
func (b *EducationSchoolUsersCollectionRequestBuilder) ID(id string) *EducationUserRequestBuilder {
	bb := &EducationUserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSchoolUsersCollectionRequest is request for EducationUser collection
type EducationSchoolUsersCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationUser collection
func (r *EducationSchoolUsersCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationUser, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationUser
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationUser
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationUser collection, max N pages
func (r *EducationSchoolUsersCollectionRequest) GetN(ctx context.Context, n int) ([]EducationUser, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationUser collection
func (r *EducationSchoolUsersCollectionRequest) Get(ctx context.Context) ([]EducationUser, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationUser collection
func (r *EducationSchoolUsersCollectionRequest) Add(ctx context.Context, reqObj *EducationUser) (resObj *EducationUser, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Outcomes returns request builder for EducationOutcome collection
func (b *EducationSubmissionRequestBuilder) Outcomes() *EducationSubmissionOutcomesCollectionRequestBuilder {
	bb := &EducationSubmissionOutcomesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/outcomes"
	return bb
}

// EducationSubmissionOutcomesCollectionRequestBuilder is request builder for EducationOutcome collection
type EducationSubmissionOutcomesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationOutcome collection
func (b *EducationSubmissionOutcomesCollectionRequestBuilder) Request() *EducationSubmissionOutcomesCollectionRequest {
	return &EducationSubmissionOutcomesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationOutcome item
func (b *EducationSubmissionOutcomesCollectionRequestBuilder) ID(id string) *EducationOutcomeRequestBuilder {
	bb := &EducationOutcomeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSubmissionOutcomesCollectionRequest is request for EducationOutcome collection
type EducationSubmissionOutcomesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationOutcome collection
func (r *EducationSubmissionOutcomesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationOutcome, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationOutcome
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationOutcome
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationOutcome collection, max N pages
func (r *EducationSubmissionOutcomesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationOutcome, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationOutcome collection
func (r *EducationSubmissionOutcomesCollectionRequest) Get(ctx context.Context) ([]EducationOutcome, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationOutcome collection
func (r *EducationSubmissionOutcomesCollectionRequest) Add(ctx context.Context, reqObj *EducationOutcome) (resObj *EducationOutcome, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Resources returns request builder for EducationSubmissionResource collection
func (b *EducationSubmissionRequestBuilder) Resources() *EducationSubmissionResourcesCollectionRequestBuilder {
	bb := &EducationSubmissionResourcesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/resources"
	return bb
}

// EducationSubmissionResourcesCollectionRequestBuilder is request builder for EducationSubmissionResource collection
type EducationSubmissionResourcesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSubmissionResource collection
func (b *EducationSubmissionResourcesCollectionRequestBuilder) Request() *EducationSubmissionResourcesCollectionRequest {
	return &EducationSubmissionResourcesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSubmissionResource item
func (b *EducationSubmissionResourcesCollectionRequestBuilder) ID(id string) *EducationSubmissionResourceRequestBuilder {
	bb := &EducationSubmissionResourceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSubmissionResourcesCollectionRequest is request for EducationSubmissionResource collection
type EducationSubmissionResourcesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSubmissionResource collection
func (r *EducationSubmissionResourcesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSubmissionResource, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSubmissionResource
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSubmissionResource
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSubmissionResource collection, max N pages
func (r *EducationSubmissionResourcesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSubmissionResource, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSubmissionResource collection
func (r *EducationSubmissionResourcesCollectionRequest) Get(ctx context.Context) ([]EducationSubmissionResource, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSubmissionResource collection
func (r *EducationSubmissionResourcesCollectionRequest) Add(ctx context.Context, reqObj *EducationSubmissionResource) (resObj *EducationSubmissionResource, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// SubmittedResources returns request builder for EducationSubmissionResource collection
func (b *EducationSubmissionRequestBuilder) SubmittedResources() *EducationSubmissionSubmittedResourcesCollectionRequestBuilder {
	bb := &EducationSubmissionSubmittedResourcesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/submittedResources"
	return bb
}

// EducationSubmissionSubmittedResourcesCollectionRequestBuilder is request builder for EducationSubmissionResource collection
type EducationSubmissionSubmittedResourcesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSubmissionResource collection
func (b *EducationSubmissionSubmittedResourcesCollectionRequestBuilder) Request() *EducationSubmissionSubmittedResourcesCollectionRequest {
	return &EducationSubmissionSubmittedResourcesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSubmissionResource item
func (b *EducationSubmissionSubmittedResourcesCollectionRequestBuilder) ID(id string) *EducationSubmissionResourceRequestBuilder {
	bb := &EducationSubmissionResourceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSubmissionSubmittedResourcesCollectionRequest is request for EducationSubmissionResource collection
type EducationSubmissionSubmittedResourcesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSubmissionResource collection
func (r *EducationSubmissionSubmittedResourcesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSubmissionResource, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSubmissionResource
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSubmissionResource
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSubmissionResource collection, max N pages
func (r *EducationSubmissionSubmittedResourcesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSubmissionResource, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSubmissionResource collection
func (r *EducationSubmissionSubmittedResourcesCollectionRequest) Get(ctx context.Context) ([]EducationSubmissionResource, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSubmissionResource collection
func (r *EducationSubmissionSubmittedResourcesCollectionRequest) Add(ctx context.Context, reqObj *EducationSubmissionResource) (resObj *EducationSubmissionResource, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Errors returns request builder for EducationSynchronizationError collection
func (b *EducationSynchronizationProfileRequestBuilder) Errors() *EducationSynchronizationProfileErrorsCollectionRequestBuilder {
	bb := &EducationSynchronizationProfileErrorsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/errors"
	return bb
}

// EducationSynchronizationProfileErrorsCollectionRequestBuilder is request builder for EducationSynchronizationError collection
type EducationSynchronizationProfileErrorsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSynchronizationError collection
func (b *EducationSynchronizationProfileErrorsCollectionRequestBuilder) Request() *EducationSynchronizationProfileErrorsCollectionRequest {
	return &EducationSynchronizationProfileErrorsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSynchronizationError item
func (b *EducationSynchronizationProfileErrorsCollectionRequestBuilder) ID(id string) *EducationSynchronizationErrorRequestBuilder {
	bb := &EducationSynchronizationErrorRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationSynchronizationProfileErrorsCollectionRequest is request for EducationSynchronizationError collection
type EducationSynchronizationProfileErrorsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSynchronizationError collection
func (r *EducationSynchronizationProfileErrorsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSynchronizationError, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSynchronizationError
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSynchronizationError
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSynchronizationError collection, max N pages
func (r *EducationSynchronizationProfileErrorsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSynchronizationError, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSynchronizationError collection
func (r *EducationSynchronizationProfileErrorsCollectionRequest) Get(ctx context.Context) ([]EducationSynchronizationError, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSynchronizationError collection
func (r *EducationSynchronizationProfileErrorsCollectionRequest) Add(ctx context.Context, reqObj *EducationSynchronizationError) (resObj *EducationSynchronizationError, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// ProfileStatus is navigation property
func (b *EducationSynchronizationProfileRequestBuilder) ProfileStatus() *EducationSynchronizationProfileStatusRequestBuilder {
	bb := &EducationSynchronizationProfileStatusRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/profileStatus"
	return bb
}

// Assignments returns request builder for EducationAssignment collection
func (b *EducationUserRequestBuilder) Assignments() *EducationUserAssignmentsCollectionRequestBuilder {
	bb := &EducationUserAssignmentsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/assignments"
	return bb
}

// EducationUserAssignmentsCollectionRequestBuilder is request builder for EducationAssignment collection
type EducationUserAssignmentsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationAssignment collection
func (b *EducationUserAssignmentsCollectionRequestBuilder) Request() *EducationUserAssignmentsCollectionRequest {
	return &EducationUserAssignmentsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationAssignment item
func (b *EducationUserAssignmentsCollectionRequestBuilder) ID(id string) *EducationAssignmentRequestBuilder {
	bb := &EducationAssignmentRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationUserAssignmentsCollectionRequest is request for EducationAssignment collection
type EducationUserAssignmentsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationAssignment collection
func (r *EducationUserAssignmentsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationAssignment, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationAssignment
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationAssignment
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationAssignment collection, max N pages
func (r *EducationUserAssignmentsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationAssignment, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationAssignment collection
func (r *EducationUserAssignmentsCollectionRequest) Get(ctx context.Context) ([]EducationAssignment, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationAssignment collection
func (r *EducationUserAssignmentsCollectionRequest) Add(ctx context.Context, reqObj *EducationAssignment) (resObj *EducationAssignment, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Classes returns request builder for EducationClass collection
func (b *EducationUserRequestBuilder) Classes() *EducationUserClassesCollectionRequestBuilder {
	bb := &EducationUserClassesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/classes"
	return bb
}

// EducationUserClassesCollectionRequestBuilder is request builder for EducationClass collection
type EducationUserClassesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationClass collection
func (b *EducationUserClassesCollectionRequestBuilder) Request() *EducationUserClassesCollectionRequest {
	return &EducationUserClassesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationClass item
func (b *EducationUserClassesCollectionRequestBuilder) ID(id string) *EducationClassRequestBuilder {
	bb := &EducationClassRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationUserClassesCollectionRequest is request for EducationClass collection
type EducationUserClassesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationClass collection
func (r *EducationUserClassesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationClass, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationClass
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationClass
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationClass collection, max N pages
func (r *EducationUserClassesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationClass, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationClass collection
func (r *EducationUserClassesCollectionRequest) Get(ctx context.Context) ([]EducationClass, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationClass collection
func (r *EducationUserClassesCollectionRequest) Add(ctx context.Context, reqObj *EducationClass) (resObj *EducationClass, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Rubrics returns request builder for EducationRubric collection
func (b *EducationUserRequestBuilder) Rubrics() *EducationUserRubricsCollectionRequestBuilder {
	bb := &EducationUserRubricsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rubrics"
	return bb
}

// EducationUserRubricsCollectionRequestBuilder is request builder for EducationRubric collection
type EducationUserRubricsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationRubric collection
func (b *EducationUserRubricsCollectionRequestBuilder) Request() *EducationUserRubricsCollectionRequest {
	return &EducationUserRubricsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationRubric item
func (b *EducationUserRubricsCollectionRequestBuilder) ID(id string) *EducationRubricRequestBuilder {
	bb := &EducationRubricRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationUserRubricsCollectionRequest is request for EducationRubric collection
type EducationUserRubricsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationRubric collection
func (r *EducationUserRubricsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationRubric, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationRubric
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationRubric
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationRubric collection, max N pages
func (r *EducationUserRubricsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationRubric, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationRubric collection
func (r *EducationUserRubricsCollectionRequest) Get(ctx context.Context) ([]EducationRubric, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationRubric collection
func (r *EducationUserRubricsCollectionRequest) Add(ctx context.Context, reqObj *EducationRubric) (resObj *EducationRubric, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Schools returns request builder for EducationSchool collection
func (b *EducationUserRequestBuilder) Schools() *EducationUserSchoolsCollectionRequestBuilder {
	bb := &EducationUserSchoolsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/schools"
	return bb
}

// EducationUserSchoolsCollectionRequestBuilder is request builder for EducationSchool collection
type EducationUserSchoolsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationSchool collection
func (b *EducationUserSchoolsCollectionRequestBuilder) Request() *EducationUserSchoolsCollectionRequest {
	return &EducationUserSchoolsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationSchool item
func (b *EducationUserSchoolsCollectionRequestBuilder) ID(id string) *EducationSchoolRequestBuilder {
	bb := &EducationSchoolRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationUserSchoolsCollectionRequest is request for EducationSchool collection
type EducationUserSchoolsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationSchool collection
func (r *EducationUserSchoolsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationSchool, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationSchool
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationSchool
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationSchool collection, max N pages
func (r *EducationUserSchoolsCollectionRequest) GetN(ctx context.Context, n int) ([]EducationSchool, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationSchool collection
func (r *EducationUserSchoolsCollectionRequest) Get(ctx context.Context) ([]EducationSchool, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationSchool collection
func (r *EducationUserSchoolsCollectionRequest) Add(ctx context.Context, reqObj *EducationSchool) (resObj *EducationSchool, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// TaughtClasses returns request builder for EducationClass collection
func (b *EducationUserRequestBuilder) TaughtClasses() *EducationUserTaughtClassesCollectionRequestBuilder {
	bb := &EducationUserTaughtClassesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/taughtClasses"
	return bb
}

// EducationUserTaughtClassesCollectionRequestBuilder is request builder for EducationClass collection
type EducationUserTaughtClassesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationClass collection
func (b *EducationUserTaughtClassesCollectionRequestBuilder) Request() *EducationUserTaughtClassesCollectionRequest {
	return &EducationUserTaughtClassesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationClass item
func (b *EducationUserTaughtClassesCollectionRequestBuilder) ID(id string) *EducationClassRequestBuilder {
	bb := &EducationClassRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// EducationUserTaughtClassesCollectionRequest is request for EducationClass collection
type EducationUserTaughtClassesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationClass collection
func (r *EducationUserTaughtClassesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationClass, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationClass
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationClass
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationClass collection, max N pages
func (r *EducationUserTaughtClassesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationClass, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationClass collection
func (r *EducationUserTaughtClassesCollectionRequest) Get(ctx context.Context) ([]EducationClass, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationClass collection
func (r *EducationUserTaughtClassesCollectionRequest) Add(ctx context.Context, reqObj *EducationClass) (resObj *EducationClass, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// User is navigation property
func (b *EducationUserRequestBuilder) User() *UserRequestBuilder {
	bb := &UserRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/user"
	return bb
}
