# Local queue

Queue module buffers messages on disk and retries delivery multiple times to
another target to ensure reliable delivery.

It is also responsible for generation of DSN messages
in case of delivery failures.

## Arguments

First argument specifies directory to use for storage.
Relative paths are relative to the StateDirectory.

## Configuration directives

```
target.queue {
    target remote
    location ...
    max_parallelism 16
    max_tries 4
	bounce {
	    destination example.org {
	        deliver_to &local_mailboxes
	    }
	    default_destination {
	        reject
	    }
	}

    autogenerated_msg_domain example.org
    debug no
}
```

**Syntax**: target _block\_name_ <br>
**Default**: not specified

REQUIRED.

Delivery target to use for final delivery.

**Syntax**: location _directory_ <br>
**Default**: StateDirectory/configuration\_block\_name

File system directory to use to store queued messages.
Relative paths are relative to the StateDirectory.

**Syntax**: max\_parallelism _integer_ <br>
**Default**: 16

Start up to _integer_ goroutines for message processing. Basically, this option
limits amount of messages tried to be delivered concurrently.

**Syntax**: max\_tries _integer_ <br>
**Default**: 20

Attempt delivery up to _integer_ times. Note that no more attempts will be done
is permanent error occurred during previous attempt.

Delay before the next attempt will be increased exponentially using the
following formula: 15mins \* 1.2 ^ (n - 1) where n is the attempt number.
This gives you approximately the following sequence of delays:
18mins, 21mins, 25mins, 31mins, 37mins, 44mins, 53mins, 64mins, ...

**Syntax**: bounce { ... } <br>
**Default**: not specified

This configuration contains pipeline configuration to be used for generated DSN
(Delivery Status Notification) messages.

If this is block is not present in configuration, DSNs will not be generated.
Note, however, this is not what you want most of the time.

**Syntax**: autogenerated\_msg\_domain _domain_ <br>
**Default**: global directive value

Domain to use in sender address for DSNs. Should be specified too if 'bounce'
block is specified.

**Syntax**: debug _boolean_ <br>
**Default**: no

Enable verbose logging.