" vim: noexpandtab ts=4 sw=4

if exists("b:current_syntax")
	finish
endif

" Lexer-defined rules
syn match		maddyComment	"#.*"
syn region      maddyString		start=+"+ skip=+\\\\\|\\"+ end=+"+ oneline

syn region		maddyBlock		start="{" end="}" transparent fold

hi def link maddyComment	Comment
hi def link maddyString		String

" Parser-defined rules
syn match		maddyMacroName	"[a-z0-9_]" contained containedin=maddyMacro
syn match		maddyMacro      "$(.\{-})" contains=maddyMacroName

syn match		maddyMacroDefSign "=" contained
syn match		maddyMacroDef     "\^$([a-z0-9_]\{-})\s=\s.\+" contains=maddyMacro,maddyMacroDefSign

hi def link maddyMacroName			Identifier
hi def link maddyMacro				Special
hi def link maddyMacroDefSign		Special

" config.Map values
syn keyword maddyBool yes no

syn match maddyInt '\<\d\+\>'
syn match maddyInt '\<[-+]\d\+\>'
syn match maddyFloat '\<[-+]\d\+\.\d*\<'

syn match maddyReference /[ \t]&[^ \t]\+/ms=s+1 contains=maddyReferenceSign
syn match maddyReferenceSign /&/ contained

hi def link maddyBool		Boolean
hi def link maddyInt		Number
hi def link maddyFloat		Float

hi def link maddyReferenceSign	Special

" Module values

" grep --no-file -E 'Register.*\(".+", ' **.go | sed -E 's/.+Register.*\("([^"]+)", .+/\1/' | sort -u
syn keyword maddyModule
	\ checks
	\ command
	\ dane
	\ dkim
	\ dnsbl
	\ dnssec
	\ dummy
	\ extauth
	\ external
	\ file
	\ identity
	\ imap
	\ imap_filters
	\ imapsql
	\ limits
	\ lmtp
	\ loader
	\ local_policy
	\ milter
	\ modifiers
	\ msgpipeline
	\ mtasts
	\ mx_auth
	\ pam
	\ pass_table
	\ plain_separate
	\ queue
	\ regexp
	\ remote
	\ replace_rcpt
	\ replace_sender
	\ require_matching_rdns
	\ require_mx_record
	\ require_tls
	\ rspamd
	\ shadow
	\ smtp
	\ sql_query
	\ sql_table
	\ static
	\ submission

syn keyword maddyDispatchDir
	\ check
	\ modify
	\ default_source
	\ source
	\ default_destination
	\ destination
	\ reject
	\ deliver_to
	\ reroute
	\ dmarc

" grep --no-file -E 'cfg..+\(".+", ' **.go | sed -E 's/.+cfg..+\("([^"]+)", .+/\1/' | sort -u
syn keyword maddyModDir
	\ add
	\ add_header_action
	\ allow_multiple_from
	\ api_path
	\ appendlimit
	\ attempt_starttls
	\ auth
	\ autogenerated_msg_domain
	\ body_canon
	\ bounce
	\ broken_sig_action
	\ buffer
	\ cache
	\ case_insensitive
	\ certs
	\ check_early
	\ client_ipv4
	\ client_ipv6
	\ compression
	\ conn_max_idle_count
	\ conn_max_idle_time
	\ conn_reuse_limit
	\ debug
	\ defer_sender_reject
	\ del
	\ domains
	\ driver
	\ dsn
	\ ehlo
	\ endpoint
	\ enforce_early
	\ enforce_testing
	\ entry
	\ error_resp_action
	\ expand_replaceholders
	\ fail_action
	\ fail_open
	\ file
	\ flags
	\ force_ipv4
	\ fs_dir
	\ fsstore
	\ full_match
	\ hash
	\ header_canon
	\ helper
	\ hostname
	\ imap_filter
	\ init
	\ insecure_auth
	\ io_debug
	\ io_error_action
	\ io_errors
	\ junk_mailbox
	\ key_column
	\ key_path
	\ keys
	\ limits
	\ list
	\ local_ip
	\ location
	\ lookup
	\ mailfrom
	\ max_logged_rcpt_errors
	\ max_message_size
	\ max_parallelism
	\ max_received
	\ max_recipients
	\ max_tries
	\ min_mx_level
	\ min_tls_level
	\ mx_auth
	\ neutral_action
	\ newkey_algo
	\ none_action
	\ no_sig_action
	\ oversign_fields
	\ pass
	\ perdomain
	\ permerr_action
	\ quarantine_threshold
	\ read_timeout
	\ reject_threshold
	\ relaxed_requiretls
	\ required_fields
	\ require_sender_match
	\ require_tls
	\ requiretls_override
	\ responses
	\ rewrite_subj_action
	\ run_on
	\ score
	\ selector
	\ set
	\ settings_id
	\ sig_expiry
	\ sign_fields
	\ sign_subdomains
	\ softfail_action
	\ SOME_action
	\ source
	\ sqlite3_busy_timeout
	\ sqlite3_cache_size
	\ sqlite3_exclusive_lock
	\ storage
	\ table
	\ table_name
	\ tag
	\ target
	\ targets
	\ temperr_action
	\ tls
	\ tls_client
	\ use_helper
	\ user
	\ value_column
	\ write_timeout

hi def link maddyModDir		Identifier
hi def link maddyModule		Identifier
hi def link maddyDispatchDir		Identifier

let b:current_syntax = "maddy"
