package i18n

func polishTranslationSet() TranslationSet {
	return TranslationSet{
		NotEnoughSpace:                      "Za mało miejsca na wyświetlenie paneli",
		DiffTitle:                           "Różnice",
		FilesTitle:                          "Pliki",
		BranchesTitle:                       "Gałęzie",
		CommitsTitle:                        "Commity",
		StashTitle:                          "Schowek",
		SnakeTitle:                          "Snake",
		EasterEgg:                           "Jajko wielkanocne",
		UnstagedChanges:                     "Zmiany niezatwierdzone",
		StagedChanges:                       "Zmiany zatwierdzone",
		MainTitle:                           "Główny",
		MergeConfirmTitle:                   "Scalanie",
		StagingTitle:                        "Panel główny (zatwierdzanie)",
		MergingTitle:                        "Panel główny (scalanie)",
		NormalTitle:                         "Panel główny (normalny)",
		LogTitle:                            "Dziennik",
		CommitSummary:                       "Podsumowanie commita",
		CredentialsUsername:                 "Nazwa użytkownika",
		CredentialsPassword:                 "Hasło",
		CredentialsPassphrase:               "Wprowadź hasło do klucza SSH",
		CredentialsPIN:                      "Wprowadź PIN do klucza SSH",
		PassUnameWrong:                      "Niewłaściwe hasło, fraza lub nazwa użytkownika",
		Commit:                              "Commit",
		CommitTooltip:                       "Zatwierdź zmiany zatwierdzone.",
		AmendLastCommit:                     "Popraw ostatni commit",
		AmendLastCommitTitle:                "Popraw ostatni commit",
		SureToAmend:                         "Czy na pewno chcesz poprawić ostatni commit? Następnie możesz zmienić wiadomość commita z panelu commitów.",
		NoCommitToAmend:                     "Brak commita do poprawienia.",
		CommitChangesWithEditor:             "Zatwierdź zmiany używając edytora git",
		FindBaseCommitForFixup:              "Znajdź bazowy commit do poprawki",
		FindBaseCommitForFixupTooltip:       "Znajdź commit, na którym opierają się Twoje obecne zmiany, w celu poprawienia/zmiany commita. To pozwala Ci uniknąć przeglądania commitów w Twojej gałęzi jeden po drugim, aby zobaczyć, który commit powinien być poprawiony/zmieniony. Zobacz dokumentację: <https://github.com/jesseduffield/lazygit/tree/master/docs/Fixup_Commits.md>",
		NoDeletedLinesInDiff:                "Brak usuniętych linii w różnicach",
		NoBaseCommitsFound:                  "Nie znaleziono bazowych commitów",
		MultipleBaseCommitsFoundStaged:      "Znaleziono wiele bazowych commitów. (Spróbuj zatwierdzić mniej zmian naraz)",
		MultipleBaseCommitsFoundUnstaged:    "Znaleziono wiele bazowych commitów. (Spróbuj zatwierdzić część zmian)",
		BaseCommitIsAlreadyOnMainBranch:     "Bazowy commit dla tej zmiany jest już na gałęzi głównej",
		BaseCommitIsNotInCurrentView:        "Bazowy commit nie jest w bieżącym widoku",
		HunksWithOnlyAddedLinesWarning:      "Istnieją zakresy tylko z dodanymi liniami w różnicach; uważaj, aby sprawdzić, czy te należą do znalezionego bazowego commita.\n\nKontynuować?",
		StatusTitle:                         "Status",
		Menu:                                "Menu",
		Execute:                             "Wykonaj",
		Stage:                               "Zatwierdź",
		StageTooltip:                        "Przełącz zatwierdzenie dla wybranego pliku.",
		ToggleStagedAll:                     "Zatwierdź wszystko",
		ToggleStagedAllTooltip:              "Przełącz zatwierdzenie/odznaczenie dla wszystkich plików w drzewie roboczym.",
		ToggleTreeView:                      "Przełącz widok drzewa plików",
		ToggleTreeViewTooltip:               "Przełącz widok plików między płaskim a drzewem. Płaski układ pokazuje wszystkie ścieżki plików na jednej liście, układ drzewa grupuje pliki według katalogów.",
		OpenDiffTool:                        "Otwórz zewnętrzne narzędzie różnic (git difftool)",
		OpenMergeTool:                       "Otwórz zewnętrzne narzędzie scalania",
		OpenMergeToolTooltip:                "Uruchom `git mergetool`.",
		Refresh:                             "Odśwież",
		RefreshTooltip:                      "Odśwież stan git (tj. uruchom `git status`, `git branch`, itp. w tle, aby zaktualizować zawartość paneli). To nie uruchamia `git fetch`.",
		Push:                                "Wypchnij",
		PushTooltip:                         "Wypchnij bieżącą gałąź do jej gałęzi nadrzędnej. Jeśli nie skonfigurowano gałęzi nadrzędnej, zostaniesz poproszony o skonfigurowanie gałęzi nadrzędnej.",
		Pull:                                "Pociągnij",
		PullTooltip:                         "Pociągnij zmiany z zdalnego dla bieżącej gałęzi. Jeśli nie skonfigurowano gałęzi nadrzędnej, zostaniesz poproszony o skonfigurowanie gałęzi nadrzędnej.",
		Scroll:                              "Przewiń",
		MergeConflictsTitle:                 "Konflikty scalania",
		Checkout:                            "Przełącz",
		CheckoutTooltip:                     "Przełącz wybrany element.",
		CantCheckoutBranchWhilePulling:      "Nie możesz przełączyć na inną gałąź podczas pobierania bieżącej gałęzi",
		TagCheckoutTooltip:                  "Przełącz wybrany tag jako odłączoną głowę (detached HEAD).",
		RemoteBranchCheckoutTooltip:         "Przełącz na nową lokalną gałąź na podstawie wybranej gałęzi zdalnej. Nowa gałąź będzie śledzić gałąź zdalną.",
		CantPullOrPushSameBranchTwice:       "Nie możesz wypchnąć lub pociągnąć gałęzi, podczas gdy jest już wypychana lub pociągana",
		FileFilter:                          "Filtruj pliki według statusu",
		CopyToClipboardMenu:                 "Kopiuj do schowka",
		CopyFileName:                        "Nazwa pliku",
		CopyFilePath:                        "Ścieżka",
		CopyFileDiffTooltip:                 "Jeśli istnieją zatwierdzone elementy, ta komenda bierze pod uwagę tylko je. W przeciwnym razie bierze pod uwagę wszystkie niezatwierdzone.",
		CopySelectedDiff:                    "Różnice wybranego pliku",
		CopyAllFilesDiff:                    "Różnice wszystkich plików",
		NoContentToCopyError:                "Nic do skopiowania",
		FileNameCopiedToast:                 "Nazwa pliku skopiowana do schowka",
		FilePathCopiedToast:                 "Ścieżka pliku skopiowana do schowka",
		FileDiffCopiedToast:                 "Różnice pliku skopiowane do schowka",
		AllFilesDiffCopiedToast:             "Różnice wszystkich plików skopiowane do schowka",
		FilterStagedFiles:                   "Pokaż tylko zatwierdzone pliki",
		FilterUnstagedFiles:                 "Pokaż tylko niezatwierdzone pliki",
		ResetFilter:                         "Resetuj filtr",
		NoChangedFiles:                      "Brak zmienionych plików",
		SoftReset:                           "Miękki reset",
		AlreadyCheckedOutBranch:             "Już przełączono na tę gałąź",
		SureForceCheckout:                   "Czy na pewno chcesz wymusić przełączenie? Stracisz wszystkie lokalne zmiany",
		ForceCheckoutBranch:                 "Wymuś przełączenie gałęzi",
		BranchName:                          "Nazwa gałęzi",
		NewBranchNameBranchOff:              "Nowa nazwa gałęzi (gałąź oparta na '{{.branchName}}')",
		CantDeleteCheckOutBranch:            "Nie możesz usunąć przełączonej gałęzi!",
		DeleteBranchTitle:                   "Usuń gałąź '{{.selectedBranchName}}'?",
		DeleteLocalBranch:                   "Usuń lokalną gałąź",
		DeleteRemoteBranchOption:            "Usuń gałąź zdalną",
		DeleteRemoteBranchPrompt:            "Czy na pewno chcesz usunąć gałąź zdalną '{{.selectedBranchName}}' z '{{.upstream}}'?",
		ForceDeleteBranchTitle:              "Wymuś usunięcie gałęzi",
		ForceDeleteBranchMessage:            "'{{.selectedBranchName}}' nie jest w pełni scalona. Czy na pewno chcesz ją usunąć?",
		RebaseBranch:                        "Przebazuj",
		RebaseBranchTooltip:                 "Przebazuj przełączoną gałąź na wybraną gałąź.",
		CantRebaseOntoSelf:                  "Nie możesz przebazować gałęzi na siebie",
		CantMergeBranchIntoItself:           "Nie możesz scalić gałęzi do siebie",
		ForceCheckout:                       "Wymuś przełączenie",
		ForceCheckoutTooltip:                "Wymuś przełączenie wybranej gałęzi. To spowoduje odrzucenie wszystkich lokalnych zmian w drzewie roboczym przed przełączeniem na wybraną gałąź.",
		CheckoutByName:                      "Przełącz według nazwy",
		CheckoutByNameTooltip:               "Przełącz według nazwy. W polu wprowadzania możesz wpisać '-' aby przełączyć się na ostatnią gałąź.",
		NewBranch:                           "Nowa gałąź",
		NewBranchFromStashTooltip:           "Utwórz nową gałąź z wybranego wpisu schowka. Działa poprzez przełączenie git na commit, na którym wpis schowka został utworzony, tworzenie nowej gałęzi z tego commita, a następnie zastosowanie wpisu schowka do nowej gałęzi jako dodatkowego commita.",
		NoBranchesThisRepo:                  "Brak gałęzi dla tego repozytorium",
		CommitWithoutMessageErr:             "Nie możesz commitować bez wiadomości commita",
		Close:                               "Zamknij",
		CloseCancel:                         "Zamknij/Anuluj",
		Confirm:                             "Potwierdź",
		Quit:                                "Wyjdź",
		SquashTooltip:                       "Scal wybrany commit z commitami poniżej. Wiadomość wybranego commita zostanie dołączona do commita poniżej.",
		NoCommitsThisBranch:                 "Brak commitów dla tej gałęzi",
		UpdateRefHere:                       "Zaktualizuj gałąź '{{.ref}}' tutaj",
		CannotSquashOrFixupFirstCommit:      "Nie ma commita poniżej do scalenia",
		Fixup:                               "Poprawka",
		SureFixupThisCommit:                 "Czy na pewno chcesz 'poprawić' wybrane commit(y) do commita poniżej?",
		SureSquashThisCommit:                "Czy na pewno chcesz scalić wybrane commit(y) do commita poniżej?",
		Squash:                              "Scal",
		PickCommitTooltip:                   "Oznacz wybrany commit do wybrania (podczas rebazowania). Oznacza to, że commit zostanie zachowany po kontynuacji rebazowania.",
		Pick:                                "Wybierz",
		CantPickDisabledReason:              "Nie możesz wybrać commita podczas rebazowania",
		Edit:                                "Edytuj",
		RevertCommit:                        "Cofnij commit",
		Revert:                              "Cofnij",
		RevertCommitTooltip:                 "Utwórz commit cofający dla wybranego commita, który stosuje zmiany wybranego commita w odwrotnej kolejności.",
		Reword:                              "Przeformułuj",
		CommitRewordTooltip:                 "Przeformułuj wiadomość wybranego commita.",
		DropCommit:                          "Usuń",
		DropCommitTooltip:                   "Usuń wybrany commit. To usunie commit z gałęzi za pomocą rebazowania. Jeśli commit wprowadza zmiany, od których zależą późniejsze commity, być może będziesz musiał rozwiązać konflikty scalania.",
		MoveDownCommit:                      "Przesuń commit w dół",
		MoveUpCommit:                        "Przesuń commit w górę",
		CannotMoveAnyFurther:                "Nie można przesunąć dalej",
		EditCommit:                          "Edytuj (rozpocznij interaktywne rebazowanie)",
		EditCommitTooltip:                   "Edytuj wybrany commit. Użyj tego, aby rozpocząć interaktywne rebazowanie od wybranego commita. Podczas trwania rebazowania, to oznaczy wybrany commit do edycji, co oznacza, że po kontynuacji rebazowania, rebazowanie zostanie wstrzymane na wybranym commicie, aby umożliwić wprowadzenie zmian.",
		AmendCommitTooltip:                  "Popraw commit ze zmianami zatwierdzonymi. Jeśli wybrany commit jest commit HEAD, to wykona `git commit --amend`. W przeciwnym razie commit zostanie poprawiony za pomocą rebazowania.",
		Amend:                               "Popraw",
		ResetAuthor:                         "Resetuj autora",
		ResetAuthorTooltip:                  "Resetuj autora commita do aktualnie skonfigurowanego użytkownika. To również odświeży znacznik czasu autora",
		SetAuthor:                           "Ustaw autora",
		SetAuthorTooltip:                    "Ustaw autora na podstawie monitu",
		AddCoAuthor:                         "Dodaj współautora",
		AmendCommitAttribute:                "Popraw atrybut commita",
		AmendCommitAttributeTooltip:         "Ustaw/Resetuj autora commita lub ustaw współautora.",
		SetAuthorPromptTitle:                "Ustaw autora (musi wyglądać jak 'Imię <Email>')",
		AddCoAuthorPromptTitle:              "Dodaj współautora (musi wyglądać jak 'Imię <Email>')",
		AddCoAuthorTooltip:                  "Dodaj współautora używając metadanych Github/Gitlab Co-authored-by.",
		SureResetCommitAuthor:               "Pole autora tego commita zostanie zaktualizowane, aby pasowało do skonfigurowanego użytkownika. To również odświeży znacznik czasu autora. Kontynuować?",
		RewordCommitEditor:                  "Przeformułuj za pomocą edytora",
		Error:                               "Błąd",
		PickHunk:                            "Wybierz fragment",
		PickAllHunks:                        "Wybierz wszystkie fragmenty",
		Undo:                                "Cofnij",
		UndoReflog:                          "Cofnij",
		RedoReflog:                          "Ponów",
		UndoTooltip:                         "Dziennik reflog zostanie użyty do określenia, jakie polecenie git należy uruchomić, aby cofnąć ostatnie polecenie git. Nie obejmuje to zmian w drzewie roboczym; brane są pod uwagę tylko commity.",
		RedoTooltip:                         "Dziennik reflog zostanie użyty do określenia, jakie polecenie git należy uruchomić, aby ponowić ostatnie polecenie git. Nie obejmuje to zmian w drzewie roboczym; brane są pod uwagę tylko commity.",
		UndoMergeResolveTooltip:             "Cofnij ostatnie rozwiązanie konfliktu scalania.",
		DiscardAllTooltip:                   "Odrzuć wszystkie zmiany (zarówno zatwierdzone jak i niezatwierdzone) w '{{.path}}'.",
		DiscardUnstagedTooltip:              "Odrzuć niezatwierdzone zmiany w '{{.path}}'.",
		Pop:                                 "Wyciągnij",
		StashPopTooltip:                     "Zastosuj wpis schowka do katalogu roboczego i usuń wpis schowka.",
		Drop:                                "Usuń",
		StashDropTooltip:                    "Usuń wpis schowka z listy schowka.",
		Apply:                               "Zastosuj",
		StashApplyTooltip:                   "Zastosuj wpis schowka do katalogu roboczego.",
		NoStashEntries:                      "Brak wpisów schowka",
		StashDrop:                           "Usuń schowek",
		SureDropStashEntry:                  "Czy na pewno chcesz usunąć ten wpis schowka?",
		StashPop:                            "Wyciągnij schowek",
		SurePopStashEntry:                   "Czy na pewno chcesz wyciągnąć ten wpis schowka?",
		StashApply:                          "Zastosuj schowek",
		SureApplyStashEntry:                 "Czy na pewno chcesz zastosować ten wpis schowka?",
		NoTrackedStagedFilesStash:           "Nie masz śledzonych/zatwierdzonych plików do schowania",
		NoFilesToStash:                      "Nie masz plików do schowania",
		StashChanges:                        "Schowaj zmiany",
		RenameStash:                         "Zmień nazwę schowka",
		RenameStashPrompt:                   "Zmień nazwę schowka: {{.stashName}}",
		OpenConfig:                          "Otwórz plik konfiguracyjny",
		EditConfig:                          "Edytuj plik konfiguracyjny",
		ForcePush:                           "Wymuś wysłanie",
		ForcePushPrompt:                     "Twoja gałąź rozbiegła się z gałęzią zdalną. Naciśnij {{.cancelKey}}, aby anulować, lub {{.confirmKey}}, aby wymusić wysłanie.",
		ForcePushDisabled:                   "Twoja gałąź rozbiegła się z gałęzią zdalną i masz wyłączone wymuszanie wysyłania",
		CheckForUpdate:                      "Sprawdź aktualizacje",
		CheckingForUpdates:                  "Sprawdzanie aktualizacji...",
		UpdateAvailableTitle:                "Dostępna aktualizacja!",
		UpdateAvailable:                     "Pobrać i zainstalować wersję {{.newVersion}}?",
		UpdateInProgressWaitingStatus:       "Aktualizacja",
		UpdateCompletedTitle:                "Aktualizacja zakończona!",
		UpdateCompleted:                     "Aktualizacja została pomyślnie zainstalowana. Uruchom ponownie lazygit, aby zaczęła działać.",
		FailedToRetrieveLatestVersionErr:    "Nie udało się pobrać informacji o wersji",
		OnLatestVersionErr:                  "Masz już najnowszą wersję",
		MajorVersionErr:                     "Nowa wersja ({{.newVersion}}) zawiera zmiany niekompatybilne wstecznie w porównaniu z bieżącą wersją ({{.currentVersion}})",
		CouldNotFindBinaryErr:               "Nie można znaleźć żadnego pliku binarnego pod adresem {{.url}}",
		UpdateFailedErr:                     "Aktualizacja nie powiodła się: {{.errMessage}}",
		ConfirmQuitDuringUpdateTitle:        "Aktualizacja w toku",
		ConfirmQuitDuringUpdate:             "Aktualizacja jest w toku. Czy na pewno chcesz wyjść?",
		MergeToolTitle:                      "Narzędzie scalania",
		MergeToolPrompt:                     "Czy na pewno chcesz otworzyć `git mergetool`?",
		IntroPopupMessage:                   englishIntroPopupMessage,
		DeprecatedEditConfigWarning:         englishDeprecatedEditConfigWarning,
		GitconfigParseErr:                   `Gogit nie mógł przetworzyć pliku gitconfig z powodu obecności niezacytowanych znaków '\'. Usunięcie ich powinno rozwiązać problem.`,
		EditFile:                            `Edytuj plik`,
		EditFileTooltip:                     "Otwórz plik w zewnętrznym edytorze.",
		OpenFile:                            `Otwórz plik`,
		OpenFileTooltip:                     "Otwórz plik w domyślnej aplikacji.",
		OpenInEditor:                        "Otwórz w edytorze",
		IgnoreFile:                          `Dodaj do .gitignore`,
		ExcludeFile:                         `Dodaj do .git/info/exclude`,
		RefreshFiles:                        `Odśwież pliki`,
		Merge:                               `Scal`,
		MergeBranchTooltip:                  "Scal wybraną gałąź z aktualnie sprawdzoną gałęzią.",
		ConfirmQuit:                         `Czy na pewno chcesz wyjść?`,
		SwitchRepo:                          `Przełącz na ostatnie repozytorium`,
		AllBranchesLogGraph:                 `Pokaż wszystkie gałęzie w logach`,
		UnsupportedGitService:               `Nieobsługiwana usługa git`,
		CreatePullRequest:                   `Utwórz żądanie ściągnięcia`,
		CopyPullRequestURL:                  `Kopiuj adres URL żądania ściągnięcia do schowka`,
		NoBranchOnRemote:                    `Ta gałąź nie istnieje na zdalnym serwerze. Musisz ją najpierw wysłać na zdalny serwer.`,
		Fetch:                               `Pobierz`,
		FetchTooltip:                        "Pobierz zmiany ze zdalnego serwera.",
		NoAutomaticGitFetchTitle:            `Brak automatycznego pobierania git`,
		NoAutomaticGitFetchBody:             `Lazygit nie może używać "git fetch" w prywatnym repozytorium; użyj 'f' w panelu plików, aby ręcznie uruchomić "git fetch"`,
		FileEnter:                           `Zatwierdź linie / Zwiń katalog`,
		FileEnterTooltip:                    "Jeśli wybrany element jest plikiem, skup się na widoku zatwierdzania, aby móc zatwierdzać poszczególne fragmenty/linie. Jeśli wybrany element jest katalogiem, zwiń/rozwiń go.",
		FileStagingRequirements:             `Można zatwierdzać poszczególne linie tylko dla śledzonych plików`,
		StageSelectionTooltip:               `Przełącz zaznaczenie zatwierdzone/niezatwierdzone.`,
		DiscardSelection:                    `Odrzuć`,
		DiscardSelectionTooltip:             "Gdy zaznaczona jest niezatwierdzona zmiana, odrzuć ją używając `git reset`. Gdy zaznaczona jest zatwierdzona zmiana, cofnij zatwierdzenie.",
		ToggleRangeSelect:                   "Przełącz zaznaczenie zakresu",
		ToggleSelectHunk:                    "Zaznacz fragment",
		ToggleSelectHunkTooltip:             "Przełącz tryb zaznaczania fragmentu.",
		ToggleSelectionForPatch:             `Przełącz linie w łatce`,
		EditHunk:                            `Edytuj fragment`,
		EditHunkTooltip:                     "Edytuj wybrany fragment w zewnętrznym edytorze.",
		ToggleStagingView:                   "Przełącz widok",
		ToggleStagingViewTooltip:            "Przełącz na inny widok (zatwierdzone/niezatwierdzone zmiany).",
		ReturnToFilesPanel:                  `Wróć do panelu plików`,
		FastForward:                         `Szybkie przewijanie`,
		FastForwardTooltip:                  "Szybkie przewijanie wybranej gałęzi z jej źródła.",
		FastForwarding:                      "Szybkie przewijanie",
		FoundConflictsTitle:                 "Konflikty!",
		ViewConflictsMenuItem:               "Pokaż konflikty",
		AbortMenuItem:                       "Przerwij %s",
		ViewMergeRebaseOptions:              "Pokaż opcje scalania/rebase",
		ViewMergeRebaseOptionsTooltip:       "Pokaż opcje do przerwania/kontynuowania/pominięcia bieżącego scalania/rebase.",
		ViewMergeOptions:                    "Pokaż opcje scalania",
		ViewRebaseOptions:                   "Pokaż opcje rebase",
		NotMergingOrRebasing:                "Aktualnie nie wykonujesz ani scalania, ani rebase",
		AlreadyRebasing:                     "Nie można wykonać tej akcji podczas rebase",
		RecentRepos:                         "Ostatnie repozytoria",
		MergeOptionsTitle:                   "Opcje scalania",
		RebaseOptionsTitle:                  "Opcje rebase",
		CommitSummaryTitle:                  "Podsumowanie commita",
		CommitDescriptionTitle:              "Opis commita",
		CommitDescriptionSubTitle:           "Naciśnij {{.togglePanelKeyBinding}}, aby przełączyć fokus, {{.commitMenuKeybinding}}, aby otworzyć menu",
		LocalBranchesTitle:                  "Lokalne gałęzie",
		SearchTitle:                         "Szukaj",
		TagsTitle:                           "Tagi",
		MenuTitle:                           "Menu",
		CommitMenuTitle:                     "Menu commita",
		RemotesTitle:                        "Zdalne",
		RemoteBranchesTitle:                 "Zdalne gałęzie",
		PatchBuildingTitle:                  "Główny panel (budowanie łatki)",
		InformationTitle:                    "Informacje",
		SecondaryTitle:                      "Dodatkowy",
		ReflogCommitsTitle:                  "Reflog",
		GlobalTitle:                         "Globalne skróty klawiszowe",
		ConflictsResolved:                   "Wszystkie konflikty scalania rozwiązane. Kontynuować?",
		Continue:                            "Kontynuuj",
		Keybindings:                         "Skróty klawiszowe",
		KeybindingsMenuSectionLocal:         "Lokalne",
		KeybindingsMenuSectionGlobal:        "Globalne",
		KeybindingsMenuSectionNavigation:    "Nawigacja",
		RebasingTitle:                       "Rebase '{{.checkedOutBranch}}' na '{{.ref}}'",
		RebasingFromBaseCommitTitle:         "Rebase '{{.checkedOutBranch}}' od oznaczonego commita bazowego na '{{.ref}}'",
		SimpleRebase:                        "Prosty rebase",
		InteractiveRebase:                   "Interaktywny rebase",
		InteractiveRebaseTooltip:            "Rozpocznij interaktywny rebase z przerwaniem na początku, abyś mógł zaktualizować commity TODO przed kontynuacją.",
		MustSelectTodoCommits:               "Podczas rebase ta akcja działa tylko na zaznaczonych commitach TODO.",
		ConfirmMerge:                        "Czy na pewno chcesz scalić '{{.selectedBranch}}' z '{{.checkedOutBranch}}'?",
		FwdNoUpstream:                       "Nie można szybko przewinąć gałęzi bez źródła",
		FwdNoLocalUpstream:                  "Nie można szybko przewinąć gałęzi, której zdalne źródło nie jest zarejestrowane lokalnie",
		FwdCommitsToPush:                    "Nie można szybko przewinąć gałęzi z commitami do wysłania",
		PullRequestNoUpstream:               "Nie można otworzyć żądania ściągnięcia dla gałęzi bez źródła",
		ErrorOccurred:                       "Wystąpił błąd! Proszę utworzyć zgłoszenie na",
		NoRoom:                              "Za mało miejsca",
		YouAreHere:                          "JESTEŚ TUTAJ",
		YouDied:                             "ZGINĄŁEŚ!",
		RewordNotSupported:                  "Zmiana słów commitów podczas interaktywnego rebase nie jest obecnie obsługiwana",
		ChangingThisActionIsNotAllowed:      "Zmiana tego rodzaju wpisu rebase TODO nie jest dozwolona",
		CherryPickCopy:                      "Kopiuj (cherry-pick)",
		CherryPickCopyTooltip:               "Oznacz commit jako skopiowany. Następnie, w widoku lokalnych commitów, możesz nacisnąć `{{.paste}}`, aby wkleić (cherry-pick) skopiowane commity do sprawdzonej gałęzi. W dowolnym momencie możesz nacisnąć `{{.escape}}`, aby anulować zaznaczenie.",
		CherryPickCopyRangeTooltip:          "Oznacz commity jako skopiowane od ostatniego skopiowanego commita do wybranego commita.",
		PasteCommits:                        "Wklej (cherry-pick)",
		SureCherryPick:                      "Czy na pewno chcesz cherry-pick skopiowane commity na tę gałąź?",
		CherryPick:                          "Cherry-pick",
		CannotCherryPickNonCommit:           "Nie można cherry-pick tego rodzaju wpisu TODO",
		CannotCherryPickMergeCommit:         "Cherry-pick commitów scalających nie jest obsługiwane",
		Donate:                              "Wesprzyj",
		AskQuestion:                         "Zadaj pytanie",
		PrevLine:                            "Wybierz poprzednią linię",
		NextLine:                            "Wybierz następną linię",
		PrevHunk:                            "Idź do poprzedniego fragmentu",
		NextHunk:                            "Idź do następnego fragmentu",
		PrevConflict:                        "Poprzedni konflikt",
		NextConflict:                        "Następny konflikt",
		SelectPrevHunk:                      "Poprzedni fragment",
		SelectNextHunk:                      "Następny fragment",
		ScrollDown:                          "Przewiń w dół",
		ScrollUp:                            "Przewiń w górę",
		ScrollUpMainWindow:                  "Przewiń główne okno w górę",
		ScrollDownMainWindow:                "Przewiń główne okno w dół",
		AmendCommitTitle:                    "Popraw commit",
		AmendCommitPrompt:                   "Czy na pewno chcesz poprawić ten commit swoimi zatwierdzonymi plikami?",
		DropCommitTitle:                     "Usuń commit",
		DropCommitPrompt:                    "Czy na pewno chcesz usunąć wybrane commity?",
		PullingStatus:                       "Ściąganie",
		PushingStatus:                       "Wysyłanie",
		FetchingStatus:                      "Pobieranie",
		SquashingStatus:                     "Sciskanie",
		FixingStatus:                        "Naprawianie",
		DeletingStatus:                      "Usuwanie",
		DroppingStatus:                      "Upuszczanie",
		MovingStatus:                        "Przesuwanie",
		RebasingStatus:                      "Rebase",
		MergingStatus:                       "Scalanie",
		LowercaseRebasingStatus:             "rebase",   // małe litery, ponieważ pojawia się w nawiasach
		LowercaseMergingStatus:              "scalanie", // małe litery, ponieważ pojawia się w nawiasach
		AmendingStatus:                      "Poprawianie",
		CherryPickingStatus:                 "Cherry-picking",
		UndoingStatus:                       "Cofanie",
		RedoingStatus:                       "Ponawianie",
		CheckingOutStatus:                   "Sprawdzanie",
		CommittingStatus:                    "Commitowanie",
		RevertingStatus:                     "Przywracanie",
		CreatingFixupCommitStatus:           "Tworzenie commita poprawiającego",
		CommitFiles:                         "Zatwierdź pliki",
		SubCommitsDynamicTitle:              "Commity (%s)",
		CommitFilesDynamicTitle:             "Pliki różnic (%s)",
		RemoteBranchesDynamicTitle:          "Zdalne gałęzie (%s)",
		ViewItemFiles:                       "Wyświetl pliki",
		ViewItemFilesTooltip:                "Wyświetl pliki zmodyfikowane przez wybrany element.",
		CommitFilesTitle:                    "Pliki commita",
		CheckoutCommitFileTooltip:           "Przełącz plik. Zastępuje plik w twoim drzewie roboczym wersją z wybranego commita.",
		CanOnlyDiscardFromLocalCommits:      "Można odrzucić tylko zmiany z lokalnych commitów",
		Remove:                              "Usuń",
		DiscardOldFileChangeTooltip:         "Odrzuć zmiany w tym pliku z tego commita. Uruchamia interaktywny rebase w tle, więc możesz otrzymać konflikt scalania, jeśli późniejszy commit również zmienia ten plik.",
		DiscardFileChangesTitle:             "Odrzuć zmiany w pliku",
		DiscardFileChangesPrompt:            "Czy na pewno chcesz usunąć zmiany w wybranym pliku/ach z tego commita?\n\nTa akcja uruchomi rebase, cofając te zmiany w pliku. Pamiętaj, że jeśli późniejsze commity zależą od tych zmian, możesz potrzebować rozwiązać konflikty.\nUwaga: Spowoduje to również zresetowanie wszelkich aktywnych niestandardowych łatek.",
		DisabledForGPG:                      "Funkcja niedostępna dla użytkowników używających GPG",
		CreateRepo:                          "Nie w repozytorium git. Utworzyć nowe repozytorium git? (t/n): ",
		BareRepo:                            "Próbujesz otworzyć Lazygit w gołym repozytorium, ale Lazygit jeszcze nie obsługuje gołych repozytoriów. Otworzyć najnowsze repozytorium? (t/n) ",
		InitialBranch:                       "Nazwa gałęzi? (pozostaw puste dla domyślnej gita): ",
		NoRecentRepositories:                "Musisz otworzyć lazygit w repozytorium git. Brak ważnych ostatnich repozytoriów. Wyjście.",
		IncorrectNotARepository:             "Wartość 'notARepository' jest nieprawidłowa. Powinna być jedną z 'prompt', 'create', 'skip', lub 'quit'.",
		AutoStashTitle:                      "Autostash?",
		AutoStashPrompt:                     "Musisz schować i wyciągnąć swoje zmiany, aby je przenieść. Zrobić to automatycznie? (enter/esc)",
		StashPrefix:                         "Automatyczne chowanie zmian dla ",
		Discard:                             "Odrzuć",
		DiscardFileChangesTooltip:           "Wyświetl opcje odrzucania zmian w wybranym pliku.",
		DiscardChangesTitle:                 "Odrzuć zmiany",
		Cancel:                              "Anuluj",
		DiscardAllChanges:                   "Odrzuć wszystkie zmiany",
		DiscardUnstagedChanges:              "Odrzuć niezatwierdzone zmiany",
		DiscardAllChangesToAllFiles:         "Zniszcz drzewo robocze",
		DiscardAnyUnstagedChanges:           "Odrzuć niezatwierdzone zmiany",
		DiscardUntrackedFiles:               "Odrzuć nieśledzone pliki",
		DiscardStagedChanges:                "Odrzuć zatwierdzone zmiany",
		HardReset:                           "Twardy reset",
		BranchDeleteTooltip:                 "Wyświetl opcje usuwania lokalnej/odległej gałęzi.",
		TagDeleteTooltip:                    "Wyświetl opcje usuwania lokalnego/odległego tagu.",
		Delete:                              "Usuń",
		Reset:                               "Reset",
		ResetTooltip:                        "Wyświetl opcje resetu (miękki/mieszany/twardy) do wybranego elementu.",
		ResetSoftTooltip:                    "Resetuj HEAD do wybranego commita, zachowując zmiany między bieżącym a wybranym commit jako zmiany zatwierdzone.",
		ResetMixedTooltip:                   "Resetuj HEAD do wybranego commita, zachowując zmiany między bieżącym a wybranym commit jako zmiany niezatwierdzone.",
		ResetHardTooltip:                    "Resetuj HEAD do wybranego commita, odrzucając wszystkie zmiany między bieżącym a wybranym commit, jak również wszystkie bieżące modyfikacje w drzewie roboczym.",
		ViewResetOptions:                    `Reset`,
		FileResetOptionsTooltip:             "Wyświetl opcje resetu dla drzewa roboczego (np. zniszczenie drzewa roboczego).",
		FixupTooltip:                        "Włącz wybrany commit do commita poniżej. Podobnie do fixup, ale wiadomość wybranego commita zostanie odrzucona.",
		CreateFixupCommitTooltip:            "Utwórz commit 'fixup!' dla wybranego commita. Później możesz nacisnąć `{{.squashAbove}}` na tym samym commicie, aby zastosować wszystkie powyższe commity fixup.",
		SquashAboveCommits:                  "Zastosuj commity fixup",
		SquashAboveCommitsTooltip:           `Scal wszystkie commity 'fixup!', albo powyżej wybranego commita, albo wszystkie w bieżącej gałęzi (autosquash).`,
		SquashCommitsAboveSelectedTooltip:   `Scal wszystkie commity 'fixup!' powyżej wybranego commita (autosquash).`,
		SquashCommitsInCurrentBranchTooltip: `Scal wszystkie commity 'fixup!' w bieżącej gałęzi (autosquash).`,
		SquashCommitsInCurrentBranch:        "W bieżącej gałęzi",
		SquashCommitsAboveSelectedCommit:    "Powyżej wybranego commita",
		CannotSquashCommitsInCurrentBranch:  "Nie można scalić commitów w bieżącej gałęzi: commit HEAD jest commit merge lub jest obecny na głównej gałęzi.",
		CreateFixupCommit:                   `Utwórz commit fixup`,
		ExecuteCustomCommand:                "Wykonaj polecenie niestandardowe",
		ExecuteCustomCommandTooltip:         "Wyświetl monit, w którym możesz wprowadzić polecenie powłoki do wykonania. Nie należy mylić z wcześniej skonfigurowanymi poleceniami niestandardowymi.",
		CustomCommand:                       "Polecenie niestandardowe:",
		CommitChangesWithoutHook:            "Zatwierdź zmiany bez hooka pre-commit",
		SkipHookPrefixNotConfigured:         "Nie skonfigurowano prefiksu wiadomości commita do pomijania hooków. Ustaw `git.skipHookPrefix = 'WIP'` w swojej konfiguracji",
		ResetTo:                             `Resetuj do`,
		PressEnterToReturn:                  "Naciśnij enter, aby wrócić do lazygit",
		ViewStashOptions:                    "Wyświetl opcje schowka",
		ViewStashOptionsTooltip:             "Wyświetl opcje schowka (np. schowaj wszystko, schowaj zatwierdzone, schowaj niezatwierdzone).",
		Stash:                               "Schowaj",
		StashTooltip:                        "Schowaj wszystkie zmiany. Dla innych wariantów schowania, użyj klawisza wyświetlania opcji schowka.",
		StashAllChanges:                     "Schowaj wszystkie zmiany",
		StashStagedChanges:                  "Schowaj zatwierdzone zmiany",
		StashAllChangesKeepIndex:            "Schowaj wszystkie zmiany i zachowaj indeks",
		StashUnstagedChanges:                "Schowaj niezatwierdzone zmiany",
		StashIncludeUntrackedChanges:        "Schowaj wszystkie zmiany włącznie z nieśledzonymi plikami",
		StashOptions:                        "Opcje schowka",
		NotARepository:                      "Błąd: musi być uruchomione wewnątrz repozytorium git",
		WorkingDirectoryDoesNotExist:        "Błąd: bieżący katalog roboczy nie istnieje",
		Jump:                                "Skocz do panelu",
		ScrollLeftRight:                     "Przewiń w lewo/prawo",
		ScrollLeft:                          "Przewiń w lewo",
		ScrollRight:                         "Przewiń w prawo",
		DiscardPatch:                        "Odrzuć łatkę",
		DiscardPatchConfirm:                 "Możesz zbudować łatkę tylko z jednego commita/stanu schowka na raz. Odrzucić bieżącą łatkę?",
		DiscardPatchSameCommitConfirm:       "Masz obecnie zmiany dodane do łatki dla tego commita. Odrzucić bieżącą łatkę?",
		CantPatchWhileRebasingError:         "Nie można budować łatki ani uruchamiać poleceń łatki podczas scalania lub rebasowania",
		ToggleAddToPatch:                    "Przełącz plik włączony w łatkę",
		ToggleAddToPatchTooltip:             "Przełącz, czy plik jest włączony w niestandardową łatkę. Zobacz {{.doc}}.",
		ToggleAllInPatch:                    "Przełącz wszystkie pliki",
		ToggleAllInPatchTooltip:             "Dodaj/usuń wszystkie pliki commita do niestandardowej łatki. Zobacz {{.doc}}.",
		UpdatingPatch:                       "Aktualizowanie łatki",
		ViewPatchOptions:                    "Wyświetl opcje niestandardowej łatki",
		PatchOptionsTitle:                   "Opcje łatki",
		NoPatchError:                        "Brak utworzonej łatki. Aby zacząć budować łatkę, użyj 'spacji' na pliku commita lub enter, aby dodać określone linie",
		EmptyPatchError:                     "Łatka jest nadal pusta. Najpierw dodaj kilka plików lub linii do łatki.",
		EnterCommitFile:                     "Wejdź do pliku / Przełącz zwiń katalog",
		EnterCommitFileTooltip:              "Jeśli plik jest wybrany, wejdź do pliku, aby móc dodawać/usuwać poszczególne linie do niestandardowej łatki. Jeśli wybrany jest katalog, przełącz katalog.",
		ExitCustomPatchBuilder:              `Wyjdź z budowniczego niestandardowej łatki`,
		EnterUpstream:                       `Wprowadź upstream jako '<zdalny> <nazwa gałęzi>'`,
		InvalidUpstream:                     "Nieprawidłowy upstream. Musi być w formacie '<zdalny> <nazwa gałęzi>'",
		ReturnToRemotesList:                 `Wróć do listy zdalnych`,
		NewRemote:                           `Nowy zdalny`,
		NewRemoteName:                       `Nowa nazwa zdalnego:`,
		NewRemoteUrl:                        `Nowy URL zdalnego:`,
		ViewBranches:                        "Wyświetl gałęzie",
		EditRemoteName:                      `Wprowadź zaktualizowaną nazwę zdalnego dla {{.remoteName}}:`,
		EditRemoteUrl:                       `Wprowadź zaktualizowany URL zdalnego dla {{.remoteName}}:`,
		RemoveRemote:                        `Usuń zdalny`,
		RemoveRemoteTooltip:                 `Usuń wybrany zdalny. Wszelkie lokalne gałęzie śledzące gałąź zdalną z tego zdalnego nie zostaną dotknięte.`,
		RemoveRemotePrompt:                  "Czy na pewno chcesz usunąć zdalny",
		DeleteRemoteBranch:                  "Usuń gałąź zdalną",
		DeleteRemoteBranchMessage:           "Czy na pewno chcesz usunąć gałąź zdalną",
		DeleteRemoteBranchTooltip:           "Usuń gałąź zdalną ze zdalnego.",
		SetAsUpstream:                       "Ustaw jako upstream",
		SetAsUpstreamTooltip:                "Ustaw wybraną gałąź zdalną jako upstream sprawdzonej gałęzi.",
		SetUpstream:                         "Ustaw upstream wybranej gałęzi",
		UnsetUpstream:                       "Usuń upstream wybranej gałęzi",
		ViewDivergenceFromUpstream:          "Wyświetl rozbieżność od upstream",
		DivergenceSectionHeaderLocal:        "Lokalne",
		DivergenceSectionHeaderRemote:       "Zdalne",
		ViewUpstreamResetOptions:            "Resetuj sprawdzoną gałąź na {{.upstream}}",
		ViewUpstreamResetOptionsTooltip:     "Wyświetl opcje resetowania sprawdzonej gałęzi na {{upstream}}. Uwaga: to nie zresetuje wybranej gałęzi na upstream, zresetuje sprawdzoną gałąź na upstream.",
		ViewUpstreamRebaseOptions:           "Rebase sprawdzonej gałęzi na {{.upstream}}",
		ViewUpstreamRebaseOptionsTooltip:    "Wyświetl opcje rebasowania sprawdzonej gałęzi na {{upstream}}. Uwaga: to nie zrebase'uje wybranej gałęzi na upstream, zrebase'uje sprawdzoną gałąź na upstream.",
		UpstreamGenericName:                 "upstream wybranej gałęzi",
		SetUpstreamTitle:                    "Ustaw gałąź upstream",
		SetUpstreamMessage:                  "Czy na pewno chcesz ustawić gałąź upstream '{{.checkedOut}}' na '{{.selected}}'",
		EditRemoteTooltip:                   "Edytuj nazwę lub URL wybranego zdalnego.",
		TagCommit:                           "Otaguj commit",
		TagCommitTooltip:                    "Utwórz nowy tag wskazujący na wybrany commit. Zostaniesz poproszony o wprowadzenie nazwy tagu i opcjonalnego opisu.",
		TagMenuTitle:                        "Utwórz tag",
		TagNameTitle:                        "Nazwa tagu",
		TagMessageTitle:                     "Opis tagu",
		AnnotatedTag:                        "Tag z adnotacją",
		LightweightTag:                      "Lekki tag",
		DeleteTagTitle:                      "Usuń tag '{{.tagName}}'?",
		DeleteLocalTag:                      "Usuń lokalny tag",
		DeleteRemoteTag:                     "Usuń zdalny tag",
		RemoteTagDeletedMessage:             "Zdalny tag usunięty",
		SelectRemoteTagUpstream:             "Zdalny, z którego usunąć tag '{{.tagName}}':",
		DeleteRemoteTagPrompt:               "Czy na pewno chcesz usunąć zdalny tag '{{.tagName}}' z '{{.upstream}}'?",
		PushTagTitle:                        "Zdalny, do którego wysłać tag '{{.tagName}}':",
		PushTag:                             "Wyślij tag",
		PushTagTooltip:                      "Wyślij wybrany tag do zdalnego. Zostaniesz poproszony o wybranie zdalnego.",
		NewTag:                              "Nowy tag",
		NewTagTooltip:                       "Utwórz nowy tag z bieżącego commita. Zostaniesz poproszony o wprowadzenie nazwy tagu i opcjonalnego opisu.",
		CreatingTag:                         "Tworzenie tagu",
		ForceTag:                            "Wymuś Tag",
		ForceTagPrompt:                      "Tag '{{.tagName}}' już istnieje. Naciśnij {{.cancelKey}}, aby anulować, lub {{.confirmKey}}, aby nadpisać.",
		FetchRemoteTooltip:                  "Pobierz aktualizacje z zdalnego repozytorium. Pobiera nowe commity i gałęzie bez scalania ich z lokalnymi gałęziami.",
		FetchingRemoteStatus:                "Pobieranie zdalnego",
		CheckoutCommit:                      "Przełącz commit",
		CheckoutCommitTooltip:               "Przełącz wybrany commit jako odłączoną HEAD.",
		SureCheckoutThisCommit:              "Czy na pewno chcesz przełączyć ten commit?",
		GitFlowOptions:                      "Pokaż opcje git-flow",
		NotAGitFlowBranch:                   "To nie wygląda na gałąź git flow",
		NewGitFlowBranchPrompt:              "Nowa nazwa {{.branchType}}:",

		IgnoreTracked:                         "Ignoruj śledzony plik",
		IgnoreTrackedPrompt:                   "Czy na pewno chcesz zignorować śledzony plik?",
		ExcludeTracked:                        "Wyklucz śledzony plik",
		ExcludeTrackedPrompt:                  "Czy na pewno chcesz wykluczyć śledzony plik?",
		ViewResetToUpstreamOptions:            "Pokaż opcje resetowania do upstream",
		NextScreenMode:                        "Następny tryb ekranu (normalny/półpełny/pełnoekranowy)",
		PrevScreenMode:                        "Poprzedni tryb ekranu",
		StartSearch:                           "Szukaj w bieżącym widoku po tekście",
		StartFilter:                           "Filtruj bieżący widok po tekście",
		Panel:                                 "Panel",
		KeybindingsLegend:                     "Legenda: `<c-b>` oznacza ctrl+b, `<a-b>` oznacza alt+b, `B` oznacza shift+b",
		RenameBranch:                          "Zmień nazwę gałęzi",
		BranchUpstreamOptionsTitle:            "Opcje upstream",
		ViewBranchUpstreamOptions:             "Pokaż opcje upstream",
		ViewBranchUpstreamOptionsTooltip:      "Pokaż opcje dotyczące upstream gałęzi, np. ustawianie/usuwanie upstream i resetowanie do upstream.",
		UpstreamNotSetError:                   "Wybrana gałąź nie ma upstream (lub upstream nie jest przechowywany lokalnie)",
		Upstream:                              "Upstream",
		UpstreamTooltip:                       "Pokaż opcje upstream dla wybranej gałęzi, np. ustawianie/usuwanie upstream i resetowanie do upstream.",
		NewBranchNamePrompt:                   "Wprowadź nową nazwę gałęzi dla gałęzi",
		RenameBranchWarning:                   "Ta gałąź śledzi zdalną. Ta akcja zmieni tylko lokalną nazwę gałęzi, nie nazwę zdalnej gałęzi. Kontynuować?",
		OpenKeybindingsMenu:                   "Otwórz menu przypisań klawiszy",
		ResetCherryPick:                       "Resetuj wybrane (cherry-picked) commity",
		NextTab:                               "Następna zakładka",
		PrevTab:                               "Poprzednia zakładka",
		CantUndoWhileRebasing:                 "Nie można cofnąć podczas rebasingu",
		CantRedoWhileRebasing:                 "Nie można ponowić podczas rebasingu",
		MustStashWarning:                      "Wyjęcie łatki do indeksu wymaga schowania i odschowania zmian. Jeśli coś pójdzie nie tak, będziesz mógł uzyskać dostęp do plików ze schowka. Kontynuować?",
		MustStashTitle:                        "Musisz schować",
		ConfirmationTitle:                     "Panel potwierdzenia",
		PrevPage:                              "Poprzednia strona",
		NextPage:                              "Następna strona",
		GotoTop:                               "Przewiń do góry",
		GotoBottom:                            "Przewiń do dołu",
		FilteringBy:                           "Filtrowanie przez",
		ResetInParentheses:                    "(Resetuj)",
		OpenFilteringMenu:                     "Pokaż opcje filtrowania",
		OpenFilteringMenuTooltip:              "Pokaż opcje filtrowania dziennika commitów, tak aby pokazywane były tylko commity pasujące do filtra.",
		FilterBy:                              "Filtruj przez",
		ExitFilterMode:                        "Zatrzymaj filtrowanie",
		FilterPathOption:                      "Wprowadź ścieżkę do filtrowania",
		FilterAuthorOption:                    "Wprowadź autora do filtrowania",
		EnterFileName:                         "Wprowadź ścieżkę:",
		EnterAuthor:                           "Wprowadź autora:",
		FilteringMenuTitle:                    "Filtrowanie",
		WillCancelExistingFilterTooltip:       "Uwaga: to anuluje istniejący filtr",
		MustExitFilterModeTitle:               "Polecenie niedostępne",
		MustExitFilterModePrompt:              "Polecenie niedostępne w trybie filtrowania po ścieżce. Wyjść z trybu filtrowania po ścieżce?",
		Diff:                                  "Różnice",
		EnterRefToDiff:                        "Wprowadź ref do różnic",
		EnterRefName:                          "Wprowadź ref:",
		ExitDiffMode:                          "Wyjdź z trybu różnic",
		DiffingMenuTitle:                      "Różnicowanie",
		SwapDiff:                              "Odwróć kierunek różnic",
		ViewDiffingOptions:                    "Pokaż opcje różnicowania",
		ViewDiffingOptionsTooltip:             "Pokaż opcje dotyczące różnicowania dwóch refów, np. różnicowanie względem wybranego refa, wprowadzanie refa do różnicowania i odwracanie kierunku różnic.",
		OpenCommandLogMenu:                    "Pokaż opcje dziennika poleceń",
		OpenCommandLogMenuTooltip:             "Pokaż opcje dla dziennika poleceń, np. pokazywanie/ukrywanie dziennika poleceń i skupienie na dzienniku poleceń.",
		ShowingGitDiff:                        "Pokazuje wynik dla:",
		CommitDiff:                            "Różnice commita",
		CopyCommitHashToClipboard:             "Kopiuj hash commita do schowka",
		CommitHash:                            "hash commita",
		CommitURL:                             "URL commita",
		CopyCommitMessageToClipboard:          "Kopiuj wiadomość commita do schowka",
		CommitMessage:                         "Wiadomość commita",
		CommitSubject:                         "Temat commita",
		CommitAuthor:                          "Autor commita",
		CopyCommitAttributeToClipboard:        "Kopiuj atrybut commita do schowka",
		CopyCommitAttributeToClipboardTooltip: "Kopiuj atrybut commita do schowka (np. hash, URL, różnice, wiadomość, autor).",
		CopyBranchNameToClipboard:             "Kopiuj nazwę gałęzi do schowka",
		CopyPathToClipboard:                   "Kopiuj ścieżkę do schowka",
		CopySelectedTextToClipboard:           "Kopiuj zaznaczony tekst do schowka",
		CommitPrefixPatternError:              "Błąd w wzorcu commitPrefix",
		NoFilesStagedTitle:                    "Brak plików przygotowanych",
		NoFilesStagedPrompt:                   "Nie przygotowałeś żadnych plików. Zatwierdzić wszystkie pliki?",
		BranchNotFoundTitle:                   "Gałąź nie znaleziona",
		BranchNotFoundPrompt:                  "Gałąź nie znaleziona. Utwórz nową gałąź o nazwie",
		BranchUnknown:                         "Gałąź nieznana",
		DiscardChangeTitle:                    "Odrzuć zmianę",
		DiscardChangePrompt:                   "Czy na pewno chcesz odrzucić tę zmianę (git reset)? Jest to nieodwracalne.\nAby wyłączyć to okno dialogowe, ustaw klucz konfiguracyjny 'gui.skipDiscardChangeWarning' na true",
		CreateNewBranchFromCommit:             "Utwórz nową gałąź z commita",
		BuildingPatch:                         "Tworzenie łatki",
		ViewCommits:                           "Pokaż commity",
		MinGitVersionError:                    "Wersja Gita musi być co najmniej 2.20 (tj. od 2018 roku). Proszę zaktualizować wersję Gita. Alternatywnie zgłoś problem na https://github.com/jesseduffield/lazygit/issues, aby lazygit był bardziej kompatybilny wstecz.",
		RunningCustomCommandStatus:            "Uruchamianie niestandardowego polecenia",
		SubmoduleStashAndReset:                "Schowaj niezatwierdzone zmiany submodułu i zaktualizuj",
		AndResetSubmodules:                    "I zresetuj submoduły",
		Enter:                                 "Wejdź",
		EnterSubmoduleTooltip:                 "Wejdź do submodułu. Po wejściu do submodułu możesz nacisnąć `{{.escape}}`, aby wrócić do repozytorium nadrzędnego.",
		CopySubmoduleNameToClipboard:          "Kopiuj nazwę submodułu do schowka",
		RemoveSubmodule:                       "Usuń submoduł",
		RemoveSubmodulePrompt:                 "Czy na pewno chcesz usunąć submoduł '%s' i odpowiadający mu katalog? Jest to nieodwracalne.",
		RemoveSubmoduleTooltip:                "Usuń wybrany submoduł i odpowiadający mu katalog.",
		ResettingSubmoduleStatus:              "Resetowanie submodułu",
		NewSubmoduleName:                      "Nowa nazwa submodułu:",
		NewSubmoduleUrl:                       "Nowy URL submodułu:",
		NewSubmodulePath:                      "Nowa ścieżka submodułu:",
		NewSubmodule:                          "Nowy submoduł",
		AddingSubmoduleStatus:                 "Dodawanie submodułu",
		UpdateSubmoduleUrl:                    "Zaktualizuj URL dla submodułu '%s'",
		UpdatingSubmoduleUrlStatus:            "Aktualizowanie URL",
		EditSubmoduleUrl:                      "Zaktualizuj URL submodułu",
		InitializingSubmoduleStatus:           "Inicjalizowanie submodułu",
		InitSubmoduleTooltip:                  "Zainicjuj wybrany submoduł, aby przygotować do pobrania. Prawdopodobnie chcesz to kontynuować, wywołując akcję 'update', aby pobrać submoduł.",
		Update:                                "Aktualizuj",
		Initialize:                            "Zainicjuj",
		SubmoduleUpdateTooltip:                "Aktualizuj wybrany submoduł.",
		UpdatingSubmoduleStatus:               "Aktualizowanie submodułu",
		BulkInitSubmodules:                    "Masowe inicjowanie submodułów",
		BulkUpdateSubmodules:                  "Masowa aktualizacja submodułów",
		BulkDeinitSubmodules:                  "Masowe wyłączanie submodułów",
		ViewBulkSubmoduleOptions:              "Pokaż opcje masowych operacji na submodułach",
		BulkSubmoduleOptions:                  "Opcje masowych operacji na submodułach",
		RunningCommand:                        "Uruchamianie polecenia",
		SubCommitsTitle:                       "Sub-commity",
		SubmodulesTitle:                       "Submoduły",
		NavigationTitle:                       "Nawigacja panelu listy",
		SuggestionsCheatsheetTitle:            "Podpowiedzi",
		SuggestionsTitle:                      "Podpowiedzi (naciśnij %s, aby skupić)",
		ExtrasTitle:                           "Dziennik poleceń",
		PushingTagStatus:                      "Wysyłanie tagu",
		PullRequestURLCopiedToClipboard:       "URL żądania ściągnięcia skopiowany do schowka",
		CommitDiffCopiedToClipboard:           "Różnice commita skopiowane do schowka",
		CommitURLCopiedToClipboard:            "URL commita skopiowany do schowka",
		CommitMessageCopiedToClipboard:        "Wiadomość commita skopiowana do schowka",
		CommitSubjectCopiedToClipboard:        "Temat commita skopiowany do schowka",
		CommitAuthorCopiedToClipboard:         "Autor commita skopiowany do schowka",
		PatchCopiedToClipboard:                "Łatka skopiowana do schowka",
		CopiedToClipboard:                     "skopiowane do schowka",
		ErrCannotEditDirectory:                "Nie można edytować katalogu: można edytować tylko pojedyncze pliki",
		ErrStageDirWithInlineMergeConflicts:   "Nie można przygotować/odprzygotować katalogu zawierającego pliki z konfliktami scalania w linii. Proszę najpierw rozwiązać konflikty scalania",
		ErrRepositoryMovedOrDeleted:           "Nie można znaleźć repozytorium. Mogło zostać przeniesione lub usunięte ¯\\_(ツ)_/¯",
		CommandLog:                            "Dziennik poleceń",
		ErrWorktreeMovedOrRemoved:             "Nie można znaleźć drzewa roboczego. Mogło zostać przeniesione lub usunięte ¯\\_(ツ)_/¯",
		ToggleShowCommandLog:                  "Przełącz pokazywanie/ukrywanie dziennika poleceń",
		FocusCommandLog:                       "Skup na dzienniku poleceń",
		CommandLogHeader:                      "Możesz ukryć/skupić się na tym panelu naciskając '%s'\n",
		RandomTip:                             "Losowa porada",
		SelectParentCommitForMerge:            "Wybierz nadrzędny commit do scalenia",
		ToggleWhitespaceInDiffView:            "Przełącz białe znaki",
		ToggleWhitespaceInDiffViewTooltip:     "Przełącz czy zmiany białych znaków są pokazywane w widoku różnic.",
		IgnoreWhitespaceDiffViewSubTitle:      "(ignorując białe znaki)",
		IgnoreWhitespaceNotSupportedHere:      "Ignorowanie białych znaków nie jest wspierane w tym widoku",
		IncreaseContextInDiffView:             "Zwiększ rozmiar kontekstu w widoku różnic",
		IncreaseContextInDiffViewTooltip:      "Zwiększ ilość kontekstu pokazywanego wokół zmian w widoku różnic.",
		DecreaseContextInDiffView:             "Zmniejsz rozmiar kontekstu w widoku różnic",
		DecreaseContextInDiffViewTooltip:      "Zmniejsz ilość kontekstu pokazywanego wokół zmian w widoku różnic.",
		DiffContextSizeChanged:                "Zmieniono rozmiar kontekstu różnic na %d",
		CreatePullRequestOptions:              "Zobacz opcje tworzenia pull requesta",
		DefaultBranch:                         "Domyślny branch",
		SelectBranch:                          "Wybierz branch",
		SelectConfigFile:                      "Wybierz plik konfiguracyjny",
		NoConfigFileFoundErr:                  "Nie znaleziono pliku konfiguracyjnego",
		LoadingFileSuggestions:                "Ładowanie sugestii plików",
		LoadingCommits:                        "Ładowanie commitów",
		MustSpecifyOriginError:                "Musisz określić zdalne repozytorium jeśli określasz branch",
		GitOutput:                             "Wyjście Gita:",
		GitCommandFailed:                      "Polecenie Gita nie powiodło się. Sprawdź logi poleceń po szczegóły (otwórz za pomocą %s)",
		AbortTitle:                            "Przerwij %s",
		AbortPrompt:                           "Czy na pewno chcesz przerwać bieżące %s?",
		OpenLogMenu:                           "Zobacz opcje logów",
		OpenLogMenuTooltip:                    "Zobacz opcje dla logów commitów, np. zmiana kolejności sortowania, ukrywanie grafu gita, pokazywanie całego grafu gita.",
		LogMenuTitle:                          "Opcje logów commitów",
		ToggleShowGitGraphAll:                 "Przełącz pokazanie całego grafu gita (dodaj flagę `--all` do `git log`)",
		ShowGitGraph:                          "Pokaż graf gita",
		SortOrder:                             "Kolejność sortowania",
		SortAlphabetical:                      "Alfabetycznie",
		SortByDate:                            "Data",
		SortByRecency:                         "Najnowsze",
		SortBasedOnReflog:                     "(na podstawie reflog)",
		SortCommits:                           "Kolejność sortowania commitów",
		CantChangeContextSizeError:            "Nie można zmienić rozmiaru kontekstu będąc w trybie budowania patcha, ponieważ byliśmy zbyt leniwi, aby to wspierać przy wydaniu funkcji. Jeśli naprawdę tego chcesz, daj nam znać!",
		OpenCommitInBrowser:                   "Otwórz commit w przeglądarce",
		ViewBisectOptions:                     "Zobacz opcje bisect",
		ConfirmRevertCommit:                   "Czy na pewno chcesz cofnąć {{.selectedCommit}}?",
		RewordInEditorTitle:                   "Przeformułuj w edytorze",
		RewordInEditorPrompt:                  "Czy na pewno chcesz przeformułować ten commit w swoim edytorze?",
		HardResetAutostashPrompt:              "Czy na pewno chcesz zrobić twardy reset do '%s'? Auto-stash zostanie wykonany jeśli będzie potrzebny.",
		CheckoutPrompt:                        "Czy na pewno chcesz przełączyć się na '%s'?",
		UpstreamGone:                          "(upstream zniknął)",
		NukeDescription:                       "Jeśli chcesz, aby wszystkie zmiany w drzewie pracy zniknęły, to jest sposób na to. Jeśli są brudne zmiany w submodule, to zostaną one zapisane w submodule(s).",
		DiscardStagedChangesDescription:       "To stworzy nowy wpis stash zawierający tylko pliki w stanie staged, a następnie go usunie, tak że drzewo pracy zostanie tylko ze zmianami niezatwierdzonymi",
		EmptyOutput:                           "<Puste wyjście>",
		Patch:                                 "Patch",
		CustomPatch:                           "Niestandardowy patch",
		CommitsCopied:                         "commitów skopiowanych", // lowercase because it's used in a sentence
		CommitCopied:                          "commit skopiowany",     // lowercase because it's used in a sentence
		ResetPatch:                            "Resetuj patch",
		ResetPatchTooltip:                     "Wyczyść bieżący patch.",
		ApplyPatch:                            "Zastosuj patch",
		ApplyPatchTooltip:                     "Zastosuj bieżący patch do drzewa pracy.",
		ApplyPatchInReverse:                   "Zastosuj patch w odwrotności",
		ApplyPatchInReverseTooltip:            "Zastosuj bieżący patch w odwrotności do drzewa pracy.",
		RemovePatchFromOriginalCommit:         "Usuń patch z oryginalnego commita (%s)",
		RemovePatchFromOriginalCommitTooltip:  "Usuń bieżący patch z jego commita. Jest to osiągane przez rozpoczęcie interaktywnego rebase na commicie, zastosowanie patcha w odwrotności, a następnie kontynuowanie rebase. Jeśli późniejsze commity zależą od patcha, możesz musieć rozwiązać konflikty.",
		MovePatchOutIntoIndex:                 "Przenieś patch do indeksu",
		MovePatchOutIntoIndexTooltip:          "Przenieś patch z jego commita do indeksu. Jest to osiągane przez rozpoczęcie interaktywnego rebase na commicie, zastosowanie patcha w odwrotności, kontynuowanie rebase do zakończenia, a następnie zastosowanie patcha do indeksu. Jeśli późniejsze commity zależą od patcha, możesz musieć rozwiązać konflikty.",
		MovePatchIntoNewCommit:                "Przenieś patch do nowego commita",
		MovePatchIntoNewCommitTooltip:         "Przenieś patch z jego commita do nowego commita na górze oryginalnego commita. Jest to osiągane przez rozpoczęcie interaktywnego rebase na oryginalnym commicie, zastosowanie patcha w odwrotności, następnie zastosowanie patcha do indeksu i zatwierdzenie go jako nowy commit, przed kontynuowaniem rebase do zakończenia. Jeśli późniejsze commity zależą od patcha, możesz musieć rozwiązać konflikty.",
		MovePatchToSelectedCommit:             "Przenieś patch do wybranego commita (%s)",
		MovePatchToSelectedCommitTooltip:      "Przenieś patch z jego oryginalnego commita do wybranego commita. Jest to osiągane przez rozpoczęcie interaktywnego rebase na oryginalnym commicie, zastosowanie patcha w odwrotności, następnie kontynuowanie rebase do wybranego commita, przed zastosowaniem patcha do przodu i zmodyfikowaniem wybranego commita. Rebase jest następnie kontynuowany do zakończenia. Jeśli commity między źródłem a miejscem docelowym zależą od patcha, możesz musieć rozwiązać konflikty.",
		CopyPatchToClipboard:                  "Kopiuj patch do schowka",
		NoMatchesFor:                          "Brak dopasowań dla '%s' %s",
		ExitSearchMode:                        "%s: Wyjdź z trybu wyszukiwania",
		ExitTextFilterMode:                    "%s: Wyjdź z trybu filtrowania",
		MatchesFor:                            "dopasowania dla '%s' (%d z %d) %s", // lowercase because it's after other text
		SearchKeybindings:                     "%s: Następne dopasowanie, %s: Poprzednie dopasowanie, %s: Wyjdź z trybu wyszukiwania",
		SearchPrefix:                          "Szukaj: ",
		FilterPrefix:                          "Filtruj: ",
		WorktreesTitle:                        "Drzewa pracy",
		WorktreeTitle:                         "Drzewo pracy",
		Switch:                                "Przełącz",
		SwitchToWorktree:                      "Przełącz do drzewa pracy",
		SwitchToWorktreeTooltip:               "Przełącz do wybranego drzewa pracy.",
		AlreadyCheckedOutByWorktree:           "Ten branch jest już używany przez drzewo pracy {{.worktreeName}}. Czy chcesz przełączyć się do tego drzewa pracy?",
		BranchCheckedOutByWorktree:            "Branch {{.branchName}} jest używany przez drzewo pracy {{.worktreeName}}",
		DetachWorktreeTooltip:                 "To uruchomi `git checkout --detach` na drzewie pracy, tak że przestanie ono używać brancha, ale drzewo pracy drzewa pracy zostanie nietknięte.",
		Switching:                             "Przełączanie",
		RemoveWorktree:                        "Usuń drzewo pracy",
		RemoveWorktreeTitle:                   "Usuń drzewo pracy",
		RemoveWorktreePrompt:                  "Czy na pewno chcesz usunąć drzewo pracy '{{.worktreeName}}'?",
		ForceRemoveWorktreePrompt:             "'{{.worktreeName}}' zawiera zmodyfikowane lub nieśledzone pliki (szczerze mówiąc, może zawierać oba). Czy na pewno chcesz to usunąć?",
		RemovingWorktree:                      "Usuwanie drzewa pracy",
		DetachWorktree:                        "Odłącz drzewo pracy",
		DetachingWorktree:                     "Odłączanie drzewa pracy",
		AddingWorktree:                        "Dodawanie drzewa pracy",
		CantDeleteCurrentWorktree:             "Nie możesz usunąć bieżącego drzewa pracy!",
		AlreadyInWorktree:                     "Jesteś już w wybranym drzewie pracy",
		CantDeleteMainWorktree:                "Nie możesz usunąć głównego drzewa pracy!",
		NoWorktreesThisRepo:                   "Brak drzew pracy",
		MissingWorktree:                       "(brakujące)",
		MainWorktree:                          "(główne)",
		NewWorktree:                           "Nowe drzewo pracy",
		NewWorktreePath:                       "Nowa ścieżka drzewa pracy",
		NewWorktreeBase:                       "Nowa bazowa ref drzewa pracy",
		RemoveWorktreeTooltip:                 "Usuń wybrane drzewo pracy. To usunie zarówno katalog drzewa pracy, jak i metadane o drzewie pracy w katalogu .git.",
		BranchNameCannotBeBlank:               "Nazwa brancha nie może być pusta",
		NewBranchName:                         "Nowa nazwa brancha",
		NewBranchNameLeaveBlank:               "Nowa nazwa brancha (pozostaw puste, aby przełączyć {{.default}})",
		ViewWorktreeOptions:                   "Zobacz opcje drzewa pracy",
		CreateWorktreeFrom:                    "Utwórz drzewo pracy z {{.ref}}",
		CreateWorktreeFromDetached:            "Utwórz drzewo pracy z {{.ref}} (odłączone)",
		LcWorktree:                            "drzewo pracy",
		ChangingDirectoryTo:                   "Zmiana katalogu na {{.path}}",
		Name:                                  "Nazwa",
		Branch:                                "Branch",
		Path:                                  "Ścieżka",
		MarkedBaseCommitStatus:                "Oznaczono bazowy commit dla rebase",
		MarkAsBaseCommit:                      "Oznacz jako bazowy commit dla rebase",
		MarkAsBaseCommitTooltip:               "Wybierz bazowy commit dla następnego rebase. Kiedy robisz rebase na branch, tylko commity powyżej bazowego commita zostaną przeniesione. Używa to polecenia `git rebase --onto`.",
		MarkedCommitMarker:                    "↑↑↑ Rebase rozpocznie się stąd ↑↑↑",
		PleaseGoToURL:                         "Proszę przejdź do {{.url}}",
		DisabledMenuItemPrefix:                "Wyłączone: ",
		NoCopiedCommits:                       "Brak skopiowanych commitów",
		QuickStartInteractiveRebase:           "Rozpocznij interaktywny rebase",
		QuickStartInteractiveRebaseTooltip:    "Rozpocznij interaktywny rebase dla commitów na twoim branchu. To będzie zawierać wszystkie commity od HEAD do pierwszego commita scalenia lub commita głównego brancha.\nJeśli chcesz zamiast tego rozpocząć interaktywny rebase od wybranego commita, naciśnij `{{.editKey}}`.",
		CannotQuickStartInteractiveRebase:     "Nie można rozpocząć interaktywnego rebase: commit HEAD jest commit'em scalenia lub jest obecny na głównym branchu, więc nie ma odpowiedniego bazowego commita, od którego można by zacząć rebase. Możesz rozpocząć interaktywny rebase z konkretnego commita, wybierając commit i naciskając `{{.editKey}}`.",
		RangeSelectUp:                         "Zaznacz zakres w górę",
		RangeSelectDown:                       "Zaznacz zakres w dół",
		RangeSelectNotSupported:               "Akcja nie wspiera zaznaczania zakresu, proszę wybrać pojedynczy element",
		NoItemSelected:                        "Nie wybrano elementu",
		SelectedItemIsNotABranch:              "Wybrany element nie jest branch'em",
		SelectedItemDoesNotHaveFiles:          "Wybrany element nie ma plików do wyświetlenia",
		RangeSelectNotSupportedForSubmodules:  "Zaznaczanie zakresu nie jest wspierane dla submodułów",
		OldCherryPickKeyWarning:               "Klawisz 'c' nie jest już domyślnym klawiszem do kopiowania commitów do cherry pick. Proszę użyj `{{.copy}}` zamiast tego (i `{{.paste}}` aby wkleić). Powodem tej zmiany jest to, że klawisz 'v' do wybierania zakresu linii podczas stagingu jest teraz używany również do wybierania zakresu linii w każdym widoku listy, co oznacza, że musieliśmy znaleźć nowy klawisz do wklejania commitów, i jeśli zamierzamy teraz używać `{{.paste}}` do wklejania commitów, możemy równie dobrze użyć `{{.copy}}` do ich kopiowania. Jeśli chcesz skonfigurować klawisze, aby uzyskać stare zachowanie, ustaw następujące w swojej konfiguracji:\n\nkeybinding:\n  universal:\n    toggleRangeSelect: <coś innego niż v>\n  commits:\n    cherryPickCopy: 'c'\n    pasteCommits: 'v'",

		Actions: Actions{
			CheckoutCommit:                 "Przełącz commit",
			CheckoutTag:                    "Przełącz tag",
			CheckoutBranch:                 "Przełącz gałąź",
			ForceCheckoutBranch:            "Wymuś przełączenie gałęzi",
			DeleteLocalBranch:              "Usuń lokalną gałąź",
			DeleteBranch:                   "Usuń gałąź",
			Merge:                          "Scal",
			RebaseBranch:                   "Rebazuj gałąź",
			RenameBranch:                   "Zmień nazwę gałęzi",
			CreateBranch:                   "Utwórz gałąź",
			CherryPick:                     "(Cherry-pick) wklej commity",
			CheckoutFile:                   "Przełącz plik",
			DiscardOldFileChange:           "Odrzuć starą zmianę w pliku",
			SquashCommitDown:               "Scal commit w dół",
			FixupCommit:                    "Popraw commit",
			RewordCommit:                   "Zmień treść commita",
			DropCommit:                     "Odrzuć commit",
			EditCommit:                     "Edytuj commit",
			AmendCommit:                    "Popraw commit",
			ResetCommitAuthor:              "Zresetuj autora commita",
			SetCommitAuthor:                "Ustaw autora commita",
			RevertCommit:                   "Cofnij commit",
			CreateFixupCommit:              "Utwórz commit poprawkowy",
			SquashAllAboveFixupCommits:     "Scal wszystkie powyższe commity poprawkowe",
			CreateLightweightTag:           "Utwórz lekki tag",
			CreateAnnotatedTag:             "Utwórz opisowy tag",
			CopyCommitMessageToClipboard:   "Kopiuj wiadomość commita do schowka",
			CopyCommitSubjectToClipboard:   "Kopiuj temat commita do schowka",
			CopyCommitDiffToClipboard:      "Kopiuj różnice commita do schowka",
			CopyCommitHashToClipboard:      "Kopiuj hash commita do schowka",
			CopyCommitURLToClipboard:       "Kopiuj URL commita do schowka",
			CopyCommitAuthorToClipboard:    "Kopiuj autora commita do schowka",
			CopyCommitAttributeToClipboard: "Kopiuj do schowka",
			CopyPatchToClipboard:           "Kopiuj łatkę do schowka",
			MoveCommitUp:                   "Przenieś commit w górę",
			MoveCommitDown:                 "Przenieś commit w dół",
			CustomCommand:                  "Polecenie niestandardowe",

			// TODO: remove
			DiscardAllChangesInDirectory:      "Odrzuć wszystkie zmiany w katalogu",
			DiscardUnstagedChangesInDirectory: "Odrzuć niezatwierdzone zmiany w katalogu",

			DiscardAllChangesInFile:         "Odrzuć wszystkie zmiany w wybranych plikach",
			DiscardAllUnstagedChangesInFile: "Odrzuć wszystkie niezatwierdzone zmiany w wybranych plikach",
			StageFile:                       "Dodaj plik do indeksu",
			StageResolvedFiles:              "Dodaj pliki, których konflikty scalania zostały rozwiązane",
			UnstageFile:                     "Usuń plik z indeksu",
			UnstageAllFiles:                 "Usuń wszystkie pliki z indeksu",
			StageAllFiles:                   "Dodaj wszystkie pliki do indeksu",
			IgnoreExcludeFile:               "Ignoruj lub wyklucz plik",
			IgnoreFileErr:                   "Nie można zignorować .gitignore",
			ExcludeFile:                     "Wyklucz plik",
			ExcludeGitIgnoreErr:             "Nie można wykluczyć .gitignore",
			Commit:                          "Commituj",
			EditFile:                        "Edytuj plik",
			Push:                            "Wypchnij",
			Pull:                            "Pociągnij",
			OpenFile:                        "Otwórz plik",
			StashAllChanges:                 "Schowaj wszystkie zmiany",
			StashAllChangesKeepIndex:        "Schowaj wszystkie zmiany i zachowaj indeks",
			StashStagedChanges:              "Schowaj zatwierdzone zmiany",
			StashUnstagedChanges:            "Schowaj niezatwierdzone zmiany",
			StashIncludeUntrackedChanges:    "Schowaj wszystkie zmiany włącznie z nieśledzonymi plikami",
			GitFlowFinish:                   "git flow zakończ",
			GitFlowStart:                    "git flow rozpocznij",
			CopyToClipboard:                 "Kopiuj do schowka",
			CopySelectedTextToClipboard:     "Kopiuj zaznaczony tekst do schowka",
			RemovePatchFromCommit:           "Usuń łatkę z commita",
			MovePatchToSelectedCommit:       "Przenieś łatkę do wybranego commita",
			MovePatchIntoIndex:              "Przenieś łatkę do indeksu",
			MovePatchIntoNewCommit:          "Przenieś łatkę do nowego commita",
			DeleteRemoteBranch:              "Usuń zdalną gałąź",
			SetBranchUpstream:               "Ustaw gałąź nadrzędną",
			AddRemote:                       "Dodaj zdalne",
			RemoveRemote:                    "Usuń zdalne",
			UpdateRemote:                    "Aktualizuj zdalne",
			ApplyPatch:                      "Zastosuj łatkę",
			Stash:                           "Schowaj",
			RenameStash:                     "Zmień nazwę schowka",
			RemoveSubmodule:                 "Usuń podmoduł",
			ResetSubmodule:                  "Resetuj podmoduł",
			AddSubmodule:                    "Dodaj podmoduł",
			UpdateSubmoduleUrl:              "Aktualizuj URL podmodułu",
			InitialiseSubmodule:             "Zainicjuj podmoduł",
			BulkInitialiseSubmodules:        "Masowo zainicjuj podmoduły",
			BulkUpdateSubmodules:            "Masowo aktualizuj podmoduły",
			BulkDeinitialiseSubmodules:      "Masowo deinicjuj podmoduły",
			UpdateSubmodule:                 "Aktualizuj podmoduł",
			DeleteLocalTag:                  "Usuń lokalny tag",
			DeleteRemoteTag:                 "Usuń zdalny tag",
			PushTag:                         "Wypchnij tag",
			NukeWorkingTree:                 "Zniszcz drzewo robocze",
			DiscardUnstagedFileChanges:      "Odrzuć niezatwierdzone zmiany w pliku",
			RemoveUntrackedFiles:            "Usuń nieśledzone pliki",
			RemoveStagedFiles:               "Usuń zatwierdzone pliki",
			SoftReset:                       "Miękki reset",
			MixedReset:                      "Mieszany reset",
			HardReset:                       "Twardy reset",
			FastForwardBranch:               "Szybkie przewijanie gałęzi",
			Undo:                            "Cofnij",
			Redo:                            "Ponów",
			CopyPullRequestURL:              "Kopiuj URL żądania ściągnięcia",
			OpenDiffTool:                    "Otwórz narzędzie różnic",
			OpenMergeTool:                   "Otwórz narzędzie scalania",
			OpenCommitInBrowser:             "Otwórz commit w przeglądarce",
			OpenPullRequest:                 "Otwórz żądanie ściągnięcia w przeglądarce",
			StartBisect:                     "Rozpocznij bisect",
			ResetBisect:                     "Resetuj bisect",
			BisectSkip:                      "Pomiń bisect",
			BisectMark:                      "Oznacz bisect",
			RemoveWorktree:                  "Usuń drzewo robocze",
			AddWorktree:                     "Dodaj drzewo robocze",
		},
		Bisect: Bisect{
			Mark:                        "Oznacz bieżący commit (%s) jako %s",
			MarkStart:                   "Oznacz %s jako %s (rozpocznij bisect)",
			SkipCurrent:                 "Pomiń bieżący commit (%s)",
			SkipSelected:                "Pomiń wybrany commit (%s)",
			ResetTitle:                  "Resetuj 'git bisect'",
			ResetPrompt:                 "Czy na pewno chcesz zresetować 'git bisect'?",
			ResetOption:                 "Resetuj bisect",
			ChooseTerms:                 "Wybierz terminy bisect",
			OldTermPrompt:               "Termin dla starego/dobrego commita:",
			NewTermPrompt:               "Termin dla nowego/złego commita:",
			BisectMenuTitle:             "Bisect",
			CompleteTitle:               "Bisect zakończony",
			CompletePrompt:              "Bisect zakończony! Następujący commit wprowadził zmianę:\n\n%s\n\nCzy chcesz teraz zresetować 'git bisect'?",
			CompletePromptIndeterminate: "Bisect zakończony! Niektóre commity zostały pominięte, więc którykolwiek z następujących commitów mógł wprowadzić zmianę:\n\n%s\n\nCzy chcesz teraz zresetować 'git bisect'?",
			Bisecting:                   "Bisectowanie",
		},
		Log: Log{
			EditRebase:               "Rozpoczynanie interaktywnego rebazowania od '{{.ref}}'",
			MoveCommitUp:             "Przenoszenie TODO w dół: '{{.shortHash}}'",
			MoveCommitDown:           "Przenoszenie TODO w dół: '{{.shortHash}}'",
			CherryPickCommits:        "Cherry-picking commitów:\n'{{.commitLines}}'",
			HandleUndo:               "Cofanie ostatniego rozwiązania konfliktu",
			HandleMidRebaseCommand:   "Aktualizacja akcji rebazowania commita {{.shortHash}} na '{{.action}}'",
			RemoveFile:               "Usuwanie ścieżki '{{.path}}'",
			CopyToClipboard:          "Kopiowanie '{{.str}}' do schowka",
			Remove:                   "Usuwanie '{{.filename}}'",
			CreateFileWithContent:    "Tworzenie pliku '{{.path}}'",
			AppendingLineToFile:      "Dodawanie '{{.line}}' do pliku '{{.filename}}'",
			EditRebaseFromBaseCommit: "Rozpoczynanie interaktywnego rebazowania od '{{.baseCommit}}' na '{{.targetBranchName}}",
		},
		BreakingChangesTitle: "Zmiany przełomowe",
		BreakingChangesMessage: `Aktualizujesz do nowej wersji lazygit, która zawiera zmiany przełomowe. Proszę przejrzeć poniższe notatki i zaktualizować swoją konfigurację, jeśli jest to konieczne.
Aby uzyskać więcej informacji, zobacz pełne notatki do wydania na <https://github.com/jesseduffield/lazygit/releases>.`,
		BreakingChangesByVersion: map[string]string{
			"0.41.0": `- Gdy naciśniesz 'g', aby wywołać menu resetu git, opcja 'mixed' jest teraz pierwsza i domyślna, a nie 'soft'. Jest to dlatego, że 'mixed' jest najczęściej używaną opcją.
- Panel wiadomości commita teraz domyślnie zawija tekst (tj. dodaje znaki nowej linii, gdy osiągniesz margines). Możesz dostosować konfigurację w następujący sposób:

git:
  commit:
    autoWrapCommitMessage: true
    autoWrapWidth: 72

- Klawisz 'v' był już używany w widoku staging do rozpoczęcia zaznaczania zakresu, ale teraz możesz go użyć do rozpoczęcia zaznaczania zakresu w dowolnym widoku. Niestety koliduje to z klawiszem 'v' dla wklejania commitów (cherry-pick), więc teraz wklejanie commitów odbywa się za pomocą 'shift+V', a dla spójności kopiowanie commitów odbywa się teraz za pomocą 'shift+C' zamiast 'c'. Zauważ, że klawisz 'v' to tylko jeden ze sposobów na rozpoczęcie zaznaczania zakresu: możesz zamiast tego użyć shift+góra/dół. Więc jeśli chcesz skonfigurować klawisze cherry-pick, aby uzyskać stare zachowanie, ustaw następujące w swojej konfiguracji:

keybinding:
  universal:
      toggleRangeSelect: <coś innego niż v>
    commits:
      cherryPickCopy: 'c'
      pasteCommits: 'v'

- Sciskanie fixupów za pomocą 'shift-S' teraz wywołuje menu, z domyślną opcją sciskania wszystkich commitów fixup w gałęzi. Oryginalne zachowanie sciskania tylko commitów fixup powyżej wybranego commita jest nadal dostępne jako druga opcja w tym menu.
- Statusy ładowania push/pull/fetch są teraz wyświetlane przy gałęzi, a nie w popupie. Pozwala to np. na równoczesne fetchowanie wielu gałęzi i widzenie statusu dla każdej gałęzi.
- Graf logu git w widoku commitów jest teraz zawsze wyświetlany domyślnie (wcześniej był wyświetlany tylko, gdy widok był maksymalizowany). Jeśli uznasz to za zbyt hałaśliwe, możesz to zmienić za pomocą ctrl+L -> 'Pokaż graf git' -> 'gdy maksymalizowany'
	  `,
		},
	}
}
