#!/bin/bash
# Copyright 2020 The Kubernetes Authors.
# SPDX-License-Identifier: Apache-2.0

set -e

if ! command -v jq &> /dev/null ; then
    echo Please install jq
    echo on ubuntu: sudo apt-get install jq
    exit 1
fi

OPEN_API_INFO=$(\
    jq -r '.info' $1  | \
    sed 's/[\" *]//g' | \
    tr -d '\n' )

cat <<EOF >kubernetesapi/openapiinfo.go
// Copyright 2020 The Kubernetes Authors.
// SPDX-License-Identifier: Apache-2.0

// Code generated by $0; DO NOT EDIT.

package kubernetesapi

const Info = "$OPEN_API_INFO"
EOF
