package graph

// This file will be automatically regenerated based on the schema, any resolver implementations
// will be copied through when generating and any unknown code will be moved to the end.
// Code generated by github.com/99designs/gqlgen version v0.17.73

import (
	"context"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/99designs/gqlgen/graphql/handler/transport"
	"github.com/kubetail-org/kubetail/modules/cluster-api/graph/model"
	"github.com/kubetail-org/kubetail/modules/shared/clusteragentpb"
	gqlerrors "github.com/kubetail-org/kubetail/modules/shared/graphql/errors"
	"github.com/kubetail-org/kubetail/modules/shared/k8shelpers"
	"github.com/kubetail-org/kubetail/modules/shared/logs"
	zlog "github.com/rs/zerolog/log"
	"github.com/vektah/gqlparser/v2/gqlerror"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/utils/ptr"
)

// LogMetadataList is the resolver for the logMetadataList field.
func (r *queryResolver) LogMetadataList(ctx context.Context, namespace *string) (*clusteragentpb.LogMetadataList, error) {
	// Deref namespace
	nsList, err := k8shelpers.DerefNamespaceToList(r.allowedNamespaces, namespace, metav1.NamespaceDefault)
	if err != nil {
		return nil, err
	}

	outList := &clusteragentpb.LogMetadataList{}
	req := &clusteragentpb.LogMetadataListRequest{Namespaces: nsList}

	// Execute
	var mu sync.Mutex
	errs := gqlerror.List{}

	r.grpcDispatcher.Fanout(ctx, func(ctx context.Context, conn *grpc.ClientConn) {
		// init client
		c := clusteragentpb.NewLogMetadataServiceClient(conn)

		// execute
		resp, err := c.List(ctx, req)

		// aquire lock
		mu.Lock()
		defer mu.Unlock()

		// update vars
		if err != nil {
			errs = append(errs, NewGrpcError(conn, err))
		} else {
			// update items
			outList.Items = append(outList.Items, resp.GetItems()...)
		}
	})

	// throw error if response is missing
	if len(errs) != 0 {
		return nil, errs
	}

	return outList, nil
}

// LogRecordsFetch is the resolver for the logRecordsFetch field.
func (r *queryResolver) LogRecordsFetch(ctx context.Context, kubeContext *string, sources []string, mode *model.LogRecordsQueryMode, since *string, until *string, after *string, before *string, grep *string, sourceFilter *model.LogSourceFilter, limit *int) (*model.LogRecordsQueryResponse, error) {
	// Get bearer token
	token, err := r.getBearerTokenRequired(ctx)
	if err != nil {
		return nil, gqlerrors.ErrUnauthenticated
	}

	// Parse time args
	sinceTime, err := parseTimeArg(ptr.Deref(since, ""))
	if err != nil {
		return nil, err
	}

	untilTime, err := parseTimeArg(ptr.Deref(until, ""))
	if err != nil {
		return nil, err
	}

	afterTime, err := parseTimeArg(ptr.Deref(after, ""))
	if err != nil {
		return nil, err
	}

	beforeTime, err := parseTimeArg(ptr.Deref(before, ""))
	if err != nil {
		return nil, err
	}

	// Handle after/before
	if !afterTime.IsZero() {
		sinceTime = afterTime.Add(1 * time.Nanosecond)
	}

	if !beforeTime.IsZero() {
		untilTime = beforeTime.Add(-1 * time.Nanosecond)
	}

	// Init stream
	sourceFilterVal := ptr.Deref(sourceFilter, model.LogSourceFilter{})

	streamOpts := []logs.Option{
		logs.WithBearerToken(token),
		logs.WithAllowedNamespaces(r.allowedNamespaces),
		logs.WithLogFetcher(logs.NewAgentLogFetcher(r.grpcDispatcher)),
		logs.WithSince(sinceTime),
		logs.WithUntil(untilTime),
		logs.WithGrep(ptr.Deref(grep, "")),
		logs.WithRegions(sourceFilterVal.Region),
		logs.WithZones(sourceFilterVal.Zone),
		logs.WithOSes(sourceFilterVal.Os),
		logs.WithArches(sourceFilterVal.Arch),
		logs.WithNodes(sourceFilterVal.Node),
		logs.WithContainers(sourceFilterVal.Container),
	}

	limitVal := int64(ptr.Deref(limit, 100))
	switch ptr.Deref(mode, model.LogRecordsQueryModeTail) {
	case model.LogRecordsQueryModeHead:
		streamOpts = append(streamOpts, logs.WithHead(limitVal))
	case model.LogRecordsQueryModeTail:
		streamOpts = append(streamOpts, logs.WithTail(limitVal))
	default:
		return nil, fmt.Errorf("not implemented %s", mode)
	}

	stream, err := logs.NewStream(ctx, r.cm, sources, streamOpts...)
	if err != nil {
		return nil, err
	}
	defer stream.Close()

	// Start stream
	if err := stream.Start(ctx); err != nil {
		return nil, err
	}

	// Write out records
	out := &model.LogRecordsQueryResponse{Records: []*logs.LogRecord{}}
	for record := range stream.Records() {
		out.Records = append(out.Records, &record)
		out.NextCursor = ptr.To(record.Timestamp.Format(time.RFC3339Nano))
	}

	if ctx.Err() != nil {
		return nil, ctx.Err()
	}

	if stream.Err() != nil {
		return nil, stream.Err()
	}

	return out, nil
}

// LogMetadataWatch is the resolver for the logMetadataWatch field.
func (r *subscriptionResolver) LogMetadataWatch(ctx context.Context, namespace *string) (<-chan *clusteragentpb.LogMetadataWatchEvent, error) {
	// Deref namespaces
	nsList, err := k8shelpers.DerefNamespaceToList(r.allowedNamespaces, namespace, metav1.NamespaceDefault)
	if err != nil {
		return nil, err
	}

	outCh := make(chan *clusteragentpb.LogMetadataWatchEvent)

	sub, err := r.grpcDispatcher.FanoutSubscribe(ctx, func(ctx context.Context, conn *grpc.ClientConn) {
		// init client
		c := clusteragentpb.NewLogMetadataServiceClient(conn)

		// init request
		req := &clusteragentpb.LogMetadataWatchRequest{Namespaces: nsList}

		// execute
		stream, err := c.Watch(ctx, req)
		if err != nil {
			return
		}

		for {
			ev, err := stream.Recv()

			// handle errors
			if err != nil {
				// ignore normal errors
				if err == io.EOF {
					break
				} else if err == context.Canceled {
					break
				}

				// check for grpc status error
				if s, ok := status.FromError(err); ok {
					switch s.Code() {
					case codes.Unavailable:
						// server down (probably restarting)
					case codes.Canceled:
						// connection closed client-side
					default:
						zlog.Error().Caller().Err(err).Msgf("Unexpected gRPC error: %v\n", s.Message())
					}
					break
				}

				zlog.Error().Caller().Err(err).Msg("Unexpected error")

				break
			}

			// forward event
			outCh <- ev
		}
	})
	if err != nil {
		return nil, err
	}

	// Unsubscribe on context close
	go func() {
		<-ctx.Done()
		sub.Unsubscribe()
	}()

	return outCh, nil
}

// LogRecordsFollow is the resolver for the logRecordsFollow field.
func (r *subscriptionResolver) LogRecordsFollow(ctx context.Context, kubeContext *string, sources []string, since *string, after *string, grep *string, sourceFilter *model.LogSourceFilter) (<-chan *logs.LogRecord, error) {
	// Get bearer token
	token, err := r.getBearerTokenRequired(ctx)
	if err != nil {
		return nil, gqlerrors.ErrUnauthenticated
	}

	// Parse time args
	sinceTime, err := parseTimeArg(ptr.Deref(since, ""))
	if err != nil {
		return nil, err
	}

	afterTime, err := parseTimeArg(ptr.Deref(after, ""))
	if err != nil {
		return nil, err
	}

	// Handle after
	if !afterTime.IsZero() {
		sinceTime = afterTime.Add(1 * time.Nanosecond)
	}

	// Init stream
	sourceFilterVal := ptr.Deref(sourceFilter, model.LogSourceFilter{})

	streamOpts := []logs.Option{
		logs.WithBearerToken(token),
		logs.WithAllowedNamespaces(r.allowedNamespaces),
		logs.WithLogFetcher(logs.NewAgentLogFetcher(r.grpcDispatcher)),
		logs.WithAll(),
		logs.WithFollow(true),
		logs.WithSince(sinceTime),
		logs.WithGrep(ptr.Deref(grep, "")),
		logs.WithRegions(sourceFilterVal.Region),
		logs.WithZones(sourceFilterVal.Zone),
		logs.WithOSes(sourceFilterVal.Os),
		logs.WithArches(sourceFilterVal.Arch),
		logs.WithNodes(sourceFilterVal.Node),
		logs.WithContainers(sourceFilterVal.Container),
	}

	stream, err := logs.NewStream(ctx, r.cm, sources, streamOpts...)
	if err != nil {
		return nil, err
	}

	// Start stream
	if err := stream.Start(ctx); err != nil {
		return nil, err
	}

	// Init output channel
	outCh := make(chan *logs.LogRecord)

	// Write out in goroutine
	go func() {
		defer close(outCh)
		defer stream.Close()

		for record := range stream.Records() {
			select {
			case <-ctx.Done():
				return
			case outCh <- &record:
				// Success
			}
		}

		// Handle errors
		if err := stream.Err(); err != nil {
			if status.Code(err) == codes.Unavailable {
				transport.AddSubscriptionError(ctx, gqlerrors.ErrServiceUnavailable)
			} else {
				zlog.Error().Err(stream.Err()).Caller().Send()
				transport.AddSubscriptionError(ctx, gqlerrors.ErrInternalServerError)
			}
		}
	}()

	return outCh, nil
}

// LogSourcesWatch is the resolver for the logSourcesWatch field.
func (r *subscriptionResolver) LogSourcesWatch(ctx context.Context, kubeContext *string, sources []string) (<-chan *model.LogSourceWatchEvent, error) {
	panic(fmt.Errorf("not implemented: LogSourcesWatch - logSourcesWatch"))
}

// Query returns QueryResolver implementation.
func (r *Resolver) Query() QueryResolver { return &queryResolver{r} }

// Subscription returns SubscriptionResolver implementation.
func (r *Resolver) Subscription() SubscriptionResolver { return &subscriptionResolver{r} }

type queryResolver struct{ *Resolver }
type subscriptionResolver struct{ *Resolver }
