// Code generated by github.com/99designs/gqlgen, DO NOT EDIT.

package graph

import (
	"bytes"
	"context"
	"embed"
	"errors"
	"fmt"
	"io"
	"strconv"
	"sync"
	"sync/atomic"
	"time"

	"github.com/99designs/gqlgen/graphql"
	"github.com/99designs/gqlgen/graphql/introspection"
	"github.com/kubetail-org/kubetail/modules/dashboard/graph/model"
	model1 "github.com/kubetail-org/kubetail/modules/shared/graphql/model"
	"github.com/kubetail-org/kubetail/modules/shared/logs"
	gqlparser "github.com/vektah/gqlparser/v2"
	"github.com/vektah/gqlparser/v2/ast"
	"helm.sh/helm/v3/pkg/chart"
	"helm.sh/helm/v3/pkg/release"
	v11 "k8s.io/api/apps/v1"
	v12 "k8s.io/api/batch/v1"
	v13 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/types"
	"k8s.io/apimachinery/pkg/watch"
)

// region    ************************** generated!.gotpl **************************

// NewExecutableSchema creates an ExecutableSchema from the ResolverRoot interface.
func NewExecutableSchema(cfg Config) graphql.ExecutableSchema {
	return &executableSchema{
		schema:     cfg.Schema,
		resolvers:  cfg.Resolvers,
		directives: cfg.Directives,
		complexity: cfg.Complexity,
	}
}

type Config struct {
	Schema     *ast.Schema
	Resolvers  ResolverRoot
	Directives DirectiveRoot
	Complexity ComplexityRoot
}

type ResolverRoot interface {
	AppsV1DaemonSetsWatchEvent() AppsV1DaemonSetsWatchEventResolver
	AppsV1DeploymentsWatchEvent() AppsV1DeploymentsWatchEventResolver
	AppsV1ReplicaSetsWatchEvent() AppsV1ReplicaSetsWatchEventResolver
	AppsV1StatefulSetsWatchEvent() AppsV1StatefulSetsWatchEventResolver
	BatchV1CronJobsWatchEvent() BatchV1CronJobsWatchEventResolver
	BatchV1JobsWatchEvent() BatchV1JobsWatchEventResolver
	CoreV1NamespacesWatchEvent() CoreV1NamespacesWatchEventResolver
	CoreV1NodesWatchEvent() CoreV1NodesWatchEventResolver
	CoreV1PodsWatchEvent() CoreV1PodsWatchEventResolver
	CoreV1ServicesWatchEvent() CoreV1ServicesWatchEventResolver
	KubeConfig() KubeConfigResolver
	Mutation() MutationResolver
	Query() QueryResolver
	Subscription() SubscriptionResolver
}

type DirectiveRoot struct {
	NullIfValidationFailed func(ctx context.Context, obj any, next graphql.Resolver) (res any, err error)
	Validate               func(ctx context.Context, obj any, next graphql.Resolver, rule string, message *string) (res any, err error)
}

type ComplexityRoot struct {
	AppsV1DaemonSet struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	AppsV1DaemonSetCondition struct {
		LastTransitionTime func(childComplexity int) int
		Message            func(childComplexity int) int
		Reason             func(childComplexity int) int
		Status             func(childComplexity int) int
		Type               func(childComplexity int) int
	}

	AppsV1DaemonSetList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	AppsV1DaemonSetSpec struct {
		Selector func(childComplexity int) int
	}

	AppsV1DaemonSetStatus struct {
		Conditions             func(childComplexity int) int
		CurrentNumberScheduled func(childComplexity int) int
		DesiredNumberScheduled func(childComplexity int) int
		NumberAvailable        func(childComplexity int) int
		NumberMisscheduled     func(childComplexity int) int
		NumberReady            func(childComplexity int) int
		NumberUnavailable      func(childComplexity int) int
		ObservedGeneration     func(childComplexity int) int
		UpdatedNumberScheduled func(childComplexity int) int
	}

	AppsV1DaemonSetsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	AppsV1Deployment struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	AppsV1DeploymentList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	AppsV1DeploymentSpec struct {
		Paused   func(childComplexity int) int
		Replicas func(childComplexity int) int
		Selector func(childComplexity int) int
	}

	AppsV1DeploymentStatus struct {
		Replicas func(childComplexity int) int
	}

	AppsV1DeploymentsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	AppsV1ReplicaSet struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	AppsV1ReplicaSetList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	AppsV1ReplicaSetSpec struct {
		Replicas func(childComplexity int) int
		Selector func(childComplexity int) int
	}

	AppsV1ReplicaSetStatus struct {
		Replicas func(childComplexity int) int
	}

	AppsV1ReplicaSetsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	AppsV1StatefulSet struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	AppsV1StatefulSetList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	AppsV1StatefulSetSpec struct {
		Replicas func(childComplexity int) int
		Selector func(childComplexity int) int
	}

	AppsV1StatefulSetsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	BatchV1CronJob struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	BatchV1CronJobList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	BatchV1CronJobSpec struct {
		FailedJobsHistoryLimit     func(childComplexity int) int
		JobTemplate                func(childComplexity int) int
		Schedule                   func(childComplexity int) int
		SuccessfulJobsHistoryLimit func(childComplexity int) int
		Suspend                    func(childComplexity int) int
		TimeZone                   func(childComplexity int) int
	}

	BatchV1CronJobStatus struct {
		Active             func(childComplexity int) int
		LastScheduleTime   func(childComplexity int) int
		LastSuccessfulTime func(childComplexity int) int
	}

	BatchV1CronJobsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	BatchV1Job struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	BatchV1JobCondition struct {
		LastProbeTime      func(childComplexity int) int
		LastTransitionTime func(childComplexity int) int
		Message            func(childComplexity int) int
		Reason             func(childComplexity int) int
		Status             func(childComplexity int) int
		Type               func(childComplexity int) int
	}

	BatchV1JobList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	BatchV1JobSpec struct {
		BackoffLimit            func(childComplexity int) int
		Completions             func(childComplexity int) int
		ManualSelector          func(childComplexity int) int
		Parallelism             func(childComplexity int) int
		Selector                func(childComplexity int) int
		Suspend                 func(childComplexity int) int
		TTLSecondsAfterFinished func(childComplexity int) int
	}

	BatchV1JobStatus struct {
		Active           func(childComplexity int) int
		CompletedIndexes func(childComplexity int) int
		CompletionTime   func(childComplexity int) int
		Conditions       func(childComplexity int) int
		Failed           func(childComplexity int) int
		Ready            func(childComplexity int) int
		StartTime        func(childComplexity int) int
		Succeeded        func(childComplexity int) int
	}

	BatchV1JobTemplateSpec struct {
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
	}

	BatchV1JobsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	CoreV1Container struct {
		Image func(childComplexity int) int
		Name  func(childComplexity int) int
	}

	CoreV1ContainerState struct {
		Running    func(childComplexity int) int
		Terminated func(childComplexity int) int
		Waiting    func(childComplexity int) int
	}

	CoreV1ContainerStateRunning struct {
		StartedAt func(childComplexity int) int
	}

	CoreV1ContainerStateTerminated struct {
		ContainerID func(childComplexity int) int
		ExitCode    func(childComplexity int) int
		Message     func(childComplexity int) int
		Reason      func(childComplexity int) int
		Signal      func(childComplexity int) int
	}

	CoreV1ContainerStateWaiting struct {
		Message func(childComplexity int) int
		Reason  func(childComplexity int) int
	}

	CoreV1ContainerStatus struct {
		ContainerID          func(childComplexity int) int
		Image                func(childComplexity int) int
		ImageID              func(childComplexity int) int
		LastTerminationState func(childComplexity int) int
		Name                 func(childComplexity int) int
		Ready                func(childComplexity int) int
		RestartCount         func(childComplexity int) int
		Started              func(childComplexity int) int
		State                func(childComplexity int) int
	}

	CoreV1Namespace struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	CoreV1NamespaceList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	CoreV1NamespacesWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	CoreV1Node struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	CoreV1NodeList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	CoreV1NodesWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	CoreV1ObjectReference struct {
		APIVersion      func(childComplexity int) int
		FieldPath       func(childComplexity int) int
		Kind            func(childComplexity int) int
		Name            func(childComplexity int) int
		Namespace       func(childComplexity int) int
		ResourceVersion func(childComplexity int) int
		UID             func(childComplexity int) int
	}

	CoreV1Pod struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		Status     func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	CoreV1PodList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	CoreV1PodSpec struct {
		Containers        func(childComplexity int) int
		Hostname          func(childComplexity int) int
		NodeName          func(childComplexity int) int
		PriorityClassName func(childComplexity int) int
	}

	CoreV1PodStatus struct {
		ContainerStatuses func(childComplexity int) int
		Message           func(childComplexity int) int
		Phase             func(childComplexity int) int
		Reason            func(childComplexity int) int
	}

	CoreV1PodsWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	CoreV1Service struct {
		APIVersion func(childComplexity int) int
		Kind       func(childComplexity int) int
		ObjectMeta func(childComplexity int) int
		Spec       func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	CoreV1ServiceList struct {
		APIVersion func(childComplexity int) int
		Items      func(childComplexity int) int
		Kind       func(childComplexity int) int
		ListMeta   func(childComplexity int) int
	}

	CoreV1ServicePort struct {
		AppProtocol func(childComplexity int) int
		Name        func(childComplexity int) int
		Port        func(childComplexity int) int
	}

	CoreV1ServiceSpec struct {
		ClusterIP    func(childComplexity int) int
		ClusterIPs   func(childComplexity int) int
		ExternalName func(childComplexity int) int
		Ports        func(childComplexity int) int
		Selector     func(childComplexity int) int
	}

	CoreV1ServicesWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	HealthCheckResponse struct {
		Message   func(childComplexity int) int
		Status    func(childComplexity int) int
		Timestamp func(childComplexity int) int
	}

	HelmChart struct {
		Metadata func(childComplexity int) int
	}

	HelmChartMetadata struct {
		AppVersion func(childComplexity int) int
		Condition  func(childComplexity int) int
		Name       func(childComplexity int) int
		Version    func(childComplexity int) int
	}

	HelmRelease struct {
		Chart     func(childComplexity int) int
		Name      func(childComplexity int) int
		Namespace func(childComplexity int) int
		Version   func(childComplexity int) int
	}

	KubeConfig struct {
		AuthInfos      func(childComplexity int) int
		Clusters       func(childComplexity int) int
		Contexts       func(childComplexity int) int
		CurrentContext func(childComplexity int) int
		Extensions     func(childComplexity int) int
	}

	KubeConfigAuthInfo struct {
		Extensions       func(childComplexity int) int
		LocationOfOrigin func(childComplexity int) int
		Name             func(childComplexity int) int
	}

	KubeConfigCluster struct {
		Extensions       func(childComplexity int) int
		LocationOfOrigin func(childComplexity int) int
		Name             func(childComplexity int) int
		Server           func(childComplexity int) int
	}

	KubeConfigContext struct {
		AuthInfo         func(childComplexity int) int
		Cluster          func(childComplexity int) int
		Extensions       func(childComplexity int) int
		LocationOfOrigin func(childComplexity int) int
		Name             func(childComplexity int) int
		Namespace        func(childComplexity int) int
	}

	KubeConfigWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	LogRecord struct {
		Message   func(childComplexity int) int
		Source    func(childComplexity int) int
		Timestamp func(childComplexity int) int
	}

	LogRecordsQueryResponse struct {
		NextCursor func(childComplexity int) int
		Records    func(childComplexity int) int
	}

	LogSource struct {
		ContainerID   func(childComplexity int) int
		ContainerName func(childComplexity int) int
		Metadata      func(childComplexity int) int
		Namespace     func(childComplexity int) int
		PodName       func(childComplexity int) int
	}

	LogSourceMetadata struct {
		Arch   func(childComplexity int) int
		Node   func(childComplexity int) int
		OS     func(childComplexity int) int
		Region func(childComplexity int) int
		Zone   func(childComplexity int) int
	}

	LogSourceWatchEvent struct {
		Object func(childComplexity int) int
		Type   func(childComplexity int) int
	}

	MetaV1LabelSelector struct {
		MatchExpressions func(childComplexity int) int
		MatchLabels      func(childComplexity int) int
	}

	MetaV1LabelSelectorRequirement struct {
		Key      func(childComplexity int) int
		Operator func(childComplexity int) int
		Values   func(childComplexity int) int
	}

	MetaV1ListMeta struct {
		Continue           func(childComplexity int) int
		RemainingItemCount func(childComplexity int) int
		ResourceVersion    func(childComplexity int) int
	}

	MetaV1ObjectMeta struct {
		Annotations       func(childComplexity int) int
		CreationTimestamp func(childComplexity int) int
		DeletionTimestamp func(childComplexity int) int
		Labels            func(childComplexity int) int
		Name              func(childComplexity int) int
		Namespace         func(childComplexity int) int
		OwnerReferences   func(childComplexity int) int
		ResourceVersion   func(childComplexity int) int
		UID               func(childComplexity int) int
	}

	MetaV1OwnerReference struct {
		APIVersion func(childComplexity int) int
		Controller func(childComplexity int) int
		Kind       func(childComplexity int) int
		Name       func(childComplexity int) int
		UID        func(childComplexity int) int
	}

	Mutation struct {
		HelmInstallLatest func(childComplexity int, kubeContext *string) int
	}

	PageInfo struct {
		EndCursor       func(childComplexity int) int
		HasNextPage     func(childComplexity int) int
		HasPreviousPage func(childComplexity int) int
		StartCursor     func(childComplexity int) int
	}

	Query struct {
		AppsV1DaemonSetsGet     func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		AppsV1DaemonSetsList    func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1DeploymentsGet    func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		AppsV1DeploymentsList   func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1ReplicaSetsGet    func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		AppsV1ReplicaSetsList   func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1StatefulSetsGet   func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		AppsV1StatefulSetsList  func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		BatchV1CronJobsGet      func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		BatchV1CronJobsList     func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		BatchV1JobsGet          func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		BatchV1JobsList         func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		ClusterAPIHealthzGet    func(childComplexity int, kubeContext *string, namespace *string, serviceName *string) int
		ClusterAPIReadyWait     func(childComplexity int, kubeContext *string, namespace *string, serviceName *string) int
		ClusterAPIServicesList  func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1NamespacesList    func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1NodesList         func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1PodsGet           func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		CoreV1PodsList          func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		CoreV1ServicesGet       func(childComplexity int, kubeContext *string, namespace *string, name string, options *v1.GetOptions) int
		CoreV1ServicesList      func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		HelmListReleases        func(childComplexity int, kubeContext *string) int
		KubeConfigGet           func(childComplexity int) int
		KubernetesAPIHealthzGet func(childComplexity int, kubeContext *string) int
		KubernetesAPIReadyWait  func(childComplexity int, kubeContext *string) int
		LogRecordsFetch         func(childComplexity int, kubeContext *string, sources []string, mode *model.LogRecordsQueryMode, since *string, until *string, after *string, before *string, grep *string, sourceFilter *model.LogSourceFilter, limit *int) int
	}

	Subscription struct {
		AppsV1DaemonSetsWatch     func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1DeploymentsWatch    func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1ReplicaSetsWatch    func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		AppsV1StatefulSetsWatch   func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		BatchV1CronJobsWatch      func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		BatchV1JobsWatch          func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		ClusterAPIHealthzWatch    func(childComplexity int, kubeContext *string, namespace *string, serviceName *string) int
		ClusterAPIReadyWait       func(childComplexity int, kubeContext *string, namespace *string, serviceName *string) int
		ClusterAPIServicesWatch   func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1NamespacesWatch     func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1NodesWatch          func(childComplexity int, kubeContext *string, options *v1.ListOptions) int
		CoreV1PodsWatch           func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		CoreV1ServicesWatch       func(childComplexity int, kubeContext *string, namespace *string, options *v1.ListOptions) int
		KubeConfigWatch           func(childComplexity int) int
		KubernetesAPIHealthzWatch func(childComplexity int, kubeContext *string) int
		KubernetesAPIReadyWait    func(childComplexity int, kubeContext *string) int
		LogRecordsFollow          func(childComplexity int, kubeContext *string, sources []string, since *string, after *string, grep *string, sourceFilter *model.LogSourceFilter) int
		LogSourcesWatch           func(childComplexity int, kubeContext *string, sources []string) int
	}
}

type AppsV1DaemonSetsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v11.DaemonSet, error)
}
type AppsV1DeploymentsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v11.Deployment, error)
}
type AppsV1ReplicaSetsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v11.ReplicaSet, error)
}
type AppsV1StatefulSetsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v11.StatefulSet, error)
}
type BatchV1CronJobsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v12.CronJob, error)
}
type BatchV1JobsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v12.Job, error)
}
type CoreV1NamespacesWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v13.Namespace, error)
}
type CoreV1NodesWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v13.Node, error)
}
type CoreV1PodsWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v13.Pod, error)
}
type CoreV1ServicesWatchEventResolver interface {
	Object(ctx context.Context, obj *watch.Event) (*v13.Service, error)
}
type KubeConfigResolver interface {
	AuthInfos(ctx context.Context, obj *model.KubeConfig) ([]*model.KubeConfigAuthInfo, error)
	Clusters(ctx context.Context, obj *model.KubeConfig) ([]*model.KubeConfigCluster, error)
	Contexts(ctx context.Context, obj *model.KubeConfig) ([]*model.KubeConfigContext, error)
}
type MutationResolver interface {
	HelmInstallLatest(ctx context.Context, kubeContext *string) (*release.Release, error)
}
type QueryResolver interface {
	AppsV1DaemonSetsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v11.DaemonSet, error)
	AppsV1DaemonSetsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v11.DaemonSetList, error)
	AppsV1DeploymentsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v11.Deployment, error)
	AppsV1DeploymentsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v11.DeploymentList, error)
	AppsV1ReplicaSetsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v11.ReplicaSet, error)
	AppsV1ReplicaSetsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v11.ReplicaSetList, error)
	AppsV1StatefulSetsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v11.StatefulSet, error)
	AppsV1StatefulSetsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v11.StatefulSetList, error)
	BatchV1CronJobsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v12.CronJob, error)
	BatchV1CronJobsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v12.CronJobList, error)
	BatchV1JobsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v12.Job, error)
	BatchV1JobsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v12.JobList, error)
	CoreV1NamespacesList(ctx context.Context, kubeContext *string, options *v1.ListOptions) (*v13.NamespaceList, error)
	CoreV1NodesList(ctx context.Context, kubeContext *string, options *v1.ListOptions) (*v13.NodeList, error)
	CoreV1PodsGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v13.Pod, error)
	CoreV1PodsList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v13.PodList, error)
	CoreV1ServicesGet(ctx context.Context, kubeContext *string, namespace *string, name string, options *v1.GetOptions) (*v13.Service, error)
	CoreV1ServicesList(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (*v13.ServiceList, error)
	ClusterAPIReadyWait(ctx context.Context, kubeContext *string, namespace *string, serviceName *string) (bool, error)
	ClusterAPIHealthzGet(ctx context.Context, kubeContext *string, namespace *string, serviceName *string) (*model.HealthCheckResponse, error)
	ClusterAPIServicesList(ctx context.Context, kubeContext *string, options *v1.ListOptions) (*v13.ServiceList, error)
	HelmListReleases(ctx context.Context, kubeContext *string) ([]*release.Release, error)
	KubeConfigGet(ctx context.Context) (*model.KubeConfig, error)
	KubernetesAPIReadyWait(ctx context.Context, kubeContext *string) (bool, error)
	KubernetesAPIHealthzGet(ctx context.Context, kubeContext *string) (*model.HealthCheckResponse, error)
	LogRecordsFetch(ctx context.Context, kubeContext *string, sources []string, mode *model.LogRecordsQueryMode, since *string, until *string, after *string, before *string, grep *string, sourceFilter *model.LogSourceFilter, limit *int) (*model.LogRecordsQueryResponse, error)
}
type SubscriptionResolver interface {
	AppsV1DaemonSetsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	AppsV1DeploymentsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	AppsV1ReplicaSetsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	AppsV1StatefulSetsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	BatchV1CronJobsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	BatchV1JobsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	CoreV1NamespacesWatch(ctx context.Context, kubeContext *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	CoreV1NodesWatch(ctx context.Context, kubeContext *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	CoreV1PodsWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	CoreV1ServicesWatch(ctx context.Context, kubeContext *string, namespace *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	KubernetesAPIReadyWait(ctx context.Context, kubeContext *string) (<-chan bool, error)
	KubernetesAPIHealthzWatch(ctx context.Context, kubeContext *string) (<-chan *model.HealthCheckResponse, error)
	ClusterAPIReadyWait(ctx context.Context, kubeContext *string, namespace *string, serviceName *string) (<-chan bool, error)
	ClusterAPIHealthzWatch(ctx context.Context, kubeContext *string, namespace *string, serviceName *string) (<-chan *model.HealthCheckResponse, error)
	ClusterAPIServicesWatch(ctx context.Context, kubeContext *string, options *v1.ListOptions) (<-chan *watch.Event, error)
	KubeConfigWatch(ctx context.Context) (<-chan *model.KubeConfigWatchEvent, error)
	LogRecordsFollow(ctx context.Context, kubeContext *string, sources []string, since *string, after *string, grep *string, sourceFilter *model.LogSourceFilter) (<-chan *logs.LogRecord, error)
	LogSourcesWatch(ctx context.Context, kubeContext *string, sources []string) (<-chan *model.LogSourceWatchEvent, error)
}

type executableSchema struct {
	schema     *ast.Schema
	resolvers  ResolverRoot
	directives DirectiveRoot
	complexity ComplexityRoot
}

func (e *executableSchema) Schema() *ast.Schema {
	if e.schema != nil {
		return e.schema
	}
	return parsedSchema
}

func (e *executableSchema) Complexity(ctx context.Context, typeName, field string, childComplexity int, rawArgs map[string]any) (int, bool) {
	ec := executionContext{nil, e, 0, 0, nil}
	_ = ec
	switch typeName + "." + field {

	case "AppsV1DaemonSet.apiVersion":
		if e.complexity.AppsV1DaemonSet.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.APIVersion(childComplexity), true

	case "AppsV1DaemonSet.kind":
		if e.complexity.AppsV1DaemonSet.Kind == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.Kind(childComplexity), true

	case "AppsV1DaemonSet.metadata":
		if e.complexity.AppsV1DaemonSet.ObjectMeta == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.ObjectMeta(childComplexity), true

	case "AppsV1DaemonSet.spec":
		if e.complexity.AppsV1DaemonSet.Spec == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.Spec(childComplexity), true

	case "AppsV1DaemonSet.status":
		if e.complexity.AppsV1DaemonSet.Status == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.Status(childComplexity), true

	case "AppsV1DaemonSet.id":
		if e.complexity.AppsV1DaemonSet.UID == nil {
			break
		}

		return e.complexity.AppsV1DaemonSet.UID(childComplexity), true

	case "AppsV1DaemonSetCondition.lastTransitionTime":
		if e.complexity.AppsV1DaemonSetCondition.LastTransitionTime == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetCondition.LastTransitionTime(childComplexity), true

	case "AppsV1DaemonSetCondition.message":
		if e.complexity.AppsV1DaemonSetCondition.Message == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetCondition.Message(childComplexity), true

	case "AppsV1DaemonSetCondition.reason":
		if e.complexity.AppsV1DaemonSetCondition.Reason == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetCondition.Reason(childComplexity), true

	case "AppsV1DaemonSetCondition.status":
		if e.complexity.AppsV1DaemonSetCondition.Status == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetCondition.Status(childComplexity), true

	case "AppsV1DaemonSetCondition.type":
		if e.complexity.AppsV1DaemonSetCondition.Type == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetCondition.Type(childComplexity), true

	case "AppsV1DaemonSetList.apiVersion":
		if e.complexity.AppsV1DaemonSetList.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetList.APIVersion(childComplexity), true

	case "AppsV1DaemonSetList.items":
		if e.complexity.AppsV1DaemonSetList.Items == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetList.Items(childComplexity), true

	case "AppsV1DaemonSetList.kind":
		if e.complexity.AppsV1DaemonSetList.Kind == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetList.Kind(childComplexity), true

	case "AppsV1DaemonSetList.metadata":
		if e.complexity.AppsV1DaemonSetList.ListMeta == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetList.ListMeta(childComplexity), true

	case "AppsV1DaemonSetSpec.selector":
		if e.complexity.AppsV1DaemonSetSpec.Selector == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetSpec.Selector(childComplexity), true

	case "AppsV1DaemonSetStatus.conditions":
		if e.complexity.AppsV1DaemonSetStatus.Conditions == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.Conditions(childComplexity), true

	case "AppsV1DaemonSetStatus.currentNumberScheduled":
		if e.complexity.AppsV1DaemonSetStatus.CurrentNumberScheduled == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.CurrentNumberScheduled(childComplexity), true

	case "AppsV1DaemonSetStatus.desiredNumberScheduled":
		if e.complexity.AppsV1DaemonSetStatus.DesiredNumberScheduled == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.DesiredNumberScheduled(childComplexity), true

	case "AppsV1DaemonSetStatus.numberAvailable":
		if e.complexity.AppsV1DaemonSetStatus.NumberAvailable == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.NumberAvailable(childComplexity), true

	case "AppsV1DaemonSetStatus.numberMisscheduled":
		if e.complexity.AppsV1DaemonSetStatus.NumberMisscheduled == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.NumberMisscheduled(childComplexity), true

	case "AppsV1DaemonSetStatus.numberReady":
		if e.complexity.AppsV1DaemonSetStatus.NumberReady == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.NumberReady(childComplexity), true

	case "AppsV1DaemonSetStatus.numberUnavailable":
		if e.complexity.AppsV1DaemonSetStatus.NumberUnavailable == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.NumberUnavailable(childComplexity), true

	case "AppsV1DaemonSetStatus.observedGeneration":
		if e.complexity.AppsV1DaemonSetStatus.ObservedGeneration == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.ObservedGeneration(childComplexity), true

	case "AppsV1DaemonSetStatus.updatedNumberScheduled":
		if e.complexity.AppsV1DaemonSetStatus.UpdatedNumberScheduled == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetStatus.UpdatedNumberScheduled(childComplexity), true

	case "AppsV1DaemonSetsWatchEvent.object":
		if e.complexity.AppsV1DaemonSetsWatchEvent.Object == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetsWatchEvent.Object(childComplexity), true

	case "AppsV1DaemonSetsWatchEvent.type":
		if e.complexity.AppsV1DaemonSetsWatchEvent.Type == nil {
			break
		}

		return e.complexity.AppsV1DaemonSetsWatchEvent.Type(childComplexity), true

	case "AppsV1Deployment.apiVersion":
		if e.complexity.AppsV1Deployment.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1Deployment.APIVersion(childComplexity), true

	case "AppsV1Deployment.kind":
		if e.complexity.AppsV1Deployment.Kind == nil {
			break
		}

		return e.complexity.AppsV1Deployment.Kind(childComplexity), true

	case "AppsV1Deployment.metadata":
		if e.complexity.AppsV1Deployment.ObjectMeta == nil {
			break
		}

		return e.complexity.AppsV1Deployment.ObjectMeta(childComplexity), true

	case "AppsV1Deployment.spec":
		if e.complexity.AppsV1Deployment.Spec == nil {
			break
		}

		return e.complexity.AppsV1Deployment.Spec(childComplexity), true

	case "AppsV1Deployment.status":
		if e.complexity.AppsV1Deployment.Status == nil {
			break
		}

		return e.complexity.AppsV1Deployment.Status(childComplexity), true

	case "AppsV1Deployment.id":
		if e.complexity.AppsV1Deployment.UID == nil {
			break
		}

		return e.complexity.AppsV1Deployment.UID(childComplexity), true

	case "AppsV1DeploymentList.apiVersion":
		if e.complexity.AppsV1DeploymentList.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1DeploymentList.APIVersion(childComplexity), true

	case "AppsV1DeploymentList.items":
		if e.complexity.AppsV1DeploymentList.Items == nil {
			break
		}

		return e.complexity.AppsV1DeploymentList.Items(childComplexity), true

	case "AppsV1DeploymentList.kind":
		if e.complexity.AppsV1DeploymentList.Kind == nil {
			break
		}

		return e.complexity.AppsV1DeploymentList.Kind(childComplexity), true

	case "AppsV1DeploymentList.metadata":
		if e.complexity.AppsV1DeploymentList.ListMeta == nil {
			break
		}

		return e.complexity.AppsV1DeploymentList.ListMeta(childComplexity), true

	case "AppsV1DeploymentSpec.paused":
		if e.complexity.AppsV1DeploymentSpec.Paused == nil {
			break
		}

		return e.complexity.AppsV1DeploymentSpec.Paused(childComplexity), true

	case "AppsV1DeploymentSpec.replicas":
		if e.complexity.AppsV1DeploymentSpec.Replicas == nil {
			break
		}

		return e.complexity.AppsV1DeploymentSpec.Replicas(childComplexity), true

	case "AppsV1DeploymentSpec.selector":
		if e.complexity.AppsV1DeploymentSpec.Selector == nil {
			break
		}

		return e.complexity.AppsV1DeploymentSpec.Selector(childComplexity), true

	case "AppsV1DeploymentStatus.replicas":
		if e.complexity.AppsV1DeploymentStatus.Replicas == nil {
			break
		}

		return e.complexity.AppsV1DeploymentStatus.Replicas(childComplexity), true

	case "AppsV1DeploymentsWatchEvent.object":
		if e.complexity.AppsV1DeploymentsWatchEvent.Object == nil {
			break
		}

		return e.complexity.AppsV1DeploymentsWatchEvent.Object(childComplexity), true

	case "AppsV1DeploymentsWatchEvent.type":
		if e.complexity.AppsV1DeploymentsWatchEvent.Type == nil {
			break
		}

		return e.complexity.AppsV1DeploymentsWatchEvent.Type(childComplexity), true

	case "AppsV1ReplicaSet.apiVersion":
		if e.complexity.AppsV1ReplicaSet.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.APIVersion(childComplexity), true

	case "AppsV1ReplicaSet.kind":
		if e.complexity.AppsV1ReplicaSet.Kind == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.Kind(childComplexity), true

	case "AppsV1ReplicaSet.metadata":
		if e.complexity.AppsV1ReplicaSet.ObjectMeta == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.ObjectMeta(childComplexity), true

	case "AppsV1ReplicaSet.spec":
		if e.complexity.AppsV1ReplicaSet.Spec == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.Spec(childComplexity), true

	case "AppsV1ReplicaSet.status":
		if e.complexity.AppsV1ReplicaSet.Status == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.Status(childComplexity), true

	case "AppsV1ReplicaSet.id":
		if e.complexity.AppsV1ReplicaSet.UID == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSet.UID(childComplexity), true

	case "AppsV1ReplicaSetList.apiVersion":
		if e.complexity.AppsV1ReplicaSetList.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetList.APIVersion(childComplexity), true

	case "AppsV1ReplicaSetList.items":
		if e.complexity.AppsV1ReplicaSetList.Items == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetList.Items(childComplexity), true

	case "AppsV1ReplicaSetList.kind":
		if e.complexity.AppsV1ReplicaSetList.Kind == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetList.Kind(childComplexity), true

	case "AppsV1ReplicaSetList.metadata":
		if e.complexity.AppsV1ReplicaSetList.ListMeta == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetList.ListMeta(childComplexity), true

	case "AppsV1ReplicaSetSpec.replicas":
		if e.complexity.AppsV1ReplicaSetSpec.Replicas == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetSpec.Replicas(childComplexity), true

	case "AppsV1ReplicaSetSpec.selector":
		if e.complexity.AppsV1ReplicaSetSpec.Selector == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetSpec.Selector(childComplexity), true

	case "AppsV1ReplicaSetStatus.replicas":
		if e.complexity.AppsV1ReplicaSetStatus.Replicas == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetStatus.Replicas(childComplexity), true

	case "AppsV1ReplicaSetsWatchEvent.object":
		if e.complexity.AppsV1ReplicaSetsWatchEvent.Object == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetsWatchEvent.Object(childComplexity), true

	case "AppsV1ReplicaSetsWatchEvent.type":
		if e.complexity.AppsV1ReplicaSetsWatchEvent.Type == nil {
			break
		}

		return e.complexity.AppsV1ReplicaSetsWatchEvent.Type(childComplexity), true

	case "AppsV1StatefulSet.apiVersion":
		if e.complexity.AppsV1StatefulSet.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1StatefulSet.APIVersion(childComplexity), true

	case "AppsV1StatefulSet.kind":
		if e.complexity.AppsV1StatefulSet.Kind == nil {
			break
		}

		return e.complexity.AppsV1StatefulSet.Kind(childComplexity), true

	case "AppsV1StatefulSet.metadata":
		if e.complexity.AppsV1StatefulSet.ObjectMeta == nil {
			break
		}

		return e.complexity.AppsV1StatefulSet.ObjectMeta(childComplexity), true

	case "AppsV1StatefulSet.spec":
		if e.complexity.AppsV1StatefulSet.Spec == nil {
			break
		}

		return e.complexity.AppsV1StatefulSet.Spec(childComplexity), true

	case "AppsV1StatefulSet.id":
		if e.complexity.AppsV1StatefulSet.UID == nil {
			break
		}

		return e.complexity.AppsV1StatefulSet.UID(childComplexity), true

	case "AppsV1StatefulSetList.apiVersion":
		if e.complexity.AppsV1StatefulSetList.APIVersion == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetList.APIVersion(childComplexity), true

	case "AppsV1StatefulSetList.items":
		if e.complexity.AppsV1StatefulSetList.Items == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetList.Items(childComplexity), true

	case "AppsV1StatefulSetList.kind":
		if e.complexity.AppsV1StatefulSetList.Kind == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetList.Kind(childComplexity), true

	case "AppsV1StatefulSetList.metadata":
		if e.complexity.AppsV1StatefulSetList.ListMeta == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetList.ListMeta(childComplexity), true

	case "AppsV1StatefulSetSpec.replicas":
		if e.complexity.AppsV1StatefulSetSpec.Replicas == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetSpec.Replicas(childComplexity), true

	case "AppsV1StatefulSetSpec.selector":
		if e.complexity.AppsV1StatefulSetSpec.Selector == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetSpec.Selector(childComplexity), true

	case "AppsV1StatefulSetsWatchEvent.object":
		if e.complexity.AppsV1StatefulSetsWatchEvent.Object == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetsWatchEvent.Object(childComplexity), true

	case "AppsV1StatefulSetsWatchEvent.type":
		if e.complexity.AppsV1StatefulSetsWatchEvent.Type == nil {
			break
		}

		return e.complexity.AppsV1StatefulSetsWatchEvent.Type(childComplexity), true

	case "BatchV1CronJob.apiVersion":
		if e.complexity.BatchV1CronJob.APIVersion == nil {
			break
		}

		return e.complexity.BatchV1CronJob.APIVersion(childComplexity), true

	case "BatchV1CronJob.kind":
		if e.complexity.BatchV1CronJob.Kind == nil {
			break
		}

		return e.complexity.BatchV1CronJob.Kind(childComplexity), true

	case "BatchV1CronJob.metadata":
		if e.complexity.BatchV1CronJob.ObjectMeta == nil {
			break
		}

		return e.complexity.BatchV1CronJob.ObjectMeta(childComplexity), true

	case "BatchV1CronJob.spec":
		if e.complexity.BatchV1CronJob.Spec == nil {
			break
		}

		return e.complexity.BatchV1CronJob.Spec(childComplexity), true

	case "BatchV1CronJob.status":
		if e.complexity.BatchV1CronJob.Status == nil {
			break
		}

		return e.complexity.BatchV1CronJob.Status(childComplexity), true

	case "BatchV1CronJob.id":
		if e.complexity.BatchV1CronJob.UID == nil {
			break
		}

		return e.complexity.BatchV1CronJob.UID(childComplexity), true

	case "BatchV1CronJobList.apiVersion":
		if e.complexity.BatchV1CronJobList.APIVersion == nil {
			break
		}

		return e.complexity.BatchV1CronJobList.APIVersion(childComplexity), true

	case "BatchV1CronJobList.items":
		if e.complexity.BatchV1CronJobList.Items == nil {
			break
		}

		return e.complexity.BatchV1CronJobList.Items(childComplexity), true

	case "BatchV1CronJobList.kind":
		if e.complexity.BatchV1CronJobList.Kind == nil {
			break
		}

		return e.complexity.BatchV1CronJobList.Kind(childComplexity), true

	case "BatchV1CronJobList.metadata":
		if e.complexity.BatchV1CronJobList.ListMeta == nil {
			break
		}

		return e.complexity.BatchV1CronJobList.ListMeta(childComplexity), true

	case "BatchV1CronJobSpec.failedJobsHistoryLimit":
		if e.complexity.BatchV1CronJobSpec.FailedJobsHistoryLimit == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.FailedJobsHistoryLimit(childComplexity), true

	case "BatchV1CronJobSpec.jobTemplate":
		if e.complexity.BatchV1CronJobSpec.JobTemplate == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.JobTemplate(childComplexity), true

	case "BatchV1CronJobSpec.schedule":
		if e.complexity.BatchV1CronJobSpec.Schedule == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.Schedule(childComplexity), true

	case "BatchV1CronJobSpec.successfulJobsHistoryLimit":
		if e.complexity.BatchV1CronJobSpec.SuccessfulJobsHistoryLimit == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.SuccessfulJobsHistoryLimit(childComplexity), true

	case "BatchV1CronJobSpec.suspend":
		if e.complexity.BatchV1CronJobSpec.Suspend == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.Suspend(childComplexity), true

	case "BatchV1CronJobSpec.timeZone":
		if e.complexity.BatchV1CronJobSpec.TimeZone == nil {
			break
		}

		return e.complexity.BatchV1CronJobSpec.TimeZone(childComplexity), true

	case "BatchV1CronJobStatus.active":
		if e.complexity.BatchV1CronJobStatus.Active == nil {
			break
		}

		return e.complexity.BatchV1CronJobStatus.Active(childComplexity), true

	case "BatchV1CronJobStatus.lastScheduleTime":
		if e.complexity.BatchV1CronJobStatus.LastScheduleTime == nil {
			break
		}

		return e.complexity.BatchV1CronJobStatus.LastScheduleTime(childComplexity), true

	case "BatchV1CronJobStatus.lastSuccessfulTime":
		if e.complexity.BatchV1CronJobStatus.LastSuccessfulTime == nil {
			break
		}

		return e.complexity.BatchV1CronJobStatus.LastSuccessfulTime(childComplexity), true

	case "BatchV1CronJobsWatchEvent.object":
		if e.complexity.BatchV1CronJobsWatchEvent.Object == nil {
			break
		}

		return e.complexity.BatchV1CronJobsWatchEvent.Object(childComplexity), true

	case "BatchV1CronJobsWatchEvent.type":
		if e.complexity.BatchV1CronJobsWatchEvent.Type == nil {
			break
		}

		return e.complexity.BatchV1CronJobsWatchEvent.Type(childComplexity), true

	case "BatchV1Job.apiVersion":
		if e.complexity.BatchV1Job.APIVersion == nil {
			break
		}

		return e.complexity.BatchV1Job.APIVersion(childComplexity), true

	case "BatchV1Job.kind":
		if e.complexity.BatchV1Job.Kind == nil {
			break
		}

		return e.complexity.BatchV1Job.Kind(childComplexity), true

	case "BatchV1Job.metadata":
		if e.complexity.BatchV1Job.ObjectMeta == nil {
			break
		}

		return e.complexity.BatchV1Job.ObjectMeta(childComplexity), true

	case "BatchV1Job.spec":
		if e.complexity.BatchV1Job.Spec == nil {
			break
		}

		return e.complexity.BatchV1Job.Spec(childComplexity), true

	case "BatchV1Job.status":
		if e.complexity.BatchV1Job.Status == nil {
			break
		}

		return e.complexity.BatchV1Job.Status(childComplexity), true

	case "BatchV1Job.id":
		if e.complexity.BatchV1Job.UID == nil {
			break
		}

		return e.complexity.BatchV1Job.UID(childComplexity), true

	case "BatchV1JobCondition.lastProbeTime":
		if e.complexity.BatchV1JobCondition.LastProbeTime == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.LastProbeTime(childComplexity), true

	case "BatchV1JobCondition.lastTransitionTime":
		if e.complexity.BatchV1JobCondition.LastTransitionTime == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.LastTransitionTime(childComplexity), true

	case "BatchV1JobCondition.message":
		if e.complexity.BatchV1JobCondition.Message == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.Message(childComplexity), true

	case "BatchV1JobCondition.reason":
		if e.complexity.BatchV1JobCondition.Reason == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.Reason(childComplexity), true

	case "BatchV1JobCondition.status":
		if e.complexity.BatchV1JobCondition.Status == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.Status(childComplexity), true

	case "BatchV1JobCondition.type":
		if e.complexity.BatchV1JobCondition.Type == nil {
			break
		}

		return e.complexity.BatchV1JobCondition.Type(childComplexity), true

	case "BatchV1JobList.apiVersion":
		if e.complexity.BatchV1JobList.APIVersion == nil {
			break
		}

		return e.complexity.BatchV1JobList.APIVersion(childComplexity), true

	case "BatchV1JobList.items":
		if e.complexity.BatchV1JobList.Items == nil {
			break
		}

		return e.complexity.BatchV1JobList.Items(childComplexity), true

	case "BatchV1JobList.kind":
		if e.complexity.BatchV1JobList.Kind == nil {
			break
		}

		return e.complexity.BatchV1JobList.Kind(childComplexity), true

	case "BatchV1JobList.metadata":
		if e.complexity.BatchV1JobList.ListMeta == nil {
			break
		}

		return e.complexity.BatchV1JobList.ListMeta(childComplexity), true

	case "BatchV1JobSpec.backoffLimit":
		if e.complexity.BatchV1JobSpec.BackoffLimit == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.BackoffLimit(childComplexity), true

	case "BatchV1JobSpec.completions":
		if e.complexity.BatchV1JobSpec.Completions == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.Completions(childComplexity), true

	case "BatchV1JobSpec.manualSelector":
		if e.complexity.BatchV1JobSpec.ManualSelector == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.ManualSelector(childComplexity), true

	case "BatchV1JobSpec.parallelism":
		if e.complexity.BatchV1JobSpec.Parallelism == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.Parallelism(childComplexity), true

	case "BatchV1JobSpec.selector":
		if e.complexity.BatchV1JobSpec.Selector == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.Selector(childComplexity), true

	case "BatchV1JobSpec.suspend":
		if e.complexity.BatchV1JobSpec.Suspend == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.Suspend(childComplexity), true

	case "BatchV1JobSpec.ttlSecondsAfterFinished":
		if e.complexity.BatchV1JobSpec.TTLSecondsAfterFinished == nil {
			break
		}

		return e.complexity.BatchV1JobSpec.TTLSecondsAfterFinished(childComplexity), true

	case "BatchV1JobStatus.active":
		if e.complexity.BatchV1JobStatus.Active == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.Active(childComplexity), true

	case "BatchV1JobStatus.completedIndexes":
		if e.complexity.BatchV1JobStatus.CompletedIndexes == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.CompletedIndexes(childComplexity), true

	case "BatchV1JobStatus.completionTime":
		if e.complexity.BatchV1JobStatus.CompletionTime == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.CompletionTime(childComplexity), true

	case "BatchV1JobStatus.conditions":
		if e.complexity.BatchV1JobStatus.Conditions == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.Conditions(childComplexity), true

	case "BatchV1JobStatus.failed":
		if e.complexity.BatchV1JobStatus.Failed == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.Failed(childComplexity), true

	case "BatchV1JobStatus.ready":
		if e.complexity.BatchV1JobStatus.Ready == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.Ready(childComplexity), true

	case "BatchV1JobStatus.startTime":
		if e.complexity.BatchV1JobStatus.StartTime == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.StartTime(childComplexity), true

	case "BatchV1JobStatus.succeeded":
		if e.complexity.BatchV1JobStatus.Succeeded == nil {
			break
		}

		return e.complexity.BatchV1JobStatus.Succeeded(childComplexity), true

	case "BatchV1JobTemplateSpec.metadata":
		if e.complexity.BatchV1JobTemplateSpec.ObjectMeta == nil {
			break
		}

		return e.complexity.BatchV1JobTemplateSpec.ObjectMeta(childComplexity), true

	case "BatchV1JobTemplateSpec.spec":
		if e.complexity.BatchV1JobTemplateSpec.Spec == nil {
			break
		}

		return e.complexity.BatchV1JobTemplateSpec.Spec(childComplexity), true

	case "BatchV1JobsWatchEvent.object":
		if e.complexity.BatchV1JobsWatchEvent.Object == nil {
			break
		}

		return e.complexity.BatchV1JobsWatchEvent.Object(childComplexity), true

	case "BatchV1JobsWatchEvent.type":
		if e.complexity.BatchV1JobsWatchEvent.Type == nil {
			break
		}

		return e.complexity.BatchV1JobsWatchEvent.Type(childComplexity), true

	case "CoreV1Container.image":
		if e.complexity.CoreV1Container.Image == nil {
			break
		}

		return e.complexity.CoreV1Container.Image(childComplexity), true

	case "CoreV1Container.name":
		if e.complexity.CoreV1Container.Name == nil {
			break
		}

		return e.complexity.CoreV1Container.Name(childComplexity), true

	case "CoreV1ContainerState.running":
		if e.complexity.CoreV1ContainerState.Running == nil {
			break
		}

		return e.complexity.CoreV1ContainerState.Running(childComplexity), true

	case "CoreV1ContainerState.terminated":
		if e.complexity.CoreV1ContainerState.Terminated == nil {
			break
		}

		return e.complexity.CoreV1ContainerState.Terminated(childComplexity), true

	case "CoreV1ContainerState.waiting":
		if e.complexity.CoreV1ContainerState.Waiting == nil {
			break
		}

		return e.complexity.CoreV1ContainerState.Waiting(childComplexity), true

	case "CoreV1ContainerStateRunning.startedAt":
		if e.complexity.CoreV1ContainerStateRunning.StartedAt == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateRunning.StartedAt(childComplexity), true

	case "CoreV1ContainerStateTerminated.containerID":
		if e.complexity.CoreV1ContainerStateTerminated.ContainerID == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateTerminated.ContainerID(childComplexity), true

	case "CoreV1ContainerStateTerminated.exitCode":
		if e.complexity.CoreV1ContainerStateTerminated.ExitCode == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateTerminated.ExitCode(childComplexity), true

	case "CoreV1ContainerStateTerminated.message":
		if e.complexity.CoreV1ContainerStateTerminated.Message == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateTerminated.Message(childComplexity), true

	case "CoreV1ContainerStateTerminated.reason":
		if e.complexity.CoreV1ContainerStateTerminated.Reason == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateTerminated.Reason(childComplexity), true

	case "CoreV1ContainerStateTerminated.signal":
		if e.complexity.CoreV1ContainerStateTerminated.Signal == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateTerminated.Signal(childComplexity), true

	case "CoreV1ContainerStateWaiting.message":
		if e.complexity.CoreV1ContainerStateWaiting.Message == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateWaiting.Message(childComplexity), true

	case "CoreV1ContainerStateWaiting.reason":
		if e.complexity.CoreV1ContainerStateWaiting.Reason == nil {
			break
		}

		return e.complexity.CoreV1ContainerStateWaiting.Reason(childComplexity), true

	case "CoreV1ContainerStatus.containerID":
		if e.complexity.CoreV1ContainerStatus.ContainerID == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.ContainerID(childComplexity), true

	case "CoreV1ContainerStatus.image":
		if e.complexity.CoreV1ContainerStatus.Image == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.Image(childComplexity), true

	case "CoreV1ContainerStatus.imageID":
		if e.complexity.CoreV1ContainerStatus.ImageID == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.ImageID(childComplexity), true

	case "CoreV1ContainerStatus.lastTerminationState":
		if e.complexity.CoreV1ContainerStatus.LastTerminationState == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.LastTerminationState(childComplexity), true

	case "CoreV1ContainerStatus.name":
		if e.complexity.CoreV1ContainerStatus.Name == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.Name(childComplexity), true

	case "CoreV1ContainerStatus.ready":
		if e.complexity.CoreV1ContainerStatus.Ready == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.Ready(childComplexity), true

	case "CoreV1ContainerStatus.restartCount":
		if e.complexity.CoreV1ContainerStatus.RestartCount == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.RestartCount(childComplexity), true

	case "CoreV1ContainerStatus.started":
		if e.complexity.CoreV1ContainerStatus.Started == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.Started(childComplexity), true

	case "CoreV1ContainerStatus.state":
		if e.complexity.CoreV1ContainerStatus.State == nil {
			break
		}

		return e.complexity.CoreV1ContainerStatus.State(childComplexity), true

	case "CoreV1Namespace.apiVersion":
		if e.complexity.CoreV1Namespace.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1Namespace.APIVersion(childComplexity), true

	case "CoreV1Namespace.kind":
		if e.complexity.CoreV1Namespace.Kind == nil {
			break
		}

		return e.complexity.CoreV1Namespace.Kind(childComplexity), true

	case "CoreV1Namespace.metadata":
		if e.complexity.CoreV1Namespace.ObjectMeta == nil {
			break
		}

		return e.complexity.CoreV1Namespace.ObjectMeta(childComplexity), true

	case "CoreV1Namespace.id":
		if e.complexity.CoreV1Namespace.UID == nil {
			break
		}

		return e.complexity.CoreV1Namespace.UID(childComplexity), true

	case "CoreV1NamespaceList.apiVersion":
		if e.complexity.CoreV1NamespaceList.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1NamespaceList.APIVersion(childComplexity), true

	case "CoreV1NamespaceList.items":
		if e.complexity.CoreV1NamespaceList.Items == nil {
			break
		}

		return e.complexity.CoreV1NamespaceList.Items(childComplexity), true

	case "CoreV1NamespaceList.kind":
		if e.complexity.CoreV1NamespaceList.Kind == nil {
			break
		}

		return e.complexity.CoreV1NamespaceList.Kind(childComplexity), true

	case "CoreV1NamespaceList.metadata":
		if e.complexity.CoreV1NamespaceList.ListMeta == nil {
			break
		}

		return e.complexity.CoreV1NamespaceList.ListMeta(childComplexity), true

	case "CoreV1NamespacesWatchEvent.object":
		if e.complexity.CoreV1NamespacesWatchEvent.Object == nil {
			break
		}

		return e.complexity.CoreV1NamespacesWatchEvent.Object(childComplexity), true

	case "CoreV1NamespacesWatchEvent.type":
		if e.complexity.CoreV1NamespacesWatchEvent.Type == nil {
			break
		}

		return e.complexity.CoreV1NamespacesWatchEvent.Type(childComplexity), true

	case "CoreV1Node.apiVersion":
		if e.complexity.CoreV1Node.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1Node.APIVersion(childComplexity), true

	case "CoreV1Node.kind":
		if e.complexity.CoreV1Node.Kind == nil {
			break
		}

		return e.complexity.CoreV1Node.Kind(childComplexity), true

	case "CoreV1Node.metadata":
		if e.complexity.CoreV1Node.ObjectMeta == nil {
			break
		}

		return e.complexity.CoreV1Node.ObjectMeta(childComplexity), true

	case "CoreV1Node.id":
		if e.complexity.CoreV1Node.UID == nil {
			break
		}

		return e.complexity.CoreV1Node.UID(childComplexity), true

	case "CoreV1NodeList.apiVersion":
		if e.complexity.CoreV1NodeList.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1NodeList.APIVersion(childComplexity), true

	case "CoreV1NodeList.items":
		if e.complexity.CoreV1NodeList.Items == nil {
			break
		}

		return e.complexity.CoreV1NodeList.Items(childComplexity), true

	case "CoreV1NodeList.kind":
		if e.complexity.CoreV1NodeList.Kind == nil {
			break
		}

		return e.complexity.CoreV1NodeList.Kind(childComplexity), true

	case "CoreV1NodeList.metadata":
		if e.complexity.CoreV1NodeList.ListMeta == nil {
			break
		}

		return e.complexity.CoreV1NodeList.ListMeta(childComplexity), true

	case "CoreV1NodesWatchEvent.object":
		if e.complexity.CoreV1NodesWatchEvent.Object == nil {
			break
		}

		return e.complexity.CoreV1NodesWatchEvent.Object(childComplexity), true

	case "CoreV1NodesWatchEvent.type":
		if e.complexity.CoreV1NodesWatchEvent.Type == nil {
			break
		}

		return e.complexity.CoreV1NodesWatchEvent.Type(childComplexity), true

	case "CoreV1ObjectReference.apiVersion":
		if e.complexity.CoreV1ObjectReference.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.APIVersion(childComplexity), true

	case "CoreV1ObjectReference.fieldPath":
		if e.complexity.CoreV1ObjectReference.FieldPath == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.FieldPath(childComplexity), true

	case "CoreV1ObjectReference.kind":
		if e.complexity.CoreV1ObjectReference.Kind == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.Kind(childComplexity), true

	case "CoreV1ObjectReference.name":
		if e.complexity.CoreV1ObjectReference.Name == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.Name(childComplexity), true

	case "CoreV1ObjectReference.namespace":
		if e.complexity.CoreV1ObjectReference.Namespace == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.Namespace(childComplexity), true

	case "CoreV1ObjectReference.resourceVersion":
		if e.complexity.CoreV1ObjectReference.ResourceVersion == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.ResourceVersion(childComplexity), true

	case "CoreV1ObjectReference.uid":
		if e.complexity.CoreV1ObjectReference.UID == nil {
			break
		}

		return e.complexity.CoreV1ObjectReference.UID(childComplexity), true

	case "CoreV1Pod.apiVersion":
		if e.complexity.CoreV1Pod.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1Pod.APIVersion(childComplexity), true

	case "CoreV1Pod.kind":
		if e.complexity.CoreV1Pod.Kind == nil {
			break
		}

		return e.complexity.CoreV1Pod.Kind(childComplexity), true

	case "CoreV1Pod.metadata":
		if e.complexity.CoreV1Pod.ObjectMeta == nil {
			break
		}

		return e.complexity.CoreV1Pod.ObjectMeta(childComplexity), true

	case "CoreV1Pod.spec":
		if e.complexity.CoreV1Pod.Spec == nil {
			break
		}

		return e.complexity.CoreV1Pod.Spec(childComplexity), true

	case "CoreV1Pod.status":
		if e.complexity.CoreV1Pod.Status == nil {
			break
		}

		return e.complexity.CoreV1Pod.Status(childComplexity), true

	case "CoreV1Pod.id":
		if e.complexity.CoreV1Pod.UID == nil {
			break
		}

		return e.complexity.CoreV1Pod.UID(childComplexity), true

	case "CoreV1PodList.apiVersion":
		if e.complexity.CoreV1PodList.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1PodList.APIVersion(childComplexity), true

	case "CoreV1PodList.items":
		if e.complexity.CoreV1PodList.Items == nil {
			break
		}

		return e.complexity.CoreV1PodList.Items(childComplexity), true

	case "CoreV1PodList.kind":
		if e.complexity.CoreV1PodList.Kind == nil {
			break
		}

		return e.complexity.CoreV1PodList.Kind(childComplexity), true

	case "CoreV1PodList.metadata":
		if e.complexity.CoreV1PodList.ListMeta == nil {
			break
		}

		return e.complexity.CoreV1PodList.ListMeta(childComplexity), true

	case "CoreV1PodSpec.containers":
		if e.complexity.CoreV1PodSpec.Containers == nil {
			break
		}

		return e.complexity.CoreV1PodSpec.Containers(childComplexity), true

	case "CoreV1PodSpec.hostname":
		if e.complexity.CoreV1PodSpec.Hostname == nil {
			break
		}

		return e.complexity.CoreV1PodSpec.Hostname(childComplexity), true

	case "CoreV1PodSpec.nodeName":
		if e.complexity.CoreV1PodSpec.NodeName == nil {
			break
		}

		return e.complexity.CoreV1PodSpec.NodeName(childComplexity), true

	case "CoreV1PodSpec.priorityClassName":
		if e.complexity.CoreV1PodSpec.PriorityClassName == nil {
			break
		}

		return e.complexity.CoreV1PodSpec.PriorityClassName(childComplexity), true

	case "CoreV1PodStatus.containerStatuses":
		if e.complexity.CoreV1PodStatus.ContainerStatuses == nil {
			break
		}

		return e.complexity.CoreV1PodStatus.ContainerStatuses(childComplexity), true

	case "CoreV1PodStatus.message":
		if e.complexity.CoreV1PodStatus.Message == nil {
			break
		}

		return e.complexity.CoreV1PodStatus.Message(childComplexity), true

	case "CoreV1PodStatus.phase":
		if e.complexity.CoreV1PodStatus.Phase == nil {
			break
		}

		return e.complexity.CoreV1PodStatus.Phase(childComplexity), true

	case "CoreV1PodStatus.reason":
		if e.complexity.CoreV1PodStatus.Reason == nil {
			break
		}

		return e.complexity.CoreV1PodStatus.Reason(childComplexity), true

	case "CoreV1PodsWatchEvent.object":
		if e.complexity.CoreV1PodsWatchEvent.Object == nil {
			break
		}

		return e.complexity.CoreV1PodsWatchEvent.Object(childComplexity), true

	case "CoreV1PodsWatchEvent.type":
		if e.complexity.CoreV1PodsWatchEvent.Type == nil {
			break
		}

		return e.complexity.CoreV1PodsWatchEvent.Type(childComplexity), true

	case "CoreV1Service.apiVersion":
		if e.complexity.CoreV1Service.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1Service.APIVersion(childComplexity), true

	case "CoreV1Service.kind":
		if e.complexity.CoreV1Service.Kind == nil {
			break
		}

		return e.complexity.CoreV1Service.Kind(childComplexity), true

	case "CoreV1Service.metadata":
		if e.complexity.CoreV1Service.ObjectMeta == nil {
			break
		}

		return e.complexity.CoreV1Service.ObjectMeta(childComplexity), true

	case "CoreV1Service.spec":
		if e.complexity.CoreV1Service.Spec == nil {
			break
		}

		return e.complexity.CoreV1Service.Spec(childComplexity), true

	case "CoreV1Service.id":
		if e.complexity.CoreV1Service.UID == nil {
			break
		}

		return e.complexity.CoreV1Service.UID(childComplexity), true

	case "CoreV1ServiceList.apiVersion":
		if e.complexity.CoreV1ServiceList.APIVersion == nil {
			break
		}

		return e.complexity.CoreV1ServiceList.APIVersion(childComplexity), true

	case "CoreV1ServiceList.items":
		if e.complexity.CoreV1ServiceList.Items == nil {
			break
		}

		return e.complexity.CoreV1ServiceList.Items(childComplexity), true

	case "CoreV1ServiceList.kind":
		if e.complexity.CoreV1ServiceList.Kind == nil {
			break
		}

		return e.complexity.CoreV1ServiceList.Kind(childComplexity), true

	case "CoreV1ServiceList.metadata":
		if e.complexity.CoreV1ServiceList.ListMeta == nil {
			break
		}

		return e.complexity.CoreV1ServiceList.ListMeta(childComplexity), true

	case "CoreV1ServicePort.appProtocol":
		if e.complexity.CoreV1ServicePort.AppProtocol == nil {
			break
		}

		return e.complexity.CoreV1ServicePort.AppProtocol(childComplexity), true

	case "CoreV1ServicePort.name":
		if e.complexity.CoreV1ServicePort.Name == nil {
			break
		}

		return e.complexity.CoreV1ServicePort.Name(childComplexity), true

	case "CoreV1ServicePort.port":
		if e.complexity.CoreV1ServicePort.Port == nil {
			break
		}

		return e.complexity.CoreV1ServicePort.Port(childComplexity), true

	case "CoreV1ServiceSpec.clusterIP":
		if e.complexity.CoreV1ServiceSpec.ClusterIP == nil {
			break
		}

		return e.complexity.CoreV1ServiceSpec.ClusterIP(childComplexity), true

	case "CoreV1ServiceSpec.clusterIPs":
		if e.complexity.CoreV1ServiceSpec.ClusterIPs == nil {
			break
		}

		return e.complexity.CoreV1ServiceSpec.ClusterIPs(childComplexity), true

	case "CoreV1ServiceSpec.externalName":
		if e.complexity.CoreV1ServiceSpec.ExternalName == nil {
			break
		}

		return e.complexity.CoreV1ServiceSpec.ExternalName(childComplexity), true

	case "CoreV1ServiceSpec.ports":
		if e.complexity.CoreV1ServiceSpec.Ports == nil {
			break
		}

		return e.complexity.CoreV1ServiceSpec.Ports(childComplexity), true

	case "CoreV1ServiceSpec.selector":
		if e.complexity.CoreV1ServiceSpec.Selector == nil {
			break
		}

		return e.complexity.CoreV1ServiceSpec.Selector(childComplexity), true

	case "CoreV1ServicesWatchEvent.object":
		if e.complexity.CoreV1ServicesWatchEvent.Object == nil {
			break
		}

		return e.complexity.CoreV1ServicesWatchEvent.Object(childComplexity), true

	case "CoreV1ServicesWatchEvent.type":
		if e.complexity.CoreV1ServicesWatchEvent.Type == nil {
			break
		}

		return e.complexity.CoreV1ServicesWatchEvent.Type(childComplexity), true

	case "HealthCheckResponse.message":
		if e.complexity.HealthCheckResponse.Message == nil {
			break
		}

		return e.complexity.HealthCheckResponse.Message(childComplexity), true

	case "HealthCheckResponse.status":
		if e.complexity.HealthCheckResponse.Status == nil {
			break
		}

		return e.complexity.HealthCheckResponse.Status(childComplexity), true

	case "HealthCheckResponse.timestamp":
		if e.complexity.HealthCheckResponse.Timestamp == nil {
			break
		}

		return e.complexity.HealthCheckResponse.Timestamp(childComplexity), true

	case "HelmChart.metadata":
		if e.complexity.HelmChart.Metadata == nil {
			break
		}

		return e.complexity.HelmChart.Metadata(childComplexity), true

	case "HelmChartMetadata.appVersion":
		if e.complexity.HelmChartMetadata.AppVersion == nil {
			break
		}

		return e.complexity.HelmChartMetadata.AppVersion(childComplexity), true

	case "HelmChartMetadata.condition":
		if e.complexity.HelmChartMetadata.Condition == nil {
			break
		}

		return e.complexity.HelmChartMetadata.Condition(childComplexity), true

	case "HelmChartMetadata.name":
		if e.complexity.HelmChartMetadata.Name == nil {
			break
		}

		return e.complexity.HelmChartMetadata.Name(childComplexity), true

	case "HelmChartMetadata.version":
		if e.complexity.HelmChartMetadata.Version == nil {
			break
		}

		return e.complexity.HelmChartMetadata.Version(childComplexity), true

	case "HelmRelease.chart":
		if e.complexity.HelmRelease.Chart == nil {
			break
		}

		return e.complexity.HelmRelease.Chart(childComplexity), true

	case "HelmRelease.name":
		if e.complexity.HelmRelease.Name == nil {
			break
		}

		return e.complexity.HelmRelease.Name(childComplexity), true

	case "HelmRelease.namespace":
		if e.complexity.HelmRelease.Namespace == nil {
			break
		}

		return e.complexity.HelmRelease.Namespace(childComplexity), true

	case "HelmRelease.version":
		if e.complexity.HelmRelease.Version == nil {
			break
		}

		return e.complexity.HelmRelease.Version(childComplexity), true

	case "KubeConfig.authInfos":
		if e.complexity.KubeConfig.AuthInfos == nil {
			break
		}

		return e.complexity.KubeConfig.AuthInfos(childComplexity), true

	case "KubeConfig.clusters":
		if e.complexity.KubeConfig.Clusters == nil {
			break
		}

		return e.complexity.KubeConfig.Clusters(childComplexity), true

	case "KubeConfig.contexts":
		if e.complexity.KubeConfig.Contexts == nil {
			break
		}

		return e.complexity.KubeConfig.Contexts(childComplexity), true

	case "KubeConfig.currentContext":
		if e.complexity.KubeConfig.CurrentContext == nil {
			break
		}

		return e.complexity.KubeConfig.CurrentContext(childComplexity), true

	case "KubeConfig.extensions":
		if e.complexity.KubeConfig.Extensions == nil {
			break
		}

		return e.complexity.KubeConfig.Extensions(childComplexity), true

	case "KubeConfigAuthInfo.extensions":
		if e.complexity.KubeConfigAuthInfo.Extensions == nil {
			break
		}

		return e.complexity.KubeConfigAuthInfo.Extensions(childComplexity), true

	case "KubeConfigAuthInfo.locationOfOrigin":
		if e.complexity.KubeConfigAuthInfo.LocationOfOrigin == nil {
			break
		}

		return e.complexity.KubeConfigAuthInfo.LocationOfOrigin(childComplexity), true

	case "KubeConfigAuthInfo.name":
		if e.complexity.KubeConfigAuthInfo.Name == nil {
			break
		}

		return e.complexity.KubeConfigAuthInfo.Name(childComplexity), true

	case "KubeConfigCluster.extensions":
		if e.complexity.KubeConfigCluster.Extensions == nil {
			break
		}

		return e.complexity.KubeConfigCluster.Extensions(childComplexity), true

	case "KubeConfigCluster.locationOfOrigin":
		if e.complexity.KubeConfigCluster.LocationOfOrigin == nil {
			break
		}

		return e.complexity.KubeConfigCluster.LocationOfOrigin(childComplexity), true

	case "KubeConfigCluster.name":
		if e.complexity.KubeConfigCluster.Name == nil {
			break
		}

		return e.complexity.KubeConfigCluster.Name(childComplexity), true

	case "KubeConfigCluster.server":
		if e.complexity.KubeConfigCluster.Server == nil {
			break
		}

		return e.complexity.KubeConfigCluster.Server(childComplexity), true

	case "KubeConfigContext.authInfo":
		if e.complexity.KubeConfigContext.AuthInfo == nil {
			break
		}

		return e.complexity.KubeConfigContext.AuthInfo(childComplexity), true

	case "KubeConfigContext.cluster":
		if e.complexity.KubeConfigContext.Cluster == nil {
			break
		}

		return e.complexity.KubeConfigContext.Cluster(childComplexity), true

	case "KubeConfigContext.extensions":
		if e.complexity.KubeConfigContext.Extensions == nil {
			break
		}

		return e.complexity.KubeConfigContext.Extensions(childComplexity), true

	case "KubeConfigContext.locationOfOrigin":
		if e.complexity.KubeConfigContext.LocationOfOrigin == nil {
			break
		}

		return e.complexity.KubeConfigContext.LocationOfOrigin(childComplexity), true

	case "KubeConfigContext.name":
		if e.complexity.KubeConfigContext.Name == nil {
			break
		}

		return e.complexity.KubeConfigContext.Name(childComplexity), true

	case "KubeConfigContext.namespace":
		if e.complexity.KubeConfigContext.Namespace == nil {
			break
		}

		return e.complexity.KubeConfigContext.Namespace(childComplexity), true

	case "KubeConfigWatchEvent.object":
		if e.complexity.KubeConfigWatchEvent.Object == nil {
			break
		}

		return e.complexity.KubeConfigWatchEvent.Object(childComplexity), true

	case "KubeConfigWatchEvent.type":
		if e.complexity.KubeConfigWatchEvent.Type == nil {
			break
		}

		return e.complexity.KubeConfigWatchEvent.Type(childComplexity), true

	case "LogRecord.message":
		if e.complexity.LogRecord.Message == nil {
			break
		}

		return e.complexity.LogRecord.Message(childComplexity), true

	case "LogRecord.source":
		if e.complexity.LogRecord.Source == nil {
			break
		}

		return e.complexity.LogRecord.Source(childComplexity), true

	case "LogRecord.timestamp":
		if e.complexity.LogRecord.Timestamp == nil {
			break
		}

		return e.complexity.LogRecord.Timestamp(childComplexity), true

	case "LogRecordsQueryResponse.nextCursor":
		if e.complexity.LogRecordsQueryResponse.NextCursor == nil {
			break
		}

		return e.complexity.LogRecordsQueryResponse.NextCursor(childComplexity), true

	case "LogRecordsQueryResponse.records":
		if e.complexity.LogRecordsQueryResponse.Records == nil {
			break
		}

		return e.complexity.LogRecordsQueryResponse.Records(childComplexity), true

	case "LogSource.containerID":
		if e.complexity.LogSource.ContainerID == nil {
			break
		}

		return e.complexity.LogSource.ContainerID(childComplexity), true

	case "LogSource.containerName":
		if e.complexity.LogSource.ContainerName == nil {
			break
		}

		return e.complexity.LogSource.ContainerName(childComplexity), true

	case "LogSource.metadata":
		if e.complexity.LogSource.Metadata == nil {
			break
		}

		return e.complexity.LogSource.Metadata(childComplexity), true

	case "LogSource.namespace":
		if e.complexity.LogSource.Namespace == nil {
			break
		}

		return e.complexity.LogSource.Namespace(childComplexity), true

	case "LogSource.podName":
		if e.complexity.LogSource.PodName == nil {
			break
		}

		return e.complexity.LogSource.PodName(childComplexity), true

	case "LogSourceMetadata.arch":
		if e.complexity.LogSourceMetadata.Arch == nil {
			break
		}

		return e.complexity.LogSourceMetadata.Arch(childComplexity), true

	case "LogSourceMetadata.node":
		if e.complexity.LogSourceMetadata.Node == nil {
			break
		}

		return e.complexity.LogSourceMetadata.Node(childComplexity), true

	case "LogSourceMetadata.os":
		if e.complexity.LogSourceMetadata.OS == nil {
			break
		}

		return e.complexity.LogSourceMetadata.OS(childComplexity), true

	case "LogSourceMetadata.region":
		if e.complexity.LogSourceMetadata.Region == nil {
			break
		}

		return e.complexity.LogSourceMetadata.Region(childComplexity), true

	case "LogSourceMetadata.zone":
		if e.complexity.LogSourceMetadata.Zone == nil {
			break
		}

		return e.complexity.LogSourceMetadata.Zone(childComplexity), true

	case "LogSourceWatchEvent.object":
		if e.complexity.LogSourceWatchEvent.Object == nil {
			break
		}

		return e.complexity.LogSourceWatchEvent.Object(childComplexity), true

	case "LogSourceWatchEvent.type":
		if e.complexity.LogSourceWatchEvent.Type == nil {
			break
		}

		return e.complexity.LogSourceWatchEvent.Type(childComplexity), true

	case "MetaV1LabelSelector.matchExpressions":
		if e.complexity.MetaV1LabelSelector.MatchExpressions == nil {
			break
		}

		return e.complexity.MetaV1LabelSelector.MatchExpressions(childComplexity), true

	case "MetaV1LabelSelector.matchLabels":
		if e.complexity.MetaV1LabelSelector.MatchLabels == nil {
			break
		}

		return e.complexity.MetaV1LabelSelector.MatchLabels(childComplexity), true

	case "MetaV1LabelSelectorRequirement.key":
		if e.complexity.MetaV1LabelSelectorRequirement.Key == nil {
			break
		}

		return e.complexity.MetaV1LabelSelectorRequirement.Key(childComplexity), true

	case "MetaV1LabelSelectorRequirement.operator":
		if e.complexity.MetaV1LabelSelectorRequirement.Operator == nil {
			break
		}

		return e.complexity.MetaV1LabelSelectorRequirement.Operator(childComplexity), true

	case "MetaV1LabelSelectorRequirement.values":
		if e.complexity.MetaV1LabelSelectorRequirement.Values == nil {
			break
		}

		return e.complexity.MetaV1LabelSelectorRequirement.Values(childComplexity), true

	case "MetaV1ListMeta.continue":
		if e.complexity.MetaV1ListMeta.Continue == nil {
			break
		}

		return e.complexity.MetaV1ListMeta.Continue(childComplexity), true

	case "MetaV1ListMeta.remainingItemCount":
		if e.complexity.MetaV1ListMeta.RemainingItemCount == nil {
			break
		}

		return e.complexity.MetaV1ListMeta.RemainingItemCount(childComplexity), true

	case "MetaV1ListMeta.resourceVersion":
		if e.complexity.MetaV1ListMeta.ResourceVersion == nil {
			break
		}

		return e.complexity.MetaV1ListMeta.ResourceVersion(childComplexity), true

	case "MetaV1ObjectMeta.annotations":
		if e.complexity.MetaV1ObjectMeta.Annotations == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.Annotations(childComplexity), true

	case "MetaV1ObjectMeta.creationTimestamp":
		if e.complexity.MetaV1ObjectMeta.CreationTimestamp == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.CreationTimestamp(childComplexity), true

	case "MetaV1ObjectMeta.deletionTimestamp":
		if e.complexity.MetaV1ObjectMeta.DeletionTimestamp == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.DeletionTimestamp(childComplexity), true

	case "MetaV1ObjectMeta.labels":
		if e.complexity.MetaV1ObjectMeta.Labels == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.Labels(childComplexity), true

	case "MetaV1ObjectMeta.name":
		if e.complexity.MetaV1ObjectMeta.Name == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.Name(childComplexity), true

	case "MetaV1ObjectMeta.namespace":
		if e.complexity.MetaV1ObjectMeta.Namespace == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.Namespace(childComplexity), true

	case "MetaV1ObjectMeta.ownerReferences":
		if e.complexity.MetaV1ObjectMeta.OwnerReferences == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.OwnerReferences(childComplexity), true

	case "MetaV1ObjectMeta.resourceVersion":
		if e.complexity.MetaV1ObjectMeta.ResourceVersion == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.ResourceVersion(childComplexity), true

	case "MetaV1ObjectMeta.uid":
		if e.complexity.MetaV1ObjectMeta.UID == nil {
			break
		}

		return e.complexity.MetaV1ObjectMeta.UID(childComplexity), true

	case "MetaV1OwnerReference.apiVersion":
		if e.complexity.MetaV1OwnerReference.APIVersion == nil {
			break
		}

		return e.complexity.MetaV1OwnerReference.APIVersion(childComplexity), true

	case "MetaV1OwnerReference.controller":
		if e.complexity.MetaV1OwnerReference.Controller == nil {
			break
		}

		return e.complexity.MetaV1OwnerReference.Controller(childComplexity), true

	case "MetaV1OwnerReference.kind":
		if e.complexity.MetaV1OwnerReference.Kind == nil {
			break
		}

		return e.complexity.MetaV1OwnerReference.Kind(childComplexity), true

	case "MetaV1OwnerReference.name":
		if e.complexity.MetaV1OwnerReference.Name == nil {
			break
		}

		return e.complexity.MetaV1OwnerReference.Name(childComplexity), true

	case "MetaV1OwnerReference.uid":
		if e.complexity.MetaV1OwnerReference.UID == nil {
			break
		}

		return e.complexity.MetaV1OwnerReference.UID(childComplexity), true

	case "Mutation.helmInstallLatest":
		if e.complexity.Mutation.HelmInstallLatest == nil {
			break
		}

		args, err := ec.field_Mutation_helmInstallLatest_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Mutation.HelmInstallLatest(childComplexity, args["kubeContext"].(*string)), true

	case "PageInfo.endCursor":
		if e.complexity.PageInfo.EndCursor == nil {
			break
		}

		return e.complexity.PageInfo.EndCursor(childComplexity), true

	case "PageInfo.hasNextPage":
		if e.complexity.PageInfo.HasNextPage == nil {
			break
		}

		return e.complexity.PageInfo.HasNextPage(childComplexity), true

	case "PageInfo.hasPreviousPage":
		if e.complexity.PageInfo.HasPreviousPage == nil {
			break
		}

		return e.complexity.PageInfo.HasPreviousPage(childComplexity), true

	case "PageInfo.startCursor":
		if e.complexity.PageInfo.StartCursor == nil {
			break
		}

		return e.complexity.PageInfo.StartCursor(childComplexity), true

	case "Query.appsV1DaemonSetsGet":
		if e.complexity.Query.AppsV1DaemonSetsGet == nil {
			break
		}

		args, err := ec.field_Query_appsV1DaemonSetsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1DaemonSetsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.appsV1DaemonSetsList":
		if e.complexity.Query.AppsV1DaemonSetsList == nil {
			break
		}

		args, err := ec.field_Query_appsV1DaemonSetsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1DaemonSetsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.appsV1DeploymentsGet":
		if e.complexity.Query.AppsV1DeploymentsGet == nil {
			break
		}

		args, err := ec.field_Query_appsV1DeploymentsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1DeploymentsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.appsV1DeploymentsList":
		if e.complexity.Query.AppsV1DeploymentsList == nil {
			break
		}

		args, err := ec.field_Query_appsV1DeploymentsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1DeploymentsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.appsV1ReplicaSetsGet":
		if e.complexity.Query.AppsV1ReplicaSetsGet == nil {
			break
		}

		args, err := ec.field_Query_appsV1ReplicaSetsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1ReplicaSetsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.appsV1ReplicaSetsList":
		if e.complexity.Query.AppsV1ReplicaSetsList == nil {
			break
		}

		args, err := ec.field_Query_appsV1ReplicaSetsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1ReplicaSetsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.appsV1StatefulSetsGet":
		if e.complexity.Query.AppsV1StatefulSetsGet == nil {
			break
		}

		args, err := ec.field_Query_appsV1StatefulSetsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1StatefulSetsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.appsV1StatefulSetsList":
		if e.complexity.Query.AppsV1StatefulSetsList == nil {
			break
		}

		args, err := ec.field_Query_appsV1StatefulSetsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.AppsV1StatefulSetsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.batchV1CronJobsGet":
		if e.complexity.Query.BatchV1CronJobsGet == nil {
			break
		}

		args, err := ec.field_Query_batchV1CronJobsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.BatchV1CronJobsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.batchV1CronJobsList":
		if e.complexity.Query.BatchV1CronJobsList == nil {
			break
		}

		args, err := ec.field_Query_batchV1CronJobsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.BatchV1CronJobsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.batchV1JobsGet":
		if e.complexity.Query.BatchV1JobsGet == nil {
			break
		}

		args, err := ec.field_Query_batchV1JobsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.BatchV1JobsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.batchV1JobsList":
		if e.complexity.Query.BatchV1JobsList == nil {
			break
		}

		args, err := ec.field_Query_batchV1JobsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.BatchV1JobsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.clusterAPIHealthzGet":
		if e.complexity.Query.ClusterAPIHealthzGet == nil {
			break
		}

		args, err := ec.field_Query_clusterAPIHealthzGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.ClusterAPIHealthzGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["serviceName"].(*string)), true

	case "Query.clusterAPIReadyWait":
		if e.complexity.Query.ClusterAPIReadyWait == nil {
			break
		}

		args, err := ec.field_Query_clusterAPIReadyWait_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.ClusterAPIReadyWait(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["serviceName"].(*string)), true

	case "Query.clusterAPIServicesList":
		if e.complexity.Query.ClusterAPIServicesList == nil {
			break
		}

		args, err := ec.field_Query_clusterAPIServicesList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.ClusterAPIServicesList(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.coreV1NamespacesList":
		if e.complexity.Query.CoreV1NamespacesList == nil {
			break
		}

		args, err := ec.field_Query_coreV1NamespacesList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1NamespacesList(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.coreV1NodesList":
		if e.complexity.Query.CoreV1NodesList == nil {
			break
		}

		args, err := ec.field_Query_coreV1NodesList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1NodesList(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.coreV1PodsGet":
		if e.complexity.Query.CoreV1PodsGet == nil {
			break
		}

		args, err := ec.field_Query_coreV1PodsGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1PodsGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.coreV1PodsList":
		if e.complexity.Query.CoreV1PodsList == nil {
			break
		}

		args, err := ec.field_Query_coreV1PodsList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1PodsList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.coreV1ServicesGet":
		if e.complexity.Query.CoreV1ServicesGet == nil {
			break
		}

		args, err := ec.field_Query_coreV1ServicesGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1ServicesGet(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["name"].(string), args["options"].(*v1.GetOptions)), true

	case "Query.coreV1ServicesList":
		if e.complexity.Query.CoreV1ServicesList == nil {
			break
		}

		args, err := ec.field_Query_coreV1ServicesList_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.CoreV1ServicesList(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Query.helmListReleases":
		if e.complexity.Query.HelmListReleases == nil {
			break
		}

		args, err := ec.field_Query_helmListReleases_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.HelmListReleases(childComplexity, args["kubeContext"].(*string)), true

	case "Query.kubeConfigGet":
		if e.complexity.Query.KubeConfigGet == nil {
			break
		}

		return e.complexity.Query.KubeConfigGet(childComplexity), true

	case "Query.kubernetesAPIHealthzGet":
		if e.complexity.Query.KubernetesAPIHealthzGet == nil {
			break
		}

		args, err := ec.field_Query_kubernetesAPIHealthzGet_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.KubernetesAPIHealthzGet(childComplexity, args["kubeContext"].(*string)), true

	case "Query.kubernetesAPIReadyWait":
		if e.complexity.Query.KubernetesAPIReadyWait == nil {
			break
		}

		args, err := ec.field_Query_kubernetesAPIReadyWait_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.KubernetesAPIReadyWait(childComplexity, args["kubeContext"].(*string)), true

	case "Query.logRecordsFetch":
		if e.complexity.Query.LogRecordsFetch == nil {
			break
		}

		args, err := ec.field_Query_logRecordsFetch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Query.LogRecordsFetch(childComplexity, args["kubeContext"].(*string), args["sources"].([]string), args["mode"].(*model.LogRecordsQueryMode), args["since"].(*string), args["until"].(*string), args["after"].(*string), args["before"].(*string), args["grep"].(*string), args["sourceFilter"].(*model.LogSourceFilter), args["limit"].(*int)), true

	case "Subscription.appsV1DaemonSetsWatch":
		if e.complexity.Subscription.AppsV1DaemonSetsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_appsV1DaemonSetsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.AppsV1DaemonSetsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.appsV1DeploymentsWatch":
		if e.complexity.Subscription.AppsV1DeploymentsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_appsV1DeploymentsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.AppsV1DeploymentsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.appsV1ReplicaSetsWatch":
		if e.complexity.Subscription.AppsV1ReplicaSetsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_appsV1ReplicaSetsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.AppsV1ReplicaSetsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.appsV1StatefulSetsWatch":
		if e.complexity.Subscription.AppsV1StatefulSetsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_appsV1StatefulSetsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.AppsV1StatefulSetsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.batchV1CronJobsWatch":
		if e.complexity.Subscription.BatchV1CronJobsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_batchV1CronJobsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.BatchV1CronJobsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.batchV1JobsWatch":
		if e.complexity.Subscription.BatchV1JobsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_batchV1JobsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.BatchV1JobsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.clusterAPIHealthzWatch":
		if e.complexity.Subscription.ClusterAPIHealthzWatch == nil {
			break
		}

		args, err := ec.field_Subscription_clusterAPIHealthzWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.ClusterAPIHealthzWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["serviceName"].(*string)), true

	case "Subscription.clusterAPIReadyWait":
		if e.complexity.Subscription.ClusterAPIReadyWait == nil {
			break
		}

		args, err := ec.field_Subscription_clusterAPIReadyWait_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.ClusterAPIReadyWait(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["serviceName"].(*string)), true

	case "Subscription.clusterAPIServicesWatch":
		if e.complexity.Subscription.ClusterAPIServicesWatch == nil {
			break
		}

		args, err := ec.field_Subscription_clusterAPIServicesWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.ClusterAPIServicesWatch(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.coreV1NamespacesWatch":
		if e.complexity.Subscription.CoreV1NamespacesWatch == nil {
			break
		}

		args, err := ec.field_Subscription_coreV1NamespacesWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.CoreV1NamespacesWatch(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.coreV1NodesWatch":
		if e.complexity.Subscription.CoreV1NodesWatch == nil {
			break
		}

		args, err := ec.field_Subscription_coreV1NodesWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.CoreV1NodesWatch(childComplexity, args["kubeContext"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.coreV1PodsWatch":
		if e.complexity.Subscription.CoreV1PodsWatch == nil {
			break
		}

		args, err := ec.field_Subscription_coreV1PodsWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.CoreV1PodsWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.coreV1ServicesWatch":
		if e.complexity.Subscription.CoreV1ServicesWatch == nil {
			break
		}

		args, err := ec.field_Subscription_coreV1ServicesWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.CoreV1ServicesWatch(childComplexity, args["kubeContext"].(*string), args["namespace"].(*string), args["options"].(*v1.ListOptions)), true

	case "Subscription.kubeConfigWatch":
		if e.complexity.Subscription.KubeConfigWatch == nil {
			break
		}

		return e.complexity.Subscription.KubeConfigWatch(childComplexity), true

	case "Subscription.kubernetesAPIHealthzWatch":
		if e.complexity.Subscription.KubernetesAPIHealthzWatch == nil {
			break
		}

		args, err := ec.field_Subscription_kubernetesAPIHealthzWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.KubernetesAPIHealthzWatch(childComplexity, args["kubeContext"].(*string)), true

	case "Subscription.kubernetesAPIReadyWait":
		if e.complexity.Subscription.KubernetesAPIReadyWait == nil {
			break
		}

		args, err := ec.field_Subscription_kubernetesAPIReadyWait_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.KubernetesAPIReadyWait(childComplexity, args["kubeContext"].(*string)), true

	case "Subscription.logRecordsFollow":
		if e.complexity.Subscription.LogRecordsFollow == nil {
			break
		}

		args, err := ec.field_Subscription_logRecordsFollow_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.LogRecordsFollow(childComplexity, args["kubeContext"].(*string), args["sources"].([]string), args["since"].(*string), args["after"].(*string), args["grep"].(*string), args["sourceFilter"].(*model.LogSourceFilter)), true

	case "Subscription.logSourcesWatch":
		if e.complexity.Subscription.LogSourcesWatch == nil {
			break
		}

		args, err := ec.field_Subscription_logSourcesWatch_args(ctx, rawArgs)
		if err != nil {
			return 0, false
		}

		return e.complexity.Subscription.LogSourcesWatch(childComplexity, args["kubeContext"].(*string), args["sources"].([]string)), true

	}
	return 0, false
}

func (e *executableSchema) Exec(ctx context.Context) graphql.ResponseHandler {
	opCtx := graphql.GetOperationContext(ctx)
	ec := executionContext{opCtx, e, 0, 0, make(chan graphql.DeferredResult)}
	inputUnmarshalMap := graphql.BuildUnmarshalerMap(
		ec.unmarshalInputLogSourceFilter,
		ec.unmarshalInputMetaV1GetOptions,
		ec.unmarshalInputMetaV1ListOptions,
	)
	first := true

	switch opCtx.Operation.Operation {
	case ast.Query:
		return func(ctx context.Context) *graphql.Response {
			var response graphql.Response
			var data graphql.Marshaler
			if first {
				first = false
				ctx = graphql.WithUnmarshalerMap(ctx, inputUnmarshalMap)
				data = ec._Query(ctx, opCtx.Operation.SelectionSet)
			} else {
				if atomic.LoadInt32(&ec.pendingDeferred) > 0 {
					result := <-ec.deferredResults
					atomic.AddInt32(&ec.pendingDeferred, -1)
					data = result.Result
					response.Path = result.Path
					response.Label = result.Label
					response.Errors = result.Errors
				} else {
					return nil
				}
			}
			var buf bytes.Buffer
			data.MarshalGQL(&buf)
			response.Data = buf.Bytes()
			if atomic.LoadInt32(&ec.deferred) > 0 {
				hasNext := atomic.LoadInt32(&ec.pendingDeferred) > 0
				response.HasNext = &hasNext
			}

			return &response
		}
	case ast.Mutation:
		return func(ctx context.Context) *graphql.Response {
			if !first {
				return nil
			}
			first = false
			ctx = graphql.WithUnmarshalerMap(ctx, inputUnmarshalMap)
			data := ec._Mutation(ctx, opCtx.Operation.SelectionSet)
			var buf bytes.Buffer
			data.MarshalGQL(&buf)

			return &graphql.Response{
				Data: buf.Bytes(),
			}
		}
	case ast.Subscription:
		next := ec._Subscription(ctx, opCtx.Operation.SelectionSet)

		var buf bytes.Buffer
		return func(ctx context.Context) *graphql.Response {
			buf.Reset()
			data := next(ctx)

			if data == nil {
				return nil
			}
			data.MarshalGQL(&buf)

			return &graphql.Response{
				Data: buf.Bytes(),
			}
		}

	default:
		return graphql.OneShot(graphql.ErrorResponse(ctx, "unsupported GraphQL operation"))
	}
}

type executionContext struct {
	*graphql.OperationContext
	*executableSchema
	deferred        int32
	pendingDeferred int32
	deferredResults chan graphql.DeferredResult
}

func (ec *executionContext) processDeferredGroup(dg graphql.DeferredGroup) {
	atomic.AddInt32(&ec.pendingDeferred, 1)
	go func() {
		ctx := graphql.WithFreshResponseContext(dg.Context)
		dg.FieldSet.Dispatch(ctx)
		ds := graphql.DeferredResult{
			Path:   dg.Path,
			Label:  dg.Label,
			Result: dg.FieldSet,
			Errors: graphql.GetErrors(ctx),
		}
		// null fields should bubble up
		if dg.FieldSet.Invalids > 0 {
			ds.Result = graphql.Null
		}
		ec.deferredResults <- ds
	}()
}

func (ec *executionContext) introspectSchema() (*introspection.Schema, error) {
	if ec.DisableIntrospection {
		return nil, errors.New("introspection disabled")
	}
	return introspection.WrapSchema(ec.Schema()), nil
}

func (ec *executionContext) introspectType(name string) (*introspection.Type, error) {
	if ec.DisableIntrospection {
		return nil, errors.New("introspection disabled")
	}
	return introspection.WrapTypeFromDef(ec.Schema(), ec.Schema().Types[name]), nil
}

//go:embed "schema.graphqls"
var sourcesFS embed.FS

func sourceData(filename string) string {
	data, err := sourcesFS.ReadFile(filename)
	if err != nil {
		panic(fmt.Sprintf("codegen problem: %s not available", filename))
	}
	return string(data)
}

var sources = []*ast.Source{
	{Name: "schema.graphqls", Input: sourceData("schema.graphqls"), BuiltIn: false},
}
var parsedSchema = gqlparser.MustLoadSchema(sources...)

// endregion ************************** generated!.gotpl **************************

// region    ***************************** args.gotpl *****************************

func (ec *executionContext) dir_validate_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.dir_validate_argsRule(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["rule"] = arg0
	arg1, err := ec.dir_validate_argsMessage(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["message"] = arg1
	return args, nil
}
func (ec *executionContext) dir_validate_argsRule(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	if _, ok := rawArgs["rule"]; !ok {
		var zeroVal string
		return zeroVal, nil
	}

	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("rule"))
	if tmp, ok := rawArgs["rule"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) dir_validate_argsMessage(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	if _, ok := rawArgs["message"]; !ok {
		var zeroVal *string
		return zeroVal, nil
	}

	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("message"))
	if tmp, ok := rawArgs["message"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Mutation_helmInstallLatest_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Mutation_helmInstallLatest_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Mutation_helmInstallLatest_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query___type_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query___type_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg0
	return args, nil
}
func (ec *executionContext) field_Query___type_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1DaemonSetsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1DaemonSetsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1DaemonSetsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_appsV1DaemonSetsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_appsV1DaemonSetsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1DaemonSetsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1DaemonSetsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1DaemonSetsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_appsV1DaemonSetsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DaemonSetsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1DeploymentsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1DeploymentsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1DeploymentsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_appsV1DeploymentsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_appsV1DeploymentsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1DeploymentsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1DeploymentsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1DeploymentsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_appsV1DeploymentsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1DeploymentsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1ReplicaSetsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1ReplicaSetsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1ReplicaSetsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_appsV1ReplicaSetsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_appsV1ReplicaSetsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1ReplicaSetsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1ReplicaSetsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1ReplicaSetsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_appsV1ReplicaSetsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1ReplicaSetsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1StatefulSetsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1StatefulSetsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1StatefulSetsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_appsV1StatefulSetsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_appsV1StatefulSetsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_appsV1StatefulSetsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_appsV1StatefulSetsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_appsV1StatefulSetsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_appsV1StatefulSetsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_appsV1StatefulSetsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_batchV1CronJobsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_batchV1CronJobsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_batchV1CronJobsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_batchV1CronJobsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_batchV1CronJobsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_batchV1CronJobsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_batchV1CronJobsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_batchV1CronJobsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_batchV1CronJobsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1CronJobsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_batchV1JobsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_batchV1JobsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_batchV1JobsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_batchV1JobsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_batchV1JobsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_batchV1JobsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_batchV1JobsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_batchV1JobsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_batchV1JobsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_batchV1JobsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIHealthzGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_clusterAPIHealthzGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_clusterAPIHealthzGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_clusterAPIHealthzGet_argsServiceName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["serviceName"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_clusterAPIHealthzGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIHealthzGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIHealthzGet_argsServiceName(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("serviceName"))
	if tmp, ok := rawArgs["serviceName"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIReadyWait_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_clusterAPIReadyWait_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_clusterAPIReadyWait_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_clusterAPIReadyWait_argsServiceName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["serviceName"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_clusterAPIReadyWait_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIReadyWait_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIReadyWait_argsServiceName(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("serviceName"))
	if tmp, ok := rawArgs["serviceName"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIServicesList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_clusterAPIServicesList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_clusterAPIServicesList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Query_clusterAPIServicesList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_clusterAPIServicesList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1NamespacesList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1NamespacesList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1NamespacesList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Query_coreV1NamespacesList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1NamespacesList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1NodesList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1NodesList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1NodesList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Query_coreV1NodesList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1NodesList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1PodsGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1PodsGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_coreV1PodsGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_coreV1PodsGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_coreV1PodsGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1PodsList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1PodsList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_coreV1PodsList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_coreV1PodsList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1PodsList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1ServicesGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1ServicesGet_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_coreV1ServicesGet_argsName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["name"] = arg2
	arg3, err := ec.field_Query_coreV1ServicesGet_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg3
	return args, nil
}
func (ec *executionContext) field_Query_coreV1ServicesGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesGet_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesGet_argsName(
	ctx context.Context,
	rawArgs map[string]any,
) (string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("name"))
	if tmp, ok := rawArgs["name"]; ok {
		return ec.unmarshalNString2string(ctx, tmp)
	}

	var zeroVal string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesGet_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.GetOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1GetOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐGetOptions(ctx, tmp)
	}

	var zeroVal *v1.GetOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesList_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_coreV1ServicesList_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_coreV1ServicesList_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Query_coreV1ServicesList_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Query_coreV1ServicesList_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesList_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_coreV1ServicesList_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Query_helmListReleases_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_helmListReleases_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Query_helmListReleases_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_kubernetesAPIHealthzGet_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_kubernetesAPIHealthzGet_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Query_kubernetesAPIHealthzGet_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_kubernetesAPIReadyWait_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_kubernetesAPIReadyWait_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Query_kubernetesAPIReadyWait_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Query_logRecordsFetch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Query_logRecordsFetch_argsSources(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["sources"] = arg1
	arg2, err := ec.field_Query_logRecordsFetch_argsMode(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["mode"] = arg2
	arg3, err := ec.field_Query_logRecordsFetch_argsSince(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["since"] = arg3
	arg4, err := ec.field_Query_logRecordsFetch_argsUntil(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["until"] = arg4
	arg5, err := ec.field_Query_logRecordsFetch_argsAfter(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["after"] = arg5
	arg6, err := ec.field_Query_logRecordsFetch_argsBefore(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["before"] = arg6
	arg7, err := ec.field_Query_logRecordsFetch_argsGrep(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["grep"] = arg7
	arg8, err := ec.field_Query_logRecordsFetch_argsSourceFilter(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["sourceFilter"] = arg8
	arg9, err := ec.field_Query_logRecordsFetch_argsLimit(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["limit"] = arg9
	return args, nil
}
func (ec *executionContext) field_Query_logRecordsFetch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsSources(
	ctx context.Context,
	rawArgs map[string]any,
) ([]string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("sources"))
	if tmp, ok := rawArgs["sources"]; ok {
		return ec.unmarshalNString2ᚕstringᚄ(ctx, tmp)
	}

	var zeroVal []string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsMode(
	ctx context.Context,
	rawArgs map[string]any,
) (*model.LogRecordsQueryMode, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("mode"))
	if tmp, ok := rawArgs["mode"]; ok {
		return ec.unmarshalOLogRecordsQueryMode2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐLogRecordsQueryMode(ctx, tmp)
	}

	var zeroVal *model.LogRecordsQueryMode
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsSince(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("since"))
	if tmp, ok := rawArgs["since"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsUntil(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("until"))
	if tmp, ok := rawArgs["until"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsAfter(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("after"))
	if tmp, ok := rawArgs["after"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsBefore(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("before"))
	if tmp, ok := rawArgs["before"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsGrep(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("grep"))
	if tmp, ok := rawArgs["grep"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsSourceFilter(
	ctx context.Context,
	rawArgs map[string]any,
) (*model.LogSourceFilter, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("sourceFilter"))
	if tmp, ok := rawArgs["sourceFilter"]; ok {
		return ec.unmarshalOLogSourceFilter2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐLogSourceFilter(ctx, tmp)
	}

	var zeroVal *model.LogSourceFilter
	return zeroVal, nil
}

func (ec *executionContext) field_Query_logRecordsFetch_argsLimit(
	ctx context.Context,
	rawArgs map[string]any,
) (*int, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("limit"))
	directive0 := func(ctx context.Context) (any, error) {
		tmp, ok := rawArgs["limit"]
		if !ok {
			var zeroVal *int
			return zeroVal, nil
		}
		return ec.unmarshalOInt2ᚖint(ctx, tmp)
	}

	directive1 := func(ctx context.Context) (any, error) {
		rule, err := ec.unmarshalNString2string(ctx, "gt=0")
		if err != nil {
			var zeroVal *int
			return zeroVal, err
		}
		message, err := ec.unmarshalOString2ᚖstring(ctx, "Value must be > 0")
		if err != nil {
			var zeroVal *int
			return zeroVal, err
		}
		if ec.directives.Validate == nil {
			var zeroVal *int
			return zeroVal, errors.New("directive validate is not implemented")
		}
		return ec.directives.Validate(ctx, rawArgs, directive0, rule, message)
	}

	tmp, err := directive1(ctx)
	if err != nil {
		var zeroVal *int
		return zeroVal, graphql.ErrorOnPath(ctx, err)
	}
	if data, ok := tmp.(*int); ok {
		return data, nil
	} else if tmp == nil {
		var zeroVal *int
		return zeroVal, nil
	} else {
		var zeroVal *int
		return zeroVal, graphql.ErrorOnPath(ctx, fmt.Errorf(`unexpected type %T from directive, should be *int`, tmp))
	}
}

func (ec *executionContext) field_Subscription_appsV1DaemonSetsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_appsV1DaemonSetsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_appsV1DaemonSetsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_appsV1DaemonSetsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_appsV1DaemonSetsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1DaemonSetsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1DaemonSetsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1DeploymentsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_appsV1DeploymentsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_appsV1DeploymentsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_appsV1DeploymentsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_appsV1DeploymentsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1DeploymentsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1DeploymentsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1ReplicaSetsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_appsV1ReplicaSetsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_appsV1ReplicaSetsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_appsV1ReplicaSetsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_appsV1ReplicaSetsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1ReplicaSetsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1ReplicaSetsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1StatefulSetsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_appsV1StatefulSetsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_appsV1StatefulSetsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_appsV1StatefulSetsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_appsV1StatefulSetsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1StatefulSetsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_appsV1StatefulSetsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1CronJobsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_batchV1CronJobsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_batchV1CronJobsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_batchV1CronJobsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_batchV1CronJobsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1CronJobsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1CronJobsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1JobsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_batchV1JobsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_batchV1JobsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_batchV1JobsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_batchV1JobsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1JobsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_batchV1JobsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIHealthzWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_clusterAPIHealthzWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_clusterAPIHealthzWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_clusterAPIHealthzWatch_argsServiceName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["serviceName"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_clusterAPIHealthzWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIHealthzWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIHealthzWatch_argsServiceName(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("serviceName"))
	if tmp, ok := rawArgs["serviceName"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIReadyWait_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_clusterAPIReadyWait_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_clusterAPIReadyWait_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_clusterAPIReadyWait_argsServiceName(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["serviceName"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_clusterAPIReadyWait_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIReadyWait_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIReadyWait_argsServiceName(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("serviceName"))
	if tmp, ok := rawArgs["serviceName"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIServicesWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_clusterAPIServicesWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_clusterAPIServicesWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Subscription_clusterAPIServicesWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_clusterAPIServicesWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1NamespacesWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_coreV1NamespacesWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_coreV1NamespacesWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Subscription_coreV1NamespacesWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1NamespacesWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1NodesWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_coreV1NodesWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_coreV1NodesWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg1
	return args, nil
}
func (ec *executionContext) field_Subscription_coreV1NodesWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1NodesWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1PodsWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_coreV1PodsWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_coreV1PodsWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_coreV1PodsWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_coreV1PodsWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1PodsWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1PodsWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1ServicesWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_coreV1ServicesWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_coreV1ServicesWatch_argsNamespace(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["namespace"] = arg1
	arg2, err := ec.field_Subscription_coreV1ServicesWatch_argsOptions(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["options"] = arg2
	return args, nil
}
func (ec *executionContext) field_Subscription_coreV1ServicesWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1ServicesWatch_argsNamespace(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("namespace"))
	if tmp, ok := rawArgs["namespace"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_coreV1ServicesWatch_argsOptions(
	ctx context.Context,
	rawArgs map[string]any,
) (*v1.ListOptions, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("options"))
	if tmp, ok := rawArgs["options"]; ok {
		return ec.unmarshalOMetaV1ListOptions2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListOptions(ctx, tmp)
	}

	var zeroVal *v1.ListOptions
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_kubernetesAPIHealthzWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_kubernetesAPIHealthzWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Subscription_kubernetesAPIHealthzWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_kubernetesAPIReadyWait_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_kubernetesAPIReadyWait_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	return args, nil
}
func (ec *executionContext) field_Subscription_kubernetesAPIReadyWait_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_logRecordsFollow_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_logRecordsFollow_argsSources(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["sources"] = arg1
	arg2, err := ec.field_Subscription_logRecordsFollow_argsSince(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["since"] = arg2
	arg3, err := ec.field_Subscription_logRecordsFollow_argsAfter(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["after"] = arg3
	arg4, err := ec.field_Subscription_logRecordsFollow_argsGrep(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["grep"] = arg4
	arg5, err := ec.field_Subscription_logRecordsFollow_argsSourceFilter(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["sourceFilter"] = arg5
	return args, nil
}
func (ec *executionContext) field_Subscription_logRecordsFollow_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_argsSources(
	ctx context.Context,
	rawArgs map[string]any,
) ([]string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("sources"))
	if tmp, ok := rawArgs["sources"]; ok {
		return ec.unmarshalNString2ᚕstringᚄ(ctx, tmp)
	}

	var zeroVal []string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_argsSince(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("since"))
	if tmp, ok := rawArgs["since"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_argsAfter(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("after"))
	if tmp, ok := rawArgs["after"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_argsGrep(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("grep"))
	if tmp, ok := rawArgs["grep"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logRecordsFollow_argsSourceFilter(
	ctx context.Context,
	rawArgs map[string]any,
) (*model.LogSourceFilter, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("sourceFilter"))
	if tmp, ok := rawArgs["sourceFilter"]; ok {
		return ec.unmarshalOLogSourceFilter2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐLogSourceFilter(ctx, tmp)
	}

	var zeroVal *model.LogSourceFilter
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logSourcesWatch_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field_Subscription_logSourcesWatch_argsKubeContext(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["kubeContext"] = arg0
	arg1, err := ec.field_Subscription_logSourcesWatch_argsSources(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["sources"] = arg1
	return args, nil
}
func (ec *executionContext) field_Subscription_logSourcesWatch_argsKubeContext(
	ctx context.Context,
	rawArgs map[string]any,
) (*string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("kubeContext"))
	if tmp, ok := rawArgs["kubeContext"]; ok {
		return ec.unmarshalOString2ᚖstring(ctx, tmp)
	}

	var zeroVal *string
	return zeroVal, nil
}

func (ec *executionContext) field_Subscription_logSourcesWatch_argsSources(
	ctx context.Context,
	rawArgs map[string]any,
) ([]string, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("sources"))
	if tmp, ok := rawArgs["sources"]; ok {
		return ec.unmarshalNString2ᚕstringᚄ(ctx, tmp)
	}

	var zeroVal []string
	return zeroVal, nil
}

func (ec *executionContext) field___Directive_args_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field___Directive_args_argsIncludeDeprecated(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["includeDeprecated"] = arg0
	return args, nil
}
func (ec *executionContext) field___Directive_args_argsIncludeDeprecated(
	ctx context.Context,
	rawArgs map[string]any,
) (*bool, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("includeDeprecated"))
	if tmp, ok := rawArgs["includeDeprecated"]; ok {
		return ec.unmarshalOBoolean2ᚖbool(ctx, tmp)
	}

	var zeroVal *bool
	return zeroVal, nil
}

func (ec *executionContext) field___Field_args_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field___Field_args_argsIncludeDeprecated(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["includeDeprecated"] = arg0
	return args, nil
}
func (ec *executionContext) field___Field_args_argsIncludeDeprecated(
	ctx context.Context,
	rawArgs map[string]any,
) (*bool, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("includeDeprecated"))
	if tmp, ok := rawArgs["includeDeprecated"]; ok {
		return ec.unmarshalOBoolean2ᚖbool(ctx, tmp)
	}

	var zeroVal *bool
	return zeroVal, nil
}

func (ec *executionContext) field___Type_enumValues_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field___Type_enumValues_argsIncludeDeprecated(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["includeDeprecated"] = arg0
	return args, nil
}
func (ec *executionContext) field___Type_enumValues_argsIncludeDeprecated(
	ctx context.Context,
	rawArgs map[string]any,
) (bool, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("includeDeprecated"))
	if tmp, ok := rawArgs["includeDeprecated"]; ok {
		return ec.unmarshalOBoolean2bool(ctx, tmp)
	}

	var zeroVal bool
	return zeroVal, nil
}

func (ec *executionContext) field___Type_fields_args(ctx context.Context, rawArgs map[string]any) (map[string]any, error) {
	var err error
	args := map[string]any{}
	arg0, err := ec.field___Type_fields_argsIncludeDeprecated(ctx, rawArgs)
	if err != nil {
		return nil, err
	}
	args["includeDeprecated"] = arg0
	return args, nil
}
func (ec *executionContext) field___Type_fields_argsIncludeDeprecated(
	ctx context.Context,
	rawArgs map[string]any,
) (bool, error) {
	ctx = graphql.WithPathContext(ctx, graphql.NewPathWithField("includeDeprecated"))
	if tmp, ok := rawArgs["includeDeprecated"]; ok {
		return ec.unmarshalOBoolean2bool(ctx, tmp)
	}

	var zeroVal bool
	return zeroVal, nil
}

// endregion ***************************** args.gotpl *****************************

// region    ************************** directives.gotpl **************************

// endregion ************************** directives.gotpl **************************

// region    **************************** field.gotpl *****************************

func (ec *executionContext) _AppsV1DaemonSet_id(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSet_kind(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSet_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSet_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSet_spec(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.DaemonSetSpec)
	fc.Result = res
	return ec.marshalNAppsV1DaemonSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "selector":
				return ec.fieldContext_AppsV1DaemonSetSpec_selector(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSetSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSet_status(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSet_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.DaemonSetStatus)
	fc.Result = res
	return ec.marshalNAppsV1DaemonSetStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSet_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "currentNumberScheduled":
				return ec.fieldContext_AppsV1DaemonSetStatus_currentNumberScheduled(ctx, field)
			case "numberMisscheduled":
				return ec.fieldContext_AppsV1DaemonSetStatus_numberMisscheduled(ctx, field)
			case "desiredNumberScheduled":
				return ec.fieldContext_AppsV1DaemonSetStatus_desiredNumberScheduled(ctx, field)
			case "numberReady":
				return ec.fieldContext_AppsV1DaemonSetStatus_numberReady(ctx, field)
			case "observedGeneration":
				return ec.fieldContext_AppsV1DaemonSetStatus_observedGeneration(ctx, field)
			case "updatedNumberScheduled":
				return ec.fieldContext_AppsV1DaemonSetStatus_updatedNumberScheduled(ctx, field)
			case "numberAvailable":
				return ec.fieldContext_AppsV1DaemonSetStatus_numberAvailable(ctx, field)
			case "numberUnavailable":
				return ec.fieldContext_AppsV1DaemonSetStatus_numberUnavailable(ctx, field)
			case "conditions":
				return ec.fieldContext_AppsV1DaemonSetStatus_conditions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSetStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetCondition_type(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetCondition_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.DaemonSetConditionType)
	fc.Result = res
	return ec.marshalNAppsV1DaemonSetConditionType2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetConditionType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetCondition_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type AppsV1DaemonSetConditionType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetCondition_status(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetCondition_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.ConditionStatus)
	fc.Result = res
	return ec.marshalNCoreV1ConditionStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐConditionStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetCondition_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type CoreV1ConditionStatus does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetCondition_lastTransitionTime(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetCondition_lastTransitionTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastTransitionTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.Time)
	fc.Result = res
	return ec.marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetCondition_lastTransitionTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetCondition_reason(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetCondition_reason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Reason, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetCondition_reason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetCondition_message(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetCondition_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetCondition_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetList_kind(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetList_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetList_items(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v11.DaemonSet)
	fc.Result = res
	return ec.marshalNAppsV1DaemonSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1DaemonSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1DaemonSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1DaemonSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1DaemonSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1DaemonSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1DaemonSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.LabelSelector)
	fc.Result = res
	return ec.marshalOMetaV1LabelSelector2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelector(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "matchLabels":
				return ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
			case "matchExpressions":
				return ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelector", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_currentNumberScheduled(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_currentNumberScheduled(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.CurrentNumberScheduled, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_currentNumberScheduled(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_numberMisscheduled(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_numberMisscheduled(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NumberMisscheduled, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_numberMisscheduled(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_desiredNumberScheduled(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_desiredNumberScheduled(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DesiredNumberScheduled, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_desiredNumberScheduled(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_numberReady(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_numberReady(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NumberReady, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_numberReady(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_observedGeneration(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_observedGeneration(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObservedGeneration, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int64)
	fc.Result = res
	return ec.marshalNInt642int64(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_observedGeneration(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int64 does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_updatedNumberScheduled(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_updatedNumberScheduled(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UpdatedNumberScheduled, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_updatedNumberScheduled(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_numberAvailable(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_numberAvailable(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NumberAvailable, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_numberAvailable(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_numberUnavailable(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_numberUnavailable(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NumberUnavailable, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_numberUnavailable(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetStatus_conditions(ctx context.Context, field graphql.CollectedField, obj *v11.DaemonSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetStatus_conditions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Conditions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v11.DaemonSetCondition)
	fc.Result = res
	return ec.marshalNAppsV1DaemonSetCondition2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetConditionᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetStatus_conditions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_AppsV1DaemonSetCondition_type(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1DaemonSetCondition_status(ctx, field)
			case "lastTransitionTime":
				return ec.fieldContext_AppsV1DaemonSetCondition_lastTransitionTime(ctx, field)
			case "reason":
				return ec.fieldContext_AppsV1DaemonSetCondition_reason(ctx, field)
			case "message":
				return ec.fieldContext_AppsV1DaemonSetCondition_message(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSetCondition", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DaemonSetsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DaemonSetsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.AppsV1DaemonSetsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.DaemonSet)
	fc.Result = res
	return ec.marshalOAppsV1DaemonSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DaemonSetsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DaemonSetsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1DaemonSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1DaemonSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1DaemonSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1DaemonSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1DaemonSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1DaemonSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_id(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_kind(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_spec(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.DeploymentSpec)
	fc.Result = res
	return ec.marshalNAppsV1DeploymentSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "replicas":
				return ec.fieldContext_AppsV1DeploymentSpec_replicas(ctx, field)
			case "selector":
				return ec.fieldContext_AppsV1DeploymentSpec_selector(ctx, field)
			case "paused":
				return ec.fieldContext_AppsV1DeploymentSpec_paused(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DeploymentSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1Deployment_status(ctx context.Context, field graphql.CollectedField, obj *v11.Deployment) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1Deployment_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.DeploymentStatus)
	fc.Result = res
	return ec.marshalNAppsV1DeploymentStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1Deployment_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1Deployment",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "replicas":
				return ec.fieldContext_AppsV1DeploymentStatus_replicas(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DeploymentStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentList_kind(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentList_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentList_items(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v11.Deployment)
	fc.Result = res
	return ec.marshalNAppsV1Deployment2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1Deployment_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1Deployment_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1Deployment_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1Deployment_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1Deployment_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1Deployment_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1Deployment", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentSpec_replicas(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentSpec_replicas(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Replicas, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentSpec_replicas(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.LabelSelector)
	fc.Result = res
	return ec.marshalOMetaV1LabelSelector2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelector(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "matchLabels":
				return ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
			case "matchExpressions":
				return ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelector", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentSpec_paused(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentSpec_paused(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Paused, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentSpec_paused(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentStatus_replicas(ctx context.Context, field graphql.CollectedField, obj *v11.DeploymentStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentStatus_replicas(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Replicas, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentStatus_replicas(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1DeploymentsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1DeploymentsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.AppsV1DeploymentsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.Deployment)
	fc.Result = res
	return ec.marshalOAppsV1Deployment2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDeployment(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1DeploymentsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1DeploymentsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1Deployment_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1Deployment_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1Deployment_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1Deployment_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1Deployment_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1Deployment_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1Deployment", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_id(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_kind(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_spec(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.ReplicaSetSpec)
	fc.Result = res
	return ec.marshalNAppsV1ReplicaSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "replicas":
				return ec.fieldContext_AppsV1ReplicaSetSpec_replicas(ctx, field)
			case "selector":
				return ec.fieldContext_AppsV1ReplicaSetSpec_selector(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSetSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSet_status(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSet_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.ReplicaSetStatus)
	fc.Result = res
	return ec.marshalNAppsV1ReplicaSetStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSet_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "replicas":
				return ec.fieldContext_AppsV1ReplicaSetStatus_replicas(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSetStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetList_kind(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetList_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetList_items(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v11.ReplicaSet)
	fc.Result = res
	return ec.marshalNAppsV1ReplicaSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1ReplicaSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1ReplicaSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1ReplicaSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1ReplicaSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1ReplicaSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1ReplicaSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetSpec_replicas(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetSpec_replicas(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Replicas, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetSpec_replicas(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.LabelSelector)
	fc.Result = res
	return ec.marshalOMetaV1LabelSelector2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelector(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "matchLabels":
				return ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
			case "matchExpressions":
				return ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelector", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetStatus_replicas(ctx context.Context, field graphql.CollectedField, obj *v11.ReplicaSetStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetStatus_replicas(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Replicas, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetStatus_replicas(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1ReplicaSetsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1ReplicaSetsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.AppsV1ReplicaSetsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.ReplicaSet)
	fc.Result = res
	return ec.marshalOAppsV1ReplicaSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1ReplicaSetsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1ReplicaSetsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1ReplicaSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1ReplicaSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1ReplicaSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1ReplicaSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1ReplicaSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1ReplicaSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSet_id(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSet_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSet_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSet_kind(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSet_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSet_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSet_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSet_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSet_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSet_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSet_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSet_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSet_spec(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSet) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSet_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v11.StatefulSetSpec)
	fc.Result = res
	return ec.marshalNAppsV1StatefulSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSetSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSet_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSet",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "replicas":
				return ec.fieldContext_AppsV1StatefulSetSpec_replicas(ctx, field)
			case "selector":
				return ec.fieldContext_AppsV1StatefulSetSpec_selector(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSetSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetList_kind(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetList_metadata(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetList_items(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v11.StatefulSet)
	fc.Result = res
	return ec.marshalNAppsV1StatefulSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSetᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1StatefulSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1StatefulSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1StatefulSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1StatefulSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1StatefulSet_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetSpec_replicas(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetSpec_replicas(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Replicas, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetSpec_replicas(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v11.StatefulSetSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.LabelSelector)
	fc.Result = res
	return ec.marshalOMetaV1LabelSelector2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelector(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "matchLabels":
				return ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
			case "matchExpressions":
				return ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelector", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _AppsV1StatefulSetsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_AppsV1StatefulSetsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.AppsV1StatefulSetsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.StatefulSet)
	fc.Result = res
	return ec.marshalOAppsV1StatefulSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_AppsV1StatefulSetsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "AppsV1StatefulSetsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1StatefulSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1StatefulSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1StatefulSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1StatefulSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1StatefulSet_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSet", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_id(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_kind(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_metadata(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_spec(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.CronJobSpec)
	fc.Result = res
	return ec.marshalNBatchV1CronJobSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "schedule":
				return ec.fieldContext_BatchV1CronJobSpec_schedule(ctx, field)
			case "timeZone":
				return ec.fieldContext_BatchV1CronJobSpec_timeZone(ctx, field)
			case "suspend":
				return ec.fieldContext_BatchV1CronJobSpec_suspend(ctx, field)
			case "jobTemplate":
				return ec.fieldContext_BatchV1CronJobSpec_jobTemplate(ctx, field)
			case "successfulJobsHistoryLimit":
				return ec.fieldContext_BatchV1CronJobSpec_successfulJobsHistoryLimit(ctx, field)
			case "failedJobsHistoryLimit":
				return ec.fieldContext_BatchV1CronJobSpec_failedJobsHistoryLimit(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJobSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJob_status(ctx context.Context, field graphql.CollectedField, obj *v12.CronJob) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJob_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.CronJobStatus)
	fc.Result = res
	return ec.marshalNBatchV1CronJobStatus2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJob_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJob",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "active":
				return ec.fieldContext_BatchV1CronJobStatus_active(ctx, field)
			case "lastScheduleTime":
				return ec.fieldContext_BatchV1CronJobStatus_lastScheduleTime(ctx, field)
			case "lastSuccessfulTime":
				return ec.fieldContext_BatchV1CronJobStatus_lastSuccessfulTime(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJobStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobList_kind(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobList_metadata(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobList_items(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v12.CronJob)
	fc.Result = res
	return ec.marshalNBatchV1CronJob2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1CronJob_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1CronJob_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1CronJob_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1CronJob_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1CronJob_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1CronJob_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJob", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_schedule(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_schedule(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Schedule, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_schedule(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_timeZone(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_timeZone(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.TimeZone, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_timeZone(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_suspend(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_suspend(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Suspend, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*bool)
	fc.Result = res
	return ec.marshalOBoolean2ᚖbool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_suspend(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_jobTemplate(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_jobTemplate(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.JobTemplate, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.JobTemplateSpec)
	fc.Result = res
	return ec.marshalNBatchV1JobTemplateSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobTemplateSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_jobTemplate(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "metadata":
				return ec.fieldContext_BatchV1JobTemplateSpec_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1JobTemplateSpec_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobTemplateSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_successfulJobsHistoryLimit(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_successfulJobsHistoryLimit(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.SuccessfulJobsHistoryLimit, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_successfulJobsHistoryLimit(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobSpec_failedJobsHistoryLimit(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobSpec_failedJobsHistoryLimit(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.FailedJobsHistoryLimit, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobSpec_failedJobsHistoryLimit(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobStatus_active(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobStatus_active(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Active, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.ObjectReference)
	fc.Result = res
	return ec.marshalNCoreV1ObjectReference2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐObjectReferenceᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobStatus_active(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1ObjectReference_kind(ctx, field)
			case "namespace":
				return ec.fieldContext_CoreV1ObjectReference_namespace(ctx, field)
			case "name":
				return ec.fieldContext_CoreV1ObjectReference_name(ctx, field)
			case "uid":
				return ec.fieldContext_CoreV1ObjectReference_uid(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1ObjectReference_apiVersion(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_CoreV1ObjectReference_resourceVersion(ctx, field)
			case "fieldPath":
				return ec.fieldContext_CoreV1ObjectReference_fieldPath(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ObjectReference", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobStatus_lastScheduleTime(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobStatus_lastScheduleTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastScheduleTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.Time)
	fc.Result = res
	return ec.marshalOMetaV1Time2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobStatus_lastScheduleTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobStatus_lastSuccessfulTime(ctx context.Context, field graphql.CollectedField, obj *v12.CronJobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobStatus_lastSuccessfulTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastSuccessfulTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.Time)
	fc.Result = res
	return ec.marshalOMetaV1Time2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobStatus_lastSuccessfulTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1CronJobsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1CronJobsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.BatchV1CronJobsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.CronJob)
	fc.Result = res
	return ec.marshalOBatchV1CronJob2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐCronJob(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1CronJobsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1CronJobsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1CronJob_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1CronJob_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1CronJob_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1CronJob_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1CronJob_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1CronJob_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJob", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_id(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_kind(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_metadata(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_spec(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.JobSpec)
	fc.Result = res
	return ec.marshalNBatchV1JobSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "parallelism":
				return ec.fieldContext_BatchV1JobSpec_parallelism(ctx, field)
			case "completions":
				return ec.fieldContext_BatchV1JobSpec_completions(ctx, field)
			case "backoffLimit":
				return ec.fieldContext_BatchV1JobSpec_backoffLimit(ctx, field)
			case "selector":
				return ec.fieldContext_BatchV1JobSpec_selector(ctx, field)
			case "manualSelector":
				return ec.fieldContext_BatchV1JobSpec_manualSelector(ctx, field)
			case "ttlSecondsAfterFinished":
				return ec.fieldContext_BatchV1JobSpec_ttlSecondsAfterFinished(ctx, field)
			case "suspend":
				return ec.fieldContext_BatchV1JobSpec_suspend(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1Job_status(ctx context.Context, field graphql.CollectedField, obj *v12.Job) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1Job_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.JobStatus)
	fc.Result = res
	return ec.marshalNBatchV1JobStatus2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1Job_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1Job",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "conditions":
				return ec.fieldContext_BatchV1JobStatus_conditions(ctx, field)
			case "startTime":
				return ec.fieldContext_BatchV1JobStatus_startTime(ctx, field)
			case "completionTime":
				return ec.fieldContext_BatchV1JobStatus_completionTime(ctx, field)
			case "active":
				return ec.fieldContext_BatchV1JobStatus_active(ctx, field)
			case "succeeded":
				return ec.fieldContext_BatchV1JobStatus_succeeded(ctx, field)
			case "failed":
				return ec.fieldContext_BatchV1JobStatus_failed(ctx, field)
			case "completedIndexes":
				return ec.fieldContext_BatchV1JobStatus_completedIndexes(ctx, field)
			case "ready":
				return ec.fieldContext_BatchV1JobStatus_ready(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_type(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.JobConditionType)
	fc.Result = res
	return ec.marshalNBatchV1JobConditionType2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobConditionType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type BatchV1JobConditionType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_status(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.ConditionStatus)
	fc.Result = res
	return ec.marshalNCoreV1ConditionStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐConditionStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type CoreV1ConditionStatus does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_lastProbeTime(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_lastProbeTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastProbeTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.Time)
	fc.Result = res
	return ec.marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_lastProbeTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_lastTransitionTime(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_lastTransitionTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastTransitionTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.Time)
	fc.Result = res
	return ec.marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_lastTransitionTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_reason(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_reason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Reason, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_reason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobCondition_message(ctx context.Context, field graphql.CollectedField, obj *v12.JobCondition) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobCondition_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobCondition_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobCondition",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobList_kind(ctx context.Context, field graphql.CollectedField, obj *v12.JobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v12.JobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobList_metadata(ctx context.Context, field graphql.CollectedField, obj *v12.JobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobList_items(ctx context.Context, field graphql.CollectedField, obj *v12.JobList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v12.Job)
	fc.Result = res
	return ec.marshalNBatchV1Job2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐJobᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1Job_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1Job_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1Job_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1Job_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1Job_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1Job_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1Job", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_parallelism(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_parallelism(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Parallelism, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_parallelism(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_completions(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_completions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Completions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_completions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_backoffLimit(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_backoffLimit(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.BackoffLimit, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_backoffLimit(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.LabelSelector)
	fc.Result = res
	return ec.marshalOMetaV1LabelSelector2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelector(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "matchLabels":
				return ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
			case "matchExpressions":
				return ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelector", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_manualSelector(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_manualSelector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ManualSelector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*bool)
	fc.Result = res
	return ec.marshalOBoolean2ᚖbool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_manualSelector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_ttlSecondsAfterFinished(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_ttlSecondsAfterFinished(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.TTLSecondsAfterFinished, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_ttlSecondsAfterFinished(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobSpec_suspend(ctx context.Context, field graphql.CollectedField, obj *v12.JobSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobSpec_suspend(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Suspend, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*bool)
	fc.Result = res
	return ec.marshalOBoolean2ᚖbool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobSpec_suspend(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_conditions(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_conditions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Conditions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v12.JobCondition)
	fc.Result = res
	return ec.marshalNBatchV1JobCondition2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐJobConditionᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_conditions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_BatchV1JobCondition_type(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1JobCondition_status(ctx, field)
			case "lastProbeTime":
				return ec.fieldContext_BatchV1JobCondition_lastProbeTime(ctx, field)
			case "lastTransitionTime":
				return ec.fieldContext_BatchV1JobCondition_lastTransitionTime(ctx, field)
			case "reason":
				return ec.fieldContext_BatchV1JobCondition_reason(ctx, field)
			case "message":
				return ec.fieldContext_BatchV1JobCondition_message(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobCondition", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_startTime(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_startTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.StartTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.Time)
	fc.Result = res
	return ec.marshalOMetaV1Time2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_startTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_completionTime(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_completionTime(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.CompletionTime, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.Time)
	fc.Result = res
	return ec.marshalOMetaV1Time2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_completionTime(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_active(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_active(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Active, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_active(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_succeeded(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_succeeded(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Succeeded, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_succeeded(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_failed(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_failed(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Failed, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_failed(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_completedIndexes(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_completedIndexes(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.CompletedIndexes, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_completedIndexes(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobStatus_ready(ctx context.Context, field graphql.CollectedField, obj *v12.JobStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobStatus_ready(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Ready, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int32)
	fc.Result = res
	return ec.marshalOInt2ᚖint32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobStatus_ready(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobTemplateSpec_metadata(ctx context.Context, field graphql.CollectedField, obj *v12.JobTemplateSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobTemplateSpec_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobTemplateSpec_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobTemplateSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobTemplateSpec_spec(ctx context.Context, field graphql.CollectedField, obj *v12.JobTemplateSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobTemplateSpec_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v12.JobSpec)
	fc.Result = res
	return ec.marshalNBatchV1JobSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobTemplateSpec_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobTemplateSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "parallelism":
				return ec.fieldContext_BatchV1JobSpec_parallelism(ctx, field)
			case "completions":
				return ec.fieldContext_BatchV1JobSpec_completions(ctx, field)
			case "backoffLimit":
				return ec.fieldContext_BatchV1JobSpec_backoffLimit(ctx, field)
			case "selector":
				return ec.fieldContext_BatchV1JobSpec_selector(ctx, field)
			case "manualSelector":
				return ec.fieldContext_BatchV1JobSpec_manualSelector(ctx, field)
			case "ttlSecondsAfterFinished":
				return ec.fieldContext_BatchV1JobSpec_ttlSecondsAfterFinished(ctx, field)
			case "suspend":
				return ec.fieldContext_BatchV1JobSpec_suspend(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _BatchV1JobsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_BatchV1JobsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.BatchV1JobsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.Job)
	fc.Result = res
	return ec.marshalOBatchV1Job2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐJob(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_BatchV1JobsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "BatchV1JobsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1Job_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1Job_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1Job_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1Job_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1Job_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1Job_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1Job", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Container_name(ctx context.Context, field graphql.CollectedField, obj *v13.Container) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Container_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Container_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Container",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Container_image(ctx context.Context, field graphql.CollectedField, obj *v13.Container) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Container_image(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Image, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Container_image(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Container",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerState_waiting(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerState) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerState_waiting(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Waiting, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.ContainerStateWaiting)
	fc.Result = res
	return ec.marshalOCoreV1ContainerStateWaiting2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStateWaiting(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerState_waiting(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerState",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "reason":
				return ec.fieldContext_CoreV1ContainerStateWaiting_reason(ctx, field)
			case "message":
				return ec.fieldContext_CoreV1ContainerStateWaiting_message(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerStateWaiting", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerState_running(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerState) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerState_running(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Running, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.ContainerStateRunning)
	fc.Result = res
	return ec.marshalOCoreV1ContainerStateRunning2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStateRunning(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerState_running(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerState",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "startedAt":
				return ec.fieldContext_CoreV1ContainerStateRunning_startedAt(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerStateRunning", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerState_terminated(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerState) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerState_terminated(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Terminated, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.ContainerStateTerminated)
	fc.Result = res
	return ec.marshalOCoreV1ContainerStateTerminated2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStateTerminated(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerState_terminated(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerState",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "exitCode":
				return ec.fieldContext_CoreV1ContainerStateTerminated_exitCode(ctx, field)
			case "signal":
				return ec.fieldContext_CoreV1ContainerStateTerminated_signal(ctx, field)
			case "reason":
				return ec.fieldContext_CoreV1ContainerStateTerminated_reason(ctx, field)
			case "message":
				return ec.fieldContext_CoreV1ContainerStateTerminated_message(ctx, field)
			case "containerID":
				return ec.fieldContext_CoreV1ContainerStateTerminated_containerID(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerStateTerminated", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateRunning_startedAt(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateRunning) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateRunning_startedAt(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.StartedAt, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.Time)
	fc.Result = res
	return ec.marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateRunning_startedAt(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateRunning",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateTerminated_exitCode(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateTerminated) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateTerminated_exitCode(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ExitCode, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateTerminated_exitCode(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateTerminated",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateTerminated_signal(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateTerminated) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateTerminated_signal(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Signal, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateTerminated_signal(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateTerminated",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateTerminated_reason(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateTerminated) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateTerminated_reason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Reason, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateTerminated_reason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateTerminated",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateTerminated_message(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateTerminated) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateTerminated_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateTerminated_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateTerminated",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateTerminated_containerID(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateTerminated) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateTerminated_containerID(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ContainerID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateTerminated_containerID(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateTerminated",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateWaiting_reason(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateWaiting) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateWaiting_reason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Reason, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateWaiting_reason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateWaiting",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStateWaiting_message(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStateWaiting) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStateWaiting_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStateWaiting_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStateWaiting",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_name(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_state(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_state(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.State, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.ContainerState)
	fc.Result = res
	return ec.marshalNCoreV1ContainerState2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainerState(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_state(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "waiting":
				return ec.fieldContext_CoreV1ContainerState_waiting(ctx, field)
			case "running":
				return ec.fieldContext_CoreV1ContainerState_running(ctx, field)
			case "terminated":
				return ec.fieldContext_CoreV1ContainerState_terminated(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerState", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_lastTerminationState(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_lastTerminationState(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LastTerminationState, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.ContainerState)
	fc.Result = res
	return ec.marshalNCoreV1ContainerState2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainerState(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_lastTerminationState(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "waiting":
				return ec.fieldContext_CoreV1ContainerState_waiting(ctx, field)
			case "running":
				return ec.fieldContext_CoreV1ContainerState_running(ctx, field)
			case "terminated":
				return ec.fieldContext_CoreV1ContainerState_terminated(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerState", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_ready(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_ready(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Ready, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_ready(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_restartCount(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_restartCount(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.RestartCount, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_restartCount(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_image(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_image(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Image, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_image(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_imageID(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_imageID(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ImageID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_imageID(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_containerID(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_containerID(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ContainerID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_containerID(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ContainerStatus_started(ctx context.Context, field graphql.CollectedField, obj *v13.ContainerStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ContainerStatus_started(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Started, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*bool)
	fc.Result = res
	return ec.marshalOBoolean2ᚖbool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ContainerStatus_started(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ContainerStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Namespace_id(ctx context.Context, field graphql.CollectedField, obj *v13.Namespace) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Namespace_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Namespace_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Namespace",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Namespace_kind(ctx context.Context, field graphql.CollectedField, obj *v13.Namespace) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Namespace_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Namespace_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Namespace",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Namespace_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.Namespace) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Namespace_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Namespace_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Namespace",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Namespace_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.Namespace) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Namespace_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Namespace_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Namespace",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespaceList_kind(ctx context.Context, field graphql.CollectedField, obj *v13.NamespaceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespaceList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespaceList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespaceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespaceList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.NamespaceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespaceList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespaceList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespaceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespaceList_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.NamespaceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespaceList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespaceList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespaceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespaceList_items(ctx context.Context, field graphql.CollectedField, obj *v13.NamespaceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespaceList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.Namespace)
	fc.Result = res
	return ec.marshalNCoreV1Namespace2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐNamespaceᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespaceList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespaceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Namespace_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Namespace_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Namespace_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Namespace_metadata(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Namespace", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespacesWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespacesWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespacesWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespacesWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NamespacesWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NamespacesWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.CoreV1NamespacesWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Namespace)
	fc.Result = res
	return ec.marshalOCoreV1Namespace2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐNamespace(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NamespacesWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NamespacesWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Namespace_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Namespace_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Namespace_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Namespace_metadata(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Namespace", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Node_id(ctx context.Context, field graphql.CollectedField, obj *v13.Node) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Node_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Node_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Node",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Node_kind(ctx context.Context, field graphql.CollectedField, obj *v13.Node) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Node_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Node_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Node",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Node_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.Node) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Node_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Node_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Node",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Node_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.Node) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Node_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Node_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Node",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodeList_kind(ctx context.Context, field graphql.CollectedField, obj *v13.NodeList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodeList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodeList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodeList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodeList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.NodeList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodeList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodeList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodeList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodeList_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.NodeList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodeList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodeList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodeList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodeList_items(ctx context.Context, field graphql.CollectedField, obj *v13.NodeList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodeList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.Node)
	fc.Result = res
	return ec.marshalNCoreV1Node2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐNodeᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodeList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodeList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Node_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Node_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Node_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Node_metadata(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Node", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodesWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodesWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodesWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodesWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1NodesWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1NodesWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.CoreV1NodesWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Node)
	fc.Result = res
	return ec.marshalOCoreV1Node2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐNode(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1NodesWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1NodesWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Node_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Node_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Node_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Node_metadata(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Node", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_kind(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_namespace(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_namespace(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Namespace, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_namespace(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_name(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_uid(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_uid(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_uid(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_resourceVersion(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_resourceVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ResourceVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_resourceVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ObjectReference_fieldPath(ctx context.Context, field graphql.CollectedField, obj *v13.ObjectReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ObjectReference_fieldPath(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.FieldPath, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ObjectReference_fieldPath(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ObjectReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_id(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_kind(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_spec(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.PodSpec)
	fc.Result = res
	return ec.marshalNCoreV1PodSpec2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "containers":
				return ec.fieldContext_CoreV1PodSpec_containers(ctx, field)
			case "nodeName":
				return ec.fieldContext_CoreV1PodSpec_nodeName(ctx, field)
			case "hostname":
				return ec.fieldContext_CoreV1PodSpec_hostname(ctx, field)
			case "priorityClassName":
				return ec.fieldContext_CoreV1PodSpec_priorityClassName(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1PodSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Pod_status(ctx context.Context, field graphql.CollectedField, obj *v13.Pod) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Pod_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.PodStatus)
	fc.Result = res
	return ec.marshalNCoreV1PodStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Pod_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Pod",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "phase":
				return ec.fieldContext_CoreV1PodStatus_phase(ctx, field)
			case "message":
				return ec.fieldContext_CoreV1PodStatus_message(ctx, field)
			case "reason":
				return ec.fieldContext_CoreV1PodStatus_reason(ctx, field)
			case "containerStatuses":
				return ec.fieldContext_CoreV1PodStatus_containerStatuses(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1PodStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodList_kind(ctx context.Context, field graphql.CollectedField, obj *v13.PodList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.PodList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodList_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.PodList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodList_items(ctx context.Context, field graphql.CollectedField, obj *v13.PodList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.Pod)
	fc.Result = res
	return ec.marshalNCoreV1Pod2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐPodᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Pod_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Pod_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Pod_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Pod_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Pod_spec(ctx, field)
			case "status":
				return ec.fieldContext_CoreV1Pod_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Pod", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodSpec_containers(ctx context.Context, field graphql.CollectedField, obj *v13.PodSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodSpec_containers(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Containers, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.Container)
	fc.Result = res
	return ec.marshalNCoreV1Container2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodSpec_containers(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_CoreV1Container_name(ctx, field)
			case "image":
				return ec.fieldContext_CoreV1Container_image(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Container", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodSpec_nodeName(ctx context.Context, field graphql.CollectedField, obj *v13.PodSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodSpec_nodeName(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NodeName, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodSpec_nodeName(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodSpec_hostname(ctx context.Context, field graphql.CollectedField, obj *v13.PodSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodSpec_hostname(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Hostname, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodSpec_hostname(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodSpec_priorityClassName(ctx context.Context, field graphql.CollectedField, obj *v13.PodSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodSpec_priorityClassName(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.PriorityClassName, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodSpec_priorityClassName(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodStatus_phase(ctx context.Context, field graphql.CollectedField, obj *v13.PodStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodStatus_phase(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Phase, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.PodPhase)
	fc.Result = res
	return ec.marshalNCoreV1PodPhase2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodPhase(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodStatus_phase(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type CoreV1PodPhase does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodStatus_message(ctx context.Context, field graphql.CollectedField, obj *v13.PodStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodStatus_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodStatus_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodStatus_reason(ctx context.Context, field graphql.CollectedField, obj *v13.PodStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodStatus_reason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Reason, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodStatus_reason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodStatus_containerStatuses(ctx context.Context, field graphql.CollectedField, obj *v13.PodStatus) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodStatus_containerStatuses(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ContainerStatuses, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.ContainerStatus)
	fc.Result = res
	return ec.marshalNCoreV1ContainerStatus2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStatusᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodStatus_containerStatuses(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodStatus",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_CoreV1ContainerStatus_name(ctx, field)
			case "state":
				return ec.fieldContext_CoreV1ContainerStatus_state(ctx, field)
			case "lastTerminationState":
				return ec.fieldContext_CoreV1ContainerStatus_lastTerminationState(ctx, field)
			case "ready":
				return ec.fieldContext_CoreV1ContainerStatus_ready(ctx, field)
			case "restartCount":
				return ec.fieldContext_CoreV1ContainerStatus_restartCount(ctx, field)
			case "image":
				return ec.fieldContext_CoreV1ContainerStatus_image(ctx, field)
			case "imageID":
				return ec.fieldContext_CoreV1ContainerStatus_imageID(ctx, field)
			case "containerID":
				return ec.fieldContext_CoreV1ContainerStatus_containerID(ctx, field)
			case "started":
				return ec.fieldContext_CoreV1ContainerStatus_started(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ContainerStatus", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodsWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodsWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodsWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodsWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1PodsWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1PodsWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.CoreV1PodsWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Pod)
	fc.Result = res
	return ec.marshalOCoreV1Pod2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐPod(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1PodsWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1PodsWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Pod_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Pod_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Pod_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Pod_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Pod_spec(ctx, field)
			case "status":
				return ec.fieldContext_CoreV1Pod_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Pod", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Service_id(ctx context.Context, field graphql.CollectedField, obj *v13.Service) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Service_id(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Service_id(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Service",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Service_kind(ctx context.Context, field graphql.CollectedField, obj *v13.Service) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Service_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Service_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Service",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Service_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.Service) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Service_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Service_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Service",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Service_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.Service) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Service_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ObjectMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ObjectMeta)
	fc.Result = res
	return ec.marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Service_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Service",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "uid":
				return ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
			case "namespace":
				return ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
			case "resourceVersion":
				return ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
			case "creationTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
			case "deletionTimestamp":
				return ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
			case "labels":
				return ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
			case "annotations":
				return ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
			case "ownerReferences":
				return ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ObjectMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1Service_spec(ctx context.Context, field graphql.CollectedField, obj *v13.Service) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1Service_spec(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Spec, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v13.ServiceSpec)
	fc.Result = res
	return ec.marshalNCoreV1ServiceSpec2k8sᚗioᚋapiᚋcoreᚋv1ᚐServiceSpec(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1Service_spec(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1Service",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "ports":
				return ec.fieldContext_CoreV1ServiceSpec_ports(ctx, field)
			case "selector":
				return ec.fieldContext_CoreV1ServiceSpec_selector(ctx, field)
			case "clusterIP":
				return ec.fieldContext_CoreV1ServiceSpec_clusterIP(ctx, field)
			case "clusterIPs":
				return ec.fieldContext_CoreV1ServiceSpec_clusterIPs(ctx, field)
			case "externalName":
				return ec.fieldContext_CoreV1ServiceSpec_externalName(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServiceSpec", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceList_kind(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceList_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceList_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceList_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceList_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceList_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceList_metadata(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceList_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ListMeta, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.ListMeta)
	fc.Result = res
	return ec.marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceList_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "resourceVersion":
				return ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
			case "continue":
				return ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
			case "remainingItemCount":
				return ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1ListMeta", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceList_items(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceList) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceList_items(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Items, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.Service)
	fc.Result = res
	return ec.marshalNCoreV1Service2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐServiceᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceList_items(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceList",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Service_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Service_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Service_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Service_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Service_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Service", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServicePort_name(ctx context.Context, field graphql.CollectedField, obj *v13.ServicePort) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServicePort_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServicePort_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServicePort",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServicePort_port(ctx context.Context, field graphql.CollectedField, obj *v13.ServicePort) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServicePort_port(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Port, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int32)
	fc.Result = res
	return ec.marshalNInt2int32(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServicePort_port(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServicePort",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServicePort_appProtocol(ctx context.Context, field graphql.CollectedField, obj *v13.ServicePort) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServicePort_appProtocol(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.AppProtocol, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServicePort_appProtocol(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServicePort",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceSpec_ports(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceSpec_ports(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Ports, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v13.ServicePort)
	fc.Result = res
	return ec.marshalNCoreV1ServicePort2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐServicePortᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceSpec_ports(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_CoreV1ServicePort_name(ctx, field)
			case "port":
				return ec.fieldContext_CoreV1ServicePort_port(ctx, field)
			case "appProtocol":
				return ec.fieldContext_CoreV1ServicePort_appProtocol(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServicePort", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceSpec_selector(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceSpec_selector(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Selector, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]string)
	fc.Result = res
	return ec.marshalOStringMap2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceSpec_selector(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type StringMap does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceSpec_clusterIP(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceSpec_clusterIP(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ClusterIP, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalOString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceSpec_clusterIP(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceSpec_clusterIPs(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceSpec_clusterIPs(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ClusterIPs, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]string)
	fc.Result = res
	return ec.marshalOString2ᚕstringᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceSpec_clusterIPs(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServiceSpec_externalName(ctx context.Context, field graphql.CollectedField, obj *v13.ServiceSpec) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServiceSpec_externalName(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ExternalName, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalOString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServiceSpec_externalName(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServiceSpec",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServicesWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServicesWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServicesWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServicesWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _CoreV1ServicesWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *watch.Event) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_CoreV1ServicesWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.CoreV1ServicesWatchEvent().Object(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Service)
	fc.Result = res
	return ec.marshalOCoreV1Service2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐService(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_CoreV1ServicesWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "CoreV1ServicesWatchEvent",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Service_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Service_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Service_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Service_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Service_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Service", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _HealthCheckResponse_status(ctx context.Context, field graphql.CollectedField, obj *model.HealthCheckResponse) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HealthCheckResponse_status(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Status, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(model.HealthCheckStatus)
	fc.Result = res
	return ec.marshalNHealthCheckStatus2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckStatus(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HealthCheckResponse_status(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HealthCheckResponse",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type HealthCheckStatus does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HealthCheckResponse_message(ctx context.Context, field graphql.CollectedField, obj *model.HealthCheckResponse) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HealthCheckResponse_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HealthCheckResponse_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HealthCheckResponse",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HealthCheckResponse_timestamp(ctx context.Context, field graphql.CollectedField, obj *model.HealthCheckResponse) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HealthCheckResponse_timestamp(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Timestamp, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(time.Time)
	fc.Result = res
	return ec.marshalNTime2timeᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HealthCheckResponse_timestamp(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HealthCheckResponse",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmChart_metadata(ctx context.Context, field graphql.CollectedField, obj *chart.Chart) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmChart_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Metadata, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*chart.Metadata)
	fc.Result = res
	return ec.marshalOHelmChartMetadata2ᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋchartᚐMetadata(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmChart_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmChart",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_HelmChartMetadata_name(ctx, field)
			case "version":
				return ec.fieldContext_HelmChartMetadata_version(ctx, field)
			case "condition":
				return ec.fieldContext_HelmChartMetadata_condition(ctx, field)
			case "appVersion":
				return ec.fieldContext_HelmChartMetadata_appVersion(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HelmChartMetadata", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmChartMetadata_name(ctx context.Context, field graphql.CollectedField, obj *chart.Metadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmChartMetadata_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmChartMetadata_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmChartMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmChartMetadata_version(ctx context.Context, field graphql.CollectedField, obj *chart.Metadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmChartMetadata_version(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Version, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmChartMetadata_version(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmChartMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmChartMetadata_condition(ctx context.Context, field graphql.CollectedField, obj *chart.Metadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmChartMetadata_condition(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Condition, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmChartMetadata_condition(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmChartMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmChartMetadata_appVersion(ctx context.Context, field graphql.CollectedField, obj *chart.Metadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmChartMetadata_appVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.AppVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmChartMetadata_appVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmChartMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmRelease_name(ctx context.Context, field graphql.CollectedField, obj *release.Release) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmRelease_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmRelease_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmRelease",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmRelease_version(ctx context.Context, field graphql.CollectedField, obj *release.Release) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmRelease_version(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Version, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(int)
	fc.Result = res
	return ec.marshalNInt2int(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmRelease_version(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmRelease",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmRelease_namespace(ctx context.Context, field graphql.CollectedField, obj *release.Release) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmRelease_namespace(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Namespace, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmRelease_namespace(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmRelease",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _HelmRelease_chart(ctx context.Context, field graphql.CollectedField, obj *release.Release) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_HelmRelease_chart(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Chart, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*chart.Chart)
	fc.Result = res
	return ec.marshalOHelmChart2ᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋchartᚐChart(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_HelmRelease_chart(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "HelmRelease",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "metadata":
				return ec.fieldContext_HelmChart_metadata(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HelmChart", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfig_authInfos(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfig) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfig_authInfos(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.KubeConfig().AuthInfos(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]*model.KubeConfigAuthInfo)
	fc.Result = res
	return ec.marshalNKubeConfigAuthInfo2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigAuthInfoᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfig_authInfos(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfig",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_KubeConfigAuthInfo_name(ctx, field)
			case "locationOfOrigin":
				return ec.fieldContext_KubeConfigAuthInfo_locationOfOrigin(ctx, field)
			case "extensions":
				return ec.fieldContext_KubeConfigAuthInfo_extensions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfigAuthInfo", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfig_clusters(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfig) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfig_clusters(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.KubeConfig().Clusters(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]*model.KubeConfigCluster)
	fc.Result = res
	return ec.marshalNKubeConfigCluster2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigClusterᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfig_clusters(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfig",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_KubeConfigCluster_name(ctx, field)
			case "locationOfOrigin":
				return ec.fieldContext_KubeConfigCluster_locationOfOrigin(ctx, field)
			case "server":
				return ec.fieldContext_KubeConfigCluster_server(ctx, field)
			case "extensions":
				return ec.fieldContext_KubeConfigCluster_extensions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfigCluster", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfig_contexts(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfig) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfig_contexts(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.KubeConfig().Contexts(rctx, obj)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]*model.KubeConfigContext)
	fc.Result = res
	return ec.marshalNKubeConfigContext2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigContextᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfig_contexts(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfig",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_KubeConfigContext_name(ctx, field)
			case "locationOfOrigin":
				return ec.fieldContext_KubeConfigContext_locationOfOrigin(ctx, field)
			case "cluster":
				return ec.fieldContext_KubeConfigContext_cluster(ctx, field)
			case "authInfo":
				return ec.fieldContext_KubeConfigContext_authInfo(ctx, field)
			case "namespace":
				return ec.fieldContext_KubeConfigContext_namespace(ctx, field)
			case "extensions":
				return ec.fieldContext_KubeConfigContext_extensions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfigContext", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfig_currentContext(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfig) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfig_currentContext(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.CurrentContext, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfig_currentContext(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfig",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfig_extensions(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfig) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfig_extensions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Extensions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]runtime.Object)
	fc.Result = res
	return ec.marshalOKubeConfigExtensions2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfig_extensions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfig",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type KubeConfigExtensions does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigAuthInfo_name(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigAuthInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigAuthInfo_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigAuthInfo_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigAuthInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigAuthInfo_locationOfOrigin(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigAuthInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigAuthInfo_locationOfOrigin(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LocationOfOrigin, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigAuthInfo_locationOfOrigin(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigAuthInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigAuthInfo_extensions(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigAuthInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigAuthInfo_extensions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Extensions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]runtime.Object)
	fc.Result = res
	return ec.marshalOKubeConfigExtensions2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigAuthInfo_extensions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigAuthInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type KubeConfigExtensions does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigCluster_name(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigCluster) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigCluster_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigCluster_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigCluster",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigCluster_locationOfOrigin(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigCluster) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigCluster_locationOfOrigin(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LocationOfOrigin, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigCluster_locationOfOrigin(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigCluster",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigCluster_server(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigCluster) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigCluster_server(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Server, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigCluster_server(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigCluster",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigCluster_extensions(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigCluster) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigCluster_extensions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Extensions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]runtime.Object)
	fc.Result = res
	return ec.marshalOKubeConfigExtensions2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigCluster_extensions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigCluster",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type KubeConfigExtensions does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_name(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_locationOfOrigin(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_locationOfOrigin(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.LocationOfOrigin, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_locationOfOrigin(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_cluster(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_cluster(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Cluster, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_cluster(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_authInfo(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_authInfo(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.AuthInfo, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_authInfo(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_namespace(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_namespace(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Namespace, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_namespace(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigContext_extensions(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigContext) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigContext_extensions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Extensions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]runtime.Object)
	fc.Result = res
	return ec.marshalOKubeConfigExtensions2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigContext_extensions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigContext",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type KubeConfigExtensions does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigWatchEvent) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _KubeConfigWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *model.KubeConfigWatchEvent) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_KubeConfigWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Object, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*model.KubeConfig)
	fc.Result = res
	return ec.marshalOKubeConfig2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfig(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_KubeConfigWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "KubeConfigWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "authInfos":
				return ec.fieldContext_KubeConfig_authInfos(ctx, field)
			case "clusters":
				return ec.fieldContext_KubeConfig_clusters(ctx, field)
			case "contexts":
				return ec.fieldContext_KubeConfig_contexts(ctx, field)
			case "currentContext":
				return ec.fieldContext_KubeConfig_currentContext(ctx, field)
			case "extensions":
				return ec.fieldContext_KubeConfig_extensions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfig", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogRecord_timestamp(ctx context.Context, field graphql.CollectedField, obj *logs.LogRecord) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogRecord_timestamp(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Timestamp, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(time.Time)
	fc.Result = res
	return ec.marshalNTime2timeᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogRecord_timestamp(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogRecord",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogRecord_message(ctx context.Context, field graphql.CollectedField, obj *logs.LogRecord) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogRecord_message(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Message, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogRecord_message(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogRecord",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogRecord_source(ctx context.Context, field graphql.CollectedField, obj *logs.LogRecord) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogRecord_source(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Source, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(logs.LogSource)
	fc.Result = res
	return ec.marshalNLogSource2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogSource(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogRecord_source(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogRecord",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "metadata":
				return ec.fieldContext_LogSource_metadata(ctx, field)
			case "namespace":
				return ec.fieldContext_LogSource_namespace(ctx, field)
			case "podName":
				return ec.fieldContext_LogSource_podName(ctx, field)
			case "containerName":
				return ec.fieldContext_LogSource_containerName(ctx, field)
			case "containerID":
				return ec.fieldContext_LogSource_containerID(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogSource", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogRecordsQueryResponse_records(ctx context.Context, field graphql.CollectedField, obj *model.LogRecordsQueryResponse) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogRecordsQueryResponse_records(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Records, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]*logs.LogRecord)
	fc.Result = res
	return ec.marshalNLogRecord2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogRecordᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogRecordsQueryResponse_records(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogRecordsQueryResponse",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "timestamp":
				return ec.fieldContext_LogRecord_timestamp(ctx, field)
			case "message":
				return ec.fieldContext_LogRecord_message(ctx, field)
			case "source":
				return ec.fieldContext_LogRecord_source(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogRecord", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogRecordsQueryResponse_nextCursor(ctx context.Context, field graphql.CollectedField, obj *model.LogRecordsQueryResponse) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogRecordsQueryResponse_nextCursor(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.NextCursor, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOID2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogRecordsQueryResponse_nextCursor(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogRecordsQueryResponse",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSource_metadata(ctx context.Context, field graphql.CollectedField, obj *logs.LogSource) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSource_metadata(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Metadata, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(logs.LogSourceMetadata)
	fc.Result = res
	return ec.marshalNLogSourceMetadata2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogSourceMetadata(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSource_metadata(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSource",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "region":
				return ec.fieldContext_LogSourceMetadata_region(ctx, field)
			case "zone":
				return ec.fieldContext_LogSourceMetadata_zone(ctx, field)
			case "os":
				return ec.fieldContext_LogSourceMetadata_os(ctx, field)
			case "arch":
				return ec.fieldContext_LogSourceMetadata_arch(ctx, field)
			case "node":
				return ec.fieldContext_LogSourceMetadata_node(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogSourceMetadata", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSource_namespace(ctx context.Context, field graphql.CollectedField, obj *logs.LogSource) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSource_namespace(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Namespace, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSource_namespace(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSource",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSource_podName(ctx context.Context, field graphql.CollectedField, obj *logs.LogSource) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSource_podName(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.PodName, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSource_podName(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSource",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSource_containerName(ctx context.Context, field graphql.CollectedField, obj *logs.LogSource) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSource_containerName(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ContainerName, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSource_containerName(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSource",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSource_containerID(ctx context.Context, field graphql.CollectedField, obj *logs.LogSource) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSource_containerID(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ContainerID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSource_containerID(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSource",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceMetadata_region(ctx context.Context, field graphql.CollectedField, obj *logs.LogSourceMetadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceMetadata_region(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Region, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceMetadata_region(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceMetadata_zone(ctx context.Context, field graphql.CollectedField, obj *logs.LogSourceMetadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceMetadata_zone(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Zone, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceMetadata_zone(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceMetadata_os(ctx context.Context, field graphql.CollectedField, obj *logs.LogSourceMetadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceMetadata_os(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.OS, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceMetadata_os(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceMetadata_arch(ctx context.Context, field graphql.CollectedField, obj *logs.LogSourceMetadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceMetadata_arch(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Arch, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceMetadata_arch(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceMetadata_node(ctx context.Context, field graphql.CollectedField, obj *logs.LogSourceMetadata) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceMetadata_node(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Node, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceMetadata_node(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceMetadata",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceWatchEvent_type(ctx context.Context, field graphql.CollectedField, obj *model.LogSourceWatchEvent) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceWatchEvent_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(watch.EventType)
	fc.Result = res
	return ec.marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceWatchEvent_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type WatchEventType does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _LogSourceWatchEvent_object(ctx context.Context, field graphql.CollectedField, obj *model.LogSourceWatchEvent) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_LogSourceWatchEvent_object(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Object, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*logs.LogSource)
	fc.Result = res
	return ec.marshalOLogSource2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogSource(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_LogSourceWatchEvent_object(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "LogSourceWatchEvent",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "metadata":
				return ec.fieldContext_LogSource_metadata(ctx, field)
			case "namespace":
				return ec.fieldContext_LogSource_namespace(ctx, field)
			case "podName":
				return ec.fieldContext_LogSource_podName(ctx, field)
			case "containerName":
				return ec.fieldContext_LogSource_containerName(ctx, field)
			case "containerID":
				return ec.fieldContext_LogSource_containerID(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogSource", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1LabelSelector_matchLabels(ctx context.Context, field graphql.CollectedField, obj *v1.LabelSelector) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1LabelSelector_matchLabels(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.MatchLabels, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]string)
	fc.Result = res
	return ec.marshalOStringMap2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1LabelSelector_matchLabels(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1LabelSelector",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type StringMap does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1LabelSelector_matchExpressions(ctx context.Context, field graphql.CollectedField, obj *v1.LabelSelector) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1LabelSelector_matchExpressions(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.MatchExpressions, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v1.LabelSelectorRequirement)
	fc.Result = res
	return ec.marshalNMetaV1LabelSelectorRequirement2ᚕk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorRequirementᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1LabelSelector_matchExpressions(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1LabelSelector",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "key":
				return ec.fieldContext_MetaV1LabelSelectorRequirement_key(ctx, field)
			case "operator":
				return ec.fieldContext_MetaV1LabelSelectorRequirement_operator(ctx, field)
			case "values":
				return ec.fieldContext_MetaV1LabelSelectorRequirement_values(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1LabelSelectorRequirement", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1LabelSelectorRequirement_key(ctx context.Context, field graphql.CollectedField, obj *v1.LabelSelectorRequirement) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1LabelSelectorRequirement_key(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Key, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1LabelSelectorRequirement_key(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1LabelSelectorRequirement",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1LabelSelectorRequirement_operator(ctx context.Context, field graphql.CollectedField, obj *v1.LabelSelectorRequirement) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1LabelSelectorRequirement_operator(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Operator, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.LabelSelectorOperator)
	fc.Result = res
	return ec.marshalNMetaV1LabelSelectorOperator2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorOperator(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1LabelSelectorRequirement_operator(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1LabelSelectorRequirement",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1LabelSelectorOperator does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1LabelSelectorRequirement_values(ctx context.Context, field graphql.CollectedField, obj *v1.LabelSelectorRequirement) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1LabelSelectorRequirement_values(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Values, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]string)
	fc.Result = res
	return ec.marshalNString2ᚕstringᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1LabelSelectorRequirement_values(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1LabelSelectorRequirement",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ListMeta_resourceVersion(ctx context.Context, field graphql.CollectedField, obj *v1.ListMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ListMeta_resourceVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ResourceVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ListMeta_resourceVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ListMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ListMeta_continue(ctx context.Context, field graphql.CollectedField, obj *v1.ListMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ListMeta_continue(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Continue, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ListMeta_continue(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ListMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ListMeta_remainingItemCount(ctx context.Context, field graphql.CollectedField, obj *v1.ListMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ListMeta_remainingItemCount(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.RemainingItemCount, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*int64)
	fc.Result = res
	return ec.marshalOInt642ᚖint64(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ListMeta_remainingItemCount(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ListMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Int64 does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_uid(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_uid(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_uid(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_name(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_namespace(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_namespace(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Namespace, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_namespace(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_resourceVersion(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_resourceVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.ResourceVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_resourceVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_creationTimestamp(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_creationTimestamp(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.CreationTimestamp, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(v1.Time)
	fc.Result = res
	return ec.marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_creationTimestamp(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_deletionTimestamp(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_deletionTimestamp(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DeletionTimestamp, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v1.Time)
	fc.Result = res
	return ec.marshalOMetaV1Time2ᚖk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_deletionTimestamp(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type MetaV1Time does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_labels(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_labels(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Labels, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]string)
	fc.Result = res
	return ec.marshalOStringMap2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_labels(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type StringMap does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_annotations(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_annotations(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Annotations, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(map[string]string)
	fc.Result = res
	return ec.marshalOStringMap2map(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_annotations(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type StringMap does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1ObjectMeta_ownerReferences(ctx context.Context, field graphql.CollectedField, obj *v1.ObjectMeta) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1ObjectMeta_ownerReferences(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.OwnerReferences, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]v1.OwnerReference)
	fc.Result = res
	return ec.marshalNMetaV1OwnerReference2ᚕk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐOwnerReferenceᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1ObjectMeta_ownerReferences(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1ObjectMeta",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "apiVersion":
				return ec.fieldContext_MetaV1OwnerReference_apiVersion(ctx, field)
			case "kind":
				return ec.fieldContext_MetaV1OwnerReference_kind(ctx, field)
			case "name":
				return ec.fieldContext_MetaV1OwnerReference_name(ctx, field)
			case "uid":
				return ec.fieldContext_MetaV1OwnerReference_uid(ctx, field)
			case "controller":
				return ec.fieldContext_MetaV1OwnerReference_controller(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type MetaV1OwnerReference", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1OwnerReference_apiVersion(ctx context.Context, field graphql.CollectedField, obj *v1.OwnerReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1OwnerReference_apiVersion(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.APIVersion, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1OwnerReference_apiVersion(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1OwnerReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1OwnerReference_kind(ctx context.Context, field graphql.CollectedField, obj *v1.OwnerReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1OwnerReference_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1OwnerReference_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1OwnerReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1OwnerReference_name(ctx context.Context, field graphql.CollectedField, obj *v1.OwnerReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1OwnerReference_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1OwnerReference_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1OwnerReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1OwnerReference_uid(ctx context.Context, field graphql.CollectedField, obj *v1.OwnerReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1OwnerReference_uid(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.UID, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(types.UID)
	fc.Result = res
	return ec.marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1OwnerReference_uid(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1OwnerReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _MetaV1OwnerReference_controller(ctx context.Context, field graphql.CollectedField, obj *v1.OwnerReference) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_MetaV1OwnerReference_controller(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Controller, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*bool)
	fc.Result = res
	return ec.marshalOBoolean2ᚖbool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_MetaV1OwnerReference_controller(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "MetaV1OwnerReference",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _Mutation_helmInstallLatest(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Mutation_helmInstallLatest(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Mutation().HelmInstallLatest(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*release.Release)
	fc.Result = res
	return ec.marshalOHelmRelease2ᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋreleaseᚐRelease(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Mutation_helmInstallLatest(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Mutation",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_HelmRelease_name(ctx, field)
			case "version":
				return ec.fieldContext_HelmRelease_version(ctx, field)
			case "namespace":
				return ec.fieldContext_HelmRelease_namespace(ctx, field)
			case "chart":
				return ec.fieldContext_HelmRelease_chart(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HelmRelease", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Mutation_helmInstallLatest_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _PageInfo_endCursor(ctx context.Context, field graphql.CollectedField, obj *model.PageInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_PageInfo_endCursor(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.EndCursor, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOID2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_PageInfo_endCursor(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "PageInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _PageInfo_hasNextPage(ctx context.Context, field graphql.CollectedField, obj *model.PageInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_PageInfo_hasNextPage(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.HasNextPage, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_PageInfo_hasNextPage(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "PageInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _PageInfo_hasPreviousPage(ctx context.Context, field graphql.CollectedField, obj *model.PageInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_PageInfo_hasPreviousPage(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.HasPreviousPage, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_PageInfo_hasPreviousPage(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "PageInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _PageInfo_startCursor(ctx context.Context, field graphql.CollectedField, obj *model.PageInfo) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_PageInfo_startCursor(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.StartCursor, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOID2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_PageInfo_startCursor(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "PageInfo",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type ID does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1DaemonSetsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1DaemonSetsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1DaemonSetsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.DaemonSet)
	fc.Result = res
	return ec.marshalOAppsV1DaemonSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1DaemonSetsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1DaemonSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1DaemonSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1DaemonSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1DaemonSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1DaemonSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1DaemonSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSet", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1DaemonSetsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1DaemonSetsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1DaemonSetsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1DaemonSetsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.DaemonSetList)
	fc.Result = res
	return ec.marshalOAppsV1DaemonSetList2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1DaemonSetsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_AppsV1DaemonSetList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1DaemonSetList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1DaemonSetList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_AppsV1DaemonSetList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSetList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1DaemonSetsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1DeploymentsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1DeploymentsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1DeploymentsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.Deployment)
	fc.Result = res
	return ec.marshalOAppsV1Deployment2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDeployment(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1DeploymentsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1Deployment_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1Deployment_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1Deployment_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1Deployment_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1Deployment_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1Deployment_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1Deployment", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1DeploymentsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1DeploymentsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1DeploymentsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1DeploymentsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.DeploymentList)
	fc.Result = res
	return ec.marshalOAppsV1DeploymentList2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1DeploymentsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_AppsV1DeploymentList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1DeploymentList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1DeploymentList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_AppsV1DeploymentList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DeploymentList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1DeploymentsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1ReplicaSetsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1ReplicaSetsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1ReplicaSetsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.ReplicaSet)
	fc.Result = res
	return ec.marshalOAppsV1ReplicaSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1ReplicaSetsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1ReplicaSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1ReplicaSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1ReplicaSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1ReplicaSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1ReplicaSet_spec(ctx, field)
			case "status":
				return ec.fieldContext_AppsV1ReplicaSet_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSet", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1ReplicaSetsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1ReplicaSetsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1ReplicaSetsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1ReplicaSetsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.ReplicaSetList)
	fc.Result = res
	return ec.marshalOAppsV1ReplicaSetList2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1ReplicaSetsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_AppsV1ReplicaSetList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1ReplicaSetList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1ReplicaSetList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_AppsV1ReplicaSetList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSetList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1ReplicaSetsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1StatefulSetsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1StatefulSetsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1StatefulSetsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.StatefulSet)
	fc.Result = res
	return ec.marshalOAppsV1StatefulSet2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSet(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1StatefulSetsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_AppsV1StatefulSet_id(ctx, field)
			case "kind":
				return ec.fieldContext_AppsV1StatefulSet_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1StatefulSet_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1StatefulSet_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_AppsV1StatefulSet_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSet", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1StatefulSetsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_appsV1StatefulSetsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_appsV1StatefulSetsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().AppsV1StatefulSetsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v11.StatefulSetList)
	fc.Result = res
	return ec.marshalOAppsV1StatefulSetList2ᚖk8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSetList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_appsV1StatefulSetsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_AppsV1StatefulSetList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_AppsV1StatefulSetList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_AppsV1StatefulSetList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_AppsV1StatefulSetList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSetList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_appsV1StatefulSetsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_batchV1CronJobsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_batchV1CronJobsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().BatchV1CronJobsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.CronJob)
	fc.Result = res
	return ec.marshalOBatchV1CronJob2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐCronJob(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_batchV1CronJobsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1CronJob_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1CronJob_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1CronJob_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1CronJob_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1CronJob_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1CronJob_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJob", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_batchV1CronJobsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_batchV1CronJobsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_batchV1CronJobsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().BatchV1CronJobsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.CronJobList)
	fc.Result = res
	return ec.marshalOBatchV1CronJobList2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_batchV1CronJobsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_BatchV1CronJobList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1CronJobList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1CronJobList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_BatchV1CronJobList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJobList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_batchV1CronJobsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_batchV1JobsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_batchV1JobsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().BatchV1JobsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.Job)
	fc.Result = res
	return ec.marshalOBatchV1Job2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐJob(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_batchV1JobsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_BatchV1Job_id(ctx, field)
			case "kind":
				return ec.fieldContext_BatchV1Job_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1Job_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1Job_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_BatchV1Job_spec(ctx, field)
			case "status":
				return ec.fieldContext_BatchV1Job_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1Job", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_batchV1JobsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_batchV1JobsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_batchV1JobsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().BatchV1JobsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v12.JobList)
	fc.Result = res
	return ec.marshalOBatchV1JobList2ᚖk8sᚗioᚋapiᚋbatchᚋv1ᚐJobList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_batchV1JobsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_BatchV1JobList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_BatchV1JobList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_BatchV1JobList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_BatchV1JobList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_batchV1JobsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1NamespacesList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1NamespacesList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1NamespacesList(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.NamespaceList)
	fc.Result = res
	return ec.marshalOCoreV1NamespaceList2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐNamespaceList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1NamespacesList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1NamespaceList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1NamespaceList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1NamespaceList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_CoreV1NamespaceList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1NamespaceList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1NamespacesList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1NodesList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1NodesList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1NodesList(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.NodeList)
	fc.Result = res
	return ec.marshalOCoreV1NodeList2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐNodeList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1NodesList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1NodeList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1NodeList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1NodeList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_CoreV1NodeList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1NodeList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1NodesList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1PodsGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1PodsGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1PodsGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Pod)
	fc.Result = res
	return ec.marshalOCoreV1Pod2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐPod(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1PodsGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Pod_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Pod_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Pod_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Pod_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Pod_spec(ctx, field)
			case "status":
				return ec.fieldContext_CoreV1Pod_status(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Pod", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1PodsGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1PodsList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1PodsList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1PodsList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.PodList)
	fc.Result = res
	return ec.marshalOCoreV1PodList2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐPodList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1PodsList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1PodList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1PodList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1PodList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_CoreV1PodList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1PodList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1PodsList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1ServicesGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1ServicesGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1ServicesGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["name"].(string), fc.Args["options"].(*v1.GetOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.Service)
	fc.Result = res
	return ec.marshalOCoreV1Service2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐService(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1ServicesGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "id":
				return ec.fieldContext_CoreV1Service_id(ctx, field)
			case "kind":
				return ec.fieldContext_CoreV1Service_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1Service_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1Service_metadata(ctx, field)
			case "spec":
				return ec.fieldContext_CoreV1Service_spec(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1Service", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1ServicesGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_coreV1ServicesList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_coreV1ServicesList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().CoreV1ServicesList(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.ServiceList)
	fc.Result = res
	return ec.marshalOCoreV1ServiceList2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐServiceList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_coreV1ServicesList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1ServiceList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1ServiceList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1ServiceList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_CoreV1ServiceList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServiceList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_coreV1ServicesList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_clusterAPIReadyWait(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_clusterAPIReadyWait(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().ClusterAPIReadyWait(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["serviceName"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_clusterAPIReadyWait(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_clusterAPIReadyWait_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_clusterAPIHealthzGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_clusterAPIHealthzGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().ClusterAPIHealthzGet(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["serviceName"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(*model.HealthCheckResponse)
	fc.Result = res
	return ec.marshalNHealthCheckResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_clusterAPIHealthzGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "status":
				return ec.fieldContext_HealthCheckResponse_status(ctx, field)
			case "message":
				return ec.fieldContext_HealthCheckResponse_message(ctx, field)
			case "timestamp":
				return ec.fieldContext_HealthCheckResponse_timestamp(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HealthCheckResponse", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_clusterAPIHealthzGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_clusterAPIServicesList(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_clusterAPIServicesList(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().ClusterAPIServicesList(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*v13.ServiceList)
	fc.Result = res
	return ec.marshalOCoreV1ServiceList2ᚖk8sᚗioᚋapiᚋcoreᚋv1ᚐServiceList(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_clusterAPIServicesList(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext_CoreV1ServiceList_kind(ctx, field)
			case "apiVersion":
				return ec.fieldContext_CoreV1ServiceList_apiVersion(ctx, field)
			case "metadata":
				return ec.fieldContext_CoreV1ServiceList_metadata(ctx, field)
			case "items":
				return ec.fieldContext_CoreV1ServiceList_items(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServiceList", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_clusterAPIServicesList_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_helmListReleases(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_helmListReleases(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().HelmListReleases(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]*release.Release)
	fc.Result = res
	return ec.marshalNHelmRelease2ᚕᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋreleaseᚐReleaseᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_helmListReleases(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext_HelmRelease_name(ctx, field)
			case "version":
				return ec.fieldContext_HelmRelease_version(ctx, field)
			case "namespace":
				return ec.fieldContext_HelmRelease_namespace(ctx, field)
			case "chart":
				return ec.fieldContext_HelmRelease_chart(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HelmRelease", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_helmListReleases_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_kubeConfigGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_kubeConfigGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().KubeConfigGet(rctx)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*model.KubeConfig)
	fc.Result = res
	return ec.marshalOKubeConfig2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfig(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_kubeConfigGet(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "authInfos":
				return ec.fieldContext_KubeConfig_authInfos(ctx, field)
			case "clusters":
				return ec.fieldContext_KubeConfig_clusters(ctx, field)
			case "contexts":
				return ec.fieldContext_KubeConfig_contexts(ctx, field)
			case "currentContext":
				return ec.fieldContext_KubeConfig_currentContext(ctx, field)
			case "extensions":
				return ec.fieldContext_KubeConfig_extensions(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfig", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _Query_kubernetesAPIReadyWait(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_kubernetesAPIReadyWait(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().KubernetesAPIReadyWait(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_kubernetesAPIReadyWait(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_kubernetesAPIReadyWait_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_kubernetesAPIHealthzGet(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_kubernetesAPIHealthzGet(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Query().KubernetesAPIHealthzGet(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(*model.HealthCheckResponse)
	fc.Result = res
	return ec.marshalNHealthCheckResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_kubernetesAPIHealthzGet(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "status":
				return ec.fieldContext_HealthCheckResponse_status(ctx, field)
			case "message":
				return ec.fieldContext_HealthCheckResponse_message(ctx, field)
			case "timestamp":
				return ec.fieldContext_HealthCheckResponse_timestamp(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HealthCheckResponse", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_kubernetesAPIHealthzGet_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query_logRecordsFetch(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query_logRecordsFetch(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		directive0 := func(rctx context.Context) (any, error) {
			ctx = rctx // use context from middleware stack in children
			return ec.resolvers.Query().LogRecordsFetch(rctx, fc.Args["kubeContext"].(*string), fc.Args["sources"].([]string), fc.Args["mode"].(*model.LogRecordsQueryMode), fc.Args["since"].(*string), fc.Args["until"].(*string), fc.Args["after"].(*string), fc.Args["before"].(*string), fc.Args["grep"].(*string), fc.Args["sourceFilter"].(*model.LogSourceFilter), fc.Args["limit"].(*int))
		}

		directive1 := func(ctx context.Context) (any, error) {
			if ec.directives.NullIfValidationFailed == nil {
				var zeroVal *model.LogRecordsQueryResponse
				return zeroVal, errors.New("directive nullIfValidationFailed is not implemented")
			}
			return ec.directives.NullIfValidationFailed(ctx, nil, directive0)
		}

		tmp, err := directive1(rctx)
		if err != nil {
			return nil, graphql.ErrorOnPath(ctx, err)
		}
		if tmp == nil {
			return nil, nil
		}
		if data, ok := tmp.(*model.LogRecordsQueryResponse); ok {
			return data, nil
		}
		return nil, fmt.Errorf(`unexpected type %T from directive, should be *github.com/kubetail-org/kubetail/modules/dashboard/graph/model.LogRecordsQueryResponse`, tmp)
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*model.LogRecordsQueryResponse)
	fc.Result = res
	return ec.marshalOLogRecordsQueryResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐLogRecordsQueryResponse(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query_logRecordsFetch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "records":
				return ec.fieldContext_LogRecordsQueryResponse_records(ctx, field)
			case "nextCursor":
				return ec.fieldContext_LogRecordsQueryResponse_nextCursor(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogRecordsQueryResponse", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query_logRecordsFetch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query___type(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query___type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.introspectType(fc.Args["name"].(string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query___type(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Query___type_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Query___schema(ctx context.Context, field graphql.CollectedField) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext_Query___schema(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.introspectSchema()
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*introspection.Schema)
	fc.Result = res
	return ec.marshalO__Schema2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐSchema(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext_Query___schema(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Query",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "description":
				return ec.fieldContext___Schema_description(ctx, field)
			case "types":
				return ec.fieldContext___Schema_types(ctx, field)
			case "queryType":
				return ec.fieldContext___Schema_queryType(ctx, field)
			case "mutationType":
				return ec.fieldContext___Schema_mutationType(ctx, field)
			case "subscriptionType":
				return ec.fieldContext___Schema_subscriptionType(ctx, field)
			case "directives":
				return ec.fieldContext___Schema_directives(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Schema", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_appsV1DaemonSetsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_appsV1DaemonSetsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().AppsV1DaemonSetsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOAppsV1DaemonSetsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_appsV1DaemonSetsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_AppsV1DaemonSetsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_AppsV1DaemonSetsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DaemonSetsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_appsV1DaemonSetsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_appsV1DeploymentsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_appsV1DeploymentsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().AppsV1DeploymentsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOAppsV1DeploymentsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_appsV1DeploymentsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_AppsV1DeploymentsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_AppsV1DeploymentsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1DeploymentsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_appsV1DeploymentsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_appsV1ReplicaSetsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_appsV1ReplicaSetsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().AppsV1ReplicaSetsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOAppsV1ReplicaSetsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_appsV1ReplicaSetsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_AppsV1ReplicaSetsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_AppsV1ReplicaSetsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1ReplicaSetsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_appsV1ReplicaSetsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_appsV1StatefulSetsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_appsV1StatefulSetsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().AppsV1StatefulSetsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOAppsV1StatefulSetsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_appsV1StatefulSetsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_AppsV1StatefulSetsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_AppsV1StatefulSetsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type AppsV1StatefulSetsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_appsV1StatefulSetsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_batchV1CronJobsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_batchV1CronJobsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().BatchV1CronJobsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOBatchV1CronJobsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_batchV1CronJobsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_BatchV1CronJobsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_BatchV1CronJobsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1CronJobsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_batchV1CronJobsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_batchV1JobsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_batchV1JobsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().BatchV1JobsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOBatchV1JobsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_batchV1JobsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_BatchV1JobsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_BatchV1JobsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type BatchV1JobsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_batchV1JobsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_coreV1NamespacesWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_coreV1NamespacesWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().CoreV1NamespacesWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOCoreV1NamespacesWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_coreV1NamespacesWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_CoreV1NamespacesWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_CoreV1NamespacesWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1NamespacesWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_coreV1NamespacesWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_coreV1NodesWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_coreV1NodesWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().CoreV1NodesWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOCoreV1NodesWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_coreV1NodesWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_CoreV1NodesWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_CoreV1NodesWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1NodesWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_coreV1NodesWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_coreV1PodsWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_coreV1PodsWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().CoreV1PodsWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOCoreV1PodsWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_coreV1PodsWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_CoreV1PodsWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_CoreV1PodsWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1PodsWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_coreV1PodsWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_coreV1ServicesWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_coreV1ServicesWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().CoreV1ServicesWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOCoreV1ServicesWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_coreV1ServicesWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_CoreV1ServicesWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_CoreV1ServicesWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServicesWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_coreV1ServicesWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_kubernetesAPIReadyWait(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_kubernetesAPIReadyWait(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().KubernetesAPIReadyWait(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan bool):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalNBoolean2bool(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_kubernetesAPIReadyWait(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_kubernetesAPIReadyWait_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_kubernetesAPIHealthzWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_kubernetesAPIHealthzWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().KubernetesAPIHealthzWatch(rctx, fc.Args["kubeContext"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *model.HealthCheckResponse):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalNHealthCheckResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_kubernetesAPIHealthzWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "status":
				return ec.fieldContext_HealthCheckResponse_status(ctx, field)
			case "message":
				return ec.fieldContext_HealthCheckResponse_message(ctx, field)
			case "timestamp":
				return ec.fieldContext_HealthCheckResponse_timestamp(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HealthCheckResponse", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_kubernetesAPIHealthzWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_clusterAPIReadyWait(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_clusterAPIReadyWait(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().ClusterAPIReadyWait(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["serviceName"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan bool):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalNBoolean2bool(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_clusterAPIReadyWait(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_clusterAPIReadyWait_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_clusterAPIHealthzWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_clusterAPIHealthzWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().ClusterAPIHealthzWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["namespace"].(*string), fc.Args["serviceName"].(*string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *model.HealthCheckResponse):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalNHealthCheckResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_clusterAPIHealthzWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "status":
				return ec.fieldContext_HealthCheckResponse_status(ctx, field)
			case "message":
				return ec.fieldContext_HealthCheckResponse_message(ctx, field)
			case "timestamp":
				return ec.fieldContext_HealthCheckResponse_timestamp(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type HealthCheckResponse", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_clusterAPIHealthzWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_clusterAPIServicesWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_clusterAPIServicesWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().ClusterAPIServicesWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["options"].(*v1.ListOptions))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *watch.Event):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOCoreV1ServicesWatchEvent2ᚖk8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_clusterAPIServicesWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_CoreV1ServicesWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_CoreV1ServicesWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type CoreV1ServicesWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_clusterAPIServicesWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_kubeConfigWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_kubeConfigWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().KubeConfigWatch(rctx)
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *model.KubeConfigWatchEvent):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOKubeConfigWatchEvent2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigWatchEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_kubeConfigWatch(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_KubeConfigWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_KubeConfigWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type KubeConfigWatchEvent", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_logRecordsFollow(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_logRecordsFollow(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		directive0 := func(rctx context.Context) (any, error) {
			ctx = rctx // use context from middleware stack in children
			return ec.resolvers.Subscription().LogRecordsFollow(rctx, fc.Args["kubeContext"].(*string), fc.Args["sources"].([]string), fc.Args["since"].(*string), fc.Args["after"].(*string), fc.Args["grep"].(*string), fc.Args["sourceFilter"].(*model.LogSourceFilter))
		}

		directive1 := func(ctx context.Context) (any, error) {
			if ec.directives.NullIfValidationFailed == nil {
				var zeroVal *logs.LogRecord
				return zeroVal, errors.New("directive nullIfValidationFailed is not implemented")
			}
			return ec.directives.NullIfValidationFailed(ctx, nil, directive0)
		}

		tmp, err := directive1(rctx)
		if err != nil {
			return nil, graphql.ErrorOnPath(ctx, err)
		}
		if tmp == nil {
			return nil, nil
		}
		if data, ok := tmp.(<-chan *logs.LogRecord); ok {
			return data, nil
		}
		return nil, fmt.Errorf(`unexpected type %T from directive, should be <-chan *github.com/kubetail-org/kubetail/modules/shared/logs.LogRecord`, tmp)
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *logs.LogRecord):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOLogRecord2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogRecord(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_logRecordsFollow(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "timestamp":
				return ec.fieldContext_LogRecord_timestamp(ctx, field)
			case "message":
				return ec.fieldContext_LogRecord_message(ctx, field)
			case "source":
				return ec.fieldContext_LogRecord_source(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogRecord", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_logRecordsFollow_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) _Subscription_logSourcesWatch(ctx context.Context, field graphql.CollectedField) (ret func(ctx context.Context) graphql.Marshaler) {
	fc, err := ec.fieldContext_Subscription_logSourcesWatch(ctx, field)
	if err != nil {
		return nil
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = nil
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return ec.resolvers.Subscription().LogSourcesWatch(rctx, fc.Args["kubeContext"].(*string), fc.Args["sources"].([]string))
	})
	if err != nil {
		ec.Error(ctx, err)
		return nil
	}
	if resTmp == nil {
		return nil
	}
	return func(ctx context.Context) graphql.Marshaler {
		select {
		case res, ok := <-resTmp.(<-chan *model.LogSourceWatchEvent):
			if !ok {
				return nil
			}
			return graphql.WriterFunc(func(w io.Writer) {
				w.Write([]byte{'{'})
				graphql.MarshalString(field.Alias).MarshalGQL(w)
				w.Write([]byte{':'})
				ec.marshalOLogSourceWatchEvent2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐLogSourceWatchEvent(ctx, field.Selections, res).MarshalGQL(w)
				w.Write([]byte{'}'})
			})
		case <-ctx.Done():
			return nil
		}
	}
}

func (ec *executionContext) fieldContext_Subscription_logSourcesWatch(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "Subscription",
		Field:      field,
		IsMethod:   true,
		IsResolver: true,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "type":
				return ec.fieldContext_LogSourceWatchEvent_type(ctx, field)
			case "object":
				return ec.fieldContext_LogSourceWatchEvent_object(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type LogSourceWatchEvent", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field_Subscription_logSourcesWatch_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) ___Directive_name(ctx context.Context, field graphql.CollectedField, obj *introspection.Directive) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Directive_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Directive_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Directive",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Directive_description(ctx context.Context, field graphql.CollectedField, obj *introspection.Directive) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Directive_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Directive_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Directive",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Directive_isRepeatable(ctx context.Context, field graphql.CollectedField, obj *introspection.Directive) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Directive_isRepeatable(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.IsRepeatable, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Directive_isRepeatable(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Directive",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Directive_locations(ctx context.Context, field graphql.CollectedField, obj *introspection.Directive) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Directive_locations(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Locations, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]string)
	fc.Result = res
	return ec.marshalN__DirectiveLocation2ᚕstringᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Directive_locations(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Directive",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type __DirectiveLocation does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Directive_args(ctx context.Context, field graphql.CollectedField, obj *introspection.Directive) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Directive_args(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Args, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]introspection.InputValue)
	fc.Result = res
	return ec.marshalN__InputValue2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐInputValueᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Directive_args(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Directive",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___InputValue_name(ctx, field)
			case "description":
				return ec.fieldContext___InputValue_description(ctx, field)
			case "type":
				return ec.fieldContext___InputValue_type(ctx, field)
			case "defaultValue":
				return ec.fieldContext___InputValue_defaultValue(ctx, field)
			case "isDeprecated":
				return ec.fieldContext___InputValue_isDeprecated(ctx, field)
			case "deprecationReason":
				return ec.fieldContext___InputValue_deprecationReason(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __InputValue", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field___Directive_args_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) ___EnumValue_name(ctx context.Context, field graphql.CollectedField, obj *introspection.EnumValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___EnumValue_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___EnumValue_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__EnumValue",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___EnumValue_description(ctx context.Context, field graphql.CollectedField, obj *introspection.EnumValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___EnumValue_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___EnumValue_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__EnumValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___EnumValue_isDeprecated(ctx context.Context, field graphql.CollectedField, obj *introspection.EnumValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___EnumValue_isDeprecated(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.IsDeprecated(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___EnumValue_isDeprecated(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__EnumValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___EnumValue_deprecationReason(ctx context.Context, field graphql.CollectedField, obj *introspection.EnumValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___EnumValue_deprecationReason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DeprecationReason(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___EnumValue_deprecationReason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__EnumValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Field_name(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Field_description(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Field_args(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_args(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Args, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]introspection.InputValue)
	fc.Result = res
	return ec.marshalN__InputValue2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐInputValueᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_args(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___InputValue_name(ctx, field)
			case "description":
				return ec.fieldContext___InputValue_description(ctx, field)
			case "type":
				return ec.fieldContext___InputValue_type(ctx, field)
			case "defaultValue":
				return ec.fieldContext___InputValue_defaultValue(ctx, field)
			case "isDeprecated":
				return ec.fieldContext___InputValue_isDeprecated(ctx, field)
			case "deprecationReason":
				return ec.fieldContext___InputValue_deprecationReason(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __InputValue", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field___Field_args_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) ___Field_type(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalN__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Field_isDeprecated(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_isDeprecated(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.IsDeprecated(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_isDeprecated(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Field_deprecationReason(ctx context.Context, field graphql.CollectedField, obj *introspection.Field) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Field_deprecationReason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DeprecationReason(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Field_deprecationReason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Field",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_name(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalNString2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_description(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_type(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_type(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Type, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalN__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_type(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_defaultValue(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_defaultValue(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DefaultValue, nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_defaultValue(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   false,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_isDeprecated(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_isDeprecated(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.IsDeprecated(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalNBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_isDeprecated(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___InputValue_deprecationReason(ctx context.Context, field graphql.CollectedField, obj *introspection.InputValue) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___InputValue_deprecationReason(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.DeprecationReason(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___InputValue_deprecationReason(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__InputValue",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_description(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_types(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_types(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Types(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]introspection.Type)
	fc.Result = res
	return ec.marshalN__Type2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐTypeᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_types(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_queryType(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_queryType(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.QueryType(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalN__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_queryType(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_mutationType(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_mutationType(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.MutationType(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_mutationType(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_subscriptionType(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_subscriptionType(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.SubscriptionType(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_subscriptionType(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Schema_directives(ctx context.Context, field graphql.CollectedField, obj *introspection.Schema) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Schema_directives(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Directives(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.([]introspection.Directive)
	fc.Result = res
	return ec.marshalN__Directive2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐDirectiveᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Schema_directives(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Schema",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___Directive_name(ctx, field)
			case "description":
				return ec.fieldContext___Directive_description(ctx, field)
			case "isRepeatable":
				return ec.fieldContext___Directive_isRepeatable(ctx, field)
			case "locations":
				return ec.fieldContext___Directive_locations(ctx, field)
			case "args":
				return ec.fieldContext___Directive_args(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Directive", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_kind(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_kind(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Kind(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		if !graphql.HasFieldError(ctx, fc) {
			ec.Errorf(ctx, "must not be null")
		}
		return graphql.Null
	}
	res := resTmp.(string)
	fc.Result = res
	return ec.marshalN__TypeKind2string(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_kind(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type __TypeKind does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_name(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_name(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Name(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_name(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_description(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_description(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Description(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_description(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_specifiedByURL(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_specifiedByURL(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.SpecifiedByURL(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*string)
	fc.Result = res
	return ec.marshalOString2ᚖstring(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_specifiedByURL(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type String does not have child fields")
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_fields(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_fields(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Fields(fc.Args["includeDeprecated"].(bool)), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]introspection.Field)
	fc.Result = res
	return ec.marshalO__Field2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐFieldᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_fields(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___Field_name(ctx, field)
			case "description":
				return ec.fieldContext___Field_description(ctx, field)
			case "args":
				return ec.fieldContext___Field_args(ctx, field)
			case "type":
				return ec.fieldContext___Field_type(ctx, field)
			case "isDeprecated":
				return ec.fieldContext___Field_isDeprecated(ctx, field)
			case "deprecationReason":
				return ec.fieldContext___Field_deprecationReason(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Field", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field___Type_fields_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) ___Type_interfaces(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_interfaces(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.Interfaces(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐTypeᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_interfaces(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_possibleTypes(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_possibleTypes(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.PossibleTypes(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐTypeᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_possibleTypes(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_enumValues(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_enumValues(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.EnumValues(fc.Args["includeDeprecated"].(bool)), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]introspection.EnumValue)
	fc.Result = res
	return ec.marshalO__EnumValue2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐEnumValueᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_enumValues(ctx context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___EnumValue_name(ctx, field)
			case "description":
				return ec.fieldContext___EnumValue_description(ctx, field)
			case "isDeprecated":
				return ec.fieldContext___EnumValue_isDeprecated(ctx, field)
			case "deprecationReason":
				return ec.fieldContext___EnumValue_deprecationReason(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __EnumValue", field.Name)
		},
	}
	defer func() {
		if r := recover(); r != nil {
			err = ec.Recover(ctx, r)
			ec.Error(ctx, err)
		}
	}()
	ctx = graphql.WithFieldContext(ctx, fc)
	if fc.Args, err = ec.field___Type_enumValues_args(ctx, field.ArgumentMap(ec.Variables)); err != nil {
		ec.Error(ctx, err)
		return fc, err
	}
	return fc, nil
}

func (ec *executionContext) ___Type_inputFields(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_inputFields(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.InputFields(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.([]introspection.InputValue)
	fc.Result = res
	return ec.marshalO__InputValue2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐInputValueᚄ(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_inputFields(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "name":
				return ec.fieldContext___InputValue_name(ctx, field)
			case "description":
				return ec.fieldContext___InputValue_description(ctx, field)
			case "type":
				return ec.fieldContext___InputValue_type(ctx, field)
			case "defaultValue":
				return ec.fieldContext___InputValue_defaultValue(ctx, field)
			case "isDeprecated":
				return ec.fieldContext___InputValue_isDeprecated(ctx, field)
			case "deprecationReason":
				return ec.fieldContext___InputValue_deprecationReason(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __InputValue", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_ofType(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_ofType(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.OfType(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(*introspection.Type)
	fc.Result = res
	return ec.marshalO__Type2ᚖgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐType(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_ofType(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			switch field.Name {
			case "kind":
				return ec.fieldContext___Type_kind(ctx, field)
			case "name":
				return ec.fieldContext___Type_name(ctx, field)
			case "description":
				return ec.fieldContext___Type_description(ctx, field)
			case "specifiedByURL":
				return ec.fieldContext___Type_specifiedByURL(ctx, field)
			case "fields":
				return ec.fieldContext___Type_fields(ctx, field)
			case "interfaces":
				return ec.fieldContext___Type_interfaces(ctx, field)
			case "possibleTypes":
				return ec.fieldContext___Type_possibleTypes(ctx, field)
			case "enumValues":
				return ec.fieldContext___Type_enumValues(ctx, field)
			case "inputFields":
				return ec.fieldContext___Type_inputFields(ctx, field)
			case "ofType":
				return ec.fieldContext___Type_ofType(ctx, field)
			case "isOneOf":
				return ec.fieldContext___Type_isOneOf(ctx, field)
			}
			return nil, fmt.Errorf("no field named %q was found under type __Type", field.Name)
		},
	}
	return fc, nil
}

func (ec *executionContext) ___Type_isOneOf(ctx context.Context, field graphql.CollectedField, obj *introspection.Type) (ret graphql.Marshaler) {
	fc, err := ec.fieldContext___Type_isOneOf(ctx, field)
	if err != nil {
		return graphql.Null
	}
	ctx = graphql.WithFieldContext(ctx, fc)
	defer func() {
		if r := recover(); r != nil {
			ec.Error(ctx, ec.Recover(ctx, r))
			ret = graphql.Null
		}
	}()
	resTmp, err := ec.ResolverMiddleware(ctx, func(rctx context.Context) (any, error) {
		ctx = rctx // use context from middleware stack in children
		return obj.IsOneOf(), nil
	})
	if err != nil {
		ec.Error(ctx, err)
		return graphql.Null
	}
	if resTmp == nil {
		return graphql.Null
	}
	res := resTmp.(bool)
	fc.Result = res
	return ec.marshalOBoolean2bool(ctx, field.Selections, res)
}

func (ec *executionContext) fieldContext___Type_isOneOf(_ context.Context, field graphql.CollectedField) (fc *graphql.FieldContext, err error) {
	fc = &graphql.FieldContext{
		Object:     "__Type",
		Field:      field,
		IsMethod:   true,
		IsResolver: false,
		Child: func(ctx context.Context, field graphql.CollectedField) (*graphql.FieldContext, error) {
			return nil, errors.New("field of type Boolean does not have child fields")
		},
	}
	return fc, nil
}

// endregion **************************** field.gotpl *****************************

// region    **************************** input.gotpl *****************************

func (ec *executionContext) unmarshalInputLogSourceFilter(ctx context.Context, obj any) (model.LogSourceFilter, error) {
	var it model.LogSourceFilter
	asMap := map[string]any{}
	for k, v := range obj.(map[string]any) {
		asMap[k] = v
	}

	fieldsInOrder := [...]string{"region", "zone", "os", "arch", "node", "container"}
	for _, k := range fieldsInOrder {
		v, ok := asMap[k]
		if !ok {
			continue
		}
		switch k {
		case "region":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("region"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Region = data
		case "zone":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("zone"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Zone = data
		case "os":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("os"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Os = data
		case "arch":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("arch"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Arch = data
		case "node":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("node"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Node = data
		case "container":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("container"))
			data, err := ec.unmarshalOString2ᚕstringᚄ(ctx, v)
			if err != nil {
				return it, err
			}
			it.Container = data
		}
	}

	return it, nil
}

func (ec *executionContext) unmarshalInputMetaV1GetOptions(ctx context.Context, obj any) (v1.GetOptions, error) {
	var it v1.GetOptions
	asMap := map[string]any{}
	for k, v := range obj.(map[string]any) {
		asMap[k] = v
	}

	fieldsInOrder := [...]string{"resourceVersion"}
	for _, k := range fieldsInOrder {
		v, ok := asMap[k]
		if !ok {
			continue
		}
		switch k {
		case "resourceVersion":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("resourceVersion"))
			data, err := ec.unmarshalOString2string(ctx, v)
			if err != nil {
				return it, err
			}
			it.ResourceVersion = data
		}
	}

	return it, nil
}

func (ec *executionContext) unmarshalInputMetaV1ListOptions(ctx context.Context, obj any) (v1.ListOptions, error) {
	var it v1.ListOptions
	asMap := map[string]any{}
	for k, v := range obj.(map[string]any) {
		asMap[k] = v
	}

	fieldsInOrder := [...]string{"labelSelector", "fieldSelector", "allowWatchBookmarks", "resourceVersion", "resourceVersionMatch", "limit", "continue", "sendInitialEvents"}
	for _, k := range fieldsInOrder {
		v, ok := asMap[k]
		if !ok {
			continue
		}
		switch k {
		case "labelSelector":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("labelSelector"))
			data, err := ec.unmarshalOString2string(ctx, v)
			if err != nil {
				return it, err
			}
			it.LabelSelector = data
		case "fieldSelector":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("fieldSelector"))
			data, err := ec.unmarshalOString2string(ctx, v)
			if err != nil {
				return it, err
			}
			it.FieldSelector = data
		case "allowWatchBookmarks":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("allowWatchBookmarks"))
			data, err := ec.unmarshalOBoolean2bool(ctx, v)
			if err != nil {
				return it, err
			}
			it.AllowWatchBookmarks = data
		case "resourceVersion":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("resourceVersion"))
			data, err := ec.unmarshalOString2string(ctx, v)
			if err != nil {
				return it, err
			}
			it.ResourceVersion = data
		case "resourceVersionMatch":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("resourceVersionMatch"))
			data, err := ec.unmarshalOMetaV1ResourceVersionMatch2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐResourceVersionMatch(ctx, v)
			if err != nil {
				return it, err
			}
			it.ResourceVersionMatch = data
		case "limit":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("limit"))
			data, err := ec.unmarshalOInt642int64(ctx, v)
			if err != nil {
				return it, err
			}
			it.Limit = data
		case "continue":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("continue"))
			data, err := ec.unmarshalOString2string(ctx, v)
			if err != nil {
				return it, err
			}
			it.Continue = data
		case "sendInitialEvents":
			ctx := graphql.WithPathContext(ctx, graphql.NewPathWithField("sendInitialEvents"))
			data, err := ec.unmarshalOBoolean2ᚖbool(ctx, v)
			if err != nil {
				return it, err
			}
			it.SendInitialEvents = data
		}
	}

	return it, nil
}

// endregion **************************** input.gotpl *****************************

// region    ************************** interface.gotpl ***************************

func (ec *executionContext) _List(ctx context.Context, sel ast.SelectionSet, obj model.List) graphql.Marshaler {
	switch obj := (obj).(type) {
	case nil:
		return graphql.Null
	case v13.ServiceList:
		return ec._CoreV1ServiceList(ctx, sel, &obj)
	case *v13.ServiceList:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1ServiceList(ctx, sel, obj)
	case v13.PodList:
		return ec._CoreV1PodList(ctx, sel, &obj)
	case *v13.PodList:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1PodList(ctx, sel, obj)
	case v13.NodeList:
		return ec._CoreV1NodeList(ctx, sel, &obj)
	case *v13.NodeList:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1NodeList(ctx, sel, obj)
	case v13.NamespaceList:
		return ec._CoreV1NamespaceList(ctx, sel, &obj)
	case *v13.NamespaceList:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1NamespaceList(ctx, sel, obj)
	case v12.JobList:
		return ec._BatchV1JobList(ctx, sel, &obj)
	case *v12.JobList:
		if obj == nil {
			return graphql.Null
		}
		return ec._BatchV1JobList(ctx, sel, obj)
	case v12.CronJobList:
		return ec._BatchV1CronJobList(ctx, sel, &obj)
	case *v12.CronJobList:
		if obj == nil {
			return graphql.Null
		}
		return ec._BatchV1CronJobList(ctx, sel, obj)
	case v11.StatefulSetList:
		return ec._AppsV1StatefulSetList(ctx, sel, &obj)
	case *v11.StatefulSetList:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1StatefulSetList(ctx, sel, obj)
	case v11.ReplicaSetList:
		return ec._AppsV1ReplicaSetList(ctx, sel, &obj)
	case *v11.ReplicaSetList:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1ReplicaSetList(ctx, sel, obj)
	case v11.DeploymentList:
		return ec._AppsV1DeploymentList(ctx, sel, &obj)
	case *v11.DeploymentList:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1DeploymentList(ctx, sel, obj)
	case v11.DaemonSetList:
		return ec._AppsV1DaemonSetList(ctx, sel, &obj)
	case *v11.DaemonSetList:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1DaemonSetList(ctx, sel, obj)
	default:
		panic(fmt.Errorf("unexpected type %T", obj))
	}
}

func (ec *executionContext) _Object(ctx context.Context, sel ast.SelectionSet, obj model.Object) graphql.Marshaler {
	switch obj := (obj).(type) {
	case nil:
		return graphql.Null
	case v13.Service:
		return ec._CoreV1Service(ctx, sel, &obj)
	case *v13.Service:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1Service(ctx, sel, obj)
	case v13.Pod:
		return ec._CoreV1Pod(ctx, sel, &obj)
	case *v13.Pod:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1Pod(ctx, sel, obj)
	case v13.Node:
		return ec._CoreV1Node(ctx, sel, &obj)
	case *v13.Node:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1Node(ctx, sel, obj)
	case v13.Namespace:
		return ec._CoreV1Namespace(ctx, sel, &obj)
	case *v13.Namespace:
		if obj == nil {
			return graphql.Null
		}
		return ec._CoreV1Namespace(ctx, sel, obj)
	case v12.Job:
		return ec._BatchV1Job(ctx, sel, &obj)
	case *v12.Job:
		if obj == nil {
			return graphql.Null
		}
		return ec._BatchV1Job(ctx, sel, obj)
	case v12.CronJob:
		return ec._BatchV1CronJob(ctx, sel, &obj)
	case *v12.CronJob:
		if obj == nil {
			return graphql.Null
		}
		return ec._BatchV1CronJob(ctx, sel, obj)
	case v11.StatefulSet:
		return ec._AppsV1StatefulSet(ctx, sel, &obj)
	case *v11.StatefulSet:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1StatefulSet(ctx, sel, obj)
	case v11.ReplicaSet:
		return ec._AppsV1ReplicaSet(ctx, sel, &obj)
	case *v11.ReplicaSet:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1ReplicaSet(ctx, sel, obj)
	case v11.Deployment:
		return ec._AppsV1Deployment(ctx, sel, &obj)
	case *v11.Deployment:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1Deployment(ctx, sel, obj)
	case v11.DaemonSet:
		return ec._AppsV1DaemonSet(ctx, sel, &obj)
	case *v11.DaemonSet:
		if obj == nil {
			return graphql.Null
		}
		return ec._AppsV1DaemonSet(ctx, sel, obj)
	default:
		panic(fmt.Errorf("unexpected type %T", obj))
	}
}

// endregion ************************** interface.gotpl ***************************

// region    **************************** object.gotpl ****************************

var appsV1DaemonSetImplementors = []string{"AppsV1DaemonSet", "Object"}

func (ec *executionContext) _AppsV1DaemonSet(ctx context.Context, sel ast.SelectionSet, obj *v11.DaemonSet) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSet")
		case "id":
			out.Values[i] = ec._AppsV1DaemonSet_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._AppsV1DaemonSet_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1DaemonSet_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1DaemonSet_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._AppsV1DaemonSet_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._AppsV1DaemonSet_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DaemonSetConditionImplementors = []string{"AppsV1DaemonSetCondition"}

func (ec *executionContext) _AppsV1DaemonSetCondition(ctx context.Context, sel ast.SelectionSet, obj *v11.DaemonSetCondition) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetConditionImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSetCondition")
		case "type":
			out.Values[i] = ec._AppsV1DaemonSetCondition_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._AppsV1DaemonSetCondition_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "lastTransitionTime":
			out.Values[i] = ec._AppsV1DaemonSetCondition_lastTransitionTime(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "reason":
			out.Values[i] = ec._AppsV1DaemonSetCondition_reason(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._AppsV1DaemonSetCondition_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DaemonSetListImplementors = []string{"AppsV1DaemonSetList", "List"}

func (ec *executionContext) _AppsV1DaemonSetList(ctx context.Context, sel ast.SelectionSet, obj *v11.DaemonSetList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSetList")
		case "kind":
			out.Values[i] = ec._AppsV1DaemonSetList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1DaemonSetList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1DaemonSetList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._AppsV1DaemonSetList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DaemonSetSpecImplementors = []string{"AppsV1DaemonSetSpec"}

func (ec *executionContext) _AppsV1DaemonSetSpec(ctx context.Context, sel ast.SelectionSet, obj *v11.DaemonSetSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSetSpec")
		case "selector":
			out.Values[i] = ec._AppsV1DaemonSetSpec_selector(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DaemonSetStatusImplementors = []string{"AppsV1DaemonSetStatus"}

func (ec *executionContext) _AppsV1DaemonSetStatus(ctx context.Context, sel ast.SelectionSet, obj *v11.DaemonSetStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSetStatus")
		case "currentNumberScheduled":
			out.Values[i] = ec._AppsV1DaemonSetStatus_currentNumberScheduled(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "numberMisscheduled":
			out.Values[i] = ec._AppsV1DaemonSetStatus_numberMisscheduled(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "desiredNumberScheduled":
			out.Values[i] = ec._AppsV1DaemonSetStatus_desiredNumberScheduled(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "numberReady":
			out.Values[i] = ec._AppsV1DaemonSetStatus_numberReady(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "observedGeneration":
			out.Values[i] = ec._AppsV1DaemonSetStatus_observedGeneration(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "updatedNumberScheduled":
			out.Values[i] = ec._AppsV1DaemonSetStatus_updatedNumberScheduled(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "numberAvailable":
			out.Values[i] = ec._AppsV1DaemonSetStatus_numberAvailable(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "numberUnavailable":
			out.Values[i] = ec._AppsV1DaemonSetStatus_numberUnavailable(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "conditions":
			out.Values[i] = ec._AppsV1DaemonSetStatus_conditions(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DaemonSetsWatchEventImplementors = []string{"AppsV1DaemonSetsWatchEvent"}

func (ec *executionContext) _AppsV1DaemonSetsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DaemonSetsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DaemonSetsWatchEvent")
		case "type":
			out.Values[i] = ec._AppsV1DaemonSetsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._AppsV1DaemonSetsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DeploymentImplementors = []string{"AppsV1Deployment", "Object"}

func (ec *executionContext) _AppsV1Deployment(ctx context.Context, sel ast.SelectionSet, obj *v11.Deployment) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DeploymentImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1Deployment")
		case "id":
			out.Values[i] = ec._AppsV1Deployment_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._AppsV1Deployment_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1Deployment_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1Deployment_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._AppsV1Deployment_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._AppsV1Deployment_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DeploymentListImplementors = []string{"AppsV1DeploymentList", "List"}

func (ec *executionContext) _AppsV1DeploymentList(ctx context.Context, sel ast.SelectionSet, obj *v11.DeploymentList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DeploymentListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DeploymentList")
		case "kind":
			out.Values[i] = ec._AppsV1DeploymentList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1DeploymentList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1DeploymentList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._AppsV1DeploymentList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DeploymentSpecImplementors = []string{"AppsV1DeploymentSpec"}

func (ec *executionContext) _AppsV1DeploymentSpec(ctx context.Context, sel ast.SelectionSet, obj *v11.DeploymentSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DeploymentSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DeploymentSpec")
		case "replicas":
			out.Values[i] = ec._AppsV1DeploymentSpec_replicas(ctx, field, obj)
		case "selector":
			out.Values[i] = ec._AppsV1DeploymentSpec_selector(ctx, field, obj)
		case "paused":
			out.Values[i] = ec._AppsV1DeploymentSpec_paused(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DeploymentStatusImplementors = []string{"AppsV1DeploymentStatus"}

func (ec *executionContext) _AppsV1DeploymentStatus(ctx context.Context, sel ast.SelectionSet, obj *v11.DeploymentStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DeploymentStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DeploymentStatus")
		case "replicas":
			out.Values[i] = ec._AppsV1DeploymentStatus_replicas(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1DeploymentsWatchEventImplementors = []string{"AppsV1DeploymentsWatchEvent"}

func (ec *executionContext) _AppsV1DeploymentsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1DeploymentsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1DeploymentsWatchEvent")
		case "type":
			out.Values[i] = ec._AppsV1DeploymentsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._AppsV1DeploymentsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1ReplicaSetImplementors = []string{"AppsV1ReplicaSet", "Object"}

func (ec *executionContext) _AppsV1ReplicaSet(ctx context.Context, sel ast.SelectionSet, obj *v11.ReplicaSet) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1ReplicaSetImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1ReplicaSet")
		case "id":
			out.Values[i] = ec._AppsV1ReplicaSet_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._AppsV1ReplicaSet_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1ReplicaSet_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1ReplicaSet_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._AppsV1ReplicaSet_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._AppsV1ReplicaSet_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1ReplicaSetListImplementors = []string{"AppsV1ReplicaSetList", "List"}

func (ec *executionContext) _AppsV1ReplicaSetList(ctx context.Context, sel ast.SelectionSet, obj *v11.ReplicaSetList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1ReplicaSetListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1ReplicaSetList")
		case "kind":
			out.Values[i] = ec._AppsV1ReplicaSetList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1ReplicaSetList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1ReplicaSetList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._AppsV1ReplicaSetList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1ReplicaSetSpecImplementors = []string{"AppsV1ReplicaSetSpec"}

func (ec *executionContext) _AppsV1ReplicaSetSpec(ctx context.Context, sel ast.SelectionSet, obj *v11.ReplicaSetSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1ReplicaSetSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1ReplicaSetSpec")
		case "replicas":
			out.Values[i] = ec._AppsV1ReplicaSetSpec_replicas(ctx, field, obj)
		case "selector":
			out.Values[i] = ec._AppsV1ReplicaSetSpec_selector(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1ReplicaSetStatusImplementors = []string{"AppsV1ReplicaSetStatus"}

func (ec *executionContext) _AppsV1ReplicaSetStatus(ctx context.Context, sel ast.SelectionSet, obj *v11.ReplicaSetStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1ReplicaSetStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1ReplicaSetStatus")
		case "replicas":
			out.Values[i] = ec._AppsV1ReplicaSetStatus_replicas(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1ReplicaSetsWatchEventImplementors = []string{"AppsV1ReplicaSetsWatchEvent"}

func (ec *executionContext) _AppsV1ReplicaSetsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1ReplicaSetsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1ReplicaSetsWatchEvent")
		case "type":
			out.Values[i] = ec._AppsV1ReplicaSetsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._AppsV1ReplicaSetsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1StatefulSetImplementors = []string{"AppsV1StatefulSet", "Object"}

func (ec *executionContext) _AppsV1StatefulSet(ctx context.Context, sel ast.SelectionSet, obj *v11.StatefulSet) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1StatefulSetImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1StatefulSet")
		case "id":
			out.Values[i] = ec._AppsV1StatefulSet_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._AppsV1StatefulSet_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1StatefulSet_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1StatefulSet_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._AppsV1StatefulSet_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1StatefulSetListImplementors = []string{"AppsV1StatefulSetList", "List"}

func (ec *executionContext) _AppsV1StatefulSetList(ctx context.Context, sel ast.SelectionSet, obj *v11.StatefulSetList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1StatefulSetListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1StatefulSetList")
		case "kind":
			out.Values[i] = ec._AppsV1StatefulSetList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._AppsV1StatefulSetList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._AppsV1StatefulSetList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._AppsV1StatefulSetList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1StatefulSetSpecImplementors = []string{"AppsV1StatefulSetSpec"}

func (ec *executionContext) _AppsV1StatefulSetSpec(ctx context.Context, sel ast.SelectionSet, obj *v11.StatefulSetSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1StatefulSetSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1StatefulSetSpec")
		case "replicas":
			out.Values[i] = ec._AppsV1StatefulSetSpec_replicas(ctx, field, obj)
		case "selector":
			out.Values[i] = ec._AppsV1StatefulSetSpec_selector(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var appsV1StatefulSetsWatchEventImplementors = []string{"AppsV1StatefulSetsWatchEvent"}

func (ec *executionContext) _AppsV1StatefulSetsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, appsV1StatefulSetsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("AppsV1StatefulSetsWatchEvent")
		case "type":
			out.Values[i] = ec._AppsV1StatefulSetsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._AppsV1StatefulSetsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1CronJobImplementors = []string{"BatchV1CronJob", "Object"}

func (ec *executionContext) _BatchV1CronJob(ctx context.Context, sel ast.SelectionSet, obj *v12.CronJob) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1CronJobImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1CronJob")
		case "id":
			out.Values[i] = ec._BatchV1CronJob_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._BatchV1CronJob_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._BatchV1CronJob_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._BatchV1CronJob_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._BatchV1CronJob_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._BatchV1CronJob_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1CronJobListImplementors = []string{"BatchV1CronJobList", "List"}

func (ec *executionContext) _BatchV1CronJobList(ctx context.Context, sel ast.SelectionSet, obj *v12.CronJobList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1CronJobListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1CronJobList")
		case "kind":
			out.Values[i] = ec._BatchV1CronJobList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._BatchV1CronJobList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._BatchV1CronJobList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._BatchV1CronJobList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1CronJobSpecImplementors = []string{"BatchV1CronJobSpec"}

func (ec *executionContext) _BatchV1CronJobSpec(ctx context.Context, sel ast.SelectionSet, obj *v12.CronJobSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1CronJobSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1CronJobSpec")
		case "schedule":
			out.Values[i] = ec._BatchV1CronJobSpec_schedule(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "timeZone":
			out.Values[i] = ec._BatchV1CronJobSpec_timeZone(ctx, field, obj)
		case "suspend":
			out.Values[i] = ec._BatchV1CronJobSpec_suspend(ctx, field, obj)
		case "jobTemplate":
			out.Values[i] = ec._BatchV1CronJobSpec_jobTemplate(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "successfulJobsHistoryLimit":
			out.Values[i] = ec._BatchV1CronJobSpec_successfulJobsHistoryLimit(ctx, field, obj)
		case "failedJobsHistoryLimit":
			out.Values[i] = ec._BatchV1CronJobSpec_failedJobsHistoryLimit(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1CronJobStatusImplementors = []string{"BatchV1CronJobStatus"}

func (ec *executionContext) _BatchV1CronJobStatus(ctx context.Context, sel ast.SelectionSet, obj *v12.CronJobStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1CronJobStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1CronJobStatus")
		case "active":
			out.Values[i] = ec._BatchV1CronJobStatus_active(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "lastScheduleTime":
			out.Values[i] = ec._BatchV1CronJobStatus_lastScheduleTime(ctx, field, obj)
		case "lastSuccessfulTime":
			out.Values[i] = ec._BatchV1CronJobStatus_lastSuccessfulTime(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1CronJobsWatchEventImplementors = []string{"BatchV1CronJobsWatchEvent"}

func (ec *executionContext) _BatchV1CronJobsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1CronJobsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1CronJobsWatchEvent")
		case "type":
			out.Values[i] = ec._BatchV1CronJobsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._BatchV1CronJobsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobImplementors = []string{"BatchV1Job", "Object"}

func (ec *executionContext) _BatchV1Job(ctx context.Context, sel ast.SelectionSet, obj *v12.Job) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1Job")
		case "id":
			out.Values[i] = ec._BatchV1Job_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._BatchV1Job_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._BatchV1Job_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._BatchV1Job_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._BatchV1Job_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._BatchV1Job_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobConditionImplementors = []string{"BatchV1JobCondition"}

func (ec *executionContext) _BatchV1JobCondition(ctx context.Context, sel ast.SelectionSet, obj *v12.JobCondition) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobConditionImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobCondition")
		case "type":
			out.Values[i] = ec._BatchV1JobCondition_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._BatchV1JobCondition_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "lastProbeTime":
			out.Values[i] = ec._BatchV1JobCondition_lastProbeTime(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "lastTransitionTime":
			out.Values[i] = ec._BatchV1JobCondition_lastTransitionTime(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "reason":
			out.Values[i] = ec._BatchV1JobCondition_reason(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._BatchV1JobCondition_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobListImplementors = []string{"BatchV1JobList", "List"}

func (ec *executionContext) _BatchV1JobList(ctx context.Context, sel ast.SelectionSet, obj *v12.JobList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobList")
		case "kind":
			out.Values[i] = ec._BatchV1JobList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._BatchV1JobList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._BatchV1JobList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._BatchV1JobList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobSpecImplementors = []string{"BatchV1JobSpec"}

func (ec *executionContext) _BatchV1JobSpec(ctx context.Context, sel ast.SelectionSet, obj *v12.JobSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobSpec")
		case "parallelism":
			out.Values[i] = ec._BatchV1JobSpec_parallelism(ctx, field, obj)
		case "completions":
			out.Values[i] = ec._BatchV1JobSpec_completions(ctx, field, obj)
		case "backoffLimit":
			out.Values[i] = ec._BatchV1JobSpec_backoffLimit(ctx, field, obj)
		case "selector":
			out.Values[i] = ec._BatchV1JobSpec_selector(ctx, field, obj)
		case "manualSelector":
			out.Values[i] = ec._BatchV1JobSpec_manualSelector(ctx, field, obj)
		case "ttlSecondsAfterFinished":
			out.Values[i] = ec._BatchV1JobSpec_ttlSecondsAfterFinished(ctx, field, obj)
		case "suspend":
			out.Values[i] = ec._BatchV1JobSpec_suspend(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobStatusImplementors = []string{"BatchV1JobStatus"}

func (ec *executionContext) _BatchV1JobStatus(ctx context.Context, sel ast.SelectionSet, obj *v12.JobStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobStatus")
		case "conditions":
			out.Values[i] = ec._BatchV1JobStatus_conditions(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "startTime":
			out.Values[i] = ec._BatchV1JobStatus_startTime(ctx, field, obj)
		case "completionTime":
			out.Values[i] = ec._BatchV1JobStatus_completionTime(ctx, field, obj)
		case "active":
			out.Values[i] = ec._BatchV1JobStatus_active(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "succeeded":
			out.Values[i] = ec._BatchV1JobStatus_succeeded(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "failed":
			out.Values[i] = ec._BatchV1JobStatus_failed(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "completedIndexes":
			out.Values[i] = ec._BatchV1JobStatus_completedIndexes(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "ready":
			out.Values[i] = ec._BatchV1JobStatus_ready(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobTemplateSpecImplementors = []string{"BatchV1JobTemplateSpec"}

func (ec *executionContext) _BatchV1JobTemplateSpec(ctx context.Context, sel ast.SelectionSet, obj *v12.JobTemplateSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobTemplateSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobTemplateSpec")
		case "metadata":
			out.Values[i] = ec._BatchV1JobTemplateSpec_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._BatchV1JobTemplateSpec_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var batchV1JobsWatchEventImplementors = []string{"BatchV1JobsWatchEvent"}

func (ec *executionContext) _BatchV1JobsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, batchV1JobsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("BatchV1JobsWatchEvent")
		case "type":
			out.Values[i] = ec._BatchV1JobsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._BatchV1JobsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerImplementors = []string{"CoreV1Container"}

func (ec *executionContext) _CoreV1Container(ctx context.Context, sel ast.SelectionSet, obj *v13.Container) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1Container")
		case "name":
			out.Values[i] = ec._CoreV1Container_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "image":
			out.Values[i] = ec._CoreV1Container_image(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerStateImplementors = []string{"CoreV1ContainerState"}

func (ec *executionContext) _CoreV1ContainerState(ctx context.Context, sel ast.SelectionSet, obj *v13.ContainerState) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerStateImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ContainerState")
		case "waiting":
			out.Values[i] = ec._CoreV1ContainerState_waiting(ctx, field, obj)
		case "running":
			out.Values[i] = ec._CoreV1ContainerState_running(ctx, field, obj)
		case "terminated":
			out.Values[i] = ec._CoreV1ContainerState_terminated(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerStateRunningImplementors = []string{"CoreV1ContainerStateRunning"}

func (ec *executionContext) _CoreV1ContainerStateRunning(ctx context.Context, sel ast.SelectionSet, obj *v13.ContainerStateRunning) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerStateRunningImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ContainerStateRunning")
		case "startedAt":
			out.Values[i] = ec._CoreV1ContainerStateRunning_startedAt(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerStateTerminatedImplementors = []string{"CoreV1ContainerStateTerminated"}

func (ec *executionContext) _CoreV1ContainerStateTerminated(ctx context.Context, sel ast.SelectionSet, obj *v13.ContainerStateTerminated) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerStateTerminatedImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ContainerStateTerminated")
		case "exitCode":
			out.Values[i] = ec._CoreV1ContainerStateTerminated_exitCode(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "signal":
			out.Values[i] = ec._CoreV1ContainerStateTerminated_signal(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "reason":
			out.Values[i] = ec._CoreV1ContainerStateTerminated_reason(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._CoreV1ContainerStateTerminated_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "containerID":
			out.Values[i] = ec._CoreV1ContainerStateTerminated_containerID(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerStateWaitingImplementors = []string{"CoreV1ContainerStateWaiting"}

func (ec *executionContext) _CoreV1ContainerStateWaiting(ctx context.Context, sel ast.SelectionSet, obj *v13.ContainerStateWaiting) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerStateWaitingImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ContainerStateWaiting")
		case "reason":
			out.Values[i] = ec._CoreV1ContainerStateWaiting_reason(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._CoreV1ContainerStateWaiting_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ContainerStatusImplementors = []string{"CoreV1ContainerStatus"}

func (ec *executionContext) _CoreV1ContainerStatus(ctx context.Context, sel ast.SelectionSet, obj *v13.ContainerStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ContainerStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ContainerStatus")
		case "name":
			out.Values[i] = ec._CoreV1ContainerStatus_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "state":
			out.Values[i] = ec._CoreV1ContainerStatus_state(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "lastTerminationState":
			out.Values[i] = ec._CoreV1ContainerStatus_lastTerminationState(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "ready":
			out.Values[i] = ec._CoreV1ContainerStatus_ready(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "restartCount":
			out.Values[i] = ec._CoreV1ContainerStatus_restartCount(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "image":
			out.Values[i] = ec._CoreV1ContainerStatus_image(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "imageID":
			out.Values[i] = ec._CoreV1ContainerStatus_imageID(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "containerID":
			out.Values[i] = ec._CoreV1ContainerStatus_containerID(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "started":
			out.Values[i] = ec._CoreV1ContainerStatus_started(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NamespaceImplementors = []string{"CoreV1Namespace", "Object"}

func (ec *executionContext) _CoreV1Namespace(ctx context.Context, sel ast.SelectionSet, obj *v13.Namespace) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NamespaceImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1Namespace")
		case "id":
			out.Values[i] = ec._CoreV1Namespace_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._CoreV1Namespace_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1Namespace_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1Namespace_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NamespaceListImplementors = []string{"CoreV1NamespaceList", "List"}

func (ec *executionContext) _CoreV1NamespaceList(ctx context.Context, sel ast.SelectionSet, obj *v13.NamespaceList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NamespaceListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1NamespaceList")
		case "kind":
			out.Values[i] = ec._CoreV1NamespaceList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1NamespaceList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1NamespaceList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._CoreV1NamespaceList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NamespacesWatchEventImplementors = []string{"CoreV1NamespacesWatchEvent"}

func (ec *executionContext) _CoreV1NamespacesWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NamespacesWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1NamespacesWatchEvent")
		case "type":
			out.Values[i] = ec._CoreV1NamespacesWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._CoreV1NamespacesWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NodeImplementors = []string{"CoreV1Node", "Object"}

func (ec *executionContext) _CoreV1Node(ctx context.Context, sel ast.SelectionSet, obj *v13.Node) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NodeImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1Node")
		case "id":
			out.Values[i] = ec._CoreV1Node_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._CoreV1Node_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1Node_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1Node_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NodeListImplementors = []string{"CoreV1NodeList", "List"}

func (ec *executionContext) _CoreV1NodeList(ctx context.Context, sel ast.SelectionSet, obj *v13.NodeList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NodeListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1NodeList")
		case "kind":
			out.Values[i] = ec._CoreV1NodeList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1NodeList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1NodeList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._CoreV1NodeList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1NodesWatchEventImplementors = []string{"CoreV1NodesWatchEvent"}

func (ec *executionContext) _CoreV1NodesWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1NodesWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1NodesWatchEvent")
		case "type":
			out.Values[i] = ec._CoreV1NodesWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._CoreV1NodesWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ObjectReferenceImplementors = []string{"CoreV1ObjectReference"}

func (ec *executionContext) _CoreV1ObjectReference(ctx context.Context, sel ast.SelectionSet, obj *v13.ObjectReference) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ObjectReferenceImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ObjectReference")
		case "kind":
			out.Values[i] = ec._CoreV1ObjectReference_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "namespace":
			out.Values[i] = ec._CoreV1ObjectReference_namespace(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "name":
			out.Values[i] = ec._CoreV1ObjectReference_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "uid":
			out.Values[i] = ec._CoreV1ObjectReference_uid(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1ObjectReference_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "resourceVersion":
			out.Values[i] = ec._CoreV1ObjectReference_resourceVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "fieldPath":
			out.Values[i] = ec._CoreV1ObjectReference_fieldPath(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1PodImplementors = []string{"CoreV1Pod", "Object"}

func (ec *executionContext) _CoreV1Pod(ctx context.Context, sel ast.SelectionSet, obj *v13.Pod) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1PodImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1Pod")
		case "id":
			out.Values[i] = ec._CoreV1Pod_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._CoreV1Pod_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1Pod_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1Pod_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._CoreV1Pod_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "status":
			out.Values[i] = ec._CoreV1Pod_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1PodListImplementors = []string{"CoreV1PodList", "List"}

func (ec *executionContext) _CoreV1PodList(ctx context.Context, sel ast.SelectionSet, obj *v13.PodList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1PodListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1PodList")
		case "kind":
			out.Values[i] = ec._CoreV1PodList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1PodList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1PodList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._CoreV1PodList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1PodSpecImplementors = []string{"CoreV1PodSpec"}

func (ec *executionContext) _CoreV1PodSpec(ctx context.Context, sel ast.SelectionSet, obj *v13.PodSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1PodSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1PodSpec")
		case "containers":
			out.Values[i] = ec._CoreV1PodSpec_containers(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "nodeName":
			out.Values[i] = ec._CoreV1PodSpec_nodeName(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "hostname":
			out.Values[i] = ec._CoreV1PodSpec_hostname(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "priorityClassName":
			out.Values[i] = ec._CoreV1PodSpec_priorityClassName(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1PodStatusImplementors = []string{"CoreV1PodStatus"}

func (ec *executionContext) _CoreV1PodStatus(ctx context.Context, sel ast.SelectionSet, obj *v13.PodStatus) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1PodStatusImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1PodStatus")
		case "phase":
			out.Values[i] = ec._CoreV1PodStatus_phase(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._CoreV1PodStatus_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "reason":
			out.Values[i] = ec._CoreV1PodStatus_reason(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "containerStatuses":
			out.Values[i] = ec._CoreV1PodStatus_containerStatuses(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1PodsWatchEventImplementors = []string{"CoreV1PodsWatchEvent"}

func (ec *executionContext) _CoreV1PodsWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1PodsWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1PodsWatchEvent")
		case "type":
			out.Values[i] = ec._CoreV1PodsWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._CoreV1PodsWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ServiceImplementors = []string{"CoreV1Service", "Object"}

func (ec *executionContext) _CoreV1Service(ctx context.Context, sel ast.SelectionSet, obj *v13.Service) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ServiceImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1Service")
		case "id":
			out.Values[i] = ec._CoreV1Service_id(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._CoreV1Service_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1Service_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1Service_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "spec":
			out.Values[i] = ec._CoreV1Service_spec(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ServiceListImplementors = []string{"CoreV1ServiceList", "List"}

func (ec *executionContext) _CoreV1ServiceList(ctx context.Context, sel ast.SelectionSet, obj *v13.ServiceList) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ServiceListImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ServiceList")
		case "kind":
			out.Values[i] = ec._CoreV1ServiceList_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "apiVersion":
			out.Values[i] = ec._CoreV1ServiceList_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "metadata":
			out.Values[i] = ec._CoreV1ServiceList_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "items":
			out.Values[i] = ec._CoreV1ServiceList_items(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ServicePortImplementors = []string{"CoreV1ServicePort"}

func (ec *executionContext) _CoreV1ServicePort(ctx context.Context, sel ast.SelectionSet, obj *v13.ServicePort) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ServicePortImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ServicePort")
		case "name":
			out.Values[i] = ec._CoreV1ServicePort_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "port":
			out.Values[i] = ec._CoreV1ServicePort_port(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "appProtocol":
			out.Values[i] = ec._CoreV1ServicePort_appProtocol(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ServiceSpecImplementors = []string{"CoreV1ServiceSpec"}

func (ec *executionContext) _CoreV1ServiceSpec(ctx context.Context, sel ast.SelectionSet, obj *v13.ServiceSpec) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ServiceSpecImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ServiceSpec")
		case "ports":
			out.Values[i] = ec._CoreV1ServiceSpec_ports(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "selector":
			out.Values[i] = ec._CoreV1ServiceSpec_selector(ctx, field, obj)
		case "clusterIP":
			out.Values[i] = ec._CoreV1ServiceSpec_clusterIP(ctx, field, obj)
		case "clusterIPs":
			out.Values[i] = ec._CoreV1ServiceSpec_clusterIPs(ctx, field, obj)
		case "externalName":
			out.Values[i] = ec._CoreV1ServiceSpec_externalName(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var coreV1ServicesWatchEventImplementors = []string{"CoreV1ServicesWatchEvent"}

func (ec *executionContext) _CoreV1ServicesWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *watch.Event) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, coreV1ServicesWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("CoreV1ServicesWatchEvent")
		case "type":
			out.Values[i] = ec._CoreV1ServicesWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "object":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._CoreV1ServicesWatchEvent_object(ctx, field, obj)
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var healthCheckResponseImplementors = []string{"HealthCheckResponse"}

func (ec *executionContext) _HealthCheckResponse(ctx context.Context, sel ast.SelectionSet, obj *model.HealthCheckResponse) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, healthCheckResponseImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("HealthCheckResponse")
		case "status":
			out.Values[i] = ec._HealthCheckResponse_status(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._HealthCheckResponse_message(ctx, field, obj)
		case "timestamp":
			out.Values[i] = ec._HealthCheckResponse_timestamp(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var helmChartImplementors = []string{"HelmChart"}

func (ec *executionContext) _HelmChart(ctx context.Context, sel ast.SelectionSet, obj *chart.Chart) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, helmChartImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("HelmChart")
		case "metadata":
			out.Values[i] = ec._HelmChart_metadata(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var helmChartMetadataImplementors = []string{"HelmChartMetadata"}

func (ec *executionContext) _HelmChartMetadata(ctx context.Context, sel ast.SelectionSet, obj *chart.Metadata) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, helmChartMetadataImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("HelmChartMetadata")
		case "name":
			out.Values[i] = ec._HelmChartMetadata_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "version":
			out.Values[i] = ec._HelmChartMetadata_version(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "condition":
			out.Values[i] = ec._HelmChartMetadata_condition(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "appVersion":
			out.Values[i] = ec._HelmChartMetadata_appVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var helmReleaseImplementors = []string{"HelmRelease"}

func (ec *executionContext) _HelmRelease(ctx context.Context, sel ast.SelectionSet, obj *release.Release) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, helmReleaseImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("HelmRelease")
		case "name":
			out.Values[i] = ec._HelmRelease_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "version":
			out.Values[i] = ec._HelmRelease_version(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "namespace":
			out.Values[i] = ec._HelmRelease_namespace(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "chart":
			out.Values[i] = ec._HelmRelease_chart(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var kubeConfigImplementors = []string{"KubeConfig"}

func (ec *executionContext) _KubeConfig(ctx context.Context, sel ast.SelectionSet, obj *model.KubeConfig) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, kubeConfigImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("KubeConfig")
		case "authInfos":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._KubeConfig_authInfos(ctx, field, obj)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		case "clusters":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._KubeConfig_clusters(ctx, field, obj)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		case "contexts":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._KubeConfig_contexts(ctx, field, obj)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			if field.Deferrable != nil {
				dfs, ok := deferred[field.Deferrable.Label]
				di := 0
				if ok {
					dfs.AddField(field)
					di = len(dfs.Values) - 1
				} else {
					dfs = graphql.NewFieldSet([]graphql.CollectedField{field})
					deferred[field.Deferrable.Label] = dfs
				}
				dfs.Concurrently(di, func(ctx context.Context) graphql.Marshaler {
					return innerFunc(ctx, dfs)
				})

				// don't run the out.Concurrently() call below
				out.Values[i] = graphql.Null
				continue
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
		case "currentContext":
			out.Values[i] = ec._KubeConfig_currentContext(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				atomic.AddUint32(&out.Invalids, 1)
			}
		case "extensions":
			out.Values[i] = ec._KubeConfig_extensions(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var kubeConfigAuthInfoImplementors = []string{"KubeConfigAuthInfo"}

func (ec *executionContext) _KubeConfigAuthInfo(ctx context.Context, sel ast.SelectionSet, obj *model.KubeConfigAuthInfo) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, kubeConfigAuthInfoImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("KubeConfigAuthInfo")
		case "name":
			out.Values[i] = ec._KubeConfigAuthInfo_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "locationOfOrigin":
			out.Values[i] = ec._KubeConfigAuthInfo_locationOfOrigin(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "extensions":
			out.Values[i] = ec._KubeConfigAuthInfo_extensions(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var kubeConfigClusterImplementors = []string{"KubeConfigCluster"}

func (ec *executionContext) _KubeConfigCluster(ctx context.Context, sel ast.SelectionSet, obj *model.KubeConfigCluster) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, kubeConfigClusterImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("KubeConfigCluster")
		case "name":
			out.Values[i] = ec._KubeConfigCluster_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "locationOfOrigin":
			out.Values[i] = ec._KubeConfigCluster_locationOfOrigin(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "server":
			out.Values[i] = ec._KubeConfigCluster_server(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "extensions":
			out.Values[i] = ec._KubeConfigCluster_extensions(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var kubeConfigContextImplementors = []string{"KubeConfigContext"}

func (ec *executionContext) _KubeConfigContext(ctx context.Context, sel ast.SelectionSet, obj *model.KubeConfigContext) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, kubeConfigContextImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("KubeConfigContext")
		case "name":
			out.Values[i] = ec._KubeConfigContext_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "locationOfOrigin":
			out.Values[i] = ec._KubeConfigContext_locationOfOrigin(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "cluster":
			out.Values[i] = ec._KubeConfigContext_cluster(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "authInfo":
			out.Values[i] = ec._KubeConfigContext_authInfo(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "namespace":
			out.Values[i] = ec._KubeConfigContext_namespace(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "extensions":
			out.Values[i] = ec._KubeConfigContext_extensions(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var kubeConfigWatchEventImplementors = []string{"KubeConfigWatchEvent"}

func (ec *executionContext) _KubeConfigWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *model.KubeConfigWatchEvent) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, kubeConfigWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("KubeConfigWatchEvent")
		case "type":
			out.Values[i] = ec._KubeConfigWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "object":
			out.Values[i] = ec._KubeConfigWatchEvent_object(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var logRecordImplementors = []string{"LogRecord"}

func (ec *executionContext) _LogRecord(ctx context.Context, sel ast.SelectionSet, obj *logs.LogRecord) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, logRecordImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("LogRecord")
		case "timestamp":
			out.Values[i] = ec._LogRecord_timestamp(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "message":
			out.Values[i] = ec._LogRecord_message(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "source":
			out.Values[i] = ec._LogRecord_source(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var logRecordsQueryResponseImplementors = []string{"LogRecordsQueryResponse"}

func (ec *executionContext) _LogRecordsQueryResponse(ctx context.Context, sel ast.SelectionSet, obj *model.LogRecordsQueryResponse) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, logRecordsQueryResponseImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("LogRecordsQueryResponse")
		case "records":
			out.Values[i] = ec._LogRecordsQueryResponse_records(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "nextCursor":
			out.Values[i] = ec._LogRecordsQueryResponse_nextCursor(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var logSourceImplementors = []string{"LogSource"}

func (ec *executionContext) _LogSource(ctx context.Context, sel ast.SelectionSet, obj *logs.LogSource) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, logSourceImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("LogSource")
		case "metadata":
			out.Values[i] = ec._LogSource_metadata(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "namespace":
			out.Values[i] = ec._LogSource_namespace(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "podName":
			out.Values[i] = ec._LogSource_podName(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "containerName":
			out.Values[i] = ec._LogSource_containerName(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "containerID":
			out.Values[i] = ec._LogSource_containerID(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var logSourceMetadataImplementors = []string{"LogSourceMetadata"}

func (ec *executionContext) _LogSourceMetadata(ctx context.Context, sel ast.SelectionSet, obj *logs.LogSourceMetadata) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, logSourceMetadataImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("LogSourceMetadata")
		case "region":
			out.Values[i] = ec._LogSourceMetadata_region(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "zone":
			out.Values[i] = ec._LogSourceMetadata_zone(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "os":
			out.Values[i] = ec._LogSourceMetadata_os(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "arch":
			out.Values[i] = ec._LogSourceMetadata_arch(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "node":
			out.Values[i] = ec._LogSourceMetadata_node(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var logSourceWatchEventImplementors = []string{"LogSourceWatchEvent"}

func (ec *executionContext) _LogSourceWatchEvent(ctx context.Context, sel ast.SelectionSet, obj *model.LogSourceWatchEvent) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, logSourceWatchEventImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("LogSourceWatchEvent")
		case "type":
			out.Values[i] = ec._LogSourceWatchEvent_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "object":
			out.Values[i] = ec._LogSourceWatchEvent_object(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var metaV1LabelSelectorImplementors = []string{"MetaV1LabelSelector"}

func (ec *executionContext) _MetaV1LabelSelector(ctx context.Context, sel ast.SelectionSet, obj *v1.LabelSelector) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, metaV1LabelSelectorImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("MetaV1LabelSelector")
		case "matchLabels":
			out.Values[i] = ec._MetaV1LabelSelector_matchLabels(ctx, field, obj)
		case "matchExpressions":
			out.Values[i] = ec._MetaV1LabelSelector_matchExpressions(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var metaV1LabelSelectorRequirementImplementors = []string{"MetaV1LabelSelectorRequirement"}

func (ec *executionContext) _MetaV1LabelSelectorRequirement(ctx context.Context, sel ast.SelectionSet, obj *v1.LabelSelectorRequirement) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, metaV1LabelSelectorRequirementImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("MetaV1LabelSelectorRequirement")
		case "key":
			out.Values[i] = ec._MetaV1LabelSelectorRequirement_key(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "operator":
			out.Values[i] = ec._MetaV1LabelSelectorRequirement_operator(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "values":
			out.Values[i] = ec._MetaV1LabelSelectorRequirement_values(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var metaV1ListMetaImplementors = []string{"MetaV1ListMeta"}

func (ec *executionContext) _MetaV1ListMeta(ctx context.Context, sel ast.SelectionSet, obj *v1.ListMeta) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, metaV1ListMetaImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("MetaV1ListMeta")
		case "resourceVersion":
			out.Values[i] = ec._MetaV1ListMeta_resourceVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "continue":
			out.Values[i] = ec._MetaV1ListMeta_continue(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "remainingItemCount":
			out.Values[i] = ec._MetaV1ListMeta_remainingItemCount(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var metaV1ObjectMetaImplementors = []string{"MetaV1ObjectMeta"}

func (ec *executionContext) _MetaV1ObjectMeta(ctx context.Context, sel ast.SelectionSet, obj *v1.ObjectMeta) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, metaV1ObjectMetaImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("MetaV1ObjectMeta")
		case "uid":
			out.Values[i] = ec._MetaV1ObjectMeta_uid(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "name":
			out.Values[i] = ec._MetaV1ObjectMeta_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "namespace":
			out.Values[i] = ec._MetaV1ObjectMeta_namespace(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "resourceVersion":
			out.Values[i] = ec._MetaV1ObjectMeta_resourceVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "creationTimestamp":
			out.Values[i] = ec._MetaV1ObjectMeta_creationTimestamp(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "deletionTimestamp":
			out.Values[i] = ec._MetaV1ObjectMeta_deletionTimestamp(ctx, field, obj)
		case "labels":
			out.Values[i] = ec._MetaV1ObjectMeta_labels(ctx, field, obj)
		case "annotations":
			out.Values[i] = ec._MetaV1ObjectMeta_annotations(ctx, field, obj)
		case "ownerReferences":
			out.Values[i] = ec._MetaV1ObjectMeta_ownerReferences(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var metaV1OwnerReferenceImplementors = []string{"MetaV1OwnerReference"}

func (ec *executionContext) _MetaV1OwnerReference(ctx context.Context, sel ast.SelectionSet, obj *v1.OwnerReference) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, metaV1OwnerReferenceImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("MetaV1OwnerReference")
		case "apiVersion":
			out.Values[i] = ec._MetaV1OwnerReference_apiVersion(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "kind":
			out.Values[i] = ec._MetaV1OwnerReference_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "name":
			out.Values[i] = ec._MetaV1OwnerReference_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "uid":
			out.Values[i] = ec._MetaV1OwnerReference_uid(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "controller":
			out.Values[i] = ec._MetaV1OwnerReference_controller(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var mutationImplementors = []string{"Mutation"}

func (ec *executionContext) _Mutation(ctx context.Context, sel ast.SelectionSet) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, mutationImplementors)
	ctx = graphql.WithFieldContext(ctx, &graphql.FieldContext{
		Object: "Mutation",
	})

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		innerCtx := graphql.WithRootFieldContext(ctx, &graphql.RootFieldContext{
			Object: field.Name,
			Field:  field,
		})

		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("Mutation")
		case "helmInstallLatest":
			out.Values[i] = ec.OperationContext.RootResolverMiddleware(innerCtx, func(ctx context.Context) (res graphql.Marshaler) {
				return ec._Mutation_helmInstallLatest(ctx, field)
			})
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var pageInfoImplementors = []string{"PageInfo"}

func (ec *executionContext) _PageInfo(ctx context.Context, sel ast.SelectionSet, obj *model.PageInfo) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, pageInfoImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("PageInfo")
		case "endCursor":
			out.Values[i] = ec._PageInfo_endCursor(ctx, field, obj)
		case "hasNextPage":
			out.Values[i] = ec._PageInfo_hasNextPage(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "hasPreviousPage":
			out.Values[i] = ec._PageInfo_hasPreviousPage(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "startCursor":
			out.Values[i] = ec._PageInfo_startCursor(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var queryImplementors = []string{"Query"}

func (ec *executionContext) _Query(ctx context.Context, sel ast.SelectionSet) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, queryImplementors)
	ctx = graphql.WithFieldContext(ctx, &graphql.FieldContext{
		Object: "Query",
	})

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		innerCtx := graphql.WithRootFieldContext(ctx, &graphql.RootFieldContext{
			Object: field.Name,
			Field:  field,
		})

		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("Query")
		case "appsV1DaemonSetsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1DaemonSetsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1DaemonSetsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1DaemonSetsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1DeploymentsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1DeploymentsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1DeploymentsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1DeploymentsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1ReplicaSetsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1ReplicaSetsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1ReplicaSetsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1ReplicaSetsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1StatefulSetsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1StatefulSetsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "appsV1StatefulSetsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_appsV1StatefulSetsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "batchV1CronJobsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_batchV1CronJobsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "batchV1CronJobsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_batchV1CronJobsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "batchV1JobsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_batchV1JobsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "batchV1JobsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_batchV1JobsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1NamespacesList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1NamespacesList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1NodesList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1NodesList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1PodsGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1PodsGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1PodsList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1PodsList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1ServicesGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1ServicesGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "coreV1ServicesList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_coreV1ServicesList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "clusterAPIReadyWait":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_clusterAPIReadyWait(ctx, field)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "clusterAPIHealthzGet":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_clusterAPIHealthzGet(ctx, field)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "clusterAPIServicesList":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_clusterAPIServicesList(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "helmListReleases":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_helmListReleases(ctx, field)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "kubeConfigGet":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_kubeConfigGet(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "kubernetesAPIReadyWait":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_kubernetesAPIReadyWait(ctx, field)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "kubernetesAPIHealthzGet":
			field := field

			innerFunc := func(ctx context.Context, fs *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_kubernetesAPIHealthzGet(ctx, field)
				if res == graphql.Null {
					atomic.AddUint32(&fs.Invalids, 1)
				}
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "logRecordsFetch":
			field := field

			innerFunc := func(ctx context.Context, _ *graphql.FieldSet) (res graphql.Marshaler) {
				defer func() {
					if r := recover(); r != nil {
						ec.Error(ctx, ec.Recover(ctx, r))
					}
				}()
				res = ec._Query_logRecordsFetch(ctx, field)
				return res
			}

			rrm := func(ctx context.Context) graphql.Marshaler {
				return ec.OperationContext.RootResolverMiddleware(ctx,
					func(ctx context.Context) graphql.Marshaler { return innerFunc(ctx, out) })
			}

			out.Concurrently(i, func(ctx context.Context) graphql.Marshaler { return rrm(innerCtx) })
		case "__type":
			out.Values[i] = ec.OperationContext.RootResolverMiddleware(innerCtx, func(ctx context.Context) (res graphql.Marshaler) {
				return ec._Query___type(ctx, field)
			})
		case "__schema":
			out.Values[i] = ec.OperationContext.RootResolverMiddleware(innerCtx, func(ctx context.Context) (res graphql.Marshaler) {
				return ec._Query___schema(ctx, field)
			})
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var subscriptionImplementors = []string{"Subscription"}

func (ec *executionContext) _Subscription(ctx context.Context, sel ast.SelectionSet) func(ctx context.Context) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, subscriptionImplementors)
	ctx = graphql.WithFieldContext(ctx, &graphql.FieldContext{
		Object: "Subscription",
	})
	if len(fields) != 1 {
		ec.Errorf(ctx, "must subscribe to exactly one stream")
		return nil
	}

	switch fields[0].Name {
	case "appsV1DaemonSetsWatch":
		return ec._Subscription_appsV1DaemonSetsWatch(ctx, fields[0])
	case "appsV1DeploymentsWatch":
		return ec._Subscription_appsV1DeploymentsWatch(ctx, fields[0])
	case "appsV1ReplicaSetsWatch":
		return ec._Subscription_appsV1ReplicaSetsWatch(ctx, fields[0])
	case "appsV1StatefulSetsWatch":
		return ec._Subscription_appsV1StatefulSetsWatch(ctx, fields[0])
	case "batchV1CronJobsWatch":
		return ec._Subscription_batchV1CronJobsWatch(ctx, fields[0])
	case "batchV1JobsWatch":
		return ec._Subscription_batchV1JobsWatch(ctx, fields[0])
	case "coreV1NamespacesWatch":
		return ec._Subscription_coreV1NamespacesWatch(ctx, fields[0])
	case "coreV1NodesWatch":
		return ec._Subscription_coreV1NodesWatch(ctx, fields[0])
	case "coreV1PodsWatch":
		return ec._Subscription_coreV1PodsWatch(ctx, fields[0])
	case "coreV1ServicesWatch":
		return ec._Subscription_coreV1ServicesWatch(ctx, fields[0])
	case "kubernetesAPIReadyWait":
		return ec._Subscription_kubernetesAPIReadyWait(ctx, fields[0])
	case "kubernetesAPIHealthzWatch":
		return ec._Subscription_kubernetesAPIHealthzWatch(ctx, fields[0])
	case "clusterAPIReadyWait":
		return ec._Subscription_clusterAPIReadyWait(ctx, fields[0])
	case "clusterAPIHealthzWatch":
		return ec._Subscription_clusterAPIHealthzWatch(ctx, fields[0])
	case "clusterAPIServicesWatch":
		return ec._Subscription_clusterAPIServicesWatch(ctx, fields[0])
	case "kubeConfigWatch":
		return ec._Subscription_kubeConfigWatch(ctx, fields[0])
	case "logRecordsFollow":
		return ec._Subscription_logRecordsFollow(ctx, fields[0])
	case "logSourcesWatch":
		return ec._Subscription_logSourcesWatch(ctx, fields[0])
	default:
		panic("unknown field " + strconv.Quote(fields[0].Name))
	}
}

var __DirectiveImplementors = []string{"__Directive"}

func (ec *executionContext) ___Directive(ctx context.Context, sel ast.SelectionSet, obj *introspection.Directive) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __DirectiveImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__Directive")
		case "name":
			out.Values[i] = ec.___Directive_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "description":
			out.Values[i] = ec.___Directive_description(ctx, field, obj)
		case "isRepeatable":
			out.Values[i] = ec.___Directive_isRepeatable(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "locations":
			out.Values[i] = ec.___Directive_locations(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "args":
			out.Values[i] = ec.___Directive_args(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var __EnumValueImplementors = []string{"__EnumValue"}

func (ec *executionContext) ___EnumValue(ctx context.Context, sel ast.SelectionSet, obj *introspection.EnumValue) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __EnumValueImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__EnumValue")
		case "name":
			out.Values[i] = ec.___EnumValue_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "description":
			out.Values[i] = ec.___EnumValue_description(ctx, field, obj)
		case "isDeprecated":
			out.Values[i] = ec.___EnumValue_isDeprecated(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "deprecationReason":
			out.Values[i] = ec.___EnumValue_deprecationReason(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var __FieldImplementors = []string{"__Field"}

func (ec *executionContext) ___Field(ctx context.Context, sel ast.SelectionSet, obj *introspection.Field) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __FieldImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__Field")
		case "name":
			out.Values[i] = ec.___Field_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "description":
			out.Values[i] = ec.___Field_description(ctx, field, obj)
		case "args":
			out.Values[i] = ec.___Field_args(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "type":
			out.Values[i] = ec.___Field_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "isDeprecated":
			out.Values[i] = ec.___Field_isDeprecated(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "deprecationReason":
			out.Values[i] = ec.___Field_deprecationReason(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var __InputValueImplementors = []string{"__InputValue"}

func (ec *executionContext) ___InputValue(ctx context.Context, sel ast.SelectionSet, obj *introspection.InputValue) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __InputValueImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__InputValue")
		case "name":
			out.Values[i] = ec.___InputValue_name(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "description":
			out.Values[i] = ec.___InputValue_description(ctx, field, obj)
		case "type":
			out.Values[i] = ec.___InputValue_type(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "defaultValue":
			out.Values[i] = ec.___InputValue_defaultValue(ctx, field, obj)
		case "isDeprecated":
			out.Values[i] = ec.___InputValue_isDeprecated(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "deprecationReason":
			out.Values[i] = ec.___InputValue_deprecationReason(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var __SchemaImplementors = []string{"__Schema"}

func (ec *executionContext) ___Schema(ctx context.Context, sel ast.SelectionSet, obj *introspection.Schema) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __SchemaImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__Schema")
		case "description":
			out.Values[i] = ec.___Schema_description(ctx, field, obj)
		case "types":
			out.Values[i] = ec.___Schema_types(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "queryType":
			out.Values[i] = ec.___Schema_queryType(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "mutationType":
			out.Values[i] = ec.___Schema_mutationType(ctx, field, obj)
		case "subscriptionType":
			out.Values[i] = ec.___Schema_subscriptionType(ctx, field, obj)
		case "directives":
			out.Values[i] = ec.___Schema_directives(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

var __TypeImplementors = []string{"__Type"}

func (ec *executionContext) ___Type(ctx context.Context, sel ast.SelectionSet, obj *introspection.Type) graphql.Marshaler {
	fields := graphql.CollectFields(ec.OperationContext, sel, __TypeImplementors)

	out := graphql.NewFieldSet(fields)
	deferred := make(map[string]*graphql.FieldSet)
	for i, field := range fields {
		switch field.Name {
		case "__typename":
			out.Values[i] = graphql.MarshalString("__Type")
		case "kind":
			out.Values[i] = ec.___Type_kind(ctx, field, obj)
			if out.Values[i] == graphql.Null {
				out.Invalids++
			}
		case "name":
			out.Values[i] = ec.___Type_name(ctx, field, obj)
		case "description":
			out.Values[i] = ec.___Type_description(ctx, field, obj)
		case "specifiedByURL":
			out.Values[i] = ec.___Type_specifiedByURL(ctx, field, obj)
		case "fields":
			out.Values[i] = ec.___Type_fields(ctx, field, obj)
		case "interfaces":
			out.Values[i] = ec.___Type_interfaces(ctx, field, obj)
		case "possibleTypes":
			out.Values[i] = ec.___Type_possibleTypes(ctx, field, obj)
		case "enumValues":
			out.Values[i] = ec.___Type_enumValues(ctx, field, obj)
		case "inputFields":
			out.Values[i] = ec.___Type_inputFields(ctx, field, obj)
		case "ofType":
			out.Values[i] = ec.___Type_ofType(ctx, field, obj)
		case "isOneOf":
			out.Values[i] = ec.___Type_isOneOf(ctx, field, obj)
		default:
			panic("unknown field " + strconv.Quote(field.Name))
		}
	}
	out.Dispatch(ctx)
	if out.Invalids > 0 {
		return graphql.Null
	}

	atomic.AddInt32(&ec.deferred, int32(len(deferred)))

	for label, dfs := range deferred {
		ec.processDeferredGroup(graphql.DeferredGroup{
			Label:    label,
			Path:     graphql.GetPath(ctx),
			FieldSet: dfs,
			Context:  ctx,
		})
	}

	return out
}

// endregion **************************** object.gotpl ****************************

// region    ***************************** type.gotpl *****************************

func (ec *executionContext) marshalNAppsV1DaemonSet2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSet(ctx context.Context, sel ast.SelectionSet, v v11.DaemonSet) graphql.Marshaler {
	return ec._AppsV1DaemonSet(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1DaemonSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetᚄ(ctx context.Context, sel ast.SelectionSet, v []v11.DaemonSet) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNAppsV1DaemonSet2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSet(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNAppsV1DaemonSetCondition2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetCondition(ctx context.Context, sel ast.SelectionSet, v v11.DaemonSetCondition) graphql.Marshaler {
	return ec._AppsV1DaemonSetCondition(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1DaemonSetCondition2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetConditionᚄ(ctx context.Context, sel ast.SelectionSet, v []v11.DaemonSetCondition) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNAppsV1DaemonSetCondition2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetCondition(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalNAppsV1DaemonSetConditionType2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetConditionType(ctx context.Context, v any) (v11.DaemonSetConditionType, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := v11.DaemonSetConditionType(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNAppsV1DaemonSetConditionType2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetConditionType(ctx context.Context, sel ast.SelectionSet, v v11.DaemonSetConditionType) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNAppsV1DaemonSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetSpec(ctx context.Context, sel ast.SelectionSet, v v11.DaemonSetSpec) graphql.Marshaler {
	return ec._AppsV1DaemonSetSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1DaemonSetStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐDaemonSetStatus(ctx context.Context, sel ast.SelectionSet, v v11.DaemonSetStatus) graphql.Marshaler {
	return ec._AppsV1DaemonSetStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1Deployment2k8sᚗioᚋapiᚋappsᚋv1ᚐDeployment(ctx context.Context, sel ast.SelectionSet, v v11.Deployment) graphql.Marshaler {
	return ec._AppsV1Deployment(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1Deployment2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentᚄ(ctx context.Context, sel ast.SelectionSet, v []v11.Deployment) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNAppsV1Deployment2k8sᚗioᚋapiᚋappsᚋv1ᚐDeployment(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNAppsV1DeploymentSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentSpec(ctx context.Context, sel ast.SelectionSet, v v11.DeploymentSpec) graphql.Marshaler {
	return ec._AppsV1DeploymentSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1DeploymentStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐDeploymentStatus(ctx context.Context, sel ast.SelectionSet, v v11.DeploymentStatus) graphql.Marshaler {
	return ec._AppsV1DeploymentStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1ReplicaSet2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSet(ctx context.Context, sel ast.SelectionSet, v v11.ReplicaSet) graphql.Marshaler {
	return ec._AppsV1ReplicaSet(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1ReplicaSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetᚄ(ctx context.Context, sel ast.SelectionSet, v []v11.ReplicaSet) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNAppsV1ReplicaSet2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSet(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNAppsV1ReplicaSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetSpec(ctx context.Context, sel ast.SelectionSet, v v11.ReplicaSetSpec) graphql.Marshaler {
	return ec._AppsV1ReplicaSetSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1ReplicaSetStatus2k8sᚗioᚋapiᚋappsᚋv1ᚐReplicaSetStatus(ctx context.Context, sel ast.SelectionSet, v v11.ReplicaSetStatus) graphql.Marshaler {
	return ec._AppsV1ReplicaSetStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1StatefulSet2k8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSet(ctx context.Context, sel ast.SelectionSet, v v11.StatefulSet) graphql.Marshaler {
	return ec._AppsV1StatefulSet(ctx, sel, &v)
}

func (ec *executionContext) marshalNAppsV1StatefulSet2ᚕk8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSetᚄ(ctx context.Context, sel ast.SelectionSet, v []v11.StatefulSet) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNAppsV1StatefulSet2k8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSet(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNAppsV1StatefulSetSpec2k8sᚗioᚋapiᚋappsᚋv1ᚐStatefulSetSpec(ctx context.Context, sel ast.SelectionSet, v v11.StatefulSetSpec) graphql.Marshaler {
	return ec._AppsV1StatefulSetSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1CronJob2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJob(ctx context.Context, sel ast.SelectionSet, v v12.CronJob) graphql.Marshaler {
	return ec._BatchV1CronJob(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1CronJob2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobᚄ(ctx context.Context, sel ast.SelectionSet, v []v12.CronJob) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNBatchV1CronJob2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJob(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNBatchV1CronJobSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobSpec(ctx context.Context, sel ast.SelectionSet, v v12.CronJobSpec) graphql.Marshaler {
	return ec._BatchV1CronJobSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1CronJobStatus2k8sᚗioᚋapiᚋbatchᚋv1ᚐCronJobStatus(ctx context.Context, sel ast.SelectionSet, v v12.CronJobStatus) graphql.Marshaler {
	return ec._BatchV1CronJobStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1Job2k8sᚗioᚋapiᚋbatchᚋv1ᚐJob(ctx context.Context, sel ast.SelectionSet, v v12.Job) graphql.Marshaler {
	return ec._BatchV1Job(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1Job2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐJobᚄ(ctx context.Context, sel ast.SelectionSet, v []v12.Job) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNBatchV1Job2k8sᚗioᚋapiᚋbatchᚋv1ᚐJob(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNBatchV1JobCondition2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobCondition(ctx context.Context, sel ast.SelectionSet, v v12.JobCondition) graphql.Marshaler {
	return ec._BatchV1JobCondition(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1JobCondition2ᚕk8sᚗioᚋapiᚋbatchᚋv1ᚐJobConditionᚄ(ctx context.Context, sel ast.SelectionSet, v []v12.JobCondition) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNBatchV1JobCondition2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobCondition(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalNBatchV1JobConditionType2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobConditionType(ctx context.Context, v any) (v12.JobConditionType, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := v12.JobConditionType(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNBatchV1JobConditionType2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobConditionType(ctx context.Context, sel ast.SelectionSet, v v12.JobConditionType) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNBatchV1JobSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobSpec(ctx context.Context, sel ast.SelectionSet, v v12.JobSpec) graphql.Marshaler {
	return ec._BatchV1JobSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1JobStatus2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobStatus(ctx context.Context, sel ast.SelectionSet, v v12.JobStatus) graphql.Marshaler {
	return ec._BatchV1JobStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNBatchV1JobTemplateSpec2k8sᚗioᚋapiᚋbatchᚋv1ᚐJobTemplateSpec(ctx context.Context, sel ast.SelectionSet, v v12.JobTemplateSpec) graphql.Marshaler {
	return ec._BatchV1JobTemplateSpec(ctx, sel, &v)
}

func (ec *executionContext) unmarshalNBoolean2bool(ctx context.Context, v any) (bool, error) {
	res, err := graphql.UnmarshalBoolean(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNBoolean2bool(ctx context.Context, sel ast.SelectionSet, v bool) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalBoolean(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNCoreV1ConditionStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐConditionStatus(ctx context.Context, v any) (v13.ConditionStatus, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := v13.ConditionStatus(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNCoreV1ConditionStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐConditionStatus(ctx context.Context, sel ast.SelectionSet, v v13.ConditionStatus) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNCoreV1Container2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainer(ctx context.Context, sel ast.SelectionSet, v v13.Container) graphql.Marshaler {
	return ec._CoreV1Container(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Container2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.Container) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1Container2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainer(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1ContainerState2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainerState(ctx context.Context, sel ast.SelectionSet, v v13.ContainerState) graphql.Marshaler {
	return ec._CoreV1ContainerState(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1ContainerStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStatus(ctx context.Context, sel ast.SelectionSet, v v13.ContainerStatus) graphql.Marshaler {
	return ec._CoreV1ContainerStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1ContainerStatus2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStatusᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.ContainerStatus) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1ContainerStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐContainerStatus(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1Namespace2k8sᚗioᚋapiᚋcoreᚋv1ᚐNamespace(ctx context.Context, sel ast.SelectionSet, v v13.Namespace) graphql.Marshaler {
	return ec._CoreV1Namespace(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Namespace2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐNamespaceᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.Namespace) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1Namespace2k8sᚗioᚋapiᚋcoreᚋv1ᚐNamespace(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1Node2k8sᚗioᚋapiᚋcoreᚋv1ᚐNode(ctx context.Context, sel ast.SelectionSet, v v13.Node) graphql.Marshaler {
	return ec._CoreV1Node(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Node2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐNodeᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.Node) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1Node2k8sᚗioᚋapiᚋcoreᚋv1ᚐNode(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1ObjectReference2k8sᚗioᚋapiᚋcoreᚋv1ᚐObjectReference(ctx context.Context, sel ast.SelectionSet, v v13.ObjectReference) graphql.Marshaler {
	return ec._CoreV1ObjectReference(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1ObjectReference2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐObjectReferenceᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.ObjectReference) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1ObjectReference2k8sᚗioᚋapiᚋcoreᚋv1ᚐObjectReference(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1Pod2k8sᚗioᚋapiᚋcoreᚋv1ᚐPod(ctx context.Context, sel ast.SelectionSet, v v13.Pod) graphql.Marshaler {
	return ec._CoreV1Pod(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Pod2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐPodᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.Pod) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1Pod2k8sᚗioᚋapiᚋcoreᚋv1ᚐPod(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalNCoreV1PodPhase2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodPhase(ctx context.Context, v any) (v13.PodPhase, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := v13.PodPhase(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNCoreV1PodPhase2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodPhase(ctx context.Context, sel ast.SelectionSet, v v13.PodPhase) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNCoreV1PodSpec2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodSpec(ctx context.Context, sel ast.SelectionSet, v v13.PodSpec) graphql.Marshaler {
	return ec._CoreV1PodSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1PodStatus2k8sᚗioᚋapiᚋcoreᚋv1ᚐPodStatus(ctx context.Context, sel ast.SelectionSet, v v13.PodStatus) graphql.Marshaler {
	return ec._CoreV1PodStatus(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Service2k8sᚗioᚋapiᚋcoreᚋv1ᚐService(ctx context.Context, sel ast.SelectionSet, v v13.Service) graphql.Marshaler {
	return ec._CoreV1Service(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1Service2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐServiceᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.Service) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1Service2k8sᚗioᚋapiᚋcoreᚋv1ᚐService(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1ServicePort2k8sᚗioᚋapiᚋcoreᚋv1ᚐServicePort(ctx context.Context, sel ast.SelectionSet, v v13.ServicePort) graphql.Marshaler {
	return ec._CoreV1ServicePort(ctx, sel, &v)
}

func (ec *executionContext) marshalNCoreV1ServicePort2ᚕk8sᚗioᚋapiᚋcoreᚋv1ᚐServicePortᚄ(ctx context.Context, sel ast.SelectionSet, v []v13.ServicePort) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNCoreV1ServicePort2k8sᚗioᚋapiᚋcoreᚋv1ᚐServicePort(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNCoreV1ServiceSpec2k8sᚗioᚋapiᚋcoreᚋv1ᚐServiceSpec(ctx context.Context, sel ast.SelectionSet, v v13.ServiceSpec) graphql.Marshaler {
	return ec._CoreV1ServiceSpec(ctx, sel, &v)
}

func (ec *executionContext) marshalNHealthCheckResponse2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx context.Context, sel ast.SelectionSet, v model.HealthCheckResponse) graphql.Marshaler {
	return ec._HealthCheckResponse(ctx, sel, &v)
}

func (ec *executionContext) marshalNHealthCheckResponse2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckResponse(ctx context.Context, sel ast.SelectionSet, v *model.HealthCheckResponse) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._HealthCheckResponse(ctx, sel, v)
}

func (ec *executionContext) unmarshalNHealthCheckStatus2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckStatus(ctx context.Context, v any) (model.HealthCheckStatus, error) {
	var res model.HealthCheckStatus
	err := res.UnmarshalGQL(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNHealthCheckStatus2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐHealthCheckStatus(ctx context.Context, sel ast.SelectionSet, v model.HealthCheckStatus) graphql.Marshaler {
	return v
}

func (ec *executionContext) marshalNHelmRelease2ᚕᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋreleaseᚐReleaseᚄ(ctx context.Context, sel ast.SelectionSet, v []*release.Release) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNHelmRelease2ᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋreleaseᚐRelease(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNHelmRelease2ᚖhelmᚗshᚋhelmᚋv3ᚋpkgᚋreleaseᚐRelease(ctx context.Context, sel ast.SelectionSet, v *release.Release) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._HelmRelease(ctx, sel, v)
}

func (ec *executionContext) unmarshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx context.Context, v any) (types.UID, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := types.UID(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNID2k8sᚗioᚋapimachineryᚋpkgᚋtypesᚐUID(ctx context.Context, sel ast.SelectionSet, v types.UID) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNInt2int(ctx context.Context, v any) (int, error) {
	res, err := graphql.UnmarshalInt(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNInt2int(ctx context.Context, sel ast.SelectionSet, v int) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalInt(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNInt2int32(ctx context.Context, v any) (int32, error) {
	res, err := graphql.UnmarshalInt32(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNInt2int32(ctx context.Context, sel ast.SelectionSet, v int32) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalInt32(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNInt642int64(ctx context.Context, v any) (int64, error) {
	res, err := model1.UnmarshalInt64(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNInt642int64(ctx context.Context, sel ast.SelectionSet, v int64) graphql.Marshaler {
	_ = sel
	res := model1.MarshalInt64(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNKubeConfigAuthInfo2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigAuthInfoᚄ(ctx context.Context, sel ast.SelectionSet, v []*model.KubeConfigAuthInfo) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNKubeConfigAuthInfo2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigAuthInfo(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNKubeConfigAuthInfo2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigAuthInfo(ctx context.Context, sel ast.SelectionSet, v *model.KubeConfigAuthInfo) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._KubeConfigAuthInfo(ctx, sel, v)
}

func (ec *executionContext) marshalNKubeConfigCluster2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigClusterᚄ(ctx context.Context, sel ast.SelectionSet, v []*model.KubeConfigCluster) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNKubeConfigCluster2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigCluster(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNKubeConfigCluster2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigCluster(ctx context.Context, sel ast.SelectionSet, v *model.KubeConfigCluster) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._KubeConfigCluster(ctx, sel, v)
}

func (ec *executionContext) marshalNKubeConfigContext2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigContextᚄ(ctx context.Context, sel ast.SelectionSet, v []*model.KubeConfigContext) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNKubeConfigContext2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigContext(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNKubeConfigContext2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋdashboardᚋgraphᚋmodelᚐKubeConfigContext(ctx context.Context, sel ast.SelectionSet, v *model.KubeConfigContext) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._KubeConfigContext(ctx, sel, v)
}

func (ec *executionContext) marshalNLogRecord2ᚕᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogRecordᚄ(ctx context.Context, sel ast.SelectionSet, v []*logs.LogRecord) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNLogRecord2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogRecord(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNLogRecord2ᚖgithubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogRecord(ctx context.Context, sel ast.SelectionSet, v *logs.LogRecord) graphql.Marshaler {
	if v == nil {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
		return graphql.Null
	}
	return ec._LogRecord(ctx, sel, v)
}

func (ec *executionContext) marshalNLogSource2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogSource(ctx context.Context, sel ast.SelectionSet, v logs.LogSource) graphql.Marshaler {
	return ec._LogSource(ctx, sel, &v)
}

func (ec *executionContext) marshalNLogSourceMetadata2githubᚗcomᚋkubetailᚑorgᚋkubetailᚋmodulesᚋsharedᚋlogsᚐLogSourceMetadata(ctx context.Context, sel ast.SelectionSet, v logs.LogSourceMetadata) graphql.Marshaler {
	return ec._LogSourceMetadata(ctx, sel, &v)
}

func (ec *executionContext) unmarshalNMetaV1LabelSelectorOperator2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorOperator(ctx context.Context, v any) (v1.LabelSelectorOperator, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := v1.LabelSelectorOperator(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNMetaV1LabelSelectorOperator2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorOperator(ctx context.Context, sel ast.SelectionSet, v v1.LabelSelectorOperator) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalNMetaV1LabelSelectorRequirement2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorRequirement(ctx context.Context, sel ast.SelectionSet, v v1.LabelSelectorRequirement) graphql.Marshaler {
	return ec._MetaV1LabelSelectorRequirement(ctx, sel, &v)
}

func (ec *executionContext) marshalNMetaV1LabelSelectorRequirement2ᚕk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorRequirementᚄ(ctx context.Context, sel ast.SelectionSet, v []v1.LabelSelectorRequirement) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNMetaV1LabelSelectorRequirement2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐLabelSelectorRequirement(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalNMetaV1ListMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐListMeta(ctx context.Context, sel ast.SelectionSet, v v1.ListMeta) graphql.Marshaler {
	return ec._MetaV1ListMeta(ctx, sel, &v)
}

func (ec *executionContext) marshalNMetaV1ObjectMeta2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐObjectMeta(ctx context.Context, sel ast.SelectionSet, v v1.ObjectMeta) graphql.Marshaler {
	return ec._MetaV1ObjectMeta(ctx, sel, &v)
}

func (ec *executionContext) marshalNMetaV1OwnerReference2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐOwnerReference(ctx context.Context, sel ast.SelectionSet, v v1.OwnerReference) graphql.Marshaler {
	return ec._MetaV1OwnerReference(ctx, sel, &v)
}

func (ec *executionContext) marshalNMetaV1OwnerReference2ᚕk8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐOwnerReferenceᚄ(ctx context.Context, sel ast.SelectionSet, v []v1.OwnerReference) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalNMetaV1OwnerReference2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐOwnerReference(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx context.Context, v any) (v1.Time, error) {
	res, err := model.UnmarshalMetaV1Time(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNMetaV1Time2k8sᚗioᚋapimachineryᚋpkgᚋapisᚋmetaᚋv1ᚐTime(ctx context.Context, sel ast.SelectionSet, v v1.Time) graphql.Marshaler {
	_ = sel
	res := model.MarshalMetaV1Time(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNString2string(ctx context.Context, v any) (string, error) {
	res, err := graphql.UnmarshalString(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNString2string(ctx context.Context, sel ast.SelectionSet, v string) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNString2ᚕstringᚄ(ctx context.Context, v any) ([]string, error) {
	var vSlice []any
	vSlice = graphql.CoerceList(v)
	var err error
	res := make([]string, len(vSlice))
	for i := range vSlice {
		ctx := graphql.WithPathContext(ctx, graphql.NewPathWithIndex(i))
		res[i], err = ec.unmarshalNString2string(ctx, vSlice[i])
		if err != nil {
			return nil, err
		}
	}
	return res, nil
}

func (ec *executionContext) marshalNString2ᚕstringᚄ(ctx context.Context, sel ast.SelectionSet, v []string) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	for i := range v {
		ret[i] = ec.marshalNString2string(ctx, sel, v[i])
	}

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalNTime2timeᚐTime(ctx context.Context, v any) (time.Time, error) {
	res, err := graphql.UnmarshalTime(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNTime2timeᚐTime(ctx context.Context, sel ast.SelectionSet, v time.Time) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalTime(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx context.Context, v any) (watch.EventType, error) {
	tmp, err := graphql.UnmarshalString(v)
	res := watch.EventType(tmp)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalNWatchEventType2k8sᚗioᚋapimachineryᚋpkgᚋwatchᚐEventType(ctx context.Context, sel ast.SelectionSet, v watch.EventType) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(string(v))
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) marshalN__Directive2githubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐDirective(ctx context.Context, sel ast.SelectionSet, v introspection.Directive) graphql.Marshaler {
	return ec.___Directive(ctx, sel, &v)
}

func (ec *executionContext) marshalN__Directive2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐDirectiveᚄ(ctx context.Context, sel ast.SelectionSet, v []introspection.Directive) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalN__Directive2githubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐDirective(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) unmarshalN__DirectiveLocation2string(ctx context.Context, v any) (string, error) {
	res, err := graphql.UnmarshalString(v)
	return res, graphql.ErrorOnPath(ctx, err)
}

func (ec *executionContext) marshalN__DirectiveLocation2string(ctx context.Context, sel ast.SelectionSet, v string) graphql.Marshaler {
	_ = sel
	res := graphql.MarshalString(v)
	if res == graphql.Null {
		if !graphql.HasFieldError(ctx, graphql.GetFieldContext(ctx)) {
			ec.Errorf(ctx, "the requested element is null which the schema does not allow")
		}
	}
	return res
}

func (ec *executionContext) unmarshalN__DirectiveLocation2ᚕstringᚄ(ctx context.Context, v any) ([]string, error) {
	var vSlice []any
	vSlice = graphql.CoerceList(v)
	var err error
	res := make([]string, len(vSlice))
	for i := range vSlice {
		ctx := graphql.WithPathContext(ctx, graphql.NewPathWithIndex(i))
		res[i], err = ec.unmarshalN__DirectiveLocation2string(ctx, vSlice[i])
		if err != nil {
			return nil, err
		}
	}
	return res, nil
}

func (ec *executionContext) marshalN__DirectiveLocation2ᚕstringᚄ(ctx context.Context, sel ast.SelectionSet, v []string) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.WithFieldContext(ctx, fc)
		f := func(i int) {
			defer func() {
				if r := recover(); r != nil {
					ec.Error(ctx, ec.Recover(ctx, r))
					ret = nil
				}
			}()
			if !isLen1 {
				defer wg.Done()
			}
			ret[i] = ec.marshalN__DirectiveLocation2string(ctx, sel, v[i])
		}
		if isLen1 {
			f(i)
		} else {
			go f(i)
		}

	}
	wg.Wait()

	for _, e := range ret {
		if e == graphql.Null {
			return graphql.Null
		}
	}

	return ret
}

func (ec *executionContext) marshalN__EnumValue2githubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐEnumValue(ctx context.Context, sel ast.SelectionSet, v introspection.EnumValue) graphql.Marshaler {
	return ec.___EnumValue(ctx, sel, &v)
}

func (ec *executionContext) marshalN__Field2githubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐField(ctx context.Context, sel ast.SelectionSet, v introspection.Field) graphql.Marshaler {
	return ec.___Field(ctx, sel, &v)
}

func (ec *executionContext) marshalN__InputValue2githubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐInputValue(ctx context.Context, sel ast.SelectionSet, v introspection.InputValue) graphql.Marshaler {
	return ec.___InputValue(ctx, sel, &v)
}

func (ec *executionContext) marshalN__InputValue2ᚕgithubᚗcomᚋ99designsᚋgqlgenᚋgraphqlᚋintrospectionᚐInputValueᚄ(ctx context.Context, sel ast.SelectionSet, v []introspection.InputValue) graphql.Marshaler {
	ret := make(graphql.Array, len(v))
	var wg sync.WaitGroup
	isLen1 := len(v) == 1
	if !isLen1 {
		wg.Add(len(v))
	}
	for i := range v {
		i := i
		fc := &graphql.FieldContext{
			Index:  &i,
			Result: &v[i],
		}
		ctx := graphql.W