//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"context"
	"net/http"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
)

// AgentPoolsCreateOrUpdatePoller provides polling facilities until the operation reaches a terminal state.
type AgentPoolsCreateOrUpdatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *AgentPoolsCreateOrUpdatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *AgentPoolsCreateOrUpdatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final AgentPoolsCreateOrUpdateResponse will be returned.
func (p *AgentPoolsCreateOrUpdatePoller) FinalResponse(ctx context.Context) (AgentPoolsCreateOrUpdateResponse, error) {
	respType := AgentPoolsCreateOrUpdateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.AgentPool)
	if err != nil {
		return AgentPoolsCreateOrUpdateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *AgentPoolsCreateOrUpdatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// AgentPoolsDeletePoller provides polling facilities until the operation reaches a terminal state.
type AgentPoolsDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *AgentPoolsDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *AgentPoolsDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final AgentPoolsDeleteResponse will be returned.
func (p *AgentPoolsDeletePoller) FinalResponse(ctx context.Context) (AgentPoolsDeleteResponse, error) {
	respType := AgentPoolsDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return AgentPoolsDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *AgentPoolsDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// AgentPoolsUpgradeNodeImageVersionPoller provides polling facilities until the operation reaches a terminal state.
type AgentPoolsUpgradeNodeImageVersionPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *AgentPoolsUpgradeNodeImageVersionPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *AgentPoolsUpgradeNodeImageVersionPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final AgentPoolsUpgradeNodeImageVersionResponse will be returned.
func (p *AgentPoolsUpgradeNodeImageVersionPoller) FinalResponse(ctx context.Context) (AgentPoolsUpgradeNodeImageVersionResponse, error) {
	respType := AgentPoolsUpgradeNodeImageVersionResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.AgentPool)
	if err != nil {
		return AgentPoolsUpgradeNodeImageVersionResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *AgentPoolsUpgradeNodeImageVersionPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersCreateOrUpdatePoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersCreateOrUpdatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersCreateOrUpdatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersCreateOrUpdatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersCreateOrUpdateResponse will be returned.
func (p *ManagedClustersCreateOrUpdatePoller) FinalResponse(ctx context.Context) (ManagedClustersCreateOrUpdateResponse, error) {
	respType := ManagedClustersCreateOrUpdateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.ManagedCluster)
	if err != nil {
		return ManagedClustersCreateOrUpdateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersCreateOrUpdatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersDeletePoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersDeleteResponse will be returned.
func (p *ManagedClustersDeletePoller) FinalResponse(ctx context.Context) (ManagedClustersDeleteResponse, error) {
	respType := ManagedClustersDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersResetAADProfilePoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersResetAADProfilePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersResetAADProfilePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersResetAADProfilePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersResetAADProfileResponse will be returned.
func (p *ManagedClustersResetAADProfilePoller) FinalResponse(ctx context.Context) (ManagedClustersResetAADProfileResponse, error) {
	respType := ManagedClustersResetAADProfileResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersResetAADProfileResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersResetAADProfilePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersResetServicePrincipalProfilePoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersResetServicePrincipalProfilePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersResetServicePrincipalProfilePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersResetServicePrincipalProfilePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersResetServicePrincipalProfileResponse will be returned.
func (p *ManagedClustersResetServicePrincipalProfilePoller) FinalResponse(ctx context.Context) (ManagedClustersResetServicePrincipalProfileResponse, error) {
	respType := ManagedClustersResetServicePrincipalProfileResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersResetServicePrincipalProfileResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersResetServicePrincipalProfilePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersRotateClusterCertificatesPoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersRotateClusterCertificatesPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersRotateClusterCertificatesPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersRotateClusterCertificatesPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersRotateClusterCertificatesResponse will be returned.
func (p *ManagedClustersRotateClusterCertificatesPoller) FinalResponse(ctx context.Context) (ManagedClustersRotateClusterCertificatesResponse, error) {
	respType := ManagedClustersRotateClusterCertificatesResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersRotateClusterCertificatesResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersRotateClusterCertificatesPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersRunCommandPoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersRunCommandPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersRunCommandPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersRunCommandPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersRunCommandResponse will be returned.
func (p *ManagedClustersRunCommandPoller) FinalResponse(ctx context.Context) (ManagedClustersRunCommandResponse, error) {
	respType := ManagedClustersRunCommandResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.RunCommandResult)
	if err != nil {
		return ManagedClustersRunCommandResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersRunCommandPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersStartPoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersStartPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersStartPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersStartPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersStartResponse will be returned.
func (p *ManagedClustersStartPoller) FinalResponse(ctx context.Context) (ManagedClustersStartResponse, error) {
	respType := ManagedClustersStartResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersStartResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersStartPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersStopPoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersStopPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersStopPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersStopPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersStopResponse will be returned.
func (p *ManagedClustersStopPoller) FinalResponse(ctx context.Context) (ManagedClustersStopResponse, error) {
	respType := ManagedClustersStopResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ManagedClustersStopResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersStopPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ManagedClustersUpdateTagsPoller provides polling facilities until the operation reaches a terminal state.
type ManagedClustersUpdateTagsPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ManagedClustersUpdateTagsPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ManagedClustersUpdateTagsPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ManagedClustersUpdateTagsResponse will be returned.
func (p *ManagedClustersUpdateTagsPoller) FinalResponse(ctx context.Context) (ManagedClustersUpdateTagsResponse, error) {
	respType := ManagedClustersUpdateTagsResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.ManagedCluster)
	if err != nil {
		return ManagedClustersUpdateTagsResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ManagedClustersUpdateTagsPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// PrivateEndpointConnectionsDeletePoller provides polling facilities until the operation reaches a terminal state.
type PrivateEndpointConnectionsDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *PrivateEndpointConnectionsDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *PrivateEndpointConnectionsDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final PrivateEndpointConnectionsDeleteResponse will be returned.
func (p *PrivateEndpointConnectionsDeletePoller) FinalResponse(ctx context.Context) (PrivateEndpointConnectionsDeleteResponse, error) {
	respType := PrivateEndpointConnectionsDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return PrivateEndpointConnectionsDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *PrivateEndpointConnectionsDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}
