// +build !ignore_autogenerated

/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	core "github.com/gardener/gardener/pkg/apis/core"
	v1beta1 "github.com/gardener/gardener/pkg/apis/core/v1beta1"
	v1 "k8s.io/api/core/v1"
	rbacv1 "k8s.io/api/rbac/v1"
	resource "k8s.io/apimachinery/pkg/api/resource"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*Addon)(nil), (*core.Addon)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Addon_To_core_Addon(a.(*Addon), b.(*core.Addon), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Addon)(nil), (*Addon)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Addon_To_v1alpha1_Addon(a.(*core.Addon), b.(*Addon), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Addons)(nil), (*core.Addons)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Addons_To_core_Addons(a.(*Addons), b.(*core.Addons), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Addons)(nil), (*Addons)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Addons_To_v1alpha1_Addons(a.(*core.Addons), b.(*Addons), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AdmissionPlugin)(nil), (*core.AdmissionPlugin)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AdmissionPlugin_To_core_AdmissionPlugin(a.(*AdmissionPlugin), b.(*core.AdmissionPlugin), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.AdmissionPlugin)(nil), (*AdmissionPlugin)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_AdmissionPlugin_To_v1alpha1_AdmissionPlugin(a.(*core.AdmissionPlugin), b.(*AdmissionPlugin), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Alerting)(nil), (*core.Alerting)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Alerting_To_core_Alerting(a.(*Alerting), b.(*core.Alerting), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Alerting)(nil), (*Alerting)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Alerting_To_v1alpha1_Alerting(a.(*core.Alerting), b.(*Alerting), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AuditConfig)(nil), (*core.AuditConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AuditConfig_To_core_AuditConfig(a.(*AuditConfig), b.(*core.AuditConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.AuditConfig)(nil), (*AuditConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_AuditConfig_To_v1alpha1_AuditConfig(a.(*core.AuditConfig), b.(*AuditConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AuditPolicy)(nil), (*core.AuditPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AuditPolicy_To_core_AuditPolicy(a.(*AuditPolicy), b.(*core.AuditPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.AuditPolicy)(nil), (*AuditPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_AuditPolicy_To_v1alpha1_AuditPolicy(a.(*core.AuditPolicy), b.(*AuditPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*AvailabilityZone)(nil), (*core.AvailabilityZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AvailabilityZone_To_core_AvailabilityZone(a.(*AvailabilityZone), b.(*core.AvailabilityZone), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.AvailabilityZone)(nil), (*AvailabilityZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_AvailabilityZone_To_v1alpha1_AvailabilityZone(a.(*core.AvailabilityZone), b.(*AvailabilityZone), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupBucketList)(nil), (*core.BackupBucketList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucketList_To_core_BackupBucketList(a.(*BackupBucketList), b.(*core.BackupBucketList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.BackupBucketList)(nil), (*BackupBucketList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupBucketList_To_v1alpha1_BackupBucketList(a.(*core.BackupBucketList), b.(*BackupBucketList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupBucketProvider)(nil), (*core.BackupBucketProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider(a.(*BackupBucketProvider), b.(*core.BackupBucketProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.BackupBucketProvider)(nil), (*BackupBucketProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider(a.(*core.BackupBucketProvider), b.(*BackupBucketProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupBucketStatus)(nil), (*core.BackupBucketStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus(a.(*BackupBucketStatus), b.(*core.BackupBucketStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.BackupBucketStatus)(nil), (*BackupBucketStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus(a.(*core.BackupBucketStatus), b.(*BackupBucketStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupEntryList)(nil), (*core.BackupEntryList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupEntryList_To_core_BackupEntryList(a.(*BackupEntryList), b.(*core.BackupEntryList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.BackupEntryList)(nil), (*BackupEntryList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupEntryList_To_v1alpha1_BackupEntryList(a.(*core.BackupEntryList), b.(*BackupEntryList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupEntryStatus)(nil), (*core.BackupEntryStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus(a.(*BackupEntryStatus), b.(*core.BackupEntryStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.BackupEntryStatus)(nil), (*BackupEntryStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus(a.(*core.BackupEntryStatus), b.(*BackupEntryStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CRI)(nil), (*core.CRI)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CRI_To_core_CRI(a.(*CRI), b.(*core.CRI), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.CRI)(nil), (*CRI)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_CRI_To_v1alpha1_CRI(a.(*core.CRI), b.(*CRI), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CloudInfo)(nil), (*core.CloudInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudInfo_To_core_CloudInfo(a.(*CloudInfo), b.(*core.CloudInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.CloudInfo)(nil), (*CloudInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_CloudInfo_To_v1alpha1_CloudInfo(a.(*core.CloudInfo), b.(*CloudInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CloudProfile)(nil), (*core.CloudProfile)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudProfile_To_core_CloudProfile(a.(*CloudProfile), b.(*core.CloudProfile), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.CloudProfile)(nil), (*CloudProfile)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_CloudProfile_To_v1alpha1_CloudProfile(a.(*core.CloudProfile), b.(*CloudProfile), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CloudProfileList)(nil), (*core.CloudProfileList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudProfileList_To_core_CloudProfileList(a.(*CloudProfileList), b.(*core.CloudProfileList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.CloudProfileList)(nil), (*CloudProfileList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_CloudProfileList_To_v1alpha1_CloudProfileList(a.(*core.CloudProfileList), b.(*CloudProfileList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CloudProfileSpec)(nil), (*core.CloudProfileSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec(a.(*CloudProfileSpec), b.(*core.CloudProfileSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.CloudProfileSpec)(nil), (*CloudProfileSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec(a.(*core.CloudProfileSpec), b.(*CloudProfileSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterAutoscaler)(nil), (*core.ClusterAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterAutoscaler_To_core_ClusterAutoscaler(a.(*ClusterAutoscaler), b.(*core.ClusterAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ClusterAutoscaler)(nil), (*ClusterAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ClusterAutoscaler_To_v1alpha1_ClusterAutoscaler(a.(*core.ClusterAutoscaler), b.(*ClusterAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterInfo)(nil), (*core.ClusterInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterInfo_To_core_ClusterInfo(a.(*ClusterInfo), b.(*core.ClusterInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ClusterInfo)(nil), (*ClusterInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ClusterInfo_To_v1alpha1_ClusterInfo(a.(*core.ClusterInfo), b.(*ClusterInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Condition)(nil), (*core.Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Condition_To_core_Condition(a.(*Condition), b.(*core.Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Condition)(nil), (*Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Condition_To_v1alpha1_Condition(a.(*core.Condition), b.(*Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ContainerRuntime)(nil), (*core.ContainerRuntime)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ContainerRuntime_To_core_ContainerRuntime(a.(*ContainerRuntime), b.(*core.ContainerRuntime), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ContainerRuntime)(nil), (*ContainerRuntime)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ContainerRuntime_To_v1alpha1_ContainerRuntime(a.(*core.ContainerRuntime), b.(*ContainerRuntime), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerDeployment)(nil), (*core.ControllerDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerDeployment_To_core_ControllerDeployment(a.(*ControllerDeployment), b.(*core.ControllerDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerDeployment)(nil), (*ControllerDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerDeployment_To_v1alpha1_ControllerDeployment(a.(*core.ControllerDeployment), b.(*ControllerDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallation)(nil), (*core.ControllerInstallation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallation_To_core_ControllerInstallation(a.(*ControllerInstallation), b.(*core.ControllerInstallation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerInstallation)(nil), (*ControllerInstallation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerInstallation_To_v1alpha1_ControllerInstallation(a.(*core.ControllerInstallation), b.(*ControllerInstallation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationList)(nil), (*core.ControllerInstallationList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationList_To_core_ControllerInstallationList(a.(*ControllerInstallationList), b.(*core.ControllerInstallationList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerInstallationList)(nil), (*ControllerInstallationList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerInstallationList_To_v1alpha1_ControllerInstallationList(a.(*core.ControllerInstallationList), b.(*ControllerInstallationList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationSpec)(nil), (*core.ControllerInstallationSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec(a.(*ControllerInstallationSpec), b.(*core.ControllerInstallationSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerInstallationSpec)(nil), (*ControllerInstallationSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec(a.(*core.ControllerInstallationSpec), b.(*ControllerInstallationSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationStatus)(nil), (*core.ControllerInstallationStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus(a.(*ControllerInstallationStatus), b.(*core.ControllerInstallationStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerInstallationStatus)(nil), (*ControllerInstallationStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus(a.(*core.ControllerInstallationStatus), b.(*ControllerInstallationStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerRegistration)(nil), (*core.ControllerRegistration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerRegistration_To_core_ControllerRegistration(a.(*ControllerRegistration), b.(*core.ControllerRegistration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerRegistration)(nil), (*ControllerRegistration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerRegistration_To_v1alpha1_ControllerRegistration(a.(*core.ControllerRegistration), b.(*ControllerRegistration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerRegistrationList)(nil), (*core.ControllerRegistrationList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerRegistrationList_To_core_ControllerRegistrationList(a.(*ControllerRegistrationList), b.(*core.ControllerRegistrationList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerRegistrationList)(nil), (*ControllerRegistrationList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerRegistrationList_To_v1alpha1_ControllerRegistrationList(a.(*core.ControllerRegistrationList), b.(*ControllerRegistrationList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerRegistrationSpec)(nil), (*core.ControllerRegistrationSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec(a.(*ControllerRegistrationSpec), b.(*core.ControllerRegistrationSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerRegistrationSpec)(nil), (*ControllerRegistrationSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec(a.(*core.ControllerRegistrationSpec), b.(*ControllerRegistrationSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerResource)(nil), (*core.ControllerResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerResource_To_core_ControllerResource(a.(*ControllerResource), b.(*core.ControllerResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ControllerResource)(nil), (*ControllerResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ControllerResource_To_v1alpha1_ControllerResource(a.(*core.ControllerResource), b.(*ControllerResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DNS)(nil), (*core.DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DNS_To_core_DNS(a.(*DNS), b.(*core.DNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.DNS)(nil), (*DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_DNS_To_v1alpha1_DNS(a.(*core.DNS), b.(*DNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DNSIncludeExclude)(nil), (*core.DNSIncludeExclude)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DNSIncludeExclude_To_core_DNSIncludeExclude(a.(*DNSIncludeExclude), b.(*core.DNSIncludeExclude), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.DNSIncludeExclude)(nil), (*DNSIncludeExclude)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_DNSIncludeExclude_To_v1alpha1_DNSIncludeExclude(a.(*core.DNSIncludeExclude), b.(*DNSIncludeExclude), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DNSProvider)(nil), (*core.DNSProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DNSProvider_To_core_DNSProvider(a.(*DNSProvider), b.(*core.DNSProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.DNSProvider)(nil), (*DNSProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_DNSProvider_To_v1alpha1_DNSProvider(a.(*core.DNSProvider), b.(*DNSProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DataVolume)(nil), (*core.DataVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_DataVolume_To_core_DataVolume(a.(*DataVolume), b.(*core.DataVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.DataVolume)(nil), (*DataVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_DataVolume_To_v1alpha1_DataVolume(a.(*core.DataVolume), b.(*DataVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Endpoint)(nil), (*core.Endpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Endpoint_To_core_Endpoint(a.(*Endpoint), b.(*core.Endpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Endpoint)(nil), (*Endpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Endpoint_To_v1alpha1_Endpoint(a.(*core.Endpoint), b.(*Endpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExpirableVersion)(nil), (*core.ExpirableVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion(a.(*ExpirableVersion), b.(*core.ExpirableVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ExpirableVersion)(nil), (*ExpirableVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion(a.(*core.ExpirableVersion), b.(*ExpirableVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Extension)(nil), (*core.Extension)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Extension_To_core_Extension(a.(*Extension), b.(*core.Extension), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Extension)(nil), (*Extension)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Extension_To_v1alpha1_Extension(a.(*core.Extension), b.(*Extension), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExtensionResourceState)(nil), (*core.ExtensionResourceState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ExtensionResourceState_To_core_ExtensionResourceState(a.(*ExtensionResourceState), b.(*core.ExtensionResourceState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ExtensionResourceState)(nil), (*ExtensionResourceState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ExtensionResourceState_To_v1alpha1_ExtensionResourceState(a.(*core.ExtensionResourceState), b.(*ExtensionResourceState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Gardener)(nil), (*core.Gardener)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Gardener_To_core_Gardener(a.(*Gardener), b.(*core.Gardener), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Gardener)(nil), (*Gardener)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Gardener_To_v1alpha1_Gardener(a.(*core.Gardener), b.(*Gardener), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GardenerResourceData)(nil), (*core.GardenerResourceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenerResourceData_To_core_GardenerResourceData(a.(*GardenerResourceData), b.(*core.GardenerResourceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.GardenerResourceData)(nil), (*GardenerResourceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_GardenerResourceData_To_v1alpha1_GardenerResourceData(a.(*core.GardenerResourceData), b.(*GardenerResourceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Hibernation)(nil), (*core.Hibernation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Hibernation_To_core_Hibernation(a.(*Hibernation), b.(*core.Hibernation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Hibernation)(nil), (*Hibernation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Hibernation_To_v1alpha1_Hibernation(a.(*core.Hibernation), b.(*Hibernation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HibernationSchedule)(nil), (*core.HibernationSchedule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HibernationSchedule_To_core_HibernationSchedule(a.(*HibernationSchedule), b.(*core.HibernationSchedule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.HibernationSchedule)(nil), (*HibernationSchedule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_HibernationSchedule_To_v1alpha1_HibernationSchedule(a.(*core.HibernationSchedule), b.(*HibernationSchedule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HorizontalPodAutoscalerConfig)(nil), (*core.HorizontalPodAutoscalerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HorizontalPodAutoscalerConfig_To_core_HorizontalPodAutoscalerConfig(a.(*HorizontalPodAutoscalerConfig), b.(*core.HorizontalPodAutoscalerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.HorizontalPodAutoscalerConfig)(nil), (*HorizontalPodAutoscalerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_HorizontalPodAutoscalerConfig_To_v1alpha1_HorizontalPodAutoscalerConfig(a.(*core.HorizontalPodAutoscalerConfig), b.(*HorizontalPodAutoscalerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Ingress)(nil), (*core.Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Ingress_To_core_Ingress(a.(*Ingress), b.(*core.Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Ingress)(nil), (*Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Ingress_To_v1alpha1_Ingress(a.(*core.Ingress), b.(*Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*IngressController)(nil), (*core.IngressController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_IngressController_To_core_IngressController(a.(*IngressController), b.(*core.IngressController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.IngressController)(nil), (*IngressController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_IngressController_To_v1alpha1_IngressController(a.(*core.IngressController), b.(*IngressController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeAPIServerConfig)(nil), (*core.KubeAPIServerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeAPIServerConfig_To_core_KubeAPIServerConfig(a.(*KubeAPIServerConfig), b.(*core.KubeAPIServerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeAPIServerConfig)(nil), (*KubeAPIServerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(a.(*core.KubeAPIServerConfig), b.(*KubeAPIServerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeAPIServerRequests)(nil), (*core.KubeAPIServerRequests)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeAPIServerRequests_To_core_KubeAPIServerRequests(a.(*KubeAPIServerRequests), b.(*core.KubeAPIServerRequests), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeAPIServerRequests)(nil), (*KubeAPIServerRequests)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeAPIServerRequests_To_v1alpha1_KubeAPIServerRequests(a.(*core.KubeAPIServerRequests), b.(*KubeAPIServerRequests), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeControllerManagerConfig)(nil), (*core.KubeControllerManagerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeControllerManagerConfig_To_core_KubeControllerManagerConfig(a.(*KubeControllerManagerConfig), b.(*core.KubeControllerManagerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeControllerManagerConfig)(nil), (*KubeControllerManagerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(a.(*core.KubeControllerManagerConfig), b.(*KubeControllerManagerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeProxyConfig)(nil), (*core.KubeProxyConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeProxyConfig_To_core_KubeProxyConfig(a.(*KubeProxyConfig), b.(*core.KubeProxyConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeProxyConfig)(nil), (*KubeProxyConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(a.(*core.KubeProxyConfig), b.(*KubeProxyConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeSchedulerConfig)(nil), (*core.KubeSchedulerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeSchedulerConfig_To_core_KubeSchedulerConfig(a.(*KubeSchedulerConfig), b.(*core.KubeSchedulerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeSchedulerConfig)(nil), (*KubeSchedulerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(a.(*core.KubeSchedulerConfig), b.(*KubeSchedulerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeletConfig)(nil), (*core.KubeletConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeletConfig_To_core_KubeletConfig(a.(*KubeletConfig), b.(*core.KubeletConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeletConfig)(nil), (*KubeletConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeletConfig_To_v1alpha1_KubeletConfig(a.(*core.KubeletConfig), b.(*KubeletConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeletConfigEviction)(nil), (*core.KubeletConfigEviction)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeletConfigEviction_To_core_KubeletConfigEviction(a.(*KubeletConfigEviction), b.(*core.KubeletConfigEviction), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeletConfigEviction)(nil), (*KubeletConfigEviction)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeletConfigEviction_To_v1alpha1_KubeletConfigEviction(a.(*core.KubeletConfigEviction), b.(*KubeletConfigEviction), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeletConfigEvictionMinimumReclaim)(nil), (*core.KubeletConfigEvictionMinimumReclaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeletConfigEvictionMinimumReclaim_To_core_KubeletConfigEvictionMinimumReclaim(a.(*KubeletConfigEvictionMinimumReclaim), b.(*core.KubeletConfigEvictionMinimumReclaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeletConfigEvictionMinimumReclaim)(nil), (*KubeletConfigEvictionMinimumReclaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeletConfigEvictionMinimumReclaim_To_v1alpha1_KubeletConfigEvictionMinimumReclaim(a.(*core.KubeletConfigEvictionMinimumReclaim), b.(*KubeletConfigEvictionMinimumReclaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeletConfigEvictionSoftGracePeriod)(nil), (*core.KubeletConfigEvictionSoftGracePeriod)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeletConfigEvictionSoftGracePeriod_To_core_KubeletConfigEvictionSoftGracePeriod(a.(*KubeletConfigEvictionSoftGracePeriod), b.(*core.KubeletConfigEvictionSoftGracePeriod), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeletConfigEvictionSoftGracePeriod)(nil), (*KubeletConfigEvictionSoftGracePeriod)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeletConfigEvictionSoftGracePeriod_To_v1alpha1_KubeletConfigEvictionSoftGracePeriod(a.(*core.KubeletConfigEvictionSoftGracePeriod), b.(*KubeletConfigEvictionSoftGracePeriod), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeletConfigReserved)(nil), (*core.KubeletConfigReserved)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeletConfigReserved_To_core_KubeletConfigReserved(a.(*KubeletConfigReserved), b.(*core.KubeletConfigReserved), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubeletConfigReserved)(nil), (*KubeletConfigReserved)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubeletConfigReserved_To_v1alpha1_KubeletConfigReserved(a.(*core.KubeletConfigReserved), b.(*KubeletConfigReserved), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Kubernetes)(nil), (*core.Kubernetes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Kubernetes_To_core_Kubernetes(a.(*Kubernetes), b.(*core.Kubernetes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Kubernetes)(nil), (*Kubernetes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Kubernetes_To_v1alpha1_Kubernetes(a.(*core.Kubernetes), b.(*Kubernetes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubernetesConfig)(nil), (*core.KubernetesConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(a.(*KubernetesConfig), b.(*core.KubernetesConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubernetesConfig)(nil), (*KubernetesConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(a.(*core.KubernetesConfig), b.(*KubernetesConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubernetesDashboard)(nil), (*core.KubernetesDashboard)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubernetesDashboard_To_core_KubernetesDashboard(a.(*KubernetesDashboard), b.(*core.KubernetesDashboard), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubernetesDashboard)(nil), (*KubernetesDashboard)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubernetesDashboard_To_v1alpha1_KubernetesDashboard(a.(*core.KubernetesDashboard), b.(*KubernetesDashboard), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubernetesInfo)(nil), (*core.KubernetesInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo(a.(*KubernetesInfo), b.(*core.KubernetesInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubernetesInfo)(nil), (*KubernetesInfo)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo(a.(*core.KubernetesInfo), b.(*KubernetesInfo), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubernetesSettings)(nil), (*core.KubernetesSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings(a.(*KubernetesSettings), b.(*core.KubernetesSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.KubernetesSettings)(nil), (*KubernetesSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings(a.(*core.KubernetesSettings), b.(*KubernetesSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LastError)(nil), (*core.LastError)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LastError_To_core_LastError(a.(*LastError), b.(*core.LastError), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.LastError)(nil), (*LastError)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_LastError_To_v1alpha1_LastError(a.(*core.LastError), b.(*LastError), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LastOperation)(nil), (*core.LastOperation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LastOperation_To_core_LastOperation(a.(*LastOperation), b.(*core.LastOperation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.LastOperation)(nil), (*LastOperation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_LastOperation_To_v1alpha1_LastOperation(a.(*core.LastOperation), b.(*LastOperation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Machine)(nil), (*core.Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Machine_To_core_Machine(a.(*Machine), b.(*core.Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Machine)(nil), (*Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Machine_To_v1alpha1_Machine(a.(*core.Machine), b.(*Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineControllerManagerSettings)(nil), (*core.MachineControllerManagerSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineControllerManagerSettings_To_core_MachineControllerManagerSettings(a.(*MachineControllerManagerSettings), b.(*core.MachineControllerManagerSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MachineControllerManagerSettings)(nil), (*MachineControllerManagerSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MachineControllerManagerSettings_To_v1alpha1_MachineControllerManagerSettings(a.(*core.MachineControllerManagerSettings), b.(*MachineControllerManagerSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineImage)(nil), (*core.MachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineImage_To_core_MachineImage(a.(*MachineImage), b.(*core.MachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MachineImage)(nil), (*MachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MachineImage_To_v1alpha1_MachineImage(a.(*core.MachineImage), b.(*MachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineImageVersion)(nil), (*core.MachineImageVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineImageVersion_To_core_MachineImageVersion(a.(*MachineImageVersion), b.(*core.MachineImageVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MachineImageVersion)(nil), (*MachineImageVersion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MachineImageVersion_To_v1alpha1_MachineImageVersion(a.(*core.MachineImageVersion), b.(*MachineImageVersion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineType)(nil), (*core.MachineType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineType_To_core_MachineType(a.(*MachineType), b.(*core.MachineType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MachineType)(nil), (*MachineType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MachineType_To_v1alpha1_MachineType(a.(*core.MachineType), b.(*MachineType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineTypeStorage)(nil), (*core.MachineTypeStorage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MachineTypeStorage_To_core_MachineTypeStorage(a.(*MachineTypeStorage), b.(*core.MachineTypeStorage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MachineTypeStorage)(nil), (*MachineTypeStorage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MachineTypeStorage_To_v1alpha1_MachineTypeStorage(a.(*core.MachineTypeStorage), b.(*MachineTypeStorage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Maintenance)(nil), (*core.Maintenance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Maintenance_To_core_Maintenance(a.(*Maintenance), b.(*core.Maintenance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Maintenance)(nil), (*Maintenance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Maintenance_To_v1alpha1_Maintenance(a.(*core.Maintenance), b.(*Maintenance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MaintenanceAutoUpdate)(nil), (*core.MaintenanceAutoUpdate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MaintenanceAutoUpdate_To_core_MaintenanceAutoUpdate(a.(*MaintenanceAutoUpdate), b.(*core.MaintenanceAutoUpdate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MaintenanceAutoUpdate)(nil), (*MaintenanceAutoUpdate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MaintenanceAutoUpdate_To_v1alpha1_MaintenanceAutoUpdate(a.(*core.MaintenanceAutoUpdate), b.(*MaintenanceAutoUpdate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MaintenanceTimeWindow)(nil), (*core.MaintenanceTimeWindow)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MaintenanceTimeWindow_To_core_MaintenanceTimeWindow(a.(*MaintenanceTimeWindow), b.(*core.MaintenanceTimeWindow), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.MaintenanceTimeWindow)(nil), (*MaintenanceTimeWindow)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_MaintenanceTimeWindow_To_v1alpha1_MaintenanceTimeWindow(a.(*core.MaintenanceTimeWindow), b.(*MaintenanceTimeWindow), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Monitoring)(nil), (*core.Monitoring)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Monitoring_To_core_Monitoring(a.(*Monitoring), b.(*core.Monitoring), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Monitoring)(nil), (*Monitoring)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Monitoring_To_v1alpha1_Monitoring(a.(*core.Monitoring), b.(*Monitoring), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NamedResourceReference)(nil), (*core.NamedResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_NamedResourceReference_To_core_NamedResourceReference(a.(*NamedResourceReference), b.(*core.NamedResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.NamedResourceReference)(nil), (*NamedResourceReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_NamedResourceReference_To_v1alpha1_NamedResourceReference(a.(*core.NamedResourceReference), b.(*NamedResourceReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Networking)(nil), (*core.Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Networking_To_core_Networking(a.(*Networking), b.(*core.Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Networking)(nil), (*Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Networking_To_v1alpha1_Networking(a.(*core.Networking), b.(*Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NginxIngress)(nil), (*core.NginxIngress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_NginxIngress_To_core_NginxIngress(a.(*NginxIngress), b.(*core.NginxIngress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.NginxIngress)(nil), (*NginxIngress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_NginxIngress_To_v1alpha1_NginxIngress(a.(*core.NginxIngress), b.(*NginxIngress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OIDCConfig)(nil), (*core.OIDCConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_OIDCConfig_To_core_OIDCConfig(a.(*OIDCConfig), b.(*core.OIDCConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.OIDCConfig)(nil), (*OIDCConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_OIDCConfig_To_v1alpha1_OIDCConfig(a.(*core.OIDCConfig), b.(*OIDCConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenIDConnectClientAuthentication)(nil), (*core.OpenIDConnectClientAuthentication)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_OpenIDConnectClientAuthentication_To_core_OpenIDConnectClientAuthentication(a.(*OpenIDConnectClientAuthentication), b.(*core.OpenIDConnectClientAuthentication), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.OpenIDConnectClientAuthentication)(nil), (*OpenIDConnectClientAuthentication)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_OpenIDConnectClientAuthentication_To_v1alpha1_OpenIDConnectClientAuthentication(a.(*core.OpenIDConnectClientAuthentication), b.(*OpenIDConnectClientAuthentication), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Plant)(nil), (*core.Plant)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Plant_To_core_Plant(a.(*Plant), b.(*core.Plant), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Plant)(nil), (*Plant)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Plant_To_v1alpha1_Plant(a.(*core.Plant), b.(*Plant), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlantList)(nil), (*core.PlantList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlantList_To_core_PlantList(a.(*PlantList), b.(*core.PlantList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.PlantList)(nil), (*PlantList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_PlantList_To_v1alpha1_PlantList(a.(*core.PlantList), b.(*PlantList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlantSpec)(nil), (*core.PlantSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlantSpec_To_core_PlantSpec(a.(*PlantSpec), b.(*core.PlantSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.PlantSpec)(nil), (*PlantSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_PlantSpec_To_v1alpha1_PlantSpec(a.(*core.PlantSpec), b.(*PlantSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlantStatus)(nil), (*core.PlantStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlantStatus_To_core_PlantStatus(a.(*PlantStatus), b.(*core.PlantStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.PlantStatus)(nil), (*PlantStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_PlantStatus_To_v1alpha1_PlantStatus(a.(*core.PlantStatus), b.(*PlantStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Project)(nil), (*core.Project)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Project_To_core_Project(a.(*Project), b.(*core.Project), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Project)(nil), (*Project)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Project_To_v1alpha1_Project(a.(*core.Project), b.(*Project), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ProjectList)(nil), (*core.ProjectList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectList_To_core_ProjectList(a.(*ProjectList), b.(*core.ProjectList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ProjectList)(nil), (*ProjectList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ProjectList_To_v1alpha1_ProjectList(a.(*core.ProjectList), b.(*ProjectList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ProjectStatus)(nil), (*core.ProjectStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectStatus_To_core_ProjectStatus(a.(*ProjectStatus), b.(*core.ProjectStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ProjectStatus)(nil), (*ProjectStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ProjectStatus_To_v1alpha1_ProjectStatus(a.(*core.ProjectStatus), b.(*ProjectStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ProjectTolerations)(nil), (*core.ProjectTolerations)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectTolerations_To_core_ProjectTolerations(a.(*ProjectTolerations), b.(*core.ProjectTolerations), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ProjectTolerations)(nil), (*ProjectTolerations)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ProjectTolerations_To_v1alpha1_ProjectTolerations(a.(*core.ProjectTolerations), b.(*ProjectTolerations), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Provider)(nil), (*core.Provider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Provider_To_core_Provider(a.(*Provider), b.(*core.Provider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Provider)(nil), (*Provider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Provider_To_v1alpha1_Provider(a.(*core.Provider), b.(*Provider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Quota)(nil), (*core.Quota)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Quota_To_core_Quota(a.(*Quota), b.(*core.Quota), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Quota)(nil), (*Quota)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Quota_To_v1alpha1_Quota(a.(*core.Quota), b.(*Quota), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*QuotaList)(nil), (*core.QuotaList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_QuotaList_To_core_QuotaList(a.(*QuotaList), b.(*core.QuotaList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.QuotaList)(nil), (*QuotaList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_QuotaList_To_v1alpha1_QuotaList(a.(*core.QuotaList), b.(*QuotaList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*QuotaSpec)(nil), (*core.QuotaSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_QuotaSpec_To_core_QuotaSpec(a.(*QuotaSpec), b.(*core.QuotaSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.QuotaSpec)(nil), (*QuotaSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_QuotaSpec_To_v1alpha1_QuotaSpec(a.(*core.QuotaSpec), b.(*QuotaSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Region)(nil), (*core.Region)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Region_To_core_Region(a.(*Region), b.(*core.Region), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Region)(nil), (*Region)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Region_To_v1alpha1_Region(a.(*core.Region), b.(*Region), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceData)(nil), (*core.ResourceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceData_To_core_ResourceData(a.(*ResourceData), b.(*core.ResourceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ResourceData)(nil), (*ResourceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ResourceData_To_v1alpha1_ResourceData(a.(*core.ResourceData), b.(*ResourceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceWatchCacheSize)(nil), (*core.ResourceWatchCacheSize)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceWatchCacheSize_To_core_ResourceWatchCacheSize(a.(*ResourceWatchCacheSize), b.(*core.ResourceWatchCacheSize), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ResourceWatchCacheSize)(nil), (*ResourceWatchCacheSize)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ResourceWatchCacheSize_To_v1alpha1_ResourceWatchCacheSize(a.(*core.ResourceWatchCacheSize), b.(*ResourceWatchCacheSize), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecretBinding)(nil), (*core.SecretBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SecretBinding_To_core_SecretBinding(a.(*SecretBinding), b.(*core.SecretBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SecretBinding)(nil), (*SecretBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SecretBinding_To_v1alpha1_SecretBinding(a.(*core.SecretBinding), b.(*SecretBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecretBindingList)(nil), (*core.SecretBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SecretBindingList_To_core_SecretBindingList(a.(*SecretBindingList), b.(*core.SecretBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SecretBindingList)(nil), (*SecretBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SecretBindingList_To_v1alpha1_SecretBindingList(a.(*core.SecretBindingList), b.(*SecretBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedBackup)(nil), (*core.SeedBackup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedBackup_To_core_SeedBackup(a.(*SeedBackup), b.(*core.SeedBackup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedBackup)(nil), (*SeedBackup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedBackup_To_v1alpha1_SeedBackup(a.(*core.SeedBackup), b.(*SeedBackup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedDNS)(nil), (*core.SeedDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedDNS_To_core_SeedDNS(a.(*SeedDNS), b.(*core.SeedDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedDNS)(nil), (*SeedDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedDNS_To_v1alpha1_SeedDNS(a.(*core.SeedDNS), b.(*SeedDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedDNSProvider)(nil), (*core.SeedDNSProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedDNSProvider_To_core_SeedDNSProvider(a.(*SeedDNSProvider), b.(*core.SeedDNSProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedDNSProvider)(nil), (*SeedDNSProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedDNSProvider_To_v1alpha1_SeedDNSProvider(a.(*core.SeedDNSProvider), b.(*SeedDNSProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedList)(nil), (*core.SeedList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedList_To_core_SeedList(a.(*SeedList), b.(*core.SeedList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedList)(nil), (*SeedList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedList_To_v1alpha1_SeedList(a.(*core.SeedList), b.(*SeedList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedProvider)(nil), (*core.SeedProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedProvider_To_core_SeedProvider(a.(*SeedProvider), b.(*core.SeedProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedProvider)(nil), (*SeedProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedProvider_To_v1alpha1_SeedProvider(a.(*core.SeedProvider), b.(*SeedProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSelector)(nil), (*core.SeedSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSelector_To_core_SeedSelector(a.(*SeedSelector), b.(*core.SeedSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSelector)(nil), (*SeedSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSelector_To_v1alpha1_SeedSelector(a.(*core.SeedSelector), b.(*SeedSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettingExcessCapacityReservation)(nil), (*core.SeedSettingExcessCapacityReservation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettingExcessCapacityReservation_To_core_SeedSettingExcessCapacityReservation(a.(*SeedSettingExcessCapacityReservation), b.(*core.SeedSettingExcessCapacityReservation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettingExcessCapacityReservation)(nil), (*SeedSettingExcessCapacityReservation)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettingExcessCapacityReservation_To_v1alpha1_SeedSettingExcessCapacityReservation(a.(*core.SeedSettingExcessCapacityReservation), b.(*SeedSettingExcessCapacityReservation), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettingLoadBalancerServices)(nil), (*core.SeedSettingLoadBalancerServices)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettingLoadBalancerServices_To_core_SeedSettingLoadBalancerServices(a.(*SeedSettingLoadBalancerServices), b.(*core.SeedSettingLoadBalancerServices), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettingLoadBalancerServices)(nil), (*SeedSettingLoadBalancerServices)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettingLoadBalancerServices_To_v1alpha1_SeedSettingLoadBalancerServices(a.(*core.SeedSettingLoadBalancerServices), b.(*SeedSettingLoadBalancerServices), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettingScheduling)(nil), (*core.SeedSettingScheduling)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettingScheduling_To_core_SeedSettingScheduling(a.(*SeedSettingScheduling), b.(*core.SeedSettingScheduling), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettingScheduling)(nil), (*SeedSettingScheduling)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettingScheduling_To_v1alpha1_SeedSettingScheduling(a.(*core.SeedSettingScheduling), b.(*SeedSettingScheduling), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettingShootDNS)(nil), (*core.SeedSettingShootDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettingShootDNS_To_core_SeedSettingShootDNS(a.(*SeedSettingShootDNS), b.(*core.SeedSettingShootDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettingShootDNS)(nil), (*SeedSettingShootDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettingShootDNS_To_v1alpha1_SeedSettingShootDNS(a.(*core.SeedSettingShootDNS), b.(*SeedSettingShootDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettingVerticalPodAutoscaler)(nil), (*core.SeedSettingVerticalPodAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettingVerticalPodAutoscaler_To_core_SeedSettingVerticalPodAutoscaler(a.(*SeedSettingVerticalPodAutoscaler), b.(*core.SeedSettingVerticalPodAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettingVerticalPodAutoscaler)(nil), (*SeedSettingVerticalPodAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettingVerticalPodAutoscaler_To_v1alpha1_SeedSettingVerticalPodAutoscaler(a.(*core.SeedSettingVerticalPodAutoscaler), b.(*SeedSettingVerticalPodAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedSettings)(nil), (*core.SeedSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSettings_To_core_SeedSettings(a.(*SeedSettings), b.(*core.SeedSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedSettings)(nil), (*SeedSettings)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSettings_To_v1alpha1_SeedSettings(a.(*core.SeedSettings), b.(*SeedSettings), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedStatus)(nil), (*core.SeedStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedStatus_To_core_SeedStatus(a.(*SeedStatus), b.(*core.SeedStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedTaint)(nil), (*core.SeedTaint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedTaint_To_core_SeedTaint(a.(*SeedTaint), b.(*core.SeedTaint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedTaint)(nil), (*SeedTaint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedTaint_To_v1alpha1_SeedTaint(a.(*core.SeedTaint), b.(*SeedTaint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedVolume)(nil), (*core.SeedVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedVolume_To_core_SeedVolume(a.(*SeedVolume), b.(*core.SeedVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedVolume)(nil), (*SeedVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedVolume_To_v1alpha1_SeedVolume(a.(*core.SeedVolume), b.(*SeedVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedVolumeProvider)(nil), (*core.SeedVolumeProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedVolumeProvider_To_core_SeedVolumeProvider(a.(*SeedVolumeProvider), b.(*core.SeedVolumeProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.SeedVolumeProvider)(nil), (*SeedVolumeProvider)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedVolumeProvider_To_v1alpha1_SeedVolumeProvider(a.(*core.SeedVolumeProvider), b.(*SeedVolumeProvider), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServiceAccountConfig)(nil), (*core.ServiceAccountConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServiceAccountConfig_To_core_ServiceAccountConfig(a.(*ServiceAccountConfig), b.(*core.ServiceAccountConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ServiceAccountConfig)(nil), (*ServiceAccountConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ServiceAccountConfig_To_v1alpha1_ServiceAccountConfig(a.(*core.ServiceAccountConfig), b.(*ServiceAccountConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Shoot)(nil), (*core.Shoot)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Shoot_To_core_Shoot(a.(*Shoot), b.(*core.Shoot), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Shoot)(nil), (*Shoot)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Shoot_To_v1alpha1_Shoot(a.(*core.Shoot), b.(*Shoot), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootList)(nil), (*core.ShootList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootList_To_core_ShootList(a.(*ShootList), b.(*core.ShootList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootList)(nil), (*ShootList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootList_To_v1alpha1_ShootList(a.(*core.ShootList), b.(*ShootList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootMachineImage)(nil), (*core.ShootMachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage(a.(*ShootMachineImage), b.(*core.ShootMachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootMachineImage)(nil), (*ShootMachineImage)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage(a.(*core.ShootMachineImage), b.(*ShootMachineImage), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootNetworks)(nil), (*core.ShootNetworks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootNetworks_To_core_ShootNetworks(a.(*ShootNetworks), b.(*core.ShootNetworks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootNetworks)(nil), (*ShootNetworks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootNetworks_To_v1alpha1_ShootNetworks(a.(*core.ShootNetworks), b.(*ShootNetworks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootSpec)(nil), (*core.ShootSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootSpec_To_core_ShootSpec(a.(*ShootSpec), b.(*core.ShootSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootSpec)(nil), (*ShootSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootSpec_To_v1alpha1_ShootSpec(a.(*core.ShootSpec), b.(*ShootSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootState)(nil), (*core.ShootState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootState_To_core_ShootState(a.(*ShootState), b.(*core.ShootState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootState)(nil), (*ShootState)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootState_To_v1alpha1_ShootState(a.(*core.ShootState), b.(*ShootState), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootStateList)(nil), (*core.ShootStateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootStateList_To_core_ShootStateList(a.(*ShootStateList), b.(*core.ShootStateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootStateList)(nil), (*ShootStateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootStateList_To_v1alpha1_ShootStateList(a.(*core.ShootStateList), b.(*ShootStateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootStateSpec)(nil), (*core.ShootStateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec(a.(*ShootStateSpec), b.(*core.ShootStateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.ShootStateSpec)(nil), (*ShootStateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec(a.(*core.ShootStateSpec), b.(*ShootStateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Toleration)(nil), (*core.Toleration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Toleration_To_core_Toleration(a.(*Toleration), b.(*core.Toleration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Toleration)(nil), (*Toleration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Toleration_To_v1alpha1_Toleration(a.(*core.Toleration), b.(*Toleration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VerticalPodAutoscaler)(nil), (*core.VerticalPodAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_VerticalPodAutoscaler_To_core_VerticalPodAutoscaler(a.(*VerticalPodAutoscaler), b.(*core.VerticalPodAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.VerticalPodAutoscaler)(nil), (*VerticalPodAutoscaler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_VerticalPodAutoscaler_To_v1alpha1_VerticalPodAutoscaler(a.(*core.VerticalPodAutoscaler), b.(*VerticalPodAutoscaler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Volume)(nil), (*core.Volume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Volume_To_core_Volume(a.(*Volume), b.(*core.Volume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Volume)(nil), (*Volume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Volume_To_v1alpha1_Volume(a.(*core.Volume), b.(*Volume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VolumeType)(nil), (*core.VolumeType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_VolumeType_To_core_VolumeType(a.(*VolumeType), b.(*core.VolumeType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.VolumeType)(nil), (*VolumeType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_VolumeType_To_v1alpha1_VolumeType(a.(*core.VolumeType), b.(*VolumeType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WatchCacheSizes)(nil), (*core.WatchCacheSizes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WatchCacheSizes_To_core_WatchCacheSizes(a.(*WatchCacheSizes), b.(*core.WatchCacheSizes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.WatchCacheSizes)(nil), (*WatchCacheSizes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_WatchCacheSizes_To_v1alpha1_WatchCacheSizes(a.(*core.WatchCacheSizes), b.(*WatchCacheSizes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Worker)(nil), (*core.Worker)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Worker_To_core_Worker(a.(*Worker), b.(*core.Worker), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.Worker)(nil), (*Worker)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Worker_To_v1alpha1_Worker(a.(*core.Worker), b.(*Worker), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkerKubernetes)(nil), (*core.WorkerKubernetes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkerKubernetes_To_core_WorkerKubernetes(a.(*WorkerKubernetes), b.(*core.WorkerKubernetes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.WorkerKubernetes)(nil), (*WorkerKubernetes)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_WorkerKubernetes_To_v1alpha1_WorkerKubernetes(a.(*core.WorkerKubernetes), b.(*WorkerKubernetes), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkerSystemComponents)(nil), (*core.WorkerSystemComponents)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkerSystemComponents_To_core_WorkerSystemComponents(a.(*WorkerSystemComponents), b.(*core.WorkerSystemComponents), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.WorkerSystemComponents)(nil), (*WorkerSystemComponents)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_WorkerSystemComponents_To_v1alpha1_WorkerSystemComponents(a.(*core.WorkerSystemComponents), b.(*WorkerSystemComponents), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.BackupBucketSpec)(nil), (*BackupBucketSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupBucketSpec_To_v1alpha1_BackupBucketSpec(a.(*core.BackupBucketSpec), b.(*BackupBucketSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.BackupBucket)(nil), (*BackupBucket)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupBucket_To_v1alpha1_BackupBucket(a.(*core.BackupBucket), b.(*BackupBucket), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.BackupEntrySpec)(nil), (*BackupEntrySpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupEntrySpec_To_v1alpha1_BackupEntrySpec(a.(*core.BackupEntrySpec), b.(*BackupEntrySpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.BackupEntry)(nil), (*BackupEntry)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_BackupEntry_To_v1alpha1_BackupEntry(a.(*core.BackupEntry), b.(*BackupEntry), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.ProjectMember)(nil), (*ProjectMember)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ProjectMember_To_v1alpha1_ProjectMember(a.(*core.ProjectMember), b.(*ProjectMember), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.ProjectSpec)(nil), (*ProjectSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ProjectSpec_To_v1alpha1_ProjectSpec(a.(*core.ProjectSpec), b.(*ProjectSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.SeedNetworks)(nil), (*SeedNetworks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedNetworks_To_v1alpha1_SeedNetworks(a.(*core.SeedNetworks), b.(*SeedNetworks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.SeedSpec)(nil), (*SeedSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedSpec_To_v1alpha1_SeedSpec(a.(*core.SeedSpec), b.(*SeedSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.SeedStatus)(nil), (*SeedStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedStatus_To_v1alpha1_SeedStatus(a.(*core.SeedStatus), b.(*SeedStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.Seed)(nil), (*Seed)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_Seed_To_v1alpha1_Seed(a.(*core.Seed), b.(*Seed), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.ShootStatus)(nil), (*ShootStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_ShootStatus_To_v1alpha1_ShootStatus(a.(*core.ShootStatus), b.(*ShootStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*BackupBucketSpec)(nil), (*core.BackupBucketSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucketSpec_To_core_BackupBucketSpec(a.(*BackupBucketSpec), b.(*core.BackupBucketSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*BackupBucket)(nil), (*core.BackupBucket)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucket_To_core_BackupBucket(a.(*BackupBucket), b.(*core.BackupBucket), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*BackupEntrySpec)(nil), (*core.BackupEntrySpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupEntrySpec_To_core_BackupEntrySpec(a.(*BackupEntrySpec), b.(*core.BackupEntrySpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*BackupEntry)(nil), (*core.BackupEntry)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupEntry_To_core_BackupEntry(a.(*BackupEntry), b.(*core.BackupEntry), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ProjectMember)(nil), (*core.ProjectMember)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectMember_To_core_ProjectMember(a.(*ProjectMember), b.(*core.ProjectMember), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ProjectSpec)(nil), (*core.ProjectSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectSpec_To_core_ProjectSpec(a.(*ProjectSpec), b.(*core.ProjectSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*SeedNetworks)(nil), (*core.SeedNetworks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedNetworks_To_core_SeedNetworks(a.(*SeedNetworks), b.(*core.SeedNetworks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*SeedSpec)(nil), (*core.SeedSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedSpec_To_core_SeedSpec(a.(*SeedSpec), b.(*core.SeedSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Seed)(nil), (*core.Seed)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Seed_To_core_Seed(a.(*Seed), b.(*core.Seed), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ShootStatus)(nil), (*core.ShootStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootStatus_To_core_ShootStatus(a.(*ShootStatus), b.(*core.ShootStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_Addon_To_core_Addon(in *Addon, out *core.Addon, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_v1alpha1_Addon_To_core_Addon is an autogenerated conversion function.
func Convert_v1alpha1_Addon_To_core_Addon(in *Addon, out *core.Addon, s conversion.Scope) error {
	return autoConvert_v1alpha1_Addon_To_core_Addon(in, out, s)
}

func autoConvert_core_Addon_To_v1alpha1_Addon(in *core.Addon, out *Addon, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_core_Addon_To_v1alpha1_Addon is an autogenerated conversion function.
func Convert_core_Addon_To_v1alpha1_Addon(in *core.Addon, out *Addon, s conversion.Scope) error {
	return autoConvert_core_Addon_To_v1alpha1_Addon(in, out, s)
}

func autoConvert_v1alpha1_Addons_To_core_Addons(in *Addons, out *core.Addons, s conversion.Scope) error {
	out.KubernetesDashboard = (*core.KubernetesDashboard)(unsafe.Pointer(in.KubernetesDashboard))
	out.NginxIngress = (*core.NginxIngress)(unsafe.Pointer(in.NginxIngress))
	return nil
}

// Convert_v1alpha1_Addons_To_core_Addons is an autogenerated conversion function.
func Convert_v1alpha1_Addons_To_core_Addons(in *Addons, out *core.Addons, s conversion.Scope) error {
	return autoConvert_v1alpha1_Addons_To_core_Addons(in, out, s)
}

func autoConvert_core_Addons_To_v1alpha1_Addons(in *core.Addons, out *Addons, s conversion.Scope) error {
	out.KubernetesDashboard = (*KubernetesDashboard)(unsafe.Pointer(in.KubernetesDashboard))
	out.NginxIngress = (*NginxIngress)(unsafe.Pointer(in.NginxIngress))
	return nil
}

// Convert_core_Addons_To_v1alpha1_Addons is an autogenerated conversion function.
func Convert_core_Addons_To_v1alpha1_Addons(in *core.Addons, out *Addons, s conversion.Scope) error {
	return autoConvert_core_Addons_To_v1alpha1_Addons(in, out, s)
}

func autoConvert_v1alpha1_AdmissionPlugin_To_core_AdmissionPlugin(in *AdmissionPlugin, out *core.AdmissionPlugin, s conversion.Scope) error {
	out.Name = in.Name
	out.Config = (*runtime.RawExtension)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_v1alpha1_AdmissionPlugin_To_core_AdmissionPlugin is an autogenerated conversion function.
func Convert_v1alpha1_AdmissionPlugin_To_core_AdmissionPlugin(in *AdmissionPlugin, out *core.AdmissionPlugin, s conversion.Scope) error {
	return autoConvert_v1alpha1_AdmissionPlugin_To_core_AdmissionPlugin(in, out, s)
}

func autoConvert_core_AdmissionPlugin_To_v1alpha1_AdmissionPlugin(in *core.AdmissionPlugin, out *AdmissionPlugin, s conversion.Scope) error {
	out.Name = in.Name
	out.Config = (*runtime.RawExtension)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_core_AdmissionPlugin_To_v1alpha1_AdmissionPlugin is an autogenerated conversion function.
func Convert_core_AdmissionPlugin_To_v1alpha1_AdmissionPlugin(in *core.AdmissionPlugin, out *AdmissionPlugin, s conversion.Scope) error {
	return autoConvert_core_AdmissionPlugin_To_v1alpha1_AdmissionPlugin(in, out, s)
}

func autoConvert_v1alpha1_Alerting_To_core_Alerting(in *Alerting, out *core.Alerting, s conversion.Scope) error {
	out.EmailReceivers = *(*[]string)(unsafe.Pointer(&in.EmailReceivers))
	return nil
}

// Convert_v1alpha1_Alerting_To_core_Alerting is an autogenerated conversion function.
func Convert_v1alpha1_Alerting_To_core_Alerting(in *Alerting, out *core.Alerting, s conversion.Scope) error {
	return autoConvert_v1alpha1_Alerting_To_core_Alerting(in, out, s)
}

func autoConvert_core_Alerting_To_v1alpha1_Alerting(in *core.Alerting, out *Alerting, s conversion.Scope) error {
	out.EmailReceivers = *(*[]string)(unsafe.Pointer(&in.EmailReceivers))
	return nil
}

// Convert_core_Alerting_To_v1alpha1_Alerting is an autogenerated conversion function.
func Convert_core_Alerting_To_v1alpha1_Alerting(in *core.Alerting, out *Alerting, s conversion.Scope) error {
	return autoConvert_core_Alerting_To_v1alpha1_Alerting(in, out, s)
}

func autoConvert_v1alpha1_AuditConfig_To_core_AuditConfig(in *AuditConfig, out *core.AuditConfig, s conversion.Scope) error {
	out.AuditPolicy = (*core.AuditPolicy)(unsafe.Pointer(in.AuditPolicy))
	return nil
}

// Convert_v1alpha1_AuditConfig_To_core_AuditConfig is an autogenerated conversion function.
func Convert_v1alpha1_AuditConfig_To_core_AuditConfig(in *AuditConfig, out *core.AuditConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_AuditConfig_To_core_AuditConfig(in, out, s)
}

func autoConvert_core_AuditConfig_To_v1alpha1_AuditConfig(in *core.AuditConfig, out *AuditConfig, s conversion.Scope) error {
	out.AuditPolicy = (*AuditPolicy)(unsafe.Pointer(in.AuditPolicy))
	return nil
}

// Convert_core_AuditConfig_To_v1alpha1_AuditConfig is an autogenerated conversion function.
func Convert_core_AuditConfig_To_v1alpha1_AuditConfig(in *core.AuditConfig, out *AuditConfig, s conversion.Scope) error {
	return autoConvert_core_AuditConfig_To_v1alpha1_AuditConfig(in, out, s)
}

func autoConvert_v1alpha1_AuditPolicy_To_core_AuditPolicy(in *AuditPolicy, out *core.AuditPolicy, s conversion.Scope) error {
	out.ConfigMapRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigMapRef))
	return nil
}

// Convert_v1alpha1_AuditPolicy_To_core_AuditPolicy is an autogenerated conversion function.
func Convert_v1alpha1_AuditPolicy_To_core_AuditPolicy(in *AuditPolicy, out *core.AuditPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha1_AuditPolicy_To_core_AuditPolicy(in, out, s)
}

func autoConvert_core_AuditPolicy_To_v1alpha1_AuditPolicy(in *core.AuditPolicy, out *AuditPolicy, s conversion.Scope) error {
	out.ConfigMapRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigMapRef))
	return nil
}

// Convert_core_AuditPolicy_To_v1alpha1_AuditPolicy is an autogenerated conversion function.
func Convert_core_AuditPolicy_To_v1alpha1_AuditPolicy(in *core.AuditPolicy, out *AuditPolicy, s conversion.Scope) error {
	return autoConvert_core_AuditPolicy_To_v1alpha1_AuditPolicy(in, out, s)
}

func autoConvert_v1alpha1_AvailabilityZone_To_core_AvailabilityZone(in *AvailabilityZone, out *core.AvailabilityZone, s conversion.Scope) error {
	out.Name = in.Name
	out.UnavailableMachineTypes = *(*[]string)(unsafe.Pointer(&in.UnavailableMachineTypes))
	out.UnavailableVolumeTypes = *(*[]string)(unsafe.Pointer(&in.UnavailableVolumeTypes))
	return nil
}

// Convert_v1alpha1_AvailabilityZone_To_core_AvailabilityZone is an autogenerated conversion function.
func Convert_v1alpha1_AvailabilityZone_To_core_AvailabilityZone(in *AvailabilityZone, out *core.AvailabilityZone, s conversion.Scope) error {
	return autoConvert_v1alpha1_AvailabilityZone_To_core_AvailabilityZone(in, out, s)
}

func autoConvert_core_AvailabilityZone_To_v1alpha1_AvailabilityZone(in *core.AvailabilityZone, out *AvailabilityZone, s conversion.Scope) error {
	out.Name = in.Name
	out.UnavailableMachineTypes = *(*[]string)(unsafe.Pointer(&in.UnavailableMachineTypes))
	out.UnavailableVolumeTypes = *(*[]string)(unsafe.Pointer(&in.UnavailableVolumeTypes))
	return nil
}

// Convert_core_AvailabilityZone_To_v1alpha1_AvailabilityZone is an autogenerated conversion function.
func Convert_core_AvailabilityZone_To_v1alpha1_AvailabilityZone(in *core.AvailabilityZone, out *AvailabilityZone, s conversion.Scope) error {
	return autoConvert_core_AvailabilityZone_To_v1alpha1_AvailabilityZone(in, out, s)
}

func autoConvert_v1alpha1_BackupBucket_To_core_BackupBucket(in *BackupBucket, out *core.BackupBucket, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_BackupBucketSpec_To_core_BackupBucketSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_core_BackupBucket_To_v1alpha1_BackupBucket(in *core.BackupBucket, out *BackupBucket, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_BackupBucketSpec_To_v1alpha1_BackupBucketSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_BackupBucketList_To_core_BackupBucketList(in *BackupBucketList, out *core.BackupBucketList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]core.BackupBucket, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_BackupBucket_To_core_BackupBucket(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_BackupBucketList_To_core_BackupBucketList is an autogenerated conversion function.
func Convert_v1alpha1_BackupBucketList_To_core_BackupBucketList(in *BackupBucketList, out *core.BackupBucketList, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupBucketList_To_core_BackupBucketList(in, out, s)
}

func autoConvert_core_BackupBucketList_To_v1alpha1_BackupBucketList(in *core.BackupBucketList, out *BackupBucketList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BackupBucket, len(*in))
		for i := range *in {
			if err := Convert_core_BackupBucket_To_v1alpha1_BackupBucket(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_core_BackupBucketList_To_v1alpha1_BackupBucketList is an autogenerated conversion function.
func Convert_core_BackupBucketList_To_v1alpha1_BackupBucketList(in *core.BackupBucketList, out *BackupBucketList, s conversion.Scope) error {
	return autoConvert_core_BackupBucketList_To_v1alpha1_BackupBucketList(in, out, s)
}

func autoConvert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider(in *BackupBucketProvider, out *core.BackupBucketProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.Region = in.Region
	return nil
}

// Convert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider is an autogenerated conversion function.
func Convert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider(in *BackupBucketProvider, out *core.BackupBucketProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider(in, out, s)
}

func autoConvert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider(in *core.BackupBucketProvider, out *BackupBucketProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.Region = in.Region
	return nil
}

// Convert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider is an autogenerated conversion function.
func Convert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider(in *core.BackupBucketProvider, out *BackupBucketProvider, s conversion.Scope) error {
	return autoConvert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider(in, out, s)
}

func autoConvert_v1alpha1_BackupBucketSpec_To_core_BackupBucketSpec(in *BackupBucketSpec, out *core.BackupBucketSpec, s conversion.Scope) error {
	if err := Convert_v1alpha1_BackupBucketProvider_To_core_BackupBucketProvider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.SecretRef = in.SecretRef
	// WARNING: in.Seed requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_core_BackupBucketSpec_To_v1alpha1_BackupBucketSpec(in *core.BackupBucketSpec, out *BackupBucketSpec, s conversion.Scope) error {
	if err := Convert_core_BackupBucketProvider_To_v1alpha1_BackupBucketProvider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.SecretRef = in.SecretRef
	// WARNING: in.SeedName requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus(in *BackupBucketStatus, out *core.BackupBucketStatus, s conversion.Scope) error {
	out.ProviderStatus = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderStatus))
	out.LastOperation = (*core.LastOperation)(unsafe.Pointer(in.LastOperation))
	out.LastError = (*core.LastError)(unsafe.Pointer(in.LastError))
	out.ObservedGeneration = in.ObservedGeneration
	out.GeneratedSecretRef = (*v1.SecretReference)(unsafe.Pointer(in.GeneratedSecretRef))
	return nil
}

// Convert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus is an autogenerated conversion function.
func Convert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus(in *BackupBucketStatus, out *core.BackupBucketStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupBucketStatus_To_core_BackupBucketStatus(in, out, s)
}

func autoConvert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus(in *core.BackupBucketStatus, out *BackupBucketStatus, s conversion.Scope) error {
	out.ProviderStatus = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderStatus))
	out.LastOperation = (*LastOperation)(unsafe.Pointer(in.LastOperation))
	out.LastError = (*LastError)(unsafe.Pointer(in.LastError))
	out.ObservedGeneration = in.ObservedGeneration
	out.GeneratedSecretRef = (*v1.SecretReference)(unsafe.Pointer(in.GeneratedSecretRef))
	return nil
}

// Convert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus is an autogenerated conversion function.
func Convert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus(in *core.BackupBucketStatus, out *BackupBucketStatus, s conversion.Scope) error {
	return autoConvert_core_BackupBucketStatus_To_v1alpha1_BackupBucketStatus(in, out, s)
}

func autoConvert_v1alpha1_BackupEntry_To_core_BackupEntry(in *BackupEntry, out *core.BackupEntry, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_BackupEntrySpec_To_core_BackupEntrySpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_core_BackupEntry_To_v1alpha1_BackupEntry(in *core.BackupEntry, out *BackupEntry, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_BackupEntrySpec_To_v1alpha1_BackupEntrySpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_BackupEntryList_To_core_BackupEntryList(in *BackupEntryList, out *core.BackupEntryList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]core.BackupEntry, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_BackupEntry_To_core_BackupEntry(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_BackupEntryList_To_core_BackupEntryList is an autogenerated conversion function.
func Convert_v1alpha1_BackupEntryList_To_core_BackupEntryList(in *BackupEntryList, out *core.BackupEntryList, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupEntryList_To_core_BackupEntryList(in, out, s)
}

func autoConvert_core_BackupEntryList_To_v1alpha1_BackupEntryList(in *core.BackupEntryList, out *BackupEntryList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BackupEntry, len(*in))
		for i := range *in {
			if err := Convert_core_BackupEntry_To_v1alpha1_BackupEntry(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_core_BackupEntryList_To_v1alpha1_BackupEntryList is an autogenerated conversion function.
func Convert_core_BackupEntryList_To_v1alpha1_BackupEntryList(in *core.BackupEntryList, out *BackupEntryList, s conversion.Scope) error {
	return autoConvert_core_BackupEntryList_To_v1alpha1_BackupEntryList(in, out, s)
}

func autoConvert_v1alpha1_BackupEntrySpec_To_core_BackupEntrySpec(in *BackupEntrySpec, out *core.BackupEntrySpec, s conversion.Scope) error {
	out.BucketName = in.BucketName
	// WARNING: in.Seed requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_core_BackupEntrySpec_To_v1alpha1_BackupEntrySpec(in *core.BackupEntrySpec, out *BackupEntrySpec, s conversion.Scope) error {
	out.BucketName = in.BucketName
	// WARNING: in.SeedName requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus(in *BackupEntryStatus, out *core.BackupEntryStatus, s conversion.Scope) error {
	out.LastOperation = (*core.LastOperation)(unsafe.Pointer(in.LastOperation))
	out.LastError = (*core.LastError)(unsafe.Pointer(in.LastError))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus is an autogenerated conversion function.
func Convert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus(in *BackupEntryStatus, out *core.BackupEntryStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupEntryStatus_To_core_BackupEntryStatus(in, out, s)
}

func autoConvert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus(in *core.BackupEntryStatus, out *BackupEntryStatus, s conversion.Scope) error {
	out.LastOperation = (*LastOperation)(unsafe.Pointer(in.LastOperation))
	out.LastError = (*LastError)(unsafe.Pointer(in.LastError))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus is an autogenerated conversion function.
func Convert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus(in *core.BackupEntryStatus, out *BackupEntryStatus, s conversion.Scope) error {
	return autoConvert_core_BackupEntryStatus_To_v1alpha1_BackupEntryStatus(in, out, s)
}

func autoConvert_v1alpha1_CRI_To_core_CRI(in *CRI, out *core.CRI, s conversion.Scope) error {
	out.Name = core.CRIName(in.Name)
	out.ContainerRuntimes = *(*[]core.ContainerRuntime)(unsafe.Pointer(&in.ContainerRuntimes))
	return nil
}

// Convert_v1alpha1_CRI_To_core_CRI is an autogenerated conversion function.
func Convert_v1alpha1_CRI_To_core_CRI(in *CRI, out *core.CRI, s conversion.Scope) error {
	return autoConvert_v1alpha1_CRI_To_core_CRI(in, out, s)
}

func autoConvert_core_CRI_To_v1alpha1_CRI(in *core.CRI, out *CRI, s conversion.Scope) error {
	out.Name = CRIName(in.Name)
	out.ContainerRuntimes = *(*[]ContainerRuntime)(unsafe.Pointer(&in.ContainerRuntimes))
	return nil
}

// Convert_core_CRI_To_v1alpha1_CRI is an autogenerated conversion function.
func Convert_core_CRI_To_v1alpha1_CRI(in *core.CRI, out *CRI, s conversion.Scope) error {
	return autoConvert_core_CRI_To_v1alpha1_CRI(in, out, s)
}

func autoConvert_v1alpha1_CloudInfo_To_core_CloudInfo(in *CloudInfo, out *core.CloudInfo, s conversion.Scope) error {
	out.Type = in.Type
	out.Region = in.Region
	return nil
}

// Convert_v1alpha1_CloudInfo_To_core_CloudInfo is an autogenerated conversion function.
func Convert_v1alpha1_CloudInfo_To_core_CloudInfo(in *CloudInfo, out *core.CloudInfo, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudInfo_To_core_CloudInfo(in, out, s)
}

func autoConvert_core_CloudInfo_To_v1alpha1_CloudInfo(in *core.CloudInfo, out *CloudInfo, s conversion.Scope) error {
	out.Type = in.Type
	out.Region = in.Region
	return nil
}

// Convert_core_CloudInfo_To_v1alpha1_CloudInfo is an autogenerated conversion function.
func Convert_core_CloudInfo_To_v1alpha1_CloudInfo(in *core.CloudInfo, out *CloudInfo, s conversion.Scope) error {
	return autoConvert_core_CloudInfo_To_v1alpha1_CloudInfo(in, out, s)
}

func autoConvert_v1alpha1_CloudProfile_To_core_CloudProfile(in *CloudProfile, out *core.CloudProfile, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_CloudProfile_To_core_CloudProfile is an autogenerated conversion function.
func Convert_v1alpha1_CloudProfile_To_core_CloudProfile(in *CloudProfile, out *core.CloudProfile, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudProfile_To_core_CloudProfile(in, out, s)
}

func autoConvert_core_CloudProfile_To_v1alpha1_CloudProfile(in *core.CloudProfile, out *CloudProfile, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_CloudProfile_To_v1alpha1_CloudProfile is an autogenerated conversion function.
func Convert_core_CloudProfile_To_v1alpha1_CloudProfile(in *core.CloudProfile, out *CloudProfile, s conversion.Scope) error {
	return autoConvert_core_CloudProfile_To_v1alpha1_CloudProfile(in, out, s)
}

func autoConvert_v1alpha1_CloudProfileList_To_core_CloudProfileList(in *CloudProfileList, out *core.CloudProfileList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.CloudProfile)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_CloudProfileList_To_core_CloudProfileList is an autogenerated conversion function.
func Convert_v1alpha1_CloudProfileList_To_core_CloudProfileList(in *CloudProfileList, out *core.CloudProfileList, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudProfileList_To_core_CloudProfileList(in, out, s)
}

func autoConvert_core_CloudProfileList_To_v1alpha1_CloudProfileList(in *core.CloudProfileList, out *CloudProfileList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]CloudProfile)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_CloudProfileList_To_v1alpha1_CloudProfileList is an autogenerated conversion function.
func Convert_core_CloudProfileList_To_v1alpha1_CloudProfileList(in *core.CloudProfileList, out *CloudProfileList, s conversion.Scope) error {
	return autoConvert_core_CloudProfileList_To_v1alpha1_CloudProfileList(in, out, s)
}

func autoConvert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec(in *CloudProfileSpec, out *core.CloudProfileSpec, s conversion.Scope) error {
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	if err := Convert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	out.MachineImages = *(*[]core.MachineImage)(unsafe.Pointer(&in.MachineImages))
	out.MachineTypes = *(*[]core.MachineType)(unsafe.Pointer(&in.MachineTypes))
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Regions = *(*[]core.Region)(unsafe.Pointer(&in.Regions))
	out.SeedSelector = (*core.SeedSelector)(unsafe.Pointer(in.SeedSelector))
	out.Type = in.Type
	out.VolumeTypes = *(*[]core.VolumeType)(unsafe.Pointer(&in.VolumeTypes))
	return nil
}

// Convert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec is an autogenerated conversion function.
func Convert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec(in *CloudProfileSpec, out *core.CloudProfileSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudProfileSpec_To_core_CloudProfileSpec(in, out, s)
}

func autoConvert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec(in *core.CloudProfileSpec, out *CloudProfileSpec, s conversion.Scope) error {
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	if err := Convert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	out.MachineImages = *(*[]MachineImage)(unsafe.Pointer(&in.MachineImages))
	out.MachineTypes = *(*[]MachineType)(unsafe.Pointer(&in.MachineTypes))
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Regions = *(*[]Region)(unsafe.Pointer(&in.Regions))
	out.SeedSelector = (*SeedSelector)(unsafe.Pointer(in.SeedSelector))
	out.Type = in.Type
	out.VolumeTypes = *(*[]VolumeType)(unsafe.Pointer(&in.VolumeTypes))
	return nil
}

// Convert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec is an autogenerated conversion function.
func Convert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec(in *core.CloudProfileSpec, out *CloudProfileSpec, s conversion.Scope) error {
	return autoConvert_core_CloudProfileSpec_To_v1alpha1_CloudProfileSpec(in, out, s)
}

func autoConvert_v1alpha1_ClusterAutoscaler_To_core_ClusterAutoscaler(in *ClusterAutoscaler, out *core.ClusterAutoscaler, s conversion.Scope) error {
	out.ScaleDownDelayAfterAdd = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterAdd))
	out.ScaleDownDelayAfterDelete = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterDelete))
	out.ScaleDownDelayAfterFailure = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterFailure))
	out.ScaleDownUnneededTime = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownUnneededTime))
	out.ScaleDownUtilizationThreshold = (*float64)(unsafe.Pointer(in.ScaleDownUtilizationThreshold))
	out.ScanInterval = (*metav1.Duration)(unsafe.Pointer(in.ScanInterval))
	return nil
}

// Convert_v1alpha1_ClusterAutoscaler_To_core_ClusterAutoscaler is an autogenerated conversion function.
func Convert_v1alpha1_ClusterAutoscaler_To_core_ClusterAutoscaler(in *ClusterAutoscaler, out *core.ClusterAutoscaler, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterAutoscaler_To_core_ClusterAutoscaler(in, out, s)
}

func autoConvert_core_ClusterAutoscaler_To_v1alpha1_ClusterAutoscaler(in *core.ClusterAutoscaler, out *ClusterAutoscaler, s conversion.Scope) error {
	out.ScaleDownDelayAfterAdd = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterAdd))
	out.ScaleDownDelayAfterDelete = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterDelete))
	out.ScaleDownDelayAfterFailure = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownDelayAfterFailure))
	out.ScaleDownUnneededTime = (*metav1.Duration)(unsafe.Pointer(in.ScaleDownUnneededTime))
	out.ScaleDownUtilizationThreshold = (*float64)(unsafe.Pointer(in.ScaleDownUtilizationThreshold))
	out.ScanInterval = (*metav1.Duration)(unsafe.Pointer(in.ScanInterval))
	return nil
}

// Convert_core_ClusterAutoscaler_To_v1alpha1_ClusterAutoscaler is an autogenerated conversion function.
func Convert_core_ClusterAutoscaler_To_v1alpha1_ClusterAutoscaler(in *core.ClusterAutoscaler, out *ClusterAutoscaler, s conversion.Scope) error {
	return autoConvert_core_ClusterAutoscaler_To_v1alpha1_ClusterAutoscaler(in, out, s)
}

func autoConvert_v1alpha1_ClusterInfo_To_core_ClusterInfo(in *ClusterInfo, out *core.ClusterInfo, s conversion.Scope) error {
	if err := Convert_v1alpha1_CloudInfo_To_core_CloudInfo(&in.Cloud, &out.Cloud, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ClusterInfo_To_core_ClusterInfo is an autogenerated conversion function.
func Convert_v1alpha1_ClusterInfo_To_core_ClusterInfo(in *ClusterInfo, out *core.ClusterInfo, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterInfo_To_core_ClusterInfo(in, out, s)
}

func autoConvert_core_ClusterInfo_To_v1alpha1_ClusterInfo(in *core.ClusterInfo, out *ClusterInfo, s conversion.Scope) error {
	if err := Convert_core_CloudInfo_To_v1alpha1_CloudInfo(&in.Cloud, &out.Cloud, s); err != nil {
		return err
	}
	if err := Convert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_ClusterInfo_To_v1alpha1_ClusterInfo is an autogenerated conversion function.
func Convert_core_ClusterInfo_To_v1alpha1_ClusterInfo(in *core.ClusterInfo, out *ClusterInfo, s conversion.Scope) error {
	return autoConvert_core_ClusterInfo_To_v1alpha1_ClusterInfo(in, out, s)
}

func autoConvert_v1alpha1_Condition_To_core_Condition(in *Condition, out *core.Condition, s conversion.Scope) error {
	out.Type = core.ConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Codes = *(*[]core.ErrorCode)(unsafe.Pointer(&in.Codes))
	return nil
}

// Convert_v1alpha1_Condition_To_core_Condition is an autogenerated conversion function.
func Convert_v1alpha1_Condition_To_core_Condition(in *Condition, out *core.Condition, s conversion.Scope) error {
	return autoConvert_v1alpha1_Condition_To_core_Condition(in, out, s)
}

func autoConvert_core_Condition_To_v1alpha1_Condition(in *core.Condition, out *Condition, s conversion.Scope) error {
	out.Type = ConditionType(in.Type)
	out.Status = ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	out.Message = in.Message
	out.Codes = *(*[]ErrorCode)(unsafe.Pointer(&in.Codes))
	return nil
}

// Convert_core_Condition_To_v1alpha1_Condition is an autogenerated conversion function.
func Convert_core_Condition_To_v1alpha1_Condition(in *core.Condition, out *Condition, s conversion.Scope) error {
	return autoConvert_core_Condition_To_v1alpha1_Condition(in, out, s)
}

func autoConvert_v1alpha1_ContainerRuntime_To_core_ContainerRuntime(in *ContainerRuntime, out *core.ContainerRuntime, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	return nil
}

// Convert_v1alpha1_ContainerRuntime_To_core_ContainerRuntime is an autogenerated conversion function.
func Convert_v1alpha1_ContainerRuntime_To_core_ContainerRuntime(in *ContainerRuntime, out *core.ContainerRuntime, s conversion.Scope) error {
	return autoConvert_v1alpha1_ContainerRuntime_To_core_ContainerRuntime(in, out, s)
}

func autoConvert_core_ContainerRuntime_To_v1alpha1_ContainerRuntime(in *core.ContainerRuntime, out *ContainerRuntime, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	return nil
}

// Convert_core_ContainerRuntime_To_v1alpha1_ContainerRuntime is an autogenerated conversion function.
func Convert_core_ContainerRuntime_To_v1alpha1_ContainerRuntime(in *core.ContainerRuntime, out *ContainerRuntime, s conversion.Scope) error {
	return autoConvert_core_ContainerRuntime_To_v1alpha1_ContainerRuntime(in, out, s)
}

func autoConvert_v1alpha1_ControllerDeployment_To_core_ControllerDeployment(in *ControllerDeployment, out *core.ControllerDeployment, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Policy = (*core.ControllerDeploymentPolicy)(unsafe.Pointer(in.Policy))
	out.SeedSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.SeedSelector))
	return nil
}

// Convert_v1alpha1_ControllerDeployment_To_core_ControllerDeployment is an autogenerated conversion function.
func Convert_v1alpha1_ControllerDeployment_To_core_ControllerDeployment(in *ControllerDeployment, out *core.ControllerDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerDeployment_To_core_ControllerDeployment(in, out, s)
}

func autoConvert_core_ControllerDeployment_To_v1alpha1_ControllerDeployment(in *core.ControllerDeployment, out *ControllerDeployment, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Policy = (*ControllerDeploymentPolicy)(unsafe.Pointer(in.Policy))
	out.SeedSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.SeedSelector))
	return nil
}

// Convert_core_ControllerDeployment_To_v1alpha1_ControllerDeployment is an autogenerated conversion function.
func Convert_core_ControllerDeployment_To_v1alpha1_ControllerDeployment(in *core.ControllerDeployment, out *ControllerDeployment, s conversion.Scope) error {
	return autoConvert_core_ControllerDeployment_To_v1alpha1_ControllerDeployment(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallation_To_core_ControllerInstallation(in *ControllerInstallation, out *core.ControllerInstallation, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ControllerInstallation_To_core_ControllerInstallation is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallation_To_core_ControllerInstallation(in *ControllerInstallation, out *core.ControllerInstallation, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallation_To_core_ControllerInstallation(in, out, s)
}

func autoConvert_core_ControllerInstallation_To_v1alpha1_ControllerInstallation(in *core.ControllerInstallation, out *ControllerInstallation, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_ControllerInstallation_To_v1alpha1_ControllerInstallation is an autogenerated conversion function.
func Convert_core_ControllerInstallation_To_v1alpha1_ControllerInstallation(in *core.ControllerInstallation, out *ControllerInstallation, s conversion.Scope) error {
	return autoConvert_core_ControllerInstallation_To_v1alpha1_ControllerInstallation(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationList_To_core_ControllerInstallationList(in *ControllerInstallationList, out *core.ControllerInstallationList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.ControllerInstallation)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ControllerInstallationList_To_core_ControllerInstallationList is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationList_To_core_ControllerInstallationList(in *ControllerInstallationList, out *core.ControllerInstallationList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationList_To_core_ControllerInstallationList(in, out, s)
}

func autoConvert_core_ControllerInstallationList_To_v1alpha1_ControllerInstallationList(in *core.ControllerInstallationList, out *ControllerInstallationList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ControllerInstallation)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_ControllerInstallationList_To_v1alpha1_ControllerInstallationList is an autogenerated conversion function.
func Convert_core_ControllerInstallationList_To_v1alpha1_ControllerInstallationList(in *core.ControllerInstallationList, out *ControllerInstallationList, s conversion.Scope) error {
	return autoConvert_core_ControllerInstallationList_To_v1alpha1_ControllerInstallationList(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec(in *ControllerInstallationSpec, out *core.ControllerInstallationSpec, s conversion.Scope) error {
	out.RegistrationRef = in.RegistrationRef
	out.SeedRef = in.SeedRef
	return nil
}

// Convert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec(in *ControllerInstallationSpec, out *core.ControllerInstallationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationSpec_To_core_ControllerInstallationSpec(in, out, s)
}

func autoConvert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec(in *core.ControllerInstallationSpec, out *ControllerInstallationSpec, s conversion.Scope) error {
	out.RegistrationRef = in.RegistrationRef
	out.SeedRef = in.SeedRef
	return nil
}

// Convert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec is an autogenerated conversion function.
func Convert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec(in *core.ControllerInstallationSpec, out *ControllerInstallationSpec, s conversion.Scope) error {
	return autoConvert_core_ControllerInstallationSpec_To_v1alpha1_ControllerInstallationSpec(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus(in *ControllerInstallationStatus, out *core.ControllerInstallationStatus, s conversion.Scope) error {
	out.Conditions = *(*[]core.Condition)(unsafe.Pointer(&in.Conditions))
	out.ProviderStatus = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderStatus))
	return nil
}

// Convert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus(in *ControllerInstallationStatus, out *core.ControllerInstallationStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationStatus_To_core_ControllerInstallationStatus(in, out, s)
}

func autoConvert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus(in *core.ControllerInstallationStatus, out *ControllerInstallationStatus, s conversion.Scope) error {
	out.Conditions = *(*[]Condition)(unsafe.Pointer(&in.Conditions))
	out.ProviderStatus = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderStatus))
	return nil
}

// Convert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus is an autogenerated conversion function.
func Convert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus(in *core.ControllerInstallationStatus, out *ControllerInstallationStatus, s conversion.Scope) error {
	return autoConvert_core_ControllerInstallationStatus_To_v1alpha1_ControllerInstallationStatus(in, out, s)
}

func autoConvert_v1alpha1_ControllerRegistration_To_core_ControllerRegistration(in *ControllerRegistration, out *core.ControllerRegistration, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ControllerRegistration_To_core_ControllerRegistration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerRegistration_To_core_ControllerRegistration(in *ControllerRegistration, out *core.ControllerRegistration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerRegistration_To_core_ControllerRegistration(in, out, s)
}

func autoConvert_core_ControllerRegistration_To_v1alpha1_ControllerRegistration(in *core.ControllerRegistration, out *ControllerRegistration, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_ControllerRegistration_To_v1alpha1_ControllerRegistration is an autogenerated conversion function.
func Convert_core_ControllerRegistration_To_v1alpha1_ControllerRegistration(in *core.ControllerRegistration, out *ControllerRegistration, s conversion.Scope) error {
	return autoConvert_core_ControllerRegistration_To_v1alpha1_ControllerRegistration(in, out, s)
}

func autoConvert_v1alpha1_ControllerRegistrationList_To_core_ControllerRegistrationList(in *ControllerRegistrationList, out *core.ControllerRegistrationList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.ControllerRegistration)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ControllerRegistrationList_To_core_ControllerRegistrationList is an autogenerated conversion function.
func Convert_v1alpha1_ControllerRegistrationList_To_core_ControllerRegistrationList(in *ControllerRegistrationList, out *core.ControllerRegistrationList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerRegistrationList_To_core_ControllerRegistrationList(in, out, s)
}

func autoConvert_core_ControllerRegistrationList_To_v1alpha1_ControllerRegistrationList(in *core.ControllerRegistrationList, out *ControllerRegistrationList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ControllerRegistration)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_ControllerRegistrationList_To_v1alpha1_ControllerRegistrationList is an autogenerated conversion function.
func Convert_core_ControllerRegistrationList_To_v1alpha1_ControllerRegistrationList(in *core.ControllerRegistrationList, out *ControllerRegistrationList, s conversion.Scope) error {
	return autoConvert_core_ControllerRegistrationList_To_v1alpha1_ControllerRegistrationList(in, out, s)
}

func autoConvert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec(in *ControllerRegistrationSpec, out *core.ControllerRegistrationSpec, s conversion.Scope) error {
	out.Resources = *(*[]core.ControllerResource)(unsafe.Pointer(&in.Resources))
	out.Deployment = (*core.ControllerDeployment)(unsafe.Pointer(in.Deployment))
	return nil
}

// Convert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec is an autogenerated conversion function.
func Convert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec(in *ControllerRegistrationSpec, out *core.ControllerRegistrationSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerRegistrationSpec_To_core_ControllerRegistrationSpec(in, out, s)
}

func autoConvert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec(in *core.ControllerRegistrationSpec, out *ControllerRegistrationSpec, s conversion.Scope) error {
	out.Resources = *(*[]ControllerResource)(unsafe.Pointer(&in.Resources))
	out.Deployment = (*ControllerDeployment)(unsafe.Pointer(in.Deployment))
	return nil
}

// Convert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec is an autogenerated conversion function.
func Convert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec(in *core.ControllerRegistrationSpec, out *ControllerRegistrationSpec, s conversion.Scope) error {
	return autoConvert_core_ControllerRegistrationSpec_To_v1alpha1_ControllerRegistrationSpec(in, out, s)
}

func autoConvert_v1alpha1_ControllerResource_To_core_ControllerResource(in *ControllerResource, out *core.ControllerResource, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Type = in.Type
	out.GloballyEnabled = (*bool)(unsafe.Pointer(in.GloballyEnabled))
	out.ReconcileTimeout = (*metav1.Duration)(unsafe.Pointer(in.ReconcileTimeout))
	out.Primary = (*bool)(unsafe.Pointer(in.Primary))
	return nil
}

// Convert_v1alpha1_ControllerResource_To_core_ControllerResource is an autogenerated conversion function.
func Convert_v1alpha1_ControllerResource_To_core_ControllerResource(in *ControllerResource, out *core.ControllerResource, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerResource_To_core_ControllerResource(in, out, s)
}

func autoConvert_core_ControllerResource_To_v1alpha1_ControllerResource(in *core.ControllerResource, out *ControllerResource, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Type = in.Type
	out.GloballyEnabled = (*bool)(unsafe.Pointer(in.GloballyEnabled))
	out.ReconcileTimeout = (*metav1.Duration)(unsafe.Pointer(in.ReconcileTimeout))
	out.Primary = (*bool)(unsafe.Pointer(in.Primary))
	return nil
}

// Convert_core_ControllerResource_To_v1alpha1_ControllerResource is an autogenerated conversion function.
func Convert_core_ControllerResource_To_v1alpha1_ControllerResource(in *core.ControllerResource, out *ControllerResource, s conversion.Scope) error {
	return autoConvert_core_ControllerResource_To_v1alpha1_ControllerResource(in, out, s)
}

func autoConvert_v1alpha1_DNS_To_core_DNS(in *DNS, out *core.DNS, s conversion.Scope) error {
	out.Domain = (*string)(unsafe.Pointer(in.Domain))
	out.Providers = *(*[]core.DNSProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_v1alpha1_DNS_To_core_DNS is an autogenerated conversion function.
func Convert_v1alpha1_DNS_To_core_DNS(in *DNS, out *core.DNS, s conversion.Scope) error {
	return autoConvert_v1alpha1_DNS_To_core_DNS(in, out, s)
}

func autoConvert_core_DNS_To_v1alpha1_DNS(in *core.DNS, out *DNS, s conversion.Scope) error {
	out.Domain = (*string)(unsafe.Pointer(in.Domain))
	out.Providers = *(*[]DNSProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_core_DNS_To_v1alpha1_DNS is an autogenerated conversion function.
func Convert_core_DNS_To_v1alpha1_DNS(in *core.DNS, out *DNS, s conversion.Scope) error {
	return autoConvert_core_DNS_To_v1alpha1_DNS(in, out, s)
}

func autoConvert_v1alpha1_DNSIncludeExclude_To_core_DNSIncludeExclude(in *DNSIncludeExclude, out *core.DNSIncludeExclude, s conversion.Scope) error {
	out.Include = *(*[]string)(unsafe.Pointer(&in.Include))
	out.Exclude = *(*[]string)(unsafe.Pointer(&in.Exclude))
	return nil
}

// Convert_v1alpha1_DNSIncludeExclude_To_core_DNSIncludeExclude is an autogenerated conversion function.
func Convert_v1alpha1_DNSIncludeExclude_To_core_DNSIncludeExclude(in *DNSIncludeExclude, out *core.DNSIncludeExclude, s conversion.Scope) error {
	return autoConvert_v1alpha1_DNSIncludeExclude_To_core_DNSIncludeExclude(in, out, s)
}

func autoConvert_core_DNSIncludeExclude_To_v1alpha1_DNSIncludeExclude(in *core.DNSIncludeExclude, out *DNSIncludeExclude, s conversion.Scope) error {
	out.Include = *(*[]string)(unsafe.Pointer(&in.Include))
	out.Exclude = *(*[]string)(unsafe.Pointer(&in.Exclude))
	return nil
}

// Convert_core_DNSIncludeExclude_To_v1alpha1_DNSIncludeExclude is an autogenerated conversion function.
func Convert_core_DNSIncludeExclude_To_v1alpha1_DNSIncludeExclude(in *core.DNSIncludeExclude, out *DNSIncludeExclude, s conversion.Scope) error {
	return autoConvert_core_DNSIncludeExclude_To_v1alpha1_DNSIncludeExclude(in, out, s)
}

func autoConvert_v1alpha1_DNSProvider_To_core_DNSProvider(in *DNSProvider, out *core.DNSProvider, s conversion.Scope) error {
	out.Domains = (*core.DNSIncludeExclude)(unsafe.Pointer(in.Domains))
	out.Primary = (*bool)(unsafe.Pointer(in.Primary))
	out.SecretName = (*string)(unsafe.Pointer(in.SecretName))
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.Zones = (*core.DNSIncludeExclude)(unsafe.Pointer(in.Zones))
	return nil
}

// Convert_v1alpha1_DNSProvider_To_core_DNSProvider is an autogenerated conversion function.
func Convert_v1alpha1_DNSProvider_To_core_DNSProvider(in *DNSProvider, out *core.DNSProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_DNSProvider_To_core_DNSProvider(in, out, s)
}

func autoConvert_core_DNSProvider_To_v1alpha1_DNSProvider(in *core.DNSProvider, out *DNSProvider, s conversion.Scope) error {
	out.Domains = (*DNSIncludeExclude)(unsafe.Pointer(in.Domains))
	out.Primary = (*bool)(unsafe.Pointer(in.Primary))
	out.SecretName = (*string)(unsafe.Pointer(in.SecretName))
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.Zones = (*DNSIncludeExclude)(unsafe.Pointer(in.Zones))
	return nil
}

// Convert_core_DNSProvider_To_v1alpha1_DNSProvider is an autogenerated conversion function.
func Convert_core_DNSProvider_To_v1alpha1_DNSProvider(in *core.DNSProvider, out *DNSProvider, s conversion.Scope) error {
	return autoConvert_core_DNSProvider_To_v1alpha1_DNSProvider(in, out, s)
}

func autoConvert_v1alpha1_DataVolume_To_core_DataVolume(in *DataVolume, out *core.DataVolume, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.VolumeSize = in.VolumeSize
	out.Encrypted = (*bool)(unsafe.Pointer(in.Encrypted))
	return nil
}

// Convert_v1alpha1_DataVolume_To_core_DataVolume is an autogenerated conversion function.
func Convert_v1alpha1_DataVolume_To_core_DataVolume(in *DataVolume, out *core.DataVolume, s conversion.Scope) error {
	return autoConvert_v1alpha1_DataVolume_To_core_DataVolume(in, out, s)
}

func autoConvert_core_DataVolume_To_v1alpha1_DataVolume(in *core.DataVolume, out *DataVolume, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.VolumeSize = in.VolumeSize
	out.Encrypted = (*bool)(unsafe.Pointer(in.Encrypted))
	return nil
}

// Convert_core_DataVolume_To_v1alpha1_DataVolume is an autogenerated conversion function.
func Convert_core_DataVolume_To_v1alpha1_DataVolume(in *core.DataVolume, out *DataVolume, s conversion.Scope) error {
	return autoConvert_core_DataVolume_To_v1alpha1_DataVolume(in, out, s)
}

func autoConvert_v1alpha1_Endpoint_To_core_Endpoint(in *Endpoint, out *core.Endpoint, s conversion.Scope) error {
	out.Name = in.Name
	out.URL = in.URL
	out.Purpose = in.Purpose
	return nil
}

// Convert_v1alpha1_Endpoint_To_core_Endpoint is an autogenerated conversion function.
func Convert_v1alpha1_Endpoint_To_core_Endpoint(in *Endpoint, out *core.Endpoint, s conversion.Scope) error {
	return autoConvert_v1alpha1_Endpoint_To_core_Endpoint(in, out, s)
}

func autoConvert_core_Endpoint_To_v1alpha1_Endpoint(in *core.Endpoint, out *Endpoint, s conversion.Scope) error {
	out.Name = in.Name
	out.URL = in.URL
	out.Purpose = in.Purpose
	return nil
}

// Convert_core_Endpoint_To_v1alpha1_Endpoint is an autogenerated conversion function.
func Convert_core_Endpoint_To_v1alpha1_Endpoint(in *core.Endpoint, out *Endpoint, s conversion.Scope) error {
	return autoConvert_core_Endpoint_To_v1alpha1_Endpoint(in, out, s)
}

func autoConvert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion(in *ExpirableVersion, out *core.ExpirableVersion, s conversion.Scope) error {
	out.Version = in.Version
	out.ExpirationDate = (*metav1.Time)(unsafe.Pointer(in.ExpirationDate))
	out.Classification = (*core.VersionClassification)(unsafe.Pointer(in.Classification))
	return nil
}

// Convert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion is an autogenerated conversion function.
func Convert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion(in *ExpirableVersion, out *core.ExpirableVersion, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion(in, out, s)
}

func autoConvert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion(in *core.ExpirableVersion, out *ExpirableVersion, s conversion.Scope) error {
	out.Version = in.Version
	out.ExpirationDate = (*metav1.Time)(unsafe.Pointer(in.ExpirationDate))
	out.Classification = (*VersionClassification)(unsafe.Pointer(in.Classification))
	return nil
}

// Convert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion is an autogenerated conversion function.
func Convert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion(in *core.ExpirableVersion, out *ExpirableVersion, s conversion.Scope) error {
	return autoConvert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion(in, out, s)
}

func autoConvert_v1alpha1_Extension_To_core_Extension(in *Extension, out *core.Extension, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Disabled = (*bool)(unsafe.Pointer(in.Disabled))
	return nil
}

// Convert_v1alpha1_Extension_To_core_Extension is an autogenerated conversion function.
func Convert_v1alpha1_Extension_To_core_Extension(in *Extension, out *core.Extension, s conversion.Scope) error {
	return autoConvert_v1alpha1_Extension_To_core_Extension(in, out, s)
}

func autoConvert_core_Extension_To_v1alpha1_Extension(in *core.Extension, out *Extension, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Disabled = (*bool)(unsafe.Pointer(in.Disabled))
	return nil
}

// Convert_core_Extension_To_v1alpha1_Extension is an autogenerated conversion function.
func Convert_core_Extension_To_v1alpha1_Extension(in *core.Extension, out *Extension, s conversion.Scope) error {
	return autoConvert_core_Extension_To_v1alpha1_Extension(in, out, s)
}

func autoConvert_v1alpha1_ExtensionResourceState_To_core_ExtensionResourceState(in *ExtensionResourceState, out *core.ExtensionResourceState, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	out.State = (*runtime.RawExtension)(unsafe.Pointer(in.State))
	out.Resources = *(*[]core.NamedResourceReference)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_v1alpha1_ExtensionResourceState_To_core_ExtensionResourceState is an autogenerated conversion function.
func Convert_v1alpha1_ExtensionResourceState_To_core_ExtensionResourceState(in *ExtensionResourceState, out *core.ExtensionResourceState, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExtensionResourceState_To_core_ExtensionResourceState(in, out, s)
}

func autoConvert_core_ExtensionResourceState_To_v1alpha1_ExtensionResourceState(in *core.ExtensionResourceState, out *ExtensionResourceState, s conversion.Scope) error {
	out.Kind = in.Kind
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	out.State = (*runtime.RawExtension)(unsafe.Pointer(in.State))
	out.Resources = *(*[]v1beta1.NamedResourceReference)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_core_ExtensionResourceState_To_v1alpha1_ExtensionResourceState is an autogenerated conversion function.
func Convert_core_ExtensionResourceState_To_v1alpha1_ExtensionResourceState(in *core.ExtensionResourceState, out *ExtensionResourceState, s conversion.Scope) error {
	return autoConvert_core_ExtensionResourceState_To_v1alpha1_ExtensionResourceState(in, out, s)
}

func autoConvert_v1alpha1_Gardener_To_core_Gardener(in *Gardener, out *core.Gardener, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Version = in.Version
	return nil
}

// Convert_v1alpha1_Gardener_To_core_Gardener is an autogenerated conversion function.
func Convert_v1alpha1_Gardener_To_core_Gardener(in *Gardener, out *core.Gardener, s conversion.Scope) error {
	return autoConvert_v1alpha1_Gardener_To_core_Gardener(in, out, s)
}

func autoConvert_core_Gardener_To_v1alpha1_Gardener(in *core.Gardener, out *Gardener, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Version = in.Version
	return nil
}

// Convert_core_Gardener_To_v1alpha1_Gardener is an autogenerated conversion function.
func Convert_core_Gardener_To_v1alpha1_Gardener(in *core.Gardener, out *Gardener, s conversion.Scope) error {
	return autoConvert_core_Gardener_To_v1alpha1_Gardener(in, out, s)
}

func autoConvert_v1alpha1_GardenerResourceData_To_core_GardenerResourceData(in *GardenerResourceData, out *core.GardenerResourceData, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = in.Type
	out.Data = in.Data
	return nil
}

// Convert_v1alpha1_GardenerResourceData_To_core_GardenerResourceData is an autogenerated conversion function.
func Convert_v1alpha1_GardenerResourceData_To_core_GardenerResourceData(in *GardenerResourceData, out *core.GardenerResourceData, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenerResourceData_To_core_GardenerResourceData(in, out, s)
}

func autoConvert_core_GardenerResourceData_To_v1alpha1_GardenerResourceData(in *core.GardenerResourceData, out *GardenerResourceData, s conversion.Scope) error {
	out.Name = in.Name
	out.Type = in.Type
	out.Data = in.Data
	return nil
}

// Convert_core_GardenerResourceData_To_v1alpha1_GardenerResourceData is an autogenerated conversion function.
func Convert_core_GardenerResourceData_To_v1alpha1_GardenerResourceData(in *core.GardenerResourceData, out *GardenerResourceData, s conversion.Scope) error {
	return autoConvert_core_GardenerResourceData_To_v1alpha1_GardenerResourceData(in, out, s)
}

func autoConvert_v1alpha1_Hibernation_To_core_Hibernation(in *Hibernation, out *core.Hibernation, s conversion.Scope) error {
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	out.Schedules = *(*[]core.HibernationSchedule)(unsafe.Pointer(&in.Schedules))
	return nil
}

// Convert_v1alpha1_Hibernation_To_core_Hibernation is an autogenerated conversion function.
func Convert_v1alpha1_Hibernation_To_core_Hibernation(in *Hibernation, out *core.Hibernation, s conversion.Scope) error {
	return autoConvert_v1alpha1_Hibernation_To_core_Hibernation(in, out, s)
}

func autoConvert_core_Hibernation_To_v1alpha1_Hibernation(in *core.Hibernation, out *Hibernation, s conversion.Scope) error {
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	out.Schedules = *(*[]HibernationSchedule)(unsafe.Pointer(&in.Schedules))
	return nil
}

// Convert_core_Hibernation_To_v1alpha1_Hibernation is an autogenerated conversion function.
func Convert_core_Hibernation_To_v1alpha1_Hibernation(in *core.Hibernation, out *Hibernation, s conversion.Scope) error {
	return autoConvert_core_Hibernation_To_v1alpha1_Hibernation(in, out, s)
}

func autoConvert_v1alpha1_HibernationSchedule_To_core_HibernationSchedule(in *HibernationSchedule, out *core.HibernationSchedule, s conversion.Scope) error {
	out.Start = (*string)(unsafe.Pointer(in.Start))
	out.End = (*string)(unsafe.Pointer(in.End))
	out.Location = (*string)(unsafe.Pointer(in.Location))
	return nil
}

// Convert_v1alpha1_HibernationSchedule_To_core_HibernationSchedule is an autogenerated conversion function.
func Convert_v1alpha1_HibernationSchedule_To_core_HibernationSchedule(in *HibernationSchedule, out *core.HibernationSchedule, s conversion.Scope) error {
	return autoConvert_v1alpha1_HibernationSchedule_To_core_HibernationSchedule(in, out, s)
}

func autoConvert_core_HibernationSchedule_To_v1alpha1_HibernationSchedule(in *core.HibernationSchedule, out *HibernationSchedule, s conversion.Scope) error {
	out.Start = (*string)(unsafe.Pointer(in.Start))
	out.End = (*string)(unsafe.Pointer(in.End))
	out.Location = (*string)(unsafe.Pointer(in.Location))
	return nil
}

// Convert_core_HibernationSchedule_To_v1alpha1_HibernationSchedule is an autogenerated conversion function.
func Convert_core_HibernationSchedule_To_v1alpha1_HibernationSchedule(in *core.HibernationSchedule, out *HibernationSchedule, s conversion.Scope) error {
	return autoConvert_core_HibernationSchedule_To_v1alpha1_HibernationSchedule(in, out, s)
}

func autoConvert_v1alpha1_HorizontalPodAutoscalerConfig_To_core_HorizontalPodAutoscalerConfig(in *HorizontalPodAutoscalerConfig, out *core.HorizontalPodAutoscalerConfig, s conversion.Scope) error {
	out.CPUInitializationPeriod = (*metav1.Duration)(unsafe.Pointer(in.CPUInitializationPeriod))
	out.DownscaleDelay = (*metav1.Duration)(unsafe.Pointer(in.DownscaleDelay))
	out.DownscaleStabilization = (*metav1.Duration)(unsafe.Pointer(in.DownscaleStabilization))
	out.InitialReadinessDelay = (*metav1.Duration)(unsafe.Pointer(in.InitialReadinessDelay))
	out.SyncPeriod = (*metav1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.Tolerance = (*float64)(unsafe.Pointer(in.Tolerance))
	out.UpscaleDelay = (*metav1.Duration)(unsafe.Pointer(in.UpscaleDelay))
	return nil
}

// Convert_v1alpha1_HorizontalPodAutoscalerConfig_To_core_HorizontalPodAutoscalerConfig is an autogenerated conversion function.
func Convert_v1alpha1_HorizontalPodAutoscalerConfig_To_core_HorizontalPodAutoscalerConfig(in *HorizontalPodAutoscalerConfig, out *core.HorizontalPodAutoscalerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_HorizontalPodAutoscalerConfig_To_core_HorizontalPodAutoscalerConfig(in, out, s)
}

func autoConvert_core_HorizontalPodAutoscalerConfig_To_v1alpha1_HorizontalPodAutoscalerConfig(in *core.HorizontalPodAutoscalerConfig, out *HorizontalPodAutoscalerConfig, s conversion.Scope) error {
	out.CPUInitializationPeriod = (*metav1.Duration)(unsafe.Pointer(in.CPUInitializationPeriod))
	out.DownscaleDelay = (*metav1.Duration)(unsafe.Pointer(in.DownscaleDelay))
	out.DownscaleStabilization = (*metav1.Duration)(unsafe.Pointer(in.DownscaleStabilization))
	out.InitialReadinessDelay = (*metav1.Duration)(unsafe.Pointer(in.InitialReadinessDelay))
	out.SyncPeriod = (*metav1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.Tolerance = (*float64)(unsafe.Pointer(in.Tolerance))
	out.UpscaleDelay = (*metav1.Duration)(unsafe.Pointer(in.UpscaleDelay))
	return nil
}

// Convert_core_HorizontalPodAutoscalerConfig_To_v1alpha1_HorizontalPodAutoscalerConfig is an autogenerated conversion function.
func Convert_core_HorizontalPodAutoscalerConfig_To_v1alpha1_HorizontalPodAutoscalerConfig(in *core.HorizontalPodAutoscalerConfig, out *HorizontalPodAutoscalerConfig, s conversion.Scope) error {
	return autoConvert_core_HorizontalPodAutoscalerConfig_To_v1alpha1_HorizontalPodAutoscalerConfig(in, out, s)
}

func autoConvert_v1alpha1_Ingress_To_core_Ingress(in *Ingress, out *core.Ingress, s conversion.Scope) error {
	out.Domain = in.Domain
	if err := Convert_v1alpha1_IngressController_To_core_IngressController(&in.Controller, &out.Controller, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Ingress_To_core_Ingress is an autogenerated conversion function.
func Convert_v1alpha1_Ingress_To_core_Ingress(in *Ingress, out *core.Ingress, s conversion.Scope) error {
	return autoConvert_v1alpha1_Ingress_To_core_Ingress(in, out, s)
}

func autoConvert_core_Ingress_To_v1alpha1_Ingress(in *core.Ingress, out *Ingress, s conversion.Scope) error {
	out.Domain = in.Domain
	if err := Convert_core_IngressController_To_v1alpha1_IngressController(&in.Controller, &out.Controller, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_Ingress_To_v1alpha1_Ingress is an autogenerated conversion function.
func Convert_core_Ingress_To_v1alpha1_Ingress(in *core.Ingress, out *Ingress, s conversion.Scope) error {
	return autoConvert_core_Ingress_To_v1alpha1_Ingress(in, out, s)
}

func autoConvert_v1alpha1_IngressController_To_core_IngressController(in *IngressController, out *core.IngressController, s conversion.Scope) error {
	out.Kind = in.Kind
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	return nil
}

// Convert_v1alpha1_IngressController_To_core_IngressController is an autogenerated conversion function.
func Convert_v1alpha1_IngressController_To_core_IngressController(in *IngressController, out *core.IngressController, s conversion.Scope) error {
	return autoConvert_v1alpha1_IngressController_To_core_IngressController(in, out, s)
}

func autoConvert_core_IngressController_To_v1alpha1_IngressController(in *core.IngressController, out *IngressController, s conversion.Scope) error {
	out.Kind = in.Kind
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	return nil
}

// Convert_core_IngressController_To_v1alpha1_IngressController is an autogenerated conversion function.
func Convert_core_IngressController_To_v1alpha1_IngressController(in *core.IngressController, out *IngressController, s conversion.Scope) error {
	return autoConvert_core_IngressController_To_v1alpha1_IngressController(in, out, s)
}

func autoConvert_v1alpha1_KubeAPIServerConfig_To_core_KubeAPIServerConfig(in *KubeAPIServerConfig, out *core.KubeAPIServerConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.AdmissionPlugins = *(*[]core.AdmissionPlugin)(unsafe.Pointer(&in.AdmissionPlugins))
	out.APIAudiences = *(*[]string)(unsafe.Pointer(&in.APIAudiences))
	out.AuditConfig = (*core.AuditConfig)(unsafe.Pointer(in.AuditConfig))
	out.EnableBasicAuthentication = (*bool)(unsafe.Pointer(in.EnableBasicAuthentication))
	out.OIDCConfig = (*core.OIDCConfig)(unsafe.Pointer(in.OIDCConfig))
	out.RuntimeConfig = *(*map[string]bool)(unsafe.Pointer(&in.RuntimeConfig))
	out.ServiceAccountConfig = (*core.ServiceAccountConfig)(unsafe.Pointer(in.ServiceAccountConfig))
	out.WatchCacheSizes = (*core.WatchCacheSizes)(unsafe.Pointer(in.WatchCacheSizes))
	out.Requests = (*core.KubeAPIServerRequests)(unsafe.Pointer(in.Requests))
	return nil
}

// Convert_v1alpha1_KubeAPIServerConfig_To_core_KubeAPIServerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeAPIServerConfig_To_core_KubeAPIServerConfig(in *KubeAPIServerConfig, out *core.KubeAPIServerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeAPIServerConfig_To_core_KubeAPIServerConfig(in, out, s)
}

func autoConvert_core_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in *core.KubeAPIServerConfig, out *KubeAPIServerConfig, s conversion.Scope) error {
	if err := Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.AdmissionPlugins = *(*[]AdmissionPlugin)(unsafe.Pointer(&in.AdmissionPlugins))
	out.APIAudiences = *(*[]string)(unsafe.Pointer(&in.APIAudiences))
	out.AuditConfig = (*AuditConfig)(unsafe.Pointer(in.AuditConfig))
	out.EnableBasicAuthentication = (*bool)(unsafe.Pointer(in.EnableBasicAuthentication))
	out.OIDCConfig = (*OIDCConfig)(unsafe.Pointer(in.OIDCConfig))
	out.RuntimeConfig = *(*map[string]bool)(unsafe.Pointer(&in.RuntimeConfig))
	out.ServiceAccountConfig = (*ServiceAccountConfig)(unsafe.Pointer(in.ServiceAccountConfig))
	out.WatchCacheSizes = (*WatchCacheSizes)(unsafe.Pointer(in.WatchCacheSizes))
	out.Requests = (*KubeAPIServerRequests)(unsafe.Pointer(in.Requests))
	return nil
}

// Convert_core_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig is an autogenerated conversion function.
func Convert_core_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in *core.KubeAPIServerConfig, out *KubeAPIServerConfig, s conversion.Scope) error {
	return autoConvert_core_KubeAPIServerConfig_To_v1alpha1_KubeAPIServerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeAPIServerRequests_To_core_KubeAPIServerRequests(in *KubeAPIServerRequests, out *core.KubeAPIServerRequests, s conversion.Scope) error {
	out.MaxNonMutatingInflight = (*int32)(unsafe.Pointer(in.MaxNonMutatingInflight))
	out.MaxMutatingInflight = (*int32)(unsafe.Pointer(in.MaxMutatingInflight))
	return nil
}

// Convert_v1alpha1_KubeAPIServerRequests_To_core_KubeAPIServerRequests is an autogenerated conversion function.
func Convert_v1alpha1_KubeAPIServerRequests_To_core_KubeAPIServerRequests(in *KubeAPIServerRequests, out *core.KubeAPIServerRequests, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeAPIServerRequests_To_core_KubeAPIServerRequests(in, out, s)
}

func autoConvert_core_KubeAPIServerRequests_To_v1alpha1_KubeAPIServerRequests(in *core.KubeAPIServerRequests, out *KubeAPIServerRequests, s conversion.Scope) error {
	out.MaxNonMutatingInflight = (*int32)(unsafe.Pointer(in.MaxNonMutatingInflight))
	out.MaxMutatingInflight = (*int32)(unsafe.Pointer(in.MaxMutatingInflight))
	return nil
}

// Convert_core_KubeAPIServerRequests_To_v1alpha1_KubeAPIServerRequests is an autogenerated conversion function.
func Convert_core_KubeAPIServerRequests_To_v1alpha1_KubeAPIServerRequests(in *core.KubeAPIServerRequests, out *KubeAPIServerRequests, s conversion.Scope) error {
	return autoConvert_core_KubeAPIServerRequests_To_v1alpha1_KubeAPIServerRequests(in, out, s)
}

func autoConvert_v1alpha1_KubeControllerManagerConfig_To_core_KubeControllerManagerConfig(in *KubeControllerManagerConfig, out *core.KubeControllerManagerConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.HorizontalPodAutoscalerConfig = (*core.HorizontalPodAutoscalerConfig)(unsafe.Pointer(in.HorizontalPodAutoscalerConfig))
	out.NodeCIDRMaskSize = (*int32)(unsafe.Pointer(in.NodeCIDRMaskSize))
	out.PodEvictionTimeout = (*metav1.Duration)(unsafe.Pointer(in.PodEvictionTimeout))
	return nil
}

// Convert_v1alpha1_KubeControllerManagerConfig_To_core_KubeControllerManagerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeControllerManagerConfig_To_core_KubeControllerManagerConfig(in *KubeControllerManagerConfig, out *core.KubeControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeControllerManagerConfig_To_core_KubeControllerManagerConfig(in, out, s)
}

func autoConvert_core_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in *core.KubeControllerManagerConfig, out *KubeControllerManagerConfig, s conversion.Scope) error {
	if err := Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.HorizontalPodAutoscalerConfig = (*HorizontalPodAutoscalerConfig)(unsafe.Pointer(in.HorizontalPodAutoscalerConfig))
	out.NodeCIDRMaskSize = (*int32)(unsafe.Pointer(in.NodeCIDRMaskSize))
	out.PodEvictionTimeout = (*metav1.Duration)(unsafe.Pointer(in.PodEvictionTimeout))
	return nil
}

// Convert_core_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig is an autogenerated conversion function.
func Convert_core_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in *core.KubeControllerManagerConfig, out *KubeControllerManagerConfig, s conversion.Scope) error {
	return autoConvert_core_KubeControllerManagerConfig_To_v1alpha1_KubeControllerManagerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeProxyConfig_To_core_KubeProxyConfig(in *KubeProxyConfig, out *core.KubeProxyConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.Mode = (*core.ProxyMode)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_v1alpha1_KubeProxyConfig_To_core_KubeProxyConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeProxyConfig_To_core_KubeProxyConfig(in *KubeProxyConfig, out *core.KubeProxyConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeProxyConfig_To_core_KubeProxyConfig(in, out, s)
}

func autoConvert_core_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in *core.KubeProxyConfig, out *KubeProxyConfig, s conversion.Scope) error {
	if err := Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.Mode = (*ProxyMode)(unsafe.Pointer(in.Mode))
	return nil
}

// Convert_core_KubeProxyConfig_To_v1alpha1_KubeProxyConfig is an autogenerated conversion function.
func Convert_core_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in *core.KubeProxyConfig, out *KubeProxyConfig, s conversion.Scope) error {
	return autoConvert_core_KubeProxyConfig_To_v1alpha1_KubeProxyConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeSchedulerConfig_To_core_KubeSchedulerConfig(in *KubeSchedulerConfig, out *core.KubeSchedulerConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.KubeMaxPDVols = (*string)(unsafe.Pointer(in.KubeMaxPDVols))
	return nil
}

// Convert_v1alpha1_KubeSchedulerConfig_To_core_KubeSchedulerConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeSchedulerConfig_To_core_KubeSchedulerConfig(in *KubeSchedulerConfig, out *core.KubeSchedulerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeSchedulerConfig_To_core_KubeSchedulerConfig(in, out, s)
}

func autoConvert_core_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in *core.KubeSchedulerConfig, out *KubeSchedulerConfig, s conversion.Scope) error {
	if err := Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.KubeMaxPDVols = (*string)(unsafe.Pointer(in.KubeMaxPDVols))
	return nil
}

// Convert_core_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig is an autogenerated conversion function.
func Convert_core_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in *core.KubeSchedulerConfig, out *KubeSchedulerConfig, s conversion.Scope) error {
	return autoConvert_core_KubeSchedulerConfig_To_v1alpha1_KubeSchedulerConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfig_To_core_KubeletConfig(in *KubeletConfig, out *core.KubeletConfig, s conversion.Scope) error {
	if err := Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.CPUCFSQuota = (*bool)(unsafe.Pointer(in.CPUCFSQuota))
	out.CPUManagerPolicy = (*string)(unsafe.Pointer(in.CPUManagerPolicy))
	out.EvictionHard = (*core.KubeletConfigEviction)(unsafe.Pointer(in.EvictionHard))
	out.EvictionMaxPodGracePeriod = (*int32)(unsafe.Pointer(in.EvictionMaxPodGracePeriod))
	out.EvictionMinimumReclaim = (*core.KubeletConfigEvictionMinimumReclaim)(unsafe.Pointer(in.EvictionMinimumReclaim))
	out.EvictionPressureTransitionPeriod = (*metav1.Duration)(unsafe.Pointer(in.EvictionPressureTransitionPeriod))
	out.EvictionSoft = (*core.KubeletConfigEviction)(unsafe.Pointer(in.EvictionSoft))
	out.EvictionSoftGracePeriod = (*core.KubeletConfigEvictionSoftGracePeriod)(unsafe.Pointer(in.EvictionSoftGracePeriod))
	out.MaxPods = (*int32)(unsafe.Pointer(in.MaxPods))
	out.PodPIDsLimit = (*int64)(unsafe.Pointer(in.PodPIDsLimit))
	out.ImagePullProgressDeadline = (*metav1.Duration)(unsafe.Pointer(in.ImagePullProgressDeadline))
	out.FailSwapOn = (*bool)(unsafe.Pointer(in.FailSwapOn))
	out.KubeReserved = (*core.KubeletConfigReserved)(unsafe.Pointer(in.KubeReserved))
	out.SystemReserved = (*core.KubeletConfigReserved)(unsafe.Pointer(in.SystemReserved))
	return nil
}

// Convert_v1alpha1_KubeletConfig_To_core_KubeletConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfig_To_core_KubeletConfig(in *KubeletConfig, out *core.KubeletConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfig_To_core_KubeletConfig(in, out, s)
}

func autoConvert_core_KubeletConfig_To_v1alpha1_KubeletConfig(in *core.KubeletConfig, out *KubeletConfig, s conversion.Scope) error {
	if err := Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(&in.KubernetesConfig, &out.KubernetesConfig, s); err != nil {
		return err
	}
	out.CPUCFSQuota = (*bool)(unsafe.Pointer(in.CPUCFSQuota))
	out.CPUManagerPolicy = (*string)(unsafe.Pointer(in.CPUManagerPolicy))
	out.EvictionHard = (*KubeletConfigEviction)(unsafe.Pointer(in.EvictionHard))
	out.EvictionMaxPodGracePeriod = (*int32)(unsafe.Pointer(in.EvictionMaxPodGracePeriod))
	out.EvictionMinimumReclaim = (*KubeletConfigEvictionMinimumReclaim)(unsafe.Pointer(in.EvictionMinimumReclaim))
	out.EvictionPressureTransitionPeriod = (*metav1.Duration)(unsafe.Pointer(in.EvictionPressureTransitionPeriod))
	out.EvictionSoft = (*KubeletConfigEviction)(unsafe.Pointer(in.EvictionSoft))
	out.EvictionSoftGracePeriod = (*KubeletConfigEvictionSoftGracePeriod)(unsafe.Pointer(in.EvictionSoftGracePeriod))
	out.MaxPods = (*int32)(unsafe.Pointer(in.MaxPods))
	out.PodPIDsLimit = (*int64)(unsafe.Pointer(in.PodPIDsLimit))
	out.ImagePullProgressDeadline = (*metav1.Duration)(unsafe.Pointer(in.ImagePullProgressDeadline))
	out.FailSwapOn = (*bool)(unsafe.Pointer(in.FailSwapOn))
	out.KubeReserved = (*KubeletConfigReserved)(unsafe.Pointer(in.KubeReserved))
	out.SystemReserved = (*KubeletConfigReserved)(unsafe.Pointer(in.SystemReserved))
	return nil
}

// Convert_core_KubeletConfig_To_v1alpha1_KubeletConfig is an autogenerated conversion function.
func Convert_core_KubeletConfig_To_v1alpha1_KubeletConfig(in *core.KubeletConfig, out *KubeletConfig, s conversion.Scope) error {
	return autoConvert_core_KubeletConfig_To_v1alpha1_KubeletConfig(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfigEviction_To_core_KubeletConfigEviction(in *KubeletConfigEviction, out *core.KubeletConfigEviction, s conversion.Scope) error {
	out.MemoryAvailable = (*string)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*string)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*string)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*string)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*string)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_v1alpha1_KubeletConfigEviction_To_core_KubeletConfigEviction is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfigEviction_To_core_KubeletConfigEviction(in *KubeletConfigEviction, out *core.KubeletConfigEviction, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfigEviction_To_core_KubeletConfigEviction(in, out, s)
}

func autoConvert_core_KubeletConfigEviction_To_v1alpha1_KubeletConfigEviction(in *core.KubeletConfigEviction, out *KubeletConfigEviction, s conversion.Scope) error {
	out.MemoryAvailable = (*string)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*string)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*string)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*string)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*string)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_core_KubeletConfigEviction_To_v1alpha1_KubeletConfigEviction is an autogenerated conversion function.
func Convert_core_KubeletConfigEviction_To_v1alpha1_KubeletConfigEviction(in *core.KubeletConfigEviction, out *KubeletConfigEviction, s conversion.Scope) error {
	return autoConvert_core_KubeletConfigEviction_To_v1alpha1_KubeletConfigEviction(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfigEvictionMinimumReclaim_To_core_KubeletConfigEvictionMinimumReclaim(in *KubeletConfigEvictionMinimumReclaim, out *core.KubeletConfigEvictionMinimumReclaim, s conversion.Scope) error {
	out.MemoryAvailable = (*resource.Quantity)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*resource.Quantity)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*resource.Quantity)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*resource.Quantity)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*resource.Quantity)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_v1alpha1_KubeletConfigEvictionMinimumReclaim_To_core_KubeletConfigEvictionMinimumReclaim is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfigEvictionMinimumReclaim_To_core_KubeletConfigEvictionMinimumReclaim(in *KubeletConfigEvictionMinimumReclaim, out *core.KubeletConfigEvictionMinimumReclaim, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfigEvictionMinimumReclaim_To_core_KubeletConfigEvictionMinimumReclaim(in, out, s)
}

func autoConvert_core_KubeletConfigEvictionMinimumReclaim_To_v1alpha1_KubeletConfigEvictionMinimumReclaim(in *core.KubeletConfigEvictionMinimumReclaim, out *KubeletConfigEvictionMinimumReclaim, s conversion.Scope) error {
	out.MemoryAvailable = (*resource.Quantity)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*resource.Quantity)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*resource.Quantity)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*resource.Quantity)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*resource.Quantity)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_core_KubeletConfigEvictionMinimumReclaim_To_v1alpha1_KubeletConfigEvictionMinimumReclaim is an autogenerated conversion function.
func Convert_core_KubeletConfigEvictionMinimumReclaim_To_v1alpha1_KubeletConfigEvictionMinimumReclaim(in *core.KubeletConfigEvictionMinimumReclaim, out *KubeletConfigEvictionMinimumReclaim, s conversion.Scope) error {
	return autoConvert_core_KubeletConfigEvictionMinimumReclaim_To_v1alpha1_KubeletConfigEvictionMinimumReclaim(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfigEvictionSoftGracePeriod_To_core_KubeletConfigEvictionSoftGracePeriod(in *KubeletConfigEvictionSoftGracePeriod, out *core.KubeletConfigEvictionSoftGracePeriod, s conversion.Scope) error {
	out.MemoryAvailable = (*metav1.Duration)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*metav1.Duration)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*metav1.Duration)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*metav1.Duration)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*metav1.Duration)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_v1alpha1_KubeletConfigEvictionSoftGracePeriod_To_core_KubeletConfigEvictionSoftGracePeriod is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfigEvictionSoftGracePeriod_To_core_KubeletConfigEvictionSoftGracePeriod(in *KubeletConfigEvictionSoftGracePeriod, out *core.KubeletConfigEvictionSoftGracePeriod, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfigEvictionSoftGracePeriod_To_core_KubeletConfigEvictionSoftGracePeriod(in, out, s)
}

func autoConvert_core_KubeletConfigEvictionSoftGracePeriod_To_v1alpha1_KubeletConfigEvictionSoftGracePeriod(in *core.KubeletConfigEvictionSoftGracePeriod, out *KubeletConfigEvictionSoftGracePeriod, s conversion.Scope) error {
	out.MemoryAvailable = (*metav1.Duration)(unsafe.Pointer(in.MemoryAvailable))
	out.ImageFSAvailable = (*metav1.Duration)(unsafe.Pointer(in.ImageFSAvailable))
	out.ImageFSInodesFree = (*metav1.Duration)(unsafe.Pointer(in.ImageFSInodesFree))
	out.NodeFSAvailable = (*metav1.Duration)(unsafe.Pointer(in.NodeFSAvailable))
	out.NodeFSInodesFree = (*metav1.Duration)(unsafe.Pointer(in.NodeFSInodesFree))
	return nil
}

// Convert_core_KubeletConfigEvictionSoftGracePeriod_To_v1alpha1_KubeletConfigEvictionSoftGracePeriod is an autogenerated conversion function.
func Convert_core_KubeletConfigEvictionSoftGracePeriod_To_v1alpha1_KubeletConfigEvictionSoftGracePeriod(in *core.KubeletConfigEvictionSoftGracePeriod, out *KubeletConfigEvictionSoftGracePeriod, s conversion.Scope) error {
	return autoConvert_core_KubeletConfigEvictionSoftGracePeriod_To_v1alpha1_KubeletConfigEvictionSoftGracePeriod(in, out, s)
}

func autoConvert_v1alpha1_KubeletConfigReserved_To_core_KubeletConfigReserved(in *KubeletConfigReserved, out *core.KubeletConfigReserved, s conversion.Scope) error {
	out.CPU = (*resource.Quantity)(unsafe.Pointer(in.CPU))
	out.Memory = (*resource.Quantity)(unsafe.Pointer(in.Memory))
	out.EphemeralStorage = (*resource.Quantity)(unsafe.Pointer(in.EphemeralStorage))
	out.PID = (*resource.Quantity)(unsafe.Pointer(in.PID))
	return nil
}

// Convert_v1alpha1_KubeletConfigReserved_To_core_KubeletConfigReserved is an autogenerated conversion function.
func Convert_v1alpha1_KubeletConfigReserved_To_core_KubeletConfigReserved(in *KubeletConfigReserved, out *core.KubeletConfigReserved, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeletConfigReserved_To_core_KubeletConfigReserved(in, out, s)
}

func autoConvert_core_KubeletConfigReserved_To_v1alpha1_KubeletConfigReserved(in *core.KubeletConfigReserved, out *KubeletConfigReserved, s conversion.Scope) error {
	out.CPU = (*resource.Quantity)(unsafe.Pointer(in.CPU))
	out.Memory = (*resource.Quantity)(unsafe.Pointer(in.Memory))
	out.EphemeralStorage = (*resource.Quantity)(unsafe.Pointer(in.EphemeralStorage))
	out.PID = (*resource.Quantity)(unsafe.Pointer(in.PID))
	return nil
}

// Convert_core_KubeletConfigReserved_To_v1alpha1_KubeletConfigReserved is an autogenerated conversion function.
func Convert_core_KubeletConfigReserved_To_v1alpha1_KubeletConfigReserved(in *core.KubeletConfigReserved, out *KubeletConfigReserved, s conversion.Scope) error {
	return autoConvert_core_KubeletConfigReserved_To_v1alpha1_KubeletConfigReserved(in, out, s)
}

func autoConvert_v1alpha1_Kubernetes_To_core_Kubernetes(in *Kubernetes, out *core.Kubernetes, s conversion.Scope) error {
	out.AllowPrivilegedContainers = (*bool)(unsafe.Pointer(in.AllowPrivilegedContainers))
	out.ClusterAutoscaler = (*core.ClusterAutoscaler)(unsafe.Pointer(in.ClusterAutoscaler))
	out.KubeAPIServer = (*core.KubeAPIServerConfig)(unsafe.Pointer(in.KubeAPIServer))
	out.KubeControllerManager = (*core.KubeControllerManagerConfig)(unsafe.Pointer(in.KubeControllerManager))
	out.KubeScheduler = (*core.KubeSchedulerConfig)(unsafe.Pointer(in.KubeScheduler))
	out.KubeProxy = (*core.KubeProxyConfig)(unsafe.Pointer(in.KubeProxy))
	out.Kubelet = (*core.KubeletConfig)(unsafe.Pointer(in.Kubelet))
	out.Version = in.Version
	out.VerticalPodAutoscaler = (*core.VerticalPodAutoscaler)(unsafe.Pointer(in.VerticalPodAutoscaler))
	return nil
}

// Convert_v1alpha1_Kubernetes_To_core_Kubernetes is an autogenerated conversion function.
func Convert_v1alpha1_Kubernetes_To_core_Kubernetes(in *Kubernetes, out *core.Kubernetes, s conversion.Scope) error {
	return autoConvert_v1alpha1_Kubernetes_To_core_Kubernetes(in, out, s)
}

func autoConvert_core_Kubernetes_To_v1alpha1_Kubernetes(in *core.Kubernetes, out *Kubernetes, s conversion.Scope) error {
	out.AllowPrivilegedContainers = (*bool)(unsafe.Pointer(in.AllowPrivilegedContainers))
	out.ClusterAutoscaler = (*ClusterAutoscaler)(unsafe.Pointer(in.ClusterAutoscaler))
	out.KubeAPIServer = (*KubeAPIServerConfig)(unsafe.Pointer(in.KubeAPIServer))
	out.KubeControllerManager = (*KubeControllerManagerConfig)(unsafe.Pointer(in.KubeControllerManager))
	out.KubeScheduler = (*KubeSchedulerConfig)(unsafe.Pointer(in.KubeScheduler))
	out.KubeProxy = (*KubeProxyConfig)(unsafe.Pointer(in.KubeProxy))
	out.Kubelet = (*KubeletConfig)(unsafe.Pointer(in.Kubelet))
	out.Version = in.Version
	out.VerticalPodAutoscaler = (*VerticalPodAutoscaler)(unsafe.Pointer(in.VerticalPodAutoscaler))
	return nil
}

// Convert_core_Kubernetes_To_v1alpha1_Kubernetes is an autogenerated conversion function.
func Convert_core_Kubernetes_To_v1alpha1_Kubernetes(in *core.Kubernetes, out *Kubernetes, s conversion.Scope) error {
	return autoConvert_core_Kubernetes_To_v1alpha1_Kubernetes(in, out, s)
}

func autoConvert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(in *KubernetesConfig, out *core.KubernetesConfig, s conversion.Scope) error {
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig is an autogenerated conversion function.
func Convert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(in *KubernetesConfig, out *core.KubernetesConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubernetesConfig_To_core_KubernetesConfig(in, out, s)
}

func autoConvert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(in *core.KubernetesConfig, out *KubernetesConfig, s conversion.Scope) error {
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig is an autogenerated conversion function.
func Convert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(in *core.KubernetesConfig, out *KubernetesConfig, s conversion.Scope) error {
	return autoConvert_core_KubernetesConfig_To_v1alpha1_KubernetesConfig(in, out, s)
}

func autoConvert_v1alpha1_KubernetesDashboard_To_core_KubernetesDashboard(in *KubernetesDashboard, out *core.KubernetesDashboard, s conversion.Scope) error {
	if err := Convert_v1alpha1_Addon_To_core_Addon(&in.Addon, &out.Addon, s); err != nil {
		return err
	}
	out.AuthenticationMode = (*string)(unsafe.Pointer(in.AuthenticationMode))
	return nil
}

// Convert_v1alpha1_KubernetesDashboard_To_core_KubernetesDashboard is an autogenerated conversion function.
func Convert_v1alpha1_KubernetesDashboard_To_core_KubernetesDashboard(in *KubernetesDashboard, out *core.KubernetesDashboard, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubernetesDashboard_To_core_KubernetesDashboard(in, out, s)
}

func autoConvert_core_KubernetesDashboard_To_v1alpha1_KubernetesDashboard(in *core.KubernetesDashboard, out *KubernetesDashboard, s conversion.Scope) error {
	if err := Convert_core_Addon_To_v1alpha1_Addon(&in.Addon, &out.Addon, s); err != nil {
		return err
	}
	out.AuthenticationMode = (*string)(unsafe.Pointer(in.AuthenticationMode))
	return nil
}

// Convert_core_KubernetesDashboard_To_v1alpha1_KubernetesDashboard is an autogenerated conversion function.
func Convert_core_KubernetesDashboard_To_v1alpha1_KubernetesDashboard(in *core.KubernetesDashboard, out *KubernetesDashboard, s conversion.Scope) error {
	return autoConvert_core_KubernetesDashboard_To_v1alpha1_KubernetesDashboard(in, out, s)
}

func autoConvert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo(in *KubernetesInfo, out *core.KubernetesInfo, s conversion.Scope) error {
	out.Version = in.Version
	return nil
}

// Convert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo is an autogenerated conversion function.
func Convert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo(in *KubernetesInfo, out *core.KubernetesInfo, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubernetesInfo_To_core_KubernetesInfo(in, out, s)
}

func autoConvert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo(in *core.KubernetesInfo, out *KubernetesInfo, s conversion.Scope) error {
	out.Version = in.Version
	return nil
}

// Convert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo is an autogenerated conversion function.
func Convert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo(in *core.KubernetesInfo, out *KubernetesInfo, s conversion.Scope) error {
	return autoConvert_core_KubernetesInfo_To_v1alpha1_KubernetesInfo(in, out, s)
}

func autoConvert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings(in *KubernetesSettings, out *core.KubernetesSettings, s conversion.Scope) error {
	out.Versions = *(*[]core.ExpirableVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings is an autogenerated conversion function.
func Convert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings(in *KubernetesSettings, out *core.KubernetesSettings, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubernetesSettings_To_core_KubernetesSettings(in, out, s)
}

func autoConvert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings(in *core.KubernetesSettings, out *KubernetesSettings, s conversion.Scope) error {
	out.Versions = *(*[]ExpirableVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings is an autogenerated conversion function.
func Convert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings(in *core.KubernetesSettings, out *KubernetesSettings, s conversion.Scope) error {
	return autoConvert_core_KubernetesSettings_To_v1alpha1_KubernetesSettings(in, out, s)
}

func autoConvert_v1alpha1_LastError_To_core_LastError(in *LastError, out *core.LastError, s conversion.Scope) error {
	out.Description = in.Description
	out.TaskID = (*string)(unsafe.Pointer(in.TaskID))
	out.Codes = *(*[]core.ErrorCode)(unsafe.Pointer(&in.Codes))
	out.LastUpdateTime = (*metav1.Time)(unsafe.Pointer(in.LastUpdateTime))
	return nil
}

// Convert_v1alpha1_LastError_To_core_LastError is an autogenerated conversion function.
func Convert_v1alpha1_LastError_To_core_LastError(in *LastError, out *core.LastError, s conversion.Scope) error {
	return autoConvert_v1alpha1_LastError_To_core_LastError(in, out, s)
}

func autoConvert_core_LastError_To_v1alpha1_LastError(in *core.LastError, out *LastError, s conversion.Scope) error {
	out.Description = in.Description
	out.TaskID = (*string)(unsafe.Pointer(in.TaskID))
	out.Codes = *(*[]ErrorCode)(unsafe.Pointer(&in.Codes))
	out.LastUpdateTime = (*metav1.Time)(unsafe.Pointer(in.LastUpdateTime))
	return nil
}

// Convert_core_LastError_To_v1alpha1_LastError is an autogenerated conversion function.
func Convert_core_LastError_To_v1alpha1_LastError(in *core.LastError, out *LastError, s conversion.Scope) error {
	return autoConvert_core_LastError_To_v1alpha1_LastError(in, out, s)
}

func autoConvert_v1alpha1_LastOperation_To_core_LastOperation(in *LastOperation, out *core.LastOperation, s conversion.Scope) error {
	out.Description = in.Description
	out.LastUpdateTime = in.LastUpdateTime
	out.Progress = in.Progress
	out.State = core.LastOperationState(in.State)
	out.Type = core.LastOperationType(in.Type)
	return nil
}

// Convert_v1alpha1_LastOperation_To_core_LastOperation is an autogenerated conversion function.
func Convert_v1alpha1_LastOperation_To_core_LastOperation(in *LastOperation, out *core.LastOperation, s conversion.Scope) error {
	return autoConvert_v1alpha1_LastOperation_To_core_LastOperation(in, out, s)
}

func autoConvert_core_LastOperation_To_v1alpha1_LastOperation(in *core.LastOperation, out *LastOperation, s conversion.Scope) error {
	out.Description = in.Description
	out.LastUpdateTime = in.LastUpdateTime
	out.Progress = in.Progress
	out.State = LastOperationState(in.State)
	out.Type = LastOperationType(in.Type)
	return nil
}

// Convert_core_LastOperation_To_v1alpha1_LastOperation is an autogenerated conversion function.
func Convert_core_LastOperation_To_v1alpha1_LastOperation(in *core.LastOperation, out *LastOperation, s conversion.Scope) error {
	return autoConvert_core_LastOperation_To_v1alpha1_LastOperation(in, out, s)
}

func autoConvert_v1alpha1_Machine_To_core_Machine(in *Machine, out *core.Machine, s conversion.Scope) error {
	out.Type = in.Type
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(core.ShootMachineImage)
		if err := Convert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

// Convert_v1alpha1_Machine_To_core_Machine is an autogenerated conversion function.
func Convert_v1alpha1_Machine_To_core_Machine(in *Machine, out *core.Machine, s conversion.Scope) error {
	return autoConvert_v1alpha1_Machine_To_core_Machine(in, out, s)
}

func autoConvert_core_Machine_To_v1alpha1_Machine(in *core.Machine, out *Machine, s conversion.Scope) error {
	out.Type = in.Type
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(ShootMachineImage)
		if err := Convert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

// Convert_core_Machine_To_v1alpha1_Machine is an autogenerated conversion function.
func Convert_core_Machine_To_v1alpha1_Machine(in *core.Machine, out *Machine, s conversion.Scope) error {
	return autoConvert_core_Machine_To_v1alpha1_Machine(in, out, s)
}

func autoConvert_v1alpha1_MachineControllerManagerSettings_To_core_MachineControllerManagerSettings(in *MachineControllerManagerSettings, out *core.MachineControllerManagerSettings, s conversion.Scope) error {
	out.MachineDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineDrainTimeout))
	out.MachineHealthTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineHealthTimeout))
	out.MachineCreationTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineCreationTimeout))
	out.MaxEvictRetries = (*int32)(unsafe.Pointer(in.MaxEvictRetries))
	out.NodeConditions = *(*[]string)(unsafe.Pointer(&in.NodeConditions))
	return nil
}

// Convert_v1alpha1_MachineControllerManagerSettings_To_core_MachineControllerManagerSettings is an autogenerated conversion function.
func Convert_v1alpha1_MachineControllerManagerSettings_To_core_MachineControllerManagerSettings(in *MachineControllerManagerSettings, out *core.MachineControllerManagerSettings, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineControllerManagerSettings_To_core_MachineControllerManagerSettings(in, out, s)
}

func autoConvert_core_MachineControllerManagerSettings_To_v1alpha1_MachineControllerManagerSettings(in *core.MachineControllerManagerSettings, out *MachineControllerManagerSettings, s conversion.Scope) error {
	out.MachineDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineDrainTimeout))
	out.MachineHealthTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineHealthTimeout))
	out.MachineCreationTimeout = (*metav1.Duration)(unsafe.Pointer(in.MachineCreationTimeout))
	out.MaxEvictRetries = (*int32)(unsafe.Pointer(in.MaxEvictRetries))
	out.NodeConditions = *(*[]string)(unsafe.Pointer(&in.NodeConditions))
	return nil
}

// Convert_core_MachineControllerManagerSettings_To_v1alpha1_MachineControllerManagerSettings is an autogenerated conversion function.
func Convert_core_MachineControllerManagerSettings_To_v1alpha1_MachineControllerManagerSettings(in *core.MachineControllerManagerSettings, out *MachineControllerManagerSettings, s conversion.Scope) error {
	return autoConvert_core_MachineControllerManagerSettings_To_v1alpha1_MachineControllerManagerSettings(in, out, s)
}

func autoConvert_v1alpha1_MachineImage_To_core_MachineImage(in *MachineImage, out *core.MachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.Versions = *(*[]core.MachineImageVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_v1alpha1_MachineImage_To_core_MachineImage is an autogenerated conversion function.
func Convert_v1alpha1_MachineImage_To_core_MachineImage(in *MachineImage, out *core.MachineImage, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineImage_To_core_MachineImage(in, out, s)
}

func autoConvert_core_MachineImage_To_v1alpha1_MachineImage(in *core.MachineImage, out *MachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.Versions = *(*[]MachineImageVersion)(unsafe.Pointer(&in.Versions))
	return nil
}

// Convert_core_MachineImage_To_v1alpha1_MachineImage is an autogenerated conversion function.
func Convert_core_MachineImage_To_v1alpha1_MachineImage(in *core.MachineImage, out *MachineImage, s conversion.Scope) error {
	return autoConvert_core_MachineImage_To_v1alpha1_MachineImage(in, out, s)
}

func autoConvert_v1alpha1_MachineImageVersion_To_core_MachineImageVersion(in *MachineImageVersion, out *core.MachineImageVersion, s conversion.Scope) error {
	if err := Convert_v1alpha1_ExpirableVersion_To_core_ExpirableVersion(&in.ExpirableVersion, &out.ExpirableVersion, s); err != nil {
		return err
	}
	out.CRI = *(*[]core.CRI)(unsafe.Pointer(&in.CRI))
	return nil
}

// Convert_v1alpha1_MachineImageVersion_To_core_MachineImageVersion is an autogenerated conversion function.
func Convert_v1alpha1_MachineImageVersion_To_core_MachineImageVersion(in *MachineImageVersion, out *core.MachineImageVersion, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineImageVersion_To_core_MachineImageVersion(in, out, s)
}

func autoConvert_core_MachineImageVersion_To_v1alpha1_MachineImageVersion(in *core.MachineImageVersion, out *MachineImageVersion, s conversion.Scope) error {
	if err := Convert_core_ExpirableVersion_To_v1alpha1_ExpirableVersion(&in.ExpirableVersion, &out.ExpirableVersion, s); err != nil {
		return err
	}
	out.CRI = *(*[]CRI)(unsafe.Pointer(&in.CRI))
	return nil
}

// Convert_core_MachineImageVersion_To_v1alpha1_MachineImageVersion is an autogenerated conversion function.
func Convert_core_MachineImageVersion_To_v1alpha1_MachineImageVersion(in *core.MachineImageVersion, out *MachineImageVersion, s conversion.Scope) error {
	return autoConvert_core_MachineImageVersion_To_v1alpha1_MachineImageVersion(in, out, s)
}

func autoConvert_v1alpha1_MachineType_To_core_MachineType(in *MachineType, out *core.MachineType, s conversion.Scope) error {
	out.CPU = in.CPU
	out.GPU = in.GPU
	out.Memory = in.Memory
	out.Name = in.Name
	out.Storage = (*core.MachineTypeStorage)(unsafe.Pointer(in.Storage))
	out.Usable = (*bool)(unsafe.Pointer(in.Usable))
	return nil
}

// Convert_v1alpha1_MachineType_To_core_MachineType is an autogenerated conversion function.
func Convert_v1alpha1_MachineType_To_core_MachineType(in *MachineType, out *core.MachineType, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineType_To_core_MachineType(in, out, s)
}

func autoConvert_core_MachineType_To_v1alpha1_MachineType(in *core.MachineType, out *MachineType, s conversion.Scope) error {
	out.CPU = in.CPU
	out.GPU = in.GPU
	out.Memory = in.Memory
	out.Name = in.Name
	out.Storage = (*MachineTypeStorage)(unsafe.Pointer(in.Storage))
	out.Usable = (*bool)(unsafe.Pointer(in.Usable))
	return nil
}

// Convert_core_MachineType_To_v1alpha1_MachineType is an autogenerated conversion function.
func Convert_core_MachineType_To_v1alpha1_MachineType(in *core.MachineType, out *MachineType, s conversion.Scope) error {
	return autoConvert_core_MachineType_To_v1alpha1_MachineType(in, out, s)
}

func autoConvert_v1alpha1_MachineTypeStorage_To_core_MachineTypeStorage(in *MachineTypeStorage, out *core.MachineTypeStorage, s conversion.Scope) error {
	out.Class = in.Class
	out.StorageSize = in.StorageSize
	out.Type = in.Type
	return nil
}

// Convert_v1alpha1_MachineTypeStorage_To_core_MachineTypeStorage is an autogenerated conversion function.
func Convert_v1alpha1_MachineTypeStorage_To_core_MachineTypeStorage(in *MachineTypeStorage, out *core.MachineTypeStorage, s conversion.Scope) error {
	return autoConvert_v1alpha1_MachineTypeStorage_To_core_MachineTypeStorage(in, out, s)
}

func autoConvert_core_MachineTypeStorage_To_v1alpha1_MachineTypeStorage(in *core.MachineTypeStorage, out *MachineTypeStorage, s conversion.Scope) error {
	out.Class = in.Class
	out.StorageSize = in.StorageSize
	out.Type = in.Type
	return nil
}

// Convert_core_MachineTypeStorage_To_v1alpha1_MachineTypeStorage is an autogenerated conversion function.
func Convert_core_MachineTypeStorage_To_v1alpha1_MachineTypeStorage(in *core.MachineTypeStorage, out *MachineTypeStorage, s conversion.Scope) error {
	return autoConvert_core_MachineTypeStorage_To_v1alpha1_MachineTypeStorage(in, out, s)
}

func autoConvert_v1alpha1_Maintenance_To_core_Maintenance(in *Maintenance, out *core.Maintenance, s conversion.Scope) error {
	out.AutoUpdate = (*core.MaintenanceAutoUpdate)(unsafe.Pointer(in.AutoUpdate))
	out.TimeWindow = (*core.MaintenanceTimeWindow)(unsafe.Pointer(in.TimeWindow))
	out.ConfineSpecUpdateRollout = (*bool)(unsafe.Pointer(in.ConfineSpecUpdateRollout))
	return nil
}

// Convert_v1alpha1_Maintenance_To_core_Maintenance is an autogenerated conversion function.
func Convert_v1alpha1_Maintenance_To_core_Maintenance(in *Maintenance, out *core.Maintenance, s conversion.Scope) error {
	return autoConvert_v1alpha1_Maintenance_To_core_Maintenance(in, out, s)
}

func autoConvert_core_Maintenance_To_v1alpha1_Maintenance(in *core.Maintenance, out *Maintenance, s conversion.Scope) error {
	out.AutoUpdate = (*MaintenanceAutoUpdate)(unsafe.Pointer(in.AutoUpdate))
	out.TimeWindow = (*MaintenanceTimeWindow)(unsafe.Pointer(in.TimeWindow))
	out.ConfineSpecUpdateRollout = (*bool)(unsafe.Pointer(in.ConfineSpecUpdateRollout))
	return nil
}

// Convert_core_Maintenance_To_v1alpha1_Maintenance is an autogenerated conversion function.
func Convert_core_Maintenance_To_v1alpha1_Maintenance(in *core.Maintenance, out *Maintenance, s conversion.Scope) error {
	return autoConvert_core_Maintenance_To_v1alpha1_Maintenance(in, out, s)
}

func autoConvert_v1alpha1_MaintenanceAutoUpdate_To_core_MaintenanceAutoUpdate(in *MaintenanceAutoUpdate, out *core.MaintenanceAutoUpdate, s conversion.Scope) error {
	out.KubernetesVersion = in.KubernetesVersion
	out.MachineImageVersion = in.MachineImageVersion
	return nil
}

// Convert_v1alpha1_MaintenanceAutoUpdate_To_core_MaintenanceAutoUpdate is an autogenerated conversion function.
func Convert_v1alpha1_MaintenanceAutoUpdate_To_core_MaintenanceAutoUpdate(in *MaintenanceAutoUpdate, out *core.MaintenanceAutoUpdate, s conversion.Scope) error {
	return autoConvert_v1alpha1_MaintenanceAutoUpdate_To_core_MaintenanceAutoUpdate(in, out, s)
}

func autoConvert_core_MaintenanceAutoUpdate_To_v1alpha1_MaintenanceAutoUpdate(in *core.MaintenanceAutoUpdate, out *MaintenanceAutoUpdate, s conversion.Scope) error {
	out.KubernetesVersion = in.KubernetesVersion
	out.MachineImageVersion = in.MachineImageVersion
	return nil
}

// Convert_core_MaintenanceAutoUpdate_To_v1alpha1_MaintenanceAutoUpdate is an autogenerated conversion function.
func Convert_core_MaintenanceAutoUpdate_To_v1alpha1_MaintenanceAutoUpdate(in *core.MaintenanceAutoUpdate, out *MaintenanceAutoUpdate, s conversion.Scope) error {
	return autoConvert_core_MaintenanceAutoUpdate_To_v1alpha1_MaintenanceAutoUpdate(in, out, s)
}

func autoConvert_v1alpha1_MaintenanceTimeWindow_To_core_MaintenanceTimeWindow(in *MaintenanceTimeWindow, out *core.MaintenanceTimeWindow, s conversion.Scope) error {
	out.Begin = in.Begin
	out.End = in.End
	return nil
}

// Convert_v1alpha1_MaintenanceTimeWindow_To_core_MaintenanceTimeWindow is an autogenerated conversion function.
func Convert_v1alpha1_MaintenanceTimeWindow_To_core_MaintenanceTimeWindow(in *MaintenanceTimeWindow, out *core.MaintenanceTimeWindow, s conversion.Scope) error {
	return autoConvert_v1alpha1_MaintenanceTimeWindow_To_core_MaintenanceTimeWindow(in, out, s)
}

func autoConvert_core_MaintenanceTimeWindow_To_v1alpha1_MaintenanceTimeWindow(in *core.MaintenanceTimeWindow, out *MaintenanceTimeWindow, s conversion.Scope) error {
	out.Begin = in.Begin
	out.End = in.End
	return nil
}

// Convert_core_MaintenanceTimeWindow_To_v1alpha1_MaintenanceTimeWindow is an autogenerated conversion function.
func Convert_core_MaintenanceTimeWindow_To_v1alpha1_MaintenanceTimeWindow(in *core.MaintenanceTimeWindow, out *MaintenanceTimeWindow, s conversion.Scope) error {
	return autoConvert_core_MaintenanceTimeWindow_To_v1alpha1_MaintenanceTimeWindow(in, out, s)
}

func autoConvert_v1alpha1_Monitoring_To_core_Monitoring(in *Monitoring, out *core.Monitoring, s conversion.Scope) error {
	out.Alerting = (*core.Alerting)(unsafe.Pointer(in.Alerting))
	return nil
}

// Convert_v1alpha1_Monitoring_To_core_Monitoring is an autogenerated conversion function.
func Convert_v1alpha1_Monitoring_To_core_Monitoring(in *Monitoring, out *core.Monitoring, s conversion.Scope) error {
	return autoConvert_v1alpha1_Monitoring_To_core_Monitoring(in, out, s)
}

func autoConvert_core_Monitoring_To_v1alpha1_Monitoring(in *core.Monitoring, out *Monitoring, s conversion.Scope) error {
	out.Alerting = (*Alerting)(unsafe.Pointer(in.Alerting))
	return nil
}

// Convert_core_Monitoring_To_v1alpha1_Monitoring is an autogenerated conversion function.
func Convert_core_Monitoring_To_v1alpha1_Monitoring(in *core.Monitoring, out *Monitoring, s conversion.Scope) error {
	return autoConvert_core_Monitoring_To_v1alpha1_Monitoring(in, out, s)
}

func autoConvert_v1alpha1_NamedResourceReference_To_core_NamedResourceReference(in *NamedResourceReference, out *core.NamedResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.ResourceRef = in.ResourceRef
	return nil
}

// Convert_v1alpha1_NamedResourceReference_To_core_NamedResourceReference is an autogenerated conversion function.
func Convert_v1alpha1_NamedResourceReference_To_core_NamedResourceReference(in *NamedResourceReference, out *core.NamedResourceReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_NamedResourceReference_To_core_NamedResourceReference(in, out, s)
}

func autoConvert_core_NamedResourceReference_To_v1alpha1_NamedResourceReference(in *core.NamedResourceReference, out *NamedResourceReference, s conversion.Scope) error {
	out.Name = in.Name
	out.ResourceRef = in.ResourceRef
	return nil
}

// Convert_core_NamedResourceReference_To_v1alpha1_NamedResourceReference is an autogenerated conversion function.
func Convert_core_NamedResourceReference_To_v1alpha1_NamedResourceReference(in *core.NamedResourceReference, out *NamedResourceReference, s conversion.Scope) error {
	return autoConvert_core_NamedResourceReference_To_v1alpha1_NamedResourceReference(in, out, s)
}

func autoConvert_v1alpha1_Networking_To_core_Networking(in *Networking, out *core.Networking, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Pods = (*string)(unsafe.Pointer(in.Pods))
	out.Nodes = (*string)(unsafe.Pointer(in.Nodes))
	out.Services = (*string)(unsafe.Pointer(in.Services))
	return nil
}

// Convert_v1alpha1_Networking_To_core_Networking is an autogenerated conversion function.
func Convert_v1alpha1_Networking_To_core_Networking(in *Networking, out *core.Networking, s conversion.Scope) error {
	return autoConvert_v1alpha1_Networking_To_core_Networking(in, out, s)
}

func autoConvert_core_Networking_To_v1alpha1_Networking(in *core.Networking, out *Networking, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Pods = (*string)(unsafe.Pointer(in.Pods))
	out.Nodes = (*string)(unsafe.Pointer(in.Nodes))
	out.Services = (*string)(unsafe.Pointer(in.Services))
	return nil
}

// Convert_core_Networking_To_v1alpha1_Networking is an autogenerated conversion function.
func Convert_core_Networking_To_v1alpha1_Networking(in *core.Networking, out *Networking, s conversion.Scope) error {
	return autoConvert_core_Networking_To_v1alpha1_Networking(in, out, s)
}

func autoConvert_v1alpha1_NginxIngress_To_core_NginxIngress(in *NginxIngress, out *core.NginxIngress, s conversion.Scope) error {
	if err := Convert_v1alpha1_Addon_To_core_Addon(&in.Addon, &out.Addon, s); err != nil {
		return err
	}
	out.LoadBalancerSourceRanges = *(*[]string)(unsafe.Pointer(&in.LoadBalancerSourceRanges))
	out.Config = *(*map[string]string)(unsafe.Pointer(&in.Config))
	out.ExternalTrafficPolicy = (*v1.ServiceExternalTrafficPolicyType)(unsafe.Pointer(in.ExternalTrafficPolicy))
	return nil
}

// Convert_v1alpha1_NginxIngress_To_core_NginxIngress is an autogenerated conversion function.
func Convert_v1alpha1_NginxIngress_To_core_NginxIngress(in *NginxIngress, out *core.NginxIngress, s conversion.Scope) error {
	return autoConvert_v1alpha1_NginxIngress_To_core_NginxIngress(in, out, s)
}

func autoConvert_core_NginxIngress_To_v1alpha1_NginxIngress(in *core.NginxIngress, out *NginxIngress, s conversion.Scope) error {
	if err := Convert_core_Addon_To_v1alpha1_Addon(&in.Addon, &out.Addon, s); err != nil {
		return err
	}
	out.LoadBalancerSourceRanges = *(*[]string)(unsafe.Pointer(&in.LoadBalancerSourceRanges))
	out.Config = *(*map[string]string)(unsafe.Pointer(&in.Config))
	out.ExternalTrafficPolicy = (*v1.ServiceExternalTrafficPolicyType)(unsafe.Pointer(in.ExternalTrafficPolicy))
	return nil
}

// Convert_core_NginxIngress_To_v1alpha1_NginxIngress is an autogenerated conversion function.
func Convert_core_NginxIngress_To_v1alpha1_NginxIngress(in *core.NginxIngress, out *NginxIngress, s conversion.Scope) error {
	return autoConvert_core_NginxIngress_To_v1alpha1_NginxIngress(in, out, s)
}

func autoConvert_v1alpha1_OIDCConfig_To_core_OIDCConfig(in *OIDCConfig, out *core.OIDCConfig, s conversion.Scope) error {
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	out.ClientAuthentication = (*core.OpenIDConnectClientAuthentication)(unsafe.Pointer(in.ClientAuthentication))
	out.ClientID = (*string)(unsafe.Pointer(in.ClientID))
	out.GroupsClaim = (*string)(unsafe.Pointer(in.GroupsClaim))
	out.GroupsPrefix = (*string)(unsafe.Pointer(in.GroupsPrefix))
	out.IssuerURL = (*string)(unsafe.Pointer(in.IssuerURL))
	out.RequiredClaims = *(*map[string]string)(unsafe.Pointer(&in.RequiredClaims))
	out.SigningAlgs = *(*[]string)(unsafe.Pointer(&in.SigningAlgs))
	out.UsernameClaim = (*string)(unsafe.Pointer(in.UsernameClaim))
	out.UsernamePrefix = (*string)(unsafe.Pointer(in.UsernamePrefix))
	return nil
}

// Convert_v1alpha1_OIDCConfig_To_core_OIDCConfig is an autogenerated conversion function.
func Convert_v1alpha1_OIDCConfig_To_core_OIDCConfig(in *OIDCConfig, out *core.OIDCConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_OIDCConfig_To_core_OIDCConfig(in, out, s)
}

func autoConvert_core_OIDCConfig_To_v1alpha1_OIDCConfig(in *core.OIDCConfig, out *OIDCConfig, s conversion.Scope) error {
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	out.ClientAuthentication = (*OpenIDConnectClientAuthentication)(unsafe.Pointer(in.ClientAuthentication))
	out.ClientID = (*string)(unsafe.Pointer(in.ClientID))
	out.GroupsClaim = (*string)(unsafe.Pointer(in.GroupsClaim))
	out.GroupsPrefix = (*string)(unsafe.Pointer(in.GroupsPrefix))
	out.IssuerURL = (*string)(unsafe.Pointer(in.IssuerURL))
	out.RequiredClaims = *(*map[string]string)(unsafe.Pointer(&in.RequiredClaims))
	out.SigningAlgs = *(*[]string)(unsafe.Pointer(&in.SigningAlgs))
	out.UsernameClaim = (*string)(unsafe.Pointer(in.UsernameClaim))
	out.UsernamePrefix = (*string)(unsafe.Pointer(in.UsernamePrefix))
	return nil
}

// Convert_core_OIDCConfig_To_v1alpha1_OIDCConfig is an autogenerated conversion function.
func Convert_core_OIDCConfig_To_v1alpha1_OIDCConfig(in *core.OIDCConfig, out *OIDCConfig, s conversion.Scope) error {
	return autoConvert_core_OIDCConfig_To_v1alpha1_OIDCConfig(in, out, s)
}

func autoConvert_v1alpha1_OpenIDConnectClientAuthentication_To_core_OpenIDConnectClientAuthentication(in *OpenIDConnectClientAuthentication, out *core.OpenIDConnectClientAuthentication, s conversion.Scope) error {
	out.ExtraConfig = *(*map[string]string)(unsafe.Pointer(&in.ExtraConfig))
	out.Secret = (*string)(unsafe.Pointer(in.Secret))
	return nil
}

// Convert_v1alpha1_OpenIDConnectClientAuthentication_To_core_OpenIDConnectClientAuthentication is an autogenerated conversion function.
func Convert_v1alpha1_OpenIDConnectClientAuthentication_To_core_OpenIDConnectClientAuthentication(in *OpenIDConnectClientAuthentication, out *core.OpenIDConnectClientAuthentication, s conversion.Scope) error {
	return autoConvert_v1alpha1_OpenIDConnectClientAuthentication_To_core_OpenIDConnectClientAuthentication(in, out, s)
}

func autoConvert_core_OpenIDConnectClientAuthentication_To_v1alpha1_OpenIDConnectClientAuthentication(in *core.OpenIDConnectClientAuthentication, out *OpenIDConnectClientAuthentication, s conversion.Scope) error {
	out.ExtraConfig = *(*map[string]string)(unsafe.Pointer(&in.ExtraConfig))
	out.Secret = (*string)(unsafe.Pointer(in.Secret))
	return nil
}

// Convert_core_OpenIDConnectClientAuthentication_To_v1alpha1_OpenIDConnectClientAuthentication is an autogenerated conversion function.
func Convert_core_OpenIDConnectClientAuthentication_To_v1alpha1_OpenIDConnectClientAuthentication(in *core.OpenIDConnectClientAuthentication, out *OpenIDConnectClientAuthentication, s conversion.Scope) error {
	return autoConvert_core_OpenIDConnectClientAuthentication_To_v1alpha1_OpenIDConnectClientAuthentication(in, out, s)
}

func autoConvert_v1alpha1_Plant_To_core_Plant(in *Plant, out *core.Plant, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_PlantSpec_To_core_PlantSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_PlantStatus_To_core_PlantStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Plant_To_core_Plant is an autogenerated conversion function.
func Convert_v1alpha1_Plant_To_core_Plant(in *Plant, out *core.Plant, s conversion.Scope) error {
	return autoConvert_v1alpha1_Plant_To_core_Plant(in, out, s)
}

func autoConvert_core_Plant_To_v1alpha1_Plant(in *core.Plant, out *Plant, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_PlantSpec_To_v1alpha1_PlantSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_PlantStatus_To_v1alpha1_PlantStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_Plant_To_v1alpha1_Plant is an autogenerated conversion function.
func Convert_core_Plant_To_v1alpha1_Plant(in *core.Plant, out *Plant, s conversion.Scope) error {
	return autoConvert_core_Plant_To_v1alpha1_Plant(in, out, s)
}

func autoConvert_v1alpha1_PlantList_To_core_PlantList(in *PlantList, out *core.PlantList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.Plant)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_PlantList_To_core_PlantList is an autogenerated conversion function.
func Convert_v1alpha1_PlantList_To_core_PlantList(in *PlantList, out *core.PlantList, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlantList_To_core_PlantList(in, out, s)
}

func autoConvert_core_PlantList_To_v1alpha1_PlantList(in *core.PlantList, out *PlantList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]Plant)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_PlantList_To_v1alpha1_PlantList is an autogenerated conversion function.
func Convert_core_PlantList_To_v1alpha1_PlantList(in *core.PlantList, out *PlantList, s conversion.Scope) error {
	return autoConvert_core_PlantList_To_v1alpha1_PlantList(in, out, s)
}

func autoConvert_v1alpha1_PlantSpec_To_core_PlantSpec(in *PlantSpec, out *core.PlantSpec, s conversion.Scope) error {
	out.SecretRef = in.SecretRef
	out.Endpoints = *(*[]core.Endpoint)(unsafe.Pointer(&in.Endpoints))
	return nil
}

// Convert_v1alpha1_PlantSpec_To_core_PlantSpec is an autogenerated conversion function.
func Convert_v1alpha1_PlantSpec_To_core_PlantSpec(in *PlantSpec, out *core.PlantSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlantSpec_To_core_PlantSpec(in, out, s)
}

func autoConvert_core_PlantSpec_To_v1alpha1_PlantSpec(in *core.PlantSpec, out *PlantSpec, s conversion.Scope) error {
	out.SecretRef = in.SecretRef
	out.Endpoints = *(*[]Endpoint)(unsafe.Pointer(&in.Endpoints))
	return nil
}

// Convert_core_PlantSpec_To_v1alpha1_PlantSpec is an autogenerated conversion function.
func Convert_core_PlantSpec_To_v1alpha1_PlantSpec(in *core.PlantSpec, out *PlantSpec, s conversion.Scope) error {
	return autoConvert_core_PlantSpec_To_v1alpha1_PlantSpec(in, out, s)
}

func autoConvert_v1alpha1_PlantStatus_To_core_PlantStatus(in *PlantStatus, out *core.PlantStatus, s conversion.Scope) error {
	out.Conditions = *(*[]core.Condition)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = (*int64)(unsafe.Pointer(in.ObservedGeneration))
	out.ClusterInfo = (*core.ClusterInfo)(unsafe.Pointer(in.ClusterInfo))
	return nil
}

// Convert_v1alpha1_PlantStatus_To_core_PlantStatus is an autogenerated conversion function.
func Convert_v1alpha1_PlantStatus_To_core_PlantStatus(in *PlantStatus, out *core.PlantStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlantStatus_To_core_PlantStatus(in, out, s)
}

func autoConvert_core_PlantStatus_To_v1alpha1_PlantStatus(in *core.PlantStatus, out *PlantStatus, s conversion.Scope) error {
	out.Conditions = *(*[]Condition)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = (*int64)(unsafe.Pointer(in.ObservedGeneration))
	out.ClusterInfo = (*ClusterInfo)(unsafe.Pointer(in.ClusterInfo))
	return nil
}

// Convert_core_PlantStatus_To_v1alpha1_PlantStatus is an autogenerated conversion function.
func Convert_core_PlantStatus_To_v1alpha1_PlantStatus(in *core.PlantStatus, out *PlantStatus, s conversion.Scope) error {
	return autoConvert_core_PlantStatus_To_v1alpha1_PlantStatus(in, out, s)
}

func autoConvert_v1alpha1_Project_To_core_Project(in *Project, out *core.Project, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ProjectSpec_To_core_ProjectSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ProjectStatus_To_core_ProjectStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Project_To_core_Project is an autogenerated conversion function.
func Convert_v1alpha1_Project_To_core_Project(in *Project, out *core.Project, s conversion.Scope) error {
	return autoConvert_v1alpha1_Project_To_core_Project(in, out, s)
}

func autoConvert_core_Project_To_v1alpha1_Project(in *core.Project, out *Project, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_ProjectSpec_To_v1alpha1_ProjectSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_ProjectStatus_To_v1alpha1_ProjectStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_Project_To_v1alpha1_Project is an autogenerated conversion function.
func Convert_core_Project_To_v1alpha1_Project(in *core.Project, out *Project, s conversion.Scope) error {
	return autoConvert_core_Project_To_v1alpha1_Project(in, out, s)
}

func autoConvert_v1alpha1_ProjectList_To_core_ProjectList(in *ProjectList, out *core.ProjectList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]core.Project, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_Project_To_core_Project(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_ProjectList_To_core_ProjectList is an autogenerated conversion function.
func Convert_v1alpha1_ProjectList_To_core_ProjectList(in *ProjectList, out *core.ProjectList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ProjectList_To_core_ProjectList(in, out, s)
}

func autoConvert_core_ProjectList_To_v1alpha1_ProjectList(in *core.ProjectList, out *ProjectList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Project, len(*in))
		for i := range *in {
			if err := Convert_core_Project_To_v1alpha1_Project(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_core_ProjectList_To_v1alpha1_ProjectList is an autogenerated conversion function.
func Convert_core_ProjectList_To_v1alpha1_ProjectList(in *core.ProjectList, out *ProjectList, s conversion.Scope) error {
	return autoConvert_core_ProjectList_To_v1alpha1_ProjectList(in, out, s)
}

func autoConvert_v1alpha1_ProjectMember_To_core_ProjectMember(in *ProjectMember, out *core.ProjectMember, s conversion.Scope) error {
	out.Subject = in.Subject
	// WARNING: in.Role requires manual conversion: does not exist in peer-type
	out.Roles = *(*[]string)(unsafe.Pointer(&in.Roles))
	return nil
}

func autoConvert_core_ProjectMember_To_v1alpha1_ProjectMember(in *core.ProjectMember, out *ProjectMember, s conversion.Scope) error {
	out.Subject = in.Subject
	out.Roles = *(*[]string)(unsafe.Pointer(&in.Roles))
	return nil
}

func autoConvert_v1alpha1_ProjectSpec_To_core_ProjectSpec(in *ProjectSpec, out *core.ProjectSpec, s conversion.Scope) error {
	out.CreatedBy = (*rbacv1.Subject)(unsafe.Pointer(in.CreatedBy))
	out.Description = (*string)(unsafe.Pointer(in.Description))
	out.Owner = (*rbacv1.Subject)(unsafe.Pointer(in.Owner))
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]core.ProjectMember, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_ProjectMember_To_core_ProjectMember(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Members = nil
	}
	out.Namespace = (*string)(unsafe.Pointer(in.Namespace))
	out.Tolerations = (*core.ProjectTolerations)(unsafe.Pointer(in.Tolerations))
	return nil
}

func autoConvert_core_ProjectSpec_To_v1alpha1_ProjectSpec(in *core.ProjectSpec, out *ProjectSpec, s conversion.Scope) error {
	out.CreatedBy = (*rbacv1.Subject)(unsafe.Pointer(in.CreatedBy))
	out.Description = (*string)(unsafe.Pointer(in.Description))
	out.Owner = (*rbacv1.Subject)(unsafe.Pointer(in.Owner))
	out.Purpose = (*string)(unsafe.Pointer(in.Purpose))
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]ProjectMember, len(*in))
		for i := range *in {
			if err := Convert_core_ProjectMember_To_v1alpha1_ProjectMember(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Members = nil
	}
	out.Namespace = (*string)(unsafe.Pointer(in.Namespace))
	out.Tolerations = (*ProjectTolerations)(unsafe.Pointer(in.Tolerations))
	return nil
}

func autoConvert_v1alpha1_ProjectStatus_To_core_ProjectStatus(in *ProjectStatus, out *core.ProjectStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Phase = core.ProjectPhase(in.Phase)
	out.StaleSinceTimestamp = (*metav1.Time)(unsafe.Pointer(in.StaleSinceTimestamp))
	out.StaleAutoDeleteTimestamp = (*metav1.Time)(unsafe.Pointer(in.StaleAutoDeleteTimestamp))
	return nil
}

// Convert_v1alpha1_ProjectStatus_To_core_ProjectStatus is an autogenerated conversion function.
func Convert_v1alpha1_ProjectStatus_To_core_ProjectStatus(in *ProjectStatus, out *core.ProjectStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ProjectStatus_To_core_ProjectStatus(in, out, s)
}

func autoConvert_core_ProjectStatus_To_v1alpha1_ProjectStatus(in *core.ProjectStatus, out *ProjectStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Phase = ProjectPhase(in.Phase)
	out.StaleSinceTimestamp = (*metav1.Time)(unsafe.Pointer(in.StaleSinceTimestamp))
	out.StaleAutoDeleteTimestamp = (*metav1.Time)(unsafe.Pointer(in.StaleAutoDeleteTimestamp))
	return nil
}

// Convert_core_ProjectStatus_To_v1alpha1_ProjectStatus is an autogenerated conversion function.
func Convert_core_ProjectStatus_To_v1alpha1_ProjectStatus(in *core.ProjectStatus, out *ProjectStatus, s conversion.Scope) error {
	return autoConvert_core_ProjectStatus_To_v1alpha1_ProjectStatus(in, out, s)
}

func autoConvert_v1alpha1_ProjectTolerations_To_core_ProjectTolerations(in *ProjectTolerations, out *core.ProjectTolerations, s conversion.Scope) error {
	out.Defaults = *(*[]core.Toleration)(unsafe.Pointer(&in.Defaults))
	out.Whitelist = *(*[]core.Toleration)(unsafe.Pointer(&in.Whitelist))
	return nil
}

// Convert_v1alpha1_ProjectTolerations_To_core_ProjectTolerations is an autogenerated conversion function.
func Convert_v1alpha1_ProjectTolerations_To_core_ProjectTolerations(in *ProjectTolerations, out *core.ProjectTolerations, s conversion.Scope) error {
	return autoConvert_v1alpha1_ProjectTolerations_To_core_ProjectTolerations(in, out, s)
}

func autoConvert_core_ProjectTolerations_To_v1alpha1_ProjectTolerations(in *core.ProjectTolerations, out *ProjectTolerations, s conversion.Scope) error {
	out.Defaults = *(*[]Toleration)(unsafe.Pointer(&in.Defaults))
	out.Whitelist = *(*[]Toleration)(unsafe.Pointer(&in.Whitelist))
	return nil
}

// Convert_core_ProjectTolerations_To_v1alpha1_ProjectTolerations is an autogenerated conversion function.
func Convert_core_ProjectTolerations_To_v1alpha1_ProjectTolerations(in *core.ProjectTolerations, out *ProjectTolerations, s conversion.Scope) error {
	return autoConvert_core_ProjectTolerations_To_v1alpha1_ProjectTolerations(in, out, s)
}

func autoConvert_v1alpha1_Provider_To_core_Provider(in *Provider, out *core.Provider, s conversion.Scope) error {
	out.Type = in.Type
	out.ControlPlaneConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ControlPlaneConfig))
	out.InfrastructureConfig = (*runtime.RawExtension)(unsafe.Pointer(in.InfrastructureConfig))
	if in.Workers != nil {
		in, out := &in.Workers, &out.Workers
		*out = make([]core.Worker, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_Worker_To_core_Worker(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Workers = nil
	}
	return nil
}

// Convert_v1alpha1_Provider_To_core_Provider is an autogenerated conversion function.
func Convert_v1alpha1_Provider_To_core_Provider(in *Provider, out *core.Provider, s conversion.Scope) error {
	return autoConvert_v1alpha1_Provider_To_core_Provider(in, out, s)
}

func autoConvert_core_Provider_To_v1alpha1_Provider(in *core.Provider, out *Provider, s conversion.Scope) error {
	out.Type = in.Type
	out.ControlPlaneConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ControlPlaneConfig))
	out.InfrastructureConfig = (*runtime.RawExtension)(unsafe.Pointer(in.InfrastructureConfig))
	if in.Workers != nil {
		in, out := &in.Workers, &out.Workers
		*out = make([]Worker, len(*in))
		for i := range *in {
			if err := Convert_core_Worker_To_v1alpha1_Worker(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Workers = nil
	}
	return nil
}

// Convert_core_Provider_To_v1alpha1_Provider is an autogenerated conversion function.
func Convert_core_Provider_To_v1alpha1_Provider(in *core.Provider, out *Provider, s conversion.Scope) error {
	return autoConvert_core_Provider_To_v1alpha1_Provider(in, out, s)
}

func autoConvert_v1alpha1_Quota_To_core_Quota(in *Quota, out *core.Quota, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_QuotaSpec_To_core_QuotaSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Quota_To_core_Quota is an autogenerated conversion function.
func Convert_v1alpha1_Quota_To_core_Quota(in *Quota, out *core.Quota, s conversion.Scope) error {
	return autoConvert_v1alpha1_Quota_To_core_Quota(in, out, s)
}

func autoConvert_core_Quota_To_v1alpha1_Quota(in *core.Quota, out *Quota, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_QuotaSpec_To_v1alpha1_QuotaSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_Quota_To_v1alpha1_Quota is an autogenerated conversion function.
func Convert_core_Quota_To_v1alpha1_Quota(in *core.Quota, out *Quota, s conversion.Scope) error {
	return autoConvert_core_Quota_To_v1alpha1_Quota(in, out, s)
}

func autoConvert_v1alpha1_QuotaList_To_core_QuotaList(in *QuotaList, out *core.QuotaList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.Quota)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_QuotaList_To_core_QuotaList is an autogenerated conversion function.
func Convert_v1alpha1_QuotaList_To_core_QuotaList(in *QuotaList, out *core.QuotaList, s conversion.Scope) error {
	return autoConvert_v1alpha1_QuotaList_To_core_QuotaList(in, out, s)
}

func autoConvert_core_QuotaList_To_v1alpha1_QuotaList(in *core.QuotaList, out *QuotaList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]Quota)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_QuotaList_To_v1alpha1_QuotaList is an autogenerated conversion function.
func Convert_core_QuotaList_To_v1alpha1_QuotaList(in *core.QuotaList, out *QuotaList, s conversion.Scope) error {
	return autoConvert_core_QuotaList_To_v1alpha1_QuotaList(in, out, s)
}

func autoConvert_v1alpha1_QuotaSpec_To_core_QuotaSpec(in *QuotaSpec, out *core.QuotaSpec, s conversion.Scope) error {
	out.ClusterLifetimeDays = (*int32)(unsafe.Pointer(in.ClusterLifetimeDays))
	out.Metrics = *(*v1.ResourceList)(unsafe.Pointer(&in.Metrics))
	out.Scope = in.Scope
	return nil
}

// Convert_v1alpha1_QuotaSpec_To_core_QuotaSpec is an autogenerated conversion function.
func Convert_v1alpha1_QuotaSpec_To_core_QuotaSpec(in *QuotaSpec, out *core.QuotaSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_QuotaSpec_To_core_QuotaSpec(in, out, s)
}

func autoConvert_core_QuotaSpec_To_v1alpha1_QuotaSpec(in *core.QuotaSpec, out *QuotaSpec, s conversion.Scope) error {
	out.ClusterLifetimeDays = (*int32)(unsafe.Pointer(in.ClusterLifetimeDays))
	out.Metrics = *(*v1.ResourceList)(unsafe.Pointer(&in.Metrics))
	out.Scope = in.Scope
	return nil
}

// Convert_core_QuotaSpec_To_v1alpha1_QuotaSpec is an autogenerated conversion function.
func Convert_core_QuotaSpec_To_v1alpha1_QuotaSpec(in *core.QuotaSpec, out *QuotaSpec, s conversion.Scope) error {
	return autoConvert_core_QuotaSpec_To_v1alpha1_QuotaSpec(in, out, s)
}

func autoConvert_v1alpha1_Region_To_core_Region(in *Region, out *core.Region, s conversion.Scope) error {
	out.Name = in.Name
	out.Zones = *(*[]core.AvailabilityZone)(unsafe.Pointer(&in.Zones))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1alpha1_Region_To_core_Region is an autogenerated conversion function.
func Convert_v1alpha1_Region_To_core_Region(in *Region, out *core.Region, s conversion.Scope) error {
	return autoConvert_v1alpha1_Region_To_core_Region(in, out, s)
}

func autoConvert_core_Region_To_v1alpha1_Region(in *core.Region, out *Region, s conversion.Scope) error {
	out.Name = in.Name
	out.Zones = *(*[]AvailabilityZone)(unsafe.Pointer(&in.Zones))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_core_Region_To_v1alpha1_Region is an autogenerated conversion function.
func Convert_core_Region_To_v1alpha1_Region(in *core.Region, out *Region, s conversion.Scope) error {
	return autoConvert_core_Region_To_v1alpha1_Region(in, out, s)
}

func autoConvert_v1alpha1_ResourceData_To_core_ResourceData(in *ResourceData, out *core.ResourceData, s conversion.Scope) error {
	out.CrossVersionObjectReference = in.CrossVersionObjectReference
	out.Data = in.Data
	return nil
}

// Convert_v1alpha1_ResourceData_To_core_ResourceData is an autogenerated conversion function.
func Convert_v1alpha1_ResourceData_To_core_ResourceData(in *ResourceData, out *core.ResourceData, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceData_To_core_ResourceData(in, out, s)
}

func autoConvert_core_ResourceData_To_v1alpha1_ResourceData(in *core.ResourceData, out *ResourceData, s conversion.Scope) error {
	out.CrossVersionObjectReference = in.CrossVersionObjectReference
	out.Data = in.Data
	return nil
}

// Convert_core_ResourceData_To_v1alpha1_ResourceData is an autogenerated conversion function.
func Convert_core_ResourceData_To_v1alpha1_ResourceData(in *core.ResourceData, out *ResourceData, s conversion.Scope) error {
	return autoConvert_core_ResourceData_To_v1alpha1_ResourceData(in, out, s)
}

func autoConvert_v1alpha1_ResourceWatchCacheSize_To_core_ResourceWatchCacheSize(in *ResourceWatchCacheSize, out *core.ResourceWatchCacheSize, s conversion.Scope) error {
	out.APIGroup = (*string)(unsafe.Pointer(in.APIGroup))
	out.Resource = in.Resource
	out.CacheSize = in.CacheSize
	return nil
}

// Convert_v1alpha1_ResourceWatchCacheSize_To_core_ResourceWatchCacheSize is an autogenerated conversion function.
func Convert_v1alpha1_ResourceWatchCacheSize_To_core_ResourceWatchCacheSize(in *ResourceWatchCacheSize, out *core.ResourceWatchCacheSize, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceWatchCacheSize_To_core_ResourceWatchCacheSize(in, out, s)
}

func autoConvert_core_ResourceWatchCacheSize_To_v1alpha1_ResourceWatchCacheSize(in *core.ResourceWatchCacheSize, out *ResourceWatchCacheSize, s conversion.Scope) error {
	out.APIGroup = (*string)(unsafe.Pointer(in.APIGroup))
	out.Resource = in.Resource
	out.CacheSize = in.CacheSize
	return nil
}

// Convert_core_ResourceWatchCacheSize_To_v1alpha1_ResourceWatchCacheSize is an autogenerated conversion function.
func Convert_core_ResourceWatchCacheSize_To_v1alpha1_ResourceWatchCacheSize(in *core.ResourceWatchCacheSize, out *ResourceWatchCacheSize, s conversion.Scope) error {
	return autoConvert_core_ResourceWatchCacheSize_To_v1alpha1_ResourceWatchCacheSize(in, out, s)
}

func autoConvert_v1alpha1_SecretBinding_To_core_SecretBinding(in *SecretBinding, out *core.SecretBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.SecretRef = in.SecretRef
	out.Quotas = *(*[]v1.ObjectReference)(unsafe.Pointer(&in.Quotas))
	return nil
}

// Convert_v1alpha1_SecretBinding_To_core_SecretBinding is an autogenerated conversion function.
func Convert_v1alpha1_SecretBinding_To_core_SecretBinding(in *SecretBinding, out *core.SecretBinding, s conversion.Scope) error {
	return autoConvert_v1alpha1_SecretBinding_To_core_SecretBinding(in, out, s)
}

func autoConvert_core_SecretBinding_To_v1alpha1_SecretBinding(in *core.SecretBinding, out *SecretBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.SecretRef = in.SecretRef
	out.Quotas = *(*[]v1.ObjectReference)(unsafe.Pointer(&in.Quotas))
	return nil
}

// Convert_core_SecretBinding_To_v1alpha1_SecretBinding is an autogenerated conversion function.
func Convert_core_SecretBinding_To_v1alpha1_SecretBinding(in *core.SecretBinding, out *SecretBinding, s conversion.Scope) error {
	return autoConvert_core_SecretBinding_To_v1alpha1_SecretBinding(in, out, s)
}

func autoConvert_v1alpha1_SecretBindingList_To_core_SecretBindingList(in *SecretBindingList, out *core.SecretBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.SecretBinding)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_SecretBindingList_To_core_SecretBindingList is an autogenerated conversion function.
func Convert_v1alpha1_SecretBindingList_To_core_SecretBindingList(in *SecretBindingList, out *core.SecretBindingList, s conversion.Scope) error {
	return autoConvert_v1alpha1_SecretBindingList_To_core_SecretBindingList(in, out, s)
}

func autoConvert_core_SecretBindingList_To_v1alpha1_SecretBindingList(in *core.SecretBindingList, out *SecretBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]SecretBinding)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_SecretBindingList_To_v1alpha1_SecretBindingList is an autogenerated conversion function.
func Convert_core_SecretBindingList_To_v1alpha1_SecretBindingList(in *core.SecretBindingList, out *SecretBindingList, s conversion.Scope) error {
	return autoConvert_core_SecretBindingList_To_v1alpha1_SecretBindingList(in, out, s)
}

func autoConvert_v1alpha1_Seed_To_core_Seed(in *Seed, out *core.Seed, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_SeedSpec_To_core_SeedSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_SeedStatus_To_core_SeedStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_core_Seed_To_v1alpha1_Seed(in *core.Seed, out *Seed, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_SeedSpec_To_v1alpha1_SeedSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_SeedStatus_To_v1alpha1_SeedStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_SeedBackup_To_core_SeedBackup(in *SeedBackup, out *core.SeedBackup, s conversion.Scope) error {
	out.Provider = in.Provider
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Region = (*string)(unsafe.Pointer(in.Region))
	out.SecretRef = in.SecretRef
	return nil
}

// Convert_v1alpha1_SeedBackup_To_core_SeedBackup is an autogenerated conversion function.
func Convert_v1alpha1_SeedBackup_To_core_SeedBackup(in *SeedBackup, out *core.SeedBackup, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedBackup_To_core_SeedBackup(in, out, s)
}

func autoConvert_core_SeedBackup_To_v1alpha1_SeedBackup(in *core.SeedBackup, out *SeedBackup, s conversion.Scope) error {
	out.Provider = in.Provider
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Region = (*string)(unsafe.Pointer(in.Region))
	out.SecretRef = in.SecretRef
	return nil
}

// Convert_core_SeedBackup_To_v1alpha1_SeedBackup is an autogenerated conversion function.
func Convert_core_SeedBackup_To_v1alpha1_SeedBackup(in *core.SeedBackup, out *SeedBackup, s conversion.Scope) error {
	return autoConvert_core_SeedBackup_To_v1alpha1_SeedBackup(in, out, s)
}

func autoConvert_v1alpha1_SeedDNS_To_core_SeedDNS(in *SeedDNS, out *core.SeedDNS, s conversion.Scope) error {
	out.IngressDomain = (*string)(unsafe.Pointer(in.IngressDomain))
	out.Provider = (*core.SeedDNSProvider)(unsafe.Pointer(in.Provider))
	return nil
}

// Convert_v1alpha1_SeedDNS_To_core_SeedDNS is an autogenerated conversion function.
func Convert_v1alpha1_SeedDNS_To_core_SeedDNS(in *SeedDNS, out *core.SeedDNS, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedDNS_To_core_SeedDNS(in, out, s)
}

func autoConvert_core_SeedDNS_To_v1alpha1_SeedDNS(in *core.SeedDNS, out *SeedDNS, s conversion.Scope) error {
	out.IngressDomain = (*string)(unsafe.Pointer(in.IngressDomain))
	out.Provider = (*SeedDNSProvider)(unsafe.Pointer(in.Provider))
	return nil
}

// Convert_core_SeedDNS_To_v1alpha1_SeedDNS is an autogenerated conversion function.
func Convert_core_SeedDNS_To_v1alpha1_SeedDNS(in *core.SeedDNS, out *SeedDNS, s conversion.Scope) error {
	return autoConvert_core_SeedDNS_To_v1alpha1_SeedDNS(in, out, s)
}

func autoConvert_v1alpha1_SeedDNSProvider_To_core_SeedDNSProvider(in *SeedDNSProvider, out *core.SeedDNSProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.SecretRef = in.SecretRef
	out.Domains = (*core.DNSIncludeExclude)(unsafe.Pointer(in.Domains))
	out.Zones = (*core.DNSIncludeExclude)(unsafe.Pointer(in.Zones))
	return nil
}

// Convert_v1alpha1_SeedDNSProvider_To_core_SeedDNSProvider is an autogenerated conversion function.
func Convert_v1alpha1_SeedDNSProvider_To_core_SeedDNSProvider(in *SeedDNSProvider, out *core.SeedDNSProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedDNSProvider_To_core_SeedDNSProvider(in, out, s)
}

func autoConvert_core_SeedDNSProvider_To_v1alpha1_SeedDNSProvider(in *core.SeedDNSProvider, out *SeedDNSProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.SecretRef = in.SecretRef
	out.Domains = (*DNSIncludeExclude)(unsafe.Pointer(in.Domains))
	out.Zones = (*DNSIncludeExclude)(unsafe.Pointer(in.Zones))
	return nil
}

// Convert_core_SeedDNSProvider_To_v1alpha1_SeedDNSProvider is an autogenerated conversion function.
func Convert_core_SeedDNSProvider_To_v1alpha1_SeedDNSProvider(in *core.SeedDNSProvider, out *SeedDNSProvider, s conversion.Scope) error {
	return autoConvert_core_SeedDNSProvider_To_v1alpha1_SeedDNSProvider(in, out, s)
}

func autoConvert_v1alpha1_SeedList_To_core_SeedList(in *SeedList, out *core.SeedList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]core.Seed, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_Seed_To_core_Seed(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_SeedList_To_core_SeedList is an autogenerated conversion function.
func Convert_v1alpha1_SeedList_To_core_SeedList(in *SeedList, out *core.SeedList, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedList_To_core_SeedList(in, out, s)
}

func autoConvert_core_SeedList_To_v1alpha1_SeedList(in *core.SeedList, out *SeedList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Seed, len(*in))
		for i := range *in {
			if err := Convert_core_Seed_To_v1alpha1_Seed(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_core_SeedList_To_v1alpha1_SeedList is an autogenerated conversion function.
func Convert_core_SeedList_To_v1alpha1_SeedList(in *core.SeedList, out *SeedList, s conversion.Scope) error {
	return autoConvert_core_SeedList_To_v1alpha1_SeedList(in, out, s)
}

func autoConvert_v1alpha1_SeedNetworks_To_core_SeedNetworks(in *SeedNetworks, out *core.SeedNetworks, s conversion.Scope) error {
	out.Nodes = (*string)(unsafe.Pointer(in.Nodes))
	out.Pods = in.Pods
	out.Services = in.Services
	out.ShootDefaults = (*core.ShootNetworks)(unsafe.Pointer(in.ShootDefaults))
	return nil
}

func autoConvert_core_SeedNetworks_To_v1alpha1_SeedNetworks(in *core.SeedNetworks, out *SeedNetworks, s conversion.Scope) error {
	out.Nodes = (*string)(unsafe.Pointer(in.Nodes))
	out.Pods = in.Pods
	out.Services = in.Services
	out.ShootDefaults = (*ShootNetworks)(unsafe.Pointer(in.ShootDefaults))
	// WARNING: in.BlockCIDRs requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha1_SeedProvider_To_core_SeedProvider(in *SeedProvider, out *core.SeedProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Region = in.Region
	return nil
}

// Convert_v1alpha1_SeedProvider_To_core_SeedProvider is an autogenerated conversion function.
func Convert_v1alpha1_SeedProvider_To_core_SeedProvider(in *SeedProvider, out *core.SeedProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedProvider_To_core_SeedProvider(in, out, s)
}

func autoConvert_core_SeedProvider_To_v1alpha1_SeedProvider(in *core.SeedProvider, out *SeedProvider, s conversion.Scope) error {
	out.Type = in.Type
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Region = in.Region
	return nil
}

// Convert_core_SeedProvider_To_v1alpha1_SeedProvider is an autogenerated conversion function.
func Convert_core_SeedProvider_To_v1alpha1_SeedProvider(in *core.SeedProvider, out *SeedProvider, s conversion.Scope) error {
	return autoConvert_core_SeedProvider_To_v1alpha1_SeedProvider(in, out, s)
}

func autoConvert_v1alpha1_SeedSelector_To_core_SeedSelector(in *SeedSelector, out *core.SeedSelector, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.ProviderTypes = *(*[]string)(unsafe.Pointer(&in.ProviderTypes))
	return nil
}

// Convert_v1alpha1_SeedSelector_To_core_SeedSelector is an autogenerated conversion function.
func Convert_v1alpha1_SeedSelector_To_core_SeedSelector(in *SeedSelector, out *core.SeedSelector, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSelector_To_core_SeedSelector(in, out, s)
}

func autoConvert_core_SeedSelector_To_v1alpha1_SeedSelector(in *core.SeedSelector, out *SeedSelector, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.ProviderTypes = *(*[]string)(unsafe.Pointer(&in.ProviderTypes))
	return nil
}

// Convert_core_SeedSelector_To_v1alpha1_SeedSelector is an autogenerated conversion function.
func Convert_core_SeedSelector_To_v1alpha1_SeedSelector(in *core.SeedSelector, out *SeedSelector, s conversion.Scope) error {
	return autoConvert_core_SeedSelector_To_v1alpha1_SeedSelector(in, out, s)
}

func autoConvert_v1alpha1_SeedSettingExcessCapacityReservation_To_core_SeedSettingExcessCapacityReservation(in *SeedSettingExcessCapacityReservation, out *core.SeedSettingExcessCapacityReservation, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_v1alpha1_SeedSettingExcessCapacityReservation_To_core_SeedSettingExcessCapacityReservation is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettingExcessCapacityReservation_To_core_SeedSettingExcessCapacityReservation(in *SeedSettingExcessCapacityReservation, out *core.SeedSettingExcessCapacityReservation, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettingExcessCapacityReservation_To_core_SeedSettingExcessCapacityReservation(in, out, s)
}

func autoConvert_core_SeedSettingExcessCapacityReservation_To_v1alpha1_SeedSettingExcessCapacityReservation(in *core.SeedSettingExcessCapacityReservation, out *SeedSettingExcessCapacityReservation, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_core_SeedSettingExcessCapacityReservation_To_v1alpha1_SeedSettingExcessCapacityReservation is an autogenerated conversion function.
func Convert_core_SeedSettingExcessCapacityReservation_To_v1alpha1_SeedSettingExcessCapacityReservation(in *core.SeedSettingExcessCapacityReservation, out *SeedSettingExcessCapacityReservation, s conversion.Scope) error {
	return autoConvert_core_SeedSettingExcessCapacityReservation_To_v1alpha1_SeedSettingExcessCapacityReservation(in, out, s)
}

func autoConvert_v1alpha1_SeedSettingLoadBalancerServices_To_core_SeedSettingLoadBalancerServices(in *SeedSettingLoadBalancerServices, out *core.SeedSettingLoadBalancerServices, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_v1alpha1_SeedSettingLoadBalancerServices_To_core_SeedSettingLoadBalancerServices is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettingLoadBalancerServices_To_core_SeedSettingLoadBalancerServices(in *SeedSettingLoadBalancerServices, out *core.SeedSettingLoadBalancerServices, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettingLoadBalancerServices_To_core_SeedSettingLoadBalancerServices(in, out, s)
}

func autoConvert_core_SeedSettingLoadBalancerServices_To_v1alpha1_SeedSettingLoadBalancerServices(in *core.SeedSettingLoadBalancerServices, out *SeedSettingLoadBalancerServices, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_core_SeedSettingLoadBalancerServices_To_v1alpha1_SeedSettingLoadBalancerServices is an autogenerated conversion function.
func Convert_core_SeedSettingLoadBalancerServices_To_v1alpha1_SeedSettingLoadBalancerServices(in *core.SeedSettingLoadBalancerServices, out *SeedSettingLoadBalancerServices, s conversion.Scope) error {
	return autoConvert_core_SeedSettingLoadBalancerServices_To_v1alpha1_SeedSettingLoadBalancerServices(in, out, s)
}

func autoConvert_v1alpha1_SeedSettingScheduling_To_core_SeedSettingScheduling(in *SeedSettingScheduling, out *core.SeedSettingScheduling, s conversion.Scope) error {
	out.Visible = in.Visible
	return nil
}

// Convert_v1alpha1_SeedSettingScheduling_To_core_SeedSettingScheduling is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettingScheduling_To_core_SeedSettingScheduling(in *SeedSettingScheduling, out *core.SeedSettingScheduling, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettingScheduling_To_core_SeedSettingScheduling(in, out, s)
}

func autoConvert_core_SeedSettingScheduling_To_v1alpha1_SeedSettingScheduling(in *core.SeedSettingScheduling, out *SeedSettingScheduling, s conversion.Scope) error {
	out.Visible = in.Visible
	return nil
}

// Convert_core_SeedSettingScheduling_To_v1alpha1_SeedSettingScheduling is an autogenerated conversion function.
func Convert_core_SeedSettingScheduling_To_v1alpha1_SeedSettingScheduling(in *core.SeedSettingScheduling, out *SeedSettingScheduling, s conversion.Scope) error {
	return autoConvert_core_SeedSettingScheduling_To_v1alpha1_SeedSettingScheduling(in, out, s)
}

func autoConvert_v1alpha1_SeedSettingShootDNS_To_core_SeedSettingShootDNS(in *SeedSettingShootDNS, out *core.SeedSettingShootDNS, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_v1alpha1_SeedSettingShootDNS_To_core_SeedSettingShootDNS is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettingShootDNS_To_core_SeedSettingShootDNS(in *SeedSettingShootDNS, out *core.SeedSettingShootDNS, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettingShootDNS_To_core_SeedSettingShootDNS(in, out, s)
}

func autoConvert_core_SeedSettingShootDNS_To_v1alpha1_SeedSettingShootDNS(in *core.SeedSettingShootDNS, out *SeedSettingShootDNS, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_core_SeedSettingShootDNS_To_v1alpha1_SeedSettingShootDNS is an autogenerated conversion function.
func Convert_core_SeedSettingShootDNS_To_v1alpha1_SeedSettingShootDNS(in *core.SeedSettingShootDNS, out *SeedSettingShootDNS, s conversion.Scope) error {
	return autoConvert_core_SeedSettingShootDNS_To_v1alpha1_SeedSettingShootDNS(in, out, s)
}

func autoConvert_v1alpha1_SeedSettingVerticalPodAutoscaler_To_core_SeedSettingVerticalPodAutoscaler(in *SeedSettingVerticalPodAutoscaler, out *core.SeedSettingVerticalPodAutoscaler, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_v1alpha1_SeedSettingVerticalPodAutoscaler_To_core_SeedSettingVerticalPodAutoscaler is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettingVerticalPodAutoscaler_To_core_SeedSettingVerticalPodAutoscaler(in *SeedSettingVerticalPodAutoscaler, out *core.SeedSettingVerticalPodAutoscaler, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettingVerticalPodAutoscaler_To_core_SeedSettingVerticalPodAutoscaler(in, out, s)
}

func autoConvert_core_SeedSettingVerticalPodAutoscaler_To_v1alpha1_SeedSettingVerticalPodAutoscaler(in *core.SeedSettingVerticalPodAutoscaler, out *SeedSettingVerticalPodAutoscaler, s conversion.Scope) error {
	out.Enabled = in.Enabled
	return nil
}

// Convert_core_SeedSettingVerticalPodAutoscaler_To_v1alpha1_SeedSettingVerticalPodAutoscaler is an autogenerated conversion function.
func Convert_core_SeedSettingVerticalPodAutoscaler_To_v1alpha1_SeedSettingVerticalPodAutoscaler(in *core.SeedSettingVerticalPodAutoscaler, out *SeedSettingVerticalPodAutoscaler, s conversion.Scope) error {
	return autoConvert_core_SeedSettingVerticalPodAutoscaler_To_v1alpha1_SeedSettingVerticalPodAutoscaler(in, out, s)
}

func autoConvert_v1alpha1_SeedSettings_To_core_SeedSettings(in *SeedSettings, out *core.SeedSettings, s conversion.Scope) error {
	out.ExcessCapacityReservation = (*core.SeedSettingExcessCapacityReservation)(unsafe.Pointer(in.ExcessCapacityReservation))
	out.Scheduling = (*core.SeedSettingScheduling)(unsafe.Pointer(in.Scheduling))
	out.ShootDNS = (*core.SeedSettingShootDNS)(unsafe.Pointer(in.ShootDNS))
	out.LoadBalancerServices = (*core.SeedSettingLoadBalancerServices)(unsafe.Pointer(in.LoadBalancerServices))
	out.VerticalPodAutoscaler = (*core.SeedSettingVerticalPodAutoscaler)(unsafe.Pointer(in.VerticalPodAutoscaler))
	return nil
}

// Convert_v1alpha1_SeedSettings_To_core_SeedSettings is an autogenerated conversion function.
func Convert_v1alpha1_SeedSettings_To_core_SeedSettings(in *SeedSettings, out *core.SeedSettings, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedSettings_To_core_SeedSettings(in, out, s)
}

func autoConvert_core_SeedSettings_To_v1alpha1_SeedSettings(in *core.SeedSettings, out *SeedSettings, s conversion.Scope) error {
	out.ExcessCapacityReservation = (*SeedSettingExcessCapacityReservation)(unsafe.Pointer(in.ExcessCapacityReservation))
	out.Scheduling = (*SeedSettingScheduling)(unsafe.Pointer(in.Scheduling))
	out.ShootDNS = (*SeedSettingShootDNS)(unsafe.Pointer(in.ShootDNS))
	out.LoadBalancerServices = (*SeedSettingLoadBalancerServices)(unsafe.Pointer(in.LoadBalancerServices))
	out.VerticalPodAutoscaler = (*SeedSettingVerticalPodAutoscaler)(unsafe.Pointer(in.VerticalPodAutoscaler))
	return nil
}

// Convert_core_SeedSettings_To_v1alpha1_SeedSettings is an autogenerated conversion function.
func Convert_core_SeedSettings_To_v1alpha1_SeedSettings(in *core.SeedSettings, out *SeedSettings, s conversion.Scope) error {
	return autoConvert_core_SeedSettings_To_v1alpha1_SeedSettings(in, out, s)
}

func autoConvert_v1alpha1_SeedSpec_To_core_SeedSpec(in *SeedSpec, out *core.SeedSpec, s conversion.Scope) error {
	out.Backup = (*core.SeedBackup)(unsafe.Pointer(in.Backup))
	// WARNING: in.BlockCIDRs requires manual conversion: does not exist in peer-type
	if err := Convert_v1alpha1_SeedDNS_To_core_SeedDNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_SeedNetworks_To_core_SeedNetworks(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_SeedProvider_To_core_SeedProvider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.SecretRef = (*v1.SecretReference)(unsafe.Pointer(in.SecretRef))
	out.Taints = *(*[]core.SeedTaint)(unsafe.Pointer(&in.Taints))
	out.Volume = (*core.SeedVolume)(unsafe.Pointer(in.Volume))
	out.Settings = (*core.SeedSettings)(unsafe.Pointer(in.Settings))
	out.Ingress = (*core.Ingress)(unsafe.Pointer(in.Ingress))
	return nil
}

func autoConvert_core_SeedSpec_To_v1alpha1_SeedSpec(in *core.SeedSpec, out *SeedSpec, s conversion.Scope) error {
	out.Backup = (*SeedBackup)(unsafe.Pointer(in.Backup))
	if err := Convert_core_SeedDNS_To_v1alpha1_SeedDNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	if err := Convert_core_SeedNetworks_To_v1alpha1_SeedNetworks(&in.Networks, &out.Networks, s); err != nil {
		return err
	}
	if err := Convert_core_SeedProvider_To_v1alpha1_SeedProvider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.SecretRef = (*v1.SecretReference)(unsafe.Pointer(in.SecretRef))
	out.Settings = (*SeedSettings)(unsafe.Pointer(in.Settings))
	out.Taints = *(*[]SeedTaint)(unsafe.Pointer(&in.Taints))
	out.Volume = (*SeedVolume)(unsafe.Pointer(in.Volume))
	out.Ingress = (*Ingress)(unsafe.Pointer(in.Ingress))
	return nil
}

func autoConvert_v1alpha1_SeedStatus_To_core_SeedStatus(in *SeedStatus, out *core.SeedStatus, s conversion.Scope) error {
	out.Conditions = *(*[]core.Condition)(unsafe.Pointer(&in.Conditions))
	out.Gardener = (*core.Gardener)(unsafe.Pointer(in.Gardener))
	out.KubernetesVersion = (*string)(unsafe.Pointer(in.KubernetesVersion))
	out.ObservedGeneration = in.ObservedGeneration
	out.ClusterIdentity = (*string)(unsafe.Pointer(in.ClusterIdentity))
	return nil
}

// Convert_v1alpha1_SeedStatus_To_core_SeedStatus is an autogenerated conversion function.
func Convert_v1alpha1_SeedStatus_To_core_SeedStatus(in *SeedStatus, out *core.SeedStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedStatus_To_core_SeedStatus(in, out, s)
}

func autoConvert_core_SeedStatus_To_v1alpha1_SeedStatus(in *core.SeedStatus, out *SeedStatus, s conversion.Scope) error {
	out.Gardener = (*Gardener)(unsafe.Pointer(in.Gardener))
	out.KubernetesVersion = (*string)(unsafe.Pointer(in.KubernetesVersion))
	out.Conditions = *(*[]Condition)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	out.ClusterIdentity = (*string)(unsafe.Pointer(in.ClusterIdentity))
	// WARNING: in.Capacity requires manual conversion: does not exist in peer-type
	// WARNING: in.Allocatable requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha1_SeedTaint_To_core_SeedTaint(in *SeedTaint, out *core.SeedTaint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = (*string)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_v1alpha1_SeedTaint_To_core_SeedTaint is an autogenerated conversion function.
func Convert_v1alpha1_SeedTaint_To_core_SeedTaint(in *SeedTaint, out *core.SeedTaint, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedTaint_To_core_SeedTaint(in, out, s)
}

func autoConvert_core_SeedTaint_To_v1alpha1_SeedTaint(in *core.SeedTaint, out *SeedTaint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = (*string)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_core_SeedTaint_To_v1alpha1_SeedTaint is an autogenerated conversion function.
func Convert_core_SeedTaint_To_v1alpha1_SeedTaint(in *core.SeedTaint, out *SeedTaint, s conversion.Scope) error {
	return autoConvert_core_SeedTaint_To_v1alpha1_SeedTaint(in, out, s)
}

func autoConvert_v1alpha1_SeedVolume_To_core_SeedVolume(in *SeedVolume, out *core.SeedVolume, s conversion.Scope) error {
	out.MinimumSize = (*resource.Quantity)(unsafe.Pointer(in.MinimumSize))
	out.Providers = *(*[]core.SeedVolumeProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_v1alpha1_SeedVolume_To_core_SeedVolume is an autogenerated conversion function.
func Convert_v1alpha1_SeedVolume_To_core_SeedVolume(in *SeedVolume, out *core.SeedVolume, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedVolume_To_core_SeedVolume(in, out, s)
}

func autoConvert_core_SeedVolume_To_v1alpha1_SeedVolume(in *core.SeedVolume, out *SeedVolume, s conversion.Scope) error {
	out.MinimumSize = (*resource.Quantity)(unsafe.Pointer(in.MinimumSize))
	out.Providers = *(*[]SeedVolumeProvider)(unsafe.Pointer(&in.Providers))
	return nil
}

// Convert_core_SeedVolume_To_v1alpha1_SeedVolume is an autogenerated conversion function.
func Convert_core_SeedVolume_To_v1alpha1_SeedVolume(in *core.SeedVolume, out *SeedVolume, s conversion.Scope) error {
	return autoConvert_core_SeedVolume_To_v1alpha1_SeedVolume(in, out, s)
}

func autoConvert_v1alpha1_SeedVolumeProvider_To_core_SeedVolumeProvider(in *SeedVolumeProvider, out *core.SeedVolumeProvider, s conversion.Scope) error {
	out.Purpose = in.Purpose
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_SeedVolumeProvider_To_core_SeedVolumeProvider is an autogenerated conversion function.
func Convert_v1alpha1_SeedVolumeProvider_To_core_SeedVolumeProvider(in *SeedVolumeProvider, out *core.SeedVolumeProvider, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedVolumeProvider_To_core_SeedVolumeProvider(in, out, s)
}

func autoConvert_core_SeedVolumeProvider_To_v1alpha1_SeedVolumeProvider(in *core.SeedVolumeProvider, out *SeedVolumeProvider, s conversion.Scope) error {
	out.Purpose = in.Purpose
	out.Name = in.Name
	return nil
}

// Convert_core_SeedVolumeProvider_To_v1alpha1_SeedVolumeProvider is an autogenerated conversion function.
func Convert_core_SeedVolumeProvider_To_v1alpha1_SeedVolumeProvider(in *core.SeedVolumeProvider, out *SeedVolumeProvider, s conversion.Scope) error {
	return autoConvert_core_SeedVolumeProvider_To_v1alpha1_SeedVolumeProvider(in, out, s)
}

func autoConvert_v1alpha1_ServiceAccountConfig_To_core_ServiceAccountConfig(in *ServiceAccountConfig, out *core.ServiceAccountConfig, s conversion.Scope) error {
	out.Issuer = (*string)(unsafe.Pointer(in.Issuer))
	out.SigningKeySecret = (*v1.LocalObjectReference)(unsafe.Pointer(in.SigningKeySecret))
	return nil
}

// Convert_v1alpha1_ServiceAccountConfig_To_core_ServiceAccountConfig is an autogenerated conversion function.
func Convert_v1alpha1_ServiceAccountConfig_To_core_ServiceAccountConfig(in *ServiceAccountConfig, out *core.ServiceAccountConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServiceAccountConfig_To_core_ServiceAccountConfig(in, out, s)
}

func autoConvert_core_ServiceAccountConfig_To_v1alpha1_ServiceAccountConfig(in *core.ServiceAccountConfig, out *ServiceAccountConfig, s conversion.Scope) error {
	out.Issuer = (*string)(unsafe.Pointer(in.Issuer))
	out.SigningKeySecret = (*v1.LocalObjectReference)(unsafe.Pointer(in.SigningKeySecret))
	return nil
}

// Convert_core_ServiceAccountConfig_To_v1alpha1_ServiceAccountConfig is an autogenerated conversion function.
func Convert_core_ServiceAccountConfig_To_v1alpha1_ServiceAccountConfig(in *core.ServiceAccountConfig, out *ServiceAccountConfig, s conversion.Scope) error {
	return autoConvert_core_ServiceAccountConfig_To_v1alpha1_ServiceAccountConfig(in, out, s)
}

func autoConvert_v1alpha1_Shoot_To_core_Shoot(in *Shoot, out *core.Shoot, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ShootSpec_To_core_ShootSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ShootStatus_To_core_ShootStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Shoot_To_core_Shoot is an autogenerated conversion function.
func Convert_v1alpha1_Shoot_To_core_Shoot(in *Shoot, out *core.Shoot, s conversion.Scope) error {
	return autoConvert_v1alpha1_Shoot_To_core_Shoot(in, out, s)
}

func autoConvert_core_Shoot_To_v1alpha1_Shoot(in *core.Shoot, out *Shoot, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_ShootSpec_To_v1alpha1_ShootSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_core_ShootStatus_To_v1alpha1_ShootStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_Shoot_To_v1alpha1_Shoot is an autogenerated conversion function.
func Convert_core_Shoot_To_v1alpha1_Shoot(in *core.Shoot, out *Shoot, s conversion.Scope) error {
	return autoConvert_core_Shoot_To_v1alpha1_Shoot(in, out, s)
}

func autoConvert_v1alpha1_ShootList_To_core_ShootList(in *ShootList, out *core.ShootList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]core.Shoot, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_Shoot_To_core_Shoot(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_ShootList_To_core_ShootList is an autogenerated conversion function.
func Convert_v1alpha1_ShootList_To_core_ShootList(in *ShootList, out *core.ShootList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootList_To_core_ShootList(in, out, s)
}

func autoConvert_core_ShootList_To_v1alpha1_ShootList(in *core.ShootList, out *ShootList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Shoot, len(*in))
		for i := range *in {
			if err := Convert_core_Shoot_To_v1alpha1_Shoot(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_core_ShootList_To_v1alpha1_ShootList is an autogenerated conversion function.
func Convert_core_ShootList_To_v1alpha1_ShootList(in *core.ShootList, out *ShootList, s conversion.Scope) error {
	return autoConvert_core_ShootList_To_v1alpha1_ShootList(in, out, s)
}

func autoConvert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage(in *ShootMachineImage, out *core.ShootMachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	if err := metav1.Convert_Pointer_string_To_string(&in.Version, &out.Version, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage is an autogenerated conversion function.
func Convert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage(in *ShootMachineImage, out *core.ShootMachineImage, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootMachineImage_To_core_ShootMachineImage(in, out, s)
}

func autoConvert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage(in *core.ShootMachineImage, out *ShootMachineImage, s conversion.Scope) error {
	out.Name = in.Name
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	if err := metav1.Convert_string_To_Pointer_string(&in.Version, &out.Version, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage is an autogenerated conversion function.
func Convert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage(in *core.ShootMachineImage, out *ShootMachineImage, s conversion.Scope) error {
	return autoConvert_core_ShootMachineImage_To_v1alpha1_ShootMachineImage(in, out, s)
}

func autoConvert_v1alpha1_ShootNetworks_To_core_ShootNetworks(in *ShootNetworks, out *core.ShootNetworks, s conversion.Scope) error {
	out.Pods = (*string)(unsafe.Pointer(in.Pods))
	out.Services = (*string)(unsafe.Pointer(in.Services))
	return nil
}

// Convert_v1alpha1_ShootNetworks_To_core_ShootNetworks is an autogenerated conversion function.
func Convert_v1alpha1_ShootNetworks_To_core_ShootNetworks(in *ShootNetworks, out *core.ShootNetworks, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootNetworks_To_core_ShootNetworks(in, out, s)
}

func autoConvert_core_ShootNetworks_To_v1alpha1_ShootNetworks(in *core.ShootNetworks, out *ShootNetworks, s conversion.Scope) error {
	out.Pods = (*string)(unsafe.Pointer(in.Pods))
	out.Services = (*string)(unsafe.Pointer(in.Services))
	return nil
}

// Convert_core_ShootNetworks_To_v1alpha1_ShootNetworks is an autogenerated conversion function.
func Convert_core_ShootNetworks_To_v1alpha1_ShootNetworks(in *core.ShootNetworks, out *ShootNetworks, s conversion.Scope) error {
	return autoConvert_core_ShootNetworks_To_v1alpha1_ShootNetworks(in, out, s)
}

func autoConvert_v1alpha1_ShootSpec_To_core_ShootSpec(in *ShootSpec, out *core.ShootSpec, s conversion.Scope) error {
	out.Addons = (*core.Addons)(unsafe.Pointer(in.Addons))
	out.CloudProfileName = in.CloudProfileName
	out.DNS = (*core.DNS)(unsafe.Pointer(in.DNS))
	out.Extensions = *(*[]core.Extension)(unsafe.Pointer(&in.Extensions))
	out.Hibernation = (*core.Hibernation)(unsafe.Pointer(in.Hibernation))
	if err := Convert_v1alpha1_Kubernetes_To_core_Kubernetes(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_Networking_To_core_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.Maintenance = (*core.Maintenance)(unsafe.Pointer(in.Maintenance))
	out.Monitoring = (*core.Monitoring)(unsafe.Pointer(in.Monitoring))
	if err := Convert_v1alpha1_Provider_To_core_Provider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.Purpose = (*core.ShootPurpose)(unsafe.Pointer(in.Purpose))
	out.Region = in.Region
	out.SecretBindingName = in.SecretBindingName
	out.SeedName = (*string)(unsafe.Pointer(in.SeedName))
	out.SeedSelector = (*core.SeedSelector)(unsafe.Pointer(in.SeedSelector))
	out.Resources = *(*[]core.NamedResourceReference)(unsafe.Pointer(&in.Resources))
	out.Tolerations = *(*[]core.Toleration)(unsafe.Pointer(&in.Tolerations))
	return nil
}

// Convert_v1alpha1_ShootSpec_To_core_ShootSpec is an autogenerated conversion function.
func Convert_v1alpha1_ShootSpec_To_core_ShootSpec(in *ShootSpec, out *core.ShootSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootSpec_To_core_ShootSpec(in, out, s)
}

func autoConvert_core_ShootSpec_To_v1alpha1_ShootSpec(in *core.ShootSpec, out *ShootSpec, s conversion.Scope) error {
	out.Addons = (*Addons)(unsafe.Pointer(in.Addons))
	out.CloudProfileName = in.CloudProfileName
	out.DNS = (*DNS)(unsafe.Pointer(in.DNS))
	out.Extensions = *(*[]Extension)(unsafe.Pointer(&in.Extensions))
	out.Hibernation = (*Hibernation)(unsafe.Pointer(in.Hibernation))
	if err := Convert_core_Kubernetes_To_v1alpha1_Kubernetes(&in.Kubernetes, &out.Kubernetes, s); err != nil {
		return err
	}
	if err := Convert_core_Networking_To_v1alpha1_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.Maintenance = (*Maintenance)(unsafe.Pointer(in.Maintenance))
	out.Monitoring = (*Monitoring)(unsafe.Pointer(in.Monitoring))
	if err := Convert_core_Provider_To_v1alpha1_Provider(&in.Provider, &out.Provider, s); err != nil {
		return err
	}
	out.Purpose = (*ShootPurpose)(unsafe.Pointer(in.Purpose))
	out.Region = in.Region
	out.SecretBindingName = in.SecretBindingName
	out.SeedName = (*string)(unsafe.Pointer(in.SeedName))
	out.SeedSelector = (*SeedSelector)(unsafe.Pointer(in.SeedSelector))
	out.Resources = *(*[]NamedResourceReference)(unsafe.Pointer(&in.Resources))
	out.Tolerations = *(*[]Toleration)(unsafe.Pointer(&in.Tolerations))
	return nil
}

// Convert_core_ShootSpec_To_v1alpha1_ShootSpec is an autogenerated conversion function.
func Convert_core_ShootSpec_To_v1alpha1_ShootSpec(in *core.ShootSpec, out *ShootSpec, s conversion.Scope) error {
	return autoConvert_core_ShootSpec_To_v1alpha1_ShootSpec(in, out, s)
}

func autoConvert_v1alpha1_ShootState_To_core_ShootState(in *ShootState, out *core.ShootState, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ShootState_To_core_ShootState is an autogenerated conversion function.
func Convert_v1alpha1_ShootState_To_core_ShootState(in *ShootState, out *core.ShootState, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootState_To_core_ShootState(in, out, s)
}

func autoConvert_core_ShootState_To_v1alpha1_ShootState(in *core.ShootState, out *ShootState, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_ShootState_To_v1alpha1_ShootState is an autogenerated conversion function.
func Convert_core_ShootState_To_v1alpha1_ShootState(in *core.ShootState, out *ShootState, s conversion.Scope) error {
	return autoConvert_core_ShootState_To_v1alpha1_ShootState(in, out, s)
}

func autoConvert_v1alpha1_ShootStateList_To_core_ShootStateList(in *ShootStateList, out *core.ShootStateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.ShootState)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ShootStateList_To_core_ShootStateList is an autogenerated conversion function.
func Convert_v1alpha1_ShootStateList_To_core_ShootStateList(in *ShootStateList, out *core.ShootStateList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootStateList_To_core_ShootStateList(in, out, s)
}

func autoConvert_core_ShootStateList_To_v1alpha1_ShootStateList(in *core.ShootStateList, out *ShootStateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ShootState)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_ShootStateList_To_v1alpha1_ShootStateList is an autogenerated conversion function.
func Convert_core_ShootStateList_To_v1alpha1_ShootStateList(in *core.ShootStateList, out *ShootStateList, s conversion.Scope) error {
	return autoConvert_core_ShootStateList_To_v1alpha1_ShootStateList(in, out, s)
}

func autoConvert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec(in *ShootStateSpec, out *core.ShootStateSpec, s conversion.Scope) error {
	out.Gardener = *(*[]core.GardenerResourceData)(unsafe.Pointer(&in.Gardener))
	out.Extensions = *(*[]core.ExtensionResourceState)(unsafe.Pointer(&in.Extensions))
	out.Resources = *(*[]core.ResourceData)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec is an autogenerated conversion function.
func Convert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec(in *ShootStateSpec, out *core.ShootStateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootStateSpec_To_core_ShootStateSpec(in, out, s)
}

func autoConvert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec(in *core.ShootStateSpec, out *ShootStateSpec, s conversion.Scope) error {
	out.Gardener = *(*[]GardenerResourceData)(unsafe.Pointer(&in.Gardener))
	out.Extensions = *(*[]ExtensionResourceState)(unsafe.Pointer(&in.Extensions))
	out.Resources = *(*[]ResourceData)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec is an autogenerated conversion function.
func Convert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec(in *core.ShootStateSpec, out *ShootStateSpec, s conversion.Scope) error {
	return autoConvert_core_ShootStateSpec_To_v1alpha1_ShootStateSpec(in, out, s)
}

func autoConvert_v1alpha1_ShootStatus_To_core_ShootStatus(in *ShootStatus, out *core.ShootStatus, s conversion.Scope) error {
	out.Conditions = *(*[]core.Condition)(unsafe.Pointer(&in.Conditions))
	out.Constraints = *(*[]core.Condition)(unsafe.Pointer(&in.Constraints))
	if err := Convert_v1alpha1_Gardener_To_core_Gardener(&in.Gardener, &out.Gardener, s); err != nil {
		return err
	}
	out.IsHibernated = in.IsHibernated
	out.LastOperation = (*core.LastOperation)(unsafe.Pointer(in.LastOperation))
	// WARNING: in.LastError requires manual conversion: does not exist in peer-type
	out.LastErrors = *(*[]core.LastError)(unsafe.Pointer(&in.LastErrors))
	out.ObservedGeneration = in.ObservedGeneration
	out.RetryCycleStartTime = (*metav1.Time)(unsafe.Pointer(in.RetryCycleStartTime))
	// WARNING: in.Seed requires manual conversion: does not exist in peer-type
	out.TechnicalID = in.TechnicalID
	out.UID = types.UID(in.UID)
	out.ClusterIdentity = (*string)(unsafe.Pointer(in.ClusterIdentity))
	return nil
}

func autoConvert_core_ShootStatus_To_v1alpha1_ShootStatus(in *core.ShootStatus, out *ShootStatus, s conversion.Scope) error {
	out.Conditions = *(*[]Condition)(unsafe.Pointer(&in.Conditions))
	out.Constraints = *(*[]Condition)(unsafe.Pointer(&in.Constraints))
	if err := Convert_core_Gardener_To_v1alpha1_Gardener(&in.Gardener, &out.Gardener, s); err != nil {
		return err
	}
	out.IsHibernated = in.IsHibernated
	out.LastOperation = (*LastOperation)(unsafe.Pointer(in.LastOperation))
	out.LastErrors = *(*[]LastError)(unsafe.Pointer(&in.LastErrors))
	out.ObservedGeneration = in.ObservedGeneration
	out.RetryCycleStartTime = (*metav1.Time)(unsafe.Pointer(in.RetryCycleStartTime))
	// WARNING: in.SeedName requires manual conversion: does not exist in peer-type
	out.TechnicalID = in.TechnicalID
	out.UID = types.UID(in.UID)
	out.ClusterIdentity = (*string)(unsafe.Pointer(in.ClusterIdentity))
	return nil
}

func autoConvert_v1alpha1_Toleration_To_core_Toleration(in *Toleration, out *core.Toleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = (*string)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_v1alpha1_Toleration_To_core_Toleration is an autogenerated conversion function.
func Convert_v1alpha1_Toleration_To_core_Toleration(in *Toleration, out *core.Toleration, s conversion.Scope) error {
	return autoConvert_v1alpha1_Toleration_To_core_Toleration(in, out, s)
}

func autoConvert_core_Toleration_To_v1alpha1_Toleration(in *core.Toleration, out *Toleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = (*string)(unsafe.Pointer(in.Value))
	return nil
}

// Convert_core_Toleration_To_v1alpha1_Toleration is an autogenerated conversion function.
func Convert_core_Toleration_To_v1alpha1_Toleration(in *core.Toleration, out *Toleration, s conversion.Scope) error {
	return autoConvert_core_Toleration_To_v1alpha1_Toleration(in, out, s)
}

func autoConvert_v1alpha1_VerticalPodAutoscaler_To_core_VerticalPodAutoscaler(in *VerticalPodAutoscaler, out *core.VerticalPodAutoscaler, s conversion.Scope) error {
	out.Enabled = in.Enabled
	out.EvictAfterOOMThreshold = (*metav1.Duration)(unsafe.Pointer(in.EvictAfterOOMThreshold))
	out.EvictionRateBurst = (*int32)(unsafe.Pointer(in.EvictionRateBurst))
	out.EvictionRateLimit = (*float64)(unsafe.Pointer(in.EvictionRateLimit))
	out.EvictionTolerance = (*float64)(unsafe.Pointer(in.EvictionTolerance))
	out.RecommendationMarginFraction = (*float64)(unsafe.Pointer(in.RecommendationMarginFraction))
	out.UpdaterInterval = (*metav1.Duration)(unsafe.Pointer(in.UpdaterInterval))
	out.RecommenderInterval = (*metav1.Duration)(unsafe.Pointer(in.RecommenderInterval))
	return nil
}

// Convert_v1alpha1_VerticalPodAutoscaler_To_core_VerticalPodAutoscaler is an autogenerated conversion function.
func Convert_v1alpha1_VerticalPodAutoscaler_To_core_VerticalPodAutoscaler(in *VerticalPodAutoscaler, out *core.VerticalPodAutoscaler, s conversion.Scope) error {
	return autoConvert_v1alpha1_VerticalPodAutoscaler_To_core_VerticalPodAutoscaler(in, out, s)
}

func autoConvert_core_VerticalPodAutoscaler_To_v1alpha1_VerticalPodAutoscaler(in *core.VerticalPodAutoscaler, out *VerticalPodAutoscaler, s conversion.Scope) error {
	out.Enabled = in.Enabled
	out.EvictAfterOOMThreshold = (*metav1.Duration)(unsafe.Pointer(in.EvictAfterOOMThreshold))
	out.EvictionRateBurst = (*int32)(unsafe.Pointer(in.EvictionRateBurst))
	out.EvictionRateLimit = (*float64)(unsafe.Pointer(in.EvictionRateLimit))
	out.EvictionTolerance = (*float64)(unsafe.Pointer(in.EvictionTolerance))
	out.RecommendationMarginFraction = (*float64)(unsafe.Pointer(in.RecommendationMarginFraction))
	out.UpdaterInterval = (*metav1.Duration)(unsafe.Pointer(in.UpdaterInterval))
	out.RecommenderInterval = (*metav1.Duration)(unsafe.Pointer(in.RecommenderInterval))
	return nil
}

// Convert_core_VerticalPodAutoscaler_To_v1alpha1_VerticalPodAutoscaler is an autogenerated conversion function.
func Convert_core_VerticalPodAutoscaler_To_v1alpha1_VerticalPodAutoscaler(in *core.VerticalPodAutoscaler, out *VerticalPodAutoscaler, s conversion.Scope) error {
	return autoConvert_core_VerticalPodAutoscaler_To_v1alpha1_VerticalPodAutoscaler(in, out, s)
}

func autoConvert_v1alpha1_Volume_To_core_Volume(in *Volume, out *core.Volume, s conversion.Scope) error {
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.VolumeSize = in.VolumeSize
	out.Encrypted = (*bool)(unsafe.Pointer(in.Encrypted))
	return nil
}

// Convert_v1alpha1_Volume_To_core_Volume is an autogenerated conversion function.
func Convert_v1alpha1_Volume_To_core_Volume(in *Volume, out *core.Volume, s conversion.Scope) error {
	return autoConvert_v1alpha1_Volume_To_core_Volume(in, out, s)
}

func autoConvert_core_Volume_To_v1alpha1_Volume(in *core.Volume, out *Volume, s conversion.Scope) error {
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Type = (*string)(unsafe.Pointer(in.Type))
	out.VolumeSize = in.VolumeSize
	out.Encrypted = (*bool)(unsafe.Pointer(in.Encrypted))
	return nil
}

// Convert_core_Volume_To_v1alpha1_Volume is an autogenerated conversion function.
func Convert_core_Volume_To_v1alpha1_Volume(in *core.Volume, out *Volume, s conversion.Scope) error {
	return autoConvert_core_Volume_To_v1alpha1_Volume(in, out, s)
}

func autoConvert_v1alpha1_VolumeType_To_core_VolumeType(in *VolumeType, out *core.VolumeType, s conversion.Scope) error {
	out.Class = in.Class
	out.Name = in.Name
	out.Usable = (*bool)(unsafe.Pointer(in.Usable))
	return nil
}

// Convert_v1alpha1_VolumeType_To_core_VolumeType is an autogenerated conversion function.
func Convert_v1alpha1_VolumeType_To_core_VolumeType(in *VolumeType, out *core.VolumeType, s conversion.Scope) error {
	return autoConvert_v1alpha1_VolumeType_To_core_VolumeType(in, out, s)
}

func autoConvert_core_VolumeType_To_v1alpha1_VolumeType(in *core.VolumeType, out *VolumeType, s conversion.Scope) error {
	out.Class = in.Class
	out.Name = in.Name
	out.Usable = (*bool)(unsafe.Pointer(in.Usable))
	return nil
}

// Convert_core_VolumeType_To_v1alpha1_VolumeType is an autogenerated conversion function.
func Convert_core_VolumeType_To_v1alpha1_VolumeType(in *core.VolumeType, out *VolumeType, s conversion.Scope) error {
	return autoConvert_core_VolumeType_To_v1alpha1_VolumeType(in, out, s)
}

func autoConvert_v1alpha1_WatchCacheSizes_To_core_WatchCacheSizes(in *WatchCacheSizes, out *core.WatchCacheSizes, s conversion.Scope) error {
	out.Default = (*int32)(unsafe.Pointer(in.Default))
	out.Resources = *(*[]core.ResourceWatchCacheSize)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_v1alpha1_WatchCacheSizes_To_core_WatchCacheSizes is an autogenerated conversion function.
func Convert_v1alpha1_WatchCacheSizes_To_core_WatchCacheSizes(in *WatchCacheSizes, out *core.WatchCacheSizes, s conversion.Scope) error {
	return autoConvert_v1alpha1_WatchCacheSizes_To_core_WatchCacheSizes(in, out, s)
}

func autoConvert_core_WatchCacheSizes_To_v1alpha1_WatchCacheSizes(in *core.WatchCacheSizes, out *WatchCacheSizes, s conversion.Scope) error {
	out.Default = (*int32)(unsafe.Pointer(in.Default))
	out.Resources = *(*[]ResourceWatchCacheSize)(unsafe.Pointer(&in.Resources))
	return nil
}

// Convert_core_WatchCacheSizes_To_v1alpha1_WatchCacheSizes is an autogenerated conversion function.
func Convert_core_WatchCacheSizes_To_v1alpha1_WatchCacheSizes(in *core.WatchCacheSizes, out *WatchCacheSizes, s conversion.Scope) error {
	return autoConvert_core_WatchCacheSizes_To_v1alpha1_WatchCacheSizes(in, out, s)
}

func autoConvert_v1alpha1_Worker_To_core_Worker(in *Worker, out *core.Worker, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	out.CRI = (*core.CRI)(unsafe.Pointer(in.CRI))
	out.Kubernetes = (*core.WorkerKubernetes)(unsafe.Pointer(in.Kubernetes))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Name = in.Name
	if err := Convert_v1alpha1_Machine_To_core_Machine(&in.Machine, &out.Machine, s); err != nil {
		return err
	}
	out.Maximum = in.Maximum
	out.Minimum = in.Minimum
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.Taints = *(*[]v1.Taint)(unsafe.Pointer(&in.Taints))
	out.Volume = (*core.Volume)(unsafe.Pointer(in.Volume))
	out.DataVolumes = *(*[]core.DataVolume)(unsafe.Pointer(&in.DataVolumes))
	out.KubeletDataVolumeName = (*string)(unsafe.Pointer(in.KubeletDataVolumeName))
	out.Zones = *(*[]string)(unsafe.Pointer(&in.Zones))
	out.SystemComponents = (*core.WorkerSystemComponents)(unsafe.Pointer(in.SystemComponents))
	out.MachineControllerManagerSettings = (*core.MachineControllerManagerSettings)(unsafe.Pointer(in.MachineControllerManagerSettings))
	return nil
}

// Convert_v1alpha1_Worker_To_core_Worker is an autogenerated conversion function.
func Convert_v1alpha1_Worker_To_core_Worker(in *Worker, out *core.Worker, s conversion.Scope) error {
	return autoConvert_v1alpha1_Worker_To_core_Worker(in, out, s)
}

func autoConvert_core_Worker_To_v1alpha1_Worker(in *core.Worker, out *Worker, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.CABundle = (*string)(unsafe.Pointer(in.CABundle))
	out.CRI = (*CRI)(unsafe.Pointer(in.CRI))
	out.Kubernetes = (*WorkerKubernetes)(unsafe.Pointer(in.Kubernetes))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Name = in.Name
	if err := Convert_core_Machine_To_v1alpha1_Machine(&in.Machine, &out.Machine, s); err != nil {
		return err
	}
	out.Maximum = in.Maximum
	out.Minimum = in.Minimum
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.ProviderConfig = (*runtime.RawExtension)(unsafe.Pointer(in.ProviderConfig))
	out.SystemComponents = (*WorkerSystemComponents)(unsafe.Pointer(in.SystemComponents))
	out.Taints = *(*[]v1.Taint)(unsafe.Pointer(&in.Taints))
	out.Volume = (*Volume)(unsafe.Pointer(in.Volume))
	out.DataVolumes = *(*[]DataVolume)(unsafe.Pointer(&in.DataVolumes))
	out.KubeletDataVolumeName = (*string)(unsafe.Pointer(in.KubeletDataVolumeName))
	out.Zones = *(*[]string)(unsafe.Pointer(&in.Zones))
	out.MachineControllerManagerSettings = (*MachineControllerManagerSettings)(unsafe.Pointer(in.MachineControllerManagerSettings))
	return nil
}

// Convert_core_Worker_To_v1alpha1_Worker is an autogenerated conversion function.
func Convert_core_Worker_To_v1alpha1_Worker(in *core.Worker, out *Worker, s conversion.Scope) error {
	return autoConvert_core_Worker_To_v1alpha1_Worker(in, out, s)
}

func autoConvert_v1alpha1_WorkerKubernetes_To_core_WorkerKubernetes(in *WorkerKubernetes, out *core.WorkerKubernetes, s conversion.Scope) error {
	out.Kubelet = (*core.KubeletConfig)(unsafe.Pointer(in.Kubelet))
	return nil
}

// Convert_v1alpha1_WorkerKubernetes_To_core_WorkerKubernetes is an autogenerated conversion function.
func Convert_v1alpha1_WorkerKubernetes_To_core_WorkerKubernetes(in *WorkerKubernetes, out *core.WorkerKubernetes, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkerKubernetes_To_core_WorkerKubernetes(in, out, s)
}

func autoConvert_core_WorkerKubernetes_To_v1alpha1_WorkerKubernetes(in *core.WorkerKubernetes, out *WorkerKubernetes, s conversion.Scope) error {
	out.Kubelet = (*KubeletConfig)(unsafe.Pointer(in.Kubelet))
	return nil
}

// Convert_core_WorkerKubernetes_To_v1alpha1_WorkerKubernetes is an autogenerated conversion function.
func Convert_core_WorkerKubernetes_To_v1alpha1_WorkerKubernetes(in *core.WorkerKubernetes, out *WorkerKubernetes, s conversion.Scope) error {
	return autoConvert_core_WorkerKubernetes_To_v1alpha1_WorkerKubernetes(in, out, s)
}

func autoConvert_v1alpha1_WorkerSystemComponents_To_core_WorkerSystemComponents(in *WorkerSystemComponents, out *core.WorkerSystemComponents, s conversion.Scope) error {
	out.Allow = in.Allow
	return nil
}

// Convert_v1alpha1_WorkerSystemComponents_To_core_WorkerSystemComponents is an autogenerated conversion function.
func Convert_v1alpha1_WorkerSystemComponents_To_core_WorkerSystemComponents(in *WorkerSystemComponents, out *core.WorkerSystemComponents, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkerSystemComponents_To_core_WorkerSystemComponents(in, out, s)
}

func autoConvert_core_WorkerSystemComponents_To_v1alpha1_WorkerSystemComponents(in *core.WorkerSystemComponents, out *WorkerSystemComponents, s conversion.Scope) error {
	out.Allow = in.Allow
	return nil
}

// Convert_core_WorkerSystemComponents_To_v1alpha1_WorkerSystemComponents is an autogenerated conversion function.
func Convert_core_WorkerSystemComponents_To_v1alpha1_WorkerSystemComponents(in *core.WorkerSystemComponents, out *WorkerSystemComponents, s conversion.Scope) error {
	return autoConvert_core_WorkerSystemComponents_To_v1alpha1_WorkerSystemComponents(in, out, s)
}
