/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package eviction

import (
	"context"

	mock "github.com/stretchr/testify/mock"
	"k8s.io/klog/v2"
	"k8s.io/kubelet/pkg/apis/stats/v1alpha1"
)

// NewMockCgroupNotifier creates a new instance of MockCgroupNotifier. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockCgroupNotifier(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockCgroupNotifier {
	mock := &MockCgroupNotifier{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockCgroupNotifier is an autogenerated mock type for the CgroupNotifier type
type MockCgroupNotifier struct {
	mock.Mock
}

type MockCgroupNotifier_Expecter struct {
	mock *mock.Mock
}

func (_m *MockCgroupNotifier) EXPECT() *MockCgroupNotifier_Expecter {
	return &MockCgroupNotifier_Expecter{mock: &_m.Mock}
}

// Start provides a mock function for the type MockCgroupNotifier
func (_mock *MockCgroupNotifier) Start(ctx context.Context, eventCh chan<- struct{}) {
	_mock.Called(ctx, eventCh)
	return
}

// MockCgroupNotifier_Start_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Start'
type MockCgroupNotifier_Start_Call struct {
	*mock.Call
}

// Start is a helper method to define mock.On call
//   - ctx context.Context
//   - eventCh chan<- struct{}
func (_e *MockCgroupNotifier_Expecter) Start(ctx interface{}, eventCh interface{}) *MockCgroupNotifier_Start_Call {
	return &MockCgroupNotifier_Start_Call{Call: _e.mock.On("Start", ctx, eventCh)}
}

func (_c *MockCgroupNotifier_Start_Call) Run(run func(ctx context.Context, eventCh chan<- struct{})) *MockCgroupNotifier_Start_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 chan<- struct{}
		if args[1] != nil {
			arg1 = args[1].(chan<- struct{})
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockCgroupNotifier_Start_Call) Return() *MockCgroupNotifier_Start_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockCgroupNotifier_Start_Call) RunAndReturn(run func(ctx context.Context, eventCh chan<- struct{})) *MockCgroupNotifier_Start_Call {
	_c.Run(run)
	return _c
}

// Stop provides a mock function for the type MockCgroupNotifier
func (_mock *MockCgroupNotifier) Stop() {
	_mock.Called()
	return
}

// MockCgroupNotifier_Stop_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Stop'
type MockCgroupNotifier_Stop_Call struct {
	*mock.Call
}

// Stop is a helper method to define mock.On call
func (_e *MockCgroupNotifier_Expecter) Stop() *MockCgroupNotifier_Stop_Call {
	return &MockCgroupNotifier_Stop_Call{Call: _e.mock.On("Stop")}
}

func (_c *MockCgroupNotifier_Stop_Call) Run(run func()) *MockCgroupNotifier_Stop_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockCgroupNotifier_Stop_Call) Return() *MockCgroupNotifier_Stop_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockCgroupNotifier_Stop_Call) RunAndReturn(run func()) *MockCgroupNotifier_Stop_Call {
	_c.Run(run)
	return _c
}

// NewMockNotifierFactory creates a new instance of MockNotifierFactory. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockNotifierFactory(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockNotifierFactory {
	mock := &MockNotifierFactory{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockNotifierFactory is an autogenerated mock type for the NotifierFactory type
type MockNotifierFactory struct {
	mock.Mock
}

type MockNotifierFactory_Expecter struct {
	mock *mock.Mock
}

func (_m *MockNotifierFactory) EXPECT() *MockNotifierFactory_Expecter {
	return &MockNotifierFactory_Expecter{mock: &_m.Mock}
}

// NewCgroupNotifier provides a mock function for the type MockNotifierFactory
func (_mock *MockNotifierFactory) NewCgroupNotifier(logger klog.Logger, path string, attribute string, threshold int64) (CgroupNotifier, error) {
	ret := _mock.Called(logger, path, attribute, threshold)

	if len(ret) == 0 {
		panic("no return value specified for NewCgroupNotifier")
	}

	var r0 CgroupNotifier
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, string, string, int64) (CgroupNotifier, error)); ok {
		return returnFunc(logger, path, attribute, threshold)
	}
	if returnFunc, ok := ret.Get(0).(func(klog.Logger, string, string, int64) CgroupNotifier); ok {
		r0 = returnFunc(logger, path, attribute, threshold)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(CgroupNotifier)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(klog.Logger, string, string, int64) error); ok {
		r1 = returnFunc(logger, path, attribute, threshold)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNotifierFactory_NewCgroupNotifier_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NewCgroupNotifier'
type MockNotifierFactory_NewCgroupNotifier_Call struct {
	*mock.Call
}

// NewCgroupNotifier is a helper method to define mock.On call
//   - logger klog.Logger
//   - path string
//   - attribute string
//   - threshold int64
func (_e *MockNotifierFactory_Expecter) NewCgroupNotifier(logger interface{}, path interface{}, attribute interface{}, threshold interface{}) *MockNotifierFactory_NewCgroupNotifier_Call {
	return &MockNotifierFactory_NewCgroupNotifier_Call{Call: _e.mock.On("NewCgroupNotifier", logger, path, attribute, threshold)}
}

func (_c *MockNotifierFactory_NewCgroupNotifier_Call) Run(run func(logger klog.Logger, path string, attribute string, threshold int64)) *MockNotifierFactory_NewCgroupNotifier_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 klog.Logger
		if args[0] != nil {
			arg0 = args[0].(klog.Logger)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		var arg3 int64
		if args[3] != nil {
			arg3 = args[3].(int64)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
		)
	})
	return _c
}

func (_c *MockNotifierFactory_NewCgroupNotifier_Call) Return(cgroupNotifier CgroupNotifier, err error) *MockNotifierFactory_NewCgroupNotifier_Call {
	_c.Call.Return(cgroupNotifier, err)
	return _c
}

func (_c *MockNotifierFactory_NewCgroupNotifier_Call) RunAndReturn(run func(logger klog.Logger, path string, attribute string, threshold int64) (CgroupNotifier, error)) *MockNotifierFactory_NewCgroupNotifier_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockThresholdNotifier creates a new instance of MockThresholdNotifier. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockThresholdNotifier(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockThresholdNotifier {
	mock := &MockThresholdNotifier{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockThresholdNotifier is an autogenerated mock type for the ThresholdNotifier type
type MockThresholdNotifier struct {
	mock.Mock
}

type MockThresholdNotifier_Expecter struct {
	mock *mock.Mock
}

func (_m *MockThresholdNotifier) EXPECT() *MockThresholdNotifier_Expecter {
	return &MockThresholdNotifier_Expecter{mock: &_m.Mock}
}

// Description provides a mock function for the type MockThresholdNotifier
func (_mock *MockThresholdNotifier) Description() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Description")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockThresholdNotifier_Description_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Description'
type MockThresholdNotifier_Description_Call struct {
	*mock.Call
}

// Description is a helper method to define mock.On call
func (_e *MockThresholdNotifier_Expecter) Description() *MockThresholdNotifier_Description_Call {
	return &MockThresholdNotifier_Description_Call{Call: _e.mock.On("Description")}
}

func (_c *MockThresholdNotifier_Description_Call) Run(run func()) *MockThresholdNotifier_Description_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockThresholdNotifier_Description_Call) Return(s string) *MockThresholdNotifier_Description_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockThresholdNotifier_Description_Call) RunAndReturn(run func() string) *MockThresholdNotifier_Description_Call {
	_c.Call.Return(run)
	return _c
}

// Start provides a mock function for the type MockThresholdNotifier
func (_mock *MockThresholdNotifier) Start(ctx context.Context) {
	_mock.Called(ctx)
	return
}

// MockThresholdNotifier_Start_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Start'
type MockThresholdNotifier_Start_Call struct {
	*mock.Call
}

// Start is a helper method to define mock.On call
//   - ctx context.Context
func (_e *MockThresholdNotifier_Expecter) Start(ctx interface{}) *MockThresholdNotifier_Start_Call {
	return &MockThresholdNotifier_Start_Call{Call: _e.mock.On("Start", ctx)}
}

func (_c *MockThresholdNotifier_Start_Call) Run(run func(ctx context.Context)) *MockThresholdNotifier_Start_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockThresholdNotifier_Start_Call) Return() *MockThresholdNotifier_Start_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockThresholdNotifier_Start_Call) RunAndReturn(run func(ctx context.Context)) *MockThresholdNotifier_Start_Call {
	_c.Run(run)
	return _c
}

// UpdateThreshold provides a mock function for the type MockThresholdNotifier
func (_mock *MockThresholdNotifier) UpdateThreshold(ctx context.Context, summary *v1alpha1.Summary) error {
	ret := _mock.Called(ctx, summary)

	if len(ret) == 0 {
		panic("no return value specified for UpdateThreshold")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *v1alpha1.Summary) error); ok {
		r0 = returnFunc(ctx, summary)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockThresholdNotifier_UpdateThreshold_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateThreshold'
type MockThresholdNotifier_UpdateThreshold_Call struct {
	*mock.Call
}

// UpdateThreshold is a helper method to define mock.On call
//   - ctx context.Context
//   - summary *v1alpha1.Summary
func (_e *MockThresholdNotifier_Expecter) UpdateThreshold(ctx interface{}, summary interface{}) *MockThresholdNotifier_UpdateThreshold_Call {
	return &MockThresholdNotifier_UpdateThreshold_Call{Call: _e.mock.On("UpdateThreshold", ctx, summary)}
}

func (_c *MockThresholdNotifier_UpdateThreshold_Call) Run(run func(ctx context.Context, summary *v1alpha1.Summary)) *MockThresholdNotifier_UpdateThreshold_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *v1alpha1.Summary
		if args[1] != nil {
			arg1 = args[1].(*v1alpha1.Summary)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockThresholdNotifier_UpdateThreshold_Call) Return(err error) *MockThresholdNotifier_UpdateThreshold_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockThresholdNotifier_UpdateThreshold_Call) RunAndReturn(run func(ctx context.Context, summary *v1alpha1.Summary) error) *MockThresholdNotifier_UpdateThreshold_Call {
	_c.Call.Return(run)
	return _c
}
