//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package crosspkg

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	other "k8s.io/code-generator/cmd/validation-gen/output_tests/_codegenignore/other"
	primitives "k8s.io/code-generator/cmd/validation-gen/output_tests/primitives"
	typedefs "k8s.io/code-generator/cmd/validation-gen/output_tests/typedefs"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	scheme.AddValidationFunc((*T1)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}, subresources ...string) field.ErrorList {
		if len(subresources) == 0 {
			return Validate_T1(ctx, op, nil /* fldPath */, obj.(*T1), safe.Cast[*T1](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresources: %v", obj, subresources))}
	})
	return nil
}

func Validate_T1(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *T1) (errs field.ErrorList) {
	// field T1.TypeMeta has no validation

	// field T1.PrimitivesT1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT1")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("primitivest1"), &obj.PrimitivesT1, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return &oldObj.PrimitivesT1 }))...)

	// field T1.PrimitivesT1Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT1Ptr")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("primitivest1Ptr"), obj.PrimitivesT1Ptr, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return oldObj.PrimitivesT1Ptr }))...)

	// field T1.PrimitivesT2
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T2) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT2")...)
			errs = append(errs, primitives.Validate_T2(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("primitivest2"), &obj.PrimitivesT2, safe.Field(oldObj, func(oldObj *T1) *primitives.T2 { return &oldObj.PrimitivesT2 }))...)

	// field T1.PrimitivesT2Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT2Ptr")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("primitivest2Ptr"), obj.PrimitivesT2Ptr, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return oldObj.PrimitivesT2Ptr }))...)

	// field T1.PrimitivesT3
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T3) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT3")...)
			return
		}(fldPath.Child("primitivest3"), &obj.PrimitivesT3, safe.Field(oldObj, func(oldObj *T1) *primitives.T3 { return &oldObj.PrimitivesT3 }))...)

	// field T1.PrimitivesT3Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *primitives.T1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.PrimitivesT3Ptr")...)
			errs = append(errs, primitives.Validate_T1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("primitivest3Ptr"), obj.PrimitivesT3Ptr, safe.Field(oldObj, func(oldObj *T1) *primitives.T1 { return oldObj.PrimitivesT3Ptr }))...)

	// field T1.TypedefsE1
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE1")...)
			errs = append(errs, typedefs.Validate_E1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse1"), &obj.TypedefsE1, safe.Field(oldObj, func(oldObj *T1) *typedefs.E1 { return &oldObj.TypedefsE1 }))...)

	// field T1.TypedefsE1Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E1) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE1Ptr")...)
			errs = append(errs, typedefs.Validate_E1(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse1Ptr"), obj.TypedefsE1Ptr, safe.Field(oldObj, func(oldObj *T1) *typedefs.E1 { return oldObj.TypedefsE1Ptr }))...)

	// field T1.TypedefsE2
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E2) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE2")...)
			errs = append(errs, typedefs.Validate_E2(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse2"), &obj.TypedefsE2, safe.Field(oldObj, func(oldObj *T1) *typedefs.E2 { return &oldObj.TypedefsE2 }))...)

	// field T1.TypedefsE2Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E2) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE2Ptr")...)
			errs = append(errs, typedefs.Validate_E2(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse2Ptr"), obj.TypedefsE2Ptr, safe.Field(oldObj, func(oldObj *T1) *typedefs.E2 { return oldObj.TypedefsE2Ptr }))...)

	// field T1.TypedefsE3
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E3) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE3")...)
			errs = append(errs, typedefs.Validate_E3(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse3"), &obj.TypedefsE3, safe.Field(oldObj, func(oldObj *T1) *typedefs.E3 { return &oldObj.TypedefsE3 }))...)

	// field T1.TypedefsE3Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E3) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE3Ptr")...)
			errs = append(errs, typedefs.Validate_E3(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse3Ptr"), obj.TypedefsE3Ptr, safe.Field(oldObj, func(oldObj *T1) *typedefs.E3 { return oldObj.TypedefsE3Ptr }))...)

	// field T1.TypedefsE4
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E4) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE4")...)
			errs = append(errs, typedefs.Validate_E4(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse4"), &obj.TypedefsE4, safe.Field(oldObj, func(oldObj *T1) *typedefs.E4 { return &oldObj.TypedefsE4 }))...)

	// field T1.TypedefsE4Ptr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *typedefs.E4) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.TypedefsE4Ptr")...)
			errs = append(errs, typedefs.Validate_E4(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("typedefse4Ptr"), obj.TypedefsE4Ptr, safe.Field(oldObj, func(oldObj *T1) *typedefs.E4 { return oldObj.TypedefsE4Ptr }))...)

	// field T1.OtherString
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.StringType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherString")...)
			return
		}(fldPath.Child("otherString"), &obj.OtherString, safe.Field(oldObj, func(oldObj *T1) *other.StringType { return &oldObj.OtherString }))...)

	// field T1.OtherStringPtr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.StringType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherStringPtr")...)
			return
		}(fldPath.Child("otherStringPtr"), obj.OtherStringPtr, safe.Field(oldObj, func(oldObj *T1) *other.StringType { return oldObj.OtherStringPtr }))...)

	// field T1.OtherInt
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.IntType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherInt")...)
			return
		}(fldPath.Child("otherInt"), &obj.OtherInt, safe.Field(oldObj, func(oldObj *T1) *other.IntType { return &oldObj.OtherInt }))...)

	// field T1.OtherIntPtr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.IntType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherIntPtr")...)
			return
		}(fldPath.Child("otherIntPtr"), obj.OtherIntPtr, safe.Field(oldObj, func(oldObj *T1) *other.IntType { return oldObj.OtherIntPtr }))...)

	// field T1.OtherStruct
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.StructType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherStruct")...)
			return
		}(fldPath.Child("otherStruct"), &obj.OtherStruct, safe.Field(oldObj, func(oldObj *T1) *other.StructType { return &oldObj.OtherStruct }))...)

	// field T1.OtherStructPtr
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *other.StructType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.OtherStructPtr")...)
			return
		}(fldPath.Child("otherStructPtr"), obj.OtherStructPtr, safe.Field(oldObj, func(oldObj *T1) *other.StructType { return oldObj.OtherStructPtr }))...)

	// field T1.SliceOfOtherStruct
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []other.StructType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.SliceOfOtherStruct")...)
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *other.StructType) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.SliceOfOtherStruct values")
			})...)
			return
		}(fldPath.Child("sliceOfOtherStruct"), obj.SliceOfOtherStruct, safe.Field(oldObj, func(oldObj *T1) []other.StructType { return oldObj.SliceOfOtherStruct }))...)

	// field T1.ListMapOfOtherStruct
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []other.StructType) (errs field.ErrorList) {
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.ListMapOfOtherStruct")...)
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, func(a other.StructType, b other.StructType) bool { return a.StringField == b.StringField }, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *other.StructType) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.SliceOfOtherStruct values")
			})...)
			return
		}(fldPath.Child("listMapOfOtherStruct"), obj.ListMapOfOtherStruct, safe.Field(oldObj, func(oldObj *T1) []other.StructType { return oldObj.ListMapOfOtherStruct }))...)

	// field T1.MapOfOtherStringToOtherStruct
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[other.StringType]other.StructType) (errs field.ErrorList) {
			errs = append(errs, validate.EachMapKey(ctx, op, fldPath, obj, oldObj, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *other.StringType) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.MapOfOtherStringToOtherStruct keys")
			})...)
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.MapOfOtherStringToOtherStruct")...)
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *other.StructType) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, true, "field T1.MapOfOtherStringToOtherStruct values")
			})...)
			return
		}(fldPath.Child("mapOfOtherStringToOtherStruct"), obj.MapOfOtherStringToOtherStruct, safe.Field(oldObj, func(oldObj *T1) map[other.StringType]other.StructType { return oldObj.MapOfOtherStringToOtherStruct }))...)

	return errs
}
