// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes a System Integrity Protection (SIP) modification task or volume
// ownership delegation task for an Amazon EC2 Mac instance. For more information,
// see [Configure SIP for Amazon EC2 instances]in the Amazon EC2 User Guide.
//
// [Configure SIP for Amazon EC2 instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-configure
func (c *Client) DescribeMacModificationTasks(ctx context.Context, params *DescribeMacModificationTasksInput, optFns ...func(*Options)) (*DescribeMacModificationTasksOutput, error) {
	if params == nil {
		params = &DescribeMacModificationTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMacModificationTasks", params, optFns, c.addOperationDescribeMacModificationTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMacModificationTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMacModificationTasksInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Specifies one or more filters for the request:
	//
	//   - instance-id - The ID of the instance for which the task was created.
	//
	//   - task-state - The state of the task ( successful | failed | in-progress |
	//   pending ).
	//
	//   - mac-system-integrity-protection-configuration.sip-status - The overall SIP
	//   state requested in the task ( enabled | disabled ).
	//
	//   - start-time - The date and time the task was created.
	//
	//   - task-type - The type of task ( sip-modification |
	//   volume-ownership-delegation ).
	Filters []types.Filter

	// The ID of task.
	MacModificationTaskIds []string

	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error.
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeMacModificationTasksOutput struct {

	// Information about the tasks.
	MacModificationTasks []types.MacModificationTask

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMacModificationTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeMacModificationTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeMacModificationTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMacModificationTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMacModificationTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeMacModificationTasksPaginatorOptions is the paginator options for
// DescribeMacModificationTasks
type DescribeMacModificationTasksPaginatorOptions struct {
	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMacModificationTasksPaginator is a paginator for
// DescribeMacModificationTasks
type DescribeMacModificationTasksPaginator struct {
	options   DescribeMacModificationTasksPaginatorOptions
	client    DescribeMacModificationTasksAPIClient
	params    *DescribeMacModificationTasksInput
	nextToken *string
	firstPage bool
}

// NewDescribeMacModificationTasksPaginator returns a new
// DescribeMacModificationTasksPaginator
func NewDescribeMacModificationTasksPaginator(client DescribeMacModificationTasksAPIClient, params *DescribeMacModificationTasksInput, optFns ...func(*DescribeMacModificationTasksPaginatorOptions)) *DescribeMacModificationTasksPaginator {
	if params == nil {
		params = &DescribeMacModificationTasksInput{}
	}

	options := DescribeMacModificationTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMacModificationTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMacModificationTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMacModificationTasks page.
func (p *DescribeMacModificationTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMacModificationTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeMacModificationTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeMacModificationTasksAPIClient is a client that implements the
// DescribeMacModificationTasks operation.
type DescribeMacModificationTasksAPIClient interface {
	DescribeMacModificationTasks(context.Context, *DescribeMacModificationTasksInput, ...func(*Options)) (*DescribeMacModificationTasksOutput, error)
}

var _ DescribeMacModificationTasksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeMacModificationTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMacModificationTasks",
	}
}
