/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package internalversion

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	scheme "k8s.io/kops/pkg/client/clientset_generated/clientset/scheme"
)

// SSHCredentialsGetter has a method to return a SSHCredentialInterface.
// A group's client should implement this interface.
type SSHCredentialsGetter interface {
	SSHCredentials(namespace string) SSHCredentialInterface
}

// SSHCredentialInterface has methods to work with SSHCredential resources.
type SSHCredentialInterface interface {
	Create(ctx context.Context, sSHCredential *kops.SSHCredential, opts v1.CreateOptions) (*kops.SSHCredential, error)
	Update(ctx context.Context, sSHCredential *kops.SSHCredential, opts v1.UpdateOptions) (*kops.SSHCredential, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kops.SSHCredential, error)
	List(ctx context.Context, opts v1.ListOptions) (*kops.SSHCredentialList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kops.SSHCredential, err error)
	SSHCredentialExpansion
}

// sSHCredentials implements SSHCredentialInterface
type sSHCredentials struct {
	*gentype.ClientWithList[*kops.SSHCredential, *kops.SSHCredentialList]
}

// newSSHCredentials returns a SSHCredentials
func newSSHCredentials(c *KopsClient, namespace string) *sSHCredentials {
	return &sSHCredentials{
		gentype.NewClientWithList[*kops.SSHCredential, *kops.SSHCredentialList](
			"sshcredentials",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kops.SSHCredential { return &kops.SSHCredential{} },
			func() *kops.SSHCredentialList { return &kops.SSHCredentialList{} },
		),
	}
}
