/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	internalversion "k8s.io/kops/pkg/client/clientset_generated/clientset/typed/kops/internalversion"
)

// fakeInstanceGroups implements InstanceGroupInterface
type fakeInstanceGroups struct {
	*gentype.FakeClientWithList[*kops.InstanceGroup, *kops.InstanceGroupList]
	Fake *FakeKops
}

func newFakeInstanceGroups(fake *FakeKops, namespace string) internalversion.InstanceGroupInterface {
	return &fakeInstanceGroups{
		gentype.NewFakeClientWithList[*kops.InstanceGroup, *kops.InstanceGroupList](
			fake.Fake,
			namespace,
			kops.SchemeGroupVersion.WithResource("instancegroups"),
			kops.SchemeGroupVersion.WithKind("InstanceGroup"),
			func() *kops.InstanceGroup { return &kops.InstanceGroup{} },
			func() *kops.InstanceGroupList { return &kops.InstanceGroupList{} },
			func(dst, src *kops.InstanceGroupList) { dst.ListMeta = src.ListMeta },
			func(list *kops.InstanceGroupList) []*kops.InstanceGroup { return gentype.ToPointerSlice(list.Items) },
			func(list *kops.InstanceGroupList, items []*kops.InstanceGroup) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
