/*
Copyright 2023 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by "go run gen/main.go > gen.go". Do not edit
// directly.

package cloud

import (
	"context"
	"fmt"
	"net/http"
	"sync"

	"google.golang.org/api/googleapi"
	"k8s.io/klog/v2"

	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/filter"
	"github.com/GoogleCloudPlatform/k8s-cloud-provider/pkg/cloud/meta"

	computealpha "google.golang.org/api/compute/v0.alpha"
	computebeta "google.golang.org/api/compute/v0.beta"
	computega "google.golang.org/api/compute/v1"
	networkservicesga "google.golang.org/api/networkservices/v1"
	networkservicesbeta "google.golang.org/api/networkservices/v1beta1"
)

func kLogEnabled(level klog.Level) bool {
	return klog.V(level).Enabled() == true
}

// Cloud is an interface for the GCE compute API.
type Cloud interface {
	Addresses() Addresses
	AlphaAddresses() AlphaAddresses
	BetaAddresses() BetaAddresses
	AlphaGlobalAddresses() AlphaGlobalAddresses
	BetaGlobalAddresses() BetaGlobalAddresses
	GlobalAddresses() GlobalAddresses
	BackendServices() BackendServices
	BetaBackendServices() BetaBackendServices
	AlphaBackendServices() AlphaBackendServices
	RegionBackendServices() RegionBackendServices
	AlphaRegionBackendServices() AlphaRegionBackendServices
	BetaRegionBackendServices() BetaRegionBackendServices
	Disks() Disks
	RegionDisks() RegionDisks
	AlphaFirewalls() AlphaFirewalls
	BetaFirewalls() BetaFirewalls
	Firewalls() Firewalls
	AlphaNetworkFirewallPolicies() AlphaNetworkFirewallPolicies
	AlphaRegionNetworkFirewallPolicies() AlphaRegionNetworkFirewallPolicies
	ForwardingRules() ForwardingRules
	AlphaForwardingRules() AlphaForwardingRules
	BetaForwardingRules() BetaForwardingRules
	AlphaGlobalForwardingRules() AlphaGlobalForwardingRules
	BetaGlobalForwardingRules() BetaGlobalForwardingRules
	GlobalForwardingRules() GlobalForwardingRules
	HealthChecks() HealthChecks
	AlphaHealthChecks() AlphaHealthChecks
	BetaHealthChecks() BetaHealthChecks
	AlphaRegionHealthChecks() AlphaRegionHealthChecks
	BetaRegionHealthChecks() BetaRegionHealthChecks
	RegionHealthChecks() RegionHealthChecks
	HttpHealthChecks() HttpHealthChecks
	HttpsHealthChecks() HttpsHealthChecks
	InstanceGroups() InstanceGroups
	Instances() Instances
	BetaInstances() BetaInstances
	AlphaInstances() AlphaInstances
	InstanceGroupManagers() InstanceGroupManagers
	InstanceTemplates() InstanceTemplates
	Images() Images
	BetaImages() BetaImages
	AlphaImages() AlphaImages
	AlphaNetworks() AlphaNetworks
	BetaNetworks() BetaNetworks
	Networks() Networks
	AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups
	BetaNetworkEndpointGroups() BetaNetworkEndpointGroups
	NetworkEndpointGroups() NetworkEndpointGroups
	AlphaGlobalNetworkEndpointGroups() AlphaGlobalNetworkEndpointGroups
	BetaGlobalNetworkEndpointGroups() BetaGlobalNetworkEndpointGroups
	GlobalNetworkEndpointGroups() GlobalNetworkEndpointGroups
	Projects() Projects
	Regions() Regions
	AlphaRouters() AlphaRouters
	BetaRouters() BetaRouters
	Routers() Routers
	Routes() Routes
	BetaSecurityPolicies() BetaSecurityPolicies
	ServiceAttachments() ServiceAttachments
	BetaServiceAttachments() BetaServiceAttachments
	AlphaServiceAttachments() AlphaServiceAttachments
	SslCertificates() SslCertificates
	BetaSslCertificates() BetaSslCertificates
	AlphaSslCertificates() AlphaSslCertificates
	AlphaRegionSslCertificates() AlphaRegionSslCertificates
	BetaRegionSslCertificates() BetaRegionSslCertificates
	RegionSslCertificates() RegionSslCertificates
	SslPolicies() SslPolicies
	RegionSslPolicies() RegionSslPolicies
	AlphaSubnetworks() AlphaSubnetworks
	BetaSubnetworks() BetaSubnetworks
	Subnetworks() Subnetworks
	AlphaTargetHttpProxies() AlphaTargetHttpProxies
	BetaTargetHttpProxies() BetaTargetHttpProxies
	TargetHttpProxies() TargetHttpProxies
	AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies
	BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies
	RegionTargetHttpProxies() RegionTargetHttpProxies
	TargetHttpsProxies() TargetHttpsProxies
	AlphaTargetHttpsProxies() AlphaTargetHttpsProxies
	BetaTargetHttpsProxies() BetaTargetHttpsProxies
	AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies
	BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies
	RegionTargetHttpsProxies() RegionTargetHttpsProxies
	TargetPools() TargetPools
	AlphaTargetTcpProxies() AlphaTargetTcpProxies
	BetaTargetTcpProxies() BetaTargetTcpProxies
	TargetTcpProxies() TargetTcpProxies
	AlphaUrlMaps() AlphaUrlMaps
	BetaUrlMaps() BetaUrlMaps
	UrlMaps() UrlMaps
	AlphaRegionUrlMaps() AlphaRegionUrlMaps
	BetaRegionUrlMaps() BetaRegionUrlMaps
	RegionUrlMaps() RegionUrlMaps
	Zones() Zones
	TcpRoutes() TcpRoutes
	BetaTcpRoutes() BetaTcpRoutes
	Meshes() Meshes
	BetaMeshes() BetaMeshes
}

// NewGCE returns a GCE.
func NewGCE(s *Service) *GCE {
	g := &GCE{
		gceAddresses:                          &GCEAddresses{s},
		gceAlphaAddresses:                     &GCEAlphaAddresses{s},
		gceBetaAddresses:                      &GCEBetaAddresses{s},
		gceAlphaGlobalAddresses:               &GCEAlphaGlobalAddresses{s},
		gceBetaGlobalAddresses:                &GCEBetaGlobalAddresses{s},
		gceGlobalAddresses:                    &GCEGlobalAddresses{s},
		gceBackendServices:                    &GCEBackendServices{s},
		gceBetaBackendServices:                &GCEBetaBackendServices{s},
		gceAlphaBackendServices:               &GCEAlphaBackendServices{s},
		gceRegionBackendServices:              &GCERegionBackendServices{s},
		gceAlphaRegionBackendServices:         &GCEAlphaRegionBackendServices{s},
		gceBetaRegionBackendServices:          &GCEBetaRegionBackendServices{s},
		gceDisks:                              &GCEDisks{s},
		gceRegionDisks:                        &GCERegionDisks{s},
		gceAlphaFirewalls:                     &GCEAlphaFirewalls{s},
		gceBetaFirewalls:                      &GCEBetaFirewalls{s},
		gceFirewalls:                          &GCEFirewalls{s},
		gceAlphaNetworkFirewallPolicies:       &GCEAlphaNetworkFirewallPolicies{s},
		gceAlphaRegionNetworkFirewallPolicies: &GCEAlphaRegionNetworkFirewallPolicies{s},
		gceForwardingRules:                    &GCEForwardingRules{s},
		gceAlphaForwardingRules:               &GCEAlphaForwardingRules{s},
		gceBetaForwardingRules:                &GCEBetaForwardingRules{s},
		gceAlphaGlobalForwardingRules:         &GCEAlphaGlobalForwardingRules{s},
		gceBetaGlobalForwardingRules:          &GCEBetaGlobalForwardingRules{s},
		gceGlobalForwardingRules:              &GCEGlobalForwardingRules{s},
		gceHealthChecks:                       &GCEHealthChecks{s},
		gceAlphaHealthChecks:                  &GCEAlphaHealthChecks{s},
		gceBetaHealthChecks:                   &GCEBetaHealthChecks{s},
		gceAlphaRegionHealthChecks:            &GCEAlphaRegionHealthChecks{s},
		gceBetaRegionHealthChecks:             &GCEBetaRegionHealthChecks{s},
		gceRegionHealthChecks:                 &GCERegionHealthChecks{s},
		gceHttpHealthChecks:                   &GCEHttpHealthChecks{s},
		gceHttpsHealthChecks:                  &GCEHttpsHealthChecks{s},
		gceInstanceGroups:                     &GCEInstanceGroups{s},
		gceInstances:                          &GCEInstances{s},
		gceBetaInstances:                      &GCEBetaInstances{s},
		gceAlphaInstances:                     &GCEAlphaInstances{s},
		gceInstanceGroupManagers:              &GCEInstanceGroupManagers{s},
		gceInstanceTemplates:                  &GCEInstanceTemplates{s},
		gceImages:                             &GCEImages{s},
		gceBetaImages:                         &GCEBetaImages{s},
		gceAlphaImages:                        &GCEAlphaImages{s},
		gceAlphaNetworks:                      &GCEAlphaNetworks{s},
		gceBetaNetworks:                       &GCEBetaNetworks{s},
		gceNetworks:                           &GCENetworks{s},
		gceAlphaNetworkEndpointGroups:         &GCEAlphaNetworkEndpointGroups{s},
		gceBetaNetworkEndpointGroups:          &GCEBetaNetworkEndpointGroups{s},
		gceNetworkEndpointGroups:              &GCENetworkEndpointGroups{s},
		gceAlphaGlobalNetworkEndpointGroups:   &GCEAlphaGlobalNetworkEndpointGroups{s},
		gceBetaGlobalNetworkEndpointGroups:    &GCEBetaGlobalNetworkEndpointGroups{s},
		gceGlobalNetworkEndpointGroups:        &GCEGlobalNetworkEndpointGroups{s},
		gceProjects:                           &GCEProjects{s},
		gceRegions:                            &GCERegions{s},
		gceAlphaRouters:                       &GCEAlphaRouters{s},
		gceBetaRouters:                        &GCEBetaRouters{s},
		gceRouters:                            &GCERouters{s},
		gceRoutes:                             &GCERoutes{s},
		gceBetaSecurityPolicies:               &GCEBetaSecurityPolicies{s},
		gceServiceAttachments:                 &GCEServiceAttachments{s},
		gceBetaServiceAttachments:             &GCEBetaServiceAttachments{s},
		gceAlphaServiceAttachments:            &GCEAlphaServiceAttachments{s},
		gceSslCertificates:                    &GCESslCertificates{s},
		gceBetaSslCertificates:                &GCEBetaSslCertificates{s},
		gceAlphaSslCertificates:               &GCEAlphaSslCertificates{s},
		gceAlphaRegionSslCertificates:         &GCEAlphaRegionSslCertificates{s},
		gceBetaRegionSslCertificates:          &GCEBetaRegionSslCertificates{s},
		gceRegionSslCertificates:              &GCERegionSslCertificates{s},
		gceSslPolicies:                        &GCESslPolicies{s},
		gceRegionSslPolicies:                  &GCERegionSslPolicies{s},
		gceAlphaSubnetworks:                   &GCEAlphaSubnetworks{s},
		gceBetaSubnetworks:                    &GCEBetaSubnetworks{s},
		gceSubnetworks:                        &GCESubnetworks{s},
		gceAlphaTargetHttpProxies:             &GCEAlphaTargetHttpProxies{s},
		gceBetaTargetHttpProxies:              &GCEBetaTargetHttpProxies{s},
		gceTargetHttpProxies:                  &GCETargetHttpProxies{s},
		gceAlphaRegionTargetHttpProxies:       &GCEAlphaRegionTargetHttpProxies{s},
		gceBetaRegionTargetHttpProxies:        &GCEBetaRegionTargetHttpProxies{s},
		gceRegionTargetHttpProxies:            &GCERegionTargetHttpProxies{s},
		gceTargetHttpsProxies:                 &GCETargetHttpsProxies{s},
		gceAlphaTargetHttpsProxies:            &GCEAlphaTargetHttpsProxies{s},
		gceBetaTargetHttpsProxies:             &GCEBetaTargetHttpsProxies{s},
		gceAlphaRegionTargetHttpsProxies:      &GCEAlphaRegionTargetHttpsProxies{s},
		gceBetaRegionTargetHttpsProxies:       &GCEBetaRegionTargetHttpsProxies{s},
		gceRegionTargetHttpsProxies:           &GCERegionTargetHttpsProxies{s},
		gceTargetPools:                        &GCETargetPools{s},
		gceAlphaTargetTcpProxies:              &GCEAlphaTargetTcpProxies{s},
		gceBetaTargetTcpProxies:               &GCEBetaTargetTcpProxies{s},
		gceTargetTcpProxies:                   &GCETargetTcpProxies{s},
		gceAlphaUrlMaps:                       &GCEAlphaUrlMaps{s},
		gceBetaUrlMaps:                        &GCEBetaUrlMaps{s},
		gceUrlMaps:                            &GCEUrlMaps{s},
		gceAlphaRegionUrlMaps:                 &GCEAlphaRegionUrlMaps{s},
		gceBetaRegionUrlMaps:                  &GCEBetaRegionUrlMaps{s},
		gceRegionUrlMaps:                      &GCERegionUrlMaps{s},
		gceZones:                              &GCEZones{s},
		tdTcpRoutes:                           &TDTcpRoutes{s},
		tdBetaTcpRoutes:                       &TDBetaTcpRoutes{s},
		tdMeshes:                              &TDMeshes{s},
		tdBetaMeshes:                          &TDBetaMeshes{s},
	}
	return g
}

// GCE implements Cloud.
var _ Cloud = (*GCE)(nil)

// GCE is the golang adapter for the compute APIs.
type GCE struct {
	gceAddresses                          *GCEAddresses
	gceAlphaAddresses                     *GCEAlphaAddresses
	gceBetaAddresses                      *GCEBetaAddresses
	gceAlphaGlobalAddresses               *GCEAlphaGlobalAddresses
	gceBetaGlobalAddresses                *GCEBetaGlobalAddresses
	gceGlobalAddresses                    *GCEGlobalAddresses
	gceBackendServices                    *GCEBackendServices
	gceBetaBackendServices                *GCEBetaBackendServices
	gceAlphaBackendServices               *GCEAlphaBackendServices
	gceRegionBackendServices              *GCERegionBackendServices
	gceAlphaRegionBackendServices         *GCEAlphaRegionBackendServices
	gceBetaRegionBackendServices          *GCEBetaRegionBackendServices
	gceDisks                              *GCEDisks
	gceRegionDisks                        *GCERegionDisks
	gceAlphaFirewalls                     *GCEAlphaFirewalls
	gceBetaFirewalls                      *GCEBetaFirewalls
	gceFirewalls                          *GCEFirewalls
	gceAlphaNetworkFirewallPolicies       *GCEAlphaNetworkFirewallPolicies
	gceAlphaRegionNetworkFirewallPolicies *GCEAlphaRegionNetworkFirewallPolicies
	gceForwardingRules                    *GCEForwardingRules
	gceAlphaForwardingRules               *GCEAlphaForwardingRules
	gceBetaForwardingRules                *GCEBetaForwardingRules
	gceAlphaGlobalForwardingRules         *GCEAlphaGlobalForwardingRules
	gceBetaGlobalForwardingRules          *GCEBetaGlobalForwardingRules
	gceGlobalForwardingRules              *GCEGlobalForwardingRules
	gceHealthChecks                       *GCEHealthChecks
	gceAlphaHealthChecks                  *GCEAlphaHealthChecks
	gceBetaHealthChecks                   *GCEBetaHealthChecks
	gceAlphaRegionHealthChecks            *GCEAlphaRegionHealthChecks
	gceBetaRegionHealthChecks             *GCEBetaRegionHealthChecks
	gceRegionHealthChecks                 *GCERegionHealthChecks
	gceHttpHealthChecks                   *GCEHttpHealthChecks
	gceHttpsHealthChecks                  *GCEHttpsHealthChecks
	gceInstanceGroups                     *GCEInstanceGroups
	gceInstances                          *GCEInstances
	gceBetaInstances                      *GCEBetaInstances
	gceAlphaInstances                     *GCEAlphaInstances
	gceInstanceGroupManagers              *GCEInstanceGroupManagers
	gceInstanceTemplates                  *GCEInstanceTemplates
	gceImages                             *GCEImages
	gceBetaImages                         *GCEBetaImages
	gceAlphaImages                        *GCEAlphaImages
	gceAlphaNetworks                      *GCEAlphaNetworks
	gceBetaNetworks                       *GCEBetaNetworks
	gceNetworks                           *GCENetworks
	gceAlphaNetworkEndpointGroups         *GCEAlphaNetworkEndpointGroups
	gceBetaNetworkEndpointGroups          *GCEBetaNetworkEndpointGroups
	gceNetworkEndpointGroups              *GCENetworkEndpointGroups
	gceAlphaGlobalNetworkEndpointGroups   *GCEAlphaGlobalNetworkEndpointGroups
	gceBetaGlobalNetworkEndpointGroups    *GCEBetaGlobalNetworkEndpointGroups
	gceGlobalNetworkEndpointGroups        *GCEGlobalNetworkEndpointGroups
	gceProjects                           *GCEProjects
	gceRegions                            *GCERegions
	gceAlphaRouters                       *GCEAlphaRouters
	gceBetaRouters                        *GCEBetaRouters
	gceRouters                            *GCERouters
	gceRoutes                             *GCERoutes
	gceBetaSecurityPolicies               *GCEBetaSecurityPolicies
	gceServiceAttachments                 *GCEServiceAttachments
	gceBetaServiceAttachments             *GCEBetaServiceAttachments
	gceAlphaServiceAttachments            *GCEAlphaServiceAttachments
	gceSslCertificates                    *GCESslCertificates
	gceBetaSslCertificates                *GCEBetaSslCertificates
	gceAlphaSslCertificates               *GCEAlphaSslCertificates
	gceAlphaRegionSslCertificates         *GCEAlphaRegionSslCertificates
	gceBetaRegionSslCertificates          *GCEBetaRegionSslCertificates
	gceRegionSslCertificates              *GCERegionSslCertificates
	gceSslPolicies                        *GCESslPolicies
	gceRegionSslPolicies                  *GCERegionSslPolicies
	gceAlphaSubnetworks                   *GCEAlphaSubnetworks
	gceBetaSubnetworks                    *GCEBetaSubnetworks
	gceSubnetworks                        *GCESubnetworks
	gceAlphaTargetHttpProxies             *GCEAlphaTargetHttpProxies
	gceBetaTargetHttpProxies              *GCEBetaTargetHttpProxies
	gceTargetHttpProxies                  *GCETargetHttpProxies
	gceAlphaRegionTargetHttpProxies       *GCEAlphaRegionTargetHttpProxies
	gceBetaRegionTargetHttpProxies        *GCEBetaRegionTargetHttpProxies
	gceRegionTargetHttpProxies            *GCERegionTargetHttpProxies
	gceTargetHttpsProxies                 *GCETargetHttpsProxies
	gceAlphaTargetHttpsProxies            *GCEAlphaTargetHttpsProxies
	gceBetaTargetHttpsProxies             *GCEBetaTargetHttpsProxies
	gceAlphaRegionTargetHttpsProxies      *GCEAlphaRegionTargetHttpsProxies
	gceBetaRegionTargetHttpsProxies       *GCEBetaRegionTargetHttpsProxies
	gceRegionTargetHttpsProxies           *GCERegionTargetHttpsProxies
	gceTargetPools                        *GCETargetPools
	gceAlphaTargetTcpProxies              *GCEAlphaTargetTcpProxies
	gceBetaTargetTcpProxies               *GCEBetaTargetTcpProxies
	gceTargetTcpProxies                   *GCETargetTcpProxies
	gceAlphaUrlMaps                       *GCEAlphaUrlMaps
	gceBetaUrlMaps                        *GCEBetaUrlMaps
	gceUrlMaps                            *GCEUrlMaps
	gceAlphaRegionUrlMaps                 *GCEAlphaRegionUrlMaps
	gceBetaRegionUrlMaps                  *GCEBetaRegionUrlMaps
	gceRegionUrlMaps                      *GCERegionUrlMaps
	gceZones                              *GCEZones
	tdTcpRoutes                           *TDTcpRoutes
	tdBetaTcpRoutes                       *TDBetaTcpRoutes
	tdMeshes                              *TDMeshes
	tdBetaMeshes                          *TDBetaMeshes
}

// Addresses returns the interface for the ga Addresses.
func (gce *GCE) Addresses() Addresses {
	return gce.gceAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (gce *GCE) AlphaAddresses() AlphaAddresses {
	return gce.gceAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (gce *GCE) BetaAddresses() BetaAddresses {
	return gce.gceBetaAddresses
}

// AlphaGlobalAddresses returns the interface for the alpha GlobalAddresses.
func (gce *GCE) AlphaGlobalAddresses() AlphaGlobalAddresses {
	return gce.gceAlphaGlobalAddresses
}

// BetaGlobalAddresses returns the interface for the beta GlobalAddresses.
func (gce *GCE) BetaGlobalAddresses() BetaGlobalAddresses {
	return gce.gceBetaGlobalAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (gce *GCE) GlobalAddresses() GlobalAddresses {
	return gce.gceGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (gce *GCE) BackendServices() BackendServices {
	return gce.gceBackendServices
}

// BetaBackendServices returns the interface for the beta BackendServices.
func (gce *GCE) BetaBackendServices() BetaBackendServices {
	return gce.gceBetaBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (gce *GCE) AlphaBackendServices() AlphaBackendServices {
	return gce.gceAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (gce *GCE) RegionBackendServices() RegionBackendServices {
	return gce.gceRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (gce *GCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return gce.gceAlphaRegionBackendServices
}

// BetaRegionBackendServices returns the interface for the beta RegionBackendServices.
func (gce *GCE) BetaRegionBackendServices() BetaRegionBackendServices {
	return gce.gceBetaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (gce *GCE) Disks() Disks {
	return gce.gceDisks
}

// RegionDisks returns the interface for the ga RegionDisks.
func (gce *GCE) RegionDisks() RegionDisks {
	return gce.gceRegionDisks
}

// AlphaFirewalls returns the interface for the alpha Firewalls.
func (gce *GCE) AlphaFirewalls() AlphaFirewalls {
	return gce.gceAlphaFirewalls
}

// BetaFirewalls returns the interface for the beta Firewalls.
func (gce *GCE) BetaFirewalls() BetaFirewalls {
	return gce.gceBetaFirewalls
}

// Firewalls returns the interface for the ga Firewalls.
func (gce *GCE) Firewalls() Firewalls {
	return gce.gceFirewalls
}

// AlphaNetworkFirewallPolicies returns the interface for the alpha NetworkFirewallPolicies.
func (gce *GCE) AlphaNetworkFirewallPolicies() AlphaNetworkFirewallPolicies {
	return gce.gceAlphaNetworkFirewallPolicies
}

// AlphaRegionNetworkFirewallPolicies returns the interface for the alpha RegionNetworkFirewallPolicies.
func (gce *GCE) AlphaRegionNetworkFirewallPolicies() AlphaRegionNetworkFirewallPolicies {
	return gce.gceAlphaRegionNetworkFirewallPolicies
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (gce *GCE) ForwardingRules() ForwardingRules {
	return gce.gceForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (gce *GCE) AlphaForwardingRules() AlphaForwardingRules {
	return gce.gceAlphaForwardingRules
}

// BetaForwardingRules returns the interface for the beta ForwardingRules.
func (gce *GCE) BetaForwardingRules() BetaForwardingRules {
	return gce.gceBetaForwardingRules
}

// AlphaGlobalForwardingRules returns the interface for the alpha GlobalForwardingRules.
func (gce *GCE) AlphaGlobalForwardingRules() AlphaGlobalForwardingRules {
	return gce.gceAlphaGlobalForwardingRules
}

// BetaGlobalForwardingRules returns the interface for the beta GlobalForwardingRules.
func (gce *GCE) BetaGlobalForwardingRules() BetaGlobalForwardingRules {
	return gce.gceBetaGlobalForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (gce *GCE) GlobalForwardingRules() GlobalForwardingRules {
	return gce.gceGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (gce *GCE) HealthChecks() HealthChecks {
	return gce.gceHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (gce *GCE) AlphaHealthChecks() AlphaHealthChecks {
	return gce.gceAlphaHealthChecks
}

// BetaHealthChecks returns the interface for the beta HealthChecks.
func (gce *GCE) BetaHealthChecks() BetaHealthChecks {
	return gce.gceBetaHealthChecks
}

// AlphaRegionHealthChecks returns the interface for the alpha RegionHealthChecks.
func (gce *GCE) AlphaRegionHealthChecks() AlphaRegionHealthChecks {
	return gce.gceAlphaRegionHealthChecks
}

// BetaRegionHealthChecks returns the interface for the beta RegionHealthChecks.
func (gce *GCE) BetaRegionHealthChecks() BetaRegionHealthChecks {
	return gce.gceBetaRegionHealthChecks
}

// RegionHealthChecks returns the interface for the ga RegionHealthChecks.
func (gce *GCE) RegionHealthChecks() RegionHealthChecks {
	return gce.gceRegionHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (gce *GCE) HttpHealthChecks() HttpHealthChecks {
	return gce.gceHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (gce *GCE) HttpsHealthChecks() HttpsHealthChecks {
	return gce.gceHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (gce *GCE) InstanceGroups() InstanceGroups {
	return gce.gceInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (gce *GCE) Instances() Instances {
	return gce.gceInstances
}

// BetaInstances returns the interface for the beta Instances.
func (gce *GCE) BetaInstances() BetaInstances {
	return gce.gceBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (gce *GCE) AlphaInstances() AlphaInstances {
	return gce.gceAlphaInstances
}

// InstanceGroupManagers returns the interface for the ga InstanceGroupManagers.
func (gce *GCE) InstanceGroupManagers() InstanceGroupManagers {
	return gce.gceInstanceGroupManagers
}

// InstanceTemplates returns the interface for the ga InstanceTemplates.
func (gce *GCE) InstanceTemplates() InstanceTemplates {
	return gce.gceInstanceTemplates
}

// Images returns the interface for the ga Images.
func (gce *GCE) Images() Images {
	return gce.gceImages
}

// BetaImages returns the interface for the beta Images.
func (gce *GCE) BetaImages() BetaImages {
	return gce.gceBetaImages
}

// AlphaImages returns the interface for the alpha Images.
func (gce *GCE) AlphaImages() AlphaImages {
	return gce.gceAlphaImages
}

// AlphaNetworks returns the interface for the alpha Networks.
func (gce *GCE) AlphaNetworks() AlphaNetworks {
	return gce.gceAlphaNetworks
}

// BetaNetworks returns the interface for the beta Networks.
func (gce *GCE) BetaNetworks() BetaNetworks {
	return gce.gceBetaNetworks
}

// Networks returns the interface for the ga Networks.
func (gce *GCE) Networks() Networks {
	return gce.gceNetworks
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (gce *GCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return gce.gceAlphaNetworkEndpointGroups
}

// BetaNetworkEndpointGroups returns the interface for the beta NetworkEndpointGroups.
func (gce *GCE) BetaNetworkEndpointGroups() BetaNetworkEndpointGroups {
	return gce.gceBetaNetworkEndpointGroups
}

// NetworkEndpointGroups returns the interface for the ga NetworkEndpointGroups.
func (gce *GCE) NetworkEndpointGroups() NetworkEndpointGroups {
	return gce.gceNetworkEndpointGroups
}

// AlphaGlobalNetworkEndpointGroups returns the interface for the alpha GlobalNetworkEndpointGroups.
func (gce *GCE) AlphaGlobalNetworkEndpointGroups() AlphaGlobalNetworkEndpointGroups {
	return gce.gceAlphaGlobalNetworkEndpointGroups
}

// BetaGlobalNetworkEndpointGroups returns the interface for the beta GlobalNetworkEndpointGroups.
func (gce *GCE) BetaGlobalNetworkEndpointGroups() BetaGlobalNetworkEndpointGroups {
	return gce.gceBetaGlobalNetworkEndpointGroups
}

// GlobalNetworkEndpointGroups returns the interface for the ga GlobalNetworkEndpointGroups.
func (gce *GCE) GlobalNetworkEndpointGroups() GlobalNetworkEndpointGroups {
	return gce.gceGlobalNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (gce *GCE) Projects() Projects {
	return gce.gceProjects
}

// Regions returns the interface for the ga Regions.
func (gce *GCE) Regions() Regions {
	return gce.gceRegions
}

// AlphaRouters returns the interface for the alpha Routers.
func (gce *GCE) AlphaRouters() AlphaRouters {
	return gce.gceAlphaRouters
}

// BetaRouters returns the interface for the beta Routers.
func (gce *GCE) BetaRouters() BetaRouters {
	return gce.gceBetaRouters
}

// Routers returns the interface for the ga Routers.
func (gce *GCE) Routers() Routers {
	return gce.gceRouters
}

// Routes returns the interface for the ga Routes.
func (gce *GCE) Routes() Routes {
	return gce.gceRoutes
}

// BetaSecurityPolicies returns the interface for the beta SecurityPolicies.
func (gce *GCE) BetaSecurityPolicies() BetaSecurityPolicies {
	return gce.gceBetaSecurityPolicies
}

// ServiceAttachments returns the interface for the ga ServiceAttachments.
func (gce *GCE) ServiceAttachments() ServiceAttachments {
	return gce.gceServiceAttachments
}

// BetaServiceAttachments returns the interface for the beta ServiceAttachments.
func (gce *GCE) BetaServiceAttachments() BetaServiceAttachments {
	return gce.gceBetaServiceAttachments
}

// AlphaServiceAttachments returns the interface for the alpha ServiceAttachments.
func (gce *GCE) AlphaServiceAttachments() AlphaServiceAttachments {
	return gce.gceAlphaServiceAttachments
}

// SslCertificates returns the interface for the ga SslCertificates.
func (gce *GCE) SslCertificates() SslCertificates {
	return gce.gceSslCertificates
}

// BetaSslCertificates returns the interface for the beta SslCertificates.
func (gce *GCE) BetaSslCertificates() BetaSslCertificates {
	return gce.gceBetaSslCertificates
}

// AlphaSslCertificates returns the interface for the alpha SslCertificates.
func (gce *GCE) AlphaSslCertificates() AlphaSslCertificates {
	return gce.gceAlphaSslCertificates
}

// AlphaRegionSslCertificates returns the interface for the alpha RegionSslCertificates.
func (gce *GCE) AlphaRegionSslCertificates() AlphaRegionSslCertificates {
	return gce.gceAlphaRegionSslCertificates
}

// BetaRegionSslCertificates returns the interface for the beta RegionSslCertificates.
func (gce *GCE) BetaRegionSslCertificates() BetaRegionSslCertificates {
	return gce.gceBetaRegionSslCertificates
}

// RegionSslCertificates returns the interface for the ga RegionSslCertificates.
func (gce *GCE) RegionSslCertificates() RegionSslCertificates {
	return gce.gceRegionSslCertificates
}

// SslPolicies returns the interface for the ga SslPolicies.
func (gce *GCE) SslPolicies() SslPolicies {
	return gce.gceSslPolicies
}

// RegionSslPolicies returns the interface for the ga RegionSslPolicies.
func (gce *GCE) RegionSslPolicies() RegionSslPolicies {
	return gce.gceRegionSslPolicies
}

// AlphaSubnetworks returns the interface for the alpha Subnetworks.
func (gce *GCE) AlphaSubnetworks() AlphaSubnetworks {
	return gce.gceAlphaSubnetworks
}

// BetaSubnetworks returns the interface for the beta Subnetworks.
func (gce *GCE) BetaSubnetworks() BetaSubnetworks {
	return gce.gceBetaSubnetworks
}

// Subnetworks returns the interface for the ga Subnetworks.
func (gce *GCE) Subnetworks() Subnetworks {
	return gce.gceSubnetworks
}

// AlphaTargetHttpProxies returns the interface for the alpha TargetHttpProxies.
func (gce *GCE) AlphaTargetHttpProxies() AlphaTargetHttpProxies {
	return gce.gceAlphaTargetHttpProxies
}

// BetaTargetHttpProxies returns the interface for the beta TargetHttpProxies.
func (gce *GCE) BetaTargetHttpProxies() BetaTargetHttpProxies {
	return gce.gceBetaTargetHttpProxies
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (gce *GCE) TargetHttpProxies() TargetHttpProxies {
	return gce.gceTargetHttpProxies
}

// AlphaRegionTargetHttpProxies returns the interface for the alpha RegionTargetHttpProxies.
func (gce *GCE) AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies {
	return gce.gceAlphaRegionTargetHttpProxies
}

// BetaRegionTargetHttpProxies returns the interface for the beta RegionTargetHttpProxies.
func (gce *GCE) BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies {
	return gce.gceBetaRegionTargetHttpProxies
}

// RegionTargetHttpProxies returns the interface for the ga RegionTargetHttpProxies.
func (gce *GCE) RegionTargetHttpProxies() RegionTargetHttpProxies {
	return gce.gceRegionTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (gce *GCE) TargetHttpsProxies() TargetHttpsProxies {
	return gce.gceTargetHttpsProxies
}

// AlphaTargetHttpsProxies returns the interface for the alpha TargetHttpsProxies.
func (gce *GCE) AlphaTargetHttpsProxies() AlphaTargetHttpsProxies {
	return gce.gceAlphaTargetHttpsProxies
}

// BetaTargetHttpsProxies returns the interface for the beta TargetHttpsProxies.
func (gce *GCE) BetaTargetHttpsProxies() BetaTargetHttpsProxies {
	return gce.gceBetaTargetHttpsProxies
}

// AlphaRegionTargetHttpsProxies returns the interface for the alpha RegionTargetHttpsProxies.
func (gce *GCE) AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies {
	return gce.gceAlphaRegionTargetHttpsProxies
}

// BetaRegionTargetHttpsProxies returns the interface for the beta RegionTargetHttpsProxies.
func (gce *GCE) BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies {
	return gce.gceBetaRegionTargetHttpsProxies
}

// RegionTargetHttpsProxies returns the interface for the ga RegionTargetHttpsProxies.
func (gce *GCE) RegionTargetHttpsProxies() RegionTargetHttpsProxies {
	return gce.gceRegionTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (gce *GCE) TargetPools() TargetPools {
	return gce.gceTargetPools
}

// AlphaTargetTcpProxies returns the interface for the alpha TargetTcpProxies.
func (gce *GCE) AlphaTargetTcpProxies() AlphaTargetTcpProxies {
	return gce.gceAlphaTargetTcpProxies
}

// BetaTargetTcpProxies returns the interface for the beta TargetTcpProxies.
func (gce *GCE) BetaTargetTcpProxies() BetaTargetTcpProxies {
	return gce.gceBetaTargetTcpProxies
}

// TargetTcpProxies returns the interface for the ga TargetTcpProxies.
func (gce *GCE) TargetTcpProxies() TargetTcpProxies {
	return gce.gceTargetTcpProxies
}

// AlphaUrlMaps returns the interface for the alpha UrlMaps.
func (gce *GCE) AlphaUrlMaps() AlphaUrlMaps {
	return gce.gceAlphaUrlMaps
}

// BetaUrlMaps returns the interface for the beta UrlMaps.
func (gce *GCE) BetaUrlMaps() BetaUrlMaps {
	return gce.gceBetaUrlMaps
}

// UrlMaps returns the interface for the ga UrlMaps.
func (gce *GCE) UrlMaps() UrlMaps {
	return gce.gceUrlMaps
}

// AlphaRegionUrlMaps returns the interface for the alpha RegionUrlMaps.
func (gce *GCE) AlphaRegionUrlMaps() AlphaRegionUrlMaps {
	return gce.gceAlphaRegionUrlMaps
}

// BetaRegionUrlMaps returns the interface for the beta RegionUrlMaps.
func (gce *GCE) BetaRegionUrlMaps() BetaRegionUrlMaps {
	return gce.gceBetaRegionUrlMaps
}

// RegionUrlMaps returns the interface for the ga RegionUrlMaps.
func (gce *GCE) RegionUrlMaps() RegionUrlMaps {
	return gce.gceRegionUrlMaps
}

// Zones returns the interface for the ga Zones.
func (gce *GCE) Zones() Zones {
	return gce.gceZones
}

// TcpRoutes returns the interface for the ga TcpRoutes.
func (gce *GCE) TcpRoutes() TcpRoutes {
	return gce.tdTcpRoutes
}

// BetaTcpRoutes returns the interface for the beta TcpRoutes.
func (gce *GCE) BetaTcpRoutes() BetaTcpRoutes {
	return gce.tdBetaTcpRoutes
}

// Meshes returns the interface for the ga Meshes.
func (gce *GCE) Meshes() Meshes {
	return gce.tdMeshes
}

// BetaMeshes returns the interface for the beta Meshes.
func (gce *GCE) BetaMeshes() BetaMeshes {
	return gce.tdBetaMeshes
}

// NewMockGCE returns a new mock for GCE.
func NewMockGCE(projectRouter ProjectRouter) *MockGCE {
	mockAddressesObjs := map[meta.Key]*MockAddressesObj{}
	mockBackendServicesObjs := map[meta.Key]*MockBackendServicesObj{}
	mockDisksObjs := map[meta.Key]*MockDisksObj{}
	mockFirewallsObjs := map[meta.Key]*MockFirewallsObj{}
	mockForwardingRulesObjs := map[meta.Key]*MockForwardingRulesObj{}
	mockGlobalAddressesObjs := map[meta.Key]*MockGlobalAddressesObj{}
	mockGlobalForwardingRulesObjs := map[meta.Key]*MockGlobalForwardingRulesObj{}
	mockGlobalNetworkEndpointGroupsObjs := map[meta.Key]*MockGlobalNetworkEndpointGroupsObj{}
	mockHealthChecksObjs := map[meta.Key]*MockHealthChecksObj{}
	mockHttpHealthChecksObjs := map[meta.Key]*MockHttpHealthChecksObj{}
	mockHttpsHealthChecksObjs := map[meta.Key]*MockHttpsHealthChecksObj{}
	mockImagesObjs := map[meta.Key]*MockImagesObj{}
	mockInstanceGroupManagersObjs := map[meta.Key]*MockInstanceGroupManagersObj{}
	mockInstanceGroupsObjs := map[meta.Key]*MockInstanceGroupsObj{}
	mockInstanceTemplatesObjs := map[meta.Key]*MockInstanceTemplatesObj{}
	mockInstancesObjs := map[meta.Key]*MockInstancesObj{}
	mockMeshesObjs := map[meta.Key]*MockMeshesObj{}
	mockNetworkEndpointGroupsObjs := map[meta.Key]*MockNetworkEndpointGroupsObj{}
	mockNetworkFirewallPoliciesObjs := map[meta.Key]*MockNetworkFirewallPoliciesObj{}
	mockNetworksObjs := map[meta.Key]*MockNetworksObj{}
	mockProjectsObjs := map[meta.Key]*MockProjectsObj{}
	mockRegionBackendServicesObjs := map[meta.Key]*MockRegionBackendServicesObj{}
	mockRegionDisksObjs := map[meta.Key]*MockRegionDisksObj{}
	mockRegionHealthChecksObjs := map[meta.Key]*MockRegionHealthChecksObj{}
	mockRegionNetworkFirewallPoliciesObjs := map[meta.Key]*MockRegionNetworkFirewallPoliciesObj{}
	mockRegionSslCertificatesObjs := map[meta.Key]*MockRegionSslCertificatesObj{}
	mockRegionSslPoliciesObjs := map[meta.Key]*MockRegionSslPoliciesObj{}
	mockRegionTargetHttpProxiesObjs := map[meta.Key]*MockRegionTargetHttpProxiesObj{}
	mockRegionTargetHttpsProxiesObjs := map[meta.Key]*MockRegionTargetHttpsProxiesObj{}
	mockRegionUrlMapsObjs := map[meta.Key]*MockRegionUrlMapsObj{}
	mockRegionsObjs := map[meta.Key]*MockRegionsObj{}
	mockRoutersObjs := map[meta.Key]*MockRoutersObj{}
	mockRoutesObjs := map[meta.Key]*MockRoutesObj{}
	mockSecurityPoliciesObjs := map[meta.Key]*MockSecurityPoliciesObj{}
	mockServiceAttachmentsObjs := map[meta.Key]*MockServiceAttachmentsObj{}
	mockSslCertificatesObjs := map[meta.Key]*MockSslCertificatesObj{}
	mockSslPoliciesObjs := map[meta.Key]*MockSslPoliciesObj{}
	mockSubnetworksObjs := map[meta.Key]*MockSubnetworksObj{}
	mockTargetHttpProxiesObjs := map[meta.Key]*MockTargetHttpProxiesObj{}
	mockTargetHttpsProxiesObjs := map[meta.Key]*MockTargetHttpsProxiesObj{}
	mockTargetPoolsObjs := map[meta.Key]*MockTargetPoolsObj{}
	mockTargetTcpProxiesObjs := map[meta.Key]*MockTargetTcpProxiesObj{}
	mockTcpRoutesObjs := map[meta.Key]*MockTcpRoutesObj{}
	mockUrlMapsObjs := map[meta.Key]*MockUrlMapsObj{}
	mockZonesObjs := map[meta.Key]*MockZonesObj{}

	mock := &MockGCE{
		MockAddresses:                          NewMockAddresses(projectRouter, mockAddressesObjs),
		MockAlphaAddresses:                     NewMockAlphaAddresses(projectRouter, mockAddressesObjs),
		MockBetaAddresses:                      NewMockBetaAddresses(projectRouter, mockAddressesObjs),
		MockAlphaGlobalAddresses:               NewMockAlphaGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockBetaGlobalAddresses:                NewMockBetaGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockGlobalAddresses:                    NewMockGlobalAddresses(projectRouter, mockGlobalAddressesObjs),
		MockBackendServices:                    NewMockBackendServices(projectRouter, mockBackendServicesObjs),
		MockBetaBackendServices:                NewMockBetaBackendServices(projectRouter, mockBackendServicesObjs),
		MockAlphaBackendServices:               NewMockAlphaBackendServices(projectRouter, mockBackendServicesObjs),
		MockRegionBackendServices:              NewMockRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockAlphaRegionBackendServices:         NewMockAlphaRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockBetaRegionBackendServices:          NewMockBetaRegionBackendServices(projectRouter, mockRegionBackendServicesObjs),
		MockDisks:                              NewMockDisks(projectRouter, mockDisksObjs),
		MockRegionDisks:                        NewMockRegionDisks(projectRouter, mockRegionDisksObjs),
		MockAlphaFirewalls:                     NewMockAlphaFirewalls(projectRouter, mockFirewallsObjs),
		MockBetaFirewalls:                      NewMockBetaFirewalls(projectRouter, mockFirewallsObjs),
		MockFirewalls:                          NewMockFirewalls(projectRouter, mockFirewallsObjs),
		MockAlphaNetworkFirewallPolicies:       NewMockAlphaNetworkFirewallPolicies(projectRouter, mockNetworkFirewallPoliciesObjs),
		MockAlphaRegionNetworkFirewallPolicies: NewMockAlphaRegionNetworkFirewallPolicies(projectRouter, mockRegionNetworkFirewallPoliciesObjs),
		MockForwardingRules:                    NewMockForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockAlphaForwardingRules:               NewMockAlphaForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockBetaForwardingRules:                NewMockBetaForwardingRules(projectRouter, mockForwardingRulesObjs),
		MockAlphaGlobalForwardingRules:         NewMockAlphaGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockBetaGlobalForwardingRules:          NewMockBetaGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockGlobalForwardingRules:              NewMockGlobalForwardingRules(projectRouter, mockGlobalForwardingRulesObjs),
		MockHealthChecks:                       NewMockHealthChecks(projectRouter, mockHealthChecksObjs),
		MockAlphaHealthChecks:                  NewMockAlphaHealthChecks(projectRouter, mockHealthChecksObjs),
		MockBetaHealthChecks:                   NewMockBetaHealthChecks(projectRouter, mockHealthChecksObjs),
		MockAlphaRegionHealthChecks:            NewMockAlphaRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockBetaRegionHealthChecks:             NewMockBetaRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockRegionHealthChecks:                 NewMockRegionHealthChecks(projectRouter, mockRegionHealthChecksObjs),
		MockHttpHealthChecks:                   NewMockHttpHealthChecks(projectRouter, mockHttpHealthChecksObjs),
		MockHttpsHealthChecks:                  NewMockHttpsHealthChecks(projectRouter, mockHttpsHealthChecksObjs),
		MockInstanceGroups:                     NewMockInstanceGroups(projectRouter, mockInstanceGroupsObjs),
		MockInstances:                          NewMockInstances(projectRouter, mockInstancesObjs),
		MockBetaInstances:                      NewMockBetaInstances(projectRouter, mockInstancesObjs),
		MockAlphaInstances:                     NewMockAlphaInstances(projectRouter, mockInstancesObjs),
		MockInstanceGroupManagers:              NewMockInstanceGroupManagers(projectRouter, mockInstanceGroupManagersObjs),
		MockInstanceTemplates:                  NewMockInstanceTemplates(projectRouter, mockInstanceTemplatesObjs),
		MockImages:                             NewMockImages(projectRouter, mockImagesObjs),
		MockBetaImages:                         NewMockBetaImages(projectRouter, mockImagesObjs),
		MockAlphaImages:                        NewMockAlphaImages(projectRouter, mockImagesObjs),
		MockAlphaNetworks:                      NewMockAlphaNetworks(projectRouter, mockNetworksObjs),
		MockBetaNetworks:                       NewMockBetaNetworks(projectRouter, mockNetworksObjs),
		MockNetworks:                           NewMockNetworks(projectRouter, mockNetworksObjs),
		MockAlphaNetworkEndpointGroups:         NewMockAlphaNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockBetaNetworkEndpointGroups:          NewMockBetaNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockNetworkEndpointGroups:              NewMockNetworkEndpointGroups(projectRouter, mockNetworkEndpointGroupsObjs),
		MockAlphaGlobalNetworkEndpointGroups:   NewMockAlphaGlobalNetworkEndpointGroups(projectRouter, mockGlobalNetworkEndpointGroupsObjs),
		MockBetaGlobalNetworkEndpointGroups:    NewMockBetaGlobalNetworkEndpointGroups(projectRouter, mockGlobalNetworkEndpointGroupsObjs),
		MockGlobalNetworkEndpointGroups:        NewMockGlobalNetworkEndpointGroups(projectRouter, mockGlobalNetworkEndpointGroupsObjs),
		MockProjects:                           NewMockProjects(projectRouter, mockProjectsObjs),
		MockRegions:                            NewMockRegions(projectRouter, mockRegionsObjs),
		MockAlphaRouters:                       NewMockAlphaRouters(projectRouter, mockRoutersObjs),
		MockBetaRouters:                        NewMockBetaRouters(projectRouter, mockRoutersObjs),
		MockRouters:                            NewMockRouters(projectRouter, mockRoutersObjs),
		MockRoutes:                             NewMockRoutes(projectRouter, mockRoutesObjs),
		MockBetaSecurityPolicies:               NewMockBetaSecurityPolicies(projectRouter, mockSecurityPoliciesObjs),
		MockServiceAttachments:                 NewMockServiceAttachments(projectRouter, mockServiceAttachmentsObjs),
		MockBetaServiceAttachments:             NewMockBetaServiceAttachments(projectRouter, mockServiceAttachmentsObjs),
		MockAlphaServiceAttachments:            NewMockAlphaServiceAttachments(projectRouter, mockServiceAttachmentsObjs),
		MockSslCertificates:                    NewMockSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockBetaSslCertificates:                NewMockBetaSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockAlphaSslCertificates:               NewMockAlphaSslCertificates(projectRouter, mockSslCertificatesObjs),
		MockAlphaRegionSslCertificates:         NewMockAlphaRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockBetaRegionSslCertificates:          NewMockBetaRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockRegionSslCertificates:              NewMockRegionSslCertificates(projectRouter, mockRegionSslCertificatesObjs),
		MockSslPolicies:                        NewMockSslPolicies(projectRouter, mockSslPoliciesObjs),
		MockRegionSslPolicies:                  NewMockRegionSslPolicies(projectRouter, mockRegionSslPoliciesObjs),
		MockAlphaSubnetworks:                   NewMockAlphaSubnetworks(projectRouter, mockSubnetworksObjs),
		MockBetaSubnetworks:                    NewMockBetaSubnetworks(projectRouter, mockSubnetworksObjs),
		MockSubnetworks:                        NewMockSubnetworks(projectRouter, mockSubnetworksObjs),
		MockAlphaTargetHttpProxies:             NewMockAlphaTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockBetaTargetHttpProxies:              NewMockBetaTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockTargetHttpProxies:                  NewMockTargetHttpProxies(projectRouter, mockTargetHttpProxiesObjs),
		MockAlphaRegionTargetHttpProxies:       NewMockAlphaRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockBetaRegionTargetHttpProxies:        NewMockBetaRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockRegionTargetHttpProxies:            NewMockRegionTargetHttpProxies(projectRouter, mockRegionTargetHttpProxiesObjs),
		MockTargetHttpsProxies:                 NewMockTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockAlphaTargetHttpsProxies:            NewMockAlphaTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockBetaTargetHttpsProxies:             NewMockBetaTargetHttpsProxies(projectRouter, mockTargetHttpsProxiesObjs),
		MockAlphaRegionTargetHttpsProxies:      NewMockAlphaRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockBetaRegionTargetHttpsProxies:       NewMockBetaRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockRegionTargetHttpsProxies:           NewMockRegionTargetHttpsProxies(projectRouter, mockRegionTargetHttpsProxiesObjs),
		MockTargetPools:                        NewMockTargetPools(projectRouter, mockTargetPoolsObjs),
		MockAlphaTargetTcpProxies:              NewMockAlphaTargetTcpProxies(projectRouter, mockTargetTcpProxiesObjs),
		MockBetaTargetTcpProxies:               NewMockBetaTargetTcpProxies(projectRouter, mockTargetTcpProxiesObjs),
		MockTargetTcpProxies:                   NewMockTargetTcpProxies(projectRouter, mockTargetTcpProxiesObjs),
		MockAlphaUrlMaps:                       NewMockAlphaUrlMaps(projectRouter, mockUrlMapsObjs),
		MockBetaUrlMaps:                        NewMockBetaUrlMaps(projectRouter, mockUrlMapsObjs),
		MockUrlMaps:                            NewMockUrlMaps(projectRouter, mockUrlMapsObjs),
		MockAlphaRegionUrlMaps:                 NewMockAlphaRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockBetaRegionUrlMaps:                  NewMockBetaRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockRegionUrlMaps:                      NewMockRegionUrlMaps(projectRouter, mockRegionUrlMapsObjs),
		MockZones:                              NewMockZones(projectRouter, mockZonesObjs),
		MockTcpRoutes:                          NewMockTcpRoutes(projectRouter, mockTcpRoutesObjs),
		MockBetaTcpRoutes:                      NewMockBetaTcpRoutes(projectRouter, mockTcpRoutesObjs),
		MockMeshes:                             NewMockMeshes(projectRouter, mockMeshesObjs),
		MockBetaMeshes:                         NewMockBetaMeshes(projectRouter, mockMeshesObjs),
	}
	return mock
}

// MockGCE implements Cloud.
var _ Cloud = (*MockGCE)(nil)

// MockGCE is the mock for the compute API.
type MockGCE struct {
	MockAddresses                          *MockAddresses
	MockAlphaAddresses                     *MockAlphaAddresses
	MockBetaAddresses                      *MockBetaAddresses
	MockAlphaGlobalAddresses               *MockAlphaGlobalAddresses
	MockBetaGlobalAddresses                *MockBetaGlobalAddresses
	MockGlobalAddresses                    *MockGlobalAddresses
	MockBackendServices                    *MockBackendServices
	MockBetaBackendServices                *MockBetaBackendServices
	MockAlphaBackendServices               *MockAlphaBackendServices
	MockRegionBackendServices              *MockRegionBackendServices
	MockAlphaRegionBackendServices         *MockAlphaRegionBackendServices
	MockBetaRegionBackendServices          *MockBetaRegionBackendServices
	MockDisks                              *MockDisks
	MockRegionDisks                        *MockRegionDisks
	MockAlphaFirewalls                     *MockAlphaFirewalls
	MockBetaFirewalls                      *MockBetaFirewalls
	MockFirewalls                          *MockFirewalls
	MockAlphaNetworkFirewallPolicies       *MockAlphaNetworkFirewallPolicies
	MockAlphaRegionNetworkFirewallPolicies *MockAlphaRegionNetworkFirewallPolicies
	MockForwardingRules                    *MockForwardingRules
	MockAlphaForwardingRules               *MockAlphaForwardingRules
	MockBetaForwardingRules                *MockBetaForwardingRules
	MockAlphaGlobalForwardingRules         *MockAlphaGlobalForwardingRules
	MockBetaGlobalForwardingRules          *MockBetaGlobalForwardingRules
	MockGlobalForwardingRules              *MockGlobalForwardingRules
	MockHealthChecks                       *MockHealthChecks
	MockAlphaHealthChecks                  *MockAlphaHealthChecks
	MockBetaHealthChecks                   *MockBetaHealthChecks
	MockAlphaRegionHealthChecks            *MockAlphaRegionHealthChecks
	MockBetaRegionHealthChecks             *MockBetaRegionHealthChecks
	MockRegionHealthChecks                 *MockRegionHealthChecks
	MockHttpHealthChecks                   *MockHttpHealthChecks
	MockHttpsHealthChecks                  *MockHttpsHealthChecks
	MockInstanceGroups                     *MockInstanceGroups
	MockInstances                          *MockInstances
	MockBetaInstances                      *MockBetaInstances
	MockAlphaInstances                     *MockAlphaInstances
	MockInstanceGroupManagers              *MockInstanceGroupManagers
	MockInstanceTemplates                  *MockInstanceTemplates
	MockImages                             *MockImages
	MockBetaImages                         *MockBetaImages
	MockAlphaImages                        *MockAlphaImages
	MockAlphaNetworks                      *MockAlphaNetworks
	MockBetaNetworks                       *MockBetaNetworks
	MockNetworks                           *MockNetworks
	MockAlphaNetworkEndpointGroups         *MockAlphaNetworkEndpointGroups
	MockBetaNetworkEndpointGroups          *MockBetaNetworkEndpointGroups
	MockNetworkEndpointGroups              *MockNetworkEndpointGroups
	MockAlphaGlobalNetworkEndpointGroups   *MockAlphaGlobalNetworkEndpointGroups
	MockBetaGlobalNetworkEndpointGroups    *MockBetaGlobalNetworkEndpointGroups
	MockGlobalNetworkEndpointGroups        *MockGlobalNetworkEndpointGroups
	MockProjects                           *MockProjects
	MockRegions                            *MockRegions
	MockAlphaRouters                       *MockAlphaRouters
	MockBetaRouters                        *MockBetaRouters
	MockRouters                            *MockRouters
	MockRoutes                             *MockRoutes
	MockBetaSecurityPolicies               *MockBetaSecurityPolicies
	MockServiceAttachments                 *MockServiceAttachments
	MockBetaServiceAttachments             *MockBetaServiceAttachments
	MockAlphaServiceAttachments            *MockAlphaServiceAttachments
	MockSslCertificates                    *MockSslCertificates
	MockBetaSslCertificates                *MockBetaSslCertificates
	MockAlphaSslCertificates               *MockAlphaSslCertificates
	MockAlphaRegionSslCertificates         *MockAlphaRegionSslCertificates
	MockBetaRegionSslCertificates          *MockBetaRegionSslCertificates
	MockRegionSslCertificates              *MockRegionSslCertificates
	MockSslPolicies                        *MockSslPolicies
	MockRegionSslPolicies                  *MockRegionSslPolicies
	MockAlphaSubnetworks                   *MockAlphaSubnetworks
	MockBetaSubnetworks                    *MockBetaSubnetworks
	MockSubnetworks                        *MockSubnetworks
	MockAlphaTargetHttpProxies             *MockAlphaTargetHttpProxies
	MockBetaTargetHttpProxies              *MockBetaTargetHttpProxies
	MockTargetHttpProxies                  *MockTargetHttpProxies
	MockAlphaRegionTargetHttpProxies       *MockAlphaRegionTargetHttpProxies
	MockBetaRegionTargetHttpProxies        *MockBetaRegionTargetHttpProxies
	MockRegionTargetHttpProxies            *MockRegionTargetHttpProxies
	MockTargetHttpsProxies                 *MockTargetHttpsProxies
	MockAlphaTargetHttpsProxies            *MockAlphaTargetHttpsProxies
	MockBetaTargetHttpsProxies             *MockBetaTargetHttpsProxies
	MockAlphaRegionTargetHttpsProxies      *MockAlphaRegionTargetHttpsProxies
	MockBetaRegionTargetHttpsProxies       *MockBetaRegionTargetHttpsProxies
	MockRegionTargetHttpsProxies           *MockRegionTargetHttpsProxies
	MockTargetPools                        *MockTargetPools
	MockAlphaTargetTcpProxies              *MockAlphaTargetTcpProxies
	MockBetaTargetTcpProxies               *MockBetaTargetTcpProxies
	MockTargetTcpProxies                   *MockTargetTcpProxies
	MockAlphaUrlMaps                       *MockAlphaUrlMaps
	MockBetaUrlMaps                        *MockBetaUrlMaps
	MockUrlMaps                            *MockUrlMaps
	MockAlphaRegionUrlMaps                 *MockAlphaRegionUrlMaps
	MockBetaRegionUrlMaps                  *MockBetaRegionUrlMaps
	MockRegionUrlMaps                      *MockRegionUrlMaps
	MockZones                              *MockZones
	MockTcpRoutes                          *MockTcpRoutes
	MockBetaTcpRoutes                      *MockBetaTcpRoutes
	MockMeshes                             *MockMeshes
	MockBetaMeshes                         *MockBetaMeshes
}

// Addresses returns the interface for the ga Addresses.
func (mock *MockGCE) Addresses() Addresses {
	return mock.MockAddresses
}

// AlphaAddresses returns the interface for the alpha Addresses.
func (mock *MockGCE) AlphaAddresses() AlphaAddresses {
	return mock.MockAlphaAddresses
}

// BetaAddresses returns the interface for the beta Addresses.
func (mock *MockGCE) BetaAddresses() BetaAddresses {
	return mock.MockBetaAddresses
}

// AlphaGlobalAddresses returns the interface for the alpha GlobalAddresses.
func (mock *MockGCE) AlphaGlobalAddresses() AlphaGlobalAddresses {
	return mock.MockAlphaGlobalAddresses
}

// BetaGlobalAddresses returns the interface for the beta GlobalAddresses.
func (mock *MockGCE) BetaGlobalAddresses() BetaGlobalAddresses {
	return mock.MockBetaGlobalAddresses
}

// GlobalAddresses returns the interface for the ga GlobalAddresses.
func (mock *MockGCE) GlobalAddresses() GlobalAddresses {
	return mock.MockGlobalAddresses
}

// BackendServices returns the interface for the ga BackendServices.
func (mock *MockGCE) BackendServices() BackendServices {
	return mock.MockBackendServices
}

// BetaBackendServices returns the interface for the beta BackendServices.
func (mock *MockGCE) BetaBackendServices() BetaBackendServices {
	return mock.MockBetaBackendServices
}

// AlphaBackendServices returns the interface for the alpha BackendServices.
func (mock *MockGCE) AlphaBackendServices() AlphaBackendServices {
	return mock.MockAlphaBackendServices
}

// RegionBackendServices returns the interface for the ga RegionBackendServices.
func (mock *MockGCE) RegionBackendServices() RegionBackendServices {
	return mock.MockRegionBackendServices
}

// AlphaRegionBackendServices returns the interface for the alpha RegionBackendServices.
func (mock *MockGCE) AlphaRegionBackendServices() AlphaRegionBackendServices {
	return mock.MockAlphaRegionBackendServices
}

// BetaRegionBackendServices returns the interface for the beta RegionBackendServices.
func (mock *MockGCE) BetaRegionBackendServices() BetaRegionBackendServices {
	return mock.MockBetaRegionBackendServices
}

// Disks returns the interface for the ga Disks.
func (mock *MockGCE) Disks() Disks {
	return mock.MockDisks
}

// RegionDisks returns the interface for the ga RegionDisks.
func (mock *MockGCE) RegionDisks() RegionDisks {
	return mock.MockRegionDisks
}

// AlphaFirewalls returns the interface for the alpha Firewalls.
func (mock *MockGCE) AlphaFirewalls() AlphaFirewalls {
	return mock.MockAlphaFirewalls
}

// BetaFirewalls returns the interface for the beta Firewalls.
func (mock *MockGCE) BetaFirewalls() BetaFirewalls {
	return mock.MockBetaFirewalls
}

// Firewalls returns the interface for the ga Firewalls.
func (mock *MockGCE) Firewalls() Firewalls {
	return mock.MockFirewalls
}

// AlphaNetworkFirewallPolicies returns the interface for the alpha NetworkFirewallPolicies.
func (mock *MockGCE) AlphaNetworkFirewallPolicies() AlphaNetworkFirewallPolicies {
	return mock.MockAlphaNetworkFirewallPolicies
}

// AlphaRegionNetworkFirewallPolicies returns the interface for the alpha RegionNetworkFirewallPolicies.
func (mock *MockGCE) AlphaRegionNetworkFirewallPolicies() AlphaRegionNetworkFirewallPolicies {
	return mock.MockAlphaRegionNetworkFirewallPolicies
}

// ForwardingRules returns the interface for the ga ForwardingRules.
func (mock *MockGCE) ForwardingRules() ForwardingRules {
	return mock.MockForwardingRules
}

// AlphaForwardingRules returns the interface for the alpha ForwardingRules.
func (mock *MockGCE) AlphaForwardingRules() AlphaForwardingRules {
	return mock.MockAlphaForwardingRules
}

// BetaForwardingRules returns the interface for the beta ForwardingRules.
func (mock *MockGCE) BetaForwardingRules() BetaForwardingRules {
	return mock.MockBetaForwardingRules
}

// AlphaGlobalForwardingRules returns the interface for the alpha GlobalForwardingRules.
func (mock *MockGCE) AlphaGlobalForwardingRules() AlphaGlobalForwardingRules {
	return mock.MockAlphaGlobalForwardingRules
}

// BetaGlobalForwardingRules returns the interface for the beta GlobalForwardingRules.
func (mock *MockGCE) BetaGlobalForwardingRules() BetaGlobalForwardingRules {
	return mock.MockBetaGlobalForwardingRules
}

// GlobalForwardingRules returns the interface for the ga GlobalForwardingRules.
func (mock *MockGCE) GlobalForwardingRules() GlobalForwardingRules {
	return mock.MockGlobalForwardingRules
}

// HealthChecks returns the interface for the ga HealthChecks.
func (mock *MockGCE) HealthChecks() HealthChecks {
	return mock.MockHealthChecks
}

// AlphaHealthChecks returns the interface for the alpha HealthChecks.
func (mock *MockGCE) AlphaHealthChecks() AlphaHealthChecks {
	return mock.MockAlphaHealthChecks
}

// BetaHealthChecks returns the interface for the beta HealthChecks.
func (mock *MockGCE) BetaHealthChecks() BetaHealthChecks {
	return mock.MockBetaHealthChecks
}

// AlphaRegionHealthChecks returns the interface for the alpha RegionHealthChecks.
func (mock *MockGCE) AlphaRegionHealthChecks() AlphaRegionHealthChecks {
	return mock.MockAlphaRegionHealthChecks
}

// BetaRegionHealthChecks returns the interface for the beta RegionHealthChecks.
func (mock *MockGCE) BetaRegionHealthChecks() BetaRegionHealthChecks {
	return mock.MockBetaRegionHealthChecks
}

// RegionHealthChecks returns the interface for the ga RegionHealthChecks.
func (mock *MockGCE) RegionHealthChecks() RegionHealthChecks {
	return mock.MockRegionHealthChecks
}

// HttpHealthChecks returns the interface for the ga HttpHealthChecks.
func (mock *MockGCE) HttpHealthChecks() HttpHealthChecks {
	return mock.MockHttpHealthChecks
}

// HttpsHealthChecks returns the interface for the ga HttpsHealthChecks.
func (mock *MockGCE) HttpsHealthChecks() HttpsHealthChecks {
	return mock.MockHttpsHealthChecks
}

// InstanceGroups returns the interface for the ga InstanceGroups.
func (mock *MockGCE) InstanceGroups() InstanceGroups {
	return mock.MockInstanceGroups
}

// Instances returns the interface for the ga Instances.
func (mock *MockGCE) Instances() Instances {
	return mock.MockInstances
}

// BetaInstances returns the interface for the beta Instances.
func (mock *MockGCE) BetaInstances() BetaInstances {
	return mock.MockBetaInstances
}

// AlphaInstances returns the interface for the alpha Instances.
func (mock *MockGCE) AlphaInstances() AlphaInstances {
	return mock.MockAlphaInstances
}

// InstanceGroupManagers returns the interface for the ga InstanceGroupManagers.
func (mock *MockGCE) InstanceGroupManagers() InstanceGroupManagers {
	return mock.MockInstanceGroupManagers
}

// InstanceTemplates returns the interface for the ga InstanceTemplates.
func (mock *MockGCE) InstanceTemplates() InstanceTemplates {
	return mock.MockInstanceTemplates
}

// Images returns the interface for the ga Images.
func (mock *MockGCE) Images() Images {
	return mock.MockImages
}

// BetaImages returns the interface for the beta Images.
func (mock *MockGCE) BetaImages() BetaImages {
	return mock.MockBetaImages
}

// AlphaImages returns the interface for the alpha Images.
func (mock *MockGCE) AlphaImages() AlphaImages {
	return mock.MockAlphaImages
}

// AlphaNetworks returns the interface for the alpha Networks.
func (mock *MockGCE) AlphaNetworks() AlphaNetworks {
	return mock.MockAlphaNetworks
}

// BetaNetworks returns the interface for the beta Networks.
func (mock *MockGCE) BetaNetworks() BetaNetworks {
	return mock.MockBetaNetworks
}

// Networks returns the interface for the ga Networks.
func (mock *MockGCE) Networks() Networks {
	return mock.MockNetworks
}

// AlphaNetworkEndpointGroups returns the interface for the alpha NetworkEndpointGroups.
func (mock *MockGCE) AlphaNetworkEndpointGroups() AlphaNetworkEndpointGroups {
	return mock.MockAlphaNetworkEndpointGroups
}

// BetaNetworkEndpointGroups returns the interface for the beta NetworkEndpointGroups.
func (mock *MockGCE) BetaNetworkEndpointGroups() BetaNetworkEndpointGroups {
	return mock.MockBetaNetworkEndpointGroups
}

// NetworkEndpointGroups returns the interface for the ga NetworkEndpointGroups.
func (mock *MockGCE) NetworkEndpointGroups() NetworkEndpointGroups {
	return mock.MockNetworkEndpointGroups
}

// AlphaGlobalNetworkEndpointGroups returns the interface for the alpha GlobalNetworkEndpointGroups.
func (mock *MockGCE) AlphaGlobalNetworkEndpointGroups() AlphaGlobalNetworkEndpointGroups {
	return mock.MockAlphaGlobalNetworkEndpointGroups
}

// BetaGlobalNetworkEndpointGroups returns the interface for the beta GlobalNetworkEndpointGroups.
func (mock *MockGCE) BetaGlobalNetworkEndpointGroups() BetaGlobalNetworkEndpointGroups {
	return mock.MockBetaGlobalNetworkEndpointGroups
}

// GlobalNetworkEndpointGroups returns the interface for the ga GlobalNetworkEndpointGroups.
func (mock *MockGCE) GlobalNetworkEndpointGroups() GlobalNetworkEndpointGroups {
	return mock.MockGlobalNetworkEndpointGroups
}

// Projects returns the interface for the ga Projects.
func (mock *MockGCE) Projects() Projects {
	return mock.MockProjects
}

// Regions returns the interface for the ga Regions.
func (mock *MockGCE) Regions() Regions {
	return mock.MockRegions
}

// AlphaRouters returns the interface for the alpha Routers.
func (mock *MockGCE) AlphaRouters() AlphaRouters {
	return mock.MockAlphaRouters
}

// BetaRouters returns the interface for the beta Routers.
func (mock *MockGCE) BetaRouters() BetaRouters {
	return mock.MockBetaRouters
}

// Routers returns the interface for the ga Routers.
func (mock *MockGCE) Routers() Routers {
	return mock.MockRouters
}

// Routes returns the interface for the ga Routes.
func (mock *MockGCE) Routes() Routes {
	return mock.MockRoutes
}

// BetaSecurityPolicies returns the interface for the beta SecurityPolicies.
func (mock *MockGCE) BetaSecurityPolicies() BetaSecurityPolicies {
	return mock.MockBetaSecurityPolicies
}

// ServiceAttachments returns the interface for the ga ServiceAttachments.
func (mock *MockGCE) ServiceAttachments() ServiceAttachments {
	return mock.MockServiceAttachments
}

// BetaServiceAttachments returns the interface for the beta ServiceAttachments.
func (mock *MockGCE) BetaServiceAttachments() BetaServiceAttachments {
	return mock.MockBetaServiceAttachments
}

// AlphaServiceAttachments returns the interface for the alpha ServiceAttachments.
func (mock *MockGCE) AlphaServiceAttachments() AlphaServiceAttachments {
	return mock.MockAlphaServiceAttachments
}

// SslCertificates returns the interface for the ga SslCertificates.
func (mock *MockGCE) SslCertificates() SslCertificates {
	return mock.MockSslCertificates
}

// BetaSslCertificates returns the interface for the beta SslCertificates.
func (mock *MockGCE) BetaSslCertificates() BetaSslCertificates {
	return mock.MockBetaSslCertificates
}

// AlphaSslCertificates returns the interface for the alpha SslCertificates.
func (mock *MockGCE) AlphaSslCertificates() AlphaSslCertificates {
	return mock.MockAlphaSslCertificates
}

// AlphaRegionSslCertificates returns the interface for the alpha RegionSslCertificates.
func (mock *MockGCE) AlphaRegionSslCertificates() AlphaRegionSslCertificates {
	return mock.MockAlphaRegionSslCertificates
}

// BetaRegionSslCertificates returns the interface for the beta RegionSslCertificates.
func (mock *MockGCE) BetaRegionSslCertificates() BetaRegionSslCertificates {
	return mock.MockBetaRegionSslCertificates
}

// RegionSslCertificates returns the interface for the ga RegionSslCertificates.
func (mock *MockGCE) RegionSslCertificates() RegionSslCertificates {
	return mock.MockRegionSslCertificates
}

// SslPolicies returns the interface for the ga SslPolicies.
func (mock *MockGCE) SslPolicies() SslPolicies {
	return mock.MockSslPolicies
}

// RegionSslPolicies returns the interface for the ga RegionSslPolicies.
func (mock *MockGCE) RegionSslPolicies() RegionSslPolicies {
	return mock.MockRegionSslPolicies
}

// AlphaSubnetworks returns the interface for the alpha Subnetworks.
func (mock *MockGCE) AlphaSubnetworks() AlphaSubnetworks {
	return mock.MockAlphaSubnetworks
}

// BetaSubnetworks returns the interface for the beta Subnetworks.
func (mock *MockGCE) BetaSubnetworks() BetaSubnetworks {
	return mock.MockBetaSubnetworks
}

// Subnetworks returns the interface for the ga Subnetworks.
func (mock *MockGCE) Subnetworks() Subnetworks {
	return mock.MockSubnetworks
}

// AlphaTargetHttpProxies returns the interface for the alpha TargetHttpProxies.
func (mock *MockGCE) AlphaTargetHttpProxies() AlphaTargetHttpProxies {
	return mock.MockAlphaTargetHttpProxies
}

// BetaTargetHttpProxies returns the interface for the beta TargetHttpProxies.
func (mock *MockGCE) BetaTargetHttpProxies() BetaTargetHttpProxies {
	return mock.MockBetaTargetHttpProxies
}

// TargetHttpProxies returns the interface for the ga TargetHttpProxies.
func (mock *MockGCE) TargetHttpProxies() TargetHttpProxies {
	return mock.MockTargetHttpProxies
}

// AlphaRegionTargetHttpProxies returns the interface for the alpha RegionTargetHttpProxies.
func (mock *MockGCE) AlphaRegionTargetHttpProxies() AlphaRegionTargetHttpProxies {
	return mock.MockAlphaRegionTargetHttpProxies
}

// BetaRegionTargetHttpProxies returns the interface for the beta RegionTargetHttpProxies.
func (mock *MockGCE) BetaRegionTargetHttpProxies() BetaRegionTargetHttpProxies {
	return mock.MockBetaRegionTargetHttpProxies
}

// RegionTargetHttpProxies returns the interface for the ga RegionTargetHttpProxies.
func (mock *MockGCE) RegionTargetHttpProxies() RegionTargetHttpProxies {
	return mock.MockRegionTargetHttpProxies
}

// TargetHttpsProxies returns the interface for the ga TargetHttpsProxies.
func (mock *MockGCE) TargetHttpsProxies() TargetHttpsProxies {
	return mock.MockTargetHttpsProxies
}

// AlphaTargetHttpsProxies returns the interface for the alpha TargetHttpsProxies.
func (mock *MockGCE) AlphaTargetHttpsProxies() AlphaTargetHttpsProxies {
	return mock.MockAlphaTargetHttpsProxies
}

// BetaTargetHttpsProxies returns the interface for the beta TargetHttpsProxies.
func (mock *MockGCE) BetaTargetHttpsProxies() BetaTargetHttpsProxies {
	return mock.MockBetaTargetHttpsProxies
}

// AlphaRegionTargetHttpsProxies returns the interface for the alpha RegionTargetHttpsProxies.
func (mock *MockGCE) AlphaRegionTargetHttpsProxies() AlphaRegionTargetHttpsProxies {
	return mock.MockAlphaRegionTargetHttpsProxies
}

// BetaRegionTargetHttpsProxies returns the interface for the beta RegionTargetHttpsProxies.
func (mock *MockGCE) BetaRegionTargetHttpsProxies() BetaRegionTargetHttpsProxies {
	return mock.MockBetaRegionTargetHttpsProxies
}

// RegionTargetHttpsProxies returns the interface for the ga RegionTargetHttpsProxies.
func (mock *MockGCE) RegionTargetHttpsProxies() RegionTargetHttpsProxies {
	return mock.MockRegionTargetHttpsProxies
}

// TargetPools returns the interface for the ga TargetPools.
func (mock *MockGCE) TargetPools() TargetPools {
	return mock.MockTargetPools
}

// AlphaTargetTcpProxies returns the interface for the alpha TargetTcpProxies.
func (mock *MockGCE) AlphaTargetTcpProxies() AlphaTargetTcpProxies {
	return mock.MockAlphaTargetTcpProxies
}

// BetaTargetTcpProxies returns the interface for the beta TargetTcpProxies.
func (mock *MockGCE) BetaTargetTcpProxies() BetaTargetTcpProxies {
	return mock.MockBetaTargetTcpProxies
}

// TargetTcpProxies returns the interface for the ga TargetTcpProxies.
func (mock *MockGCE) TargetTcpProxies() TargetTcpProxies {
	return mock.MockTargetTcpProxies
}

// AlphaUrlMaps returns the interface for the alpha UrlMaps.
func (mock *MockGCE) AlphaUrlMaps() AlphaUrlMaps {
	return mock.MockAlphaUrlMaps
}

// BetaUrlMaps returns the interface for the beta UrlMaps.
func (mock *MockGCE) BetaUrlMaps() BetaUrlMaps {
	return mock.MockBetaUrlMaps
}

// UrlMaps returns the interface for the ga UrlMaps.
func (mock *MockGCE) UrlMaps() UrlMaps {
	return mock.MockUrlMaps
}

// AlphaRegionUrlMaps returns the interface for the alpha RegionUrlMaps.
func (mock *MockGCE) AlphaRegionUrlMaps() AlphaRegionUrlMaps {
	return mock.MockAlphaRegionUrlMaps
}

// BetaRegionUrlMaps returns the interface for the beta RegionUrlMaps.
func (mock *MockGCE) BetaRegionUrlMaps() BetaRegionUrlMaps {
	return mock.MockBetaRegionUrlMaps
}

// RegionUrlMaps returns the interface for the ga RegionUrlMaps.
func (mock *MockGCE) RegionUrlMaps() RegionUrlMaps {
	return mock.MockRegionUrlMaps
}

// Zones returns the interface for the ga Zones.
func (mock *MockGCE) Zones() Zones {
	return mock.MockZones
}

// TcpRoutes returns the interface for the ga TcpRoutes.
func (mock *MockGCE) TcpRoutes() TcpRoutes {
	return mock.MockTcpRoutes
}

// BetaTcpRoutes returns the interface for the beta TcpRoutes.
func (mock *MockGCE) BetaTcpRoutes() BetaTcpRoutes {
	return mock.MockBetaTcpRoutes
}

// Meshes returns the interface for the ga Meshes.
func (mock *MockGCE) Meshes() Meshes {
	return mock.MockMeshes
}

// BetaMeshes returns the interface for the beta Meshes.
func (mock *MockGCE) BetaMeshes() BetaMeshes {
	return mock.MockBetaMeshes
}

// MockAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockAddressesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockAddressesObj) ToAlpha() *computealpha.Address {
	if ret, ok := m.Obj.(*computealpha.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockAddressesObj) ToBeta() *computebeta.Address {
	if ret, ok := m.Obj.(*computebeta.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockAddressesObj) ToGA() *computega.Address {
	if ret, ok := m.Obj.(*computega.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockBackendServicesObj) ToAlpha() *computealpha.BackendService {
	if ret, ok := m.Obj.(*computealpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockBackendServicesObj) ToBeta() *computebeta.BackendService {
	if ret, ok := m.Obj.(*computebeta.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockBackendServicesObj) ToGA() *computega.BackendService {
	if ret, ok := m.Obj.(*computega.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockDisksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockDisksObj) ToGA() *computega.Disk {
	if ret, ok := m.Obj.(*computega.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockFirewallsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockFirewallsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockFirewallsObj) ToAlpha() *computealpha.Firewall {
	if ret, ok := m.Obj.(*computealpha.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockFirewallsObj) ToBeta() *computebeta.Firewall {
	if ret, ok := m.Obj.(*computebeta.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockFirewallsObj) ToGA() *computega.Firewall {
	if ret, ok := m.Obj.(*computega.Firewall); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Firewall{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Firewall via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockForwardingRulesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToAlpha() *computealpha.ForwardingRule {
	if ret, ok := m.Obj.(*computealpha.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToBeta() *computebeta.ForwardingRule {
	if ret, ok := m.Obj.(*computebeta.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockForwardingRulesObj) ToGA() *computega.ForwardingRule {
	if ret, ok := m.Obj.(*computega.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalAddressesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalAddressesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToAlpha() *computealpha.Address {
	if ret, ok := m.Obj.(*computealpha.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToBeta() *computebeta.Address {
	if ret, ok := m.Obj.(*computebeta.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalAddressesObj) ToGA() *computega.Address {
	if ret, ok := m.Obj.(*computega.Address); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Address{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Address via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalForwardingRulesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalForwardingRulesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToAlpha() *computealpha.ForwardingRule {
	if ret, ok := m.Obj.(*computealpha.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToBeta() *computebeta.ForwardingRule {
	if ret, ok := m.Obj.(*computebeta.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalForwardingRulesObj) ToGA() *computega.ForwardingRule {
	if ret, ok := m.Obj.(*computega.ForwardingRule); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.ForwardingRule{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.ForwardingRule via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockGlobalNetworkEndpointGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockGlobalNetworkEndpointGroupsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockGlobalNetworkEndpointGroupsObj) ToAlpha() *computealpha.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computealpha.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockGlobalNetworkEndpointGroupsObj) ToBeta() *computebeta.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computebeta.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockGlobalNetworkEndpointGroupsObj) ToGA() *computega.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computega.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHealthChecksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockHealthChecksObj) ToAlpha() *computealpha.HealthCheck {
	if ret, ok := m.Obj.(*computealpha.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockHealthChecksObj) ToBeta() *computebeta.HealthCheck {
	if ret, ok := m.Obj.(*computebeta.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockHealthChecksObj) ToGA() *computega.HealthCheck {
	if ret, ok := m.Obj.(*computega.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpHealthChecksObj) ToGA() *computega.HttpHealthCheck {
	if ret, ok := m.Obj.(*computega.HttpHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.HttpHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.HttpHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockHttpsHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockHttpsHealthChecksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockHttpsHealthChecksObj) ToGA() *computega.HttpsHealthCheck {
	if ret, ok := m.Obj.(*computega.HttpsHealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.HttpsHealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.HttpsHealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockImagesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockImagesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockImagesObj) ToAlpha() *computealpha.Image {
	if ret, ok := m.Obj.(*computealpha.Image); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Image{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Image via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockImagesObj) ToBeta() *computebeta.Image {
	if ret, ok := m.Obj.(*computebeta.Image); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Image{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Image via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockImagesObj) ToGA() *computega.Image {
	if ret, ok := m.Obj.(*computega.Image); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Image{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Image via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstanceGroupManagersObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstanceGroupManagersObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockInstanceGroupManagersObj) ToGA() *computega.InstanceGroupManager {
	if ret, ok := m.Obj.(*computega.InstanceGroupManager); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.InstanceGroupManager{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.InstanceGroupManager via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstanceGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstanceGroupsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockInstanceGroupsObj) ToGA() *computega.InstanceGroup {
	if ret, ok := m.Obj.(*computega.InstanceGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.InstanceGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.InstanceGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstanceTemplatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstanceTemplatesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockInstanceTemplatesObj) ToGA() *computega.InstanceTemplate {
	if ret, ok := m.Obj.(*computega.InstanceTemplate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.InstanceTemplate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.InstanceTemplate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockInstancesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockInstancesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockInstancesObj) ToAlpha() *computealpha.Instance {
	if ret, ok := m.Obj.(*computealpha.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockInstancesObj) ToBeta() *computebeta.Instance {
	if ret, ok := m.Obj.(*computebeta.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockInstancesObj) ToGA() *computega.Instance {
	if ret, ok := m.Obj.(*computega.Instance); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Instance{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Instance via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockMeshesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockMeshesObj struct {
	Obj interface{}
}

// ToBeta retrieves the given version of the object.
func (m *MockMeshesObj) ToBeta() *networkservicesbeta.Mesh {
	if ret, ok := m.Obj.(*networkservicesbeta.Mesh); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &networkservicesbeta.Mesh{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *networkservicesbeta.Mesh via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockMeshesObj) ToGA() *networkservicesga.Mesh {
	if ret, ok := m.Obj.(*networkservicesga.Mesh); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &networkservicesga.Mesh{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *networkservicesga.Mesh via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworkEndpointGroupsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworkEndpointGroupsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToAlpha() *computealpha.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computealpha.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToBeta() *computebeta.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computebeta.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockNetworkEndpointGroupsObj) ToGA() *computega.NetworkEndpointGroup {
	if ret, ok := m.Obj.(*computega.NetworkEndpointGroup); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.NetworkEndpointGroup{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.NetworkEndpointGroup via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworkFirewallPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworkFirewallPoliciesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworkFirewallPoliciesObj) ToAlpha() *computealpha.FirewallPolicy {
	if ret, ok := m.Obj.(*computealpha.FirewallPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.FirewallPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.FirewallPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockNetworksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockNetworksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockNetworksObj) ToAlpha() *computealpha.Network {
	if ret, ok := m.Obj.(*computealpha.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockNetworksObj) ToBeta() *computebeta.Network {
	if ret, ok := m.Obj.(*computebeta.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockNetworksObj) ToGA() *computega.Network {
	if ret, ok := m.Obj.(*computega.Network); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Network{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Network via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockProjectsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockProjectsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockProjectsObj) ToGA() *computega.Project {
	if ret, ok := m.Obj.(*computega.Project); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Project{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Project via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionBackendServicesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionBackendServicesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToAlpha() *computealpha.BackendService {
	if ret, ok := m.Obj.(*computealpha.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToBeta() *computebeta.BackendService {
	if ret, ok := m.Obj.(*computebeta.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionBackendServicesObj) ToGA() *computega.BackendService {
	if ret, ok := m.Obj.(*computega.BackendService); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.BackendService{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.BackendService via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionDisksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionDisksObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionDisksObj) ToGA() *computega.Disk {
	if ret, ok := m.Obj.(*computega.Disk); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Disk{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Disk via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionHealthChecksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionHealthChecksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToAlpha() *computealpha.HealthCheck {
	if ret, ok := m.Obj.(*computealpha.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToBeta() *computebeta.HealthCheck {
	if ret, ok := m.Obj.(*computebeta.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionHealthChecksObj) ToGA() *computega.HealthCheck {
	if ret, ok := m.Obj.(*computega.HealthCheck); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.HealthCheck{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.HealthCheck via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionNetworkFirewallPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionNetworkFirewallPoliciesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionNetworkFirewallPoliciesObj) ToAlpha() *computealpha.FirewallPolicy {
	if ret, ok := m.Obj.(*computealpha.FirewallPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.FirewallPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.FirewallPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionSslCertificatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionSslCertificatesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToAlpha() *computealpha.SslCertificate {
	if ret, ok := m.Obj.(*computealpha.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToBeta() *computebeta.SslCertificate {
	if ret, ok := m.Obj.(*computebeta.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionSslCertificatesObj) ToGA() *computega.SslCertificate {
	if ret, ok := m.Obj.(*computega.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionSslPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionSslPoliciesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionSslPoliciesObj) ToGA() *computega.SslPolicy {
	if ret, ok := m.Obj.(*computega.SslPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.SslPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.SslPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionTargetHttpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionTargetHttpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToAlpha() *computealpha.TargetHttpProxy {
	if ret, ok := m.Obj.(*computealpha.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToBeta() *computebeta.TargetHttpProxy {
	if ret, ok := m.Obj.(*computebeta.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionTargetHttpProxiesObj) ToGA() *computega.TargetHttpProxy {
	if ret, ok := m.Obj.(*computega.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionTargetHttpsProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionTargetHttpsProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToAlpha() *computealpha.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computealpha.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToBeta() *computebeta.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computebeta.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionTargetHttpsProxiesObj) ToGA() *computega.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computega.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionUrlMapsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionUrlMapsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToAlpha() *computealpha.UrlMap {
	if ret, ok := m.Obj.(*computealpha.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToBeta() *computebeta.UrlMap {
	if ret, ok := m.Obj.(*computebeta.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRegionUrlMapsObj) ToGA() *computega.UrlMap {
	if ret, ok := m.Obj.(*computega.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRegionsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRegionsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRegionsObj) ToGA() *computega.Region {
	if ret, ok := m.Obj.(*computega.Region); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Region{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Region via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRoutersObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRoutersObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockRoutersObj) ToAlpha() *computealpha.Router {
	if ret, ok := m.Obj.(*computealpha.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockRoutersObj) ToBeta() *computebeta.Router {
	if ret, ok := m.Obj.(*computebeta.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockRoutersObj) ToGA() *computega.Router {
	if ret, ok := m.Obj.(*computega.Router); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Router{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Router via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockRoutesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockRoutesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockRoutesObj) ToGA() *computega.Route {
	if ret, ok := m.Obj.(*computega.Route); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Route{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Route via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSecurityPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSecurityPoliciesObj struct {
	Obj interface{}
}

// ToBeta retrieves the given version of the object.
func (m *MockSecurityPoliciesObj) ToBeta() *computebeta.SecurityPolicy {
	if ret, ok := m.Obj.(*computebeta.SecurityPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.SecurityPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.SecurityPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockServiceAttachmentsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockServiceAttachmentsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockServiceAttachmentsObj) ToAlpha() *computealpha.ServiceAttachment {
	if ret, ok := m.Obj.(*computealpha.ServiceAttachment); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.ServiceAttachment{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.ServiceAttachment via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockServiceAttachmentsObj) ToBeta() *computebeta.ServiceAttachment {
	if ret, ok := m.Obj.(*computebeta.ServiceAttachment); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.ServiceAttachment{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.ServiceAttachment via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockServiceAttachmentsObj) ToGA() *computega.ServiceAttachment {
	if ret, ok := m.Obj.(*computega.ServiceAttachment); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.ServiceAttachment{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.ServiceAttachment via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSslCertificatesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSslCertificatesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToAlpha() *computealpha.SslCertificate {
	if ret, ok := m.Obj.(*computealpha.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToBeta() *computebeta.SslCertificate {
	if ret, ok := m.Obj.(*computebeta.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockSslCertificatesObj) ToGA() *computega.SslCertificate {
	if ret, ok := m.Obj.(*computega.SslCertificate); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.SslCertificate{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.SslCertificate via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSslPoliciesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSslPoliciesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockSslPoliciesObj) ToGA() *computega.SslPolicy {
	if ret, ok := m.Obj.(*computega.SslPolicy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.SslPolicy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.SslPolicy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockSubnetworksObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockSubnetworksObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockSubnetworksObj) ToAlpha() *computealpha.Subnetwork {
	if ret, ok := m.Obj.(*computealpha.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockSubnetworksObj) ToBeta() *computebeta.Subnetwork {
	if ret, ok := m.Obj.(*computebeta.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockSubnetworksObj) ToGA() *computega.Subnetwork {
	if ret, ok := m.Obj.(*computega.Subnetwork); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Subnetwork{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Subnetwork via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToAlpha() *computealpha.TargetHttpProxy {
	if ret, ok := m.Obj.(*computealpha.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToBeta() *computebeta.TargetHttpProxy {
	if ret, ok := m.Obj.(*computebeta.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpProxiesObj) ToGA() *computega.TargetHttpProxy {
	if ret, ok := m.Obj.(*computega.TargetHttpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetHttpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetHttpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetHttpsProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetHttpsProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToAlpha() *computealpha.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computealpha.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToBeta() *computebeta.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computebeta.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTargetHttpsProxiesObj) ToGA() *computega.TargetHttpsProxy {
	if ret, ok := m.Obj.(*computega.TargetHttpsProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetHttpsProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetHttpsProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetPoolsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetPoolsObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockTargetPoolsObj) ToGA() *computega.TargetPool {
	if ret, ok := m.Obj.(*computega.TargetPool); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetPool{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetPool via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTargetTcpProxiesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTargetTcpProxiesObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockTargetTcpProxiesObj) ToAlpha() *computealpha.TargetTcpProxy {
	if ret, ok := m.Obj.(*computealpha.TargetTcpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.TargetTcpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.TargetTcpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockTargetTcpProxiesObj) ToBeta() *computebeta.TargetTcpProxy {
	if ret, ok := m.Obj.(*computebeta.TargetTcpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.TargetTcpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.TargetTcpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTargetTcpProxiesObj) ToGA() *computega.TargetTcpProxy {
	if ret, ok := m.Obj.(*computega.TargetTcpProxy); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.TargetTcpProxy{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.TargetTcpProxy via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockTcpRoutesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockTcpRoutesObj struct {
	Obj interface{}
}

// ToBeta retrieves the given version of the object.
func (m *MockTcpRoutesObj) ToBeta() *networkservicesbeta.TcpRoute {
	if ret, ok := m.Obj.(*networkservicesbeta.TcpRoute); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &networkservicesbeta.TcpRoute{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *networkservicesbeta.TcpRoute via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockTcpRoutesObj) ToGA() *networkservicesga.TcpRoute {
	if ret, ok := m.Obj.(*networkservicesga.TcpRoute); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &networkservicesga.TcpRoute{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *networkservicesga.TcpRoute via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockUrlMapsObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockUrlMapsObj struct {
	Obj interface{}
}

// ToAlpha retrieves the given version of the object.
func (m *MockUrlMapsObj) ToAlpha() *computealpha.UrlMap {
	if ret, ok := m.Obj.(*computealpha.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computealpha.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computealpha.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToBeta retrieves the given version of the object.
func (m *MockUrlMapsObj) ToBeta() *computebeta.UrlMap {
	if ret, ok := m.Obj.(*computebeta.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computebeta.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computebeta.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// ToGA retrieves the given version of the object.
func (m *MockUrlMapsObj) ToGA() *computega.UrlMap {
	if ret, ok := m.Obj.(*computega.UrlMap); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.UrlMap{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.UrlMap via JSON: %v", m.Obj, err)
	}
	return ret
}

// MockZonesObj is used to store the various object versions in the shared
// map of mocked objects. This allows for multiple API versions to co-exist and
// share the same "view" of the objects in the backend.
type MockZonesObj struct {
	Obj interface{}
}

// ToGA retrieves the given version of the object.
func (m *MockZonesObj) ToGA() *computega.Zone {
	if ret, ok := m.Obj.(*computega.Zone); ok {
		return ret
	}
	// Convert the object via JSON copying to the type that was requested.
	ret := &computega.Zone{}
	if err := copyViaJSON(ret, m.Obj); err != nil {
		klog.Errorf("Could not convert %T to *computega.Zone via JSON: %v", m.Obj, err)
	}
	return ret
}

// Addresses is an interface that allows for mocking of Addresses.
type Addresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.Address, error)
}

// NewMockAddresses returns a new mock for Addresses.
func NewMockAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAddresses {
	mock := &MockAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAddresses is the mock for Addresses.
type MockAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockAddresses, options ...Option) (bool, *computega.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockAddresses, options ...Option) (bool, []*computega.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *computega.Address, m *MockAddresses, options ...Option) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockAddresses, options ...Option) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockAddresses, options ...Option) (bool, map[string][]*computega.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAddresses) Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computega.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAddresses) Obj(o *computega.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAddresses is a simplifying adapter for the GCE Addresses.
type GCEAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAddresses.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAddresses.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.GA.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Address
	f := func(l *computega.AddressList) error {
		klog.V(5).Infof("GCEAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAddresses) Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Addresses.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computega.Address{}
	f := func(l *computega.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AlphaAddresses is an interface that allows for mocking of Addresses.
type AlphaAddresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.Address, error)
}

// NewMockAlphaAddresses returns a new mock for Addresses.
func NewMockAlphaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockAlphaAddresses {
	mock := &MockAlphaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaAddresses is the mock for Addresses.
type MockAlphaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses, options ...Option) (bool, *computealpha.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockAlphaAddresses, options ...Option) (bool, []*computealpha.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *computealpha.Address, m *MockAlphaAddresses, options ...Option) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockAlphaAddresses, options ...Option) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockAlphaAddresses, options ...Option) (bool, map[string][]*computealpha.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAlphaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockAlphaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computealpha.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaAddresses) Obj(o *computealpha.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEAlphaAddresses is a simplifying adapter for the GCE Addresses.
type GCEAlphaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAlphaAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAlphaAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEAlphaAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaAddresses.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Alpha.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Address
	f := func(l *computealpha.AddressList) error {
		klog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAlphaAddresses) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAlphaAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEAlphaAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Addresses.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computealpha.Address{}
	f := func(l *computealpha.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// BetaAddresses is an interface that allows for mocking of Addresses.
type BetaAddresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.Address, error)
}

// NewMockBetaAddresses returns a new mock for Addresses.
func NewMockBetaAddresses(pr ProjectRouter, objs map[meta.Key]*MockAddressesObj) *MockBetaAddresses {
	mock := &MockBetaAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaAddresses is the mock for Addresses.
type MockBetaAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook            func(ctx context.Context, key *meta.Key, m *MockBetaAddresses, options ...Option) (bool, *computebeta.Address, error)
	ListHook           func(ctx context.Context, region string, fl *filter.F, m *MockBetaAddresses, options ...Option) (bool, []*computebeta.Address, error)
	InsertHook         func(ctx context.Context, key *meta.Key, obj *computebeta.Address, m *MockBetaAddresses, options ...Option) (bool, error)
	DeleteHook         func(ctx context.Context, key *meta.Key, m *MockBetaAddresses, options ...Option) (bool, error)
	AggregatedListHook func(ctx context.Context, fl *filter.F, m *MockBetaAddresses, options ...Option) (bool, map[string][]*computebeta.Address, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
	}
	klog.V(5).Infof("MockBetaAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Address
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaAddresses.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaAddresses %v exists", key),
		}
		klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "addresses", key)

	m.Objects[*key] = &MockAddressesObj{obj}
	klog.V(5).Infof("MockBetaAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaAddresses %v not found", key),
		}
		klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.Address, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computebeta.Address{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaAddresses.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaAddresses) Obj(o *computebeta.Address) *MockAddressesObj {
	return &MockAddressesObj{o}
}

// GCEBetaAddresses is a simplifying adapter for the GCE Addresses.
type GCEBetaAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEBetaAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEBetaAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Addresses.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEBetaAddresses) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaAddresses.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Beta.Addresses.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Address
	f := func(l *computebeta.AddressList) error {
		klog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEBetaAddresses) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Addresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEBetaAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Addresses.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEBetaAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}
	klog.V(5).Infof("GCEBetaAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Addresses.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaAddresses) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Addresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "Addresses",
	}

	klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.Addresses.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computebeta.Address{}
	f := func(l *computebeta.AddressAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.Addresses...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaAddresses.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AlphaGlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type AlphaGlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockAlphaGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockAlphaGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockAlphaGlobalAddresses {
	mock := &MockAlphaGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaGlobalAddresses is the mock for GlobalAddresses.
type MockAlphaGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalAddresses, options ...Option) (bool, *computealpha.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaGlobalAddresses, options ...Option) (bool, []*computealpha.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computealpha.Address, m *MockAlphaGlobalAddresses, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalAddresses, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockAlphaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockAlphaGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaGlobalAddresses) Obj(o *computealpha.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEAlphaGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEAlphaGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEAlphaGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}

	klog.V(5).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEAlphaGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Address
	f := func(l *computealpha.AddressList) error {
		klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEAlphaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEAlphaGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalAddresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaGlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type BetaGlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockBetaGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockBetaGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockBetaGlobalAddresses {
	mock := &MockBetaGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaGlobalAddresses is the mock for GlobalAddresses.
type MockBetaGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaGlobalAddresses, options ...Option) (bool, *computebeta.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaGlobalAddresses, options ...Option) (bool, []*computebeta.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computebeta.Address, m *MockBetaGlobalAddresses, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaGlobalAddresses, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockBetaGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockBetaGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaGlobalAddresses) Obj(o *computebeta.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEBetaGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEBetaGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEBetaGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}

	klog.V(5).Infof("GCEBetaGlobalAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEBetaGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Address
	f := func(l *computebeta.AddressList) error {
		klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEBetaGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEBetaGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalAddresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GlobalAddresses is an interface that allows for mocking of GlobalAddresses.
type GlobalAddresses interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Address, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockGlobalAddresses returns a new mock for GlobalAddresses.
func NewMockGlobalAddresses(pr ProjectRouter, objs map[meta.Key]*MockGlobalAddressesObj) *MockGlobalAddresses {
	mock := &MockGlobalAddresses{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalAddresses is the mock for GlobalAddresses.
type MockGlobalAddresses struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalAddressesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses, options ...Option) (bool, *computega.Address, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockGlobalAddresses, options ...Option) (bool, []*computega.Address, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.Address, m *MockGlobalAddresses, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockGlobalAddresses, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
	}
	klog.V(5).Infof("MockGlobalAddresses.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Address, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Address
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockGlobalAddresses.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalAddresses %v exists", key),
		}
		klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "addresses")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "addresses", key)

	m.Objects[*key] = &MockGlobalAddressesObj{obj}
	klog.V(5).Infof("MockGlobalAddresses.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalAddresses %v not found", key),
		}
		klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockGlobalAddresses.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalAddresses) Obj(o *computega.Address) *MockGlobalAddressesObj {
	return &MockGlobalAddressesObj{o}
}

// GCEGlobalAddresses is a simplifying adapter for the GCE GlobalAddresses.
type GCEGlobalAddresses struct {
	s *Service
}

// Get the Address named by key.
func (g *GCEGlobalAddresses) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}

	klog.V(5).Infof("GCEGlobalAddresses.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalAddresses.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEGlobalAddresses.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Address objects.
func (g *GCEGlobalAddresses) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Address, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalAddresses.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEGlobalAddresses.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.GlobalAddresses.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Address
	f := func(l *computega.AddressList) error {
		klog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEGlobalAddresses.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEGlobalAddresses.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Address with key of value obj.
func (g *GCEGlobalAddresses) Insert(ctx context.Context, key *meta.Key, obj *computega.Address, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalAddresses")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalAddresses.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalAddresses.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Address referenced by key.
func (g *GCEGlobalAddresses) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalAddresses.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalAddresses")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalAddresses",
	}
	klog.V(5).Infof("GCEGlobalAddresses.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalAddresses.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalAddresses.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BackendServices is an interface that allows for mocking of BackendServices.
type BackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.BackendService, error)
	AddSignedUrlKey(context.Context, *meta.Key, *computega.SignedUrlKey, ...Option) error
	DeleteSignedUrlKey(context.Context, *meta.Key, string, ...Option) error
	GetHealth(context.Context, *meta.Key, *computega.ResourceGroupReference, ...Option) (*computega.BackendServiceGroupHealth, error)
	Patch(context.Context, *meta.Key, *computega.BackendService, ...Option) error
	SetSecurityPolicy(context.Context, *meta.Key, *computega.SecurityPolicyReference, ...Option) error
	Update(context.Context, *meta.Key, *computega.BackendService, ...Option) error
}

// NewMockBackendServices returns a new mock for BackendServices.
func NewMockBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockBackendServices {
	mock := &MockBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBackendServices is the mock for BackendServices.
type MockBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockBackendServices, options ...Option) (bool, *computega.BackendService, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockBackendServices, options ...Option) (bool, []*computega.BackendService, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computega.BackendService, m *MockBackendServices, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockBackendServices, options ...Option) (bool, error)
	AggregatedListHook     func(ctx context.Context, fl *filter.F, m *MockBackendServices, options ...Option) (bool, map[string][]*computega.BackendService, error)
	AddSignedUrlKeyHook    func(context.Context, *meta.Key, *computega.SignedUrlKey, *MockBackendServices, ...Option) error
	DeleteSignedUrlKeyHook func(context.Context, *meta.Key, string, *MockBackendServices, ...Option) error
	GetHealthHook          func(context.Context, *meta.Key, *computega.ResourceGroupReference, *MockBackendServices, ...Option) (*computega.BackendServiceGroupHealth, error)
	PatchHook              func(context.Context, *meta.Key, *computega.BackendService, *MockBackendServices, ...Option) error
	SetSecurityPolicyHook  func(context.Context, *meta.Key, *computega.SecurityPolicyReference, *MockBackendServices, ...Option) error
	UpdateHook             func(context.Context, *meta.Key, *computega.BackendService, *MockBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computega.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToGA().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToGA())
	}
	klog.V(5).Infof("MockBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBackendServices) Obj(o *computega.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// AddSignedUrlKey is a mock for the corresponding method.
func (m *MockBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computega.SignedUrlKey, options ...Option) error {
	if m.AddSignedUrlKeyHook != nil {
		return m.AddSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// DeleteSignedUrlKey is a mock for the corresponding method.
func (m *MockBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DeleteSignedUrlKeyHook != nil {
		return m.DeleteSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// GetHealth is a mock for the corresponding method.
func (m *MockBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computega.ResourceGroupReference, options ...Option) (*computega.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computega.SecurityPolicyReference, options ...Option) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCEBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBackendServices.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.BackendService
	f := func(l *computega.BackendServiceList) error {
		klog.V(5).Infof("GCEBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.GA.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computega.BackendService{}
	f := func(l *computega.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AddSignedUrlKey is a method on GCEBackendServices.
func (g *GCEBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computega.SignedUrlKey, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddSignedUrlKey",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.AddSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DeleteSignedUrlKey is a method on GCEBackendServices.
func (g *GCEBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DeleteSignedUrlKey",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.DeleteSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEBackendServices.
func (g *GCEBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computega.ResourceGroupReference, options ...Option) (*computega.BackendServiceGroupHealth, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.GetHealth(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.GetHealth(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.BackendServices.GetHealth(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBackendServices.
func (g *GCEBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetSecurityPolicy is a method on GCEBackendServices.
func (g *GCEBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computega.SecurityPolicyReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBackendServices.
func (g *GCEBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaBackendServices is an interface that allows for mocking of BackendServices.
type BetaBackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.BackendService, error)
	AddSignedUrlKey(context.Context, *meta.Key, *computebeta.SignedUrlKey, ...Option) error
	DeleteSignedUrlKey(context.Context, *meta.Key, string, ...Option) error
	Patch(context.Context, *meta.Key, *computebeta.BackendService, ...Option) error
	SetSecurityPolicy(context.Context, *meta.Key, *computebeta.SecurityPolicyReference, ...Option) error
	Update(context.Context, *meta.Key, *computebeta.BackendService, ...Option) error
}

// NewMockBetaBackendServices returns a new mock for BackendServices.
func NewMockBetaBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockBetaBackendServices {
	mock := &MockBetaBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaBackendServices is the mock for BackendServices.
type MockBetaBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockBetaBackendServices, options ...Option) (bool, *computebeta.BackendService, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockBetaBackendServices, options ...Option) (bool, []*computebeta.BackendService, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, m *MockBetaBackendServices, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockBetaBackendServices, options ...Option) (bool, error)
	AggregatedListHook     func(ctx context.Context, fl *filter.F, m *MockBetaBackendServices, options ...Option) (bool, map[string][]*computebeta.BackendService, error)
	AddSignedUrlKeyHook    func(context.Context, *meta.Key, *computebeta.SignedUrlKey, *MockBetaBackendServices, ...Option) error
	DeleteSignedUrlKeyHook func(context.Context, *meta.Key, string, *MockBetaBackendServices, ...Option) error
	PatchHook              func(context.Context, *meta.Key, *computebeta.BackendService, *MockBetaBackendServices, ...Option) error
	SetSecurityPolicyHook  func(context.Context, *meta.Key, *computebeta.SecurityPolicyReference, *MockBetaBackendServices, ...Option) error
	UpdateHook             func(context.Context, *meta.Key, *computebeta.BackendService, *MockBetaBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBetaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockBetaBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computebeta.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaBackendServices) Obj(o *computebeta.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// AddSignedUrlKey is a mock for the corresponding method.
func (m *MockBetaBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computebeta.SignedUrlKey, options ...Option) error {
	if m.AddSignedUrlKeyHook != nil {
		return m.AddSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// DeleteSignedUrlKey is a mock for the corresponding method.
func (m *MockBetaBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DeleteSignedUrlKeyHook != nil {
		return m.DeleteSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// Patch is a mock for the corresponding method.
func (m *MockBetaBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockBetaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computebeta.SecurityPolicyReference, options ...Option) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBetaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEBetaBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBetaBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBetaBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCEBetaBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaBackendServices.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.BackendService
	f := func(l *computebeta.BackendServiceList) error {
		klog.V(5).Infof("GCEBetaBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBetaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBetaBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computebeta.BackendService{}
	f := func(l *computebeta.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AddSignedUrlKey is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computebeta.SignedUrlKey, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddSignedUrlKey",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.AddSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DeleteSignedUrlKey is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DeleteSignedUrlKey",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.DeleteSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Patch is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetSecurityPolicy is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computebeta.SecurityPolicyReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaBackendServices.
func (g *GCEBetaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEBetaBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaBackendServices is an interface that allows for mocking of BackendServices.
type AlphaBackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.BackendService, error)
	AddSignedUrlKey(context.Context, *meta.Key, *computealpha.SignedUrlKey, ...Option) error
	DeleteSignedUrlKey(context.Context, *meta.Key, string, ...Option) error
	Patch(context.Context, *meta.Key, *computealpha.BackendService, ...Option) error
	SetSecurityPolicy(context.Context, *meta.Key, *computealpha.SecurityPolicyReference, ...Option) error
	Update(context.Context, *meta.Key, *computealpha.BackendService, ...Option) error
}

// NewMockAlphaBackendServices returns a new mock for BackendServices.
func NewMockAlphaBackendServices(pr ProjectRouter, objs map[meta.Key]*MockBackendServicesObj) *MockAlphaBackendServices {
	mock := &MockAlphaBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaBackendServices is the mock for BackendServices.
type MockAlphaBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices, options ...Option) (bool, *computealpha.BackendService, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockAlphaBackendServices, options ...Option) (bool, []*computealpha.BackendService, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, m *MockAlphaBackendServices, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockAlphaBackendServices, options ...Option) (bool, error)
	AggregatedListHook     func(ctx context.Context, fl *filter.F, m *MockAlphaBackendServices, options ...Option) (bool, map[string][]*computealpha.BackendService, error)
	AddSignedUrlKeyHook    func(context.Context, *meta.Key, *computealpha.SignedUrlKey, *MockAlphaBackendServices, ...Option) error
	DeleteSignedUrlKeyHook func(context.Context, *meta.Key, string, *MockAlphaBackendServices, ...Option) error
	PatchHook              func(context.Context, *meta.Key, *computealpha.BackendService, *MockAlphaBackendServices, ...Option) error
	SetSecurityPolicyHook  func(context.Context, *meta.Key, *computealpha.SecurityPolicyReference, *MockAlphaBackendServices, ...Option) error
	UpdateHook             func(context.Context, *meta.Key, *computealpha.BackendService, *MockAlphaBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockAlphaBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.BackendService
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaBackendServices.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockBackendServicesObj{obj}
	klog.V(5).Infof("MockAlphaBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.BackendService, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computealpha.BackendService{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaBackendServices.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaBackendServices) Obj(o *computealpha.BackendService) *MockBackendServicesObj {
	return &MockBackendServicesObj{o}
}

// AddSignedUrlKey is a mock for the corresponding method.
func (m *MockAlphaBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computealpha.SignedUrlKey, options ...Option) error {
	if m.AddSignedUrlKeyHook != nil {
		return m.AddSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// DeleteSignedUrlKey is a mock for the corresponding method.
func (m *MockAlphaBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DeleteSignedUrlKeyHook != nil {
		return m.DeleteSignedUrlKeyHook(ctx, key, arg0, m)
	}
	return nil
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetSecurityPolicy is a mock for the corresponding method.
func (m *MockAlphaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.SecurityPolicyReference, options ...Option) error {
	if m.SetSecurityPolicyHook != nil {
		return m.SetSecurityPolicyHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaBackendServices is a simplifying adapter for the GCE BackendServices.
type GCEAlphaBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEAlphaBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.BackendServices.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaBackendServices) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaBackendServices.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.BackendServices.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.BackendService
	f := func(l *computealpha.BackendServiceList) error {
		klog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.BackendServices.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaBackendServices) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}

	klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.BackendServices.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computealpha.BackendService{}
	f := func(l *computealpha.BackendServiceAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.BackendServices...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaBackendServices.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AddSignedUrlKey is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) AddSignedUrlKey(ctx context.Context, key *meta.Key, arg0 *computealpha.SignedUrlKey, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddSignedUrlKey",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.AddSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaBackendServices.AddSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DeleteSignedUrlKey is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) DeleteSignedUrlKey(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DeleteSignedUrlKey",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.DeleteSignedUrlKey(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaBackendServices.DeleteSignedUrlKey(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Patch is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetSecurityPolicy is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) SetSecurityPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.SecurityPolicyReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetSecurityPolicy",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.SetSecurityPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaBackendServices.SetSecurityPolicy(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaBackendServices.
func (g *GCEAlphaBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "BackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "BackendServices",
	}
	klog.V(5).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.BackendServices.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type RegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetHealth(context.Context, *meta.Key, *computega.ResourceGroupReference, ...Option) (*computega.BackendServiceGroupHealth, error)
	Patch(context.Context, *meta.Key, *computega.BackendService, ...Option) error
	Update(context.Context, *meta.Key, *computega.BackendService, ...Option) error
}

// NewMockRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockRegionBackendServices {
	mock := &MockRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionBackendServices is the mock for RegionBackendServices.
type MockRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices, options ...Option) (bool, *computega.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockRegionBackendServices, options ...Option) (bool, []*computega.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computega.BackendService, m *MockRegionBackendServices, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockRegionBackendServices, options ...Option) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *computega.ResourceGroupReference, *MockRegionBackendServices, ...Option) (*computega.BackendServiceGroupHealth, error)
	PatchHook     func(context.Context, *meta.Key, *computega.BackendService, *MockRegionBackendServices, ...Option) error
	UpdateHook    func(context.Context, *meta.Key, *computega.BackendService, *MockRegionBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionBackendServices) Obj(o *computega.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computega.ResourceGroupReference, options ...Option) (*computega.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockRegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCERegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCERegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}

	klog.V(5).Infof("GCERegionBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCERegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionBackendServices.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.GA.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.BackendService
	f := func(l *computega.BackendServiceList) error {
		klog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCERegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCERegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCERegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computega.ResourceGroupReference, options ...Option) (*computega.BackendServiceGroupHealth, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.GetHealth(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCERegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCERegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCERegionBackendServices.
func (g *GCERegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computega.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCERegionBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCERegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type AlphaRegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetHealth(context.Context, *meta.Key, *computealpha.ResourceGroupReference, ...Option) (*computealpha.BackendServiceGroupHealth, error)
	Patch(context.Context, *meta.Key, *computealpha.BackendService, ...Option) error
	Update(context.Context, *meta.Key, *computealpha.BackendService, ...Option) error
}

// NewMockAlphaRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockAlphaRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockAlphaRegionBackendServices {
	mock := &MockAlphaRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionBackendServices is the mock for RegionBackendServices.
type MockAlphaRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices, options ...Option) (bool, *computealpha.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionBackendServices, options ...Option) (bool, []*computealpha.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, m *MockAlphaRegionBackendServices, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionBackendServices, options ...Option) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *computealpha.ResourceGroupReference, *MockAlphaRegionBackendServices, ...Option) (*computealpha.BackendServiceGroupHealth, error)
	PatchHook     func(context.Context, *meta.Key, *computealpha.BackendService, *MockAlphaRegionBackendServices, ...Option) error
	UpdateHook    func(context.Context, *meta.Key, *computealpha.BackendService, *MockAlphaRegionBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockAlphaRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionBackendServices) Obj(o *computealpha.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computealpha.ResourceGroupReference, options ...Option) (*computealpha.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCEAlphaRegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEAlphaRegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}

	klog.V(5).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCEAlphaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Alpha.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.BackendService
	f := func(l *computealpha.BackendServiceList) error {
		klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEAlphaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEAlphaRegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computealpha.ResourceGroupReference, options ...Option) (*computealpha.BackendServiceGroupHealth, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaRegionBackendServices.
func (g *GCEAlphaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaRegionBackendServices is an interface that allows for mocking of RegionBackendServices.
type BetaRegionBackendServices interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetHealth(context.Context, *meta.Key, *computebeta.ResourceGroupReference, ...Option) (*computebeta.BackendServiceGroupHealth, error)
	Patch(context.Context, *meta.Key, *computebeta.BackendService, ...Option) error
	Update(context.Context, *meta.Key, *computebeta.BackendService, ...Option) error
}

// NewMockBetaRegionBackendServices returns a new mock for RegionBackendServices.
func NewMockBetaRegionBackendServices(pr ProjectRouter, objs map[meta.Key]*MockRegionBackendServicesObj) *MockBetaRegionBackendServices {
	mock := &MockBetaRegionBackendServices{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRegionBackendServices is the mock for RegionBackendServices.
type MockBetaRegionBackendServices struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionBackendServicesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaRegionBackendServices, options ...Option) (bool, *computebeta.BackendService, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockBetaRegionBackendServices, options ...Option) (bool, []*computebeta.BackendService, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, m *MockBetaRegionBackendServices, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaRegionBackendServices, options ...Option) (bool, error)
	GetHealthHook func(context.Context, *meta.Key, *computebeta.ResourceGroupReference, *MockBetaRegionBackendServices, ...Option) (*computebeta.BackendServiceGroupHealth, error)
	PatchHook     func(context.Context, *meta.Key, *computebeta.BackendService, *MockBetaRegionBackendServices, ...Option) error
	UpdateHook    func(context.Context, *meta.Key, *computebeta.BackendService, *MockBetaRegionBackendServices, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRegionBackendServices %v not found", key),
	}
	klog.V(5).Infof("MockBetaRegionBackendServices.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.BackendService
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRegionBackendServices.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRegionBackendServices %v exists", key),
		}
		klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "backendServices")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "backendServices", key)

	m.Objects[*key] = &MockRegionBackendServicesObj{obj}
	klog.V(5).Infof("MockBetaRegionBackendServices.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRegionBackendServices %v not found", key),
		}
		klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRegionBackendServices.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRegionBackendServices) Obj(o *computebeta.BackendService) *MockRegionBackendServicesObj {
	return &MockRegionBackendServicesObj{o}
}

// GetHealth is a mock for the corresponding method.
func (m *MockBetaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computebeta.ResourceGroupReference, options ...Option) (*computebeta.BackendServiceGroupHealth, error) {
	if m.GetHealthHook != nil {
		return m.GetHealthHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("GetHealthHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBetaRegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBetaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaRegionBackendServices is a simplifying adapter for the GCE RegionBackendServices.
type GCEBetaRegionBackendServices struct {
	s *Service
}

// Get the BackendService named by key.
func (g *GCEBetaRegionBackendServices) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}

	klog.V(5).Infof("GCEBetaRegionBackendServices.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionBackendServices.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionBackendServices.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all BackendService objects.
func (g *GCEBetaRegionBackendServices) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.BackendService, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Beta.RegionBackendServices.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.BackendService
	f := func(l *computebeta.BackendServiceList) error {
		klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRegionBackendServices.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert BackendService with key of value obj.
func (g *GCEBetaRegionBackendServices) Insert(ctx context.Context, key *meta.Key, obj *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.RegionBackendServices.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionBackendServices.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the BackendService referenced by key.
func (g *GCEBetaRegionBackendServices) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionBackendServices.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionBackendServices.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetHealth is a method on GCEBetaRegionBackendServices.
func (g *GCEBetaRegionBackendServices) GetHealth(ctx context.Context, key *meta.Key, arg0 *computebeta.ResourceGroupReference, options ...Option) (*computebeta.BackendServiceGroupHealth, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetHealth",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionBackendServices.GetHealth(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBetaRegionBackendServices.GetHealth(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBetaRegionBackendServices.
func (g *GCEBetaRegionBackendServices) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionBackendServices.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaRegionBackendServices.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaRegionBackendServices.
func (g *GCEBetaRegionBackendServices) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.BackendService, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionBackendServices.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionBackendServices.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionBackendServices")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "RegionBackendServices",
	}
	klog.V(5).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionBackendServices.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaRegionBackendServices.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Disks is an interface that allows for mocking of Disks.
type Disks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Resize(context.Context, *meta.Key, *computega.DisksResizeRequest, ...Option) error
}

// NewMockDisks returns a new mock for Disks.
func NewMockDisks(pr ProjectRouter, objs map[meta.Key]*MockDisksObj) *MockDisks {
	mock := &MockDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockDisks is the mock for Disks.
type MockDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockDisks, options ...Option) (bool, *computega.Disk, error)
	ListHook   func(ctx context.Context, zone string, fl *filter.F, m *MockDisks, options ...Option) (bool, []*computega.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.Disk, m *MockDisks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockDisks, options ...Option) (bool, error)
	ResizeHook func(context.Context, *meta.Key, *computega.DisksResizeRequest, *MockDisks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockDisks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockDisks %v not found", key),
	}
	klog.V(5).Infof("MockDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockDisks) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockDisks.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Disk
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockDisks.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockDisks) Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockDisks %v exists", key),
		}
		klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "disks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "disks", key)

	m.Objects[*key] = &MockDisksObj{obj}
	klog.V(5).Infof("MockDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockDisks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockDisks %v not found", key),
		}
		klog.V(5).Infof("MockDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockDisks) Obj(o *computega.Disk) *MockDisksObj {
	return &MockDisksObj{o}
}

// Resize is a mock for the corresponding method.
func (m *MockDisks) Resize(ctx context.Context, key *meta.Key, arg0 *computega.DisksResizeRequest, options ...Option) error {
	if m.ResizeHook != nil {
		return m.ResizeHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEDisks is a simplifying adapter for the GCE Disks.
type GCEDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCEDisks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEDisks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Disks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}

	klog.V(5).Infof("GCEDisks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Disks.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Disk objects.
func (g *GCEDisks) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Disk, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEDisks.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Disks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEDisks.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.GA.Disks.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Disk
	f := func(l *computega.DiskList) error {
		klog.V(5).Infof("GCEDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCEDisks) Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEDisks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Disks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Disks.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCEDisks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEDisks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Disks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Disks.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Resize is a method on GCEDisks.
func (g *GCEDisks) Resize(ctx context.Context, key *meta.Key, arg0 *computega.DisksResizeRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEDisks.Resize(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEDisks.Resize(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Disks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Resize",
		Version:   meta.Version("ga"),
		Service:   "Disks",
	}
	klog.V(5).Infof("GCEDisks.Resize(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Disks.Resize(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionDisks is an interface that allows for mocking of RegionDisks.
type RegionDisks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Disk, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Resize(context.Context, *meta.Key, *computega.RegionDisksResizeRequest, ...Option) error
}

// NewMockRegionDisks returns a new mock for RegionDisks.
func NewMockRegionDisks(pr ProjectRouter, objs map[meta.Key]*MockRegionDisksObj) *MockRegionDisks {
	mock := &MockRegionDisks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionDisks is the mock for RegionDisks.
type MockRegionDisks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionDisksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRegionDisks, options ...Option) (bool, *computega.Disk, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockRegionDisks, options ...Option) (bool, []*computega.Disk, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.Disk, m *MockRegionDisks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRegionDisks, options ...Option) (bool, error)
	ResizeHook func(context.Context, *meta.Key, *computega.RegionDisksResizeRequest, *MockRegionDisks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionDisks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionDisks %v not found", key),
	}
	klog.V(5).Infof("MockRegionDisks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionDisks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Disk, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Disk
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionDisks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionDisks) Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionDisks %v exists", key),
		}
		klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "disks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "disks", key)

	m.Objects[*key] = &MockRegionDisksObj{obj}
	klog.V(5).Infof("MockRegionDisks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionDisks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionDisks %v not found", key),
		}
		klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionDisks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionDisks) Obj(o *computega.Disk) *MockRegionDisksObj {
	return &MockRegionDisksObj{o}
}

// Resize is a mock for the corresponding method.
func (m *MockRegionDisks) Resize(ctx context.Context, key *meta.Key, arg0 *computega.RegionDisksResizeRequest, options ...Option) error {
	if m.ResizeHook != nil {
		return m.ResizeHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionDisks is a simplifying adapter for the GCE RegionDisks.
type GCERegionDisks struct {
	s *Service
}

// Get the Disk named by key.
func (g *GCERegionDisks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Disk, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionDisks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionDisks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}

	klog.V(5).Infof("GCERegionDisks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionDisks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionDisks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionDisks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Disk objects.
func (g *GCERegionDisks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.Disk, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionDisks.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionDisks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionDisks.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.GA.RegionDisks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Disk
	f := func(l *computega.DiskList) error {
		klog.V(5).Infof("GCERegionDisks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCERegionDisks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionDisks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Disk with key of value obj.
func (g *GCERegionDisks) Insert(ctx context.Context, key *meta.Key, obj *computega.Disk, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionDisks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionDisks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionDisks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionDisks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Disk referenced by key.
func (g *GCERegionDisks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionDisks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionDisks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionDisks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionDisks.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionDisks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionDisks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Resize is a method on GCERegionDisks.
func (g *GCERegionDisks) Resize(ctx context.Context, key *meta.Key, arg0 *computega.RegionDisksResizeRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionDisks.Resize(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionDisks.Resize(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionDisks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Resize",
		Version:   meta.Version("ga"),
		Service:   "RegionDisks",
	}
	klog.V(5).Infof("GCERegionDisks.Resize(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionDisks.Resize(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCERegionDisks.Resize(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaFirewalls is an interface that allows for mocking of Firewalls.
type AlphaFirewalls interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Firewall, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Firewall, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Patch(context.Context, *meta.Key, *computealpha.Firewall, ...Option) error
	Update(context.Context, *meta.Key, *computealpha.Firewall, ...Option) error
}

// NewMockAlphaFirewalls returns a new mock for Firewalls.
func NewMockAlphaFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockAlphaFirewalls {
	mock := &MockAlphaFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaFirewalls is the mock for Firewalls.
type MockAlphaFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaFirewalls, options ...Option) (bool, *computealpha.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaFirewalls, options ...Option) (bool, []*computealpha.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computealpha.Firewall, m *MockAlphaFirewalls, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaFirewalls, options ...Option) (bool, error)
	PatchHook  func(context.Context, *meta.Key, *computealpha.Firewall, *MockAlphaFirewalls, ...Option) error
	UpdateHook func(context.Context, *meta.Key, *computealpha.Firewall, *MockAlphaFirewalls, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockAlphaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Firewall, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "firewalls")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockAlphaFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaFirewalls) Obj(o *computealpha.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.Firewall, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockAlphaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.Firewall, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEAlphaFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEAlphaFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}

	klog.V(5).Infof("GCEAlphaFirewalls.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Firewall objects.
func (g *GCEAlphaFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaFirewalls.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Firewall
	f := func(l *computealpha.FirewallList) error {
		klog.V(5).Infof("GCEAlphaFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEAlphaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEAlphaFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Patch is a method on GCEAlphaFirewalls.
func (g *GCEAlphaFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Firewalls.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaFirewalls.
func (g *GCEAlphaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaFirewalls.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaFirewalls.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaFirewalls is an interface that allows for mocking of Firewalls.
type BetaFirewalls interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Firewall, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Firewall, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Patch(context.Context, *meta.Key, *computebeta.Firewall, ...Option) error
	Update(context.Context, *meta.Key, *computebeta.Firewall, ...Option) error
}

// NewMockBetaFirewalls returns a new mock for Firewalls.
func NewMockBetaFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockBetaFirewalls {
	mock := &MockBetaFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaFirewalls is the mock for Firewalls.
type MockBetaFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaFirewalls, options ...Option) (bool, *computebeta.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaFirewalls, options ...Option) (bool, []*computebeta.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computebeta.Firewall, m *MockBetaFirewalls, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaFirewalls, options ...Option) (bool, error)
	PatchHook  func(context.Context, *meta.Key, *computebeta.Firewall, *MockBetaFirewalls, ...Option) error
	UpdateHook func(context.Context, *meta.Key, *computebeta.Firewall, *MockBetaFirewalls, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockBetaFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Firewall, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "firewalls")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockBetaFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaFirewalls) Obj(o *computebeta.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Patch is a mock for the corresponding method.
func (m *MockBetaFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.Firewall, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockBetaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.Firewall, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEBetaFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEBetaFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}

	klog.V(5).Infof("GCEBetaFirewalls.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Firewall objects.
func (g *GCEBetaFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaFirewalls.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Firewall
	f := func(l *computebeta.FirewallList) error {
		klog.V(5).Infof("GCEBetaFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEBetaFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEBetaFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Patch is a method on GCEBetaFirewalls.
func (g *GCEBetaFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Firewalls.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaFirewalls.
func (g *GCEBetaFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaFirewalls.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaFirewalls.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEBetaFirewalls.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Firewalls is an interface that allows for mocking of Firewalls.
type Firewalls interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Firewall, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Firewall, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Firewall, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Patch(context.Context, *meta.Key, *computega.Firewall, ...Option) error
	Update(context.Context, *meta.Key, *computega.Firewall, ...Option) error
}

// NewMockFirewalls returns a new mock for Firewalls.
func NewMockFirewalls(pr ProjectRouter, objs map[meta.Key]*MockFirewallsObj) *MockFirewalls {
	mock := &MockFirewalls{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockFirewalls is the mock for Firewalls.
type MockFirewalls struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockFirewallsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockFirewalls, options ...Option) (bool, *computega.Firewall, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockFirewalls, options ...Option) (bool, []*computega.Firewall, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.Firewall, m *MockFirewalls, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockFirewalls, options ...Option) (bool, error)
	PatchHook  func(context.Context, *meta.Key, *computega.Firewall, *MockFirewalls, ...Option) error
	UpdateHook func(context.Context, *meta.Key, *computega.Firewall, *MockFirewalls, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Firewall, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockFirewalls.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockFirewalls %v not found", key),
	}
	klog.V(5).Infof("MockFirewalls.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Firewall, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockFirewalls.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Firewall
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockFirewalls.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computega.Firewall, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockFirewalls %v exists", key),
		}
		klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "firewalls")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "firewalls", key)

	m.Objects[*key] = &MockFirewallsObj{obj}
	klog.V(5).Infof("MockFirewalls.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockFirewalls %v not found", key),
		}
		klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockFirewalls.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockFirewalls) Obj(o *computega.Firewall) *MockFirewallsObj {
	return &MockFirewallsObj{o}
}

// Patch is a mock for the corresponding method.
func (m *MockFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computega.Firewall, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// Update is a mock for the corresponding method.
func (m *MockFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computega.Firewall, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEFirewalls is a simplifying adapter for the GCE Firewalls.
type GCEFirewalls struct {
	s *Service
}

// Get the Firewall named by key.
func (g *GCEFirewalls) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}

	klog.V(5).Infof("GCEFirewalls.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEFirewalls.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Firewalls.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEFirewalls.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Firewall objects.
func (g *GCEFirewalls) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Firewall, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEFirewalls.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.Firewalls.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Firewall
	f := func(l *computega.FirewallList) error {
		klog.V(5).Infof("GCEFirewalls.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEFirewalls.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEFirewalls.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Firewall with key of value obj.
func (g *GCEFirewalls) Insert(ctx context.Context, key *meta.Key, obj *computega.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Firewalls.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEFirewalls.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Firewall referenced by key.
func (g *GCEFirewalls) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEFirewalls.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEFirewalls.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Patch is a method on GCEFirewalls.
func (g *GCEFirewalls) Patch(ctx context.Context, key *meta.Key, arg0 *computega.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEFirewalls.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEFirewalls.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Update is a method on GCEFirewalls.
func (g *GCEFirewalls) Update(ctx context.Context, key *meta.Key, arg0 *computega.Firewall, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEFirewalls.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEFirewalls.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Firewalls")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "Firewalls",
	}
	klog.V(5).Infof("GCEFirewalls.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Firewalls.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEFirewalls.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaNetworkFirewallPolicies is an interface that allows for mocking of NetworkFirewallPolicies.
type AlphaNetworkFirewallPolicies interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AddAssociation(context.Context, *meta.Key, *computealpha.FirewallPolicyAssociation, ...Option) error
	AddRule(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, ...Option) error
	CloneRules(context.Context, *meta.Key, ...Option) error
	GetAssociation(context.Context, *meta.Key, ...Option) (*computealpha.FirewallPolicyAssociation, error)
	GetIamPolicy(context.Context, *meta.Key, ...Option) (*computealpha.Policy, error)
	GetRule(context.Context, *meta.Key, ...Option) (*computealpha.FirewallPolicyRule, error)
	Patch(context.Context, *meta.Key, *computealpha.FirewallPolicy, ...Option) error
	PatchRule(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, ...Option) error
	RemoveAssociation(context.Context, *meta.Key, ...Option) error
	RemoveRule(context.Context, *meta.Key, ...Option) error
	SetIamPolicy(context.Context, *meta.Key, *computealpha.GlobalSetPolicyRequest, ...Option) (*computealpha.Policy, error)
	TestIamPermissions(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, ...Option) (*computealpha.TestPermissionsResponse, error)
}

// NewMockAlphaNetworkFirewallPolicies returns a new mock for NetworkFirewallPolicies.
func NewMockAlphaNetworkFirewallPolicies(pr ProjectRouter, objs map[meta.Key]*MockNetworkFirewallPoliciesObj) *MockAlphaNetworkFirewallPolicies {
	mock := &MockAlphaNetworkFirewallPolicies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworkFirewallPolicies is the mock for NetworkFirewallPolicies.
type MockAlphaNetworkFirewallPolicies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkFirewallPoliciesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkFirewallPolicies, options ...Option) (bool, *computealpha.FirewallPolicy, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockAlphaNetworkFirewallPolicies, options ...Option) (bool, []*computealpha.FirewallPolicy, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, m *MockAlphaNetworkFirewallPolicies, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkFirewallPolicies, options ...Option) (bool, error)
	AddAssociationHook     func(context.Context, *meta.Key, *computealpha.FirewallPolicyAssociation, *MockAlphaNetworkFirewallPolicies, ...Option) error
	AddRuleHook            func(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, *MockAlphaNetworkFirewallPolicies, ...Option) error
	CloneRulesHook         func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) error
	GetAssociationHook     func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) (*computealpha.FirewallPolicyAssociation, error)
	GetIamPolicyHook       func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) (*computealpha.Policy, error)
	GetRuleHook            func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) (*computealpha.FirewallPolicyRule, error)
	PatchHook              func(context.Context, *meta.Key, *computealpha.FirewallPolicy, *MockAlphaNetworkFirewallPolicies, ...Option) error
	PatchRuleHook          func(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, *MockAlphaNetworkFirewallPolicies, ...Option) error
	RemoveAssociationHook  func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) error
	RemoveRuleHook         func(context.Context, *meta.Key, *MockAlphaNetworkFirewallPolicies, ...Option) error
	SetIamPolicyHook       func(context.Context, *meta.Key, *computealpha.GlobalSetPolicyRequest, *MockAlphaNetworkFirewallPolicies, ...Option) (*computealpha.Policy, error)
	TestIamPermissionsHook func(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, *MockAlphaNetworkFirewallPolicies, ...Option) (*computealpha.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworkFirewallPolicies) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworkFirewallPolicies %v not found", key),
	}
	klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaNetworkFirewallPolicies) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.FirewallPolicy
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworkFirewallPolicies) Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworkFirewallPolicies %v exists", key),
		}
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "networkFirewallPolicies")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "networkFirewallPolicies", key)

	m.Objects[*key] = &MockNetworkFirewallPoliciesObj{obj}
	klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworkFirewallPolicies) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworkFirewallPolicies %v not found", key),
		}
		klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaNetworkFirewallPolicies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworkFirewallPolicies) Obj(o *computealpha.FirewallPolicy) *MockNetworkFirewallPoliciesObj {
	return &MockNetworkFirewallPoliciesObj{o}
}

// AddAssociation is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) AddAssociation(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyAssociation, options ...Option) error {
	if m.AddAssociationHook != nil {
		return m.AddAssociationHook(ctx, key, arg0, m)
	}
	return nil
}

// AddRule is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	if m.AddRuleHook != nil {
		return m.AddRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// CloneRules is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) CloneRules(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.CloneRulesHook != nil {
		return m.CloneRulesHook(ctx, key, m)
	}
	return nil
}

// GetAssociation is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) GetAssociation(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyAssociation, error) {
	if m.GetAssociationHook != nil {
		return m.GetAssociationHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetAssociationHook must be set")
}

// GetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	if m.GetIamPolicyHook != nil {
		return m.GetIamPolicyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetIamPolicyHook must be set")
}

// GetRule is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) GetRule(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyRule, error) {
	if m.GetRuleHook != nil {
		return m.GetRuleHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRuleHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicy, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// PatchRule is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	if m.PatchRuleHook != nil {
		return m.PatchRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// RemoveAssociation is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) RemoveAssociation(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.RemoveAssociationHook != nil {
		return m.RemoveAssociationHook(ctx, key, m)
	}
	return nil
}

// RemoveRule is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) RemoveRule(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.RemoveRuleHook != nil {
		return m.RemoveRuleHook(ctx, key, m)
	}
	return nil
}

// SetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	if m.SetIamPolicyHook != nil {
		return m.SetIamPolicyHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("SetIamPolicyHook must be set")
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockAlphaNetworkFirewallPolicies) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEAlphaNetworkFirewallPolicies is a simplifying adapter for the GCE NetworkFirewallPolicies.
type GCEAlphaNetworkFirewallPolicies struct {
	s *Service
}

// Get the FirewallPolicy named by key.
func (g *GCEAlphaNetworkFirewallPolicies) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}

	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all FirewallPolicy objects.
func (g *GCEAlphaNetworkFirewallPolicies) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.NetworkFirewallPolicies.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.FirewallPolicy
	f := func(l *computealpha.FirewallPolicyList) error {
		klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert FirewallPolicy with key of value obj.
func (g *GCEAlphaNetworkFirewallPolicies) Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.NetworkFirewallPolicies.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the FirewallPolicy referenced by key.
func (g *GCEAlphaNetworkFirewallPolicies) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddAssociation is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) AddAssociation(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyAssociation, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddAssociation",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.AddAssociation(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddAssociation(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AddRule is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddRule",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.AddRule(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// CloneRules is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) CloneRules(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "CloneRules",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.CloneRules(projectID, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.CloneRules(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GetAssociation is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) GetAssociation(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyAssociation, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.GetAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetAssociation",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.GetAssociation(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetAssociation(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetIamPolicy is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.GetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.GetIamPolicy(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetRule is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) GetRule(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.GetRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetRule",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.GetRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.GetRule(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.GetRule(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicy, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// PatchRule is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "PatchRule",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.PatchRule(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveAssociation is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) RemoveAssociation(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "RemoveAssociation",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.RemoveAssociation(projectID, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveRule is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) RemoveRule(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "RemoveRule",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.RemoveRule(projectID, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetIamPolicy is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.SetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.SetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.SetIamPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// TestIamPermissions is a method on GCEAlphaNetworkFirewallPolicies.
func (g *GCEAlphaNetworkFirewallPolicies) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.TestIamPermissions(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkFirewallPolicies.TestIamPermissions(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("alpha"),
		Service:   "NetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkFirewallPolicies.TestIamPermissions(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// AlphaRegionNetworkFirewallPolicies is an interface that allows for mocking of RegionNetworkFirewallPolicies.
type AlphaRegionNetworkFirewallPolicies interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AddAssociation(context.Context, *meta.Key, *computealpha.FirewallPolicyAssociation, ...Option) error
	AddRule(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, ...Option) error
	CloneRules(context.Context, *meta.Key, ...Option) error
	GetAssociation(context.Context, *meta.Key, ...Option) (*computealpha.FirewallPolicyAssociation, error)
	GetIamPolicy(context.Context, *meta.Key, ...Option) (*computealpha.Policy, error)
	GetRule(context.Context, *meta.Key, ...Option) (*computealpha.FirewallPolicyRule, error)
	Patch(context.Context, *meta.Key, *computealpha.FirewallPolicy, ...Option) error
	PatchRule(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, ...Option) error
	RemoveAssociation(context.Context, *meta.Key, ...Option) error
	RemoveRule(context.Context, *meta.Key, ...Option) error
	SetIamPolicy(context.Context, *meta.Key, *computealpha.RegionSetPolicyRequest, ...Option) (*computealpha.Policy, error)
	TestIamPermissions(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, ...Option) (*computealpha.TestPermissionsResponse, error)
}

// NewMockAlphaRegionNetworkFirewallPolicies returns a new mock for RegionNetworkFirewallPolicies.
func NewMockAlphaRegionNetworkFirewallPolicies(pr ProjectRouter, objs map[meta.Key]*MockRegionNetworkFirewallPoliciesObj) *MockAlphaRegionNetworkFirewallPolicies {
	mock := &MockAlphaRegionNetworkFirewallPolicies{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionNetworkFirewallPolicies is the mock for RegionNetworkFirewallPolicies.
type MockAlphaRegionNetworkFirewallPolicies struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionNetworkFirewallPoliciesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockAlphaRegionNetworkFirewallPolicies, options ...Option) (bool, *computealpha.FirewallPolicy, error)
	ListHook               func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionNetworkFirewallPolicies, options ...Option) (bool, []*computealpha.FirewallPolicy, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, m *MockAlphaRegionNetworkFirewallPolicies, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockAlphaRegionNetworkFirewallPolicies, options ...Option) (bool, error)
	AddAssociationHook     func(context.Context, *meta.Key, *computealpha.FirewallPolicyAssociation, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	AddRuleHook            func(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	CloneRulesHook         func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	GetAssociationHook     func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) (*computealpha.FirewallPolicyAssociation, error)
	GetIamPolicyHook       func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) (*computealpha.Policy, error)
	GetRuleHook            func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) (*computealpha.FirewallPolicyRule, error)
	PatchHook              func(context.Context, *meta.Key, *computealpha.FirewallPolicy, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	PatchRuleHook          func(context.Context, *meta.Key, *computealpha.FirewallPolicyRule, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	RemoveAssociationHook  func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	RemoveRuleHook         func(context.Context, *meta.Key, *MockAlphaRegionNetworkFirewallPolicies, ...Option) error
	SetIamPolicyHook       func(context.Context, *meta.Key, *computealpha.RegionSetPolicyRequest, *MockAlphaRegionNetworkFirewallPolicies, ...Option) (*computealpha.Policy, error)
	TestIamPermissionsHook func(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, *MockAlphaRegionNetworkFirewallPolicies, ...Option) (*computealpha.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionNetworkFirewallPolicies) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionNetworkFirewallPolicies %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionNetworkFirewallPolicies) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.FirewallPolicy
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionNetworkFirewallPolicies) Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionNetworkFirewallPolicies %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "regionNetworkFirewallPolicies")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "regionNetworkFirewallPolicies", key)

	m.Objects[*key] = &MockRegionNetworkFirewallPoliciesObj{obj}
	klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionNetworkFirewallPolicies) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionNetworkFirewallPolicies %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionNetworkFirewallPolicies) Obj(o *computealpha.FirewallPolicy) *MockRegionNetworkFirewallPoliciesObj {
	return &MockRegionNetworkFirewallPoliciesObj{o}
}

// AddAssociation is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) AddAssociation(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyAssociation, options ...Option) error {
	if m.AddAssociationHook != nil {
		return m.AddAssociationHook(ctx, key, arg0, m)
	}
	return nil
}

// AddRule is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	if m.AddRuleHook != nil {
		return m.AddRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// CloneRules is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) CloneRules(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.CloneRulesHook != nil {
		return m.CloneRulesHook(ctx, key, m)
	}
	return nil
}

// GetAssociation is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) GetAssociation(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyAssociation, error) {
	if m.GetAssociationHook != nil {
		return m.GetAssociationHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetAssociationHook must be set")
}

// GetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	if m.GetIamPolicyHook != nil {
		return m.GetIamPolicyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetIamPolicyHook must be set")
}

// GetRule is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) GetRule(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyRule, error) {
	if m.GetRuleHook != nil {
		return m.GetRuleHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetRuleHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicy, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// PatchRule is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	if m.PatchRuleHook != nil {
		return m.PatchRuleHook(ctx, key, arg0, m)
	}
	return nil
}

// RemoveAssociation is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) RemoveAssociation(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.RemoveAssociationHook != nil {
		return m.RemoveAssociationHook(ctx, key, m)
	}
	return nil
}

// RemoveRule is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) RemoveRule(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.RemoveRuleHook != nil {
		return m.RemoveRuleHook(ctx, key, m)
	}
	return nil
}

// SetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.RegionSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	if m.SetIamPolicyHook != nil {
		return m.SetIamPolicyHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("SetIamPolicyHook must be set")
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockAlphaRegionNetworkFirewallPolicies) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEAlphaRegionNetworkFirewallPolicies is a simplifying adapter for the GCE RegionNetworkFirewallPolicies.
type GCEAlphaRegionNetworkFirewallPolicies struct {
	s *Service
}

// Get the FirewallPolicy named by key.
func (g *GCEAlphaRegionNetworkFirewallPolicies) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}

	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all FirewallPolicy objects.
func (g *GCEAlphaRegionNetworkFirewallPolicies) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.FirewallPolicy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Alpha.RegionNetworkFirewallPolicies.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.FirewallPolicy
	f := func(l *computealpha.FirewallPolicyList) error {
		klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert FirewallPolicy with key of value obj.
func (g *GCEAlphaRegionNetworkFirewallPolicies) Insert(ctx context.Context, key *meta.Key, obj *computealpha.FirewallPolicy, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionNetworkFirewallPolicies.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the FirewallPolicy referenced by key.
func (g *GCEAlphaRegionNetworkFirewallPolicies) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddAssociation is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) AddAssociation(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyAssociation, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddAssociation",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.AddAssociation(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddAssociation(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AddRule is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) AddRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddRule",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.AddRule(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.AddRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// CloneRules is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) CloneRules(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "CloneRules",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.CloneRules(projectID, key.Region, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.CloneRules(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GetAssociation is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) GetAssociation(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyAssociation, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetAssociation",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.GetAssociation(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetAssociation(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetIamPolicy is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.GetIamPolicy(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetRule is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) GetRule(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.FirewallPolicyRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetRule",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.GetRule(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.GetRule(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicy, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.Patch(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// PatchRule is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) PatchRule(ctx context.Context, key *meta.Key, arg0 *computealpha.FirewallPolicyRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "PatchRule",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.PatchRule(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.PatchRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveAssociation is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) RemoveAssociation(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "RemoveAssociation",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.RemoveAssociation(projectID, key.Region, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveAssociation(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RemoveRule is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) RemoveRule(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "RemoveRule",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.RemoveRule(projectID, key.Region, key.Name)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.RemoveRule(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetIamPolicy is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.RegionSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.SetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.SetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.SetIamPolicy(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.SetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// TestIamPermissions is a method on GCEAlphaRegionNetworkFirewallPolicies.
func (g *GCEAlphaRegionNetworkFirewallPolicies) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.TestIamPermissions(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionNetworkFirewallPolicies.TestIamPermissions(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionNetworkFirewallPolicies")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("alpha"),
		Service:   "RegionNetworkFirewallPolicies",
	}
	klog.V(5).Infof("GCEAlphaRegionNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionNetworkFirewallPolicies.TestIamPermissions(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaRegionNetworkFirewallPolicies.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// ForwardingRules is an interface that allows for mocking of ForwardingRules.
type ForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computega.RegionSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computega.TargetReference, ...Option) error
}

// NewMockForwardingRules returns a new mock for ForwardingRules.
func NewMockForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockForwardingRules {
	mock := &MockForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockForwardingRules is the mock for ForwardingRules.
type MockForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockForwardingRules, options ...Option) (bool, *computega.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockForwardingRules, options ...Option) (bool, []*computega.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, m *MockForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computega.RegionSetLabelsRequest, *MockForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computega.TargetReference, *MockForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockForwardingRules) Obj(o *computega.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.RegionSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computega.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}

	klog.V(5).Infof("GCEForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEForwardingRules.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.GA.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.ForwardingRule
	f := func(l *computega.ForwardingRuleList) error {
		klog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEForwardingRules.
func (g *GCEForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.RegionSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.SetLabels(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEForwardingRules.
func (g *GCEForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computega.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("ga"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaForwardingRules is an interface that allows for mocking of ForwardingRules.
type AlphaForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computealpha.RegionSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computealpha.TargetReference, ...Option) error
}

// NewMockAlphaForwardingRules returns a new mock for ForwardingRules.
func NewMockAlphaForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockAlphaForwardingRules {
	mock := &MockAlphaForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaForwardingRules is the mock for ForwardingRules.
type MockAlphaForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules, options ...Option) (bool, *computealpha.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockAlphaForwardingRules, options ...Option) (bool, []*computealpha.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, m *MockAlphaForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computealpha.RegionSetLabelsRequest, *MockAlphaForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computealpha.TargetReference, *MockAlphaForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockAlphaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockAlphaForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaForwardingRules) Obj(o *computealpha.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockAlphaForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.RegionSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockAlphaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computealpha.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEAlphaForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEAlphaForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}

	klog.V(5).Infof("GCEAlphaForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEAlphaForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Alpha.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.ForwardingRule
	f := func(l *computealpha.ForwardingRuleList) error {
		klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEAlphaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEAlphaForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEAlphaForwardingRules.
func (g *GCEAlphaForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.RegionSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.SetLabels(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEAlphaForwardingRules.
func (g *GCEAlphaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computealpha.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("alpha"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaForwardingRules is an interface that allows for mocking of ForwardingRules.
type BetaForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computebeta.RegionSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computebeta.TargetReference, ...Option) error
}

// NewMockBetaForwardingRules returns a new mock for ForwardingRules.
func NewMockBetaForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockForwardingRulesObj) *MockBetaForwardingRules {
	mock := &MockBetaForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaForwardingRules is the mock for ForwardingRules.
type MockBetaForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaForwardingRules, options ...Option) (bool, *computebeta.ForwardingRule, error)
	ListHook      func(ctx context.Context, region string, fl *filter.F, m *MockBetaForwardingRules, options ...Option) (bool, []*computebeta.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, m *MockBetaForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computebeta.RegionSetLabelsRequest, *MockBetaForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computebeta.TargetReference, *MockBetaForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockBetaForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.ForwardingRule
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaForwardingRules.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockForwardingRulesObj{obj}
	klog.V(5).Infof("MockBetaForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaForwardingRules) Obj(o *computebeta.ForwardingRule) *MockForwardingRulesObj {
	return &MockForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockBetaForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.RegionSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockBetaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computebeta.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaForwardingRules is a simplifying adapter for the GCE ForwardingRules.
type GCEBetaForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEBetaForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}

	klog.V(5).Infof("GCEBetaForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.ForwardingRules.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEBetaForwardingRules) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaForwardingRules.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Beta.ForwardingRules.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.ForwardingRule
	f := func(l *computebeta.ForwardingRuleList) error {
		klog.V(5).Infof("GCEBetaForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEBetaForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.ForwardingRules.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEBetaForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ForwardingRules.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEBetaForwardingRules.
func (g *GCEBetaForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.RegionSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ForwardingRules.SetLabels(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEBetaForwardingRules.
func (g *GCEBetaForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computebeta.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "ForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("beta"),
		Service:   "ForwardingRules",
	}
	klog.V(5).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.ForwardingRules.SetTarget(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaGlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type AlphaGlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computealpha.GlobalSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computealpha.TargetReference, ...Option) error
}

// NewMockAlphaGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockAlphaGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockAlphaGlobalForwardingRules {
	mock := &MockAlphaGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockAlphaGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalForwardingRules, options ...Option) (bool, *computealpha.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockAlphaGlobalForwardingRules, options ...Option) (bool, []*computealpha.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, m *MockAlphaGlobalForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockAlphaGlobalForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computealpha.GlobalSetLabelsRequest, *MockAlphaGlobalForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computealpha.TargetReference, *MockAlphaGlobalForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaGlobalForwardingRules) Obj(o *computealpha.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockAlphaGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockAlphaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computealpha.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEAlphaGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEAlphaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}

	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEAlphaGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.ForwardingRule
	f := func(l *computealpha.ForwardingRuleList) error {
		klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEAlphaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computealpha.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEAlphaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEAlphaGlobalForwardingRules.
func (g *GCEAlphaGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalForwardingRules.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEAlphaGlobalForwardingRules.
func (g *GCEAlphaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computealpha.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("alpha"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaGlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type BetaGlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computebeta.GlobalSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computebeta.TargetReference, ...Option) error
}

// NewMockBetaGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockBetaGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockBetaGlobalForwardingRules {
	mock := &MockBetaGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockBetaGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockBetaGlobalForwardingRules, options ...Option) (bool, *computebeta.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockBetaGlobalForwardingRules, options ...Option) (bool, []*computebeta.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, m *MockBetaGlobalForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockBetaGlobalForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computebeta.GlobalSetLabelsRequest, *MockBetaGlobalForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computebeta.TargetReference, *MockBetaGlobalForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaGlobalForwardingRules) Obj(o *computebeta.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockBetaGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockBetaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computebeta.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEBetaGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEBetaGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}

	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEBetaGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.ForwardingRule
	f := func(l *computebeta.ForwardingRuleList) error {
		klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEBetaGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computebeta.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEBetaGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEBetaGlobalForwardingRules.
func (g *GCEBetaGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalForwardingRules.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEBetaGlobalForwardingRules.
func (g *GCEBetaGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computebeta.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("beta"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// GlobalForwardingRules is an interface that allows for mocking of GlobalForwardingRules.
type GlobalForwardingRules interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	SetLabels(context.Context, *meta.Key, *computega.GlobalSetLabelsRequest, ...Option) error
	SetTarget(context.Context, *meta.Key, *computega.TargetReference, ...Option) error
}

// NewMockGlobalForwardingRules returns a new mock for GlobalForwardingRules.
func NewMockGlobalForwardingRules(pr ProjectRouter, objs map[meta.Key]*MockGlobalForwardingRulesObj) *MockGlobalForwardingRules {
	mock := &MockGlobalForwardingRules{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockGlobalForwardingRules is the mock for GlobalForwardingRules.
type MockGlobalForwardingRules struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockGlobalForwardingRulesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook       func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules, options ...Option) (bool, *computega.ForwardingRule, error)
	ListHook      func(ctx context.Context, fl *filter.F, m *MockGlobalForwardingRules, options ...Option) (bool, []*computega.ForwardingRule, error)
	InsertHook    func(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, m *MockGlobalForwardingRules, options ...Option) (bool, error)
	DeleteHook    func(ctx context.Context, key *meta.Key, m *MockGlobalForwardingRules, options ...Option) (bool, error)
	SetLabelsHook func(context.Context, *meta.Key, *computega.GlobalSetLabelsRequest, *MockGlobalForwardingRules, ...Option) error
	SetTargetHook func(context.Context, *meta.Key, *computega.TargetReference, *MockGlobalForwardingRules, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
	}
	klog.V(5).Infof("MockGlobalForwardingRules.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.ForwardingRule
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockGlobalForwardingRules.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v exists", key),
		}
		klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "forwardingRules")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "forwardingRules", key)

	m.Objects[*key] = &MockGlobalForwardingRulesObj{obj}
	klog.V(5).Infof("MockGlobalForwardingRules.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockGlobalForwardingRules %v not found", key),
		}
		klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockGlobalForwardingRules.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockGlobalForwardingRules) Obj(o *computega.ForwardingRule) *MockGlobalForwardingRulesObj {
	return &MockGlobalForwardingRulesObj{o}
}

// SetLabels is a mock for the corresponding method.
func (m *MockGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// SetTarget is a mock for the corresponding method.
func (m *MockGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computega.TargetReference, options ...Option) error {
	if m.SetTargetHook != nil {
		return m.SetTargetHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEGlobalForwardingRules is a simplifying adapter for the GCE GlobalForwardingRules.
type GCEGlobalForwardingRules struct {
	s *Service
}

// Get the ForwardingRule named by key.
func (g *GCEGlobalForwardingRules) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}

	klog.V(5).Infof("GCEGlobalForwardingRules.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.GlobalForwardingRules.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEGlobalForwardingRules.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all ForwardingRule objects.
func (g *GCEGlobalForwardingRules) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.ForwardingRule, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.GlobalForwardingRules.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.ForwardingRule
	f := func(l *computega.ForwardingRuleList) error {
		klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEGlobalForwardingRules.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert ForwardingRule with key of value obj.
func (g *GCEGlobalForwardingRules) Insert(ctx context.Context, key *meta.Key, obj *computega.ForwardingRule, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.GlobalForwardingRules.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalForwardingRules.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the ForwardingRule referenced by key.
func (g *GCEGlobalForwardingRules) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEGlobalForwardingRules.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// SetLabels is a method on GCEGlobalForwardingRules.
func (g *GCEGlobalForwardingRules) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEGlobalForwardingRules.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetTarget is a method on GCEGlobalForwardingRules.
func (g *GCEGlobalForwardingRules) SetTarget(ctx context.Context, key *meta.Key, arg0 *computega.TargetReference, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "GlobalForwardingRules")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetTarget",
		Version:   meta.Version("ga"),
		Service:   "GlobalForwardingRules",
	}
	klog.V(5).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.GlobalForwardingRules.SetTarget(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEGlobalForwardingRules.SetTarget(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HealthChecks is an interface that allows for mocking of HealthChecks.
type HealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computega.HealthCheck, ...Option) error
}

// NewMockHealthChecks returns a new mock for HealthChecks.
func NewMockHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockHealthChecks {
	mock := &MockHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHealthChecks is the mock for HealthChecks.
type MockHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHealthChecks, options ...Option) (bool, *computega.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHealthChecks, options ...Option) (bool, []*computega.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, m *MockHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computega.HealthCheck, *MockHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHealthChecks) Obj(o *computega.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}

	klog.V(5).Infof("GCEHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCEHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHealthChecks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHealthChecks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.HealthCheck
	f := func(l *computega.HealthCheckList) error {
		klog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHealthChecks.
func (g *GCEHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaHealthChecks is an interface that allows for mocking of HealthChecks.
type AlphaHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computealpha.HealthCheck, ...Option) error
}

// NewMockAlphaHealthChecks returns a new mock for HealthChecks.
func NewMockAlphaHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockAlphaHealthChecks {
	mock := &MockAlphaHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaHealthChecks is the mock for HealthChecks.
type MockAlphaHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks, options ...Option) (bool, *computealpha.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaHealthChecks, options ...Option) (bool, []*computealpha.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, m *MockAlphaHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computealpha.HealthCheck, *MockAlphaHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockAlphaHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaHealthChecks) Obj(o *computealpha.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEAlphaHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEAlphaHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}

	klog.V(5).Infof("GCEAlphaHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCEAlphaHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.HealthCheck
	f := func(l *computealpha.HealthCheckList) error {
		klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEAlphaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEAlphaHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaHealthChecks.
func (g *GCEAlphaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaHealthChecks is an interface that allows for mocking of HealthChecks.
type BetaHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computebeta.HealthCheck, ...Option) error
}

// NewMockBetaHealthChecks returns a new mock for HealthChecks.
func NewMockBetaHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHealthChecksObj) *MockBetaHealthChecks {
	mock := &MockBetaHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaHealthChecks is the mock for HealthChecks.
type MockBetaHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaHealthChecks, options ...Option) (bool, *computebeta.HealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaHealthChecks, options ...Option) (bool, []*computebeta.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, m *MockBetaHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computebeta.HealthCheck, *MockBetaHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockBetaHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.HealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "healthChecks", key)

	m.Objects[*key] = &MockHealthChecksObj{obj}
	klog.V(5).Infof("MockBetaHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaHealthChecks) Obj(o *computebeta.HealthCheck) *MockHealthChecksObj {
	return &MockHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockBetaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaHealthChecks is a simplifying adapter for the GCE HealthChecks.
type GCEBetaHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEBetaHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}

	klog.V(5).Infof("GCEBetaHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.HealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCEBetaHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaHealthChecks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaHealthChecks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.HealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.HealthCheck
	f := func(l *computebeta.HealthCheckList) error {
		klog.V(5).Infof("GCEBetaHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEBetaHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "HealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.HealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEBetaHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.HealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaHealthChecks.
func (g *GCEBetaHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "HealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "HealthChecks",
	}
	klog.V(5).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.HealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaRegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type AlphaRegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computealpha.HealthCheck, ...Option) error
}

// NewMockAlphaRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockAlphaRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockAlphaRegionHealthChecks {
	mock := &MockAlphaRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaRegionHealthChecks is the mock for RegionHealthChecks.
type MockAlphaRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaRegionHealthChecks, options ...Option) (bool, *computealpha.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockAlphaRegionHealthChecks, options ...Option) (bool, []*computealpha.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, m *MockAlphaRegionHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaRegionHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computealpha.HealthCheck, *MockAlphaRegionHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaRegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockAlphaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaRegionHealthChecks) Obj(o *computealpha.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockAlphaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEAlphaRegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCEAlphaRegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEAlphaRegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}

	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCEAlphaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computealpha.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Alpha.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.HealthCheck
	f := func(l *computealpha.HealthCheckList) error {
		klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEAlphaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEAlphaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionHealthChecks.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEAlphaRegionHealthChecks.
func (g *GCEAlphaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computealpha.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("alpha"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaRegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type BetaRegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computebeta.HealthCheck, ...Option) error
}

// NewMockBetaRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockBetaRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockBetaRegionHealthChecks {
	mock := &MockBetaRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaRegionHealthChecks is the mock for RegionHealthChecks.
type MockBetaRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaRegionHealthChecks, options ...Option) (bool, *computebeta.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockBetaRegionHealthChecks, options ...Option) (bool, []*computebeta.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, m *MockBetaRegionHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaRegionHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computebeta.HealthCheck, *MockBetaRegionHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaRegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockBetaRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockBetaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockBetaRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaRegionHealthChecks) Obj(o *computebeta.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockBetaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEBetaRegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCEBetaRegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCEBetaRegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}

	klog.V(5).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCEBetaRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computebeta.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.Beta.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.HealthCheck
	f := func(l *computebeta.HealthCheckList) error {
		klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaRegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCEBetaRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCEBetaRegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionHealthChecks.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEBetaRegionHealthChecks.
func (g *GCEBetaRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computebeta.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("beta"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaRegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// RegionHealthChecks is an interface that allows for mocking of RegionHealthChecks.
type RegionHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error)
	List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computega.HealthCheck, ...Option) error
}

// NewMockRegionHealthChecks returns a new mock for RegionHealthChecks.
func NewMockRegionHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockRegionHealthChecksObj) *MockRegionHealthChecks {
	mock := &MockRegionHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockRegionHealthChecks is the mock for RegionHealthChecks.
type MockRegionHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockRegionHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockRegionHealthChecks, options ...Option) (bool, *computega.HealthCheck, error)
	ListHook   func(ctx context.Context, region string, fl *filter.F, m *MockRegionHealthChecks, options ...Option) (bool, []*computega.HealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, m *MockRegionHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockRegionHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computega.HealthCheck, *MockRegionHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockRegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockRegionHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockRegionHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given region.
func (m *MockRegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, region, fl, m, options...); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = [%v items], %v", ctx, region, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = nil, %v", ctx, region, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.HealthCheck
	for key, obj := range m.Objects {
		if key.Region != region {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockRegionHealthChecks.List(%v, %q, %v) = [%v items], nil", ctx, region, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockRegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockRegionHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "healthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "healthChecks", key)

	m.Objects[*key] = &MockRegionHealthChecksObj{obj}
	klog.V(5).Infof("MockRegionHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockRegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockRegionHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockRegionHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockRegionHealthChecks) Obj(o *computega.HealthCheck) *MockRegionHealthChecksObj {
	return &MockRegionHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockRegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCERegionHealthChecks is a simplifying adapter for the GCE RegionHealthChecks.
type GCERegionHealthChecks struct {
	s *Service
}

// Get the HealthCheck named by key.
func (g *GCERegionHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}

	klog.V(5).Infof("GCERegionHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.RegionHealthChecks.Get(projectID, key.Region, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCERegionHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HealthCheck objects.
func (g *GCERegionHealthChecks) List(ctx context.Context, region string, fl *filter.F, options ...Option) ([]*computega.HealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionHealthChecks.List(%v, %v, %v, %v) called", ctx, region, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCERegionHealthChecks.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, region, fl, projectID, ck)
	call := g.s.GA.RegionHealthChecks.List(projectID, region)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.HealthCheck
	f := func(l *computega.HealthCheckList) error {
		klog.V(5).Infof("GCERegionHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCERegionHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCERegionHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HealthCheck with key of value obj.
func (g *GCERegionHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.RegionHealthChecks.Insert(projectID, key.Region, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HealthCheck referenced by key.
func (g *GCERegionHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionHealthChecks.Delete(projectID, key.Region, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCERegionHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCERegionHealthChecks.
func (g *GCERegionHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCERegionHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCERegionHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "RegionHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "RegionHealthChecks",
	}
	klog.V(5).Infof("GCERegionHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.RegionHealthChecks.Update(projectID, key.Region, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCERegionHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpHealthChecks is an interface that allows for mocking of HttpHealthChecks.
type HttpHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpHealthCheck, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.HttpHealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computega.HttpHealthCheck, ...Option) error
}

// NewMockHttpHealthChecks returns a new mock for HttpHealthChecks.
func NewMockHttpHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpHealthChecksObj) *MockHttpHealthChecks {
	mock := &MockHttpHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpHealthChecks is the mock for HttpHealthChecks.
type MockHttpHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks, options ...Option) (bool, *computega.HttpHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpHealthChecks, options ...Option) (bool, []*computega.HttpHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.HttpHealthCheck, m *MockHttpHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computega.HttpHealthCheck, *MockHttpHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHttpHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.HttpHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHttpHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HttpHealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "httpHealthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "httpHealthChecks", key)

	m.Objects[*key] = &MockHttpHealthChecksObj{obj}
	klog.V(5).Infof("MockHttpHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHttpHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpHealthChecks) Obj(o *computega.HttpHealthCheck) *MockHttpHealthChecksObj {
	return &MockHttpHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HttpHealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpHealthChecks is a simplifying adapter for the GCE HttpHealthChecks.
type GCEHttpHealthChecks struct {
	s *Service
}

// Get the HttpHealthCheck named by key.
func (g *GCEHttpHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpHealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}

	klog.V(5).Infof("GCEHttpHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHttpHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HttpHealthCheck objects.
func (g *GCEHttpHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpHealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHttpHealthChecks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.HttpHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.HttpHealthCheck
	f := func(l *computega.HttpHealthCheckList) error {
		klog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHttpHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpHealthCheck with key of value obj.
func (g *GCEHttpHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HttpHealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpHealthCheck referenced by key.
func (g *GCEHttpHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpHealthChecks.
func (g *GCEHttpHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HttpHealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpHealthChecks",
	}
	klog.V(5).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEHttpHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// HttpsHealthChecks is an interface that allows for mocking of HttpsHealthChecks.
type HttpsHealthChecks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpsHealthCheck, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpsHealthCheck, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.HttpsHealthCheck, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	Update(context.Context, *meta.Key, *computega.HttpsHealthCheck, ...Option) error
}

// NewMockHttpsHealthChecks returns a new mock for HttpsHealthChecks.
func NewMockHttpsHealthChecks(pr ProjectRouter, objs map[meta.Key]*MockHttpsHealthChecksObj) *MockHttpsHealthChecks {
	mock := &MockHttpsHealthChecks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockHttpsHealthChecks is the mock for HttpsHealthChecks.
type MockHttpsHealthChecks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockHttpsHealthChecksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks, options ...Option) (bool, *computega.HttpsHealthCheck, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockHttpsHealthChecks, options ...Option) (bool, []*computega.HttpsHealthCheck, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.HttpsHealthCheck, m *MockHttpsHealthChecks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockHttpsHealthChecks, options ...Option) (bool, error)
	UpdateHook func(context.Context, *meta.Key, *computega.HttpsHealthCheck, *MockHttpsHealthChecks, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockHttpsHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpsHealthCheck, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
	}
	klog.V(5).Infof("MockHttpsHealthChecks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockHttpsHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpsHealthCheck, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.HttpsHealthCheck
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockHttpsHealthChecks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HttpsHealthCheck, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v exists", key),
		}
		klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "httpsHealthChecks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "httpsHealthChecks", key)

	m.Objects[*key] = &MockHttpsHealthChecksObj{obj}
	klog.V(5).Infof("MockHttpsHealthChecks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockHttpsHealthChecks %v not found", key),
		}
		klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockHttpsHealthChecks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockHttpsHealthChecks) Obj(o *computega.HttpsHealthCheck) *MockHttpsHealthChecksObj {
	return &MockHttpsHealthChecksObj{o}
}

// Update is a mock for the corresponding method.
func (m *MockHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HttpsHealthCheck, options ...Option) error {
	if m.UpdateHook != nil {
		return m.UpdateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEHttpsHealthChecks is a simplifying adapter for the GCE HttpsHealthChecks.
type GCEHttpsHealthChecks struct {
	s *Service
}

// Get the HttpsHealthCheck named by key.
func (g *GCEHttpsHealthChecks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.HttpsHealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpsHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}

	klog.V(5).Infof("GCEHttpsHealthChecks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.HttpsHealthChecks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEHttpsHealthChecks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all HttpsHealthCheck objects.
func (g *GCEHttpsHealthChecks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.HttpsHealthCheck, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpsHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.HttpsHealthChecks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.HttpsHealthCheck
	f := func(l *computega.HttpsHealthCheckList) error {
		klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEHttpsHealthChecks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert HttpsHealthCheck with key of value obj.
func (g *GCEHttpsHealthChecks) Insert(ctx context.Context, key *meta.Key, obj *computega.HttpsHealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpsHealthChecks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.HttpsHealthChecks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpsHealthChecks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the HttpsHealthCheck referenced by key.
func (g *GCEHttpsHealthChecks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpsHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEHttpsHealthChecks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Update is a method on GCEHttpsHealthChecks.
func (g *GCEHttpsHealthChecks) Update(ctx context.Context, key *meta.Key, arg0 *computega.HttpsHealthCheck, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEHttpsHealthChecks.Update(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "HttpsHealthChecks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Update",
		Version:   meta.Version("ga"),
		Service:   "HttpsHealthChecks",
	}
	klog.V(5).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.HttpsHealthChecks.Update(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEHttpsHealthChecks.Update(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// InstanceGroups is an interface that allows for mocking of InstanceGroups.
type InstanceGroups interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroup, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroup, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AddInstances(context.Context, *meta.Key, *computega.InstanceGroupsAddInstancesRequest, ...Option) error
	ListInstances(context.Context, *meta.Key, *computega.InstanceGroupsListInstancesRequest, *filter.F, ...Option) ([]*computega.InstanceWithNamedPorts, error)
	RemoveInstances(context.Context, *meta.Key, *computega.InstanceGroupsRemoveInstancesRequest, ...Option) error
	SetNamedPorts(context.Context, *meta.Key, *computega.InstanceGroupsSetNamedPortsRequest, ...Option) error
}

// NewMockInstanceGroups returns a new mock for InstanceGroups.
func NewMockInstanceGroups(pr ProjectRouter, objs map[meta.Key]*MockInstanceGroupsObj) *MockInstanceGroups {
	mock := &MockInstanceGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstanceGroups is the mock for InstanceGroups.
type MockInstanceGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstanceGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook             func(ctx context.Context, key *meta.Key, m *MockInstanceGroups, options ...Option) (bool, *computega.InstanceGroup, error)
	ListHook            func(ctx context.Context, zone string, fl *filter.F, m *MockInstanceGroups, options ...Option) (bool, []*computega.InstanceGroup, error)
	InsertHook          func(ctx context.Context, key *meta.Key, obj *computega.InstanceGroup, m *MockInstanceGroups, options ...Option) (bool, error)
	DeleteHook          func(ctx context.Context, key *meta.Key, m *MockInstanceGroups, options ...Option) (bool, error)
	AddInstancesHook    func(context.Context, *meta.Key, *computega.InstanceGroupsAddInstancesRequest, *MockInstanceGroups, ...Option) error
	ListInstancesHook   func(context.Context, *meta.Key, *computega.InstanceGroupsListInstancesRequest, *filter.F, *MockInstanceGroups, ...Option) ([]*computega.InstanceWithNamedPorts, error)
	RemoveInstancesHook func(context.Context, *meta.Key, *computega.InstanceGroupsRemoveInstancesRequest, *MockInstanceGroups, ...Option) error
	SetNamedPortsHook   func(context.Context, *meta.Key, *computega.InstanceGroupsSetNamedPortsRequest, *MockInstanceGroups, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstanceGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
	}
	klog.V(5).Infof("MockInstanceGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstanceGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.InstanceGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstanceGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroup, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstanceGroups %v exists", key),
		}
		klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "instanceGroups")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "instanceGroups", key)

	m.Objects[*key] = &MockInstanceGroupsObj{obj}
	klog.V(5).Infof("MockInstanceGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstanceGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstanceGroups %v not found", key),
		}
		klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstanceGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstanceGroups) Obj(o *computega.InstanceGroup) *MockInstanceGroupsObj {
	return &MockInstanceGroupsObj{o}
}

// AddInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsAddInstancesRequest, options ...Option) error {
	if m.AddInstancesHook != nil {
		return m.AddInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// ListInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsListInstancesRequest, fl *filter.F, options ...Option) ([]*computega.InstanceWithNamedPorts, error) {
	if m.ListInstancesHook != nil {
		return m.ListInstancesHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// RemoveInstances is a mock for the corresponding method.
func (m *MockInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsRemoveInstancesRequest, options ...Option) error {
	if m.RemoveInstancesHook != nil {
		return m.RemoveInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// SetNamedPorts is a mock for the corresponding method.
func (m *MockInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsSetNamedPortsRequest, options ...Option) error {
	if m.SetNamedPortsHook != nil {
		return m.SetNamedPortsHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstanceGroups is a simplifying adapter for the GCE InstanceGroups.
type GCEInstanceGroups struct {
	s *Service
}

// Get the InstanceGroup named by key.
func (g *GCEInstanceGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}

	klog.V(5).Infof("GCEInstanceGroups.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstanceGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all InstanceGroup objects.
func (g *GCEInstanceGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstanceGroups.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.GA.InstanceGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.InstanceGroup
	f := func(l *computega.InstanceGroupList) error {
		klog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEInstanceGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert InstanceGroup with key of value obj.
func (g *GCEInstanceGroups) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroup, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.InstanceGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the InstanceGroup referenced by key.
func (g *GCEInstanceGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AddInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) AddInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsAddInstancesRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.AddInstances(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AddInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.AddInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroups.AddInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) ListInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsListInstancesRequest, fl *filter.F, options ...Option) ([]*computega.InstanceWithNamedPorts, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.ListInstances(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "ListInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroups.ListInstances(projectID, key.Zone, key.Name, arg0)
	var all []*computega.InstanceWithNamedPorts
	f := func(l *computega.InstanceGroupsListInstances) error {
		klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceGroups.ListInstances(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// RemoveInstances is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) RemoveInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsRemoveInstancesRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "RemoveInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.RemoveInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroups.RemoveInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetNamedPorts is a method on GCEInstanceGroups.
func (g *GCEInstanceGroups) SetNamedPorts(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupsSetNamedPortsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetNamedPorts",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroups",
	}
	klog.V(5).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroups.SetNamedPorts(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroups.SetNamedPorts(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Instances is an interface that allows for mocking of Instances.
type Instances interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Instance, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AttachDisk(context.Context, *meta.Key, *computega.AttachedDisk, ...Option) error
	DetachDisk(context.Context, *meta.Key, string, ...Option) error
}

// NewMockInstances returns a new mock for Instances.
func NewMockInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockInstances {
	mock := &MockInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstances is the mock for Instances.
type MockInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook        func(ctx context.Context, key *meta.Key, m *MockInstances, options ...Option) (bool, *computega.Instance, error)
	ListHook       func(ctx context.Context, zone string, fl *filter.F, m *MockInstances, options ...Option) (bool, []*computega.Instance, error)
	InsertHook     func(ctx context.Context, key *meta.Key, obj *computega.Instance, m *MockInstances, options ...Option) (bool, error)
	DeleteHook     func(ctx context.Context, key *meta.Key, m *MockInstances, options ...Option) (bool, error)
	AttachDiskHook func(context.Context, *meta.Key, *computega.AttachedDisk, *MockInstances, ...Option) error
	DetachDiskHook func(context.Context, *meta.Key, string, *MockInstances, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstances %v not found", key),
	}
	klog.V(5).Infof("MockInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstances) Insert(ctx context.Context, key *meta.Key, obj *computega.Instance, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstances %v exists", key),
		}
		klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "instances")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstances %v not found", key),
		}
		klog.V(5).Infof("MockInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstances) Obj(o *computega.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computega.AttachedDisk, options ...Option) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstances is a simplifying adapter for the GCE Instances.
type GCEInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}

	klog.V(5).Infof("GCEInstances.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Instance objects.
func (g *GCEInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstances.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.GA.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Instance
	f := func(l *computega.InstanceList) error {
		klog.V(5).Infof("GCEInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEInstances) Insert(ctx context.Context, key *meta.Key, obj *computega.Instance, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEInstances.
func (g *GCEInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computega.AttachedDisk, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.AttachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.AttachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEInstances.
func (g *GCEInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstances.DetachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("ga"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEInstances.DetachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// BetaInstances is an interface that allows for mocking of Instances.
type BetaInstances interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Instance, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AttachDisk(context.Context, *meta.Key, *computebeta.AttachedDisk, ...Option) error
	DetachDisk(context.Context, *meta.Key, string, ...Option) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *computebeta.NetworkInterface, ...Option) error
}

// NewMockBetaInstances returns a new mock for Instances.
func NewMockBetaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockBetaInstances {
	mock := &MockBetaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaInstances is the mock for Instances.
type MockBetaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockBetaInstances, options ...Option) (bool, *computebeta.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockBetaInstances, options ...Option) (bool, []*computebeta.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *computebeta.Instance, m *MockBetaInstances, options ...Option) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockBetaInstances, options ...Option) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *computebeta.AttachedDisk, *MockBetaInstances, ...Option) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockBetaInstances, ...Option) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *computebeta.NetworkInterface, *MockBetaInstances, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaInstances %v not found", key),
	}
	klog.V(5).Infof("MockBetaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockBetaInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Instance, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaInstances %v exists", key),
		}
		klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "instances")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockBetaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaInstances %v not found", key),
		}
		klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaInstances) Obj(o *computebeta.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computebeta.AttachedDisk, options ...Option) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *computebeta.NetworkInterface, options ...Option) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEBetaInstances is a simplifying adapter for the GCE Instances.
type GCEBetaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEBetaInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}

	klog.V(5).Infof("GCEBetaInstances.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Instance objects.
func (g *GCEBetaInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaInstances.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.Beta.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Instance
	f := func(l *computebeta.InstanceList) error {
		klog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEBetaInstances) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Instance, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEBetaInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computebeta.AttachedDisk, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.AttachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEBetaInstances.
func (g *GCEBetaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.DetachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEBetaInstances.
func (g *GCEBetaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *computebeta.NetworkInterface, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("beta"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// AlphaInstances is an interface that allows for mocking of Instances.
type AlphaInstances interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Instance, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.Instance, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Instance, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AttachDisk(context.Context, *meta.Key, *computealpha.AttachedDisk, ...Option) error
	DetachDisk(context.Context, *meta.Key, string, ...Option) error
	UpdateNetworkInterface(context.Context, *meta.Key, string, *computealpha.NetworkInterface, ...Option) error
}

// NewMockAlphaInstances returns a new mock for Instances.
func NewMockAlphaInstances(pr ProjectRouter, objs map[meta.Key]*MockInstancesObj) *MockAlphaInstances {
	mock := &MockAlphaInstances{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaInstances is the mock for Instances.
type MockAlphaInstances struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstancesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaInstances, options ...Option) (bool, *computealpha.Instance, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaInstances, options ...Option) (bool, []*computealpha.Instance, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *computealpha.Instance, m *MockAlphaInstances, options ...Option) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaInstances, options ...Option) (bool, error)
	AttachDiskHook             func(context.Context, *meta.Key, *computealpha.AttachedDisk, *MockAlphaInstances, ...Option) error
	DetachDiskHook             func(context.Context, *meta.Key, string, *MockAlphaInstances, ...Option) error
	UpdateNetworkInterfaceHook func(context.Context, *meta.Key, string, *computealpha.NetworkInterface, *MockAlphaInstances, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Instance, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
	}
	klog.V(5).Infof("MockAlphaInstances.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.Instance, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Instance
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaInstances.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Instance, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaInstances %v exists", key),
		}
		klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "instances")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "instances", key)

	m.Objects[*key] = &MockInstancesObj{obj}
	klog.V(5).Infof("MockAlphaInstances.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaInstances %v not found", key),
		}
		klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaInstances.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaInstances) Obj(o *computealpha.Instance) *MockInstancesObj {
	return &MockInstancesObj{o}
}

// AttachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computealpha.AttachedDisk, options ...Option) error {
	if m.AttachDiskHook != nil {
		return m.AttachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachDisk is a mock for the corresponding method.
func (m *MockAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	if m.DetachDiskHook != nil {
		return m.DetachDiskHook(ctx, key, arg0, m)
	}
	return nil
}

// UpdateNetworkInterface is a mock for the corresponding method.
func (m *MockAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *computealpha.NetworkInterface, options ...Option) error {
	if m.UpdateNetworkInterfaceHook != nil {
		return m.UpdateNetworkInterfaceHook(ctx, key, arg0, arg1, m)
	}
	return nil
}

// GCEAlphaInstances is a simplifying adapter for the GCE Instances.
type GCEAlphaInstances struct {
	s *Service
}

// Get the Instance named by key.
func (g *GCEAlphaInstances) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}

	klog.V(5).Infof("GCEAlphaInstances.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Instances.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaInstances.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Instance objects.
func (g *GCEAlphaInstances) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.Instance, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaInstances.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.Alpha.Instances.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Instance
	f := func(l *computealpha.InstanceList) error {
		klog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaInstances.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaInstances.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Instance with key of value obj.
func (g *GCEAlphaInstances) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Instance, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Instances.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Instance referenced by key.
func (g *GCEAlphaInstances) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaInstances.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AttachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) AttachDisk(ctx context.Context, key *meta.Key, arg0 *computealpha.AttachedDisk, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.AttachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AttachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.AttachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaInstances.AttachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachDisk is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) DetachDisk(ctx context.Context, key *meta.Key, arg0 string, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.DetachDisk(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DetachDisk",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.DetachDisk(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaInstances.DetachDisk(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// UpdateNetworkInterface is a method on GCEAlphaInstances.
func (g *GCEAlphaInstances) UpdateNetworkInterface(ctx context.Context, key *meta.Key, arg0 string, arg1 *computealpha.NetworkInterface, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Instances")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "UpdateNetworkInterface",
		Version:   meta.Version("alpha"),
		Service:   "Instances",
	}
	klog.V(5).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Instances.UpdateNetworkInterface(projectID, key.Zone, key.Name, arg0, arg1)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaInstances.UpdateNetworkInterface(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// InstanceGroupManagers is an interface that allows for mocking of InstanceGroupManagers.
type InstanceGroupManagers interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroupManager, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroupManager, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroupManager, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	CreateInstances(context.Context, *meta.Key, *computega.InstanceGroupManagersCreateInstancesRequest, ...Option) error
	DeleteInstances(context.Context, *meta.Key, *computega.InstanceGroupManagersDeleteInstancesRequest, ...Option) error
	Resize(context.Context, *meta.Key, int64, ...Option) error
	SetInstanceTemplate(context.Context, *meta.Key, *computega.InstanceGroupManagersSetInstanceTemplateRequest, ...Option) error
}

// NewMockInstanceGroupManagers returns a new mock for InstanceGroupManagers.
func NewMockInstanceGroupManagers(pr ProjectRouter, objs map[meta.Key]*MockInstanceGroupManagersObj) *MockInstanceGroupManagers {
	mock := &MockInstanceGroupManagers{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstanceGroupManagers is the mock for InstanceGroupManagers.
type MockInstanceGroupManagers struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstanceGroupManagersObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                 func(ctx context.Context, key *meta.Key, m *MockInstanceGroupManagers, options ...Option) (bool, *computega.InstanceGroupManager, error)
	ListHook                func(ctx context.Context, zone string, fl *filter.F, m *MockInstanceGroupManagers, options ...Option) (bool, []*computega.InstanceGroupManager, error)
	InsertHook              func(ctx context.Context, key *meta.Key, obj *computega.InstanceGroupManager, m *MockInstanceGroupManagers, options ...Option) (bool, error)
	DeleteHook              func(ctx context.Context, key *meta.Key, m *MockInstanceGroupManagers, options ...Option) (bool, error)
	CreateInstancesHook     func(context.Context, *meta.Key, *computega.InstanceGroupManagersCreateInstancesRequest, *MockInstanceGroupManagers, ...Option) error
	DeleteInstancesHook     func(context.Context, *meta.Key, *computega.InstanceGroupManagersDeleteInstancesRequest, *MockInstanceGroupManagers, ...Option) error
	ResizeHook              func(context.Context, *meta.Key, int64, *MockInstanceGroupManagers, ...Option) error
	SetInstanceTemplateHook func(context.Context, *meta.Key, *computega.InstanceGroupManagersSetInstanceTemplateRequest, *MockInstanceGroupManagers, ...Option) error

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstanceGroupManagers) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroupManager, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroupManagers.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroupManagers.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstanceGroupManagers.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstanceGroupManagers %v not found", key),
	}
	klog.V(5).Infof("MockInstanceGroupManagers.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockInstanceGroupManagers) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroupManager, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroupManagers.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstanceGroupManagers.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.InstanceGroupManager
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstanceGroupManagers.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstanceGroupManagers) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroupManager, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroupManagers.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroupManagers.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstanceGroupManagers %v exists", key),
		}
		klog.V(5).Infof("MockInstanceGroupManagers.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "instanceGroupManagers")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "instanceGroupManagers", key)

	m.Objects[*key] = &MockInstanceGroupManagersObj{obj}
	klog.V(5).Infof("MockInstanceGroupManagers.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstanceGroupManagers) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceGroupManagers.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstanceGroupManagers.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstanceGroupManagers %v not found", key),
		}
		klog.V(5).Infof("MockInstanceGroupManagers.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstanceGroupManagers.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstanceGroupManagers) Obj(o *computega.InstanceGroupManager) *MockInstanceGroupManagersObj {
	return &MockInstanceGroupManagersObj{o}
}

// CreateInstances is a mock for the corresponding method.
func (m *MockInstanceGroupManagers) CreateInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersCreateInstancesRequest, options ...Option) error {
	if m.CreateInstancesHook != nil {
		return m.CreateInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// DeleteInstances is a mock for the corresponding method.
func (m *MockInstanceGroupManagers) DeleteInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersDeleteInstancesRequest, options ...Option) error {
	if m.DeleteInstancesHook != nil {
		return m.DeleteInstancesHook(ctx, key, arg0, m)
	}
	return nil
}

// Resize is a mock for the corresponding method.
func (m *MockInstanceGroupManagers) Resize(ctx context.Context, key *meta.Key, arg0 int64, options ...Option) error {
	if m.ResizeHook != nil {
		return m.ResizeHook(ctx, key, arg0, m)
	}
	return nil
}

// SetInstanceTemplate is a mock for the corresponding method.
func (m *MockInstanceGroupManagers) SetInstanceTemplate(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersSetInstanceTemplateRequest, options ...Option) error {
	if m.SetInstanceTemplateHook != nil {
		return m.SetInstanceTemplateHook(ctx, key, arg0, m)
	}
	return nil
}

// GCEInstanceGroupManagers is a simplifying adapter for the GCE InstanceGroupManagers.
type GCEInstanceGroupManagers struct {
	s *Service
}

// Get the InstanceGroupManager named by key.
func (g *GCEInstanceGroupManagers) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceGroupManager, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}

	klog.V(5).Infof("GCEInstanceGroupManagers.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceGroupManagers.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstanceGroupManagers.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all InstanceGroupManager objects.
func (g *GCEInstanceGroupManagers) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.InstanceGroupManager, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.GA.InstanceGroupManagers.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.InstanceGroupManager
	f := func(l *computega.InstanceGroupManagerList) error {
		klog.V(5).Infof("GCEInstanceGroupManagers.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroupManagers.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEInstanceGroupManagers.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceGroupManagers.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert InstanceGroupManager with key of value obj.
func (g *GCEInstanceGroupManagers) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceGroupManager, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.InstanceGroupManagers.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroupManagers.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the InstanceGroupManager referenced by key.
func (g *GCEInstanceGroupManagers) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroupManagers.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceGroupManagers.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// CreateInstances is a method on GCEInstanceGroupManagers.
func (g *GCEInstanceGroupManagers) CreateInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersCreateInstancesRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "CreateInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroupManagers.CreateInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroupManagers.CreateInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DeleteInstances is a method on GCEInstanceGroupManagers.
func (g *GCEInstanceGroupManagers) DeleteInstances(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersDeleteInstancesRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DeleteInstances",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroupManagers.DeleteInstances(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroupManagers.DeleteInstances(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// Resize is a method on GCEInstanceGroupManagers.
func (g *GCEInstanceGroupManagers) Resize(ctx context.Context, key *meta.Key, arg0 int64, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.Resize(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.Resize(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Resize",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.Resize(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.Resize(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroupManagers.Resize(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroupManagers.Resize(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroupManagers.Resize(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetInstanceTemplate is a method on GCEInstanceGroupManagers.
func (g *GCEInstanceGroupManagers) SetInstanceTemplate(ctx context.Context, key *meta.Key, arg0 *computega.InstanceGroupManagersSetInstanceTemplateRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceGroupManagers")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetInstanceTemplate",
		Version:   meta.Version("ga"),
		Service:   "InstanceGroupManagers",
	}
	klog.V(5).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceGroupManagers.SetInstanceTemplate(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEInstanceGroupManagers.SetInstanceTemplate(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// InstanceTemplates is an interface that allows for mocking of InstanceTemplates.
type InstanceTemplates interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceTemplate, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.InstanceTemplate, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceTemplate, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockInstanceTemplates returns a new mock for InstanceTemplates.
func NewMockInstanceTemplates(pr ProjectRouter, objs map[meta.Key]*MockInstanceTemplatesObj) *MockInstanceTemplates {
	mock := &MockInstanceTemplates{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockInstanceTemplates is the mock for InstanceTemplates.
type MockInstanceTemplates struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockInstanceTemplatesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockInstanceTemplates, options ...Option) (bool, *computega.InstanceTemplate, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockInstanceTemplates, options ...Option) (bool, []*computega.InstanceTemplate, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.InstanceTemplate, m *MockInstanceTemplates, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockInstanceTemplates, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockInstanceTemplates) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceTemplate, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceTemplates.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockInstanceTemplates.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockInstanceTemplates.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockInstanceTemplates %v not found", key),
	}
	klog.V(5).Infof("MockInstanceTemplates.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockInstanceTemplates) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.InstanceTemplate, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockInstanceTemplates.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockInstanceTemplates.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.InstanceTemplate
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockInstanceTemplates.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockInstanceTemplates) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceTemplate, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockInstanceTemplates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockInstanceTemplates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockInstanceTemplates %v exists", key),
		}
		klog.V(5).Infof("MockInstanceTemplates.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "instanceTemplates")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "instanceTemplates", key)

	m.Objects[*key] = &MockInstanceTemplatesObj{obj}
	klog.V(5).Infof("MockInstanceTemplates.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockInstanceTemplates) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockInstanceTemplates.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockInstanceTemplates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockInstanceTemplates %v not found", key),
		}
		klog.V(5).Infof("MockInstanceTemplates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockInstanceTemplates.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockInstanceTemplates) Obj(o *computega.InstanceTemplate) *MockInstanceTemplatesObj {
	return &MockInstanceTemplatesObj{o}
}

// GCEInstanceTemplates is a simplifying adapter for the GCE InstanceTemplates.
type GCEInstanceTemplates struct {
	s *Service
}

// Get the InstanceTemplate named by key.
func (g *GCEInstanceTemplates) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.InstanceTemplate, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceTemplates.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceTemplates.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceTemplates")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "InstanceTemplates",
	}

	klog.V(5).Infof("GCEInstanceTemplates.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceTemplates.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.InstanceTemplates.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEInstanceTemplates.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all InstanceTemplate objects.
func (g *GCEInstanceTemplates) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.InstanceTemplate, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceTemplates.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceTemplates")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "InstanceTemplates",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEInstanceTemplates.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.InstanceTemplates.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.InstanceTemplate
	f := func(l *computega.InstanceTemplateList) error {
		klog.V(5).Infof("GCEInstanceTemplates.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEInstanceTemplates.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEInstanceTemplates.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEInstanceTemplates.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert InstanceTemplate with key of value obj.
func (g *GCEInstanceTemplates) Insert(ctx context.Context, key *meta.Key, obj *computega.InstanceTemplate, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceTemplates.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceTemplates.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceTemplates")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "InstanceTemplates",
	}
	klog.V(5).Infof("GCEInstanceTemplates.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceTemplates.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.InstanceTemplates.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceTemplates.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceTemplates.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the InstanceTemplate referenced by key.
func (g *GCEInstanceTemplates) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEInstanceTemplates.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEInstanceTemplates.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "InstanceTemplates")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "InstanceTemplates",
	}
	klog.V(5).Infof("GCEInstanceTemplates.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEInstanceTemplates.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.InstanceTemplates.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEInstanceTemplates.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEInstanceTemplates.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Images is an interface that allows for mocking of Images.
type Images interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Image, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Image, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Image, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetFromFamily(context.Context, *meta.Key, ...Option) (*computega.Image, error)
	GetIamPolicy(context.Context, *meta.Key, ...Option) (*computega.Policy, error)
	Patch(context.Context, *meta.Key, *computega.Image, ...Option) error
	SetIamPolicy(context.Context, *meta.Key, *computega.GlobalSetPolicyRequest, ...Option) (*computega.Policy, error)
	SetLabels(context.Context, *meta.Key, *computega.GlobalSetLabelsRequest, ...Option) error
	TestIamPermissions(context.Context, *meta.Key, *computega.TestPermissionsRequest, ...Option) (*computega.TestPermissionsResponse, error)
}

// NewMockImages returns a new mock for Images.
func NewMockImages(pr ProjectRouter, objs map[meta.Key]*MockImagesObj) *MockImages {
	mock := &MockImages{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockImages is the mock for Images.
type MockImages struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockImagesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockImages, options ...Option) (bool, *computega.Image, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockImages, options ...Option) (bool, []*computega.Image, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computega.Image, m *MockImages, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockImages, options ...Option) (bool, error)
	GetFromFamilyHook      func(context.Context, *meta.Key, *MockImages, ...Option) (*computega.Image, error)
	GetIamPolicyHook       func(context.Context, *meta.Key, *MockImages, ...Option) (*computega.Policy, error)
	PatchHook              func(context.Context, *meta.Key, *computega.Image, *MockImages, ...Option) error
	SetIamPolicyHook       func(context.Context, *meta.Key, *computega.GlobalSetPolicyRequest, *MockImages, ...Option) (*computega.Policy, error)
	SetLabelsHook          func(context.Context, *meta.Key, *computega.GlobalSetLabelsRequest, *MockImages, ...Option) error
	TestIamPermissionsHook func(context.Context, *meta.Key, *computega.TestPermissionsRequest, *MockImages, ...Option) (*computega.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Image, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockImages.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockImages.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockImages.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockImages %v not found", key),
	}
	klog.V(5).Infof("MockImages.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Image, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockImages.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockImages.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Image
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockImages.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockImages) Insert(ctx context.Context, key *meta.Key, obj *computega.Image, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockImages %v exists", key),
		}
		klog.V(5).Infof("MockImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "Images")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "Images", key)

	m.Objects[*key] = &MockImagesObj{obj}
	klog.V(5).Infof("MockImages.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockImages.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockImages %v not found", key),
		}
		klog.V(5).Infof("MockImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockImages.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockImages) Obj(o *computega.Image) *MockImagesObj {
	return &MockImagesObj{o}
}

// GetFromFamily is a mock for the corresponding method.
func (m *MockImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computega.Image, error) {
	if m.GetFromFamilyHook != nil {
		return m.GetFromFamilyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetFromFamilyHook must be set")
}

// GetIamPolicy is a mock for the corresponding method.
func (m *MockImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computega.Policy, error) {
	if m.GetIamPolicyHook != nil {
		return m.GetIamPolicyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetIamPolicyHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockImages) Patch(ctx context.Context, key *meta.Key, arg0 *computega.Image, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetIamPolicy is a mock for the corresponding method.
func (m *MockImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetPolicyRequest, options ...Option) (*computega.Policy, error) {
	if m.SetIamPolicyHook != nil {
		return m.SetIamPolicyHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("SetIamPolicyHook must be set")
}

// SetLabels is a mock for the corresponding method.
func (m *MockImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computega.TestPermissionsRequest, options ...Option) (*computega.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEImages is a simplifying adapter for the GCE Images.
type GCEImages struct {
	s *Service
}

// Get the Image named by key.
func (g *GCEImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}

	klog.V(5).Infof("GCEImages.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Images.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEImages.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Image objects.
func (g *GCEImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEImages.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.Images.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Image
	f := func(l *computega.ImageList) error {
		klog.V(5).Infof("GCEImages.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEImages.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEImages.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEImages.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Image with key of value obj.
func (g *GCEImages) Insert(ctx context.Context, key *meta.Key, obj *computega.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEImages.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Images.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEImages.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEImages.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Image referenced by key.
func (g *GCEImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEImages.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Images.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEImages.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetFromFamily is a method on GCEImages.
func (g *GCEImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computega.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.GetFromFamily(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.GetFromFamily(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetFromFamily",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.GetFromFamily(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.GetFromFamily(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Images.GetFromFamily(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEImages.GetFromFamily(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetIamPolicy is a method on GCEImages.
func (g *GCEImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computega.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.GetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.GetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetIamPolicy",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.GetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.GetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Images.GetIamPolicy(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEImages.GetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEImages.
func (g *GCEImages) Patch(ctx context.Context, key *meta.Key, arg0 *computega.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Images.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetIamPolicy is a method on GCEImages.
func (g *GCEImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetPolicyRequest, options ...Option) (*computega.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.SetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.SetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetIamPolicy",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.SetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.SetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Images.SetIamPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEImages.SetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// SetLabels is a method on GCEImages.
func (g *GCEImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computega.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Images.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TestIamPermissions is a method on GCEImages.
func (g *GCEImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computega.TestPermissionsRequest, options ...Option) (*computega.TestPermissionsResponse, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEImages.TestIamPermissions(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEImages.TestIamPermissions(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("ga"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEImages.TestIamPermissions(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEImages.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Images.TestIamPermissions(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEImages.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// BetaImages is an interface that allows for mocking of Images.
type BetaImages interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Image, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Image, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Image, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetFromFamily(context.Context, *meta.Key, ...Option) (*computebeta.Image, error)
	GetIamPolicy(context.Context, *meta.Key, ...Option) (*computebeta.Policy, error)
	Patch(context.Context, *meta.Key, *computebeta.Image, ...Option) error
	SetIamPolicy(context.Context, *meta.Key, *computebeta.GlobalSetPolicyRequest, ...Option) (*computebeta.Policy, error)
	SetLabels(context.Context, *meta.Key, *computebeta.GlobalSetLabelsRequest, ...Option) error
	TestIamPermissions(context.Context, *meta.Key, *computebeta.TestPermissionsRequest, ...Option) (*computebeta.TestPermissionsResponse, error)
}

// NewMockBetaImages returns a new mock for Images.
func NewMockBetaImages(pr ProjectRouter, objs map[meta.Key]*MockImagesObj) *MockBetaImages {
	mock := &MockBetaImages{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaImages is the mock for Images.
type MockBetaImages struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockImagesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockBetaImages, options ...Option) (bool, *computebeta.Image, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockBetaImages, options ...Option) (bool, []*computebeta.Image, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computebeta.Image, m *MockBetaImages, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockBetaImages, options ...Option) (bool, error)
	GetFromFamilyHook      func(context.Context, *meta.Key, *MockBetaImages, ...Option) (*computebeta.Image, error)
	GetIamPolicyHook       func(context.Context, *meta.Key, *MockBetaImages, ...Option) (*computebeta.Policy, error)
	PatchHook              func(context.Context, *meta.Key, *computebeta.Image, *MockBetaImages, ...Option) error
	SetIamPolicyHook       func(context.Context, *meta.Key, *computebeta.GlobalSetPolicyRequest, *MockBetaImages, ...Option) (*computebeta.Policy, error)
	SetLabelsHook          func(context.Context, *meta.Key, *computebeta.GlobalSetLabelsRequest, *MockBetaImages, ...Option) error
	TestIamPermissionsHook func(context.Context, *meta.Key, *computebeta.TestPermissionsRequest, *MockBetaImages, ...Option) (*computebeta.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Image, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaImages.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaImages.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaImages.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaImages %v not found", key),
	}
	klog.V(5).Infof("MockBetaImages.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Image, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaImages.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaImages.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Image
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaImages.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaImages) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Image, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaImages %v exists", key),
		}
		klog.V(5).Infof("MockBetaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "Images")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "Images", key)

	m.Objects[*key] = &MockImagesObj{obj}
	klog.V(5).Infof("MockBetaImages.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaImages.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaImages %v not found", key),
		}
		klog.V(5).Infof("MockBetaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaImages.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaImages) Obj(o *computebeta.Image) *MockImagesObj {
	return &MockImagesObj{o}
}

// GetFromFamily is a mock for the corresponding method.
func (m *MockBetaImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Image, error) {
	if m.GetFromFamilyHook != nil {
		return m.GetFromFamilyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetFromFamilyHook must be set")
}

// GetIamPolicy is a mock for the corresponding method.
func (m *MockBetaImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Policy, error) {
	if m.GetIamPolicyHook != nil {
		return m.GetIamPolicyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetIamPolicyHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockBetaImages) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.Image, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetIamPolicy is a mock for the corresponding method.
func (m *MockBetaImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetPolicyRequest, options ...Option) (*computebeta.Policy, error) {
	if m.SetIamPolicyHook != nil {
		return m.SetIamPolicyHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("SetIamPolicyHook must be set")
}

// SetLabels is a mock for the corresponding method.
func (m *MockBetaImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockBetaImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computebeta.TestPermissionsRequest, options ...Option) (*computebeta.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEBetaImages is a simplifying adapter for the GCE Images.
type GCEBetaImages struct {
	s *Service
}

// Get the Image named by key.
func (g *GCEBetaImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}

	klog.V(5).Infof("GCEBetaImages.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Images.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaImages.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Image objects.
func (g *GCEBetaImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaImages.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.Images.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Image
	f := func(l *computebeta.ImageList) error {
		klog.V(5).Infof("GCEBetaImages.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaImages.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaImages.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaImages.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Image with key of value obj.
func (g *GCEBetaImages) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Images.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaImages.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaImages.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Image referenced by key.
func (g *GCEBetaImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Images.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaImages.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetFromFamily is a method on GCEBetaImages.
func (g *GCEBetaImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.GetFromFamily(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.GetFromFamily(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetFromFamily",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.GetFromFamily(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.GetFromFamily(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Images.GetFromFamily(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBetaImages.GetFromFamily(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetIamPolicy is a method on GCEBetaImages.
func (g *GCEBetaImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.GetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.GetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetIamPolicy",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.GetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.GetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Images.GetIamPolicy(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBetaImages.GetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEBetaImages.
func (g *GCEBetaImages) Patch(ctx context.Context, key *meta.Key, arg0 *computebeta.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Images.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetIamPolicy is a method on GCEBetaImages.
func (g *GCEBetaImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetPolicyRequest, options ...Option) (*computebeta.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.SetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.SetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetIamPolicy",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.SetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.SetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Images.SetIamPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBetaImages.SetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// SetLabels is a method on GCEBetaImages.
func (g *GCEBetaImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computebeta.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Images.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TestIamPermissions is a method on GCEBetaImages.
func (g *GCEBetaImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computebeta.TestPermissionsRequest, options ...Option) (*computebeta.TestPermissionsResponse, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaImages.TestIamPermissions(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaImages.TestIamPermissions(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("beta"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEBetaImages.TestIamPermissions(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaImages.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Images.TestIamPermissions(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEBetaImages.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// AlphaImages is an interface that allows for mocking of Images.
type AlphaImages interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Image, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Image, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Image, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	GetFromFamily(context.Context, *meta.Key, ...Option) (*computealpha.Image, error)
	GetIamPolicy(context.Context, *meta.Key, ...Option) (*computealpha.Policy, error)
	Patch(context.Context, *meta.Key, *computealpha.Image, ...Option) error
	SetIamPolicy(context.Context, *meta.Key, *computealpha.GlobalSetPolicyRequest, ...Option) (*computealpha.Policy, error)
	SetLabels(context.Context, *meta.Key, *computealpha.GlobalSetLabelsRequest, ...Option) error
	TestIamPermissions(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, ...Option) (*computealpha.TestPermissionsResponse, error)
}

// NewMockAlphaImages returns a new mock for Images.
func NewMockAlphaImages(pr ProjectRouter, objs map[meta.Key]*MockImagesObj) *MockAlphaImages {
	mock := &MockAlphaImages{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaImages is the mock for Images.
type MockAlphaImages struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockImagesObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                func(ctx context.Context, key *meta.Key, m *MockAlphaImages, options ...Option) (bool, *computealpha.Image, error)
	ListHook               func(ctx context.Context, fl *filter.F, m *MockAlphaImages, options ...Option) (bool, []*computealpha.Image, error)
	InsertHook             func(ctx context.Context, key *meta.Key, obj *computealpha.Image, m *MockAlphaImages, options ...Option) (bool, error)
	DeleteHook             func(ctx context.Context, key *meta.Key, m *MockAlphaImages, options ...Option) (bool, error)
	GetFromFamilyHook      func(context.Context, *meta.Key, *MockAlphaImages, ...Option) (*computealpha.Image, error)
	GetIamPolicyHook       func(context.Context, *meta.Key, *MockAlphaImages, ...Option) (*computealpha.Policy, error)
	PatchHook              func(context.Context, *meta.Key, *computealpha.Image, *MockAlphaImages, ...Option) error
	SetIamPolicyHook       func(context.Context, *meta.Key, *computealpha.GlobalSetPolicyRequest, *MockAlphaImages, ...Option) (*computealpha.Policy, error)
	SetLabelsHook          func(context.Context, *meta.Key, *computealpha.GlobalSetLabelsRequest, *MockAlphaImages, ...Option) error
	TestIamPermissionsHook func(context.Context, *meta.Key, *computealpha.TestPermissionsRequest, *MockAlphaImages, ...Option) (*computealpha.TestPermissionsResponse, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Image, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaImages.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaImages.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaImages.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaImages %v not found", key),
	}
	klog.V(5).Infof("MockAlphaImages.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Image, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaImages.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaImages.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Image
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaImages.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaImages) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Image, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaImages %v exists", key),
		}
		klog.V(5).Infof("MockAlphaImages.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "Images")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "Images", key)

	m.Objects[*key] = &MockImagesObj{obj}
	klog.V(5).Infof("MockAlphaImages.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaImages.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaImages %v not found", key),
		}
		klog.V(5).Infof("MockAlphaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaImages.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaImages) Obj(o *computealpha.Image) *MockImagesObj {
	return &MockImagesObj{o}
}

// GetFromFamily is a mock for the corresponding method.
func (m *MockAlphaImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Image, error) {
	if m.GetFromFamilyHook != nil {
		return m.GetFromFamilyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetFromFamilyHook must be set")
}

// GetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	if m.GetIamPolicyHook != nil {
		return m.GetIamPolicyHook(ctx, key, m)
	}
	return nil, fmt.Errorf("GetIamPolicyHook must be set")
}

// Patch is a mock for the corresponding method.
func (m *MockAlphaImages) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.Image, options ...Option) error {
	if m.PatchHook != nil {
		return m.PatchHook(ctx, key, arg0, m)
	}
	return nil
}

// SetIamPolicy is a mock for the corresponding method.
func (m *MockAlphaImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	if m.SetIamPolicyHook != nil {
		return m.SetIamPolicyHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("SetIamPolicyHook must be set")
}

// SetLabels is a mock for the corresponding method.
func (m *MockAlphaImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetLabelsRequest, options ...Option) error {
	if m.SetLabelsHook != nil {
		return m.SetLabelsHook(ctx, key, arg0, m)
	}
	return nil
}

// TestIamPermissions is a mock for the corresponding method.
func (m *MockAlphaImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	if m.TestIamPermissionsHook != nil {
		return m.TestIamPermissionsHook(ctx, key, arg0, m)
	}
	return nil, fmt.Errorf("TestIamPermissionsHook must be set")
}

// GCEAlphaImages is a simplifying adapter for the GCE Images.
type GCEAlphaImages struct {
	s *Service
}

// Get the Image named by key.
func (g *GCEAlphaImages) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}

	klog.V(5).Infof("GCEAlphaImages.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Images.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaImages.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Image objects.
func (g *GCEAlphaImages) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaImages.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.Images.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Image
	f := func(l *computealpha.ImageList) error {
		klog.V(5).Infof("GCEAlphaImages.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaImages.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaImages.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaImages.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Image with key of value obj.
func (g *GCEAlphaImages) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Images.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaImages.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaImages.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Image referenced by key.
func (g *GCEAlphaImages) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Images.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaImages.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaImages.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// GetFromFamily is a method on GCEAlphaImages.
func (g *GCEAlphaImages) GetFromFamily(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Image, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.GetFromFamily(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.GetFromFamily(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetFromFamily",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.GetFromFamily(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.GetFromFamily(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Images.GetFromFamily(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaImages.GetFromFamily(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// GetIamPolicy is a method on GCEAlphaImages.
func (g *GCEAlphaImages) GetIamPolicy(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.GetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.GetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "GetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.GetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.GetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Images.GetIamPolicy(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaImages.GetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// Patch is a method on GCEAlphaImages.
func (g *GCEAlphaImages) Patch(ctx context.Context, key *meta.Key, arg0 *computealpha.Image, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.Patch(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.Patch(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Patch",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.Patch(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.Patch(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Images.Patch(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaImages.Patch(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// SetIamPolicy is a method on GCEAlphaImages.
func (g *GCEAlphaImages) SetIamPolicy(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetPolicyRequest, options ...Option) (*computealpha.Policy, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.SetIamPolicy(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.SetIamPolicy(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetIamPolicy",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.SetIamPolicy(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.SetIamPolicy(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Images.SetIamPolicy(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaImages.SetIamPolicy(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// SetLabels is a method on GCEAlphaImages.
func (g *GCEAlphaImages) SetLabels(ctx context.Context, key *meta.Key, arg0 *computealpha.GlobalSetLabelsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.SetLabels(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.SetLabels(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "SetLabels",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.SetLabels(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.SetLabels(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Images.SetLabels(projectID, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaImages.SetLabels(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// TestIamPermissions is a method on GCEAlphaImages.
func (g *GCEAlphaImages) TestIamPermissions(ctx context.Context, key *meta.Key, arg0 *computealpha.TestPermissionsRequest, options ...Option) (*computealpha.TestPermissionsResponse, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaImages.TestIamPermissions(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaImages.TestIamPermissions(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Images")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "TestIamPermissions",
		Version:   meta.Version("alpha"),
		Service:   "Images",
	}
	klog.V(5).Infof("GCEAlphaImages.TestIamPermissions(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaImages.TestIamPermissions(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Images.TestIamPermissions(projectID, key.Name, arg0)
	call.Context(ctx)
	v, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	klog.V(4).Infof("GCEAlphaImages.TestIamPermissions(%v, %v, ...) = %+v, %v", ctx, key, v, err)
	return v, err
}

// AlphaNetworks is an interface that allows for mocking of Networks.
type AlphaNetworks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Network, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.Network, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockAlphaNetworks returns a new mock for Networks.
func NewMockAlphaNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockAlphaNetworks {
	mock := &MockAlphaNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworks is the mock for Networks.
type MockAlphaNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockAlphaNetworks, options ...Option) (bool, *computealpha.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockAlphaNetworks, options ...Option) (bool, []*computealpha.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computealpha.Network, m *MockAlphaNetworks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockAlphaNetworks, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworks %v not found", key),
	}
	klog.V(5).Infof("MockAlphaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockAlphaNetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Network, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworks %v exists", key),
		}
		klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "networks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockAlphaNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworks %v not found", key),
		}
		klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworks) Obj(o *computealpha.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCEAlphaNetworks is a simplifying adapter for the GCE Networks.
type GCEAlphaNetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCEAlphaNetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}

	klog.V(5).Infof("GCEAlphaNetworks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaNetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Network objects.
func (g *GCEAlphaNetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computealpha.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaNetworks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Alpha.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.Network
	f := func(l *computealpha.NetworkList) error {
		klog.V(5).Infof("GCEAlphaNetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaNetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCEAlphaNetworks) Insert(ctx context.Context, key *meta.Key, obj *computealpha.Network, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCEAlphaNetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "Networks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEAlphaNetworks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// BetaNetworks is an interface that allows for mocking of Networks.
type BetaNetworks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Network, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.Network, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockBetaNetworks returns a new mock for Networks.
func NewMockBetaNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockBetaNetworks {
	mock := &MockBetaNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaNetworks is the mock for Networks.
type MockBetaNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockBetaNetworks, options ...Option) (bool, *computebeta.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockBetaNetworks, options ...Option) (bool, []*computebeta.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computebeta.Network, m *MockBetaNetworks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockBetaNetworks, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaNetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaNetworks %v not found", key),
	}
	klog.V(5).Infof("MockBetaNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockBetaNetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaNetworks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Network, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaNetworks %v exists", key),
		}
		klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "networks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockBetaNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaNetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaNetworks %v not found", key),
		}
		klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaNetworks) Obj(o *computebeta.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCEBetaNetworks is a simplifying adapter for the GCE Networks.
type GCEBetaNetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCEBetaNetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}

	klog.V(5).Infof("GCEBetaNetworks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaNetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Network objects.
func (g *GCEBetaNetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computebeta.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaNetworks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.Beta.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.Network
	f := func(l *computebeta.NetworkList) error {
		klog.V(5).Infof("GCEBetaNetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaNetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCEBetaNetworks) Insert(ctx context.Context, key *meta.Key, obj *computebeta.Network, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEBetaNetworks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCEBetaNetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "Networks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCEBetaNetworks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// Networks is an interface that allows for mocking of Networks.
type Networks interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Network, error)
	List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Network, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.Network, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
}

// NewMockNetworks returns a new mock for Networks.
func NewMockNetworks(pr ProjectRouter, objs map[meta.Key]*MockNetworksObj) *MockNetworks {
	mock := &MockNetworks{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockNetworks is the mock for Networks.
type MockNetworks struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworksObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError    map[meta.Key]error
	ListError   *error
	InsertError map[meta.Key]error
	DeleteError map[meta.Key]error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook    func(ctx context.Context, key *meta.Key, m *MockNetworks, options ...Option) (bool, *computega.Network, error)
	ListHook   func(ctx context.Context, fl *filter.F, m *MockNetworks, options ...Option) (bool, []*computega.Network, error)
	InsertHook func(ctx context.Context, key *meta.Key, obj *computega.Network, m *MockNetworks, options ...Option) (bool, error)
	DeleteHook func(ctx context.Context, key *meta.Key, m *MockNetworks, options ...Option) (bool, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockNetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Network, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockNetworks.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToGA()
		klog.V(5).Infof("MockNetworks.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockNetworks %v not found", key),
	}
	klog.V(5).Infof("MockNetworks.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock.
func (m *MockNetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Network, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockNetworks.List(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockNetworks.List(%v, %v) = nil, %v", ctx, fl, err)

		return nil, *m.ListError
	}

	var objs []*computega.Network
	for _, obj := range m.Objects {
		if !fl.Match(obj.ToGA()) {
			continue
		}
		objs = append(objs, obj.ToGA())
	}

	klog.V(5).Infof("MockNetworks.List(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockNetworks) Insert(ctx context.Context, key *meta.Key, obj *computega.Network, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockNetworks %v exists", key),
		}
		klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "ga", "networks")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionGA, projectID, "networks", key)

	m.Objects[*key] = &MockNetworksObj{obj}
	klog.V(5).Infof("MockNetworks.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockNetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockNetworks %v not found", key),
		}
		klog.V(5).Infof("MockNetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockNetworks.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// Obj wraps the object for use in the mock.
func (m *MockNetworks) Obj(o *computega.Network) *MockNetworksObj {
	return &MockNetworksObj{o}
}

// GCENetworks is a simplifying adapter for the GCE Networks.
type GCENetworks struct {
	s *Service
}

// Get the Network named by key.
func (g *GCENetworks) Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCENetworks.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}

	klog.V(5).Infof("GCENetworks.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCENetworks.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.GA.Networks.Get(projectID, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCENetworks.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all Network objects.
func (g *GCENetworks) List(ctx context.Context, fl *filter.F, options ...Option) ([]*computega.Network, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCENetworks.List(%v, %v, %v) called", ctx, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCENetworks.List(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	call := g.s.GA.Networks.List(projectID)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computega.Network
	f := func(l *computega.NetworkList) error {
		klog.V(5).Infof("GCENetworks.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCENetworks.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCENetworks.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCENetworks.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert Network with key of value obj.
func (g *GCENetworks) Insert(ctx context.Context, key *meta.Key, obj *computega.Network, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCENetworks.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Networks")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCENetworks.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCENetworks.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.GA.Networks.Insert(projectID, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCENetworks.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworks.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the Network referenced by key.
func (g *GCENetworks) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCENetworks.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCENetworks.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "ga", "Networks")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("ga"),
		Service:   "Networks",
	}
	klog.V(5).Infof("GCENetworks.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCENetworks.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.GA.Networks.Delete(projectID, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCENetworks.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCENetworks.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AlphaNetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type AlphaNetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *computealpha.NetworkEndpointGroup, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsAttachEndpointsRequest, ...Option) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsDetachEndpointsRequest, ...Option) error
	ListNetworkEndpoints(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F, ...Option) ([]*computealpha.NetworkEndpointWithHealthStatus, error)
}

// NewMockAlphaNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockAlphaNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockAlphaNetworkEndpointGroups {
	mock := &MockAlphaNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockAlphaNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockAlphaNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups, options ...Option) (bool, *computealpha.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockAlphaNetworkEndpointGroups, options ...Option) (bool, []*computealpha.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *computealpha.NetworkEndpointGroup, m *MockAlphaNetworkEndpointGroups, options ...Option) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockAlphaNetworkEndpointGroups, options ...Option) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockAlphaNetworkEndpointGroups, options ...Option) (bool, map[string][]*computealpha.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsAttachEndpointsRequest, *MockAlphaNetworkEndpointGroups, ...Option) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsDetachEndpointsRequest, *MockAlphaNetworkEndpointGroups, ...Option) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *computealpha.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockAlphaNetworkEndpointGroups, ...Option) ([]*computealpha.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToAlpha()
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
	}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computealpha.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		objs = append(objs, obj.ToAlpha())
	}

	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *computealpha.NetworkEndpointGroup, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v exists", key),
		}
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "alpha", "networkEndpointGroups")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionAlpha, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockAlphaNetworkEndpointGroups %v not found", key),
		}
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computealpha.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToAlpha().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToAlpha()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToAlpha())
	}
	klog.V(5).Infof("MockAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockAlphaNetworkEndpointGroups) Obj(o *computealpha.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsAttachEndpointsRequest, options ...Option) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsDetachEndpointsRequest, options ...Option) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F, options ...Option) ([]*computealpha.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCEAlphaNetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCEAlphaNetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCEAlphaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computealpha.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCEAlphaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computealpha.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.Alpha.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computealpha.NetworkEndpointGroup
	f := func(l *computealpha.NetworkEndpointGroupList) error {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCEAlphaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *computealpha.NetworkEndpointGroup, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Alpha.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCEAlphaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEAlphaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computealpha.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Alpha.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computealpha.NetworkEndpointGroup{}
	f := func(l *computealpha.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsAttachEndpointsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsDetachEndpointsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Alpha.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCEAlphaNetworkEndpointGroups.
func (g *GCEAlphaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computealpha.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F, options ...Option) ([]*computealpha.NetworkEndpointWithHealthStatus, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "alpha", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("alpha"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Alpha.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*computealpha.NetworkEndpointWithHealthStatus
	f := func(l *computealpha.NetworkEndpointGroupsListNetworkEndpoints) error {
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEAlphaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// BetaNetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type BetaNetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *computebeta.NetworkEndpointGroup, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsAttachEndpointsRequest, ...Option) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsDetachEndpointsRequest, ...Option) error
	ListNetworkEndpoints(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsListEndpointsRequest, *filter.F, ...Option) ([]*computebeta.NetworkEndpointWithHealthStatus, error)
}

// NewMockBetaNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockBetaNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockBetaNetworkEndpointGroups {
	mock := &MockBetaNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockBetaNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockBetaNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ after the hook function executes.
	GetHook                    func(ctx context.Context, key *meta.Key, m *MockBetaNetworkEndpointGroups, options ...Option) (bool, *computebeta.NetworkEndpointGroup, error)
	ListHook                   func(ctx context.Context, zone string, fl *filter.F, m *MockBetaNetworkEndpointGroups, options ...Option) (bool, []*computebeta.NetworkEndpointGroup, error)
	InsertHook                 func(ctx context.Context, key *meta.Key, obj *computebeta.NetworkEndpointGroup, m *MockBetaNetworkEndpointGroups, options ...Option) (bool, error)
	DeleteHook                 func(ctx context.Context, key *meta.Key, m *MockBetaNetworkEndpointGroups, options ...Option) (bool, error)
	AggregatedListHook         func(ctx context.Context, fl *filter.F, m *MockBetaNetworkEndpointGroups, options ...Option) (bool, map[string][]*computebeta.NetworkEndpointGroup, error)
	AttachNetworkEndpointsHook func(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsAttachEndpointsRequest, *MockBetaNetworkEndpointGroups, ...Option) error
	DetachNetworkEndpointsHook func(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsDetachEndpointsRequest, *MockBetaNetworkEndpointGroups, ...Option) error
	ListNetworkEndpointsHook   func(context.Context, *meta.Key, *computebeta.NetworkEndpointGroupsListEndpointsRequest, *filter.F, *MockBetaNetworkEndpointGroups, ...Option) ([]*computebeta.NetworkEndpointWithHealthStatus, error)

	// X is extra state that can be used as part of the mock. Generated code
	// will not use this field.
	X interface{}
}

// Get returns the object from the mock.
func (m *MockBetaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.NetworkEndpointGroup, error) {
	if m.GetHook != nil {
		if intercept, obj, err := m.GetHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = %+v, %v", ctx, key, obj, err)
			return obj, err
		}
	}
	if !key.Valid() {
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.GetError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
		return nil, err
	}
	if obj, ok := m.Objects[*key]; ok {
		typedObj := obj.ToBeta()
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = %+v, nil", ctx, key, typedObj)
		return typedObj, nil
	}

	err := &googleapi.Error{
		Code:    http.StatusNotFound,
		Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v not found", key),
	}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Get(%v, %s) = nil, %v", ctx, key, err)
	return nil, err
}

// List all of the objects in the mock in the given zone.
func (m *MockBetaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.NetworkEndpointGroup, error) {
	if m.ListHook != nil {
		if intercept, objs, err := m.ListHook(ctx, zone, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], %v", ctx, zone, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.ListError != nil {
		err := *m.ListError
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = nil, %v", ctx, zone, fl, err)

		return nil, *m.ListError
	}

	var objs []*computebeta.NetworkEndpointGroup
	for key, obj := range m.Objects {
		if key.Zone != zone {
			continue
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		objs = append(objs, obj.ToBeta())
	}

	klog.V(5).Infof("MockBetaNetworkEndpointGroups.List(%v, %q, %v) = [%v items], nil", ctx, zone, fl, len(objs))
	return objs, nil
}

// Insert is a mock for inserting/creating a new object.
func (m *MockBetaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *computebeta.NetworkEndpointGroup, options ...Option) error {
	if m.InsertHook != nil {
		if intercept, err := m.InsertHook(ctx, key, obj, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
			return err
		}
	}
	opts := mergeOptions(options)
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.InsertError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}
	if _, ok := m.Objects[*key]; ok {
		err := &googleapi.Error{
			Code:    http.StatusConflict,
			Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v exists", key),
		}
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %v", ctx, key, obj, err)
		return err
	}

	obj.Name = key.Name
	projectID := getProjectID(ctx, m.ProjectRouter, opts, "beta", "networkEndpointGroups")
	obj.SelfLink = SelfLinkWithGroup("compute", meta.VersionBeta, projectID, "networkEndpointGroups", key)

	m.Objects[*key] = &MockNetworkEndpointGroupsObj{obj}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = nil", ctx, key, obj)
	return nil
}

// Delete is a mock for deleting the object.
func (m *MockBetaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	if m.DeleteHook != nil {
		if intercept, err := m.DeleteHook(ctx, key, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
			return err
		}
	}
	if !key.Valid() {
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if err, ok := m.DeleteError[*key]; ok {
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}
	if _, ok := m.Objects[*key]; !ok {
		err := &googleapi.Error{
			Code:    http.StatusNotFound,
			Message: fmt.Sprintf("MockBetaNetworkEndpointGroups %v not found", key),
		}
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	delete(m.Objects, *key)
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.Delete(%v, %v) = nil", ctx, key)
	return nil
}

// AggregatedList is a mock for AggregatedList.
func (m *MockBetaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.NetworkEndpointGroup, error) {
	if m.AggregatedListHook != nil {
		if intercept, objs, err := m.AggregatedListHook(ctx, fl, m, options...); intercept {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(objs), err)
			return objs, err
		}
	}

	m.Lock.Lock()
	defer m.Lock.Unlock()

	if m.AggregatedListError != nil {
		err := *m.AggregatedListError
		klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
		return nil, err
	}

	objs := map[string][]*computebeta.NetworkEndpointGroup{}
	for _, obj := range m.Objects {
		res, err := ParseResourceURL(obj.ToBeta().SelfLink)
		if err != nil {
			klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = nil, %v", ctx, fl, err)
			return nil, err
		}
		if !fl.Match(obj.ToBeta()) {
			continue
		}
		location := aggregatedListKey(res.Key)
		objs[location] = append(objs[location], obj.ToBeta())
	}
	klog.V(5).Infof("MockBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], nil", ctx, fl, len(objs))
	return objs, nil
}

// Obj wraps the object for use in the mock.
func (m *MockBetaNetworkEndpointGroups) Obj(o *computebeta.NetworkEndpointGroup) *MockNetworkEndpointGroupsObj {
	return &MockNetworkEndpointGroupsObj{o}
}

// AttachNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsAttachEndpointsRequest, options ...Option) error {
	if m.AttachNetworkEndpointsHook != nil {
		return m.AttachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// DetachNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsDetachEndpointsRequest, options ...Option) error {
	if m.DetachNetworkEndpointsHook != nil {
		return m.DetachNetworkEndpointsHook(ctx, key, arg0, m)
	}
	return nil
}

// ListNetworkEndpoints is a mock for the corresponding method.
func (m *MockBetaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F, options ...Option) ([]*computebeta.NetworkEndpointWithHealthStatus, error) {
	if m.ListNetworkEndpointsHook != nil {
		return m.ListNetworkEndpointsHook(ctx, key, arg0, fl, m)
	}
	return nil, nil
}

// GCEBetaNetworkEndpointGroups is a simplifying adapter for the GCE NetworkEndpointGroups.
type GCEBetaNetworkEndpointGroups struct {
	s *Service
}

// Get the NetworkEndpointGroup named by key.
func (g *GCEBetaNetworkEndpointGroups) Get(ctx context.Context, key *meta.Key, options ...Option) (*computebeta.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v, %v): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): key is invalid (%#v)", ctx, key, key)
		return nil, fmt.Errorf("invalid GCE key (%#v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Get",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.NetworkEndpointGroups.Get(projectID, key.Zone, key.Name)
	call.Context(ctx)
	v, err := call.Do()
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Get(%v, %v) = %+v, %v", ctx, key, v, err)

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	return v, err
}

// List all NetworkEndpointGroup objects.
func (g *GCEBetaNetworkEndpointGroups) List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computebeta.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, %v, %v, %v) called", ctx, zone, fl, opts)
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "List",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}

	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		return nil, err
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, %v, %v): projectID = %v, ck = %+v", ctx, zone, fl, projectID, ck)
	call := g.s.Beta.NetworkEndpointGroups.List(projectID, zone)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	var all []*computebeta.NetworkEndpointGroup
	f := func(l *computebeta.NetworkEndpointGroupList) error {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v): page %+v", ctx, fl, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.List(%v, ..., %v) = %v, %v", ctx, fl, asStr, nil)
	}

	return all, nil
}

// Insert NetworkEndpointGroup with key of value obj.
func (g *GCEBetaNetworkEndpointGroups) Insert(ctx context.Context, key *meta.Key, obj *computebeta.NetworkEndpointGroup, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, %+v, %v): called", ctx, key, obj, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")

	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Insert",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	obj.Name = key.Name
	call := g.s.Beta.NetworkEndpointGroups.Insert(projectID, key.Zone, obj)
	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Insert(%v, %v, %+v) = %+v", ctx, key, obj, err)
	return err
}

// Delete the NetworkEndpointGroup referenced by key.
func (g *GCEBetaNetworkEndpointGroups) Delete(ctx context.Context, key *meta.Key, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v, %v): called", ctx, key, opts)
	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): key is invalid (%#v)", ctx, key, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "Delete",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.Delete(projectID, key.Zone, key.Name)

	call.Context(ctx)

	op, err := call.Do()

	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck)

	if err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.Delete(%v, %v) = %v", ctx, key, err)
	return err
}

// AggregatedList lists all resources of the given type across all locations.
func (g *GCEBetaNetworkEndpointGroups) AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computebeta.NetworkEndpointGroup, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) called", ctx, fl)

	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AggregatedList",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}

	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): projectID = %v, ck = %+v", ctx, fl, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): RateLimiter error: %v", ctx, fl, err)
		return nil, err
	}

	call := g.s.Beta.NetworkEndpointGroups.AggregatedList(projectID)
	call.Context(ctx)
	if fl != filter.None {
		call.Filter(fl.String())
	}

	all := map[string][]*computebeta.NetworkEndpointGroup{}
	f := func(l *computebeta.NetworkEndpointGroupAggregatedList) error {
		for k, v := range l.Items {
			klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v): page[%v]%+v", ctx, fl, k, v)
			all[k] = append(all[k], v.NetworkEndpointGroups...)
		}
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, nil, err)
		return nil, err
	}
	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = [%v items], %v", ctx, fl, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AggregatedList(%v, %v) = %v, %v", ctx, fl, asStr, nil)
	}
	return all, nil
}

// AttachNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) AttachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsAttachEndpointsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "AttachNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.AttachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.AttachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// DetachNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) DetachNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsDetachEndpointsRequest, options ...Option) error {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "DetachNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return err
	}
	call := g.s.Beta.NetworkEndpointGroups.DetachNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	call.Context(ctx)
	op, err := call.Do()

	if err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
		return err
	}

	err = g.s.WaitForCompletion(ctx, op)
	callObserverEnd(ctx, ck, err)
	g.s.RateLimiter.Observe(ctx, err, ck) // XXX

	klog.V(4).Infof("GCEBetaNetworkEndpointGroups.DetachNetworkEndpoints(%v, %v, ...) = %+v", ctx, key, err)
	return err
}

// ListNetworkEndpoints is a method on GCEBetaNetworkEndpointGroups.
func (g *GCEBetaNetworkEndpointGroups) ListNetworkEndpoints(ctx context.Context, key *meta.Key, arg0 *computebeta.NetworkEndpointGroupsListEndpointsRequest, fl *filter.F, options ...Option) ([]*computebeta.NetworkEndpointWithHealthStatus, error) {
	opts := mergeOptions(options)
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, %v, ...): called", ctx, key, opts)

	if !key.Valid() {
		klog.V(2).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, %v, ...): key is invalid (%#v)", ctx, key, opts, key)
		return nil, fmt.Errorf("invalid GCE key (%+v)", key)
	}
	projectID := getProjectID(ctx, g.s.ProjectRouter, opts, "beta", "NetworkEndpointGroups")
	ck := &CallContextKey{
		ProjectID: projectID,
		Operation: "ListNetworkEndpoints",
		Version:   meta.Version("beta"),
		Service:   "NetworkEndpointGroups",
	}
	klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): projectID = %v, ck = %+v", ctx, key, projectID, ck)
	callObserverStart(ctx, ck)
	if err := g.s.RateLimiter.Accept(ctx, ck); err != nil {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): RateLimiter error: %v", ctx, key, err)
		return nil, err
	}
	call := g.s.Beta.NetworkEndpointGroups.ListNetworkEndpoints(projectID, key.Zone, key.Name, arg0)
	var all []*computebeta.NetworkEndpointWithHealthStatus
	f := func(l *computebeta.NetworkEndpointGroupsListNetworkEndpoints) error {
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...): page %+v", ctx, key, l)
		all = append(all, l.Items...)
		return nil
	}
	if err := call.Pages(ctx, f); err != nil {
		callObserverEnd(ctx, ck, err)
		g.s.RateLimiter.Observe(ctx, err, ck)

		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, nil, err)
		return nil, err
	}

	callObserverEnd(ctx, ck, nil)
	g.s.RateLimiter.Observe(ctx, nil, ck)

	if kLogEnabled(4) {
		klog.V(4).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = [%v items], %v", ctx, key, len(all), nil)
	} else if kLogEnabled(5) {
		var asStr []string
		for _, o := range all {
			asStr = append(asStr, fmt.Sprintf("%+v", o))
		}
		klog.V(5).Infof("GCEBetaNetworkEndpointGroups.ListNetworkEndpoints(%v, %v, ...) = %v, %v", ctx, key, asStr, nil)
	}
	return all, nil
}

// NetworkEndpointGroups is an interface that allows for mocking of NetworkEndpointGroups.
type NetworkEndpointGroups interface {
	Get(ctx context.Context, key *meta.Key, options ...Option) (*computega.NetworkEndpointGroup, error)
	List(ctx context.Context, zone string, fl *filter.F, options ...Option) ([]*computega.NetworkEndpointGroup, error)
	Insert(ctx context.Context, key *meta.Key, obj *computega.NetworkEndpointGroup, options ...Option) error
	Delete(ctx context.Context, key *meta.Key, options ...Option) error
	AggregatedList(ctx context.Context, fl *filter.F, options ...Option) (map[string][]*computega.NetworkEndpointGroup, error)
	AttachNetworkEndpoints(context.Context, *meta.Key, *computega.NetworkEndpointGroupsAttachEndpointsRequest, ...Option) error
	DetachNetworkEndpoints(context.Context, *meta.Key, *computega.NetworkEndpointGroupsDetachEndpointsRequest, ...Option) error
	ListNetworkEndpoints(context.Context, *meta.Key, *computega.NetworkEndpointGroupsListEndpointsRequest, *filter.F, ...Option) ([]*computega.NetworkEndpointWithHealthStatus, error)
}

// NewMockNetworkEndpointGroups returns a new mock for NetworkEndpointGroups.
func NewMockNetworkEndpointGroups(pr ProjectRouter, objs map[meta.Key]*MockNetworkEndpointGroupsObj) *MockNetworkEndpointGroups {
	mock := &MockNetworkEndpointGroups{
		ProjectRouter: pr,

		Objects:     objs,
		GetError:    map[meta.Key]error{},
		InsertError: map[meta.Key]error{},
		DeleteError: map[meta.Key]error{},
	}
	return mock
}

// MockNetworkEndpointGroups is the mock for NetworkEndpointGroups.
type MockNetworkEndpointGroups struct {
	Lock sync.Mutex

	ProjectRouter ProjectRouter

	// Objects maintained by the mock.
	Objects map[meta.Key]*MockNetworkEndpointGroupsObj

	// If an entry exists for the given key and operation, then the error
	// will be returned instead of the operation.
	GetError            map[meta.Key]error
	ListError           *error
	InsertError         map[meta.Key]error
	DeleteError         map[meta.Key]error
	AggregatedListError *error

	// xxxHook allow you to intercept the standard processing of the mock in
	// order to add your own logic. Return (true, _, _) to prevent the normal
	// execution flow of the mock. Return (false, nil, nil) to continue with
	// normal mock behavior/ a