## Release notes for kOps 1.27 series

**&#9888; kOps 1.27 has not been released yet! &#9888;**

This is a document to gather the release notes prior to the release.

# Significant changes

* **The default image has been updated to [Ubuntu 22.04 (Jammy)](https://kops.sigs.k8s.io/operations/images/#ubuntu-2204-jammy)**.

* The default retention duration for the etcd backups is now set to 90 days.
This behaviour can be overridden by setting `spec.etcdClusters[*].manager.backupRetentionDays` in the cluster spec.

* external-dns is now supported in IPv6 clusters.

* `Karpenter` has been upgraded to version `0.27.x` and the feature flag is no longer necessary.

## AWS

* As of Kubernetes version 1.27, all nodes will default to running with instance-metadata-service tokens required, with a max hop limit of 1.
Newly created clusters will be configured as necessary to have these settings.

* As of Kubernetes version 1.27, credentials for private ECR repositories will be handled by the out-of-tree credential provider. This is an additional binary that each instance downloads from the assets repository.

## GCP

## Openstack

* Nodes will now assign floating IPs when they are in a subnet that is of type `Public`. Previously
they would do so when the respective `topology` was set to `public`.

# Breaking changes

## Other breaking changes

* Support for Kubernetes version 1.21 has been removed.

# Deprecations

* Support for Kubernetes version 1.22 is deprecated and will be removed in kOps 1.28.

* Support for Kubernetes version 1.23 is deprecated and will be removed in kOps 1.29.

* Support for Ubuntu 18.04 is deprecated and will be removed in kOps 1.28.

* Support for AWS Classic Load Balancer for API is deprecated and should not be used for newly created clusters.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).

# Help Wanted

* kOps needs maintainers for Canal, Flannel, and Kube-Router to keep versions up to date and move the integration from experimental to stable.
If no volunteers step up by the time kOps 1.27 is released, support will be phased out.
