/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "k8s.io/api/resource/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PodSchedulingLister helps list PodSchedulings.
// All objects returned here must be treated as read-only.
type PodSchedulingLister interface {
	// List lists all PodSchedulings in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.PodScheduling, err error)
	// PodSchedulings returns an object that can list and get PodSchedulings.
	PodSchedulings(namespace string) PodSchedulingNamespaceLister
	PodSchedulingListerExpansion
}

// podSchedulingLister implements the PodSchedulingLister interface.
type podSchedulingLister struct {
	indexer cache.Indexer
}

// NewPodSchedulingLister returns a new PodSchedulingLister.
func NewPodSchedulingLister(indexer cache.Indexer) PodSchedulingLister {
	return &podSchedulingLister{indexer: indexer}
}

// List lists all PodSchedulings in the indexer.
func (s *podSchedulingLister) List(selector labels.Selector) (ret []*v1alpha1.PodScheduling, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.PodScheduling))
	})
	return ret, err
}

// PodSchedulings returns an object that can list and get PodSchedulings.
func (s *podSchedulingLister) PodSchedulings(namespace string) PodSchedulingNamespaceLister {
	return podSchedulingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PodSchedulingNamespaceLister helps list and get PodSchedulings.
// All objects returned here must be treated as read-only.
type PodSchedulingNamespaceLister interface {
	// List lists all PodSchedulings in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.PodScheduling, err error)
	// Get retrieves the PodScheduling from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.PodScheduling, error)
	PodSchedulingNamespaceListerExpansion
}

// podSchedulingNamespaceLister implements the PodSchedulingNamespaceLister
// interface.
type podSchedulingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PodSchedulings in the indexer for a given namespace.
func (s podSchedulingNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.PodScheduling, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.PodScheduling))
	})
	return ret, err
}

// Get retrieves the PodScheduling from the indexer for a given namespace and name.
func (s podSchedulingNamespaceLister) Get(name string) (*v1alpha1.PodScheduling, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("podscheduling"), name)
	}
	return obj.(*v1alpha1.PodScheduling), nil
}
