/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package validation

import (
	"k8s.io/apimachinery/pkg/util/validation/field"
	"k8s.io/kops/pkg/apis/kops"
)

func openstackValidateCluster(c *kops.Cluster) (errList field.ErrorList) {
	if c.Spec.CloudProvider.Openstack == nil {
		return errList
	}
	if c.Spec.CloudProvider.Openstack.Router == nil || c.Spec.CloudProvider.Openstack.Router.ExternalNetwork == nil {
		topology := c.Spec.Networking.Topology
		if topology == nil || topology.Nodes == kops.TopologyPublic {
			errList = append(errList, field.Forbidden(field.NewPath("spec", "networking", "topology", "nodes"), "Public topology requires an external network"))
		}
		if topology == nil || topology.ControlPlane == kops.TopologyPublic {
			errList = append(errList, field.Forbidden(field.NewPath("spec", "networking", "topology", "controlPlane"), "Public topology requires an external network"))
		}
	}
	return errList
}
