
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops export kubeconfig

Export kubeconfig.

### Synopsis

Export a kubeconfig file for a cluster from the state store. By default the configuration will be saved into a users $HOME/.kube/config file.

```
kops export kubeconfig [CLUSTER | --all] [flags]
```

### Examples

```
  # export a kubeconfig file with the cluster admin user (make sure you keep this user safe!)
  kops export kubeconfig k8s-cluster.example.com --admin
  
  # export using a user already existing in the kubeconfig file
  kops export kubeconfig k8s-cluster.example.com --user my-oidc-user
  
  # export using the internal DNS name, bypassing the cloud load balancer
  kops export kubeconfig k8s-cluster.example.com --internal
```

### Options

```
      --admin duration[=18h0m0s]   Also export a cluster admin user credential with the specified lifetime and add it to the cluster context
      --all                        Export all clusters from the kOps state store
      --auth-plugin                Use the kOps authentication plugin
  -h, --help                       help for kubeconfig
      --internal                   Use the cluster's internal DNS name
      --kubeconfig string          Filename of the kubeconfig to create
      --user string                Existing user in kubeconfig file to use
```

### Options inherited from parent commands

```
      --add_dir_header                   If true, adds the file directory to the header of the log messages
      --alsologtostderr                  log to standard error as well as files (no effect when -logtostderr=true)
      --config string                    yaml config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory (no effect when -logtostderr=true)
      --log_file string                  If non-empty, use this log file (no effect when -logtostderr=true)
      --log_file_max_size uint           Defines the maximum size a log file can grow to (no effect when -logtostderr=true). Unit is megabytes. If the value is 0, the maximum file size is unlimited. (default 1800)
      --logtostderr                      log to standard error instead of files (default true)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --one_output                       If true, only write logs to their native severity level (vs also writing to each lower severity level; no effect when -logtostderr=true)
      --skip_headers                     If true, avoid header prefixes in the log messages
      --skip_log_headers                 If true, avoid headers when opening log files (no effect when -logtostderr=true)
      --state string                     Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr when writing to files and stderr (no effect when -logtostderr=true or -alsologtostderr=false) (default 2)
  -v, --v Level                          number for the log level verbosity
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO

* [kops export](kops_export.md)	 - Export configuration.

