## Release notes for kOps 1.21 series

# Significant changes

## Service Account Issuer Discovery and AWS IAM Roles for Service Accounts (IRSA)

kOps now supports publishing an OIDC-compatible discovery document to an S3 bucket and configuring AWS to use it for IAM Roles for Service Accounts (IRSA).

See the [Service Account Issuer Discovery](https://kops.sigs.k8s.io/cluster_spec#service-account-issuer-discovery-and-aws-iam-roles-for-service-accounts-irsa) documentation for more information.

## Dedicated API Server nodes.

kOps now supports extending the control plane with [dedicated apiserver nodes](https://kops.sigs.k8s.io/operations/scaling). These nodes run in dedicated instance groups that can be scaled horizontally.

In 1.21, this feature is behind a feature flag as node role name, labels, taints, and domains can change based on feedback from the community.

## Warm Pool (AWS only)

A Warm Pool contains pre-initialized EC2 instances that can join the cluster significantly faster than regular instances. These instances run the kOps configuration process, pull known container images, and then shut down. When the ASG needs to scale out it will pull instances from the warm pool if any are available.

See the [warm pool](https://kops.sigs.k8s.io/instance_groups/#warmpool-aws-only) documentation for more information.

# Other significant changes

* Protokube now runs as a systemd process rather than a docker container.

* Support for AWS launch configurations has been removed in favour of launch templates.

* kOps can now use Node Termination Handler's Queue Processor mode, which offers more functionality than the IMDS Processor mode. See [the addons page](https://kops.sigs.k8s.io/addons/#queue-processor-mode) for more information.

* New addon for the [CSI snapshot-controller](https://kops.sigs.k8s.io/addons/#snapshot-controller).

# Breaking changes

* Support for Kubernetes versions 1.13 and 1.14 has been removed.

# Required Actions

* The ClusterRoleBinding for AWS EBS CSI DaemonSet has changed name. If you installed this addon before kOps 1.21, you need run `kubectl delete crb ebs-csi-node-binding`.

* To support [Node Termination Handler's Queue Process mode](https://kops.sigs.k8s.io/addons/#node-termination-handler), AWS cluster deletion now requires the kops CLI have `sqs:ListQueues` and `events:ListRules` permissions regardless of whether or not the addon is used.

# Deprecations

* Support for Kubernetes versions 1.15 and 1.16 is deprecated and will be removed in kOps 1.22.

* Support for Kubernetes version 1.17 is deprecated and will be removed in kOps 1.23.

* Support for CentOS 7 is deprecated and will be removed in future versions of kOps.

* Support for CentOS 8 is deprecated and will be removed in future versions of kOps.

* Support for Debian 9 (Stretch) is deprecated and will be removed in future versions of kOps.

* Support for RHEL 7 is deprecated and will be removed in future versions of kOps.

* Support for Ubuntu 18.04 (Bionic) is deprecated and will be removed in future versions of kOps.

* The legacy location for downloads `s3://https://kubeupv2.s3.amazonaws.com/kops/` has been deprecated and will not be used as of kOps 1.22. The new canonical downloads location is `https://artifacts.k8s.io/binaries/kops/`.

* The [manifest based metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) has been deprecated in favour of a configurable addon.

* The [manifest based cluster autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler) has been deprecated in favour of a configurable addon.

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and might be removed from control plane nodes in kOps 1.23.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this cloud provider.

# Full change list since 1.20.0 release

## 1.20.0-alpha.2 to 1.21.0-alpha.1

* Release notes for 1.20.0-alpha.2 [@hakman](https://github.com/hakman) [#10768](https://github.com/kubernetes/kops/pull/10768)
* Add troubleshooting of corrupted api server leases [@olemarkus](https://github.com/olemarkus) [#10764](https://github.com/kubernetes/kops/pull/10764)
* Boot nodes without state store access [@justinsb](https://github.com/justinsb) [#10469](https://github.com/kubernetes/kops/pull/10469)
* Update GCE zones [@bharath-123](https://github.com/bharath-123) [#10771](https://github.com/kubernetes/kops/pull/10771)
* Kubetest2 - Use a shell lexer for passing extra args to `create cluster` [@rifelpet](https://github.com/rifelpet) [#10772](https://github.com/kubernetes/kops/pull/10772)
* Use the kubeApiServerConfig clientCAFile field [@slu2011](https://github.com/slu2011) [#10707](https://github.com/kubernetes/kops/pull/10707)
* Kubetest2 - Fix splitting of --create-args [@rifelpet](https://github.com/rifelpet) [#10775](https://github.com/kubernetes/kops/pull/10775)
* Logging: don't suggest we are pre-creating DNS records unless we are [@justinsb](https://github.com/justinsb) [#10782](https://github.com/kubernetes/kops/pull/10782)
* Add missing versions to channels [@olemarkus](https://github.com/olemarkus) [#10781](https://github.com/kubernetes/kops/pull/10781)
* fix: asset task copy docker image [@johanneswuerbach](https://github.com/johanneswuerbach) [#10767](https://github.com/kubernetes/kops/pull/10767)
* Add support for creating world-readable managedFiles [@olemarkus](https://github.com/olemarkus) [#10778](https://github.com/kubernetes/kops/pull/10778)
* Update kubectl documentation with new flags [@rpadovani](https://github.com/rpadovani),[@hakman](https://github.com/hakman) [#10779](https://github.com/kubernetes/kops/pull/10779)
* Add overrides testing in lifecycle integration tests [@rifelpet](https://github.com/rifelpet) [#10752](https://github.com/kubernetes/kops/pull/10752)
* Add AWS LoadBalancerController [@olemarkus](https://github.com/olemarkus) [#10489](https://github.com/kubernetes/kops/pull/10489)
* Update Calico to v3.17.2 [@hakman](https://github.com/hakman) [#10787](https://github.com/kubernetes/kops/pull/10787)
* Enable CSIMigrationAWS if CSI EBS driver is installed [@olemarkus](https://github.com/olemarkus) [#10791](https://github.com/kubernetes/kops/pull/10791)
* Fill Role names in kops-controller-config instead of instance profile names when it is specified [@h3poteto](https://github.com/h3poteto) [#10728](https://github.com/kubernetes/kops/pull/10728)
* Storage: Allow disabling of kOps's management of StorageClasses [@seh](https://github.com/seh) [#10733](https://github.com/kubernetes/kops/pull/10733)
* kubetest2 - Dump all pod logs in addition to host logs [@rifelpet](https://github.com/rifelpet) [#10799](https://github.com/kubernetes/kops/pull/10799)
* Update Docker to v19.03.15 [@hakman](https://github.com/hakman) [#10802](https://github.com/kubernetes/kops/pull/10802)
* Fix LaunchSpec TF output [@hakman](https://github.com/hakman) [#10806](https://github.com/kubernetes/kops/pull/10806)
* Make protokube CP label setting consistent with kops-controller [@olemarkus](https://github.com/olemarkus) [#10780](https://github.com/kubernetes/kops/pull/10780)
* Add deprecation notice for launch templates.  [@bharath-123](https://github.com/bharath-123) [#10809](https://github.com/kubernetes/kops/pull/10809)
* add azure support for internal loadbalancer to k8s api [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10744](https://github.com/kubernetes/kops/pull/10744)
* Allow managed images for Azure instance groups [@NickSchleicher](https://github.com/NickSchleicher) [#10797](https://github.com/kubernetes/kops/pull/10797)
* kubenet containerd: match upstream [@justinsb](https://github.com/justinsb) [#10759](https://github.com/kubernetes/kops/pull/10759)
* kubetest2: Add --host argument [@justinsb](https://github.com/justinsb) [#10814](https://github.com/kubernetes/kops/pull/10814)
* iptables: Use the lock when checking for existing rules [@justinsb](https://github.com/justinsb) [#10812](https://github.com/kubernetes/kops/pull/10812)
* Spotinst: Replace corev1.Taint to fix HCL2 serialization [@liranp](https://github.com/liranp) [#10819](https://github.com/kubernetes/kops/pull/10819)
* Spotinst: Bump the Ocean Controller to 1.0.72 [@liranp](https://github.com/liranp) [#10820](https://github.com/kubernetes/kops/pull/10820)
* Allow to control which subnets and IPs get used for the API loadbalancer [@codablock](https://github.com/codablock) [#10741](https://github.com/kubernetes/kops/pull/10741)
* kubetest2: Call Test, not Execute [@justinsb](https://github.com/justinsb) [#10824](https://github.com/kubernetes/kops/pull/10824)
* Fix kdi 'must specify' error [@olemarkus](https://github.com/olemarkus) [#10825](https://github.com/kubernetes/kops/pull/10825)
* Update aws-sdk-go [@rifelpet](https://github.com/rifelpet) [#10830](https://github.com/kubernetes/kops/pull/10830)
* Use correct tag when creating node labels from azure cloud tags [@NickSchleicher](https://github.com/NickSchleicher) [#10619](https://github.com/kubernetes/kops/pull/10619)
* Precreate the kops-controller DNS name [@rifelpet](https://github.com/rifelpet) [#10833](https://github.com/kubernetes/kops/pull/10833)
* containerd installation: always configure, even if we don't install [@justinsb](https://github.com/justinsb) [#10813](https://github.com/kubernetes/kops/pull/10813)
* Release binaries for protokube and channels [@hakman](https://github.com/hakman) [#10840](https://github.com/kubernetes/kops/pull/10840)
* Release 1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10841](https://github.com/kubernetes/kops/pull/10841)

## 1.21.0-alpha.1 to 1.21.0-alpha.2

* Release notes for 1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10844](https://github.com/kubernetes/kops/pull/10844)
* Update mock to v1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10845](https://github.com/kubernetes/kops/pull/10845)
* Kubetest2 - terraform support [@rifelpet](https://github.com/rifelpet) [#10697](https://github.com/kubernetes/kops/pull/10697)
* Actually enable systemd cgroup for containerd [@codablock](https://github.com/codablock) [#10846](https://github.com/kubernetes/kops/pull/10846)
* Update Go to v1.15.8 [@hakman](https://github.com/hakman) [#10853](https://github.com/kubernetes/kops/pull/10853)
* Add liveness probe for calico-kube-controllers [@hakman](https://github.com/hakman) [#10856](https://github.com/kubernetes/kops/pull/10856)
* Fix OpenStack delete functions [@ottosulin](https://github.com/ottosulin) [#10849](https://github.com/kubernetes/kops/pull/10849)
* Add support for CAS 1.20 + support for disabling CAS for a given IG [@olemarkus](https://github.com/olemarkus) [#10857](https://github.com/kubernetes/kops/pull/10857)
* Bump aws node termination handler to 1.12.0 [@bharath-123](https://github.com/bharath-123) [#10863](https://github.com/kubernetes/kops/pull/10863)
* Kubetest2 - add ginkgo node debug logs [@rifelpet](https://github.com/rifelpet) [#10866](https://github.com/kubernetes/kops/pull/10866)
* K8s Version Updates February 2021 [@MoShitrit](https://github.com/MoShitrit) [#10865](https://github.com/kubernetes/kops/pull/10865)
* Add note about remote identities [@olemarkus](https://github.com/olemarkus) [#10868](https://github.com/kubernetes/kops/pull/10868)
* Bump metrics-server to 0.4.2 [@olemarkus](https://github.com/olemarkus) [#10858](https://github.com/kubernetes/kops/pull/10858)
* kubetest2 - support terraform with `kops create cluster` [@rifelpet](https://github.com/rifelpet) [#10867](https://github.com/kubernetes/kops/pull/10867)
* Add validation for instanceType and ami architecture  [@bharath-123](https://github.com/bharath-123) [#10747](https://github.com/kubernetes/kops/pull/10747)
* Upgrade k8s 1.20 to latest patch version [@MoShitrit](https://github.com/MoShitrit) [#10875](https://github.com/kubernetes/kops/pull/10875)
* Update AWS CNI to latest patch version [@MoShitrit](https://github.com/MoShitrit) [#10876](https://github.com/kubernetes/kops/pull/10876)
* Fixes for 1.21 e2e tests [@olemarkus](https://github.com/olemarkus) [#10879](https://github.com/kubernetes/kops/pull/10879)
* Release notes for 1.19.1 [@justinsb](https://github.com/justinsb) [#10883](https://github.com/kubernetes/kops/pull/10883)
* Improve machine type and image validation [@hakman](https://github.com/hakman) [#10884](https://github.com/kubernetes/kops/pull/10884)
* fix loadBalancerID null pointer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10886](https://github.com/kubernetes/kops/pull/10886)
* Update Openstack Cloud Go module to v1.20.1 [@bmelbourne](https://github.com/bmelbourne) [#10896](https://github.com/kubernetes/kops/pull/10896)
* Enforce 1.14 deprecation [@olemarkus](https://github.com/olemarkus) [#10897](https://github.com/kubernetes/kops/pull/10897)
* add usage of subnet and routetable shared resources in azure [@ngalantowicz](https://github.com/ngalantowicz) [#10900](https://github.com/kubernetes/kops/pull/10900)
* Update Calico to v3.18.0 [@hakman](https://github.com/hakman) [#10904](https://github.com/kubernetes/kops/pull/10904)
* Adding Elastic IP Allocations to NLB API [@timothyclarke](https://github.com/timothyclarke) [#10872](https://github.com/kubernetes/kops/pull/10872)
* Release notes for 1.20.0-beta.1 [@hakman](https://github.com/hakman) [#10909](https://github.com/kubernetes/kops/pull/10909)
* Update Google Cloud Go module to v0.77.0 [@bmelbourne](https://github.com/bmelbourne) [#10894](https://github.com/kubernetes/kops/pull/10894)
* Add Tagging to Instance Profiles and OIDC Providers [@rifelpet](https://github.com/rifelpet) [#10832](https://github.com/kubernetes/kops/pull/10832)
* AWS LB controller is as of 1.20, not 1.19 [@olemarkus](https://github.com/olemarkus) [#10919](https://github.com/kubernetes/kops/pull/10919)
* Spotinst: Prevent instance groups with the same suffix from being deleted [@liranp](https://github.com/liranp) [#10918](https://github.com/kubernetes/kops/pull/10918)
* add support for azure public loadbalancer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10915](https://github.com/kubernetes/kops/pull/10915)
* Fix nil pointer deference for image ID with spotinst [@hakman](https://github.com/hakman) [#10924](https://github.com/kubernetes/kops/pull/10924)
* Update SSH documentation for ubuntu [@jpugliesi](https://github.com/jpugliesi) [#10931](https://github.com/kubernetes/kops/pull/10931)
* Fix no-schedule issue [@christian-schlichtherle](https://github.com/christian-schlichtherle) [#10928](https://github.com/kubernetes/kops/pull/10928)
* Update Controller Runtime Go module to v0.8.2 [@bmelbourne](https://github.com/bmelbourne) [#10914](https://github.com/kubernetes/kops/pull/10914)
* Sort external policies when checking for changes [@hakman](https://github.com/hakman) [#10940](https://github.com/kubernetes/kops/pull/10940)
* Instruct GH to collapse BUILD.bazel diffs by default [@rifelpet](https://github.com/rifelpet) [#10912](https://github.com/kubernetes/kops/pull/10912)
* Further improve cloudLabel validation [@olemarkus](https://github.com/olemarkus) [#10910](https://github.com/kubernetes/kops/pull/10910)
* Add a standardised set of labels on all resources [@olemarkus](https://github.com/olemarkus) [#10796](https://github.com/kubernetes/kops/pull/10796)
* Bump external-dns to 0.7.6 [@olemarkus](https://github.com/olemarkus) [#10946](https://github.com/kubernetes/kops/pull/10946)
* Update etcd-manager to 3.0.20210228 [@justinsb](https://github.com/justinsb) [#10949](https://github.com/kubernetes/kops/pull/10949)
* gce doesn't suffix the IG names with ClusterName [@olemarkus](https://github.com/olemarkus) [#10944](https://github.com/kubernetes/kops/pull/10944)
* Add AWS Transit Gateway support [@rifelpet](https://github.com/rifelpet) [#10948](https://github.com/kubernetes/kops/pull/10948)
* Fix node label conversion in Azure [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10935](https://github.com/kubernetes/kops/pull/10935)
* Spotinst: Bump the Ocean Controller to 1.0.73 [@liranp](https://github.com/liranp) [#10960](https://github.com/kubernetes/kops/pull/10960)
* Spotinst: Don't skip LB attachments when SpotinstHybrid is enabled [@liranp](https://github.com/liranp) [#10961](https://github.com/kubernetes/kops/pull/10961)
* Add explicit RBAC permissions for finalizers subresources [@olemarkus](https://github.com/olemarkus) [#10966](https://github.com/kubernetes/kops/pull/10966)
* Fix typos in docs/getting_started [@roim](https://github.com/roim) [#10921](https://github.com/kubernetes/kops/pull/10921)
* Add support for CPU Credits on AWS t2 and t3 instance families [@rifelpet](https://github.com/rifelpet) [#10934](https://github.com/kubernetes/kops/pull/10934)
* Add support for enable-cadvisor-json-endpoints with Kubelet [@adrianmoisey](https://github.com/adrianmoisey) [#10957](https://github.com/kubernetes/kops/pull/10957)
* Exclude CP nodes from load balancers [@olemarkus](https://github.com/olemarkus) [#10945](https://github.com/kubernetes/kops/pull/10945)
* Update k8s.io Go modules to v0.20.4 [@bmelbourne](https://github.com/bmelbourne) [#10965](https://github.com/kubernetes/kops/pull/10965)
* Update Go to v1.16 [@bmelbourne](https://github.com/bmelbourne) [#10892](https://github.com/kubernetes/kops/pull/10892)
* Add a note about informal office hours [@olemarkus](https://github.com/olemarkus) [#10650](https://github.com/kubernetes/kops/pull/10650)
* Removing duplicate local and output values in terraform(#10786) [@mmerrill3](https://github.com/mmerrill3) [#10978](https://github.com/kubernetes/kops/pull/10978)
* Add CloudLabels as --extra-tags to aws-ebs-csi driver [@codablock](https://github.com/codablock) [#10976](https://github.com/kubernetes/kops/pull/10976)
* Use internal api url for jwks [@olemarkus](https://github.com/olemarkus) [#10888](https://github.com/kubernetes/kops/pull/10888)
* Disable Calico Prometheus metrics by default [@hakman](https://github.com/hakman) [#10982](https://github.com/kubernetes/kops/pull/10982)
* Add etcd-manager discoveryPollInterval option [@ottosulin](https://github.com/ottosulin) [#10975](https://github.com/kubernetes/kops/pull/10975)
* Remove manually added labels from addons [@hakman](https://github.com/hakman) [#10987](https://github.com/kubernetes/kops/pull/10987)
* Fix kops-controller rbac due to leader election change [@olemarkus](https://github.com/olemarkus) [#10988](https://github.com/kubernetes/kops/pull/10988)
* Various cleanups around apply_cluster and awsmodel [@olemarkus](https://github.com/olemarkus) [#10579](https://github.com/kubernetes/kops/pull/10579)
* Fix very minor formatting typos in docs/manifests_and_customizing_via_api [@vitaliyf](https://github.com/vitaliyf) [#10990](https://github.com/kubernetes/kops/pull/10990)
* Run protokube as a systemd service [@bharath-123](https://github.com/bharath-123),[@hakman](https://github.com/hakman) [#10574](https://github.com/kubernetes/kops/pull/10574)
* kubetest2 - don't overwrite create args that use equals signs [@rifelpet](https://github.com/rifelpet) [#10994](https://github.com/kubernetes/kops/pull/10994)
* Remove support for launch configurations [@bharath-123](https://github.com/bharath-123) [#10937](https://github.com/kubernetes/kops/pull/10937)
* Use exponential backoff for DNS updates [@hakman](https://github.com/hakman) [#10996](https://github.com/kubernetes/kops/pull/10996)
* Storage: Amend default choice for StorageClass management to honor a specified OpenStack-related value [@seh](https://github.com/seh) [#11002](https://github.com/kubernetes/kops/pull/11002)
* Add to 1.21 release notes [@bharath-123](https://github.com/bharath-123) [#11004](https://github.com/kubernetes/kops/pull/11004)
* Kubetest2 - Add support for publishing the kops version marker [@rifelpet](https://github.com/rifelpet) [#11006](https://github.com/kubernetes/kops/pull/11006)
* Kubetest2 - Fix kops' --kubernetes-version with k8s version markers [@rifelpet](https://github.com/rifelpet) [#11007](https://github.com/kubernetes/kops/pull/11007)
* Don't build kops during periodic upgrade tests [@rifelpet](https://github.com/rifelpet) [#11005](https://github.com/kubernetes/kops/pull/11005)
* Remove extraneous field from integration test [@rifelpet](https://github.com/rifelpet) [#11010](https://github.com/kubernetes/kops/pull/11010)
* Remove trailing newline from kubernetes version marker [@rifelpet](https://github.com/rifelpet) [#11011](https://github.com/kubernetes/kops/pull/11011)
* aws: Graceful handling of EC2 detach errors [@hwoarang](https://github.com/hwoarang) [#10740](https://github.com/kubernetes/kops/pull/10740)
* Kubetest2 - use same kops binary for all commands in upgrade scenario [@rifelpet](https://github.com/rifelpet) [#11017](https://github.com/kubernetes/kops/pull/11017)
* Update Calico to v3.18.1 [@hakman](https://github.com/hakman) [#11018](https://github.com/kubernetes/kops/pull/11018)
* Increase route53 retry count from 3 to 5 [@rifelpet](https://github.com/rifelpet) [#11020](https://github.com/kubernetes/kops/pull/11020)
* Spotinst: Add support for block device mappings in Ocean Launch Spec [@liranp](https://github.com/liranp) [#11009](https://github.com/kubernetes/kops/pull/11009)
* Allow cilium 1.10 [@olemarkus](https://github.com/olemarkus) [#11026](https://github.com/kubernetes/kops/pull/11026)
* Fix rendering of multiple Docker insecure registries [@hakman](https://github.com/hakman) [#11027](https://github.com/kubernetes/kops/pull/11027)
* azure: fix null pointer when updating in place cluster [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#11015](https://github.com/kubernetes/kops/pull/11015)
* Release notes for 1.20.0-beta.2 [@hakman](https://github.com/hakman) [#11034](https://github.com/kubernetes/kops/pull/11034)
* Update k8s dependencies to v1.21.0-beta.1 [@hakman](https://github.com/hakman) [#11013](https://github.com/kubernetes/kops/pull/11013)
* Trim space on kops version markers [@rifelpet](https://github.com/rifelpet) [#11037](https://github.com/kubernetes/kops/pull/11037)
* Honor OS update policy at InstanceGroup level too [@seh](https://github.com/seh) [#10913](https://github.com/kubernetes/kops/pull/10913)
* Update Go to v1.16.2 [@hakman](https://github.com/hakman) [#11039](https://github.com/kubernetes/kops/pull/11039)
* Create an environment file for kops-configuration systemd process [@bharath-123](https://github.com/bharath-123) [#11042](https://github.com/kubernetes/kops/pull/11042)
* Improve instance type validation error message [@bharath-123](https://github.com/bharath-123) [#11043](https://github.com/kubernetes/kops/pull/11043)
* Revert upgrade script to build kops [@rifelpet](https://github.com/rifelpet) [#11044](https://github.com/kubernetes/kops/pull/11044)
* cluster validation - allow flapping of validation errors [@rifelpet](https://github.com/rifelpet) [#11049](https://github.com/kubernetes/kops/pull/11049)
* Update Terraform to v0.14.8 [@bmelbourne](https://github.com/bmelbourne) [#11051](https://github.com/kubernetes/kops/pull/11051)
* Cleanup some nodeup & protokube logging [@rifelpet](https://github.com/rifelpet) [#11052](https://github.com/kubernetes/kops/pull/11052)
* Update Go modules to latest versions [@bmelbourne](https://github.com/bmelbourne) [#11047](https://github.com/kubernetes/kops/pull/11047)
* Add channels entries for image architecture [@hakman](https://github.com/hakman) [#11046](https://github.com/kubernetes/kops/pull/11046)
* fix CNI bin path in troubleshoot.md [@adrianmester](https://github.com/adrianmester) [#11061](https://github.com/kubernetes/kops/pull/11061)
* Kubetest2 - Add GCE default SSH key values from prow jobs [@rifelpet](https://github.com/rifelpet) [#11065](https://github.com/kubernetes/kops/pull/11065)
* correct a word for readme [@yojay11717](https://github.com/yojay11717) [#11066](https://github.com/kubernetes/kops/pull/11066)
* Update Bazel to v3.5.0 [@hakman](https://github.com/hakman) [#11041](https://github.com/kubernetes/kops/pull/11041)
* Install bazelisk before pushing images [@hakman](https://github.com/hakman) [#11067](https://github.com/kubernetes/kops/pull/11067)
* Kubetest2 - Add boskos for GCE support [@rifelpet](https://github.com/rifelpet) [#11070](https://github.com/kubernetes/kops/pull/11070)
* Download kubectl to /opt/kops/bin on Flatcar OS [@rifelpet](https://github.com/rifelpet) [#11054](https://github.com/kubernetes/kops/pull/11054)
* Kubetest2 - initialize boskos heartbeat channel [@rifelpet](https://github.com/rifelpet) [#11073](https://github.com/kubernetes/kops/pull/11073)
* Instance roles for service accounts (IRSA) contd [@rifelpet](https://github.com/rifelpet),[@olemarkus](https://github.com/olemarkus) [#10756](https://github.com/kubernetes/kops/pull/10756)
* Kubetest2 - add more validation time for --target terraform [@rifelpet](https://github.com/rifelpet) [#11077](https://github.com/kubernetes/kops/pull/11077)
* Fix GCE channels version constraints [@rifelpet](https://github.com/rifelpet) [#11076](https://github.com/kubernetes/kops/pull/11076)
* Update k8s versions with March 2021 releases [@MoShitrit](https://github.com/MoShitrit) [#11075](https://github.com/kubernetes/kops/pull/11075)
* Upgrade AWS CNI to version 1.7.10 [@MoShitrit](https://github.com/MoShitrit) [#11078](https://github.com/kubernetes/kops/pull/11078)
* Improve error messages around PublicJWKS [@justinsb](https://github.com/justinsb) [#11085](https://github.com/kubernetes/kops/pull/11085)
* Don't add control-plane DNS permissions with UseServiceAccountIAM [@justinsb](https://github.com/justinsb) [#11086](https://github.com/kubernetes/kops/pull/11086)
* Ensure a publicdatastore exists for jwks and that it can only be s3 [@olemarkus](https://github.com/olemarkus) [#11081](https://github.com/kubernetes/kops/pull/11081)
* Apiserver nodes [@olemarkus](https://github.com/olemarkus) [#10722](https://github.com/kubernetes/kops/pull/10722)
* fix(docs): cpuCFSQuotaPeriod needs a feature gate [@danmx](https://github.com/danmx) [#11071](https://github.com/kubernetes/kops/pull/11071)
* Update Ubuntu 20.04 to latest AMI [@bmelbourne](https://github.com/bmelbourne) [#11083](https://github.com/kubernetes/kops/pull/11083)
* Re-add integration tests for jwks [@justinsb](https://github.com/justinsb) [#11087](https://github.com/kubernetes/kops/pull/11087)
* Replace go-bindata with go:embed [@rifelpet](https://github.com/rifelpet) [#11089](https://github.com/kubernetes/kops/pull/11089)
* Dns controller fixes [@olemarkus](https://github.com/olemarkus) [#11069](https://github.com/kubernetes/kops/pull/11069)
* Remove unused RoleLabelName16 [@justinsb](https://github.com/justinsb) [#11097](https://github.com/kubernetes/kops/pull/11097)
* Add additional IOPS validation for AWS EBS gp3 volumes [@lichuan0620](https://github.com/lichuan0620) [#10843](https://github.com/kubernetes/kops/pull/10843)
* Update google SDK libraries [@justinsb](https://github.com/justinsb) [#11096](https://github.com/kubernetes/kops/pull/11096)
* Add values page [@justinsb](https://github.com/justinsb) [#11094](https://github.com/kubernetes/kops/pull/11094)
* Deeper validation in dns controller tests [@justinsb](https://github.com/justinsb) [#11095](https://github.com/kubernetes/kops/pull/11095)
* Ensure protokube can connect to kube-apiserver before starting the sync loop [@olemarkus](https://github.com/olemarkus) [#11093](https://github.com/kubernetes/kops/pull/11093)
* Remove dbus dependency [@bharath-123](https://github.com/bharath-123) [#11082](https://github.com/kubernetes/kops/pull/11082)
* Have nodeup retry kops-controller bootstrapping sooner if DNS isn't setup [@rifelpet](https://github.com/rifelpet) [#11101](https://github.com/kubernetes/kops/pull/11101)
* Update AWS zones used by e2e tests [@rifelpet](https://github.com/rifelpet) [#11103](https://github.com/kubernetes/kops/pull/11103)
* Add docs about dedicated apiserver ndoes [@olemarkus](https://github.com/olemarkus) [#11090](https://github.com/kubernetes/kops/pull/11090)
* Put awslbcontroller on the control-plane [@olemarkus](https://github.com/olemarkus) [#11091](https://github.com/kubernetes/kops/pull/11091)
* Release 1.21.0 alpha.2 [@hakman](https://github.com/hakman) [#11109](https://github.com/kubernetes/kops/pull/11109)

## 1.21.0-alpha.2 to 1.21.0-alpha.3

* Release notes for 1.21.0-alpha.2 [@hakman](https://github.com/hakman) [#11111](https://github.com/kubernetes/kops/pull/11111)
* Update release process docs [@hakman](https://github.com/hakman) [#11112](https://github.com/kubernetes/kops/pull/11112)
* Use "tag on create" for EIPs, NLBs, and TargetGroups [@rifelpet](https://github.com/rifelpet) [#11107](https://github.com/kubernetes/kops/pull/11107)
* Load env vars from file for kops-configuration service [@hakman](https://github.com/hakman) [#11114](https://github.com/kubernetes/kops/pull/11114)
* Update containerd to v1.3.10/v1.4.4 [@bmelbourne](https://github.com/bmelbourne) [#11084](https://github.com/kubernetes/kops/pull/11084)
* [DigitalOcean] Fix DO Tag issue [@srikiz](https://github.com/srikiz) [#11102](https://github.com/kubernetes/kops/pull/11102)
* Kubetest2 - Setup SSH keys for GCE [@rifelpet](https://github.com/rifelpet) [#11123](https://github.com/kubernetes/kops/pull/11123)
* Validate that kube-apiserver has the necessary authz modes set [@olemarkus](https://github.com/olemarkus) [#11127](https://github.com/kubernetes/kops/pull/11127)
* Remove instance-selector label [@bharath-123](https://github.com/bharath-123) [#11048](https://github.com/kubernetes/kops/pull/11048)
* Kubetest2 - fix temp directory created for GCE SSH keys [@rifelpet](https://github.com/rifelpet) [#11133](https://github.com/kubernetes/kops/pull/11133)
* replace hard coded aws region checks with aws sdk calls [@guydog28](https://github.com/guydog28) [#11119](https://github.com/kubernetes/kops/pull/11119)
* kubetest2 - Specify GCE network name  [@rifelpet](https://github.com/rifelpet) [#11139](https://github.com/kubernetes/kops/pull/11139)
* Update protokube systemd unit docs link [@rifelpet](https://github.com/rifelpet) [#11138](https://github.com/kubernetes/kops/pull/11138)
* Add scaleDownDelayAfterAdd to clusterAutoscaler spec [@jurriaanpro](https://github.com/jurriaanpro) [#11140](https://github.com/kubernetes/kops/pull/11140)
* Update cluster_spec.md [@carnivorelogic](https://github.com/carnivorelogic) [#11142](https://github.com/kubernetes/kops/pull/11142)
* minor protokube code clean up [@bharath-123](https://github.com/bharath-123) [#11143](https://github.com/kubernetes/kops/pull/11143)
* Pass ctx to drain helper [@olemarkus](https://github.com/olemarkus) [#11146](https://github.com/kubernetes/kops/pull/11146)
* Change registrable domains to placeholders [@lukehinds](https://github.com/lukehinds) [#11147](https://github.com/kubernetes/kops/pull/11147)
* Add tags to instance profile and OIDC provider terraform resources [@rifelpet](https://github.com/rifelpet) [#11149](https://github.com/kubernetes/kops/pull/11149)
* Clarify release notes around exporting kubeconfig [@justinsb](https://github.com/justinsb) [#11154](https://github.com/kubernetes/kops/pull/11154)
* Expand flag help on --user flags [@justinsb](https://github.com/justinsb) [#11153](https://github.com/kubernetes/kops/pull/11153)
* Update Getting Started AWS guide [@allir](https://github.com/allir) [#11150](https://github.com/kubernetes/kops/pull/11150)
* fix the mistake link in addons.md [@maoyangLiu](https://github.com/maoyangLiu) [#11151](https://github.com/kubernetes/kops/pull/11151)
* cloudbuild: capture some hashes [@justinsb](https://github.com/justinsb) [#11159](https://github.com/kubernetes/kops/pull/11159)
* Only update kops-controller pods on deletion [@olemarkus](https://github.com/olemarkus) [#10871](https://github.com/kubernetes/kops/pull/10871)
* Side load images also on apiserver [@olemarkus](https://github.com/olemarkus) [#11156](https://github.com/kubernetes/kops/pull/11156)
* Add an option to skip NTP installation [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11160](https://github.com/kubernetes/kops/pull/11160)
* kubetest2 - Pass GOPATH when building kops [@rifelpet](https://github.com/rifelpet) [#11167](https://github.com/kubernetes/kops/pull/11167)
* Filter kOps NatGateways from route table [@zetaab](https://github.com/zetaab) [#11169](https://github.com/kubernetes/kops/pull/11169)
* Bump k8s deps to 1.21-rc.0 [@olemarkus](https://github.com/olemarkus) [#11168](https://github.com/kubernetes/kops/pull/11168)
* Allow setting dedicated apiserver node count from create cluster cmd [@olemarkus](https://github.com/olemarkus) [#11152](https://github.com/kubernetes/kops/pull/11152)
* Update Go to v1.16.3 [@bmelbourne](https://github.com/bmelbourne) [#11174](https://github.com/kubernetes/kops/pull/11174)
* Add integration test for aws lb controller [@olemarkus](https://github.com/olemarkus) [#11175](https://github.com/kubernetes/kops/pull/11175)
* Enable use of irsa for aws load balancer controller [@olemarkus](https://github.com/olemarkus) [#11088](https://github.com/kubernetes/kops/pull/11088)
* Increase timeout and update images for postsubmit job [@rifelpet](https://github.com/rifelpet) [#11177](https://github.com/kubernetes/kops/pull/11177)
* Update Go modules to latest versions [@bmelbourne](https://github.com/bmelbourne) [#11176](https://github.com/kubernetes/kops/pull/11176)
* Kubetest2 - Add flag to expose cluster validation wait time [@rifelpet](https://github.com/rifelpet) [#11178](https://github.com/kubernetes/kops/pull/11178)
* Spotinst: Use BDM to configure the root volume size at VNG level [@liranp](https://github.com/liranp) [#11179](https://github.com/kubernetes/kops/pull/11179)
* Spotinst: Configure headroom resources only at the VNG level [@liranp](https://github.com/liranp) [#11181](https://github.com/kubernetes/kops/pull/11181)
* Update k8s dependencies to v1.21.0 [@hakman](https://github.com/hakman) [#11188](https://github.com/kubernetes/kops/pull/11188)
* Release notes for 1.19.2 [@justinsb](https://github.com/justinsb) [#11193](https://github.com/kubernetes/kops/pull/11193)
* Update node local dns cache [@zetaab](https://github.com/zetaab) [#11057](https://github.com/kubernetes/kops/pull/11057)
* Update cilium.md [@recollir](https://github.com/recollir) [#11189](https://github.com/kubernetes/kops/pull/11189)
* Release notes for 1.20.0 [@justinsb](https://github.com/justinsb) [#11196](https://github.com/kubernetes/kops/pull/11196)
* Docs: Remove 'prerelease' warning from 1.20 [@justinsb](https://github.com/justinsb) [#11198](https://github.com/kubernetes/kops/pull/11198)
* Kubetest2 - Create project-specific state store buckets in GCP [@rifelpet](https://github.com/rifelpet) [#11200](https://github.com/kubernetes/kops/pull/11200)
* Update release compatibility matrix [@johngmyers](https://github.com/johngmyers) [#11201](https://github.com/kubernetes/kops/pull/11201)
* Update integration tests to k8s v1.21.0 [@bmelbourne](https://github.com/bmelbourne) [#11206](https://github.com/kubernetes/kops/pull/11206)
* Kubetest2 - Set KOPS_BASE_URL to --build's stage location [@rifelpet](https://github.com/rifelpet) [#11210](https://github.com/kubernetes/kops/pull/11210)
* Update Docker to v20.10.5 [@bmelbourne](https://github.com/bmelbourne) [#11195](https://github.com/kubernetes/kops/pull/11195)
* Rename the service account key [@johngmyers](https://github.com/johngmyers) [#11207](https://github.com/kubernetes/kops/pull/11207)
* Update go deps [@zetaab](https://github.com/zetaab) [#11208](https://github.com/kubernetes/kops/pull/11208)
* Kubetest2 - detect errors creating GCS bucket [@rifelpet](https://github.com/rifelpet) [#11212](https://github.com/kubernetes/kops/pull/11212)
* Kubetest2 - Ensure the bucket path is the final gsutil arg [@rifelpet](https://github.com/rifelpet) [#11215](https://github.com/kubernetes/kops/pull/11215)
* Update IG tutorial for per-AZ node groups [@rifelpet](https://github.com/rifelpet) [#11218](https://github.com/kubernetes/kops/pull/11218)
* Use "string" for architecture type in ChannelRecommendedImage [@hakman](https://github.com/hakman) [#11220](https://github.com/kubernetes/kops/pull/11220)
* Always secure api -> kubelet communication [@olemarkus](https://github.com/olemarkus) [#11185](https://github.com/kubernetes/kops/pull/11185)
* Fix etcd volume validation logic [@hakman](https://github.com/hakman) [#11225](https://github.com/kubernetes/kops/pull/11225)
* Replace k8s.io/utils/mount with k8s.io/mount-utils [@hakman](https://github.com/hakman) [#11229](https://github.com/kubernetes/kops/pull/11229)
* Release 1.21.0-alpha.3 [@hakman](https://github.com/hakman) [#11231](https://github.com/kubernetes/kops/pull/11231)

## 1.21.0-alpha.3 to 1.21.0-beta.1

* fix a typo [@yojay11717](https://github.com/yojay11717) [#11232](https://github.com/kubernetes/kops/pull/11232)
* Release notes for 1.21.0-alpha.3 [@hakman](https://github.com/hakman) [#11233](https://github.com/kubernetes/kops/pull/11233)
* Remove validations for EBS from cluster validation [@h3poteto](https://github.com/h3poteto) [#11228](https://github.com/kubernetes/kops/pull/11228)
* Add support for Docker v20.10.6 [@hakman](https://github.com/hakman) [#11236](https://github.com/kubernetes/kops/pull/11236)
* Don't start kubelet if instance is entering the warm pool [@olemarkus](https://github.com/olemarkus) [#11216](https://github.com/kubernetes/kops/pull/11216)
* Correct typos [@Akiros001](https://github.com/Akiros001) [#11238](https://github.com/kubernetes/kops/pull/11238)
* Logging cleanup [@rifelpet](https://github.com/rifelpet) [#11080](https://github.com/kubernetes/kops/pull/11080)
* Update kops_create_secret_dockerconfig.md [@integrii](https://github.com/integrii),[@hakman](https://github.com/hakman) [#11186](https://github.com/kubernetes/kops/pull/11186)
* Remove BLM banner  [@hakman](https://github.com/hakman) [#10672](https://github.com/kubernetes/kops/pull/10672)
* Run tests only in zones with increased limits [@hakman](https://github.com/hakman) [#11240](https://github.com/kubernetes/kops/pull/11240)
* Give kOps CLI knowledge about ASG warm pools [@olemarkus](https://github.com/olemarkus) [#11227](https://github.com/kubernetes/kops/pull/11227)
* Fix golint issue caused by typo [@fenggw-fnst](https://github.com/fenggw-fnst) [#11239](https://github.com/kubernetes/kops/pull/11239)
* Remove unused constants [@johngmyers](https://github.com/johngmyers) [#11241](https://github.com/kubernetes/kops/pull/11241)
* Bump k8s versions with April 2021 releases in Alpha channel [@MoShitrit](https://github.com/MoShitrit) [#11245](https://github.com/kubernetes/kops/pull/11245)
* Update kOps recommended versions and images [@hakman](https://github.com/hakman) [#11247](https://github.com/kubernetes/kops/pull/11247)
* Kubetest2 - Cleanup leaked resources from previous clusters [@rifelpet](https://github.com/rifelpet) [#11250](https://github.com/kubernetes/kops/pull/11250)
* Run tests in all regions with increased limits [@hakman](https://github.com/hakman) [#11249](https://github.com/kubernetes/kops/pull/11249)
* Don't set NeedUpdate on first addon install [@olemarkus](https://github.com/olemarkus) [#11257](https://github.com/kubernetes/kops/pull/11257)
* Make it possible to detect field changes when mixedInstancePolicy is removed [@h3poteto](https://github.com/h3poteto) [#11255](https://github.com/kubernetes/kops/pull/11255)
* Update rolling update documentation [@johngmyers](https://github.com/johngmyers) [#11263](https://github.com/kubernetes/kops/pull/11263)
* Pre-pull cilium and kube-proxy in warming mode [@olemarkus](https://github.com/olemarkus) [#11258](https://github.com/kubernetes/kops/pull/11258)
* [cilium] Add support for choosing resources [@dntosas](https://github.com/dntosas) [#11248](https://github.com/kubernetes/kops/pull/11248)
* Add install section to kubelet unit [@olemarkus](https://github.com/olemarkus) [#11264](https://github.com/kubernetes/kops/pull/11264)
* Update terraform and cloudformation lint versions [@rifelpet](https://github.com/rifelpet) [#11266](https://github.com/kubernetes/kops/pull/11266)
* Fix cilium template scoping typo [@javipolo](https://github.com/javipolo) [#11270](https://github.com/kubernetes/kops/pull/11270)
* Add Azure image to alpha/stable channel [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11271](https://github.com/kubernetes/kops/pull/11271)
* Exclude nodes from load balancers upon cordoning [@johngmyers](https://github.com/johngmyers) [#11273](https://github.com/kubernetes/kops/pull/11273)
* Make it possible to enable/configure warm pool [@olemarkus](https://github.com/olemarkus) [#11235](https://github.com/kubernetes/kops/pull/11235)
* If one tries to use eip with a public ip that doesn't exist, fail [@olemarkus](https://github.com/olemarkus) [#11276](https://github.com/kubernetes/kops/pull/11276)
* Spotinst: Update spotinst/ocean-controller to v1.0.74 [@liranp](https://github.com/liranp) [#11286](https://github.com/kubernetes/kops/pull/11286)
* Add NTH Queue Processor Mode [@haugenj](https://github.com/haugenj) [#10995](https://github.com/kubernetes/kops/pull/10995)
* Apiserver fixes [@olemarkus](https://github.com/olemarkus) [#11293](https://github.com/kubernetes/kops/pull/11293)
* Spotinst: Prevent nil pointer dereference [@liranp](https://github.com/liranp) [#11289](https://github.com/kubernetes/kops/pull/11289)
* fix: create.go doesnt add --name flag to the prompt: kops update cluster [@ebarped](https://github.com/ebarped) [#11296](https://github.com/kubernetes/kops/pull/11296)
* Make warm pool no ASG found error retryable [@olemarkus](https://github.com/olemarkus) [#11285](https://github.com/kubernetes/kops/pull/11285)
* Document the newly required SQS permissions for NTH [@rifelpet](https://github.com/rifelpet) [#11300](https://github.com/kubernetes/kops/pull/11300)
* fix permissions required for NTH Queue Processor [@haugenj](https://github.com/haugenj) [#11303](https://github.com/kubernetes/kops/pull/11303)
* bump NTH to 1.13.0 [@haugenj](https://github.com/haugenj) [#11301](https://github.com/kubernetes/kops/pull/11301)
* Add GCE Router task [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11184](https://github.com/kubernetes/kops/pull/11184)
* Add ability to set a default Issuer in certManager addon [@javipolo](https://github.com/javipolo) [#11281](https://github.com/kubernetes/kops/pull/11281)
* Make nodeup able to complete the warming life cycle hook [@olemarkus](https://github.com/olemarkus) [#11259](https://github.com/kubernetes/kops/pull/11259)
* update deps [@zetaab](https://github.com/zetaab) [#11306](https://github.com/kubernetes/kops/pull/11306)
* Filter servers using cluster name in tags [@zetaab](https://github.com/zetaab) [#11305](https://github.com/kubernetes/kops/pull/11305)
* Add warm pool docs and release notes [@olemarkus](https://github.com/olemarkus) [#11307](https://github.com/kubernetes/kops/pull/11307)
* Use the full operator instead of the generic one [@olemarkus](https://github.com/olemarkus) [#11312](https://github.com/kubernetes/kops/pull/11312)
* Improve warm pool documentation [@johngmyers](https://github.com/johngmyers) [#11313](https://github.com/kubernetes/kops/pull/11313)
* Disallow negative warmpool sizes [@johngmyers](https://github.com/johngmyers) [#11317](https://github.com/kubernetes/kops/pull/11317)
* Promote channel alpha to stable [@hakman](https://github.com/hakman) [#11318](https://github.com/kubernetes/kops/pull/11318)
* [metrics-server] Bump manifest to latest stable [@dntosas](https://github.com/dntosas) [#11319](https://github.com/kubernetes/kops/pull/11319)
* Allow disabling warm pool by setting WarmPool.MaxSize to 0 [@johngmyers](https://github.com/johngmyers) [#11316](https://github.com/kubernetes/kops/pull/11316)
* Fix typo [@johngmyers](https://github.com/johngmyers) [#11321](https://github.com/kubernetes/kops/pull/11321)
* [csi/aws] Bump templates + add support for warm pools [@dntosas](https://github.com/dntosas) [#11304](https://github.com/kubernetes/kops/pull/11304)
* Add a lifecycle test for GCE [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11291](https://github.com/kubernetes/kops/pull/11291)
* Add cluster-level warmPool settings [@johngmyers](https://github.com/johngmyers) [#11322](https://github.com/kubernetes/kops/pull/11322)
* Fix arguments to csi-provisioner after bump to v2.2.0 [@codablock](https://github.com/codablock) [#11326](https://github.com/kubernetes/kops/pull/11326)
* kubetest2: Infer the provider and zones from the kops cluster [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#10847](https://github.com/kubernetes/kops/pull/10847)
* Add support for configuring Cilium enable-host-reachable-services. [@bjhaid](https://github.com/bjhaid) [#11333](https://github.com/kubernetes/kops/pull/11333)
* Fix lifecycle hook naming [@olemarkus](https://github.com/olemarkus) [#11335](https://github.com/kubernetes/kops/pull/11335)
* Recognize Ubuntu 21.04 [@hakman](https://github.com/hakman) [#11327](https://github.com/kubernetes/kops/pull/11327)
* Add `enable-host-reachable-services` to 1.8 and generic cilium. [@bjhaid](https://github.com/bjhaid) [#11337](https://github.com/kubernetes/kops/pull/11337)
* Don't try to delete warm pool when creating the cluster [@olemarkus](https://github.com/olemarkus) [#11331](https://github.com/kubernetes/kops/pull/11331)
* Update Calico to v3.18.2 [@hakman](https://github.com/hakman) [#11339](https://github.com/kubernetes/kops/pull/11339)
* Fix SQS resource flapping [@olemarkus](https://github.com/olemarkus) [#11336](https://github.com/kubernetes/kops/pull/11336)
* Update controller-runtime to v0.9.0-beta.0 [@hakman](https://github.com/hakman) [#11342](https://github.com/kubernetes/kops/pull/11342)
* Set SAN for addon CAs [@olemarkus](https://github.com/olemarkus) [#11328](https://github.com/kubernetes/kops/pull/11328)
* Update kubetest2 dependency and fix install method for upgrade scenario [@rifelpet](https://github.com/rifelpet) [#11338](https://github.com/kubernetes/kops/pull/11338)
* Bump cilium to 1.9.6 [@olemarkus](https://github.com/olemarkus) [#11344](https://github.com/kubernetes/kops/pull/11344)
* Fix upgrade scenario kubetest2 install [@rifelpet](https://github.com/rifelpet) [#11350](https://github.com/kubernetes/kops/pull/11350)
* Fix kubetest2 panic inheriting env vars [@rifelpet](https://github.com/rifelpet) [#11351](https://github.com/kubernetes/kops/pull/11351)
* Mount /run inside etcd-manager pods for systemd mounts [@hakman](https://github.com/hakman) [#11352](https://github.com/kubernetes/kops/pull/11352)
* Update deps [@zetaab](https://github.com/zetaab) [#11357](https://github.com/kubernetes/kops/pull/11357)
* Ignore detached nodes when doing validate cluster [@rajatjindal](https://github.com/rajatjindal) [#11349](https://github.com/kubernetes/kops/pull/11349)
* Move firewall, iam, network and sshkey to awsmodel [@hakman](https://github.com/hakman) [#11358](https://github.com/kubernetes/kops/pull/11358)
* [addons/nth] Add capability to define resources [@dntosas](https://github.com/dntosas) [#11360](https://github.com/kubernetes/kops/pull/11360)
* Split oidc_provider [@olemarkus](https://github.com/olemarkus) [#11359](https://github.com/kubernetes/kops/pull/11359)
* Expose hubble agent when hubble is enabled [@olemarkus](https://github.com/olemarkus) [#11314](https://github.com/kubernetes/kops/pull/11314)
* Configure aws oidc provider [@olemarkus](https://github.com/olemarkus) [#11361](https://github.com/kubernetes/kops/pull/11361)
* Use VFS as service account issuer if configured [@olemarkus](https://github.com/olemarkus) [#11362](https://github.com/kubernetes/kops/pull/11362)
* Allow cert-manager to be provisioned externally [@codablock](https://github.com/codablock) [#11354](https://github.com/kubernetes/kops/pull/11354)
* Mark control-plane node for update when etcd volume size changes [@hakman](https://github.com/hakman) [#11365](https://github.com/kubernetes/kops/pull/11365)
* Mark control-plane node for update when etcd manager config changes [@hakman](https://github.com/hakman) [#11369](https://github.com/kubernetes/kops/pull/11369)
* user-configurable IAM roles for ServiceAccounts [@olemarkus](https://github.com/olemarkus) [#11016](https://github.com/kubernetes/kops/pull/11016)
* add permission to create sa tokens [@zetaab](https://github.com/zetaab) [#11373](https://github.com/kubernetes/kops/pull/11373)
* Add more support for cilium 1.10 [@olemarkus](https://github.com/olemarkus) [#11374](https://github.com/kubernetes/kops/pull/11374)
* Update Calico to v3.19.0 [@hakman](https://github.com/hakman) [#11372](https://github.com/kubernetes/kops/pull/11372)
* Refactor terraform writing [@johngmyers](https://github.com/johngmyers) [#11371](https://github.com/kubernetes/kops/pull/11371)
* Remove unused k8s version parsing [@rifelpet](https://github.com/rifelpet) [#11375](https://github.com/kubernetes/kops/pull/11375)
* Fix upgrade of service-account key [@johngmyers](https://github.com/johngmyers) [#11376](https://github.com/kubernetes/kops/pull/11376)
* Don't try to mount hubble TLS on the agent if we don't use hubble [@olemarkus](https://github.com/olemarkus) [#11378](https://github.com/kubernetes/kops/pull/11378)
* Kubetest2 - Update k8s upgrade test + add kops upgrade test  [@rifelpet](https://github.com/rifelpet) [#11382](https://github.com/kubernetes/kops/pull/11382)
* Kubetest2 - Fix GNU mktemp syntax [@rifelpet](https://github.com/rifelpet) [#11384](https://github.com/kubernetes/kops/pull/11384)
* Kubetest2 - fix wget flag in kops download [@rifelpet](https://github.com/rifelpet) [#11385](https://github.com/kubernetes/kops/pull/11385)
* kubetest2 - remove unnecessary flags from upgrade scripts [@rifelpet](https://github.com/rifelpet) [#11386](https://github.com/kubernetes/kops/pull/11386)
* Don't use PublicJWKS in TestAWSLBController [@johngmyers](https://github.com/johngmyers) [#11391](https://github.com/kubernetes/kops/pull/11391)
* Don't add IRSA env vars if feature flag is not enabled [@olemarkus](https://github.com/olemarkus) [#11392](https://github.com/kubernetes/kops/pull/11392)
* Recognize the ServiceAccountIssuerDiscovery featue gate [@johngmyers](https://github.com/johngmyers) [#11395](https://github.com/kubernetes/kops/pull/11395)
* Quote `grep` patterns in docs/rotate-secrets.md [@keithlayne](https://github.com/keithlayne) [#10656](https://github.com/kubernetes/kops/pull/10656)
* Documentation and release note for IRSA [@johngmyers](https://github.com/johngmyers) [#11398](https://github.com/kubernetes/kops/pull/11398)
* Remove the PublicJWKS feature flag [@johngmyers](https://github.com/johngmyers) [#11396](https://github.com/kubernetes/kops/pull/11396)
* Don't publish OIDC discovery if DiscoveryStore not set [@johngmyers](https://github.com/johngmyers) [#11397](https://github.com/kubernetes/kops/pull/11397)
* Add elasticloadbalancing:ModifyTargetGroupAttributes to aws lb controller [@olemarkus](https://github.com/olemarkus) [#11393](https://github.com/kubernetes/kops/pull/11393)
* Add another update cluster dryrun to upgrade tests [@rifelpet](https://github.com/rifelpet) [#11401](https://github.com/kubernetes/kops/pull/11401)
* Update default volumes types in Cluster Documentation [@allir](https://github.com/allir) [#11405](https://github.com/kubernetes/kops/pull/11405)

## 1.21.0-beta.1 to 1.21.0-beta.2

* Use etcd-manager built from etcdadm repo [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#11098](https://github.com/kubernetes/kops/pull/11098)
* Release 1.21.0-beta.1 [@johngmyers](https://github.com/johngmyers) [#11408](https://github.com/kubernetes/kops/pull/11408)
* [addons/awscsidriver] Bump to GA release [@dntosas](https://github.com/dntosas) [#11418](https://github.com/kubernetes/kops/pull/11418)
* Verify all versions are set correctly [@johngmyers](https://github.com/johngmyers) [#11413](https://github.com/kubernetes/kops/pull/11413)
* Update verify-terraform to use 0.15.3 [@rifelpet](https://github.com/rifelpet) [#11433](https://github.com/kubernetes/kops/pull/11433)
* Create new clusters without forcing a container runtime [@hakman](https://github.com/hakman) [#11428](https://github.com/kubernetes/kops/pull/11428)
* Sort --extra-tags of ebs-csi-driver [@codablock](https://github.com/codablock) [#11444](https://github.com/kubernetes/kops/pull/11444)
* Allow AWS instance types with multiple architectures [@hakman](https://github.com/hakman) [#11463](https://github.com/kubernetes/kops/pull/11463)
* Add support for CAS 1.21.0 [@olemarkus](https://github.com/olemarkus) [#11462](https://github.com/kubernetes/kops/pull/11462)
* 1.21 branch: Announce k8s removals two kOps versions in advance [@johngmyers](https://github.com/johngmyers) [#11490](https://github.com/kubernetes/kops/pull/11490)
* Update cert-manager [@olemarkus](https://github.com/olemarkus) [#11493](https://github.com/kubernetes/kops/pull/11493)
* Set priorityClassName on critical addons [@olemarkus](https://github.com/olemarkus) [#11495](https://github.com/kubernetes/kops/pull/11495)
* fix(coredns/rbac): add permission to list and watch endpointslices [@nettoclaudio](https://github.com/nettoclaudio) [#11459](https://github.com/kubernetes/kops/pull/11459)
* upup: gcetasks: fix diffs in instance template and router [@nicktrav](https://github.com/nicktrav) [#11460](https://github.com/kubernetes/kops/pull/11460)
* upup: gcetasks: force send AutoCreateSubnetworks field when set to false [@nicktrav](https://github.com/nicktrav) [#11457](https://github.com/kubernetes/kops/pull/11457)
* Spotinst: Update spotinst/ocean-controller to v1.0.75 [@liranp](https://github.com/liranp) [#11512](https://github.com/kubernetes/kops/pull/11512)
* bump aws lb controller to 2.2.0 [@olemarkus](https://github.com/olemarkus) [#11502](https://github.com/kubernetes/kops/pull/11502)
* Set default fstype for ebs volumes to ext4 [@olemarkus](https://github.com/olemarkus) [#11525](https://github.com/kubernetes/kops/pull/11525)
* [addons/networking.cilium.io] enable prometheus scraping [@ulfox](https://github.com/ulfox) [#11514](https://github.com/kubernetes/kops/pull/11514)
* Update containerd to v1.4.6 [@hakman](https://github.com/hakman) [#11535](https://github.com/kubernetes/kops/pull/11535)
* Release images bundle instead of separate images [@hakman](https://github.com/hakman) [#11522](https://github.com/kubernetes/kops/pull/11522)
* Bump CoreDNS manifests to latest stable version 1.8.3 [@dntosas](https://github.com/dntosas) [#11500](https://github.com/kubernetes/kops/pull/11500)
* Update CAS manifest [@olemarkus](https://github.com/olemarkus) [#11491](https://github.com/kubernetes/kops/pull/11491)
* Make events etcd cluster optional [@codablock](https://github.com/codablock) [#11330](https://github.com/kubernetes/kops/pull/11330)
* Bump default cilium to 1.9.7 [@olemarkus](https://github.com/olemarkus) [#11554](https://github.com/kubernetes/kops/pull/11554)
* Add snapshot-controller [@olemarkus](https://github.com/olemarkus) [#10730](https://github.com/kubernetes/kops/pull/10730)
* Add snapshot-controller [@olemarkus](https://github.com/olemarkus) [#11561](https://github.com/kubernetes/kops/pull/11561)
* Allow using insecure TLS for metrics-server with Kubernetes 1.19+ [@hakman](https://github.com/hakman) [#11559](https://github.com/kubernetes/kops/pull/11559)
* Cleanup orphaned IAM service account roles in direct render [@johngmyers](https://github.com/johngmyers) [#11497](https://github.com/kubernetes/kops/pull/11497)
* Fix deletion of IAM roles and policies [@johngmyers](https://github.com/johngmyers) [#11558](https://github.com/kubernetes/kops/pull/11558)

## 1.21.0-beta.2 to 1.21.0-beta.3

* Release 1.21.0-beta.2 [@johngmyers](https://github.com/johngmyers) [#11567](https://github.com/kubernetes/kops/pull/11567)
* Allow Spotinst to use comma separated instance types [@hakman](https://github.com/hakman) [#11560](https://github.com/kubernetes/kops/pull/11560)
* Only allow deletion of snapshots owned by the cluster [@olemarkus](https://github.com/olemarkus) [#11571](https://github.com/kubernetes/kops/pull/11571)
* Only update kubeconfig user when we have user info [@justinsb](https://github.com/justinsb) [#11584](https://github.com/kubernetes/kops/pull/11584)
* Update Calico to v3.19.1 [@hakman](https://github.com/hakman) [#11594](https://github.com/kubernetes/kops/pull/11594)
* Use the OnDelete updateStrategy for AWS VPC CNI DaemonSet [@johngmyers](https://github.com/johngmyers) [#11590](https://github.com/kubernetes/kops/pull/11590)
* Add init image field for Amazon VPC CNI [@ryan-dyer](https://github.com/ryan-dyer) [#11602](https://github.com/kubernetes/kops/pull/11602)
* Fix duplicate CopyFile tasks [@johngmyers](https://github.com/johngmyers) [#11619](https://github.com/kubernetes/kops/pull/11619)
* Update Go to v1.16.4 [@hakman](https://github.com/hakman) [#11626](https://github.com/kubernetes/kops/pull/11626)
* Set lifecycle on WarmPool task [@johngmyers](https://github.com/johngmyers) [#11618](https://github.com/kubernetes/kops/pull/11618)
* Consolidate CSI livenessprobe images for multi-arch support [@rifelpet](https://github.com/rifelpet) [#11652](https://github.com/kubernetes/kops/pull/11652)
* Fix jwks object path in S3 for IRSA [@h3poteto](https://github.com/h3poteto) [#11649](https://github.com/kubernetes/kops/pull/11649)
* Set canonical location for downloads to artifacts.k8s.io [@hakman](https://github.com/hakman) [#11486](https://github.com/kubernetes/kops/pull/11486)
* Drop trailing slash from oidc issuer [@olemarkus](https://github.com/olemarkus) [#11682](https://github.com/kubernetes/kops/pull/11682)
* Update Go to v1.16.5 [@hakman](https://github.com/hakman) [#11686](https://github.com/kubernetes/kops/pull/11686)
* Add support for Docker v20.10.7 [@hakman](https://github.com/hakman) [#11674](https://github.com/kubernetes/kops/pull/11674)

## 1.21.0-beta.3 to 1.21.0

* Release 1.21.0-beta.3 [@johngmyers](https://github.com/johngmyers) [#11690](https://github.com/kubernetes/kops/pull/11690)
* Fix set-version leaving backup files with "-e" suffix [@johngmyers](https://github.com/johngmyers) [#11692](https://github.com/kubernetes/kops/pull/11692)
* Fix the CSI EBS DS CRB. [@olemarkus](https://github.com/olemarkus) [#11704](https://github.com/kubernetes/kops/pull/11704)
* Add proxy envs to calico to make possible usage of AWS source [@DOboznyi](https://github.com/DOboznyi) [#11710](https://github.com/kubernetes/kops/pull/11710)
* Generate AWSEBSCSIDriver model only when using AWS [@hakman](https://github.com/hakman) [#11718](https://github.com/kubernetes/kops/pull/11718)
* Use quay images for cilium [@olemarkus](https://github.com/olemarkus) [#11728](https://github.com/kubernetes/kops/pull/11728)
* fix enable default SC when EBS driver is not installed [@olemarkus](https://github.com/olemarkus) [#11773](https://github.com/kubernetes/kops/pull/11773)
* Compare OpenStack security groups deterministically
* Make forwardToKubeDNS work in the NodeLocal DNSCache template [@ederst](https://github.com/ederst) [#11757](https://github.com/kubernetes/kops/pull/11757)
* Bump the cas addon version. [@olemarkus](https://github.com/olemarkus) [#11781](https://github.com/kubernetes/kops/pull/11781)
* Don't try to build etcd-manager secrets for cilium twice [@olemarkus](https://github.com/olemarkus) [#11792](https://github.com/kubernetes/kops/pull/11792)
* Also set haveUserInfo=true in case --user was provided in [@codablock](https://github.com/codablock) [#11812](https://github.com/kubernetes/kops/pull/11812)
* Handle containerExec hooks when using containerd [@hakman](https://github.com/hakman) [#11855](https://github.com/kubernetes/kops/pull/11855)
* bump the version of gophercloud [@cardoe](https://github.com/cardoe) [#11830](https://github.com/kubernetes/kops/pull/11830)
* support large/slow downloads #11886: Set download timeout to 3 minutes [@aojea](https://github.com/aojea),[@hakman](https://github.com/hakman) [#11891](https://github.com/kubernetes/kops/pull/11891)
* Include GCP Project in terraform HCL2 output [@rifelpet](https://github.com/rifelpet) [#11902](https://github.com/kubernetes/kops/pull/11902)
* Avoid spurious changes for ASG InstanceProtection and LT [@hakman](https://github.com/hakman) [#11882](https://github.com/kubernetes/kops/pull/11882)

## 1.21.0 to 1.21.1

* Release 1.21.0 [@justinsb](https://github.com/justinsb) [#11908](https://github.com/kubernetes/kops/pull/11908)
* Add log rotation for etcd-cilium.log [@hakman](https://github.com/hakman) [#11943](https://github.com/kubernetes/kops/pull/11943)
* check if the instance is under an asg [@olivierpilotte](https://github.com/olivierpilotte) [#11958](https://github.com/kubernetes/kops/pull/11958)
* Cilium etcd fixes [@olemarkus](https://github.com/olemarkus) [#11961](https://github.com/kubernetes/kops/pull/11961)
* Use regional STS endpoint [@johngmyers](https://github.com/johngmyers) [#12043](https://github.com/kubernetes/kops/pull/12043)
* Update containerd to v1.4.8 [@hakman](https://github.com/hakman) [#12059](https://github.com/kubernetes/kops/pull/12059)
* Update core-dns to v1.8.4 [@hakman](https://github.com/hakman) [#12062](https://github.com/kubernetes/kops/pull/12062)
* Update Docker to v20.10.8 [@hakman](https://github.com/hakman) [#12096](https://github.com/kubernetes/kops/pull/12096)
* Make metrics-server insecure if insecure is true [@olemarkus](https://github.com/olemarkus) [#12114](https://github.com/kubernetes/kops/pull/12114)
* Update Calico to v3.19.2 [@hakman](https://github.com/hakman) [#12125](https://github.com/kubernetes/kops/pull/12125)
* Fix cases when the VPC doesn't exist yet for vpccidrblocks in 1.21 [@mikesplain](https://github.com/mikesplain) [#12126](https://github.com/kubernetes/kops/pull/12126)
* Fix disabling unattended upgrades  [@olemarkus](https://github.com/olemarkus) [#12123](https://github.com/kubernetes/kops/pull/12123)
* Support Debian 11 Bullseye [@ReillyBrogan](https://github.com/ReillyBrogan) [#12108](https://github.com/kubernetes/kops/pull/12108)
* Bump cilium to 1.9.9 [@olemarkus](https://github.com/olemarkus) [#12146](https://github.com/kubernetes/kops/pull/12146)
* Reconcile if managedFile is public or not [@olemarkus](https://github.com/olemarkus) [#12148](https://github.com/kubernetes/kops/pull/12148)
* leverage proxy env variables [@aojea](https://github.com/aojea) [#12150](https://github.com/kubernetes/kops/pull/12150)
* Update Go to v1.16.7 [@hakman](https://github.com/hakman) [#12153](https://github.com/kubernetes/kops/pull/12153)
* Debian 11: Release AMIs use same AWS Owner ID as Buster [@ReillyBrogan](https://github.com/ReillyBrogan) [#12161](https://github.com/kubernetes/kops/pull/12161)
* Log s3 acl in additional cases [@olemarkus](https://github.com/olemarkus) [#12167](https://github.com/kubernetes/kops/pull/12167)
* Hardcode Flatcar containerd exec command [@hakman](https://github.com/hakman) [#12177](https://github.com/kubernetes/kops/pull/12177)
* Backport moving updatePolicy to nodeup config [@ReillyBrogan](https://github.com/ReillyBrogan) [#12175](https://github.com/kubernetes/kops/pull/12175)
* Add option in Cluster Autoscaler AddOn for AWS EC2 Static instance list [@amitpd](https://github.com/amitpd) [#12187](https://github.com/kubernetes/kops/pull/12187)

## 1.21.1 to 1.21.2

* Release 1.21.1 [@justinsb](https://github.com/justinsb) [#12191](https://github.com/kubernetes/kops/pull/12191)
* Update Calico to v3.19.3 for kOps 1.21 [@hakman](https://github.com/hakman) [#12362](https://github.com/kubernetes/kops/pull/12362)
* Truncate cluster name in NTH EventBridgeRules [@rifelpet](https://github.com/rifelpet) [#12439](https://github.com/kubernetes/kops/pull/12439)
* Don't ignore channel value in toolbox template [@hakman](https://github.com/hakman) [#12464](https://github.com/kubernetes/kops/pull/12464)
* Update containerd and Docker for kOps 1.21 [@hakman](https://github.com/hakman) [#12508](https://github.com/kubernetes/kops/pull/12508)

## 1.21.2 to 1.21.4

* Increase upup http response header timeout [@AlexLast](https://github.com/AlexLast) [#12694](https://github.com/kubernetes/kops/pull/12694)
* set calico-node readiness/liveness timeout to 10s [@estahn](https://github.com/estahn) [#12713](https://github.com/kubernetes/kops/pull/12713)
* Fix out of bounds error when instance detach fails [@johngmyers](https://github.com/johngmyers) [#12698](https://github.com/kubernetes/kops/pull/12698)
* Fix that states AWS IAM Instance Profile blocks IAM Role [@angeloskaltsikis](https://github.com/angeloskaltsikis) [#12677](https://github.com/kubernetes/kops/pull/12677)
* Shorten filenames in the asset store [@johngmyers](https://github.com/johngmyers) [#12765](https://github.com/kubernetes/kops/pull/12765)
* Add hashes for latest containerd and Docker versions [@hakman](https://github.com/hakman) [#12767](https://github.com/kubernetes/kops/pull/12767)
* Update containerd to v1.4.12 [@hakman](https://github.com/hakman) [#12772](https://github.com/kubernetes/kops/pull/12772)
* Fix volume ratio comparisons [@olemarkus](https://github.com/olemarkus) [#12791](https://github.com/kubernetes/kops/pull/12791)
* Bump etcd manager to 20211117 [@justinsb](https://github.com/justinsb) [#12763](https://github.com/kubernetes/kops/pull/12763)
* Upgrade Go to 1.16.10 [@hakman](https://github.com/hakman) [#12798](https://github.com/kubernetes/kops/pull/12798)
