//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by deepcopy-gen. DO NOT EDIT.

package v1alpha3

import (
	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	kops "k8s.io/kops/pkg/apis/kops"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSAuthenticationIdentityMappingSpec) DeepCopyInto(out *AWSAuthenticationIdentityMappingSpec) {
	*out = *in
	if in.Groups != nil {
		in, out := &in.Groups, &out.Groups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSAuthenticationIdentityMappingSpec.
func (in *AWSAuthenticationIdentityMappingSpec) DeepCopy() *AWSAuthenticationIdentityMappingSpec {
	if in == nil {
		return nil
	}
	out := new(AWSAuthenticationIdentityMappingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSAuthenticationSpec) DeepCopyInto(out *AWSAuthenticationSpec) {
	*out = *in
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPULimit != nil {
		in, out := &in.CPULimit, &out.CPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.IdentityMappings != nil {
		in, out := &in.IdentityMappings, &out.IdentityMappings
		*out = make([]AWSAuthenticationIdentityMappingSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSAuthenticationSpec.
func (in *AWSAuthenticationSpec) DeepCopy() *AWSAuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(AWSAuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSEBSCSIDriver) DeepCopyInto(out *AWSEBSCSIDriver) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	if in.VolumeAttachLimit != nil {
		in, out := &in.VolumeAttachLimit, &out.VolumeAttachLimit
		*out = new(int)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSEBSCSIDriver.
func (in *AWSEBSCSIDriver) DeepCopy() *AWSEBSCSIDriver {
	if in == nil {
		return nil
	}
	out := new(AWSEBSCSIDriver)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSLoadBalancerControllerConfig) DeepCopyInto(out *AWSLoadBalancerControllerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSLoadBalancerControllerConfig.
func (in *AWSLoadBalancerControllerConfig) DeepCopy() *AWSLoadBalancerControllerConfig {
	if in == nil {
		return nil
	}
	out := new(AWSLoadBalancerControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSPermission) DeepCopyInto(out *AWSPermission) {
	*out = *in
	if in.PolicyARNs != nil {
		in, out := &in.PolicyARNs, &out.PolicyARNs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSPermission.
func (in *AWSPermission) DeepCopy() *AWSPermission {
	if in == nil {
		return nil
	}
	out := new(AWSPermission)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AccessLogSpec) DeepCopyInto(out *AccessLogSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AccessLogSpec.
func (in *AccessLogSpec) DeepCopy() *AccessLogSpec {
	if in == nil {
		return nil
	}
	out := new(AccessLogSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AccessSpec) DeepCopyInto(out *AccessSpec) {
	*out = *in
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = new(DNSAccessSpec)
		**out = **in
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		*out = new(LoadBalancerAccessSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AccessSpec.
func (in *AccessSpec) DeepCopy() *AccessSpec {
	if in == nil {
		return nil
	}
	out := new(AccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AddonSpec) DeepCopyInto(out *AddonSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AddonSpec.
func (in *AddonSpec) DeepCopy() *AddonSpec {
	if in == nil {
		return nil
	}
	out := new(AddonSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlwaysAllowAuthorizationSpec) DeepCopyInto(out *AlwaysAllowAuthorizationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlwaysAllowAuthorizationSpec.
func (in *AlwaysAllowAuthorizationSpec) DeepCopy() *AlwaysAllowAuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(AlwaysAllowAuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AmazonVPCNetworkingSpec) DeepCopyInto(out *AmazonVPCNetworkingSpec) {
	*out = *in
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]EnvVar, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AmazonVPCNetworkingSpec.
func (in *AmazonVPCNetworkingSpec) DeepCopy() *AmazonVPCNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(AmazonVPCNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Assets) DeepCopyInto(out *Assets) {
	*out = *in
	if in.ContainerRegistry != nil {
		in, out := &in.ContainerRegistry, &out.ContainerRegistry
		*out = new(string)
		**out = **in
	}
	if in.FileRepository != nil {
		in, out := &in.FileRepository, &out.FileRepository
		*out = new(string)
		**out = **in
	}
	if in.ContainerProxy != nil {
		in, out := &in.ContainerProxy, &out.ContainerProxy
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Assets.
func (in *Assets) DeepCopy() *Assets {
	if in == nil {
		return nil
	}
	out := new(Assets)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthenticationSpec) DeepCopyInto(out *AuthenticationSpec) {
	*out = *in
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(KopeioAuthenticationSpec)
		**out = **in
	}
	if in.AWS != nil {
		in, out := &in.AWS, &out.AWS
		*out = new(AWSAuthenticationSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthenticationSpec.
func (in *AuthenticationSpec) DeepCopy() *AuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(AuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AuthorizationSpec) DeepCopyInto(out *AuthorizationSpec) {
	*out = *in
	if in.AlwaysAllow != nil {
		in, out := &in.AlwaysAllow, &out.AlwaysAllow
		*out = new(AlwaysAllowAuthorizationSpec)
		**out = **in
	}
	if in.RBAC != nil {
		in, out := &in.RBAC, &out.RBAC
		*out = new(RBACAuthorizationSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AuthorizationSpec.
func (in *AuthorizationSpec) DeepCopy() *AuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(AuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureConfiguration) DeepCopyInto(out *AzureConfiguration) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureConfiguration.
func (in *AzureConfiguration) DeepCopy() *AzureConfiguration {
	if in == nil {
		return nil
	}
	out := new(AzureConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BastionLoadBalancerSpec) DeepCopyInto(out *BastionLoadBalancerSpec) {
	*out = *in
	if in.AdditionalSecurityGroups != nil {
		in, out := &in.AdditionalSecurityGroups, &out.AdditionalSecurityGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BastionLoadBalancerSpec.
func (in *BastionLoadBalancerSpec) DeepCopy() *BastionLoadBalancerSpec {
	if in == nil {
		return nil
	}
	out := new(BastionLoadBalancerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BastionSpec) DeepCopyInto(out *BastionSpec) {
	*out = *in
	if in.IdleTimeoutSeconds != nil {
		in, out := &in.IdleTimeoutSeconds, &out.IdleTimeoutSeconds
		*out = new(int64)
		**out = **in
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		*out = new(BastionLoadBalancerSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BastionSpec.
func (in *BastionSpec) DeepCopy() *BastionSpec {
	if in == nil {
		return nil
	}
	out := new(BastionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNINetworkingSpec) DeepCopyInto(out *CNINetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNINetworkingSpec.
func (in *CNINetworkingSpec) DeepCopy() *CNINetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CNINetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNetworkingSpec) DeepCopyInto(out *CalicoNetworkingSpec) {
	*out = *in
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CrossSubnet != nil {
		in, out := &in.CrossSubnet, &out.CrossSubnet
		*out = new(bool)
		**out = **in
	}
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNetworkingSpec.
func (in *CalicoNetworkingSpec) DeepCopy() *CalicoNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CanalNetworkingSpec) DeepCopyInto(out *CanalNetworkingSpec) {
	*out = *in
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.FlanneldIptablesForwardRules != nil {
		in, out := &in.FlanneldIptablesForwardRules, &out.FlanneldIptablesForwardRules
		*out = new(bool)
		**out = **in
	}
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CanalNetworkingSpec.
func (in *CanalNetworkingSpec) DeepCopy() *CanalNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CanalNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CertManagerConfig) DeepCopyInto(out *CertManagerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Managed != nil {
		in, out := &in.Managed, &out.Managed
		*out = new(bool)
		**out = **in
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.DefaultIssuer != nil {
		in, out := &in.DefaultIssuer, &out.DefaultIssuer
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CertManagerConfig.
func (in *CertManagerConfig) DeepCopy() *CertManagerConfig {
	if in == nil {
		return nil
	}
	out := new(CertManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CiliumNetworkingSpec) DeepCopyInto(out *CiliumNetworkingSpec) {
	*out = *in
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.EnableL7Proxy != nil {
		in, out := &in.EnableL7Proxy, &out.EnableL7Proxy
		*out = new(bool)
		**out = **in
	}
	if in.EnableBPFMasquerade != nil {
		in, out := &in.EnableBPFMasquerade, &out.EnableBPFMasquerade
		*out = new(bool)
		**out = **in
	}
	if in.EnableEndpointHealthChecking != nil {
		in, out := &in.EnableEndpointHealthChecking, &out.EnableEndpointHealthChecking
		*out = new(bool)
		**out = **in
	}
	if in.Masquerade != nil {
		in, out := &in.Masquerade, &out.Masquerade
		*out = new(bool)
		**out = **in
	}
	if in.AgentPodAnnotations != nil {
		in, out := &in.AgentPodAnnotations, &out.AgentPodAnnotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.InstallIptablesRules != nil {
		in, out := &in.InstallIptablesRules, &out.InstallIptablesRules
		*out = new(bool)
		**out = **in
	}
	if in.EnableRemoteNodeIdentity != nil {
		in, out := &in.EnableRemoteNodeIdentity, &out.EnableRemoteNodeIdentity
		*out = new(bool)
		**out = **in
	}
	if in.Hubble != nil {
		in, out := &in.Hubble, &out.Hubble
		*out = new(HubbleSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DisableCNPStatusUpdates != nil {
		in, out := &in.DisableCNPStatusUpdates, &out.DisableCNPStatusUpdates
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CiliumNetworkingSpec.
func (in *CiliumNetworkingSpec) DeepCopy() *CiliumNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(CiliumNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudConfiguration) DeepCopyInto(out *CloudConfiguration) {
	*out = *in
	if in.ManageStorageClasses != nil {
		in, out := &in.ManageStorageClasses, &out.ManageStorageClasses
		*out = new(bool)
		**out = **in
	}
	if in.Multizone != nil {
		in, out := &in.Multizone, &out.Multizone
		*out = new(bool)
		**out = **in
	}
	if in.NodeTags != nil {
		in, out := &in.NodeTags, &out.NodeTags
		*out = new(string)
		**out = **in
	}
	if in.NodeInstancePrefix != nil {
		in, out := &in.NodeInstancePrefix, &out.NodeInstancePrefix
		*out = new(string)
		**out = **in
	}
	if in.NodeIPFamilies != nil {
		in, out := &in.NodeIPFamilies, &out.NodeIPFamilies
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DisableSecurityGroupIngress != nil {
		in, out := &in.DisableSecurityGroupIngress, &out.DisableSecurityGroupIngress
		*out = new(bool)
		**out = **in
	}
	if in.ElbSecurityGroup != nil {
		in, out := &in.ElbSecurityGroup, &out.ElbSecurityGroup
		*out = new(string)
		**out = **in
	}
	if in.SpotinstProduct != nil {
		in, out := &in.SpotinstProduct, &out.SpotinstProduct
		*out = new(string)
		**out = **in
	}
	if in.SpotinstOrientation != nil {
		in, out := &in.SpotinstOrientation, &out.SpotinstOrientation
		*out = new(string)
		**out = **in
	}
	if in.Openstack != nil {
		in, out := &in.Openstack, &out.Openstack
		*out = new(OpenstackConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.Azure != nil {
		in, out := &in.Azure, &out.Azure
		*out = new(AzureConfiguration)
		**out = **in
	}
	if in.AWSEBSCSIDriver != nil {
		in, out := &in.AWSEBSCSIDriver, &out.AWSEBSCSIDriver
		*out = new(AWSEBSCSIDriver)
		(*in).DeepCopyInto(*out)
	}
	if in.GCPPDCSIDriver != nil {
		in, out := &in.GCPPDCSIDriver, &out.GCPPDCSIDriver
		*out = new(GCPPDCSIDriver)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudConfiguration.
func (in *CloudConfiguration) DeepCopy() *CloudConfiguration {
	if in == nil {
		return nil
	}
	out := new(CloudConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudControllerManagerConfig) DeepCopyInto(out *CloudControllerManagerConfig) {
	*out = *in
	if in.AllocateNodeCIDRs != nil {
		in, out := &in.AllocateNodeCIDRs, &out.AllocateNodeCIDRs
		*out = new(bool)
		**out = **in
	}
	if in.ConfigureCloudRoutes != nil {
		in, out := &in.ConfigureCloudRoutes, &out.ConfigureCloudRoutes
		*out = new(bool)
		**out = **in
	}
	if in.CIDRAllocatorType != nil {
		in, out := &in.CIDRAllocatorType, &out.CIDRAllocatorType
		*out = new(string)
		**out = **in
	}
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.UseServiceAccountCredentials != nil {
		in, out := &in.UseServiceAccountCredentials, &out.UseServiceAccountCredentials
		*out = new(bool)
		**out = **in
	}
	if in.EnableLeaderMigration != nil {
		in, out := &in.EnableLeaderMigration, &out.EnableLeaderMigration
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudControllerManagerConfig.
func (in *CloudControllerManagerConfig) DeepCopy() *CloudControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(CloudControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Cluster) DeepCopyInto(out *Cluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Cluster.
func (in *Cluster) DeepCopy() *Cluster {
	if in == nil {
		return nil
	}
	out := new(Cluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Cluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterAutoscalerConfig) DeepCopyInto(out *ClusterAutoscalerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Expander != nil {
		in, out := &in.Expander, &out.Expander
		*out = new(string)
		**out = **in
	}
	if in.BalanceSimilarNodeGroups != nil {
		in, out := &in.BalanceSimilarNodeGroups, &out.BalanceSimilarNodeGroups
		*out = new(bool)
		**out = **in
	}
	if in.AWSUseStaticInstanceList != nil {
		in, out := &in.AWSUseStaticInstanceList, &out.AWSUseStaticInstanceList
		*out = new(bool)
		**out = **in
	}
	if in.ScaleDownUtilizationThreshold != nil {
		in, out := &in.ScaleDownUtilizationThreshold, &out.ScaleDownUtilizationThreshold
		*out = new(string)
		**out = **in
	}
	if in.SkipNodesWithSystemPods != nil {
		in, out := &in.SkipNodesWithSystemPods, &out.SkipNodesWithSystemPods
		*out = new(bool)
		**out = **in
	}
	if in.SkipNodesWithLocalStorage != nil {
		in, out := &in.SkipNodesWithLocalStorage, &out.SkipNodesWithLocalStorage
		*out = new(bool)
		**out = **in
	}
	if in.NewPodScaleUpDelay != nil {
		in, out := &in.NewPodScaleUpDelay, &out.NewPodScaleUpDelay
		*out = new(string)
		**out = **in
	}
	if in.ScaleDownDelayAfterAdd != nil {
		in, out := &in.ScaleDownDelayAfterAdd, &out.ScaleDownDelayAfterAdd
		*out = new(string)
		**out = **in
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterAutoscalerConfig.
func (in *ClusterAutoscalerConfig) DeepCopy() *ClusterAutoscalerConfig {
	if in == nil {
		return nil
	}
	out := new(ClusterAutoscalerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterList) DeepCopyInto(out *ClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterList.
func (in *ClusterList) DeepCopy() *ClusterList {
	if in == nil {
		return nil
	}
	out := new(ClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSpec) DeepCopyInto(out *ClusterSpec) {
	*out = *in
	if in.Addons != nil {
		in, out := &in.Addons, &out.Addons
		*out = make([]AddonSpec, len(*in))
		copy(*out, *in)
	}
	if in.GossipConfig != nil {
		in, out := &in.GossipConfig, &out.GossipConfig
		*out = new(GossipConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]ClusterSubnetSpec, len(*in))
		copy(*out, *in)
	}
	if in.AdditionalNetworkCIDRs != nil {
		in, out := &in.AdditionalNetworkCIDRs, &out.AdditionalNetworkCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Topology != nil {
		in, out := &in.Topology, &out.Topology
		*out = new(TopologySpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DNSControllerGossipConfig != nil {
		in, out := &in.DNSControllerGossipConfig, &out.DNSControllerGossipConfig
		*out = new(DNSControllerGossipConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.AdditionalSANs != nil {
		in, out := &in.AdditionalSANs, &out.AdditionalSANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SSHAccess != nil {
		in, out := &in.SSHAccess, &out.SSHAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NodePortAccess != nil {
		in, out := &in.NodePortAccess, &out.NodePortAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EgressProxy != nil {
		in, out := &in.EgressProxy, &out.EgressProxy
		*out = new(EgressProxySpec)
		**out = **in
	}
	if in.SSHKeyName != nil {
		in, out := &in.SSHKeyName, &out.SSHKeyName
		*out = new(string)
		**out = **in
	}
	if in.KubernetesAPIAccess != nil {
		in, out := &in.KubernetesAPIAccess, &out.KubernetesAPIAccess
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IsolateMasters != nil {
		in, out := &in.IsolateMasters, &out.IsolateMasters
		*out = new(bool)
		**out = **in
	}
	if in.UpdatePolicy != nil {
		in, out := &in.UpdatePolicy, &out.UpdatePolicy
		*out = new(string)
		**out = **in
	}
	if in.ExternalPolicies != nil {
		in, out := &in.ExternalPolicies, &out.ExternalPolicies
		*out = new(map[string][]string)
		if **in != nil {
			in, out := *in, *out
			*out = make(map[string][]string, len(*in))
			for key, val := range *in {
				var outVal []string
				if val == nil {
					(*out)[key] = nil
				} else {
					in, out := &val, &outVal
					*out = make([]string, len(*in))
					copy(*out, *in)
				}
				(*out)[key] = outVal
			}
		}
	}
	if in.AdditionalPolicies != nil {
		in, out := &in.AdditionalPolicies, &out.AdditionalPolicies
		*out = new(map[string]string)
		if **in != nil {
			in, out := *in, *out
			*out = make(map[string]string, len(*in))
			for key, val := range *in {
				(*out)[key] = val
			}
		}
	}
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EtcdClusters != nil {
		in, out := &in.EtcdClusters, &out.EtcdClusters
		*out = make([]EtcdClusterSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Containerd != nil {
		in, out := &in.Containerd, &out.Containerd
		*out = new(ContainerdConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Docker != nil {
		in, out := &in.Docker, &out.Docker
		*out = new(DockerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeDNS != nil {
		in, out := &in.KubeDNS, &out.KubeDNS
		*out = new(KubeDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeAPIServer != nil {
		in, out := &in.KubeAPIServer, &out.KubeAPIServer
		*out = new(KubeAPIServerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeControllerManager != nil {
		in, out := &in.KubeControllerManager, &out.KubeControllerManager
		*out = new(KubeControllerManagerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ExternalCloudControllerManager != nil {
		in, out := &in.ExternalCloudControllerManager, &out.ExternalCloudControllerManager
		*out = new(CloudControllerManagerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeScheduler != nil {
		in, out := &in.KubeScheduler, &out.KubeScheduler
		*out = new(KubeSchedulerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeProxy != nil {
		in, out := &in.KubeProxy, &out.KubeProxy
		*out = new(KubeProxyConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(KubeletConfigSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.MasterKubelet != nil {
		in, out := &in.MasterKubelet, &out.MasterKubelet
		*out = new(KubeletConfigSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.CloudConfig != nil {
		in, out := &in.CloudConfig, &out.CloudConfig
		*out = new(CloudConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.ExternalDNS != nil {
		in, out := &in.ExternalDNS, &out.ExternalDNS
		*out = new(ExternalDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.NTP != nil {
		in, out := &in.NTP, &out.NTP
		*out = new(NTPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeTerminationHandler != nil {
		in, out := &in.NodeTerminationHandler, &out.NodeTerminationHandler
		*out = new(NodeTerminationHandlerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeProblemDetector != nil {
		in, out := &in.NodeProblemDetector, &out.NodeProblemDetector
		*out = new(NodeProblemDetectorConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MetricsServer != nil {
		in, out := &in.MetricsServer, &out.MetricsServer
		*out = new(MetricsServerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.CertManager != nil {
		in, out := &in.CertManager, &out.CertManager
		*out = new(CertManagerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.AWSLoadBalancerController != nil {
		in, out := &in.AWSLoadBalancerController, &out.AWSLoadBalancerController
		*out = new(AWSLoadBalancerControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Networking != nil {
		in, out := &in.Networking, &out.Networking
		*out = new(NetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.API != nil {
		in, out := &in.API, &out.API
		*out = new(AccessSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Authentication != nil {
		in, out := &in.Authentication, &out.Authentication
		*out = new(AuthenticationSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(AuthorizationSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeAuthorization != nil {
		in, out := &in.NodeAuthorization, &out.NodeAuthorization
		*out = new(kops.NodeAuthorizationSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.CloudLabels != nil {
		in, out := &in.CloudLabels, &out.CloudLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Assets != nil {
		in, out := &in.Assets, &out.Assets
		*out = new(Assets)
		(*in).DeepCopyInto(*out)
	}
	if in.IAM != nil {
		in, out := &in.IAM, &out.IAM
		*out = new(IAMSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.EncryptionConfig != nil {
		in, out := &in.EncryptionConfig, &out.EncryptionConfig
		*out = new(bool)
		**out = **in
	}
	if in.TagSubnets != nil {
		in, out := &in.TagSubnets, &out.TagSubnets
		*out = new(bool)
		**out = **in
	}
	if in.Target != nil {
		in, out := &in.Target, &out.Target
		*out = new(TargetSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.UseHostCertificates != nil {
		in, out := &in.UseHostCertificates, &out.UseHostCertificates
		*out = new(bool)
		**out = **in
	}
	if in.SysctlParameters != nil {
		in, out := &in.SysctlParameters, &out.SysctlParameters
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(RollingUpdate)
		(*in).DeepCopyInto(*out)
	}
	if in.ClusterAutoscaler != nil {
		in, out := &in.ClusterAutoscaler, &out.ClusterAutoscaler
		*out = new(ClusterAutoscalerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.WarmPool != nil {
		in, out := &in.WarmPool, &out.WarmPool
		*out = new(WarmPoolSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccountIssuerDiscovery != nil {
		in, out := &in.ServiceAccountIssuerDiscovery, &out.ServiceAccountIssuerDiscovery
		*out = new(ServiceAccountIssuerDiscoveryConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.SnapshotController != nil {
		in, out := &in.SnapshotController, &out.SnapshotController
		*out = new(SnapshotControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.PodIdentityWebhook != nil {
		in, out := &in.PodIdentityWebhook, &out.PodIdentityWebhook
		*out = new(PodIdentityWebhookConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSpec.
func (in *ClusterSpec) DeepCopy() *ClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSubnetSpec) DeepCopyInto(out *ClusterSubnetSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSubnetSpec.
func (in *ClusterSubnetSpec) DeepCopy() *ClusterSubnetSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSubnetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ContainerdConfig) DeepCopyInto(out *ContainerdConfig) {
	*out = *in
	if in.Address != nil {
		in, out := &in.Address, &out.Address
		*out = new(string)
		**out = **in
	}
	if in.ConfigOverride != nil {
		in, out := &in.ConfigOverride, &out.ConfigOverride
		*out = new(string)
		**out = **in
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		*out = new(string)
		**out = **in
	}
	if in.Packages != nil {
		in, out := &in.Packages, &out.Packages
		*out = new(PackagesConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.RegistryMirrors != nil {
		in, out := &in.RegistryMirrors, &out.RegistryMirrors
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.Root != nil {
		in, out := &in.Root, &out.Root
		*out = new(string)
		**out = **in
	}
	if in.State != nil {
		in, out := &in.State, &out.State
		*out = new(string)
		**out = **in
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	if in.NvidiaGPU != nil {
		in, out := &in.NvidiaGPU, &out.NvidiaGPU
		*out = new(NvidiaGPUConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ContainerdConfig.
func (in *ContainerdConfig) DeepCopy() *ContainerdConfig {
	if in == nil {
		return nil
	}
	out := new(ContainerdConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSAccessSpec) DeepCopyInto(out *DNSAccessSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSAccessSpec.
func (in *DNSAccessSpec) DeepCopy() *DNSAccessSpec {
	if in == nil {
		return nil
	}
	out := new(DNSAccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSControllerGossipConfig) DeepCopyInto(out *DNSControllerGossipConfig) {
	*out = *in
	if in.Protocol != nil {
		in, out := &in.Protocol, &out.Protocol
		*out = new(string)
		**out = **in
	}
	if in.Listen != nil {
		in, out := &in.Listen, &out.Listen
		*out = new(string)
		**out = **in
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(string)
		**out = **in
	}
	if in.Secondary != nil {
		in, out := &in.Secondary, &out.Secondary
		*out = new(DNSControllerGossipConfigSecondary)
		(*in).DeepCopyInto(*out)
	}
	if in.Seed != nil {
		in, out := &in.Seed, &out.Seed
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSControllerGossipConfig.
func (in *DNSControllerGossipConfig) DeepCopy() *DNSControllerGossipConfig {
	if in == nil {
		return nil
	}
	out := new(DNSControllerGossipConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSControllerGossipConfigSecondary) DeepCopyInto(out *DNSControllerGossipConfigSecondary) {
	*out = *in
	if in.Protocol != nil {
		in, out := &in.Protocol, &out.Protocol
		*out = new(string)
		**out = **in
	}
	if in.Listen != nil {
		in, out := &in.Listen, &out.Listen
		*out = new(string)
		**out = **in
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(string)
		**out = **in
	}
	if in.Seed != nil {
		in, out := &in.Seed, &out.Seed
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSControllerGossipConfigSecondary.
func (in *DNSControllerGossipConfigSecondary) DeepCopy() *DNSControllerGossipConfigSecondary {
	if in == nil {
		return nil
	}
	out := new(DNSControllerGossipConfigSecondary)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSSpec) DeepCopyInto(out *DNSSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSSpec.
func (in *DNSSpec) DeepCopy() *DNSSpec {
	if in == nil {
		return nil
	}
	out := new(DNSSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerConfig) DeepCopyInto(out *DockerConfig) {
	*out = *in
	if in.AuthorizationPlugins != nil {
		in, out := &in.AuthorizationPlugins, &out.AuthorizationPlugins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Bridge != nil {
		in, out := &in.Bridge, &out.Bridge
		*out = new(string)
		**out = **in
	}
	if in.BridgeIP != nil {
		in, out := &in.BridgeIP, &out.BridgeIP
		*out = new(string)
		**out = **in
	}
	if in.DataRoot != nil {
		in, out := &in.DataRoot, &out.DataRoot
		*out = new(string)
		**out = **in
	}
	if in.DefaultUlimit != nil {
		in, out := &in.DefaultUlimit, &out.DefaultUlimit
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DefaultRuntime != nil {
		in, out := &in.DefaultRuntime, &out.DefaultRuntime
		*out = new(string)
		**out = **in
	}
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExecOpt != nil {
		in, out := &in.ExecOpt, &out.ExecOpt
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExecRoot != nil {
		in, out := &in.ExecRoot, &out.ExecRoot
		*out = new(string)
		**out = **in
	}
	if in.Experimental != nil {
		in, out := &in.Experimental, &out.Experimental
		*out = new(bool)
		**out = **in
	}
	if in.Hosts != nil {
		in, out := &in.Hosts, &out.Hosts
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IPMasq != nil {
		in, out := &in.IPMasq, &out.IPMasq
		*out = new(bool)
		**out = **in
	}
	if in.IPTables != nil {
		in, out := &in.IPTables, &out.IPTables
		*out = new(bool)
		**out = **in
	}
	if in.InsecureRegistry != nil {
		in, out := &in.InsecureRegistry, &out.InsecureRegistry
		*out = new(string)
		**out = **in
	}
	if in.InsecureRegistries != nil {
		in, out := &in.InsecureRegistries, &out.InsecureRegistries
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.LiveRestore != nil {
		in, out := &in.LiveRestore, &out.LiveRestore
		*out = new(bool)
		**out = **in
	}
	if in.LogDriver != nil {
		in, out := &in.LogDriver, &out.LogDriver
		*out = new(string)
		**out = **in
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		*out = new(string)
		**out = **in
	}
	if in.LogOpt != nil {
		in, out := &in.LogOpt, &out.LogOpt
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MaxConcurrentDownloads != nil {
		in, out := &in.MaxConcurrentDownloads, &out.MaxConcurrentDownloads
		*out = new(int32)
		**out = **in
	}
	if in.MaxConcurrentUploads != nil {
		in, out := &in.MaxConcurrentUploads, &out.MaxConcurrentUploads
		*out = new(int32)
		**out = **in
	}
	if in.MaxDownloadAttempts != nil {
		in, out := &in.MaxDownloadAttempts, &out.MaxDownloadAttempts
		*out = new(int32)
		**out = **in
	}
	if in.MetricsAddress != nil {
		in, out := &in.MetricsAddress, &out.MetricsAddress
		*out = new(string)
		**out = **in
	}
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		*out = new(int32)
		**out = **in
	}
	if in.Packages != nil {
		in, out := &in.Packages, &out.Packages
		*out = new(PackagesConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.RegistryMirrors != nil {
		in, out := &in.RegistryMirrors, &out.RegistryMirrors
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Runtimes != nil {
		in, out := &in.Runtimes, &out.Runtimes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SelinuxEnabled != nil {
		in, out := &in.SelinuxEnabled, &out.SelinuxEnabled
		*out = new(bool)
		**out = **in
	}
	if in.Storage != nil {
		in, out := &in.Storage, &out.Storage
		*out = new(string)
		**out = **in
	}
	if in.StorageOpts != nil {
		in, out := &in.StorageOpts, &out.StorageOpts
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerConfig.
func (in *DockerConfig) DeepCopy() *DockerConfig {
	if in == nil {
		return nil
	}
	out := new(DockerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EgressProxySpec) DeepCopyInto(out *EgressProxySpec) {
	*out = *in
	out.HTTPProxy = in.HTTPProxy
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EgressProxySpec.
func (in *EgressProxySpec) DeepCopy() *EgressProxySpec {
	if in == nil {
		return nil
	}
	out := new(EgressProxySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EnvVar) DeepCopyInto(out *EnvVar) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EnvVar.
func (in *EnvVar) DeepCopy() *EnvVar {
	if in == nil {
		return nil
	}
	out := new(EnvVar)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdBackupSpec) DeepCopyInto(out *EtcdBackupSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdBackupSpec.
func (in *EtcdBackupSpec) DeepCopy() *EtcdBackupSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdBackupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdClusterSpec) DeepCopyInto(out *EtcdClusterSpec) {
	*out = *in
	if in.Members != nil {
		in, out := &in.Members, &out.Members
		*out = make([]EtcdMemberSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LeaderElectionTimeout != nil {
		in, out := &in.LeaderElectionTimeout, &out.LeaderElectionTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HeartbeatInterval != nil {
		in, out := &in.HeartbeatInterval, &out.HeartbeatInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.Backups != nil {
		in, out := &in.Backups, &out.Backups
		*out = new(EtcdBackupSpec)
		**out = **in
	}
	if in.Manager != nil {
		in, out := &in.Manager, &out.Manager
		*out = new(EtcdManagerSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdClusterSpec.
func (in *EtcdClusterSpec) DeepCopy() *EtcdClusterSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdManagerSpec) DeepCopyInto(out *EtcdManagerSpec) {
	*out = *in
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]EnvVar, len(*in))
		copy(*out, *in)
	}
	if in.DiscoveryPollInterval != nil {
		in, out := &in.DiscoveryPollInterval, &out.DiscoveryPollInterval
		*out = new(string)
		**out = **in
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdManagerSpec.
func (in *EtcdManagerSpec) DeepCopy() *EtcdManagerSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdManagerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdMemberSpec) DeepCopyInto(out *EtcdMemberSpec) {
	*out = *in
	if in.InstanceGroup != nil {
		in, out := &in.InstanceGroup, &out.InstanceGroup
		*out = new(string)
		**out = **in
	}
	if in.VolumeType != nil {
		in, out := &in.VolumeType, &out.VolumeType
		*out = new(string)
		**out = **in
	}
	if in.VolumeIOPS != nil {
		in, out := &in.VolumeIOPS, &out.VolumeIOPS
		*out = new(int32)
		**out = **in
	}
	if in.VolumeThroughput != nil {
		in, out := &in.VolumeThroughput, &out.VolumeThroughput
		*out = new(int32)
		**out = **in
	}
	if in.VolumeSize != nil {
		in, out := &in.VolumeSize, &out.VolumeSize
		*out = new(int32)
		**out = **in
	}
	if in.KmsKeyID != nil {
		in, out := &in.KmsKeyID, &out.KmsKeyID
		*out = new(string)
		**out = **in
	}
	if in.EncryptedVolume != nil {
		in, out := &in.EncryptedVolume, &out.EncryptedVolume
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdMemberSpec.
func (in *EtcdMemberSpec) DeepCopy() *EtcdMemberSpec {
	if in == nil {
		return nil
	}
	out := new(EtcdMemberSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExecContainerAction) DeepCopyInto(out *ExecContainerAction) {
	*out = *in
	if in.Command != nil {
		in, out := &in.Command, &out.Command
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Environment != nil {
		in, out := &in.Environment, &out.Environment
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExecContainerAction.
func (in *ExecContainerAction) DeepCopy() *ExecContainerAction {
	if in == nil {
		return nil
	}
	out := new(ExecContainerAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalDNSConfig) DeepCopyInto(out *ExternalDNSConfig) {
	*out = *in
	if in.WatchIngress != nil {
		in, out := &in.WatchIngress, &out.WatchIngress
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalDNSConfig.
func (in *ExternalDNSConfig) DeepCopy() *ExternalDNSConfig {
	if in == nil {
		return nil
	}
	out := new(ExternalDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalNetworkingSpec) DeepCopyInto(out *ExternalNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalNetworkingSpec.
func (in *ExternalNetworkingSpec) DeepCopy() *ExternalNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(ExternalNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileAssetSpec) DeepCopyInto(out *FileAssetSpec) {
	*out = *in
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileAssetSpec.
func (in *FileAssetSpec) DeepCopy() *FileAssetSpec {
	if in == nil {
		return nil
	}
	out := new(FileAssetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FlannelNetworkingSpec) DeepCopyInto(out *FlannelNetworkingSpec) {
	*out = *in
	if in.IptablesResyncSeconds != nil {
		in, out := &in.IptablesResyncSeconds, &out.IptablesResyncSeconds
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FlannelNetworkingSpec.
func (in *FlannelNetworkingSpec) DeepCopy() *FlannelNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(FlannelNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCENetworkingSpec) DeepCopyInto(out *GCENetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCENetworkingSpec.
func (in *GCENetworkingSpec) DeepCopy() *GCENetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(GCENetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCPPDCSIDriver) DeepCopyInto(out *GCPPDCSIDriver) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCPPDCSIDriver.
func (in *GCPPDCSIDriver) DeepCopy() *GCPPDCSIDriver {
	if in == nil {
		return nil
	}
	out := new(GCPPDCSIDriver)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GossipConfig) DeepCopyInto(out *GossipConfig) {
	*out = *in
	if in.Protocol != nil {
		in, out := &in.Protocol, &out.Protocol
		*out = new(string)
		**out = **in
	}
	if in.Listen != nil {
		in, out := &in.Listen, &out.Listen
		*out = new(string)
		**out = **in
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(string)
		**out = **in
	}
	if in.Secondary != nil {
		in, out := &in.Secondary, &out.Secondary
		*out = new(GossipConfigSecondary)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GossipConfig.
func (in *GossipConfig) DeepCopy() *GossipConfig {
	if in == nil {
		return nil
	}
	out := new(GossipConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GossipConfigSecondary) DeepCopyInto(out *GossipConfigSecondary) {
	*out = *in
	if in.Protocol != nil {
		in, out := &in.Protocol, &out.Protocol
		*out = new(string)
		**out = **in
	}
	if in.Listen != nil {
		in, out := &in.Listen, &out.Listen
		*out = new(string)
		**out = **in
	}
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GossipConfigSecondary.
func (in *GossipConfigSecondary) DeepCopy() *GossipConfigSecondary {
	if in == nil {
		return nil
	}
	out := new(GossipConfigSecondary)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPProxy) DeepCopyInto(out *HTTPProxy) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPProxy.
func (in *HTTPProxy) DeepCopy() *HTTPProxy {
	if in == nil {
		return nil
	}
	out := new(HTTPProxy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HookSpec) DeepCopyInto(out *HookSpec) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Roles != nil {
		in, out := &in.Roles, &out.Roles
		*out = make([]InstanceGroupRole, len(*in))
		copy(*out, *in)
	}
	if in.Requires != nil {
		in, out := &in.Requires, &out.Requires
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Before != nil {
		in, out := &in.Before, &out.Before
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExecContainer != nil {
		in, out := &in.ExecContainer, &out.ExecContainer
		*out = new(ExecContainerAction)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HookSpec.
func (in *HookSpec) DeepCopy() *HookSpec {
	if in == nil {
		return nil
	}
	out := new(HookSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HubbleSpec) DeepCopyInto(out *HubbleSpec) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Metrics != nil {
		in, out := &in.Metrics, &out.Metrics
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HubbleSpec.
func (in *HubbleSpec) DeepCopy() *HubbleSpec {
	if in == nil {
		return nil
	}
	out := new(HubbleSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IAMProfileSpec) DeepCopyInto(out *IAMProfileSpec) {
	*out = *in
	if in.Profile != nil {
		in, out := &in.Profile, &out.Profile
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IAMProfileSpec.
func (in *IAMProfileSpec) DeepCopy() *IAMProfileSpec {
	if in == nil {
		return nil
	}
	out := new(IAMProfileSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IAMSpec) DeepCopyInto(out *IAMSpec) {
	*out = *in
	if in.PermissionsBoundary != nil {
		in, out := &in.PermissionsBoundary, &out.PermissionsBoundary
		*out = new(string)
		**out = **in
	}
	if in.UseServiceAccountExternalPermissions != nil {
		in, out := &in.UseServiceAccountExternalPermissions, &out.UseServiceAccountExternalPermissions
		*out = new(bool)
		**out = **in
	}
	if in.ServiceAccountExternalPermissions != nil {
		in, out := &in.ServiceAccountExternalPermissions, &out.ServiceAccountExternalPermissions
		*out = make([]ServiceAccountExternalPermission, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IAMSpec.
func (in *IAMSpec) DeepCopy() *IAMSpec {
	if in == nil {
		return nil
	}
	out := new(IAMSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroup) DeepCopyInto(out *InstanceGroup) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroup.
func (in *InstanceGroup) DeepCopy() *InstanceGroup {
	if in == nil {
		return nil
	}
	out := new(InstanceGroup)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *InstanceGroup) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroupList) DeepCopyInto(out *InstanceGroupList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]InstanceGroup, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroupList.
func (in *InstanceGroupList) DeepCopy() *InstanceGroupList {
	if in == nil {
		return nil
	}
	out := new(InstanceGroupList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *InstanceGroupList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceGroupSpec) DeepCopyInto(out *InstanceGroupSpec) {
	*out = *in
	if in.MinSize != nil {
		in, out := &in.MinSize, &out.MinSize
		*out = new(int32)
		**out = **in
	}
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		*out = new(int32)
		**out = **in
	}
	if in.Autoscale != nil {
		in, out := &in.Autoscale, &out.Autoscale
		*out = new(bool)
		**out = **in
	}
	if in.RootVolumeSize != nil {
		in, out := &in.RootVolumeSize, &out.RootVolumeSize
		*out = new(int32)
		**out = **in
	}
	if in.RootVolumeType != nil {
		in, out := &in.RootVolumeType, &out.RootVolumeType
		*out = new(string)
		**out = **in
	}
	if in.RootVolumeIOPS != nil {
		in, out := &in.RootVolumeIOPS, &out.RootVolumeIOPS
		*out = new(int32)
		**out = **in
	}
	if in.RootVolumeThroughput != nil {
		in, out := &in.RootVolumeThroughput, &out.RootVolumeThroughput
		*out = new(int32)
		**out = **in
	}
	if in.RootVolumeOptimization != nil {
		in, out := &in.RootVolumeOptimization, &out.RootVolumeOptimization
		*out = new(bool)
		**out = **in
	}
	if in.RootVolumeEncryption != nil {
		in, out := &in.RootVolumeEncryption, &out.RootVolumeEncryption
		*out = new(bool)
		**out = **in
	}
	if in.RootVolumeEncryptionKey != nil {
		in, out := &in.RootVolumeEncryptionKey, &out.RootVolumeEncryptionKey
		*out = new(string)
		**out = **in
	}
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]VolumeSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeMounts != nil {
		in, out := &in.VolumeMounts, &out.VolumeMounts
		*out = make([]VolumeMountSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Zones != nil {
		in, out := &in.Zones, &out.Zones
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Hooks != nil {
		in, out := &in.Hooks, &out.Hooks
		*out = make([]HookSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MaxPrice != nil {
		in, out := &in.MaxPrice, &out.MaxPrice
		*out = new(string)
		**out = **in
	}
	if in.SpotDurationInMinutes != nil {
		in, out := &in.SpotDurationInMinutes, &out.SpotDurationInMinutes
		*out = new(int64)
		**out = **in
	}
	if in.CPUCredits != nil {
		in, out := &in.CPUCredits, &out.CPUCredits
		*out = new(string)
		**out = **in
	}
	if in.AssociatePublicIP != nil {
		in, out := &in.AssociatePublicIP, &out.AssociatePublicIP
		*out = new(bool)
		**out = **in
	}
	if in.AdditionalSecurityGroups != nil {
		in, out := &in.AdditionalSecurityGroups, &out.AdditionalSecurityGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CloudLabels != nil {
		in, out := &in.CloudLabels, &out.CloudLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.NodeLabels != nil {
		in, out := &in.NodeLabels, &out.NodeLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.FileAssets != nil {
		in, out := &in.FileAssets, &out.FileAssets
		*out = make([]FileAssetSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Kubelet != nil {
		in, out := &in.Kubelet, &out.Kubelet
		*out = new(KubeletConfigSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MixedInstancesPolicy != nil {
		in, out := &in.MixedInstancesPolicy, &out.MixedInstancesPolicy
		*out = new(MixedInstancesPolicySpec)
		(*in).DeepCopyInto(*out)
	}
	if in.AdditionalUserData != nil {
		in, out := &in.AdditionalUserData, &out.AdditionalUserData
		*out = make([]UserData, len(*in))
		copy(*out, *in)
	}
	if in.SuspendProcesses != nil {
		in, out := &in.SuspendProcesses, &out.SuspendProcesses
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ExternalLoadBalancers != nil {
		in, out := &in.ExternalLoadBalancers, &out.ExternalLoadBalancers
		*out = make([]LoadBalancer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DetailedInstanceMonitoring != nil {
		in, out := &in.DetailedInstanceMonitoring, &out.DetailedInstanceMonitoring
		*out = new(bool)
		**out = **in
	}
	if in.IAM != nil {
		in, out := &in.IAM, &out.IAM
		*out = new(IAMProfileSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.SecurityGroupOverride != nil {
		in, out := &in.SecurityGroupOverride, &out.SecurityGroupOverride
		*out = new(string)
		**out = **in
	}
	if in.InstanceProtection != nil {
		in, out := &in.InstanceProtection, &out.InstanceProtection
		*out = new(bool)
		**out = **in
	}
	if in.SysctlParameters != nil {
		in, out := &in.SysctlParameters, &out.SysctlParameters
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(RollingUpdate)
		(*in).DeepCopyInto(*out)
	}
	if in.InstanceInterruptionBehavior != nil {
		in, out := &in.InstanceInterruptionBehavior, &out.InstanceInterruptionBehavior
		*out = new(string)
		**out = **in
	}
	if in.CompressUserData != nil {
		in, out := &in.CompressUserData, &out.CompressUserData
		*out = new(bool)
		**out = **in
	}
	if in.InstanceMetadata != nil {
		in, out := &in.InstanceMetadata, &out.InstanceMetadata
		*out = new(InstanceMetadataOptions)
		(*in).DeepCopyInto(*out)
	}
	if in.UpdatePolicy != nil {
		in, out := &in.UpdatePolicy, &out.UpdatePolicy
		*out = new(string)
		**out = **in
	}
	if in.WarmPool != nil {
		in, out := &in.WarmPool, &out.WarmPool
		*out = new(WarmPoolSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceGroupSpec.
func (in *InstanceGroupSpec) DeepCopy() *InstanceGroupSpec {
	if in == nil {
		return nil
	}
	out := new(InstanceGroupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InstanceMetadataOptions) DeepCopyInto(out *InstanceMetadataOptions) {
	*out = *in
	if in.HTTPPutResponseHopLimit != nil {
		in, out := &in.HTTPPutResponseHopLimit, &out.HTTPPutResponseHopLimit
		*out = new(int64)
		**out = **in
	}
	if in.HTTPTokens != nil {
		in, out := &in.HTTPTokens, &out.HTTPTokens
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InstanceMetadataOptions.
func (in *InstanceMetadataOptions) DeepCopy() *InstanceMetadataOptions {
	if in == nil {
		return nil
	}
	out := new(InstanceMetadataOptions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Keyset) DeepCopyInto(out *Keyset) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Keyset.
func (in *Keyset) DeepCopy() *Keyset {
	if in == nil {
		return nil
	}
	out := new(Keyset)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Keyset) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetItem) DeepCopyInto(out *KeysetItem) {
	*out = *in
	if in.DistrustTimestamp != nil {
		in, out := &in.DistrustTimestamp, &out.DistrustTimestamp
		*out = (*in).DeepCopy()
	}
	if in.PublicMaterial != nil {
		in, out := &in.PublicMaterial, &out.PublicMaterial
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.PrivateMaterial != nil {
		in, out := &in.PrivateMaterial, &out.PrivateMaterial
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetItem.
func (in *KeysetItem) DeepCopy() *KeysetItem {
	if in == nil {
		return nil
	}
	out := new(KeysetItem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetList) DeepCopyInto(out *KeysetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Keyset, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetList.
func (in *KeysetList) DeepCopy() *KeysetList {
	if in == nil {
		return nil
	}
	out := new(KeysetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KeysetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeysetSpec) DeepCopyInto(out *KeysetSpec) {
	*out = *in
	if in.Keys != nil {
		in, out := &in.Keys, &out.Keys
		*out = make([]KeysetItem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeysetSpec.
func (in *KeysetSpec) DeepCopy() *KeysetSpec {
	if in == nil {
		return nil
	}
	out := new(KeysetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KopeioAuthenticationSpec) DeepCopyInto(out *KopeioAuthenticationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KopeioAuthenticationSpec.
func (in *KopeioAuthenticationSpec) DeepCopy() *KopeioAuthenticationSpec {
	if in == nil {
		return nil
	}
	out := new(KopeioAuthenticationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KopeioNetworkingSpec) DeepCopyInto(out *KopeioNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KopeioNetworkingSpec.
func (in *KopeioNetworkingSpec) DeepCopy() *KopeioNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KopeioNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeAPIServerConfig) DeepCopyInto(out *KubeAPIServerConfig) {
	*out = *in
	if in.DisableBasicAuth != nil {
		in, out := &in.DisableBasicAuth, &out.DisableBasicAuth
		*out = new(bool)
		**out = **in
	}
	if in.EnableBootstrapAuthToken != nil {
		in, out := &in.EnableBootstrapAuthToken, &out.EnableBootstrapAuthToken
		*out = new(bool)
		**out = **in
	}
	if in.EnableAggregatorRouting != nil {
		in, out := &in.EnableAggregatorRouting, &out.EnableAggregatorRouting
		*out = new(bool)
		**out = **in
	}
	if in.AdmissionControl != nil {
		in, out := &in.AdmissionControl, &out.AdmissionControl
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AppendAdmissionPlugins != nil {
		in, out := &in.AppendAdmissionPlugins, &out.AppendAdmissionPlugins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EnableAdmissionPlugins != nil {
		in, out := &in.EnableAdmissionPlugins, &out.EnableAdmissionPlugins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DisableAdmissionPlugins != nil {
		in, out := &in.DisableAdmissionPlugins, &out.DisableAdmissionPlugins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EtcdServers != nil {
		in, out := &in.EtcdServers, &out.EtcdServers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EtcdServersOverrides != nil {
		in, out := &in.EtcdServersOverrides, &out.EtcdServersOverrides
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.TLSCipherSuites != nil {
		in, out := &in.TLSCipherSuites, &out.TLSCipherSuites
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AllowPrivileged != nil {
		in, out := &in.AllowPrivileged, &out.AllowPrivileged
		*out = new(bool)
		**out = **in
	}
	if in.APIServerCount != nil {
		in, out := &in.APIServerCount, &out.APIServerCount
		*out = new(int32)
		**out = **in
	}
	if in.RuntimeConfig != nil {
		in, out := &in.RuntimeConfig, &out.RuntimeConfig
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.AnonymousAuth != nil {
		in, out := &in.AnonymousAuth, &out.AnonymousAuth
		*out = new(bool)
		**out = **in
	}
	if in.KubeletPreferredAddressTypes != nil {
		in, out := &in.KubeletPreferredAddressTypes, &out.KubeletPreferredAddressTypes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.StorageBackend != nil {
		in, out := &in.StorageBackend, &out.StorageBackend
		*out = new(string)
		**out = **in
	}
	if in.OIDCUsernameClaim != nil {
		in, out := &in.OIDCUsernameClaim, &out.OIDCUsernameClaim
		*out = new(string)
		**out = **in
	}
	if in.OIDCUsernamePrefix != nil {
		in, out := &in.OIDCUsernamePrefix, &out.OIDCUsernamePrefix
		*out = new(string)
		**out = **in
	}
	if in.OIDCGroupsClaim != nil {
		in, out := &in.OIDCGroupsClaim, &out.OIDCGroupsClaim
		*out = new(string)
		**out = **in
	}
	if in.OIDCGroupsPrefix != nil {
		in, out := &in.OIDCGroupsPrefix, &out.OIDCGroupsPrefix
		*out = new(string)
		**out = **in
	}
	if in.OIDCIssuerURL != nil {
		in, out := &in.OIDCIssuerURL, &out.OIDCIssuerURL
		*out = new(string)
		**out = **in
	}
	if in.OIDCClientID != nil {
		in, out := &in.OIDCClientID, &out.OIDCClientID
		*out = new(string)
		**out = **in
	}
	if in.OIDCRequiredClaim != nil {
		in, out := &in.OIDCRequiredClaim, &out.OIDCRequiredClaim
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.OIDCCAFile != nil {
		in, out := &in.OIDCCAFile, &out.OIDCCAFile
		*out = new(string)
		**out = **in
	}
	if in.ProxyClientCertFile != nil {
		in, out := &in.ProxyClientCertFile, &out.ProxyClientCertFile
		*out = new(string)
		**out = **in
	}
	if in.ProxyClientKeyFile != nil {
		in, out := &in.ProxyClientKeyFile, &out.ProxyClientKeyFile
		*out = new(string)
		**out = **in
	}
	if in.AuditLogFormat != nil {
		in, out := &in.AuditLogFormat, &out.AuditLogFormat
		*out = new(string)
		**out = **in
	}
	if in.AuditLogPath != nil {
		in, out := &in.AuditLogPath, &out.AuditLogPath
		*out = new(string)
		**out = **in
	}
	if in.AuditLogMaxAge != nil {
		in, out := &in.AuditLogMaxAge, &out.AuditLogMaxAge
		*out = new(int32)
		**out = **in
	}
	if in.AuditLogMaxBackups != nil {
		in, out := &in.AuditLogMaxBackups, &out.AuditLogMaxBackups
		*out = new(int32)
		**out = **in
	}
	if in.AuditLogMaxSize != nil {
		in, out := &in.AuditLogMaxSize, &out.AuditLogMaxSize
		*out = new(int32)
		**out = **in
	}
	if in.AuditWebhookBatchBufferSize != nil {
		in, out := &in.AuditWebhookBatchBufferSize, &out.AuditWebhookBatchBufferSize
		*out = new(int32)
		**out = **in
	}
	if in.AuditWebhookBatchMaxSize != nil {
		in, out := &in.AuditWebhookBatchMaxSize, &out.AuditWebhookBatchMaxSize
		*out = new(int32)
		**out = **in
	}
	if in.AuditWebhookBatchMaxWait != nil {
		in, out := &in.AuditWebhookBatchMaxWait, &out.AuditWebhookBatchMaxWait
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuditWebhookBatchThrottleBurst != nil {
		in, out := &in.AuditWebhookBatchThrottleBurst, &out.AuditWebhookBatchThrottleBurst
		*out = new(int32)
		**out = **in
	}
	if in.AuditWebhookBatchThrottleEnable != nil {
		in, out := &in.AuditWebhookBatchThrottleEnable, &out.AuditWebhookBatchThrottleEnable
		*out = new(bool)
		**out = **in
	}
	if in.AuditWebhookBatchThrottleQps != nil {
		in, out := &in.AuditWebhookBatchThrottleQps, &out.AuditWebhookBatchThrottleQps
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.AuditWebhookInitialBackoff != nil {
		in, out := &in.AuditWebhookInitialBackoff, &out.AuditWebhookInitialBackoff
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuthenticationTokenWebhookConfigFile != nil {
		in, out := &in.AuthenticationTokenWebhookConfigFile, &out.AuthenticationTokenWebhookConfigFile
		*out = new(string)
		**out = **in
	}
	if in.AuthenticationTokenWebhookCacheTTL != nil {
		in, out := &in.AuthenticationTokenWebhookCacheTTL, &out.AuthenticationTokenWebhookCacheTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuthorizationMode != nil {
		in, out := &in.AuthorizationMode, &out.AuthorizationMode
		*out = new(string)
		**out = **in
	}
	if in.AuthorizationWebhookConfigFile != nil {
		in, out := &in.AuthorizationWebhookConfigFile, &out.AuthorizationWebhookConfigFile
		*out = new(string)
		**out = **in
	}
	if in.AuthorizationWebhookCacheAuthorizedTTL != nil {
		in, out := &in.AuthorizationWebhookCacheAuthorizedTTL, &out.AuthorizationWebhookCacheAuthorizedTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuthorizationWebhookCacheUnauthorizedTTL != nil {
		in, out := &in.AuthorizationWebhookCacheUnauthorizedTTL, &out.AuthorizationWebhookCacheUnauthorizedTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuthorizationRBACSuperUser != nil {
		in, out := &in.AuthorizationRBACSuperUser, &out.AuthorizationRBACSuperUser
		*out = new(string)
		**out = **in
	}
	if in.EncryptionProviderConfig != nil {
		in, out := &in.EncryptionProviderConfig, &out.EncryptionProviderConfig
		*out = new(string)
		**out = **in
	}
	if in.ExperimentalEncryptionProviderConfig != nil {
		in, out := &in.ExperimentalEncryptionProviderConfig, &out.ExperimentalEncryptionProviderConfig
		*out = new(string)
		**out = **in
	}
	if in.RequestheaderUsernameHeaders != nil {
		in, out := &in.RequestheaderUsernameHeaders, &out.RequestheaderUsernameHeaders
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderGroupHeaders != nil {
		in, out := &in.RequestheaderGroupHeaders, &out.RequestheaderGroupHeaders
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderExtraHeaderPrefixes != nil {
		in, out := &in.RequestheaderExtraHeaderPrefixes, &out.RequestheaderExtraHeaderPrefixes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequestheaderAllowedNames != nil {
		in, out := &in.RequestheaderAllowedNames, &out.RequestheaderAllowedNames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.HTTP2MaxStreamsPerConnection != nil {
		in, out := &in.HTTP2MaxStreamsPerConnection, &out.HTTP2MaxStreamsPerConnection
		*out = new(int32)
		**out = **in
	}
	if in.EtcdQuorumRead != nil {
		in, out := &in.EtcdQuorumRead, &out.EtcdQuorumRead
		*out = new(bool)
		**out = **in
	}
	if in.RequestTimeout != nil {
		in, out := &in.RequestTimeout, &out.RequestTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.MinRequestTimeout != nil {
		in, out := &in.MinRequestTimeout, &out.MinRequestTimeout
		*out = new(int32)
		**out = **in
	}
	if in.ServiceAccountKeyFile != nil {
		in, out := &in.ServiceAccountKeyFile, &out.ServiceAccountKeyFile
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ServiceAccountSigningKeyFile != nil {
		in, out := &in.ServiceAccountSigningKeyFile, &out.ServiceAccountSigningKeyFile
		*out = new(string)
		**out = **in
	}
	if in.ServiceAccountIssuer != nil {
		in, out := &in.ServiceAccountIssuer, &out.ServiceAccountIssuer
		*out = new(string)
		**out = **in
	}
	if in.ServiceAccountJWKSURI != nil {
		in, out := &in.ServiceAccountJWKSURI, &out.ServiceAccountJWKSURI
		*out = new(string)
		**out = **in
	}
	if in.APIAudiences != nil {
		in, out := &in.APIAudiences, &out.APIAudiences
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPULimit != nil {
		in, out := &in.CPULimit, &out.CPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.EventTTL != nil {
		in, out := &in.EventTTL, &out.EventTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AuditDynamicConfiguration != nil {
		in, out := &in.AuditDynamicConfiguration, &out.AuditDynamicConfiguration
		*out = new(bool)
		**out = **in
	}
	if in.EnableProfiling != nil {
		in, out := &in.EnableProfiling, &out.EnableProfiling
		*out = new(bool)
		**out = **in
	}
	if in.CorsAllowedOrigins != nil {
		in, out := &in.CorsAllowedOrigins, &out.CorsAllowedOrigins
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.DefaultNotReadyTolerationSeconds != nil {
		in, out := &in.DefaultNotReadyTolerationSeconds, &out.DefaultNotReadyTolerationSeconds
		*out = new(int64)
		**out = **in
	}
	if in.DefaultUnreachableTolerationSeconds != nil {
		in, out := &in.DefaultUnreachableTolerationSeconds, &out.DefaultUnreachableTolerationSeconds
		*out = new(int64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeAPIServerConfig.
func (in *KubeAPIServerConfig) DeepCopy() *KubeAPIServerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeAPIServerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllerManagerConfig) DeepCopyInto(out *KubeControllerManagerConfig) {
	*out = *in
	if in.AllocateNodeCIDRs != nil {
		in, out := &in.AllocateNodeCIDRs, &out.AllocateNodeCIDRs
		*out = new(bool)
		**out = **in
	}
	if in.NodeCIDRMaskSize != nil {
		in, out := &in.NodeCIDRMaskSize, &out.NodeCIDRMaskSize
		*out = new(int32)
		**out = **in
	}
	if in.ConfigureCloudRoutes != nil {
		in, out := &in.ConfigureCloudRoutes, &out.ConfigureCloudRoutes
		*out = new(bool)
		**out = **in
	}
	if in.Controllers != nil {
		in, out := &in.Controllers, &out.Controllers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.CIDRAllocatorType != nil {
		in, out := &in.CIDRAllocatorType, &out.CIDRAllocatorType
		*out = new(string)
		**out = **in
	}
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.AttachDetachReconcileSyncPeriod != nil {
		in, out := &in.AttachDetachReconcileSyncPeriod, &out.AttachDetachReconcileSyncPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.DisableAttachDetachReconcileSync != nil {
		in, out := &in.DisableAttachDetachReconcileSync, &out.DisableAttachDetachReconcileSync
		*out = new(bool)
		**out = **in
	}
	if in.TerminatedPodGCThreshold != nil {
		in, out := &in.TerminatedPodGCThreshold, &out.TerminatedPodGCThreshold
		*out = new(int32)
		**out = **in
	}
	if in.NodeMonitorPeriod != nil {
		in, out := &in.NodeMonitorPeriod, &out.NodeMonitorPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.NodeMonitorGracePeriod != nil {
		in, out := &in.NodeMonitorGracePeriod, &out.NodeMonitorGracePeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.PodEvictionTimeout != nil {
		in, out := &in.PodEvictionTimeout, &out.PodEvictionTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.UseServiceAccountCredentials != nil {
		in, out := &in.UseServiceAccountCredentials, &out.UseServiceAccountCredentials
		*out = new(bool)
		**out = **in
	}
	if in.HorizontalPodAutoscalerSyncPeriod != nil {
		in, out := &in.HorizontalPodAutoscalerSyncPeriod, &out.HorizontalPodAutoscalerSyncPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerDownscaleDelay != nil {
		in, out := &in.HorizontalPodAutoscalerDownscaleDelay, &out.HorizontalPodAutoscalerDownscaleDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerDownscaleStabilization != nil {
		in, out := &in.HorizontalPodAutoscalerDownscaleStabilization, &out.HorizontalPodAutoscalerDownscaleStabilization
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerUpscaleDelay != nil {
		in, out := &in.HorizontalPodAutoscalerUpscaleDelay, &out.HorizontalPodAutoscalerUpscaleDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerInitialReadinessDelay != nil {
		in, out := &in.HorizontalPodAutoscalerInitialReadinessDelay, &out.HorizontalPodAutoscalerInitialReadinessDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerCPUInitializationPeriod != nil {
		in, out := &in.HorizontalPodAutoscalerCPUInitializationPeriod, &out.HorizontalPodAutoscalerCPUInitializationPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HorizontalPodAutoscalerTolerance != nil {
		in, out := &in.HorizontalPodAutoscalerTolerance, &out.HorizontalPodAutoscalerTolerance
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.HorizontalPodAutoscalerUseRestClients != nil {
		in, out := &in.HorizontalPodAutoscalerUseRestClients, &out.HorizontalPodAutoscalerUseRestClients
		*out = new(bool)
		**out = **in
	}
	if in.ExperimentalClusterSigningDuration != nil {
		in, out := &in.ExperimentalClusterSigningDuration, &out.ExperimentalClusterSigningDuration
		*out = new(v1.Duration)
		**out = **in
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TLSCertFile != nil {
		in, out := &in.TLSCertFile, &out.TLSCertFile
		*out = new(string)
		**out = **in
	}
	if in.TLSCipherSuites != nil {
		in, out := &in.TLSCipherSuites, &out.TLSCipherSuites
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.KubeAPIQPS != nil {
		in, out := &in.KubeAPIQPS, &out.KubeAPIQPS
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.KubeAPIBurst != nil {
		in, out := &in.KubeAPIBurst, &out.KubeAPIBurst
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentDeploymentSyncs != nil {
		in, out := &in.ConcurrentDeploymentSyncs, &out.ConcurrentDeploymentSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentEndpointSyncs != nil {
		in, out := &in.ConcurrentEndpointSyncs, &out.ConcurrentEndpointSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentNamespaceSyncs != nil {
		in, out := &in.ConcurrentNamespaceSyncs, &out.ConcurrentNamespaceSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentReplicasetSyncs != nil {
		in, out := &in.ConcurrentReplicasetSyncs, &out.ConcurrentReplicasetSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentServiceSyncs != nil {
		in, out := &in.ConcurrentServiceSyncs, &out.ConcurrentServiceSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentResourceQuotaSyncs != nil {
		in, out := &in.ConcurrentResourceQuotaSyncs, &out.ConcurrentResourceQuotaSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentServiceaccountTokenSyncs != nil {
		in, out := &in.ConcurrentServiceaccountTokenSyncs, &out.ConcurrentServiceaccountTokenSyncs
		*out = new(int32)
		**out = **in
	}
	if in.ConcurrentRCSyncs != nil {
		in, out := &in.ConcurrentRCSyncs, &out.ConcurrentRCSyncs
		*out = new(int32)
		**out = **in
	}
	if in.AuthorizationAlwaysAllowPaths != nil {
		in, out := &in.AuthorizationAlwaysAllowPaths, &out.AuthorizationAlwaysAllowPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EnableProfiling != nil {
		in, out := &in.EnableProfiling, &out.EnableProfiling
		*out = new(bool)
		**out = **in
	}
	if in.EnableLeaderMigration != nil {
		in, out := &in.EnableLeaderMigration, &out.EnableLeaderMigration
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllerManagerConfig.
func (in *KubeControllerManagerConfig) DeepCopy() *KubeControllerManagerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeControllerManagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeDNSConfig) DeepCopyInto(out *KubeDNSConfig) {
	*out = *in
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.StubDomains != nil {
		in, out := &in.StubDomains, &out.StubDomains
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.UpstreamNameservers != nil {
		in, out := &in.UpstreamNameservers, &out.UpstreamNameservers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.NodeLocalDNS != nil {
		in, out := &in.NodeLocalDNS, &out.NodeLocalDNS
		*out = new(NodeLocalDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeDNSConfig.
func (in *KubeDNSConfig) DeepCopy() *KubeDNSConfig {
	if in == nil {
		return nil
	}
	out := new(KubeDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeProxyConfig) DeepCopyInto(out *KubeProxyConfig) {
	*out = *in
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPULimit != nil {
		in, out := &in.CPULimit, &out.CPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.ClusterCIDR != nil {
		in, out := &in.ClusterCIDR, &out.ClusterCIDR
		*out = new(string)
		**out = **in
	}
	if in.MetricsBindAddress != nil {
		in, out := &in.MetricsBindAddress, &out.MetricsBindAddress
		*out = new(string)
		**out = **in
	}
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.IPVSExcludeCIDRs != nil {
		in, out := &in.IPVSExcludeCIDRs, &out.IPVSExcludeCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.IPVSMinSyncPeriod != nil {
		in, out := &in.IPVSMinSyncPeriod, &out.IPVSMinSyncPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IPVSScheduler != nil {
		in, out := &in.IPVSScheduler, &out.IPVSScheduler
		*out = new(string)
		**out = **in
	}
	if in.IPVSSyncPeriod != nil {
		in, out := &in.IPVSSyncPeriod, &out.IPVSSyncPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.ConntrackMaxPerCore != nil {
		in, out := &in.ConntrackMaxPerCore, &out.ConntrackMaxPerCore
		*out = new(int32)
		**out = **in
	}
	if in.ConntrackMin != nil {
		in, out := &in.ConntrackMin, &out.ConntrackMin
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeProxyConfig.
func (in *KubeProxyConfig) DeepCopy() *KubeProxyConfig {
	if in == nil {
		return nil
	}
	out := new(KubeProxyConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeSchedulerConfig) DeepCopyInto(out *KubeSchedulerConfig) {
	*out = *in
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(LeaderElectionConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.UsePolicyConfigMap != nil {
		in, out := &in.UsePolicyConfigMap, &out.UsePolicyConfigMap
		*out = new(bool)
		**out = **in
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MaxPersistentVolumes != nil {
		in, out := &in.MaxPersistentVolumes, &out.MaxPersistentVolumes
		*out = new(int32)
		**out = **in
	}
	if in.Qps != nil {
		in, out := &in.Qps, &out.Qps
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.AuthorizationAlwaysAllowPaths != nil {
		in, out := &in.AuthorizationAlwaysAllowPaths, &out.AuthorizationAlwaysAllowPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EnableProfiling != nil {
		in, out := &in.EnableProfiling, &out.EnableProfiling
		*out = new(bool)
		**out = **in
	}
	if in.TLSCertFile != nil {
		in, out := &in.TLSCertFile, &out.TLSCertFile
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeSchedulerConfig.
func (in *KubeSchedulerConfig) DeepCopy() *KubeSchedulerConfig {
	if in == nil {
		return nil
	}
	out := new(KubeSchedulerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeletConfigSpec) DeepCopyInto(out *KubeletConfigSpec) {
	*out = *in
	if in.AnonymousAuth != nil {
		in, out := &in.AnonymousAuth, &out.AnonymousAuth
		*out = new(bool)
		**out = **in
	}
	if in.TLSCipherSuites != nil {
		in, out := &in.TLSCipherSuites, &out.TLSCipherSuites
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RequireKubeconfig != nil {
		in, out := &in.RequireKubeconfig, &out.RequireKubeconfig
		*out = new(bool)
		**out = **in
	}
	if in.LogLevel != nil {
		in, out := &in.LogLevel, &out.LogLevel
		*out = new(int32)
		**out = **in
	}
	if in.SeccompProfileRoot != nil {
		in, out := &in.SeccompProfileRoot, &out.SeccompProfileRoot
		*out = new(string)
		**out = **in
	}
	if in.AllowPrivileged != nil {
		in, out := &in.AllowPrivileged, &out.AllowPrivileged
		*out = new(bool)
		**out = **in
	}
	if in.EnableDebuggingHandlers != nil {
		in, out := &in.EnableDebuggingHandlers, &out.EnableDebuggingHandlers
		*out = new(bool)
		**out = **in
	}
	if in.RegisterNode != nil {
		in, out := &in.RegisterNode, &out.RegisterNode
		*out = new(bool)
		**out = **in
	}
	if in.NodeStatusUpdateFrequency != nil {
		in, out := &in.NodeStatusUpdateFrequency, &out.NodeStatusUpdateFrequency
		*out = new(v1.Duration)
		**out = **in
	}
	if in.ReadOnlyPort != nil {
		in, out := &in.ReadOnlyPort, &out.ReadOnlyPort
		*out = new(int32)
		**out = **in
	}
	if in.ConfigureCBR0 != nil {
		in, out := &in.ConfigureCBR0, &out.ConfigureCBR0
		*out = new(bool)
		**out = **in
	}
	if in.BabysitDaemons != nil {
		in, out := &in.BabysitDaemons, &out.BabysitDaemons
		*out = new(bool)
		**out = **in
	}
	if in.MaxPods != nil {
		in, out := &in.MaxPods, &out.MaxPods
		*out = new(int32)
		**out = **in
	}
	if in.ResolverConfig != nil {
		in, out := &in.ResolverConfig, &out.ResolverConfig
		*out = new(string)
		**out = **in
	}
	if in.ReconcileCIDR != nil {
		in, out := &in.ReconcileCIDR, &out.ReconcileCIDR
		*out = new(bool)
		**out = **in
	}
	if in.RegisterSchedulable != nil {
		in, out := &in.RegisterSchedulable, &out.RegisterSchedulable
		*out = new(bool)
		**out = **in
	}
	if in.SerializeImagePulls != nil {
		in, out := &in.SerializeImagePulls, &out.SerializeImagePulls
		*out = new(bool)
		**out = **in
	}
	if in.NodeLabels != nil {
		in, out := &in.NodeLabels, &out.NodeLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.EnableCustomMetrics != nil {
		in, out := &in.EnableCustomMetrics, &out.EnableCustomMetrics
		*out = new(bool)
		**out = **in
	}
	if in.NetworkPluginMTU != nil {
		in, out := &in.NetworkPluginMTU, &out.NetworkPluginMTU
		*out = new(int32)
		**out = **in
	}
	if in.ImageGCHighThresholdPercent != nil {
		in, out := &in.ImageGCHighThresholdPercent, &out.ImageGCHighThresholdPercent
		*out = new(int32)
		**out = **in
	}
	if in.ImageGCLowThresholdPercent != nil {
		in, out := &in.ImageGCLowThresholdPercent, &out.ImageGCLowThresholdPercent
		*out = new(int32)
		**out = **in
	}
	if in.ImagePullProgressDeadline != nil {
		in, out := &in.ImagePullProgressDeadline, &out.ImagePullProgressDeadline
		*out = new(v1.Duration)
		**out = **in
	}
	if in.EvictionHard != nil {
		in, out := &in.EvictionHard, &out.EvictionHard
		*out = new(string)
		**out = **in
	}
	if in.EvictionPressureTransitionPeriod != nil {
		in, out := &in.EvictionPressureTransitionPeriod, &out.EvictionPressureTransitionPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.FeatureGates != nil {
		in, out := &in.FeatureGates, &out.FeatureGates
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KernelMemcgNotification != nil {
		in, out := &in.KernelMemcgNotification, &out.KernelMemcgNotification
		*out = new(bool)
		**out = **in
	}
	if in.KubeReserved != nil {
		in, out := &in.KubeReserved, &out.KubeReserved
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.SystemReserved != nil {
		in, out := &in.SystemReserved, &out.SystemReserved
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RuntimeRequestTimeout != nil {
		in, out := &in.RuntimeRequestTimeout, &out.RuntimeRequestTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.VolumeStatsAggPeriod != nil {
		in, out := &in.VolumeStatsAggPeriod, &out.VolumeStatsAggPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.FailSwapOn != nil {
		in, out := &in.FailSwapOn, &out.FailSwapOn
		*out = new(bool)
		**out = **in
	}
	if in.ExperimentalAllowedUnsafeSysctls != nil {
		in, out := &in.ExperimentalAllowedUnsafeSysctls, &out.ExperimentalAllowedUnsafeSysctls
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AllowedUnsafeSysctls != nil {
		in, out := &in.AllowedUnsafeSysctls, &out.AllowedUnsafeSysctls
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.StreamingConnectionIdleTimeout != nil {
		in, out := &in.StreamingConnectionIdleTimeout, &out.StreamingConnectionIdleTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.DockerDisableSharedPID != nil {
		in, out := &in.DockerDisableSharedPID, &out.DockerDisableSharedPID
		*out = new(bool)
		**out = **in
	}
	if in.AuthenticationTokenWebhook != nil {
		in, out := &in.AuthenticationTokenWebhook, &out.AuthenticationTokenWebhook
		*out = new(bool)
		**out = **in
	}
	if in.AuthenticationTokenWebhookCacheTTL != nil {
		in, out := &in.AuthenticationTokenWebhookCacheTTL, &out.AuthenticationTokenWebhookCacheTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.CPUCFSQuota != nil {
		in, out := &in.CPUCFSQuota, &out.CPUCFSQuota
		*out = new(bool)
		**out = **in
	}
	if in.CPUCFSQuotaPeriod != nil {
		in, out := &in.CPUCFSQuotaPeriod, &out.CPUCFSQuotaPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.RegistryPullQPS != nil {
		in, out := &in.RegistryPullQPS, &out.RegistryPullQPS
		*out = new(int32)
		**out = **in
	}
	if in.RegistryBurst != nil {
		in, out := &in.RegistryBurst, &out.RegistryBurst
		*out = new(int32)
		**out = **in
	}
	if in.RotateCertificates != nil {
		in, out := &in.RotateCertificates, &out.RotateCertificates
		*out = new(bool)
		**out = **in
	}
	if in.ProtectKernelDefaults != nil {
		in, out := &in.ProtectKernelDefaults, &out.ProtectKernelDefaults
		*out = new(bool)
		**out = **in
	}
	if in.HousekeepingInterval != nil {
		in, out := &in.HousekeepingInterval, &out.HousekeepingInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.EventQPS != nil {
		in, out := &in.EventQPS, &out.EventQPS
		*out = new(int32)
		**out = **in
	}
	if in.EventBurst != nil {
		in, out := &in.EventBurst, &out.EventBurst
		*out = new(int32)
		**out = **in
	}
	if in.ContainerLogMaxFiles != nil {
		in, out := &in.ContainerLogMaxFiles, &out.ContainerLogMaxFiles
		*out = new(int32)
		**out = **in
	}
	if in.EnableCadvisorJsonEndpoints != nil {
		in, out := &in.EnableCadvisorJsonEndpoints, &out.EnableCadvisorJsonEndpoints
		*out = new(bool)
		**out = **in
	}
	if in.PodPidsLimit != nil {
		in, out := &in.PodPidsLimit, &out.PodPidsLimit
		*out = new(int64)
		**out = **in
	}
	if in.ShutdownGracePeriod != nil {
		in, out := &in.ShutdownGracePeriod, &out.ShutdownGracePeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.ShutdownGracePeriodCriticalPods != nil {
		in, out := &in.ShutdownGracePeriodCriticalPods, &out.ShutdownGracePeriodCriticalPods
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeletConfigSpec.
func (in *KubeletConfigSpec) DeepCopy() *KubeletConfigSpec {
	if in == nil {
		return nil
	}
	out := new(KubeletConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubenetNetworkingSpec) DeepCopyInto(out *KubenetNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubenetNetworkingSpec.
func (in *KubenetNetworkingSpec) DeepCopy() *KubenetNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KubenetNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KuberouterNetworkingSpec) DeepCopyInto(out *KuberouterNetworkingSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KuberouterNetworkingSpec.
func (in *KuberouterNetworkingSpec) DeepCopy() *KuberouterNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(KuberouterNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LeaderElectionConfiguration) DeepCopyInto(out *LeaderElectionConfiguration) {
	*out = *in
	if in.LeaderElect != nil {
		in, out := &in.LeaderElect, &out.LeaderElect
		*out = new(bool)
		**out = **in
	}
	if in.LeaderElectLeaseDuration != nil {
		in, out := &in.LeaderElectLeaseDuration, &out.LeaderElectLeaseDuration
		*out = new(v1.Duration)
		**out = **in
	}
	if in.LeaderElectRenewDeadlineDuration != nil {
		in, out := &in.LeaderElectRenewDeadlineDuration, &out.LeaderElectRenewDeadlineDuration
		*out = new(v1.Duration)
		**out = **in
	}
	if in.LeaderElectResourceLock != nil {
		in, out := &in.LeaderElectResourceLock, &out.LeaderElectResourceLock
		*out = new(string)
		**out = **in
	}
	if in.LeaderElectResourceName != nil {
		in, out := &in.LeaderElectResourceName, &out.LeaderElectResourceName
		*out = new(string)
		**out = **in
	}
	if in.LeaderElectResourceNamespace != nil {
		in, out := &in.LeaderElectResourceNamespace, &out.LeaderElectResourceNamespace
		*out = new(string)
		**out = **in
	}
	if in.LeaderElectRetryPeriod != nil {
		in, out := &in.LeaderElectRetryPeriod, &out.LeaderElectRetryPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LeaderElectionConfiguration.
func (in *LeaderElectionConfiguration) DeepCopy() *LeaderElectionConfiguration {
	if in == nil {
		return nil
	}
	out := new(LeaderElectionConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancer) DeepCopyInto(out *LoadBalancer) {
	*out = *in
	if in.LoadBalancerName != nil {
		in, out := &in.LoadBalancerName, &out.LoadBalancerName
		*out = new(string)
		**out = **in
	}
	if in.TargetGroupARN != nil {
		in, out := &in.TargetGroupARN, &out.TargetGroupARN
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancer.
func (in *LoadBalancer) DeepCopy() *LoadBalancer {
	if in == nil {
		return nil
	}
	out := new(LoadBalancer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancerAccessSpec) DeepCopyInto(out *LoadBalancerAccessSpec) {
	*out = *in
	if in.IdleTimeoutSeconds != nil {
		in, out := &in.IdleTimeoutSeconds, &out.IdleTimeoutSeconds
		*out = new(int64)
		**out = **in
	}
	if in.SecurityGroupOverride != nil {
		in, out := &in.SecurityGroupOverride, &out.SecurityGroupOverride
		*out = new(string)
		**out = **in
	}
	if in.AdditionalSecurityGroups != nil {
		in, out := &in.AdditionalSecurityGroups, &out.AdditionalSecurityGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SSLPolicy != nil {
		in, out := &in.SSLPolicy, &out.SSLPolicy
		*out = new(string)
		**out = **in
	}
	if in.CrossZoneLoadBalancing != nil {
		in, out := &in.CrossZoneLoadBalancing, &out.CrossZoneLoadBalancing
		*out = new(bool)
		**out = **in
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]LoadBalancerSubnetSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AccessLog != nil {
		in, out := &in.AccessLog, &out.AccessLog
		*out = new(AccessLogSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancerAccessSpec.
func (in *LoadBalancerAccessSpec) DeepCopy() *LoadBalancerAccessSpec {
	if in == nil {
		return nil
	}
	out := new(LoadBalancerAccessSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancerSubnetSpec) DeepCopyInto(out *LoadBalancerSubnetSpec) {
	*out = *in
	if in.PrivateIPv4Address != nil {
		in, out := &in.PrivateIPv4Address, &out.PrivateIPv4Address
		*out = new(string)
		**out = **in
	}
	if in.AllocationID != nil {
		in, out := &in.AllocationID, &out.AllocationID
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancerSubnetSpec.
func (in *LoadBalancerSubnetSpec) DeepCopy() *LoadBalancerSubnetSpec {
	if in == nil {
		return nil
	}
	out := new(LoadBalancerSubnetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MetricsServerConfig) DeepCopyInto(out *MetricsServerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.Insecure != nil {
		in, out := &in.Insecure, &out.Insecure
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MetricsServerConfig.
func (in *MetricsServerConfig) DeepCopy() *MetricsServerConfig {
	if in == nil {
		return nil
	}
	out := new(MetricsServerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MixedInstancesPolicySpec) DeepCopyInto(out *MixedInstancesPolicySpec) {
	*out = *in
	if in.Instances != nil {
		in, out := &in.Instances, &out.Instances
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.OnDemandAllocationStrategy != nil {
		in, out := &in.OnDemandAllocationStrategy, &out.OnDemandAllocationStrategy
		*out = new(string)
		**out = **in
	}
	if in.OnDemandBase != nil {
		in, out := &in.OnDemandBase, &out.OnDemandBase
		*out = new(int64)
		**out = **in
	}
	if in.OnDemandAboveBase != nil {
		in, out := &in.OnDemandAboveBase, &out.OnDemandAboveBase
		*out = new(int64)
		**out = **in
	}
	if in.SpotAllocationStrategy != nil {
		in, out := &in.SpotAllocationStrategy, &out.SpotAllocationStrategy
		*out = new(string)
		**out = **in
	}
	if in.SpotInstancePools != nil {
		in, out := &in.SpotInstancePools, &out.SpotInstancePools
		*out = new(int64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MixedInstancesPolicySpec.
func (in *MixedInstancesPolicySpec) DeepCopy() *MixedInstancesPolicySpec {
	if in == nil {
		return nil
	}
	out := new(MixedInstancesPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NTPConfig) DeepCopyInto(out *NTPConfig) {
	*out = *in
	if in.Managed != nil {
		in, out := &in.Managed, &out.Managed
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NTPConfig.
func (in *NTPConfig) DeepCopy() *NTPConfig {
	if in == nil {
		return nil
	}
	out := new(NTPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkingSpec) DeepCopyInto(out *NetworkingSpec) {
	*out = *in
	if in.Classic != nil {
		in, out := &in.Classic, &out.Classic
		*out = new(kops.ClassicNetworkingSpec)
		**out = **in
	}
	if in.Kubenet != nil {
		in, out := &in.Kubenet, &out.Kubenet
		*out = new(KubenetNetworkingSpec)
		**out = **in
	}
	if in.External != nil {
		in, out := &in.External, &out.External
		*out = new(ExternalNetworkingSpec)
		**out = **in
	}
	if in.CNI != nil {
		in, out := &in.CNI, &out.CNI
		*out = new(CNINetworkingSpec)
		**out = **in
	}
	if in.Kopeio != nil {
		in, out := &in.Kopeio, &out.Kopeio
		*out = new(KopeioNetworkingSpec)
		**out = **in
	}
	if in.Weave != nil {
		in, out := &in.Weave, &out.Weave
		*out = new(WeaveNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Flannel != nil {
		in, out := &in.Flannel, &out.Flannel
		*out = new(FlannelNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Calico != nil {
		in, out := &in.Calico, &out.Calico
		*out = new(CalicoNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Canal != nil {
		in, out := &in.Canal, &out.Canal
		*out = new(CanalNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Kuberouter != nil {
		in, out := &in.Kuberouter, &out.Kuberouter
		*out = new(KuberouterNetworkingSpec)
		**out = **in
	}
	if in.Romana != nil {
		in, out := &in.Romana, &out.Romana
		*out = new(kops.RomanaNetworkingSpec)
		**out = **in
	}
	if in.AmazonVPC != nil {
		in, out := &in.AmazonVPC, &out.AmazonVPC
		*out = new(AmazonVPCNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Cilium != nil {
		in, out := &in.Cilium, &out.Cilium
		*out = new(CiliumNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.LyftVPC != nil {
		in, out := &in.LyftVPC, &out.LyftVPC
		*out = new(kops.LyftVPCNetworkingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.GCE != nil {
		in, out := &in.GCE, &out.GCE
		*out = new(GCENetworkingSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkingSpec.
func (in *NetworkingSpec) DeepCopy() *NetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(NetworkingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeLocalDNSConfig) DeepCopyInto(out *NodeLocalDNSConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.ForwardToKubeDNS != nil {
		in, out := &in.ForwardToKubeDNS, &out.ForwardToKubeDNS
		*out = new(bool)
		**out = **in
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeLocalDNSConfig.
func (in *NodeLocalDNSConfig) DeepCopy() *NodeLocalDNSConfig {
	if in == nil {
		return nil
	}
	out := new(NodeLocalDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeProblemDetectorConfig) DeepCopyInto(out *NodeProblemDetectorConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPULimit != nil {
		in, out := &in.CPULimit, &out.CPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeProblemDetectorConfig.
func (in *NodeProblemDetectorConfig) DeepCopy() *NodeProblemDetectorConfig {
	if in == nil {
		return nil
	}
	out := new(NodeProblemDetectorConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeTerminationHandlerConfig) DeepCopyInto(out *NodeTerminationHandlerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	if in.EnableSpotInterruptionDraining != nil {
		in, out := &in.EnableSpotInterruptionDraining, &out.EnableSpotInterruptionDraining
		*out = new(bool)
		**out = **in
	}
	if in.EnableScheduledEventDraining != nil {
		in, out := &in.EnableScheduledEventDraining, &out.EnableScheduledEventDraining
		*out = new(bool)
		**out = **in
	}
	if in.EnableRebalanceMonitoring != nil {
		in, out := &in.EnableRebalanceMonitoring, &out.EnableRebalanceMonitoring
		*out = new(bool)
		**out = **in
	}
	if in.EnableRebalanceDraining != nil {
		in, out := &in.EnableRebalanceDraining, &out.EnableRebalanceDraining
		*out = new(bool)
		**out = **in
	}
	if in.EnablePrometheusMetrics != nil {
		in, out := &in.EnablePrometheusMetrics, &out.EnablePrometheusMetrics
		*out = new(bool)
		**out = **in
	}
	if in.EnableSQSTerminationDraining != nil {
		in, out := &in.EnableSQSTerminationDraining, &out.EnableSQSTerminationDraining
		*out = new(bool)
		**out = **in
	}
	if in.ManagedASGTag != nil {
		in, out := &in.ManagedASGTag, &out.ManagedASGTag
		*out = new(string)
		**out = **in
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeTerminationHandlerConfig.
func (in *NodeTerminationHandlerConfig) DeepCopy() *NodeTerminationHandlerConfig {
	if in == nil {
		return nil
	}
	out := new(NodeTerminationHandlerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NvidiaGPUConfig) DeepCopyInto(out *NvidiaGPUConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NvidiaGPUConfig.
func (in *NvidiaGPUConfig) DeepCopy() *NvidiaGPUConfig {
	if in == nil {
		return nil
	}
	out := new(NvidiaGPUConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackBlockStorageConfig) DeepCopyInto(out *OpenstackBlockStorageConfig) {
	*out = *in
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	if in.IgnoreAZ != nil {
		in, out := &in.IgnoreAZ, &out.IgnoreAZ
		*out = new(bool)
		**out = **in
	}
	if in.OverrideAZ != nil {
		in, out := &in.OverrideAZ, &out.OverrideAZ
		*out = new(string)
		**out = **in
	}
	if in.CreateStorageClass != nil {
		in, out := &in.CreateStorageClass, &out.CreateStorageClass
		*out = new(bool)
		**out = **in
	}
	if in.CSITopologySupport != nil {
		in, out := &in.CSITopologySupport, &out.CSITopologySupport
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackBlockStorageConfig.
func (in *OpenstackBlockStorageConfig) DeepCopy() *OpenstackBlockStorageConfig {
	if in == nil {
		return nil
	}
	out := new(OpenstackBlockStorageConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackConfiguration) DeepCopyInto(out *OpenstackConfiguration) {
	*out = *in
	if in.Loadbalancer != nil {
		in, out := &in.Loadbalancer, &out.Loadbalancer
		*out = new(OpenstackLoadbalancerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Monitor != nil {
		in, out := &in.Monitor, &out.Monitor
		*out = new(OpenstackMonitor)
		(*in).DeepCopyInto(*out)
	}
	if in.Router != nil {
		in, out := &in.Router, &out.Router
		*out = new(OpenstackRouter)
		(*in).DeepCopyInto(*out)
	}
	if in.BlockStorage != nil {
		in, out := &in.BlockStorage, &out.BlockStorage
		*out = new(OpenstackBlockStorageConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.InsecureSkipVerify != nil {
		in, out := &in.InsecureSkipVerify, &out.InsecureSkipVerify
		*out = new(bool)
		**out = **in
	}
	if in.Network != nil {
		in, out := &in.Network, &out.Network
		*out = new(OpenstackNetwork)
		(*in).DeepCopyInto(*out)
	}
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(OpenstackMetadata)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackConfiguration.
func (in *OpenstackConfiguration) DeepCopy() *OpenstackConfiguration {
	if in == nil {
		return nil
	}
	out := new(OpenstackConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackLoadbalancerConfig) DeepCopyInto(out *OpenstackLoadbalancerConfig) {
	*out = *in
	if in.Method != nil {
		in, out := &in.Method, &out.Method
		*out = new(string)
		**out = **in
	}
	if in.Provider != nil {
		in, out := &in.Provider, &out.Provider
		*out = new(string)
		**out = **in
	}
	if in.UseOctavia != nil {
		in, out := &in.UseOctavia, &out.UseOctavia
		*out = new(bool)
		**out = **in
	}
	if in.FloatingNetwork != nil {
		in, out := &in.FloatingNetwork, &out.FloatingNetwork
		*out = new(string)
		**out = **in
	}
	if in.FloatingNetworkID != nil {
		in, out := &in.FloatingNetworkID, &out.FloatingNetworkID
		*out = new(string)
		**out = **in
	}
	if in.FloatingSubnet != nil {
		in, out := &in.FloatingSubnet, &out.FloatingSubnet
		*out = new(string)
		**out = **in
	}
	if in.SubnetID != nil {
		in, out := &in.SubnetID, &out.SubnetID
		*out = new(string)
		**out = **in
	}
	if in.ManageSecGroups != nil {
		in, out := &in.ManageSecGroups, &out.ManageSecGroups
		*out = new(bool)
		**out = **in
	}
	if in.EnableIngressHostname != nil {
		in, out := &in.EnableIngressHostname, &out.EnableIngressHostname
		*out = new(bool)
		**out = **in
	}
	if in.IngressHostnameSuffix != nil {
		in, out := &in.IngressHostnameSuffix, &out.IngressHostnameSuffix
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackLoadbalancerConfig.
func (in *OpenstackLoadbalancerConfig) DeepCopy() *OpenstackLoadbalancerConfig {
	if in == nil {
		return nil
	}
	out := new(OpenstackLoadbalancerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackMetadata) DeepCopyInto(out *OpenstackMetadata) {
	*out = *in
	if in.ConfigDrive != nil {
		in, out := &in.ConfigDrive, &out.ConfigDrive
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackMetadata.
func (in *OpenstackMetadata) DeepCopy() *OpenstackMetadata {
	if in == nil {
		return nil
	}
	out := new(OpenstackMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackMonitor) DeepCopyInto(out *OpenstackMonitor) {
	*out = *in
	if in.Delay != nil {
		in, out := &in.Delay, &out.Delay
		*out = new(string)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(string)
		**out = **in
	}
	if in.MaxRetries != nil {
		in, out := &in.MaxRetries, &out.MaxRetries
		*out = new(int)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackMonitor.
func (in *OpenstackMonitor) DeepCopy() *OpenstackMonitor {
	if in == nil {
		return nil
	}
	out := new(OpenstackMonitor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackNetwork) DeepCopyInto(out *OpenstackNetwork) {
	*out = *in
	if in.AvailabilityZoneHints != nil {
		in, out := &in.AvailabilityZoneHints, &out.AvailabilityZoneHints
		*out = make([]*string, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(string)
				**out = **in
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackNetwork.
func (in *OpenstackNetwork) DeepCopy() *OpenstackNetwork {
	if in == nil {
		return nil
	}
	out := new(OpenstackNetwork)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenstackRouter) DeepCopyInto(out *OpenstackRouter) {
	*out = *in
	if in.ExternalNetwork != nil {
		in, out := &in.ExternalNetwork, &out.ExternalNetwork
		*out = new(string)
		**out = **in
	}
	if in.DNSServers != nil {
		in, out := &in.DNSServers, &out.DNSServers
		*out = new(string)
		**out = **in
	}
	if in.ExternalSubnet != nil {
		in, out := &in.ExternalSubnet, &out.ExternalSubnet
		*out = new(string)
		**out = **in
	}
	if in.AvailabilityZoneHints != nil {
		in, out := &in.AvailabilityZoneHints, &out.AvailabilityZoneHints
		*out = make([]*string, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(string)
				**out = **in
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenstackRouter.
func (in *OpenstackRouter) DeepCopy() *OpenstackRouter {
	if in == nil {
		return nil
	}
	out := new(OpenstackRouter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PackagesConfig) DeepCopyInto(out *PackagesConfig) {
	*out = *in
	if in.HashAmd64 != nil {
		in, out := &in.HashAmd64, &out.HashAmd64
		*out = new(string)
		**out = **in
	}
	if in.HashArm64 != nil {
		in, out := &in.HashArm64, &out.HashArm64
		*out = new(string)
		**out = **in
	}
	if in.UrlAmd64 != nil {
		in, out := &in.UrlAmd64, &out.UrlAmd64
		*out = new(string)
		**out = **in
	}
	if in.UrlArm64 != nil {
		in, out := &in.UrlArm64, &out.UrlArm64
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PackagesConfig.
func (in *PackagesConfig) DeepCopy() *PackagesConfig {
	if in == nil {
		return nil
	}
	out := new(PackagesConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodIdentityWebhookConfig) DeepCopyInto(out *PodIdentityWebhookConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodIdentityWebhookConfig.
func (in *PodIdentityWebhookConfig) DeepCopy() *PodIdentityWebhookConfig {
	if in == nil {
		return nil
	}
	out := new(PodIdentityWebhookConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RBACAuthorizationSpec) DeepCopyInto(out *RBACAuthorizationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RBACAuthorizationSpec.
func (in *RBACAuthorizationSpec) DeepCopy() *RBACAuthorizationSpec {
	if in == nil {
		return nil
	}
	out := new(RBACAuthorizationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RollingUpdate) DeepCopyInto(out *RollingUpdate) {
	*out = *in
	if in.DrainAndTerminate != nil {
		in, out := &in.DrainAndTerminate, &out.DrainAndTerminate
		*out = new(bool)
		**out = **in
	}
	if in.MaxUnavailable != nil {
		in, out := &in.MaxUnavailable, &out.MaxUnavailable
		*out = new(intstr.IntOrString)
		**out = **in
	}
	if in.MaxSurge != nil {
		in, out := &in.MaxSurge, &out.MaxSurge
		*out = new(intstr.IntOrString)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RollingUpdate.
func (in *RollingUpdate) DeepCopy() *RollingUpdate {
	if in == nil {
		return nil
	}
	out := new(RollingUpdate)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredential) DeepCopyInto(out *SSHCredential) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredential.
func (in *SSHCredential) DeepCopy() *SSHCredential {
	if in == nil {
		return nil
	}
	out := new(SSHCredential)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SSHCredential) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredentialList) DeepCopyInto(out *SSHCredentialList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SSHCredential, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredentialList.
func (in *SSHCredentialList) DeepCopy() *SSHCredentialList {
	if in == nil {
		return nil
	}
	out := new(SSHCredentialList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SSHCredentialList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SSHCredentialSpec) DeepCopyInto(out *SSHCredentialSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SSHCredentialSpec.
func (in *SSHCredentialSpec) DeepCopy() *SSHCredentialSpec {
	if in == nil {
		return nil
	}
	out := new(SSHCredentialSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceAccountExternalPermission) DeepCopyInto(out *ServiceAccountExternalPermission) {
	*out = *in
	if in.AWS != nil {
		in, out := &in.AWS, &out.AWS
		*out = new(AWSPermission)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceAccountExternalPermission.
func (in *ServiceAccountExternalPermission) DeepCopy() *ServiceAccountExternalPermission {
	if in == nil {
		return nil
	}
	out := new(ServiceAccountExternalPermission)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceAccountIssuerDiscoveryConfig) DeepCopyInto(out *ServiceAccountIssuerDiscoveryConfig) {
	*out = *in
	if in.AdditionalAudiences != nil {
		in, out := &in.AdditionalAudiences, &out.AdditionalAudiences
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceAccountIssuerDiscoveryConfig.
func (in *ServiceAccountIssuerDiscoveryConfig) DeepCopy() *ServiceAccountIssuerDiscoveryConfig {
	if in == nil {
		return nil
	}
	out := new(ServiceAccountIssuerDiscoveryConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotControllerConfig) DeepCopyInto(out *SnapshotControllerConfig) {
	*out = *in
	if in.Enabled != nil {
		in, out := &in.Enabled, &out.Enabled
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotControllerConfig.
func (in *SnapshotControllerConfig) DeepCopy() *SnapshotControllerConfig {
	if in == nil {
		return nil
	}
	out := new(SnapshotControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TargetSpec) DeepCopyInto(out *TargetSpec) {
	*out = *in
	if in.Terraform != nil {
		in, out := &in.Terraform, &out.Terraform
		*out = new(TerraformSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TargetSpec.
func (in *TargetSpec) DeepCopy() *TargetSpec {
	if in == nil {
		return nil
	}
	out := new(TargetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TerraformSpec) DeepCopyInto(out *TerraformSpec) {
	*out = *in
	if in.ProviderExtraConfig != nil {
		in, out := &in.ProviderExtraConfig, &out.ProviderExtraConfig
		*out = new(map[string]string)
		if **in != nil {
			in, out := *in, *out
			*out = make(map[string]string, len(*in))
			for key, val := range *in {
				(*out)[key] = val
			}
		}
	}
	if in.FilesProviderExtraConfig != nil {
		in, out := &in.FilesProviderExtraConfig, &out.FilesProviderExtraConfig
		*out = new(map[string]string)
		if **in != nil {
			in, out := *in, *out
			*out = make(map[string]string, len(*in))
			for key, val := range *in {
				(*out)[key] = val
			}
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TerraformSpec.
func (in *TerraformSpec) DeepCopy() *TerraformSpec {
	if in == nil {
		return nil
	}
	out := new(TerraformSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TopologySpec) DeepCopyInto(out *TopologySpec) {
	*out = *in
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		*out = new(BastionSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.DNS != nil {
		in, out := &in.DNS, &out.DNS
		*out = new(DNSSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TopologySpec.
func (in *TopologySpec) DeepCopy() *TopologySpec {
	if in == nil {
		return nil
	}
	out := new(TopologySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserData) DeepCopyInto(out *UserData) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserData.
func (in *UserData) DeepCopy() *UserData {
	if in == nil {
		return nil
	}
	out := new(UserData)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeMountSpec) DeepCopyInto(out *VolumeMountSpec) {
	*out = *in
	if in.FormatOptions != nil {
		in, out := &in.FormatOptions, &out.FormatOptions
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MountOptions != nil {
		in, out := &in.MountOptions, &out.MountOptions
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeMountSpec.
func (in *VolumeMountSpec) DeepCopy() *VolumeMountSpec {
	if in == nil {
		return nil
	}
	out := new(VolumeMountSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VolumeSpec) DeepCopyInto(out *VolumeSpec) {
	*out = *in
	if in.DeleteOnTermination != nil {
		in, out := &in.DeleteOnTermination, &out.DeleteOnTermination
		*out = new(bool)
		**out = **in
	}
	if in.Encrypted != nil {
		in, out := &in.Encrypted, &out.Encrypted
		*out = new(bool)
		**out = **in
	}
	if in.IOPS != nil {
		in, out := &in.IOPS, &out.IOPS
		*out = new(int64)
		**out = **in
	}
	if in.Throughput != nil {
		in, out := &in.Throughput, &out.Throughput
		*out = new(int64)
		**out = **in
	}
	if in.Key != nil {
		in, out := &in.Key, &out.Key
		*out = new(string)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VolumeSpec.
func (in *VolumeSpec) DeepCopy() *VolumeSpec {
	if in == nil {
		return nil
	}
	out := new(VolumeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WarmPoolSpec) DeepCopyInto(out *WarmPoolSpec) {
	*out = *in
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		*out = new(int64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WarmPoolSpec.
func (in *WarmPoolSpec) DeepCopy() *WarmPoolSpec {
	if in == nil {
		return nil
	}
	out := new(WarmPoolSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WeaveNetworkingSpec) DeepCopyInto(out *WeaveNetworkingSpec) {
	*out = *in
	if in.MTU != nil {
		in, out := &in.MTU, &out.MTU
		*out = new(int32)
		**out = **in
	}
	if in.ConnLimit != nil {
		in, out := &in.ConnLimit, &out.ConnLimit
		*out = new(int32)
		**out = **in
	}
	if in.NoMasqLocal != nil {
		in, out := &in.NoMasqLocal, &out.NoMasqLocal
		*out = new(int32)
		**out = **in
	}
	if in.MemoryRequest != nil {
		in, out := &in.MemoryRequest, &out.MemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPURequest != nil {
		in, out := &in.CPURequest, &out.CPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MemoryLimit != nil {
		in, out := &in.MemoryLimit, &out.MemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.CPULimit != nil {
		in, out := &in.CPULimit, &out.CPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.NPCMemoryRequest != nil {
		in, out := &in.NPCMemoryRequest, &out.NPCMemoryRequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.NPCCPURequest != nil {
		in, out := &in.NPCCPURequest, &out.NPCCPURequest
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.NPCMemoryLimit != nil {
		in, out := &in.NPCMemoryLimit, &out.NPCMemoryLimit
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.NPCCPULimit != nil {
		in, out := &in.NPCCPULimit, &out.NPCCPULimit
		x := (*in).DeepCopy()
		*out = &x
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WeaveNetworkingSpec.
func (in *WeaveNetworkingSpec) DeepCopy() *WeaveNetworkingSpec {
	if in == nil {
		return nil
	}
	out := new(WeaveNetworkingSpec)
	in.DeepCopyInto(out)
	return out
}
