## Release notes for kOps 1.23 series

**&#9888; kOps 1.23 has not been released yet! &#9888;**

This is a document to gather the release notes prior to the release.

# Significant changes

## Other significant changes

* If the Kubernetes version is 1.23 or later and the external AWS Cloud Controller Manager is
being used, then Kubernetes Node resources will be named after their AWS instance ID instead of their domain name.

* Support for [ShutdownGracePeriod and ShutdownGracePeriodCriticalPods](https://kubernetes.io/blog/2021/04/21/graceful-node-shutdown-beta/). By default, kOps will set ShutdownGracePeriod to 30 seconds and ShutdownGracePeriodCriticalPods to 10 seconds if the Kubernetes version is above 1.21.

# Breaking changes

* Support for Kubernetes version 1.17 has been removed.

* Support for the Lyft CNI has been removed.

* The Weave CNI is not supported for Kubernetes 1.23 or later.

* Support for CentOS 7 has been removed.

* Support for CentOS 8 has been removed.

* Support for Debian 9 has been removed.

* Support for RHEL 7 is has been removed.

* Support for Ubuntu 16.04 (Xenial) has been removed.

* Support for Ubuntu 18.04 (Bionic) has been removed.

* Cilium now has `disable-cnp-status-updates: true` by default. Set this to false if you rely on the CiliumNetworkPolicy status fields.

# Required actions

# Deprecations

* Support for Kubernetes version 1.18 is deprecated and will be removed in kOps 1.24.

* Support for Kubernetes version 1.19 is deprecated and will be removed in kOps 1.25.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and might be removed from control plane nodes in future versions of kOps.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this cloud provider.

* Due to lack of maintainers, the CloudFormation support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this target.

# Other changes of note

* The `kops create cluster` command has a new `--discovery-store` flag for specifying a public store for the OIDC-compatible discovery documents.
If this flag is used in AWS, it will enable IRSA.

* If `externalDns.provider` is `external-dns`, then `externalDns.watchIngress` will now default to `true`.

* The `kops rolling-update cluster` command has a new `--drain-timeout` flag for specifying the maximum amount of time to wait when attempting to drain a node. Previously, rolling-updates would attempt to drain a node for an indefinite amount of time. If `--drain-timeout` is not specified, a default of 15 minutes is applied.

* Fix inconsistent output of `kops get clusters -ojson`. This will now always return a list (irrespective of a single or multiple clusters) to keep the format consistent. However, note that `kops get cluster dev.example.com -ojson` will continue to work as previously, and will return a single object.

* Digital Ocean kops now has vpc support. You can specify a `network-cidr` range while creating the kops cluster. kops resources will be created in the new vpc range. Also supports shared vpc; you can specify the vpc uuid while creating kops cluster.

# Full change list since 1.22.0 release


## 1.23.0-alpha.1 to 1.23.0-alpha.2

* Release 1.22.0-beta.1 [@johngmyers](https://github.com/johngmyers) [#12211](https://github.com/kubernetes/kops/pull/12211)
* Revert "Release 1.22.0-beta.1" [@johngmyers](https://github.com/johngmyers) [#12213](https://github.com/kubernetes/kops/pull/12213)
* Release 1.23.0-alpha.1 [@johngmyers](https://github.com/johngmyers) [#12210](https://github.com/kubernetes/kops/pull/12210)
* [addons/metrics-server] Bump minor version [@dntosas](https://github.com/dntosas) [#12198](https://github.com/kubernetes/kops/pull/12198)
* Release notes for 1.22.0-beta.1  [@johngmyers](https://github.com/johngmyers) [#12216](https://github.com/kubernetes/kops/pull/12216)
* Remove code for unsupported features [@johngmyers](https://github.com/johngmyers) [#12218](https://github.com/kubernetes/kops/pull/12218)
* Bump cloudbuild images to latest [@rifelpet](https://github.com/rifelpet) [#12222](https://github.com/kubernetes/kops/pull/12222)
* Fix new staticcheck errors [@burntcarrot](https://github.com/burntcarrot) [#12215](https://github.com/kubernetes/kops/pull/12215)
* Move bootstrap RBAC from protokube to core bootstrap addon [@johngmyers](https://github.com/johngmyers) [#12221](https://github.com/kubernetes/kops/pull/12221)
* Update staticcheck to latest [@rifelpet](https://github.com/rifelpet) [#12224](https://github.com/kubernetes/kops/pull/12224)
* [Documentation update] Note for the metrics configuration for etcd [@recollir](https://github.com/recollir) [#12223](https://github.com/kubernetes/kops/pull/12223)
* fix parse semver [@zetaab](https://github.com/zetaab) [#12227](https://github.com/kubernetes/kops/pull/12227)
* check does iface has associations [@zetaab](https://github.com/zetaab) [#12232](https://github.com/kubernetes/kops/pull/12232)
* Bump cert-manager to 1.5.3 [@olemarkus](https://github.com/olemarkus) [#12229](https://github.com/kubernetes/kops/pull/12229)
* Fix etcd3-migration docs link [@RetWolf](https://github.com/RetWolf) [#12238](https://github.com/kubernetes/kops/pull/12238)
* Update metrics-server tag used in e2e scenario [@rifelpet](https://github.com/rifelpet) [#12239](https://github.com/kubernetes/kops/pull/12239)
* Bump node termination handler to 1.13.3 [@olemarkus](https://github.com/olemarkus) [#12237](https://github.com/kubernetes/kops/pull/12237)
* [addons/node-local-dns] Bump version and make image field configurable [@dntosas](https://github.com/dntosas) [#12219](https://github.com/kubernetes/kops/pull/12219)
* Set kube-apiserver as default logs container [@olemarkus](https://github.com/olemarkus) [#12246](https://github.com/kubernetes/kops/pull/12246)
* Enable protect-kernel-defaults by default and set the correct sysctls in nodeup [@olemarkus](https://github.com/olemarkus) [#12193](https://github.com/kubernetes/kops/pull/12193)
* Use node internal IP for metrics-server [@olemarkus](https://github.com/olemarkus) [#12260](https://github.com/kubernetes/kops/pull/12260)
* Set ipv6 nameservers on aws [@olemarkus](https://github.com/olemarkus) [#12259](https://github.com/kubernetes/kops/pull/12259)
* Set NodeIPFamilies in ipv6 mode [@olemarkus](https://github.com/olemarkus) [#12258](https://github.com/kubernetes/kops/pull/12258)
* Disable masquerade means disable masquerade if ipv6 too [@olemarkus](https://github.com/olemarkus) [#12265](https://github.com/kubernetes/kops/pull/12265)
* Update controller-runtime to v0.9.7 [@hakman](https://github.com/hakman) [#12264](https://github.com/kubernetes/kops/pull/12264)
* Try to bootstrap when at least one IP is available [@hakman](https://github.com/hakman) [#12270](https://github.com/kubernetes/kops/pull/12270)
* Fix core manifest [@olemarkus](https://github.com/olemarkus) [#12268](https://github.com/kubernetes/kops/pull/12268)
* update openstack CSI [@zetaab](https://github.com/zetaab) [#12251](https://github.com/kubernetes/kops/pull/12251)
* Fix bootstrap when at least one IP is available [@hakman](https://github.com/hakman) [#12273](https://github.com/kubernetes/kops/pull/12273)
* Fix kernel parameter for IPv6 forwarding [@hakman](https://github.com/hakman) [#12271](https://github.com/kubernetes/kops/pull/12271)
* Dump external-dns and dns-controller pod logs [@rifelpet](https://github.com/rifelpet) [#12276](https://github.com/kubernetes/kops/pull/12276)
* Add .log suffix to dumped pod logs [@rifelpet](https://github.com/rifelpet) [#12278](https://github.com/kubernetes/kops/pull/12278)
* Add support --kernel-memcg-notification Kubelet flag [@hakman](https://github.com/hakman) [#12267](https://github.com/kubernetes/kops/pull/12267)
* Set explicit fsType to be able to mount volumes [@pa1op](https://github.com/pa1op) [#12280](https://github.com/kubernetes/kops/pull/12280)
* dev: hack/update-expected script should clear KOPS_ARCH [@justinsb](https://github.com/justinsb) [#12283](https://github.com/kubernetes/kops/pull/12283)
* Add helper to convert kubemanifest.Object to unstructured [@justinsb](https://github.com/justinsb) [#12284](https://github.com/kubernetes/kops/pull/12284)
* Add notes and docs on external-dns [@olemarkus](https://github.com/olemarkus) [#12279](https://github.com/kubernetes/kops/pull/12279)
* use ipip Always by default in OpenStack [@zetaab](https://github.com/zetaab) [#12286](https://github.com/kubernetes/kops/pull/12286)
* Include kops- prefix in external-dns TXT record [@rifelpet](https://github.com/rifelpet) [#12289](https://github.com/kubernetes/kops/pull/12289)
* External dns fixes [@olemarkus](https://github.com/olemarkus) [#12288](https://github.com/kubernetes/kops/pull/12288)
* Do not set ClusterCIDR for KubeProxy when using CNI networking and kubeProxy.clusterCIDR is not set [@dezmodue](https://github.com/dezmodue) [#12207](https://github.com/kubernetes/kops/pull/12207)
* Update AWS CCM tags [@rifelpet](https://github.com/rifelpet) [#12104](https://github.com/kubernetes/kops/pull/12104)
* Enable IMDS IPv6 endpoint [@rifelpet](https://github.com/rifelpet) [#12290](https://github.com/kubernetes/kops/pull/12290)
* Note about breaking change for apiserver files [@olemarkus](https://github.com/olemarkus) [#12294](https://github.com/kubernetes/kops/pull/12294)
* Use MasterInternalName for gossip cluster SA issuer [@rifelpet](https://github.com/rifelpet) [#12297](https://github.com/kubernetes/kops/pull/12297)
* [kubelet] Add validation for cpuCFSQuotaPeriod after k8s>=1.20 [@dntosas](https://github.com/dntosas) [#12292](https://github.com/kubernetes/kops/pull/12292)
* Recognize Ubuntu 21.10 (Impish Indri) [@hakman](https://github.com/hakman) [#12300](https://github.com/kubernetes/kops/pull/12300)
* Bump snapshot-controller to 4.2.1 [@olemarkus](https://github.com/olemarkus) [#12303](https://github.com/kubernetes/kops/pull/12303)
* Update Go to v1.16.8 [@hakman](https://github.com/hakman) [#12306](https://github.com/kubernetes/kops/pull/12306)
* Bump aws ebs csi driver to 1.2.1 [@olemarkus](https://github.com/olemarkus) [#12310](https://github.com/kubernetes/kops/pull/12310)
* Add ability to yaml-encode unstructured [@justinsb](https://github.com/justinsb) [#12282](https://github.com/kubernetes/kops/pull/12282)
* Pre-install nvidia container runtime + drivers on GPU instances [@olemarkus](https://github.com/olemarkus) [#11628](https://github.com/kubernetes/kops/pull/11628)
* Update Bazel to v4.2.1 [@hakman](https://github.com/hakman) [#12311](https://github.com/kubernetes/kops/pull/12311)
* Do not precreate dns record for api lbs [@olemarkus](https://github.com/olemarkus) [#12308](https://github.com/kubernetes/kops/pull/12308)
* Default to latest staging image for AWS CCM [@hakman](https://github.com/hakman) [#12291](https://github.com/kubernetes/kops/pull/12291)
* Make AWS CCM NodeIPFamilies configurable [@hakman](https://github.com/hakman) [#12305](https://github.com/kubernetes/kops/pull/12305)
* Use sg rule ids and tags where possible [@olemarkus](https://github.com/olemarkus) [#12314](https://github.com/kubernetes/kops/pull/12314)
* Allow arbitrary length terraform literals [@rifelpet](https://github.com/rifelpet) [#12316](https://github.com/kubernetes/kops/pull/12316)
* Report the power state of cloud instances [@yadneshk](https://github.com/yadneshk) [#12326](https://github.com/kubernetes/kops/pull/12326)
* include new required permissions in documentation [@yeus](https://github.com/yeus) [#12328](https://github.com/kubernetes/kops/pull/12328)
* Use TLS for kubescheduler health check as of k8s 1.23 [@olemarkus](https://github.com/olemarkus) [#12333](https://github.com/kubernetes/kops/pull/12333)
* Update ALPHA k8s versions with Sept releases [@MoShitrit](https://github.com/MoShitrit) [#12337](https://github.com/kubernetes/kops/pull/12337)
* Implement support for AWS ipv6 prefixes [@olemarkus](https://github.com/olemarkus) [#12112](https://github.com/kubernetes/kops/pull/12112)
* Add IMDS IPv6 endpoint in terraform [@rifelpet](https://github.com/rifelpet) [#12298](https://github.com/kubernetes/kops/pull/12298)
* Deprecate TerraformJSON feature flag [@rifelpet](https://github.com/rifelpet) [#12341](https://github.com/kubernetes/kops/pull/12341)
* Skip SCTP e2e tests on cilium + k8s 1.23 [@rifelpet](https://github.com/rifelpet) [#12348](https://github.com/kubernetes/kops/pull/12348)
* Use EC2 and Metadata IPv6 endpoints in IPv6 mode for EBS CSI Driver [@hakman](https://github.com/hakman) [#12349](https://github.com/kubernetes/kops/pull/12349)
* fix: remove inconsistent comment [@eddycharly](https://github.com/eddycharly) [#12351](https://github.com/kubernetes/kops/pull/12351)
* fix: etcd backup docs [@eddycharly](https://github.com/eddycharly) [#12352](https://github.com/kubernetes/kops/pull/12352)
* Fix EC2 IPv6 endpoint for EBS CSI Driver controller [@hakman](https://github.com/hakman) [#12353](https://github.com/kubernetes/kops/pull/12353)
* Create a second Terraform provider for managed files [@rifelpet](https://github.com/rifelpet) [#12322](https://github.com/kubernetes/kops/pull/12322)
* Recognize pending EC2 instances as needed deletion [@justinsb](https://github.com/justinsb) [#12357](https://github.com/kubernetes/kops/pull/12357)
* Script for iterating development on AWS [@justinsb](https://github.com/justinsb) [#12356](https://github.com/kubernetes/kops/pull/12356)
* Only add IPv6 IAM permissions if using IPv6 [@justinsb](https://github.com/justinsb) [#12355](https://github.com/kubernetes/kops/pull/12355)
* Fix controller defaults for both bootstrap tokens and ipv6 [@justinsb](https://github.com/justinsb) [#12354](https://github.com/kubernetes/kops/pull/12354)
* Update Calico to v3.20.1 [@hakman](https://github.com/hakman) [#12360](https://github.com/kubernetes/kops/pull/12360)
* Fix version check in cilium SCTP test skipping [@rifelpet](https://github.com/rifelpet) [#12365](https://github.com/kubernetes/kops/pull/12365)
* Only configure IMDSv2 on AWS [@justinsb](https://github.com/justinsb) [#12369](https://github.com/kubernetes/kops/pull/12369)
* AWS: Move some subnet functions into AWS model [@justinsb](https://github.com/justinsb) [#12367](https://github.com/kubernetes/kops/pull/12367)
* Fix nil pointer error where containerd is not in use [@justinsb](https://github.com/justinsb) [#12374](https://github.com/kubernetes/kops/pull/12374)
* kubetest2 - add support for dumping k8s resources via SSH [@rifelpet](https://github.com/rifelpet) [#12372](https://github.com/kubernetes/kops/pull/12372)
* Better logging in setLifecycleOverride [@justinsb](https://github.com/justinsb) [#12376](https://github.com/kubernetes/kops/pull/12376)
* Fix parsing of kops toolbox dump yaml output [@rifelpet](https://github.com/rifelpet) [#12377](https://github.com/kubernetes/kops/pull/12377)
* Move cidrmap to subnet package [@justinsb](https://github.com/justinsb) [#11578](https://github.com/kubernetes/kops/pull/11578)
* GCE: Don't create utility subnets in private topology [@justinsb](https://github.com/justinsb) [#12373](https://github.com/kubernetes/kops/pull/12373)
* GCE: Fix subnet deletion [@justinsb](https://github.com/justinsb) [#12370](https://github.com/kubernetes/kops/pull/12370)
* GCE: Always have IPv6 rules in "ipv6 mode" [@justinsb](https://github.com/justinsb) [#12368](https://github.com/kubernetes/kops/pull/12368)
* [channels] Bump AWS/GCP/Azure Ubuntu AMIs to latest [@dntosas](https://github.com/dntosas) [#12334](https://github.com/kubernetes/kops/pull/12334)
* GCE: For IPAlias or Custom Routes, we must recognize source by CIDR [@justinsb](https://github.com/justinsb) [#12371](https://github.com/kubernetes/kops/pull/12371)
* kubetest2 - fix parsing output from toolbox dump [@rifelpet](https://github.com/rifelpet) [#12379](https://github.com/kubernetes/kops/pull/12379)
* Update Go to v1.17.1 [@hakman](https://github.com/hakman) [#12375](https://github.com/kubernetes/kops/pull/12375)
* GCE: When using calico, need to open up ipip protocol [@justinsb](https://github.com/justinsb) [#12384](https://github.com/kubernetes/kops/pull/12384)
* Remove unneeded network related sysctls [@hakman](https://github.com/hakman) [#12385](https://github.com/kubernetes/kops/pull/12385)
* Add specific taints to dns-controller. [@olemarkus](https://github.com/olemarkus) [#12389](https://github.com/kubernetes/kops/pull/12389)
* Add sleep to upgrade-ab scenario [@olemarkus](https://github.com/olemarkus) [#12391](https://github.com/kubernetes/kops/pull/12391)
* Make channels target phony [@olemarkus](https://github.com/olemarkus) [#12392](https://github.com/kubernetes/kops/pull/12392)
* feat: add support for wildcard in roles generated for IRSA [@eddycharly](https://github.com/eddycharly) [#12342](https://github.com/kubernetes/kops/pull/12342)
* Support zone autocompletion [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#12366](https://github.com/kubernetes/kops/pull/12366)
* Decrease connection timeout when dumping logs from instances [@rifelpet](https://github.com/rifelpet) [#12397](https://github.com/kubernetes/kops/pull/12397)
* Fix list of supported cloud providers in CLI docs [@rifelpet](https://github.com/rifelpet) [#12396](https://github.com/kubernetes/kops/pull/12396)
* Fix link to addons documentation [@johngmyers](https://github.com/johngmyers) [#12402](https://github.com/kubernetes/kops/pull/12402)
* Upgrade terraform to 1.0.7 [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#12403](https://github.com/kubernetes/kops/pull/12403)
* Add support to configure Cilium CNI chaining [@choutone](https://github.com/choutone) [#12407](https://github.com/kubernetes/kops/pull/12407)
* Run verify-cloudformation in host network [@rifelpet](https://github.com/rifelpet) [#12410](https://github.com/kubernetes/kops/pull/12410)
* Upgrade cnf-lint to 0.54.2 [@hakman](https://github.com/hakman) [#12411](https://github.com/kubernetes/kops/pull/12411)
* Add option to create an internal load balancer for the bastion [@dezmodue](https://github.com/dezmodue) [#12321](https://github.com/kubernetes/kops/pull/12321)
* Remove critical-pod scheduler annotation. [@rifelpet](https://github.com/rifelpet) [#12398](https://github.com/kubernetes/kops/pull/12398)
* Revert "Remove unneeded network related sysctls" [@olemarkus](https://github.com/olemarkus) [#12415](https://github.com/kubernetes/kops/pull/12415)
* Add bidirectional BPF mount for Cilium >= 1.9.10 or >= 1.10.4 [@ReillyBrogan](https://github.com/ReillyBrogan) [#12394](https://github.com/kubernetes/kops/pull/12394)
* Allow adding more subnets to an NLB [@olemarkus](https://github.com/olemarkus) [#12412](https://github.com/kubernetes/kops/pull/12412)
* release-process.md: Update references to artifact promotion [@justaugustus](https://github.com/justaugustus) [#12386](https://github.com/kubernetes/kops/pull/12386)
* Update google.golang.org/api to 0.57.0 [@justinsb](https://github.com/justinsb) [#12421](https://github.com/kubernetes/kops/pull/12421)
* protokube: don't try to connect to apiserver if not control-plane [@justinsb](https://github.com/justinsb) [#12424](https://github.com/kubernetes/kops/pull/12424)
* Refactor bootstrap verifier/authenticator into its own package [@justinsb](https://github.com/justinsb) [#12422](https://github.com/kubernetes/kops/pull/12422)
* Add kubetest2-kops template for testing dedicated APIServer nodes [@rifelpet](https://github.com/rifelpet) [#12428](https://github.com/kubernetes/kops/pull/12428)
* Have toolbox dump include contents of /etc/hosts [@rifelpet](https://github.com/rifelpet) [#12427](https://github.com/kubernetes/kops/pull/12427)
* Allow aws-iam-authenticator to be scheduled onto dedicated apiserver nodes [@rifelpet](https://github.com/rifelpet) [#12426](https://github.com/kubernetes/kops/pull/12426)
* Mount cgroupv2 for cilium at a custom location [@olemarkus](https://github.com/olemarkus) [#12431](https://github.com/kubernetes/kops/pull/12431)
* Update Amazon Linux 2 documentation to mention the 5.10 kernel [@rifelpet](https://github.com/rifelpet) [#12430](https://github.com/kubernetes/kops/pull/12430)
* Add ability to provide custom CoreDNS tolerations and affinity [@hierynomus](https://github.com/hierynomus) [#12234](https://github.com/kubernetes/kops/pull/12234)
* Document cloud-init behaviour [@dezmodue](https://github.com/dezmodue) [#12438](https://github.com/kubernetes/kops/pull/12438)
* Skip certain e2e tests in GCE [@rifelpet](https://github.com/rifelpet) [#12434](https://github.com/kubernetes/kops/pull/12434)
* Fix AWS IAM Authenticator support for k8s 1.22 [@rifelpet](https://github.com/rifelpet) [#12425](https://github.com/kubernetes/kops/pull/12425)
* feat: add support for custom audience in aws oidc provider [@eddycharly](https://github.com/eddycharly) [#12419](https://github.com/kubernetes/kops/pull/12419)
* Fix typo in name of new 'UseServiceAccountExternalPermissions' variable. [@ev-hines](https://github.com/ev-hines) [#12440](https://github.com/kubernetes/kops/pull/12440)
* Truncate cluster name in NTH EventBridgeRules [@rifelpet](https://github.com/rifelpet) [#12439](https://github.com/kubernetes/kops/pull/12439)
* Use separate cloud.config file for in-tree vs out-of-tree components [@rifelpet](https://github.com/rifelpet) [#12435](https://github.com/kubernetes/kops/pull/12435)
* Add fixed version to all addons [@olemarkus](https://github.com/olemarkus) [#12416](https://github.com/kubernetes/kops/pull/12416)
* Add support for YAML/JSON output to 'kops get instances' [@hierynomus](https://github.com/hierynomus) [#12442](https://github.com/kubernetes/kops/pull/12442)
* Update stable k8s versions [@MoShitrit](https://github.com/MoShitrit) [#12454](https://github.com/kubernetes/kops/pull/12454)
* Bump  aws-cni version to 1.9.1 [@MoShitrit](https://github.com/MoShitrit) [#12455](https://github.com/kubernetes/kops/pull/12455)
* Skip load balancer test in IPv6 clusters [@rifelpet](https://github.com/rifelpet) [#12452](https://github.com/kubernetes/kops/pull/12452)
* Update containerd to v1.4.10 [@hakman](https://github.com/hakman) [#12459](https://github.com/kubernetes/kops/pull/12459)
* Remove unnecessary sysctl "net.ipv6.conf.all.accept_ra=2" [@hakman](https://github.com/hakman) [#12461](https://github.com/kubernetes/kops/pull/12461)
* Bump Cluster Autoscaler images [@olemarkus](https://github.com/olemarkus) [#12463](https://github.com/kubernetes/kops/pull/12463)
* Create v1alpha3 apiVersion [@johngmyers](https://github.com/johngmyers) [#12406](https://github.com/kubernetes/kops/pull/12406)
* v1alpha3 API fixup [@johngmyers](https://github.com/johngmyers) [#12466](https://github.com/kubernetes/kops/pull/12466)
* Release notes for 1.22.0-beta.2 [@johngmyers](https://github.com/johngmyers) [#12468](https://github.com/kubernetes/kops/pull/12468)
* Fail if an apimachinery conversion is missing [@johngmyers](https://github.com/johngmyers) [#12469](https://github.com/kubernetes/kops/pull/12469)
* kube-controller-manager also doesn't mount /srv/kubernetes [@johngmyers](https://github.com/johngmyers) [#12473](https://github.com/kubernetes/kops/pull/12473)
* Cleanup ClusterSpec code [@johngmyers](https://github.com/johngmyers) [#12472](https://github.com/kubernetes/kops/pull/12472)
* Remove Docker overlayfs upgrade code [@johngmyers](https://github.com/johngmyers) [#12471](https://github.com/kubernetes/kops/pull/12471)
* Spotinst: Update `spotinst/ocean-controller` to v1.0.78 [@liranp](https://github.com/liranp) [#12476](https://github.com/kubernetes/kops/pull/12476)
* Update containerd to v1.4.11 [@hakman](https://github.com/hakman) [#12479](https://github.com/kubernetes/kops/pull/12479)
* Update Docker to v20.10.9 [@hakman](https://github.com/hakman) [#12481](https://github.com/kubernetes/kops/pull/12481)
* Update k8s dependencies to v1.22.2 [@hakman](https://github.com/hakman) [#12483](https://github.com/kubernetes/kops/pull/12483)
* Add Cilium agent pod annotations support to improve personalization [@sterchelen](https://github.com/sterchelen) [#12414](https://github.com/kubernetes/kops/pull/12414)
* [DigitalOcean] Incorporate existing vpc support for kops [@srikiz](https://github.com/srikiz) [#12485](https://github.com/kubernetes/kops/pull/12485)
* Add kubescheduler.config.k8s.io/v1beta2 for k8s 1.22+ [@hakman](https://github.com/hakman) [#12486](https://github.com/kubernetes/kops/pull/12486)
* Update controller-runtime to v0.10.2 [@hakman](https://github.com/hakman) [#12490](https://github.com/kubernetes/kops/pull/12490)
* Update Calico to v3.20.2 [@hakman](https://github.com/hakman) [#12491](https://github.com/kubernetes/kops/pull/12491)
* Replace klog flags with go-runner in k8s 1.23  [@rifelpet](https://github.com/rifelpet) [#12494](https://github.com/kubernetes/kops/pull/12494)
* Support GCE TPM verification [@justinsb](https://github.com/justinsb) [#12420](https://github.com/kubernetes/kops/pull/12420)
* Remove unused fields cluster APIs [@johngmyers](https://github.com/johngmyers) [#12475](https://github.com/kubernetes/kops/pull/12475)
* Update Bazel rules_go to v0.29.0 [@hakman](https://github.com/hakman) [#12496](https://github.com/kubernetes/kops/pull/12496)
* Update etcd-manager to 3.0.20211007 [@hakman](https://github.com/hakman) [#12497](https://github.com/kubernetes/kops/pull/12497)
* Remove some unused fields from v1alpha3 componentconfig [@johngmyers](https://github.com/johngmyers) [#12500](https://github.com/kubernetes/kops/pull/12500)
* Add Cilium + RHEL8 release note [@rifelpet](https://github.com/rifelpet) [#12504](https://github.com/kubernetes/kops/pull/12504)
* Update Go to v1.17.2 [@hakman](https://github.com/hakman) [#12502](https://github.com/kubernetes/kops/pull/12502)
* Convert go.mod files to Go 1.17 [@hakman](https://github.com/hakman) [#12505](https://github.com/kubernetes/kops/pull/12505)
* Release notes for 1.20.3 [@hakman](https://github.com/hakman) [#12512](https://github.com/kubernetes/kops/pull/12512)
* Release notes for 1.21.2 [@hakman](https://github.com/hakman) [#12513](https://github.com/kubernetes/kops/pull/12513)
* Bump channels [@hakman](https://github.com/hakman) [#12516](https://github.com/kubernetes/kops/pull/12516)
* Update release process docs [@hakman](https://github.com/hakman) [#12514](https://github.com/kubernetes/kops/pull/12514)
* Remove more unused fields from v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12517](https://github.com/kubernetes/kops/pull/12517)
* Update coredns to v1.8.5 [@hakman](https://github.com/hakman) [#12518](https://github.com/kubernetes/kops/pull/12518)
* Fix addon-resource-tracking e2e scenario [@rifelpet](https://github.com/rifelpet) [#12520](https://github.com/kubernetes/kops/pull/12520)
* Spotinst: Support for RI commitments [@liranp](https://github.com/liranp) [#12522](https://github.com/kubernetes/kops/pull/12522)
* tests: create-cluster integration tests should validate additional objects [@justinsb](https://github.com/justinsb) [#12285](https://github.com/kubernetes/kops/pull/12285)
* Update Bazel rules_docker to v0.20.0 [@hakman](https://github.com/hakman) [#12523](https://github.com/kubernetes/kops/pull/12523)
* Enable ingress hostname feature for OpenStack [@zetaab](https://github.com/zetaab) [#12525](https://github.com/kubernetes/kops/pull/12525)
* Upgrade EBS CSI Driver to v1.4.0 [@rifelpet](https://github.com/rifelpet),[@olemarkus](https://github.com/olemarkus) [#12529](https://github.com/kubernetes/kops/pull/12529)
* Release notes for 1.22.0 [@johngmyers](https://github.com/johngmyers) [#12533](https://github.com/kubernetes/kops/pull/12533)
* Spotinst: Permission to create `bigdata.spot.io/bigdataenvironments` [@liranp](https://github.com/liranp) [#12521](https://github.com/kubernetes/kops/pull/12521)
* Add missing "a" to 1.22 release notes [@yurrriq](https://github.com/yurrriq) [#12536](https://github.com/kubernetes/kops/pull/12536)
* Bump cert-manager dependency [@olemarkus](https://github.com/olemarkus) [#12537](https://github.com/kubernetes/kops/pull/12537)
* Don't hard-code the SQS Queue ARN partition [@rifelpet](https://github.com/rifelpet) [#12540](https://github.com/kubernetes/kops/pull/12540)
* Minor updates to releases document [@johngmyers](https://github.com/johngmyers) [#12546](https://github.com/kubernetes/kops/pull/12546)
* Add rolling updates doc to menus [@johngmyers](https://github.com/johngmyers) [#12550](https://github.com/kubernetes/kops/pull/12550)
* [cilium] Add support for bpf-lb-sock-hostns-only field [@dntosas](https://github.com/dntosas) [#12524](https://github.com/kubernetes/kops/pull/12524)
* kops-controller: register coordination scheme [@justinsb](https://github.com/justinsb) [#12553](https://github.com/kubernetes/kops/pull/12553)
* Add capacity-optimized-prioritized as a valid spot allocation strategy [@ripta](https://github.com/ripta) [#12560](https://github.com/kubernetes/kops/pull/12560)
* Disable CNP status updates by default [@olemarkus](https://github.com/olemarkus) [#12564](https://github.com/kubernetes/kops/pull/12564)
* Update google/go-containerregistry to v0.6.0 [@hakman](https://github.com/hakman) [#12566](https://github.com/kubernetes/kops/pull/12566)
* Re-add ec2:DescribeLaunchTemplateVersions to CA IAM policy [@rifelpet](https://github.com/rifelpet) [#12568](https://github.com/kubernetes/kops/pull/12568)
* Upgrade tests - cleanup previous cluster with newer kops version [@rifelpet](https://github.com/rifelpet) [#12570](https://github.com/kubernetes/kops/pull/12570)
* Upgrade AWS VPC CNI to 1.9.3 w/ k8s 1.22 support [@rifelpet](https://github.com/rifelpet) [#12573](https://github.com/kubernetes/kops/pull/12573)
* Update channels [@hakman](https://github.com/hakman) [#12548](https://github.com/kubernetes/kops/pull/12548)
* Make it possible to set CAS max-node-provision-time [@olemarkus](https://github.com/olemarkus) [#12437](https://github.com/kubernetes/kops/pull/12437)
* Update release documentation [@johngmyers](https://github.com/johngmyers) [#12578](https://github.com/kubernetes/kops/pull/12578)
* Release notes for 1.22.1 [@johngmyers](https://github.com/johngmyers) [#12579](https://github.com/kubernetes/kops/pull/12579)
* Prune addons via labels [@justinsb](https://github.com/justinsb) [#12156](https://github.com/kubernetes/kops/pull/12156)
* Support BYO IPv6 [@johngmyers](https://github.com/johngmyers) [#12582](https://github.com/kubernetes/kops/pull/12582)
* Mention KOPS_ARCH in contributor documentation [@johngmyers](https://github.com/johngmyers) [#12586](https://github.com/kubernetes/kops/pull/12586)
* Allow AWS LBC to attach certificates [@olemarkus](https://github.com/olemarkus) [#12309](https://github.com/kubernetes/kops/pull/12309)
* gossip: Seed /etc/hosts in nodeup [@justinsb](https://github.com/justinsb) [#12554](https://github.com/kubernetes/kops/pull/12554)
* GCE: use chrony on Ubuntu + GCE [@justinsb](https://github.com/justinsb) [#12587](https://github.com/kubernetes/kops/pull/12587)
* Upgrade Canal to v3.20 with k8s 1.22 support [@rifelpet](https://github.com/rifelpet) [#12584](https://github.com/kubernetes/kops/pull/12584)
* GCE: Allow network to be marked as shared [@justinsb](https://github.com/justinsb) [#12590](https://github.com/kubernetes/kops/pull/12590)
* Add calico-kube-controllers for Canal [@hakman](https://github.com/hakman) [#12593](https://github.com/kubernetes/kops/pull/12593)
* Support BYO IPv6 [@johngmyers](https://github.com/johngmyers) [#12592](https://github.com/kubernetes/kops/pull/12592)
* gce: allow router to refer to network object [@justinsb](https://github.com/justinsb) [#12591](https://github.com/kubernetes/kops/pull/12591)
* Update Canal based on Calico [@hakman](https://github.com/hakman) [#12594](https://github.com/kubernetes/kops/pull/12594)
* Spotinst: Get instance types from `mixedInstancesPolicy` field [@liranp](https://github.com/liranp) [#12549](https://github.com/kubernetes/kops/pull/12549)
* Rename BAZEL_BIN to BAZEL in Makefile [@hakman](https://github.com/hakman) [#12599](https://github.com/kubernetes/kops/pull/12599)
* gce: open kops-controller port from nodes [@justinsb](https://github.com/justinsb) [#12556](https://github.com/kubernetes/kops/pull/12556)
* Handle keypair items without certificates [@johngmyers](https://github.com/johngmyers) [#12601](https://github.com/kubernetes/kops/pull/12601)
* Respect any MaxPods value the user sets explicitly [@hakman](https://github.com/hakman) [#12603](https://github.com/kubernetes/kops/pull/12603)
* Add permissions needed for KCM to provision NLBs [@olemarkus](https://github.com/olemarkus) [#12611](https://github.com/kubernetes/kops/pull/12611)
* dns-controller: Treat IPv6 node addresses as both internal and external [@johngmyers](https://github.com/johngmyers) [#12608](https://github.com/kubernetes/kops/pull/12608)
* GCE: improve network & subnet terraform support [@justinsb](https://github.com/justinsb) [#12382](https://github.com/kubernetes/kops/pull/12382)
* GCE: support egress specification [@justinsb](https://github.com/justinsb) [#12600](https://github.com/kubernetes/kops/pull/12600)
* Fix GCE router terraform reference [@rifelpet](https://github.com/rifelpet) [#12618](https://github.com/kubernetes/kops/pull/12618)
* Use the SQS Queue's ARN reference [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#12571](https://github.com/kubernetes/kops/pull/12571)
* Remove vestigial Cilium ContainerRuntimeLabels code [@johngmyers](https://github.com/johngmyers) [#12615](https://github.com/kubernetes/kops/pull/12615)
*  Improve default CIDR assignments for IPv6  [@johngmyers](https://github.com/johngmyers) [#12617](https://github.com/kubernetes/kops/pull/12617)
* Make dns-controller delete placeholder addresses for IPv6 cluster [@johngmyers](https://github.com/johngmyers) [#12605](https://github.com/kubernetes/kops/pull/12605)
* Use .bazel-bin to help gopls & VSCode [@justinsb](https://github.com/justinsb) [#12498](https://github.com/kubernetes/kops/pull/12498)
* GCE: Delete routes with long cluster names [@justinsb](https://github.com/justinsb) [#12619](https://github.com/kubernetes/kops/pull/12619)
* Use instance metadata to find local IPv6 prefix [@hakman](https://github.com/hakman) [#12622](https://github.com/kubernetes/kops/pull/12622)
* Create placeholder DNS records of correct type for IPv6 clusters [@johngmyers](https://github.com/johngmyers) [#12616](https://github.com/kubernetes/kops/pull/12616)
* kubetest2: remove duplicate admin-access flag [@justinsb](https://github.com/justinsb) [#12625](https://github.com/kubernetes/kops/pull/12625)
* kubetest2: force printing of the plan on cluster creation [@justinsb](https://github.com/justinsb) [#12624](https://github.com/kubernetes/kops/pull/12624)
* Use server-side apply for addons. Identify as kops [@olemarkus](https://github.com/olemarkus) [#12583](https://github.com/kubernetes/kops/pull/12583)
* Use InternalIP as preferred kubelet address only in ivp6 mode [@olemarkus](https://github.com/olemarkus) [#12626](https://github.com/kubernetes/kops/pull/12626)
* Clarify the deployment responsible for API DNS in error message [@rifelpet](https://github.com/rifelpet) [#12277](https://github.com/kubernetes/kops/pull/12277)
* Dump more resource types from kubectl into cluster-info directory [@rifelpet](https://github.com/rifelpet) [#12631](https://github.com/kubernetes/kops/pull/12631)
* Configure aws-iam-authenticator using identityMappings defined in cluster.yaml [@hierynomus](https://github.com/hierynomus) [#12538](https://github.com/kubernetes/kops/pull/12538)
* Never masquerade IPv6 with Cilium [@johngmyers](https://github.com/johngmyers) [#12623](https://github.com/kubernetes/kops/pull/12623)
* Add more IPv6 integration tests [@hakman](https://github.com/hakman) [#12634](https://github.com/kubernetes/kops/pull/12634)
* Log `kops toolbox dump` output to artifacts dir rather than stdout [@rifelpet](https://github.com/rifelpet) [#12639](https://github.com/kubernetes/kops/pull/12639)
* Integration test cleanup [@rifelpet](https://github.com/rifelpet) [#12637](https://github.com/kubernetes/kops/pull/12637)
* Allow kops-controller to describe network interfaces [@hakman](https://github.com/hakman) [#12641](https://github.com/kubernetes/kops/pull/12641)
* Fix hardcoded ARN partitions [@rifelpet](https://github.com/rifelpet) [#12638](https://github.com/kubernetes/kops/pull/12638)
* Check for hardcoded partitions in integration tests [@rifelpet](https://github.com/rifelpet) [#12635](https://github.com/kubernetes/kops/pull/12635)
* Enable Router Advertisements for Debian 11 [@hakman](https://github.com/hakman) [#12642](https://github.com/kubernetes/kops/pull/12642)
* Use prefixes for IPv6 with Calico [@hakman](https://github.com/hakman) [#12643](https://github.com/kubernetes/kops/pull/12643)
* doc: Number subsections that are procedural steps [@johngmyers](https://github.com/johngmyers) [#12645](https://github.com/kubernetes/kops/pull/12645)
* Revert "Make dns-controller delete placeholder addresses for IPv6 cluster" [@johngmyers](https://github.com/johngmyers) [#12646](https://github.com/kubernetes/kops/pull/12646)
* dns-controller: use aliases for internal host-network pods [@johngmyers](https://github.com/johngmyers) [#12640](https://github.com/kubernetes/kops/pull/12640)
* Prohibit masquerading in IPv6 clusters [@johngmyers](https://github.com/johngmyers) [#12647](https://github.com/kubernetes/kops/pull/12647)
* Validate CNI can support IPv6 [@johngmyers](https://github.com/johngmyers) [#12650](https://github.com/kubernetes/kops/pull/12650)
* Remove unused Cilium fields from v1alpha3 API [@johngmyers](https://github.com/johngmyers) [#12610](https://github.com/kubernetes/kops/pull/12610)
* Remove obsolete documents [@johngmyers](https://github.com/johngmyers) [#12648](https://github.com/kubernetes/kops/pull/12648)
* Enable Router Advertisements for Debian 11 on  ens* interfaces [@hakman](https://github.com/hakman) [#12652](https://github.com/kubernetes/kops/pull/12652)
* IPv6 requires external CCM [@johngmyers](https://github.com/johngmyers) [#12651](https://github.com/kubernetes/kops/pull/12651)
