## Release notes for kOps 1.20 series

(The kOps 1.20 release has not been released yet; this is a document to gather the notes prior to the release).

# Significant changes

* Default container runtime is now set to `containerd` for new clusters running Kubernetes 1.20.0+.

* Added experimental Azure support. To get started check the [docs](https://kops.sigs.k8s.io/getting_started/azure/)

* Default settings for AWS instances are updated to take advantage of recent performance and security features:
    * Default root volume encryption changes to enabled
    * Default root volume type changes from `gp2` to `gp3`

* Added [template funtions](https://kops.sigs.k8s.io/operations/cluster_template/#template-functions) for kubernetes version based on channel data.

* kOps now use helm3 functions for merging template `--set` and `--values` arguments. This has slightly different behaviour than previous helm2-like logic.

* Following kubeadm, control plane nodes are now labelled with `node-role.kubernetes.io/control-plane=""`

* Default node image for GCE changed from COS to Ubuntu for K8s versions >= 1.17.0. This is to more closely align with the AWS implementation (the most mature support) and because COS limits the ability to modify files on its disk.

# Breaking changes

* Support for Kubernetes 1.11 and 1.12 has been removed.

* Support for Terraform version 0.11 has been removed.

* Support for the feature flag `Terraform-0.12` has been removed.  All generated Terraform HCL2/JSON files will support versions `0.12.26+` and `0.13.0+`.

# Required Actions

* If you are running `kops toolbox template` in an airgapped environment, you have to set `--channel` to point to a local channel file.

* If your workload targets control plane nodes, you need to change them to select the `node-role.kubernetes.io/control-plane=""` label. You should also add the `node-role.kubernetes.io/control-plane:NoSchedule` toleration to these workloads. This taint will not be added to control plane nodes before kOps 1.22.

# Deprecations

* Support for Kubernetes versions 1.13 and 1.14 are deprecated and will be removed in kOps 1.21.

* The [manifest based metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) has been deprecated in favour of a configurable addon.

* The [manifest based cluster autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler) has been deprecated in favour of a configurable addon.

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and will be removed from control plane nodes in kOps 1.22

* The experimental node-authorizer that could be enabled using `nodeAuthorization` has been removed. Setting this value is now forbidden.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this cloud provider.

# Full change list since 1.19.0 release

## 1.19.0-beta.3 to 1.20.0-alpha.1

* Update docs for cutting new release branches [@rifelpet](https://github.com/rifelpet) [#10084](https://github.com/kubernetes/kops/pull/10084)
* Update security_groups.md [@yurrriq](https://github.com/yurrriq) [#10078](https://github.com/kubernetes/kops/pull/10078)
* Take node labels from cloud tags on AWS [@johngmyers](https://github.com/johngmyers) [#9575](https://github.com/kubernetes/kops/pull/9575)
* Update Office Hours Zoom link [@johngmyers](https://github.com/johngmyers) [#10087](https://github.com/kubernetes/kops/pull/10087)
* Update zoom links on the spanish README [@rdrgmnzs](https://github.com/rdrgmnzs) [#10088](https://github.com/kubernetes/kops/pull/10088)
* Ignore changes to ForAPIServer field [@justinsb](https://github.com/justinsb) [#10086](https://github.com/kubernetes/kops/pull/10086)
* Update Flannel CNI to v0.13.0 [@hakman](https://github.com/hakman) [#10064](https://github.com/kubernetes/kops/pull/10064)
* kubetest2 - Implement create/validate/delete cluster functionality [@rifelpet](https://github.com/rifelpet) [#10083](https://github.com/kubernetes/kops/pull/10083)
* Cert circular deps [@olemarkus](https://github.com/olemarkus) [#10092](https://github.com/kubernetes/kops/pull/10092)
* Fix cilium template by specifying boolean as a string for enable-metrics [@h3poteto](https://github.com/h3poteto) [#10094](https://github.com/kubernetes/kops/pull/10094)
* Release notes for 1.18.2 [@justinsb](https://github.com/justinsb) [#10097](https://github.com/kubernetes/kops/pull/10097)
* Update Kops Go build supported versions 1.15 [@bmelbourne](https://github.com/bmelbourne) [#10099](https://github.com/kubernetes/kops/pull/10099)
* Spotinst: Bump the Spot Cluster Controller to 1.0.68 [@liranp](https://github.com/liranp) [#10103](https://github.com/kubernetes/kops/pull/10103)
* Remove hack/workaround from etcd-manager certificate expiration advisory [@hakman](https://github.com/hakman) [#10102](https://github.com/kubernetes/kops/pull/10102)
* Install container runtime packages as assets [@hakman](https://github.com/hakman) [#10048](https://github.com/kubernetes/kops/pull/10048)
* Default to exporting a kubecfg, even without credentials [@justinsb](https://github.com/justinsb) [#10105](https://github.com/kubernetes/kops/pull/10105)
* Remove dependency of TerraformJSON feature flag [@johngmyers](https://github.com/johngmyers) [#10106](https://github.com/kubernetes/kops/pull/10106)
* Makefile and hack script cleanup [@rifelpet](https://github.com/rifelpet) [#10112](https://github.com/kubernetes/kops/pull/10112)
* Update channels [@hakman](https://github.com/hakman) [#10117](https://github.com/kubernetes/kops/pull/10117)
* Update Calico config for eBPF mode [@hakman](https://github.com/hakman) [#10115](https://github.com/kubernetes/kops/pull/10115)
* Add random AWS zone logic + specify build stage location [@rifelpet](https://github.com/rifelpet) [#10121](https://github.com/kubernetes/kops/pull/10121)
* Update AWS VPC CNI to 1.7.5 [@MoShitrit](https://github.com/MoShitrit) [#10124](https://github.com/kubernetes/kops/pull/10124)
* Add nodeLocalDNSCache.kubeDnsOnly option [@javipolo](https://github.com/javipolo) [#10111](https://github.com/kubernetes/kops/pull/10111)
* Align AWS VPC CNI manifest with upstream [@hakman](https://github.com/hakman) [#10126](https://github.com/kubernetes/kops/pull/10126)
* Fix release notes links to point to https://kops.sigs.k8s [@hakman](https://github.com/hakman) [#10118](https://github.com/kubernetes/kops/pull/10118)
* Add verify-cloudformation script [@rifelpet](https://github.com/rifelpet) [#10130](https://github.com/kubernetes/kops/pull/10130)
* Fix cloudformation lint errors [@rifelpet](https://github.com/rifelpet) [#10131](https://github.com/kubernetes/kops/pull/10131)
* Update shell style for CLI docs for better compatibility [@hakman](https://github.com/hakman) [#10128](https://github.com/kubernetes/kops/pull/10128)
* Prevent unintended resource updates to LB attatchments [@rdrgmnzs](https://github.com/rdrgmnzs) [#9794](https://github.com/kubernetes/kops/pull/9794)
* Make verify-cloudformation job fail when issues are found [@rifelpet](https://github.com/rifelpet) [#10133](https://github.com/kubernetes/kops/pull/10133)
* Set minimum Terraform version to 0.12.26/0.13.0 [@bmelbourne](https://github.com/bmelbourne) [#10109](https://github.com/kubernetes/kops/pull/10109)
* ELB/TargetGroup/ASG attachment fixes [@rifelpet](https://github.com/rifelpet) [#10138](https://github.com/kubernetes/kops/pull/10138)
* Prepare for version 1.20 [@johngmyers](https://github.com/johngmyers) [#10101](https://github.com/kubernetes/kops/pull/10101)
* Rebrand kops to kOps [@hakman](https://github.com/hakman) [#10077](https://github.com/kubernetes/kops/pull/10077)
* Remove code for no-longer-supported k8s releases [@johngmyers](https://github.com/johngmyers) [#10141](https://github.com/kubernetes/kops/pull/10141)
* allow reauth for openstack client [@zetaab](https://github.com/zetaab) [#10144](https://github.com/kubernetes/kops/pull/10144)
* Simplify etcd options builder [@hakman](https://github.com/hakman) [#10145](https://github.com/kubernetes/kops/pull/10145)
* Update AWS Cloudmock for complex and externallb integration test clusters [@rifelpet](https://github.com/rifelpet) [#10140](https://github.com/kubernetes/kops/pull/10140)
* Deprecate field calico.majorVersion [@hakman](https://github.com/hakman) [#10143](https://github.com/kubernetes/kops/pull/10143)
* [Digital Ocean] Use Debian10 as default image [@srikiz](https://github.com/srikiz) [#10098](https://github.com/kubernetes/kops/pull/10098)
* Fix NLB naming for terraform and cloudformation targets [@rifelpet](https://github.com/rifelpet) [#10158](https://github.com/kubernetes/kops/pull/10158)
* Move NLB's VPC CIDR security group rule logic into model [@rifelpet](https://github.com/rifelpet) [#10161](https://github.com/kubernetes/kops/pull/10161)
* Fix additionalSecurityGroups support for NLB [@rifelpet](https://github.com/rifelpet) [#10162](https://github.com/kubernetes/kops/pull/10162)
* Some typos [@Hellcatlk](https://github.com/Hellcatlk) [#10160](https://github.com/kubernetes/kops/pull/10160)
* Fix output for CF and TF [@hakman](https://github.com/hakman) [#10164](https://github.com/kubernetes/kops/pull/10164)
* Avoid waiting on validation during rolling update for inapplicable instance groups [@bharath-123](https://github.com/bharath-123) [#10065](https://github.com/kubernetes/kops/pull/10065)
* OpenStack Reset deviceID status if needed [@zetaab](https://github.com/zetaab) [#10178](https://github.com/kubernetes/kops/pull/10178)
* Remove unused bearer token field from kubeconfig builder [@rifelpet](https://github.com/rifelpet) [#10181](https://github.com/kubernetes/kops/pull/10181)
* Compare KubernetesAPIAccess to OpenStack allowedCIDRs deterministically [@havulv](https://github.com/havulv) [#10186](https://github.com/kubernetes/kops/pull/10186)
* Consistent naming of security group rules [@olemarkus](https://github.com/olemarkus) [#10179](https://github.com/kubernetes/kops/pull/10179)
* Upgrade Hashicorp HCLv2 Go module v2.7.0 [@bmelbourne](https://github.com/bmelbourne) [#10189](https://github.com/kubernetes/kops/pull/10189)
* Fix auto scaling group changes when using spot instances [@hakman](https://github.com/hakman) [#10187](https://github.com/kubernetes/kops/pull/10187)
* Upgrade sprig to v3 [@olemarkus](https://github.com/olemarkus) [#10191](https://github.com/kubernetes/kops/pull/10191)
* Upgrade helm to 2.17 and use the helm.sh reference [@olemarkus](https://github.com/olemarkus) [#10192](https://github.com/kubernetes/kops/pull/10192)
* Fix AWS NLB reconciliation [@hakman](https://github.com/hakman) [#10199](https://github.com/kubernetes/kops/pull/10199)
* Fix disabling spot instances when using launch templates [@hakman](https://github.com/hakman) [#10198](https://github.com/kubernetes/kops/pull/10198)
* Add ACM cert permalink [@rifelpet](https://github.com/rifelpet) [#10156](https://github.com/kubernetes/kops/pull/10156)
*  Setup a second NLB listener when an AWS ACM certificate is used [@rifelpet](https://github.com/rifelpet),[@hakman](https://github.com/hakman) [#10157](https://github.com/kubernetes/kops/pull/10157)
* Update Go to v1.15.4 [@hakman](https://github.com/hakman) [#10209](https://github.com/kubernetes/kops/pull/10209)
* Upgrade docker client [@olemarkus](https://github.com/olemarkus) [#10193](https://github.com/kubernetes/kops/pull/10193)
* Spotinst: Configure Resource Limits in Ocean Auto Scaler [@liranp](https://github.com/liranp) [#10190](https://github.com/kubernetes/kops/pull/10190)
* Release notes 1.19.0-beta.1 [@hakman](https://github.com/hakman) [#10213](https://github.com/kubernetes/kops/pull/10213)
* Use LaunchTemplate versions instead of timestamped LaunchTemplates [@hakman](https://github.com/hakman) [#10151](https://github.com/kubernetes/kops/pull/10151)
* Update kOps version after 1.19.0-beta.1 release [@hakman](https://github.com/hakman) [#10216](https://github.com/kubernetes/kops/pull/10216)
* Remove components from cluster validation [@johngmyers](https://github.com/johngmyers) [#10214](https://github.com/kubernetes/kops/pull/10214)
* Allow to use custom csi plugin image and enable topology support [@zetaab](https://github.com/zetaab) [#10215](https://github.com/kubernetes/kops/pull/10215)
* Update validate cluster cli docs [@johngmyers](https://github.com/johngmyers) [#10219](https://github.com/kubernetes/kops/pull/10219)
* Fix cluster autoscaler docs [@djablonski-moia](https://github.com/djablonski-moia) [#10225](https://github.com/kubernetes/kops/pull/10225)
* Make etcd-manager log verbosity configurable [@elblivion](https://github.com/elblivion) [#10194](https://github.com/kubernetes/kops/pull/10194)
* Update k8s versions nov 2020 [@MoShitrit](https://github.com/MoShitrit) [#10227](https://github.com/kubernetes/kops/pull/10227)
* Update Ubuntu ami to latest version [@MoShitrit](https://github.com/MoShitrit) [#10195](https://github.com/kubernetes/kops/pull/10195)
* Fix various nits [@hakman](https://github.com/hakman) [#10217](https://github.com/kubernetes/kops/pull/10217)
* Switch ARM64 CI to Graviton2 CPU [@hakman](https://github.com/hakman) [#10230](https://github.com/kubernetes/kops/pull/10230)
* Update docs related to audit logging [@hakman](https://github.com/hakman) [#10231](https://github.com/kubernetes/kops/pull/10231)
* Don't install the misc packages for k8s 1.20+ [@johngmyers](https://github.com/johngmyers) [#10222](https://github.com/kubernetes/kops/pull/10222)
* Fix readme [@karancode](https://github.com/karancode) [#10228](https://github.com/kubernetes/kops/pull/10228)
* Update kops as kOps and remove extra spaces from .md files [@axpraka](https://github.com/axpraka),[@hakman](https://github.com/hakman) [#10235](https://github.com/kubernetes/kops/pull/10235)
* Add default runtime and runtimes fields in the docker config [@bharath-123](https://github.com/bharath-123) [#10238](https://github.com/kubernetes/kops/pull/10238)
* Fix cluster validation dependency on local kubeconfig [@eddycharly](https://github.com/eddycharly) [#10221](https://github.com/kubernetes/kops/pull/10221)
* Associate instance group to pod validation failures in cluster validation. [@bharath-123](https://github.com/bharath-123) [#10237](https://github.com/kubernetes/kops/pull/10237)
* Add HPA Flags for `horizontal-pod-autoscaler-initial-readiness-delay` & `horizontal-pod-autoscaler-cpu-initialization-period` [@JoelBCarter](https://github.com/JoelBCarter) [#10241](https://github.com/kubernetes/kops/pull/10241)
* Remove more code specific to unsupported etcd v2 [@johngmyers](https://github.com/johngmyers) [#10245](https://github.com/kubernetes/kops/pull/10245)
* GCE: ignore (output-only) networkInterface.name [@justinsb](https://github.com/justinsb) [#10242](https://github.com/kubernetes/kops/pull/10242)
* Make it possible to use OnDelete update strategy on addon daemonset [@olemarkus](https://github.com/olemarkus) [#10167](https://github.com/kubernetes/kops/pull/10167)
* Fix version of storage-aws addon manifest [@johngmyers](https://github.com/johngmyers) [#10247](https://github.com/kubernetes/kops/pull/10247)
* Fix cloudformation lint job [@rifelpet](https://github.com/rifelpet) [#10256](https://github.com/kubernetes/kops/pull/10256)
* Update etcd-manager to 3.0.20201117 [@justinsb](https://github.com/justinsb) [#10257](https://github.com/kubernetes/kops/pull/10257)
* Use separate domain for kops-controller bootstrap [@johngmyers](https://github.com/johngmyers) [#10239](https://github.com/kubernetes/kops/pull/10239)
* Revert "Switch ARM64 CI to Graviton2 CPU" [@hakman](https://github.com/hakman) [#10262](https://github.com/kubernetes/kops/pull/10262)
* Update Bazel rules for Go to v0.24.7 [@hakman](https://github.com/hakman) [#10240](https://github.com/kubernetes/kops/pull/10240)
* Update k8s dependencies to 1.20.0-beta.2 [@rifelpet](https://github.com/rifelpet) [#10266](https://github.com/kubernetes/kops/pull/10266)
* Push multi-arch images [@hakman](https://github.com/hakman) [#10265](https://github.com/kubernetes/kops/pull/10265)
* alpha channel: update legacy images [@justinsb](https://github.com/justinsb) [#10269](https://github.com/kubernetes/kops/pull/10269)
* Fix multi-arch image pushing [@hakman](https://github.com/hakman) [#10270](https://github.com/kubernetes/kops/pull/10270)
* Add sslPolicy for NLB to change listener's security policy [@FrankYang0529](https://github.com/FrankYang0529) [#9666](https://github.com/kubernetes/kops/pull/9666)
* Optimize Bazel builds by os and arch [@hakman](https://github.com/hakman) [#10267](https://github.com/kubernetes/kops/pull/10267)
* Fix incorrect URLs in kops cluster documentation [@bycEEE](https://github.com/bycEEE) [#10274](https://github.com/kubernetes/kops/pull/10274)
* Use etcd v3.4.13 for k8s v1.19+ [@hakman](https://github.com/hakman) [#10277](https://github.com/kubernetes/kops/pull/10277)
* Parse TargetGroup names from ARNs [@hakman](https://github.com/hakman) [#10276](https://github.com/kubernetes/kops/pull/10276)
* Add Go code-generator v0.20.0-beta.2 crypto hash [@bmelbourne](https://github.com/bmelbourne) [#10285](https://github.com/kubernetes/kops/pull/10285)
* Add ACM/NLB instructions to 1.19 release notes [@rifelpet](https://github.com/rifelpet) [#10292](https://github.com/kubernetes/kops/pull/10292)
* Release notes for 1.19.0-beta.2 [@hakman](https://github.com/hakman) [#10293](https://github.com/kubernetes/kops/pull/10293)
* Add more NLB release notes and documentation [@rifelpet](https://github.com/rifelpet) [#10294](https://github.com/kubernetes/kops/pull/10294)
* Can check cert expiry using openssl [@alok87](https://github.com/alok87),[@hakman](https://github.com/hakman) [#10282](https://github.com/kubernetes/kops/pull/10282)
* [weave] Add support for default version override [@dntosas](https://github.com/dntosas),[@hakman](https://github.com/hakman) [#10273](https://github.com/kubernetes/kops/pull/10273)
* Add support of Azure Blob storage to VFS [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10258](https://github.com/kubernetes/kops/pull/10258)
* Update kOps version after 1.19.0-beta.2 release [@hakman](https://github.com/hakman) [#10295](https://github.com/kubernetes/kops/pull/10295)
* Remove support for using legacy ELB name [@hakman](https://github.com/hakman) [#10296](https://github.com/kubernetes/kops/pull/10296)
* Remove dead code [@hakman](https://github.com/hakman) [#10297](https://github.com/kubernetes/kops/pull/10297)
* Remove support for disabling manifest normalization [@johngmyers](https://github.com/johngmyers) [#10298](https://github.com/kubernetes/kops/pull/10298)
* Upgrade cloud-provider-openstack to 1.19.2 [@rifelpet](https://github.com/rifelpet) [#10303](https://github.com/kubernetes/kops/pull/10303)
* Fix a typo in an error message returned from buildAzureBlobPath [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10305](https://github.com/kubernetes/kops/pull/10305)
* Allow setting CPU limit and Mem request / limit for kube API server [@rdrgmnzs](https://github.com/rdrgmnzs) [#10275](https://github.com/kubernetes/kops/pull/10275)
* Optimize Bazel dev builds by arch [@hakman](https://github.com/hakman) [#10309](https://github.com/kubernetes/kops/pull/10309)
* Update Calico to v3.17.0 [@hakman](https://github.com/hakman) [#10310](https://github.com/kubernetes/kops/pull/10310)
* [Digital Ocean] Upgrade godo sdk to v1.54 [@srikiz](https://github.com/srikiz) [#10320](https://github.com/kubernetes/kops/pull/10320)
* Tolerate missing detached EC2 instances [@hwoarang](https://github.com/hwoarang) [#10319](https://github.com/kubernetes/kops/pull/10319)
* Don't try to detach masters [@olemarkus](https://github.com/olemarkus) [#10328](https://github.com/kubernetes/kops/pull/10328)
* Remove copyright notice from nodeup scripts to reduce the user-data size. [@rdrgmnzs](https://github.com/rdrgmnzs) [#10333](https://github.com/kubernetes/kops/pull/10333)
* Add docs for metrics server [@olemarkus](https://github.com/olemarkus) [#10332](https://github.com/kubernetes/kops/pull/10332)
* Push alpha to stable [@MoShitrit](https://github.com/MoShitrit) [#10336](https://github.com/kubernetes/kops/pull/10336)
* Add paramaeters related to Taint based Evictions in kube-apiserver [@h3poteto](https://github.com/h3poteto) [#10339](https://github.com/kubernetes/kops/pull/10339)
* Allow using gp3 for root volumes [@olemarkus](https://github.com/olemarkus) [#10345](https://github.com/kubernetes/kops/pull/10345)
* Update containerd and Docker versions [@hakman](https://github.com/hakman) [#10341](https://github.com/kubernetes/kops/pull/10341)
* Update aws-sdk-go to v1.36.0 [@hakman](https://github.com/hakman) [#10347](https://github.com/kubernetes/kops/pull/10347)
* Bump aws-vpc-cni version to 1.7.6 [@MoShitrit](https://github.com/MoShitrit) [#10337](https://github.com/kubernetes/kops/pull/10337)
* Update etcd-manager to 3.0.20201202 [@justinsb](https://github.com/justinsb) [#10351](https://github.com/kubernetes/kops/pull/10351)
* Update DigitalOcean cloud-controller-manager to v0.1.30 [@timoreimann](https://github.com/timoreimann) [#10352](https://github.com/kubernetes/kops/pull/10352)
* Add aws-cloud-controller-manager config to addons [@nckturner](https://github.com/nckturner) [#9704](https://github.com/kubernetes/kops/pull/9704)
* Allow attaching same external target group to multiple instance groups [@hakman](https://github.com/hakman) [#10335](https://github.com/kubernetes/kops/pull/10335)
* Add fuzzer and OSS-fuzz build script [@AdamKorcz](https://github.com/AdamKorcz) [#10326](https://github.com/kubernetes/kops/pull/10326)
* Set --service-account-issuer for k8s 1.20+ [@johngmyers](https://github.com/johngmyers) [#10284](https://github.com/kubernetes/kops/pull/10284)
* Promote addon docs to first level menu item [@olemarkus](https://github.com/olemarkus) [#10355](https://github.com/kubernetes/kops/pull/10355)
* [Digital Ocean] Promote to Beta [@srikiz](https://github.com/srikiz) [#10312](https://github.com/kubernetes/kops/pull/10312)
* Give users the option to gzip and base64 encode the heredocs in the nodeup.sh user-data [@rdrgmnzs](https://github.com/rdrgmnzs) [#10357](https://github.com/kubernetes/kops/pull/10357)
* Add integration test for creating an HA cluster in shared zone [@hakman](https://github.com/hakman) [#10365](https://github.com/kubernetes/kops/pull/10365)
* Add minimal cert-manager addon [@olemarkus](https://github.com/olemarkus) [#10318](https://github.com/kubernetes/kops/pull/10318)
* Add option to reuse existing Elastic IPs for NAT gateways [@hakman](https://github.com/hakman) [#10374](https://github.com/kubernetes/kops/pull/10374)
* Remove resource limits from cluster autoscaler [@olemarkus](https://github.com/olemarkus) [#10375](https://github.com/kubernetes/kops/pull/10375)
* Remove dependency on TravisCI [@hakman](https://github.com/hakman) [#10366](https://github.com/kubernetes/kops/pull/10366)
* fix cluster-autoscaler README url from cluster_spec -> addons [@isaachui](https://github.com/isaachui) [#10373](https://github.com/kubernetes/kops/pull/10373)
* Rename duplicate ci target to quick-ci [@hakman](https://github.com/hakman) [#10378](https://github.com/kubernetes/kops/pull/10378)
* Use custom-configured ServiceAccountIssuer when present [@johngmyers](https://github.com/johngmyers) [#10364](https://github.com/kubernetes/kops/pull/10364)
* Add option for setting the volume encryption key in AWS [@hakman](https://github.com/hakman) [#10359](https://github.com/kubernetes/kops/pull/10359)
* Add support for AWS IMDS v2 [@bharath-123](https://github.com/bharath-123) [#10324](https://github.com/kubernetes/kops/pull/10324)
* Update k8s dependencies to v1.20.0 [@hakman](https://github.com/hakman) [#10390](https://github.com/kubernetes/kops/pull/10390)
* Update docs for CentOS 8 [@hakman](https://github.com/hakman) [#10368](https://github.com/kubernetes/kops/pull/10368)
* Move tools into separate `hack` go module [@rifelpet](https://github.com/rifelpet) [#10308](https://github.com/kubernetes/kops/pull/10308)
* Update etcd-manager to 20201209 [@justinsb](https://github.com/justinsb) [#10394](https://github.com/kubernetes/kops/pull/10394)
* Mount /lib64 for Protokube only on AMD64 [@hakman](https://github.com/hakman) [#10396](https://github.com/kubernetes/kops/pull/10396)
* Explicitly specify http_endpoint in terraform launch template [@bharath-123](https://github.com/bharath-123) [#10398](https://github.com/kubernetes/kops/pull/10398)
* Update alpha channel with December 2020 k8s releases and bump Ubuntu AMI version [@MoShitrit](https://github.com/MoShitrit) [#10401](https://github.com/kubernetes/kops/pull/10401)
* Hack script improvements [@rifelpet](https://github.com/rifelpet) [#10407](https://github.com/kubernetes/kops/pull/10407)
* hack/goimports - Replace mapfile with read [@rifelpet](https://github.com/rifelpet) [#10410](https://github.com/kubernetes/kops/pull/10410)
* Allow override of registry and tag for Calico images [@hakman](https://github.com/hakman) [#10316](https://github.com/kubernetes/kops/pull/10316)
* Update Calico to v3.17.1 [@hakman](https://github.com/hakman) [#10408](https://github.com/kubernetes/kops/pull/10408)
* Bump aws-cni to 1.7.7 [@MoShitrit](https://github.com/MoShitrit) [#10416](https://github.com/kubernetes/kops/pull/10416)
* Add support for containerd v1.4.3 ARM64 [@hakman](https://github.com/hakman) [#10418](https://github.com/kubernetes/kops/pull/10418)
* Add release note for terraform launch template migration [@rifelpet](https://github.com/rifelpet) [#10423](https://github.com/kubernetes/kops/pull/10423)
* Expose metrics port when PrometheusMetricsEnabled set to true in Calico [@avdhoot](https://github.com/avdhoot) [#10414](https://github.com/kubernetes/kops/pull/10414)
* Bump etcd client to 3.4.13. Use go modules [@olemarkus](https://github.com/olemarkus) [#10425](https://github.com/kubernetes/kops/pull/10425)
* Use the kubernetes-sigs version of yaml [@olemarkus](https://github.com/olemarkus) [#10427](https://github.com/kubernetes/kops/pull/10427)
* Bump heredoc to v2 [@olemarkus](https://github.com/olemarkus) [#10429](https://github.com/kubernetes/kops/pull/10429)
* Update container runtime service files [@hakman](https://github.com/hakman) [#10428](https://github.com/kubernetes/kops/pull/10428)
* Template functions for recommended kubernetes versions [@olemarkus](https://github.com/olemarkus) [#10369](https://github.com/kubernetes/kops/pull/10369)
* Make CoreDNS the default DNS server [@rajansandeep](https://github.com/rajansandeep) [#7919](https://github.com/kubernetes/kops/pull/7919)
* Delay defaulting to CoreDNS to k8s v1.20 [@hakman](https://github.com/hakman) [#10435](https://github.com/kubernetes/kops/pull/10435)
* Bump go-bindata and use go module [@olemarkus](https://github.com/olemarkus) [#10421](https://github.com/kubernetes/kops/pull/10421)
* Bump sftp to 1.12 [@olemarkus](https://github.com/olemarkus) [#10436](https://github.com/kubernetes/kops/pull/10436)
* IAM ServiceAccount Roles: truncate name at 64 characters [@justinsb](https://github.com/justinsb) [#10437](https://github.com/kubernetes/kops/pull/10437)
* Bump helm to v3 [@olemarkus](https://github.com/olemarkus) [#10426](https://github.com/kubernetes/kops/pull/10426)
* cloudmock - guard the VPC CIDR association calls with a mutex [@rifelpet](https://github.com/rifelpet) [#10440](https://github.com/kubernetes/kops/pull/10440)
* Upgrade mkdocs dependencies to latest [@rifelpet](https://github.com/rifelpet) [#10433](https://github.com/kubernetes/kops/pull/10433)
* Spotinst: Schedule Ocean Controller to Linux nodes only [@liranp](https://github.com/liranp) [#10444](https://github.com/kubernetes/kops/pull/10444)
* Bump AWS-CNI to version 1.7.8 [@MoShitrit](https://github.com/MoShitrit) [#10447](https://github.com/kubernetes/kops/pull/10447)
* protokube - query host by label when setting tags [@rdrgmnzs](https://github.com/rdrgmnzs) [#10413](https://github.com/kubernetes/kops/pull/10413)
* Allow Calico to run on systems with loose reverse path forwarding [@hakman](https://github.com/hakman) [#10442](https://github.com/kubernetes/kops/pull/10442)
* Bump k8s versions on alpha and bump Ubuntu AMI version on stable [@MoShitrit](https://github.com/MoShitrit) [#10464](https://github.com/kubernetes/kops/pull/10464)
* Remove gjtempleton as reviewer [@gjtempleton](https://github.com/gjtempleton) [#10466](https://github.com/kubernetes/kops/pull/10466)
* Calico: Allow operators to choose which encapsulation mode to use [@seh](https://github.com/seh) [#10404](https://github.com/kubernetes/kops/pull/10404)
* Spotinst: Ignore volume type case sensitivity to prevent unnecessary updates [@liranp](https://github.com/liranp) [#10450](https://github.com/kubernetes/kops/pull/10450)
* Spotinst: Expose Ocean Headroom percentage and autoconfig labels [@liranp](https://github.com/liranp) [#10449](https://github.com/kubernetes/kops/pull/10449)
* Spotinst: Support for multiple subnets per zone [@liranp](https://github.com/liranp) [#10452](https://github.com/kubernetes/kops/pull/10452)
* Add new-pod-scale-up-delay in Cluster Autoscaler spec [@akshedu](https://github.com/akshedu) [#10471](https://github.com/kubernetes/kops/pull/10471)
* Replace (some) deprecated ResourceHolder with Resource [@justinsb](https://github.com/justinsb) [#10472](https://github.com/kubernetes/kops/pull/10472)
* Remove ResourceHolder: remove last usages and remove code [@justinsb](https://github.com/justinsb) [#10478](https://github.com/kubernetes/kops/pull/10478)
* Refactor MirroredAsset into mirrors package [@justinsb](https://github.com/justinsb) [#10475](https://github.com/kubernetes/kops/pull/10475)
* Refactor nodeUpConfigBuilder to be standalone [@justinsb](https://github.com/justinsb) [#10476](https://github.com/kubernetes/kops/pull/10476)
* Avoid recursive type definitions in schema [@justinsb](https://github.com/justinsb) [#10482](https://github.com/kubernetes/kops/pull/10482)
* Drop support for containerd 1.2 [@hakman](https://github.com/hakman) [#10483](https://github.com/kubernetes/kops/pull/10483)
* Update CNI plugins to v0.8.7 [@hakman](https://github.com/hakman) [#10481](https://github.com/kubernetes/kops/pull/10481)
* Add Azure support [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10114](https://github.com/kubernetes/kops/pull/10114)
* Refactor GCE InstanceTemplate [@justinsb](https://github.com/justinsb) [#10477](https://github.com/kubernetes/kops/pull/10477)
* Use Region method of fi.Cloud [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#10474](https://github.com/kubernetes/kops/pull/10474)
* Spotinst: Bump the Ocean Controller to 1.0.69 [@liranp](https://github.com/liranp) [#10487](https://github.com/kubernetes/kops/pull/10487)
* Added event-qps and event-burst flags to kubelet [@DOboznyi](https://github.com/DOboznyi) [#10486](https://github.com/kubernetes/kops/pull/10486)
* Add config options for container runtime package URL and Hash [@hakman](https://github.com/hakman) [#10473](https://github.com/kubernetes/kops/pull/10473)
* Fix cluster setup when KOPS_ARCH is set [@hakman](https://github.com/hakman) [#10496](https://github.com/kubernetes/kops/pull/10496)
* Docs: Rename "Development" section to "Contributing" and add instructions to update the base AMI version of Ubuntu [@MoShitrit](https://github.com/MoShitrit) [#10455](https://github.com/kubernetes/kops/pull/10455)
* Release notes for 1.19.0-beta.3 [@hakman](https://github.com/hakman) [#10497](https://github.com/kubernetes/kops/pull/10497)
* Use containerd.sock for AmazonVPC CNI with containerd [@hakman](https://github.com/hakman) [#10502](https://github.com/kubernetes/kops/pull/10502)
* Remove support for Kubenet with containerd [@hakman](https://github.com/hakman) [#10501](https://github.com/kubernetes/kops/pull/10501)
* Add containerd option for registry mirrors [@hakman](https://github.com/hakman) [#10507](https://github.com/kubernetes/kops/pull/10507)
* Treat InvalidDhcpOptionsId.NotFound as already-deleted [@wongma7](https://github.com/wongma7) [#10508](https://github.com/kubernetes/kops/pull/10508)
* Add required toleration to gpu documentation [@silashansen](https://github.com/silashansen) [#10509](https://github.com/kubernetes/kops/pull/10509)
* AWS IAM Role Tagging [@rifelpet](https://github.com/rifelpet) [#10488](https://github.com/kubernetes/kops/pull/10488)
* Update stable channel with recent k8s releases [@MoShitrit](https://github.com/MoShitrit) [#10514](https://github.com/kubernetes/kops/pull/10514)
* Run k/k's e2e suite via new kubetest2 make target [@rifelpet](https://github.com/rifelpet) [#10504](https://github.com/kubernetes/kops/pull/10504)
* Remove copyright YEAR from generated Go files [@bmelbourne](https://github.com/bmelbourne) [#10520](https://github.com/kubernetes/kops/pull/10520)
* e2e - dump cluster manifests into artifacts and add --kubernetes-version  [@rifelpet](https://github.com/rifelpet) [#10522](https://github.com/kubernetes/kops/pull/10522)
* kubetest2: Pass through some AWS env vars [@justinsb](https://github.com/justinsb) [#10525](https://github.com/kubernetes/kops/pull/10525)
* kubetest2: add initial support for GCE [@justinsb](https://github.com/justinsb) [#10524](https://github.com/kubernetes/kops/pull/10524)
* Add gp3 Volume Type to etcd [@msidwell](https://github.com/msidwell) [#10453](https://github.com/kubernetes/kops/pull/10453)
* Only include API server additional security groups in InstanceGroups for masters [@seh](https://github.com/seh) [#10519](https://github.com/kubernetes/kops/pull/10519)
* Update kube-router to v1.1.1 [@hakman](https://github.com/hakman) [#10512](https://github.com/kubernetes/kops/pull/10512)
* IRSA - continue adding route53 permisions to masters [@rifelpet](https://github.com/rifelpet) [#10529](https://github.com/kubernetes/kops/pull/10529)
* Add possibility to set volume throughput for gp3 volumes [@hakman](https://github.com/hakman) [#10530](https://github.com/kubernetes/kops/pull/10530)
* Prefix etcd cluster names with letters [@hakman](https://github.com/hakman) [#10361](https://github.com/kubernetes/kops/pull/10361)
* Recognize ubuntu 20.10 [@justinsb](https://github.com/justinsb) [#10278](https://github.com/kubernetes/kops/pull/10278)
* Don't allow ebs volume TF resource names to begin with digit [@rifelpet](https://github.com/rifelpet) [#10424](https://github.com/kubernetes/kops/pull/10424)
* Add K8s Docker runtime support deprecation release note [@bmelbourne](https://github.com/bmelbourne),[@hakman](https://github.com/hakman) [#10371](https://github.com/kubernetes/kops/pull/10371)
* Make it possible to change the etcd volume type and iops [@olemarkus](https://github.com/olemarkus) [#10461](https://github.com/kubernetes/kops/pull/10461)
* Promote Ole Markus to approvers list [@hakman](https://github.com/hakman) [#10542](https://github.com/kubernetes/kops/pull/10542)
* Add containerd config file to Flatcar based instances [@hakman](https://github.com/hakman) [#10540](https://github.com/kubernetes/kops/pull/10540)
* Add control-plane node role label to cp nodes [@olemarkus](https://github.com/olemarkus) [#10397](https://github.com/kubernetes/kops/pull/10397)
* Move bootstrapchannelbuilder to a dedicated package [@olemarkus](https://github.com/olemarkus) [#10409](https://github.com/kubernetes/kops/pull/10409)
* kubetest2: support specifying admin-access value [@justinsb](https://github.com/justinsb) [#10526](https://github.com/kubernetes/kops/pull/10526)
* GCE: Don't warn about NVME [@justinsb](https://github.com/justinsb) [#10548](https://github.com/kubernetes/kops/pull/10548)
* Simple upgrade test using kubetest2 framework [@justinsb](https://github.com/justinsb) [#10523](https://github.com/kubernetes/kops/pull/10523)
* Refactor and centralize distribution logic [@justinsb](https://github.com/justinsb) [#10538](https://github.com/kubernetes/kops/pull/10538)
* Fix to handle exit code of gazelle command in hack/verify-bazel.sh [@h3poteto](https://github.com/h3poteto) [#10182](https://github.com/kubernetes/kops/pull/10182)
* COS/GCE: exec on kubelet/flexvolume dirs [@justinsb](https://github.com/justinsb) [#10547](https://github.com/kubernetes/kops/pull/10547)
* Fix typo in comment [@fenggw-fnst](https://github.com/fenggw-fnst) [#10541](https://github.com/kubernetes/kops/pull/10541)
* Openstack: Prevent data race in servergroup member list [@justinsb](https://github.com/justinsb) [#10553](https://github.com/kubernetes/kops/pull/10553)
* Updates GCE channels to use ubuntu over COS [@geojaz](https://github.com/geojaz) [#10554](https://github.com/kubernetes/kops/pull/10554)
* Kubetest2 - use our own tester that wraps kubetest2's ginkgo tester [@rifelpet](https://github.com/rifelpet) [#10549](https://github.com/kubernetes/kops/pull/10549)
* Spotinst: Specify Spot percentage per Instance Group [@liranp](https://github.com/liranp) [#10551](https://github.com/kubernetes/kops/pull/10551)
* update gophercloud dependency [@zetaab](https://github.com/zetaab) [#10556](https://github.com/kubernetes/kops/pull/10556)
* Upgrade Go v1.15.6 / Bazel v3.4.1 [@bmelbourne](https://github.com/bmelbourne) [#10550](https://github.com/kubernetes/kops/pull/10550)
* Remove node-authorization [@olemarkus](https://github.com/olemarkus) [#10439](https://github.com/kubernetes/kops/pull/10439)
* [addons/CA] Add support for specifying resources and metrics [@dntosas](https://github.com/dntosas) [#10281](https://github.com/kubernetes/kops/pull/10281)
* Spotinst: Iterate over metadata labels only once [@liranp](https://github.com/liranp) [#10560](https://github.com/kubernetes/kops/pull/10560)
* Default cgroup driver to systemd from k8s 1.20 [@bharath-123](https://github.com/bharath-123) [#10419](https://github.com/kubernetes/kops/pull/10419)
* AWS CSI driver [@olemarkus](https://github.com/olemarkus) [#10467](https://github.com/kubernetes/kops/pull/10467)
* Upgrade cfn-lint to 0.44.3 [@rifelpet](https://github.com/rifelpet) [#10565](https://github.com/kubernetes/kops/pull/10565)
* Fix file not found error detection in fs://  [@rifelpet](https://github.com/rifelpet) [#10566](https://github.com/kubernetes/kops/pull/10566)
* Fix NLB listener -> target group association for TF & CF [@rifelpet](https://github.com/rifelpet) [#10567](https://github.com/kubernetes/kops/pull/10567)
* Spotinst: Bump the Ocean Controller to 1.0.70 [@liranp](https://github.com/liranp) [#10573](https://github.com/kubernetes/kops/pull/10573)
* Spotinst: Specify whether scale-down activities should be restricted [@liranp](https://github.com/liranp) [#10561](https://github.com/kubernetes/kops/pull/10561)
* [OpenStack] Use new hash format in instance names [@zetaab](https://github.com/zetaab) [#10557](https://github.com/kubernetes/kops/pull/10557)
* kubetest2 - Add manifest template support [@rifelpet](https://github.com/rifelpet) [#10559](https://github.com/kubernetes/kops/pull/10559)
* Updates to Alpha versions - k8s & kOps [@MoShitrit](https://github.com/MoShitrit) [#10576](https://github.com/kubernetes/kops/pull/10576)
* Use Bazel 3.4.1 for postsubmit jobs [@hakman](https://github.com/hakman) [#10578](https://github.com/kubernetes/kops/pull/10578)
* Give kubetest2 its own makefile [@rifelpet](https://github.com/rifelpet) [#10577](https://github.com/kubernetes/kops/pull/10577)
* Use consistent naming for the remaining SGRs part two [@olemarkus](https://github.com/olemarkus) [#10188](https://github.com/kubernetes/kops/pull/10188)
* [DigitalOcean] add e2e tests [@srikiz](https://github.com/srikiz) [#10575](https://github.com/kubernetes/kops/pull/10575)
* Allow nodeup (and others) to replace in-use files [@justinsb](https://github.com/justinsb) [#10581](https://github.com/kubernetes/kops/pull/10581)
* Dial-down logging on flagbuilder [@justinsb](https://github.com/justinsb) [#10582](https://github.com/kubernetes/kops/pull/10582)
* Fix default make target [@rifelpet](https://github.com/rifelpet) [#10584](https://github.com/kubernetes/kops/pull/10584)
* containerd: Add /etc/crictl config to enable crictl [@justinsb](https://github.com/justinsb) [#10585](https://github.com/kubernetes/kops/pull/10585)
* Add CF integration test for gp3 volumes [@hakman](https://github.com/hakman) [#10569](https://github.com/kubernetes/kops/pull/10569)
* Release 1.20.0-alpha.1 [@hakman](https://github.com/hakman) [#10591](https://github.com/kubernetes/kops/pull/10591)
