## Release notes for kops 1.16 series

# Significant changes

* To address the [issue](https://github.com/kubernetes/kubernetes/issues/91507) of IPv4 only clusters being susceptible to MitM attacks via IPv6 rogue router advertisements, the affected components have been upgraded as follows:
    * Docker version 19.03.11 - [CVE-2020-13401](https://github.com/docker/docker-ce/releases/v19.03.11) (optional)
    * CNI plugins 0.8.6 - [CVE-2020-10749](https://github.com/containernetworking/plugins/releases/tag/v0.8.6)
    * Calico 3.9.6 - [CVE-2020-13597](https://docs.projectcalico.org/archive/v3.9/release-notes/)
    * Weave Net 2.6.5 - [CVE-2020-11091](https://github.com/weaveworks/weave/security/advisories/GHSA-59qg-grp7-5r73)

* If upgrading from 1.11 or earlier, please see the notes in previous releases
  about upgrading through kubernetes 1.12, with the etcd3 upgrade.

* A new component runs on the master nodes now: kops-controller.
  kops-controller currently labels nodes, but will likely perform additional
  functionality in future releases.

# Breaking changes

* Support for Docker versions 1.11, 1.12 and 1.13 has been removed because of the [dockerproject.org shut down](https://www.docker.com/blog/changes-dockerproject-org-apt-yum-repositories/). Those affected must upgrade to a newer Docker version.
 
* Please see the notes in the 1.15 release about the apiGroup changing from kops
  to kops.k8s.io

* A controller is now used to apply labels to nodes.  If you are not using AWS,
  GCE or OpenStack your (non-master) nodes may not have labels applied
  correctly.

# Required Actions

* If either a Kops 1.16 alpha release or a custom Kops build was used on a cluster,
  a kops-controller Deployment may have been created that should get deleted.
  Run `kubectl -n kube-system delete deployment kops-controller` after upgrading to Kops 1.16.0-beta.1 or later.

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. This is required for newer versions of Kops.

  To enable the Pod priority feature, follow these steps:
  ```
  kops edit cluster
  # Add the following section
  spec:
    kubelet:
      featureGates:
        PodPriority: "true"
  ```
 
# Deprecations

* Support for Kubernetes releases prior to 1.9 is deprecated and will be removed in kops 1.18.

* The `kops/v1alpha1` API is deprecated and will be removed in kops 1.18. Users of `kops replace` will need to supply v1alpha2 resources.

# Full change list since 1.15.0 release

## 1.15.0-alpha.1 to 1.16.0-alpha.1

* Update release notes for 1.15.0-alpha.1 [@justinsb](https://github.com/justinsb) [#7535](https://github.com/kubernetes/kops/pull/7535)
*  When fast-building, copy a newer version of utils.tar.gz [@justinsb](https://github.com/justinsb) [#7536](https://github.com/kubernetes/kops/pull/7536)
* Bootstrap: protokube labels its own node with node-role label [@justinsb](https://github.com/justinsb) [#7537](https://github.com/kubernetes/kops/pull/7537)
* Update copyright notices [@mikesplain](https://github.com/mikesplain) [#7542](https://github.com/kubernetes/kops/pull/7542)
* Add a few docs comments on gomod and bazel [@mikesplain](https://github.com/mikesplain) [#7541](https://github.com/kubernetes/kops/pull/7541)
* Calico update and typha [@gjtempleton](https://github.com/gjtempleton),[@mikesplain](https://github.com/mikesplain) [#7528](https://github.com/kubernetes/kops/pull/7528)
* "Force" k8s 1.11.10 [@justinsb](https://github.com/justinsb) [#7423](https://github.com/kubernetes/kops/pull/7423)
* Log more sensibly when we can't get sha256 [@justinsb](https://github.com/justinsb) [#7555](https://github.com/kubernetes/kops/pull/7555)
* [Feature] CoreDNS: External CoreFile option [@gjtempleton](https://github.com/gjtempleton),[@mikesplain](https://github.com/mikesplain) [#7376](https://github.com/kubernetes/kops/pull/7376)
* Fix gomod errors [@mikesplain](https://github.com/mikesplain) [#7571](https://github.com/kubernetes/kops/pull/7571)
* Add horizontalPodAutoscalerDownscaleStabilization [@mikesplain](https://github.com/mikesplain) [#7573](https://github.com/kubernetes/kops/pull/7573)
* Associate subnets to port within OpenStack [@mitch000001](https://github.com/mitch000001) [#7578](https://github.com/kubernetes/kops/pull/7578)
* Fix kops for us-gov-east-1 #7564 [@ibrf](https://github.com/ibrf) [#7565](https://github.com/kubernetes/kops/pull/7565)
* Promote 1.13 AMI from alpha to stable [@rifelpet](https://github.com/rifelpet) [#7590](https://github.com/kubernetes/kops/pull/7590)
* Add myself @rifelpet as a reviewer [@rifelpet](https://github.com/rifelpet) [#7587](https://github.com/kubernetes/kops/pull/7587)
* Fix mkdocs [@mikesplain](https://github.com/mikesplain) [#7591](https://github.com/kubernetes/kops/pull/7591)
* Add missing OpenStack reference [@marsavela](https://github.com/marsavela) [#7567](https://github.com/kubernetes/kops/pull/7567)
* Fix Dropped Errors in upup [@alrs](https://github.com/alrs) [#7586](https://github.com/kubernetes/kops/pull/7586)
* Promote 2019-08-16 AMIs from alpha -> stable [@justinsb](https://github.com/justinsb) [#7594](https://github.com/kubernetes/kops/pull/7594)
* hack/update-expected.sh: mask development env vars [@justinsb](https://github.com/justinsb) [#7595](https://github.com/kubernetes/kops/pull/7595)
* "Force" k8s 1.11.10 in stable channel [@justinsb](https://github.com/justinsb) [#7596](https://github.com/kubernetes/kops/pull/7596)
* add cilium in error message [@PascalBourdier](https://github.com/PascalBourdier) [#7601](https://github.com/kubernetes/kops/pull/7601)
* Clean security groups if api/ssh ips are removed from config [@zetaab](https://github.com/zetaab) [#7561](https://github.com/kubernetes/kops/pull/7561)
* [DO-7442] Digital Ocean add consistent volume and droplet tags for multi master feature [@srikiz](https://github.com/srikiz) [#7566](https://github.com/kubernetes/kops/pull/7566)
* Expose API Server flags needed for AWS pod identities [@rifelpet](https://github.com/rifelpet) [#7610](https://github.com/kubernetes/kops/pull/7610)
* Add logrotate for etcd/etcd-events.log [@mikesplain](https://github.com/mikesplain) [#7614](https://github.com/kubernetes/kops/pull/7614)
* Updated container-selinux url to point to the right path [@igarcia-sugarcrm](https://github.com/igarcia-sugarcrm),[@mikesplain](https://github.com/mikesplain) [#7609](https://github.com/kubernetes/kops/pull/7609)
* Check the HTTP response code when downloading URLs [@rifelpet](https://github.com/rifelpet) [#7611](https://github.com/kubernetes/kops/pull/7611)
* Update rules_go with some fixes [@mikesplain](https://github.com/mikesplain) [#7625](https://github.com/kubernetes/kops/pull/7625)
* Change Cilium templates to standalone version [@nebril](https://github.com/nebril),[@olemarkus](https://github.com/olemarkus) [#7474](https://github.com/kubernetes/kops/pull/7474)
* Skip Docker install [@austinmoore-](https://github.com/austinmoore-) [#6957](https://github.com/kubernetes/kops/pull/6957)
* Add --wait argument to kops validate [@justinsb](https://github.com/justinsb) [#7371](https://github.com/kubernetes/kops/pull/7371)
* Fixed "NeedsUpdate" status of nodes in mixedinstancegroups after rolling update [@hippolin](https://github.com/hippolin) [#7445](https://github.com/kubernetes/kops/pull/7445)
* fix instance name [@zetaab](https://github.com/zetaab) [#7641](https://github.com/kubernetes/kops/pull/7641)
* Use without external router (OpenStack) [@zetaab](https://github.com/zetaab) [#7644](https://github.com/kubernetes/kops/pull/7644)
* Openstack: value if spec does not associate public ips [@mitch000001](https://github.com/mitch000001) [#7649](https://github.com/kubernetes/kops/pull/7649)
* Updating master IAM policies. [@michalschott](https://github.com/michalschott) [#7580](https://github.com/kubernetes/kops/pull/7580)
* Machine types g4dn [@mikesplain](https://github.com/mikesplain) [#7653](https://github.com/kubernetes/kops/pull/7653)
* OpenStack: Additional security groups for instances [@mitch000001](https://github.com/mitch000001) [#7581](https://github.com/kubernetes/kops/pull/7581)
* Add arg min-port=1024 to dnsmasq container in kube-dns [@nr17](https://github.com/nr17) [#7020](https://github.com/kubernetes/kops/pull/7020)
* Release notes for 1.13.1 [@justinsb](https://github.com/justinsb) [#7666](https://github.com/kubernetes/kops/pull/7666)
* Pull centos.org packages from the vault [@justinsb](https://github.com/justinsb) [#7674](https://github.com/kubernetes/kops/pull/7674)
* fix-typo [@tanjunchen](https://github.com/tanjunchen) [#7669](https://github.com/kubernetes/kops/pull/7669)
* Align AWS and kops validation for spot allocation strategy [@coufalja](https://github.com/coufalja) [#7660](https://github.com/kubernetes/kops/pull/7660)
* Add relnotes for 1.13.2 [@justinsb](https://github.com/justinsb) [#7681](https://github.com/kubernetes/kops/pull/7681)
* Fix some bugs reported by staticcheck [@rifelpet](https://github.com/rifelpet) [#7663](https://github.com/kubernetes/kops/pull/7663)
* Bump k8s versions in alpha channel [@olemarkus](https://github.com/olemarkus) [#7647](https://github.com/kubernetes/kops/pull/7647)
* Misleading description for KubeProxy MetricsBindAddress [@RmMsr](https://github.com/RmMsr) [#7672](https://github.com/kubernetes/kops/pull/7672)
* Fix for tarball image names after 1.16 [@justinsb](https://github.com/justinsb) [#7686](https://github.com/kubernetes/kops/pull/7686)
* Cilium standalone continuation [@olemarkus](https://github.com/olemarkus) [#7646](https://github.com/kubernetes/kops/pull/7646)
* Limit calico cpu request to 100m [@justinsb](https://github.com/justinsb) [#7688](https://github.com/kubernetes/kops/pull/7688)
* fix-up some spelling mistakes in /pkg [@tanjunchen](https://github.com/tanjunchen) [#7684](https://github.com/kubernetes/kops/pull/7684)
* kops-controller [@justinsb](https://github.com/justinsb) [#7496](https://github.com/kubernetes/kops/pull/7496)
* OpenStack: use InstanceGroup zones to populate availability zone [@mitch000001](https://github.com/mitch000001) [#7690](https://github.com/kubernetes/kops/pull/7690)
* alpha channel: image for 1.15 and general update [@justinsb](https://github.com/justinsb) [#7665](https://github.com/kubernetes/kops/pull/7665)
* Calico: upgrade pod2daemon (only) [@justinsb](https://github.com/justinsb) [#7689](https://github.com/kubernetes/kops/pull/7689)
* Add verify-staticcheck script [@rifelpet](https://github.com/rifelpet) [#7687](https://github.com/kubernetes/kops/pull/7687)
* Create tools/sha1 and sha256 helpers, simply Makefile [@justinsb](https://github.com/justinsb) [#7702](https://github.com/kubernetes/kops/pull/7702)
* kops-controller version should match version of kops [@justinsb](https://github.com/justinsb) [#7700](https://github.com/kubernetes/kops/pull/7700)
* Publish kops-controller container dump to S3/GCS [@justinsb](https://github.com/justinsb) [#7701](https://github.com/kubernetes/kops/pull/7701)
* Change from float -> resource.Quantity [@justinsb](https://github.com/justinsb) [#7708](https://github.com/kubernetes/kops/pull/7708)
* More staticcheck bugfixes and cleanup [@rifelpet](https://github.com/rifelpet) [#7696](https://github.com/kubernetes/kops/pull/7696)
* Correct word misspelling [@yuxiaobo96](https://github.com/yuxiaobo96) [#7705](https://github.com/kubernetes/kops/pull/7705)
* fix-up some spelling mistakes [@tanjunchen](https://github.com/tanjunchen) [#7704](https://github.com/kubernetes/kops/pull/7704)
* Add calico 3.9.1 [@mikesplain](https://github.com/mikesplain) [#7694](https://github.com/kubernetes/kops/pull/7694)
* Allow to use custom rootCAs [@zetaab](https://github.com/zetaab) [#7643](https://github.com/kubernetes/kops/pull/7643)
* cleanup code to cancel some staticcheck warnings [@beautytiger](https://github.com/beautytiger) [#7661](https://github.com/kubernetes/kops/pull/7661)
* Use helpers to move gzip & sha from makefile to bazel [@justinsb](https://github.com/justinsb) [#7703](https://github.com/kubernetes/kops/pull/7703)
* Update etcd-manager with OpenStack fixes [@justinsb](https://github.com/justinsb) [#7710](https://github.com/kubernetes/kops/pull/7710)
* Update etcd-manager backup image [@justinsb](https://github.com/justinsb) [#7713](https://github.com/kubernetes/kops/pull/7713)
* Update DigitalOcean CCM to v0.1.20 [@timoreimann](https://github.com/timoreimann) [#7714](https://github.com/kubernetes/kops/pull/7714)
* ineffectual assignment to [@tanjunchen](https://github.com/tanjunchen) [#7560](https://github.com/kubernetes/kops/pull/7560)
* remove duplicated entry in notes [@beautytiger](https://github.com/beautytiger) [#7715](https://github.com/kubernetes/kops/pull/7715)
* docs: fix spelling mistakes [@hwdef](https://github.com/hwdef) [#7709](https://github.com/kubernetes/kops/pull/7709)
* Docs: Adding a doc on how to propose a cherry-pick [@justinsb](https://github.com/justinsb) [#7717](https://github.com/kubernetes/kops/pull/7717)
* relnotes for 1.14.0 [@justinsb](https://github.com/justinsb) [#7725](https://github.com/kubernetes/kops/pull/7725)
* bazel: fix hashes rule to generate outputs [@justinsb](https://github.com/justinsb) [#7724](https://github.com/kubernetes/kops/pull/7724)
* remove the repeat word in docs/authentication.md b/docs/authentication.md [@tanjunchen](https://github.com/tanjunchen) [#7729](https://github.com/kubernetes/kops/pull/7729)
* Rollback alpha channels 1.14.7 [@mikesplain](https://github.com/mikesplain) [#7734](https://github.com/kubernetes/kops/pull/7734)
* Openstack block device mapping support [@Shonei](https://github.com/Shonei) [#7652](https://github.com/kubernetes/kops/pull/7652)
* Update controller-tools and CRDs [@rifelpet](https://github.com/rifelpet) [#7634](https://github.com/kubernetes/kops/pull/7634)
* Upgrade bazel's rules_go and rules_docker [@rifelpet](https://github.com/rifelpet) [#7727](https://github.com/kubernetes/kops/pull/7727)
* simplfy code [@tanjunchen](https://github.com/tanjunchen) [#7745](https://github.com/kubernetes/kops/pull/7745)
* fix-up some staticcheck error [@tanjunchen](https://github.com/tanjunchen) [#7744](https://github.com/kubernetes/kops/pull/7744)
* nodeup download: try to use compression [@justinsb](https://github.com/justinsb) [#7751](https://github.com/kubernetes/kops/pull/7751)
* Add optional RBE support for kops [@fejta](https://github.com/fejta) [#7756](https://github.com/kubernetes/kops/pull/7756)
* Update readme for 1.14 [@mikesplain](https://github.com/mikesplain) [#7757](https://github.com/kubernetes/kops/pull/7757)
* Add a BAZEL_CONFIG Makefile arg to bazel commands [@fejta](https://github.com/fejta) [#7758](https://github.com/kubernetes/kops/pull/7758)
* Memberlist gossip implementation [@jacksontj](https://github.com/jacksontj) [#7521](https://github.com/kubernetes/kops/pull/7521)
* bazel: comment out shallow_since as fails to build with bazel 1.0 [@justinsb](https://github.com/justinsb) [#7771](https://github.com/kubernetes/kops/pull/7771)
* Kops controller support for OpenStack [@zetaab](https://github.com/zetaab) [#7692](https://github.com/kubernetes/kops/pull/7692)
* Upgrade Amazon VPC CNI plugin to 1.5.4 [@rifelpet](https://github.com/rifelpet) [#7398](https://github.com/kubernetes/kops/pull/7398)
* Add documentation for updating CRDs when making API changes [@rifelpet](https://github.com/rifelpet) [#7728](https://github.com/kubernetes/kops/pull/7728)
* Kubelet configuration: Maximum pods flag is miscalculated when using Amazon VPC CNI [@liranp](https://github.com/liranp) [#7539](https://github.com/kubernetes/kops/pull/7539)
* Add event ttl flag [@tioxy](https://github.com/tioxy) [#7487](https://github.com/kubernetes/kops/pull/7487)
* docs: document state store configuration [@mitch000001](https://github.com/mitch000001) [#7750](https://github.com/kubernetes/kops/pull/7750)
* Add artifacts.k8s.io to mirror list [@justinsb](https://github.com/justinsb) [#7378](https://github.com/kubernetes/kops/pull/7378)
* fix-up gosimple check error [@tanjunchen](https://github.com/tanjunchen) [#7754](https://github.com/kubernetes/kops/pull/7754)
* fix-up staticcheck error [@tanjunchen](https://github.com/tanjunchen) [#7755](https://github.com/kubernetes/kops/pull/7755)
* remove the unnecessary newline and unused vars [@tanjunchen](https://github.com/tanjunchen) [#7760](https://github.com/kubernetes/kops/pull/7760)
* Upload dns-controller archive, use in KOPS_BASE_URL [@justinsb](https://github.com/justinsb) [#7777](https://github.com/kubernetes/kops/pull/7777)
* Move kops-controller to use a yaml configuration file [@justinsb](https://github.com/justinsb) [#7774](https://github.com/kubernetes/kops/pull/7774)
* fix(apiserver): allow multiple service-account-key-file [@hatappi](https://github.com/hatappi) [#7781](https://github.com/kubernetes/kops/pull/7781)
* Move kops-controller to daemonset [@justinsb](https://github.com/justinsb) [#7783](https://github.com/kubernetes/kops/pull/7783)
* Change default port for memberlist from 3997 [@justinsb](https://github.com/justinsb) [#7778](https://github.com/kubernetes/kops/pull/7778)
* bazel: remove deprecated stamp attribute from container building [@justinsb](https://github.com/justinsb) [#7779](https://github.com/kubernetes/kops/pull/7779)
* Promote alpha to stable, bump alpha [@mikesplain](https://github.com/mikesplain) [#7795](https://github.com/kubernetes/kops/pull/7795)
* Fix network changed in openstack ports [@zetaab](https://github.com/zetaab) [#7807](https://github.com/kubernetes/kops/pull/7807)
* Upgrade go version to 1.12.11 [@rifelpet](https://github.com/rifelpet) [#7811](https://github.com/kubernetes/kops/pull/7811)
* Rename upload command variable in Makefile [@bittopaz](https://github.com/bittopaz) [#7798](https://github.com/kubernetes/kops/pull/7798)
* fix-up bug in nodeup/pkg/model [@tanjunchen](https://github.com/tanjunchen) [#7793](https://github.com/kubernetes/kops/pull/7793)
* fix string trim func in main [@beautytiger](https://github.com/beautytiger) [#7801](https://github.com/kubernetes/kops/pull/7801)
* Alicloud: add OSS as upload dest [@bittopaz](https://github.com/bittopaz) [#7802](https://github.com/kubernetes/kops/pull/7802)
* Alicloud: fix status discovery [@bittopaz](https://github.com/bittopaz) [#7804](https://github.com/kubernetes/kops/pull/7804)
* Alicloud: add hostname override [@bittopaz](https://github.com/bittopaz) [#7803](https://github.com/kubernetes/kops/pull/7803)
* Alicloud: fix error msg when check hostname [@bittopaz](https://github.com/bittopaz) [#7814](https://github.com/kubernetes/kops/pull/7814)
* replace slice loop with append for simple and clear [@beautytiger](https://github.com/beautytiger) [#7759](https://github.com/kubernetes/kops/pull/7759)
* dnsprovider,nodeup: fix static check [@hwdef](https://github.com/hwdef) [#7818](https://github.com/kubernetes/kops/pull/7818)
* pkg: fix static check [@hwdef](https://github.com/hwdef) [#7819](https://github.com/kubernetes/kops/pull/7819)
* Add relnotes for 1.15.0-beta.1 [@justinsb](https://github.com/justinsb) [#7797](https://github.com/kubernetes/kops/pull/7797)
* Docs cleanup / mkdocs migration [@mikesplain](https://github.com/mikesplain) [#7593](https://github.com/kubernetes/kops/pull/7593)
* Allow for override of CoreDNS version [@gjtempleton](https://github.com/gjtempleton) [#7794](https://github.com/kubernetes/kops/pull/7794)
* Add netlify config [@mikesplain](https://github.com/mikesplain) [#7823](https://github.com/kubernetes/kops/pull/7823)
* Update etcd-manager to 3.0.20191025 [@justinsb](https://github.com/justinsb) [#7822](https://github.com/kubernetes/kops/pull/7822)
* Document eventTTL [@tioxy](https://github.com/tioxy) [#7826](https://github.com/kubernetes/kops/pull/7826)
* use existing network and subnet in OpenStack [@zetaab](https://github.com/zetaab) [#7699](https://github.com/kubernetes/kops/pull/7699)
* fix static check [@hwdef](https://github.com/hwdef) [#7831](https://github.com/kubernetes/kops/pull/7831)
* fix firewalls for OpenStack [@zetaab](https://github.com/zetaab) [#7829](https://github.com/kubernetes/kops/pull/7829)
* Set default image for OpenStack CCM [@zetaab](https://github.com/zetaab) [#7773](https://github.com/kubernetes/kops/pull/7773)
* Add protocol rules to master as well [@zetaab](https://github.com/zetaab) [#7834](https://github.com/kubernetes/kops/pull/7834)
* Fix permalink [@mikesplain](https://github.com/mikesplain) [#7836](https://github.com/kubernetes/kops/pull/7836)
* Remove extraneous document separator causing failures applying addons [@ripta](https://github.com/ripta) [#7857](https://github.com/kubernetes/kops/pull/7857)
* docs(addons): fix broken links [@mitch000001](https://github.com/mitch000001) [#7846](https://github.com/kubernetes/kops/pull/7846)
* Fix extraneous whitespace in warning message [@johngmyers](https://github.com/johngmyers) [#7869](https://github.com/kubernetes/kops/pull/7869)
* Revert "Upgrade Amazon VPC CNI plugin to 1.5.4" [@rifelpet](https://github.com/rifelpet) [#7847](https://github.com/kubernetes/kops/pull/7847)
* mark weavenet-pod as system-critical [@jochen42](https://github.com/jochen42) [#7874](https://github.com/kubernetes/kops/pull/7874)
* increase retry count [@zetaab](https://github.com/zetaab) [#7881](https://github.com/kubernetes/kops/pull/7881)
* awsup: fix shadowed var when looking for etcd cluster name [@diversario](https://github.com/diversario) [#7868](https://github.com/kubernetes/kops/pull/7868)
* Add back calico metrics options [@mikesplain](https://github.com/mikesplain) [#7885](https://github.com/kubernetes/kops/pull/7885)
* Fix kops upgrade cluster link [@flackdl](https://github.com/flackdl) [#7887](https://github.com/kubernetes/kops/pull/7887)
* Fix doc linkages to addons [@s3than](https://github.com/s3than),[@justinsb](https://github.com/justinsb) [#7830](https://github.com/kubernetes/kops/pull/7830)
* Alicloud: remove unnecessary if when evaluateHostnameOverride [@bittopaz](https://github.com/bittopaz) [#7850](https://github.com/kubernetes/kops/pull/7850)
* Alicloud: split ProviderID with "." [@bittopaz](https://github.com/bittopaz) [#7852](https://github.com/kubernetes/kops/pull/7852)
* Fix behavior of mock DescribeAutoScalingGroups when no names supplied [@johngmyers](https://github.com/johngmyers) [#7867](https://github.com/kubernetes/kops/pull/7867)
* Update "Guide" links for DigitalOcean & OpenStack [@jcodybaker](https://github.com/jcodybaker) [#7884](https://github.com/kubernetes/kops/pull/7884)
* Add ci postsubmit script for pushing images to staging [@justinsb](https://github.com/justinsb) [#7697](https://github.com/kubernetes/kops/pull/7697)
* remove the unnecessary break [@tanjunchen](https://github.com/tanjunchen) [#7791](https://github.com/kubernetes/kops/pull/7791)
* [DO-7442] Add gossip cluster implementation for Digital Ocean cloud provider [@srikiz](https://github.com/srikiz) [#7838](https://github.com/kubernetes/kops/pull/7838)
* fix-up static-check [@tanjunchen](https://github.com/tanjunchen) [#7841](https://github.com/kubernetes/kops/pull/7841)
* remove myself from OWNERS [@andrewsykim](https://github.com/andrewsykim) [#7888](https://github.com/kubernetes/kops/pull/7888)
* Cleanup make targets [@rifelpet](https://github.com/rifelpet) [#7863](https://github.com/kubernetes/kops/pull/7863)
* fix golint failures [@FayerZhang](https://github.com/FayerZhang) [#7854](https://github.com/kubernetes/kops/pull/7854)
* Recommend kops 1.11.1 [@justinsb](https://github.com/justinsb) [#7892](https://github.com/kubernetes/kops/pull/7892)
* fix-up staticcheck problems [@tanjunchen](https://github.com/tanjunchen) [#7839](https://github.com/kubernetes/kops/pull/7839)
* Add hint how to determine mount path of etcd data [@FuriKuri](https://github.com/FuriKuri) [#7735](https://github.com/kubernetes/kops/pull/7735)
* stable channel: promote default AMIs from alpha -> stable [@justinsb](https://github.com/justinsb) [#7893](https://github.com/kubernetes/kops/pull/7893)
* Release notes for 1.14.1 [@justinsb](https://github.com/justinsb) [#7895](https://github.com/kubernetes/kops/pull/7895)

## 1.16.0-alpha.1 to 1.16.0-alpha.2

* Add release notes for 1.16.0-alpha.1 [@justinsb](https://github.com/justinsb) [#7896](https://github.com/kubernetes/kops/pull/7896)
* stable channel: promote kubernetes 1.13.12, 1.14.8 etc [@justinsb](https://github.com/justinsb) [#7891](https://github.com/kubernetes/kops/pull/7891)
* Don't update first node in instancegroup if cluster fails validation [@johngmyers](https://github.com/johngmyers),[@justinsb](https://github.com/justinsb) [#7872](https://github.com/kubernetes/kops/pull/7872)
* add missing priorityClassName to flannel DaemonSet [@EladDolev](https://github.com/EladDolev) [#7842](https://github.com/kubernetes/kops/pull/7842)
* fix broken links [@dj80hd](https://github.com/dj80hd) [#7901](https://github.com/kubernetes/kops/pull/7901)
* Fix rendering of the Node Authorizer template [@KashifSaadat](https://github.com/KashifSaadat) [#7916](https://github.com/kubernetes/kops/pull/7916)
* Fix fork bomb in Makefile [@johngmyers](https://github.com/johngmyers) [#7935](https://github.com/kubernetes/kops/pull/7935)
* Unhide docs make logging [@mikesplain](https://github.com/mikesplain) [#7936](https://github.com/kubernetes/kops/pull/7936)
* Upgrade AWS VPC CNI to 1.5.5 [@rifelpet](https://github.com/rifelpet) [#7938](https://github.com/kubernetes/kops/pull/7938)
* Correct spelling mistakes [@yuxiaobo96](https://github.com/yuxiaobo96) [#7922](https://github.com/kubernetes/kops/pull/7922)
* Fix flannel CNI version to use 0.2.0 [@srikiz](https://github.com/srikiz) [#7924](https://github.com/kubernetes/kops/pull/7924)
* Update vendoring documentation for go modules [@rifelpet](https://github.com/rifelpet) [#7937](https://github.com/kubernetes/kops/pull/7937)
* Remove duplication and update release details [@mikesplain](https://github.com/mikesplain) [#7939](https://github.com/kubernetes/kops/pull/7939)
* Updated documentation on how to move from single to multi master [@mccare](https://github.com/mccare) [#7439](https://github.com/kubernetes/kops/pull/7439)
* Create PodDisruptionBudget for kube-dns in kube-system namespace [@hakman](https://github.com/hakman) [#7856](https://github.com/kubernetes/kops/pull/7856)
* Add support for newer Docker versions [@hakman](https://github.com/hakman) [#7860](https://github.com/kubernetes/kops/pull/7860)
* Machine types updates [@mikesplain](https://github.com/mikesplain) [#7947](https://github.com/kubernetes/kops/pull/7947)
* fix 404 urls in docs [@tanjunchen](https://github.com/tanjunchen) [#7943](https://github.com/kubernetes/kops/pull/7943)
* Fix generation of documentation /sitemap.xml file [@aledbf](https://github.com/aledbf) [#7949](https://github.com/kubernetes/kops/pull/7949)
* Kops site link [@mikesplain](https://github.com/mikesplain) [#7950](https://github.com/kubernetes/kops/pull/7950)
* Fix netlify mixed content [@mikesplain](https://github.com/mikesplain) [#7953](https://github.com/kubernetes/kops/pull/7953)
* Fix goimports errors [@rifelpet](https://github.com/rifelpet) [#7955](https://github.com/kubernetes/kops/pull/7955)
* Upate Lyft CNI to v0.5.1 [@maruina](https://github.com/maruina) [#7402](https://github.com/kubernetes/kops/pull/7402)

## 1.16.0-alpha.2 to 1.16.0-beta.1

* Complete support for Flatcar [@mazzy89](https://github.com/mazzy89) [#7545](https://github.com/kubernetes/kops/pull/7545)
* Fix mounting Calico "flexvol-driver-host" in CoreOS [@hakman](https://github.com/hakman) [#8062](https://github.com/kubernetes/kops/pull/8062)
* fix(openstack): fix additional security groups on instance groups [@mitch000001](https://github.com/mitch000001) [#8004](https://github.com/kubernetes/kops/pull/8004)
* Cloud controller template function [@DavidSie](https://github.com/DavidSie) [#7992](https://github.com/kubernetes/kops/pull/7992)
* Add CapacityOptimized to list of supported spot allocation strategies [@gjtempleton](https://github.com/gjtempleton) [#7406](https://github.com/kubernetes/kops/pull/7406)
* Add inf1 isntances [@mikesplain](https://github.com/mikesplain) [#8128](https://github.com/kubernetes/kops/pull/8128)
* Openstack: Fix cluster floating ips [@mitch000001](https://github.com/mitch000001) [#8115](https://github.com/kubernetes/kops/pull/8115)
* [Issue-7870] kops controller support for digital ocean [@srikiz](https://github.com/srikiz) [#7961](https://github.com/kubernetes/kops/pull/7961)
* Fix Handling of LaunchTemplate Versions for MixedInstancePolicy [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#8038](https://github.com/kubernetes/kops/pull/8038)
* Bump cilium version to 1.6.4 [@olemarkus](https://github.com/olemarkus) [#8022](https://github.com/kubernetes/kops/pull/8022)
* Update copyrights for 2020 [@johngmyers](https://github.com/johngmyers) [#8241](https://github.com/kubernetes/kops/pull/8241)
* cilium: don't try to mount sys/fs/bpf if already mounted [@justinsb](https://github.com/justinsb) [#7832](https://github.com/kubernetes/kops/pull/7832)
* Fix protokube osx build [@mikesplain](https://github.com/mikesplain) [#8263](https://github.com/kubernetes/kops/pull/8263)
* Add deprecation warning for older k8s versions [@rifelpet](https://github.com/rifelpet) [#8176](https://github.com/kubernetes/kops/pull/8176)
* Remove kops-controller deployment [@rifelpet](https://github.com/rifelpet) [#8273](https://github.com/kubernetes/kops/pull/8273)
* Promote peter & ryan & zetaab to approvers [@justinsb](https://github.com/justinsb) [#7983](https://github.com/kubernetes/kops/pull/7983)
* Fix crossbuild-nodeup-in-docker [@johngmyers](https://github.com/johngmyers) [#8343](https://github.com/kubernetes/kops/pull/8343)
* Add release notes for deleting the kops-controller deployment [@rifelpet](https://github.com/rifelpet) [#8321](https://github.com/kubernetes/kops/pull/8321)
* Configuration to specify no SSH key [@austinmoore-](https://github.com/austinmoore-) [#7096](https://github.com/kubernetes/kops/pull/7096)
* Set CLUSTER_NAME env var on amazon-vpc-cni pods [@rifelpet](https://github.com/rifelpet) [#8274](https://github.com/kubernetes/kops/pull/8274)
* Don't output empty sections in the manifests [@justinsb](https://github.com/justinsb) [#8317](https://github.com/kubernetes/kops/pull/8317)
* Fix issues with older versions of k8s for basic clusters [@hakman](https://github.com/hakman),[@rifelpet](https://github.com/rifelpet) [#8248](https://github.com/kubernetes/kops/pull/8248)
* Backport the k8s 1.9 required action release note [@johngmyers](https://github.com/johngmyers) [#8378](https://github.com/kubernetes/kops/pull/8378)
* Fix scheduler policy configmap args [@vvbogdanov87](https://github.com/vvbogdanov87) [#8386](https://github.com/kubernetes/kops/pull/8386)
* Use IAMPrefix() for hostedzone [@lazzarello](https://github.com/lazzarello) [#8366](https://github.com/kubernetes/kops/pull/8366)
* Add Cilium.EnablePolicy back into templates [@olemarkus](https://github.com/olemarkus) [#8379](https://github.com/kubernetes/kops/pull/8379)
* CoreDNS default image bump to 1.6.6 to resolve CVE [@gjtempleton](https://github.com/gjtempleton) [#8333](https://github.com/kubernetes/kops/pull/8333)
* Don't load nonexistent calico-client cert when CNI is Cilium [@johngmyers](https://github.com/johngmyers) [#8338](https://github.com/kubernetes/kops/pull/8338)
* Kops releases - prefix git tags with v [@rifelpet](https://github.com/rifelpet) [#8373](https://github.com/kubernetes/kops/pull/8373)
* EBS Root Volume Termination [@tioxy](https://github.com/tioxy) [#7865](https://github.com/kubernetes/kops/pull/7865)
* Announce impending removal of v1alpha1 API [@johngmyers](https://github.com/johngmyers) [#8064](https://github.com/kubernetes/kops/pull/8064)
* Add missing priorityClassName for critical pods [@johngmyers](https://github.com/johngmyers) [#8200](https://github.com/kubernetes/kops/pull/8200)

## 1.16.0-beta.1 to 1.16.0-beta.2

* Fix Github download url for nodeup [@adri](https://github.com/adri),[@justinsb](https://github.com/justinsb) [#8468](https://github.com/kubernetes/kops/pull/8468)
* GCS: Don't try to set ACLs if bucket-policy only is set [@justinsb](https://github.com/justinsb) [#8493](https://github.com/kubernetes/kops/pull/8493)
* Alicloud: allow use RAM role for OSS client [@bittopaz](https://github.com/bittopaz) [#8025](https://github.com/kubernetes/kops/pull/8025)
* Cilium - Add missing Identity Allocation Mode to Operator Template [@daviddyball](https://github.com/daviddyball) [#8445](https://github.com/kubernetes/kops/pull/8445)
* Make it possible to enable Prometheus metrics for Cilium [@olemarkus](https://github.com/olemarkus) [#8433](https://github.com/kubernetes/kops/pull/8433)
* Update cilium to 1.6.6 [@olemarkus](https://github.com/olemarkus) [#8484](https://github.com/kubernetes/kops/pull/8484)

## 1.16.0-beta.2 to 1.16.0

* Stabilize sequence of "export xx=xxx" statements [@bittopaz](https://github.com/bittopaz) [#8247](https://github.com/kubernetes/kops/pull/8247)
* Add events RBAC permissions to kops-controller [@rifelpet](https://github.com/rifelpet) [#8535](https://github.com/kubernetes/kops/pull/8535)
* Update AWS IAM Authenticator to 0.5.0 [@rifelpet](https://github.com/rifelpet) [#8423](https://github.com/kubernetes/kops/pull/8423)
* Update IAM permissions for amazon-vpc-cni-k8s 1.6.0 [@rifelpet](https://github.com/rifelpet) [#8548](https://github.com/kubernetes/kops/pull/8548)
* Update amazon-vpc-cni-k8s to v1.6.0 [@hakman](https://github.com/hakman) [#8538](https://github.com/kubernetes/kops/pull/8538)
* Switch AWS IAM Authenticator to use non-scratch image [@rifelpet](https://github.com/rifelpet) [#8555](https://github.com/kubernetes/kops/pull/8555)
* Fix DNS loop on Ubuntu 18.04 (Bionic) [@hakman](https://github.com/hakman) [#8353](https://github.com/kubernetes/kops/pull/8353)
* Revert update of AWS IAM Authenticator to 0.5.0 for 1.16 [@rifelpet](https://github.com/rifelpet) [#8583](https://github.com/kubernetes/kops/pull/8583)
* add s3 region [@zetaab](https://github.com/zetaab) [#8592](https://github.com/kubernetes/kops/pull/8592)
* Update coredns to 1.6.7 [@maruina](https://github.com/maruina) [#8602](https://github.com/kubernetes/kops/pull/8602)
* Cilium fix bpffs check [@olemarkus](https://github.com/olemarkus) [#8599](https://github.com/kubernetes/kops/pull/8599)
* Fix periodic e2e test for Ubuntu 16.04 [@hakman](https://github.com/hakman) [#8160](https://github.com/kubernetes/kops/pull/8160)

## 1.16.0 to 1.16.1

* Add indent template function and use it to fix KubeDNS.ExternalCoreFile rendering [@rochacon](https://github.com/rochacon) [#7979](https://github.com/kubernetes/kops/pull/7979)
* Bump Cilium to 1.7 for k8s 1.12+ [@olemarkus](https://github.com/olemarkus) [#8589](https://github.com/kubernetes/kops/pull/8589)
* Implementing audit dynamic configuration (#7392) [@mmerrill3](https://github.com/mmerrill3) [#7424](https://github.com/kubernetes/kops/pull/7424)
* Revert "Automated cherry pick of #8589: Bump Cilium to 1.7 for k8s 1.12+ #8591: Fix typo in the cilium default version" [@olemarkus](https://github.com/olemarkus) [#8677](https://github.com/kubernetes/kops/pull/8677)
* Use latest patch release for Calico, Canal and Cilium [@hakman](https://github.com/hakman) [#8698](https://github.com/kubernetes/kops/pull/8698)
* Fix uploading of file assets [@johngmyers](https://github.com/johngmyers) [#8694](https://github.com/kubernetes/kops/pull/8694)
* Tag EBS volumes when using launch templates with AWS API target [@johngmyers](https://github.com/johngmyers),[@hakman](https://github.com/hakman) [#8462](https://github.com/kubernetes/kops/pull/8462)
* Fix RollingUpdate behaviour when using LaunchTemplates for both kops & terraform spec updates [@KashifSaadat](https://github.com/KashifSaadat),[@qqshfox](https://github.com/qqshfox) [#8261](https://github.com/kubernetes/kops/pull/8261)
* Enable stamping on bazel image builds [@rifelpet](https://github.com/rifelpet) [#8835](https://github.com/kubernetes/kops/pull/8835)
* Update lyft CNI to 0.6.0 [@maruina](https://github.com/maruina) [#8757](https://github.com/kubernetes/kops/pull/8757)
* Remove support for Docker 1.11, 1.12 and 1.13 [@hakman](https://github.com/hakman) [#8855](https://github.com/kubernetes/kops/pull/8855)
* Fix kuberouter for k8s 1.16+ [@UnderMyBed](https://github.com/UnderMyBed),[@hakman](https://github.com/hakman) [#8697](https://github.com/kubernetes/kops/pull/8697)
* Fix tests for obsolete Docker versions in 1.16 [@hakman](https://github.com/hakman) [#8890](https://github.com/kubernetes/kops/pull/8890)
* Load the correct certificate before deleting [@olemarkus](https://github.com/olemarkus) [#8945](https://github.com/kubernetes/kops/pull/8945)
* Use non-experimental version of encryption provider config flag in 1.13+ [@zacblazic](https://github.com/zacblazic) [#7900](https://github.com/kubernetes/kops/pull/7900)

## 1.16.1 to 1.16.2

* Add support for Ubuntu 20.04 (Focal) [@hakman](https://github.com/hakman) [#8925](https://github.com/kubernetes/kops/pull/8925)
* feat(openstack): propagate cloud labels to machines [@mitch000001](https://github.com/mitch000001) [#9013](https://github.com/kubernetes/kops/pull/9013)
* Back-port well known owner aliases and SSH users to 1.16 [@hakman](https://github.com/hakman) [#9036](https://github.com/kubernetes/kops/pull/9036)
* Use Ubuntu 18.04 Docker packages for Ubuntu 20.04 setups [@hakman](https://github.com/hakman) [#9046](https://github.com/kubernetes/kops/pull/9046)
* Make cilium operator health check go against localhost IP [@olemarkus](https://github.com/olemarkus) [#9045](https://github.com/kubernetes/kops/pull/9045)
* Update to etcd-manager 3.0.20200428 [@justinsb](https://github.com/justinsb) [#9042](https://github.com/kubernetes/kops/pull/9042)

## 1.16.2 to 1.16.3

* Revert "Automated cherry pick of #8999: feat(openstack): propagate cloud labels to machines" [@zetaab](https://github.com/zetaab) [#9089](https://github.com/kubernetes/kops/pull/9089)
* Reduce the number of TravisCI jobs for release branch [@hakman](https://github.com/hakman) [#9081](https://github.com/kubernetes/kops/pull/9081)
* Fix zsh completion [@olemarkus](https://github.com/olemarkus) [#9108](https://github.com/kubernetes/kops/pull/9108)
* Allow cluster maintenance when channel is unavailable [@johngmyers](https://github.com/johngmyers) [#9053](https://github.com/kubernetes/kops/pull/9053)
* Upgrade amazon vpc cni to 1.6.1 [@rifelpet](https://github.com/rifelpet) [#9020](https://github.com/kubernetes/kops/pull/9020)
* Use systemd-timesyncd for Ubuntu 20.04 [@hakman](https://github.com/hakman) [#9182](https://github.com/kubernetes/kops/pull/9182)
* Remove all versions of a file from the S3 bucket [@hakman](https://github.com/hakman) [#9171](https://github.com/kubernetes/kops/pull/9171)
* Allow listing versions for objects in the S3 bucket [@hakman](https://github.com/hakman) [#9205](https://github.com/kubernetes/kops/pull/9205)

## 1.16.3 to 1.16.4

* Update etcd-manager to 3.0.20200531 [@hakman](https://github.com/hakman) [#9237](https://github.com/kubernetes/kops/pull/9237)
* Use CNI 0.8.6 for Kubernetes 1.15+ [@hakman](https://github.com/hakman) [#9256](https://github.com/kubernetes/kops/pull/9256)
* Use Docker 19.03.11 for Kubernetes 1.17+ [@hakman](https://github.com/hakman) [#9314](https://github.com/kubernetes/kops/pull/9314)
* Fix missing changes in Weave manifest [@hakman](https://github.com/hakman) [#8965](https://github.com/kubernetes/kops/pull/8965)
* Update Weave Net to 2.6.5 [@hakman](https://github.com/hakman) [#9330](https://github.com/kubernetes/kops/pull/9330)
* Update Calico for CVE-2020-13597 [@hakman](https://github.com/hakman) [#9331](https://github.com/kubernetes/kops/pull/9331)
* Add support for c5a aws ec2 instance types [@coolstang](https://github.com/coolstang) [#9386](https://github.com/kubernetes/kops/pull/9386)
