## Release notes for kops 1.10 series

# Significant changes

* Old LaunchConfigurations are now deleted on AWS.  By default the 3 most recent LaunchConfigurations for each InstanceGroup are kept, and older ones are automatically removed.  To keep the existing behaviour set the KeepLaunchConfigurations feature flag i.e. `export KOPS_FEATURE_FLAGS=KeepLaunchConfigurations`

# Required Actions

None known at this time

# Highlighted changes

(coming soon)

# Full change list since 1.9.0 release

## 1.9.0 - 1.10.0

* Update alpha channel with latest k8s releases [@justinsb](https://github.com/justinsb) [#4965](https://github.com/kubernetes/kops/pull/4965)
* 1.9.0 release notes [@justinsb](https://github.com/justinsb) [#4964](https://github.com/kubernetes/kops/pull/4964)
* digitalocean tutorial [@andrewsykim](https://github.com/andrewsykim) [#4976](https://github.com/kubernetes/kops/pull/4976)
* Update roadmap [@justinsb](https://github.com/justinsb) [#4966](https://github.com/kubernetes/kops/pull/4966)
* digitalocean: use new droplet sizes providing the same resources at cheaper prices [@andrewsykim](https://github.com/andrewsykim) [#5005](https://github.com/kubernetes/kops/pull/5005)
* Set AWS_REGION into bootstrapscript [@justinsb](https://github.com/justinsb) [#4982](https://github.com/kubernetes/kops/pull/4982)
* digitalocean: only delete A DNS records [@andrewsykim](https://github.com/andrewsykim) [#5006](https://github.com/kubernetes/kops/pull/5006)
* AWS: validate region against aws-sdk [@justinsb](https://github.com/justinsb) [#4983](https://github.com/kubernetes/kops/pull/4983)
* Treat Amazon Linux 2 as CentOS 7 [@sonaltr](https://github.com/sonaltr) [#5028](https://github.com/kubernetes/kops/pull/5028)
* Update bazel [@mikesplain](https://github.com/mikesplain) [#5032](https://github.com/kubernetes/kops/pull/5032)
* Add missing google cloud zones [@povilasv](https://github.com/povilasv) [#5022](https://github.com/kubernetes/kops/pull/5022)
* Update generated docs for 1.10 [@justinsb](https://github.com/justinsb) [#5034](https://github.com/kubernetes/kops/pull/5034)
* gazelle: use separate gazelle [@justinsb](https://github.com/justinsb) [#5036](https://github.com/kubernetes/kops/pull/5036)
* Bump recommended version for kops 1.9.0 [@mikesplain](https://github.com/mikesplain) [#5041](https://github.com/kubernetes/kops/pull/5041)
* fix IAM role for current versions of the kube-ingress-aws-controller [@szuecs](https://github.com/szuecs) [#5014](https://github.com/kubernetes/kops/pull/5014)
* Add docker 17.09.0 version for Debian 9 [@Cryptophobia](https://github.com/Cryptophobia) [#5042](https://github.com/kubernetes/kops/pull/5042)
* Fixes environment variable export. [@Raffo](https://github.com/Raffo) [#5016](https://github.com/kubernetes/kops/pull/5016)
* fix :"rbac" should be "RBAC" [@yulng](https://github.com/yulng) [#4993](https://github.com/kubernetes/kops/pull/4993)
* upgrade kube-dns to 1.14.10, fixes #4986 [@jjo](https://github.com/jjo) [#5026](https://github.com/kubernetes/kops/pull/5026)
* makefile: fix bazel-push [@justinsb](https://github.com/justinsb) [#5053](https://github.com/kubernetes/kops/pull/5053)
* Typo fix aditional->additional [@AdamDang](https://github.com/AdamDang) [#5058](https://github.com/kubernetes/kops/pull/5058)
* Add Replace and delete for SSH Secret YAML [@mikesplain](https://github.com/mikesplain) [#5050](https://github.com/kubernetes/kops/pull/5050)
* Typo fix in addons.md [@AdamDang](https://github.com/AdamDang) [#5069](https://github.com/kubernetes/kops/pull/5069)
* Update readme for 1.9 [@mikesplain](https://github.com/mikesplain) [#4963](https://github.com/kubernetes/kops/pull/4963)
* Make LogSeveritySys configurable for Canal Networking [@KashifSaadat](https://github.com/KashifSaadat) [#5068](https://github.com/kubernetes/kops/pull/5068)
* Typo fix in 1.9-NOTES.md: compatibility->compatibility [@AdamDang](https://github.com/AdamDang) [#5073](https://github.com/kubernetes/kops/pull/5073) (fixed typo in message for verify - @chrisz100)
* Typo fix: Kuberenetes->Kubernetes [@AdamDang](https://github.com/AdamDang) [#5079](https://github.com/kubernetes/kops/pull/5079)
* Typo fix: seet->set [@AdamDang](https://github.com/AdamDang) [#5080](https://github.com/kubernetes/kops/pull/5080)
* Typo fix in vsphere-development-status.md: secrete->secret [@AdamDang](https://github.com/AdamDang) [#5084](https://github.com/kubernetes/kops/pull/5084)
* Perform deep merge for template values [@gwkunze](https://github.com/gwkunze) [#4668](https://github.com/kubernetes/kops/pull/4668)
* Note that `kops rolling-update` is required after tf apply [@fgrehm](https://github.com/fgrehm) [#5081](https://github.com/kubernetes/kops/pull/5081)
* Typo fix: wil->will [@AdamDang](https://github.com/AdamDang) [#5091](https://github.com/kubernetes/kops/pull/5091)
* Add SubnetType tags to run_in_existing_vpc docs [@tsupertramp](https://github.com/tsupertramp) [#5094](https://github.com/kubernetes/kops/pull/5094)
* Typo fix: actually->actually/overide->override/to to->to [@AdamDang](https://github.com/AdamDang) [#5099](https://github.com/kubernetes/kops/pull/5099) (fixed typo in message for verify - @chrisz100)
* Typo fix detaults->defaults [@AdamDang](https://github.com/AdamDang) [#5067](https://github.com/kubernetes/kops/pull/5067)
* Update upgrade_from_kops_1.6_to_1.7_calico_cidr_migration.md [@AdamDang](https://github.com/AdamDang) [#5107](https://github.com/kubernetes/kops/pull/5107)
* Typo fix: healthly->healthy [@AdamDang](https://github.com/AdamDang) [#5125](https://github.com/kubernetes/kops/pull/5125)
*  Remove custom Statement IDs from IAM Policy Statements [@KashifSaadat](https://github.com/KashifSaadat) [#4958](https://github.com/kubernetes/kops/pull/4958)
* Adds new kops logo [@iMartyn](https://github.com/iMartyn) [#5113](https://github.com/kubernetes/kops/pull/5113)
* Update rules go to support go 1.10.2 and 1.9.6 [@mikesplain](https://github.com/mikesplain) [#5100](https://github.com/kubernetes/kops/pull/5100)
* Typo fix in returned message: formated->formatted [@AdamDang](https://github.com/AdamDang) [#5112](https://github.com/kubernetes/kops/pull/5112)
* Fix for validating kubeconfig's hosts [@0mok](https://github.com/0mok) [#5096](https://github.com/kubernetes/kops/pull/5096)
* Add ability to use ec2 nat instance as egress [@relu](https://github.com/relu) [#5133](https://github.com/kubernetes/kops/pull/5133)
* Added tls certificate and private key path flags to kubelet config [@chrisz100](https://github.com/chrisz100) [#5088](https://github.com/kubernetes/kops/pull/5088)
* kubelet: expose --experimental-allowed-unsafe-sysctls [@smcquay](https://github.com/smcquay) [#5104](https://github.com/kubernetes/kops/pull/5104)
* Update docker image versions [@justinsb](https://github.com/justinsb) [#5057](https://github.com/kubernetes/kops/pull/5057)
* CoreDNS in Kops as an addon [@rajansandeep](https://github.com/rajansandeep) [#4041](https://github.com/kubernetes/kops/pull/4041)
* Implement network task for AlibabaCloud [@LilyFaFa](https://github.com/LilyFaFa),[@xh4n3](https://github.com/xh4n3) [#4991](https://github.com/kubernetes/kops/pull/4991)
* Allow rolling-update to filter on roles [@justinsb](https://github.com/justinsb) [#5122](https://github.com/kubernetes/kops/pull/5122)
* Remove stub tests [@justinsb](https://github.com/justinsb) [#5117](https://github.com/kubernetes/kops/pull/5117)
* Don't tag shared instances at all [@justinsb](https://github.com/justinsb) [#5138](https://github.com/kubernetes/kops/pull/5138)
* fix:please N/A should be " Not Applicable" [@yulng](https://github.com/yulng) [#4994](https://github.com/kubernetes/kops/pull/4994)
* Re-enable validation of DNS ServerIP [@justinsb](https://github.com/justinsb) [#5142](https://github.com/kubernetes/kops/pull/5142)
* digitalocean: don't set --cloud-provider=external on control plane starting v1.10 [@andrewsykim](https://github.com/andrewsykim) [#4990](https://github.com/kubernetes/kops/pull/4990)
* [instance_groups.md] typo: receive->receive [@AdamDang](https://github.com/AdamDang) [#5152](https://github.com/kubernetes/kops/pull/5152) (fixed typo in message for verify - @chrisz100)
* Update docs regarding shared NAT Instances setup [@relu](https://github.com/relu) [#5151](https://github.com/kubernetes/kops/pull/5151)
* Update office hours time to account for DST [@mikesplain](https://github.com/mikesplain) [#5148](https://github.com/kubernetes/kops/pull/5148)
* set default GracePeriodSeconds to -1 when draining nodes [@rajatjindal](https://github.com/rajatjindal) [#5143](https://github.com/kubernetes/kops/pull/5143)
* implement disk task for ALICloud and fix typos [@LilyFaFa](https://github.com/LilyFaFa) [#5158](https://github.com/kubernetes/kops/pull/5158)
* Unify create-create overrides and set-cluster fields [@justinsb](https://github.com/justinsb) [#5123](https://github.com/kubernetes/kops/pull/5123)
* Typo fix in the returned message: runnning->running [@AdamDang](https://github.com/AdamDang) [#5186](https://github.com/kubernetes/kops/pull/5186)
* Documentation - networking Amazon VPC backend [@recollir](https://github.com/recollir) [#5180](https://github.com/kubernetes/kops/pull/5180)
* added i3.metal AWS instance type [@DavidXArnold](https://github.com/DavidXArnold) [#5189](https://github.com/kubernetes/kops/pull/5189)
* Documentation - cloudProvider required in kubelet spec with Amazon VPC backend [@recollir](https://github.com/recollir) [#5181](https://github.com/kubernetes/kops/pull/5181)
* 1.8 release notes correctly note `replace --force` [@wendorf](https://github.com/wendorf) [#5182](https://github.com/kubernetes/kops/pull/5182)
* CA Key File Permissions [@gambol99](https://github.com/gambol99) [#5196](https://github.com/kubernetes/kops/pull/5196)
* Expose streaming connection idle timeout [@aleerizw](https://github.com/aleerizw) [#5155](https://github.com/kubernetes/kops/pull/5155)
* implement SSHKey task for ALICloud [@LilyFaFa](https://github.com/LilyFaFa) [#5184](https://github.com/kubernetes/kops/pull/5184)
* Documentation - updated example for dashboard installation to 1.8.3 [@recollir](https://github.com/recollir) [#5198](https://github.com/kubernetes/kops/pull/5198)
* Update CoreDNS manifest [@rajansandeep](https://github.com/rajansandeep) [#5203](https://github.com/kubernetes/kops/pull/5203)
* Create initial docs for etcd-manager [@justinsb](https://github.com/justinsb) [#5210](https://github.com/kubernetes/kops/pull/5210)
* Support (optional) etcd-manager [@justinsb](https://github.com/justinsb) [#5126](https://github.com/kubernetes/kops/pull/5126)
* Create override for etcd-manager image [@justinsb](https://github.com/justinsb) [#5136](https://github.com/kubernetes/kops/pull/5136)
* Typo fix: attatch->attach [@AdamDang](https://github.com/AdamDang) [#5160](https://github.com/kubernetes/kops/pull/5160)
* Add a FIXME and don't log about insecure ports [@dims](https://github.com/dims) [#5178](https://github.com/kubernetes/kops/pull/5178)
* Add support for C5D instance family on AWS [@ripta](https://github.com/ripta) [#5179](https://github.com/kubernetes/kops/pull/5179)
* Add stdin support for create -f and replace -f [@ihoegen](https://github.com/ihoegen) [#5150](https://github.com/kubernetes/kops/pull/5150)
* Update AWS AMI for kubernetes >=1.9.0 <1.10.0 [@AmazingDreams](https://github.com/AmazingDreams) [#5173](https://github.com/kubernetes/kops/pull/5173)
* Kuberenets 1.11 has deprecated ExternalID this replaces it with Provi… [@zachaller](https://github.com/zachaller) [#5167](https://github.com/kubernetes/kops/pull/5167)
* Update alpha channel with latest k8s versions [@justinsb](https://github.com/justinsb) [#5217](https://github.com/kubernetes/kops/pull/5217)
* Update alpha channel with latest images [@justinsb](https://github.com/justinsb) [#5222](https://github.com/kubernetes/kops/pull/5222)
* Recommend kops 1.9.1 in alpha channel [@justinsb](https://github.com/justinsb) [#5218](https://github.com/kubernetes/kops/pull/5218)
* PSP Updates, new apiGroup for k8s v1.10 [@KashifSaadat](https://github.com/KashifSaadat) [#5225](https://github.com/kubernetes/kops/pull/5225)
* Create addon for prometheus-operator [@gianrubio](https://github.com/gianrubio) [#5140](https://github.com/kubernetes/kops/pull/5140)
* Fixing name of cert file  [#5220](https://github.com/kubernetes/kops/pull/5220)
* Promote alpha channel to stable [@justinsb](https://github.com/justinsb) [#5216](https://github.com/kubernetes/kops/pull/5216)
* Add --enable-admission-plugins API server flag for k8s 1.10 [@ripta](https://github.com/ripta) [#5221](https://github.com/kubernetes/kops/pull/5221)
* Fix typo: "to user" -> "to use" [@justinsb](https://github.com/justinsb) [#5232](https://github.com/kubernetes/kops/pull/5232)
* Bump Cilium version to released [@nebril](https://github.com/nebril) [#5208](https://github.com/kubernetes/kops/pull/5208)
* Typo fix: are be->are [@AdamDang](https://github.com/AdamDang) [#5237](https://github.com/kubernetes/kops/pull/5237)
* Add proper autoloading for kops autocomplete [@ihoegen](https://github.com/ihoegen) [#5230](https://github.com/kubernetes/kops/pull/5230)
* Fix typo: adddresses -> addresses [@justinsb](https://github.com/justinsb) [#5235](https://github.com/kubernetes/kops/pull/5235)
* Replace deprecated flags: address -> insecure-bind-address [@justinsb](https://github.com/justinsb) [#5234](https://github.com/kubernetes/kops/pull/5234)
* Add AuthenticationTokenWebhook flag [@ihoegen](https://github.com/ihoegen) [#5231](https://github.com/kubernetes/kops/pull/5231)
* Setup heptio authenticator [@rdrgmnzs](https://github.com/rdrgmnzs) [#5197](https://github.com/kubernetes/kops/pull/5197)
* File Permissions Private Key [@gambol99](https://github.com/gambol99) [#5241](https://github.com/kubernetes/kops/pull/5241)
* Correct PSP RoleBinding with namespace for kube-system [@KashifSaadat](https://github.com/KashifSaadat) [#5244](https://github.com/kubernetes/kops/pull/5244)
* Fix an error. [@mahuihuang](https://github.com/mahuihuang) [#4942](https://github.com/kubernetes/kops/pull/4942)
* Upgrade to flannel v0.10.0 and explicitly specify amd64 arch [@martinhoefling](https://github.com/martinhoefling) [#5095](https://github.com/kubernetes/kops/pull/5095)
* hacks for tests on windows [@sroylance](https://github.com/sroylance) [#4723](https://github.com/kubernetes/kops/pull/4723)
* Admission Controller Fix [@gambol99](https://github.com/gambol99) [#5248](https://github.com/kubernetes/kops/pull/5248)
* Use HomeDir from client-go to get home directory [@justinsb](https://github.com/justinsb) [#5249](https://github.com/kubernetes/kops/pull/5249)
* Add public ssh keys for GCE [@povilasv](https://github.com/povilasv) [#5056](https://github.com/kubernetes/kops/pull/5056)
* Release windows build in alpha [@chrislovecnm](https://github.com/chrislovecnm) [#4524](https://github.com/kubernetes/kops/pull/4524)
* some typo fix [@liwjGhostcloud](https://github.com/liwjGhostcloud) [#4937](https://github.com/kubernetes/kops/pull/4937)
* docker: Set TasksMax to infinity [@justinsb](https://github.com/justinsb) [#5259](https://github.com/kubernetes/kops/pull/5259)
* Update aws-sdk-go to v1.13.60 [@justinsb](https://github.com/justinsb) [#5261](https://github.com/kubernetes/kops/pull/5261)
* Put verify-apimachinery into ci makefile target [@justinsb](https://github.com/justinsb) [#5262](https://github.com/kubernetes/kops/pull/5262)
* Perf fix for makefile [@justinsb](https://github.com/justinsb) [#5255](https://github.com/kubernetes/kops/pull/5255)
* Use STABLE_ prefixes for bazel workspace vars [@justinsb](https://github.com/justinsb) [#5257](https://github.com/kubernetes/kops/pull/5257)
* bazel: add notes that tasks do not work [@justinsb](https://github.com/justinsb) [#5263](https://github.com/kubernetes/kops/pull/5263)
* vendor gazelle [@justinsb](https://github.com/justinsb) [#4564](https://github.com/kubernetes/kops/pull/4564)
* Clean up variable naming in integration test [@justinsb](https://github.com/justinsb) [#5264](https://github.com/kubernetes/kops/pull/5264)
* Allow integration tests to update expected TF output [@justinsb](https://github.com/justinsb) [#5265](https://github.com/kubernetes/kops/pull/5265)
* Validate FileAssets [@gambol99](https://github.com/gambol99) [#5272](https://github.com/kubernetes/kops/pull/5272)
* Validate InstanceGroup Hooks [@gambol99](https://github.com/gambol99) [#5271](https://github.com/kubernetes/kops/pull/5271)
* Update bazel gazelle [@mikesplain](https://github.com/mikesplain) [#5274](https://github.com/kubernetes/kops/pull/5274)
* Fix go version hack to be more generic. [@mikesplain](https://github.com/mikesplain) [#5267](https://github.com/kubernetes/kops/pull/5267)
* CoreDNS pull image from gcr.io [@rajansandeep](https://github.com/rajansandeep) [#5268](https://github.com/kubernetes/kops/pull/5268)
* Clarify the usage of the --state flag. [@rdrgmnzs](https://github.com/rdrgmnzs) [#5275](https://github.com/kubernetes/kops/pull/5275)
* Implement AdditionalCIDR configuration. [@rdrgmnzs](https://github.com/rdrgmnzs) [#5270](https://github.com/kubernetes/kops/pull/5270)
* Update heptio authenticator to 0.3.0 [@rdrgmnzs](https://github.com/rdrgmnzs) [#5276](https://github.com/kubernetes/kops/pull/5276)
* Update elasticsearch logging to 5.6.4 [@frankh](https://github.com/frankh) [#5137](https://github.com/kubernetes/kops/pull/5137)
* Fix: Update heptio authenticator to 0.3.0 #5276 [@rdrgmnzs](https://github.com/rdrgmnzs) [#5278](https://github.com/kubernetes/kops/pull/5278)
* Create a SECURITY_CONTACTS file. #5205 [@rdrgmnzs](https://github.com/rdrgmnzs) [#5279](https://github.com/kubernetes/kops/pull/5279)
* Verify Spelling [@gambol99](https://github.com/gambol99) [#5277](https://github.com/kubernetes/kops/pull/5277)
* Fix some typos [@mirake](https://github.com/mirake) [#5282](https://github.com/kubernetes/kops/pull/5282)
* Update kops_edit_instancegroup.go and kops_edit_instancegroup.md [@noinarisak](https://github.com/noinarisak) [#5284](https://github.com/kubernetes/kops/pull/5284)
* Override hostname with 'aws' only if hostname override is not specified. [@tvi](https://github.com/tvi) [#5285](https://github.com/kubernetes/kops/pull/5285)
* Enable override bind address for kube-proxy. [@tvi](https://github.com/tvi) [#5286](https://github.com/kubernetes/kops/pull/5286)
* Add support for M5D instance family on AWS [@ripta](https://github.com/ripta) [#5287](https://github.com/kubernetes/kops/pull/5287)
* Support overlay2 in docker [@justinsb](https://github.com/justinsb) [#5258](https://github.com/kubernetes/kops/pull/5258)
* Rename to kops [@justinsb](https://github.com/justinsb) [#1](https://github.com/kubernetes/kops/pull/1)
* Destinctive names for ClusterRoleBindings in prometheus-operator addon [@moritzheiber](https://github.com/moritzheiber) [#5294](https://github.com/kubernetes/kops/pull/5294)
* Revert "digitalocean: don't set --cloud-provider=external on control plane starting v1.10" [@andrewsykim](https://github.com/andrewsykim) [#5297](https://github.com/kubernetes/kops/pull/5297)
* Fix typo [@xianlubird](https://github.com/xianlubird) [#4985](https://github.com/kubernetes/kops/pull/4985)
* Fix issue where we assumed that private zone were in order [@justinsb](https://github.com/justinsb) [#5139](https://github.com/kubernetes/kops/pull/5139)
* Add support for external IAM Instance Profiles [@chrislovecnm](https://github.com/chrislovecnm),[@rifelpet](https://github.com/rifelpet) [#4171](https://github.com/kubernetes/kops/pull/4171)
* Feature/s3 bucket encryption - Implements PR #4235 [@gekart](https://github.com/gekart),[@chrisz100](https://github.com/chrisz100) [#5194](https://github.com/kubernetes/kops/pull/5194)
* Customize KubeDNS [@gambol99](https://github.com/gambol99) [#4724](https://github.com/kubernetes/kops/pull/4724)
* Add hooks example for cachefiled [@bhack](https://github.com/bhack) [#5072](https://github.com/kubernetes/kops/pull/5072)
* implement LoadBalancer task for ALICloud [@LilyFaFa](https://github.com/LilyFaFa) [#5207](https://github.com/kubernetes/kops/pull/5207)
* Admission Controller Validation [@gambol99](https://github.com/gambol99) [#5250](https://github.com/kubernetes/kops/pull/5250)
* Amazon VPC CNI: Upgrade to v1.0 and Allow Custom Images [@ripta](https://github.com/ripta) [#5119](https://github.com/kubernetes/kops/pull/5119)
* ListKeypairs: don't print 'keyset.yaml' as the key id [@justinsb](https://github.com/justinsb) [#5254](https://github.com/kubernetes/kops/pull/5254)
* Fix alitasks loadbalancer typo causing test failures [@KashifSaadat](https://github.com/KashifSaadat) [#5301](https://github.com/kubernetes/kops/pull/5301)
* fix broken link to example policy file in the cluster_spec docs [@kaspernissen](https://github.com/kaspernissen) [#5146](https://github.com/kubernetes/kops/pull/5146)
* Export outputs to aid with VPC peering in Terraform [@chrissnell](https://github.com/chrissnell),[@justinsb](https://github.com/justinsb) [#5030](https://github.com/kubernetes/kops/pull/5030)
* implement router interface task for OpenStack platform [@zengchen1024](https://github.com/zengchen1024) [#4977](https://github.com/kubernetes/kops/pull/4977)
* Update expected TF output for latest master [@justinsb](https://github.com/justinsb) [#5303](https://github.com/kubernetes/kops/pull/5303)
* implement keypair task for OpenStack platform [@zetaab](https://github.com/zetaab),[@justinsb](https://github.com/justinsb) [#5110](https://github.com/kubernetes/kops/pull/5110)
* Fixup bazel [@justinsb](https://github.com/justinsb) [#5304](https://github.com/kubernetes/kops/pull/5304)
* Fix gofmt [@justinsb](https://github.com/justinsb) [#5305](https://github.com/kubernetes/kops/pull/5305)
* Add feature with s3 state store from configfile [@jsenon](https://github.com/jsenon),[@justinsb](https://github.com/justinsb) [#4737](https://github.com/kubernetes/kops/pull/4737)
* Node Bootstrap Tokens [@gambol99](https://github.com/gambol99) [#5253](https://github.com/kubernetes/kops/pull/5253)
* Add prometheus scrape to kube-dns [@mikesplain](https://github.com/mikesplain) [#5308](https://github.com/kubernetes/kops/pull/5308)
* Fix typo: HONE -> HOME [@justinsb](https://github.com/justinsb) [#5306](https://github.com/kubernetes/kops/pull/5306)
* Node Bootstrap Fix Ups [@gambol99](https://github.com/gambol99) [#5309](https://github.com/kubernetes/kops/pull/5309)
* Fix Admission Controller Validation [@gambol99](https://github.com/gambol99) [#5313](https://github.com/kubernetes/kops/pull/5313)
* Added comment for 404 on healthcheck for non-standard vpc-cidr [@aberfeldy](https://github.com/aberfeldy) [#5312](https://github.com/kubernetes/kops/pull/5312)
* Correct deployment yaml of CoreDNS [@rajansandeep](https://github.com/rajansandeep) [#5315](https://github.com/kubernetes/kops/pull/5315)
* implement Ram task for ALICloud [@LilyFaFa](https://github.com/LilyFaFa) [#5316](https://github.com/kubernetes/kops/pull/5316)
* Avoid changing IAM policy for users [@justinsb](https://github.com/justinsb) [#5307](https://github.com/kubernetes/kops/pull/5307)
* File Path Fixes [@gambol99](https://github.com/gambol99) [#5311](https://github.com/kubernetes/kops/pull/5311)
* Communicate before long waits [@eherot](https://github.com/eherot) [#5322](https://github.com/kubernetes/kops/pull/5322)
* kops set cluster: honor --name flag [@justinsb](https://github.com/justinsb) [#5325](https://github.com/kubernetes/kops/pull/5325)
* Don't always print state store path [@justinsb](https://github.com/justinsb) [#5323](https://github.com/kubernetes/kops/pull/5323)
* protokube: only specify etcd flags when managing etcd [@justinsb](https://github.com/justinsb) [#5334](https://github.com/kubernetes/kops/pull/5334)
* Use less viper discovery [@justinsb](https://github.com/justinsb) [#5324](https://github.com/kubernetes/kops/pull/5324)
* GCE: Set network tier, to avoid spurious changes [@justinsb](https://github.com/justinsb) [#5330](https://github.com/kubernetes/kops/pull/5330)
* Set log-verbosity for etcd-manager [@justinsb](https://github.com/justinsb) [#5333](https://github.com/kubernetes/kops/pull/5333)
* More configuration options for cilium [@nebril](https://github.com/nebril) [#5320](https://github.com/kubernetes/kops/pull/5320)
* gossip: create zone in protokube [@justinsb](https://github.com/justinsb) [#5332](https://github.com/kubernetes/kops/pull/5332)
* implement SecurityGroup task for ALICloud [@LilyFaFa](https://github.com/LilyFaFa) [#5328](https://github.com/kubernetes/kops/pull/5328)
* Add missing nodes/stats resource to the system:metrics-server Cluster… [@azman0101](https://github.com/azman0101) [#5331](https://github.com/kubernetes/kops/pull/5331)
* Don't autoload SSH key on GCE [@justinsb](https://github.com/justinsb) [#5256](https://github.com/kubernetes/kops/pull/5256)
* add SSHKey model for AliCloud [@LilyFaFa](https://github.com/LilyFaFa) [#5340](https://github.com/kubernetes/kops/pull/5340)
* implement scalingGroup tasks for AliCloud [@LilyFaFa](https://github.com/LilyFaFa) [#5341](https://github.com/kubernetes/kops/pull/5341)
* Typo fix [@jonyhy96](https://github.com/jonyhy96) [#5344](https://github.com/kubernetes/kops/pull/5344)
* Code Clean [@gambol99](https://github.com/gambol99) [#5350](https://github.com/kubernetes/kops/pull/5350)
* add firewallModel for ALIcloud [@LilyFaFa](https://github.com/LilyFaFa) [#5343](https://github.com/kubernetes/kops/pull/5343)
* Aggregator Routing Option [@gambol99](https://github.com/gambol99) [#5349](https://github.com/kubernetes/kops/pull/5349)
* Removing Duplication [@gambol99](https://github.com/gambol99) [#5351](https://github.com/kubernetes/kops/pull/5351)
* Git Ignore - Merge Conflict Files [@gambol99](https://github.com/gambol99) [#5354](https://github.com/kubernetes/kops/pull/5354)
* etcd-manager: GCE support [@justinsb](https://github.com/justinsb) [#5335](https://github.com/kubernetes/kops/pull/5335)
* AWS: Delete old LaunchConfigurations [@justinsb](https://github.com/justinsb) [#5245](https://github.com/kubernetes/kops/pull/5245)
* GCE: Handle storage flag on COS more carefully [@justinsb](https://github.com/justinsb) [#5362](https://github.com/kubernetes/kops/pull/5362)
* Revert COS in stable/alpha channel [@justinsb](https://github.com/justinsb) [#5359](https://github.com/kubernetes/kops/pull/5359)
* Fix containerRegistry for Kubernetes < 1.10 [@kampka](https://github.com/kampka) [#5353](https://github.com/kubernetes/kops/pull/5353)
* add RAM model for ALIcloud [@LilyFaFa](https://github.com/LilyFaFa) [#5356](https://github.com/kubernetes/kops/pull/5356)
* Add etcd TLS support for Cilium [@nebril](https://github.com/nebril) [#5240](https://github.com/kubernetes/kops/pull/5240)
* Nodeup clean [@gambol99](https://github.com/gambol99) [#5352](https://github.com/kubernetes/kops/pull/5352)
* add ScalingGroup model for AliCloud [@LilyFaFa](https://github.com/LilyFaFa) [#5364](https://github.com/kubernetes/kops/pull/5364)
* Typo fix in documentation.md [@AdamDang](https://github.com/AdamDang) [#5348](https://github.com/kubernetes/kops/pull/5348)
* Mark 1.10.0-alpha.1 [@justinsb](https://github.com/justinsb) [#5367](https://github.com/kubernetes/kops/pull/5367)
* Add 1.10-alpha.1 to stable & alpha channels [@justinsb](https://github.com/justinsb) [#5369](https://github.com/kubernetes/kops/pull/5369)
* Go versions: don't block on 1.8 [@justinsb](https://github.com/justinsb) [#5366](https://github.com/kubernetes/kops/pull/5366)
* Docker Userspace Remapping Options [@gambol99](https://github.com/gambol99) [#5357](https://github.com/kubernetes/kops/pull/5357)
* Fix minor typo in DO tutorial [@andrewlouis93](https://github.com/andrewlouis93) [#5377](https://github.com/kubernetes/kops/pull/5377)
* Installation of AWS CLI tools [@the-lost-explorer](https://github.com/the-lost-explorer) [#5379](https://github.com/kubernetes/kops/pull/5379)
* Switch bucket encryption policy warning to debug [@mikesplain](https://github.com/mikesplain) [#5376](https://github.com/kubernetes/kops/pull/5376)
* Update rolling update ig roles flag to be case insensitive [@KashifSaadat](https://github.com/KashifSaadat) [#5386](https://github.com/kubernetes/kops/pull/5386)
* add Volume model for aliCloud [@LilyFaFa](https://github.com/LilyFaFa) [#5374](https://github.com/kubernetes/kops/pull/5374)
* fix broken compute resource reservation docs for storage in cluster_spec [@kimxogus](https://github.com/kimxogus) [#5401](https://github.com/kubernetes/kops/pull/5401)
* Add Cilium documentation to networking.md [@nebril](https://github.com/nebril) [#5388](https://github.com/kubernetes/kops/pull/5388)
* delete cluster resources for ALicloud [@LilyFaFa](https://github.com/LilyFaFa) [#5395](https://github.com/kubernetes/kops/pull/5395)
* Add dockerDisableSharedPID to kubelet config [@ripta](https://github.com/ripta) [#5403](https://github.com/kubernetes/kops/pull/5403)
* Add IAM ec2:ModifyVolume permission to allow EBS volume resize [@KashifSaadat](https://github.com/KashifSaadat) [#5416](https://github.com/kubernetes/kops/pull/5416)
* Remap initContainers as well as containers in PodSpec [@coreypobrien](https://github.com/coreypobrien) [#5427](https://github.com/kubernetes/kops/pull/5427)
* Rename hept.io authenticator to aws authenticator [@rdrgmnzs](https://github.com/rdrgmnzs) [#5421](https://github.com/kubernetes/kops/pull/5421)
* Use /bin/bash in kubelet manifest ExecStartPre [@coreypobrien](https://github.com/coreypobrien) [#5428](https://github.com/kubernetes/kops/pull/5428)
* Fix the issue described in #5412 where the authenticator is no longer… [@rdrgmnzs](https://github.com/rdrgmnzs) [#5424](https://github.com/kubernetes/kops/pull/5424)
* Allow setting MTU for calico networking. [@shrinandj](https://github.com/shrinandj) [#5380](https://github.com/kubernetes/kops/pull/5380)
* Add prometheus scrape port to CoreDNS service [@rajansandeep](https://github.com/rajansandeep) [#5392](https://github.com/kubernetes/kops/pull/5392)
* Added metrics port and health check to kube-router [@aleerizw](https://github.com/aleerizw) [#5426](https://github.com/kubernetes/kops/pull/5426)
* Initial Ubuntu Bionic Support [@mikesplain](https://github.com/mikesplain) [#5394](https://github.com/kubernetes/kops/pull/5394)
* Fail cluster validation for rolling-update if a failure occurs [@dzoeteman](https://github.com/dzoeteman) [#5445](https://github.com/kubernetes/kops/pull/5445)
* Update Audit file example [@jsenon](https://github.com/jsenon) [#5432](https://github.com/kubernetes/kops/pull/5432)
* Add data-root and exec-root attributes to the docker config spec [@ripta](https://github.com/ripta) [#5431](https://github.com/kubernetes/kops/pull/5431)
* Add minRequestTimeout flag in kube-APIServer [@Sturgelose](https://github.com/Sturgelose) [#5438](https://github.com/kubernetes/kops/pull/5438)
* Fixes issue when setting docker version [@mikesplain](https://github.com/mikesplain) [#5417](https://github.com/kubernetes/kops/pull/5417)
* support edit cluster and rolling-update cluster for AliCloud [@LilyFaFa](https://github.com/LilyFaFa) [#5419](https://github.com/kubernetes/kops/pull/5419)
* docs for different VPC in the Security Group of kube-ingress-aws-controller [@kanolato](https://github.com/kanolato) [#5418](https://github.com/kubernetes/kops/pull/5418)
* Don't mount volume for auditLog when STDOUT is configured as path [@kampka](https://github.com/kampka) [#5448](https://github.com/kubernetes/kops/pull/5448)
* Adding a disclaimer for instanceGroups in docs [@Cryptophobia](https://github.com/Cryptophobia) [#3445](https://github.com/kubernetes/kops/pull/3445)
* add cluster-autoscaler.sh [@sdarwin](https://github.com/sdarwin) [#5433](https://github.com/kubernetes/kops/pull/5433)
* Add weave network encryption secret [@kampka](https://github.com/kampka) [#5441](https://github.com/kubernetes/kops/pull/5441)
* skipper selector changed [@kanolato](https://github.com/kanolato) [#5430](https://github.com/kubernetes/kops/pull/5430)
* Generate locals for terraform target [@kampka](https://github.com/kampka) [#5443](https://github.com/kubernetes/kops/pull/5443)
* Correct all the word "cluster" to be in lowercase [@AdamDang](https://github.com/AdamDang) [#5153](https://github.com/kubernetes/kops/pull/5153)
* Stop rolling update if bastions or masters failed to update [@dzoeteman](https://github.com/dzoeteman) [#5446](https://github.com/kubernetes/kops/pull/5446)
* Generate random weave password it none is supplied [@kampka](https://github.com/kampka) [#5457](https://github.com/kubernetes/kops/pull/5457)
* Node Authorization Service [@gambol99](https://github.com/gambol99) [#5317](https://github.com/kubernetes/kops/pull/5317)
* [WIP] Initial implementation of ACM certificate for API server ELB [@Raffo](https://github.com/Raffo) [#5414](https://github.com/kubernetes/kops/pull/5414)
* More autofix of expected test output [@justinsb](https://github.com/justinsb) [#5466](https://github.com/kubernetes/kops/pull/5466)
* Add configurable conntrack settings [@mikesplain](https://github.com/mikesplain) [#5456](https://github.com/kubernetes/kops/pull/5456)
* Add pull-through proxy cache for asset docker images [@kampka](https://github.com/kampka) [#5390](https://github.com/kubernetes/kops/pull/5390)
* Don't repeatedly download nodeup [@justinsb](https://github.com/justinsb) [#5462](https://github.com/kubernetes/kops/pull/5462)
* Adds ability to set template context values on command line  [@gwkunze](https://github.com/gwkunze) [#5108](https://github.com/kubernetes/kops/pull/5108)
* Allow users to set the kubelets root dir. [@rdrgmnzs](https://github.com/rdrgmnzs) [#5467](https://github.com/kubernetes/kops/pull/5467)
* Update docs for config file [@justinsb](https://github.com/justinsb) [#5469](https://github.com/kubernetes/kops/pull/5469)
* Correct the `maxSize` in the cluster template example [@dcherman](https://github.com/dcherman) [#5455](https://github.com/kubernetes/kops/pull/5455)
* Add the ability to specify external loadbalancers for instancegroups [@gwkunze](https://github.com/gwkunze) [#4677](https://github.com/kubernetes/kops/pull/4677)
* Fix tests that crossed during PR merges [@justinsb](https://github.com/justinsb) [#5470](https://github.com/kubernetes/kops/pull/5470)
* change gossip dns conn limit by ENV [@yancl](https://github.com/yancl) [#5077](https://github.com/kubernetes/kops/pull/5077)
* Introduce a global backoff to rate limit failed image downloads [@justinsb](https://github.com/justinsb) [#5464](https://github.com/kubernetes/kops/pull/5464)
* Add mikesplain to approvers [@justinsb](https://github.com/justinsb) [#5480](https://github.com/kubernetes/kops/pull/5480)
* have travis fail when verify-apimachinery.sh fails and fix incompatible apimachinery [@chrisz100](https://github.com/chrisz100) [#5477](https://github.com/kubernetes/kops/pull/5477)
* Use portable shebang for hack scripts [@kampka](https://github.com/kampka) [#5478](https://github.com/kubernetes/kops/pull/5478)
* Add autoscaling group ids to terraform module output [@kampka](https://github.com/kampka) [#5472](https://github.com/kubernetes/kops/pull/5472)
* Allow kubelet to bind the hosts primary IP  [@rdrgmnzs](https://github.com/rdrgmnzs) [#5460](https://github.com/kubernetes/kops/pull/5460)
* ContainerRegistry remapping should be atomic [@kampka](https://github.com/kampka) [#5479](https://github.com/kubernetes/kops/pull/5479)
* [GPU] Updated Kops GPU Setup Hook [@dcwangmit01](https://github.com/dcwangmit01) [#4971](https://github.com/kubernetes/kops/pull/4971)
* Only use SSL for ELB if certificate configured [@justinsb](https://github.com/justinsb) [#5485](https://github.com/kubernetes/kops/pull/5485)
* Simplify logic around master rolling-update [@justinsb](https://github.com/justinsb) [#5488](https://github.com/kubernetes/kops/pull/5488)
* Update Issue templates and add PR template [@mikesplain](https://github.com/mikesplain) [#5487](https://github.com/kubernetes/kops/pull/5487)
* Force-load br_netfilter in nodeup [@justinsb](https://github.com/justinsb) [#5490](https://github.com/kubernetes/kops/pull/5490)
* Remove gossip connection limit entirely [@justinsb](https://github.com/justinsb) [#5486](https://github.com/kubernetes/kops/pull/5486)
* Fix GCE instance lookup during validation [@justinsb](https://github.com/justinsb) [#5491](https://github.com/kubernetes/kops/pull/5491)
* Only manage internal DNS zone if configuration has been specified [@mellowplace](https://github.com/mellowplace) [#5375](https://github.com/kubernetes/kops/pull/5375)
* Add portmap CNI plugin for k8s >= 1.9 [@justinsb](https://github.com/justinsb) [#5494](https://github.com/kubernetes/kops/pull/5494)
* Add new instance types r5, r5d, z1d [@rekcah78](https://github.com/rekcah78) [#5529](https://github.com/kubernetes/kops/pull/5529)
* Remove GetAsgForInstance IAM permission [@justinsb](https://github.com/justinsb) [#5566](https://github.com/kubernetes/kops/pull/5566)
* Check errors when parsing JSON on IAM policies [@justinsb](https://github.com/justinsb) [#5533](https://github.com/kubernetes/kops/pull/5533)
* Add authentication-token-webhook-cache-ttl flag to kubelet config [@ihoegen](https://github.com/ihoegen) [#5508](https://github.com/kubernetes/kops/pull/5508)
* Add AWS IAM permission to check for volume resize [@KashifSaadat](https://github.com/KashifSaadat) [#5597](https://github.com/kubernetes/kops/pull/5597)
* Enable weave network encryption for k8s 1.6 [@Andrey9kin](https://github.com/Andrey9kin) [#5595](https://github.com/kubernetes/kops/pull/5595)
* Add ssh user to kops toolbox dump [@justinsb](https://github.com/justinsb) [#5511](https://github.com/kubernetes/kops/pull/5511)
* Add amazon.com image owner alias and Amazon Linux 2 documentation [@Pharb](https://github.com/Pharb) [#5577](https://github.com/kubernetes/kops/pull/5577)
* Bump Weave Net to v2.4.0 [@brb](https://github.com/brb) [#5552](https://github.com/kubernetes/kops/pull/5552)
* Create ExperimentalClusterDNS feature flag [@justinsb](https://github.com/justinsb) [#5610](https://github.com/kubernetes/kops/pull/5610)
* Validate that require-kubeconfig is not passed after 1.10 [@justinsb](https://github.com/justinsb) [#5621](https://github.com/kubernetes/kops/pull/5621)
* Don't assume that we only have one subnet per AZ [@justinsb](https://github.com/justinsb) [#5601](https://github.com/kubernetes/kops/pull/5601)
* DigitalOcean: don't try to set SSE [@justinsb](https://github.com/justinsb) [#5625](https://github.com/kubernetes/kops/pull/5625)
* weave: bump version for 2.3.0 [@justinsb](https://github.com/justinsb) [#5618](https://github.com/kubernetes/kops/pull/5618)
