
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops get

Get one or many resources.

### Synopsis

Display one or many resources.

  *  cluster
  *  instancegroup
  *  secret

```
kops get [flags]
```

### Examples

```
  # Get all clusters in a state store
  kops get clusters
  
  # Get a cluster and its instancegroups
  kops get k8s-cluster.example.com
  
  # Get a cluster and its instancegroups' YAML desired configuration
  kops get k8s-cluster.example.com -o yaml
  
  # Save a cluster and its instancegroups' desired configuration to YAML file
  kops get k8s-cluster.example.com -o yaml > cluster-desired-config.yaml
  
  # Get a secret
  kops get secrets kube -oplaintext
  
  # Get the admin password for a cluster
  kops get secrets admin -oplaintext
```

### Options

```
  -h, --help            help for get
  -o, --output string   output format.  One of: table, yaml, json (default "table")
```

### Options inherited from parent commands

```
      --add_dir_header                   If true, adds the file directory to the header of the log messages
      --alsologtostderr                  log to standard error as well as files
      --config string                    yaml config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory
      --log_file string                  If non-empty, use this log file
      --log_file_max_size uint           Defines the maximum size a log file can grow to. Unit is megabytes. If the value is 0, the maximum file size is unlimited. (default 1800)
      --logtostderr                      log to standard error instead of files (default true)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --skip_headers                     If true, avoid header prefixes in the log messages
      --skip_log_headers                 If true, avoid headers when opening log files
      --state string                     Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr (default 2)
  -v, --v Level                          number for the log level verbosity
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO

* [kops](kops.md)	 - kops is Kubernetes ops.
* [kops get clusters](kops_get_clusters.md)	 - Get one or many clusters.
* [kops get instancegroups](kops_get_instancegroups.md)	 - Get one or many instancegroups
* [kops get instances](kops_get_instances.md)	 - Display cluster instances.
* [kops get secrets](kops_get_secrets.md)	 - Get one or many secrets.

