/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package api

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/client-go/1.4/pkg/api/resource"
	pkg2_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg6_fields "k8s.io/client-go/1.4/pkg/fields"
	pkg5_labels "k8s.io/client-go/1.4/pkg/labels"
	pkg7_runtime "k8s.io/client-go/1.4/pkg/runtime"
	pkg1_types "k8s.io/client-go/1.4/pkg/types"
	pkg4_intstr "k8s.io/client-go/1.4/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg6_fields.Selector
		var v3 pkg5_labels.Selector
		var v4 pkg7_runtime.Object
		var v5 pkg1_types.UID
		var v6 pkg4_intstr.IntOrString
		var v7 time.Time
		_, _, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6, v7
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [15]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			yyq2[12] = len(x.OwnerReferences) != 0
			yyq2[13] = len(x.Finalizers) != 0
			yyq2[14] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(15)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym51 := z.EncBinary()
					_ = yym51
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv62 := &x.CreationTimestamp
				yym63 := z.DecBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv62) {
				} else if yym63 {
					z.DecBinaryUnmarshal(yyv62)
				} else if !yym63 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv62)
				} else {
					z.DecFallback(yyv62, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym65 := z.DecBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym65 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym65 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym67 := z.DecBinary()
				_ = yym67
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv68 := &x.Labels
				yym69 := z.DecBinary()
				_ = yym69
				if false {
				} else {
					z.F.DecMapStringStringX(yyv68, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv70 := &x.Annotations
				yym71 := z.DecBinary()
				_ = yym71
				if false {
				} else {
					z.F.DecMapStringStringX(yyv70, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv72 := &x.OwnerReferences
				yym73 := z.DecBinary()
				_ = yym73
				if false {
				} else {
					h.decSliceOwnerReference((*[]OwnerReference)(yyv72), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv74 := &x.Finalizers
				yym75 := z.DecBinary()
				_ = yym75
				if false {
				} else {
					z.F.DecSliceStringX(yyv74, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj77 int
	var yyb77 bool
	var yyhl77 bool = l >= 0
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv85 := &x.CreationTimestamp
		yym86 := z.DecBinary()
		_ = yym86
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv85) {
		} else if yym86 {
			z.DecBinaryUnmarshal(yyv85)
		} else if !yym86 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv85)
		} else {
			z.DecFallback(yyv85, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym88 := z.DecBinary()
		_ = yym88
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym88 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym88 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym90 := z.DecBinary()
		_ = yym90
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv91 := &x.Labels
		yym92 := z.DecBinary()
		_ = yym92
		if false {
		} else {
			z.F.DecMapStringStringX(yyv91, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv93 := &x.Annotations
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else {
			z.F.DecMapStringStringX(yyv93, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv95 := &x.OwnerReferences
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else {
			h.decSliceOwnerReference((*[]OwnerReference)(yyv95), d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv97 := &x.Finalizers
		yym98 := z.DecBinary()
		_ = yym98
		if false {
		} else {
			z.F.DecSliceStringX(yyv97, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	for {
		yyj77++
		if yyhl77 {
			yyb77 = yyj77 > l
		} else {
			yyb77 = r.CheckBreak()
		}
		if yyb77 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj77-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym100 := z.EncBinary()
		_ = yym100
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep101 := !z.EncBinary()
			yy2arr101 := z.EncBasicHandle().StructToArray
			var yyq101 [23]bool
			_, _, _ = yysep101, yyq101, yy2arr101
			const yyr101 bool = false
			yyq101[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq101[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq101[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq101[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq101[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq101[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq101[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq101[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq101[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq101[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq101[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq101[12] = x.VolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq101[13] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq101[14] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq101[15] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq101[16] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq101[17] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq101[18] = x.VolumeSource.FC != nil && x.FC != nil
			yyq101[19] = x.VolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq101[20] = x.VolumeSource.ConfigMap != nil && x.ConfigMap != nil
			yyq101[21] = x.VolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq101[22] = x.VolumeSource.AzureDisk != nil && x.AzureDisk != nil
			var yynn101 int
			if yyr101 || yy2arr101 {
				r.EncodeArrayStart(23)
			} else {
				yynn101 = 1
				for _, b := range yyq101 {
					if b {
						yynn101++
					}
				}
				r.EncodeMapStart(yynn101)
				yynn101 = 0
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym104 := z.EncBinary()
				_ = yym104
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn105 bool
			if x.VolumeSource.HostPath == nil {
				yyn105 = true
				goto LABEL105
			}
		LABEL105:
			if yyr101 || yy2arr101 {
				if yyn105 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn105 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn106 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn106 = true
				goto LABEL106
			}
		LABEL106:
			if yyr101 || yy2arr101 {
				if yyn106 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn106 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn107 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn107 = true
				goto LABEL107
			}
		LABEL107:
			if yyr101 || yy2arr101 {
				if yyn107 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn107 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn108 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn108 = true
				goto LABEL108
			}
		LABEL108:
			if yyr101 || yy2arr101 {
				if yyn108 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn108 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn109 bool
			if x.VolumeSource.GitRepo == nil {
				yyn109 = true
				goto LABEL109
			}
		LABEL109:
			if yyr101 || yy2arr101 {
				if yyn109 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn109 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn110 bool
			if x.VolumeSource.Secret == nil {
				yyn110 = true
				goto LABEL110
			}
		LABEL110:
			if yyr101 || yy2arr101 {
				if yyn110 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn110 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn111 bool
			if x.VolumeSource.NFS == nil {
				yyn111 = true
				goto LABEL111
			}
		LABEL111:
			if yyr101 || yy2arr101 {
				if yyn111 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn111 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn112 bool
			if x.VolumeSource.ISCSI == nil {
				yyn112 = true
				goto LABEL112
			}
		LABEL112:
			if yyr101 || yy2arr101 {
				if yyn112 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn112 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn113 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn113 = true
				goto LABEL113
			}
		LABEL113:
			if yyr101 || yy2arr101 {
				if yyn113 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn113 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn114 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn114 = true
				goto LABEL114
			}
		LABEL114:
			if yyr101 || yy2arr101 {
				if yyn114 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn114 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn115 bool
			if x.VolumeSource.RBD == nil {
				yyn115 = true
				goto LABEL115
			}
		LABEL115:
			if yyr101 || yy2arr101 {
				if yyn115 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn115 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn116 bool
			if x.VolumeSource.Quobyte == nil {
				yyn116 = true
				goto LABEL116
			}
		LABEL116:
			if yyr101 || yy2arr101 {
				if yyn116 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[12] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn116 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn117 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn117 = true
				goto LABEL117
			}
		LABEL117:
			if yyr101 || yy2arr101 {
				if yyn117 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[13] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn117 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn118 bool
			if x.VolumeSource.Cinder == nil {
				yyn118 = true
				goto LABEL118
			}
		LABEL118:
			if yyr101 || yy2arr101 {
				if yyn118 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[14] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn118 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn119 bool
			if x.VolumeSource.CephFS == nil {
				yyn119 = true
				goto LABEL119
			}
		LABEL119:
			if yyr101 || yy2arr101 {
				if yyn119 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[15] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn119 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn120 bool
			if x.VolumeSource.Flocker == nil {
				yyn120 = true
				goto LABEL120
			}
		LABEL120:
			if yyr101 || yy2arr101 {
				if yyn120 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[16] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn120 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn121 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn121 = true
				goto LABEL121
			}
		LABEL121:
			if yyr101 || yy2arr101 {
				if yyn121 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[17] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn121 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn122 bool
			if x.VolumeSource.FC == nil {
				yyn122 = true
				goto LABEL122
			}
		LABEL122:
			if yyr101 || yy2arr101 {
				if yyn122 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[18] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn122 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn123 bool
			if x.VolumeSource.AzureFile == nil {
				yyn123 = true
				goto LABEL123
			}
		LABEL123:
			if yyr101 || yy2arr101 {
				if yyn123 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[19] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn123 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn124 bool
			if x.VolumeSource.ConfigMap == nil {
				yyn124 = true
				goto LABEL124
			}
		LABEL124:
			if yyr101 || yy2arr101 {
				if yyn124 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[20] {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn124 {
						r.EncodeNil()
					} else {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn125 bool
			if x.VolumeSource.VsphereVolume == nil {
				yyn125 = true
				goto LABEL125
			}
		LABEL125:
			if yyr101 || yy2arr101 {
				if yyn125 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[21] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn125 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn126 bool
			if x.VolumeSource.AzureDisk == nil {
				yyn126 = true
				goto LABEL126
			}
		LABEL126:
			if yyr101 || yy2arr101 {
				if yyn126 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[22] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn126 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym127 := z.DecBinary()
	_ = yym127
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct128 := r.ContainerType()
		if yyct128 == codecSelferValueTypeMap1234 {
			yyl128 := r.ReadMapStart()
			if yyl128 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl128, d)
			}
		} else if yyct128 == codecSelferValueTypeArray1234 {
			yyl128 := r.ReadArrayStart()
			if yyl128 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl128, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys129Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys129Slc
	var yyhl129 bool = l >= 0
	for yyj129 := 0; ; yyj129++ {
		if yyhl129 {
			if yyj129 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys129Slc = r.DecodeBytes(yys129Slc, true, true)
		yys129 := string(yys129Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys129 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.VolumeSource.Quobyte == nil {
				x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.VolumeSource.AzureFile == nil {
				x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if x.VolumeSource.ConfigMap == nil {
				x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.VolumeSource.VsphereVolume == nil {
				x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.VolumeSource.AzureDisk == nil {
				x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys129)
		} // end switch yys129
	} // end for yyj129
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj153 int
	var yyb153 bool
	var yyhl153 bool = l >= 0
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Quobyte == nil {
		x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureFile == nil {
		x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ConfigMap == nil {
		x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	if x.VolumeSource.VsphereVolume == nil {
		x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureDisk == nil {
		x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj153++
		if yyhl153 {
			yyb153 = yyj153 > l
		} else {
			yyb153 = r.CheckBreak()
		}
		if yyb153 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj153-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym177 := z.EncBinary()
		_ = yym177
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep178 := !z.EncBinary()
			yy2arr178 := z.EncBasicHandle().StructToArray
			var yyq178 [22]bool
			_, _, _ = yysep178, yyq178, yy2arr178
			const yyr178 bool = false
			yyq178[0] = x.HostPath != nil
			yyq178[1] = x.EmptyDir != nil
			yyq178[2] = x.GCEPersistentDisk != nil
			yyq178[3] = x.AWSElasticBlockStore != nil
			yyq178[4] = x.GitRepo != nil
			yyq178[5] = x.Secret != nil
			yyq178[6] = x.NFS != nil
			yyq178[7] = x.ISCSI != nil
			yyq178[8] = x.Glusterfs != nil
			yyq178[9] = x.PersistentVolumeClaim != nil
			yyq178[10] = x.RBD != nil
			yyq178[11] = x.Quobyte != nil
			yyq178[12] = x.FlexVolume != nil
			yyq178[13] = x.Cinder != nil
			yyq178[14] = x.CephFS != nil
			yyq178[15] = x.Flocker != nil
			yyq178[16] = x.DownwardAPI != nil
			yyq178[17] = x.FC != nil
			yyq178[18] = x.AzureFile != nil
			yyq178[19] = x.ConfigMap != nil
			yyq178[20] = x.VsphereVolume != nil
			yyq178[21] = x.AzureDisk != nil
			var yynn178 int
			if yyr178 || yy2arr178 {
				r.EncodeArrayStart(22)
			} else {
				yynn178 = 0
				for _, b := range yyq178 {
					if b {
						yynn178++
					}
				}
				r.EncodeMapStart(yynn178)
				yynn178 = 0
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[11] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[12] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[13] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[14] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[15] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[16] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[17] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[18] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[19] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[20] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq178[21] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq178[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr178 || yy2arr178 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym201 := z.DecBinary()
	_ = yym201
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct202 := r.ContainerType()
		if yyct202 == codecSelferValueTypeMap1234 {
			yyl202 := r.ReadMapStart()
			if yyl202 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl202, d)
			}
		} else if yyct202 == codecSelferValueTypeArray1234 {
			yyl202 := r.ReadArrayStart()
			if yyl202 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl202, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys203Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys203Slc
	var yyhl203 bool = l >= 0
	for yyj203 := 0; ; yyj203++ {
		if yyhl203 {
			if yyj203 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys203Slc = r.DecodeBytes(yys203Slc, true, true)
		yys203 := string(yys203Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys203 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys203)
		} // end switch yys203
	} // end for yyj203
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj226 int
	var yyb226 bool
	var yyhl226 bool = l >= 0
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj226++
	if yyhl226 {
		yyb226 = yyj226 > l
	} else {
		yyb226 = r.CheckBreak()
	}
	if yyb226 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj226++
		if yyhl226 {
			yyb226 = yyj226 > l
		} else {
			yyb226 = r.CheckBreak()
		}
		if yyb226 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj226-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym249 := z.EncBinary()
		_ = yym249
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep250 := !z.EncBinary()
			yy2arr250 := z.EncBasicHandle().StructToArray
			var yyq250 [16]bool
			_, _, _ = yysep250, yyq250, yy2arr250
			const yyr250 bool = false
			yyq250[0] = x.GCEPersistentDisk != nil
			yyq250[1] = x.AWSElasticBlockStore != nil
			yyq250[2] = x.HostPath != nil
			yyq250[3] = x.Glusterfs != nil
			yyq250[4] = x.NFS != nil
			yyq250[5] = x.RBD != nil
			yyq250[6] = x.Quobyte != nil
			yyq250[7] = x.ISCSI != nil
			yyq250[8] = x.FlexVolume != nil
			yyq250[9] = x.Cinder != nil
			yyq250[10] = x.CephFS != nil
			yyq250[11] = x.FC != nil
			yyq250[12] = x.Flocker != nil
			yyq250[13] = x.AzureFile != nil
			yyq250[14] = x.VsphereVolume != nil
			yyq250[15] = x.AzureDisk != nil
			var yynn250 int
			if yyr250 || yy2arr250 {
				r.EncodeArrayStart(16)
			} else {
				yynn250 = 0
				for _, b := range yyq250 {
					if b {
						yynn250++
					}
				}
				r.EncodeMapStart(yynn250)
				yynn250 = 0
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[6] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[8] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[9] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[10] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[11] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[12] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[13] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[14] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq250[15] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq250[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr250 || yy2arr250 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym267 := z.DecBinary()
	_ = yym267
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct268 := r.ContainerType()
		if yyct268 == codecSelferValueTypeMap1234 {
			yyl268 := r.ReadMapStart()
			if yyl268 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl268, d)
			}
		} else if yyct268 == codecSelferValueTypeArray1234 {
			yyl268 := r.ReadArrayStart()
			if yyl268 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl268, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys269Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys269Slc
	var yyhl269 bool = l >= 0
	for yyj269 := 0; ; yyj269++ {
		if yyhl269 {
			if yyj269 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys269Slc = r.DecodeBytes(yys269Slc, true, true)
		yys269 := string(yys269Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys269 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys269)
		} // end switch yys269
	} // end for yyj269
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj286 int
	var yyb286 bool
	var yyhl286 bool = l >= 0
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj286++
	if yyhl286 {
		yyb286 = yyj286 > l
	} else {
		yyb286 = r.CheckBreak()
	}
	if yyb286 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	for {
		yyj286++
		if yyhl286 {
			yyb286 = yyj286 > l
		} else {
			yyb286 = r.CheckBreak()
		}
		if yyb286 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj286-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym303 := z.EncBinary()
		_ = yym303
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep304 := !z.EncBinary()
			yy2arr304 := z.EncBasicHandle().StructToArray
			var yyq304 [2]bool
			_, _, _ = yysep304, yyq304, yy2arr304
			const yyr304 bool = false
			yyq304[1] = x.ReadOnly != false
			var yynn304 int
			if yyr304 || yy2arr304 {
				r.EncodeArrayStart(2)
			} else {
				yynn304 = 1
				for _, b := range yyq304 {
					if b {
						yynn304++
					}
				}
				r.EncodeMapStart(yynn304)
				yynn304 = 0
			}
			if yyr304 || yy2arr304 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym306 := z.EncBinary()
				_ = yym306
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym307 := z.EncBinary()
				_ = yym307
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr304 || yy2arr304 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq304[1] {
					yym309 := z.EncBinary()
					_ = yym309
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq304[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym310 := z.EncBinary()
					_ = yym310
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr304 || yy2arr304 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym311 := z.DecBinary()
	_ = yym311
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct312 := r.ContainerType()
		if yyct312 == codecSelferValueTypeMap1234 {
			yyl312 := r.ReadMapStart()
			if yyl312 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl312, d)
			}
		} else if yyct312 == codecSelferValueTypeArray1234 {
			yyl312 := r.ReadArrayStart()
			if yyl312 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl312, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys313Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys313Slc
	var yyhl313 bool = l >= 0
	for yyj313 := 0; ; yyj313++ {
		if yyhl313 {
			if yyj313 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys313Slc = r.DecodeBytes(yys313Slc, true, true)
		yys313 := string(yys313Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys313 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys313)
		} // end switch yys313
	} // end for yyj313
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj316 int
	var yyb316 bool
	var yyhl316 bool = l >= 0
	yyj316++
	if yyhl316 {
		yyb316 = yyj316 > l
	} else {
		yyb316 = r.CheckBreak()
	}
	if yyb316 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj316++
	if yyhl316 {
		yyb316 = yyj316 > l
	} else {
		yyb316 = r.CheckBreak()
	}
	if yyb316 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj316++
		if yyhl316 {
			yyb316 = yyj316 > l
		} else {
			yyb316 = r.CheckBreak()
		}
		if yyb316 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj316-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym319 := z.EncBinary()
		_ = yym319
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep320 := !z.EncBinary()
			yy2arr320 := z.EncBasicHandle().StructToArray
			var yyq320 [5]bool
			_, _, _ = yysep320, yyq320, yy2arr320
			const yyr320 bool = false
			yyq320[0] = x.Kind != ""
			yyq320[1] = x.APIVersion != ""
			yyq320[2] = true
			yyq320[3] = true
			yyq320[4] = true
			var yynn320 int
			if yyr320 || yy2arr320 {
				r.EncodeArrayStart(5)
			} else {
				yynn320 = 0
				for _, b := range yyq320 {
					if b {
						yynn320++
					}
				}
				r.EncodeMapStart(yynn320)
				yynn320 = 0
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[0] {
					yym322 := z.EncBinary()
					_ = yym322
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq320[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[1] {
					yym325 := z.EncBinary()
					_ = yym325
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq320[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym326 := z.EncBinary()
					_ = yym326
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[2] {
					yy328 := &x.ObjectMeta
					yy328.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy329 := &x.ObjectMeta
					yy329.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[3] {
					yy331 := &x.Spec
					yy331.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy332 := &x.Spec
					yy332.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq320[4] {
					yy334 := &x.Status
					yy334.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq320[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy335 := &x.Status
					yy335.CodecEncodeSelf(e)
				}
			}
			if yyr320 || yy2arr320 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym336 := z.DecBinary()
	_ = yym336
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct337 := r.ContainerType()
		if yyct337 == codecSelferValueTypeMap1234 {
			yyl337 := r.ReadMapStart()
			if yyl337 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl337, d)
			}
		} else if yyct337 == codecSelferValueTypeArray1234 {
			yyl337 := r.ReadArrayStart()
			if yyl337 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl337, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys338Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys338Slc
	var yyhl338 bool = l >= 0
	for yyj338 := 0; ; yyj338++ {
		if yyhl338 {
			if yyj338 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys338Slc = r.DecodeBytes(yys338Slc, true, true)
		yys338 := string(yys338Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys338 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv341 := &x.ObjectMeta
				yyv341.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv342 := &x.Spec
				yyv342.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv343 := &x.Status
				yyv343.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys338)
		} // end switch yys338
	} // end for yyj338
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj344 int
	var yyb344 bool
	var yyhl344 bool = l >= 0
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv347 := &x.ObjectMeta
		yyv347.CodecDecodeSelf(d)
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv348 := &x.Spec
		yyv348.CodecDecodeSelf(d)
	}
	yyj344++
	if yyhl344 {
		yyb344 = yyj344 > l
	} else {
		yyb344 = r.CheckBreak()
	}
	if yyb344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv349 := &x.Status
		yyv349.CodecDecodeSelf(d)
	}
	for {
		yyj344++
		if yyhl344 {
			yyb344 = yyj344 > l
		} else {
			yyb344 = r.CheckBreak()
		}
		if yyb344 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj344-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym350 := z.EncBinary()
		_ = yym350
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep351 := !z.EncBinary()
			yy2arr351 := z.EncBasicHandle().StructToArray
			var yyq351 [20]bool
			_, _, _ = yysep351, yyq351, yy2arr351
			const yyr351 bool = false
			yyq351[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq351[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq351[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq351[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq351[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq351[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq351[7] = x.PersistentVolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq351[8] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq351[9] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq351[10] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq351[11] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq351[12] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq351[13] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq351[14] = x.PersistentVolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq351[15] = x.PersistentVolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq351[16] = x.PersistentVolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq351[17] = len(x.AccessModes) != 0
			yyq351[18] = x.ClaimRef != nil
			yyq351[19] = x.PersistentVolumeReclaimPolicy != ""
			var yynn351 int
			if yyr351 || yy2arr351 {
				r.EncodeArrayStart(20)
			} else {
				yynn351 = 1
				for _, b := range yyq351 {
					if b {
						yynn351++
					}
				}
				r.EncodeMapStart(yynn351)
				yynn351 = 0
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("capacity"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			}
			var yyn353 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn353 = true
				goto LABEL353
			}
		LABEL353:
			if yyr351 || yy2arr351 {
				if yyn353 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn353 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn354 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn354 = true
				goto LABEL354
			}
		LABEL354:
			if yyr351 || yy2arr351 {
				if yyn354 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn354 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn355 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn355 = true
				goto LABEL355
			}
		LABEL355:
			if yyr351 || yy2arr351 {
				if yyn355 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn355 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn356 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn356 = true
				goto LABEL356
			}
		LABEL356:
			if yyr351 || yy2arr351 {
				if yyn356 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn356 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn357 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn357 = true
				goto LABEL357
			}
		LABEL357:
			if yyr351 || yy2arr351 {
				if yyn357 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn357 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn358 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn358 = true
				goto LABEL358
			}
		LABEL358:
			if yyr351 || yy2arr351 {
				if yyn358 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn358 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn359 bool
			if x.PersistentVolumeSource.Quobyte == nil {
				yyn359 = true
				goto LABEL359
			}
		LABEL359:
			if yyr351 || yy2arr351 {
				if yyn359 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[7] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn359 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn360 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn360 = true
				goto LABEL360
			}
		LABEL360:
			if yyr351 || yy2arr351 {
				if yyn360 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn360 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn361 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn361 = true
				goto LABEL361
			}
		LABEL361:
			if yyr351 || yy2arr351 {
				if yyn361 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[9] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn361 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn362 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn362 = true
				goto LABEL362
			}
		LABEL362:
			if yyr351 || yy2arr351 {
				if yyn362 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[10] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn362 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn363 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn363 = true
				goto LABEL363
			}
		LABEL363:
			if yyr351 || yy2arr351 {
				if yyn363 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[11] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn363 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn364 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn364 = true
				goto LABEL364
			}
		LABEL364:
			if yyr351 || yy2arr351 {
				if yyn364 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[12] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn364 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn365 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn365 = true
				goto LABEL365
			}
		LABEL365:
			if yyr351 || yy2arr351 {
				if yyn365 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[13] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn365 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn366 bool
			if x.PersistentVolumeSource.AzureFile == nil {
				yyn366 = true
				goto LABEL366
			}
		LABEL366:
			if yyr351 || yy2arr351 {
				if yyn366 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[14] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn366 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn367 bool
			if x.PersistentVolumeSource.VsphereVolume == nil {
				yyn367 = true
				goto LABEL367
			}
		LABEL367:
			if yyr351 || yy2arr351 {
				if yyn367 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[15] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn367 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn368 bool
			if x.PersistentVolumeSource.AzureDisk == nil {
				yyn368 = true
				goto LABEL368
			}
		LABEL368:
			if yyr351 || yy2arr351 {
				if yyn368 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq351[16] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq351[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn368 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[17] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym370 := z.EncBinary()
						_ = yym370
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym371 := z.EncBinary()
						_ = yym371
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[18] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[19] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym374 := z.DecBinary()
	_ = yym374
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct375 := r.ContainerType()
		if yyct375 == codecSelferValueTypeMap1234 {
			yyl375 := r.ReadMapStart()
			if yyl375 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl375, d)
			}
		} else if yyct375 == codecSelferValueTypeArray1234 {
			yyl375 := r.ReadArrayStart()
			if yyl375 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl375, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys376Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys376Slc
	var yyhl376 bool = l >= 0
	for yyj376 := 0; ; yyj376++ {
		if yyhl376 {
			if yyj376 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys376Slc = r.DecodeBytes(yys376Slc, true, true)
		yys376 := string(yys376Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys376 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv377 := &x.Capacity
				yyv377.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.PersistentVolumeSource.Quobyte == nil {
				x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.PersistentVolumeSource.AzureFile == nil {
				x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.PersistentVolumeSource.VsphereVolume == nil {
				x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.PersistentVolumeSource.AzureDisk == nil {
				x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv394 := &x.AccessModes
				yym395 := z.DecBinary()
				_ = yym395
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv394), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys376)
		} // end switch yys376
	} // end for yyj376
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj398 int
	var yyb398 bool
	var yyhl398 bool = l >= 0
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv399 := &x.Capacity
		yyv399.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Quobyte == nil {
		x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureFile == nil {
		x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.VsphereVolume == nil {
		x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureDisk == nil {
		x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv416 := &x.AccessModes
		yym417 := z.DecBinary()
		_ = yym417
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv416), d)
		}
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj398++
	if yyhl398 {
		yyb398 = yyj398 > l
	} else {
		yyb398 = r.CheckBreak()
	}
	if yyb398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj398++
		if yyhl398 {
			yyb398 = yyj398 > l
		} else {
			yyb398 = r.CheckBreak()
		}
		if yyb398 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj398-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym420 := z.EncBinary()
	_ = yym420
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym421 := z.DecBinary()
	_ = yym421
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym422 := z.EncBinary()
		_ = yym422
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep423 := !z.EncBinary()
			yy2arr423 := z.EncBasicHandle().StructToArray
			var yyq423 [3]bool
			_, _, _ = yysep423, yyq423, yy2arr423
			const yyr423 bool = false
			yyq423[0] = x.Phase != ""
			yyq423[1] = x.Message != ""
			yyq423[2] = x.Reason != ""
			var yynn423 int
			if yyr423 || yy2arr423 {
				r.EncodeArrayStart(3)
			} else {
				yynn423 = 0
				for _, b := range yyq423 {
					if b {
						yynn423++
					}
				}
				r.EncodeMapStart(yynn423)
				yynn423 = 0
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[1] {
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym427 := z.EncBinary()
					_ = yym427
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq423[2] {
					yym429 := z.EncBinary()
					_ = yym429
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq423[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym430 := z.EncBinary()
					_ = yym430
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr423 || yy2arr423 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym431 := z.DecBinary()
	_ = yym431
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct432 := r.ContainerType()
		if yyct432 == codecSelferValueTypeMap1234 {
			yyl432 := r.ReadMapStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl432, d)
			}
		} else if yyct432 == codecSelferValueTypeArray1234 {
			yyl432 := r.ReadArrayStart()
			if yyl432 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl432, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys433Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys433Slc
	var yyhl433 bool = l >= 0
	for yyj433 := 0; ; yyj433++ {
		if yyhl433 {
			if yyj433 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys433Slc = r.DecodeBytes(yys433Slc, true, true)
		yys433 := string(yys433Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys433 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys433)
		} // end switch yys433
	} // end for yyj433
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj437 int
	var yyb437 bool
	var yyhl437 bool = l >= 0
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj437++
	if yyhl437 {
		yyb437 = yyj437 > l
	} else {
		yyb437 = r.CheckBreak()
	}
	if yyb437 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj437++
		if yyhl437 {
			yyb437 = yyj437 > l
		} else {
			yyb437 = r.CheckBreak()
		}
		if yyb437 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj437-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym441 := z.EncBinary()
		_ = yym441
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep442 := !z.EncBinary()
			yy2arr442 := z.EncBasicHandle().StructToArray
			var yyq442 [4]bool
			_, _, _ = yysep442, yyq442, yy2arr442
			const yyr442 bool = false
			yyq442[0] = x.Kind != ""
			yyq442[1] = x.APIVersion != ""
			yyq442[2] = true
			var yynn442 int
			if yyr442 || yy2arr442 {
				r.EncodeArrayStart(4)
			} else {
				yynn442 = 1
				for _, b := range yyq442 {
					if b {
						yynn442++
					}
				}
				r.EncodeMapStart(yynn442)
				yynn442 = 0
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[0] {
					yym444 := z.EncBinary()
					_ = yym444
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[1] {
					yym447 := z.EncBinary()
					_ = yym447
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[2] {
					yy450 := &x.ListMeta
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else if z.HasExtensions() && z.EncExt(yy450) {
					} else {
						z.EncFallback(yy450)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq442[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy452 := &x.ListMeta
					yym453 := z.EncBinary()
					_ = yym453
					if false {
					} else if z.HasExtensions() && z.EncExt(yy452) {
					} else {
						z.EncFallback(yy452)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym455 := z.EncBinary()
					_ = yym455
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym457 := z.DecBinary()
	_ = yym457
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct458 := r.ContainerType()
		if yyct458 == codecSelferValueTypeMap1234 {
			yyl458 := r.ReadMapStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl458, d)
			}
		} else if yyct458 == codecSelferValueTypeArray1234 {
			yyl458 := r.ReadArrayStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl458, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys459Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys459Slc
	var yyhl459 bool = l >= 0
	for yyj459 := 0; ; yyj459++ {
		if yyhl459 {
			if yyj459 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys459Slc = r.DecodeBytes(yys459Slc, true, true)
		yys459 := string(yys459Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys459 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv462 := &x.ListMeta
				yym463 := z.DecBinary()
				_ = yym463
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv462) {
				} else {
					z.DecFallback(yyv462, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv464 := &x.Items
				yym465 := z.DecBinary()
				_ = yym465
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv464), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys459)
		} // end switch yys459
	} // end for yyj459
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj466 int
	var yyb466 bool
	var yyhl466 bool = l >= 0
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv469 := &x.ListMeta
		yym470 := z.DecBinary()
		_ = yym470
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv469) {
		} else {
			z.DecFallback(yyv469, false)
		}
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv471 := &x.Items
		yym472 := z.DecBinary()
		_ = yym472
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv471), d)
		}
	}
	for {
		yyj466++
		if yyhl466 {
			yyb466 = yyj466 > l
		} else {
			yyb466 = r.CheckBreak()
		}
		if yyb466 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj466-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym473 := z.EncBinary()
		_ = yym473
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep474 := !z.EncBinary()
			yy2arr474 := z.EncBasicHandle().StructToArray
			var yyq474 [5]bool
			_, _, _ = yysep474, yyq474, yy2arr474
			const yyr474 bool = false
			yyq474[0] = x.Kind != ""
			yyq474[1] = x.APIVersion != ""
			yyq474[2] = true
			yyq474[3] = true
			yyq474[4] = true
			var yynn474 int
			if yyr474 || yy2arr474 {
				r.EncodeArrayStart(5)
			} else {
				yynn474 = 0
				for _, b := range yyq474 {
					if b {
						yynn474++
					}
				}
				r.EncodeMapStart(yynn474)
				yynn474 = 0
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[0] {
					yym476 := z.EncBinary()
					_ = yym476
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq474[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym477 := z.EncBinary()
					_ = yym477
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[1] {
					yym479 := z.EncBinary()
					_ = yym479
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq474[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym480 := z.EncBinary()
					_ = yym480
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[2] {
					yy482 := &x.ObjectMeta
					yy482.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy483 := &x.ObjectMeta
					yy483.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[3] {
					yy485 := &x.Spec
					yy485.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy486 := &x.Spec
					yy486.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[4] {
					yy488 := &x.Status
					yy488.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy489 := &x.Status
					yy489.CodecEncodeSelf(e)
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym490 := z.DecBinary()
	_ = yym490
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct491 := r.ContainerType()
		if yyct491 == codecSelferValueTypeMap1234 {
			yyl491 := r.ReadMapStart()
			if yyl491 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl491, d)
			}
		} else if yyct491 == codecSelferValueTypeArray1234 {
			yyl491 := r.ReadArrayStart()
			if yyl491 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl491, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys492Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys492Slc
	var yyhl492 bool = l >= 0
	for yyj492 := 0; ; yyj492++ {
		if yyhl492 {
			if yyj492 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys492Slc = r.DecodeBytes(yys492Slc, true, true)
		yys492 := string(yys492Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys492 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv495 := &x.ObjectMeta
				yyv495.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv496 := &x.Spec
				yyv496.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv497 := &x.Status
				yyv497.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys492)
		} // end switch yys492
	} // end for yyj492
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj498 int
	var yyb498 bool
	var yyhl498 bool = l >= 0
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv501 := &x.ObjectMeta
		yyv501.CodecDecodeSelf(d)
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv502 := &x.Spec
		yyv502.CodecDecodeSelf(d)
	}
	yyj498++
	if yyhl498 {
		yyb498 = yyj498 > l
	} else {
		yyb498 = r.CheckBreak()
	}
	if yyb498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv503 := &x.Status
		yyv503.CodecDecodeSelf(d)
	}
	for {
		yyj498++
		if yyhl498 {
			yyb498 = yyj498 > l
		} else {
			yyb498 = r.CheckBreak()
		}
		if yyb498 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj498-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym504 := z.EncBinary()
		_ = yym504
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep505 := !z.EncBinary()
			yy2arr505 := z.EncBasicHandle().StructToArray
			var yyq505 [4]bool
			_, _, _ = yysep505, yyq505, yy2arr505
			const yyr505 bool = false
			yyq505[0] = x.Kind != ""
			yyq505[1] = x.APIVersion != ""
			yyq505[2] = true
			var yynn505 int
			if yyr505 || yy2arr505 {
				r.EncodeArrayStart(4)
			} else {
				yynn505 = 1
				for _, b := range yyq505 {
					if b {
						yynn505++
					}
				}
				r.EncodeMapStart(yynn505)
				yynn505 = 0
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[0] {
					yym507 := z.EncBinary()
					_ = yym507
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq505[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym508 := z.EncBinary()
					_ = yym508
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[1] {
					yym510 := z.EncBinary()
					_ = yym510
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq505[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym511 := z.EncBinary()
					_ = yym511
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq505[2] {
					yy513 := &x.ListMeta
					yym514 := z.EncBinary()
					_ = yym514
					if false {
					} else if z.HasExtensions() && z.EncExt(yy513) {
					} else {
						z.EncFallback(yy513)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq505[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy515 := &x.ListMeta
					yym516 := z.EncBinary()
					_ = yym516
					if false {
					} else if z.HasExtensions() && z.EncExt(yy515) {
					} else {
						z.EncFallback(yy515)
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym518 := z.EncBinary()
					_ = yym518
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr505 || yy2arr505 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym520 := z.DecBinary()
	_ = yym520
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct521 := r.ContainerType()
		if yyct521 == codecSelferValueTypeMap1234 {
			yyl521 := r.ReadMapStart()
			if yyl521 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl521, d)
			}
		} else if yyct521 == codecSelferValueTypeArray1234 {
			yyl521 := r.ReadArrayStart()
			if yyl521 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl521, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys522Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys522Slc
	var yyhl522 bool = l >= 0
	for yyj522 := 0; ; yyj522++ {
		if yyhl522 {
			if yyj522 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys522Slc = r.DecodeBytes(yys522Slc, true, true)
		yys522 := string(yys522Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys522 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv525 := &x.ListMeta
				yym526 := z.DecBinary()
				_ = yym526
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv525) {
				} else {
					z.DecFallback(yyv525, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv527 := &x.Items
				yym528 := z.DecBinary()
				_ = yym528
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv527), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys522)
		} // end switch yys522
	} // end for yyj522
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj529 int
	var yyb529 bool
	var yyhl529 bool = l >= 0
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv532 := &x.ListMeta
		yym533 := z.DecBinary()
		_ = yym533
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv532) {
		} else {
			z.DecFallback(yyv532, false)
		}
	}
	yyj529++
	if yyhl529 {
		yyb529 = yyj529 > l
	} else {
		yyb529 = r.CheckBreak()
	}
	if yyb529 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv534 := &x.Items
		yym535 := z.DecBinary()
		_ = yym535
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv534), d)
		}
	}
	for {
		yyj529++
		if yyhl529 {
			yyb529 = yyj529 > l
		} else {
			yyb529 = r.CheckBreak()
		}
		if yyb529 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj529-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym536 := z.EncBinary()
		_ = yym536
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep537 := !z.EncBinary()
			yy2arr537 := z.EncBasicHandle().StructToArray
			var yyq537 [4]bool
			_, _, _ = yysep537, yyq537, yy2arr537
			const yyr537 bool = false
			yyq537[0] = len(x.AccessModes) != 0
			yyq537[1] = x.Selector != nil
			yyq537[2] = true
			yyq537[3] = x.VolumeName != ""
			var yynn537 int
			if yyr537 || yy2arr537 {
				r.EncodeArrayStart(4)
			} else {
				yynn537 = 0
				for _, b := range yyq537 {
					if b {
						yynn537++
					}
				}
				r.EncodeMapStart(yynn537)
				yynn537 = 0
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym539 := z.EncBinary()
						_ = yym539
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym540 := z.EncBinary()
						_ = yym540
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym542 := z.EncBinary()
						_ = yym542
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym543 := z.EncBinary()
						_ = yym543
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[2] {
					yy545 := &x.Resources
					yy545.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq537[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy546 := &x.Resources
					yy546.CodecEncodeSelf(e)
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq537[3] {
					yym548 := z.EncBinary()
					_ = yym548
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq537[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym549 := z.EncBinary()
					_ = yym549
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr537 || yy2arr537 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym550 := z.DecBinary()
	_ = yym550
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct551 := r.ContainerType()
		if yyct551 == codecSelferValueTypeMap1234 {
			yyl551 := r.ReadMapStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl551, d)
			}
		} else if yyct551 == codecSelferValueTypeArray1234 {
			yyl551 := r.ReadArrayStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl551, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys552Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys552Slc
	var yyhl552 bool = l >= 0
	for yyj552 := 0; ; yyj552++ {
		if yyhl552 {
			if yyj552 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys552Slc = r.DecodeBytes(yys552Slc, true, true)
		yys552 := string(yys552Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys552 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv553 := &x.AccessModes
				yym554 := z.DecBinary()
				_ = yym554
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv553), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_unversioned.LabelSelector)
				}
				yym556 := z.DecBinary()
				_ = yym556
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv557 := &x.Resources
				yyv557.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys552)
		} // end switch yys552
	} // end for yyj552
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj559 int
	var yyb559 bool
	var yyhl559 bool = l >= 0
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv560 := &x.AccessModes
		yym561 := z.DecBinary()
		_ = yym561
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv560), d)
		}
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_unversioned.LabelSelector)
		}
		yym563 := z.DecBinary()
		_ = yym563
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv564 := &x.Resources
		yyv564.CodecDecodeSelf(d)
	}
	yyj559++
	if yyhl559 {
		yyb559 = yyj559 > l
	} else {
		yyb559 = r.CheckBreak()
	}
	if yyb559 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj559++
		if yyhl559 {
			yyb559 = yyj559 > l
		} else {
			yyb559 = r.CheckBreak()
		}
		if yyb559 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj559-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym566 := z.EncBinary()
		_ = yym566
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep567 := !z.EncBinary()
			yy2arr567 := z.EncBasicHandle().StructToArray
			var yyq567 [3]bool
			_, _, _ = yysep567, yyq567, yy2arr567
			const yyr567 bool = false
			yyq567[0] = x.Phase != ""
			yyq567[1] = len(x.AccessModes) != 0
			yyq567[2] = len(x.Capacity) != 0
			var yynn567 int
			if yyr567 || yy2arr567 {
				r.EncodeArrayStart(3)
			} else {
				yynn567 = 0
				for _, b := range yyq567 {
					if b {
						yynn567++
					}
				}
				r.EncodeMapStart(yynn567)
				yynn567 = 0
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq567[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym570 := z.EncBinary()
						_ = yym570
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq567[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym571 := z.EncBinary()
						_ = yym571
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq567[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq567[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr567 || yy2arr567 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym573 := z.DecBinary()
	_ = yym573
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct574 := r.ContainerType()
		if yyct574 == codecSelferValueTypeMap1234 {
			yyl574 := r.ReadMapStart()
			if yyl574 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl574, d)
			}
		} else if yyct574 == codecSelferValueTypeArray1234 {
			yyl574 := r.ReadArrayStart()
			if yyl574 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl574, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys575Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys575Slc
	var yyhl575 bool = l >= 0
	for yyj575 := 0; ; yyj575++ {
		if yyhl575 {
			if yyj575 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys575Slc = r.DecodeBytes(yys575Slc, true, true)
		yys575 := string(yys575Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys575 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv577 := &x.AccessModes
				yym578 := z.DecBinary()
				_ = yym578
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv577), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv579 := &x.Capacity
				yyv579.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys575)
		} // end switch yys575
	} // end for yyj575
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj580 int
	var yyb580 bool
	var yyhl580 bool = l >= 0
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv582 := &x.AccessModes
		yym583 := z.DecBinary()
		_ = yym583
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv582), d)
		}
	}
	yyj580++
	if yyhl580 {
		yyb580 = yyj580 > l
	} else {
		yyb580 = r.CheckBreak()
	}
	if yyb580 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv584 := &x.Capacity
		yyv584.CodecDecodeSelf(d)
	}
	for {
		yyj580++
		if yyhl580 {
			yyb580 = yyj580 > l
		} else {
			yyb580 = r.CheckBreak()
		}
		if yyb580 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj580-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym585 := z.EncBinary()
	_ = yym585
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym586 := z.DecBinary()
	_ = yym586
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym587 := z.EncBinary()
	_ = yym587
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym588 := z.DecBinary()
	_ = yym588
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym589 := z.EncBinary()
	_ = yym589
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym590 := z.DecBinary()
	_ = yym590
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym591 := z.EncBinary()
		_ = yym591
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep592 := !z.EncBinary()
			yy2arr592 := z.EncBasicHandle().StructToArray
			var yyq592 [1]bool
			_, _, _ = yysep592, yyq592, yy2arr592
			const yyr592 bool = false
			var yynn592 int
			if yyr592 || yy2arr592 {
				r.EncodeArrayStart(1)
			} else {
				yynn592 = 1
				for _, b := range yyq592 {
					if b {
						yynn592++
					}
				}
				r.EncodeMapStart(yynn592)
				yynn592 = 0
			}
			if yyr592 || yy2arr592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym594 := z.EncBinary()
				_ = yym594
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym595 := z.EncBinary()
				_ = yym595
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr592 || yy2arr592 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym596 := z.DecBinary()
	_ = yym596
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct597 := r.ContainerType()
		if yyct597 == codecSelferValueTypeMap1234 {
			yyl597 := r.ReadMapStart()
			if yyl597 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl597, d)
			}
		} else if yyct597 == codecSelferValueTypeArray1234 {
			yyl597 := r.ReadArrayStart()
			if yyl597 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl597, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys598Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys598Slc
	var yyhl598 bool = l >= 0
	for yyj598 := 0; ; yyj598++ {
		if yyhl598 {
			if yyj598 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys598Slc = r.DecodeBytes(yys598Slc, true, true)
		yys598 := string(yys598Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys598 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys598)
		} // end switch yys598
	} // end for yyj598
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj600 int
	var yyb600 bool
	var yyhl600 bool = l >= 0
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj600++
		if yyhl600 {
			yyb600 = yyj600 > l
		} else {
			yyb600 = r.CheckBreak()
		}
		if yyb600 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj600-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym602 := z.EncBinary()
		_ = yym602
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep603 := !z.EncBinary()
			yy2arr603 := z.EncBasicHandle().StructToArray
			var yyq603 [1]bool
			_, _, _ = yysep603, yyq603, yy2arr603
			const yyr603 bool = false
			yyq603[0] = x.Medium != ""
			var yynn603 int
			if yyr603 || yy2arr603 {
				r.EncodeArrayStart(1)
			} else {
				yynn603 = 0
				for _, b := range yyq603 {
					if b {
						yynn603++
					}
				}
				r.EncodeMapStart(yynn603)
				yynn603 = 0
			}
			if yyr603 || yy2arr603 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq603[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq603[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr603 || yy2arr603 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym605 := z.DecBinary()
	_ = yym605
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct606 := r.ContainerType()
		if yyct606 == codecSelferValueTypeMap1234 {
			yyl606 := r.ReadMapStart()
			if yyl606 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl606, d)
			}
		} else if yyct606 == codecSelferValueTypeArray1234 {
			yyl606 := r.ReadArrayStart()
			if yyl606 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl606, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys607Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys607Slc
	var yyhl607 bool = l >= 0
	for yyj607 := 0; ; yyj607++ {
		if yyhl607 {
			if yyj607 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys607Slc = r.DecodeBytes(yys607Slc, true, true)
		yys607 := string(yys607Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys607 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys607)
		} // end switch yys607
	} // end for yyj607
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj609 int
	var yyb609 bool
	var yyhl609 bool = l >= 0
	yyj609++
	if yyhl609 {
		yyb609 = yyj609 > l
	} else {
		yyb609 = r.CheckBreak()
	}
	if yyb609 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj609++
		if yyhl609 {
			yyb609 = yyj609 > l
		} else {
			yyb609 = r.CheckBreak()
		}
		if yyb609 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj609-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym611 := z.EncBinary()
	_ = yym611
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym612 := z.DecBinary()
	_ = yym612
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym613 := z.EncBinary()
	_ = yym613
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym614 := z.DecBinary()
	_ = yym614
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym615 := z.EncBinary()
		_ = yym615
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep616 := !z.EncBinary()
			yy2arr616 := z.EncBasicHandle().StructToArray
			var yyq616 [4]bool
			_, _, _ = yysep616, yyq616, yy2arr616
			const yyr616 bool = false
			yyq616[1] = x.FSType != ""
			yyq616[2] = x.Partition != 0
			yyq616[3] = x.ReadOnly != false
			var yynn616 int
			if yyr616 || yy2arr616 {
				r.EncodeArrayStart(4)
			} else {
				yynn616 = 1
				for _, b := range yyq616 {
					if b {
						yynn616++
					}
				}
				r.EncodeMapStart(yynn616)
				yynn616 = 0
			}
			if yyr616 || yy2arr616 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym618 := z.EncBinary()
				_ = yym618
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym619 := z.EncBinary()
				_ = yym619
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr616 || yy2arr616 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq616[1] {
					yym621 := z.EncBinary()
					_ = yym621
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq616[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym622 := z.EncBinary()
					_ = yym622
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr616 || yy2arr616 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq616[2] {
					yym624 := z.EncBinary()
					_ = yym624
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq616[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym625 := z.EncBinary()
					_ = yym625
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr616 || yy2arr616 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq616[3] {
					yym627 := z.EncBinary()
					_ = yym627
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq616[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym628 := z.EncBinary()
					_ = yym628
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr616 || yy2arr616 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym629 := z.DecBinary()
	_ = yym629
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct630 := r.ContainerType()
		if yyct630 == codecSelferValueTypeMap1234 {
			yyl630 := r.ReadMapStart()
			if yyl630 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl630, d)
			}
		} else if yyct630 == codecSelferValueTypeArray1234 {
			yyl630 := r.ReadArrayStart()
			if yyl630 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl630, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys631Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys631Slc
	var yyhl631 bool = l >= 0
	for yyj631 := 0; ; yyj631++ {
		if yyhl631 {
			if yyj631 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys631Slc = r.DecodeBytes(yys631Slc, true, true)
		yys631 := string(yys631Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys631 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys631)
		} // end switch yys631
	} // end for yyj631
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj636 int
	var yyb636 bool
	var yyhl636 bool = l >= 0
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj636++
		if yyhl636 {
			yyb636 = yyj636 > l
		} else {
			yyb636 = r.CheckBreak()
		}
		if yyb636 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj636-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym641 := z.EncBinary()
		_ = yym641
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep642 := !z.EncBinary()
			yy2arr642 := z.EncBasicHandle().StructToArray
			var yyq642 [6]bool
			_, _, _ = yysep642, yyq642, yy2arr642
			const yyr642 bool = false
			yyq642[0] = x.TargetPortal != ""
			yyq642[1] = x.IQN != ""
			yyq642[2] = x.Lun != 0
			yyq642[3] = x.ISCSIInterface != ""
			yyq642[4] = x.FSType != ""
			yyq642[5] = x.ReadOnly != false
			var yynn642 int
			if yyr642 || yy2arr642 {
				r.EncodeArrayStart(6)
			} else {
				yynn642 = 0
				for _, b := range yyq642 {
					if b {
						yynn642++
					}
				}
				r.EncodeMapStart(yynn642)
				yynn642 = 0
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[0] {
					yym644 := z.EncBinary()
					_ = yym644
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq642[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym645 := z.EncBinary()
					_ = yym645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[1] {
					yym647 := z.EncBinary()
					_ = yym647
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq642[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iqn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[2] {
					yym650 := z.EncBinary()
					_ = yym650
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq642[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lun"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym651 := z.EncBinary()
					_ = yym651
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[3] {
					yym653 := z.EncBinary()
					_ = yym653
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq642[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym654 := z.EncBinary()
					_ = yym654
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[4] {
					yym656 := z.EncBinary()
					_ = yym656
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq642[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym657 := z.EncBinary()
					_ = yym657
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq642[5] {
					yym659 := z.EncBinary()
					_ = yym659
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq642[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym660 := z.EncBinary()
					_ = yym660
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr642 || yy2arr642 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym661 := z.DecBinary()
	_ = yym661
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct662 := r.ContainerType()
		if yyct662 == codecSelferValueTypeMap1234 {
			yyl662 := r.ReadMapStart()
			if yyl662 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl662, d)
			}
		} else if yyct662 == codecSelferValueTypeArray1234 {
			yyl662 := r.ReadArrayStart()
			if yyl662 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl662, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys663Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys663Slc
	var yyhl663 bool = l >= 0
	for yyj663 := 0; ; yyj663++ {
		if yyhl663 {
			if yyj663 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys663Slc = r.DecodeBytes(yys663Slc, true, true)
		yys663 := string(yys663Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys663 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int32(r.DecodeInt(32))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys663)
		} // end switch yys663
	} // end for yyj663
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj670 int
	var yyb670 bool
	var yyhl670 bool = l >= 0
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int32(r.DecodeInt(32))
	}
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj670++
	if yyhl670 {
		yyb670 = yyj670 > l
	} else {
		yyb670 = r.CheckBreak()
	}
	if yyb670 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj670++
		if yyhl670 {
			yyb670 = yyj670 > l
		} else {
			yyb670 = r.CheckBreak()
		}
		if yyb670 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj670-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym677 := z.EncBinary()
		_ = yym677
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep678 := !z.EncBinary()
			yy2arr678 := z.EncBasicHandle().StructToArray
			var yyq678 [4]bool
			_, _, _ = yysep678, yyq678, yy2arr678
			const yyr678 bool = false
			yyq678[2] = x.FSType != ""
			yyq678[3] = x.ReadOnly != false
			var yynn678 int
			if yyr678 || yy2arr678 {
				r.EncodeArrayStart(4)
			} else {
				yynn678 = 2
				for _, b := range yyq678 {
					if b {
						yynn678++
					}
				}
				r.EncodeMapStart(yynn678)
				yynn678 = 0
			}
			if yyr678 || yy2arr678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym680 := z.EncBinary()
					_ = yym680
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym681 := z.EncBinary()
					_ = yym681
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr678 || yy2arr678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy683 := *x.Lun
					yym684 := z.EncBinary()
					_ = yym684
					if false {
					} else {
						r.EncodeInt(int64(yy683))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy685 := *x.Lun
					yym686 := z.EncBinary()
					_ = yym686
					if false {
					} else {
						r.EncodeInt(int64(yy685))
					}
				}
			}
			if yyr678 || yy2arr678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq678[2] {
					yym688 := z.EncBinary()
					_ = yym688
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq678[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym689 := z.EncBinary()
					_ = yym689
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr678 || yy2arr678 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq678[3] {
					yym691 := z.EncBinary()
					_ = yym691
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq678[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym692 := z.EncBinary()
					_ = yym692
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr678 || yy2arr678 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym693 := z.DecBinary()
	_ = yym693
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct694 := r.ContainerType()
		if yyct694 == codecSelferValueTypeMap1234 {
			yyl694 := r.ReadMapStart()
			if yyl694 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl694, d)
			}
		} else if yyct694 == codecSelferValueTypeArray1234 {
			yyl694 := r.ReadArrayStart()
			if yyl694 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl694, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys695Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys695Slc
	var yyhl695 bool = l >= 0
	for yyj695 := 0; ; yyj695++ {
		if yyhl695 {
			if yyj695 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys695Slc = r.DecodeBytes(yys695Slc, true, true)
		yys695 := string(yys695Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys695 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv696 := &x.TargetWWNs
				yym697 := z.DecBinary()
				_ = yym697
				if false {
				} else {
					z.F.DecSliceStringX(yyv696, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym699 := z.DecBinary()
				_ = yym699
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys695)
		} // end switch yys695
	} // end for yyj695
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj702 int
	var yyb702 bool
	var yyhl702 bool = l >= 0
	yyj702++
	if yyhl702 {
		yyb702 = yyj702 > l
	} else {
		yyb702 = r.CheckBreak()
	}
	if yyb702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv703 := &x.TargetWWNs
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else {
			z.F.DecSliceStringX(yyv703, false, d)
		}
	}
	yyj702++
	if yyhl702 {
		yyb702 = yyj702 > l
	} else {
		yyb702 = r.CheckBreak()
	}
	if yyb702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym706 := z.DecBinary()
		_ = yym706
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj702++
	if yyhl702 {
		yyb702 = yyj702 > l
	} else {
		yyb702 = r.CheckBreak()
	}
	if yyb702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj702++
	if yyhl702 {
		yyb702 = yyj702 > l
	} else {
		yyb702 = r.CheckBreak()
	}
	if yyb702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj702++
		if yyhl702 {
			yyb702 = yyj702 > l
		} else {
			yyb702 = r.CheckBreak()
		}
		if yyb702 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj702-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym709 := z.EncBinary()
		_ = yym709
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep710 := !z.EncBinary()
			yy2arr710 := z.EncBasicHandle().StructToArray
			var yyq710 [5]bool
			_, _, _ = yysep710, yyq710, yy2arr710
			const yyr710 bool = false
			yyq710[1] = x.FSType != ""
			yyq710[2] = x.SecretRef != nil
			yyq710[3] = x.ReadOnly != false
			yyq710[4] = len(x.Options) != 0
			var yynn710 int
			if yyr710 || yy2arr710 {
				r.EncodeArrayStart(5)
			} else {
				yynn710 = 1
				for _, b := range yyq710 {
					if b {
						yynn710++
					}
				}
				r.EncodeMapStart(yynn710)
				yynn710 = 0
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym712 := z.EncBinary()
				_ = yym712
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym713 := z.EncBinary()
				_ = yym713
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[1] {
					yym715 := z.EncBinary()
					_ = yym715
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq710[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym716 := z.EncBinary()
					_ = yym716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq710[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[3] {
					yym719 := z.EncBinary()
					_ = yym719
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq710[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym720 := z.EncBinary()
					_ = yym720
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym722 := z.EncBinary()
						_ = yym722
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq710[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym723 := z.EncBinary()
						_ = yym723
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym724 := z.DecBinary()
	_ = yym724
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct725 := r.ContainerType()
		if yyct725 == codecSelferValueTypeMap1234 {
			yyl725 := r.ReadMapStart()
			if yyl725 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl725, d)
			}
		} else if yyct725 == codecSelferValueTypeArray1234 {
			yyl725 := r.ReadArrayStart()
			if yyl725 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl725, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys726Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys726Slc
	var yyhl726 bool = l >= 0
	for yyj726 := 0; ; yyj726++ {
		if yyhl726 {
			if yyj726 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys726Slc = r.DecodeBytes(yys726Slc, true, true)
		yys726 := string(yys726Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys726 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv731 := &x.Options
				yym732 := z.DecBinary()
				_ = yym732
				if false {
				} else {
					z.F.DecMapStringStringX(yyv731, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys726)
		} // end switch yys726
	} // end for yyj726
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj733 int
	var yyb733 bool
	var yyhl733 bool = l >= 0
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv738 := &x.Options
		yym739 := z.DecBinary()
		_ = yym739
		if false {
		} else {
			z.F.DecMapStringStringX(yyv738, false, d)
		}
	}
	for {
		yyj733++
		if yyhl733 {
			yyb733 = yyj733 > l
		} else {
			yyb733 = r.CheckBreak()
		}
		if yyb733 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj733-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym740 := z.EncBinary()
		_ = yym740
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep741 := !z.EncBinary()
			yy2arr741 := z.EncBasicHandle().StructToArray
			var yyq741 [4]bool
			_, _, _ = yysep741, yyq741, yy2arr741
			const yyr741 bool = false
			yyq741[1] = x.FSType != ""
			yyq741[2] = x.Partition != 0
			yyq741[3] = x.ReadOnly != false
			var yynn741 int
			if yyr741 || yy2arr741 {
				r.EncodeArrayStart(4)
			} else {
				yynn741 = 1
				for _, b := range yyq741 {
					if b {
						yynn741++
					}
				}
				r.EncodeMapStart(yynn741)
				yynn741 = 0
			}
			if yyr741 || yy2arr741 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym743 := z.EncBinary()
				_ = yym743
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym744 := z.EncBinary()
				_ = yym744
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr741 || yy2arr741 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq741[1] {
					yym746 := z.EncBinary()
					_ = yym746
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq741[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym747 := z.EncBinary()
					_ = yym747
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr741 || yy2arr741 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq741[2] {
					yym749 := z.EncBinary()
					_ = yym749
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq741[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym750 := z.EncBinary()
					_ = yym750
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr741 || yy2arr741 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq741[3] {
					yym752 := z.EncBinary()
					_ = yym752
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq741[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym753 := z.EncBinary()
					_ = yym753
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr741 || yy2arr741 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym754 := z.DecBinary()
	_ = yym754
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct755 := r.ContainerType()
		if yyct755 == codecSelferValueTypeMap1234 {
			yyl755 := r.ReadMapStart()
			if yyl755 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl755, d)
			}
		} else if yyct755 == codecSelferValueTypeArray1234 {
			yyl755 := r.ReadArrayStart()
			if yyl755 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl755, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys756Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys756Slc
	var yyhl756 bool = l >= 0
	for yyj756 := 0; ; yyj756++ {
		if yyhl756 {
			if yyj756 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys756Slc = r.DecodeBytes(yys756Slc, true, true)
		yys756 := string(yys756Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys756 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys756)
		} // end switch yys756
	} // end for yyj756
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj761 int
	var yyb761 bool
	var yyhl761 bool = l >= 0
	yyj761++
	if yyhl761 {
		yyb761 = yyj761 > l
	} else {
		yyb761 = r.CheckBreak()
	}
	if yyb761 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj761++
	if yyhl761 {
		yyb761 = yyj761 > l
	} else {
		yyb761 = r.CheckBreak()
	}
	if yyb761 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj761++
	if yyhl761 {
		yyb761 = yyj761 > l
	} else {
		yyb761 = r.CheckBreak()
	}
	if yyb761 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj761++
	if yyhl761 {
		yyb761 = yyj761 > l
	} else {
		yyb761 = r.CheckBreak()
	}
	if yyb761 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj761++
		if yyhl761 {
			yyb761 = yyj761 > l
		} else {
			yyb761 = r.CheckBreak()
		}
		if yyb761 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj761-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym766 := z.EncBinary()
		_ = yym766
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep767 := !z.EncBinary()
			yy2arr767 := z.EncBasicHandle().StructToArray
			var yyq767 [3]bool
			_, _, _ = yysep767, yyq767, yy2arr767
			const yyr767 bool = false
			yyq767[1] = x.Revision != ""
			yyq767[2] = x.Directory != ""
			var yynn767 int
			if yyr767 || yy2arr767 {
				r.EncodeArrayStart(3)
			} else {
				yynn767 = 1
				for _, b := range yyq767 {
					if b {
						yynn767++
					}
				}
				r.EncodeMapStart(yynn767)
				yynn767 = 0
			}
			if yyr767 || yy2arr767 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym769 := z.EncBinary()
				_ = yym769
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym770 := z.EncBinary()
				_ = yym770
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr767 || yy2arr767 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq767[1] {
					yym772 := z.EncBinary()
					_ = yym772
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq767[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym773 := z.EncBinary()
					_ = yym773
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr767 || yy2arr767 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq767[2] {
					yym775 := z.EncBinary()
					_ = yym775
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq767[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym776 := z.EncBinary()
					_ = yym776
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr767 || yy2arr767 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym777 := z.DecBinary()
	_ = yym777
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct778 := r.ContainerType()
		if yyct778 == codecSelferValueTypeMap1234 {
			yyl778 := r.ReadMapStart()
			if yyl778 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl778, d)
			}
		} else if yyct778 == codecSelferValueTypeArray1234 {
			yyl778 := r.ReadArrayStart()
			if yyl778 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl778, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys779Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys779Slc
	var yyhl779 bool = l >= 0
	for yyj779 := 0; ; yyj779++ {
		if yyhl779 {
			if yyj779 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys779Slc = r.DecodeBytes(yys779Slc, true, true)
		yys779 := string(yys779Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys779 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys779)
		} // end switch yys779
	} // end for yyj779
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj783 int
	var yyb783 bool
	var yyhl783 bool = l >= 0
	yyj783++
	if yyhl783 {
		yyb783 = yyj783 > l
	} else {
		yyb783 = r.CheckBreak()
	}
	if yyb783 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj783++
	if yyhl783 {
		yyb783 = yyj783 > l
	} else {
		yyb783 = r.CheckBreak()
	}
	if yyb783 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj783++
	if yyhl783 {
		yyb783 = yyj783 > l
	} else {
		yyb783 = r.CheckBreak()
	}
	if yyb783 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj783++
		if yyhl783 {
			yyb783 = yyj783 > l
		} else {
			yyb783 = r.CheckBreak()
		}
		if yyb783 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj783-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym787 := z.EncBinary()
		_ = yym787
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep788 := !z.EncBinary()
			yy2arr788 := z.EncBasicHandle().StructToArray
			var yyq788 [3]bool
			_, _, _ = yysep788, yyq788, yy2arr788
			const yyr788 bool = false
			yyq788[0] = x.SecretName != ""
			yyq788[1] = len(x.Items) != 0
			yyq788[2] = x.DefaultMode != nil
			var yynn788 int
			if yyr788 || yy2arr788 {
				r.EncodeArrayStart(3)
			} else {
				yynn788 = 0
				for _, b := range yyq788 {
					if b {
						yynn788++
					}
				}
				r.EncodeMapStart(yynn788)
				yynn788 = 0
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq788[0] {
					yym790 := z.EncBinary()
					_ = yym790
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq788[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym791 := z.EncBinary()
					_ = yym791
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq788[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym793 := z.EncBinary()
						_ = yym793
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq788[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym794 := z.EncBinary()
						_ = yym794
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq788[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy796 := *x.DefaultMode
						yym797 := z.EncBinary()
						_ = yym797
						if false {
						} else {
							r.EncodeInt(int64(yy796))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq788[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy798 := *x.DefaultMode
						yym799 := z.EncBinary()
						_ = yym799
						if false {
						} else {
							r.EncodeInt(int64(yy798))
						}
					}
				}
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym800 := z.DecBinary()
	_ = yym800
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct801 := r.ContainerType()
		if yyct801 == codecSelferValueTypeMap1234 {
			yyl801 := r.ReadMapStart()
			if yyl801 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl801, d)
			}
		} else if yyct801 == codecSelferValueTypeArray1234 {
			yyl801 := r.ReadArrayStart()
			if yyl801 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl801, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys802Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys802Slc
	var yyhl802 bool = l >= 0
	for yyj802 := 0; ; yyj802++ {
		if yyhl802 {
			if yyj802 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys802Slc = r.DecodeBytes(yys802Slc, true, true)
		yys802 := string(yys802Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys802 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv804 := &x.Items
				yym805 := z.DecBinary()
				_ = yym805
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv804), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym807 := z.DecBinary()
				_ = yym807
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys802)
		} // end switch yys802
	} // end for yyj802
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj808 int
	var yyb808 bool
	var yyhl808 bool = l >= 0
	yyj808++
	if yyhl808 {
		yyb808 = yyj808 > l
	} else {
		yyb808 = r.CheckBreak()
	}
	if yyb808 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj808++
	if yyhl808 {
		yyb808 = yyj808 > l
	} else {
		yyb808 = r.CheckBreak()
	}
	if yyb808 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv810 := &x.Items
		yym811 := z.DecBinary()
		_ = yym811
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv810), d)
		}
	}
	yyj808++
	if yyhl808 {
		yyb808 = yyj808 > l
	} else {
		yyb808 = r.CheckBreak()
	}
	if yyb808 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym813 := z.DecBinary()
		_ = yym813
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj808++
		if yyhl808 {
			yyb808 = yyj808 > l
		} else {
			yyb808 = r.CheckBreak()
		}
		if yyb808 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj808-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym814 := z.EncBinary()
		_ = yym814
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep815 := !z.EncBinary()
			yy2arr815 := z.EncBasicHandle().StructToArray
			var yyq815 [3]bool
			_, _, _ = yysep815, yyq815, yy2arr815
			const yyr815 bool = false
			yyq815[2] = x.ReadOnly != false
			var yynn815 int
			if yyr815 || yy2arr815 {
				r.EncodeArrayStart(3)
			} else {
				yynn815 = 2
				for _, b := range yyq815 {
					if b {
						yynn815++
					}
				}
				r.EncodeMapStart(yynn815)
				yynn815 = 0
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym817 := z.EncBinary()
				_ = yym817
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym818 := z.EncBinary()
				_ = yym818
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym820 := z.EncBinary()
				_ = yym820
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym821 := z.EncBinary()
				_ = yym821
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq815[2] {
					yym823 := z.EncBinary()
					_ = yym823
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq815[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym824 := z.EncBinary()
					_ = yym824
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym825 := z.DecBinary()
	_ = yym825
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct826 := r.ContainerType()
		if yyct826 == codecSelferValueTypeMap1234 {
			yyl826 := r.ReadMapStart()
			if yyl826 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl826, d)
			}
		} else if yyct826 == codecSelferValueTypeArray1234 {
			yyl826 := r.ReadArrayStart()
			if yyl826 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl826, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys827Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys827Slc
	var yyhl827 bool = l >= 0
	for yyj827 := 0; ; yyj827++ {
		if yyhl827 {
			if yyj827 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys827Slc = r.DecodeBytes(yys827Slc, true, true)
		yys827 := string(yys827Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys827 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys827)
		} // end switch yys827
	} // end for yyj827
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj831 int
	var yyb831 bool
	var yyhl831 bool = l >= 0
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj831++
	if yyhl831 {
		yyb831 = yyj831 > l
	} else {
		yyb831 = r.CheckBreak()
	}
	if yyb831 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj831++
		if yyhl831 {
			yyb831 = yyj831 > l
		} else {
			yyb831 = r.CheckBreak()
		}
		if yyb831 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj831-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *QuobyteVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym835 := z.EncBinary()
		_ = yym835
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep836 := !z.EncBinary()
			yy2arr836 := z.EncBasicHandle().StructToArray
			var yyq836 [5]bool
			_, _, _ = yysep836, yyq836, yy2arr836
			const yyr836 bool = false
			yyq836[2] = x.ReadOnly != false
			yyq836[3] = x.User != ""
			yyq836[4] = x.Group != ""
			var yynn836 int
			if yyr836 || yy2arr836 {
				r.EncodeArrayStart(5)
			} else {
				yynn836 = 2
				for _, b := range yyq836 {
					if b {
						yynn836++
					}
				}
				r.EncodeMapStart(yynn836)
				yynn836 = 0
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym838 := z.EncBinary()
				_ = yym838
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym839 := z.EncBinary()
				_ = yym839
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym841 := z.EncBinary()
				_ = yym841
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volume"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym842 := z.EncBinary()
				_ = yym842
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq836[2] {
					yym844 := z.EncBinary()
					_ = yym844
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq836[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym845 := z.EncBinary()
					_ = yym845
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq836[3] {
					yym847 := z.EncBinary()
					_ = yym847
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq836[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym848 := z.EncBinary()
					_ = yym848
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq836[4] {
					yym850 := z.EncBinary()
					_ = yym850
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq836[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym851 := z.EncBinary()
					_ = yym851
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr836 || yy2arr836 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *QuobyteVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym852 := z.DecBinary()
	_ = yym852
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct853 := r.ContainerType()
		if yyct853 == codecSelferValueTypeMap1234 {
			yyl853 := r.ReadMapStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl853, d)
			}
		} else if yyct853 == codecSelferValueTypeArray1234 {
			yyl853 := r.ReadArrayStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl853, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys854Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys854Slc
	var yyhl854 bool = l >= 0
	for yyj854 := 0; ; yyj854++ {
		if yyhl854 {
			if yyj854 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys854Slc = r.DecodeBytes(yys854Slc, true, true)
		yys854 := string(yys854Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys854 {
		case "registry":
			if r.TryDecodeAsNil() {
				x.Registry = ""
			} else {
				x.Registry = string(r.DecodeString())
			}
		case "volume":
			if r.TryDecodeAsNil() {
				x.Volume = ""
			} else {
				x.Volume = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys854)
		} // end switch yys854
	} // end for yyj854
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj860 int
	var yyb860 bool
	var yyhl860 bool = l >= 0
	yyj860++
	if yyhl860 {
		yyb860 = yyj860 > l
	} else {
		yyb860 = r.CheckBreak()
	}
	if yyb860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Registry = ""
	} else {
		x.Registry = string(r.DecodeString())
	}
	yyj860++
	if yyhl860 {
		yyb860 = yyj860 > l
	} else {
		yyb860 = r.CheckBreak()
	}
	if yyb860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volume = ""
	} else {
		x.Volume = string(r.DecodeString())
	}
	yyj860++
	if yyhl860 {
		yyb860 = yyj860 > l
	} else {
		yyb860 = r.CheckBreak()
	}
	if yyb860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj860++
	if yyhl860 {
		yyb860 = yyj860 > l
	} else {
		yyb860 = r.CheckBreak()
	}
	if yyb860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj860++
	if yyhl860 {
		yyb860 = yyj860 > l
	} else {
		yyb860 = r.CheckBreak()
	}
	if yyb860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	for {
		yyj860++
		if yyhl860 {
			yyb860 = yyj860 > l
		} else {
			yyb860 = r.CheckBreak()
		}
		if yyb860 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj860-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym866 := z.EncBinary()
		_ = yym866
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep867 := !z.EncBinary()
			yy2arr867 := z.EncBasicHandle().StructToArray
			var yyq867 [3]bool
			_, _, _ = yysep867, yyq867, yy2arr867
			const yyr867 bool = false
			yyq867[2] = x.ReadOnly != false
			var yynn867 int
			if yyr867 || yy2arr867 {
				r.EncodeArrayStart(3)
			} else {
				yynn867 = 2
				for _, b := range yyq867 {
					if b {
						yynn867++
					}
				}
				r.EncodeMapStart(yynn867)
				yynn867 = 0
			}
			if yyr867 || yy2arr867 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym869 := z.EncBinary()
				_ = yym869
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym870 := z.EncBinary()
				_ = yym870
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr867 || yy2arr867 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym872 := z.EncBinary()
				_ = yym872
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym873 := z.EncBinary()
				_ = yym873
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr867 || yy2arr867 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq867[2] {
					yym875 := z.EncBinary()
					_ = yym875
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq867[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym876 := z.EncBinary()
					_ = yym876
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr867 || yy2arr867 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym877 := z.DecBinary()
	_ = yym877
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct878 := r.ContainerType()
		if yyct878 == codecSelferValueTypeMap1234 {
			yyl878 := r.ReadMapStart()
			if yyl878 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl878, d)
			}
		} else if yyct878 == codecSelferValueTypeArray1234 {
			yyl878 := r.ReadArrayStart()
			if yyl878 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl878, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys879Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys879Slc
	var yyhl879 bool = l >= 0
	for yyj879 := 0; ; yyj879++ {
		if yyhl879 {
			if yyj879 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys879Slc = r.DecodeBytes(yys879Slc, true, true)
		yys879 := string(yys879Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys879 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys879)
		} // end switch yys879
	} // end for yyj879
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj883 int
	var yyb883 bool
	var yyhl883 bool = l >= 0
	yyj883++
	if yyhl883 {
		yyb883 = yyj883 > l
	} else {
		yyb883 = r.CheckBreak()
	}
	if yyb883 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj883++
	if yyhl883 {
		yyb883 = yyj883 > l
	} else {
		yyb883 = r.CheckBreak()
	}
	if yyb883 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj883++
	if yyhl883 {
		yyb883 = yyj883 > l
	} else {
		yyb883 = r.CheckBreak()
	}
	if yyb883 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj883++
		if yyhl883 {
			yyb883 = yyj883 > l
		} else {
			yyb883 = r.CheckBreak()
		}
		if yyb883 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj883-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym887 := z.EncBinary()
		_ = yym887
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep888 := !z.EncBinary()
			yy2arr888 := z.EncBasicHandle().StructToArray
			var yyq888 [8]bool
			_, _, _ = yysep888, yyq888, yy2arr888
			const yyr888 bool = false
			yyq888[2] = x.FSType != ""
			yyq888[3] = x.RBDPool != ""
			yyq888[4] = x.RadosUser != ""
			yyq888[5] = x.Keyring != ""
			yyq888[6] = x.SecretRef != nil
			yyq888[7] = x.ReadOnly != false
			var yynn888 int
			if yyr888 || yy2arr888 {
				r.EncodeArrayStart(8)
			} else {
				yynn888 = 2
				for _, b := range yyq888 {
					if b {
						yynn888++
					}
				}
				r.EncodeMapStart(yynn888)
				yynn888 = 0
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym890 := z.EncBinary()
					_ = yym890
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym891 := z.EncBinary()
					_ = yym891
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym893 := z.EncBinary()
				_ = yym893
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym894 := z.EncBinary()
				_ = yym894
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[2] {
					yym896 := z.EncBinary()
					_ = yym896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq888[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym897 := z.EncBinary()
					_ = yym897
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[3] {
					yym899 := z.EncBinary()
					_ = yym899
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq888[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("pool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym900 := z.EncBinary()
					_ = yym900
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[4] {
					yym902 := z.EncBinary()
					_ = yym902
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq888[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym903 := z.EncBinary()
					_ = yym903
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[5] {
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq888[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("keyring"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym906 := z.EncBinary()
					_ = yym906
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[6] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq888[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq888[7] {
					yym909 := z.EncBinary()
					_ = yym909
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq888[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym910 := z.EncBinary()
					_ = yym910
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr888 || yy2arr888 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym911 := z.DecBinary()
	_ = yym911
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct912 := r.ContainerType()
		if yyct912 == codecSelferValueTypeMap1234 {
			yyl912 := r.ReadMapStart()
			if yyl912 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl912, d)
			}
		} else if yyct912 == codecSelferValueTypeArray1234 {
			yyl912 := r.ReadArrayStart()
			if yyl912 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl912, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys913Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys913Slc
	var yyhl913 bool = l >= 0
	for yyj913 := 0; ; yyj913++ {
		if yyhl913 {
			if yyj913 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys913Slc = r.DecodeBytes(yys913Slc, true, true)
		yys913 := string(yys913Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys913 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv914 := &x.CephMonitors
				yym915 := z.DecBinary()
				_ = yym915
				if false {
				} else {
					z.F.DecSliceStringX(yyv914, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys913)
		} // end switch yys913
	} // end for yyj913
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj923 int
	var yyb923 bool
	var yyhl923 bool = l >= 0
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv924 := &x.CephMonitors
		yym925 := z.DecBinary()
		_ = yym925
		if false {
		} else {
			z.F.DecSliceStringX(yyv924, false, d)
		}
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj923++
		if yyhl923 {
			yyb923 = yyj923 > l
		} else {
			yyb923 = r.CheckBreak()
		}
		if yyb923 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj923-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym933 := z.EncBinary()
		_ = yym933
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep934 := !z.EncBinary()
			yy2arr934 := z.EncBasicHandle().StructToArray
			var yyq934 [3]bool
			_, _, _ = yysep934, yyq934, yy2arr934
			const yyr934 bool = false
			yyq934[1] = x.FSType != ""
			yyq934[2] = x.ReadOnly != false
			var yynn934 int
			if yyr934 || yy2arr934 {
				r.EncodeArrayStart(3)
			} else {
				yynn934 = 1
				for _, b := range yyq934 {
					if b {
						yynn934++
					}
				}
				r.EncodeMapStart(yynn934)
				yynn934 = 0
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym937 := z.EncBinary()
				_ = yym937
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq934[1] {
					yym939 := z.EncBinary()
					_ = yym939
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq934[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym940 := z.EncBinary()
					_ = yym940
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq934[2] {
					yym942 := z.EncBinary()
					_ = yym942
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq934[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym943 := z.EncBinary()
					_ = yym943
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr934 || yy2arr934 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym944 := z.DecBinary()
	_ = yym944
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct945 := r.ContainerType()
		if yyct945 == codecSelferValueTypeMap1234 {
			yyl945 := r.ReadMapStart()
			if yyl945 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl945, d)
			}
		} else if yyct945 == codecSelferValueTypeArray1234 {
			yyl945 := r.ReadArrayStart()
			if yyl945 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl945, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys946Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys946Slc
	var yyhl946 bool = l >= 0
	for yyj946 := 0; ; yyj946++ {
		if yyhl946 {
			if yyj946 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys946Slc = r.DecodeBytes(yys946Slc, true, true)
		yys946 := string(yys946Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys946 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys946)
		} // end switch yys946
	} // end for yyj946
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj950 int
	var yyb950 bool
	var yyhl950 bool = l >= 0
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj950++
		if yyhl950 {
			yyb950 = yyj950 > l
		} else {
			yyb950 = r.CheckBreak()
		}
		if yyb950 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj950-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym954 := z.EncBinary()
		_ = yym954
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep955 := !z.EncBinary()
			yy2arr955 := z.EncBasicHandle().StructToArray
			var yyq955 [6]bool
			_, _, _ = yysep955, yyq955, yy2arr955
			const yyr955 bool = false
			yyq955[1] = x.Path != ""
			yyq955[2] = x.User != ""
			yyq955[3] = x.SecretFile != ""
			yyq955[4] = x.SecretRef != nil
			yyq955[5] = x.ReadOnly != false
			var yynn955 int
			if yyr955 || yy2arr955 {
				r.EncodeArrayStart(6)
			} else {
				yynn955 = 1
				for _, b := range yyq955 {
					if b {
						yynn955++
					}
				}
				r.EncodeMapStart(yynn955)
				yynn955 = 0
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym957 := z.EncBinary()
					_ = yym957
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym958 := z.EncBinary()
					_ = yym958
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[1] {
					yym960 := z.EncBinary()
					_ = yym960
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq955[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym961 := z.EncBinary()
					_ = yym961
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[2] {
					yym963 := z.EncBinary()
					_ = yym963
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq955[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym964 := z.EncBinary()
					_ = yym964
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[3] {
					yym966 := z.EncBinary()
					_ = yym966
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq955[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym967 := z.EncBinary()
					_ = yym967
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[4] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq955[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq955[5] {
					yym970 := z.EncBinary()
					_ = yym970
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq955[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym971 := z.EncBinary()
					_ = yym971
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr955 || yy2arr955 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym972 := z.DecBinary()
	_ = yym972
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct973 := r.ContainerType()
		if yyct973 == codecSelferValueTypeMap1234 {
			yyl973 := r.ReadMapStart()
			if yyl973 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl973, d)
			}
		} else if yyct973 == codecSelferValueTypeArray1234 {
			yyl973 := r.ReadArrayStart()
			if yyl973 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl973, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys974Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys974Slc
	var yyhl974 bool = l >= 0
	for yyj974 := 0; ; yyj974++ {
		if yyhl974 {
			if yyj974 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys974Slc = r.DecodeBytes(yys974Slc, true, true)
		yys974 := string(yys974Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys974 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv975 := &x.Monitors
				yym976 := z.DecBinary()
				_ = yym976
				if false {
				} else {
					z.F.DecSliceStringX(yyv975, false, d)
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys974)
		} // end switch yys974
	} // end for yyj974
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj982 int
	var yyb982 bool
	var yyhl982 bool = l >= 0
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv983 := &x.Monitors
		yym984 := z.DecBinary()
		_ = yym984
		if false {
		} else {
			z.F.DecSliceStringX(yyv983, false, d)
		}
	}
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj982++
	if yyhl982 {
		yyb982 = yyj982 > l
	} else {
		yyb982 = r.CheckBreak()
	}
	if yyb982 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj982++
		if yyhl982 {
			yyb982 = yyj982 > l
		} else {
			yyb982 = r.CheckBreak()
		}
		if yyb982 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj982-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym990 := z.EncBinary()
		_ = yym990
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep991 := !z.EncBinary()
			yy2arr991 := z.EncBasicHandle().StructToArray
			var yyq991 [1]bool
			_, _, _ = yysep991, yyq991, yy2arr991
			const yyr991 bool = false
			var yynn991 int
			if yyr991 || yy2arr991 {
				r.EncodeArrayStart(1)
			} else {
				yynn991 = 1
				for _, b := range yyq991 {
					if b {
						yynn991++
					}
				}
				r.EncodeMapStart(yynn991)
				yynn991 = 0
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym993 := z.EncBinary()
				_ = yym993
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym994 := z.EncBinary()
				_ = yym994
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
				}
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym995 := z.DecBinary()
	_ = yym995
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct996 := r.ContainerType()
		if yyct996 == codecSelferValueTypeMap1234 {
			yyl996 := r.ReadMapStart()
			if yyl996 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl996, d)
			}
		} else if yyct996 == codecSelferValueTypeArray1234 {
			yyl996 := r.ReadArrayStart()
			if yyl996 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl996, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys997Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys997Slc
	var yyhl997 bool = l >= 0
	for yyj997 := 0; ; yyj997++ {
		if yyhl997 {
			if yyj997 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys997Slc = r.DecodeBytes(yys997Slc, true, true)
		yys997 := string(yys997Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys997 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys997)
		} // end switch yys997
	} // end for yyj997
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj999 int
	var yyb999 bool
	var yyhl999 bool = l >= 0
	yyj999++
	if yyhl999 {
		yyb999 = yyj999 > l
	} else {
		yyb999 = r.CheckBreak()
	}
	if yyb999 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	for {
		yyj999++
		if yyhl999 {
			yyb999 = yyj999 > l
		} else {
			yyb999 = r.CheckBreak()
		}
		if yyb999 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj999-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1001 := z.EncBinary()
		_ = yym1001
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1002 := !z.EncBinary()
			yy2arr1002 := z.EncBasicHandle().StructToArray
			var yyq1002 [2]bool
			_, _, _ = yysep1002, yyq1002, yy2arr1002
			const yyr1002 bool = false
			yyq1002[0] = len(x.Items) != 0
			yyq1002[1] = x.DefaultMode != nil
			var yynn1002 int
			if yyr1002 || yy2arr1002 {
				r.EncodeArrayStart(2)
			} else {
				yynn1002 = 0
				for _, b := range yyq1002 {
					if b {
						yynn1002++
					}
				}
				r.EncodeMapStart(yynn1002)
				yynn1002 = 0
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1002[0] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1004 := z.EncBinary()
						_ = yym1004
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1002[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1005 := z.EncBinary()
						_ = yym1005
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				}
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1002[1] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1007 := *x.DefaultMode
						yym1008 := z.EncBinary()
						_ = yym1008
						if false {
						} else {
							r.EncodeInt(int64(yy1007))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1002[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1009 := *x.DefaultMode
						yym1010 := z.EncBinary()
						_ = yym1010
						if false {
						} else {
							r.EncodeInt(int64(yy1009))
						}
					}
				}
			}
			if yyr1002 || yy2arr1002 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1011 := z.DecBinary()
	_ = yym1011
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1012 := r.ContainerType()
		if yyct1012 == codecSelferValueTypeMap1234 {
			yyl1012 := r.ReadMapStart()
			if yyl1012 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1012, d)
			}
		} else if yyct1012 == codecSelferValueTypeArray1234 {
			yyl1012 := r.ReadArrayStart()
			if yyl1012 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1012, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1013Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1013Slc
	var yyhl1013 bool = l >= 0
	for yyj1013 := 0; ; yyj1013++ {
		if yyhl1013 {
			if yyj1013 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1013Slc = r.DecodeBytes(yys1013Slc, true, true)
		yys1013 := string(yys1013Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1013 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1014 := &x.Items
				yym1015 := z.DecBinary()
				_ = yym1015
				if false {
				} else {
					h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv1014), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1017 := z.DecBinary()
				_ = yym1017
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1013)
		} // end switch yys1013
	} // end for yyj1013
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1018 int
	var yyb1018 bool
	var yyhl1018 bool = l >= 0
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1019 := &x.Items
		yym1020 := z.DecBinary()
		_ = yym1020
		if false {
		} else {
			h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv1019), d)
		}
	}
	yyj1018++
	if yyhl1018 {
		yyb1018 = yyj1018 > l
	} else {
		yyb1018 = r.CheckBreak()
	}
	if yyb1018 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1022 := z.DecBinary()
		_ = yym1022
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1018++
		if yyhl1018 {
			yyb1018 = yyj1018 > l
		} else {
			yyb1018 = r.CheckBreak()
		}
		if yyb1018 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1018-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeFile) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1023 := z.EncBinary()
		_ = yym1023
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1024 := !z.EncBinary()
			yy2arr1024 := z.EncBasicHandle().StructToArray
			var yyq1024 [4]bool
			_, _, _ = yysep1024, yyq1024, yy2arr1024
			const yyr1024 bool = false
			yyq1024[1] = x.FieldRef != nil
			yyq1024[2] = x.ResourceFieldRef != nil
			yyq1024[3] = x.Mode != nil
			var yynn1024 int
			if yyr1024 || yy2arr1024 {
				r.EncodeArrayStart(4)
			} else {
				yynn1024 = 1
				for _, b := range yyq1024 {
					if b {
						yynn1024++
					}
				}
				r.EncodeMapStart(yynn1024)
				yynn1024 = 0
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1027 := z.EncBinary()
				_ = yym1027
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[1] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1024[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[2] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1024[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[3] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1031 := *x.Mode
						yym1032 := z.EncBinary()
						_ = yym1032
						if false {
						} else {
							r.EncodeInt(int64(yy1031))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1024[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1033 := *x.Mode
						yym1034 := z.EncBinary()
						_ = yym1034
						if false {
						} else {
							r.EncodeInt(int64(yy1033))
						}
					}
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeFile) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1035 := z.DecBinary()
	_ = yym1035
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1036 := r.ContainerType()
		if yyct1036 == codecSelferValueTypeMap1234 {
			yyl1036 := r.ReadMapStart()
			if yyl1036 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1036, d)
			}
		} else if yyct1036 == codecSelferValueTypeArray1234 {
			yyl1036 := r.ReadArrayStart()
			if yyl1036 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1036, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1037Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1037Slc
	var yyhl1037 bool = l >= 0
	for yyj1037 := 0; ; yyj1037++ {
		if yyhl1037 {
			if yyj1037 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1037Slc = r.DecodeBytes(yys1037Slc, true, true)
		yys1037 := string(yys1037Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1037 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1042 := z.DecBinary()
				_ = yym1042
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1037)
		} // end switch yys1037
	} // end for yyj1037
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1043 int
	var yyb1043 bool
	var yyhl1043 bool = l >= 0
	yyj1043++
	if yyhl1043 {
		yyb1043 = yyj1043 > l
	} else {
		yyb1043 = r.CheckBreak()
	}
	if yyb1043 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1043++
	if yyhl1043 {
		yyb1043 = yyj1043 > l
	} else {
		yyb1043 = r.CheckBreak()
	}
	if yyb1043 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1043++
	if yyhl1043 {
		yyb1043 = yyj1043 > l
	} else {
		yyb1043 = r.CheckBreak()
	}
	if yyb1043 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1043++
	if yyhl1043 {
		yyb1043 = yyj1043 > l
	} else {
		yyb1043 = r.CheckBreak()
	}
	if yyb1043 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1048 := z.DecBinary()
		_ = yym1048
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1043++
		if yyhl1043 {
			yyb1043 = yyj1043 > l
		} else {
			yyb1043 = r.CheckBreak()
		}
		if yyb1043 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1043-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AzureFileVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1049 := z.EncBinary()
		_ = yym1049
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1050 := !z.EncBinary()
			yy2arr1050 := z.EncBasicHandle().StructToArray
			var yyq1050 [3]bool
			_, _, _ = yysep1050, yyq1050, yy2arr1050
			const yyr1050 bool = false
			yyq1050[2] = x.ReadOnly != false
			var yynn1050 int
			if yyr1050 || yy2arr1050 {
				r.EncodeArrayStart(3)
			} else {
				yynn1050 = 2
				for _, b := range yyq1050 {
					if b {
						yynn1050++
					}
				}
				r.EncodeMapStart(yynn1050)
				yynn1050 = 0
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1052 := z.EncBinary()
				_ = yym1052
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1053 := z.EncBinary()
				_ = yym1053
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1055 := z.EncBinary()
				_ = yym1055
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("shareName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1056 := z.EncBinary()
				_ = yym1056
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[2] {
					yym1058 := z.EncBinary()
					_ = yym1058
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1059 := z.EncBinary()
					_ = yym1059
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureFileVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1060 := z.DecBinary()
	_ = yym1060
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1061 := r.ContainerType()
		if yyct1061 == codecSelferValueTypeMap1234 {
			yyl1061 := r.ReadMapStart()
			if yyl1061 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1061, d)
			}
		} else if yyct1061 == codecSelferValueTypeArray1234 {
			yyl1061 := r.ReadArrayStart()
			if yyl1061 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1061, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1062Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1062Slc
	var yyhl1062 bool = l >= 0
	for yyj1062 := 0; ; yyj1062++ {
		if yyhl1062 {
			if yyj1062 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1062Slc = r.DecodeBytes(yys1062Slc, true, true)
		yys1062 := string(yys1062Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1062 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "shareName":
			if r.TryDecodeAsNil() {
				x.ShareName = ""
			} else {
				x.ShareName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1062)
		} // end switch yys1062
	} // end for yyj1062
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1066 int
	var yyb1066 bool
	var yyhl1066 bool = l >= 0
	yyj1066++
	if yyhl1066 {
		yyb1066 = yyj1066 > l
	} else {
		yyb1066 = r.CheckBreak()
	}
	if yyb1066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj1066++
	if yyhl1066 {
		yyb1066 = yyj1066 > l
	} else {
		yyb1066 = r.CheckBreak()
	}
	if yyb1066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ShareName = ""
	} else {
		x.ShareName = string(r.DecodeString())
	}
	yyj1066++
	if yyhl1066 {
		yyb1066 = yyj1066 > l
	} else {
		yyb1066 = r.CheckBreak()
	}
	if yyb1066 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj1066++
		if yyhl1066 {
			yyb1066 = yyj1066 > l
		} else {
			yyb1066 = r.CheckBreak()
		}
		if yyb1066 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1066-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1070 := z.EncBinary()
		_ = yym1070
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1071 := !z.EncBinary()
			yy2arr1071 := z.EncBasicHandle().StructToArray
			var yyq1071 [2]bool
			_, _, _ = yysep1071, yyq1071, yy2arr1071
			const yyr1071 bool = false
			yyq1071[1] = x.FSType != ""
			var yynn1071 int
			if yyr1071 || yy2arr1071 {
				r.EncodeArrayStart(2)
			} else {
				yynn1071 = 1
				for _, b := range yyq1071 {
					if b {
						yynn1071++
					}
				}
				r.EncodeMapStart(yynn1071)
				yynn1071 = 0
			}
			if yyr1071 || yy2arr1071 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1073 := z.EncBinary()
				_ = yym1073
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1074 := z.EncBinary()
				_ = yym1074
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			}
			if yyr1071 || yy2arr1071 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1071[1] {
					yym1076 := z.EncBinary()
					_ = yym1076
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1071[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1077 := z.EncBinary()
					_ = yym1077
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1071 || yy2arr1071 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1078 := z.DecBinary()
	_ = yym1078
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1079 := r.ContainerType()
		if yyct1079 == codecSelferValueTypeMap1234 {
			yyl1079 := r.ReadMapStart()
			if yyl1079 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1079, d)
			}
		} else if yyct1079 == codecSelferValueTypeArray1234 {
			yyl1079 := r.ReadArrayStart()
			if yyl1079 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1079, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1080Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1080Slc
	var yyhl1080 bool = l >= 0
	for yyj1080 := 0; ; yyj1080++ {
		if yyhl1080 {
			if yyj1080 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1080Slc = r.DecodeBytes(yys1080Slc, true, true)
		yys1080 := string(yys1080Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1080 {
		case "volumePath":
			if r.TryDecodeAsNil() {
				x.VolumePath = ""
			} else {
				x.VolumePath = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1080)
		} // end switch yys1080
	} // end for yyj1080
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1083 int
	var yyb1083 bool
	var yyhl1083 bool = l >= 0
	yyj1083++
	if yyhl1083 {
		yyb1083 = yyj1083 > l
	} else {
		yyb1083 = r.CheckBreak()
	}
	if yyb1083 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePath = ""
	} else {
		x.VolumePath = string(r.DecodeString())
	}
	yyj1083++
	if yyhl1083 {
		yyb1083 = yyj1083 > l
	} else {
		yyb1083 = r.CheckBreak()
	}
	if yyb1083 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1083++
		if yyhl1083 {
			yyb1083 = yyj1083 > l
		} else {
			yyb1083 = r.CheckBreak()
		}
		if yyb1083 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1083-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x AzureDataDiskCachingMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1086 := z.EncBinary()
	_ = yym1086
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *AzureDataDiskCachingMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1087 := z.DecBinary()
	_ = yym1087
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AzureDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1088 := z.EncBinary()
		_ = yym1088
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1089 := !z.EncBinary()
			yy2arr1089 := z.EncBasicHandle().StructToArray
			var yyq1089 [5]bool
			_, _, _ = yysep1089, yyq1089, yy2arr1089
			const yyr1089 bool = false
			yyq1089[2] = x.CachingMode != nil
			yyq1089[3] = x.FSType != nil
			yyq1089[4] = x.ReadOnly != nil
			var yynn1089 int
			if yyr1089 || yy2arr1089 {
				r.EncodeArrayStart(5)
			} else {
				yynn1089 = 2
				for _, b := range yyq1089 {
					if b {
						yynn1089++
					}
				}
				r.EncodeMapStart(yynn1089)
				yynn1089 = 0
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1091 := z.EncBinary()
				_ = yym1091
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1092 := z.EncBinary()
				_ = yym1092
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1094 := z.EncBinary()
				_ = yym1094
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskURI"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1095 := z.EncBinary()
				_ = yym1095
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1089[2] {
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1097 := *x.CachingMode
						yy1097.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1089[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cachingMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1098 := *x.CachingMode
						yy1098.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1089[3] {
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1100 := *x.FSType
						yym1101 := z.EncBinary()
						_ = yym1101
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1100))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1089[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1102 := *x.FSType
						yym1103 := z.EncBinary()
						_ = yym1103
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1102))
						}
					}
				}
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1089[4] {
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1105 := *x.ReadOnly
						yym1106 := z.EncBinary()
						_ = yym1106
						if false {
						} else {
							r.EncodeBool(bool(yy1105))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1089[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1107 := *x.ReadOnly
						yym1108 := z.EncBinary()
						_ = yym1108
						if false {
						} else {
							r.EncodeBool(bool(yy1107))
						}
					}
				}
			}
			if yyr1089 || yy2arr1089 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1109 := z.DecBinary()
	_ = yym1109
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1110 := r.ContainerType()
		if yyct1110 == codecSelferValueTypeMap1234 {
			yyl1110 := r.ReadMapStart()
			if yyl1110 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1110, d)
			}
		} else if yyct1110 == codecSelferValueTypeArray1234 {
			yyl1110 := r.ReadArrayStart()
			if yyl1110 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1110, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1111Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1111Slc
	var yyhl1111 bool = l >= 0
	for yyj1111 := 0; ; yyj1111++ {
		if yyhl1111 {
			if yyj1111 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1111Slc = r.DecodeBytes(yys1111Slc, true, true)
		yys1111 := string(yys1111Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1111 {
		case "diskName":
			if r.TryDecodeAsNil() {
				x.DiskName = ""
			} else {
				x.DiskName = string(r.DecodeString())
			}
		case "diskURI":
			if r.TryDecodeAsNil() {
				x.DataDiskURI = ""
			} else {
				x.DataDiskURI = string(r.DecodeString())
			}
		case "cachingMode":
			if r.TryDecodeAsNil() {
				if x.CachingMode != nil {
					x.CachingMode = nil
				}
			} else {
				if x.CachingMode == nil {
					x.CachingMode = new(AzureDataDiskCachingMode)
				}
				x.CachingMode.CodecDecodeSelf(d)
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				if x.FSType != nil {
					x.FSType = nil
				}
			} else {
				if x.FSType == nil {
					x.FSType = new(string)
				}
				yym1116 := z.DecBinary()
				_ = yym1116
				if false {
				} else {
					*((*string)(x.FSType)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				if x.ReadOnly != nil {
					x.ReadOnly = nil
				}
			} else {
				if x.ReadOnly == nil {
					x.ReadOnly = new(bool)
				}
				yym1118 := z.DecBinary()
				_ = yym1118
				if false {
				} else {
					*((*bool)(x.ReadOnly)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1111)
		} // end switch yys1111
	} // end for yyj1111
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1119 int
	var yyb1119 bool
	var yyhl1119 bool = l >= 0
	yyj1119++
	if yyhl1119 {
		yyb1119 = yyj1119 > l
	} else {
		yyb1119 = r.CheckBreak()
	}
	if yyb1119 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DiskName = ""
	} else {
		x.DiskName = string(r.DecodeString())
	}
	yyj1119++
	if yyhl1119 {
		yyb1119 = yyj1119 > l
	} else {
		yyb1119 = r.CheckBreak()
	}
	if yyb1119 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DataDiskURI = ""
	} else {
		x.DataDiskURI = string(r.DecodeString())
	}
	yyj1119++
	if yyhl1119 {
		yyb1119 = yyj1119 > l
	} else {
		yyb1119 = r.CheckBreak()
	}
	if yyb1119 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CachingMode != nil {
			x.CachingMode = nil
		}
	} else {
		if x.CachingMode == nil {
			x.CachingMode = new(AzureDataDiskCachingMode)
		}
		x.CachingMode.CodecDecodeSelf(d)
	}
	yyj1119++
	if yyhl1119 {
		yyb1119 = yyj1119 > l
	} else {
		yyb1119 = r.CheckBreak()
	}
	if yyb1119 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSType != nil {
			x.FSType = nil
		}
	} else {
		if x.FSType == nil {
			x.FSType = new(string)
		}
		yym1124 := z.DecBinary()
		_ = yym1124
		if false {
		} else {
			*((*string)(x.FSType)) = r.DecodeString()
		}
	}
	yyj1119++
	if yyhl1119 {
		yyb1119 = yyj1119 > l
	} else {
		yyb1119 = r.CheckBreak()
	}
	if yyb1119 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadOnly != nil {
			x.ReadOnly = nil
		}
	} else {
		if x.ReadOnly == nil {
			x.ReadOnly = new(bool)
		}
		yym1126 := z.DecBinary()
		_ = yym1126
		if false {
		} else {
			*((*bool)(x.ReadOnly)) = r.DecodeBool()
		}
	}
	for {
		yyj1119++
		if yyhl1119 {
			yyb1119 = yyj1119 > l
		} else {
			yyb1119 = r.CheckBreak()
		}
		if yyb1119 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1119-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1127 := z.EncBinary()
		_ = yym1127
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1128 := !z.EncBinary()
			yy2arr1128 := z.EncBasicHandle().StructToArray
			var yyq1128 [3]bool
			_, _, _ = yysep1128, yyq1128, yy2arr1128
			const yyr1128 bool = false
			yyq1128[1] = len(x.Items) != 0
			yyq1128[2] = x.DefaultMode != nil
			var yynn1128 int
			if yyr1128 || yy2arr1128 {
				r.EncodeArrayStart(3)
			} else {
				yynn1128 = 1
				for _, b := range yyq1128 {
					if b {
						yynn1128++
					}
				}
				r.EncodeMapStart(yynn1128)
				yynn1128 = 0
			}
			if yyr1128 || yy2arr1128 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1130 := z.EncBinary()
				_ = yym1130
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1131 := z.EncBinary()
				_ = yym1131
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1128 || yy2arr1128 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1128[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1133 := z.EncBinary()
						_ = yym1133
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1128[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1134 := z.EncBinary()
						_ = yym1134
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr1128 || yy2arr1128 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1128[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1136 := *x.DefaultMode
						yym1137 := z.EncBinary()
						_ = yym1137
						if false {
						} else {
							r.EncodeInt(int64(yy1136))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1128[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1138 := *x.DefaultMode
						yym1139 := z.EncBinary()
						_ = yym1139
						if false {
						} else {
							r.EncodeInt(int64(yy1138))
						}
					}
				}
			}
			if yyr1128 || yy2arr1128 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1140 := z.DecBinary()
	_ = yym1140
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1141 := r.ContainerType()
		if yyct1141 == codecSelferValueTypeMap1234 {
			yyl1141 := r.ReadMapStart()
			if yyl1141 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1141, d)
			}
		} else if yyct1141 == codecSelferValueTypeArray1234 {
			yyl1141 := r.ReadArrayStart()
			if yyl1141 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1141, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1142Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1142Slc
	var yyhl1142 bool = l >= 0
	for yyj1142 := 0; ; yyj1142++ {
		if yyhl1142 {
			if yyj1142 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1142Slc = r.DecodeBytes(yys1142Slc, true, true)
		yys1142 := string(yys1142Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1142 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1144 := &x.Items
				yym1145 := z.DecBinary()
				_ = yym1145
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv1144), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1147 := z.DecBinary()
				_ = yym1147
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1142)
		} // end switch yys1142
	} // end for yyj1142
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1148 int
	var yyb1148 bool
	var yyhl1148 bool = l >= 0
	yyj1148++
	if yyhl1148 {
		yyb1148 = yyj1148 > l
	} else {
		yyb1148 = r.CheckBreak()
	}
	if yyb1148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1148++
	if yyhl1148 {
		yyb1148 = yyj1148 > l
	} else {
		yyb1148 = r.CheckBreak()
	}
	if yyb1148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1150 := &x.Items
		yym1151 := z.DecBinary()
		_ = yym1151
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv1150), d)
		}
	}
	yyj1148++
	if yyhl1148 {
		yyb1148 = yyj1148 > l
	} else {
		yyb1148 = r.CheckBreak()
	}
	if yyb1148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1153 := z.DecBinary()
		_ = yym1153
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1148++
		if yyhl1148 {
			yyb1148 = yyj1148 > l
		} else {
			yyb1148 = r.CheckBreak()
		}
		if yyb1148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KeyToPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1154 := z.EncBinary()
		_ = yym1154
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1155 := !z.EncBinary()
			yy2arr1155 := z.EncBasicHandle().StructToArray
			var yyq1155 [3]bool
			_, _, _ = yysep1155, yyq1155, yy2arr1155
			const yyr1155 bool = false
			yyq1155[2] = x.Mode != nil
			var yynn1155 int
			if yyr1155 || yy2arr1155 {
				r.EncodeArrayStart(3)
			} else {
				yynn1155 = 2
				for _, b := range yyq1155 {
					if b {
						yynn1155++
					}
				}
				r.EncodeMapStart(yynn1155)
				yynn1155 = 0
			}
			if yyr1155 || yy2arr1155 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1157 := z.EncBinary()
				_ = yym1157
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1158 := z.EncBinary()
				_ = yym1158
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1155 || yy2arr1155 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1160 := z.EncBinary()
				_ = yym1160
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1161 := z.EncBinary()
				_ = yym1161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1155 || yy2arr1155 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1155[2] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1163 := *x.Mode
						yym1164 := z.EncBinary()
						_ = yym1164
						if false {
						} else {
							r.EncodeInt(int64(yy1163))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1155[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1165 := *x.Mode
						yym1166 := z.EncBinary()
						_ = yym1166
						if false {
						} else {
							r.EncodeInt(int64(yy1165))
						}
					}
				}
			}
			if yyr1155 || yy2arr1155 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KeyToPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1167 := z.DecBinary()
	_ = yym1167
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1168 := r.ContainerType()
		if yyct1168 == codecSelferValueTypeMap1234 {
			yyl1168 := r.ReadMapStart()
			if yyl1168 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1168, d)
			}
		} else if yyct1168 == codecSelferValueTypeArray1234 {
			yyl1168 := r.ReadArrayStart()
			if yyl1168 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1168, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KeyToPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1169Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1169Slc
	var yyhl1169 bool = l >= 0
	for yyj1169 := 0; ; yyj1169++ {
		if yyhl1169 {
			if yyj1169 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1169Slc = r.DecodeBytes(yys1169Slc, true, true)
		yys1169 := string(yys1169Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1169 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1173 := z.DecBinary()
				_ = yym1173
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1169)
		} // end switch yys1169
	} // end for yyj1169
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KeyToPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1174 int
	var yyb1174 bool
	var yyhl1174 bool = l >= 0
	yyj1174++
	if yyhl1174 {
		yyb1174 = yyj1174 > l
	} else {
		yyb1174 = r.CheckBreak()
	}
	if yyb1174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1174++
	if yyhl1174 {
		yyb1174 = yyj1174 > l
	} else {
		yyb1174 = r.CheckBreak()
	}
	if yyb1174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1174++
	if yyhl1174 {
		yyb1174 = yyj1174 > l
	} else {
		yyb1174 = r.CheckBreak()
	}
	if yyb1174 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1178 := z.DecBinary()
		_ = yym1178
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1174++
		if yyhl1174 {
			yyb1174 = yyj1174 > l
		} else {
			yyb1174 = r.CheckBreak()
		}
		if yyb1174 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1174-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1179 := z.EncBinary()
		_ = yym1179
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1180 := !z.EncBinary()
			yy2arr1180 := z.EncBasicHandle().StructToArray
			var yyq1180 [5]bool
			_, _, _ = yysep1180, yyq1180, yy2arr1180
			const yyr1180 bool = false
			yyq1180[0] = x.Name != ""
			yyq1180[1] = x.HostPort != 0
			yyq1180[3] = x.Protocol != ""
			yyq1180[4] = x.HostIP != ""
			var yynn1180 int
			if yyr1180 || yy2arr1180 {
				r.EncodeArrayStart(5)
			} else {
				yynn1180 = 1
				for _, b := range yyq1180 {
					if b {
						yynn1180++
					}
				}
				r.EncodeMapStart(yynn1180)
				yynn1180 = 0
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1180[0] {
					yym1182 := z.EncBinary()
					_ = yym1182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1180[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1183 := z.EncBinary()
					_ = yym1183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1180[1] {
					yym1185 := z.EncBinary()
					_ = yym1185
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1180[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1186 := z.EncBinary()
					_ = yym1186
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1188 := z.EncBinary()
				_ = yym1188
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1189 := z.EncBinary()
				_ = yym1189
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1180[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1180[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1180[4] {
					yym1192 := z.EncBinary()
					_ = yym1192
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1180[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1193 := z.EncBinary()
					_ = yym1193
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1180 || yy2arr1180 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1194 := z.DecBinary()
	_ = yym1194
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1195 := r.ContainerType()
		if yyct1195 == codecSelferValueTypeMap1234 {
			yyl1195 := r.ReadMapStart()
			if yyl1195 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1195, d)
			}
		} else if yyct1195 == codecSelferValueTypeArray1234 {
			yyl1195 := r.ReadArrayStart()
			if yyl1195 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1195, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1196Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1196Slc
	var yyhl1196 bool = l >= 0
	for yyj1196 := 0; ; yyj1196++ {
		if yyhl1196 {
			if yyj1196 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1196Slc = r.DecodeBytes(yys1196Slc, true, true)
		yys1196 := string(yys1196Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1196 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int32(r.DecodeInt(32))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1196)
		} // end switch yys1196
	} // end for yyj1196
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1202 int
	var yyb1202 bool
	var yyhl1202 bool = l >= 0
	yyj1202++
	if yyhl1202 {
		yyb1202 = yyj1202 > l
	} else {
		yyb1202 = r.CheckBreak()
	}
	if yyb1202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1202++
	if yyhl1202 {
		yyb1202 = yyj1202 > l
	} else {
		yyb1202 = r.CheckBreak()
	}
	if yyb1202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int32(r.DecodeInt(32))
	}
	yyj1202++
	if yyhl1202 {
		yyb1202 = yyj1202 > l
	} else {
		yyb1202 = r.CheckBreak()
	}
	if yyb1202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int32(r.DecodeInt(32))
	}
	yyj1202++
	if yyhl1202 {
		yyb1202 = yyj1202 > l
	} else {
		yyb1202 = r.CheckBreak()
	}
	if yyb1202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj1202++
	if yyhl1202 {
		yyb1202 = yyj1202 > l
	} else {
		yyb1202 = r.CheckBreak()
	}
	if yyb1202 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj1202++
		if yyhl1202 {
			yyb1202 = yyj1202 > l
		} else {
			yyb1202 = r.CheckBreak()
		}
		if yyb1202 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1202-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1208 := z.EncBinary()
		_ = yym1208
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1209 := !z.EncBinary()
			yy2arr1209 := z.EncBasicHandle().StructToArray
			var yyq1209 [4]bool
			_, _, _ = yysep1209, yyq1209, yy2arr1209
			const yyr1209 bool = false
			yyq1209[1] = x.ReadOnly != false
			yyq1209[3] = x.SubPath != ""
			var yynn1209 int
			if yyr1209 || yy2arr1209 {
				r.EncodeArrayStart(4)
			} else {
				yynn1209 = 2
				for _, b := range yyq1209 {
					if b {
						yynn1209++
					}
				}
				r.EncodeMapStart(yynn1209)
				yynn1209 = 0
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1211 := z.EncBinary()
				_ = yym1211
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1212 := z.EncBinary()
				_ = yym1212
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1209[1] {
					yym1214 := z.EncBinary()
					_ = yym1214
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1209[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1215 := z.EncBinary()
					_ = yym1215
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1217 := z.EncBinary()
				_ = yym1217
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1218 := z.EncBinary()
				_ = yym1218
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1209[3] {
					yym1220 := z.EncBinary()
					_ = yym1220
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1209[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1221 := z.EncBinary()
					_ = yym1221
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				}
			}
			if yyr1209 || yy2arr1209 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1222 := z.DecBinary()
	_ = yym1222
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1223 := r.ContainerType()
		if yyct1223 == codecSelferValueTypeMap1234 {
			yyl1223 := r.ReadMapStart()
			if yyl1223 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1223, d)
			}
		} else if yyct1223 == codecSelferValueTypeArray1234 {
			yyl1223 := r.ReadArrayStart()
			if yyl1223 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1223, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1224Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1224Slc
	var yyhl1224 bool = l >= 0
	for yyj1224 := 0; ; yyj1224++ {
		if yyhl1224 {
			if yyj1224 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1224Slc = r.DecodeBytes(yys1224Slc, true, true)
		yys1224 := string(yys1224Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1224 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		case "subPath":
			if r.TryDecodeAsNil() {
				x.SubPath = ""
			} else {
				x.SubPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1224)
		} // end switch yys1224
	} // end for yyj1224
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1229 int
	var yyb1229 bool
	var yyhl1229 bool = l >= 0
	yyj1229++
	if yyhl1229 {
		yyb1229 = yyj1229 > l
	} else {
		yyb1229 = r.CheckBreak()
	}
	if yyb1229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1229++
	if yyhl1229 {
		yyb1229 = yyj1229 > l
	} else {
		yyb1229 = r.CheckBreak()
	}
	if yyb1229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj1229++
	if yyhl1229 {
		yyb1229 = yyj1229 > l
	} else {
		yyb1229 = r.CheckBreak()
	}
	if yyb1229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	yyj1229++
	if yyhl1229 {
		yyb1229 = yyj1229 > l
	} else {
		yyb1229 = r.CheckBreak()
	}
	if yyb1229 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SubPath = ""
	} else {
		x.SubPath = string(r.DecodeString())
	}
	for {
		yyj1229++
		if yyhl1229 {
			yyb1229 = yyj1229 > l
		} else {
			yyb1229 = r.CheckBreak()
		}
		if yyb1229 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1229-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1234 := z.EncBinary()
		_ = yym1234
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1235 := !z.EncBinary()
			yy2arr1235 := z.EncBasicHandle().StructToArray
			var yyq1235 [3]bool
			_, _, _ = yysep1235, yyq1235, yy2arr1235
			const yyr1235 bool = false
			yyq1235[1] = x.Value != ""
			yyq1235[2] = x.ValueFrom != nil
			var yynn1235 int
			if yyr1235 || yy2arr1235 {
				r.EncodeArrayStart(3)
			} else {
				yynn1235 = 1
				for _, b := range yyq1235 {
					if b {
						yynn1235++
					}
				}
				r.EncodeMapStart(yynn1235)
				yynn1235 = 0
			}
			if yyr1235 || yy2arr1235 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1237 := z.EncBinary()
				_ = yym1237
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1238 := z.EncBinary()
				_ = yym1238
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1235 || yy2arr1235 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1235[1] {
					yym1240 := z.EncBinary()
					_ = yym1240
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1235[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1241 := z.EncBinary()
					_ = yym1241
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1235 || yy2arr1235 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1235[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1235[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1235 || yy2arr1235 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1243 := z.DecBinary()
	_ = yym1243
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1244 := r.ContainerType()
		if yyct1244 == codecSelferValueTypeMap1234 {
			yyl1244 := r.ReadMapStart()
			if yyl1244 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1244, d)
			}
		} else if yyct1244 == codecSelferValueTypeArray1234 {
			yyl1244 := r.ReadArrayStart()
			if yyl1244 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1244, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1245Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1245Slc
	var yyhl1245 bool = l >= 0
	for yyj1245 := 0; ; yyj1245++ {
		if yyhl1245 {
			if yyj1245 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1245Slc = r.DecodeBytes(yys1245Slc, true, true)
		yys1245 := string(yys1245Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1245 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1245)
		} // end switch yys1245
	} // end for yyj1245
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1249 int
	var yyb1249 bool
	var yyhl1249 bool = l >= 0
	yyj1249++
	if yyhl1249 {
		yyb1249 = yyj1249 > l
	} else {
		yyb1249 = r.CheckBreak()
	}
	if yyb1249 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1249++
	if yyhl1249 {
		yyb1249 = yyj1249 > l
	} else {
		yyb1249 = r.CheckBreak()
	}
	if yyb1249 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1249++
	if yyhl1249 {
		yyb1249 = yyj1249 > l
	} else {
		yyb1249 = r.CheckBreak()
	}
	if yyb1249 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj1249++
		if yyhl1249 {
			yyb1249 = yyj1249 > l
		} else {
			yyb1249 = r.CheckBreak()
		}
		if yyb1249 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1249-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1253 := z.EncBinary()
		_ = yym1253
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1254 := !z.EncBinary()
			yy2arr1254 := z.EncBasicHandle().StructToArray
			var yyq1254 [4]bool
			_, _, _ = yysep1254, yyq1254, yy2arr1254
			const yyr1254 bool = false
			yyq1254[0] = x.FieldRef != nil
			yyq1254[1] = x.ResourceFieldRef != nil
			yyq1254[2] = x.ConfigMapKeyRef != nil
			yyq1254[3] = x.SecretKeyRef != nil
			var yynn1254 int
			if yyr1254 || yy2arr1254 {
				r.EncodeArrayStart(4)
			} else {
				yynn1254 = 0
				for _, b := range yyq1254 {
					if b {
						yynn1254++
					}
				}
				r.EncodeMapStart(yynn1254)
				yynn1254 = 0
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[0] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[1] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[2] {
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1254[3] {
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1254[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1254 || yy2arr1254 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1259 := z.DecBinary()
	_ = yym1259
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1260 := r.ContainerType()
		if yyct1260 == codecSelferValueTypeMap1234 {
			yyl1260 := r.ReadMapStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1260, d)
			}
		} else if yyct1260 == codecSelferValueTypeArray1234 {
			yyl1260 := r.ReadArrayStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1260, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1261Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1261Slc
	var yyhl1261 bool = l >= 0
	for yyj1261 := 0; ; yyj1261++ {
		if yyhl1261 {
			if yyj1261 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1261Slc = r.DecodeBytes(yys1261Slc, true, true)
		yys1261 := string(yys1261Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1261 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "configMapKeyRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapKeyRef != nil {
					x.ConfigMapKeyRef = nil
				}
			} else {
				if x.ConfigMapKeyRef == nil {
					x.ConfigMapKeyRef = new(ConfigMapKeySelector)
				}
				x.ConfigMapKeyRef.CodecDecodeSelf(d)
			}
		case "secretKeyRef":
			if r.TryDecodeAsNil() {
				if x.SecretKeyRef != nil {
					x.SecretKeyRef = nil
				}
			} else {
				if x.SecretKeyRef == nil {
					x.SecretKeyRef = new(SecretKeySelector)
				}
				x.SecretKeyRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1261)
		} // end switch yys1261
	} // end for yyj1261
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1266 int
	var yyb1266 bool
	var yyhl1266 bool = l >= 0
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapKeyRef != nil {
			x.ConfigMapKeyRef = nil
		}
	} else {
		if x.ConfigMapKeyRef == nil {
			x.ConfigMapKeyRef = new(ConfigMapKeySelector)
		}
		x.ConfigMapKeyRef.CodecDecodeSelf(d)
	}
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretKeyRef != nil {
			x.SecretKeyRef = nil
		}
	} else {
		if x.SecretKeyRef == nil {
			x.SecretKeyRef = new(SecretKeySelector)
		}
		x.SecretKeyRef.CodecDecodeSelf(d)
	}
	for {
		yyj1266++
		if yyhl1266 {
			yyb1266 = yyj1266 > l
		} else {
			yyb1266 = r.CheckBreak()
		}
		if yyb1266 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1266-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1271 := z.EncBinary()
		_ = yym1271
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1272 := !z.EncBinary()
			yy2arr1272 := z.EncBasicHandle().StructToArray
			var yyq1272 [2]bool
			_, _, _ = yysep1272, yyq1272, yy2arr1272
			const yyr1272 bool = false
			var yynn1272 int
			if yyr1272 || yy2arr1272 {
				r.EncodeArrayStart(2)
			} else {
				yynn1272 = 2
				for _, b := range yyq1272 {
					if b {
						yynn1272++
					}
				}
				r.EncodeMapStart(yynn1272)
				yynn1272 = 0
			}
			if yyr1272 || yy2arr1272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1274 := z.EncBinary()
				_ = yym1274
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1275 := z.EncBinary()
				_ = yym1275
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			}
			if yyr1272 || yy2arr1272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1277 := z.EncBinary()
				_ = yym1277
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1278 := z.EncBinary()
				_ = yym1278
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr1272 || yy2arr1272 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1279 := z.DecBinary()
	_ = yym1279
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1280 := r.ContainerType()
		if yyct1280 == codecSelferValueTypeMap1234 {
			yyl1280 := r.ReadMapStart()
			if yyl1280 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1280, d)
			}
		} else if yyct1280 == codecSelferValueTypeArray1234 {
			yyl1280 := r.ReadArrayStart()
			if yyl1280 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1280, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1281Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1281Slc
	var yyhl1281 bool = l >= 0
	for yyj1281 := 0; ; yyj1281++ {
		if yyhl1281 {
			if yyj1281 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1281Slc = r.DecodeBytes(yys1281Slc, true, true)
		yys1281 := string(yys1281Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1281 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1281)
		} // end switch yys1281
	} // end for yyj1281
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1284 int
	var yyb1284 bool
	var yyhl1284 bool = l >= 0
	yyj1284++
	if yyhl1284 {
		yyb1284 = yyj1284 > l
	} else {
		yyb1284 = r.CheckBreak()
	}
	if yyb1284 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1284++
	if yyhl1284 {
		yyb1284 = yyj1284 > l
	} else {
		yyb1284 = r.CheckBreak()
	}
	if yyb1284 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj1284++
		if yyhl1284 {
			yyb1284 = yyj1284 > l
		} else {
			yyb1284 = r.CheckBreak()
		}
		if yyb1284 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1284-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1287 := z.EncBinary()
		_ = yym1287
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1288 := !z.EncBinary()
			yy2arr1288 := z.EncBasicHandle().StructToArray
			var yyq1288 [3]bool
			_, _, _ = yysep1288, yyq1288, yy2arr1288
			const yyr1288 bool = false
			yyq1288[0] = x.ContainerName != ""
			yyq1288[2] = true
			var yynn1288 int
			if yyr1288 || yy2arr1288 {
				r.EncodeArrayStart(3)
			} else {
				yynn1288 = 1
				for _, b := range yyq1288 {
					if b {
						yynn1288++
					}
				}
				r.EncodeMapStart(yynn1288)
				yynn1288 = 0
			}
			if yyr1288 || yy2arr1288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1288[0] {
					yym1290 := z.EncBinary()
					_ = yym1290
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1288[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1291 := z.EncBinary()
					_ = yym1291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				}
			}
			if yyr1288 || yy2arr1288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1293 := z.EncBinary()
				_ = yym1293
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1294 := z.EncBinary()
				_ = yym1294
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr1288 || yy2arr1288 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1288[2] {
					yy1296 := &x.Divisor
					yym1297 := z.EncBinary()
					_ = yym1297
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1296) {
					} else if !yym1297 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1296)
					} else {
						z.EncFallback(yy1296)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1288[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("divisor"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1298 := &x.Divisor
					yym1299 := z.EncBinary()
					_ = yym1299
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1298) {
					} else if !yym1299 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1298)
					} else {
						z.EncFallback(yy1298)
					}
				}
			}
			if yyr1288 || yy2arr1288 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1300 := z.DecBinary()
	_ = yym1300
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1301 := r.ContainerType()
		if yyct1301 == codecSelferValueTypeMap1234 {
			yyl1301 := r.ReadMapStart()
			if yyl1301 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1301, d)
			}
		} else if yyct1301 == codecSelferValueTypeArray1234 {
			yyl1301 := r.ReadArrayStart()
			if yyl1301 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1301, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1302Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1302Slc
	var yyhl1302 bool = l >= 0
	for yyj1302 := 0; ; yyj1302++ {
		if yyhl1302 {
			if yyj1302 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1302Slc = r.DecodeBytes(yys1302Slc, true, true)
		yys1302 := string(yys1302Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1302 {
		case "containerName":
			if r.TryDecodeAsNil() {
				x.ContainerName = ""
			} else {
				x.ContainerName = string(r.DecodeString())
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "divisor":
			if r.TryDecodeAsNil() {
				x.Divisor = pkg3_resource.Quantity{}
			} else {
				yyv1305 := &x.Divisor
				yym1306 := z.DecBinary()
				_ = yym1306
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1305) {
				} else if !yym1306 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1305)
				} else {
					z.DecFallback(yyv1305, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1302)
		} // end switch yys1302
	} // end for yyj1302
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1307 int
	var yyb1307 bool
	var yyhl1307 bool = l >= 0
	yyj1307++
	if yyhl1307 {
		yyb1307 = yyj1307 > l
	} else {
		yyb1307 = r.CheckBreak()
	}
	if yyb1307 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerName = ""
	} else {
		x.ContainerName = string(r.DecodeString())
	}
	yyj1307++
	if yyhl1307 {
		yyb1307 = yyj1307 > l
	} else {
		yyb1307 = r.CheckBreak()
	}
	if yyb1307 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj1307++
	if yyhl1307 {
		yyb1307 = yyj1307 > l
	} else {
		yyb1307 = r.CheckBreak()
	}
	if yyb1307 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Divisor = pkg3_resource.Quantity{}
	} else {
		yyv1310 := &x.Divisor
		yym1311 := z.DecBinary()
		_ = yym1311
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1310) {
		} else if !yym1311 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1310)
		} else {
			z.DecFallback(yyv1310, false)
		}
	}
	for {
		yyj1307++
		if yyhl1307 {
			yyb1307 = yyj1307 > l
		} else {
			yyb1307 = r.CheckBreak()
		}
		if yyb1307 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1307-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1312 := z.EncBinary()
		_ = yym1312
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1313 := !z.EncBinary()
			yy2arr1313 := z.EncBasicHandle().StructToArray
			var yyq1313 [2]bool
			_, _, _ = yysep1313, yyq1313, yy2arr1313
			const yyr1313 bool = false
			var yynn1313 int
			if yyr1313 || yy2arr1313 {
				r.EncodeArrayStart(2)
			} else {
				yynn1313 = 2
				for _, b := range yyq1313 {
					if b {
						yynn1313++
					}
				}
				r.EncodeMapStart(yynn1313)
				yynn1313 = 0
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1315 := z.EncBinary()
				_ = yym1315
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1316 := z.EncBinary()
				_ = yym1316
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1318 := z.EncBinary()
				_ = yym1318
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1319 := z.EncBinary()
				_ = yym1319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1313 || yy2arr1313 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1320 := z.DecBinary()
	_ = yym1320
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1321 := r.ContainerType()
		if yyct1321 == codecSelferValueTypeMap1234 {
			yyl1321 := r.ReadMapStart()
			if yyl1321 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1321, d)
			}
		} else if yyct1321 == codecSelferValueTypeArray1234 {
			yyl1321 := r.ReadArrayStart()
			if yyl1321 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1321, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1322Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1322Slc
	var yyhl1322 bool = l >= 0
	for yyj1322 := 0; ; yyj1322++ {
		if yyhl1322 {
			if yyj1322 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1322Slc = r.DecodeBytes(yys1322Slc, true, true)
		yys1322 := string(yys1322Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1322 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1322)
		} // end switch yys1322
	} // end for yyj1322
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1325 int
	var yyb1325 bool
	var yyhl1325 bool = l >= 0
	yyj1325++
	if yyhl1325 {
		yyb1325 = yyj1325 > l
	} else {
		yyb1325 = r.CheckBreak()
	}
	if yyb1325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1325++
	if yyhl1325 {
		yyb1325 = yyj1325 > l
	} else {
		yyb1325 = r.CheckBreak()
	}
	if yyb1325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1325++
		if yyhl1325 {
			yyb1325 = yyj1325 > l
		} else {
			yyb1325 = r.CheckBreak()
		}
		if yyb1325 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1325-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1328 := z.EncBinary()
		_ = yym1328
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1329 := !z.EncBinary()
			yy2arr1329 := z.EncBasicHandle().StructToArray
			var yyq1329 [2]bool
			_, _, _ = yysep1329, yyq1329, yy2arr1329
			const yyr1329 bool = false
			var yynn1329 int
			if yyr1329 || yy2arr1329 {
				r.EncodeArrayStart(2)
			} else {
				yynn1329 = 2
				for _, b := range yyq1329 {
					if b {
						yynn1329++
					}
				}
				r.EncodeMapStart(yynn1329)
				yynn1329 = 0
			}
			if yyr1329 || yy2arr1329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1331 := z.EncBinary()
				_ = yym1331
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1332 := z.EncBinary()
				_ = yym1332
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1329 || yy2arr1329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1334 := z.EncBinary()
				_ = yym1334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1335 := z.EncBinary()
				_ = yym1335
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1329 || yy2arr1329 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1336 := z.DecBinary()
	_ = yym1336
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1337 := r.ContainerType()
		if yyct1337 == codecSelferValueTypeMap1234 {
			yyl1337 := r.ReadMapStart()
			if yyl1337 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1337, d)
			}
		} else if yyct1337 == codecSelferValueTypeArray1234 {
			yyl1337 := r.ReadArrayStart()
			if yyl1337 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1337, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1338Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1338Slc
	var yyhl1338 bool = l >= 0
	for yyj1338 := 0; ; yyj1338++ {
		if yyhl1338 {
			if yyj1338 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1338Slc = r.DecodeBytes(yys1338Slc, true, true)
		yys1338 := string(yys1338Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1338 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1338)
		} // end switch yys1338
	} // end for yyj1338
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1341 int
	var yyb1341 bool
	var yyhl1341 bool = l >= 0
	yyj1341++
	if yyhl1341 {
		yyb1341 = yyj1341 > l
	} else {
		yyb1341 = r.CheckBreak()
	}
	if yyb1341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1341++
	if yyhl1341 {
		yyb1341 = yyj1341 > l
	} else {
		yyb1341 = r.CheckBreak()
	}
	if yyb1341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1341++
		if yyhl1341 {
			yyb1341 = yyj1341 > l
		} else {
			yyb1341 = r.CheckBreak()
		}
		if yyb1341 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1341-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPHeader) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1344 := z.EncBinary()
		_ = yym1344
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1345 := !z.EncBinary()
			yy2arr1345 := z.EncBasicHandle().StructToArray
			var yyq1345 [2]bool
			_, _, _ = yysep1345, yyq1345, yy2arr1345
			const yyr1345 bool = false
			var yynn1345 int
			if yyr1345 || yy2arr1345 {
				r.EncodeArrayStart(2)
			} else {
				yynn1345 = 2
				for _, b := range yyq1345 {
					if b {
						yynn1345++
					}
				}
				r.EncodeMapStart(yynn1345)
				yynn1345 = 0
			}
			if yyr1345 || yy2arr1345 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1347 := z.EncBinary()
				_ = yym1347
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1348 := z.EncBinary()
				_ = yym1348
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1345 || yy2arr1345 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1350 := z.EncBinary()
				_ = yym1350
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1351 := z.EncBinary()
				_ = yym1351
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr1345 || yy2arr1345 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPHeader) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1352 := z.DecBinary()
	_ = yym1352
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1353 := r.ContainerType()
		if yyct1353 == codecSelferValueTypeMap1234 {
			yyl1353 := r.ReadMapStart()
			if yyl1353 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1353, d)
			}
		} else if yyct1353 == codecSelferValueTypeArray1234 {
			yyl1353 := r.ReadArrayStart()
			if yyl1353 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1353, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPHeader) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1354Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1354Slc
	var yyhl1354 bool = l >= 0
	for yyj1354 := 0; ; yyj1354++ {
		if yyhl1354 {
			if yyj1354 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1354Slc = r.DecodeBytes(yys1354Slc, true, true)
		yys1354 := string(yys1354Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1354 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1354)
		} // end switch yys1354
	} // end for yyj1354
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPHeader) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1357 int
	var yyb1357 bool
	var yyhl1357 bool = l >= 0
	yyj1357++
	if yyhl1357 {
		yyb1357 = yyj1357 > l
	} else {
		yyb1357 = r.CheckBreak()
	}
	if yyb1357 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1357++
	if yyhl1357 {
		yyb1357 = yyj1357 > l
	} else {
		yyb1357 = r.CheckBreak()
	}
	if yyb1357 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj1357++
		if yyhl1357 {
			yyb1357 = yyj1357 > l
		} else {
			yyb1357 = r.CheckBreak()
		}
		if yyb1357 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1357-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1360 := z.EncBinary()
		_ = yym1360
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1361 := !z.EncBinary()
			yy2arr1361 := z.EncBasicHandle().StructToArray
			var yyq1361 [5]bool
			_, _, _ = yysep1361, yyq1361, yy2arr1361
			const yyr1361 bool = false
			yyq1361[0] = x.Path != ""
			yyq1361[1] = true
			yyq1361[2] = x.Host != ""
			yyq1361[3] = x.Scheme != ""
			yyq1361[4] = len(x.HTTPHeaders) != 0
			var yynn1361 int
			if yyr1361 || yy2arr1361 {
				r.EncodeArrayStart(5)
			} else {
				yynn1361 = 0
				for _, b := range yyq1361 {
					if b {
						yynn1361++
					}
				}
				r.EncodeMapStart(yynn1361)
				yynn1361 = 0
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1361[0] {
					yym1363 := z.EncBinary()
					_ = yym1363
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1361[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1364 := z.EncBinary()
					_ = yym1364
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1361[1] {
					yy1366 := &x.Port
					yym1367 := z.EncBinary()
					_ = yym1367
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1366) {
					} else if !yym1367 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1366)
					} else {
						z.EncFallback(yy1366)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1361[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1368 := &x.Port
					yym1369 := z.EncBinary()
					_ = yym1369
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1368) {
					} else if !yym1369 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1368)
					} else {
						z.EncFallback(yy1368)
					}
				}
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1361[2] {
					yym1371 := z.EncBinary()
					_ = yym1371
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1361[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1372 := z.EncBinary()
					_ = yym1372
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1361[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1361[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1361[4] {
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1375 := z.EncBinary()
						_ = yym1375
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1361[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpHeaders"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1376 := z.EncBinary()
						_ = yym1376
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				}
			}
			if yyr1361 || yy2arr1361 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1377 := z.DecBinary()
	_ = yym1377
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1378 := r.ContainerType()
		if yyct1378 == codecSelferValueTypeMap1234 {
			yyl1378 := r.ReadMapStart()
			if yyl1378 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1378, d)
			}
		} else if yyct1378 == codecSelferValueTypeArray1234 {
			yyl1378 := r.ReadArrayStart()
			if yyl1378 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1378, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1379Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1379Slc
	var yyhl1379 bool = l >= 0
	for yyj1379 := 0; ; yyj1379++ {
		if yyhl1379 {
			if yyj1379 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1379Slc = r.DecodeBytes(yys1379Slc, true, true)
		yys1379 := string(yys1379Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1379 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1381 := &x.Port
				yym1382 := z.DecBinary()
				_ = yym1382
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1381) {
				} else if !yym1382 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1381)
				} else {
					z.DecFallback(yyv1381, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		case "httpHeaders":
			if r.TryDecodeAsNil() {
				x.HTTPHeaders = nil
			} else {
				yyv1385 := &x.HTTPHeaders
				yym1386 := z.DecBinary()
				_ = yym1386
				if false {
				} else {
					h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1385), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1379)
		} // end switch yys1379
	} // end for yyj1379
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1387 int
	var yyb1387 bool
	var yyhl1387 bool = l >= 0
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1389 := &x.Port
		yym1390 := z.DecBinary()
		_ = yym1390
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1389) {
		} else if !yym1390 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1389)
		} else {
			z.DecFallback(yyv1389, false)
		}
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPHeaders = nil
	} else {
		yyv1393 := &x.HTTPHeaders
		yym1394 := z.DecBinary()
		_ = yym1394
		if false {
		} else {
			h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1393), d)
		}
	}
	for {
		yyj1387++
		if yyhl1387 {
			yyb1387 = yyj1387 > l
		} else {
			yyb1387 = r.CheckBreak()
		}
		if yyb1387 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1387-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1395 := z.EncBinary()
	_ = yym1395
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1396 := z.DecBinary()
	_ = yym1396
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1397 := z.EncBinary()
		_ = yym1397
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1398 := !z.EncBinary()
			yy2arr1398 := z.EncBasicHandle().StructToArray
			var yyq1398 [1]bool
			_, _, _ = yysep1398, yyq1398, yy2arr1398
			const yyr1398 bool = false
			yyq1398[0] = true
			var yynn1398 int
			if yyr1398 || yy2arr1398 {
				r.EncodeArrayStart(1)
			} else {
				yynn1398 = 0
				for _, b := range yyq1398 {
					if b {
						yynn1398++
					}
				}
				r.EncodeMapStart(yynn1398)
				yynn1398 = 0
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1398[0] {
					yy1400 := &x.Port
					yym1401 := z.EncBinary()
					_ = yym1401
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1400) {
					} else if !yym1401 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1400)
					} else {
						z.EncFallback(yy1400)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1398[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1402 := &x.Port
					yym1403 := z.EncBinary()
					_ = yym1403
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1402) {
					} else if !yym1403 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1402)
					} else {
						z.EncFallback(yy1402)
					}
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1404 := z.DecBinary()
	_ = yym1404
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1405 := r.ContainerType()
		if yyct1405 == codecSelferValueTypeMap1234 {
			yyl1405 := r.ReadMapStart()
			if yyl1405 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1405, d)
			}
		} else if yyct1405 == codecSelferValueTypeArray1234 {
			yyl1405 := r.ReadArrayStart()
			if yyl1405 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1405, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1406Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1406Slc
	var yyhl1406 bool = l >= 0
	for yyj1406 := 0; ; yyj1406++ {
		if yyhl1406 {
			if yyj1406 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1406Slc = r.DecodeBytes(yys1406Slc, true, true)
		yys1406 := string(yys1406Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1406 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1407 := &x.Port
				yym1408 := z.DecBinary()
				_ = yym1408
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1407) {
				} else if !yym1408 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1407)
				} else {
					z.DecFallback(yyv1407, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1406)
		} // end switch yys1406
	} // end for yyj1406
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1409 int
	var yyb1409 bool
	var yyhl1409 bool = l >= 0
	yyj1409++
	if yyhl1409 {
		yyb1409 = yyj1409 > l
	} else {
		yyb1409 = r.CheckBreak()
	}
	if yyb1409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1410 := &x.Port
		yym1411 := z.DecBinary()
		_ = yym1411
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1410) {
		} else if !yym1411 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1410)
		} else {
			z.DecFallback(yyv1410, false)
		}
	}
	for {
		yyj1409++
		if yyhl1409 {
			yyb1409 = yyj1409 > l
		} else {
			yyb1409 = r.CheckBreak()
		}
		if yyb1409 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1409-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1412 := z.EncBinary()
		_ = yym1412
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1413 := !z.EncBinary()
			yy2arr1413 := z.EncBasicHandle().StructToArray
			var yyq1413 [1]bool
			_, _, _ = yysep1413, yyq1413, yy2arr1413
			const yyr1413 bool = false
			yyq1413[0] = len(x.Command) != 0
			var yynn1413 int
			if yyr1413 || yy2arr1413 {
				r.EncodeArrayStart(1)
			} else {
				yynn1413 = 0
				for _, b := range yyq1413 {
					if b {
						yynn1413++
					}
				}
				r.EncodeMapStart(yynn1413)
				yynn1413 = 0
			}
			if yyr1413 || yy2arr1413 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1413[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1415 := z.EncBinary()
						_ = yym1415
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1413[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1416 := z.EncBinary()
						_ = yym1416
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1413 || yy2arr1413 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1417 := z.DecBinary()
	_ = yym1417
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1418 := r.ContainerType()
		if yyct1418 == codecSelferValueTypeMap1234 {
			yyl1418 := r.ReadMapStart()
			if yyl1418 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1418, d)
			}
		} else if yyct1418 == codecSelferValueTypeArray1234 {
			yyl1418 := r.ReadArrayStart()
			if yyl1418 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1418, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1419Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1419Slc
	var yyhl1419 bool = l >= 0
	for yyj1419 := 0; ; yyj1419++ {
		if yyhl1419 {
			if yyj1419 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1419Slc = r.DecodeBytes(yys1419Slc, true, true)
		yys1419 := string(yys1419Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1419 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1420 := &x.Command
				yym1421 := z.DecBinary()
				_ = yym1421
				if false {
				} else {
					z.F.DecSliceStringX(yyv1420, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1419)
		} // end switch yys1419
	} // end for yyj1419
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1422 int
	var yyb1422 bool
	var yyhl1422 bool = l >= 0
	yyj1422++
	if yyhl1422 {
		yyb1422 = yyj1422 > l
	} else {
		yyb1422 = r.CheckBreak()
	}
	if yyb1422 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1423 := &x.Command
		yym1424 := z.DecBinary()
		_ = yym1424
		if false {
		} else {
			z.F.DecSliceStringX(yyv1423, false, d)
		}
	}
	for {
		yyj1422++
		if yyhl1422 {
			yyb1422 = yyj1422 > l
		} else {
			yyb1422 = r.CheckBreak()
		}
		if yyb1422 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1422-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1425 := z.EncBinary()
		_ = yym1425
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1426 := !z.EncBinary()
			yy2arr1426 := z.EncBasicHandle().StructToArray
			var yyq1426 [8]bool
			_, _, _ = yysep1426, yyq1426, yy2arr1426
			const yyr1426 bool = false
			yyq1426[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1426[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1426[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1426[3] = x.InitialDelaySeconds != 0
			yyq1426[4] = x.TimeoutSeconds != 0
			yyq1426[5] = x.PeriodSeconds != 0
			yyq1426[6] = x.SuccessThreshold != 0
			yyq1426[7] = x.FailureThreshold != 0
			var yynn1426 int
			if yyr1426 || yy2arr1426 {
				r.EncodeArrayStart(8)
			} else {
				yynn1426 = 0
				for _, b := range yyq1426 {
					if b {
						yynn1426++
					}
				}
				r.EncodeMapStart(yynn1426)
				yynn1426 = 0
			}
			var yyn1427 bool
			if x.Handler.Exec == nil {
				yyn1427 = true
				goto LABEL1427
			}
		LABEL1427:
			if yyr1426 || yy2arr1426 {
				if yyn1427 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1426[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1426[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1427 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1428 bool
			if x.Handler.HTTPGet == nil {
				yyn1428 = true
				goto LABEL1428
			}
		LABEL1428:
			if yyr1426 || yy2arr1426 {
				if yyn1428 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1426[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1426[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1428 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1429 bool
			if x.Handler.TCPSocket == nil {
				yyn1429 = true
				goto LABEL1429
			}
		LABEL1429:
			if yyr1426 || yy2arr1426 {
				if yyn1429 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1426[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1426[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1429 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1426[3] {
					yym1431 := z.EncBinary()
					_ = yym1431
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1426[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1432 := z.EncBinary()
					_ = yym1432
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1426[4] {
					yym1434 := z.EncBinary()
					_ = yym1434
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1426[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1435 := z.EncBinary()
					_ = yym1435
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1426[5] {
					yym1437 := z.EncBinary()
					_ = yym1437
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1426[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1438 := z.EncBinary()
					_ = yym1438
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1426[6] {
					yym1440 := z.EncBinary()
					_ = yym1440
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1426[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1441 := z.EncBinary()
					_ = yym1441
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1426[7] {
					yym1443 := z.EncBinary()
					_ = yym1443
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1426[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1444 := z.EncBinary()
					_ = yym1444
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1426 || yy2arr1426 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1445 := z.DecBinary()
	_ = yym1445
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1446 := r.ContainerType()
		if yyct1446 == codecSelferValueTypeMap1234 {
			yyl1446 := r.ReadMapStart()
			if yyl1446 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1446, d)
			}
		} else if yyct1446 == codecSelferValueTypeArray1234 {
			yyl1446 := r.ReadArrayStart()
			if yyl1446 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1446, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1447Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1447Slc
	var yyhl1447 bool = l >= 0
	for yyj1447 := 0; ; yyj1447++ {
		if yyhl1447 {
			if yyj1447 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1447Slc = r.DecodeBytes(yys1447Slc, true, true)
		yys1447 := string(yys1447Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1447 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int32(r.DecodeInt(32))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int32(r.DecodeInt(32))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int32(r.DecodeInt(32))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int32(r.DecodeInt(32))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1447)
		} // end switch yys1447
	} // end for yyj1447
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1456 int
	var yyb1456 bool
	var yyhl1456 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int32(r.DecodeInt(32))
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int32(r.DecodeInt(32))
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int32(r.DecodeInt(32))
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int32(r.DecodeInt(32))
	}
	yyj1456++
	if yyhl1456 {
		yyb1456 = yyj1456 > l
	} else {
		yyb1456 = r.CheckBreak()
	}
	if yyb1456 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int32(r.DecodeInt(32))
	}
	for {
		yyj1456++
		if yyhl1456 {
			yyb1456 = yyj1456 > l
		} else {
			yyb1456 = r.CheckBreak()
		}
		if yyb1456 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1456-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1465 := z.EncBinary()
	_ = yym1465
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1466 := z.DecBinary()
	_ = yym1466
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1467 := z.EncBinary()
	_ = yym1467
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1468 := z.DecBinary()
	_ = yym1468
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1469 := z.EncBinary()
		_ = yym1469
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1470 := !z.EncBinary()
			yy2arr1470 := z.EncBasicHandle().StructToArray
			var yyq1470 [2]bool
			_, _, _ = yysep1470, yyq1470, yy2arr1470
			const yyr1470 bool = false
			yyq1470[0] = len(x.Add) != 0
			yyq1470[1] = len(x.Drop) != 0
			var yynn1470 int
			if yyr1470 || yy2arr1470 {
				r.EncodeArrayStart(2)
			} else {
				yynn1470 = 0
				for _, b := range yyq1470 {
					if b {
						yynn1470++
					}
				}
				r.EncodeMapStart(yynn1470)
				yynn1470 = 0
			}
			if yyr1470 || yy2arr1470 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1470[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1472 := z.EncBinary()
						_ = yym1472
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1470[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1473 := z.EncBinary()
						_ = yym1473
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1470 || yy2arr1470 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1470[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1475 := z.EncBinary()
						_ = yym1475
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1470[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1476 := z.EncBinary()
						_ = yym1476
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1470 || yy2arr1470 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1477 := z.DecBinary()
	_ = yym1477
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1478 := r.ContainerType()
		if yyct1478 == codecSelferValueTypeMap1234 {
			yyl1478 := r.ReadMapStart()
			if yyl1478 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1478, d)
			}
		} else if yyct1478 == codecSelferValueTypeArray1234 {
			yyl1478 := r.ReadArrayStart()
			if yyl1478 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1478, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1479Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1479Slc
	var yyhl1479 bool = l >= 0
	for yyj1479 := 0; ; yyj1479++ {
		if yyhl1479 {
			if yyj1479 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1479Slc = r.DecodeBytes(yys1479Slc, true, true)
		yys1479 := string(yys1479Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1479 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1480 := &x.Add
				yym1481 := z.DecBinary()
				_ = yym1481
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1480), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1482 := &x.Drop
				yym1483 := z.DecBinary()
				_ = yym1483
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1482), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1479)
		} // end switch yys1479
	} // end for yyj1479
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1484 int
	var yyb1484 bool
	var yyhl1484 bool = l >= 0
	yyj1484++
	if yyhl1484 {
		yyb1484 = yyj1484 > l
	} else {
		yyb1484 = r.CheckBreak()
	}
	if yyb1484 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1485 := &x.Add
		yym1486 := z.DecBinary()
		_ = yym1486
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1485), d)
		}
	}
	yyj1484++
	if yyhl1484 {
		yyb1484 = yyj1484 > l
	} else {
		yyb1484 = r.CheckBreak()
	}
	if yyb1484 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1487 := &x.Drop
		yym1488 := z.DecBinary()
		_ = yym1488
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1487), d)
		}
	}
	for {
		yyj1484++
		if yyhl1484 {
			yyb1484 = yyj1484 > l
		} else {
			yyb1484 = r.CheckBreak()
		}
		if yyb1484 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1484-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1489 := z.EncBinary()
		_ = yym1489
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1490 := !z.EncBinary()
			yy2arr1490 := z.EncBasicHandle().StructToArray
			var yyq1490 [2]bool
			_, _, _ = yysep1490, yyq1490, yy2arr1490
			const yyr1490 bool = false
			yyq1490[0] = len(x.Limits) != 0
			yyq1490[1] = len(x.Requests) != 0
			var yynn1490 int
			if yyr1490 || yy2arr1490 {
				r.EncodeArrayStart(2)
			} else {
				yynn1490 = 0
				for _, b := range yyq1490 {
					if b {
						yynn1490++
					}
				}
				r.EncodeMapStart(yynn1490)
				yynn1490 = 0
			}
			if yyr1490 || yy2arr1490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1490[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1490[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1490 || yy2arr1490 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1490[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1490[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1490 || yy2arr1490 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1493 := z.DecBinary()
	_ = yym1493
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1494 := r.ContainerType()
		if yyct1494 == codecSelferValueTypeMap1234 {
			yyl1494 := r.ReadMapStart()
			if yyl1494 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1494, d)
			}
		} else if yyct1494 == codecSelferValueTypeArray1234 {
			yyl1494 := r.ReadArrayStart()
			if yyl1494 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1494, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1495Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1495Slc
	var yyhl1495 bool = l >= 0
	for yyj1495 := 0; ; yyj1495++ {
		if yyhl1495 {
			if yyj1495 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1495Slc = r.DecodeBytes(yys1495Slc, true, true)
		yys1495 := string(yys1495Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1495 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1496 := &x.Limits
				yyv1496.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1497 := &x.Requests
				yyv1497.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1495)
		} // end switch yys1495
	} // end for yyj1495
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1498 int
	var yyb1498 bool
	var yyhl1498 bool = l >= 0
	yyj1498++
	if yyhl1498 {
		yyb1498 = yyj1498 > l
	} else {
		yyb1498 = r.CheckBreak()
	}
	if yyb1498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1499 := &x.Limits
		yyv1499.CodecDecodeSelf(d)
	}
	yyj1498++
	if yyhl1498 {
		yyb1498 = yyj1498 > l
	} else {
		yyb1498 = r.CheckBreak()
	}
	if yyb1498 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1500 := &x.Requests
		yyv1500.CodecDecodeSelf(d)
	}
	for {
		yyj1498++
		if yyhl1498 {
			yyb1498 = yyj1498 > l
		} else {
			yyb1498 = r.CheckBreak()
		}
		if yyb1498 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1498-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1501 := z.EncBinary()
		_ = yym1501
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1502 := !z.EncBinary()
			yy2arr1502 := z.EncBasicHandle().StructToArray
			var yyq1502 [18]bool
			_, _, _ = yysep1502, yyq1502, yy2arr1502
			const yyr1502 bool = false
			yyq1502[2] = len(x.Command) != 0
			yyq1502[3] = len(x.Args) != 0
			yyq1502[4] = x.WorkingDir != ""
			yyq1502[5] = len(x.Ports) != 0
			yyq1502[6] = len(x.Env) != 0
			yyq1502[7] = true
			yyq1502[8] = len(x.VolumeMounts) != 0
			yyq1502[9] = x.LivenessProbe != nil
			yyq1502[10] = x.ReadinessProbe != nil
			yyq1502[11] = x.Lifecycle != nil
			yyq1502[12] = x.TerminationMessagePath != ""
			yyq1502[14] = x.SecurityContext != nil
			yyq1502[15] = x.Stdin != false
			yyq1502[16] = x.StdinOnce != false
			yyq1502[17] = x.TTY != false
			var yynn1502 int
			if yyr1502 || yy2arr1502 {
				r.EncodeArrayStart(18)
			} else {
				yynn1502 = 3
				for _, b := range yyq1502 {
					if b {
						yynn1502++
					}
				}
				r.EncodeMapStart(yynn1502)
				yynn1502 = 0
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1504 := z.EncBinary()
				_ = yym1504
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1505 := z.EncBinary()
				_ = yym1505
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1507 := z.EncBinary()
				_ = yym1507
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1508 := z.EncBinary()
				_ = yym1508
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1510 := z.EncBinary()
						_ = yym1510
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1511 := z.EncBinary()
						_ = yym1511
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1513 := z.EncBinary()
						_ = yym1513
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1514 := z.EncBinary()
						_ = yym1514
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[4] {
					yym1516 := z.EncBinary()
					_ = yym1516
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1502[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1517 := z.EncBinary()
					_ = yym1517
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1519 := z.EncBinary()
						_ = yym1519
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1520 := z.EncBinary()
						_ = yym1520
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1522 := z.EncBinary()
						_ = yym1522
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1523 := z.EncBinary()
						_ = yym1523
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[7] {
					yy1525 := &x.Resources
					yy1525.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1526 := &x.Resources
					yy1526.CodecEncodeSelf(e)
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1528 := z.EncBinary()
						_ = yym1528
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1529 := z.EncBinary()
						_ = yym1529
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[12] {
					yym1534 := z.EncBinary()
					_ = yym1534
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1502[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1535 := z.EncBinary()
					_ = yym1535
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1502[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[15] {
					yym1539 := z.EncBinary()
					_ = yym1539
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1502[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1540 := z.EncBinary()
					_ = yym1540
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[16] {
					yym1542 := z.EncBinary()
					_ = yym1542
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1502[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1543 := z.EncBinary()
					_ = yym1543
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1502[17] {
					yym1545 := z.EncBinary()
					_ = yym1545
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1502[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1546 := z.EncBinary()
					_ = yym1546
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1502 || yy2arr1502 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1547 := z.DecBinary()
	_ = yym1547
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1548 := r.ContainerType()
		if yyct1548 == codecSelferValueTypeMap1234 {
			yyl1548 := r.ReadMapStart()
			if yyl1548 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1548, d)
			}
		} else if yyct1548 == codecSelferValueTypeArray1234 {
			yyl1548 := r.ReadArrayStart()
			if yyl1548 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1548, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1549Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1549Slc
	var yyhl1549 bool = l >= 0
	for yyj1549 := 0; ; yyj1549++ {
		if yyhl1549 {
			if yyj1549 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1549Slc = r.DecodeBytes(yys1549Slc, true, true)
		yys1549 := string(yys1549Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1549 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1552 := &x.Command
				yym1553 := z.DecBinary()
				_ = yym1553
				if false {
				} else {
					z.F.DecSliceStringX(yyv1552, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1554 := &x.Args
				yym1555 := z.DecBinary()
				_ = yym1555
				if false {
				} else {
					z.F.DecSliceStringX(yyv1554, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1557 := &x.Ports
				yym1558 := z.DecBinary()
				_ = yym1558
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1557), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1559 := &x.Env
				yym1560 := z.DecBinary()
				_ = yym1560
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1559), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1561 := &x.Resources
				yyv1561.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1562 := &x.VolumeMounts
				yym1563 := z.DecBinary()
				_ = yym1563
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1562), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1549)
		} // end switch yys1549
	} // end for yyj1549
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1573 int
	var yyb1573 bool
	var yyhl1573 bool = l >= 0
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1576 := &x.Command
		yym1577 := z.DecBinary()
		_ = yym1577
		if false {
		} else {
			z.F.DecSliceStringX(yyv1576, false, d)
		}
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1578 := &x.Args
		yym1579 := z.DecBinary()
		_ = yym1579
		if false {
		} else {
			z.F.DecSliceStringX(yyv1578, false, d)
		}
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1581 := &x.Ports
		yym1582 := z.DecBinary()
		_ = yym1582
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1581), d)
		}
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1583 := &x.Env
		yym1584 := z.DecBinary()
		_ = yym1584
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1583), d)
		}
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1585 := &x.Resources
		yyv1585.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1586 := &x.VolumeMounts
		yym1587 := z.DecBinary()
		_ = yym1587
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1586), d)
		}
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1573++
	if yyhl1573 {
		yyb1573 = yyj1573 > l
	} else {
		yyb1573 = r.CheckBreak()
	}
	if yyb1573 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1573++
		if yyhl1573 {
			yyb1573 = yyj1573 > l
		} else {
			yyb1573 = r.CheckBreak()
		}
		if yyb1573 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1573-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1597 := z.EncBinary()
		_ = yym1597
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1598 := !z.EncBinary()
			yy2arr1598 := z.EncBasicHandle().StructToArray
			var yyq1598 [3]bool
			_, _, _ = yysep1598, yyq1598, yy2arr1598
			const yyr1598 bool = false
			yyq1598[0] = x.Exec != nil
			yyq1598[1] = x.HTTPGet != nil
			yyq1598[2] = x.TCPSocket != nil
			var yynn1598 int
			if yyr1598 || yy2arr1598 {
				r.EncodeArrayStart(3)
			} else {
				yynn1598 = 0
				for _, b := range yyq1598 {
					if b {
						yynn1598++
					}
				}
				r.EncodeMapStart(yynn1598)
				yynn1598 = 0
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1598[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1598[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1598[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1598[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1598[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1598[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1602 := z.DecBinary()
	_ = yym1602
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1603 := r.ContainerType()
		if yyct1603 == codecSelferValueTypeMap1234 {
			yyl1603 := r.ReadMapStart()
			if yyl1603 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1603, d)
			}
		} else if yyct1603 == codecSelferValueTypeArray1234 {
			yyl1603 := r.ReadArrayStart()
			if yyl1603 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1603, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1604Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1604Slc
	var yyhl1604 bool = l >= 0
	for yyj1604 := 0; ; yyj1604++ {
		if yyhl1604 {
			if yyj1604 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1604Slc = r.DecodeBytes(yys1604Slc, true, true)
		yys1604 := string(yys1604Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1604 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1604)
		} // end switch yys1604
	} // end for yyj1604
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1608 int
	var yyb1608 bool
	var yyhl1608 bool = l >= 0
	yyj1608++
	if yyhl1608 {
		yyb1608 = yyj1608 > l
	} else {
		yyb1608 = r.CheckBreak()
	}
	if yyb1608 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1608++
	if yyhl1608 {
		yyb1608 = yyj1608 > l
	} else {
		yyb1608 = r.CheckBreak()
	}
	if yyb1608 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1608++
	if yyhl1608 {
		yyb1608 = yyj1608 > l
	} else {
		yyb1608 = r.CheckBreak()
	}
	if yyb1608 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1608++
		if yyhl1608 {
			yyb1608 = yyj1608 > l
		} else {
			yyb1608 = r.CheckBreak()
		}
		if yyb1608 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1608-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1612 := z.EncBinary()
		_ = yym1612
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1613 := !z.EncBinary()
			yy2arr1613 := z.EncBasicHandle().StructToArray
			var yyq1613 [2]bool
			_, _, _ = yysep1613, yyq1613, yy2arr1613
			const yyr1613 bool = false
			yyq1613[0] = x.PostStart != nil
			yyq1613[1] = x.PreStop != nil
			var yynn1613 int
			if yyr1613 || yy2arr1613 {
				r.EncodeArrayStart(2)
			} else {
				yynn1613 = 0
				for _, b := range yyq1613 {
					if b {
						yynn1613++
					}
				}
				r.EncodeMapStart(yynn1613)
				yynn1613 = 0
			}
			if yyr1613 || yy2arr1613 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1613[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1613[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1613 || yy2arr1613 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1613[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1613[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1613 || yy2arr1613 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1616 := z.DecBinary()
	_ = yym1616
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1617 := r.ContainerType()
		if yyct1617 == codecSelferValueTypeMap1234 {
			yyl1617 := r.ReadMapStart()
			if yyl1617 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1617, d)
			}
		} else if yyct1617 == codecSelferValueTypeArray1234 {
			yyl1617 := r.ReadArrayStart()
			if yyl1617 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1617, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1618Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1618Slc
	var yyhl1618 bool = l >= 0
	for yyj1618 := 0; ; yyj1618++ {
		if yyhl1618 {
			if yyj1618 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1618Slc = r.DecodeBytes(yys1618Slc, true, true)
		yys1618 := string(yys1618Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1618 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1618)
		} // end switch yys1618
	} // end for yyj1618
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1621 int
	var yyb1621 bool
	var yyhl1621 bool = l >= 0
	yyj1621++
	if yyhl1621 {
		yyb1621 = yyj1621 > l
	} else {
		yyb1621 = r.CheckBreak()
	}
	if yyb1621 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1621++
	if yyhl1621 {
		yyb1621 = yyj1621 > l
	} else {
		yyb1621 = r.CheckBreak()
	}
	if yyb1621 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1621++
		if yyhl1621 {
			yyb1621 = yyj1621 > l
		} else {
			yyb1621 = r.CheckBreak()
		}
		if yyb1621 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1621-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1624 := z.EncBinary()
	_ = yym1624
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1625 := z.DecBinary()
	_ = yym1625
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1626 := z.EncBinary()
		_ = yym1626
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1627 := !z.EncBinary()
			yy2arr1627 := z.EncBasicHandle().StructToArray
			var yyq1627 [2]bool
			_, _, _ = yysep1627, yyq1627, yy2arr1627
			const yyr1627 bool = false
			yyq1627[0] = x.Reason != ""
			yyq1627[1] = x.Message != ""
			var yynn1627 int
			if yyr1627 || yy2arr1627 {
				r.EncodeArrayStart(2)
			} else {
				yynn1627 = 0
				for _, b := range yyq1627 {
					if b {
						yynn1627++
					}
				}
				r.EncodeMapStart(yynn1627)
				yynn1627 = 0
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1627[0] {
					yym1629 := z.EncBinary()
					_ = yym1629
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1627[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1630 := z.EncBinary()
					_ = yym1630
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1627[1] {
					yym1632 := z.EncBinary()
					_ = yym1632
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1627[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1633 := z.EncBinary()
					_ = yym1633
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1634 := z.DecBinary()
	_ = yym1634
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1635 := r.ContainerType()
		if yyct1635 == codecSelferValueTypeMap1234 {
			yyl1635 := r.ReadMapStart()
			if yyl1635 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1635, d)
			}
		} else if yyct1635 == codecSelferValueTypeArray1234 {
			yyl1635 := r.ReadArrayStart()
			if yyl1635 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1635, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1636Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1636Slc
	var yyhl1636 bool = l >= 0
	for yyj1636 := 0; ; yyj1636++ {
		if yyhl1636 {
			if yyj1636 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1636Slc = r.DecodeBytes(yys1636Slc, true, true)
		yys1636 := string(yys1636Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1636 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1636)
		} // end switch yys1636
	} // end for yyj1636
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1639 int
	var yyb1639 bool
	var yyhl1639 bool = l >= 0
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1639++
		if yyhl1639 {
			yyb1639 = yyj1639 > l
		} else {
			yyb1639 = r.CheckBreak()
		}
		if yyb1639 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1639-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1642 := z.EncBinary()
		_ = yym1642
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1643 := !z.EncBinary()
			yy2arr1643 := z.EncBasicHandle().StructToArray
			var yyq1643 [1]bool
			_, _, _ = yysep1643, yyq1643, yy2arr1643
			const yyr1643 bool = false
			yyq1643[0] = true
			var yynn1643 int
			if yyr1643 || yy2arr1643 {
				r.EncodeArrayStart(1)
			} else {
				yynn1643 = 0
				for _, b := range yyq1643 {
					if b {
						yynn1643++
					}
				}
				r.EncodeMapStart(yynn1643)
				yynn1643 = 0
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[0] {
					yy1645 := &x.StartedAt
					yym1646 := z.EncBinary()
					_ = yym1646
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1645) {
					} else if yym1646 {
						z.EncBinaryMarshal(yy1645)
					} else if !yym1646 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1645)
					} else {
						z.EncFallback(yy1645)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1643[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1647 := &x.StartedAt
					yym1648 := z.EncBinary()
					_ = yym1648
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1647) {
					} else if yym1648 {
						z.EncBinaryMarshal(yy1647)
					} else if !yym1648 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1647)
					} else {
						z.EncFallback(yy1647)
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1649 := z.DecBinary()
	_ = yym1649
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1650 := r.ContainerType()
		if yyct1650 == codecSelferValueTypeMap1234 {
			yyl1650 := r.ReadMapStart()
			if yyl1650 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1650, d)
			}
		} else if yyct1650 == codecSelferValueTypeArray1234 {
			yyl1650 := r.ReadArrayStart()
			if yyl1650 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1650, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1651Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1651Slc
	var yyhl1651 bool = l >= 0
	for yyj1651 := 0; ; yyj1651++ {
		if yyhl1651 {
			if yyj1651 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1651Slc = r.DecodeBytes(yys1651Slc, true, true)
		yys1651 := string(yys1651Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1651 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1652 := &x.StartedAt
				yym1653 := z.DecBinary()
				_ = yym1653
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1652) {
				} else if yym1653 {
					z.DecBinaryUnmarshal(yyv1652)
				} else if !yym1653 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1652)
				} else {
					z.DecFallback(yyv1652, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1651)
		} // end switch yys1651
	} // end for yyj1651
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1654 int
	var yyb1654 bool
	var yyhl1654 bool = l >= 0
	yyj1654++
	if yyhl1654 {
		yyb1654 = yyj1654 > l
	} else {
		yyb1654 = r.CheckBreak()
	}
	if yyb1654 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1655 := &x.StartedAt
		yym1656 := z.DecBinary()
		_ = yym1656
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1655) {
		} else if yym1656 {
			z.DecBinaryUnmarshal(yyv1655)
		} else if !yym1656 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1655)
		} else {
			z.DecFallback(yyv1655, false)
		}
	}
	for {
		yyj1654++
		if yyhl1654 {
			yyb1654 = yyj1654 > l
		} else {
			yyb1654 = r.CheckBreak()
		}
		if yyb1654 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1654-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1657 := z.EncBinary()
		_ = yym1657
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1658 := !z.EncBinary()
			yy2arr1658 := z.EncBasicHandle().StructToArray
			var yyq1658 [7]bool
			_, _, _ = yysep1658, yyq1658, yy2arr1658
			const yyr1658 bool = false
			yyq1658[1] = x.Signal != 0
			yyq1658[2] = x.Reason != ""
			yyq1658[3] = x.Message != ""
			yyq1658[4] = true
			yyq1658[5] = true
			yyq1658[6] = x.ContainerID != ""
			var yynn1658 int
			if yyr1658 || yy2arr1658 {
				r.EncodeArrayStart(7)
			} else {
				yynn1658 = 1
				for _, b := range yyq1658 {
					if b {
						yynn1658++
					}
				}
				r.EncodeMapStart(yynn1658)
				yynn1658 = 0
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1660 := z.EncBinary()
				_ = yym1660
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1661 := z.EncBinary()
				_ = yym1661
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[1] {
					yym1663 := z.EncBinary()
					_ = yym1663
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1658[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1664 := z.EncBinary()
					_ = yym1664
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[2] {
					yym1666 := z.EncBinary()
					_ = yym1666
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1658[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1667 := z.EncBinary()
					_ = yym1667
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[3] {
					yym1669 := z.EncBinary()
					_ = yym1669
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1658[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1670 := z.EncBinary()
					_ = yym1670
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[4] {
					yy1672 := &x.StartedAt
					yym1673 := z.EncBinary()
					_ = yym1673
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1672) {
					} else if yym1673 {
						z.EncBinaryMarshal(yy1672)
					} else if !yym1673 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1672)
					} else {
						z.EncFallback(yy1672)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1658[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1674 := &x.StartedAt
					yym1675 := z.EncBinary()
					_ = yym1675
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1674) {
					} else if yym1675 {
						z.EncBinaryMarshal(yy1674)
					} else if !yym1675 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1674)
					} else {
						z.EncFallback(yy1674)
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[5] {
					yy1677 := &x.FinishedAt
					yym1678 := z.EncBinary()
					_ = yym1678
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1677) {
					} else if yym1678 {
						z.EncBinaryMarshal(yy1677)
					} else if !yym1678 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1677)
					} else {
						z.EncFallback(yy1677)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1658[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1679 := &x.FinishedAt
					yym1680 := z.EncBinary()
					_ = yym1680
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1679) {
					} else if yym1680 {
						z.EncBinaryMarshal(yy1679)
					} else if !yym1680 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1679)
					} else {
						z.EncFallback(yy1679)
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[6] {
					yym1682 := z.EncBinary()
					_ = yym1682
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1658[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1683 := z.EncBinary()
					_ = yym1683
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1684 := z.DecBinary()
	_ = yym1684
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1685 := r.ContainerType()
		if yyct1685 == codecSelferValueTypeMap1234 {
			yyl1685 := r.ReadMapStart()
			if yyl1685 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1685, d)
			}
		} else if yyct1685 == codecSelferValueTypeArray1234 {
			yyl1685 := r.ReadArrayStart()
			if yyl1685 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1685, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1686Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1686Slc
	var yyhl1686 bool = l >= 0
	for yyj1686 := 0; ; yyj1686++ {
		if yyhl1686 {
			if yyj1686 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1686Slc = r.DecodeBytes(yys1686Slc, true, true)
		yys1686 := string(yys1686Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1686 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int32(r.DecodeInt(32))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int32(r.DecodeInt(32))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1691 := &x.StartedAt
				yym1692 := z.DecBinary()
				_ = yym1692
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1691) {
				} else if yym1692 {
					z.DecBinaryUnmarshal(yyv1691)
				} else if !yym1692 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1691)
				} else {
					z.DecFallback(yyv1691, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1693 := &x.FinishedAt
				yym1694 := z.DecBinary()
				_ = yym1694
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1693) {
				} else if yym1694 {
					z.DecBinaryUnmarshal(yyv1693)
				} else if !yym1694 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1693)
				} else {
					z.DecFallback(yyv1693, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1686)
		} // end switch yys1686
	} // end for yyj1686
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1696 int
	var yyb1696 bool
	var yyhl1696 bool = l >= 0
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int32(r.DecodeInt(32))
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int32(r.DecodeInt(32))
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1701 := &x.StartedAt
		yym1702 := z.DecBinary()
		_ = yym1702
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1701) {
		} else if yym1702 {
			z.DecBinaryUnmarshal(yyv1701)
		} else if !yym1702 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1701)
		} else {
			z.DecFallback(yyv1701, false)
		}
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1703 := &x.FinishedAt
		yym1704 := z.DecBinary()
		_ = yym1704
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1703) {
		} else if yym1704 {
			z.DecBinaryUnmarshal(yyv1703)
		} else if !yym1704 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1703)
		} else {
			z.DecFallback(yyv1703, false)
		}
	}
	yyj1696++
	if yyhl1696 {
		yyb1696 = yyj1696 > l
	} else {
		yyb1696 = r.CheckBreak()
	}
	if yyb1696 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1696++
		if yyhl1696 {
			yyb1696 = yyj1696 > l
		} else {
			yyb1696 = r.CheckBreak()
		}
		if yyb1696 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1696-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1706 := z.EncBinary()
		_ = yym1706
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1707 := !z.EncBinary()
			yy2arr1707 := z.EncBasicHandle().StructToArray
			var yyq1707 [3]bool
			_, _, _ = yysep1707, yyq1707, yy2arr1707
			const yyr1707 bool = false
			yyq1707[0] = x.Waiting != nil
			yyq1707[1] = x.Running != nil
			yyq1707[2] = x.Terminated != nil
			var yynn1707 int
			if yyr1707 || yy2arr1707 {
				r.EncodeArrayStart(3)
			} else {
				yynn1707 = 0
				for _, b := range yyq1707 {
					if b {
						yynn1707++
					}
				}
				r.EncodeMapStart(yynn1707)
				yynn1707 = 0
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1707[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1707[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1707[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1711 := z.DecBinary()
	_ = yym1711
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1712 := r.ContainerType()
		if yyct1712 == codecSelferValueTypeMap1234 {
			yyl1712 := r.ReadMapStart()
			if yyl1712 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1712, d)
			}
		} else if yyct1712 == codecSelferValueTypeArray1234 {
			yyl1712 := r.ReadArrayStart()
			if yyl1712 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1712, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1713Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1713Slc
	var yyhl1713 bool = l >= 0
	for yyj1713 := 0; ; yyj1713++ {
		if yyhl1713 {
			if yyj1713 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1713Slc = r.DecodeBytes(yys1713Slc, true, true)
		yys1713 := string(yys1713Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1713 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1713)
		} // end switch yys1713
	} // end for yyj1713
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1717 int
	var yyb1717 bool
	var yyhl1717 bool = l >= 0
	yyj1717++
	if yyhl1717 {
		yyb1717 = yyj1717 > l
	} else {
		yyb1717 = r.CheckBreak()
	}
	if yyb1717 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1717++
	if yyhl1717 {
		yyb1717 = yyj1717 > l
	} else {
		yyb1717 = r.CheckBreak()
	}
	if yyb1717 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1717++
	if yyhl1717 {
		yyb1717 = yyj1717 > l
	} else {
		yyb1717 = r.CheckBreak()
	}
	if yyb1717 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1717++
		if yyhl1717 {
			yyb1717 = yyj1717 > l
		} else {
			yyb1717 = r.CheckBreak()
		}
		if yyb1717 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1717-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1721 := z.EncBinary()
		_ = yym1721
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1722 := !z.EncBinary()
			yy2arr1722 := z.EncBasicHandle().StructToArray
			var yyq1722 [8]bool
			_, _, _ = yysep1722, yyq1722, yy2arr1722
			const yyr1722 bool = false
			yyq1722[1] = true
			yyq1722[2] = true
			yyq1722[7] = x.ContainerID != ""
			var yynn1722 int
			if yyr1722 || yy2arr1722 {
				r.EncodeArrayStart(8)
			} else {
				yynn1722 = 5
				for _, b := range yyq1722 {
					if b {
						yynn1722++
					}
				}
				r.EncodeMapStart(yynn1722)
				yynn1722 = 0
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1724 := z.EncBinary()
				_ = yym1724
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1725 := z.EncBinary()
				_ = yym1725
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1722[1] {
					yy1727 := &x.State
					yy1727.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1722[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1728 := &x.State
					yy1728.CodecEncodeSelf(e)
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1722[2] {
					yy1730 := &x.LastTerminationState
					yy1730.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1722[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1731 := &x.LastTerminationState
					yy1731.CodecEncodeSelf(e)
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1733 := z.EncBinary()
				_ = yym1733
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1734 := z.EncBinary()
				_ = yym1734
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1736 := z.EncBinary()
				_ = yym1736
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1737 := z.EncBinary()
				_ = yym1737
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1739 := z.EncBinary()
				_ = yym1739
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1740 := z.EncBinary()
				_ = yym1740
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1742 := z.EncBinary()
				_ = yym1742
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1743 := z.EncBinary()
				_ = yym1743
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1722[7] {
					yym1745 := z.EncBinary()
					_ = yym1745
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1722[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1746 := z.EncBinary()
					_ = yym1746
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1722 || yy2arr1722 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1747 := z.DecBinary()
	_ = yym1747
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1748 := r.ContainerType()
		if yyct1748 == codecSelferValueTypeMap1234 {
			yyl1748 := r.ReadMapStart()
			if yyl1748 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1748, d)
			}
		} else if yyct1748 == codecSelferValueTypeArray1234 {
			yyl1748 := r.ReadArrayStart()
			if yyl1748 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1748, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1749Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1749Slc
	var yyhl1749 bool = l >= 0
	for yyj1749 := 0; ; yyj1749++ {
		if yyhl1749 {
			if yyj1749 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1749Slc = r.DecodeBytes(yys1749Slc, true, true)
		yys1749 := string(yys1749Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1749 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1751 := &x.State
				yyv1751.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1752 := &x.LastTerminationState
				yyv1752.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int32(r.DecodeInt(32))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1749)
		} // end switch yys1749
	} // end for yyj1749
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1758 int
	var yyb1758 bool
	var yyhl1758 bool = l >= 0
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1760 := &x.State
		yyv1760.CodecDecodeSelf(d)
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1761 := &x.LastTerminationState
		yyv1761.CodecDecodeSelf(d)
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int32(r.DecodeInt(32))
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1758++
	if yyhl1758 {
		yyb1758 = yyj1758 > l
	} else {
		yyb1758 = r.CheckBreak()
	}
	if yyb1758 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1758++
		if yyhl1758 {
			yyb1758 = yyj1758 > l
		} else {
			yyb1758 = r.CheckBreak()
		}
		if yyb1758 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1758-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1767 := z.EncBinary()
	_ = yym1767
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1768 := z.DecBinary()
	_ = yym1768
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1769 := z.EncBinary()
	_ = yym1769
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1770 := z.DecBinary()
	_ = yym1770
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1771 := z.EncBinary()
		_ = yym1771
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1772 := !z.EncBinary()
			yy2arr1772 := z.EncBasicHandle().StructToArray
			var yyq1772 [6]bool
			_, _, _ = yysep1772, yyq1772, yy2arr1772
			const yyr1772 bool = false
			yyq1772[2] = true
			yyq1772[3] = true
			yyq1772[4] = x.Reason != ""
			yyq1772[5] = x.Message != ""
			var yynn1772 int
			if yyr1772 || yy2arr1772 {
				r.EncodeArrayStart(6)
			} else {
				yynn1772 = 2
				for _, b := range yyq1772 {
					if b {
						yynn1772++
					}
				}
				r.EncodeMapStart(yynn1772)
				yynn1772 = 0
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1772[2] {
					yy1776 := &x.LastProbeTime
					yym1777 := z.EncBinary()
					_ = yym1777
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1776) {
					} else if yym1777 {
						z.EncBinaryMarshal(yy1776)
					} else if !yym1777 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1776)
					} else {
						z.EncFallback(yy1776)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1772[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1778 := &x.LastProbeTime
					yym1779 := z.EncBinary()
					_ = yym1779
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1778) {
					} else if yym1779 {
						z.EncBinaryMarshal(yy1778)
					} else if !yym1779 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1778)
					} else {
						z.EncFallback(yy1778)
					}
				}
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1772[3] {
					yy1781 := &x.LastTransitionTime
					yym1782 := z.EncBinary()
					_ = yym1782
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1781) {
					} else if yym1782 {
						z.EncBinaryMarshal(yy1781)
					} else if !yym1782 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1781)
					} else {
						z.EncFallback(yy1781)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1772[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1783 := &x.LastTransitionTime
					yym1784 := z.EncBinary()
					_ = yym1784
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1783) {
					} else if yym1784 {
						z.EncBinaryMarshal(yy1783)
					} else if !yym1784 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1783)
					} else {
						z.EncFallback(yy1783)
					}
				}
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1772[4] {
					yym1786 := z.EncBinary()
					_ = yym1786
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1772[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1787 := z.EncBinary()
					_ = yym1787
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1772[5] {
					yym1789 := z.EncBinary()
					_ = yym1789
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1772[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1790 := z.EncBinary()
					_ = yym1790
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1772 || yy2arr1772 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1791 := z.DecBinary()
	_ = yym1791
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1792 := r.ContainerType()
		if yyct1792 == codecSelferValueTypeMap1234 {
			yyl1792 := r.ReadMapStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1792, d)
			}
		} else if yyct1792 == codecSelferValueTypeArray1234 {
			yyl1792 := r.ReadArrayStart()
			if yyl1792 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1792, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1793Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1793Slc
	var yyhl1793 bool = l >= 0
	for yyj1793 := 0; ; yyj1793++ {
		if yyhl1793 {
			if yyj1793 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1793Slc = r.DecodeBytes(yys1793Slc, true, true)
		yys1793 := string(yys1793Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1793 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1796 := &x.LastProbeTime
				yym1797 := z.DecBinary()
				_ = yym1797
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1796) {
				} else if yym1797 {
					z.DecBinaryUnmarshal(yyv1796)
				} else if !yym1797 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1796)
				} else {
					z.DecFallback(yyv1796, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1798 := &x.LastTransitionTime
				yym1799 := z.DecBinary()
				_ = yym1799
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1798) {
				} else if yym1799 {
					z.DecBinaryUnmarshal(yyv1798)
				} else if !yym1799 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1798)
				} else {
					z.DecFallback(yyv1798, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1793)
		} // end switch yys1793
	} // end for yyj1793
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1802 int
	var yyb1802 bool
	var yyhl1802 bool = l >= 0
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1805 := &x.LastProbeTime
		yym1806 := z.DecBinary()
		_ = yym1806
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1805) {
		} else if yym1806 {
			z.DecBinaryUnmarshal(yyv1805)
		} else if !yym1806 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1805)
		} else {
			z.DecFallback(yyv1805, false)
		}
	}
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1807 := &x.LastTransitionTime
		yym1808 := z.DecBinary()
		_ = yym1808
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1807) {
		} else if yym1808 {
			z.DecBinaryUnmarshal(yyv1807)
		} else if !yym1808 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1807)
		} else {
			z.DecFallback(yyv1807, false)
		}
	}
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1802++
	if yyhl1802 {
		yyb1802 = yyj1802 > l
	} else {
		yyb1802 = r.CheckBreak()
	}
	if yyb1802 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1802++
		if yyhl1802 {
			yyb1802 = yyj1802 > l
		} else {
			yyb1802 = r.CheckBreak()
		}
		if yyb1802 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1802-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1811 := z.EncBinary()
	_ = yym1811
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1812 := z.DecBinary()
	_ = yym1812
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1813 := z.EncBinary()
		_ = yym1813
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1814 := !z.EncBinary()
			yy2arr1814 := z.EncBasicHandle().StructToArray
			var yyq1814 [4]bool
			_, _, _ = yysep1814, yyq1814, yy2arr1814
			const yyr1814 bool = false
			yyq1814[0] = x.Kind != ""
			yyq1814[1] = x.APIVersion != ""
			yyq1814[2] = true
			var yynn1814 int
			if yyr1814 || yy2arr1814 {
				r.EncodeArrayStart(4)
			} else {
				yynn1814 = 1
				for _, b := range yyq1814 {
					if b {
						yynn1814++
					}
				}
				r.EncodeMapStart(yynn1814)
				yynn1814 = 0
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1814[0] {
					yym1816 := z.EncBinary()
					_ = yym1816
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1814[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1817 := z.EncBinary()
					_ = yym1817
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1814[1] {
					yym1819 := z.EncBinary()
					_ = yym1819
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1814[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1820 := z.EncBinary()
					_ = yym1820
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1814[2] {
					yy1822 := &x.ListMeta
					yym1823 := z.EncBinary()
					_ = yym1823
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1822) {
					} else {
						z.EncFallback(yy1822)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1814[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1824 := &x.ListMeta
					yym1825 := z.EncBinary()
					_ = yym1825
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1824) {
					} else {
						z.EncFallback(yy1824)
					}
				}
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1827 := z.EncBinary()
					_ = yym1827
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1828 := z.EncBinary()
					_ = yym1828
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1829 := z.DecBinary()
	_ = yym1829
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1830 := r.ContainerType()
		if yyct1830 == codecSelferValueTypeMap1234 {
			yyl1830 := r.ReadMapStart()
			if yyl1830 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1830, d)
			}
		} else if yyct1830 == codecSelferValueTypeArray1234 {
			yyl1830 := r.ReadArrayStart()
			if yyl1830 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1830, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1831Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1831Slc
	var yyhl1831 bool = l >= 0
	for yyj1831 := 0; ; yyj1831++ {
		if yyhl1831 {
			if yyj1831 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1831Slc = r.DecodeBytes(yys1831Slc, true, true)
		yys1831 := string(yys1831Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1831 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1834 := &x.ListMeta
				yym1835 := z.DecBinary()
				_ = yym1835
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1834) {
				} else {
					z.DecFallback(yyv1834, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1836 := &x.Items
				yym1837 := z.DecBinary()
				_ = yym1837
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv1836), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1831)
		} // end switch yys1831
	} // end for yyj1831
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1838 int
	var yyb1838 bool
	var yyhl1838 bool = l >= 0
	yyj1838++
	if yyhl1838 {
		yyb1838 = yyj1838 > l
	} else {
		yyb1838 = r.CheckBreak()
	}
	if yyb1838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1838++
	if yyhl1838 {
		yyb1838 = yyj1838 > l
	} else {
		yyb1838 = r.CheckBreak()
	}
	if yyb1838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1838++
	if yyhl1838 {
		yyb1838 = yyj1838 > l
	} else {
		yyb1838 = r.CheckBreak()
	}
	if yyb1838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1841 := &x.ListMeta
		yym1842 := z.DecBinary()
		_ = yym1842
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1841) {
		} else {
			z.DecFallback(yyv1841, false)
		}
	}
	yyj1838++
	if yyhl1838 {
		yyb1838 = yyj1838 > l
	} else {
		yyb1838 = r.CheckBreak()
	}
	if yyb1838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1843 := &x.Items
		yym1844 := z.DecBinary()
		_ = yym1844
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv1843), d)
		}
	}
	for {
		yyj1838++
		if yyhl1838 {
			yyb1838 = yyj1838 > l
		} else {
			yyb1838 = r.CheckBreak()
		}
		if yyb1838 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1838-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1845 := z.EncBinary()
	_ = yym1845
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1846 := z.DecBinary()
	_ = yym1846
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1847 := z.EncBinary()
		_ = yym1847
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1848 := !z.EncBinary()
			yy2arr1848 := z.EncBasicHandle().StructToArray
			var yyq1848 [1]bool
			_, _, _ = yysep1848, yyq1848, yy2arr1848
			const yyr1848 bool = false
			var yynn1848 int
			if yyr1848 || yy2arr1848 {
				r.EncodeArrayStart(1)
			} else {
				yynn1848 = 1
				for _, b := range yyq1848 {
					if b {
						yynn1848++
					}
				}
				r.EncodeMapStart(yynn1848)
				yynn1848 = 0
			}
			if yyr1848 || yy2arr1848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1850 := z.EncBinary()
					_ = yym1850
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSelectorTerms"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1851 := z.EncBinary()
					_ = yym1851
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			}
			if yyr1848 || yy2arr1848 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1852 := z.DecBinary()
	_ = yym1852
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1853 := r.ContainerType()
		if yyct1853 == codecSelferValueTypeMap1234 {
			yyl1853 := r.ReadMapStart()
			if yyl1853 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1853, d)
			}
		} else if yyct1853 == codecSelferValueTypeArray1234 {
			yyl1853 := r.ReadArrayStart()
			if yyl1853 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1853, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1854Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1854Slc
	var yyhl1854 bool = l >= 0
	for yyj1854 := 0; ; yyj1854++ {
		if yyhl1854 {
			if yyj1854 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1854Slc = r.DecodeBytes(yys1854Slc, true, true)
		yys1854 := string(yys1854Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1854 {
		case "nodeSelectorTerms":
			if r.TryDecodeAsNil() {
				x.NodeSelectorTerms = nil
			} else {
				yyv1855 := &x.NodeSelectorTerms
				yym1856 := z.DecBinary()
				_ = yym1856
				if false {
				} else {
					h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1855), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1854)
		} // end switch yys1854
	} // end for yyj1854
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1857 int
	var yyb1857 bool
	var yyhl1857 bool = l >= 0
	yyj1857++
	if yyhl1857 {
		yyb1857 = yyj1857 > l
	} else {
		yyb1857 = r.CheckBreak()
	}
	if yyb1857 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelectorTerms = nil
	} else {
		yyv1858 := &x.NodeSelectorTerms
		yym1859 := z.DecBinary()
		_ = yym1859
		if false {
		} else {
			h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1858), d)
		}
	}
	for {
		yyj1857++
		if yyhl1857 {
			yyb1857 = yyj1857 > l
		} else {
			yyb1857 = r.CheckBreak()
		}
		if yyb1857 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1857-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1860 := z.EncBinary()
		_ = yym1860
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1861 := !z.EncBinary()
			yy2arr1861 := z.EncBasicHandle().StructToArray
			var yyq1861 [1]bool
			_, _, _ = yysep1861, yyq1861, yy2arr1861
			const yyr1861 bool = false
			var yynn1861 int
			if yyr1861 || yy2arr1861 {
				r.EncodeArrayStart(1)
			} else {
				yynn1861 = 1
				for _, b := range yyq1861 {
					if b {
						yynn1861++
					}
				}
				r.EncodeMapStart(yynn1861)
				yynn1861 = 0
			}
			if yyr1861 || yy2arr1861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1863 := z.EncBinary()
					_ = yym1863
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1864 := z.EncBinary()
					_ = yym1864
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			}
			if yyr1861 || yy2arr1861 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1865 := z.DecBinary()
	_ = yym1865
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1866 := r.ContainerType()
		if yyct1866 == codecSelferValueTypeMap1234 {
			yyl1866 := r.ReadMapStart()
			if yyl1866 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1866, d)
			}
		} else if yyct1866 == codecSelferValueTypeArray1234 {
			yyl1866 := r.ReadArrayStart()
			if yyl1866 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1866, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1867Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1867Slc
	var yyhl1867 bool = l >= 0
	for yyj1867 := 0; ; yyj1867++ {
		if yyhl1867 {
			if yyj1867 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1867Slc = r.DecodeBytes(yys1867Slc, true, true)
		yys1867 := string(yys1867Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1867 {
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1868 := &x.MatchExpressions
				yym1869 := z.DecBinary()
				_ = yym1869
				if false {
				} else {
					h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1868), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1867)
		} // end switch yys1867
	} // end for yyj1867
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1870 int
	var yyb1870 bool
	var yyhl1870 bool = l >= 0
	yyj1870++
	if yyhl1870 {
		yyb1870 = yyj1870 > l
	} else {
		yyb1870 = r.CheckBreak()
	}
	if yyb1870 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1871 := &x.MatchExpressions
		yym1872 := z.DecBinary()
		_ = yym1872
		if false {
		} else {
			h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1871), d)
		}
	}
	for {
		yyj1870++
		if yyhl1870 {
			yyb1870 = yyj1870 > l
		} else {
			yyb1870 = r.CheckBreak()
		}
		if yyb1870 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1870-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1873 := z.EncBinary()
		_ = yym1873
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1874 := !z.EncBinary()
			yy2arr1874 := z.EncBasicHandle().StructToArray
			var yyq1874 [3]bool
			_, _, _ = yysep1874, yyq1874, yy2arr1874
			const yyr1874 bool = false
			yyq1874[2] = len(x.Values) != 0
			var yynn1874 int
			if yyr1874 || yy2arr1874 {
				r.EncodeArrayStart(3)
			} else {
				yynn1874 = 2
				for _, b := range yyq1874 {
					if b {
						yynn1874++
					}
				}
				r.EncodeMapStart(yynn1874)
				yynn1874 = 0
			}
			if yyr1874 || yy2arr1874 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1876 := z.EncBinary()
				_ = yym1876
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1877 := z.EncBinary()
				_ = yym1877
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1874 || yy2arr1874 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1874 || yy2arr1874 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1874[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1880 := z.EncBinary()
						_ = yym1880
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1874[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1881 := z.EncBinary()
						_ = yym1881
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1874 || yy2arr1874 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1882 := z.DecBinary()
	_ = yym1882
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1883 := r.ContainerType()
		if yyct1883 == codecSelferValueTypeMap1234 {
			yyl1883 := r.ReadMapStart()
			if yyl1883 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1883, d)
			}
		} else if yyct1883 == codecSelferValueTypeArray1234 {
			yyl1883 := r.ReadArrayStart()
			if yyl1883 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1883, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1884Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1884Slc
	var yyhl1884 bool = l >= 0
	for yyj1884 := 0; ; yyj1884++ {
		if yyhl1884 {
			if yyj1884 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1884Slc = r.DecodeBytes(yys1884Slc, true, true)
		yys1884 := string(yys1884Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1884 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = NodeSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1887 := &x.Values
				yym1888 := z.DecBinary()
				_ = yym1888
				if false {
				} else {
					z.F.DecSliceStringX(yyv1887, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1884)
		} // end switch yys1884
	} // end for yyj1884
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1889 int
	var yyb1889 bool
	var yyhl1889 bool = l >= 0
	yyj1889++
	if yyhl1889 {
		yyb1889 = yyj1889 > l
	} else {
		yyb1889 = r.CheckBreak()
	}
	if yyb1889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1889++
	if yyhl1889 {
		yyb1889 = yyj1889 > l
	} else {
		yyb1889 = r.CheckBreak()
	}
	if yyb1889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = NodeSelectorOperator(r.DecodeString())
	}
	yyj1889++
	if yyhl1889 {
		yyb1889 = yyj1889 > l
	} else {
		yyb1889 = r.CheckBreak()
	}
	if yyb1889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1892 := &x.Values
		yym1893 := z.DecBinary()
		_ = yym1893
		if false {
		} else {
			z.F.DecSliceStringX(yyv1892, false, d)
		}
	}
	for {
		yyj1889++
		if yyhl1889 {
			yyb1889 = yyj1889 > l
		} else {
			yyb1889 = r.CheckBreak()
		}
		if yyb1889 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1889-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1894 := z.EncBinary()
	_ = yym1894
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1895 := z.DecBinary()
	_ = yym1895
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Affinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1896 := z.EncBinary()
		_ = yym1896
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1897 := !z.EncBinary()
			yy2arr1897 := z.EncBasicHandle().StructToArray
			var yyq1897 [3]bool
			_, _, _ = yysep1897, yyq1897, yy2arr1897
			const yyr1897 bool = false
			yyq1897[0] = x.NodeAffinity != nil
			yyq1897[1] = x.PodAffinity != nil
			yyq1897[2] = x.PodAntiAffinity != nil
			var yynn1897 int
			if yyr1897 || yy2arr1897 {
				r.EncodeArrayStart(3)
			} else {
				yynn1897 = 0
				for _, b := range yyq1897 {
					if b {
						yynn1897++
					}
				}
				r.EncodeMapStart(yynn1897)
				yynn1897 = 0
			}
			if yyr1897 || yy2arr1897 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1897[0] {
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1897[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1897 || yy2arr1897 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1897[1] {
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1897[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1897 || yy2arr1897 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1897[2] {
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1897[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAntiAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1897 || yy2arr1897 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Affinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1901 := z.DecBinary()
	_ = yym1901
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1902 := r.ContainerType()
		if yyct1902 == codecSelferValueTypeMap1234 {
			yyl1902 := r.ReadMapStart()
			if yyl1902 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1902, d)
			}
		} else if yyct1902 == codecSelferValueTypeArray1234 {
			yyl1902 := r.ReadArrayStart()
			if yyl1902 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1902, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Affinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1903Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1903Slc
	var yyhl1903 bool = l >= 0
	for yyj1903 := 0; ; yyj1903++ {
		if yyhl1903 {
			if yyj1903 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1903Slc = r.DecodeBytes(yys1903Slc, true, true)
		yys1903 := string(yys1903Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1903 {
		case "nodeAffinity":
			if r.TryDecodeAsNil() {
				if x.NodeAffinity != nil {
					x.NodeAffinity = nil
				}
			} else {
				if x.NodeAffinity == nil {
					x.NodeAffinity = new(NodeAffinity)
				}
				x.NodeAffinity.CodecDecodeSelf(d)
			}
		case "podAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAffinity != nil {
					x.PodAffinity = nil
				}
			} else {
				if x.PodAffinity == nil {
					x.PodAffinity = new(PodAffinity)
				}
				x.PodAffinity.CodecDecodeSelf(d)
			}
		case "podAntiAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAntiAffinity != nil {
					x.PodAntiAffinity = nil
				}
			} else {
				if x.PodAntiAffinity == nil {
					x.PodAntiAffinity = new(PodAntiAffinity)
				}
				x.PodAntiAffinity.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1903)
		} // end switch yys1903
	} // end for yyj1903
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Affinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1907 int
	var yyb1907 bool
	var yyhl1907 bool = l >= 0
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeAffinity != nil {
			x.NodeAffinity = nil
		}
	} else {
		if x.NodeAffinity == nil {
			x.NodeAffinity = new(NodeAffinity)
		}
		x.NodeAffinity.CodecDecodeSelf(d)
	}
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAffinity != nil {
			x.PodAffinity = nil
		}
	} else {
		if x.PodAffinity == nil {
			x.PodAffinity = new(PodAffinity)
		}
		x.PodAffinity.CodecDecodeSelf(d)
	}
	yyj1907++
	if yyhl1907 {
		yyb1907 = yyj1907 > l
	} else {
		yyb1907 = r.CheckBreak()
	}
	if yyb1907 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAntiAffinity != nil {
			x.PodAntiAffinity = nil
		}
	} else {
		if x.PodAntiAffinity == nil {
			x.PodAntiAffinity = new(PodAntiAffinity)
		}
		x.PodAntiAffinity.CodecDecodeSelf(d)
	}
	for {
		yyj1907++
		if yyhl1907 {
			yyb1907 = yyj1907 > l
		} else {
			yyb1907 = r.CheckBreak()
		}
		if yyb1907 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1907-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1911 := z.EncBinary()
		_ = yym1911
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1912 := !z.EncBinary()
			yy2arr1912 := z.EncBasicHandle().StructToArray
			var yyq1912 [2]bool
			_, _, _ = yysep1912, yyq1912, yy2arr1912
			const yyr1912 bool = false
			yyq1912[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1912[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1912 int
			if yyr1912 || yy2arr1912 {
				r.EncodeArrayStart(2)
			} else {
				yynn1912 = 0
				for _, b := range yyq1912 {
					if b {
						yynn1912++
					}
				}
				r.EncodeMapStart(yynn1912)
				yynn1912 = 0
			}
			if yyr1912 || yy2arr1912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1912[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1914 := z.EncBinary()
						_ = yym1914
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1912[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1915 := z.EncBinary()
						_ = yym1915
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1912 || yy2arr1912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1912[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1917 := z.EncBinary()
						_ = yym1917
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1912[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1918 := z.EncBinary()
						_ = yym1918
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1912 || yy2arr1912 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1919 := z.DecBinary()
	_ = yym1919
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1920 := r.ContainerType()
		if yyct1920 == codecSelferValueTypeMap1234 {
			yyl1920 := r.ReadMapStart()
			if yyl1920 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1920, d)
			}
		} else if yyct1920 == codecSelferValueTypeArray1234 {
			yyl1920 := r.ReadArrayStart()
			if yyl1920 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1920, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1921Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1921Slc
	var yyhl1921 bool = l >= 0
	for yyj1921 := 0; ; yyj1921++ {
		if yyhl1921 {
			if yyj1921 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1921Slc = r.DecodeBytes(yys1921Slc, true, true)
		yys1921 := string(yys1921Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1921 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1922 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1923 := z.DecBinary()
				_ = yym1923
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1922), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1924 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1925 := z.DecBinary()
				_ = yym1925
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1924), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1921)
		} // end switch yys1921
	} // end for yyj1921
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1926 int
	var yyb1926 bool
	var yyhl1926 bool = l >= 0
	yyj1926++
	if yyhl1926 {
		yyb1926 = yyj1926 > l
	} else {
		yyb1926 = r.CheckBreak()
	}
	if yyb1926 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1927 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1928 := z.DecBinary()
		_ = yym1928
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1927), d)
		}
	}
	yyj1926++
	if yyhl1926 {
		yyb1926 = yyj1926 > l
	} else {
		yyb1926 = r.CheckBreak()
	}
	if yyb1926 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1929 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1930 := z.DecBinary()
		_ = yym1930
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1929), d)
		}
	}
	for {
		yyj1926++
		if yyhl1926 {
			yyb1926 = yyj1926 > l
		} else {
			yyb1926 = r.CheckBreak()
		}
		if yyb1926 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1926-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAntiAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1931 := z.EncBinary()
		_ = yym1931
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1932 := !z.EncBinary()
			yy2arr1932 := z.EncBasicHandle().StructToArray
			var yyq1932 [2]bool
			_, _, _ = yysep1932, yyq1932, yy2arr1932
			const yyr1932 bool = false
			yyq1932[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1932[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1932 int
			if yyr1932 || yy2arr1932 {
				r.EncodeArrayStart(2)
			} else {
				yynn1932 = 0
				for _, b := range yyq1932 {
					if b {
						yynn1932++
					}
				}
				r.EncodeMapStart(yynn1932)
				yynn1932 = 0
			}
			if yyr1932 || yy2arr1932 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1932[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1934 := z.EncBinary()
						_ = yym1934
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1932[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1935 := z.EncBinary()
						_ = yym1935
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1932 || yy2arr1932 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1932[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1937 := z.EncBinary()
						_ = yym1937
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1932[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1938 := z.EncBinary()
						_ = yym1938
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1932 || yy2arr1932 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAntiAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1939 := z.DecBinary()
	_ = yym1939
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1940 := r.ContainerType()
		if yyct1940 == codecSelferValueTypeMap1234 {
			yyl1940 := r.ReadMapStart()
			if yyl1940 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1940, d)
			}
		} else if yyct1940 == codecSelferValueTypeArray1234 {
			yyl1940 := r.ReadArrayStart()
			if yyl1940 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1940, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAntiAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1941Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1941Slc
	var yyhl1941 bool = l >= 0
	for yyj1941 := 0; ; yyj1941++ {
		if yyhl1941 {
			if yyj1941 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1941Slc = r.DecodeBytes(yys1941Slc, true, true)
		yys1941 := string(yys1941Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1941 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1942 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1943 := z.DecBinary()
				_ = yym1943
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1942), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1944 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1945 := z.DecBinary()
				_ = yym1945
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1944), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1941)
		} // end switch yys1941
	} // end for yyj1941
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAntiAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1946 int
	var yyb1946 bool
	var yyhl1946 bool = l >= 0
	yyj1946++
	if yyhl1946 {
		yyb1946 = yyj1946 > l
	} else {
		yyb1946 = r.CheckBreak()
	}
	if yyb1946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1947 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1948 := z.DecBinary()
		_ = yym1948
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1947), d)
		}
	}
	yyj1946++
	if yyhl1946 {
		yyb1946 = yyj1946 > l
	} else {
		yyb1946 = r.CheckBreak()
	}
	if yyb1946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1949 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1950 := z.DecBinary()
		_ = yym1950
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1949), d)
		}
	}
	for {
		yyj1946++
		if yyhl1946 {
			yyb1946 = yyj1946 > l
		} else {
			yyb1946 = r.CheckBreak()
		}
		if yyb1946 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1946-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *WeightedPodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1951 := z.EncBinary()
		_ = yym1951
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1952 := !z.EncBinary()
			yy2arr1952 := z.EncBasicHandle().StructToArray
			var yyq1952 [2]bool
			_, _, _ = yysep1952, yyq1952, yy2arr1952
			const yyr1952 bool = false
			var yynn1952 int
			if yyr1952 || yy2arr1952 {
				r.EncodeArrayStart(2)
			} else {
				yynn1952 = 2
				for _, b := range yyq1952 {
					if b {
						yynn1952++
					}
				}
				r.EncodeMapStart(yynn1952)
				yynn1952 = 0
			}
			if yyr1952 || yy2arr1952 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1954 := z.EncBinary()
				_ = yym1954
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1955 := z.EncBinary()
				_ = yym1955
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1952 || yy2arr1952 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1957 := &x.PodAffinityTerm
				yy1957.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podAffinityTerm"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1958 := &x.PodAffinityTerm
				yy1958.CodecEncodeSelf(e)
			}
			if yyr1952 || yy2arr1952 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *WeightedPodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1959 := z.DecBinary()
	_ = yym1959
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1960 := r.ContainerType()
		if yyct1960 == codecSelferValueTypeMap1234 {
			yyl1960 := r.ReadMapStart()
			if yyl1960 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1960, d)
			}
		} else if yyct1960 == codecSelferValueTypeArray1234 {
			yyl1960 := r.ReadArrayStart()
			if yyl1960 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1960, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1961Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1961Slc
	var yyhl1961 bool = l >= 0
	for yyj1961 := 0; ; yyj1961++ {
		if yyhl1961 {
			if yyj1961 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1961Slc = r.DecodeBytes(yys1961Slc, true, true)
		yys1961 := string(yys1961Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1961 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "podAffinityTerm":
			if r.TryDecodeAsNil() {
				x.PodAffinityTerm = PodAffinityTerm{}
			} else {
				yyv1963 := &x.PodAffinityTerm
				yyv1963.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1961)
		} // end switch yys1961
	} // end for yyj1961
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1964 int
	var yyb1964 bool
	var yyhl1964 bool = l >= 0
	yyj1964++
	if yyhl1964 {
		yyb1964 = yyj1964 > l
	} else {
		yyb1964 = r.CheckBreak()
	}
	if yyb1964 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1964++
	if yyhl1964 {
		yyb1964 = yyj1964 > l
	} else {
		yyb1964 = r.CheckBreak()
	}
	if yyb1964 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodAffinityTerm = PodAffinityTerm{}
	} else {
		yyv1966 := &x.PodAffinityTerm
		yyv1966.CodecDecodeSelf(d)
	}
	for {
		yyj1964++
		if yyhl1964 {
			yyb1964 = yyj1964 > l
		} else {
			yyb1964 = r.CheckBreak()
		}
		if yyb1964 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1964-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1967 := z.EncBinary()
		_ = yym1967
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1968 := !z.EncBinary()
			yy2arr1968 := z.EncBasicHandle().StructToArray
			var yyq1968 [3]bool
			_, _, _ = yysep1968, yyq1968, yy2arr1968
			const yyr1968 bool = false
			yyq1968[0] = x.LabelSelector != nil
			yyq1968[2] = x.TopologyKey != ""
			var yynn1968 int
			if yyr1968 || yy2arr1968 {
				r.EncodeArrayStart(3)
			} else {
				yynn1968 = 1
				for _, b := range yyq1968 {
					if b {
						yynn1968++
					}
				}
				r.EncodeMapStart(yynn1968)
				yynn1968 = 0
			}
			if yyr1968 || yy2arr1968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1968[0] {
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1970 := z.EncBinary()
						_ = yym1970
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1968[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1971 := z.EncBinary()
						_ = yym1971
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				}
			}
			if yyr1968 || yy2arr1968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1973 := z.EncBinary()
					_ = yym1973
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaces"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1974 := z.EncBinary()
					_ = yym1974
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			}
			if yyr1968 || yy2arr1968 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1968[2] {
					yym1976 := z.EncBinary()
					_ = yym1976
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1968[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("topologyKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1977 := z.EncBinary()
					_ = yym1977
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				}
			}
			if yyr1968 || yy2arr1968 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1978 := z.DecBinary()
	_ = yym1978
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1979 := r.ContainerType()
		if yyct1979 == codecSelferValueTypeMap1234 {
			yyl1979 := r.ReadMapStart()
			if yyl1979 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1979, d)
			}
		} else if yyct1979 == codecSelferValueTypeArray1234 {
			yyl1979 := r.ReadArrayStart()
			if yyl1979 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1979, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1980Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1980Slc
	var yyhl1980 bool = l >= 0
	for yyj1980 := 0; ; yyj1980++ {
		if yyhl1980 {
			if yyj1980 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1980Slc = r.DecodeBytes(yys1980Slc, true, true)
		yys1980 := string(yys1980Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1980 {
		case "labelSelector":
			if r.TryDecodeAsNil() {
				if x.LabelSelector != nil {
					x.LabelSelector = nil
				}
			} else {
				if x.LabelSelector == nil {
					x.LabelSelector = new(pkg2_unversioned.LabelSelector)
				}
				yym1982 := z.DecBinary()
				_ = yym1982
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
				} else {
					z.DecFallback(x.LabelSelector, false)
				}
			}
		case "namespaces":
			if r.TryDecodeAsNil() {
				x.Namespaces = nil
			} else {
				yyv1983 := &x.Namespaces
				yym1984 := z.DecBinary()
				_ = yym1984
				if false {
				} else {
					z.F.DecSliceStringX(yyv1983, false, d)
				}
			}
		case "topologyKey":
			if r.TryDecodeAsNil() {
				x.TopologyKey = ""
			} else {
				x.TopologyKey = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1980)
		} // end switch yys1980
	} // end for yyj1980
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1986 int
	var yyb1986 bool
	var yyhl1986 bool = l >= 0
	yyj1986++
	if yyhl1986 {
		yyb1986 = yyj1986 > l
	} else {
		yyb1986 = r.CheckBreak()
	}
	if yyb1986 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LabelSelector != nil {
			x.LabelSelector = nil
		}
	} else {
		if x.LabelSelector == nil {
			x.LabelSelector = new(pkg2_unversioned.LabelSelector)
		}
		yym1988 := z.DecBinary()
		_ = yym1988
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
		} else {
			z.DecFallback(x.LabelSelector, false)
		}
	}
	yyj1986++
	if yyhl1986 {
		yyb1986 = yyj1986 > l
	} else {
		yyb1986 = r.CheckBreak()
	}
	if yyb1986 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespaces = nil
	} else {
		yyv1989 := &x.Namespaces
		yym1990 := z.DecBinary()
		_ = yym1990
		if false {
		} else {
			z.F.DecSliceStringX(yyv1989, false, d)
		}
	}
	yyj1986++
	if yyhl1986 {
		yyb1986 = yyj1986 > l
	} else {
		yyb1986 = r.CheckBreak()
	}
	if yyb1986 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TopologyKey = ""
	} else {
		x.TopologyKey = string(r.DecodeString())
	}
	for {
		yyj1986++
		if yyhl1986 {
			yyb1986 = yyj1986 > l
		} else {
			yyb1986 = r.CheckBreak()
		}
		if yyb1986 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1986-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1992 := z.EncBinary()
		_ = yym1992
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1993 := !z.EncBinary()
			yy2arr1993 := z.EncBasicHandle().StructToArray
			var yyq1993 [2]bool
			_, _, _ = yysep1993, yyq1993, yy2arr1993
			const yyr1993 bool = false
			yyq1993[0] = x.RequiredDuringSchedulingIgnoredDuringExecution != nil
			yyq1993[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1993 int
			if yyr1993 || yy2arr1993 {
				r.EncodeArrayStart(2)
			} else {
				yynn1993 = 0
				for _, b := range yyq1993 {
					if b {
						yynn1993++
					}
				}
				r.EncodeMapStart(yynn1993)
				yynn1993 = 0
			}
			if yyr1993 || yy2arr1993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1993[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1993[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1993 || yy2arr1993 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1993[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1996 := z.EncBinary()
						_ = yym1996
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1993[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1997 := z.EncBinary()
						_ = yym1997
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1993 || yy2arr1993 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1998 := z.DecBinary()
	_ = yym1998
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1999 := r.ContainerType()
		if yyct1999 == codecSelferValueTypeMap1234 {
			yyl1999 := r.ReadMapStart()
			if yyl1999 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1999, d)
			}
		} else if yyct1999 == codecSelferValueTypeArray1234 {
			yyl1999 := r.ReadArrayStart()
			if yyl1999 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1999, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2000Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2000Slc
	var yyhl2000 bool = l >= 0
	for yyj2000 := 0; ; yyj2000++ {
		if yyhl2000 {
			if yyj2000 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2000Slc = r.DecodeBytes(yys2000Slc, true, true)
		yys2000 := string(yys2000Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2000 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = nil
				}
			} else {
				if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
				}
				x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv2002 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym2003 := z.DecBinary()
				_ = yym2003
				if false {
				} else {
					h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv2002), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2000)
		} // end switch yys2000
	} // end for yyj2000
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2004 int
	var yyb2004 bool
	var yyhl2004 bool = l >= 0
	yyj2004++
	if yyhl2004 {
		yyb2004 = yyj2004 > l
	} else {
		yyb2004 = r.CheckBreak()
	}
	if yyb2004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
	} else {
		if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
		}
		x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
	}
	yyj2004++
	if yyhl2004 {
		yyb2004 = yyj2004 > l
	} else {
		yyb2004 = r.CheckBreak()
	}
	if yyb2004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv2006 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym2007 := z.DecBinary()
		_ = yym2007
		if false {
		} else {
			h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv2006), d)
		}
	}
	for {
		yyj2004++
		if yyhl2004 {
			yyb2004 = yyj2004 > l
		} else {
			yyb2004 = r.CheckBreak()
		}
		if yyb2004 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2004-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferredSchedulingTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2008 := z.EncBinary()
		_ = yym2008
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2009 := !z.EncBinary()
			yy2arr2009 := z.EncBasicHandle().StructToArray
			var yyq2009 [2]bool
			_, _, _ = yysep2009, yyq2009, yy2arr2009
			const yyr2009 bool = false
			var yynn2009 int
			if yyr2009 || yy2arr2009 {
				r.EncodeArrayStart(2)
			} else {
				yynn2009 = 2
				for _, b := range yyq2009 {
					if b {
						yynn2009++
					}
				}
				r.EncodeMapStart(yynn2009)
				yynn2009 = 0
			}
			if yyr2009 || yy2arr2009 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2011 := z.EncBinary()
				_ = yym2011
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2012 := z.EncBinary()
				_ = yym2012
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr2009 || yy2arr2009 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2014 := &x.Preference
				yy2014.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("preference"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2015 := &x.Preference
				yy2015.CodecEncodeSelf(e)
			}
			if yyr2009 || yy2arr2009 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferredSchedulingTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2016 := z.DecBinary()
	_ = yym2016
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2017 := r.ContainerType()
		if yyct2017 == codecSelferValueTypeMap1234 {
			yyl2017 := r.ReadMapStart()
			if yyl2017 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2017, d)
			}
		} else if yyct2017 == codecSelferValueTypeArray1234 {
			yyl2017 := r.ReadArrayStart()
			if yyl2017 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2017, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2018Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2018Slc
	var yyhl2018 bool = l >= 0
	for yyj2018 := 0; ; yyj2018++ {
		if yyhl2018 {
			if yyj2018 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2018Slc = r.DecodeBytes(yys2018Slc, true, true)
		yys2018 := string(yys2018Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2018 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "preference":
			if r.TryDecodeAsNil() {
				x.Preference = NodeSelectorTerm{}
			} else {
				yyv2020 := &x.Preference
				yyv2020.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2018)
		} // end switch yys2018
	} // end for yyj2018
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2021 int
	var yyb2021 bool
	var yyhl2021 bool = l >= 0
	yyj2021++
	if yyhl2021 {
		yyb2021 = yyj2021 > l
	} else {
		yyb2021 = r.CheckBreak()
	}
	if yyb2021 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj2021++
	if yyhl2021 {
		yyb2021 = yyj2021 > l
	} else {
		yyb2021 = r.CheckBreak()
	}
	if yyb2021 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Preference = NodeSelectorTerm{}
	} else {
		yyv2023 := &x.Preference
		yyv2023.CodecDecodeSelf(d)
	}
	for {
		yyj2021++
		if yyhl2021 {
			yyb2021 = yyj2021 > l
		} else {
			yyb2021 = r.CheckBreak()
		}
		if yyb2021 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2021-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Taint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2024 := z.EncBinary()
		_ = yym2024
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2025 := !z.EncBinary()
			yy2arr2025 := z.EncBasicHandle().StructToArray
			var yyq2025 [3]bool
			_, _, _ = yysep2025, yyq2025, yy2arr2025
			const yyr2025 bool = false
			yyq2025[1] = x.Value != ""
			var yynn2025 int
			if yyr2025 || yy2arr2025 {
				r.EncodeArrayStart(3)
			} else {
				yynn2025 = 2
				for _, b := range yyq2025 {
					if b {
						yynn2025++
					}
				}
				r.EncodeMapStart(yynn2025)
				yynn2025 = 0
			}
			if yyr2025 || yy2arr2025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2027 := z.EncBinary()
				_ = yym2027
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2028 := z.EncBinary()
				_ = yym2028
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2025 || yy2arr2025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2025[1] {
					yym2030 := z.EncBinary()
					_ = yym2030
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2025[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2031 := z.EncBinary()
					_ = yym2031
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2025 || yy2arr2025 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Effect.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("effect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Effect.CodecEncodeSelf(e)
			}
			if yyr2025 || yy2arr2025 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Taint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2033 := z.DecBinary()
	_ = yym2033
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2034 := r.ContainerType()
		if yyct2034 == codecSelferValueTypeMap1234 {
			yyl2034 := r.ReadMapStart()
			if yyl2034 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2034, d)
			}
		} else if yyct2034 == codecSelferValueTypeArray1234 {
			yyl2034 := r.ReadArrayStart()
			if yyl2034 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2034, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Taint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2035Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2035Slc
	var yyhl2035 bool = l >= 0
	for yyj2035 := 0; ; yyj2035++ {
		if yyhl2035 {
			if yyj2035 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2035Slc = r.DecodeBytes(yys2035Slc, true, true)
		yys2035 := string(yys2035Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2035 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2035)
		} // end switch yys2035
	} // end for yyj2035
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Taint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2039 int
	var yyb2039 bool
	var yyhl2039 bool = l >= 0
	yyj2039++
	if yyhl2039 {
		yyb2039 = yyj2039 > l
	} else {
		yyb2039 = r.CheckBreak()
	}
	if yyb2039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj2039++
	if yyhl2039 {
		yyb2039 = yyj2039 > l
	} else {
		yyb2039 = r.CheckBreak()
	}
	if yyb2039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj2039++
	if yyhl2039 {
		yyb2039 = yyj2039 > l
	} else {
		yyb2039 = r.CheckBreak()
	}
	if yyb2039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj2039++
		if yyhl2039 {
			yyb2039 = yyj2039 > l
		} else {
			yyb2039 = r.CheckBreak()
		}
		if yyb2039 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2039-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TaintEffect) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2043 := z.EncBinary()
	_ = yym2043
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TaintEffect) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2044 := z.DecBinary()
	_ = yym2044
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Toleration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2045 := z.EncBinary()
		_ = yym2045
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2046 := !z.EncBinary()
			yy2arr2046 := z.EncBasicHandle().StructToArray
			var yyq2046 [4]bool
			_, _, _ = yysep2046, yyq2046, yy2arr2046
			const yyr2046 bool = false
			yyq2046[0] = x.Key != ""
			yyq2046[1] = x.Operator != ""
			yyq2046[2] = x.Value != ""
			yyq2046[3] = x.Effect != ""
			var yynn2046 int
			if yyr2046 || yy2arr2046 {
				r.EncodeArrayStart(4)
			} else {
				yynn2046 = 0
				for _, b := range yyq2046 {
					if b {
						yynn2046++
					}
				}
				r.EncodeMapStart(yynn2046)
				yynn2046 = 0
			}
			if yyr2046 || yy2arr2046 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2046[0] {
					yym2048 := z.EncBinary()
					_ = yym2048
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2046[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("key"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2049 := z.EncBinary()
					_ = yym2049
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				}
			}
			if yyr2046 || yy2arr2046 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2046[1] {
					x.Operator.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2046[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("operator"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Operator.CodecEncodeSelf(e)
				}
			}
			if yyr2046 || yy2arr2046 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2046[2] {
					yym2052 := z.EncBinary()
					_ = yym2052
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2046[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2053 := z.EncBinary()
					_ = yym2053
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2046 || yy2arr2046 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2046[3] {
					x.Effect.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2046[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("effect"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Effect.CodecEncodeSelf(e)
				}
			}
			if yyr2046 || yy2arr2046 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Toleration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2055 := z.DecBinary()
	_ = yym2055
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2056 := r.ContainerType()
		if yyct2056 == codecSelferValueTypeMap1234 {
			yyl2056 := r.ReadMapStart()
			if yyl2056 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2056, d)
			}
		} else if yyct2056 == codecSelferValueTypeArray1234 {
			yyl2056 := r.ReadArrayStart()
			if yyl2056 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2056, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Toleration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2057Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2057Slc
	var yyhl2057 bool = l >= 0
	for yyj2057 := 0; ; yyj2057++ {
		if yyhl2057 {
			if yyj2057 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2057Slc = r.DecodeBytes(yys2057Slc, true, true)
		yys2057 := string(yys2057Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2057 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = TolerationOperator(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2057)
		} // end switch yys2057
	} // end for yyj2057
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Toleration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2062 int
	var yyb2062 bool
	var yyhl2062 bool = l >= 0
	yyj2062++
	if yyhl2062 {
		yyb2062 = yyj2062 > l
	} else {
		yyb2062 = r.CheckBreak()
	}
	if yyb2062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj2062++
	if yyhl2062 {
		yyb2062 = yyj2062 > l
	} else {
		yyb2062 = r.CheckBreak()
	}
	if yyb2062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = TolerationOperator(r.DecodeString())
	}
	yyj2062++
	if yyhl2062 {
		yyb2062 = yyj2062 > l
	} else {
		yyb2062 = r.CheckBreak()
	}
	if yyb2062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj2062++
	if yyhl2062 {
		yyb2062 = yyj2062 > l
	} else {
		yyb2062 = r.CheckBreak()
	}
	if yyb2062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj2062++
		if yyhl2062 {
			yyb2062 = yyj2062 > l
		} else {
			yyb2062 = r.CheckBreak()
		}
		if yyb2062 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2062-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TolerationOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2067 := z.EncBinary()
	_ = yym2067
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TolerationOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2068 := z.DecBinary()
	_ = yym2068
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2069 := z.EncBinary()
		_ = yym2069
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2070 := !z.EncBinary()
			yy2arr2070 := z.EncBasicHandle().StructToArray
			var yyq2070 [13]bool
			_, _, _ = yysep2070, yyq2070, yy2arr2070
			const yyr2070 bool = false
			yyq2070[2] = x.RestartPolicy != ""
			yyq2070[3] = x.TerminationGracePeriodSeconds != nil
			yyq2070[4] = x.ActiveDeadlineSeconds != nil
			yyq2070[5] = x.DNSPolicy != ""
			yyq2070[6] = len(x.NodeSelector) != 0
			yyq2070[8] = x.NodeName != ""
			yyq2070[9] = x.SecurityContext != nil
			yyq2070[10] = len(x.ImagePullSecrets) != 0
			yyq2070[11] = x.Hostname != ""
			yyq2070[12] = x.Subdomain != ""
			var yynn2070 int
			if yyr2070 || yy2arr2070 {
				r.EncodeArrayStart(13)
			} else {
				yynn2070 = 3
				for _, b := range yyq2070 {
					if b {
						yynn2070++
					}
				}
				r.EncodeMapStart(yynn2070)
				yynn2070 = 0
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym2072 := z.EncBinary()
					_ = yym2072
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym2073 := z.EncBinary()
					_ = yym2073
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2075 := z.EncBinary()
					_ = yym2075
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2076 := z.EncBinary()
					_ = yym2076
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2070[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2079 := *x.TerminationGracePeriodSeconds
						yym2080 := z.EncBinary()
						_ = yym2080
						if false {
						} else {
							r.EncodeInt(int64(yy2079))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2070[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2081 := *x.TerminationGracePeriodSeconds
						yym2082 := z.EncBinary()
						_ = yym2082
						if false {
						} else {
							r.EncodeInt(int64(yy2081))
						}
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2084 := *x.ActiveDeadlineSeconds
						yym2085 := z.EncBinary()
						_ = yym2085
						if false {
						} else {
							r.EncodeInt(int64(yy2084))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2070[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2086 := *x.ActiveDeadlineSeconds
						yym2087 := z.EncBinary()
						_ = yym2087
						if false {
						} else {
							r.EncodeInt(int64(yy2086))
						}
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2070[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2090 := z.EncBinary()
						_ = yym2090
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2070[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2091 := z.EncBinary()
						_ = yym2091
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2093 := z.EncBinary()
				_ = yym2093
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2094 := z.EncBinary()
				_ = yym2094
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[8] {
					yym2096 := z.EncBinary()
					_ = yym2096
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2070[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2097 := z.EncBinary()
					_ = yym2097
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[9] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2070[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[10] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2100 := z.EncBinary()
						_ = yym2100
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2070[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2101 := z.EncBinary()
						_ = yym2101
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[11] {
					yym2103 := z.EncBinary()
					_ = yym2103
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2070[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2104 := z.EncBinary()
					_ = yym2104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2070[12] {
					yym2106 := z.EncBinary()
					_ = yym2106
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2070[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subdomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2107 := z.EncBinary()
					_ = yym2107
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				}
			}
			if yyr2070 || yy2arr2070 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2108 := z.DecBinary()
	_ = yym2108
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2109 := r.ContainerType()
		if yyct2109 == codecSelferValueTypeMap1234 {
			yyl2109 := r.ReadMapStart()
			if yyl2109 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2109, d)
			}
		} else if yyct2109 == codecSelferValueTypeArray1234 {
			yyl2109 := r.ReadArrayStart()
			if yyl2109 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2109, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2110Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2110Slc
	var yyhl2110 bool = l >= 0
	for yyj2110 := 0; ; yyj2110++ {
		if yyhl2110 {
			if yyj2110 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2110Slc = r.DecodeBytes(yys2110Slc, true, true)
		yys2110 := string(yys2110Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2110 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv2111 := &x.Volumes
				yym2112 := z.DecBinary()
				_ = yym2112
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv2111), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv2113 := &x.Containers
				yym2114 := z.DecBinary()
				_ = yym2114
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv2113), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym2117 := z.DecBinary()
				_ = yym2117
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym2119 := z.DecBinary()
				_ = yym2119
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv2121 := &x.NodeSelector
				yym2122 := z.DecBinary()
				_ = yym2122
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2121, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2126 := &x.ImagePullSecrets
				yym2127 := z.DecBinary()
				_ = yym2127
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2126), d)
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "subdomain":
			if r.TryDecodeAsNil() {
				x.Subdomain = ""
			} else {
				x.Subdomain = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2110)
		} // end switch yys2110
	} // end for yyj2110
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2130 int
	var yyb2130 bool
	var yyhl2130 bool = l >= 0
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv2131 := &x.Volumes
		yym2132 := z.DecBinary()
		_ = yym2132
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv2131), d)
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv2133 := &x.Containers
		yym2134 := z.DecBinary()
		_ = yym2134
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv2133), d)
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym2137 := z.DecBinary()
		_ = yym2137
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym2139 := z.DecBinary()
		_ = yym2139
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv2141 := &x.NodeSelector
		yym2142 := z.DecBinary()
		_ = yym2142
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2141, false, d)
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2146 := &x.ImagePullSecrets
		yym2147 := z.DecBinary()
		_ = yym2147
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2146), d)
		}
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2130++
	if yyhl2130 {
		yyb2130 = yyj2130 > l
	} else {
		yyb2130 = r.CheckBreak()
	}
	if yyb2130 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subdomain = ""
	} else {
		x.Subdomain = string(r.DecodeString())
	}
	for {
		yyj2130++
		if yyhl2130 {
			yyb2130 = yyj2130 > l
		} else {
			yyb2130 = r.CheckBreak()
		}
		if yyb2130 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2130-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Sysctl) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2150 := z.EncBinary()
		_ = yym2150
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2151 := !z.EncBinary()
			yy2arr2151 := z.EncBasicHandle().StructToArray
			var yyq2151 [2]bool
			_, _, _ = yysep2151, yyq2151, yy2arr2151
			const yyr2151 bool = false
			var yynn2151 int
			if yyr2151 || yy2arr2151 {
				r.EncodeArrayStart(2)
			} else {
				yynn2151 = 2
				for _, b := range yyq2151 {
					if b {
						yynn2151++
					}
				}
				r.EncodeMapStart(yynn2151)
				yynn2151 = 0
			}
			if yyr2151 || yy2arr2151 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2153 := z.EncBinary()
				_ = yym2153
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2154 := z.EncBinary()
				_ = yym2154
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2151 || yy2arr2151 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2156 := z.EncBinary()
				_ = yym2156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2157 := z.EncBinary()
				_ = yym2157
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr2151 || yy2arr2151 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Sysctl) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2158 := z.DecBinary()
	_ = yym2158
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2159 := r.ContainerType()
		if yyct2159 == codecSelferValueTypeMap1234 {
			yyl2159 := r.ReadMapStart()
			if yyl2159 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2159, d)
			}
		} else if yyct2159 == codecSelferValueTypeArray1234 {
			yyl2159 := r.ReadArrayStart()
			if yyl2159 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2159, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Sysctl) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2160Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2160Slc
	var yyhl2160 bool = l >= 0
	for yyj2160 := 0; ; yyj2160++ {
		if yyhl2160 {
			if yyj2160 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2160Slc = r.DecodeBytes(yys2160Slc, true, true)
		yys2160 := string(yys2160Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2160 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2160)
		} // end switch yys2160
	} // end for yyj2160
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Sysctl) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2163 int
	var yyb2163 bool
	var yyhl2163 bool = l >= 0
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj2163++
		if yyhl2163 {
			yyb2163 = yyj2163 > l
		} else {
			yyb2163 = r.CheckBreak()
		}
		if yyb2163 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2163-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2166 := z.EncBinary()
		_ = yym2166
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2167 := !z.EncBinary()
			yy2arr2167 := z.EncBasicHandle().StructToArray
			var yyq2167 [8]bool
			_, _, _ = yysep2167, yyq2167, yy2arr2167
			const yyr2167 bool = false
			yyq2167[0] = x.HostNetwork != false
			yyq2167[1] = x.HostPID != false
			yyq2167[2] = x.HostIPC != false
			yyq2167[3] = x.SELinuxOptions != nil
			yyq2167[4] = x.RunAsUser != nil
			yyq2167[5] = x.RunAsNonRoot != nil
			yyq2167[6] = len(x.SupplementalGroups) != 0
			yyq2167[7] = x.FSGroup != nil
			var yynn2167 int
			if yyr2167 || yy2arr2167 {
				r.EncodeArrayStart(8)
			} else {
				yynn2167 = 0
				for _, b := range yyq2167 {
					if b {
						yynn2167++
					}
				}
				r.EncodeMapStart(yynn2167)
				yynn2167 = 0
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[0] {
					yym2169 := z.EncBinary()
					_ = yym2169
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2167[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2170 := z.EncBinary()
					_ = yym2170
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[1] {
					yym2172 := z.EncBinary()
					_ = yym2172
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2167[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2173 := z.EncBinary()
					_ = yym2173
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[2] {
					yym2175 := z.EncBinary()
					_ = yym2175
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2167[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2176 := z.EncBinary()
					_ = yym2176
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[3] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[4] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2179 := *x.RunAsUser
						yym2180 := z.EncBinary()
						_ = yym2180
						if false {
						} else {
							r.EncodeInt(int64(yy2179))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2181 := *x.RunAsUser
						yym2182 := z.EncBinary()
						_ = yym2182
						if false {
						} else {
							r.EncodeInt(int64(yy2181))
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[5] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2184 := *x.RunAsNonRoot
						yym2185 := z.EncBinary()
						_ = yym2185
						if false {
						} else {
							r.EncodeBool(bool(yy2184))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2186 := *x.RunAsNonRoot
						yym2187 := z.EncBinary()
						_ = yym2187
						if false {
						} else {
							r.EncodeBool(bool(yy2186))
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[6] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2189 := z.EncBinary()
						_ = yym2189
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2190 := z.EncBinary()
						_ = yym2190
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[7] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2192 := *x.FSGroup
						yym2193 := z.EncBinary()
						_ = yym2193
						if false {
						} else {
							r.EncodeInt(int64(yy2192))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2194 := *x.FSGroup
						yym2195 := z.EncBinary()
						_ = yym2195
						if false {
						} else {
							r.EncodeInt(int64(yy2194))
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2196 := z.DecBinary()
	_ = yym2196
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2197 := r.ContainerType()
		if yyct2197 == codecSelferValueTypeMap1234 {
			yyl2197 := r.ReadMapStart()
			if yyl2197 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2197, d)
			}
		} else if yyct2197 == codecSelferValueTypeArray1234 {
			yyl2197 := r.ReadArrayStart()
			if yyl2197 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2197, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2198Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2198Slc
	var yyhl2198 bool = l >= 0
	for yyj2198 := 0; ; yyj2198++ {
		if yyhl2198 {
			if yyj2198 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2198Slc = r.DecodeBytes(yys2198Slc, true, true)
		yys2198 := string(yys2198Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2198 {
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym2204 := z.DecBinary()
				_ = yym2204
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym2206 := z.DecBinary()
				_ = yym2206
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv2207 := &x.SupplementalGroups
				yym2208 := z.DecBinary()
				_ = yym2208
				if false {
				} else {
					z.F.DecSliceInt64X(yyv2207, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym2210 := z.DecBinary()
				_ = yym2210
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2198)
		} // end switch yys2198
	} // end for yyj2198
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2211 int
	var yyb2211 bool
	var yyhl2211 bool = l >= 0
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym2217 := z.DecBinary()
		_ = yym2217
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym2219 := z.DecBinary()
		_ = yym2219
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv2220 := &x.SupplementalGroups
		yym2221 := z.DecBinary()
		_ = yym2221
		if false {
		} else {
			z.F.DecSliceInt64X(yyv2220, false, d)
		}
	}
	yyj2211++
	if yyhl2211 {
		yyb2211 = yyj2211 > l
	} else {
		yyb2211 = r.CheckBreak()
	}
	if yyb2211 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym2223 := z.DecBinary()
		_ = yym2223
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2211++
		if yyhl2211 {
			yyb2211 = yyj2211 > l
		} else {
			yyb2211 = r.CheckBreak()
		}
		if yyb2211 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2211-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2224 := z.EncBinary()
		_ = yym2224
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2225 := !z.EncBinary()
			yy2arr2225 := z.EncBasicHandle().StructToArray
			var yyq2225 [8]bool
			_, _, _ = yysep2225, yyq2225, yy2arr2225
			const yyr2225 bool = false
			yyq2225[0] = x.Phase != ""
			yyq2225[1] = len(x.Conditions) != 0
			yyq2225[2] = x.Message != ""
			yyq2225[3] = x.Reason != ""
			yyq2225[4] = x.HostIP != ""
			yyq2225[5] = x.PodIP != ""
			yyq2225[6] = x.StartTime != nil
			yyq2225[7] = len(x.ContainerStatuses) != 0
			var yynn2225 int
			if yyr2225 || yy2arr2225 {
				r.EncodeArrayStart(8)
			} else {
				yynn2225 = 0
				for _, b := range yyq2225 {
					if b {
						yynn2225++
					}
				}
				r.EncodeMapStart(yynn2225)
				yynn2225 = 0
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2225[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2228 := z.EncBinary()
						_ = yym2228
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2225[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2229 := z.EncBinary()
						_ = yym2229
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[2] {
					yym2231 := z.EncBinary()
					_ = yym2231
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2225[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2232 := z.EncBinary()
					_ = yym2232
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[3] {
					yym2234 := z.EncBinary()
					_ = yym2234
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2225[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2235 := z.EncBinary()
					_ = yym2235
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[4] {
					yym2237 := z.EncBinary()
					_ = yym2237
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2225[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2238 := z.EncBinary()
					_ = yym2238
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[5] {
					yym2240 := z.EncBinary()
					_ = yym2240
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2225[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2241 := z.EncBinary()
					_ = yym2241
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2243 := z.EncBinary()
						_ = yym2243
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2243 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2243 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2225[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2244 := z.EncBinary()
						_ = yym2244
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2244 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2244 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2225[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2246 := z.EncBinary()
						_ = yym2246
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2225[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2247 := z.EncBinary()
						_ = yym2247
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr2225 || yy2arr2225 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2248 := z.DecBinary()
	_ = yym2248
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2249 := r.ContainerType()
		if yyct2249 == codecSelferValueTypeMap1234 {
			yyl2249 := r.ReadMapStart()
			if yyl2249 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2249, d)
			}
		} else if yyct2249 == codecSelferValueTypeArray1234 {
			yyl2249 := r.ReadArrayStart()
			if yyl2249 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2249, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2250Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2250Slc
	var yyhl2250 bool = l >= 0
	for yyj2250 := 0; ; yyj2250++ {
		if yyhl2250 {
			if yyj2250 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2250Slc = r.DecodeBytes(yys2250Slc, true, true)
		yys2250 := string(yys2250Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2250 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2252 := &x.Conditions
				yym2253 := z.DecBinary()
				_ = yym2253
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv2252), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym2259 := z.DecBinary()
				_ = yym2259
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym2259 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym2259 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv2260 := &x.ContainerStatuses
				yym2261 := z.DecBinary()
				_ = yym2261
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv2260), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2250)
		} // end switch yys2250
	} // end for yyj2250
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2262 int
	var yyb2262 bool
	var yyhl2262 bool = l >= 0
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2264 := &x.Conditions
		yym2265 := z.DecBinary()
		_ = yym2265
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv2264), d)
		}
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym2271 := z.DecBinary()
		_ = yym2271
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym2271 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym2271 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj2262++
	if yyhl2262 {
		yyb2262 = yyj2262 > l
	} else {
		yyb2262 = r.CheckBreak()
	}
	if yyb2262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv2272 := &x.ContainerStatuses
		yym2273 := z.DecBinary()
		_ = yym2273
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv2272), d)
		}
	}
	for {
		yyj2262++
		if yyhl2262 {
			yyb2262 = yyj2262 > l
		} else {
			yyb2262 = r.CheckBreak()
		}
		if yyb2262 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2262-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2274 := z.EncBinary()
		_ = yym2274
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2275 := !z.EncBinary()
			yy2arr2275 := z.EncBasicHandle().StructToArray
			var yyq2275 [4]bool
			_, _, _ = yysep2275, yyq2275, yy2arr2275
			const yyr2275 bool = false
			yyq2275[0] = x.Kind != ""
			yyq2275[1] = x.APIVersion != ""
			yyq2275[2] = true
			yyq2275[3] = true
			var yynn2275 int
			if yyr2275 || yy2arr2275 {
				r.EncodeArrayStart(4)
			} else {
				yynn2275 = 0
				for _, b := range yyq2275 {
					if b {
						yynn2275++
					}
				}
				r.EncodeMapStart(yynn2275)
				yynn2275 = 0
			}
			if yyr2275 || yy2arr2275 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2275[0] {
					yym2277 := z.EncBinary()
					_ = yym2277
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2275[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2278 := z.EncBinary()
					_ = yym2278
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2275 || yy2arr2275 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2275[1] {
					yym2280 := z.EncBinary()
					_ = yym2280
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2275[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2281 := z.EncBinary()
					_ = yym2281
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2275 || yy2arr2275 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2275[2] {
					yy2283 := &x.ObjectMeta
					yy2283.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2275[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2284 := &x.ObjectMeta
					yy2284.CodecEncodeSelf(e)
				}
			}
			if yyr2275 || yy2arr2275 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2275[3] {
					yy2286 := &x.Status
					yy2286.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2275[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2287 := &x.Status
					yy2287.CodecEncodeSelf(e)
				}
			}
			if yyr2275 || yy2arr2275 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2288 := z.DecBinary()
	_ = yym2288
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2289 := r.ContainerType()
		if yyct2289 == codecSelferValueTypeMap1234 {
			yyl2289 := r.ReadMapStart()
			if yyl2289 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2289, d)
			}
		} else if yyct2289 == codecSelferValueTypeArray1234 {
			yyl2289 := r.ReadArrayStart()
			if yyl2289 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2289, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2290Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2290Slc
	var yyhl2290 bool = l >= 0
	for yyj2290 := 0; ; yyj2290++ {
		if yyhl2290 {
			if yyj2290 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2290Slc = r.DecodeBytes(yys2290Slc, true, true)
		yys2290 := string(yys2290Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2290 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2293 := &x.ObjectMeta
				yyv2293.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2294 := &x.Status
				yyv2294.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2290)
		} // end switch yys2290
	} // end for yyj2290
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2295 int
	var yyb2295 bool
	var yyhl2295 bool = l >= 0
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2298 := &x.ObjectMeta
		yyv2298.CodecDecodeSelf(d)
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2299 := &x.Status
		yyv2299.CodecDecodeSelf(d)
	}
	for {
		yyj2295++
		if yyhl2295 {
			yyb2295 = yyj2295 > l
		} else {
			yyb2295 = r.CheckBreak()
		}
		if yyb2295 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2295-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2300 := z.EncBinary()
		_ = yym2300
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2301 := !z.EncBinary()
			yy2arr2301 := z.EncBasicHandle().StructToArray
			var yyq2301 [5]bool
			_, _, _ = yysep2301, yyq2301, yy2arr2301
			const yyr2301 bool = false
			yyq2301[0] = x.Kind != ""
			yyq2301[1] = x.APIVersion != ""
			yyq2301[2] = true
			yyq2301[3] = true
			yyq2301[4] = true
			var yynn2301 int
			if yyr2301 || yy2arr2301 {
				r.EncodeArrayStart(5)
			} else {
				yynn2301 = 0
				for _, b := range yyq2301 {
					if b {
						yynn2301++
					}
				}
				r.EncodeMapStart(yynn2301)
				yynn2301 = 0
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2301[0] {
					yym2303 := z.EncBinary()
					_ = yym2303
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2301[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2304 := z.EncBinary()
					_ = yym2304
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2301[1] {
					yym2306 := z.EncBinary()
					_ = yym2306
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2301[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2307 := z.EncBinary()
					_ = yym2307
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2301[2] {
					yy2309 := &x.ObjectMeta
					yy2309.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2301[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2310 := &x.ObjectMeta
					yy2310.CodecEncodeSelf(e)
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2301[3] {
					yy2312 := &x.Spec
					yy2312.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2301[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2313 := &x.Spec
					yy2313.CodecEncodeSelf(e)
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2301[4] {
					yy2315 := &x.Status
					yy2315.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2301[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2316 := &x.Status
					yy2316.CodecEncodeSelf(e)
				}
			}
			if yyr2301 || yy2arr2301 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2317 := z.DecBinary()
	_ = yym2317
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2318 := r.ContainerType()
		if yyct2318 == codecSelferValueTypeMap1234 {
			yyl2318 := r.ReadMapStart()
			if yyl2318 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2318, d)
			}
		} else if yyct2318 == codecSelferValueTypeArray1234 {
			yyl2318 := r.ReadArrayStart()
			if yyl2318 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2318, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2319Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2319Slc
	var yyhl2319 bool = l >= 0
	for yyj2319 := 0; ; yyj2319++ {
		if yyhl2319 {
			if yyj2319 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2319Slc = r.DecodeBytes(yys2319Slc, true, true)
		yys2319 := string(yys2319Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2319 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2322 := &x.ObjectMeta
				yyv2322.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2323 := &x.Spec
				yyv2323.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2324 := &x.Status
				yyv2324.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2319)
		} // end switch yys2319
	} // end for yyj2319
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2325 int
	var yyb2325 bool
	var yyhl2325 bool = l >= 0
	yyj2325++
	if yyhl2325 {
		yyb2325 = yyj2325 > l
	} else {
		yyb2325 = r.CheckBreak()
	}
	if yyb2325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2325++
	if yyhl2325 {
		yyb2325 = yyj2325 > l
	} else {
		yyb2325 = r.CheckBreak()
	}
	if yyb2325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2325++
	if yyhl2325 {
		yyb2325 = yyj2325 > l
	} else {
		yyb2325 = r.CheckBreak()
	}
	if yyb2325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2328 := &x.ObjectMeta
		yyv2328.CodecDecodeSelf(d)
	}
	yyj2325++
	if yyhl2325 {
		yyb2325 = yyj2325 > l
	} else {
		yyb2325 = r.CheckBreak()
	}
	if yyb2325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2329 := &x.Spec
		yyv2329.CodecDecodeSelf(d)
	}
	yyj2325++
	if yyhl2325 {
		yyb2325 = yyj2325 > l
	} else {
		yyb2325 = r.CheckBreak()
	}
	if yyb2325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2330 := &x.Status
		yyv2330.CodecDecodeSelf(d)
	}
	for {
		yyj2325++
		if yyhl2325 {
			yyb2325 = yyj2325 > l
		} else {
			yyb2325 = r.CheckBreak()
		}
		if yyb2325 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2325-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2331 := z.EncBinary()
		_ = yym2331
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2332 := !z.EncBinary()
			yy2arr2332 := z.EncBasicHandle().StructToArray
			var yyq2332 [2]bool
			_, _, _ = yysep2332, yyq2332, yy2arr2332
			const yyr2332 bool = false
			yyq2332[0] = true
			yyq2332[1] = true
			var yynn2332 int
			if yyr2332 || yy2arr2332 {
				r.EncodeArrayStart(2)
			} else {
				yynn2332 = 0
				for _, b := range yyq2332 {
					if b {
						yynn2332++
					}
				}
				r.EncodeMapStart(yynn2332)
				yynn2332 = 0
			}
			if yyr2332 || yy2arr2332 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2332[0] {
					yy2334 := &x.ObjectMeta
					yy2334.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2332[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2335 := &x.ObjectMeta
					yy2335.CodecEncodeSelf(e)
				}
			}
			if yyr2332 || yy2arr2332 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2332[1] {
					yy2337 := &x.Spec
					yy2337.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2332[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2338 := &x.Spec
					yy2338.CodecEncodeSelf(e)
				}
			}
			if yyr2332 || yy2arr2332 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2339 := z.DecBinary()
	_ = yym2339
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2340 := r.ContainerType()
		if yyct2340 == codecSelferValueTypeMap1234 {
			yyl2340 := r.ReadMapStart()
			if yyl2340 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2340, d)
			}
		} else if yyct2340 == codecSelferValueTypeArray1234 {
			yyl2340 := r.ReadArrayStart()
			if yyl2340 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2340, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2341Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2341Slc
	var yyhl2341 bool = l >= 0
	for yyj2341 := 0; ; yyj2341++ {
		if yyhl2341 {
			if yyj2341 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2341Slc = r.DecodeBytes(yys2341Slc, true, true)
		yys2341 := string(yys2341Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2341 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2342 := &x.ObjectMeta
				yyv2342.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2343 := &x.Spec
				yyv2343.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2341)
		} // end switch yys2341
	} // end for yyj2341
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2344 int
	var yyb2344 bool
	var yyhl2344 bool = l >= 0
	yyj2344++
	if yyhl2344 {
		yyb2344 = yyj2344 > l
	} else {
		yyb2344 = r.CheckBreak()
	}
	if yyb2344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2345 := &x.ObjectMeta
		yyv2345.CodecDecodeSelf(d)
	}
	yyj2344++
	if yyhl2344 {
		yyb2344 = yyj2344 > l
	} else {
		yyb2344 = r.CheckBreak()
	}
	if yyb2344 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2346 := &x.Spec
		yyv2346.CodecDecodeSelf(d)
	}
	for {
		yyj2344++
		if yyhl2344 {
			yyb2344 = yyj2344 > l
		} else {
			yyb2344 = r.CheckBreak()
		}
		if yyb2344 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2344-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2347 := z.EncBinary()
		_ = yym2347
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2348 := !z.EncBinary()
			yy2arr2348 := z.EncBasicHandle().StructToArray
			var yyq2348 [4]bool
			_, _, _ = yysep2348, yyq2348, yy2arr2348
			const yyr2348 bool = false
			yyq2348[0] = x.Kind != ""
			yyq2348[1] = x.APIVersion != ""
			yyq2348[2] = true
			yyq2348[3] = true
			var yynn2348 int
			if yyr2348 || yy2arr2348 {
				r.EncodeArrayStart(4)
			} else {
				yynn2348 = 0
				for _, b := range yyq2348 {
					if b {
						yynn2348++
					}
				}
				r.EncodeMapStart(yynn2348)
				yynn2348 = 0
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[0] {
					yym2350 := z.EncBinary()
					_ = yym2350
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2348[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2351 := z.EncBinary()
					_ = yym2351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[1] {
					yym2353 := z.EncBinary()
					_ = yym2353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2348[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2354 := z.EncBinary()
					_ = yym2354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[2] {
					yy2356 := &x.ObjectMeta
					yy2356.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2348[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2357 := &x.ObjectMeta
					yy2357.CodecEncodeSelf(e)
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[3] {
					yy2359 := &x.Template
					yy2359.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2348[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2360 := &x.Template
					yy2360.CodecEncodeSelf(e)
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2361 := z.DecBinary()
	_ = yym2361
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2362 := r.ContainerType()
		if yyct2362 == codecSelferValueTypeMap1234 {
			yyl2362 := r.ReadMapStart()
			if yyl2362 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2362, d)
			}
		} else if yyct2362 == codecSelferValueTypeArray1234 {
			yyl2362 := r.ReadArrayStart()
			if yyl2362 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2362, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2363Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2363Slc
	var yyhl2363 bool = l >= 0
	for yyj2363 := 0; ; yyj2363++ {
		if yyhl2363 {
			if yyj2363 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2363Slc = r.DecodeBytes(yys2363Slc, true, true)
		yys2363 := string(yys2363Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2363 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2366 := &x.ObjectMeta
				yyv2366.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv2367 := &x.Template
				yyv2367.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2363)
		} // end switch yys2363
	} // end for yyj2363
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2368 int
	var yyb2368 bool
	var yyhl2368 bool = l >= 0
	yyj2368++
	if yyhl2368 {
		yyb2368 = yyj2368 > l
	} else {
		yyb2368 = r.CheckBreak()
	}
	if yyb2368 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2368++
	if yyhl2368 {
		yyb2368 = yyj2368 > l
	} else {
		yyb2368 = r.CheckBreak()
	}
	if yyb2368 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2368++
	if yyhl2368 {
		yyb2368 = yyj2368 > l
	} else {
		yyb2368 = r.CheckBreak()
	}
	if yyb2368 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2371 := &x.ObjectMeta
		yyv2371.CodecDecodeSelf(d)
	}
	yyj2368++
	if yyhl2368 {
		yyb2368 = yyj2368 > l
	} else {
		yyb2368 = r.CheckBreak()
	}
	if yyb2368 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv2372 := &x.Template
		yyv2372.CodecDecodeSelf(d)
	}
	for {
		yyj2368++
		if yyhl2368 {
			yyb2368 = yyj2368 > l
		} else {
			yyb2368 = r.CheckBreak()
		}
		if yyb2368 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2368-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2373 := z.EncBinary()
		_ = yym2373
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2374 := !z.EncBinary()
			yy2arr2374 := z.EncBasicHandle().StructToArray
			var yyq2374 [4]bool
			_, _, _ = yysep2374, yyq2374, yy2arr2374
			const yyr2374 bool = false
			yyq2374[0] = x.Kind != ""
			yyq2374[1] = x.APIVersion != ""
			yyq2374[2] = true
			var yynn2374 int
			if yyr2374 || yy2arr2374 {
				r.EncodeArrayStart(4)
			} else {
				yynn2374 = 1
				for _, b := range yyq2374 {
					if b {
						yynn2374++
					}
				}
				r.EncodeMapStart(yynn2374)
				yynn2374 = 0
			}
			if yyr2374 || yy2arr2374 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2374[0] {
					yym2376 := z.EncBinary()
					_ = yym2376
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2374[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2377 := z.EncBinary()
					_ = yym2377
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2374 || yy2arr2374 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2374[1] {
					yym2379 := z.EncBinary()
					_ = yym2379
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2374[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2380 := z.EncBinary()
					_ = yym2380
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2374 || yy2arr2374 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2374[2] {
					yy2382 := &x.ListMeta
					yym2383 := z.EncBinary()
					_ = yym2383
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2382) {
					} else {
						z.EncFallback(yy2382)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2374[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2384 := &x.ListMeta
					yym2385 := z.EncBinary()
					_ = yym2385
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2384) {
					} else {
						z.EncFallback(yy2384)
					}
				}
			}
			if yyr2374 || yy2arr2374 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2387 := z.EncBinary()
					_ = yym2387
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2388 := z.EncBinary()
					_ = yym2388
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr2374 || yy2arr2374 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2389 := z.DecBinary()
	_ = yym2389
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2390 := r.ContainerType()
		if yyct2390 == codecSelferValueTypeMap1234 {
			yyl2390 := r.ReadMapStart()
			if yyl2390 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2390, d)
			}
		} else if yyct2390 == codecSelferValueTypeArray1234 {
			yyl2390 := r.ReadArrayStart()
			if yyl2390 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2390, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2391Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2391Slc
	var yyhl2391 bool = l >= 0
	for yyj2391 := 0; ; yyj2391++ {
		if yyhl2391 {
			if yyj2391 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2391Slc = r.DecodeBytes(yys2391Slc, true, true)
		yys2391 := string(yys2391Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2391 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2394 := &x.ListMeta
				yym2395 := z.DecBinary()
				_ = yym2395
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2394) {
				} else {
					z.DecFallback(yyv2394, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2396 := &x.Items
				yym2397 := z.DecBinary()
				_ = yym2397
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv2396), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2391)
		} // end switch yys2391
	} // end for yyj2391
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2398 int
	var yyb2398 bool
	var yyhl2398 bool = l >= 0
	yyj2398++
	if yyhl2398 {
		yyb2398 = yyj2398 > l
	} else {
		yyb2398 = r.CheckBreak()
	}
	if yyb2398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2398++
	if yyhl2398 {
		yyb2398 = yyj2398 > l
	} else {
		yyb2398 = r.CheckBreak()
	}
	if yyb2398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2398++
	if yyhl2398 {
		yyb2398 = yyj2398 > l
	} else {
		yyb2398 = r.CheckBreak()
	}
	if yyb2398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2401 := &x.ListMeta
		yym2402 := z.DecBinary()
		_ = yym2402
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2401) {
		} else {
			z.DecFallback(yyv2401, false)
		}
	}
	yyj2398++
	if yyhl2398 {
		yyb2398 = yyj2398 > l
	} else {
		yyb2398 = r.CheckBreak()
	}
	if yyb2398 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2403 := &x.Items
		yym2404 := z.DecBinary()
		_ = yym2404
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv2403), d)
		}
	}
	for {
		yyj2398++
		if yyhl2398 {
			yyb2398 = yyj2398 > l
		} else {
			yyb2398 = r.CheckBreak()
		}
		if yyb2398 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2398-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2405 := z.EncBinary()
		_ = yym2405
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2406 := !z.EncBinary()
			yy2arr2406 := z.EncBasicHandle().StructToArray
			var yyq2406 [3]bool
			_, _, _ = yysep2406, yyq2406, yy2arr2406
			const yyr2406 bool = false
			yyq2406[2] = x.Template != nil
			var yynn2406 int
			if yyr2406 || yy2arr2406 {
				r.EncodeArrayStart(3)
			} else {
				yynn2406 = 2
				for _, b := range yyq2406 {
					if b {
						yynn2406++
					}
				}
				r.EncodeMapStart(yynn2406)
				yynn2406 = 0
			}
			if yyr2406 || yy2arr2406 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2408 := z.EncBinary()
				_ = yym2408
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2409 := z.EncBinary()
				_ = yym2409
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2406 || yy2arr2406 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2411 := z.EncBinary()
					_ = yym2411
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2412 := z.EncBinary()
					_ = yym2412
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr2406 || yy2arr2406 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2406[2] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2406[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2406 || yy2arr2406 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2414 := z.DecBinary()
	_ = yym2414
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2415 := r.ContainerType()
		if yyct2415 == codecSelferValueTypeMap1234 {
			yyl2415 := r.ReadMapStart()
			if yyl2415 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2415, d)
			}
		} else if yyct2415 == codecSelferValueTypeArray1234 {
			yyl2415 := r.ReadArrayStart()
			if yyl2415 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2415, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2416Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2416Slc
	var yyhl2416 bool = l >= 0
	for yyj2416 := 0; ; yyj2416++ {
		if yyhl2416 {
			if yyj2416 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2416Slc = r.DecodeBytes(yys2416Slc, true, true)
		yys2416 := string(yys2416Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2416 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2418 := &x.Selector
				yym2419 := z.DecBinary()
				_ = yym2419
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2418, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2416)
		} // end switch yys2416
	} // end for yyj2416
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2421 int
	var yyb2421 bool
	var yyhl2421 bool = l >= 0
	yyj2421++
	if yyhl2421 {
		yyb2421 = yyj2421 > l
	} else {
		yyb2421 = r.CheckBreak()
	}
	if yyb2421 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2421++
	if yyhl2421 {
		yyb2421 = yyj2421 > l
	} else {
		yyb2421 = r.CheckBreak()
	}
	if yyb2421 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2423 := &x.Selector
		yym2424 := z.DecBinary()
		_ = yym2424
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2423, false, d)
		}
	}
	yyj2421++
	if yyhl2421 {
		yyb2421 = yyj2421 > l
	} else {
		yyb2421 = r.CheckBreak()
	}
	if yyb2421 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj2421++
		if yyhl2421 {
			yyb2421 = yyj2421 > l
		} else {
			yyb2421 = r.CheckBreak()
		}
		if yyb2421 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2421-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2426 := z.EncBinary()
		_ = yym2426
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2427 := !z.EncBinary()
			yy2arr2427 := z.EncBasicHandle().StructToArray
			var yyq2427 [4]bool
			_, _, _ = yysep2427, yyq2427, yy2arr2427
			const yyr2427 bool = false
			yyq2427[1] = x.FullyLabeledReplicas != 0
			yyq2427[2] = x.ReadyReplicas != 0
			yyq2427[3] = x.ObservedGeneration != 0
			var yynn2427 int
			if yyr2427 || yy2arr2427 {
				r.EncodeArrayStart(4)
			} else {
				yynn2427 = 1
				for _, b := range yyq2427 {
					if b {
						yynn2427++
					}
				}
				r.EncodeMapStart(yynn2427)
				yynn2427 = 0
			}
			if yyr2427 || yy2arr2427 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2429 := z.EncBinary()
				_ = yym2429
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2430 := z.EncBinary()
				_ = yym2430
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2427 || yy2arr2427 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2427[1] {
					yym2432 := z.EncBinary()
					_ = yym2432
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2427[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2433 := z.EncBinary()
					_ = yym2433
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr2427 || yy2arr2427 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2427[2] {
					yym2435 := z.EncBinary()
					_ = yym2435
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2427[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2436 := z.EncBinary()
					_ = yym2436
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr2427 || yy2arr2427 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2427[3] {
					yym2438 := z.EncBinary()
					_ = yym2438
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2427[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2439 := z.EncBinary()
					_ = yym2439
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr2427 || yy2arr2427 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2440 := z.DecBinary()
	_ = yym2440
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2441 := r.ContainerType()
		if yyct2441 == codecSelferValueTypeMap1234 {
			yyl2441 := r.ReadMapStart()
			if yyl2441 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2441, d)
			}
		} else if yyct2441 == codecSelferValueTypeArray1234 {
			yyl2441 := r.ReadArrayStart()
			if yyl2441 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2441, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2442Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2442Slc
	var yyhl2442 bool = l >= 0
	for yyj2442 := 0; ; yyj2442++ {
		if yyhl2442 {
			if yyj2442 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2442Slc = r.DecodeBytes(yys2442Slc, true, true)
		yys2442 := string(yys2442Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2442 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2442)
		} // end switch yys2442
	} // end for yyj2442
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2447 int
	var yyb2447 bool
	var yyhl2447 bool = l >= 0
	yyj2447++
	if yyhl2447 {
		yyb2447 = yyj2447 > l
	} else {
		yyb2447 = r.CheckBreak()
	}
	if yyb2447 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2447++
	if yyhl2447 {
		yyb2447 = yyj2447 > l
	} else {
		yyb2447 = r.CheckBreak()
	}
	if yyb2447 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj2447++
	if yyhl2447 {
		yyb2447 = yyj2447 > l
	} else {
		yyb2447 = r.CheckBreak()
	}
	if yyb2447 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj2447++
	if yyhl2447 {
		yyb2447 = yyj2447 > l
	} else {
		yyb2447 = r.CheckBreak()
	}
	if yyb2447 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj2447++
		if yyhl2447 {
			yyb2447 = yyj2447 > l
		} else {
			yyb2447 = r.CheckBreak()
		}
		if yyb2447 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2447-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2452 := z.EncBinary()
		_ = yym2452
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2453 := !z.EncBinary()
			yy2arr2453 := z.EncBasicHandle().StructToArray
			var yyq2453 [5]bool
			_, _, _ = yysep2453, yyq2453, yy2arr2453
			const yyr2453 bool = false
			yyq2453[0] = x.Kind != ""
			yyq2453[1] = x.APIVersion != ""
			yyq2453[2] = true
			yyq2453[3] = true
			yyq2453[4] = true
			var yynn2453 int
			if yyr2453 || yy2arr2453 {
				r.EncodeArrayStart(5)
			} else {
				yynn2453 = 0
				for _, b := range yyq2453 {
					if b {
						yynn2453++
					}
				}
				r.EncodeMapStart(yynn2453)
				yynn2453 = 0
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2453[0] {
					yym2455 := z.EncBinary()
					_ = yym2455
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2453[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2456 := z.EncBinary()
					_ = yym2456
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2453[1] {
					yym2458 := z.EncBinary()
					_ = yym2458
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2453[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2459 := z.EncBinary()
					_ = yym2459
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2453[2] {
					yy2461 := &x.ObjectMeta
					yy2461.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2453[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2462 := &x.ObjectMeta
					yy2462.CodecEncodeSelf(e)
				}
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2453[3] {
					yy2464 := &x.Spec
					yy2464.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2453[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2465 := &x.Spec
					yy2465.CodecEncodeSelf(e)
				}
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2453[4] {
					yy2467 := &x.Status
					yy2467.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2453[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2468 := &x.Status
					yy2468.CodecEncodeSelf(e)
				}
			}
			if yyr2453 || yy2arr2453 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2469 := z.DecBinary()
	_ = yym2469
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2470 := r.ContainerType()
		if yyct2470 == codecSelferValueTypeMap1234 {
			yyl2470 := r.ReadMapStart()
			if yyl2470 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2470, d)
			}
		} else if yyct2470 == codecSelferValueTypeArray1234 {
			yyl2470 := r.ReadArrayStart()
			if yyl2470 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2470, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2471Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2471Slc
	var yyhl2471 bool = l >= 0
	for yyj2471 := 0; ; yyj2471++ {
		if yyhl2471 {
			if yyj2471 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2471Slc = r.DecodeBytes(yys2471Slc, true, true)
		yys2471 := string(yys2471Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2471 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2474 := &x.ObjectMeta
				yyv2474.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv2475 := &x.Spec
				yyv2475.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv2476 := &x.Status
				yyv2476.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2471)
		} // end switch yys2471
	} // end for yyj2471
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2477 int
	var yyb2477 bool
	var yyhl2477 bool = l >= 0
	yyj2477++
	if yyhl2477 {
		yyb2477 = yyj2477 > l
	} else {
		yyb2477 = r.CheckBreak()
	}
	if yyb2477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2477++
	if yyhl2477 {
		yyb2477 = yyj2477 > l
	} else {
		yyb2477 = r.CheckBreak()
	}
	if yyb2477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2477++
	if yyhl2477 {
		yyb2477 = yyj2477 > l
	} else {
		yyb2477 = r.CheckBreak()
	}
	if yyb2477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2480 := &x.ObjectMeta
		yyv2480.CodecDecodeSelf(d)
	}
	yyj2477++
	if yyhl2477 {
		yyb2477 = yyj2477 > l
	} else {
		yyb2477 = r.CheckBreak()
	}
	if yyb2477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv2481 := &x.Spec
		yyv2481.CodecDecodeSelf(d)
	}
	yyj2477++
	if yyhl2477 {
		yyb2477 = yyj2477 > l
	} else {
		yyb2477 = r.CheckBreak()
	}
	if yyb2477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv2482 := &x.Status
		yyv2482.CodecDecodeSelf(d)
	}
	for {
		yyj2477++
		if yyhl2477 {
			yyb2477 = yyj2477 > l
		} else {
			yyb2477 = r.CheckBreak()
		}
		if yyb2477 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2477-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2483 := z.EncBinary()
		_ = yym2483
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2484 := !z.EncBinary()
			yy2arr2484 := z.EncBasicHandle().StructToArray
			var yyq2484 [4]bool
			_, _, _ = yysep2484, yyq2484, yy2arr2484
			const yyr2484 bool = false
			yyq2484[0] = x.Kind != ""
			yyq2484[1] = x.APIVersion != ""
			yyq2484[2] = true
			var yynn2484 int
			if yyr2484 || yy2arr2484 {
				r.EncodeArrayStart(4)
			} else {
				yynn2484 = 1
				for _, b := range yyq2484 {
					if b {
						yynn2484++
					}
				}
				r.EncodeMapStart(yynn2484)
				yynn2484 = 0
			}
			if yyr2484 || yy2arr2484 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2484[0] {
					yym2486 := z.EncBinary()
					_ = yym2486
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2484[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2487 := z.EncBinary()
					_ = yym2487
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2484 || yy2arr2484 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2484[1] {
					yym2489 := z.EncBinary()
					_ = yym2489
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2484[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2490 := z.EncBinary()
					_ = yym2490
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2484 || yy2arr2484 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2484[2] {
					yy2492 := &x.ListMeta
					yym2493 := z.EncBinary()
					_ = yym2493
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2492) {
					} else {
						z.EncFallback(yy2492)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2484[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2494 := &x.ListMeta
					yym2495 := z.EncBinary()
					_ = yym2495
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2494) {
					} else {
						z.EncFallback(yy2494)
					}
				}
			}
			if yyr2484 || yy2arr2484 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2497 := z.EncBinary()
					_ = yym2497
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2498 := z.EncBinary()
					_ = yym2498
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr2484 || yy2arr2484 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2499 := z.DecBinary()
	_ = yym2499
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2500 := r.ContainerType()
		if yyct2500 == codecSelferValueTypeMap1234 {
			yyl2500 := r.ReadMapStart()
			if yyl2500 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2500, d)
			}
		} else if yyct2500 == codecSelferValueTypeArray1234 {
			yyl2500 := r.ReadArrayStart()
			if yyl2500 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2500, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2501Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2501Slc
	var yyhl2501 bool = l >= 0
	for yyj2501 := 0; ; yyj2501++ {
		if yyhl2501 {
			if yyj2501 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2501Slc = r.DecodeBytes(yys2501Slc, true, true)
		yys2501 := string(yys2501Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2501 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2504 := &x.ListMeta
				yym2505 := z.DecBinary()
				_ = yym2505
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2504) {
				} else {
					z.DecFallback(yyv2504, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2506 := &x.Items
				yym2507 := z.DecBinary()
				_ = yym2507
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv2506), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2501)
		} // end switch yys2501
	} // end for yyj2501
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2508 int
	var yyb2508 bool
	var yyhl2508 bool = l >= 0
	yyj2508++
	if yyhl2508 {
		yyb2508 = yyj2508 > l
	} else {
		yyb2508 = r.CheckBreak()
	}
	if yyb2508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2508++
	if yyhl2508 {
		yyb2508 = yyj2508 > l
	} else {
		yyb2508 = r.CheckBreak()
	}
	if yyb2508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2508++
	if yyhl2508 {
		yyb2508 = yyj2508 > l
	} else {
		yyb2508 = r.CheckBreak()
	}
	if yyb2508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2511 := &x.ListMeta
		yym2512 := z.DecBinary()
		_ = yym2512
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2511) {
		} else {
			z.DecFallback(yyv2511, false)
		}
	}
	yyj2508++
	if yyhl2508 {
		yyb2508 = yyj2508 > l
	} else {
		yyb2508 = r.CheckBreak()
	}
	if yyb2508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2513 := &x.Items
		yym2514 := z.DecBinary()
		_ = yym2514
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv2513), d)
		}
	}
	for {
		yyj2508++
		if yyhl2508 {
			yyb2508 = yyj2508 > l
		} else {
			yyb2508 = r.CheckBreak()
		}
		if yyb2508 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2508-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2515 := z.EncBinary()
		_ = yym2515
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2516 := !z.EncBinary()
			yy2arr2516 := z.EncBasicHandle().StructToArray
			var yyq2516 [4]bool
			_, _, _ = yysep2516, yyq2516, yy2arr2516
			const yyr2516 bool = false
			yyq2516[0] = x.Kind != ""
			yyq2516[1] = x.APIVersion != ""
			yyq2516[2] = true
			var yynn2516 int
			if yyr2516 || yy2arr2516 {
				r.EncodeArrayStart(4)
			} else {
				yynn2516 = 1
				for _, b := range yyq2516 {
					if b {
						yynn2516++
					}
				}
				r.EncodeMapStart(yynn2516)
				yynn2516 = 0
			}
			if yyr2516 || yy2arr2516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2516[0] {
					yym2518 := z.EncBinary()
					_ = yym2518
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2516[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2519 := z.EncBinary()
					_ = yym2519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2516 || yy2arr2516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2516[1] {
					yym2521 := z.EncBinary()
					_ = yym2521
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2516[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2522 := z.EncBinary()
					_ = yym2522
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2516 || yy2arr2516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2516[2] {
					yy2524 := &x.ListMeta
					yym2525 := z.EncBinary()
					_ = yym2525
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2524) {
					} else {
						z.EncFallback(yy2524)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2516[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2526 := &x.ListMeta
					yym2527 := z.EncBinary()
					_ = yym2527
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2526) {
					} else {
						z.EncFallback(yy2526)
					}
				}
			}
			if yyr2516 || yy2arr2516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2529 := z.EncBinary()
					_ = yym2529
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2530 := z.EncBinary()
					_ = yym2530
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2516 || yy2arr2516 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2531 := z.DecBinary()
	_ = yym2531
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2532 := r.ContainerType()
		if yyct2532 == codecSelferValueTypeMap1234 {
			yyl2532 := r.ReadMapStart()
			if yyl2532 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2532, d)
			}
		} else if yyct2532 == codecSelferValueTypeArray1234 {
			yyl2532 := r.ReadArrayStart()
			if yyl2532 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2532, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2533Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2533Slc
	var yyhl2533 bool = l >= 0
	for yyj2533 := 0; ; yyj2533++ {
		if yyhl2533 {
			if yyj2533 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2533Slc = r.DecodeBytes(yys2533Slc, true, true)
		yys2533 := string(yys2533Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2533 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2536 := &x.ListMeta
				yym2537 := z.DecBinary()
				_ = yym2537
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2536) {
				} else {
					z.DecFallback(yyv2536, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2538 := &x.Items
				yym2539 := z.DecBinary()
				_ = yym2539
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv2538), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2533)
		} // end switch yys2533
	} // end for yyj2533
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2540 int
	var yyb2540 bool
	var yyhl2540 bool = l >= 0
	yyj2540++
	if yyhl2540 {
		yyb2540 = yyj2540 > l
	} else {
		yyb2540 = r.CheckBreak()
	}
	if yyb2540 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2540++
	if yyhl2540 {
		yyb2540 = yyj2540 > l
	} else {
		yyb2540 = r.CheckBreak()
	}
	if yyb2540 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2540++
	if yyhl2540 {
		yyb2540 = yyj2540 > l
	} else {
		yyb2540 = r.CheckBreak()
	}
	if yyb2540 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2543 := &x.ListMeta
		yym2544 := z.DecBinary()
		_ = yym2544
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2543) {
		} else {
			z.DecFallback(yyv2543, false)
		}
	}
	yyj2540++
	if yyhl2540 {
		yyb2540 = yyj2540 > l
	} else {
		yyb2540 = r.CheckBreak()
	}
	if yyb2540 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2545 := &x.Items
		yym2546 := z.DecBinary()
		_ = yym2546
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv2545), d)
		}
	}
	for {
		yyj2540++
		if yyhl2540 {
			yyb2540 = yyj2540 > l
		} else {
			yyb2540 = r.CheckBreak()
		}
		if yyb2540 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2540-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2547 := z.EncBinary()
	_ = yym2547
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2548 := z.DecBinary()
	_ = yym2548
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2549 := z.EncBinary()
	_ = yym2549
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2550 := z.DecBinary()
	_ = yym2550
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2551 := z.EncBinary()
		_ = yym2551
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2552 := !z.EncBinary()
			yy2arr2552 := z.EncBasicHandle().StructToArray
			var yyq2552 [1]bool
			_, _, _ = yysep2552, yyq2552, yy2arr2552
			const yyr2552 bool = false
			yyq2552[0] = true
			var yynn2552 int
			if yyr2552 || yy2arr2552 {
				r.EncodeArrayStart(1)
			} else {
				yynn2552 = 0
				for _, b := range yyq2552 {
					if b {
						yynn2552++
					}
				}
				r.EncodeMapStart(yynn2552)
				yynn2552 = 0
			}
			if yyr2552 || yy2arr2552 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2552[0] {
					yy2554 := &x.LoadBalancer
					yy2554.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2552[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2555 := &x.LoadBalancer
					yy2555.CodecEncodeSelf(e)
				}
			}
			if yyr2552 || yy2arr2552 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2556 := z.DecBinary()
	_ = yym2556
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2557 := r.ContainerType()
		if yyct2557 == codecSelferValueTypeMap1234 {
			yyl2557 := r.ReadMapStart()
			if yyl2557 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2557, d)
			}
		} else if yyct2557 == codecSelferValueTypeArray1234 {
			yyl2557 := r.ReadArrayStart()
			if yyl2557 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2557, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2558Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2558Slc
	var yyhl2558 bool = l >= 0
	for yyj2558 := 0; ; yyj2558++ {
		if yyhl2558 {
			if yyj2558 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2558Slc = r.DecodeBytes(yys2558Slc, true, true)
		yys2558 := string(yys2558Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2558 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv2559 := &x.LoadBalancer
				yyv2559.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2558)
		} // end switch yys2558
	} // end for yyj2558
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2560 int
	var yyb2560 bool
	var yyhl2560 bool = l >= 0
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv2561 := &x.LoadBalancer
		yyv2561.CodecDecodeSelf(d)
	}
	for {
		yyj2560++
		if yyhl2560 {
			yyb2560 = yyj2560 > l
		} else {
			yyb2560 = r.CheckBreak()
		}
		if yyb2560 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2560-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2562 := z.EncBinary()
		_ = yym2562
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2563 := !z.EncBinary()
			yy2arr2563 := z.EncBasicHandle().StructToArray
			var yyq2563 [1]bool
			_, _, _ = yysep2563, yyq2563, yy2arr2563
			const yyr2563 bool = false
			yyq2563[0] = len(x.Ingress) != 0
			var yynn2563 int
			if yyr2563 || yy2arr2563 {
				r.EncodeArrayStart(1)
			} else {
				yynn2563 = 0
				for _, b := range yyq2563 {
					if b {
						yynn2563++
					}
				}
				r.EncodeMapStart(yynn2563)
				yynn2563 = 0
			}
			if yyr2563 || yy2arr2563 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2563[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2565 := z.EncBinary()
						_ = yym2565
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2563[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2566 := z.EncBinary()
						_ = yym2566
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr2563 || yy2arr2563 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2567 := z.DecBinary()
	_ = yym2567
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2568 := r.ContainerType()
		if yyct2568 == codecSelferValueTypeMap1234 {
			yyl2568 := r.ReadMapStart()
			if yyl2568 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2568, d)
			}
		} else if yyct2568 == codecSelferValueTypeArray1234 {
			yyl2568 := r.ReadArrayStart()
			if yyl2568 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2568, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2569Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2569Slc
	var yyhl2569 bool = l >= 0
	for yyj2569 := 0; ; yyj2569++ {
		if yyhl2569 {
			if yyj2569 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2569Slc = r.DecodeBytes(yys2569Slc, true, true)
		yys2569 := string(yys2569Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2569 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv2570 := &x.Ingress
				yym2571 := z.DecBinary()
				_ = yym2571
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2570), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2569)
		} // end switch yys2569
	} // end for yyj2569
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2572 int
	var yyb2572 bool
	var yyhl2572 bool = l >= 0
	yyj2572++
	if yyhl2572 {
		yyb2572 = yyj2572 > l
	} else {
		yyb2572 = r.CheckBreak()
	}
	if yyb2572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv2573 := &x.Ingress
		yym2574 := z.DecBinary()
		_ = yym2574
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2573), d)
		}
	}
	for {
		yyj2572++
		if yyhl2572 {
			yyb2572 = yyj2572 > l
		} else {
			yyb2572 = r.CheckBreak()
		}
		if yyb2572 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2572-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2575 := z.EncBinary()
		_ = yym2575
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2576 := !z.EncBinary()
			yy2arr2576 := z.EncBasicHandle().StructToArray
			var yyq2576 [2]bool
			_, _, _ = yysep2576, yyq2576, yy2arr2576
			const yyr2576 bool = false
			yyq2576[0] = x.IP != ""
			yyq2576[1] = x.Hostname != ""
			var yynn2576 int
			if yyr2576 || yy2arr2576 {
				r.EncodeArrayStart(2)
			} else {
				yynn2576 = 0
				for _, b := range yyq2576 {
					if b {
						yynn2576++
					}
				}
				r.EncodeMapStart(yynn2576)
				yynn2576 = 0
			}
			if yyr2576 || yy2arr2576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2576[0] {
					yym2578 := z.EncBinary()
					_ = yym2578
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2576[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2579 := z.EncBinary()
					_ = yym2579
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr2576 || yy2arr2576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2576[1] {
					yym2581 := z.EncBinary()
					_ = yym2581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2576[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2582 := z.EncBinary()
					_ = yym2582
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2576 || yy2arr2576 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2583 := z.DecBinary()
	_ = yym2583
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2584 := r.ContainerType()
		if yyct2584 == codecSelferValueTypeMap1234 {
			yyl2584 := r.ReadMapStart()
			if yyl2584 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2584, d)
			}
		} else if yyct2584 == codecSelferValueTypeArray1234 {
			yyl2584 := r.ReadArrayStart()
			if yyl2584 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2584, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2585Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2585Slc
	var yyhl2585 bool = l >= 0
	for yyj2585 := 0; ; yyj2585++ {
		if yyhl2585 {
			if yyj2585 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2585Slc = r.DecodeBytes(yys2585Slc, true, true)
		yys2585 := string(yys2585Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2585 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2585)
		} // end switch yys2585
	} // end for yyj2585
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2588 int
	var yyb2588 bool
	var yyhl2588 bool = l >= 0
	yyj2588++
	if yyhl2588 {
		yyb2588 = yyj2588 > l
	} else {
		yyb2588 = r.CheckBreak()
	}
	if yyb2588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2588++
	if yyhl2588 {
		yyb2588 = yyj2588 > l
	} else {
		yyb2588 = r.CheckBreak()
	}
	if yyb2588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj2588++
		if yyhl2588 {
			yyb2588 = yyj2588 > l
		} else {
			yyb2588 = r.CheckBreak()
		}
		if yyb2588 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2588-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2591 := z.EncBinary()
		_ = yym2591
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2592 := !z.EncBinary()
			yy2arr2592 := z.EncBasicHandle().StructToArray
			var yyq2592 [9]bool
			_, _, _ = yysep2592, yyq2592, yy2arr2592
			const yyr2592 bool = false
			yyq2592[0] = x.Type != ""
			yyq2592[3] = x.ClusterIP != ""
			yyq2592[5] = len(x.ExternalIPs) != 0
			yyq2592[6] = x.LoadBalancerIP != ""
			yyq2592[7] = x.SessionAffinity != ""
			yyq2592[8] = len(x.LoadBalancerSourceRanges) != 0
			var yynn2592 int
			if yyr2592 || yy2arr2592 {
				r.EncodeArrayStart(9)
			} else {
				yynn2592 = 3
				for _, b := range yyq2592 {
					if b {
						yynn2592++
					}
				}
				r.EncodeMapStart(yynn2592)
				yynn2592 = 0
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2592[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2595 := z.EncBinary()
					_ = yym2595
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2596 := z.EncBinary()
					_ = yym2596
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2598 := z.EncBinary()
					_ = yym2598
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2599 := z.EncBinary()
					_ = yym2599
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[3] {
					yym2601 := z.EncBinary()
					_ = yym2601
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2592[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2602 := z.EncBinary()
					_ = yym2602
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2604 := z.EncBinary()
				_ = yym2604
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ExternalName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2605 := z.EncBinary()
				_ = yym2605
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[5] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2607 := z.EncBinary()
						_ = yym2607
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2592[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2608 := z.EncBinary()
						_ = yym2608
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[6] {
					yym2610 := z.EncBinary()
					_ = yym2610
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2592[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2611 := z.EncBinary()
					_ = yym2611
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[7] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2592[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2592[8] {
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2614 := z.EncBinary()
						_ = yym2614
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2592[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerSourceRanges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2615 := z.EncBinary()
						_ = yym2615
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				}
			}
			if yyr2592 || yy2arr2592 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2616 := z.DecBinary()
	_ = yym2616
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2617 := r.ContainerType()
		if yyct2617 == codecSelferValueTypeMap1234 {
			yyl2617 := r.ReadMapStart()
			if yyl2617 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2617, d)
			}
		} else if yyct2617 == codecSelferValueTypeArray1234 {
			yyl2617 := r.ReadArrayStart()
			if yyl2617 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2617, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2618Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2618Slc
	var yyhl2618 bool = l >= 0
	for yyj2618 := 0; ; yyj2618++ {
		if yyhl2618 {
			if yyj2618 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2618Slc = r.DecodeBytes(yys2618Slc, true, true)
		yys2618 := string(yys2618Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2618 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2620 := &x.Ports
				yym2621 := z.DecBinary()
				_ = yym2621
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv2620), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2622 := &x.Selector
				yym2623 := z.DecBinary()
				_ = yym2623
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2622, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "ExternalName":
			if r.TryDecodeAsNil() {
				x.ExternalName = ""
			} else {
				x.ExternalName = string(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv2626 := &x.ExternalIPs
				yym2627 := z.DecBinary()
				_ = yym2627
				if false {
				} else {
					z.F.DecSliceStringX(yyv2626, false, d)
				}
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		case "loadBalancerSourceRanges":
			if r.TryDecodeAsNil() {
				x.LoadBalancerSourceRanges = nil
			} else {
				yyv2630 := &x.LoadBalancerSourceRanges
				yym2631 := z.DecBinary()
				_ = yym2631
				if false {
				} else {
					z.F.DecSliceStringX(yyv2630, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2618)
		} // end switch yys2618
	} // end for yyj2618
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2632 int
	var yyb2632 bool
	var yyhl2632 bool = l >= 0
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2634 := &x.Ports
		yym2635 := z.DecBinary()
		_ = yym2635
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv2634), d)
		}
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2636 := &x.Selector
		yym2637 := z.DecBinary()
		_ = yym2637
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2636, false, d)
		}
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalName = ""
	} else {
		x.ExternalName = string(r.DecodeString())
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv2640 := &x.ExternalIPs
		yym2641 := z.DecBinary()
		_ = yym2641
		if false {
		} else {
			z.F.DecSliceStringX(yyv2640, false, d)
		}
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	yyj2632++
	if yyhl2632 {
		yyb2632 = yyj2632 > l
	} else {
		yyb2632 = r.CheckBreak()
	}
	if yyb2632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerSourceRanges = nil
	} else {
		yyv2644 := &x.LoadBalancerSourceRanges
		yym2645 := z.DecBinary()
		_ = yym2645
		if false {
		} else {
			z.F.DecSliceStringX(yyv2644, false, d)
		}
	}
	for {
		yyj2632++
		if yyhl2632 {
			yyb2632 = yyj2632 > l
		} else {
			yyb2632 = r.CheckBreak()
		}
		if yyb2632 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2632-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2646 := z.EncBinary()
		_ = yym2646
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2647 := !z.EncBinary()
			yy2arr2647 := z.EncBasicHandle().StructToArray
			var yyq2647 [5]bool
			_, _, _ = yysep2647, yyq2647, yy2arr2647
			const yyr2647 bool = false
			var yynn2647 int
			if yyr2647 || yy2arr2647 {
				r.EncodeArrayStart(5)
			} else {
				yynn2647 = 5
				for _, b := range yyq2647 {
					if b {
						yynn2647++
					}
				}
				r.EncodeMapStart(yynn2647)
				yynn2647 = 0
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2649 := z.EncBinary()
				_ = yym2649
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2650 := z.EncBinary()
				_ = yym2650
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2653 := z.EncBinary()
				_ = yym2653
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2654 := z.EncBinary()
				_ = yym2654
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2656 := &x.TargetPort
				yym2657 := z.EncBinary()
				_ = yym2657
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2656) {
				} else if !yym2657 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2656)
				} else {
					z.EncFallback(yy2656)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2658 := &x.TargetPort
				yym2659 := z.EncBinary()
				_ = yym2659
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2658) {
				} else if !yym2659 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2658)
				} else {
					z.EncFallback(yy2658)
				}
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2661 := z.EncBinary()
				_ = yym2661
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2662 := z.EncBinary()
				_ = yym2662
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			}
			if yyr2647 || yy2arr2647 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2663 := z.DecBinary()
	_ = yym2663
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2664 := r.ContainerType()
		if yyct2664 == codecSelferValueTypeMap1234 {
			yyl2664 := r.ReadMapStart()
			if yyl2664 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2664, d)
			}
		} else if yyct2664 == codecSelferValueTypeArray1234 {
			yyl2664 := r.ReadArrayStart()
			if yyl2664 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2664, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2665Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2665Slc
	var yyhl2665 bool = l >= 0
	for yyj2665 := 0; ; yyj2665++ {
		if yyhl2665 {
			if yyj2665 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2665Slc = r.DecodeBytes(yys2665Slc, true, true)
		yys2665 := string(yys2665Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2665 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg4_intstr.IntOrString{}
			} else {
				yyv2669 := &x.TargetPort
				yym2670 := z.DecBinary()
				_ = yym2670
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2669) {
				} else if !yym2670 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2669)
				} else {
					z.DecFallback(yyv2669, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2665)
		} // end switch yys2665
	} // end for yyj2665
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2672 int
	var yyb2672 bool
	var yyhl2672 bool = l >= 0
	yyj2672++
	if yyhl2672 {
		yyb2672 = yyj2672 > l
	} else {
		yyb2672 = r.CheckBreak()
	}
	if yyb2672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2672++
	if yyhl2672 {
		yyb2672 = yyj2672 > l
	} else {
		yyb2672 = r.CheckBreak()
	}
	if yyb2672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj2672++
	if yyhl2672 {
		yyb2672 = yyj2672 > l
	} else {
		yyb2672 = r.CheckBreak()
	}
	if yyb2672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2672++
	if yyhl2672 {
		yyb2672 = yyj2672 > l
	} else {
		yyb2672 = r.CheckBreak()
	}
	if yyb2672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg4_intstr.IntOrString{}
	} else {
		yyv2676 := &x.TargetPort
		yym2677 := z.DecBinary()
		_ = yym2677
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2676) {
		} else if !yym2677 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2676)
		} else {
			z.DecFallback(yyv2676, false)
		}
	}
	yyj2672++
	if yyhl2672 {
		yyb2672 = yyj2672 > l
	} else {
		yyb2672 = r.CheckBreak()
	}
	if yyb2672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int32(r.DecodeInt(32))
	}
	for {
		yyj2672++
		if yyhl2672 {
			yyb2672 = yyj2672 > l
		} else {
			yyb2672 = r.CheckBreak()
		}
		if yyb2672 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2672-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2679 := z.EncBinary()
		_ = yym2679
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2680 := !z.EncBinary()
			yy2arr2680 := z.EncBasicHandle().StructToArray
			var yyq2680 [5]bool
			_, _, _ = yysep2680, yyq2680, yy2arr2680
			const yyr2680 bool = false
			yyq2680[0] = x.Kind != ""
			yyq2680[1] = x.APIVersion != ""
			yyq2680[2] = true
			yyq2680[3] = true
			yyq2680[4] = true
			var yynn2680 int
			if yyr2680 || yy2arr2680 {
				r.EncodeArrayStart(5)
			} else {
				yynn2680 = 0
				for _, b := range yyq2680 {
					if b {
						yynn2680++
					}
				}
				r.EncodeMapStart(yynn2680)
				yynn2680 = 0
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2680[0] {
					yym2682 := z.EncBinary()
					_ = yym2682
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2680[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2683 := z.EncBinary()
					_ = yym2683
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2680[1] {
					yym2685 := z.EncBinary()
					_ = yym2685
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2680[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2686 := z.EncBinary()
					_ = yym2686
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2680[2] {
					yy2688 := &x.ObjectMeta
					yy2688.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2680[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2689 := &x.ObjectMeta
					yy2689.CodecEncodeSelf(e)
				}
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2680[3] {
					yy2691 := &x.Spec
					yy2691.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2680[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2692 := &x.Spec
					yy2692.CodecEncodeSelf(e)
				}
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2680[4] {
					yy2694 := &x.Status
					yy2694.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2680[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2695 := &x.Status
					yy2695.CodecEncodeSelf(e)
				}
			}
			if yyr2680 || yy2arr2680 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2696 := z.DecBinary()
	_ = yym2696
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2697 := r.ContainerType()
		if yyct2697 == codecSelferValueTypeMap1234 {
			yyl2697 := r.ReadMapStart()
			if yyl2697 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2697, d)
			}
		} else if yyct2697 == codecSelferValueTypeArray1234 {
			yyl2697 := r.ReadArrayStart()
			if yyl2697 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2697, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2698Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2698Slc
	var yyhl2698 bool = l >= 0
	for yyj2698 := 0; ; yyj2698++ {
		if yyhl2698 {
			if yyj2698 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2698Slc = r.DecodeBytes(yys2698Slc, true, true)
		yys2698 := string(yys2698Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2698 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2701 := &x.ObjectMeta
				yyv2701.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2702 := &x.Spec
				yyv2702.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2703 := &x.Status
				yyv2703.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2698)
		} // end switch yys2698
	} // end for yyj2698
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2704 int
	var yyb2704 bool
	var yyhl2704 bool = l >= 0
	yyj2704++
	if yyhl2704 {
		yyb2704 = yyj2704 > l
	} else {
		yyb2704 = r.CheckBreak()
	}
	if yyb2704 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2704++
	if yyhl2704 {
		yyb2704 = yyj2704 > l
	} else {
		yyb2704 = r.CheckBreak()
	}
	if yyb2704 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2704++
	if yyhl2704 {
		yyb2704 = yyj2704 > l
	} else {
		yyb2704 = r.CheckBreak()
	}
	if yyb2704 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2707 := &x.ObjectMeta
		yyv2707.CodecDecodeSelf(d)
	}
	yyj2704++
	if yyhl2704 {
		yyb2704 = yyj2704 > l
	} else {
		yyb2704 = r.CheckBreak()
	}
	if yyb2704 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2708 := &x.Spec
		yyv2708.CodecDecodeSelf(d)
	}
	yyj2704++
	if yyhl2704 {
		yyb2704 = yyj2704 > l
	} else {
		yyb2704 = r.CheckBreak()
	}
	if yyb2704 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2709 := &x.Status
		yyv2709.CodecDecodeSelf(d)
	}
	for {
		yyj2704++
		if yyhl2704 {
			yyb2704 = yyj2704 > l
		} else {
			yyb2704 = r.CheckBreak()
		}
		if yyb2704 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2704-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2710 := z.EncBinary()
		_ = yym2710
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2711 := !z.EncBinary()
			yy2arr2711 := z.EncBasicHandle().StructToArray
			var yyq2711 [5]bool
			_, _, _ = yysep2711, yyq2711, yy2arr2711
			const yyr2711 bool = false
			yyq2711[0] = x.Kind != ""
			yyq2711[1] = x.APIVersion != ""
			yyq2711[2] = true
			yyq2711[4] = len(x.ImagePullSecrets) != 0
			var yynn2711 int
			if yyr2711 || yy2arr2711 {
				r.EncodeArrayStart(5)
			} else {
				yynn2711 = 1
				for _, b := range yyq2711 {
					if b {
						yynn2711++
					}
				}
				r.EncodeMapStart(yynn2711)
				yynn2711 = 0
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[0] {
					yym2713 := z.EncBinary()
					_ = yym2713
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2711[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2714 := z.EncBinary()
					_ = yym2714
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[1] {
					yym2716 := z.EncBinary()
					_ = yym2716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2711[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2717 := z.EncBinary()
					_ = yym2717
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[2] {
					yy2719 := &x.ObjectMeta
					yy2719.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2720 := &x.ObjectMeta
					yy2720.CodecEncodeSelf(e)
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2722 := z.EncBinary()
					_ = yym2722
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secrets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2723 := z.EncBinary()
					_ = yym2723
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2711[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2725 := z.EncBinary()
						_ = yym2725
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2711[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2726 := z.EncBinary()
						_ = yym2726
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2711 || yy2arr2711 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2727 := z.DecBinary()
	_ = yym2727
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2728 := r.ContainerType()
		if yyct2728 == codecSelferValueTypeMap1234 {
			yyl2728 := r.ReadMapStart()
			if yyl2728 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2728, d)
			}
		} else if yyct2728 == codecSelferValueTypeArray1234 {
			yyl2728 := r.ReadArrayStart()
			if yyl2728 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2728, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2729Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2729Slc
	var yyhl2729 bool = l >= 0
	for yyj2729 := 0; ; yyj2729++ {
		if yyhl2729 {
			if yyj2729 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2729Slc = r.DecodeBytes(yys2729Slc, true, true)
		yys2729 := string(yys2729Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2729 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2732 := &x.ObjectMeta
				yyv2732.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2733 := &x.Secrets
				yym2734 := z.DecBinary()
				_ = yym2734
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2733), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2735 := &x.ImagePullSecrets
				yym2736 := z.DecBinary()
				_ = yym2736
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2735), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2729)
		} // end switch yys2729
	} // end for yyj2729
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2737 int
	var yyb2737 bool
	var yyhl2737 bool = l >= 0
	yyj2737++
	if yyhl2737 {
		yyb2737 = yyj2737 > l
	} else {
		yyb2737 = r.CheckBreak()
	}
	if yyb2737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2737++
	if yyhl2737 {
		yyb2737 = yyj2737 > l
	} else {
		yyb2737 = r.CheckBreak()
	}
	if yyb2737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2737++
	if yyhl2737 {
		yyb2737 = yyj2737 > l
	} else {
		yyb2737 = r.CheckBreak()
	}
	if yyb2737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2740 := &x.ObjectMeta
		yyv2740.CodecDecodeSelf(d)
	}
	yyj2737++
	if yyhl2737 {
		yyb2737 = yyj2737 > l
	} else {
		yyb2737 = r.CheckBreak()
	}
	if yyb2737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2741 := &x.Secrets
		yym2742 := z.DecBinary()
		_ = yym2742
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2741), d)
		}
	}
	yyj2737++
	if yyhl2737 {
		yyb2737 = yyj2737 > l
	} else {
		yyb2737 = r.CheckBreak()
	}
	if yyb2737 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2743 := &x.ImagePullSecrets
		yym2744 := z.DecBinary()
		_ = yym2744
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2743), d)
		}
	}
	for {
		yyj2737++
		if yyhl2737 {
			yyb2737 = yyj2737 > l
		} else {
			yyb2737 = r.CheckBreak()
		}
		if yyb2737 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2737-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2745 := z.EncBinary()
		_ = yym2745
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2746 := !z.EncBinary()
			yy2arr2746 := z.EncBasicHandle().StructToArray
			var yyq2746 [4]bool
			_, _, _ = yysep2746, yyq2746, yy2arr2746
			const yyr2746 bool = false
			yyq2746[0] = x.Kind != ""
			yyq2746[1] = x.APIVersion != ""
			yyq2746[2] = true
			var yynn2746 int
			if yyr2746 || yy2arr2746 {
				r.EncodeArrayStart(4)
			} else {
				yynn2746 = 1
				for _, b := range yyq2746 {
					if b {
						yynn2746++
					}
				}
				r.EncodeMapStart(yynn2746)
				yynn2746 = 0
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[0] {
					yym2748 := z.EncBinary()
					_ = yym2748
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2746[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2749 := z.EncBinary()
					_ = yym2749
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[1] {
					yym2751 := z.EncBinary()
					_ = yym2751
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2746[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2752 := z.EncBinary()
					_ = yym2752
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[2] {
					yy2754 := &x.ListMeta
					yym2755 := z.EncBinary()
					_ = yym2755
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2754) {
					} else {
						z.EncFallback(yy2754)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2746[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2756 := &x.ListMeta
					yym2757 := z.EncBinary()
					_ = yym2757
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2756) {
					} else {
						z.EncFallback(yy2756)
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2759 := z.EncBinary()
					_ = yym2759
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2760 := z.EncBinary()
					_ = yym2760
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2761 := z.DecBinary()
	_ = yym2761
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2762 := r.ContainerType()
		if yyct2762 == codecSelferValueTypeMap1234 {
			yyl2762 := r.ReadMapStart()
			if yyl2762 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2762, d)
			}
		} else if yyct2762 == codecSelferValueTypeArray1234 {
			yyl2762 := r.ReadArrayStart()
			if yyl2762 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2762, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2763Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2763Slc
	var yyhl2763 bool = l >= 0
	for yyj2763 := 0; ; yyj2763++ {
		if yyhl2763 {
			if yyj2763 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2763Slc = r.DecodeBytes(yys2763Slc, true, true)
		yys2763 := string(yys2763Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2763 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2766 := &x.ListMeta
				yym2767 := z.DecBinary()
				_ = yym2767
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2766) {
				} else {
					z.DecFallback(yyv2766, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2768 := &x.Items
				yym2769 := z.DecBinary()
				_ = yym2769
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2768), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2763)
		} // end switch yys2763
	} // end for yyj2763
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2770 int
	var yyb2770 bool
	var yyhl2770 bool = l >= 0
	yyj2770++
	if yyhl2770 {
		yyb2770 = yyj2770 > l
	} else {
		yyb2770 = r.CheckBreak()
	}
	if yyb2770 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2770++
	if yyhl2770 {
		yyb2770 = yyj2770 > l
	} else {
		yyb2770 = r.CheckBreak()
	}
	if yyb2770 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2770++
	if yyhl2770 {
		yyb2770 = yyj2770 > l
	} else {
		yyb2770 = r.CheckBreak()
	}
	if yyb2770 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2773 := &x.ListMeta
		yym2774 := z.DecBinary()
		_ = yym2774
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2773) {
		} else {
			z.DecFallback(yyv2773, false)
		}
	}
	yyj2770++
	if yyhl2770 {
		yyb2770 = yyj2770 > l
	} else {
		yyb2770 = r.CheckBreak()
	}
	if yyb2770 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2775 := &x.Items
		yym2776 := z.DecBinary()
		_ = yym2776
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2775), d)
		}
	}
	for {
		yyj2770++
		if yyhl2770 {
			yyb2770 = yyj2770 > l
		} else {
			yyb2770 = r.CheckBreak()
		}
		if yyb2770 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2770-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2777 := z.EncBinary()
		_ = yym2777
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2778 := !z.EncBinary()
			yy2arr2778 := z.EncBasicHandle().StructToArray
			var yyq2778 [4]bool
			_, _, _ = yysep2778, yyq2778, yy2arr2778
			const yyr2778 bool = false
			yyq2778[0] = x.Kind != ""
			yyq2778[1] = x.APIVersion != ""
			yyq2778[2] = true
			var yynn2778 int
			if yyr2778 || yy2arr2778 {
				r.EncodeArrayStart(4)
			} else {
				yynn2778 = 1
				for _, b := range yyq2778 {
					if b {
						yynn2778++
					}
				}
				r.EncodeMapStart(yynn2778)
				yynn2778 = 0
			}
			if yyr2778 || yy2arr2778 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2778[0] {
					yym2780 := z.EncBinary()
					_ = yym2780
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2778[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2781 := z.EncBinary()
					_ = yym2781
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2778 || yy2arr2778 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2778[1] {
					yym2783 := z.EncBinary()
					_ = yym2783
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2778[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2784 := z.EncBinary()
					_ = yym2784
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2778 || yy2arr2778 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2778[2] {
					yy2786 := &x.ObjectMeta
					yy2786.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2778[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2787 := &x.ObjectMeta
					yy2787.CodecEncodeSelf(e)
				}
			}
			if yyr2778 || yy2arr2778 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2789 := z.EncBinary()
					_ = yym2789
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2790 := z.EncBinary()
					_ = yym2790
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2778 || yy2arr2778 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2791 := z.DecBinary()
	_ = yym2791
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2792 := r.ContainerType()
		if yyct2792 == codecSelferValueTypeMap1234 {
			yyl2792 := r.ReadMapStart()
			if yyl2792 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2792, d)
			}
		} else if yyct2792 == codecSelferValueTypeArray1234 {
			yyl2792 := r.ReadArrayStart()
			if yyl2792 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2792, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2793Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2793Slc
	var yyhl2793 bool = l >= 0
	for yyj2793 := 0; ; yyj2793++ {
		if yyhl2793 {
			if yyj2793 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2793Slc = r.DecodeBytes(yys2793Slc, true, true)
		yys2793 := string(yys2793Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2793 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2796 := &x.ObjectMeta
				yyv2796.CodecDecodeSelf(d)
			}
		case "Subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2797 := &x.Subsets
				yym2798 := z.DecBinary()
				_ = yym2798
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2797), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2793)
		} // end switch yys2793
	} // end for yyj2793
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2799 int
	var yyb2799 bool
	var yyhl2799 bool = l >= 0
	yyj2799++
	if yyhl2799 {
		yyb2799 = yyj2799 > l
	} else {
		yyb2799 = r.CheckBreak()
	}
	if yyb2799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2799++
	if yyhl2799 {
		yyb2799 = yyj2799 > l
	} else {
		yyb2799 = r.CheckBreak()
	}
	if yyb2799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2799++
	if yyhl2799 {
		yyb2799 = yyj2799 > l
	} else {
		yyb2799 = r.CheckBreak()
	}
	if yyb2799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2802 := &x.ObjectMeta
		yyv2802.CodecDecodeSelf(d)
	}
	yyj2799++
	if yyhl2799 {
		yyb2799 = yyj2799 > l
	} else {
		yyb2799 = r.CheckBreak()
	}
	if yyb2799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2803 := &x.Subsets
		yym2804 := z.DecBinary()
		_ = yym2804
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2803), d)
		}
	}
	for {
		yyj2799++
		if yyhl2799 {
			yyb2799 = yyj2799 > l
		} else {
			yyb2799 = r.CheckBreak()
		}
		if yyb2799 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2799-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2805 := z.EncBinary()
		_ = yym2805
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2806 := !z.EncBinary()
			yy2arr2806 := z.EncBasicHandle().StructToArray
			var yyq2806 [3]bool
			_, _, _ = yysep2806, yyq2806, yy2arr2806
			const yyr2806 bool = false
			var yynn2806 int
			if yyr2806 || yy2arr2806 {
				r.EncodeArrayStart(3)
			} else {
				yynn2806 = 3
				for _, b := range yyq2806 {
					if b {
						yynn2806++
					}
				}
				r.EncodeMapStart(yynn2806)
				yynn2806 = 0
			}
			if yyr2806 || yy2arr2806 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2808 := z.EncBinary()
					_ = yym2808
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Addresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2809 := z.EncBinary()
					_ = yym2809
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			}
			if yyr2806 || yy2arr2806 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2811 := z.EncBinary()
					_ = yym2811
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("NotReadyAddresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2812 := z.EncBinary()
					_ = yym2812
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			}
			if yyr2806 || yy2arr2806 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2814 := z.EncBinary()
					_ = yym2814
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2815 := z.EncBinary()
					_ = yym2815
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			}
			if yyr2806 || yy2arr2806 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2816 := z.DecBinary()
	_ = yym2816
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2817 := r.ContainerType()
		if yyct2817 == codecSelferValueTypeMap1234 {
			yyl2817 := r.ReadMapStart()
			if yyl2817 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2817, d)
			}
		} else if yyct2817 == codecSelferValueTypeArray1234 {
			yyl2817 := r.ReadArrayStart()
			if yyl2817 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2817, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2818Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2818Slc
	var yyhl2818 bool = l >= 0
	for yyj2818 := 0; ; yyj2818++ {
		if yyhl2818 {
			if yyj2818 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2818Slc = r.DecodeBytes(yys2818Slc, true, true)
		yys2818 := string(yys2818Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2818 {
		case "Addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2819 := &x.Addresses
				yym2820 := z.DecBinary()
				_ = yym2820
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2819), d)
				}
			}
		case "NotReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2821 := &x.NotReadyAddresses
				yym2822 := z.DecBinary()
				_ = yym2822
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2821), d)
				}
			}
		case "Ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2823 := &x.Ports
				yym2824 := z.DecBinary()
				_ = yym2824
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2823), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2818)
		} // end switch yys2818
	} // end for yyj2818
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2825 int
	var yyb2825 bool
	var yyhl2825 bool = l >= 0
	yyj2825++
	if yyhl2825 {
		yyb2825 = yyj2825 > l
	} else {
		yyb2825 = r.CheckBreak()
	}
	if yyb2825 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2826 := &x.Addresses
		yym2827 := z.DecBinary()
		_ = yym2827
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2826), d)
		}
	}
	yyj2825++
	if yyhl2825 {
		yyb2825 = yyj2825 > l
	} else {
		yyb2825 = r.CheckBreak()
	}
	if yyb2825 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2828 := &x.NotReadyAddresses
		yym2829 := z.DecBinary()
		_ = yym2829
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2828), d)
		}
	}
	yyj2825++
	if yyhl2825 {
		yyb2825 = yyj2825 > l
	} else {
		yyb2825 = r.CheckBreak()
	}
	if yyb2825 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2830 := &x.Ports
		yym2831 := z.DecBinary()
		_ = yym2831
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2830), d)
		}
	}
	for {
		yyj2825++
		if yyhl2825 {
			yyb2825 = yyj2825 > l
		} else {
			yyb2825 = r.CheckBreak()
		}
		if yyb2825 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2825-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2832 := z.EncBinary()
		_ = yym2832
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2833 := !z.EncBinary()
			yy2arr2833 := z.EncBasicHandle().StructToArray
			var yyq2833 [4]bool
			_, _, _ = yysep2833, yyq2833, yy2arr2833
			const yyr2833 bool = false
			yyq2833[1] = x.Hostname != ""
			yyq2833[2] = x.NodeName != nil
			var yynn2833 int
			if yyr2833 || yy2arr2833 {
				r.EncodeArrayStart(4)
			} else {
				yynn2833 = 2
				for _, b := range yyq2833 {
					if b {
						yynn2833++
					}
				}
				r.EncodeMapStart(yynn2833)
				yynn2833 = 0
			}
			if yyr2833 || yy2arr2833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2835 := z.EncBinary()
				_ = yym2835
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("IP"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2836 := z.EncBinary()
				_ = yym2836
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2833 || yy2arr2833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2833[1] {
					yym2838 := z.EncBinary()
					_ = yym2838
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2833[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2839 := z.EncBinary()
					_ = yym2839
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2833 || yy2arr2833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2833[2] {
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2841 := *x.NodeName
						yym2842 := z.EncBinary()
						_ = yym2842
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2841))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2833[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2843 := *x.NodeName
						yym2844 := z.EncBinary()
						_ = yym2844
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2843))
						}
					}
				}
			}
			if yyr2833 || yy2arr2833 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TargetRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			}
			if yyr2833 || yy2arr2833 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2846 := z.DecBinary()
	_ = yym2846
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2847 := r.ContainerType()
		if yyct2847 == codecSelferValueTypeMap1234 {
			yyl2847 := r.ReadMapStart()
			if yyl2847 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2847, d)
			}
		} else if yyct2847 == codecSelferValueTypeArray1234 {
			yyl2847 := r.ReadArrayStart()
			if yyl2847 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2847, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2848Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2848Slc
	var yyhl2848 bool = l >= 0
	for yyj2848 := 0; ; yyj2848++ {
		if yyhl2848 {
			if yyj2848 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2848Slc = r.DecodeBytes(yys2848Slc, true, true)
		yys2848 := string(yys2848Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2848 {
		case "IP":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				if x.NodeName != nil {
					x.NodeName = nil
				}
			} else {
				if x.NodeName == nil {
					x.NodeName = new(string)
				}
				yym2852 := z.DecBinary()
				_ = yym2852
				if false {
				} else {
					*((*string)(x.NodeName)) = r.DecodeString()
				}
			}
		case "TargetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2848)
		} // end switch yys2848
	} // end for yyj2848
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2854 int
	var yyb2854 bool
	var yyhl2854 bool = l >= 0
	yyj2854++
	if yyhl2854 {
		yyb2854 = yyj2854 > l
	} else {
		yyb2854 = r.CheckBreak()
	}
	if yyb2854 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2854++
	if yyhl2854 {
		yyb2854 = yyj2854 > l
	} else {
		yyb2854 = r.CheckBreak()
	}
	if yyb2854 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2854++
	if yyhl2854 {
		yyb2854 = yyj2854 > l
	} else {
		yyb2854 = r.CheckBreak()
	}
	if yyb2854 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeName != nil {
			x.NodeName = nil
		}
	} else {
		if x.NodeName == nil {
			x.NodeName = new(string)
		}
		yym2858 := z.DecBinary()
		_ = yym2858
		if false {
		} else {
			*((*string)(x.NodeName)) = r.DecodeString()
		}
	}
	yyj2854++
	if yyhl2854 {
		yyb2854 = yyj2854 > l
	} else {
		yyb2854 = r.CheckBreak()
	}
	if yyb2854 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2854++
		if yyhl2854 {
			yyb2854 = yyj2854 > l
		} else {
			yyb2854 = r.CheckBreak()
		}
		if yyb2854 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2854-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2860 := z.EncBinary()
		_ = yym2860
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2861 := !z.EncBinary()
			yy2arr2861 := z.EncBasicHandle().StructToArray
			var yyq2861 [3]bool
			_, _, _ = yysep2861, yyq2861, yy2arr2861
			const yyr2861 bool = false
			var yynn2861 int
			if yyr2861 || yy2arr2861 {
				r.EncodeArrayStart(3)
			} else {
				yynn2861 = 3
				for _, b := range yyq2861 {
					if b {
						yynn2861++
					}
				}
				r.EncodeMapStart(yynn2861)
				yynn2861 = 0
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2863 := z.EncBinary()
				_ = yym2863
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2864 := z.EncBinary()
				_ = yym2864
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2866 := z.EncBinary()
				_ = yym2866
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2867 := z.EncBinary()
				_ = yym2867
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2869 := z.DecBinary()
	_ = yym2869
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2870 := r.ContainerType()
		if yyct2870 == codecSelferValueTypeMap1234 {
			yyl2870 := r.ReadMapStart()
			if yyl2870 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2870, d)
			}
		} else if yyct2870 == codecSelferValueTypeArray1234 {
			yyl2870 := r.ReadArrayStart()
			if yyl2870 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2870, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2871Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2871Slc
	var yyhl2871 bool = l >= 0
	for yyj2871 := 0; ; yyj2871++ {
		if yyhl2871 {
			if yyj2871 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2871Slc = r.DecodeBytes(yys2871Slc, true, true)
		yys2871 := string(yys2871Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2871 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "Protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2871)
		} // end switch yys2871
	} // end for yyj2871
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2875 int
	var yyb2875 bool
	var yyhl2875 bool = l >= 0
	yyj2875++
	if yyhl2875 {
		yyb2875 = yyj2875 > l
	} else {
		yyb2875 = r.CheckBreak()
	}
	if yyb2875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2875++
	if yyhl2875 {
		yyb2875 = yyj2875 > l
	} else {
		yyb2875 = r.CheckBreak()
	}
	if yyb2875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2875++
	if yyhl2875 {
		yyb2875 = yyj2875 > l
	} else {
		yyb2875 = r.CheckBreak()
	}
	if yyb2875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2875++
		if yyhl2875 {
			yyb2875 = yyj2875 > l
		} else {
			yyb2875 = r.CheckBreak()
		}
		if yyb2875 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2875-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2879 := z.EncBinary()
		_ = yym2879
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2880 := !z.EncBinary()
			yy2arr2880 := z.EncBasicHandle().StructToArray
			var yyq2880 [4]bool
			_, _, _ = yysep2880, yyq2880, yy2arr2880
			const yyr2880 bool = false
			yyq2880[0] = x.Kind != ""
			yyq2880[1] = x.APIVersion != ""
			yyq2880[2] = true
			var yynn2880 int
			if yyr2880 || yy2arr2880 {
				r.EncodeArrayStart(4)
			} else {
				yynn2880 = 1
				for _, b := range yyq2880 {
					if b {
						yynn2880++
					}
				}
				r.EncodeMapStart(yynn2880)
				yynn2880 = 0
			}
			if yyr2880 || yy2arr2880 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2880[0] {
					yym2882 := z.EncBinary()
					_ = yym2882
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2880[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2883 := z.EncBinary()
					_ = yym2883
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2880 || yy2arr2880 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2880[1] {
					yym2885 := z.EncBinary()
					_ = yym2885
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2880[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2886 := z.EncBinary()
					_ = yym2886
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2880 || yy2arr2880 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2880[2] {
					yy2888 := &x.ListMeta
					yym2889 := z.EncBinary()
					_ = yym2889
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2888) {
					} else {
						z.EncFallback(yy2888)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2880[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2890 := &x.ListMeta
					yym2891 := z.EncBinary()
					_ = yym2891
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2890) {
					} else {
						z.EncFallback(yy2890)
					}
				}
			}
			if yyr2880 || yy2arr2880 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2893 := z.EncBinary()
					_ = yym2893
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2894 := z.EncBinary()
					_ = yym2894
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2880 || yy2arr2880 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2895 := z.DecBinary()
	_ = yym2895
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2896 := r.ContainerType()
		if yyct2896 == codecSelferValueTypeMap1234 {
			yyl2896 := r.ReadMapStart()
			if yyl2896 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2896, d)
			}
		} else if yyct2896 == codecSelferValueTypeArray1234 {
			yyl2896 := r.ReadArrayStart()
			if yyl2896 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2896, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2897Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2897Slc
	var yyhl2897 bool = l >= 0
	for yyj2897 := 0; ; yyj2897++ {
		if yyhl2897 {
			if yyj2897 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2897Slc = r.DecodeBytes(yys2897Slc, true, true)
		yys2897 := string(yys2897Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2897 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2900 := &x.ListMeta
				yym2901 := z.DecBinary()
				_ = yym2901
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2900) {
				} else {
					z.DecFallback(yyv2900, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2902 := &x.Items
				yym2903 := z.DecBinary()
				_ = yym2903
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2902), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2897)
		} // end switch yys2897
	} // end for yyj2897
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2904 int
	var yyb2904 bool
	var yyhl2904 bool = l >= 0
	yyj2904++
	if yyhl2904 {
		yyb2904 = yyj2904 > l
	} else {
		yyb2904 = r.CheckBreak()
	}
	if yyb2904 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2904++
	if yyhl2904 {
		yyb2904 = yyj2904 > l
	} else {
		yyb2904 = r.CheckBreak()
	}
	if yyb2904 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2904++
	if yyhl2904 {
		yyb2904 = yyj2904 > l
	} else {
		yyb2904 = r.CheckBreak()
	}
	if yyb2904 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2907 := &x.ListMeta
		yym2908 := z.DecBinary()
		_ = yym2908
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2907) {
		} else {
			z.DecFallback(yyv2907, false)
		}
	}
	yyj2904++
	if yyhl2904 {
		yyb2904 = yyj2904 > l
	} else {
		yyb2904 = r.CheckBreak()
	}
	if yyb2904 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2909 := &x.Items
		yym2910 := z.DecBinary()
		_ = yym2910
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2909), d)
		}
	}
	for {
		yyj2904++
		if yyhl2904 {
			yyb2904 = yyj2904 > l
		} else {
			yyb2904 = r.CheckBreak()
		}
		if yyb2904 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2904-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2911 := z.EncBinary()
		_ = yym2911
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2912 := !z.EncBinary()
			yy2arr2912 := z.EncBasicHandle().StructToArray
			var yyq2912 [4]bool
			_, _, _ = yysep2912, yyq2912, yy2arr2912
			const yyr2912 bool = false
			yyq2912[0] = x.PodCIDR != ""
			yyq2912[1] = x.ExternalID != ""
			yyq2912[2] = x.ProviderID != ""
			yyq2912[3] = x.Unschedulable != false
			var yynn2912 int
			if yyr2912 || yy2arr2912 {
				r.EncodeArrayStart(4)
			} else {
				yynn2912 = 0
				for _, b := range yyq2912 {
					if b {
						yynn2912++
					}
				}
				r.EncodeMapStart(yynn2912)
				yynn2912 = 0
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2912[0] {
					yym2914 := z.EncBinary()
					_ = yym2914
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2912[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2915 := z.EncBinary()
					_ = yym2915
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2912[1] {
					yym2917 := z.EncBinary()
					_ = yym2917
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2912[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2918 := z.EncBinary()
					_ = yym2918
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2912[2] {
					yym2920 := z.EncBinary()
					_ = yym2920
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2912[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2921 := z.EncBinary()
					_ = yym2921
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2912[3] {
					yym2923 := z.EncBinary()
					_ = yym2923
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2912[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2924 := z.EncBinary()
					_ = yym2924
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2912 || yy2arr2912 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2925 := z.DecBinary()
	_ = yym2925
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2926 := r.ContainerType()
		if yyct2926 == codecSelferValueTypeMap1234 {
			yyl2926 := r.ReadMapStart()
			if yyl2926 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2926, d)
			}
		} else if yyct2926 == codecSelferValueTypeArray1234 {
			yyl2926 := r.ReadArrayStart()
			if yyl2926 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2926, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2927Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2927Slc
	var yyhl2927 bool = l >= 0
	for yyj2927 := 0; ; yyj2927++ {
		if yyhl2927 {
			if yyj2927 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2927Slc = r.DecodeBytes(yys2927Slc, true, true)
		yys2927 := string(yys2927Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2927 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2927)
		} // end switch yys2927
	} // end for yyj2927
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2932 int
	var yyb2932 bool
	var yyhl2932 bool = l >= 0
	yyj2932++
	if yyhl2932 {
		yyb2932 = yyj2932 > l
	} else {
		yyb2932 = r.CheckBreak()
	}
	if yyb2932 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj2932++
	if yyhl2932 {
		yyb2932 = yyj2932 > l
	} else {
		yyb2932 = r.CheckBreak()
	}
	if yyb2932 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj2932++
	if yyhl2932 {
		yyb2932 = yyj2932 > l
	} else {
		yyb2932 = r.CheckBreak()
	}
	if yyb2932 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj2932++
	if yyhl2932 {
		yyb2932 = yyj2932 > l
	} else {
		yyb2932 = r.CheckBreak()
	}
	if yyb2932 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj2932++
		if yyhl2932 {
			yyb2932 = yyj2932 > l
		} else {
			yyb2932 = r.CheckBreak()
		}
		if yyb2932 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2932-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2937 := z.EncBinary()
		_ = yym2937
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2938 := !z.EncBinary()
			yy2arr2938 := z.EncBasicHandle().StructToArray
			var yyq2938 [1]bool
			_, _, _ = yysep2938, yyq2938, yy2arr2938
			const yyr2938 bool = false
			var yynn2938 int
			if yyr2938 || yy2arr2938 {
				r.EncodeArrayStart(1)
			} else {
				yynn2938 = 1
				for _, b := range yyq2938 {
					if b {
						yynn2938++
					}
				}
				r.EncodeMapStart(yynn2938)
				yynn2938 = 0
			}
			if yyr2938 || yy2arr2938 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2940 := z.EncBinary()
				_ = yym2940
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2941 := z.EncBinary()
				_ = yym2941
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2938 || yy2arr2938 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2942 := z.DecBinary()
	_ = yym2942
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2943 := r.ContainerType()
		if yyct2943 == codecSelferValueTypeMap1234 {
			yyl2943 := r.ReadMapStart()
			if yyl2943 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2943, d)
			}
		} else if yyct2943 == codecSelferValueTypeArray1234 {
			yyl2943 := r.ReadArrayStart()
			if yyl2943 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2943, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2944Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2944Slc
	var yyhl2944 bool = l >= 0
	for yyj2944 := 0; ; yyj2944++ {
		if yyhl2944 {
			if yyj2944 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2944Slc = r.DecodeBytes(yys2944Slc, true, true)
		yys2944 := string(yys2944Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2944 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2944)
		} // end switch yys2944
	} // end for yyj2944
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2946 int
	var yyb2946 bool
	var yyhl2946 bool = l >= 0
	yyj2946++
	if yyhl2946 {
		yyb2946 = yyj2946 > l
	} else {
		yyb2946 = r.CheckBreak()
	}
	if yyb2946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	for {
		yyj2946++
		if yyhl2946 {
			yyb2946 = yyj2946 > l
		} else {
			yyb2946 = r.CheckBreak()
		}
		if yyb2946 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2946-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2948 := z.EncBinary()
		_ = yym2948
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2949 := !z.EncBinary()
			yy2arr2949 := z.EncBasicHandle().StructToArray
			var yyq2949 [1]bool
			_, _, _ = yysep2949, yyq2949, yy2arr2949
			const yyr2949 bool = false
			yyq2949[0] = true
			var yynn2949 int
			if yyr2949 || yy2arr2949 {
				r.EncodeArrayStart(1)
			} else {
				yynn2949 = 0
				for _, b := range yyq2949 {
					if b {
						yynn2949++
					}
				}
				r.EncodeMapStart(yynn2949)
				yynn2949 = 0
			}
			if yyr2949 || yy2arr2949 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2949[0] {
					yy2951 := &x.KubeletEndpoint
					yy2951.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2949[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2952 := &x.KubeletEndpoint
					yy2952.CodecEncodeSelf(e)
				}
			}
			if yyr2949 || yy2arr2949 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2953 := z.DecBinary()
	_ = yym2953
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2954 := r.ContainerType()
		if yyct2954 == codecSelferValueTypeMap1234 {
			yyl2954 := r.ReadMapStart()
			if yyl2954 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2954, d)
			}
		} else if yyct2954 == codecSelferValueTypeArray1234 {
			yyl2954 := r.ReadArrayStart()
			if yyl2954 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2954, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2955Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2955Slc
	var yyhl2955 bool = l >= 0
	for yyj2955 := 0; ; yyj2955++ {
		if yyhl2955 {
			if yyj2955 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2955Slc = r.DecodeBytes(yys2955Slc, true, true)
		yys2955 := string(yys2955Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2955 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv2956 := &x.KubeletEndpoint
				yyv2956.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2955)
		} // end switch yys2955
	} // end for yyj2955
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2957 int
	var yyb2957 bool
	var yyhl2957 bool = l >= 0
	yyj2957++
	if yyhl2957 {
		yyb2957 = yyj2957 > l
	} else {
		yyb2957 = r.CheckBreak()
	}
	if yyb2957 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv2958 := &x.KubeletEndpoint
		yyv2958.CodecDecodeSelf(d)
	}
	for {
		yyj2957++
		if yyhl2957 {
			yyb2957 = yyj2957 > l
		} else {
			yyb2957 = r.CheckBreak()
		}
		if yyb2957 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2957-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2959 := z.EncBinary()
		_ = yym2959
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2960 := !z.EncBinary()
			yy2arr2960 := z.EncBasicHandle().StructToArray
			var yyq2960 [10]bool
			_, _, _ = yysep2960, yyq2960, yy2arr2960
			const yyr2960 bool = false
			var yynn2960 int
			if yyr2960 || yy2arr2960 {
				r.EncodeArrayStart(10)
			} else {
				yynn2960 = 10
				for _, b := range yyq2960 {
					if b {
						yynn2960++
					}
				}
				r.EncodeMapStart(yynn2960)
				yynn2960 = 0
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2962 := z.EncBinary()
				_ = yym2962
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2963 := z.EncBinary()
				_ = yym2963
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2965 := z.EncBinary()
				_ = yym2965
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2966 := z.EncBinary()
				_ = yym2966
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2968 := z.EncBinary()
				_ = yym2968
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2969 := z.EncBinary()
				_ = yym2969
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2971 := z.EncBinary()
				_ = yym2971
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2972 := z.EncBinary()
				_ = yym2972
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2974 := z.EncBinary()
				_ = yym2974
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2975 := z.EncBinary()
				_ = yym2975
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2977 := z.EncBinary()
				_ = yym2977
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2978 := z.EncBinary()
				_ = yym2978
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2980 := z.EncBinary()
				_ = yym2980
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2981 := z.EncBinary()
				_ = yym2981
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2983 := z.EncBinary()
				_ = yym2983
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2984 := z.EncBinary()
				_ = yym2984
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2986 := z.EncBinary()
				_ = yym2986
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operatingSystem"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2987 := z.EncBinary()
				_ = yym2987
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2989 := z.EncBinary()
				_ = yym2989
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("architecture"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2990 := z.EncBinary()
				_ = yym2990
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			}
			if yyr2960 || yy2arr2960 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2991 := z.DecBinary()
	_ = yym2991
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2992 := r.ContainerType()
		if yyct2992 == codecSelferValueTypeMap1234 {
			yyl2992 := r.ReadMapStart()
			if yyl2992 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2992, d)
			}
		} else if yyct2992 == codecSelferValueTypeArray1234 {
			yyl2992 := r.ReadArrayStart()
			if yyl2992 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2992, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2993Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2993Slc
	var yyhl2993 bool = l >= 0
	for yyj2993 := 0; ; yyj2993++ {
		if yyhl2993 {
			if yyj2993 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2993Slc = r.DecodeBytes(yys2993Slc, true, true)
		yys2993 := string(yys2993Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2993 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		case "operatingSystem":
			if r.TryDecodeAsNil() {
				x.OperatingSystem = ""
			} else {
				x.OperatingSystem = string(r.DecodeString())
			}
		case "architecture":
			if r.TryDecodeAsNil() {
				x.Architecture = ""
			} else {
				x.Architecture = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2993)
		} // end switch yys2993
	} // end for yyj2993
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3004 int
	var yyb3004 bool
	var yyhl3004 bool = l >= 0
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OperatingSystem = ""
	} else {
		x.OperatingSystem = string(r.DecodeString())
	}
	yyj3004++
	if yyhl3004 {
		yyb3004 = yyj3004 > l
	} else {
		yyb3004 = r.CheckBreak()
	}
	if yyb3004 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Architecture = ""
	} else {
		x.Architecture = string(r.DecodeString())
	}
	for {
		yyj3004++
		if yyhl3004 {
			yyb3004 = yyj3004 > l
		} else {
			yyb3004 = r.CheckBreak()
		}
		if yyb3004 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3004-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3015 := z.EncBinary()
		_ = yym3015
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3016 := !z.EncBinary()
			yy2arr3016 := z.EncBasicHandle().StructToArray
			var yyq3016 [10]bool
			_, _, _ = yysep3016, yyq3016, yy2arr3016
			const yyr3016 bool = false
			yyq3016[0] = len(x.Capacity) != 0
			yyq3016[1] = len(x.Allocatable) != 0
			yyq3016[2] = x.Phase != ""
			yyq3016[3] = len(x.Conditions) != 0
			yyq3016[4] = len(x.Addresses) != 0
			yyq3016[5] = true
			yyq3016[6] = true
			yyq3016[7] = len(x.Images) != 0
			yyq3016[8] = len(x.VolumesInUse) != 0
			yyq3016[9] = len(x.VolumesAttached) != 0
			var yynn3016 int
			if yyr3016 || yy2arr3016 {
				r.EncodeArrayStart(10)
			} else {
				yynn3016 = 0
				for _, b := range yyq3016 {
					if b {
						yynn3016++
					}
				}
				r.EncodeMapStart(yynn3016)
				yynn3016 = 0
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3016[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3021 := z.EncBinary()
						_ = yym3021
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3022 := z.EncBinary()
						_ = yym3022
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3024 := z.EncBinary()
						_ = yym3024
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3025 := z.EncBinary()
						_ = yym3025
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[5] {
					yy3027 := &x.DaemonEndpoints
					yy3027.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3028 := &x.DaemonEndpoints
					yy3028.CodecEncodeSelf(e)
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[6] {
					yy3030 := &x.NodeInfo
					yy3030.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3031 := &x.NodeInfo
					yy3031.CodecEncodeSelf(e)
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[7] {
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3033 := z.EncBinary()
						_ = yym3033
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("images"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3034 := z.EncBinary()
						_ = yym3034
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[8] {
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3036 := z.EncBinary()
						_ = yym3036
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesInUse"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3037 := z.EncBinary()
						_ = yym3037
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3016[9] {
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3039 := z.EncBinary()
						_ = yym3039
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3016[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesAttached"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3040 := z.EncBinary()
						_ = yym3040
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				}
			}
			if yyr3016 || yy2arr3016 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3041 := z.DecBinary()
	_ = yym3041
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3042 := r.ContainerType()
		if yyct3042 == codecSelferValueTypeMap1234 {
			yyl3042 := r.ReadMapStart()
			if yyl3042 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3042, d)
			}
		} else if yyct3042 == codecSelferValueTypeArray1234 {
			yyl3042 := r.ReadArrayStart()
			if yyl3042 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3042, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3043Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3043Slc
	var yyhl3043 bool = l >= 0
	for yyj3043 := 0; ; yyj3043++ {
		if yyhl3043 {
			if yyj3043 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3043Slc = r.DecodeBytes(yys3043Slc, true, true)
		yys3043 := string(yys3043Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3043 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv3044 := &x.Capacity
				yyv3044.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv3045 := &x.Allocatable
				yyv3045.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv3047 := &x.Conditions
				yym3048 := z.DecBinary()
				_ = yym3048
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv3047), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv3049 := &x.Addresses
				yym3050 := z.DecBinary()
				_ = yym3050
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv3049), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv3051 := &x.DaemonEndpoints
				yyv3051.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv3052 := &x.NodeInfo
				yyv3052.CodecDecodeSelf(d)
			}
		case "images":
			if r.TryDecodeAsNil() {
				x.Images = nil
			} else {
				yyv3053 := &x.Images
				yym3054 := z.DecBinary()
				_ = yym3054
				if false {
				} else {
					h.decSliceContainerImage((*[]ContainerImage)(yyv3053), d)
				}
			}
		case "volumesInUse":
			if r.TryDecodeAsNil() {
				x.VolumesInUse = nil
			} else {
				yyv3055 := &x.VolumesInUse
				yym3056 := z.DecBinary()
				_ = yym3056
				if false {
				} else {
					h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3055), d)
				}
			}
		case "volumesAttached":
			if r.TryDecodeAsNil() {
				x.VolumesAttached = nil
			} else {
				yyv3057 := &x.VolumesAttached
				yym3058 := z.DecBinary()
				_ = yym3058
				if false {
				} else {
					h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3057), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3043)
		} // end switch yys3043
	} // end for yyj3043
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3059 int
	var yyb3059 bool
	var yyhl3059 bool = l >= 0
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv3060 := &x.Capacity
		yyv3060.CodecDecodeSelf(d)
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv3061 := &x.Allocatable
		yyv3061.CodecDecodeSelf(d)
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv3063 := &x.Conditions
		yym3064 := z.DecBinary()
		_ = yym3064
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv3063), d)
		}
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv3065 := &x.Addresses
		yym3066 := z.DecBinary()
		_ = yym3066
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv3065), d)
		}
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv3067 := &x.DaemonEndpoints
		yyv3067.CodecDecodeSelf(d)
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv3068 := &x.NodeInfo
		yyv3068.CodecDecodeSelf(d)
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Images = nil
	} else {
		yyv3069 := &x.Images
		yym3070 := z.DecBinary()
		_ = yym3070
		if false {
		} else {
			h.decSliceContainerImage((*[]ContainerImage)(yyv3069), d)
		}
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesInUse = nil
	} else {
		yyv3071 := &x.VolumesInUse
		yym3072 := z.DecBinary()
		_ = yym3072
		if false {
		} else {
			h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3071), d)
		}
	}
	yyj3059++
	if yyhl3059 {
		yyb3059 = yyj3059 > l
	} else {
		yyb3059 = r.CheckBreak()
	}
	if yyb3059 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesAttached = nil
	} else {
		yyv3073 := &x.VolumesAttached
		yym3074 := z.DecBinary()
		_ = yym3074
		if false {
		} else {
			h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3073), d)
		}
	}
	for {
		yyj3059++
		if yyhl3059 {
			yyb3059 = yyj3059 > l
		} else {
			yyb3059 = r.CheckBreak()
		}
		if yyb3059 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3059-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x UniqueVolumeName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3075 := z.EncBinary()
	_ = yym3075
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *UniqueVolumeName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3076 := z.DecBinary()
	_ = yym3076
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AttachedVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3077 := z.EncBinary()
		_ = yym3077
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3078 := !z.EncBinary()
			yy2arr3078 := z.EncBasicHandle().StructToArray
			var yyq3078 [2]bool
			_, _, _ = yysep3078, yyq3078, yy2arr3078
			const yyr3078 bool = false
			var yynn3078 int
			if yyr3078 || yy2arr3078 {
				r.EncodeArrayStart(2)
			} else {
				yynn3078 = 2
				for _, b := range yyq3078 {
					if b {
						yynn3078++
					}
				}
				r.EncodeMapStart(yynn3078)
				yynn3078 = 0
			}
			if yyr3078 || yy2arr3078 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Name.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Name.CodecEncodeSelf(e)
			}
			if yyr3078 || yy2arr3078 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3081 := z.EncBinary()
				_ = yym3081
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("devicePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3082 := z.EncBinary()
				_ = yym3082
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			}
			if yyr3078 || yy2arr3078 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AttachedVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3083 := z.DecBinary()
	_ = yym3083
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3084 := r.ContainerType()
		if yyct3084 == codecSelferValueTypeMap1234 {
			yyl3084 := r.ReadMapStart()
			if yyl3084 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3084, d)
			}
		} else if yyct3084 == codecSelferValueTypeArray1234 {
			yyl3084 := r.ReadArrayStart()
			if yyl3084 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3084, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AttachedVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3085Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3085Slc
	var yyhl3085 bool = l >= 0
	for yyj3085 := 0; ; yyj3085++ {
		if yyhl3085 {
			if yyj3085 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3085Slc = r.DecodeBytes(yys3085Slc, true, true)
		yys3085 := string(yys3085Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3085 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = UniqueVolumeName(r.DecodeString())
			}
		case "devicePath":
			if r.TryDecodeAsNil() {
				x.DevicePath = ""
			} else {
				x.DevicePath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3085)
		} // end switch yys3085
	} // end for yyj3085
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AttachedVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3088 int
	var yyb3088 bool
	var yyhl3088 bool = l >= 0
	yyj3088++
	if yyhl3088 {
		yyb3088 = yyj3088 > l
	} else {
		yyb3088 = r.CheckBreak()
	}
	if yyb3088 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = UniqueVolumeName(r.DecodeString())
	}
	yyj3088++
	if yyhl3088 {
		yyb3088 = yyj3088 > l
	} else {
		yyb3088 = r.CheckBreak()
	}
	if yyb3088 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DevicePath = ""
	} else {
		x.DevicePath = string(r.DecodeString())
	}
	for {
		yyj3088++
		if yyhl3088 {
			yyb3088 = yyj3088 > l
		} else {
			yyb3088 = r.CheckBreak()
		}
		if yyb3088 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3088-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AvoidPods) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3091 := z.EncBinary()
		_ = yym3091
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3092 := !z.EncBinary()
			yy2arr3092 := z.EncBasicHandle().StructToArray
			var yyq3092 [1]bool
			_, _, _ = yysep3092, yyq3092, yy2arr3092
			const yyr3092 bool = false
			yyq3092[0] = len(x.PreferAvoidPods) != 0
			var yynn3092 int
			if yyr3092 || yy2arr3092 {
				r.EncodeArrayStart(1)
			} else {
				yynn3092 = 0
				for _, b := range yyq3092 {
					if b {
						yynn3092++
					}
				}
				r.EncodeMapStart(yynn3092)
				yynn3092 = 0
			}
			if yyr3092 || yy2arr3092 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3092[0] {
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3094 := z.EncBinary()
						_ = yym3094
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3092[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferAvoidPods"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3095 := z.EncBinary()
						_ = yym3095
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				}
			}
			if yyr3092 || yy2arr3092 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AvoidPods) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3096 := z.DecBinary()
	_ = yym3096
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3097 := r.ContainerType()
		if yyct3097 == codecSelferValueTypeMap1234 {
			yyl3097 := r.ReadMapStart()
			if yyl3097 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3097, d)
			}
		} else if yyct3097 == codecSelferValueTypeArray1234 {
			yyl3097 := r.ReadArrayStart()
			if yyl3097 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3097, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AvoidPods) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3098Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3098Slc
	var yyhl3098 bool = l >= 0
	for yyj3098 := 0; ; yyj3098++ {
		if yyhl3098 {
			if yyj3098 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3098Slc = r.DecodeBytes(yys3098Slc, true, true)
		yys3098 := string(yys3098Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3098 {
		case "preferAvoidPods":
			if r.TryDecodeAsNil() {
				x.PreferAvoidPods = nil
			} else {
				yyv3099 := &x.PreferAvoidPods
				yym3100 := z.DecBinary()
				_ = yym3100
				if false {
				} else {
					h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3099), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3098)
		} // end switch yys3098
	} // end for yyj3098
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AvoidPods) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3101 int
	var yyb3101 bool
	var yyhl3101 bool = l >= 0
	yyj3101++
	if yyhl3101 {
		yyb3101 = yyj3101 > l
	} else {
		yyb3101 = r.CheckBreak()
	}
	if yyb3101 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferAvoidPods = nil
	} else {
		yyv3102 := &x.PreferAvoidPods
		yym3103 := z.DecBinary()
		_ = yym3103
		if false {
		} else {
			h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3102), d)
		}
	}
	for {
		yyj3101++
		if yyhl3101 {
			yyb3101 = yyj3101 > l
		} else {
			yyb3101 = r.CheckBreak()
		}
		if yyb3101 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3101-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferAvoidPodsEntry) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3104 := z.EncBinary()
		_ = yym3104
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3105 := !z.EncBinary()
			yy2arr3105 := z.EncBasicHandle().StructToArray
			var yyq3105 [4]bool
			_, _, _ = yysep3105, yyq3105, yy2arr3105
			const yyr3105 bool = false
			yyq3105[1] = true
			yyq3105[2] = x.Reason != ""
			yyq3105[3] = x.Message != ""
			var yynn3105 int
			if yyr3105 || yy2arr3105 {
				r.EncodeArrayStart(4)
			} else {
				yynn3105 = 1
				for _, b := range yyq3105 {
					if b {
						yynn3105++
					}
				}
				r.EncodeMapStart(yynn3105)
				yynn3105 = 0
			}
			if yyr3105 || yy2arr3105 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy3107 := &x.PodSignature
				yy3107.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSignature"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy3108 := &x.PodSignature
				yy3108.CodecEncodeSelf(e)
			}
			if yyr3105 || yy2arr3105 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3105[1] {
					yy3110 := &x.EvictionTime
					yym3111 := z.EncBinary()
					_ = yym3111
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3110) {
					} else if yym3111 {
						z.EncBinaryMarshal(yy3110)
					} else if !yym3111 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3110)
					} else {
						z.EncFallback(yy3110)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3105[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3112 := &x.EvictionTime
					yym3113 := z.EncBinary()
					_ = yym3113
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3112) {
					} else if yym3113 {
						z.EncBinaryMarshal(yy3112)
					} else if !yym3113 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3112)
					} else {
						z.EncFallback(yy3112)
					}
				}
			}
			if yyr3105 || yy2arr3105 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3105[2] {
					yym3115 := z.EncBinary()
					_ = yym3115
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3105[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3116 := z.EncBinary()
					_ = yym3116
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3105 || yy2arr3105 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3105[3] {
					yym3118 := z.EncBinary()
					_ = yym3118
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3105[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3119 := z.EncBinary()
					_ = yym3119
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3105 || yy2arr3105 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferAvoidPodsEntry) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3120 := z.DecBinary()
	_ = yym3120
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3121 := r.ContainerType()
		if yyct3121 == codecSelferValueTypeMap1234 {
			yyl3121 := r.ReadMapStart()
			if yyl3121 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3121, d)
			}
		} else if yyct3121 == codecSelferValueTypeArray1234 {
			yyl3121 := r.ReadArrayStart()
			if yyl3121 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3121, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3122Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3122Slc
	var yyhl3122 bool = l >= 0
	for yyj3122 := 0; ; yyj3122++ {
		if yyhl3122 {
			if yyj3122 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3122Slc = r.DecodeBytes(yys3122Slc, true, true)
		yys3122 := string(yys3122Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3122 {
		case "podSignature":
			if r.TryDecodeAsNil() {
				x.PodSignature = PodSignature{}
			} else {
				yyv3123 := &x.PodSignature
				yyv3123.CodecDecodeSelf(d)
			}
		case "evictionTime":
			if r.TryDecodeAsNil() {
				x.EvictionTime = pkg2_unversioned.Time{}
			} else {
				yyv3124 := &x.EvictionTime
				yym3125 := z.DecBinary()
				_ = yym3125
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3124) {
				} else if yym3125 {
					z.DecBinaryUnmarshal(yyv3124)
				} else if !yym3125 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3124)
				} else {
					z.DecFallback(yyv3124, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3122)
		} // end switch yys3122
	} // end for yyj3122
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3128 int
	var yyb3128 bool
	var yyhl3128 bool = l >= 0
	yyj3128++
	if yyhl3128 {
		yyb3128 = yyj3128 > l
	} else {
		yyb3128 = r.CheckBreak()
	}
	if yyb3128 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSignature = PodSignature{}
	} else {
		yyv3129 := &x.PodSignature
		yyv3129.CodecDecodeSelf(d)
	}
	yyj3128++
	if yyhl3128 {
		yyb3128 = yyj3128 > l
	} else {
		yyb3128 = r.CheckBreak()
	}
	if yyb3128 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionTime = pkg2_unversioned.Time{}
	} else {
		yyv3130 := &x.EvictionTime
		yym3131 := z.DecBinary()
		_ = yym3131
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3130) {
		} else if yym3131 {
			z.DecBinaryUnmarshal(yyv3130)
		} else if !yym3131 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3130)
		} else {
			z.DecFallback(yyv3130, false)
		}
	}
	yyj3128++
	if yyhl3128 {
		yyb3128 = yyj3128 > l
	} else {
		yyb3128 = r.CheckBreak()
	}
	if yyb3128 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3128++
	if yyhl3128 {
		yyb3128 = yyj3128 > l
	} else {
		yyb3128 = r.CheckBreak()
	}
	if yyb3128 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj3128++
		if yyhl3128 {
			yyb3128 = yyj3128 > l
		} else {
			yyb3128 = r.CheckBreak()
		}
		if yyb3128 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3128-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSignature) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3134 := z.EncBinary()
		_ = yym3134
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3135 := !z.EncBinary()
			yy2arr3135 := z.EncBasicHandle().StructToArray
			var yyq3135 [1]bool
			_, _, _ = yysep3135, yyq3135, yy2arr3135
			const yyr3135 bool = false
			yyq3135[0] = x.PodController != nil
			var yynn3135 int
			if yyr3135 || yy2arr3135 {
				r.EncodeArrayStart(1)
			} else {
				yynn3135 = 0
				for _, b := range yyq3135 {
					if b {
						yynn3135++
					}
				}
				r.EncodeMapStart(yynn3135)
				yynn3135 = 0
			}
			if yyr3135 || yy2arr3135 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3135[0] {
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3135[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podController"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3135 || yy2arr3135 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSignature) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3137 := z.DecBinary()
	_ = yym3137
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3138 := r.ContainerType()
		if yyct3138 == codecSelferValueTypeMap1234 {
			yyl3138 := r.ReadMapStart()
			if yyl3138 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3138, d)
			}
		} else if yyct3138 == codecSelferValueTypeArray1234 {
			yyl3138 := r.ReadArrayStart()
			if yyl3138 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3138, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSignature) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3139Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3139Slc
	var yyhl3139 bool = l >= 0
	for yyj3139 := 0; ; yyj3139++ {
		if yyhl3139 {
			if yyj3139 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3139Slc = r.DecodeBytes(yys3139Slc, true, true)
		yys3139 := string(yys3139Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3139 {
		case "podController":
			if r.TryDecodeAsNil() {
				if x.PodController != nil {
					x.PodController = nil
				}
			} else {
				if x.PodController == nil {
					x.PodController = new(OwnerReference)
				}
				x.PodController.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3139)
		} // end switch yys3139
	} // end for yyj3139
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSignature) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3141 int
	var yyb3141 bool
	var yyhl3141 bool = l >= 0
	yyj3141++
	if yyhl3141 {
		yyb3141 = yyj3141 > l
	} else {
		yyb3141 = r.CheckBreak()
	}
	if yyb3141 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodController != nil {
			x.PodController = nil
		}
	} else {
		if x.PodController == nil {
			x.PodController = new(OwnerReference)
		}
		x.PodController.CodecDecodeSelf(d)
	}
	for {
		yyj3141++
		if yyhl3141 {
			yyb3141 = yyj3141 > l
		} else {
			yyb3141 = r.CheckBreak()
		}
		if yyb3141 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3141-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerImage) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3143 := z.EncBinary()
		_ = yym3143
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3144 := !z.EncBinary()
			yy2arr3144 := z.EncBasicHandle().StructToArray
			var yyq3144 [2]bool
			_, _, _ = yysep3144, yyq3144, yy2arr3144
			const yyr3144 bool = false
			yyq3144[1] = x.SizeBytes != 0
			var yynn3144 int
			if yyr3144 || yy2arr3144 {
				r.EncodeArrayStart(2)
			} else {
				yynn3144 = 1
				for _, b := range yyq3144 {
					if b {
						yynn3144++
					}
				}
				r.EncodeMapStart(yynn3144)
				yynn3144 = 0
			}
			if yyr3144 || yy2arr3144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3146 := z.EncBinary()
					_ = yym3146
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("names"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3147 := z.EncBinary()
					_ = yym3147
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			}
			if yyr3144 || yy2arr3144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3144[1] {
					yym3149 := z.EncBinary()
					_ = yym3149
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq3144[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sizeBytes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3150 := z.EncBinary()
					_ = yym3150
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				}
			}
			if yyr3144 || yy2arr3144 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerImage) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3151 := z.DecBinary()
	_ = yym3151
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3152 := r.ContainerType()
		if yyct3152 == codecSelferValueTypeMap1234 {
			yyl3152 := r.ReadMapStart()
			if yyl3152 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3152, d)
			}
		} else if yyct3152 == codecSelferValueTypeArray1234 {
			yyl3152 := r.ReadArrayStart()
			if yyl3152 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3152, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerImage) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3153Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3153Slc
	var yyhl3153 bool = l >= 0
	for yyj3153 := 0; ; yyj3153++ {
		if yyhl3153 {
			if yyj3153 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3153Slc = r.DecodeBytes(yys3153Slc, true, true)
		yys3153 := string(yys3153Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3153 {
		case "names":
			if r.TryDecodeAsNil() {
				x.Names = nil
			} else {
				yyv3154 := &x.Names
				yym3155 := z.DecBinary()
				_ = yym3155
				if false {
				} else {
					z.F.DecSliceStringX(yyv3154, false, d)
				}
			}
		case "sizeBytes":
			if r.TryDecodeAsNil() {
				x.SizeBytes = 0
			} else {
				x.SizeBytes = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys3153)
		} // end switch yys3153
	} // end for yyj3153
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerImage) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3157 int
	var yyb3157 bool
	var yyhl3157 bool = l >= 0
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Names = nil
	} else {
		yyv3158 := &x.Names
		yym3159 := z.DecBinary()
		_ = yym3159
		if false {
		} else {
			z.F.DecSliceStringX(yyv3158, false, d)
		}
	}
	yyj3157++
	if yyhl3157 {
		yyb3157 = yyj3157 > l
	} else {
		yyb3157 = r.CheckBreak()
	}
	if yyb3157 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SizeBytes = 0
	} else {
		x.SizeBytes = int64(r.DecodeInt(64))
	}
	for {
		yyj3157++
		if yyhl3157 {
			yyb3157 = yyj3157 > l
		} else {
			yyb3157 = r.CheckBreak()
		}
		if yyb3157 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3157-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3161 := z.EncBinary()
	_ = yym3161
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3162 := z.DecBinary()
	_ = yym3162
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x NodeConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3163 := z.EncBinary()
	_ = yym3163
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3164 := z.DecBinary()
	_ = yym3164
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3165 := z.EncBinary()
		_ = yym3165
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3166 := !z.EncBinary()
			yy2arr3166 := z.EncBasicHandle().StructToArray
			var yyq3166 [6]bool
			_, _, _ = yysep3166, yyq3166, yy2arr3166
			const yyr3166 bool = false
			yyq3166[2] = true
			yyq3166[3] = true
			yyq3166[4] = x.Reason != ""
			yyq3166[5] = x.Message != ""
			var yynn3166 int
			if yyr3166 || yy2arr3166 {
				r.EncodeArrayStart(6)
			} else {
				yynn3166 = 2
				for _, b := range yyq3166 {
					if b {
						yynn3166++
					}
				}
				r.EncodeMapStart(yynn3166)
				yynn3166 = 0
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3166[2] {
					yy3170 := &x.LastHeartbeatTime
					yym3171 := z.EncBinary()
					_ = yym3171
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3170) {
					} else if yym3171 {
						z.EncBinaryMarshal(yy3170)
					} else if !yym3171 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3170)
					} else {
						z.EncFallback(yy3170)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3166[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastHeartbeatTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3172 := &x.LastHeartbeatTime
					yym3173 := z.EncBinary()
					_ = yym3173
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3172) {
					} else if yym3173 {
						z.EncBinaryMarshal(yy3172)
					} else if !yym3173 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3172)
					} else {
						z.EncFallback(yy3172)
					}
				}
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3166[3] {
					yy3175 := &x.LastTransitionTime
					yym3176 := z.EncBinary()
					_ = yym3176
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3175) {
					} else if yym3176 {
						z.EncBinaryMarshal(yy3175)
					} else if !yym3176 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3175)
					} else {
						z.EncFallback(yy3175)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3166[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3177 := &x.LastTransitionTime
					yym3178 := z.EncBinary()
					_ = yym3178
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3177) {
					} else if yym3178 {
						z.EncBinaryMarshal(yy3177)
					} else if !yym3178 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3177)
					} else {
						z.EncFallback(yy3177)
					}
				}
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3166[4] {
					yym3180 := z.EncBinary()
					_ = yym3180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3166[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3181 := z.EncBinary()
					_ = yym3181
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3166[5] {
					yym3183 := z.EncBinary()
					_ = yym3183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3166[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3184 := z.EncBinary()
					_ = yym3184
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3166 || yy2arr3166 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3185 := z.DecBinary()
	_ = yym3185
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3186 := r.ContainerType()
		if yyct3186 == codecSelferValueTypeMap1234 {
			yyl3186 := r.ReadMapStart()
			if yyl3186 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3186, d)
			}
		} else if yyct3186 == codecSelferValueTypeArray1234 {
			yyl3186 := r.ReadArrayStart()
			if yyl3186 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3186, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3187Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3187Slc
	var yyhl3187 bool = l >= 0
	for yyj3187 := 0; ; yyj3187++ {
		if yyhl3187 {
			if yyj3187 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3187Slc = r.DecodeBytes(yys3187Slc, true, true)
		yys3187 := string(yys3187Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3187 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = NodeConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastHeartbeatTime":
			if r.TryDecodeAsNil() {
				x.LastHeartbeatTime = pkg2_unversioned.Time{}
			} else {
				yyv3190 := &x.LastHeartbeatTime
				yym3191 := z.DecBinary()
				_ = yym3191
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3190) {
				} else if yym3191 {
					z.DecBinaryUnmarshal(yyv3190)
				} else if !yym3191 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3190)
				} else {
					z.DecFallback(yyv3190, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv3192 := &x.LastTransitionTime
				yym3193 := z.DecBinary()
				_ = yym3193
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3192) {
				} else if yym3193 {
					z.DecBinaryUnmarshal(yyv3192)
				} else if !yym3193 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3192)
				} else {
					z.DecFallback(yyv3192, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3187)
		} // end switch yys3187
	} // end for yyj3187
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3196 int
	var yyb3196 bool
	var yyhl3196 bool = l >= 0
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = NodeConditionType(r.DecodeString())
	}
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastHeartbeatTime = pkg2_unversioned.Time{}
	} else {
		yyv3199 := &x.LastHeartbeatTime
		yym3200 := z.DecBinary()
		_ = yym3200
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3199) {
		} else if yym3200 {
			z.DecBinaryUnmarshal(yyv3199)
		} else if !yym3200 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3199)
		} else {
			z.DecFallback(yyv3199, false)
		}
	}
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv3201 := &x.LastTransitionTime
		yym3202 := z.DecBinary()
		_ = yym3202
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3201) {
		} else if yym3202 {
			z.DecBinaryUnmarshal(yyv3201)
		} else if !yym3202 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3201)
		} else {
			z.DecFallback(yyv3201, false)
		}
	}
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3196++
	if yyhl3196 {
		yyb3196 = yyj3196 > l
	} else {
		yyb3196 = r.CheckBreak()
	}
	if yyb3196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj3196++
		if yyhl3196 {
			yyb3196 = yyj3196 > l
		} else {
			yyb3196 = r.CheckBreak()
		}
		if yyb3196 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3196-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeAddressType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3205 := z.EncBinary()
	_ = yym3205
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeAddressType) 