// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	api "github.com/openshift/origin/pkg/image/api"
	pkg_api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_DockerImageReference_To_api_DockerImageReference,
		Convert_api_DockerImageReference_To_v1_DockerImageReference,
		Convert_v1_Image_To_api_Image,
		Convert_api_Image_To_v1_Image,
		Convert_v1_ImageImportSpec_To_api_ImageImportSpec,
		Convert_api_ImageImportSpec_To_v1_ImageImportSpec,
		Convert_v1_ImageImportStatus_To_api_ImageImportStatus,
		Convert_api_ImageImportStatus_To_v1_ImageImportStatus,
		Convert_v1_ImageLayer_To_api_ImageLayer,
		Convert_api_ImageLayer_To_v1_ImageLayer,
		Convert_v1_ImageList_To_api_ImageList,
		Convert_api_ImageList_To_v1_ImageList,
		Convert_v1_ImageSignature_To_api_ImageSignature,
		Convert_api_ImageSignature_To_v1_ImageSignature,
		Convert_v1_ImageStream_To_api_ImageStream,
		Convert_api_ImageStream_To_v1_ImageStream,
		Convert_v1_ImageStreamImage_To_api_ImageStreamImage,
		Convert_api_ImageStreamImage_To_v1_ImageStreamImage,
		Convert_v1_ImageStreamImport_To_api_ImageStreamImport,
		Convert_api_ImageStreamImport_To_v1_ImageStreamImport,
		Convert_v1_ImageStreamImportSpec_To_api_ImageStreamImportSpec,
		Convert_api_ImageStreamImportSpec_To_v1_ImageStreamImportSpec,
		Convert_v1_ImageStreamImportStatus_To_api_ImageStreamImportStatus,
		Convert_api_ImageStreamImportStatus_To_v1_ImageStreamImportStatus,
		Convert_v1_ImageStreamList_To_api_ImageStreamList,
		Convert_api_ImageStreamList_To_v1_ImageStreamList,
		Convert_v1_ImageStreamMapping_To_api_ImageStreamMapping,
		Convert_api_ImageStreamMapping_To_v1_ImageStreamMapping,
		Convert_v1_ImageStreamSpec_To_api_ImageStreamSpec,
		Convert_api_ImageStreamSpec_To_v1_ImageStreamSpec,
		Convert_v1_ImageStreamStatus_To_api_ImageStreamStatus,
		Convert_api_ImageStreamStatus_To_v1_ImageStreamStatus,
		Convert_v1_ImageStreamTag_To_api_ImageStreamTag,
		Convert_api_ImageStreamTag_To_v1_ImageStreamTag,
		Convert_v1_ImageStreamTagList_To_api_ImageStreamTagList,
		Convert_api_ImageStreamTagList_To_v1_ImageStreamTagList,
		Convert_v1_RepositoryImportSpec_To_api_RepositoryImportSpec,
		Convert_api_RepositoryImportSpec_To_v1_RepositoryImportSpec,
		Convert_v1_RepositoryImportStatus_To_api_RepositoryImportStatus,
		Convert_api_RepositoryImportStatus_To_v1_RepositoryImportStatus,
		Convert_v1_SignatureCondition_To_api_SignatureCondition,
		Convert_api_SignatureCondition_To_v1_SignatureCondition,
		Convert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity,
		Convert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity,
		Convert_v1_SignatureIssuer_To_api_SignatureIssuer,
		Convert_api_SignatureIssuer_To_v1_SignatureIssuer,
		Convert_v1_SignatureSubject_To_api_SignatureSubject,
		Convert_api_SignatureSubject_To_v1_SignatureSubject,
		Convert_v1_TagEvent_To_api_TagEvent,
		Convert_api_TagEvent_To_v1_TagEvent,
		Convert_v1_TagEventCondition_To_api_TagEventCondition,
		Convert_api_TagEventCondition_To_v1_TagEventCondition,
		Convert_v1_TagImportPolicy_To_api_TagImportPolicy,
		Convert_api_TagImportPolicy_To_v1_TagImportPolicy,
		Convert_v1_TagReference_To_api_TagReference,
		Convert_api_TagReference_To_v1_TagReference,
	)
}

func autoConvert_v1_DockerImageReference_To_api_DockerImageReference(in *DockerImageReference, out *api.DockerImageReference, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.Tag = in.Tag
	out.ID = in.ID
	return nil
}

func Convert_v1_DockerImageReference_To_api_DockerImageReference(in *DockerImageReference, out *api.DockerImageReference, s conversion.Scope) error {
	return autoConvert_v1_DockerImageReference_To_api_DockerImageReference(in, out, s)
}

func autoConvert_api_DockerImageReference_To_v1_DockerImageReference(in *api.DockerImageReference, out *DockerImageReference, s conversion.Scope) error {
	out.Registry = in.Registry
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.Tag = in.Tag
	out.ID = in.ID
	return nil
}

func Convert_api_DockerImageReference_To_v1_DockerImageReference(in *api.DockerImageReference, out *DockerImageReference, s conversion.Scope) error {
	return autoConvert_api_DockerImageReference_To_v1_DockerImageReference(in, out, s)
}

func autoConvert_v1_ImageImportSpec_To_api_ImageImportSpec(in *ImageImportSpec, out *api.ImageImportSpec, s conversion.Scope) error {
	SetDefaults_ImageImportSpec(in)
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(pkg_api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_v1_TagImportPolicy_To_api_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func Convert_v1_ImageImportSpec_To_api_ImageImportSpec(in *ImageImportSpec, out *api.ImageImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageImportSpec_To_api_ImageImportSpec(in, out, s)
}

func autoConvert_api_ImageImportSpec_To_v1_ImageImportSpec(in *api.ImageImportSpec, out *ImageImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := Convert_api_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func Convert_api_ImageImportSpec_To_v1_ImageImportSpec(in *api.ImageImportSpec, out *ImageImportSpec, s conversion.Scope) error {
	return autoConvert_api_ImageImportSpec_To_v1_ImageImportSpec(in, out, s)
}

func autoConvert_v1_ImageImportStatus_To_api_ImageImportStatus(in *ImageImportStatus, out *api.ImageImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(api.Image)
		if err := Convert_v1_Image_To_api_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	out.Tag = in.Tag
	return nil
}

func Convert_v1_ImageImportStatus_To_api_ImageImportStatus(in *ImageImportStatus, out *api.ImageImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageImportStatus_To_api_ImageImportStatus(in, out, s)
}

func autoConvert_api_ImageImportStatus_To_v1_ImageImportStatus(in *api.ImageImportStatus, out *ImageImportStatus, s conversion.Scope) error {
	out.Tag = in.Tag
	out.Status = in.Status
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(Image)
		if err := Convert_api_Image_To_v1_Image(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

func Convert_api_ImageImportStatus_To_v1_ImageImportStatus(in *api.ImageImportStatus, out *ImageImportStatus, s conversion.Scope) error {
	return autoConvert_api_ImageImportStatus_To_v1_ImageImportStatus(in, out, s)
}

func autoConvert_v1_ImageLayer_To_api_ImageLayer(in *ImageLayer, out *api.ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

func Convert_v1_ImageLayer_To_api_ImageLayer(in *ImageLayer, out *api.ImageLayer, s conversion.Scope) error {
	return autoConvert_v1_ImageLayer_To_api_ImageLayer(in, out, s)
}

func autoConvert_api_ImageLayer_To_v1_ImageLayer(in *api.ImageLayer, out *ImageLayer, s conversion.Scope) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

func Convert_api_ImageLayer_To_v1_ImageLayer(in *api.ImageLayer, out *ImageLayer, s conversion.Scope) error {
	return autoConvert_api_ImageLayer_To_v1_ImageLayer(in, out, s)
}

func autoConvert_v1_ImageList_To_api_ImageList(in *ImageList, out *api.ImageList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.Image, len(*in))
		for i := range *in {
			if err := Convert_v1_Image_To_api_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ImageList_To_api_ImageList(in *ImageList, out *api.ImageList, s conversion.Scope) error {
	return autoConvert_v1_ImageList_To_api_ImageList(in, out, s)
}

func autoConvert_api_ImageList_To_v1_ImageList(in *api.ImageList, out *ImageList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Image, len(*in))
		for i := range *in {
			if err := Convert_api_Image_To_v1_Image(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ImageList_To_v1_ImageList(in *api.ImageList, out *ImageList, s conversion.Scope) error {
	return autoConvert_api_ImageList_To_v1_ImageList(in, out, s)
}

func autoConvert_v1_ImageSignature_To_api_ImageSignature(in *ImageSignature, out *api.ImageSignature, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.Type = in.Type
	if err := conversion.Convert_Slice_byte_To_Slice_byte(&in.Content, &out.Content, s); err != nil {
		return err
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]api.SignatureCondition, len(*in))
		for i := range *in {
			if err := Convert_v1_SignatureCondition_To_api_SignatureCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = in.SignedClaims
	out.Created = in.Created
	if in.IssuedBy != nil {
		in, out := &in.IssuedBy, &out.IssuedBy
		*out = new(api.SignatureIssuer)
		if err := Convert_v1_SignatureIssuer_To_api_SignatureIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IssuedBy = nil
	}
	if in.IssuedTo != nil {
		in, out := &in.IssuedTo, &out.IssuedTo
		*out = new(api.SignatureSubject)
		if err := Convert_v1_SignatureSubject_To_api_SignatureSubject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IssuedTo = nil
	}
	return nil
}

func Convert_v1_ImageSignature_To_api_ImageSignature(in *ImageSignature, out *api.ImageSignature, s conversion.Scope) error {
	return autoConvert_v1_ImageSignature_To_api_ImageSignature(in, out, s)
}

func autoConvert_api_ImageSignature_To_v1_ImageSignature(in *api.ImageSignature, out *ImageSignature, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	out.Type = in.Type
	if err := conversion.Convert_Slice_byte_To_Slice_byte(&in.Content, &out.Content, s); err != nil {
		return err
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]SignatureCondition, len(*in))
		for i := range *in {
			if err := Convert_api_SignatureCondition_To_v1_SignatureCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.ImageIdentity = in.ImageIdentity
	out.SignedClaims = in.SignedClaims
	out.Created = in.Created
	if in.IssuedBy != nil {
		in, out := &in.IssuedBy, &out.IssuedBy
		*out = new(SignatureIssuer)
		if err := Convert_api_SignatureIssuer_To_v1_SignatureIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IssuedBy = nil
	}
	if in.IssuedTo != nil {
		in, out := &in.IssuedTo, &out.IssuedTo
		*out = new(SignatureSubject)
		if err := Convert_api_SignatureSubject_To_v1_SignatureSubject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.IssuedTo = nil
	}
	return nil
}

func Convert_api_ImageSignature_To_v1_ImageSignature(in *api.ImageSignature, out *ImageSignature, s conversion.Scope) error {
	return autoConvert_api_ImageSignature_To_v1_ImageSignature(in, out, s)
}

func autoConvert_v1_ImageStream_To_api_ImageStream(in *ImageStream, out *api.ImageStream, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamSpec_To_api_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamStatus_To_api_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_ImageStream_To_api_ImageStream(in *ImageStream, out *api.ImageStream, s conversion.Scope) error {
	return autoConvert_v1_ImageStream_To_api_ImageStream(in, out, s)
}

func autoConvert_api_ImageStream_To_v1_ImageStream(in *api.ImageStream, out *ImageStream, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_ImageStreamSpec_To_v1_ImageStreamSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_ImageStreamStatus_To_v1_ImageStreamStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ImageStream_To_v1_ImageStream(in *api.ImageStream, out *ImageStream, s conversion.Scope) error {
	return autoConvert_api_ImageStream_To_v1_ImageStream(in, out, s)
}

func autoConvert_v1_ImageStreamImage_To_api_ImageStreamImage(in *ImageStreamImage, out *api.ImageStreamImage, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_Image_To_api_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_ImageStreamImage_To_api_ImageStreamImage(in *ImageStreamImage, out *api.ImageStreamImage, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImage_To_api_ImageStreamImage(in, out, s)
}

func autoConvert_api_ImageStreamImage_To_v1_ImageStreamImage(in *api.ImageStreamImage, out *ImageStreamImage, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ImageStreamImage_To_v1_ImageStreamImage(in *api.ImageStreamImage, out *ImageStreamImage, s conversion.Scope) error {
	return autoConvert_api_ImageStreamImage_To_v1_ImageStreamImage(in, out, s)
}

func autoConvert_v1_ImageStreamImport_To_api_ImageStreamImport(in *ImageStreamImport, out *api.ImageStreamImport, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamImportSpec_To_api_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ImageStreamImportStatus_To_api_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_ImageStreamImport_To_api_ImageStreamImport(in *ImageStreamImport, out *api.ImageStreamImport, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImport_To_api_ImageStreamImport(in, out, s)
}

func autoConvert_api_ImageStreamImport_To_v1_ImageStreamImport(in *api.ImageStreamImport, out *ImageStreamImport, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_api_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ImageStreamImport_To_v1_ImageStreamImport(in *api.ImageStreamImport, out *ImageStreamImport, s conversion.Scope) error {
	return autoConvert_api_ImageStreamImport_To_v1_ImageStreamImport(in, out, s)
}

func autoConvert_v1_ImageStreamImportSpec_To_api_ImageStreamImportSpec(in *ImageStreamImportSpec, out *api.ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(api.RepositoryImportSpec)
		if err := Convert_v1_RepositoryImportSpec_To_api_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]api.ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportSpec_To_api_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func Convert_v1_ImageStreamImportSpec_To_api_ImageStreamImportSpec(in *ImageStreamImportSpec, out *api.ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportSpec_To_api_ImageStreamImportSpec(in, out, s)
}

func autoConvert_api_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *api.ImageStreamImportSpec, out *ImageStreamImportSpec, s conversion.Scope) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(RepositoryImportSpec)
		if err := Convert_api_RepositoryImportSpec_To_v1_RepositoryImportSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportSpec, len(*in))
		for i := range *in {
			if err := Convert_api_ImageImportSpec_To_v1_ImageImportSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func Convert_api_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in *api.ImageStreamImportSpec, out *ImageStreamImportSpec, s conversion.Scope) error {
	return autoConvert_api_ImageStreamImportSpec_To_v1_ImageStreamImportSpec(in, out, s)
}

func autoConvert_v1_ImageStreamImportStatus_To_api_ImageStreamImportStatus(in *ImageStreamImportStatus, out *api.ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(api.ImageStream)
		if err := Convert_v1_ImageStream_To_api_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(api.RepositoryImportStatus)
		if err := Convert_v1_RepositoryImportStatus_To_api_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]api.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_api_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func Convert_v1_ImageStreamImportStatus_To_api_ImageStreamImportStatus(in *ImageStreamImportStatus, out *api.ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamImportStatus_To_api_ImageStreamImportStatus(in, out, s)
}

func autoConvert_api_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *api.ImageStreamImportStatus, out *ImageStreamImportStatus, s conversion.Scope) error {
	if in.Import != nil {
		in, out := &in.Import, &out.Import
		*out = new(ImageStream)
		if err := Convert_api_ImageStream_To_v1_ImageStream(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := &in.Repository, &out.Repository
		*out = new(RepositoryImportStatus)
		if err := Convert_api_RepositoryImportStatus_To_v1_RepositoryImportStatus(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_api_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func Convert_api_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in *api.ImageStreamImportStatus, out *ImageStreamImportStatus, s conversion.Scope) error {
	return autoConvert_api_ImageStreamImportStatus_To_v1_ImageStreamImportStatus(in, out, s)
}

func autoConvert_v1_ImageStreamList_To_api_ImageStreamList(in *ImageStreamList, out *api.ImageStreamList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ImageStream, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStream_To_api_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ImageStreamList_To_api_ImageStreamList(in *ImageStreamList, out *api.ImageStreamList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamList_To_api_ImageStreamList(in, out, s)
}

func autoConvert_api_ImageStreamList_To_v1_ImageStreamList(in *api.ImageStreamList, out *ImageStreamList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageStream, len(*in))
		for i := range *in {
			if err := Convert_api_ImageStream_To_v1_ImageStream(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ImageStreamList_To_v1_ImageStreamList(in *api.ImageStreamList, out *ImageStreamList, s conversion.Scope) error {
	return autoConvert_api_ImageStreamList_To_v1_ImageStreamList(in, out, s)
}

func autoConvert_v1_ImageStreamMapping_To_api_ImageStreamMapping(in *ImageStreamMapping, out *api.ImageStreamMapping, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1_Image_To_api_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_api_ImageStreamMapping_To_v1_ImageStreamMapping(in *api.ImageStreamMapping, out *ImageStreamMapping, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_api_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func autoConvert_v1_ImageStreamTag_To_api_ImageStreamTag(in *ImageStreamTag, out *api.ImageStreamTag, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ObjectMeta_To_api_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(api.TagReference)
		if err := Convert_v1_TagReference_To_api_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]api.TagEventCondition, len(*in))
		for i := range *in {
			if err := Convert_v1_TagEventCondition_To_api_TagEventCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	if err := Convert_v1_Image_To_api_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_ImageStreamTag_To_api_ImageStreamTag(in *ImageStreamTag, out *api.ImageStreamTag, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTag_To_api_ImageStreamTag(in, out, s)
}

func autoConvert_api_ImageStreamTag_To_v1_ImageStreamTag(in *api.ImageStreamTag, out *ImageStreamTag, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ObjectMeta_To_v1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(TagReference)
		if err := Convert_api_TagReference_To_v1_TagReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]TagEventCondition, len(*in))
		for i := range *in {
			if err := Convert_api_TagEventCondition_To_v1_TagEventCondition(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	if err := Convert_api_Image_To_v1_Image(&in.Image, &out.Image, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_ImageStreamTag_To_v1_ImageStreamTag(in *api.ImageStreamTag, out *ImageStreamTag, s conversion.Scope) error {
	return autoConvert_api_ImageStreamTag_To_v1_ImageStreamTag(in, out, s)
}

func autoConvert_v1_ImageStreamTagList_To_api_ImageStreamTagList(in *ImageStreamTagList, out *api.ImageStreamTagList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]api.ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageStreamTag_To_api_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_v1_ImageStreamTagList_To_api_ImageStreamTagList(in *ImageStreamTagList, out *api.ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_v1_ImageStreamTagList_To_api_ImageStreamTagList(in, out, s)
}

func autoConvert_api_ImageStreamTagList_To_v1_ImageStreamTagList(in *api.ImageStreamTagList, out *ImageStreamTagList, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_TypeMeta_To_unversioned_TypeMeta(&in.TypeMeta, &out.TypeMeta, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_ListMeta_To_unversioned_ListMeta(&in.ListMeta, &out.ListMeta, s); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ImageStreamTag, len(*in))
		for i := range *in {
			if err := Convert_api_ImageStreamTag_To_v1_ImageStreamTag(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func Convert_api_ImageStreamTagList_To_v1_ImageStreamTagList(in *api.ImageStreamTagList, out *ImageStreamTagList, s conversion.Scope) error {
	return autoConvert_api_ImageStreamTagList_To_v1_ImageStreamTagList(in, out, s)
}

func autoConvert_v1_RepositoryImportSpec_To_api_RepositoryImportSpec(in *RepositoryImportSpec, out *api.RepositoryImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_v1_TagImportPolicy_To_api_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func Convert_v1_RepositoryImportSpec_To_api_RepositoryImportSpec(in *RepositoryImportSpec, out *api.RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportSpec_To_api_RepositoryImportSpec(in, out, s)
}

func autoConvert_api_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *api.RepositoryImportSpec, out *RepositoryImportSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if err := Convert_api_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func Convert_api_RepositoryImportSpec_To_v1_RepositoryImportSpec(in *api.RepositoryImportSpec, out *RepositoryImportSpec, s conversion.Scope) error {
	return autoConvert_api_RepositoryImportSpec_To_v1_RepositoryImportSpec(in, out, s)
}

func autoConvert_v1_RepositoryImportStatus_To_api_RepositoryImportStatus(in *RepositoryImportStatus, out *api.RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]api.ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageImportStatus_To_api_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = in.AdditionalTags
	return nil
}

func Convert_v1_RepositoryImportStatus_To_api_RepositoryImportStatus(in *RepositoryImportStatus, out *api.RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_v1_RepositoryImportStatus_To_api_RepositoryImportStatus(in, out, s)
}

func autoConvert_api_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *api.RepositoryImportStatus, out *RepositoryImportStatus, s conversion.Scope) error {
	out.Status = in.Status
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageImportStatus, len(*in))
		for i := range *in {
			if err := Convert_api_ImageImportStatus_To_v1_ImageImportStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.AdditionalTags = in.AdditionalTags
	return nil
}

func Convert_api_RepositoryImportStatus_To_v1_RepositoryImportStatus(in *api.RepositoryImportStatus, out *RepositoryImportStatus, s conversion.Scope) error {
	return autoConvert_api_RepositoryImportStatus_To_v1_RepositoryImportStatus(in, out, s)
}

func autoConvert_v1_SignatureCondition_To_api_SignatureCondition(in *SignatureCondition, out *api.SignatureCondition, s conversion.Scope) error {
	out.Type = api.SignatureConditionType(in.Type)
	out.Status = pkg_api.ConditionStatus(in.Status)
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastProbeTime, &out.LastProbeTime, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastTransitionTime, &out.LastTransitionTime, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func Convert_v1_SignatureCondition_To_api_SignatureCondition(in *SignatureCondition, out *api.SignatureCondition, s conversion.Scope) error {
	return autoConvert_v1_SignatureCondition_To_api_SignatureCondition(in, out, s)
}

func autoConvert_api_SignatureCondition_To_v1_SignatureCondition(in *api.SignatureCondition, out *SignatureCondition, s conversion.Scope) error {
	out.Type = SignatureConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastProbeTime, &out.LastProbeTime, s); err != nil {
		return err
	}
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastTransitionTime, &out.LastTransitionTime, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func Convert_api_SignatureCondition_To_v1_SignatureCondition(in *api.SignatureCondition, out *SignatureCondition, s conversion.Scope) error {
	return autoConvert_api_SignatureCondition_To_v1_SignatureCondition(in, out, s)
}

func autoConvert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity(in *SignatureGenericEntity, out *api.SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

func Convert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity(in *SignatureGenericEntity, out *api.SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity(in, out, s)
}

func autoConvert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *api.SignatureGenericEntity, out *SignatureGenericEntity, s conversion.Scope) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

func Convert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity(in *api.SignatureGenericEntity, out *SignatureGenericEntity, s conversion.Scope) error {
	return autoConvert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity(in, out, s)
}

func autoConvert_v1_SignatureIssuer_To_api_SignatureIssuer(in *SignatureIssuer, out *api.SignatureIssuer, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_SignatureIssuer_To_api_SignatureIssuer(in *SignatureIssuer, out *api.SignatureIssuer, s conversion.Scope) error {
	return autoConvert_v1_SignatureIssuer_To_api_SignatureIssuer(in, out, s)
}

func autoConvert_api_SignatureIssuer_To_v1_SignatureIssuer(in *api.SignatureIssuer, out *SignatureIssuer, s conversion.Scope) error {
	if err := Convert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_SignatureIssuer_To_v1_SignatureIssuer(in *api.SignatureIssuer, out *SignatureIssuer, s conversion.Scope) error {
	return autoConvert_api_SignatureIssuer_To_v1_SignatureIssuer(in, out, s)
}

func autoConvert_v1_SignatureSubject_To_api_SignatureSubject(in *SignatureSubject, out *api.SignatureSubject, s conversion.Scope) error {
	if err := Convert_v1_SignatureGenericEntity_To_api_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

func Convert_v1_SignatureSubject_To_api_SignatureSubject(in *SignatureSubject, out *api.SignatureSubject, s conversion.Scope) error {
	return autoConvert_v1_SignatureSubject_To_api_SignatureSubject(in, out, s)
}

func autoConvert_api_SignatureSubject_To_v1_SignatureSubject(in *api.SignatureSubject, out *SignatureSubject, s conversion.Scope) error {
	if err := Convert_api_SignatureGenericEntity_To_v1_SignatureGenericEntity(&in.SignatureGenericEntity, &out.SignatureGenericEntity, s); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

func Convert_api_SignatureSubject_To_v1_SignatureSubject(in *api.SignatureSubject, out *SignatureSubject, s conversion.Scope) error {
	return autoConvert_api_SignatureSubject_To_v1_SignatureSubject(in, out, s)
}

func autoConvert_v1_TagEvent_To_api_TagEvent(in *TagEvent, out *api.TagEvent, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.Created, &out.Created, s); err != nil {
		return err
	}
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

func Convert_v1_TagEvent_To_api_TagEvent(in *TagEvent, out *api.TagEvent, s conversion.Scope) error {
	return autoConvert_v1_TagEvent_To_api_TagEvent(in, out, s)
}

func autoConvert_api_TagEvent_To_v1_TagEvent(in *api.TagEvent, out *TagEvent, s conversion.Scope) error {
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.Created, &out.Created, s); err != nil {
		return err
	}
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

func Convert_api_TagEvent_To_v1_TagEvent(in *api.TagEvent, out *TagEvent, s conversion.Scope) error {
	return autoConvert_api_TagEvent_To_v1_TagEvent(in, out, s)
}

func autoConvert_v1_TagEventCondition_To_api_TagEventCondition(in *TagEventCondition, out *api.TagEventCondition, s conversion.Scope) error {
	out.Type = api.TagEventConditionType(in.Type)
	out.Status = pkg_api.ConditionStatus(in.Status)
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastTransitionTime, &out.LastTransitionTime, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

func Convert_v1_TagEventCondition_To_api_TagEventCondition(in *TagEventCondition, out *api.TagEventCondition, s conversion.Scope) error {
	return autoConvert_v1_TagEventCondition_To_api_TagEventCondition(in, out, s)
}

func autoConvert_api_TagEventCondition_To_v1_TagEventCondition(in *api.TagEventCondition, out *TagEventCondition, s conversion.Scope) error {
	out.Type = TagEventConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	if err := pkg_api.Convert_unversioned_Time_To_unversioned_Time(&in.LastTransitionTime, &out.LastTransitionTime, s); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

func Convert_api_TagEventCondition_To_v1_TagEventCondition(in *api.TagEventCondition, out *TagEventCondition, s conversion.Scope) error {
	return autoConvert_api_TagEventCondition_To_v1_TagEventCondition(in, out, s)
}

func autoConvert_v1_TagImportPolicy_To_api_TagImportPolicy(in *TagImportPolicy, out *api.TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

func Convert_v1_TagImportPolicy_To_api_TagImportPolicy(in *TagImportPolicy, out *api.TagImportPolicy, s conversion.Scope) error {
	return autoConvert_v1_TagImportPolicy_To_api_TagImportPolicy(in, out, s)
}

func autoConvert_api_TagImportPolicy_To_v1_TagImportPolicy(in *api.TagImportPolicy, out *TagImportPolicy, s conversion.Scope) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

func Convert_api_TagImportPolicy_To_v1_TagImportPolicy(in *api.TagImportPolicy, out *TagImportPolicy, s conversion.Scope) error {
	return autoConvert_api_TagImportPolicy_To_v1_TagImportPolicy(in, out, s)
}

func autoConvert_v1_TagReference_To_api_TagReference(in *TagReference, out *api.TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = in.Annotations
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(pkg_api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = in.Generation
	if err := Convert_v1_TagImportPolicy_To_api_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	return nil
}

func Convert_v1_TagReference_To_api_TagReference(in *TagReference, out *api.TagReference, s conversion.Scope) error {
	return autoConvert_v1_TagReference_To_api_TagReference(in, out, s)
}

func autoConvert_api_TagReference_To_v1_TagReference(in *api.TagReference, out *TagReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Annotations = in.Annotations
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	out.Generation = in.Generation
	if err := Convert_api_TagImportPolicy_To_v1_TagImportPolicy(&in.ImportPolicy, &out.ImportPolicy, s); err != nil {
		return err
	}
	return nil
}

func Convert_api_TagReference_To_v1_TagReference(in *api.TagReference, out *TagReference, s conversion.Scope) error {
	return autoConvert_api_TagReference_To_v1_TagReference(in, out, s)
}
