// Copyright 2020-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by goyacc -o proto.y.go -l -p proto proto.y. DO NOT EDIT.
package parser

import __yyfmt__ "fmt"

//lint:file-ignore SA4006 generated parser has unused values

import (
	"math"

	"github.com/bufbuild/protocompile/ast"
)

type protoSymType struct {
	yys          int
	file         *ast.FileNode
	syn          *ast.SyntaxNode
	ed           *ast.EditionNode
	fileElements []ast.FileElement
	pkg          nodeWithEmptyDecls[*ast.PackageNode]
	imprt        nodeWithEmptyDecls[*ast.ImportNode]
	msg          nodeWithEmptyDecls[*ast.MessageNode]
	msgElements  []ast.MessageElement
	fld          *ast.FieldNode
	msgFld       nodeWithEmptyDecls[*ast.FieldNode]
	mapFld       nodeWithEmptyDecls[*ast.MapFieldNode]
	mapType      *ast.MapTypeNode
	grp          *ast.GroupNode
	msgGrp       nodeWithEmptyDecls[*ast.GroupNode]
	oo           nodeWithEmptyDecls[*ast.OneofNode]
	ooElement    ast.OneofElement
	ooElements   []ast.OneofElement
	ext          nodeWithEmptyDecls[*ast.ExtensionRangeNode]
	resvd        nodeWithEmptyDecls[*ast.ReservedNode]
	en           nodeWithEmptyDecls[*ast.EnumNode]
	enElements   []ast.EnumElement
	env          nodeWithEmptyDecls[*ast.EnumValueNode]
	extend       nodeWithEmptyDecls[*ast.ExtendNode]
	extElement   ast.ExtendElement
	extElements  []ast.ExtendElement
	svc          nodeWithEmptyDecls[*ast.ServiceNode]
	svcElements  []ast.ServiceElement
	mtd          nodeWithEmptyDecls[*ast.RPCNode]
	mtdMsgType   *ast.RPCTypeNode
	mtdElements  []ast.RPCElement
	optRaw       *ast.OptionNode
	opt          nodeWithEmptyDecls[*ast.OptionNode]
	opts         *compactOptionSlices
	ref          *ast.FieldReferenceNode
	optNms       *fieldRefSlices
	cmpctOpts    *ast.CompactOptionsNode
	rng          *ast.RangeNode
	rngs         *rangeSlices
	names        *nameSlices
	cid          *identSlices
	tid          ast.IdentValueNode
	sl           *valueSlices
	msgLitFlds   *messageFieldList
	msgLitFld    *ast.MessageFieldNode
	v            ast.ValueNode
	il           ast.IntValueNode
	str          []*ast.StringLiteralNode
	s            *ast.StringLiteralNode
	i            *ast.UintLiteralNode
	f            *ast.FloatLiteralNode
	id           *ast.IdentNode
	b            *ast.RuneNode
	bs           []*ast.RuneNode
	err          error
}

const _STRING_LIT = 57346
const _INT_LIT = 57347
const _FLOAT_LIT = 57348
const _NAME = 57349
const _SYNTAX = 57350
const _EDITION = 57351
const _IMPORT = 57352
const _WEAK = 57353
const _PUBLIC = 57354
const _PACKAGE = 57355
const _OPTION = 57356
const _TRUE = 57357
const _FALSE = 57358
const _INF = 57359
const _NAN = 57360
const _REPEATED = 57361
const _OPTIONAL = 57362
const _REQUIRED = 57363
const _DOUBLE = 57364
const _FLOAT = 57365
const _INT32 = 57366
const _INT64 = 57367
const _UINT32 = 57368
const _UINT64 = 57369
const _SINT32 = 57370
const _SINT64 = 57371
const _FIXED32 = 57372
const _FIXED64 = 57373
const _SFIXED32 = 57374
const _SFIXED64 = 57375
const _BOOL = 57376
const _STRING = 57377
const _BYTES = 57378
const _GROUP = 57379
const _ONEOF = 57380
const _MAP = 57381
const _EXTENSIONS = 57382
const _TO = 57383
const _MAX = 57384
const _RESERVED = 57385
const _ENUM = 57386
const _MESSAGE = 57387
const _EXTEND = 57388
const _SERVICE = 57389
const _RPC = 57390
const _STREAM = 57391
const _RETURNS = 57392
const _ERROR = 57393

var protoToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_STRING_LIT",
	"_INT_LIT",
	"_FLOAT_LIT",
	"_NAME",
	"_SYNTAX",
	"_EDITION",
	"_IMPORT",
	"_WEAK",
	"_PUBLIC",
	"_PACKAGE",
	"_OPTION",
	"_TRUE",
	"_FALSE",
	"_INF",
	"_NAN",
	"_REPEATED",
	"_OPTIONAL",
	"_REQUIRED",
	"_DOUBLE",
	"_FLOAT",
	"_INT32",
	"_INT64",
	"_UINT32",
	"_UINT64",
	"_SINT32",
	"_SINT64",
	"_FIXED32",
	"_FIXED64",
	"_SFIXED32",
	"_SFIXED64",
	"_BOOL",
	"_STRING",
	"_BYTES",
	"_GROUP",
	"_ONEOF",
	"_MAP",
	"_EXTENSIONS",
	"_TO",
	"_MAX",
	"_RESERVED",
	"_ENUM",
	"_MESSAGE",
	"_EXTEND",
	"_SERVICE",
	"_RPC",
	"_STREAM",
	"_RETURNS",
	"_ERROR",
	"'='",
	"';'",
	"':'",
	"'{'",
	"'}'",
	"'\\\\'",
	"'/'",
	"'?'",
	"'.'",
	"','",
	"'>'",
	"'<'",
	"'+'",
	"'-'",
	"'('",
	"')'",
	"'['",
	"']'",
	"'*'",
	"'&'",
	"'^'",
	"'%'",
	"'$'",
	"'#'",
	"'@'",
	"'!'",
	"'~'",
	"'`'",
}

var protoStatenames = [...]string{}

const protoEofCode = 1
const protoErrCode = 2
const protoInitialStackSize = 16

var protoExca = [...]int16{
	-1, 0,
	1, 6,
	-2, 21,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	-2, 21,
	-1, 3,
	1, 2,
	-2, 21,
	-1, 14,
	1, 7,
	-2, 0,
	-1, 108,
	56, 212,
	-2, 0,
	-1, 129,
	56, 192,
	-2, 0,
	-1, 131,
	56, 181,
	-2, 0,
	-1, 133,
	56, 213,
	-2, 0,
	-1, 187,
	56, 225,
	-2, 0,
	-1, 192,
	56, 67,
	62, 67,
	-2, 0,
	-1, 205,
	56, 193,
	-2, 0,
	-1, 262,
	56, 182,
	-2, 0,
	-1, 368,
	56, 226,
	-2, 0,
	-1, 449,
	56, 128,
	-2, 0,
	-1, 505,
	56, 129,
	-2, 0,
	-1, 686,
	56, 236,
	-2, 0,
	-1, 696,
	56, 237,
	-2, 0,
}

const protoPrivate = 57344

const protoLast = 1895

var protoAct = [...]int16{
	129, 7, 128, 7, 7, 569, 18, 697, 385, 484,
	500, 114, 428, 92, 501, 479, 506, 91, 445, 412,
	413, 117, 396, 189, 40, 369, 115, 426, 395, 224,
	263, 317, 21, 20, 32, 34, 19, 98, 191, 39,
	101, 85, 134, 138, 87, 206, 36, 623, 490, 436,
	692, 86, 89, 90, 439, 94, 102, 381, 120, 99,
	100, 631, 622, 447, 102, 438, 386, 489, 444, 630,
	621, 387, 571, 625, 9, 488, 446, 656, 645, 440,
	675, 652, 414, 447, 127, 120, 480, 447, 414, 447,
	447, 447, 407, 386, 669, 379, 380, 487, 560, 102,
	111, 112, 120, 378, 653, 472, 105, 109, 131, 9,
	386, 187, 116, 471, 9, 188, 435, 455, 451, 566,
	639, 704, 453, 377, 664, 632, 446, 113, 119, 125,
	710, 376, 104, 104, 9, 419, 213, 678, 264, 103,
	405, 102, 415, 671, 365, 196, 708, 104, 415, 126,
	701, 695, 694, 687, 683, 9, 633, 674, 366, 374,
	367, 270, 210, 208, 364, 313, 209, 261, 204, 449,
	110, 108, 107, 218, 106, 96, 314, 5, 6, 96,
	96, 9, 571, 635, 315, 31, 666, 665, 493, 492,
	23, 476, 475, 450, 370, 443, 421, 410, 24, 13,
	12, 25, 26, 572, 502, 390, 473, 372, 383, 448,
	96, 388, 213, 203, 201, 200, 198, 196, 699, 26,
	682, 15, 9, 681, 9, 202, 627, 199, 97, 95,
	26, 375, 28, 27, 29, 30, 35, 626, 210, 208,
	406, 503, 209, 568, 394, 403, 398, 399, 404, 218,
	393, 391, 400, 373, 567, 556, 33, 8, 397, 494,
	478, 474, 408, 37, 38, 33, 685, 696, 371, 264,
	458, 459, 460, 461, 462, 463, 464, 465, 466, 467,
	468, 469, 4, 186, 368, 10, 11, 22, 132, 133,
	265, 403, 270, 409, 404, 130, 262, 211, 411, 266,
	216, 402, 401, 504, 505, 205, 222, 215, 212, 509,
	136, 214, 135, 508, 416, 207, 193, 192, 434, 481,
	574, 512, 139, 219, 575, 318, 514, 143, 225, 268,
	577, 320, 516, 420, 145, 228, 457, 382, 384, 429,
	118, 417, 418, 195, 498, 507, 17, 16, 14, 3,
	2, 1, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 423, 0,
	0, 0, 0, 0, 0, 370, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	422, 0, 0, 0, 424, 0, 0, 0, 425, 0,
	437, 0, 452, 454, 0, 119, 119, 427, 427, 431,
	432, 196, 0, 0, 0, 0, 0, 441, 442, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	456, 470, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 486, 477, 495, 496, 0, 0, 0,
	0, 0, 557, 491, 0, 119, 0, 485, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 497,
	0, 561, 86, 564, 0, 558, 0, 0, 0, 0,
	559, 0, 0, 0, 0, 0, 0, 0, 0, 562,
	0, 563, 0, 0, 565, 628, 0, 570, 0, 0,
	0, 0, 624, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 629, 0, 0, 0, 0, 0, 0,
	0, 0, 634, 0, 0, 0, 636, 0, 0, 640,
	0, 0, 0, 0, 0, 0, 86, 637, 638, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 641, 0, 0,
	0, 0, 0, 644, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 647, 642, 649, 0, 643, 0,
	0, 0, 0, 0, 0, 0, 646, 648, 650, 0,
	654, 651, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 658, 0,
	660, 0, 655, 0, 663, 486, 0, 0, 0, 0,
	0, 116, 661, 668, 662, 657, 659, 119, 670, 485,
	0, 673, 0, 0, 672, 0, 86, 119, 0, 677,
	679, 0, 0, 0, 667, 0, 0, 0, 0, 0,
	0, 0, 0, 116, 684, 686, 680, 0, 676, 0,
	0, 688, 0, 0, 0, 0, 689, 690, 700, 119,
	0, 0, 0, 698, 0, 703, 705, 702, 0, 0,
	691, 693, 707, 698, 706, 0, 483, 709, 33, 124,
	121, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 120,
	0, 0, 0, 0, 0, 0, 0, 386, 123, 122,
	0, 0, 0, 482, 33, 124, 121, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
	84, 0, 0, 0, 0, 120, 0, 0, 0, 0,
	0, 0, 0, 386, 123, 122, 0, 0, 430, 33,
	124, 121, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 0, 0, 0, 0,
	120, 0, 0, 0, 0, 0, 0, 0, 386, 123,
	122, 33, 124, 121, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 0, 0,
	0, 0, 120, 0, 0, 0, 0, 0, 0, 0,
	0, 123, 122, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 79, 80, 81, 82, 83, 84, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 194, 88, 0, 0, 499, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 433, 0, 194, 0, 0, 0, 197, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 0, 0, 0, 0, 0, 190, 0, 0,
	0, 0, 0, 0, 0, 194, 0, 0, 0, 197,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 33,
	414, 197, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	415, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	88, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 93, 578, 579, 580, 581, 582,
	583, 584, 585, 586, 587, 588, 589, 590, 591, 592,
	593, 594, 595, 596, 597, 598, 599, 600, 601, 602,
	603, 604, 605, 606, 607, 608, 609, 610, 611, 612,
	613, 614, 615, 616, 617, 618, 619, 573, 620, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 576, 321,
	322, 323, 324, 325, 326, 327, 328, 329, 330, 331,
	332, 333, 334, 335, 336, 337, 338, 339, 340, 341,
	342, 343, 344, 345, 346, 347, 348, 349, 350, 392,
	351, 352, 353, 354, 355, 356, 357, 358, 359, 360,
	361, 362, 363, 0, 0, 0, 0, 0, 217, 0,
	0, 0, 319, 229, 230, 231, 232, 233, 234, 235,
	26, 236, 237, 238, 239, 142, 141, 140, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
	252, 253, 254, 0, 221, 227, 220, 255, 256, 223,
	28, 27, 29, 257, 258, 259, 260, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 226, 321, 322, 323,
	324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
	334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
	344, 345, 346, 347, 348, 349, 350, 316, 351, 352,
	353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
	363, 0, 0, 0, 0, 0, 137, 0, 0, 0,
	319, 146, 147, 148, 149, 150, 151, 152, 153, 154,
	155, 156, 157, 142, 141, 140, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 170, 171,
	172, 0, 173, 174, 175, 176, 177, 178, 179, 180,
	181, 182, 183, 184, 185, 0, 0, 0, 0, 0,
	510, 0, 0, 0, 144, 517, 518, 519, 520, 521,
	522, 523, 511, 524, 525, 526, 527, 0, 0, 0,
	528, 529, 530, 531, 532, 533, 534, 535, 536, 537,
	538, 539, 540, 541, 542, 513, 543, 544, 545, 546,
	547, 548, 549, 550, 551, 552, 553, 554, 555, 0,
	0, 0, 0, 0, 0, 0, 33, 397, 515, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 267, 0, 0, 0, 0, 271, 272,
	273, 274, 275, 276, 277, 26, 278, 279, 280, 281,
	282, 283, 284, 285, 286, 287, 288, 289, 290, 291,
	292, 293, 294, 295, 296, 297, 298, 299, 300, 301,
	302, 303, 304, 305, 269, 306, 307, 308, 309, 310,
	311, 312, 389, 0, 0, 0, 0, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
	84, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84,
}

var protoPact = [...]int16{
	169, -1000, 128, 128, -1000, 148, 147, 188, 132, -1000,
	-1000, -1000, 261, 261, 188, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 252, 1844, 1264, 1844, 1844, 1324,
	1844, -1000, 176, -1000, 175, -1000, 171, 261, 261, 81,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 87, -1000, -1000, 1324, 119,
	117, 116, 39, 1844, 115, -1000, -1000, -1000, -1000, 171,
	171, -1000, 1844, 897, 1264, 17, 128, 128, 1594, 39,
	128, -1000, -1000, -1000, 128, -1000, -1000, 206, -1000, -1000,
	1081, -1000, 210, 208, -1000, -1000, -1000, -1000, 112, 1486,
	111, 1751, 109, 1594, -1000, -1000, -1000, 131, 1540, 1844,
	-1000, -1000, -1000, 84, 1844, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 104, 205, -1000, 103,
	-1000, -1000, 1143, 70, 42, 3, -1000, 1800, -1000, -1000,
	-1000, -1000, -1000, -1000, 128, 1486, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 1432, 1844,
	253, 1844, 1844, 1702, -1000, 80, 1844, 29, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 128, 1751, -1000, -1000, -1000, -1000, -1000, 145, 1205,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 128, -1000, -1000, 1844, 1844, 75, 1844,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 144, 1844, 39, 128, 205, -1000,
	-1000, -1000, -1000, 1844, -1000, -1000, -1000, -1000, -1000, -1000,
	770, 770, -1000, -1000, -1000, -1000, 1019, 47, -4, 10,
	-1000, -1000, 1844, 1844, 143, 15, -1000, 168, 114, 141,
	65, 61, 56, 206, -1000, 1844, 39, 246, -1000, -1000,
	83, 52, -1000, 165, -1000, 256, -1000, 140, 139, 1844,
	39, 255, -1000, -1000, -1000, 20, -1000, -1000, -1000, -1000,
	704, -1000, 35, -1000, 6, -1000, -21, -1000, -1000, 1844,
	-1000, 137, 136, 254, 128, 128, 253, 956, 199, 1648,
	250, 128, -1000, 261, -1000, 1844, -1000, 37, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	21, 83, 128, 77, -1000, 249, 238, -1000, 19, 153,
	1378, 1, -1000, -22, -1000, -1000, -1000, -1000, -1000, 30,
	-1000, 4, 232, 221, 21, -1000, -1000, -1000, 0, -1000,
	-1000, 73, -1000, -1000, 100, 1648, -1000, -1000, -1000, -1000,
	130, 1264, 1844, 1844, 60, 1844, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 21, -1000, 206, -1000,
	1324, -1000, 128, -1000, -1000, -1000, -1000, 23, 19, -1000,
	129, -1000, 20, 1324, 14, 44, 1844, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 835, -1000, -1000, -1000, 22, 21, -1000, 128,
	-1000, 1264, 897, 128, -1000, -1000, 72, 135, 134, 1844,
	39, -1000, 128, 32, -1000, 128, 88, -1000, 129, -1000,
	102, 13, -1000, 1844, 39, -1000, 128, 82, -1000, 128,
	-1000, -1000, -1000, -1000, 897, 218, 215, -1000, -1000, -1000,
	98, 128, -1000, -1000, 128, -1000, -1000, 97, 128, -1000,
	129, 19, -5, -1000, 96, 95, 216, 128, 94, -1000,
	-1000, 129, 128, 66, -1000, 128, 216, -1000, -1000, -1000,
	-1000, 128, -1000, 90, 128, -1000, -1000, -1000, -1000, 74,
	-1000,
}

var protoPgo = [...]int16{
	0, 351, 350, 349, 282, 221, 348, 347, 346, 10,
	345, 6, 344, 44, 343, 14, 18, 27, 11, 26,
	8, 12, 340, 339, 9, 338, 337, 20, 24, 336,
	335, 334, 332, 331, 330, 329, 43, 13, 328, 327,
	326, 325, 324, 17, 323, 322, 321, 31, 320, 319,
	318, 317, 38, 23, 316, 315, 313, 312, 311, 310,
	309, 308, 307, 306, 36, 45, 305, 2, 16, 304,
	303, 302, 301, 300, 299, 29, 22, 19, 28, 298,
	297, 33, 30, 296, 295, 290, 32, 42, 289, 288,
	21, 287, 25, 284, 283, 268, 7, 267, 266, 15,
	5, 0, 257,
}

var protoR1 = [...]int8{
	0, 1, 1, 1, 1, 1, 1, 4, 6, 6,
	5, 5, 5, 5, 5, 5, 5, 5, 102, 102,
	101, 101, 100, 100, 2, 3, 7, 7, 7, 8,
	37, 37, 38, 38, 39, 39, 40, 40, 41, 41,
	42, 42, 10, 11, 15, 15, 15, 15, 13, 18,
	18, 19, 19, 19, 22, 22, 22, 22, 22, 22,
	22, 22, 90, 90, 20, 20, 53, 52, 52, 51,
	51, 51, 51, 51, 51, 54, 54, 54, 14, 14,
	14, 14, 17, 17, 17, 26, 26, 21, 21, 21,
	23, 23, 23, 49, 49, 24, 24, 25, 25, 25,
	50, 50, 43, 43, 44, 44, 45, 45, 46, 46,
	47, 47, 48, 48, 36, 36, 36, 16, 16, 12,
	12, 9, 9, 59, 59, 61, 61, 58, 70, 70,
	69, 69, 68, 68, 68, 68, 68, 56, 56, 60,
	60, 62, 62, 63, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 80, 80, 78, 78,
	76, 76, 76, 79, 79, 77, 77, 77, 27, 27,
	73, 73, 74, 74, 75, 75, 71, 71, 72, 72,
	81, 84, 84, 83, 83, 82, 82, 82, 82, 85,
	85, 64, 67, 67, 66, 66, 65, 65, 65, 65,
	65, 65, 65, 65, 65, 65, 65, 55, 55, 55,
	55, 86, 89, 89, 88, 88, 87, 87, 87, 87,
	57, 57, 57, 57, 91, 94, 94, 93, 93, 92,
	92, 92, 95, 95, 99, 99, 98, 98, 97, 97,
	96, 96, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33, 33, 34,
	34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28,
}

var protoR2 = [...]int8{
	0, 1, 1, 1, 2, 2, 0, 2, 2, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	1, 0, 1, 0, 4, 4, 3, 4, 4, 3,
	1, 3, 1, 3, 1, 3, 1, 3, 1, 3,
	1, 3, 5, 5, 1, 3, 1, 3, 3, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 1,
	2, 2, 1, 2, 3, 2, 1, 1, 2, 1,
	2, 2, 2, 2, 1, 3, 2, 3, 1, 3,
	5, 3, 1, 1, 1, 1, 1, 1, 3, 2,
	3, 2, 3, 1, 3, 1, 1, 3, 2, 3,
	1, 3, 1, 2, 1, 2, 1, 2, 1, 2,
	1, 2, 1, 2, 1, 1, 1, 3, 2, 1,
	3, 3, 1, 8, 9, 9, 10, 6, 0, 1,
	2, 1, 1, 1, 1, 2, 1, 5, 6, 7,
	8, 5, 6, 6, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 4, 4, 1, 3,
	1, 3, 3, 1, 3, 1, 3, 3, 1, 2,
	4, 1, 4, 1, 3, 3, 1, 3, 1, 3,
	6, 1, 2, 2, 1, 1, 1, 1, 1, 4,
	5, 6, 1, 2, 2, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 6, 7, 5,
	6, 6, 0, 1, 2, 1, 1, 1, 2, 1,
	6, 7, 5, 6, 6, 1, 2, 2, 1, 1,
	1, 1, 6, 9, 4, 3, 1, 2, 2, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1,
}

var protoChk = [...]int16{
	-1000, -1, -2, -3, -4, 8, 9, -101, -102, 53,
	-4, -4, 52, 52, -6, -5, -7, -8, -11, -64,
	-81, -86, -91, 2, 10, 13, 14, 45, 44, 46,
	47, 53, -90, 4, -90, -5, -90, 11, 12, -37,
	-28, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, -15, -28, -13, 66, -28,
	-28, -43, -37, 60, -28, 53, 4, 53, -101, -90,
	-90, -101, 60, 52, 60, -43, 55, 55, 55, -37,
	55, -101, -101, -28, -18, -19, -20, -90, -22, -28,
	55, 6, 65, 64, 5, -28, -13, 67, -67, -101,
	-84, -101, -89, -88, -87, -57, -59, 2, -36, -45,
	21, 20, 19, -39, 60, -31, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
	34, 35, 36, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, -94, -101, -101, -53,
	56, -52, -51, -54, 2, -14, -28, 68, 6, 17,
	5, 6, 17, 5, 56, -66, -65, -55, -81, -64,
	-86, -80, -61, -11, -58, -62, -73, 2, -36, -44,
	40, 38, -63, 43, -75, -38, 60, 39, -30, 7,
	8, 9, 10, 11, 12, 13, 15, 16, 17, 18,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 41, 42, 47, 48, 49,
	50, 56, -83, -82, -11, -85, -74, 2, -35, 43,
	-75, 7, 8, 9, 10, 11, 12, 13, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
	37, 38, 39, 40, 41, 42, 44, 45, 46, 47,
	48, 49, 50, 56, -87, 53, 37, -47, -41, 60,
	-33, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	36, 38, 39, 40, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 50, -28, 60, -37, 56, -93, -92,
	-11, -95, 2, 48, 56, -52, 61, 53, 61, 53,
	54, 54, -26, -21, -25, -20, 63, 68, -37, 2,
	-101, -65, 37, -47, -28, -78, -76, 5, -28, -28,
	-78, -71, -72, -90, -28, 60, -37, 63, -101, -82,
	52, -79, -77, -27, 5, 65, -101, -28, -28, 60,
	-37, 52, -28, -101, -92, -28, -17, -19, -21, -23,
	68, -17, -53, 62, -50, 69, 2, -21, 69, 58,
	69, -28, -28, 52, 53, -16, 61, 68, 41, 55,
	52, 53, -101, 61, -101, 61, -28, -29, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	-27, 61, 53, 41, 5, 52, 52, -28, 5, -99,
	66, -49, 69, 2, -24, -19, -21, 62, 69, 61,
	69, -37, 52, 52, 5, -101, -101, -76, -12, 69,
	-9, -15, 5, 42, -70, -69, -68, -10, -56, -60,
	2, 14, -46, 37, -40, 60, -32, 7, 8, 9,
	10, 11, 12, 13, 15, 16, 17, 18, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
	34, 35, 36, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 5, -101, -90, -28,
	61, -101, -16, -77, -101, -27, 42, 5, 5, -100,
	-16, 53, 50, 49, -48, -42, 60, -34, 7, 8,
	9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
	19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	50, 69, 61, 69, -21, 69, 5, 5, -101, -16,
	69, 61, 52, 56, -68, 53, -15, -28, -28, 60,
	-37, -101, -16, -43, -101, 55, -16, -100, -16, -100,
	-99, -43, 67, 60, -37, -24, 55, -16, -101, -16,
	-101, -9, -18, -101, 52, 52, 52, -28, -101, 62,
	-67, 55, -100, -101, 55, 67, -28, -67, 55, -101,
	-18, 5, 5, 56, -67, -98, -101, 56, -67, -100,
	-100, -16, 55, -16, 56, 56, -97, -96, -11, 2,
	-101, 56, -100, -67, 55, -101, -96, -101, 56, -67,
	56,
}

var protoDef = [...]int16{
	-2, -2, -2, -2, 3, 0, 0, 0, 20, 18,
	4, 5, 0, 0, -2, 9, 10, 11, 12, 13,
	14, 15, 16, 17, 0, 0, 0, 0, 0, 0,
	0, 19, 0, 62, 0, 8, 21, 0, 0, 21,
	30, 482, 483, 484, 485, 486, 487, 488, 489, 490,
	491, 492, 493, 494, 495, 496, 497, 498, 499, 500,
	501, 502, 503, 504, 505, 506, 507, 508, 509, 510,
	511, 512, 513, 514, 515, 516, 517, 518, 519, 520,
	521, 522, 523, 524, 525, 0, 44, 46, 0, 0,
	0, 0, 102, 0, 0, 24, 63, 25, 26, 21,
	21, 29, 0, 0, 0, 0, 21, 21, -2, 103,
	21, 27, 28, 31, 21, 49, 50, 51, 52, 53,
	0, 54, 0, 0, 59, 45, 47, 48, 0, -2,
	0, -2, 0, -2, 215, 216, 217, 219, 0, 0,
	114, 115, 116, 106, 0, 34, 275, 276, 277, 278,
	279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
	289, 290, 291, 292, 293, 294, 295, 296, 297, 298,
	299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
	309, 310, 311, 312, 313, 314, 0, -2, 43, 0,
	65, 66, -2, 69, 74, 0, 78, 0, 55, 58,
	61, 56, 57, 60, 21, -2, 195, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 205, 206, 0, 0,
	0, 0, 0, 0, 171, 104, 0, 268, 32, 242,
	243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	253, 254, 255, 256, 257, 258, 259, 260, 261, 262,
	263, 264, 265, 266, 267, 269, 270, 271, 272, 273,
	274, 21, -2, 184, 185, 186, 187, 188, 0, 0,
	173, 315, 316, 317, 318, 319, 320, 321, 322, 323,
	324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
	334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
	344, 345, 346, 347, 348, 349, 350, 351, 352, 353,
	354, 355, 356, 21, 214, 218, 0, 0, 110, 0,
	38, 396, 397, 398, 399, 400, 401, 402, 403, 404,
	405, 406, 407, 408, 409, 410, 411, 412, 413, 414,
	415, 416, 417, 418, 419, 420, 421, 422, 423, 424,
	425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
	435, 436, 437, 438, 0, 0, 107, 21, -2, 228,
	229, 230, 231, 0, 64, 68, 70, 71, 72, 73,
	0, 0, 76, 85, 86, 87, 0, 0, 0, 0,
	191, 194, 0, 0, 0, 0, 158, 160, 0, 0,
	0, 21, 21, 176, 178, 0, 105, 0, 180, 183,
	0, 0, 163, 165, 168, 0, 211, 0, 0, 0,
	111, 0, 35, 224, 227, 0, 77, 82, 83, 84,
	0, 75, 0, 89, 0, 98, 0, 100, 79, 0,
	81, 0, 0, 0, 21, 21, 0, 0, 0, -2,
	0, 21, 174, 0, 175, 0, 33, 0, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
	21, 0, 21, 0, 169, 0, 0, 39, 23, 0,
	0, 0, 91, 0, 93, 95, 96, 88, 97, 0,
	99, 0, 0, 0, 21, 156, 157, 159, 0, 118,
	119, 122, 161, 162, 0, -2, 131, 132, 133, 134,
	136, 0, 0, 0, 108, 0, 36, 357, 358, 359,
	360, 361, 362, 363, 364, 365, 366, 367, 368, 369,
	370, 371, 372, 373, 374, 375, 376, 377, 378, 379,
	380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
	390, 391, 392, 393, 394, 395, 21, 170, 177, 179,
	0, 189, 21, 164, 172, 166, 167, 0, 23, 222,
	23, 22, 0, 0, 0, 112, 0, 40, 439, 440,
	441, 442, 443, 444, 445, 446, 447, 448, 449, 450,
	451, 452, 453, 454, 455, 456, 457, 458, 459, 460,
	461, 462, 463, 464, 465, 466, 467, 468, 469, 470,
	471, 472, 473, 474, 475, 476, 477, 478, 479, 480,
	481, 90, 0, 92, 101, 80, 0, 21, 209, 21,
	117, 0, 0, 21, 130, 135, 0, 0, 0, 0,
	109, 141, 21, 0, 190, 21, 0, 220, 23, 223,
	21, 0, 235, 0, 113, 94, 21, 0, 207, 21,
	210, 120, 121, 127, 0, 0, 0, 37, 142, 143,
	0, 21, 221, 232, 21, 234, 41, 0, 21, 208,
	23, 23, 0, 123, 0, 0, -2, 21, 0, 42,
	137, 23, 21, 0, 124, 21, -2, 239, 240, 241,
	125, 21, 138, 0, 21, 233, 238, 126, 139, 0,
	140,
}

var protoTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 77, 3, 75, 74, 73, 71, 3,
	66, 67, 70, 64, 61, 65, 60, 58, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 54, 53,
	63, 52, 62, 59, 76, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 68, 57, 69, 72, 3, 79, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 55, 3, 56, 78,
}

var protoTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
}

var protoTok3 = [...]int8{
	0,
}

var protoErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	protoDebug        = 0
	protoErrorVerbose = false
)

type protoLexer interface {
	Lex(lval *protoSymType) int
	Error(s string)
}

type protoParser interface {
	Parse(protoLexer) int
	Lookahead() int
}

type protoParserImpl struct {
	lval  protoSymType
	stack [protoInitialStackSize]protoSymType
	char  int
}

func (p *protoParserImpl) Lookahead() int {
	return p.char
}

func protoNewParser() protoParser {
	return &protoParserImpl{}
}

const protoFlag = -1000

func protoTokname(c int) string {
	if c >= 1 && c-1 < len(protoToknames) {
		if protoToknames[c-1] != "" {
			return protoToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func protoStatname(s int) string {
	if s >= 0 && s < len(protoStatenames) {
		if protoStatenames[s] != "" {
			return protoStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func protoErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !protoErrorVerbose {
		return "syntax error"
	}

	for _, e := range protoErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + protoTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(protoPact[state])
	for tok := TOKSTART; tok-1 < len(protoToknames); tok++ {
		if n := base + tok; n >= 0 && n < protoLast && int(protoChk[int(protoAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if protoDef[state] == -2 {
		i := 0
		for protoExca[i] != -1 || int(protoExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; protoExca[i] >= 0; i += 2 {
			tok := int(protoExca[i])
			if tok < TOKSTART || protoExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if protoExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += protoTokname(tok)
	}
	return res
}

func protolex1(lex protoLexer, lval *protoSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(protoTok1[0])
		goto out
	}
	if char < len(protoTok1) {
		token = int(protoTok1[char])
		goto out
	}
	if char >= protoPrivate {
		if char < protoPrivate+len(protoTok2) {
			token = int(protoTok2[char-protoPrivate])
			goto out
		}
	}
	for i := 0; i < len(protoTok3); i += 2 {
		token = int(protoTok3[i+0])
		if token == char {
			token = int(protoTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(protoTok2[1]) /* unknown char */
	}
	if protoDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", protoTokname(token), uint(char))
	}
	return char, token
}

func protoParse(protolex protoLexer) int {
	return protoNewParser().Parse(protolex)
}

func (protorcvr *protoParserImpl) Parse(protolex protoLexer) int {
	var proton int
	var protoVAL protoSymType
	var protoDollar []protoSymType
	_ = protoDollar // silence set and not used
	protoS := protorcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	protostate := 0
	protorcvr.char = -1
	prototoken := -1 // protorcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		protostate = -1
		protorcvr.char = -1
		prototoken = -1
	}()
	protop := -1
	goto protostack

ret0:
	return 0

ret1:
	return 1

protostack:
	/* put a state and value onto the stack */
	if protoDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", protoTokname(prototoken), protoStatname(protostate))
	}

	protop++
	if protop >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoS[protop] = protoVAL
	protoS[protop].yys = protostate

protonewstate:
	proton = int(protoPact[protostate])
	if proton <= protoFlag {
		goto protodefault /* simple state */
	}
	if protorcvr.char < 0 {
		protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
	}
	proton += prototoken
	if proton < 0 || proton >= protoLast {
		goto protodefault
	}
	proton = int(protoAct[proton])
	if int(protoChk[proton]) == prototoken { /* valid shift */
		protorcvr.char = -1
		prototoken = -1
		protoVAL = protorcvr.lval
		protostate = proton
		if Errflag > 0 {
			Errflag--
		}
		goto protostack
	}

protodefault:
	/* default state action */
	proton = int(protoDef[protostate])
	if proton == -2 {
		if protorcvr.char < 0 {
			protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if protoExca[xi+0] == -1 && int(protoExca[xi+1]) == protostate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			proton = int(protoExca[xi+0])
			if proton < 0 || proton == prototoken {
				break
			}
		}
		proton = int(protoExca[xi+1])
		if proton < 0 {
			goto ret0
		}
	}
	if proton == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			protolex.Error(protoErrorMessage(protostate, prototoken))
			Nerrs++
			if protoDebug >= 1 {
				__yyfmt__.Printf("%s", protoStatname(protostate))
				__yyfmt__.Printf(" saw %s\n", protoTokname(prototoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for protop >= 0 {
				proton = int(protoPact[protoS[protop].yys]) + protoErrCode
				if proton >= 0 && proton < protoLast {
					protostate = int(protoAct[proton]) /* simulate a shift of "error" */
					if int(protoChk[protostate]) == protoErrCode {
						goto protostack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if protoDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", protoS[protop].yys)
				}
				protop--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if protoDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", protoTokname(prototoken))
			}
			if prototoken == protoEofCode {
				goto ret1
			}
			protorcvr.char = -1
			prototoken = -1
			goto protonewstate /* try again in the same state */
		}
	}

	/* reduction by production proton */
	if protoDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", proton, protoStatname(protostate))
	}

	protont := proton
	protopt := protop
	_ = protopt // guard against "declared and not used"

	protop -= int(protoR2[proton])
	// protop is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if protop+1 >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoVAL = protoS[protop+1]

	/* consult goto table to find next state */
	proton = int(protoR1[proton])
	protog := int(protoPgo[proton])
	protoj := protog + protoS[protop].yys + 1

	if protoj >= protoLast {
		protostate = int(protoAct[protog])
	} else {
		protostate = int(protoAct[protoj])
		if int(protoChk[protostate]) != -proton {
			protostate = int(protoAct[protog])
		}
	}
	// dummy call; replaced with literal code
	switch protont {

	case 1:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 2:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 3:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, protoDollar[1].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 4:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 5:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 6:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 7:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = newFileElements(protoDollar[1].bs, protoDollar[2].fileElements)
		}
	case 8:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = append(protoDollar[1].fileElements, protoDollar[2].fileElements...)
		}
	case 9:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = protoDollar[1].fileElements
		}
	case 10:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].imprt)
		}
	case 11:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].pkg)
		}
	case 12:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].opt)
		}
	case 13:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].msg)
		}
	case 14:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].en)
		}
	case 15:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].extend)
		}
	case 16:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toFileElements(protoDollar[1].svc)
		}
	case 17:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = nil
		}
	case 18:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = []*ast.RuneNode{protoDollar[1].b}
		}
	case 19:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.bs = append(protoDollar[1].bs, protoDollar[2].b)
		}
	case 20:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = protoDollar[1].bs
		}
	case 21:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.bs = nil
		}
	case 22:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.b = protoDollar[1].b
		}
	case 23:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protolex.(*protoLex).Error("expected ';'")
			protoVAL.b = nil
		}
	case 24:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.syn = ast.NewSyntaxNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 25:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.ed = ast.NewEditionNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 26:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.imprt = newNodeWithEmptyDecls(ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, nil, toStringValueNode(protoDollar[2].str), semi), extra)
		}
	case 27:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithEmptyDecls(ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), semi), extra)
		}
	case 28:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithEmptyDecls(ast.NewImportNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), nil, toStringValueNode(protoDollar[3].str), semi), extra)
		}
	case 29:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.pkg = newNodeWithEmptyDecls(ast.NewPackageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].cid.toIdentValueNode(nil), semi), extra)
		}
	case 30:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 31:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 32:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 33:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 34:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 35:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 36:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 37:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 38:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 39:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 40:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 41:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 42:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			protoVAL.optRaw = ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, protoDollar[5].b)
		}
	case 43:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.opt = newNodeWithEmptyDecls(ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, semi), extra)
		}
	case 44:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			fieldReferenceNode := ast.NewFieldReferenceNode(protoDollar[1].id)
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{fieldReferenceNode}}
		}
	case 45:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, ast.NewFieldReferenceNode(protoDollar[3].id))
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].b)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 46:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref}}
		}
	case 47:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[3].ref)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].b)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 48:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].tid, protoDollar[3].b)
		}
	case 51:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 53:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 54:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].f
		}
	case 55:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 56:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 57:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 58:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 59:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].i
		}
	case 60:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewPositiveUintLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 61:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].i.Val > math.MaxInt64+1 {
				// can't represent as int so treat as float literal
				protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].i)
			} else {
				protoVAL.v = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
			}
		}
	case 62:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.str = []*ast.StringLiteralNode{protoDollar[1].s}
		}
	case 63:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.str = append(protoDollar[1].str, protoDollar[2].s)
		}
	case 64:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 65:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 68:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFlds != nil {
				protoDollar[1].msgLitFlds.next = protoDollar[2].msgLitFlds
				protoVAL.msgLitFlds = protoDollar[1].msgLitFlds
			} else {
				protoVAL.msgLitFlds = protoDollar[2].msgLitFlds
			}
		}
	case 69:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 70:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 71:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 72:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 73:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 74:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 75:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].ref != nil && protoDollar[2].b != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].ref, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 76:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].ref != nil && protoDollar[2].v != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].ref, nil, protoDollar[2].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 77:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.msgLitFld = nil
		}
	case 78:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 79:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 80:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.ref = ast.NewAnyTypeReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b, protoDollar[4].cid.toIdentValueNode(nil), protoDollar[5].b)
		}
	case 81:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.ref = nil
		}
	case 88:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 89:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 90:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 91:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 92:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 93:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 94:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 97:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 98:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 99:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 100:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 101:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 102:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 103:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 104:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 105:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 106:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 107:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 108:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 109:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 110:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 111:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 112:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 113:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 117:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, protoDollar[2].opts.options, protoDollar[2].opts.commas, protoDollar[3].b)
		}
	case 118:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protolex.(*protoLex).Error("compact options must have at least one option")
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 119:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].optRaw}}
		}
	case 120:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[3].optRaw)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].b)
			protoVAL.opts = protoDollar[1].opts
		}
	case 121:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, protoDollar[2].b, protoDollar[3].v)
		}
	case 122:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protolex.(*protoLex).Error("compact option must have a value")
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, nil, nil)
		}
	case 123:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 124:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b)
		}
	case 125:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithEmptyDecls(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b), protoDollar[9].bs)
		}
	case 126:
		protoDollar = protoS[protopt-10 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithEmptyDecls(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b), protoDollar[10].bs)
		}
	case 127:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.oo = newNodeWithEmptyDecls(ast.NewOneofNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].ooElements, protoDollar[5].b), protoDollar[6].bs)
		}
	case 128:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.ooElements = nil
		}
	case 130:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].ooElement != nil {
				protoVAL.ooElements = append(protoDollar[1].ooElements, protoDollar[2].ooElement)
			} else {
				protoVAL.ooElements = protoDollar[1].ooElements
			}
		}
	case 131:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].ooElement != nil {
				protoVAL.ooElements = []ast.OneofElement{protoDollar[1].ooElement}
			} else {
				protoVAL.ooElements = nil
			}
		}
	case 132:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].optRaw
		}
	case 133:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].fld
		}
	case 134:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].grp
		}
	case 135:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 136:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 137:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 138:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 139:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b, protoDollar[6].msgElements, protoDollar[7].b)
		}
	case 140:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 141:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.mapFld = newNodeWithEmptyDecls(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semi), extra)
		}
	case 142:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mapFld = newNodeWithEmptyDecls(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semi), extra)
		}
	case 143:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapType = ast.NewMapTypeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].id, protoDollar[4].b, protoDollar[5].tid, protoDollar[6].b)
		}
	case 156:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `extensions 1 to 10` and `extensions 1` followed by `to = 10`.
			protoVAL.ext = newNodeWithEmptyDecls(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, nil, protoDollar[3].b), protoDollar[4].bs)
		}
	case 157:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.ext = newNodeWithEmptyDecls(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].cmpctOpts, semi), extra)
		}
	case 158:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 159:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 160:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, nil, nil, nil)
		}
	case 161:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), protoDollar[3].i, nil)
		}
	case 162:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 163:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 164:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 165:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, nil, nil, nil)
		}
	case 166:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), protoDollar[3].il, nil)
		}
	case 167:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 168:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.il = protoDollar[1].i
		}
	case 169:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.il = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 170:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithEmptyDecls(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs)
		}
	case 172:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithEmptyDecls(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs)
		}
	case 174:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithEmptyDecls(ast.NewReservedNamesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.names, protoDollar[2].names.commas, semi), extra)
		}
	case 175:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithEmptyDecls(ast.NewReservedIdentifiersNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.idents, protoDollar[2].names.commas, semi), extra)
		}
	case 176:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{names: []ast.StringValueNode{toStringValueNode(protoDollar[1].str)}}
		}
	case 177:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.names = append(protoDollar[1].names.names, toStringValueNode(protoDollar[3].str))
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 178:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 179:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.idents = append(protoDollar[1].names.idents, protoDollar[3].id)
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 180:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.en = newNodeWithEmptyDecls(ast.NewEnumNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].enElements, protoDollar[5].b), protoDollar[6].bs)
		}
	case 181:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = newEnumElements(protoDollar[1].bs, nil)
		}
	case 182:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = newEnumElements(protoDollar[1].bs, protoDollar[2].enElements)
		}
	case 183:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = append(protoDollar[1].enElements, protoDollar[2].enElements...)
		}
	case 184:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = protoDollar[1].enElements
		}
	case 185:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toEnumElements(protoDollar[1].opt)
		}
	case 186:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toEnumElements(protoDollar[1].env)
		}
	case 187:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toEnumElements(protoDollar[1].resvd)
		}
	case 188:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = nil
		}
	case 189:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.env = newNodeWithEmptyDecls(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, nil, semi), extra)
		}
	case 190:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.env = newNodeWithEmptyDecls(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, protoDollar[4].cmpctOpts, semi), extra)
		}
	case 191:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.msg = newNodeWithEmptyDecls(ast.NewMessageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].msgElements, protoDollar[5].b), protoDollar[6].bs)
		}
	case 192:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = newMessageElements(protoDollar[1].bs, nil)
		}
	case 193:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = newMessageElements(protoDollar[1].bs, protoDollar[2].msgElements)
		}
	case 194:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = append(protoDollar[1].msgElements, protoDollar[2].msgElements...)
		}
	case 195:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = protoDollar[1].msgElements
		}
	case 196:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].msgFld)
		}
	case 197:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].en)
		}
	case 198:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].msg)
		}
	case 199:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].extend)
		}
	case 200:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].ext)
		}
	case 201:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].msgGrp)
		}
	case 202:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].opt)
		}
	case 203:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].oo)
		}
	case 204:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].mapFld)
		}
	case 205:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toMessageElements(protoDollar[1].resvd)
		}
	case 206:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = nil
		}
	case 207:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithEmptyDecls(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, semis), extra)
		}
	case 208:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[7].bs)
			protoVAL.msgFld = newNodeWithEmptyDecls(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, semis), extra)
		}
	case 209:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithEmptyDecls(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semis), extra)
		}
	case 210:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithEmptyDecls(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semis), extra)
		}
	case 211:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.extend = newNodeWithEmptyDecls(ast.NewExtendNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].b, protoDollar[4].extElements, protoDollar[5].b), protoDollar[6].bs)
		}
	case 212:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.extElements = nil
		}
	case 214:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].extElement != nil {
				protoVAL.extElements = append(protoDollar[1].extElements, protoDollar[2].extElement)
			} else {
				protoVAL.extElements = protoDollar[1].extElements
			}
		}
	case 215:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].extElement != nil {
				protoVAL.extElements = []ast.ExtendElement{protoDollar[1].extElement}
			} else {
				protoVAL.extElements = nil
			}
		}
	case 216:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].fld
		}
	case 217:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].grp
		}
	case 218:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 219:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 220:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 221:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 222:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 223:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 224:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.svc = newNodeWithEmptyDecls(ast.NewServiceNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].svcElements, protoDollar[5].b), protoDollar[6].bs)
		}
	case 225:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = newServiceElements(protoDollar[1].bs, nil)
		}
	case 226:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = newServiceElements(protoDollar[1].bs, protoDollar[2].svcElements)
		}
	case 227:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = append(protoDollar[1].svcElements, protoDollar[2].svcElements...)
		}
	case 228:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = protoDollar[1].svcElements
		}
	case 229:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toServiceElements(protoDollar[1].opt)
		}
	case 230:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toServiceElements(protoDollar[1].mtd)
		}
	case 231:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = nil
		}
	case 232:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mtd = newNodeWithEmptyDecls(ast.NewRPCNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, semi), extra)
		}
	case 233:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.mtd = newNodeWithEmptyDecls(ast.NewRPCNodeWithBody(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, protoDollar[6].b, protoDollar[7].mtdElements, protoDollar[8].b), protoDollar[9].bs)
		}
	case 234:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, protoDollar[2].id.ToKeyword(), protoDollar[3].tid, protoDollar[4].b)
		}
	case 235:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, nil, protoDollar[2].tid, protoDollar[3].b)
		}
	case 236:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = newMethodElements(protoDollar[1].bs, nil)
		}
	case 237:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = newMethodElements(protoDollar[1].bs, protoDollar[2].mtdElements)
		}
	case 238:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = append(protoDollar[1].mtdElements, protoDollar[2].mtdElements...)
		}
	case 239:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = protoDollar[1].mtdElements
		}
	case 240:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = toMethodElements(protoDollar[1].opt)
		}
	case 241:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = nil
		}
	}
	goto protostack /* stack new state and value */
}
