package dom

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"errors"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// Quad an array of quad vertices, x immediately followed by y for each
// point, points clock-wise.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Quad
type Quad []float64

// BoxModel box model.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-BoxModel
type BoxModel struct {
	Content      Quad              `json:"content"`                // Content box
	Padding      Quad              `json:"padding"`                // Padding box
	Border       Quad              `json:"border"`                 // Border box
	Margin       Quad              `json:"margin"`                 // Margin box
	Width        int64             `json:"width"`                  // Node width
	Height       int64             `json:"height"`                 // Node height
	ShapeOutside *ShapeOutsideInfo `json:"shapeOutside,omitempty"` // Shape outside coordinates
}

// ShapeOutsideInfo CSS Shape Outside details.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-ShapeOutsideInfo
type ShapeOutsideInfo struct {
	Bounds      Quad                  `json:"bounds"`      // Shape bounds
	Shape       []easyjson.RawMessage `json:"shape"`       // Shape coordinate details
	MarginShape []easyjson.RawMessage `json:"marginShape"` // Margin shape bounds
}

// Rect Rectangle.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Rect
type Rect struct {
	X      float64 `json:"x"`      // X coordinate
	Y      float64 `json:"y"`      // Y coordinate
	Width  float64 `json:"width"`  // Rectangle width
	Height float64 `json:"height"` // Rectangle height
}

// CSSComputedStyleProperty [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-CSSComputedStyleProperty
type CSSComputedStyleProperty struct {
	Name  string `json:"name"`  // Computed style property name.
	Value string `json:"value"` // Computed style property value.
}

// EnableIncludeWhitespace whether to include whitespaces in the children
// array of returned Nodes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#method-enable
type EnableIncludeWhitespace string

// String returns the EnableIncludeWhitespace as string value.
func (t EnableIncludeWhitespace) String() string {
	return string(t)
}

// EnableIncludeWhitespace values.
const (
	EnableIncludeWhitespaceNone EnableIncludeWhitespace = "none"
	EnableIncludeWhitespaceAll  EnableIncludeWhitespace = "all"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t EnableIncludeWhitespace) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t EnableIncludeWhitespace) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *EnableIncludeWhitespace) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch EnableIncludeWhitespace(in.String()) {
	case EnableIncludeWhitespaceNone:
		*t = EnableIncludeWhitespaceNone
	case EnableIncludeWhitespaceAll:
		*t = EnableIncludeWhitespaceAll

	default:
		in.AddError(errors.New("unknown EnableIncludeWhitespace value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *EnableIncludeWhitespace) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
